VERSION 2.00
Begin Form Form1 
   AutoRedraw      =   -1  'True
   Caption         =   "Picture Viewer"
   ClientHeight    =   4635
   ClientLeft      =   1470
   ClientTop       =   1665
   ClientWidth     =   2175
   ClipControls    =   0   'False
   Height          =   5040
   Left            =   1410
   LinkTopic       =   "Form1"
   ScaleHeight     =   4635
   ScaleWidth      =   2175
   Top             =   1320
   Width           =   2295
   Begin CommandButton Command1 
      Caption         =   "Exit"
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Top             =   3240
      Width           =   495
   End
   Begin TextBox Text1 
      BorderStyle     =   0  'None
      Height          =   375
      Left            =   720
      TabIndex        =   14
      Top             =   3240
      Width           =   1335
   End
   Begin Frame Color_Frame 
      Caption         =   "Order"
      Height          =   495
      Left            =   120
      TabIndex        =   8
      Top             =   4080
      Width           =   1935
      Begin OptionButton two_pass_FS 
         Caption         =   "two_pass_FS"
         Height          =   255
         Left            =   1560
         TabIndex        =   13
         Top             =   240
         Width           =   255
      End
      Begin OptionButton two_pass 
         Caption         =   "two_pass"
         Height          =   255
         Left            =   1200
         TabIndex        =   12
         Top             =   240
         Width           =   255
      End
      Begin OptionButton true 
         Caption         =   "true"
         Height          =   255
         Left            =   840
         TabIndex        =   11
         Top             =   240
         Width           =   255
      End
      Begin OptionButton gray 
         Caption         =   "gray"
         Height          =   255
         Left            =   480
         TabIndex        =   10
         Top             =   240
         Width           =   255
      End
      Begin OptionButton order 
         Caption         =   "order"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   240
         Value           =   -1  'True
         Width           =   255
      End
   End
   Begin Frame Size_Frame 
      Caption         =   "2:1"
      Height          =   495
      Left            =   120
      TabIndex        =   3
      Top             =   3600
      Width           =   1935
      Begin OptionButton eighth 
         Caption         =   "eighth"
         Height          =   255
         Left            =   1560
         TabIndex        =   7
         Top             =   240
         Width           =   255
      End
      Begin OptionButton quarter 
         Caption         =   "quarter"
         Height          =   255
         Left            =   1200
         TabIndex        =   6
         Top             =   240
         Width           =   255
      End
      Begin OptionButton full 
         Caption         =   "full"
         Height          =   255
         Left            =   480
         TabIndex        =   5
         Top             =   240
         Width           =   255
      End
      Begin OptionButton half 
         Caption         =   "half"
         Height          =   255
         Left            =   840
         TabIndex        =   4
         Top             =   240
         Value           =   -1  'True
         Width           =   255
      End
   End
   Begin ccCallback Callback1 
      IntVersion      =   1
      Left            =   1560
      Top             =   2640
      Type            =   8  'LineDDA
   End
   Begin FileListBox File1 
      Height          =   1590
      Left            =   0
      Pattern         =   "*.jpg"
      TabIndex        =   2
      Top             =   1560
      Width           =   2175
   End
   Begin DirListBox Dir1 
      Height          =   1155
      Left            =   0
      TabIndex        =   1
      Top             =   360
      Width           =   2175
   End
   Begin DriveListBox Drive1 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   2175
   End
End
Declare Function CloseClipboard Lib "User" () As Integer
Declare Function OpenClipboard Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ECJ_Decode% Lib "WECJLIB.DLL" (ByVal Filen$, ByVal attrib%, ByVal ECJMessage&, ByVal ECJCallback&)
Declare Function SetClipboardData Lib "User" (ByVal wFormat As Integer, ByVal hMem As Integer) As Integer
Declare Function ECJ_DecodeToClipboard% Lib "WECJVB.DLL" (ByVal hWnd As Integer, ByVal Filen$, ByVal attrib%, ByVal ECJMessage&, ByVal ECJCallback&)
Declare Function ECJ_Info% Lib "WECJLIB.DLL" (ByVal Filen$, X%, Y%, color_format%)
Declare Function ECJ_Version% Lib "WECJLIB.DLL" ()
Dim color$(3)
Dim jpginfo As String
Dim pic_size%
Dim color_mode%

Const ECJ_FULL_SIZE = 0
Const ECJ_HALF_SIZE = 1
Const ECJ_4_SIZE = 64
Const ECJ_8_SIZE = 128

Const ECJ_ORDER = 0
Const ECJ_GRAY_ONLY = 4
Const ECJ_2_PASS = 8
Const ECJ_DITHER = 16
Const ECJ_24_BITS = 32

Sub auto_Click ()
    pic_size = ECJ_AUTO_SIZE
End Sub

Sub Callback1_LineDDA (Msg As Integer, wParam As Integer, lParam As Long, retval As Integer)
    Select Case Msg
    Case 0
        id = wParam \ 256
        wParam = wParam - id * 256
        size = wParam \ 8
        Select Case size
        Case 0
            shrink = ""
        Case 1
            shrink = "Shrunk 2" & Chr(215)
        Case 2
            shrink = "Shrunk 4" & Chr(215)
        Case 4
            shrink = "Shrunk 8" & Chr(215)
        End Select
        chroma = color(wParam - size * 8)
        X = lParam \ 65536
        Y = lParam - X * 65536
        form2.Caption = form2.Caption & " " & Format$(X) & Chr(215) & Format$(Y) & " " & chroma & " " & shrink
        jpginfo = form2.Caption
    Case 1
        Select Case wParam
        Case 0
            text1.Text = Str(lParam) & "%"
        Case 1
            text1.Text = "Histogram..."
        Case 2
            text1.Text = "Mapping" & Str(lParam) & "%"
        End Select
    Case 2
    End Select
    DoEvents
End Sub

Sub Command1_Click ()
   End
End Sub

Sub Dir1_Change ()
' When directory is changed, update path in Files control.
    file1.Path = Dir1.Path
End Sub

Sub Drive1_Change ()
' When drive is changed, update directory control.
' (This also causes a Change event for the directory control).
       Dir1.Path = Drive1.Drive
End Sub

Sub eighth_Click ()
    Size_Frame.Caption = "8:1"
    pic_size = ECJ_8_SIZE
End Sub

Sub File1_Click ()
    Const CF_DIB = 8
    Dim lpbmi As Long
' When at the root level (for example, C:\) the Path property
' has a backslash (\) at the end.  When at any other level,
' there is no final \.  This code handles either case to build
' the complete path and filename of the selected file.
      If Right(file1.Path, 1) <> "\" Then
        fullpath = file1.Path & "\" & file1.FileName
      Else
        fullpath = file1.Path & file1.FileName
      End If
      form2.Caption = file1.FileName
' Load the selected picture file.
      attrib = pic_size + color_mode
      hDib% = ECJ_Decode(fullpath, attrib, 0&, callback1.ProcAddress)
      form2.Caption = jpginfo
      text1.Text = ""
      dum% = OpenClipboard(form1.hWnd)
      dum% = SetClipboardData(CF_DIB, hDib%)
      dum% = CloseClipboard()
      form2.Picture = clipboard.GetData(CF_DIB)
      clipboard.Clear
End Sub

Sub Form_Load ()
' Set drive and path for controls to drive
' and directory where this application is located.
    Drive1.Drive = App.Path
    Dir1.Path = App.Path
    color(0) = "Y only"
    color(1) = "YUV422"
    color(2) = "YUV411"
    color(3) = "YUV444"
    form2.Show
End Sub

Sub full_Click ()
    Size_Frame.Caption = "1:1"
    pic_size = ECJ_FULL_SIZE
End Sub

Sub gray_Click ()
    Color_Frame.Caption = "Gray"
    color_mode = ECJ_GRAY_ONLY
End Sub

Sub half_Click ()
    Size_Frame.Caption = "2:1"
    pic_size = ECJ_HALF_SIZE
End Sub

Sub order_Click ()
    Color_Frame.Caption = "Order"
    color_mode = ECJ_ORDER
End Sub

Sub quarter_Click ()
    Size_Frame.Caption = "4:1"
    pic_size = ECJ_4_SIZE
End Sub

Sub true_Click ()
    Color_Frame.Caption = "True-color"
    color_mode = ECJ_24_BITS
End Sub

Sub two_pass_Click ()
    Color_Frame.Caption = "2 pass"
    color_mode = ECJ_2_PASS
End Sub

Sub two_pass_FS_Click ()
    Color_Frame.Caption = "2 pass dithered"
    color_mode = ECJ_DITHER + ECJ_2_PASS
End Sub

