unit dtmgrdfuncs;  {from GLScene TexTerr}
{A very rudimentary unit to read Arcinfo Grid Ascii format
P.G. Scadden, 26/10/00 P.Scadden@gns.cri.nz
change a little and LoadSurferfromfile added by
Ivan Lee Herring 12/04/02}
interface
Type
TGrd = class
          pts:array of array of single;
          destructor destroy; override;
        Public
          height,width:integer;
          maxz:single;
          null:single;
          cellsize:single;
          originX,OriginY:double;
          Function LoadArcfromfile(filename:String):Boolean;
          Function LoadSurferfromfile(filename:String):Boolean;
       end;


implementation

uses
  Windows, Messages,  FileCtrl,
   Graphics, Controls, Forms,
  Dialogs, Grids, Menus,
Sysutils, Classes, dtmHtfFrm;

Type   TCharSet = TSysCharSet;


function WordPosition(const N: Integer; const S: string;
  const WordDelims: TCharSet): Integer;
{This function lifted straight out of RXlib}
var
  Count, I: Integer;
begin
  Count := 0;
  I := 1;
  Result := 0;
  while (I <= Length(S)) and (Count <> N) do begin
    { skip over delimiters }
    while (I <= Length(S)) and (S[I] in WordDelims) do Inc(I);
    { if we're not beyond end of S, we're at the start of a word }
    if I <= Length(S) then Inc(Count);
    { if not finished, find the end of the current word }
    if Count <> N then
      while (I <= Length(S)) and not (S[I] in WordDelims) do Inc(I)
    else Result := I;
  end;
end;

function ExtractWord(N: Integer; const S: string;
  const WordDelims: TCharSet): string;
{This function lifted straight out of RXlib}
var
  I: Integer;
  Len: Integer;
begin
  Len := 0;
  I := WordPosition(N, S, WordDelims);
  if I <> 0 then
    { find the end of the current word }
    while (I <= Length(S)) and not(S[I] in WordDelims) do begin
      { add the I'th character to result }
      Inc(Len);
      SetLength(Result, Len);
      Result[Len] := S[I];
      Inc(I);
    end;
  SetLength(Result, Len);
end;

{kapiti.grd
ncols         200
nrows         225
xllcorner     2667000
yllcorner     6033000
cellsize      40
NODATA_value  -9999
-9999 -9999 ...}
Function TGrd.LoadArcfromfile(filename:String):Boolean;
var
   tracer:Boolean;
   f:TStringList;
    linestring,valstr : String;
    row,col:Integer;
    i, n:Integer;
   function ReadLine : String;
   begin
      Result:=f[n];
      Inc(n);
   end;

begin
  tracer:=False;
  f := TStringList.create;
  f.LoadFromFile(filename);
  n:=0;
  try
     HtfForm.DEMtoBinMemo.Clear;
     linestring := ReadLine;
     width := strtoInt(copy(linestring,6,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     linestring := ReadLine;
     height := strtoInt(copy(linestring,6,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     linestring := ReadLine;
     OriginX := strtofloat(copy(linestring,11,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     linestring := ReadLine;
     OriginY := strtofloat(copy(linestring,11,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     linestring := ReadLine;
     cellsize := strtofloat(copy(linestring,11,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     linestring := ReadLine;
     null := strtofloat(copy(linestring,15,50));
     HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     setlength(pts,height,width);
     {setlength(pts,width,height);}
     row := height - 1;
     col := 0;
     maxz := -3 * 10E38;
     while (n<f.Count) and (row >=0) do
     begin
       linestring := readline;
       i:= 1;
       valstr := extractword(i,linestring,[' ']);
       while valstr<>'' do
       begin
          pts [row,col] :=strtofloat(valstr);
          if pts[row,col]>maxz then maxz := pts[row,col];
          inc(col);
          If (col=width) then
          begin
            dec(row);
            col := 0;
          end;
          inc(i);
          valstr := extractword(i,linestring,[' ']);
       end;
     end;
     tracer:=True;
  finally
   LoadArcfromfile:=tracer;
    f.free;
  end;
end;


{
Surfer ASCII grid files have a five line header with
the letters "DSAA" on the first line,
the number of columns and rows on the second line,
the range of longitude on the third line,
the range of latitude on the fourth line,
and the range of depth on the fifth line.
Thereafter, depths are listed by rows
  starting at the lower left hand corner.
Skagtext.grd
Convert your data in ASCII using the following data structure
(Surfer ASCII grid file):
 DSAA
329 582
  0.00  3280.00
  0.00  5810.00
-40 1065
DSAA
nx ny    "where nx is the integer number of grid lines along the X axis (columns)
            ny is the integer number of grid lines along the Y axis (rows)
xlo xhi  "where  xlo is the minimum X value of the grid
            xhi is the maximum X value of the grid
ylo yhi  "where  ylo is the minimum Y value of the grid
            yhi is the maximum Y value of the grid
zlo zhi   "where  zlo is the minimum Z value of the grid
            zhi is the maximum Z value of the grid
grid row 1
grid row 2
grid row 3
    these are the rows of Z values of the grid,
 organized in row order.
 Each row has a constant Y coordinate.
 Grid row 1 corresponds to ylo and
 the last grid row corresponds to yhi.
 Within each row, the Z values are arranged from xlo to xhi.
}
Function TGrd.LoadSurferfromfile(filename:String):Boolean;
var
   tracer:Boolean;
   f:TStringList;
    linestring,valstr : String;
    row,col:Integer;
    i, n:Integer;
    OriginX2:double;
   function ReadLine : String;
   begin
      Result:=f[n];
      Inc(n);
   end;

begin
  tracer:=False;
  f := TStringList.create;
  f.LoadFromFile(filename);
  n:=0;
  try
     HtfForm.DEMtoBinMemo.Clear;
     linestring := ReadLine;
      HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     {nxFileSizeX  ny FileSizeY}
     linestring := ReadLine;
      HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     width:=Strtoint(trim(Copy(linestring,1,Pos(' ',linestring))));
     height:=Strtoint(trim(Copy(linestring,Pos(' ',linestring),Length(linestring))));
      HtfForm.DEMtoBinMemo.LineS.Append('width:'+inttostr(width)+'  '+'height:'+inttostr(height));
     linestring := ReadLine; {X}
     linestring := trim(linestring);
      HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     OriginX:=Strtofloat(trim(Copy(linestring,1,Pos(' ',linestring))));
     OriginX2:=Strtofloat(trim(Copy(linestring,Pos(' ',linestring),Length(linestring))));
     cellsize := OriginX2-OriginX / width;
     linestring := ReadLine; {Y}
     linestring := trim(linestring);
      HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     OriginY:=Strtofloat(trim(Copy(linestring,1,Pos(' ',linestring))));
     linestring := ReadLine;  {Z}
     linestring := trim(linestring);
      HtfForm.DEMtoBinMemo.LineS.Append(linestring);
     null:=(Strtoint(trim(Copy(linestring,1,Pos(' ',linestring)))) -1);
{     setlength(pts,width,height);}
     setlength(pts,height,width);
     row := height - 1;
     col := 0;
     maxz := -3 * 10E38;
     while (n<f.Count) and (row >=0) do
     begin
       linestring := readline;
       i:= 1;
       valstr := extractword(i,linestring,[' ']);
       while valstr<>'' do
       begin
          pts [row,col] :=strtofloat(valstr);
          if pts[row,col]>maxz then maxz := pts[row,col];
          inc(col);
          If (col=width) then
          begin
            dec(row);
            col := 0;
          end;
          inc(i);
          valstr := extractword(i,linestring,[' ']);
       end;
     end;
     tracer:=True;
  finally
    LoadSurferfromfile:=tracer;
    f.free;
  end;
end;





destructor Tgrd.destroy;
begin
  pts := nil;
  inherited destroy;
end;

end.
