{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{          Digital Terrain Mapping Main Form            }             
{*******************************************************}
unit dtmfrm;
{: GLScene:
   Basic viewer for HTF Content.<p>
   Gives basic time stats for HTF data extraction and rendering (there is NO
   cache, each tile is reloaded each time from the disk, ie. those are the
   timings you could expect when accessing an HTF area for the first time or
   when "moving at high speed").<p>
   Requires the Graphics32 library (http://www.g32.org)..now... GR32}
  {GLSViewerFrm requires Graphex by Lischke}
(*  Changed March..August 2002 by Ivan Lee Herring
  dtmGlobals in 'dtmGlobals.pas',
  DtmShpSaver in 'DtmShpSaver.pas',  includes  dtmProgressForm
  dtmgrdfuncs in 'dtmgrdfuncs.pas',
  aclass5 in '..\common\aclass5.pas',
  dtmcommasplit in 'dtmcommasplit.pas',
  dtmgridimportfn in 'dtmgridimportfn.pas',
  dtmPOFrm in 'dtmPOFrm.pas' {dtmPOFForm},                  50
  dtmAbout in 'dtmAbout.pas' {AboutDTM},                   222
  dtmSysInfo in 'dtmSysInfo.pas' {SystemInfoForm},       13000
  dtmfrm in 'dtmfrm.pas' {DTMform},                       1000
  dtmHtfFrm in 'dtmHtfFrm.pas' {HtfForm},                 2001
  dtmNavFrm in 'dtmNavFrm.pas' {NavForm},                 3000
  dtmGlFrm in 'dtmGlFrm.pas' {DTMGLForm},                 4567
  dtmGlHeight in 'dtmGlHeight.pas' {dtmGlHeightForm}      4321
  dtmJoy in 'dtmJoy.pas' {dtmJoyForm}                     4444
  dtmIMFrm in 'dtmIMFrm.pas' {ImageMakerForm}             5678
  dtmLegend in 'dtmLegend.pas' {LegendForm}               6000
  dtmDbFrm in 'dtmDbFrm.pas' {dtmDbForm}                  7000
  dtmDbAboutFrm in 'dtmDbAboutFrm.pas' {dtmDbAboutForm},   Db Component
  AllSplash in '..\common\AllSplash.pas' {SplashScreen};
  dtmSmdQcFrm in 'dtmSmdQcFrm.pas' {dtmSmdQcForm},               8000
  dtmSmdLoadMdlFrm in 'dtmSmdLoadMdlFrm.pas' {dtmSmdLoadMdlForm},8500
  dtmPanVizFrm in 'dtmPanVizFrm.pas' {dtmPanVizForm},            9000
  dtmImageRGB in 'dtmImageRGB.pas' {DtmImageRGBForm};           10000
  dtmImageDotRGB in 'dtmImageDotRGB.pas' {DtmImageDotRGBForm},  10500
  GLSViewerFrm in 'GLSViewerFrm.pas' {GLSViewerForm}            11000
  dtmLOSProfile in 'dtmLOSProfile.pas' {LineProfileForm}        12000
  dtmSysInfo in 'dtmSysInfo.pas' {SystemInfoForm},              13000
  dtmRasterImageFile in 'dtmRasterImageFile.pas',      duped from HTF
  dtmRIFImageViewerFrm in 'dtmRIFImageViewerFrm.pas'
                           {RIFImageViewerForm};                14000
  dtmEcotypeColorsFrm in 'dtmEcotypeColorsFrm.pas'
                           {dtmEcotypeColorsForm};  Legend part 2
    includes the Db and 2 Reports                               6500
         EcoDbForm   6996    EcoDbReportForm   EcoDbCSForm
  SELDIRHELP = 120;
TODO
GL tin the data and start at center tile
reload area whenever moved out of center tile
recenter area to 3x3 tiles
Resize Bitmap when loaded to 3x3 tiles.. Use bitmap as texture*)

{gridlines,
 coordinate conversion,
 SCALE of Terrain and thus Data/Actor}
{procedure THtfForm.ReadAnyVersionProj(ReadFileName:String);
procedure THtfForm.ReadVersionProj(ReadFileName:String);
procedure THtfForm.ReadVer1Proj(ReadFileName:String);

procedure THtfForm.WriteProjectionFile(InfileName:String);
procedure THtfForm.WriteBitFile(InfileName:String);
procedure THtfForm.WriteTpcfgFile(InfileName:String);}

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms,  Geometry,
  Dialogs,  ActnList, ExtDlgs,
  StdCtrls, ExtCtrls, ComCtrls, ImgList,
  Menus, ToolWin,
  MRUList, {bz Menu list}
  HeightTileFile,  {HTF file access}
  GR32, GR32_Layers, GR32_Polygons, GR32_Image;

const
  DataLimit = 9;
type
  ScoreList = array[1..DataLimit] of Real;
type
  TDTMform = class(TForm)
    ToolBar: TToolBar;
    ImageList: TImageList;
    ActionList: TActionList;
    OpenTB: TToolButton;
    LAMap: TLabel;
    ToolButton2: TToolButton;
    ACOpen: TAction;
    ACExit: TAction;
    ExitTB: TToolButton;
    OpenDialog: TOpenDialog;
    ToolButton4: TToolButton;
    TBGrid: TToolButton;
    ToolButton5: TToolButton;
    NavMapTB: TToolButton;
    ACNavMap: TAction;
    StatusBar: TStatusBar;
    PalettesTB: TToolButton;
    ACPalette: TAction;
    PMPalettes: TPopupMenu;
    OpenDialogPal: TOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    View1: TMenuItem;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    OnHelp1: TMenuItem;
    Me1: TMenuItem;
    About1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    Navigator1: TMenuItem;
    Options1: TMenuItem;
    N2: TMenuItem;
    HTFpack1: TMenuItem;
    HintsPanel: TPanel;
    Grid1: TMenuItem;
    MRUFileList: TMRUFileList;
    OpenShape1: TMenuItem;
    N3: TMenuItem;
    Image321: TImage32;
    Legend1: TMenuItem;
    Imagemaker1: TMenuItem;
    DemDblist1: TMenuItem;
    LatLongGrid1: TMenuItem;
    N4: TMenuItem;
    ElevationTint1: TMenuItem;
    SlopeTint1: TMenuItem;
    ContourLines1: TMenuItem;
    Tools1: TMenuItem;
    TLLGrid: TToolButton;
    LineofSight1: TMenuItem;
    LOSMaskedArea1: TMenuItem;
    ContourLines21: TMenuItem;
    ContourLinesAll1: TMenuItem;
    SlopeDirectional1: TMenuItem;
    RagDoll1: TMenuItem;
    Panaviewer1: TMenuItem;
    N5: TMenuItem;
    SlopeSetDirection1: TMenuItem;
    Image3DHistogram1: TMenuItem;
    Image3DdotHistogram1: TMenuItem;
    ProgressBar1: TProgressBar;
    GLSViewer1: TMenuItem;
    N6: TMenuItem;
    Joystick1: TMenuItem;
    N7: TMenuItem;
    RIFImageViewer1: TMenuItem;
    N8: TMenuItem;
    SaveDtmProject1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Redraw1: TMenuItem;
    N9: TMenuItem;
    OpenBackImage1: TMenuItem;
    N10: TMenuItem;
    Ecotype1: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    OpenDtp1: TMenuItem;
    N11: TMenuItem;
    SetEcoColors1: TMenuItem;
    SlopePercent1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

procedure ShowHint(Sender: TObject);
procedure DisplaySplashScreen;
    procedure ACExitExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormKeyPress(Sender: TObject; var Key: Char);

{here}

procedure DodtpLoad(InDtmFilename:String);
procedure DodtmMapLoad(InDtmFilename:String);
    procedure SaveDtmProject1Click(Sender: TObject);
procedure DoSaveDtmProject(Filename:String);

    procedure MRUFileListMRUItemClick(Sender: TObject;
      AFilename: TFileName);
    procedure ACOpenExecute(Sender: TObject);
procedure DoLoad(AFilename:String);
{procedure DoGlTerrain(Switch:Integer);}
    procedure PrepareBitmap;
procedure PrepareBigBitmap;
procedure PrepareTileBitmap;
procedure PrepTints(Xwin,Yhin:Integer);
procedure PrepContour1(Xwin,Yhin:Integer);
procedure SortItQuick(Count: Integer; var Item: ScoreList);
procedure PrepContour2(Xwin,Yhin:Integer);
procedure PrepLOS(Xwin,Yhin:Integer);
procedure PrepEcoType(Xwin,Yhin:Integer);

    procedure TBGridClick(Sender: TObject);
    procedure ACNavMapExecute(Sender: TObject);
    procedure ACNavMapUpdate(Sender: TObject);
    procedure ACPaletteExecute(Sender: TObject);
    procedure HTFpack1Click(Sender: TObject);

    procedure Options1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure OnHelp1Click(Sender: TObject);
    procedure Me1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure OpenShape1Click(Sender: TObject);
Function NewLayer:Boolean;
Function LoadLayer:Boolean;
procedure DVDORedraw;
    procedure Image321Resize(Sender: TObject);
    procedure Image321MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
    procedure Image321MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer; Layer: TCustomLayer);
    procedure Image321MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
    procedure Legend1Click(Sender: TObject);
    procedure Imagemaker1Click(Sender: TObject);
    procedure DemDblist1Click(Sender: TObject);


{procedure ContourDisplay;}
    procedure LatLongGrid1Click(Sender: TObject);
procedure AllBtnsUp;
    procedure ElevationTint1Click(Sender: TObject);
    procedure SlopeTint1Click(Sender: TObject);
    procedure SlopeDirectional1Click(Sender: TObject);
    procedure SlopeSetDirection1Click(Sender: TObject);
    procedure ContourLines1Click(Sender: TObject);
    procedure ContourLines21Click(Sender: TObject);
    procedure ContourLinesAll1Click(Sender: TObject);

    procedure Ecotype1Click(Sender: TObject);
    procedure SetEcoColors1Click(Sender: TObject);

    procedure LineofSight1Click(Sender: TObject);
    procedure LOSMaskedArea1Click(Sender: TObject);
procedure DoLOSint(LOSintin,X,Y:Integer);
{procedure LineofSightArea;}
    procedure RagDoll1Click(Sender: TObject);
    procedure Panaviewer1Click(Sender: TObject);
    procedure Image3DHistogram1Click(Sender: TObject);
    procedure Image3DdotHistogram1Click(Sender: TObject);
    procedure GLSViewer1Click(Sender: TObject);

    procedure Joystick1Click(Sender: TObject);

    procedure RIFImageViewer1Click(Sender: TObject);
    procedure Redraw1Click(Sender: TObject);
    procedure OpenBackImage1Click(Sender: TObject);

    procedure OpenDtp1Click(Sender: TObject);
    procedure SlopePercent1Click(Sender: TObject);

  private
    { Private declarations }
    {DemName, DemPath,    ProjectName  HTFPath}
    BackBitmapName,  BackBitmapPath:String;
    BackClipBitmap,
    bmpTile : TBitmap32;  {Used for each small tile}
                          {big tiled image is Image321's}
    curX, curY, mx, my : Integer;{Mouse locations}
    {EcoMatrix: array of array of Smallint;}
  public
    { Public declarations }
     Canvas: TCanvas;
     Dragging: Boolean;
  end;

var
  DTMform: TDTMform;
  DataItem: ScoreList;
  LOSint,NumberOfScores1: Integer;
  heightColor : array [Low(SmallInt)..High(SmallInt)] of TColor32;

implementation

{$R *.dfm}

uses Registry,
     AllSplash, dtmGlobals,
     dtmPOFvar,DtmShpSaver,dtmErrMsg,
     dtmNavFrm,
     dtmHtfFrm, dtmPOFrm,
     dtmIMFrm, dtmDTPFrm, dtmDbFrm, dtmAbout,
     DtmGlfrm, dtmGlHeight,
     dtmSmdQcFrm,
     dtmImageRGB, dtmImageDotRGB, dtmPanVizFrm,
     dtmGLSViewerFrm, dtmLOSProfile, dtmJoy, dtmSmdLoadMdlFrm,
     dtmRIFImageViewerFrm,
     dtmEcotypeColorsFrm,dtmEcoReader;

{ Quick'n dirty parser for palette file format '.pal',
  in which each line defines
  nodes in the color ramp palette:
             value:red,green,blue
  color is then interpolated between node values
     (ie. between each line in the file)}
procedure PreparePal(const fileName : String);
   procedure ParseLine(buf : String; var n : Integer; var c : TAffineVector);
   var
      p : Integer;
   begin
      p:=Pos(':', buf);
      n:=StrToInt(Copy(buf, 1, p-1)); buf:=Copy(buf, p+1, MaxInt);
      p:=Pos(',', buf);
      c[0]:=StrToInt(Copy(buf, 1, p-1)); buf:=Copy(buf, p+1, MaxInt);
      p:=Pos(',', buf);
      c[1]:=StrToInt(Copy(buf, 1, p-1)); buf:=Copy(buf, p+1, MaxInt);
      c[2]:=StrToInt(buf);
   end;
var
   prev, next : Integer;
   pC, nC : TAffineVector;
   procedure Ramp;
   var
      cur : Integer;
      cC : TAffineVector;
      d : Single;
   begin
      if prev<next then
         d:=1/(next-prev)
      else d:=0;
      for cur:=prev to next do
      begin
         cC:=VectorLerp(pC, nC, (cur-prev)*d);
         heightColor[cur]:=Color32(Round(cC[0]), Round(cC[1]), Round(cC[2]));
      end;
   end;
var
   i : Integer;
   sl : TStrings;
begin
   sl:=TStringList.Create;
   try
      sl.LoadFromFile(fileName);
      prev:=0;
      pC:=NullVector;
      for i:=0 to sl.Count-1 do
      begin
         ParseLine(sl[i], next, nC);
         Ramp;
         prev:=next;
         pC:=nC;
      end;
   finally
      sl.Free;
   end;
end;


procedure TDTMform.FormCreate(Sender: TObject);
var
   reg : TRegistry;
   shellCmd : String;
   keyOkay : Boolean;
const
   cKeyName : String = 'Applications\dtm.exe\shell\open\command';
   cFriendlyKeyName : String = 'Applications\dtm.exe';
var
   i,ii : Integer;
   sr : TSearchRec;
   mi : TMenuItem;
   sl : TStringList;
   Helps: string;
begin
  if FileExists(ExtractFilePath(ParamStr(0)) + 'dtm.pof') then
  begin
    DoLoader;
  end else
  begin
    StartedNameNumber := 'Not Registered';
    Started := Date;
    Colorreg := 123;
    RandSeed:=8111953;
    Helps:='';
    HiddenString:=
      'DTM 1.2 Copyright, 2002: Ivan Lee Herring ';
    For i:=length(HiddenString) to 254 do
    Helps:= Helps + char(random(128)+32);
    HiddenString:= HiddenString+Helps;
    ResetToDefaults;
    DoSaver;
  end; {of pof file, start of normal initialize}
  If (not SkipIntroScreen) then DisplaySplashScreen;
  top := DTMformY;
  left := DTMformX;{  Version:='1.1';  moved to Global Const}
  ProgramPath := ExtractFilePath(ParamStr(0));
  OpenDialog.InitialDir := ProgramPath;
  ForceCurrentDirectory := True;
  {Get App Location to load Help}
  Helps := ProgramPath + 'dtm.HLP';
  Application.HelpFile := Helps;
  Application.OnHint := ShowHint;
  ProgressBar1.Visible:=False;
  ProjectActorOtsFilename:= NoName;
  isRunningOnDtp:=False;
  isReallyGone:=False;
  isHTFLoaded:=False;
  Dragging := False;
  NoGLRunning:=True;
  LOSint:=0;
  DShiftOffsetX:=0;
  DShiftOffsetY:=0;
  MaxOffsetX:=0;
  MaxOffsetY:=0;
  MinimumElevation:=0;
  MaximumElevation:=0;
  SetLength(ManMatrix,10,10);
  Randomize;
  For i:=0 to 9 do
    For ii:=0 to 9 do
      ManMatrix[i,ii]:= Random(100);
  SetLength(EcoRecord, 10, 10);
  bmpTile:=TBitmap32.Create;
  Image321.SetupBitmap;
  Image321.Bitmap.Clear(clWhite32);
  Canvas := TCanvas.Create; // create a new independent TCanvas object
  Canvas.Handle := Image321.Bitmap.Handle; // attach it to the Bitmap32 object
  LayersLoaded:=0;
  OpenShape1.Enabled:=False;
  Legend1.Enabled:=False;
  OpenBackImage1.Enabled:=False;
  Imagemaker1.Enabled:=False;
  PreparePal(ProgramPath+'Blue-Green-Red.pal');
  i:=FindFirst(ProgramPath+'*.pal', faAnyFile, sr);
  sl:=TStringList.Create;
  try
    while i=0 do
    begin
      sl.Add(sr.Name);
      i:=FindNext(sr);
    end;
    sl.Sort;
    for i:=0 to sl.Count-1 do
    begin
      mi:=TMenuItem.Create(PMPalettes);
      mi.Caption:=Copy(sl[i], 1, Length(sl[i])-4);
      mi.Hint:=ProgramPath+sl[i];
      mi.OnClick:=ACPaletteExecute;
      PMPalettes.Items.Add(mi);
    end;
  finally
    sl.Free;
    FindClose(sr);
  end;

  MMSysHandle := LoadLibrary('WINMM.DLL');
  if (MMSysHandle <> 0) then
  begin
    @PlaySound := GetProcAddress(MMSysHandle, 'sndPlaySoundA');
  end else
  begin
    MMSysHandle := LoadLibrary('MMSYSTEM.DLL');
    if (MMSysHandle <> 0) then
    begin
      @PlaySound := GetProcAddress(MMSysHandle, 'sndPlaySound');
    end;
  end;
  if (MMSysHandle = 0) then DoMessages(22222);
       {22222, "WINMM.DLL or MMSYSTEM.DLL required for Sound"}
   // register as an application that handles arbitrary file classes
   //from GLSViewer...
   try
      reg:=TRegistry.Create;
      try
         shellCmd:='"'+Application.ExeName+'" "%1"';
         reg.RootKey:=HKEY_CLASSES_ROOT;
         keyOkay:=False;
         if reg.OpenKeyReadOnly(cKeyName) then
            keyOkay:=(reg.ReadString('')=shellCmd);
         if not keyOkay then begin
            reg.CloseKey;
            if reg.OpenKey(cKeyName, True) then
               reg.WriteString('', shellCmd);
            reg.CloseKey;
            if reg.OpenKey(cFriendlyKeyName, True) then
               reg.WriteString('FriendlyAppName', 'dtm, OpenGL 3D Files Viewer');
   {cKeyName : String = 'Applications\dtm.exe\shell\open\command';
   cFriendlyKeyName : String = 'Applications\dtm.exe';}
         end;
      finally
         reg.Free;
      end;
   except
      // ignore all registry issues (not critical)
   end;
end;

procedure TDTMform.FormShow(Sender: TObject);
begin
  if ParamCount >0 then
  begin
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.HTF' then
    begin   {Check self first  DTMPath}
      HTFPath := ExtractFilePath(ParamStr(1));
      HTFName := ExtractFileName(ParamStr(1));   {Ecotype1}
      DoLoad(ParamStr(1));
    end else    {dtm Map file}
    If (Lowercase(ExtractFileExt(ParamStr(1)))= '.dtm') then
      DodtmMapLoad(ParamStr(1))
    else         {dtm Project file}
    If (Lowercase(ExtractFileExt(ParamStr(1)))= '.dtp') then
      DodtpLoad(ParamStr(1))
    else    {Pan images?}
    if ((UpperCase(ExtractFileExt(ParamStr(1))) = '.BMP')
      or (UpperCase(ExtractFileExt(ParamStr(1))) = '.JPG')
      or (UpperCase(ExtractFileExt(ParamStr(1))) = '.PNG')) then
    begin    {Need a Plane for 'flat' pictures}
      NoGLRunning:=False;
      dtmPanVizForm.Show;
      dtmPanVizForm.ShowDown(ParamStr(1));
    end else
    {Actors}
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.QC' then
    begin
      NoGLRunning:=False;
      dtmSmdQcForm.Show;
      dtmSmdQcForm.DoCcOpen(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.MDL' then
    begin
      dtmSmdLoadMdlForm.show;
      dtmSmdLoadMdlForm.DoMdlOpen(ParamStr(1));
    end else
    {?All? Terrain data types}
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.TPCFG' then
    begin
      HtfForm.show;
      HtfForm.DoTpcfgOpen(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.DEM' then
    begin
      HtfForm.show;
      HtfForm.SetDefaultDEMProj;
      DemPath:= ExtractFilePath(ParamStr(1));
      HtfForm.DoDEMtoBin(ParamStr(1),0);
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.GRD' then
    begin
      HtfForm.show;
    HtfForm.DoSurferGridtoBin(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.XYZ' then
    begin
      HtfForm.show;
      HtfForm.DoXYZtoBin(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.BT' then
    begin
      HtfForm.show;
      HtfForm.DoBT(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.VRP' then
    begin
      HtfForm.show;
      HtfForm.ReadAnyVersionProj(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.VRP' then
    begin    {BIT... make a little bitty bit viewer,}
      HtfForm.show;
      HtfForm.ReadAlittleBit(ParamStr(1));
    end else
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.SHP' then
    begin         {SHP simple viewer?}
      HtfForm.show;
      HtfForm.ReadAlittleShp(ParamStr(1));
    end else
    {3D RGB image pixel count}
    if UpperCase(ExtractFileExt(ParamStr(1))) = '.RS3' then
    begin
      ImagePath:=ExtractFilePath(ParamStr(1));
      NoGLRunning:=False;
      Application.ProcessMessages;
      DtmImageRGBForm.Show;
      DtmImageRGBForm.ShowDown(ParamStr(1));
    end else
    begin  {GLSViewer 3d files.. .smd, .3ds, ...? and
                         Object + Texture Set (*.ots) }
    NoGLRunning:=False;
    dtmGLSViewerForm.show;
    end;
  end;
end;

procedure TDTMform.DisplaySplashScreen;
begin
  SplashScreen := TSplashScreen.Create(Application);
  SplashScreen.SplashSet(7,2000);
  SplashScreen.Show;
  SplashScreen.Refresh;
end;

procedure TDTMform.ShowHint(Sender: TObject);
begin
  HintsPanel.Caption := Application.Hint;
end;

procedure TDTMform.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  LayersLoaded:=0;
  isReallyGone:=True;
  Application.ProcessMessages;
  { DTMGLForm.Close;}
  DTMformY := DTMform.top;
  DTMformX := DTMform.left;
  DoSaver;
  Application.ProcessMessages;
  CanClose:=True;
end;

procedure TDTMform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{  Application.ProcessMessages;}
end;

procedure TDTMform.FormDestroy(Sender: TObject);
begin
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  SetLength(EcoRecord, 0, 0);
  htf.Free;
  bmpTile.Free;
  BackClipBitmap.Free;
  Canvas.Free;
end;

procedure TDTMform.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

procedure TDTMform.ACExitExecute(Sender: TObject);
begin
  Close;
end;


procedure TDTMform.MRUFileListMRUItemClick(Sender: TObject;
  AFilename: TFileName);
begin
  If (Lowercase(ExtractFileExt(AFilename))= '.dtp') then
      DodtpLoad(AFilename)
  else
  If (Lowercase(ExtractFileExt(AFilename))= '.htf') then
      DoLoad(AFilename)
  else if not Assigned(htf) then Exit
  else if ('.SHP'= UpperCase(ExtractFileExt(AFilename))) then
  begin
    ShapePath := ExtractFilePath(AFilename);
    ShpFileName := AFilename;
    If NewLayer then
    begin
      {load database}
    end  else
    begin
      {Clear arrays cause it crashed}
      SetLength(ManMatrix,10,10);{so GL Heightfield does not crash}
      SetLength(LayA,0);
      SetLength(LayersControlArray,0);
      SetLength(ShapesFoundArray,0);
      DoMessages(8);{8, "Not a Shape (*.shp) file"}
    end;
  end;
end;

procedure TDTMform.DodtmMapLoad(InDtmFilename:String);
Begin
{}
End;

procedure TDTMform.OpenDtp1Click(Sender: TObject);
begin
  OpenDialog.Filter:= 'DTP File (*.dtp)|*.dtp|dtp Files (*.dtp)|*.dtp';
  {HTF File (*.htf)|*.htf|All Files (*.*)|*.*}
  OpenDialog.FileName:= '*.dtp';
  OpenDialog.InitialDir:=ProjectPath;
  if OpenDialog.Execute then
  If (Lowercase(ExtractFileExt(OpenDialog.FileName))= '.dtp') then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.FileName);
    DodtpLoad(OpenDialog.FileName);
  end;
end;
procedure TDTMform.DodtpLoad(InDtmFilename:String);
var
  ShapeFileInT: Textfile;
  InShpFilename,InPath:String[255];
  CanvasLineSize,
  IStipple,  LoaderLayersLoaded, ILoad:Integer;
    {GR32 data}
    LayerColor,OutLineColor:TColor;
    PolyFilled, UseOutlinePoly, PolygonAntialiased:Boolean;
    PointSize, CurrentPointType,
    FillAlphaPosition, LineAlphaPosition:Integer;
    LineSize:Double;
    WhatsMyLine,InVersion, OtsNameEditText:String;
    StippleColorCount:Integer;
    UseStippleStep:Boolean;
    StippleStep:Single;
    StippleColorArray:array of TColor;
Begin
  Try
    ProjectName:= ExtractFileName(InDtmFilename);
    ProjectPath:= ExtractFilePath(InDtmFilename);
    AssignFile(ShapeFileInT, InDtmFilename);
    Reset(ShapeFileInT);
    Application.ProcessMessages;
    Readln(ShapeFileInT, InVersion); {Version}
    If (Version<>InVersion) then {ErrorMessage};
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then bDemLoaded:=True
                          else bDemLoaded:=False;{Boolean}
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then bBackClipBitmapLoaded:=True
                          else bBackClipBitmapLoaded:=False;{Boolean}

    Readln(ShapeFileInT, HTFPath);
    Readln(ShapeFileInT, HTFName);
    Readln(ShapeFileInT, BackBitmapPath{, SizeOf(BackBitmapPath), NumRead});
    Readln(ShapeFileInT, BackBitmapName{, SizeOf(BackBitmapName), NumRead});
    {LoadDem}
    If (not bDemLoaded) then {ErrorMessage};
    DoLoad(HTFPath+HTFName);
    bDemLoaded:=True;
    {LoadBitmap}
    If bBackClipBitmapLoaded then
    begin
      BackClipBitmap := TBitmap32.Create;
      BackClipBitmap.LoadFromFile(BackBitmapPath+BackBitmapName);
      {Figure out the Image Size and Registration:
      StretchDraw X,Y, Width, Height}
      Image321.Bitmap.Draw(0,0, BackClipBitmap);
      {Tint of Area not Covered... Background Layer Level Top..Bottom}
    end;
    {LayersLoaded}
    Readln(ShapeFileInT, ProjectActorOtsFilename);

    Readln(ShapeFileInT, WhatsMyLine);
    LoaderLayersLoaded:=strtoint(WhatsMyLine);
    For ILoad := 1 to  LoaderLayersLoaded do
    begin
      Readln(ShapeFileInT, InShpFilename);
      Readln(ShapeFileInT, InPath);
      ShpFileName:=InPath+InShpFilename;
    {GR32 data}
    Readln(ShapeFileInT, WhatsMyLine);         {:TColor;}
    LayerColor:=strtoint(WhatsMyLine);

    Readln(ShapeFileInT, WhatsMyLine);
    OutLineColor:=strtoint(WhatsMyLine);{:TColor;}

    {Boolean}
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then UseOutlinePoly:=True
                          else UseOutlinePoly:=False;{Boolean}
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then PolygonAntialiased:=True
                          else PolygonAntialiased:=False;{Boolean}
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then PolyFilled:=True
                          else PolyFilled:=False;{Boolean}

    Readln(ShapeFileInT, WhatsMyLine);
    PointSize:=strtoint(WhatsMyLine);
    Readln(ShapeFileInT, WhatsMyLine);
    CurrentPointType:=strtoint(WhatsMyLine);

    Readln(ShapeFileInT, WhatsMyLine);
    FillAlphaPosition:=strtoint(WhatsMyLine);

    Readln(ShapeFileInT, WhatsMyLine);
    LineAlphaPosition:=strtoint(WhatsMyLine);{:Integer;}
    Readln(ShapeFileInT, WhatsMyLine);
    LineSize:=strtofloat(WhatsMyLine);{:Single;}

    Readln(ShapeFileInT, WhatsMyLine);
    CanvasLineSize:=strtoint(WhatsMyLine);

    Readln(ShapeFileInT, OtsNameEditText);{:String;}

    Readln(ShapeFileInT, WhatsMyLine);
    StippleColorCount:=strtoint(WhatsMyLine);
    Readln(ShapeFileInT, WhatsMyLine);
    If WhatsMyLine='True' then UseStippleStep:=True
                          else UseStippleStep:=False; {:Boolean;}
    Readln(ShapeFileInT, WhatsMyLine);
    StippleStep:=strtofloat(WhatsMyLine);   { :Single;}
    SetLength(StippleColorArray,StippleColorCount);
    For IStipple := 0 to StippleColorCount-1 do
    begin
    Readln(ShapeFileInT, WhatsMyLine);
    StippleColorArray[IStipple]:=strtoint(WhatsMyLine);
        {:array of TColor;}
    end;

      {Get the .db extension and check for it}
      If FileExists(ChangeFileExt(ShpFileName,'.dbf')) then
      begin
        ShapePath := ExtractFilePath(ShpFileName);
        Image321.Cursor:=crHourGlass; {crDefault}
        If NewLayer then
        begin
          Legend1.Enabled:=True;
  LayA[CurrentLayer].LayerColor:=LayerColor;
  LayA[CurrentLayer].OutLineColor:=OutLineColor;
  LayA[CurrentLayer].PolygonAntialiased:=PolygonAntialiased;
  LayA[CurrentLayer].PolyFilled:=PolyFilled;

  LayA[CurrentLayer].LineAlphaPosition:=LineAlphaPosition;
  LayA[CurrentLayer].FillAlphaPosition:=FillAlphaPosition;
  LayA[CurrentLayer].UseOutlinePoly := UseOutlinePoly;
  LayA[CurrentLayer].LineSize := LineSize;
  LayA[CurrentLayer].CanvasLineSize:=CanvasLineSize;
  LayA[CurrentLayer].PointSize:=PointSize;
  LayA[CurrentLayer].CurrentPointType:=CurrentPointType;
  LayA[CurrentLayer].OtsNameEditText:= OtsNameEditText;
  LayA[CurrentLayer].StippleColorCount:= StippleColorCount;
  LayA[CurrentLayer].UseStippleStep:=UseStippleStep;{ :Boolean;}
  LayA[CurrentLayer].StippleStep:= StippleStep;{  :Single;}
    SetLength(LayA[CurrentLayer].StippleColorArray,StippleColorCount);
    For IStipple := 0 to StippleColorCount-1 do
    begin
      LayA[CurrentLayer].StippleColorArray[IStipple]:=
          StippleColorArray[IStipple];  {:array of TColor;}
    end;
        end else DoRezError(19);
        {Read Layers Shapes GR32 data AND PLACE OVER the default data}
        Image321.Cursor:=crDefault; {crDefault}
      end else DoRezError(20);
    end;
    If InVersion <> Verstring{'1.1'} then
    begin
      {Ready for new version activities here}
    end;
    isRunningOnDtp:=True;
  Finally
    CloseFile(ShapeFileInT);
  End;
  PrepareBitmap;
End;

procedure TDTMform.SaveDtmProject1Click(Sender: TObject);
begin                      { HTFName }
  SaveDialog1.Filter:= 'DTP Project (*.dtp)|*.dtp';
  SaveDialog1.InitialDir:=ProjectPath;
  SaveDialog1.DefaultExt:='dtp';
  SaveDialog1.Filename:=ChangeFileExt(ProjectName,'.dtp' );
  if SaveDialog1.Execute then
  begin
    Application.ProcessMessages;
    ProjectName:= ExtractFileName(SaveDialog1.Filename);
    ProjectPath:= ExtractFilePath(SaveDialog1.Filename);
    DoSaveDtmProject(SaveDialog1.Filename);
    isRunningOnDtp:=True;
  end;
End;

procedure TDTMform.DoSaveDtmProject(Filename:String);
var
  ShapeFileInT: Textfile;
  {  InShpFilename,InPath:String[255];}
  IStipple, ILoad:Integer;
    {GR32 data}
    LayerColor,OutLineColor:TColor;
    PolyFilled, UseOutlinePoly, PolygonAntialiased:Boolean;
    CanvasLineSize,
    PointSize, CurrentPointType,
    FillAlphaPosition, LineAlphaPosition:Integer;
    LineSize:Double;
    WhatsMyLine,{InVersion,} OtsNameEditText:String;
    StippleColorCount:Integer;
    UseStippleStep:Boolean;
    StippleStep:Single;
    StippleColorArray:array of TColor;
Begin
  Try
    AssignFile(ShapeFileInT, FileName);
    Rewrite(ShapeFileInT);
    WhatsMyLine:=Verstring;
    Writeln(ShapeFileInT, WhatsMyLine); {Version};
    {If bDemLoaded=True then WhatsMyLine:='True'
                       else WhatsMyLine:='False';}{Boolean}
    WhatsMyLine:='True';
    Writeln(ShapeFileInT, WhatsMyLine);
    If bBackClipBitmapLoaded=True then WhatsMyLine:='True'
                       else WhatsMyLine:='False';{Boolean}
    Writeln(ShapeFileInT, WhatsMyLine);

    Writeln(ShapeFileInT, HTFPath);
    HTFName:=ChangeFileExt(HTFName,'.htf' );
    Writeln(ShapeFileInT, HTFName);
    If (not bBackClipBitmapLoaded) then
    begin
    BackBitmapPath:=NoName;
    BackBitmapName:=NoName;
    end;
    Writeln(ShapeFileInT, BackBitmapPath);
    Writeln(ShapeFileInT, BackBitmapName);
    Writeln(ShapeFileInT, ProjectActorOtsFilename);{NoName}
    WhatsMyLine:=inttostr(LayersLoaded);
    Writeln(ShapeFileInT, WhatsMyLine);
    {LayersLoaded}
    For ILoad := 1 to  LayersLoaded do
    begin
      {LayA[CurrentLayer].LayerDBName
       LayA[CurrentLayer].LayerDBPath}
      Writeln(ShapeFileInT, LayA[ILoad].Filename);
      Writeln(ShapeFileInT, LayA[ILoad].Path);
    {GR32 data}
LayerColor:=  LayA[ILoad].LayerColor;
OutLineColor:=  LayA[ILoad].OutLineColor;
PolygonAntialiased:=  LayA[ILoad].PolygonAntialiased;
PolyFilled  :=   LayA[CurrentLayer].PolyFilled;
LineAlphaPosition:=  LayA[ILoad].LineAlphaPosition;
FillAlphaPosition:=  LayA[ILoad].FillAlphaPosition;
UseOutlinePoly:=  LayA[ILoad].UseOutlinePoly;
LineSize:=  LayA[ILoad].LineSize;
CanvasLineSize:=  LayA[ILoad].CanvasLineSize;
PointSize:=  LayA[ILoad].PointSize;
CurrentPointType:=  LayA[ILoad].CurrentPointType;
OtsNameEditText:=  LayA[ILoad].OtsNameEditText;
StippleColorCount:=  LayA[ILoad].StippleColorCount;
UseStippleStep:=  LayA[ILoad].UseStippleStep;{ :Boolean;}
StippleStep:=  LayA[ILoad].StippleStep;{  :Single;}
    SetLength(StippleColorArray,StippleColorCount);
    For IStipple := 0 to StippleColorCount-1 do
    begin
    StippleColorArray[IStipple]:=
      LayA[ILoad].StippleColorArray[IStipple];
            {:array of TColor;}
    end;
    WhatsMyLine:=inttostr(LayerColor);{:TColor;}
    Writeln(ShapeFileInT, WhatsMyLine);
    WhatsMyLine:=inttostr(OutLineColor);{:TColor;}
    Writeln(ShapeFileInT, WhatsMyLine);
    {Boolean}
    If UseOutlinePoly=True then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(ShapeFileInT, WhatsMyLine);
    If PolygonAntialiased=True then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(ShapeFileInT, WhatsMyLine);
    If PolyFilled=True then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(ShapeFileInT, WhatsMyLine);

    WhatsMyLine:=inttostr(PointSize);
    Writeln(ShapeFileInT, WhatsMyLine);
    WhatsMyLine:=inttostr(CurrentPointType);
    Writeln(ShapeFileInT, WhatsMyLine);

    WhatsMyLine:=inttostr(FillAlphaPosition);
    Writeln(ShapeFileInT, WhatsMyLine);

    WhatsMyLine:=inttostr(LineAlphaPosition);{:Integer;}
    Writeln(ShapeFileInT, WhatsMyLine);

    WhatsMyLine:=floattostr(LineSize);{:Double;}
    Writeln(ShapeFileInT, WhatsMyLine);
    WhatsMyLine:=inttostr(CanvasLineSize);
    Writeln(ShapeFileInT, WhatsMyLine);

    Writeln(ShapeFileInT, OtsNameEditText);{:String;}

    WhatsMyLine:=inttostr(StippleColorCount);
    Writeln(ShapeFileInT, WhatsMyLine);

    If UseStippleStep=True then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(ShapeFileInT, WhatsMyLine);

    WhatsMyLine:=floattostr(StippleStep);{:Double;}
    Writeln(ShapeFileInT, WhatsMyLine);

    SetLength(StippleColorArray,StippleColorCount);
    For IStipple := 0 to StippleColorCount-1 do
    begin
    WhatsMyLine:=inttostr(StippleColorArray[IStipple]);{:TColor;}
    Writeln(ShapeFileInT, WhatsMyLine);
    end;
      end;
  Finally
    CloseFile(ShapeFileInT);
  End;
End;



procedure TDTMform.ACOpenExecute(Sender: TObject);
begin
  OpenDialog.Filter:= 'HTF File (*.htf)|*.htf';
  {HTF File (*.htf)|*.htf|All Files (*.*)|*.*|dtp Files (*.dtp)|*.dtp}
  OpenDialog.FileName:= '*.htf';
  OpenDialog.InitialDir:=HTFPath;
  if OpenDialog.Execute then
  If (Lowercase(ExtractFileExt(OpenDialog.FileName))= '.htf') then
  begin
    HTFPath:=ExtractFilePath(OpenDialog.FileName);
    isRunningOnDtp:=False;{not loaded from a .dtp}
    DoLoad(OpenDialog.FileName);
  end;
end;

procedure TDTMform.DoLoad(AFilename:String);
Begin
  If FileExists(AFilename) then
  if UpperCase(ExtractFileExt(AFilename)) = '.HTF' then
  begin
    {New Htf... new all}
    HTFPath:=ExtractFilePath(AFilename);
    curX:=0;
    curY:=0;
    isHTFLoaded:=False;
    DShiftOffsetX:=0;
    DShiftOffsetY:=0;
    MinimumElevation:=0;
    MaximumElevation:=0;
    LayersLoaded:=0;
    SetLength(ManMatrix,10,10);
    SetLength(LayA,0);
    SetLength(LayersControlArray,0);
    SetLength(ShapesFoundArray,0);
    Application.ProcessMessages;
    HTFName := ExtractFileName(AFilename);
    OpenShape1.Enabled:=True;
    OpenBackImage1.Enabled:=True;
    Imagemaker1.Enabled:=True;
    MRUFileList.AddItem(AFilename);
    htf.Free;
    htf:=THeightTileFile.Create(AFilename);
    Caption:='Digital Terrain Mapping : '+ExtractFileName(AFilename);
    If FileExists(ChangeFileExt(AFilename,'.vrp')) then
    Begin  {Pretend is Full Globe Geo Projection for now}
      HtfForm.ReadAnyVersionProj(ChangeFileExt(AFilename,'.vrp'));
      TMaxOffsetX:=( (abs(MapProjRec.TopRightXEditText-MapProjRec.TopLeftXEditText) /htf.SizeX));
      TMaxOffsetY:=( (abs(MapProjRec.BottomLeftYEditText-MapProjRec.TopLeftYEditText) /htf.SizeY));
      TMaxOffX:= htf.SizeX;
      TMaxOffY:= htf.SizeY;
    end else
    Begin  {Guess full world htf}
      TMaxOffsetX:=( (360 /htf.SizeX));
      TMaxOffsetY:=( (180 /htf.SizeY));
      TMaxOffX:= htf.SizeX;
      TMaxOffY:= htf.SizeY;
    end;
    ScreenHeight:=Image321.Height;
    ScreenWidth:=Image321.Width;
    isHTFLoaded:=True;
    PrepareBitmap;
  end;
End;
{==============================================================}
{==============================================================}
procedure TDTMform.PrepareBitmap;
var
  i, sex, tx, ty : Integer;
  scanLine : PColor32Array;
  tileInfo : PHeightTileInfo;
  dataRow : PSmallIntArray;
  tile : PHeightTile;
  start, lap, stop, htfTime, drawTime, freq : Int64;
  tileList : TList;
begin
  If ((ElevationTint1.Checked)and(LOSint=0)) then
  begin
    {Image321.Bitmap.BeginUpdate;}
    sex:=Image321.Width;
    Image321.Bitmap.Clear(Color32(MapBacksColor));
    if not Assigned(htf) then Exit;
      {Figure out the Image Size and Registration:
      StretchDraw X,Y, Width, Height}
    If bBackClipBitmapLoaded then
      Image321.Bitmap.Draw(0,0, BackClipBitmap);
    drawTime:=0;
    tileList:=TList.Create;
    try
      QueryPerformanceCounter(start);
      htf.TilesInRect(curX, curY, curX+sex-1,
                      curY+Image321.Bitmap.Height-1, tileList);
      QueryPerformanceCounter(stop);
      htfTime:=stop-start;

      for i:=0 to tileList.Count-1 do
      begin
        tileInfo:=PHeightTileInfo(tileList[i]);
        QueryPerformanceCounter(start);
        tile:=htf.GetTile(tileInfo.left, tileInfo.top);
        QueryPerformanceCounter(lap);
        bmpTile.Width:=tileinfo.width;
        bmpTile.Height:=tileInfo.height;
        for ty:=0 to tileInfo.height-1 do
        begin
          scanLine:=bmpTile.ScanLine[ty];
          dataRow:=@tile.data[ty*tileInfo.width];
          for tx:=0 to tileInfo.width-1 do
             scanLine[tx]:=heightColor[dataRow[tx]];
        end;

        Image321.Bitmap.Draw(tileInfo.left-curX, tileInfo.top-curY, bmpTile);

        QueryPerformanceCounter(stop);
        htfTime:=htfTime+lap-start;
        drawTime:=drawTime+stop-lap;
      end;

      {Tile Grid Lines}
      if TBGrid.Down then
      begin
        for i:=0 to tileList.Count-1 do with PHeightTileInfo(tileList[i])^ do
        begin
          Image321.Bitmap.FrameRectS(
          left-curX,
          top-curY,
          left+width-curX+1,
          top+height-curY+1,
          Color32(MapGridsColor));
        end;
      end;
      {LatLong Grid Lines}
      if TLLGrid.Down then
      begin

      end;

      if LayersLoaded>0 then
      begin
        TMinOffX:= curX;
        TMinOffY:= curY;
        DVDORedraw;
      End;
    finally
      tileList.Free;
    end;

    QueryPerformanceFrequency(freq);
    LAMap.Caption:=Format(' %d x %d - %.1f ms HTF - %.1fms Draw ',
                         [htf.SizeX, htf.SizeY,
                          1000*htfTime/freq,
                          1000*drawTime/freq]);
{  Image321.Bitmap.EndUpdate;
  Image321.Bitmap.Changed;
  Image321.Refresh; // force repaint}
  end else If (LOSint=2) then PrepareTileBitmap
  else  PrepareBigBitmap;
end;


procedure TDTMform.PrepareBigBitmap;
var
  sex,sey, i, itl, tx, ty : Integer;
  scanLine : PColor32Array;
  tileInfo : PHeightTileInfo;
  dataRow : PSmallIntArray;
  tile : PHeightTile;
  Correction:SmallInt;
  start, lap, stop, htfTime, drawTime, freq : Int64;
  tileList : TList;
  TinyBmp,TiledBmp:TBitmap;
  MyRect:TRect;
  aManMatrix: array of array of Smallint;
Begin
  Screen.Cursor := crHourGlass;
  sex:=Image321.Bitmap.Width;
  sey:=Image321.Bitmap.Height;
  Image321.Bitmap.Clear(Color32(MapBacksColor));
  if not Assigned(htf) then Exit;
  drawTime:=0;
  tileList:=TList.Create;
  try
    QueryPerformanceCounter(start);
    htf.TilesInRect(curX, curY, curX+sex-1,
                      curY+Image321.Bitmap.Height-1, tileList);
    QueryPerformanceCounter(stop);
    htfTime:=stop-start;
    {Get data}
    {Setlength(MiniMatrix,sex ,Image321.Bitmap.Height );}
    Setlength(ManMatrix,sex ,Image321.Bitmap.Height );
    TinyBmp:=Tbitmap.Create;
    TiledBmp:=Tbitmap.Create;
    If LOSint=3 then {Prepare for 3D}
    begin
      FileSizeX:=Image321.Bitmap.width;
      FileSizeY:=Image321.Bitmap.height;
      NullDemValue :=MinimumElevation;
      CellSizeX :=Image321.Bitmap.width;
      CellSizeY :=Image321.Bitmap.height;
      {TinyBmp:=Tbitmap.Create; }
      TinyBmp.width:=(Image321.Bitmap.width);
      TinyBmp.height:=(Image321.Bitmap.height);
      TinyBmp.PixelFormat := pf32bit;
      {TiledBmp:=Tbitmap.Create;}
      TiledBmp.width:=(Image321.Bitmap.width*2);
      TiledBmp.height:=(Image321.Bitmap.height*2);
      TiledBmp.PixelFormat := pf32bit;
    End;
    bmpTile.Width:=Image321.Bitmap.width;
    bmpTile.Height:=Image321.Bitmap.height;
      {Part 1}
    MinimumElevation:=32767;
    MaximumElevation:= -32768;
    for itl:=0 to tileList.Count-1 do
    begin
      tileInfo:=PHeightTileInfo(tileList[itl]);
      QueryPerformanceCounter(start);
      tile:=htf.GetTile(tileInfo.left, tileInfo.top);
      QueryPerformanceCounter(lap);
          If MinimumElevation> tileInfo.min
             then MinimumElevation:=tileInfo.min;
          If MaximumElevation< tileInfo.max
             then MaximumElevation:=tileInfo.max;

      {Set Data into Matrix}
      {showmessage(Inttostr(tileInfo.left)
          +' - ' +Inttostr(curX)
          + ' '  +Inttostr(tileInfo.top)
          +' - ' +Inttostr(curY)    );}

      for ty:=0 to tileInfo.height-1 do
      begin
        dataRow:=@tile.data[ty*tileInfo.width];
        for tx:=0 to tileInfo.width-1 do
        begin
          If  ((((tileInfo.left+tx)-curX)>=0) and (((tileInfo.left+tx)-curX)<sex)
          and  (((tileInfo.top+ty)-curY)>=0) and (((tileInfo.top+ty)-curY)<Image321.Bitmap.height))
          then
          begin
            {Copy for ManMatrix too + Zeroizer}
            ManMatrix[(tileInfo.left+tx)-curX,
               ((tileInfo.top+ty)-curY)]:=dataRow[tx]{+MinimumElevation};
          end;
        end;
      end;
    end;

    {Set blank into bitmap corners}
    for ty:=0 to sey-1 do
    begin
      scanLine:=bmpTile.ScanLine[ty];
      If ((ty=0) or (ty=sey-1)) then
      begin
        for tx:=0 to sex-1 do
          scanLine[tx]:=Color32(MapBacksColor){heightColor[dataRow[tx]]}
      end else
      begin
        scanLine[0]:=Color32(MapBacksColor);{heightColor[dataRow[0]];}
        scanLine[sex-1]:=Color32(MapBacksColor);{heightColor[dataRow[tileInfo.width-1]];}
      end;
    end;


    IF ElevationTint1.Checked then
    begin
      for ty:=0 to sey-1 do
      begin
        scanLine:=bmpTile.ScanLine[ty];
        for tx:=0 to sex-1 do
            scanLine[tx]:=heightColor[ManMatrix[tx,ty]];
      end;
    end else

    If ({(ElevationTint1.Checked) or}
    (SlopeTint1.Checked) or
    (SlopeDirectional1.Checked) or
    (SlopeSetDirection1.Checked)) then PrepTints(sex,sey)
    Else
    If ((ContourLines1.Checked)or
       (ContourLinesAll1.Checked)) then PrepContour1(sex,sey)
    Else
    If ContourLines21.Checked then PrepContour2(sex,sey)
    Else If LOSMaskedArea1.Checked then PrepLOS(sex,sey)
    Else If Ecotype1.Checked then PrepEcoType(sex,sey);

{Draw upside down here ? or switch Manmatrix twice?}
{CopyRect(Dest: TRect; Canvas: TCanvas; Source: TRect);}
{procedure Draw(const DstRect, SrcRect: TRect; Src: TBitmap32); overload;}
    Image321.Bitmap.Draw(0,0,bmpTile);
    QueryPerformanceCounter(stop);
    htfTime:=htfTime+lap-start;
    drawTime:=drawTime+stop-lap;
    {Tile Grid Lines}
    if TBGrid.Down then
    begin
      for i:=0 to tileList.Count-1 do with PHeightTileInfo(tileList[i])^ do
      begin
        Image321.Bitmap.FrameRectS(
          left-curX,
          top-curY,
          left+width-curX+1,
          top+height-curY+1,
          Color32(MapGridsColor));
      end;
    end;
    {LatLong Grid Lines}
    if TLLGrid.Down then
    begin

    end;

    if LayersLoaded>0 then
    begin
      TMinOffX:= curX;
      TMinOffY:= curY;
      DVDORedraw;
    End;
    {Copy bitmap to Texture}
    If  LOSint=3 then
    begin
      LOSint:=0;{keep from repeating Pete fell off who was left}

      Setlength(aManMatrix,sex ,sey );
      If MinimumElevation <0 then
         Correction:=abs(MinimumElevation)+1 else
         Correction:=1-MinimumElevation;
      MinimumElevation:=MinimumElevation+Correction;
      MaximumElevation:=MaximumElevation+Correction;
      for ty:=0 to sey-1 do
        for tx:=0 to sex-1 do
         ManMatrix[tx,ty]:=ManMatrix[tx,ty]+Correction;
      for ty:=0 to sey-1 do  {Reverse top side down}
        for tx:=0 to sex-1 do
         aManMatrix[tx,(sey-ty)-1]:=ManMatrix[tx,ty];
      for ty:=0 to sey-1 do
        for tx:=0 to sex-1 do
         ManMatrix[tx,ty]:=aManMatrix[tx,ty];
      MyRect.Left:=0;
      MyRect.Top:=0;
      MyRect.Right:=TiledBmp.width-1;
      MyRect.Bottom:=TiledBmp.height-1;
      bmpTile.Draw(0,0, Image321.Bitmap); {to get the shape image too}
      TinyBmp.Assign(bmpTile);
      TiledBmp.Canvas.stretchdraw(MyRect,TinyBmp);
      Application.ProcessMessages;
{      dtmGlHeightForm.Image2.picture.Bitmap.PixelFormat := pf32bit;
      dtmGlHeightForm.Image2.picture.Assign(TiledBmp);}
{      dtmGlHeightForm.Heightfield1.Material.Texture.Image.picture.Bitmap.PixelFormat := pf32bit;}
{      dtmGlHeightForm.Image2.picture.Assign(Image321.Bitmap);}
{      dtmGlHeightForm.Heightfield1.Material.Texture.Image.assign(dtmGlHeightForm.Image2.picture.Graphic);}
      dtmGlHeightForm.Heightfield1.Material.Texture.Image.assign(TiledBmp);
      dtmGlHeightForm.show;
      Application.ProcessMessages;
      dtmGlHeightForm.FormShowDown;
    End;
  finally
    tileList.Free;
  end;
  {Setlength(MiniMatrix,0,0);}
  TiledBmp.Free;
  TinyBmp.Free;
  {SetLength(PredA, 0);}
  Screen.Cursor := crDefault;
  QueryPerformanceFrequency(freq);
  LAMap.Caption:=Format(' %d x %d - %.1f ms HTF - %.1fms Draw ',
                         [htf.SizeX, htf.SizeY,
                          1000*htfTime/freq,
                          1000*drawTime/freq]);
End;


procedure TDTMform.PrepareTileBitmap;
var
   sex,sey,mxx,myy,tx, ty : Integer;
   Correction:SmallInt;
   tileInfo : PHeightTileInfo;
   dataRow : PSmallIntArray;
   scanLine : PColor32Array;
   tile : PHeightTile;
   TinyBmp,TiledBmp:TBitmap;
   MyRect:TRect;
Begin
  LOSint:=0;{{GL form}
  if Assigned(htf) then
  begin
    mxx:=mx+curX;
    myy:=my+curY;
    tileInfo:=htf.XYTileInfo(mxx, myy);
    if Assigned(tileInfo) then
    begin
      tile:=htf.GetTile(tileInfo.left, tileInfo.top);
      FileSizeX:=tileinfo.width;
      FileSizeY:=tileInfo.height;
      sex:=tileInfo.Width;
      sey:=tileInfo.Height;
      SetLength(ManMatrix,tileInfo.width,tileInfo.height);
      If tileInfo.min <0 then
         Correction:=abs(tileInfo.min)+1 else
         Correction:=1-tileInfo.min;
      MinimumElevation:=tileInfo.min+Correction;
      MaximumElevation:=tileInfo.max+Correction;
      NullDemValue :=MinimumElevation;
      CellSizeX :=tileinfo.width;
      CellSizeY :=tileInfo.height;
      FileSizeX:=tileinfo.width;
      FileSizeY:=tileInfo.height;
      TinyBmp:=Tbitmap.Create;
      TinyBmp.width:=(tileinfo.width);
      TinyBmp.height:=(tileInfo.height);
      TinyBmp.PixelFormat := pf32bit;
      TiledBmp:=Tbitmap.Create;
      TiledBmp.width:=(tileinfo.width*2);
      TiledBmp.height:=(tileInfo.height*2);
      TiledBmp.PixelFormat := pf32bit;
      for ty:=0 to tileInfo.height-1 do
      begin
        {If ElevationTint1.Checked then}
        scanLine:=bmpTile.ScanLine[ty];
        dataRow:=@tile.data[ty*tileInfo.width];
        for tx:=0 to tileInfo.width-1 do
        begin
          ManMatrix[tx,(tileInfo.height-ty)-1]:=dataRow[tx]+Correction;
          If ElevationTint1.Checked then
          scanLine[tx]:=heightColor[dataRow[tx]];
        end;
      end;
      If ({(ElevationTint1.Checked) or}
         (SlopeTint1.Checked) or
         (SlopeDirectional1.Checked) or
         (SlopeSetDirection1.Checked)) then PrepTints(sex,sey)
      Else
      If ((ContourLines1.Checked)or
          (ContourLinesAll1.Checked)) then PrepContour1(sex,sey)
      Else
      If ContourLines21.Checked then PrepContour2(sex,sey)
      Else If LOSMaskedArea1.Checked then PrepLOS(sex,sey)
      Else If Ecotype1.Checked then PrepEcoType(sex,sey);;

      MyRect.Left:=0;
      MyRect.Top:=0;
      MyRect.Right:=TiledBmp.width-1;
      MyRect.Bottom:=TiledBmp.height-1;
      TinyBmp.Assign(bmpTile);
      TiledBmp.Canvas.stretchdraw(MyRect,TinyBmp);
      {TiledBmp.SaveToFile('testy.bmp');}
(*      Case Switch of
      0:  {Ctrl}
      Begin*)
        dtmGlForm.Image2.picture.Bitmap.PixelFormat := pf32bit;
        dtmGlForm.Image2.picture.Assign(TiledBmp);
        dtmGlForm.Heightfield1.Material.Texture.Image.assign(dtmGlForm.Image2.picture.Graphic);
        dtmGlForm.show;
        dtmGlForm.FormShowDown;
(*      end;
      1:{Shift}
      Begin
        dtmGlHeightForm.Image2.picture.Assign(TiledBmp);
        dtmGlHeightForm.Heightfield1.Material.Texture.Image.assign(dtmGlHeightForm.Image2.picture.Graphic);
        dtmGlHeightForm.FormShowDown;
        dtmGlHeightForm.show;
      end;
      end;*)
      TiledBmp.Free;
      TinyBmp.Free;
    end;
  end;
End;


procedure TDTMform.PrepTints(Xwin,Yhin:Integer);
var
  C1, C2, C3, C4, C5, C6, C7,C8,
  Elevated,Cx,Cy, Elevator, sex, sey,tx, ty : Integer;
  scanLine : PColor32Array;
Begin
  sex:=Xwin;
  sey:=Yhin;
  IF ((SlopeTint1.Checked)
             or (SlopeDirectional1.Checked)
             or (SlopeSetDirection1.Checked))then
  begin
          {Set Data into Matrix}
{          Setlength(MiniMatrix,tileinfo.width ,tileInfo.height );}
(*          for ty:=0 to tileInfo.height-1 do
          begin
            dataRow:=@tile.data[ty*tileInfo.width];
            for tx:=0 to tileInfo.width-1 do
                MiniMatrix[tx,ty]:=dataRow[tx];
            scanLine:=bmpTile.ScanLine[ty];
            If ((ty=0) or (ty=tileInfo.height-1)) then
            begin
              If UseContourColors then
                 for tx:=0 to tileInfo.width-1 do
                 scanLine[tx]:=Color32(MapBacksColor){heightColor[dataRow[tx]]}
              else
                 for tx:=0 to tileInfo.width-1 do
                 scanLine[tx]:=Color32(MapBacksColor);
            end else
            begin
              If UseContourColors then
              begin
                scanLine[0]:=Color32(MapBacksColor);{heightColor[dataRow[0]];}
                scanLine[tileInfo.width-1]:=Color32(MapBacksColor);{heightColor[dataRow[tileInfo.width-1]];}
              end else
              begin
                scanLine[0]:=Color32(MapBacksColor);
                scanLine[tileInfo.width-1]:=Color32(MapBacksColor);
              end;
            end;
          end;
*)
          for ty:=1 to sey-2 do
          begin
            scanLine:=bmpTile.ScanLine[ty];
            for tx:=1 to sex-2 do
            begin
              scanLine[tx]:=Color32(MapBacksColor);
              Elevator:= ManMatrix[tx,ty];
              DataItem[9]:=Elevator;
              IF (SlopeTint1.Checked)then
              begin           {North Only}
              for CY := -1 to -1{0} do
              begin
                for CX := -1 to 1 do
                begin
                  Elevated := ManMatrix[tx + CX, ty + CY];
                  if (Elevator < Elevated )
                  then scanLine[tx]:=Color32(RGB(255, 0,0)){Red 255,0,0}
                  else scanLine[tx]:=heightColor[ManMatrix[tx,ty]];
                end;
              end;
            end else
            begin
              C1:= ManMatrix[tx -1, ty + 1];DataItem[1]:=C1;
              C2:= ManMatrix[tx , ty + 1];  DataItem[2]:=C2;
              C3:= ManMatrix[tx +1, ty + 1];DataItem[3]:=C3;
              C4:= ManMatrix[tx -1, ty + 0];DataItem[4]:=C4;
              C5:= ManMatrix[tx +1, ty + 0];DataItem[5]:=C5;
              C6:= ManMatrix[tx -1, ty - 1];DataItem[6]:=C6;
              C7:= ManMatrix[tx , ty - 1];  DataItem[7]:=C7;
              C8:= ManMatrix[tx +1, ty - 1];DataItem[8]:=C8;
              {Sort em        Elevated:=High(List1);}
              SortItQuick(9, DataItem);
              Elevated:=Round(DataItem[9]);{Highest}
              If ((SlopeSetDirection1.Checked)) then
              begin
                Case SlopeDirection of
                  0:if (Elevated= C1 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  1:if (Elevated= C2 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  2:if (Elevated= C3 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  3:if (Elevated= C4 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  4:if (Elevated= Elevator )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  5:if (Elevated= C5 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  6:if (Elevated= C6 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  7:if (Elevated= C7 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                  8:if (Elevated= C8 )then scanLine[tx]:=Color32(RGB(255, 0,0));
                end;
              end else
              begin  {SlopeDirectional1}
                 {  showmessage(Inttostr(Elevated)+'  '+Inttostr(Round(DataItem[1])));}
{Blue 0,0,255 } if (Elevated= C1 )then scanLine[tx]:=Color32(RGB(0, 0,255))
{Aqua 0,255,255}else if (Elevated= C2 )then scanLine[tx]:=Color32(RGB(0, 255,255))
 {Green 0,255,0}else if (Elevated= C3 )then scanLine[tx]:=Color32(RGB(0, 255,0))
{Yellow 255,255,0}else if (Elevated= C4 )then scanLine[tx]:=Color32(RGB(255, 255,0))
{YeOrqange? 255,155,0}else if (Elevated= C5 )then scanLine[tx]:=Color32(RGB(255, 155,0))

{Red 255,0,0}   else if (Elevated= C6 )then scanLine[tx]:=Color32(RGB(255, 0,0))
{Purple 255,0,255}else if (Elevated= C7 )then scanLine[tx]:=Color32(RGB(255, 0,255))
{Smaug 255,0,155}else if (Elevated= C8 )then scanLine[tx]:=Color32(RGB(255, 0,155));
              end;
            end;
          end;
        end;
      end
End;
{************ Begin of SortItQuick ***************************************}
procedure TDTMform.SortItQuick(Count: Integer; var Item: ScoreList);
  { Making the Array a variable means less copying and space is saved }
{*************************************************************************
*         A recursive procedure made of 2 other procedures.
*         The SortItQuick is a mask to pass the variable to PartialSort
*         which does most of the work.  When a number is found to be sorted
*         the procedure Switch exchanges the 2 numbers.
*************************************************************************}
{********* Recursive procedure inside SortItQuick ************************}
  procedure PartialSort(left, right: Integer; var InArray:ScoreList);
{**************************************************************************
*         This procedure is documented along with the Source code in
*         an effort to effectively allow the understanding of the algorithm.
***************************************************************************}
  var
    k: Real; { used in PartialSort to determine the middle
                               of the array and use it to compare with
                               elements in the array as they are processed }
    i,j:Integer;
{********* Recursive procedure inside SortItQuick *************************}
    procedure Switch(var A, B: Real);
                      { Variable so it will return the numbers as switched }
    var
      C: Real; { The A,B,C Reals are switched around using C as }
    begin { temporary storage passage space.               }
      if A <> B then
      begin
        C := A;
        A := B;
        B := C;
      end;
    end;
{************ End of Switch ***********************************************}
{************ Begin of PartialSort ****************************************}
  begin
    k := (InArray[left] + InArray[right]) / 2;
       { Find the middle of Array to start from }
    i := left;
      { Duplicated to be able to keep the ends while changing }
    j := right;
      { the number that is being referenced in the array      }

    repeat
      while InArray[i] < k do
        { 1 of 2 : Change > to < for Ascending sort   }
        Inc(i);
          { Inc and Dec Increase or Decrease the variable by 1    }

      while k < InArray[j] do
        { 2 of 2 : Change > to < for Ascending sort   }
        Dec(j); { if it is Dec(i,n) the n can be up to a Longint }

      if i <= j then
        { if the left is less than the right then switch the    }
      begin { Numbers in the array                                  }
        Switch(InArray[i], InArray[j]);
        Inc(i);
        Dec(j);
      end;
    until i > j;

    if left < j then
      { Check to see if the original left has been passed   }
      PartialSort(left, j, InArray); { by the working right }
    if i < right then
      PartialSort(i, right, InArray);
  end;
{************ End of PartialSort ******************************************}
{************ Begin of SortItQuick ****************************************}
begin { Actual start of SortItQuick procedure }
  PartialSort(1, Count, Item);
    { Pass the parameters to PartialSort    }
end;
{************ End of SortItQuick ******************************************}


procedure TDTMform.PrepContour1(Xwin,Yhin:Integer);
var
  MiniMe,Mini,Counts, Countless, Elevated,Cx,Cy,
  Elevator, sex,sey, tx, ty : Integer;
  scanLine : PColor32Array;
Begin
  sey:=Yhin;
  sex:=Xwin;
  IF ((ContourLines1.Checked)or(ContourLinesAll1.Checked)) then
  begin
    Counts := ((MaximumElevation - MinimumElevation) div Contours);
    MiniMe:=Contours;
    While MinimumElevation > MiniMe do MiniMe:=MiniMe+MiniMe;
    for ty:=1 to sey-2 do
    begin
      scanLine:=bmpTile.ScanLine[ty];
      for tx:=1 to sex-2 do
      begin
        If ((ManMatrix[tx,ty] mod Contours)=0)then
        begin
          If UseContourColors then
            scanLine[tx]:= heightColor[ManMatrix[tx,ty]]{MapBordersColor}
            else scanLine[tx]:= Color32(MapBordersColor);
        end
        else
        begin
          scanLine[tx]:=Color32(MapBacksColor);
          Mini:=MiniMe- Contours;
          Elevator:= ManMatrix[tx,ty];
          Countless:= 0;
          Repeat
          begin
            inc(Countless);
            Mini:=Mini+ Contours;
            for CY := -1 to 1 do
            begin
              for CX := -1 to 1 do
              begin
                Elevated := ManMatrix[tx + CX, ty + CY];
                if (((Elevator) = Mini) or
                   ((Elevator < Mini) and (Elevated > Mini))
                   or ((Elevator > Mini) and (Elevated < Mini)))
                then
                begin
                  If UseContourColors then
                     scanLine[tx]:= heightColor[ManMatrix[tx,ty]]
                  else scanLine[tx]:= Color32(MapBordersColor);
                  Countless:= Counts;
                end;
              end;
            end;
          end;
          until Countless= Counts;
        end;
      end;
    end;
  end;
End;




procedure TDTMform.PrepContour2(Xwin,Yhin:Integer);
var
  ContourInterval,Range,
  C1, C2, C3, C4, C5, C6, C7,
  sex,sey,Elevator, Elevated, Cx,Cy, tx, ty : Integer;
  scanLine : PColor32Array;
Begin
  sey:=Yhin;
  sex:=Xwin;
  {Check Matrix Contours}
  Range:=(MaximumElevation-MinimumElevation);
  ContourInterval:=(Range div 7);
  C1 := (MinimumElevation + ContourInterval);
  C2 := (MinimumElevation + (ContourInterval * 2));
  C3 := (MinimumElevation + (ContourInterval * 3));
  C4 := (MinimumElevation + (ContourInterval * 4));
  C5 := (MinimumElevation + (ContourInterval * 5));
  C6 := (MinimumElevation + (ContourInterval * 6));
  C7 := (MinimumElevation + (ContourInterval * 7));

  for ty:=1 to sey-2 do
  begin
    scanLine:=bmpTile.ScanLine[ty];
    for tx:=1 to sex-2 do
    begin
      scanLine[tx]:=Color32(MapBacksColor);
      Elevator:= ManMatrix[tx,ty];
      if (Elevator = MaximumElevation) then
        scanLine[tx]:= Color32(clWhite)
        else
          if ((Elevator >= MinimumElevation)
            and (Elevator <= C1)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX := -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C1) or
               ((Elevator < C1) and (Elevated > C1))
            or ((Elevator > C1) and (Elevated < C1)))
            then begin
              scanLine[tx]:=Color32(RGB(0, 0,255));
            end;
          end;
        end;
      end else
      if ((Elevator >= C1) and (Elevator <= C2)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX:= -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C2) or
               ((Elevator < C2) and (Elevated > C2))
            or ((Elevator > C2) and (Elevated < C2)))
            then begin
              scanLine[tx]:=Color32(RGB(0, 255,255));
            end;
          end;
        end;
      end else
      if ((Elevator >= C2) and (Elevator <= C3)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX:= -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C3) or
               ((Elevator < C3) and (Elevated > C3))
            or ((Elevator > C3) and (Elevated < C3)))
            then begin
              scanLine[tx]:=Color32(RGB(0, 255,0));
            end;
          end;
        end;
      end else
      if ((Elevator >= C3) and (Elevator <= C4)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX := -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C4) or
               ((Elevator < C4) and (Elevated > C4))
            or ((Elevator > C4) and (Elevated < C4)))
            then begin
              scanLine[tx]:=Color32(RGB(255, 255,0));
            end;
          end;
        end;
      end else
      if ((Elevator >= C4) and (Elevator <= C5)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX := -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C5) or
               ((Elevator < C5) and (Elevated > C5))
            or ((Elevator > C5) and (Elevated < C5)))
            then begin
              scanLine[tx]:=Color32(RGB(255, 0,0));
            end;
          end;
        end;
      end else
      if ((Elevator >= C5) and (Elevator <= C6)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX := -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C6) or
               ((Elevator < C6) and (Elevated > C6))
            or ((Elevator > C6) and (Elevated < C6)))
            then begin
              scanLine[tx]:=Color32(RGB(255,0,255));
            end;
          end;
        end;
      end else
      if ((Elevator >= C6) and (Elevator <= C7)) then
      begin
        scanLine[tx]:=Color32(MapBacksColor);
        for CY := -1 to 1 do begin
          for CX := -1 to 1 do begin
            Elevated := ManMatrix[tx + CX, ty + CY];
            if ((Elevator = C7) or
               ((Elevator < C7) and (Elevated > C7))
            or ((Elevator > C7) and (Elevated < C7)))
            then begin
              scanLine[tx]:=Color32(RGB(255,255,255));
            end;
          end;
        end;
      end;
    end;
  end;{END of the TINTS}
End;

procedure TDTMform.PrepLOS(Xwin,Yhin:Integer);
var
  fraction, xd, yd: DOUBLE;
  i, j: DWord;
  Circle,RoundAbout,Blinder, k,PixelDistance,
  sex,sey, tx2, ty2, tx, ty : Integer;
  scanLine : PColor32Array;
  Keeper:Shortint;
  MiniMatrix:Array of array of Boolean;
function Distance(const x1,x2, y1,y2: Integer): DOUBLE;
begin
  RESULT := SQRT(SQR(x1 - x2) + SQR(y1 - y2))
end {Distance};
begin
  sex:=Xwin;
  sey:=Yhin;
  Setlength(MiniMatrix ,sex ,sey );
  {Compute LOS}
  Circle:= (2*sex)+(2*(sey-2))-1;
  For RoundAbout:=0 to Circle do
  begin
    If ((RoundAbout<sex)) then
    begin {Top}
      ty2:=0; tx2:=RoundAbout;
    end else
    If ((RoundAbout<(2*sex)-1)) then
    begin {Bottom}
      ty2:=sey-1; tx2:=RoundAbout-sex
    end else
    If ((RoundAbout<((2*sex)+sey-1))) then
    begin {Left side}
       ty2:=RoundAbout-(2*sex); tx2:=0;
    end else
    begin  {Right side}
      ty2:=RoundAbout-((2*sex)+sey); tx2:=sex-1;
    end;
    PixelDistance := TRUNC(Distance(mx,tx2,my,ty2)+ 0.5);
    Keeper:=ManMatrix[mx,my];
    Blinder :=0;
    for k := 1 to PixelDistance-1 do
    begin
      fraction := k / PixelDistance;
        // Add 0.5 to endpoints so "line" is from center of pixel
      xd := (1.0 - fraction) * (mx + 0.5) +fraction * (tX2 + 0.5);
      yd := (1.0 - fraction) * (mY + 0.5) +fraction * (tY2 + 0.5);
      i := TRUNC(xd);
      j := TRUNC(yd);
        {Figure out the LOS}
        {First valley}
      If ((Keeper > ManMatrix[i,j])and (Keeper >Blinder))then MiniMatrix[i,j]:=False
        else {first upslope}
      If ((Keeper < ManMatrix[i,j])and (ManMatrix[i,j] >Blinder)) then
      begin
        Blinder :=ManMatrix[i,j];
        MiniMatrix[i,j]:=False;
      end else
      If ManMatrix[i,j]< Blinder then MiniMatrix[i,j]:=True;
    end;
  end;{Circle}
    {Paint LOS}
  for ty:=0 to sey -1 do
  begin
    scanLine:=bmpTile.ScanLine[ty];
    for tx:=0 to sex-1 do
    begin
      If MiniMatrix[tx,ty] then
         scanLine[tx]:=Color32(clred) else
      If (not MiniMatrix[tx,ty]) then
          scanLine[tx]:=heightColor[ManMatrix[tx,ty]];
    end;
  end;    {tile list}
  Setlength(MiniMatrix ,0 ,0 );
end;
{==============================================================}

{==============================================================}
{==============================================================}
procedure TDTMform.Image321MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer; Layer: TCustomLayer);
var
   tileIdx, n : Integer;
   tileInfo : PHeightTileInfo;
begin
  {if ((ssLeft in shift)and(ssAlt in shift))then
   begin
   end else }
  if Dragging then
  begin
    Image321.Bitmap.LineToS(X, Y);
    Image321.Invalidate;  // be sure to refresh the image
  end else
  if (ssLeft in shift){Shift<>[]} then    {??}
  begin
    curX:=curX-(x-mx);
    curY:=curY-(y-my);
    mx:=x;
    my:=y;
    PrepareBitmap;
{    Image321.Refresh;}
  end;
  if Assigned(htf) then
  begin
    x:=x+curX;
    y:=y+curY;
    StatusBar.Panels[0].Text:=' X: '+IntToStr(x);
    StatusBar.Panels[1].Text:=' Y: '+IntToStr(y);
    StatusBar.Panels[2].Text:=' H: '+IntToStr(htf.XYHeight(x, y));

    tileInfo:=htf.XYTileInfo(x, y);
    if Assigned(tileInfo) then
    begin
      tileIdx:=htf.IndexOfTile(tileInfo);
      StatusBar.Panels[3].Text:=' Tile: '+IntToStr(tileIdx);
      n:=htf.TileCompressedSize(tileIdx)+SizeOf(THeightTileInfo);
      StatusBar.Panels[4].Text:=Format(' %.2f kB (%.0f %%)',
                                          [n/1024, 100-100*n/(htf.TileSize*htf.TileSize*2)]);
      StatusBar.Panels[5].Text:=Format(' Tile average: %d, range: [%d; %d])',
                                          [tileInfo.average, tileInfo.min, tileInfo.max]);
    end else
    begin
      StatusBar.Panels[3].Text:=' Tile: N/A';
      StatusBar.Panels[4].Text:=' N/A';
      StatusBar.Panels[5].Text:=' N/A';
    end;
  end;{if htf}
end;


procedure TDTMform.Image321MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
var
  SaveFileName, BackupName: string;
begin
  if ((ssAlt in shift)) then
  begin
   {Save bitmap image}
   SaveFileName:=ImagePath+ChangeFileExt(HTFName,'.bmp');
    if FileExists(SaveFileName) then
    begin
      BackupName := ExtractFileName(SaveFileName);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(SaveFileName, BackupName) then
        raise Exception.Create('Unable to create backup file.');
    end;
   Image321.Bitmap.SaveToFile(SaveFileName);
  end
  else
  {If ... click then make it 3D}
  if ((ssCtrl in shift)and NoGLRunning) then
  begin    {If NoGLRunning then }
    mx:=X;
    my:=Y;
    NoGLRunning:=False;
    LOSint:=2;
    PrepareBitmap;   {Tile Size}
{    Image321.Refresh;}
  end
  else
  if ((ssShift in shift)and NoGLRunning) then
  begin
    mx:=X;
    my:=Y;
    NoGLRunning:=False;
    LOSint:=3;
    PrepareBitmap;   {Full Size}
{    Image321.Refresh;}
  end
  else
  {simple drawing on image for LOS area selection}
  If LOSint=1 then
  begin
    Dragging:=True;
    mx:=X;
    my:=Y;
    Image321.Bitmap.MoveTo(X, Y);
  end else
  begin
    Image321.Cursor:=crSizeAll;
    mx:=X;
    my:=Y;
  end;
end;

procedure TDTMform.Image321MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
begin
  Image321.Cursor:=crDefault;
  Dragging := False;
  If LOSint=1 then
  begin
    LOSint:=0;
    LineProfileForm.Show;
    LineProfileForm.UpdateImage(mx+curX,x+curX,my+curY,y+curY);
  end;
end;

procedure TDTMform.Image321Resize(Sender: TObject);
begin
   if Assigned(htf) then
   begin
     Image321.Bitmap.SetSize(DTMform.ClientWidth,
                            (DTMform.ClientHeight-47));
     ScreenHeight:=Image321.Height;
     ScreenWidth:=Image321.Width;
     if Assigned(htf) then PrepareBitmap;
   end;
end;
{  Image321.Height:=(DTMform.ClientHeight-47);
  Image321.Width:=DTMform.ClientWidth;
  ScreenHeight:=Image321.Height;
  ScreenWidth:=Image321.Width;}
{  if Assigned(htf) then PrepareBitmap;}
{==============================================================}


{==============================================================}
{gridlines,
 coordinate conversion,}
{Produce Elevation Tints,
Slope Tints,
Contours,
Line of Sight,
LOS Masked Areas, and
Perspective Views}
procedure TDTMform.TBGridClick(Sender: TObject);
begin
  If Grid1.Checked then TBGrid.Down:=False
     else TBGrid.Down:=True;
  Grid1.Checked := TBGrid.Down;
  PrepareBitmap;
end;
procedure TDTMform.LatLongGrid1Click(Sender: TObject);
begin
  If LatLongGrid1.Checked then TLLGrid.Down:=False
     else TLLGrid.Down:=True;
  LatLongGrid1.Checked := TLLGrid.Down;
  PrepareBitmap;
end;

procedure TDTMform.Redraw1Click(Sender: TObject);
begin
  PrepareBitmap;
end;

procedure TDTMform.AllBtnsUp;
Begin
  ElevationTint1.Checked:=False;
  SlopeTint1.Checked:=False;
  SlopeDirectional1.Checked:=False;
  SlopeSetDirection1.Checked:=False;
  SlopePercent1.Checked:=False;
  ContourLines1.Checked:=False;
  ContourLinesAll1.Checked:=False;
  ContourLines21.Checked:=False;
  LOSMaskedArea1.Checked:=False;
  Ecotype1.Checked:=False;
End;
procedure TDTMform.ElevationTint1Click(Sender: TObject);
begin
  AllBtnsUp;
  ElevationTint1.Checked:=True;
end;
procedure TDTMform.SlopeTint1Click(Sender: TObject);
begin
  AllBtnsUp;
  SlopeTint1.Checked:=True;
end;
procedure TDTMform.SlopeDirectional1Click(Sender: TObject);
begin
  AllBtnsUp;
  SlopeDirectional1.Checked:=True;
end;
procedure TDTMform.SlopeSetDirection1Click(Sender: TObject);
begin
  AllBtnsUp;
  SlopeSetDirection1.Checked:=True;
end;

procedure TDTMform.SlopePercent1Click(Sender: TObject);
begin
  AllBtnsUp;
  SlopePercent1.Checked:=True;
end;

procedure TDTMform.ContourLines1Click(Sender: TObject);
begin
  AllBtnsUp;
  ContourLines1.Checked:=True;
end;
procedure TDTMform.ContourLinesAll1Click(Sender: TObject);
begin
  AllBtnsUp;
  ContourLinesAll1.Checked:=True;
  MinimumElevation:=0;
  MaximumElevation:=0;
end;
procedure TDTMform.ContourLines21Click(Sender: TObject);
begin
  AllBtnsUp;
  ContourLines21.Checked:=True;
  MinimumElevation:=0;
  MaximumElevation:=0;
end;
procedure TDTMform.Ecotype1Click(Sender: TObject);
begin
  AllBtnsUp;
  Ecotype1.Checked:=True;
end;
{==============================================================}
procedure TDTMform.PrepEcoType(Xwin,Yhin:Integer);
var
  StepLevel, StepLevelCount, Step, Stepcount: Integer;
  TotRez,Rez:Double;
  RezEly,RezRely,RezSlope,RezSlopeDir:Double;

  HiEl,LoEl,
  MinRezEly,MinRezRely,MinRezSlope,
  TotRezEly,TotRezRely,TotRezSlope,
  REX, RexSq,RelativeElevation, SlopeDir,
  Slope2,CX2,CY2, Slope,CX,CY:Double;
  WidthX,HeightY, tx, ty : Integer;
  scanLine : PColor32Array;
  EcoMatrix: array of array of array of Double;
Begin
  HeightY:=Yhin-2;
  WidthX:=Xwin-2;
  MinRezEly:=0;MinRezRely:=0;MinRezSlope:=0;LoEl:=0;
  TotRezEly:=0;TotRezRely:=0;TotRezSlope:=0;HiEl:=0;
  {Precompute  Data into Matrix}
  Setlength(EcoMatrix,10 ,EcoLevelsProcessed+1, 4 );
  for Step:=0 to 9 do
  for StepLevel:=0 to EcoLevelsProcessed do
  begin
    EcoMatrix[Step,StepLevel,0]:=(EcoRecord[Step,StepLevel].ElevMax-EcoRecord[Step,StepLevel].ElevMin);
    EcoMatrix[Step,StepLevel,1]:=(EcoRecord[Step,StepLevel].REMax-EcoRecord[Step,StepLevel].REMin);
    EcoMatrix[Step,StepLevel,2]:=(EcoRecord[Step,StepLevel].SlopeMax-EcoRecord[Step,StepLevel].SlopeMin);
    EcoMatrix[Step,StepLevel,3]:=(EcoRecord[Step,StepLevel].SlopeDirMax-EcoRecord[Step,StepLevel].SlopeDirMin)
  end;

  for ty:=1 to HeightY do
  begin
    scanLine:=bmpTile.ScanLine[ty];
    for tx:=1 to WidthX do
    begin
      {EcoMatrix[tx,ty]:=ManMatrix[tx,ty];}
      CY := (ManMatrix[tx,ty+1] - ManMatrix[tx,ty-1])/2;
      CX := (ManMatrix[tx+1,ty] - ManMatrix[tx-1,ty])/2;
      Slope :=  {Sqrt}(CX+ CY);
      Slope2:=Slope / sqrt((Slope*Slope)+1);
      CX2:=CX*CX;
      CX2:=CX / sqrt((CX2)+1);
      CY2:=CY*CY;
      CY2:=CY / sqrt((CY2)+1);
      SlopeDir:=CX2+CY2;
      REX:=ManMatrix[tx,ty]-
      ((ManMatrix[tx+1,ty-1]+
       ManMatrix[tx+1,ty+1]+
       ManMatrix[tx-1,ty+1]+
       ManMatrix[tx-1,ty-1])  /4);
       RexSq:=REX / sqrt((REX*REX)+1);
       RelativeElevation:=  RexSq;

  TotRez:=0;
  Stepcount:=1;
  StepLevelCount:=0;
  for Step:=1 to 9 do
  for StepLevel:=0 to EcoLevelsProcessed do
  begin       {EcoRecord[ChangeColX,ChangeRowY]}
  RezEly:= abs((ManMatrix[tx,ty]-(EcoMatrix[Step,StepLevel,0]))
           /EcoMatrix[Step,StepLevel,0]);
  RezEly:=  power( 0.5, RezEly);
  RezEly:=  power( RezEly,EcoRecord[Step,StepLevel].ElevSharpness);
{  RezEly:=  power( 0.5, RezEly);}
{  RezEly:= power( power( 0.5,EcoRecord[Step,StepLevel].ElevSharpness),RezEly);}

  RezRely:= ( (RelativeElevation-(EcoMatrix[Step,StepLevel,1]))
           /EcoMatrix[Step,StepLevel,1]);
  RezRely:=  power( 0.5, RezRely);
  RezRely:=  power( RezRely,EcoRecord[Step,StepLevel].RESharpness);

  RezSlope:= ((Slope2-(EcoMatrix[Step,StepLevel,2]))
           /EcoMatrix[Step,StepLevel,2]);
  RezSlope:=  power( 0.5, RezSlope);
  RezSlope:=  power( RezSlope,EcoRecord[Step,StepLevel].SlopeSharpness);

  RezSlopeDir:= ((SlopeDir-(EcoMatrix[Step,StepLevel,3]))
           /EcoMatrix[Step,StepLevel,3]);
  RezSlopeDir:=  power( 0.5, RezSlopeDir);
  RezSlopeDir:=  power( RezSlopeDir,EcoRecord[Step,StepLevel].SlopeDirSharpness);

  Rez:= RezEly+ RezRely+ RezSlope+RezSlopeDir;
  {Sun Rises from East so What?} {then Valley UpDown else if}{Shady?}
  If Rez > TotRez then
  begin
  TotRez:=Rez;
  Stepcount:=Step ;
  StepLevelCount:=StepLevel;
  end;
  end;
  {StatusBar.Panels[5].Text:=  Floattostr(TotRez);
  Application.ProcessMessages;}
    scanLine[tx]:=Color32(EcoRecord[Stepcount,StepLevelCount].Color);

        If EcoBool[4]=True then
        begin
        If ManMatrix[tx,ty] > HiEl then HiEl:=ManMatrix[tx,ty];
        If ManMatrix[tx,ty] < LoEl then LoEl:=ManMatrix[tx,ty];
        If RelativeElevation > TotRezEly then TotRezEly:=RelativeElevation;
        If Slope2 > TotRezRely then TotRezRely:=Slope2;
        If SlopeDir > TotRezSlope then TotRezSlope:=SlopeDir;
        If RelativeElevation < MinRezEly then MinRezEly:=RelativeElevation;
        If Slope2 < MinRezRely then MinRezRely:=Slope2;
        If SlopeDir < MinRezSlope then MinRezSlope:=SlopeDir;
        If ( (Slope2> 0) and (Slope2< 0.4)) then
          begin
           StatusBar.Panels[5].Text:=  Floattostr(
           {RelativeElevation}
           Slope2
           {SlopeDir} ) ;
           Application.ProcessMessages;
          end;
        end;
    end;
  end;
  If EcoBool[4]=True then
     showmessage(
  'E: '+Floattostr((HiEl))+#13#10+
  'R: '+Floattostr((TotRezEly))+  #13#10+
  'S: '+Floattostr((TotRezRely))+#13#10+
  'sD: '+Floattostr((TotRezSlope))
       +  #13#10+  #13#10+
  'E-: '+Floattostr((LoEl))+#13#10+
  'R-: '+Floattostr((MinRezEly))+  #13#10+
  'S-: '+Floattostr((MinRezRely))+#13#10+
  'sD-: '+Floattostr((MinRezSlope)) );
  Setlength(EcoMatrix,0 ,0, 0 );
End;

{==============================================================}

{Two points required: Start and end point of LOS}
procedure TDTMform.LineofSight1Click(Sender: TObject);
begin
    LineofSight1.Checked:=(not LineofSight1.Checked );
    LOSint:=1;
end;

{The LOS Area is of the full screen in 3D,
Colors: Green is visible, Red is concealed}
procedure TDTMform.LOSMaskedArea1Click(Sender: TObject);
begin
  AllBtnsUp;
  LOSMaskedArea1.Checked:=True;
end;

procedure TDTMform.DoLOSint(LOSintin,X,Y:Integer);
begin
{  showmessage(
    'Which '+Inttostr(LOSint)+
    ' startx '+Inttostr(mx+curX)+
    ' x '+Inttostr(X+curX)+
    ' starty '+Inttostr(my+curY)+
    ' y '+Inttostr(Y+curY));}
  LOSint:=0;
  If LOSintin=1 then
  begin {LineofSight Line}
    LineProfileForm.Show;
    LineProfileForm.UpdateImage(mx+curX,x+curX,my+curY,y+curY);
  end;
end;



procedure TDTMform.ACNavMapExecute(Sender: TObject);
begin
   if NavForm.Execute(htf) then
   begin
      curX:=NavForm.PickX;
      curY:=NavForm.PickY;
      PrepareBitmap;
   end;
end;

procedure TDTMform.ACNavMapUpdate(Sender: TObject);
begin
   ACNavMap.Enabled:=Assigned(htf);
end;

procedure TDTMform.ACPaletteExecute(Sender: TObject);
begin
   if Sender is TMenuItem then
   begin
     PreparePal(TMenuItem(Sender).Hint);
     PrepareBitmap;
   end  else
   begin
     OpenDialogPal.InitialDir:= ProgramPath;
     OpenDialogPal.Filter:= 'HTF Palette (*.pal)|*.pal';
     OpenDialogPal.FileName:= '*.pal';
     if OpenDialogPal.Execute then
     begin
       if UpperCase(ExtractFileExt(OpenDialogPal.FileName)) = '.PAL' then
       begin
         PreparePal(OpenDialogPal.FileName);
         PrepareBitmap;
       end;
     end;
   end;
end;
{==============================================================}


{==============================================================}
procedure TDTMform.Contents1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TDTMform.OnHelp1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TDTMform.Me1Click(Sender: TObject);
begin
  Application.HelpContext(1000);
end;

procedure TDTMform.About1Click(Sender: TObject);
begin
  AboutDTM.Show;
end;
{==============================================================}

procedure TDTMform.OpenBackImage1Click(Sender: TObject);
begin
  OpenDialog.Filter:= 'Image File (*.png;*.jpg;*.jpeg;*.bmp)|*.png;*.jpg;*.jpeg;*.bmp;*.ico;*.emf;*.wmf|Portable Network Graphics (*.png)|*.png|JPEG Image File (*.jpg)|*.jpg|JPEG Image File (*.jpeg)|*.jpeg|Bitmaps (*.bmp)|*.bmp';
  OpenDialog.FileName:= '*.png';
  OpenDialog.InitialDir:=ShapePath;
  if OpenDialog.Execute then
  begin
    if length(OpenDialog.filename) = 0 then Exit;{Exits from the current procedure.}
    if ('.BMP'= UpperCase(ExtractFileExt(OpenDialog.FileName))) then
    begin
      BackBitmapPath := ExtractFilePath(OpenDialog.Filename);
      BackBitmapName := ExtractFileName(OpenDialog.Filename);
      BackClipBitmap := TBitmap32.Create;
      BackClipBitmap.LoadFromFile(BackBitmapPath+BackBitmapName);
      {Figure out the Image Size and Registration:
      StretchDraw X,Y, Width, Height}
      Image321.Bitmap.Draw(0,0, BackClipBitmap);
      {Tint of Area not Covered... Background Layer Level Top..Bottom}
    end;
  end;
end;
{==============================================================}
procedure TDTMform.OpenShape1Click(Sender: TObject);
begin
  OpenDialog.Filter:= 'Shape File (*.shp)|*.shp';
  OpenDialog.FileName:= '*.shp';
  OpenDialog.InitialDir:=ShapePath;
  if OpenDialog.Execute then
  begin
    if length(OpenDialog.filename) = 0 then Exit;{Exits from the current procedure.}
    if ('.SHP'= UpperCase(ExtractFileExt(OpenDialog.FileName))) then
    begin
       ShapePath := ExtractFilePath(OpenDialog.Filename);
       ShpFileName := OpenDialog.Filename;
      DTMform.Cursor:=crHourGlass; {crDefault}
      If NewLayer then
      begin
        MRUFileList.AddItem(ShpFileName);
      end else DoMessages(8);{8, "Not a Shape (*.shp) file"}
      DTMform.Cursor:=crDefault; {crDefault}
    end;
  end;
end;


Function TDTMform.NewLayer:Boolean;
var gotloaded:Boolean;
begin
  gotloaded:=False;
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[(LayersLoaded-1)]:= LayersLoaded;
  If LoadLayer then gotloaded:=True;
  If gotloaded then result:=gotloaded else
  begin
    {do something cause it failed loading}
    dec(LayersLoaded);
    CurrentLayer:=LayersLoaded;
    SetLength(LayA,LayersLoaded+1);
    SetLength(LayersControlArray,LayersLoaded);
    result:=gotloaded;
    DoMessages(16);{16, "Error loading Shape (*.shp) file"}
  end;
  Legend1.Enabled:=gotloaded;
  PrepareBitmap;
end;

{This reads a Shape file into an Array
Someday: Make a Direct File Access
to read from file and thus have NO storage
Store 'header' of each object? and File Offset for Points?}
Function TDTMform.LoadLayer:Boolean;
var
 ShapeFileIn: file;
 InString:String;
 BufByte:Byte;
 ShapeType,
 PointCount, IslandCount,
 {AreaCount,}FileSizeCheck,FileSizeChecker,
 NumShape, NumParts, NumPoints,
 ShapeNumber, PartNumber, PointNumber,
 ICOIn,{ICO,} BufI,ByteArray, I: integer;
  function SwapShapeByte: Integer;
  var aByteArray, oByteArray: array[0..3] of Byte;
    Outgoing: Integer;
  begin
    Move(ByteArray, aByteArray, 4);
    oByteArray[0] := aByteArray[3];
    oByteArray[1] := aByteArray[2];
    oByteArray[2] := aByteArray[1];
    oByteArray[3] := aByteArray[0];
    Move(oByteArray, Outgoing, 4);
    Result := Outgoing;
  end;
  function SwapShapeInteger(InInteger:Integer): Integer;
  var
    aByteArray, oByteArray: array[0..3] of Byte;
    Outgoing: Integer;
  begin
    Move(InInteger, aByteArray, SizeOf(aByteArray));
    oByteArray[0] := aByteArray[3];
    oByteArray[1] := aByteArray[2];
    oByteArray[2] := aByteArray[1];
    oByteArray[3] := aByteArray[0];
    Move(oByteArray, Outgoing, SizeOf(Outgoing));
    Result := Outgoing;
  end;
begin
  Result:=False;
  Try
  Begin
    AssignFile(ShapeFileIn, ShpFileName);
    Reset(ShapeFileIn, 1); { Record size = 1 }
    Application.ProcessMessages;
    PointCount := 0;
    IslandCount := 0;
     {AreaCount := 0; }
    ShapeNumber :=0;
    NumShape:=0;
    LayA[CurrentLayer].Modified:=False;

    {Set up Shape}
    BlockRead(ShapeFileIn, ByteArray, 4); {9994 file code}
    str(SwapShapeInteger(ByteArray), InString);
    {ShapeViewMemo.Lines.Add('9994 file code: ' + InString);}

    for I := 1 to 5 do
    begin {5 blank zeros}
        BlockRead(ShapeFileIn, ByteArray, 4);
        str(SwapShapeInteger(ByteArray), InString);
       {ShapeViewMemo.Lines.Add('zero: ' + InString);}
    end;
    BlockRead(ShapeFileIn, ByteArray, 4);
    BlockRead(ShapeFileIn, BufI, 4); {Version 1000}
    If BufI <> 1000 then exit;{New version}
    {ShapeViewMemo.Lines.Add('Version 1000: ' + Inttostr(BufI));}
    BlockRead(ShapeFileIn, BufI, 4);{Shapetype}
    ShapeType := BufI;
    {ShapeViewMemo.Lines.Add('Shapetype: ' + Inttostr(BufI));}
    LayA[CurrentLayer].LayerN:=CurrentLayer;
    LayA[CurrentLayer].ShpType:=ShapeType;
    LayA[CurrentLayer].Modified:=False;
    LayA[CurrentLayer].Filename:=ExtractFileName(ShpFileName);
    LayA[CurrentLayer].Path:=ExtractFilePath(ShpFileName);
    {Place Shape type into record}
    BlockRead(ShapeFileIn, dXMIN, 8);
    {ShapeViewMemo.Lines.Add('XMIN: '  + Floattostr(dXMIN));}
    BlockRead(ShapeFileIn, dYMIN, 8);
    {ShapeViewMemo.Lines.Add('YMIN: '  + Floattostr(dYMIN));}
    BlockRead(ShapeFileIn, dXMAX, 8);
    {ShapeViewMemo.Lines.Add('XMAX: '  + Floattostr(dXMAX));}
    BlockRead(ShapeFileIn, dYMAX, 8);
    {ShapeViewMemo.Lines.Add('YMAX: '  + Floattostr(dYMAX));}
    {Place XMIN,YMIN,XMAX,YMAX:Double; into record}
    LayA[CurrentLayer].XMin:= dXMIN;
    LayA[CurrentLayer].YMin:= dYMIN;
    LayA[CurrentLayer].XMax:= dXMAX;
    LayA[CurrentLayer].YMax:= dYMAX;
    if dXMIN < 0 then
      LayA[CurrentLayer].OffsetX := (180+dXMIN)+abs(dXMIN)
      else if dXMIN > 0 then
      LayA[CurrentLayer].OffsetX  := (0 - dXMIN)
      else LayA[CurrentLayer].OffsetX  := 0;
    if dYMIN < 0 then
      LayA[CurrentLayer].OffsetY := (90+dYMIN)+abs(dYMIN)
      else if dYMIN > 0 then
      LayA[CurrentLayer].OffsetY := (0 - dYMIN)
      else LayA[CurrentLayer].OffsetY := 0;

    If abs(LayA[CurrentLayer].OffsetX) > abs(MaxOffsetX) then
       MaxOffsetX:= LayA[CurrentLayer].OffsetX;
    If abs(LayA[CurrentLayer].OffsetY) > abs(MaxOffsetY) then
       MaxOffsetY:= LayA[CurrentLayer].OffsetY;

    If CurrentLayer =1 then
    Begin
      MinOffX:=LayA[CurrentLayer].XMin;
      MinOffY:=LayA[CurrentLayer].YMin;
      MaxOffX:=LayA[CurrentLayer].XMax;
      MaxOffY:=LayA[CurrentLayer].YMax;
    End;
    BlockRead(ShapeFileIn, dXTemp, 8);
    BlockRead(ShapeFileIn, dYTemp, 8);
    LayA[CurrentLayer].ZMin:= dXTemp;
    {ShapeViewMemo.Lines.Add('ZMin: '  + Floattostr(dXTemp));}
    LayA[CurrentLayer].ZMax:= dYTemp;
    {ShapeViewMemo.Lines.Add('ZMax: '  + Floattostr(dYTemp));}
    BlockRead(ShapeFileIn, dXTemp, 8);
    BlockRead(ShapeFileIn, dYTemp, 8);
    LayA[CurrentLayer].MMin:= dXTemp;
    LayA[CurrentLayer].MMax:= dYTemp;
    {ShapeViewMemo.Lines.Add('MMax: '  + Floattostr(dYTemp));}
    {LayA[].ShpLayer.LyrShp[].ShpObj.PARA[PartsN #].PAR.PA[PPA[PartsN #]].Pnts.Xn Yn Zn Mn}

    {******************* BIG SWITCH ******************}
   {==============================================================}
    If ((ShapeType=1)       {Point Type, Box, Numpoints, Points }
        or(ShapeType=11)
        or(ShapeType=21)) then
    begin
      ShapeNumber :=0;
      while (not (eof(ShapeFileIn))) do
      begin
      {Header}
        BlockRead(ShapeFileIn, ICOIn, 4); {Record Number}
        inc(ShapeNumber);
        NumShape:=SwapShapeInteger(ICOIn);{Store total for later}
        Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
        StatusBar.Panels[0].Text:=Inttostr(NumShape);
        Application.ProcessMessages;
        BlockRead(ShapeFileIn, ByteArray, 4); {Content length}
        FileSizeCheck:=SwapShapeByte;
      {Data per Point}
        BlockRead(ShapeFileIn, BufI, 4); {Shapetype Store only #6}
        BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= dXTemp;
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= dXTemp;
        BlockRead(ShapeFileIn, dYTemp, 8);
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= dYTemp;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= dYTemp;
        {Z M POINTS....}
        If (ShapeType=11) then
        begin
          BlockRead(ShapeFileIn, dXTemp, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMin:= dXTemp;}
          BlockRead(ShapeFileIn, dXTemp, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMax:= dXTemp;}
        end;
        If ((ShapeType=11)or(ShapeType=21)) then
        begin
          BlockRead(ShapeFileIn, dYTemp, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].MMin:= dYTemp;}
          BlockRead(ShapeFileIn, dYTemp, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].MMax:= dYTemp;}
        end; {For II}
        {Some shape files have 'proprietary' stuff
          'hidden' in the files...IGNORE it}
        If ((ShapeType=1)and (FileSizeCheck > 10)) then
        begin
          FileSizeCheck:=(FileSizeCheck * 2);
          for I:= 1 to FileSizeCheck-20 do
          begin
            BlockRead(ShapeFileIn, BufByte,1);
          end;
        end;
        If ((ShapeType=21)and (FileSizeCheck > 18)) then
        begin
          FileSizeCheck:=(FileSizeCheck * 2);
          for I:= 1 to FileSizeCheck-36 do
          begin
            BlockRead(ShapeFileIn, BufByte,1);
          end;
        end;
        If ((ShapeType=11)and (FileSizeCheck > 26)) then
        begin
          FileSizeCheck:=(FileSizeCheck * 2);
          for I:= 1 to FileSizeCheck-52 do
          begin
            BlockRead(ShapeFileIn, BufByte,1);
          end;
        end;
        LayA[CurrentLayer].ShapeN:=NumShape;
        LayA[CurrentLayer].TotalPnts:=ShapeNumber;
        LayA[CurrentLayer].IslandsN:=0;
      end;{File}
    end {points} else
    (********************************)
    If ((ShapeType=3) {Line }
          or(ShapeType=13)
          or(ShapeType=23)
          or  (ShapeType=5) { Polygon}
          or(ShapeType=15)
          or(ShapeType=25) ) then
    begin
      ShapeNumber :=0;
      while (not (eof(ShapeFileIn))) do
      begin
        Application.ProcessMessages;
        {inc(AreaCount);}
        BlockRead(ShapeFileIn, ICOIn, 4); {Record Number}
        inc(ShapeNumber);
        NumShape:=SwapShapeInteger(ICOIn);{Store total for later}
        Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
        {ShapeViewMemo.Lines.Add('Record Number: ' + Inttostr(NumShape));}
              {  Counter status}
        StatusBar.Panels[0].Text:=Inttostr(NumShape);

        BlockRead(ShapeFileIn, ByteArray, 4); {Content length}
        FileSizeCheck:=SwapShapeByte;
        {ShapeViewMemo.Lines.Add('Content length: ' + Inttostr(SwapShapeInteger(ByteArray)));}
        BlockRead(ShapeFileIn, BufI, 4); {Shapetype}
        {ShapeViewMemo.Lines.Add('Shapetype: ' + Inttostr(BufI));}
              {If not same as Shapetype then error}
        {XMIN,YMIN,XMAX,YMAX:Double;}
        BlockRead(ShapeFileIn, dXMIN, 8);
        {ShapeViewMemo.Lines.Add('XMIN: '  + Floattostr(dXMIN));}
        BlockRead(ShapeFileIn, dYMIN, 8);
        {ShapeViewMemo.Lines.Add('YMIN: '  + Floattostr(dXMIN));}
        BlockRead(ShapeFileIn, dXMAX, 8);
        {ShapeViewMemo.Lines.Add('XMAX: '  + Floattostr(dXMAX));}
        BlockRead(ShapeFileIn, dYMAX, 8);
        {ShapeViewMemo.Lines.Add('YMAX: '  + Floattostr(dYMAX));}
        {LayA[].ShpLayer.LyrShp[].ShpObj.PARA[PartsN #].PAR.PA[PPA[PartsN #]].Pnts.Xn Yn Zn Mn}
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= dXMIN;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= dYMIN;
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= dXMAX;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= dYMAX;

        BlockRead(ShapeFileIn, Numparts, 4); {Numparts}
        LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=Numparts;
        IslandCount:= IslandCount+(Numparts-1);
        {CHANGE the array size to Numparts}
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
        BlockRead(ShapeFileIn, NumPoints, 4); {NumPoints}
        LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
        PointCount:=PointCount+NumPoints;{Total points for File}
        {ShapeViewMemo.Lines.Add('NumPoints: ' + Inttostr(NumPoints));}
        {Ignore storing NumPoints.. use it to read file}
        {If MessageDlg('Got to shape NumPoints '+Inttostr(NumPoints)+' Exit now?'
                  ,mtConfirmation, [mbYes, mbNo], 0)=mrYes then exit;}
        BlockRead(ShapeFileIn, BufI, 4); {Parts... skip first as it is 0}
        {ShapeViewMemo.Lines.Add('Parts Points at: ' + Inttostr(BufI));}
        ICOIn:=0;
        If Numparts >1 then
        begin
          for I := 1 to Numparts-1 do
          begin {Always at least 1 0...}
            BlockRead(ShapeFileIn, BufI, 4); {Parts 2...}
            {ShapeViewMemo.Lines.Add('Parts Points: ' + Inttostr(BufI));}
            LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[I]:=((BufI)-ICOIn);
            {If MessageDlg('Got to shape '+Inttostr(ShapeNumber)
                           +' .BufI. '+Inttostr(BufI)
                           +' .-. '+Inttostr((BufI)-ICOIn)
                           +' .NumPoints. '+Inttostr(NumPoints)
                           +' Exit now?'
                   ,mtConfirmation, [mbYes, mbNo], 0)=mrYes then exit;}
            SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[I].PA,((BufI+1)-ICOIn) );
            ICOIn:=BufI;
          end;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:=((NumPoints-ICOIn));
          SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,((NumPoints-ICOIn)+1) );
        end else
        begin
          LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:=NumPoints;{((NumPoints-BufI)+1);}{BufI;}
          SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,NumPoints+1);
        end;
        {ShapeViewMemo.Lines.Add('total Points: ' + Inttostr(NumPoints));}
        ICOIn:=0;
        for I := 1 to Numparts do
        begin
          ICOIn:= ICOIn+LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[I];
        end;
        If (ICOIn <> NumPoints) then
        begin
          If MessageDlg('Count Wrong ICOIN= '+Inttostr(ICOIn)
                        +' <>NumPoints: '+Inttostr(NumPoints)
                        +' Exit now?'
                   ,mtConfirmation, [mbYes, mbNo], 0)=mrYes then exit;
        end;
        {GET the Parts array data}
        PartNumber:=1;
        PointNumber:=1;
        {Get the Parts array and use to divide lines}
        for I := 1 to NumPoints do
        begin {2 points internally}
            {SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA,PointNumber+1);}
          BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Xd:=dXTemp;
          {ShapeViewMemo.Lines.Add('Point X ' + Inttostr(PointNumber)+ ' : ' + Floattostr(dXTemp));}
          BlockRead(ShapeFileIn, dYTemp, 8);
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Yd:=dYTemp;
          {ShapeViewMemo.Lines.Add('Point Y ' + Inttostr(PointNumber)+ ' : ' + Floattostr(dYTemp));}
          {Change the Part Number according to the number of points in the Part}
          If (PointNumber = (LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[PartNumber])) then
          begin
            inc(PartNumber);
            PointNumber:=0;
          end;
          inc(PointNumber);
        end;
        {DO Z and M}
        If ((ShapeType=13)or(ShapeType=15) ) then
        begin
          BlockRead(ShapeFileIn, dXMIN, 8);
          BlockRead(ShapeFileIn, dXMAX, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMin:= dXMIN;
          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMAX:= dXMAX;}
          {GET the Parts array data}
          PartNumber:=1;
          PointNumber:=1;
          {Get the Parts array and use to divide lines}
          for I := 1 to NumPoints do
          begin {1 point internally}
            BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
{            LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Zd:=dXTemp;}
            {Change the Part Number according to the number of points in the Part}
            If (PointNumber = (LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[PartNumber])) then
            begin
              inc(PartNumber);
              PointNumber:=0;
            end;
            inc(PointNumber);
          end;{I}
        end;{Z array}

        If ((ShapeType=23)or(ShapeType=25)
          or(ShapeType=13)or(ShapeType=15) ) then
        begin
          BlockRead(ShapeFileIn, dXMIN, 8);
          BlockRead(ShapeFileIn, dXMAX, 8);
{          LayA[CurrentLayer].LyrShp[ShapeNumber].MMin:= dXMIN;
          LayA[CurrentLayer].LyrShp[ShapeNumber].MMAX:= dXMAX;}
          {GET the Parts array data}
          PartNumber:=1;
          PointNumber:=1;
          {Get the Parts array and use to divide lines}
          for I := 1 to NumPoints do
          begin {1 point internally}
            BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
{            LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Md:=dXTemp;}
            {Change the Part Number according to the number of points in the Part}
            If (PointNumber = (LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[PartNumber])) then
            begin
              inc(PartNumber);
              PointNumber:=0;
            end;
            inc(PointNumber);
          end;{I}
        end;{M array}
{        FileSizeCheck:=SwapShapeByte;}
{Compute Actual size of THIS Shape Object}
        FileSizeChecker:=FileSizeCheck*2;
        If FileSizeCheck > FileSizeChecker then
        begin
          FileSizeCheck:=(FileSizeCheck * 2);
          for I:= 1 to FileSizeCheck-20 do
          begin
            BlockRead(ShapeFileIn, BufByte,1);
          end;
        end;
      end; {For II File}
      LayA[CurrentLayer].ShapeN:=NumShape;
      LayA[CurrentLayer].TotalPnts:=PointCount;
      LayA[CurrentLayer].IslandsN:=IslandCount;
    end {shape type...Polygon}
    else

    (********************************)
    If ((ShapeType=8){MultiPoint 1 Part of Many Points}
          or(ShapeType=18)
          or(ShapeType=28)) then
    begin
      ShapeNumber :=0;
      while (not (eof(ShapeFileIn))) do
      begin
        BlockRead(ShapeFileIn, ICOIn, 4); {Record Number}
        inc(ShapeNumber);
        NumShape:=SwapShapeInteger(ICOIn);{Store total for later}
        Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
         {  Counter status}
        StatusBar.Panels[0].Text:=Inttostr(NumShape);
        Application.ProcessMessages;
        BlockRead(ShapeFileIn, ByteArray, 4); {Content length}
        FileSizeCheck:=SwapShapeByte;
        { ShapeViewMemo.Lines.Add('Content length: ' + Inttostr(SwapShapeInteger(ByteArray)));}
        BlockRead(ShapeFileIn, BufI, 4); {Shapetype}
        {ShapeViewMemo.Lines.Add('Shapetype: ' + Inttostr(BufI));}
              {If not same as Shapetype then error}
        {XMIN,YMIN,XMAX,YMAX:Double;}
        BlockRead(ShapeFileIn, dXMIN, 8);
        {ShapeViewMemo.Lines.Add('XMIN: '  + Floattostr(dXMIN));}
        BlockRead(ShapeFileIn, dYMIN, 8);
        {ShapeViewMemo.Lines.Add('YMIN: '  + Floattostr(dXMIN));}
        BlockRead(ShapeFileIn, dXMAX, 8);
         {ShapeViewMemo.Lines.Add('XMAX: '  + Floattostr(dXMAX));}
        BlockRead(ShapeFileIn, dYMAX, 8);
         {ShapeViewMemo.Lines.Add('YMAX: '  + Floattostr(dYMAX));}
         {LayA[].ShpLayer.LyrShp[].ShpObj.PARA[PartsN #].PAR.PA[PPA[PartsN #]].Pnts.Xn Yn Zn Mn}
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= dXMIN;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= dYMIN;
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= dXMAX;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= dYMAX;
        Numparts:=1;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=1;{Numparts}
         {IslandCount:= IslandCount+(Numparts-1);}
        {CHANGE the array size to Numparts}
        {SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);}
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
        BlockRead(ShapeFileIn, NumPoints, 4); {NumPoints}
        LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
        PointCount:=PointCount+NumPoints;{Total points for File}
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1].PA,NumPoints+1 );

        {GET the Parts array data}
        PartNumber:=1;
        PointNumber:=1;
         {Get the Parts array and use to divide lines}
        for I := 1 to NumPoints do
        begin {2 points internally}
          BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Xd:=dXTemp;
          BlockRead(ShapeFileIn, dYTemp, 8);
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Yd:=dYTemp;
          inc(PointNumber);
        end;
        If (ShapeType=18) then {Z 18 only}
        begin
          BlockRead(ShapeFileIn, dXMIN, 8);
          {ShapeViewMemo.Lines.Add('XMAX: '  + Floattostr(dXMAX));}
          BlockRead(ShapeFileIn, dYMAX, 8);
          {ShapeViewMemo.Lines.Add('YMAX: '  + Floattostr(dYMAX));}
          {LayA[].ShpLayer.LyrShp[].ShpObj.PARA[PartsN #].PAR.PA[PPA[PartsN #]].Pnts.Xn Yn Zn Mn}
{          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMin:= dXMIN;
          LayA[CurrentLayer].LyrShp[ShapeNumber].ZMax:= dXMAX;}
          for I := 1 to NumPoints do
          begin {2 points internally}
            BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
{            LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Zd:=dXTemp;}
          end;
        end;
        If (ShapeType>8) then {18 and 28}
        begin
          BlockRead(ShapeFileIn, dXMIN, 8);
          { ShapeViewMemo.Lines.Add('XMAX: '  + Floattostr(dXMAX));}
          BlockRead(ShapeFileIn, dYMAX, 8);
          {ShapeViewMemo.Lines.Add('YMAX: '  + Floattostr(dYMAX));}
          {LayA[].ShpLayer.LyrShp[].ShpObj.PARA[PartsN #].PAR.PA[PPA[PartsN #]].Pnts.Xn Yn Zn Mn}
{          LayA[CurrentLayer].LyrShp[ShapeNumber].MMin:= dXMIN;
          LayA[CurrentLayer].LyrShp[ShapeNumber].MMax:= dXMAX;}
          for I := 1 to NumPoints do
          begin {2 points internally}
            BlockRead(ShapeFileIn, dXTemp, 8); {POINTS....}
{            LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[PartNumber].PA[PointNumber].Md:=dXTemp;}
          end;
        end;
{COMPUTE Actual Shape Object Size}
        FileSizeChecker:=FileSizeCheck*2;
        If FileSizeCheck > FileSizeChecker then
        begin
          FileSizeCheck:=(FileSizeCheck * 2);
          for I:= 1 to FileSizeCheck-20 do
          begin
            BlockRead(ShapeFileIn, BufByte,1);
          end;
        end;
      end; {For II File}
      LayA[CurrentLayer].ShapeN:=NumShape;
      LayA[CurrentLayer].TotalPnts:=PointCount;
      LayA[CurrentLayer].IslandsN:=0;{IslandCount;}
    end {shape type...Multi Point}
    else
    If (ShapeType=31) then
    begin  {Fan or Strip.. Read into Mesh}
      Result:=False;
      DoMessages(16);{16, "Error loading Shape (*.shp) file"}
    end else Result:=False;

    If ShapeNumber <> NumShape then Result:=False
       else Result:=True;

    If (Result=True) then
    begin
    {Make Attributes .. If Db fileexists then read it}
     LayA[CurrentLayer].LayerColor:=
     RGB(Random(255),Random(255),Random(255));
     LayA[CurrentLayer].OutLineColor:=
          LayA[CurrentLayer].LayerColor;
     LayA[CurrentLayer].PolygonAntialiased:=False;
     LayA[CurrentLayer].PolyFilled:=False;
     LayA[CurrentLayer].UseOutlinePoly:=False;
     LayA[CurrentLayer].LineAlphaPosition:=255;
     LayA[CurrentLayer].FillAlphaPosition:=127;
     LayA[CurrentLayer].LineSize:=1.0;
     LayA[CurrentLayer].PointSize:=2;
     LayA[CurrentLayer].OtsNameEditText:='Nada.ots';
     LayA[CurrentLayer].StippleColorCount:=1;
     LayA[CurrentLayer].UseStippleStep:=False;
     LayA[CurrentLayer].StippleStep:=1.0;
     SetLength(LayA[CurrentLayer].StippleColorArray,1);
     LayA[CurrentLayer].StippleColorArray[0]:=ClBlack;
     LayA[CurrentLayer].CanvasLineSize:=0;
    end;

  End;{Finally Begin}
  Finally
      CloseFile(ShapeFileIn);
  end;{Finally}
end; {PROCEDURE }
{==============================================================}

{==============================================================}
{Text X,Y =recompute; if 'set' rescale then recompute}
procedure TDTMform.DVDORedraw;
var
UseOutlinePoly:Boolean;
 LayerDo, Startat,{ Finishat, }
 INumparts,  INumPoints, CurrentPointType,PointSize,
 ShapeType, ShapeToDo, DXI,DYI,
 NumShape, NumParts, NumPoints,
 FillAlphaPosition, LineAlphaPosition : integer;
 DXdtemp,DYdtemp:Double;
 Editarray:Array of TPoint;
{ Editarray32:TArrayOfFixedPoint;}
 PolyColor, OutLineColor,PointColor:TColor32;
    Polygon: TPolygon32;
    Outline: TPolygon32;
    TmpPoly: TPolygon32;
    Step, LineSize:Single;
begin
  If LayersLoaded>0 then
  Begin
    {Offset is +- to center data to 0,0}
    TMinOffX:= TMinOffX*TMaxOffsetX;
    TMinOffY:= TMinOffY*TMaxOffsetY;
    ScreenScale :=   TMaxOffsetX;
    For Startat:=0 to LayersLoaded-1 do
    Begin
      LayerDo:=LayersControlArray[Startat];
      ShapeType:= LayA[LayerDo].ShpType;
      NumShape:= LayA[LayerDo].ShapeN;
      Image321.Bitmap.PenColor :=
            Color32(LayA[LayerDo].LayerColor);
      PointColor:= Color32(LayA[LayerDo].LayerColor);
      PolyColor:= Color32(LayA[LayerDo].LayerColor);
      OutLineColor:= Color32(LayA[LayerDo].OutLineColor);
          {Point Type, Box, Numpoints, Points }
  Canvas.Pen.Color := LayA[LayerDo].LayerColor; // use standard TCanvas methods for drawing
  Canvas.Brush.Color := LayA[LayerDo].LayerColor; // use standard TCanvas methods for drawing
  Canvas.Pen.Width := LayA[LayerDo].CanvasLineSize; // use standard TCanvas methods for drawing
     Canvas.Brush.Style := bsSolid; {bsClear}
      If ((ShapeType=1) or(ShapeType=11) or(ShapeType=21)) then
      begin
        CurrentPointType:=LayA[LayerDo].CurrentPointType;
        PointSize:=LayA[LayerDo].PointSize;
          case CurrentPointType of {Set for all points NOW}
            1:Canvas.Brush.Style :=bsClear;
            3:Canvas.Pen.Color :=LayA[CurrentLayer].OutLineColor;
            6..7:Canvas.Brush.Style :=bsClear;
          end;
        For ShapeToDo:=1 to NumShape do
        Begin
          dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].XMax;
          dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].YMax;
          DXdtemp:=MaxOffsetX +DShiftOffsetX+dXTemp- TMinOffX ;
          DYdtemp:=MaxOffsetY +DShiftOffsetY+dYTemp+ TMinOffY;
          DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
          DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
{Points: Dot Circle DotInCircle FilledCircle PlusSign X Box XInBox FilledBox}
          case CurrentPointType of
            0: {Pnt Dot} Canvas.Pixels[DXI, DYI] :=
                LayA[CurrentLayer].LayerColor;
            1: {Pnt Circle}
              begin {    Canvas.Ellipse}
                Canvas.Ellipse(DXI - PointSize, DYI - PointSize,
                DXI + PointSize, DYI +PointSize);
              end;
            2: {Pnt DotInCircle  }
              begin
                Canvas.Ellipse(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.Pixels[DXI, DYI] :=
                  LayA[CurrentLayer].OutLineColor;
              end;
              {FilledCircle}
            3:Canvas.Ellipse(DXI - PointSize,
            DYI - PointSize, DXI + PointSize, DYI +PointSize);

            4: {Pnt PlusSign  +}
              begin
                Canvas.moveto(DXI - PointSize, DYI);
                Canvas.lineto(DXI + PointSize, DYI);
                Canvas.moveto(DXI, DYI + PointSize);
                Canvas.lineto(DXI, DYI - PointSize);
              end;
            5: {PntX   X}
              begin
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;

            6: {Pnt Box X1, Y1, X2, Y2}
              begin
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
              end;
            7: {Pnt XInBox}
              begin
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;
             8: {FilledBox}
          Canvas.FillRect(Rect(DXI-PointSize,DYI+PointSize,
          DXI+PointSize,DYI-PointSize){,PointColor});
          end; {Case}
        end;
      end else
{0 Null Shape
1 Point      11 PointZ       21 PointM
8 MultiPoint 18 MultiPointZ  28 MultiPointM

3 PolyLine   13 PolyLineZ    23 PolyLineM
5 Polygon    15 PolygonZ     25 PolygonM
31 MultiPatch      Fan or Strip     }
      If ( (ShapeType=3) or (ShapeType=13) or (ShapeType=23)
{         or(ShapeType=5) or (ShapeType=15) or (ShapeType=25)}
         {MultiPoint 1 Part of Many Points}
         or(ShapeType=8) or(ShapeType=18) or(ShapeType=28)
         {31 blocked out Fans and Strips}
         )then
      begin
        For ShapeToDo:=1 to NumShape do
        Begin
          Application.ProcessMessages;
          Numparts:=LayA[LayerDo].LyrShp[ShapeToDo].PartsN;{Numparts}
          for INumparts := 1 to Numparts do
          begin {Always at least 1 0...}
            NumPoints:=LayA[LayerDo].LyrShp[ShapeToDo].PPA[INumparts];
            {Make Poly array}
            SetLength(Editarray,NumPoints);
            for INumPoints := 1{2} to NumPoints do
            begin {2 points internally}
              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
              DXdtemp:=MaxOffsetX +DShiftOffsetX+dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +DShiftOffsetY+dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              Editarray[INumPoints-1].X:= DXI;
              Editarray[INumPoints-1].Y:= DYI;
            end;{INumPoints}
            begin
              Image321.Bitmap.MoveTo(Editarray[0].X, Editarray[0].Y);
              for INumPoints := 2 to NumPoints do
   If LayA[LayerDo].UseStippleStep then
   Image321.Bitmap.LineToFSP(Editarray[INumPoints-1].X,
                                        Editarray[INumPoints-1].Y)
   else
    Image321.Bitmap.LineToS(Editarray[INumPoints-1].X,
                                        Editarray[INumPoints-1].Y);
            end;
          end;{INumparts}
        end; {For ShapeToDo}
      end else

      If ((ShapeType=5) or (ShapeType=15) or (ShapeType=25) )then
      begin
        {New Polygon ?}
        Polygon := TPolygon32.Create;
        Outline := TPolygon32.Create;
        Polygon.Antialiased := LayA[LayerDo].PolygonAntialiased;
        UseOutlinePoly:= LayA[LayerDo].UseOutlinePoly;
        Polygon.FillMode := pfWinding;  {pfAlternate}
        FillAlphaPosition:= LayA[LayerDo].FillAlphaPosition;
        LineAlphaPosition:= LayA[LayerDo].LineAlphaPosition;
        LineSize:= LayA[LayerDo].LineSize;
        For ShapeToDo:=1 to NumShape do
        Begin
          Application.ProcessMessages;
          Numparts:=LayA[LayerDo].LyrShp[ShapeToDo].PartsN;{Numparts}
          for INumparts := 1 to Numparts do
          begin {Always at least 1 0...}
            Polygon.NewLine;
            NumPoints:=LayA[LayerDo].LyrShp[ShapeToDo].PPA[INumparts];
            {Make Poly array}
            {SetLength(Editarray32,NumPoints);}
            for INumPoints := 1 to NumPoints do
            begin {2 points internally}
              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
              DXdtemp:=MaxOffsetX +DShiftOffsetX+dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +DShiftOffsetY+dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              {Editarray32[INumPoints-1].X:= DXI;
              Editarray32[INumPoints-1].Y:= DYI;}
             Polygon.Add(FixedPoint(DXI, DYI))
            end;{INumPoints}
            begin
              {Image321.Bitmap.MoveTo(Editarray[0].X, Editarray[0].Y);
              for INumPoints := 2 to NumPoints do
                Image321.Bitmap.LineToS(Editarray[INumPoints-1].X,
                                        Editarray[INumPoints-1].Y);}
            end;
          end;{INumparts}
        end; {For ShapeToDo}
        Polygon.DrawFill(Image321.Bitmap,
                   SetAlpha(PolyColor, FillAlphaPosition));
        if UseOutlinePoly then
        begin
          TmpPoly := Polygon.Outline;
          Outline := TmpPoly.Grow(Fixed(LineSize / 2), 0.5);
          Outline.FillMode := pfWinding;
          TmpPoly.Free;
        end;
        if UseOutlinePoly then
           Outline.Antialiased := LayA[LayerDo].PolygonAntialiased;
        if UseOutlinePoly then
           Outline.DrawFill(Image321.Bitmap,
                     SetAlpha(OutLineColor, LineAlphaPosition))
           else Polygon.DrawEdge(Image321.Bitmap,
                     SetAlpha(OutLineColor, LineAlphaPosition));
        Outline.Free;
        {Outline := nil;  }
        Polygon.Free;
      end;{LayerDo ShapeType}
    end;{CurrentLayer for each layer}
  end;{Any Layers ?}
  SetLength(Editarray,0);{  SetLength(Editarray32,0);}
End;
{==============================================================}
{==============================================================}


{==============================================================}
{==============================================================}
procedure TDTMform.Options1Click(Sender: TObject);
begin
  dtmPOFForm.show;
end;

procedure TDTMform.SetEcoColors1Click(Sender: TObject);
begin
  dtmEcotypeColorsForm.show;
end;

procedure TDTMform.HTFpack1Click(Sender: TObject);
begin
  HtfForm.show;
end;

procedure TDTMform.Legend1Click(Sender: TObject);
begin
  If LayersLoaded>0 then
  begin   {Legend is MODAL.. only 1 and only IT}
    dtmDTPForm:=TdtmDTPForm.Create(Application);
    dtmDTPForm.Showmodal;
    dtmDTPForm.Release;
    PrepareBitmap;
  end;
end;

procedure TDTMform.DemDblist1Click(Sender: TObject);
begin
  dtmDbForm.show;
end;

procedure TDTMform.Imagemaker1Click(Sender: TObject);
begin
  if Assigned(htf) then
  begin
    ImageMakerForm:=TImageMakerForm.Create(Application);
    ImageMakerForm.Showmodal;
    ImageMakerForm.Release;
  end;
end;



procedure TDTMform.RagDoll1Click(Sender: TObject);
begin
  If NoGLRunning then
  begin
    NoGLRunning:=False;
    dtmSmdQcForm.show;
  end;
end;

procedure TDTMform.GLSViewer1Click(Sender: TObject);
begin
  If NoGLRunning then
  begin
    NoGLRunning:=False;
    dtmGLSViewerForm.show;
  end;
end;

procedure TDTMform.Panaviewer1Click(Sender: TObject);
begin
  If NoGLRunning then
  begin
    NoGLRunning:=False;
    dtmPanVizForm.Show;
  end;
end;

procedure TDTMform.Joystick1Click(Sender: TObject);
begin
  If NoGLRunning then
  begin
    NoGLRunning:=False;
    dtmJoyForm:=TdtmJoyForm.Create(Application);
    dtmJoyForm.Showmodal;
    dtmJoyForm.Release;
  end;
end;

procedure TDTMform.Image3DHistogram1Click(Sender: TObject);
begin
  If NoGLRunning then
  begin
    {Open a data file made of an Image Histogram
     Display on a GL form as Cubes...
     255x255x255: Location determines RGB Value
             -> Look up in Data LIST
             to determine COUNT of Values of that color}
    OpenDialog.Filter:= 'Raster 3d Histogram File (*.rs3)|*.rs3';
    OpenDialog.FileName:= '*.rs3';
    OpenDialog.InitialDir:=ImagePath;
    if OpenDialog.Execute then
    begin
      ImagePath:=ExtractFilePath(OpenDialog.FileName);
      NoGLRunning:=False;
      Application.ProcessMessages;
      DtmImageRGBForm.Show;
      DtmImageRGBForm.ShowDown(OpenDialog.FileName);
    end;
  end;
end;

procedure TDTMform.Image3DdotHistogram1Click(Sender: TObject);
type
  Count3D = array[0..255] of Byte;
var
  Count3DArray: Count3D;
  RX, GY, BZ, Value: Byte;
  Counter:Integer;
  fLoad: file of Count3D;
begin
  If NoGLRunning then
  begin
    {Open a data file made of an Image Histogram
     Display on a GL form as dots... All at once
     255x255x255: precompute the LIST of Records
     thus saving time later:
     NO PIXEL VALUE lookup comparison of null values}
    OpenDialog.Filter:= 'Raster 3d Histogram File (*.rs3)|*.rs3';
    OpenDialog.FileName:= '*.rs3';
    OpenDialog.InitialDir:=ImagePath;
    if OpenDialog.Execute then
    begin
      ImagePath:=ExtractFilePath(OpenDialog.FileName);
      NoGLRunning:=False;
      Application.ProcessMessages;
      Counter:=0;
      {$I-}
      AssignFile(fLoad, OpenDialog.FileName);
      Reset(fLoad);
      ProgressBar1.Position:=0;
      ProgressBar1.Visible:=True;
      for BZ := 0 to 255 do
      begin
        ProgressBar1.Position:= Round(100 * (BZ / 255));
        for GY := 0 to 255 do
        begin {Row}
          Read(fLoad, Count3DArray);
          for RX := 0 to 255 do
          begin {Col}
            Value := Count3DArray[RX];
            If Value > 0 then
            begin
              inc(Counter);
              SetLength(Array3D, Counter+1);
              Array3D[Counter].RX:=RX;
              Array3D[Counter].GY:=GY;
              Array3D[Counter].BZ:=BZ;
              Array3D[Counter].Count:=Value;
            end;
          end;
        end;
      end;
      CloseFile(fLoad);
      {$I+}
      Array3DCounter:=Counter;
      ProgressBar1.Position:=0;
      ProgressBar1.Visible:=False;
      Application.ProcessMessages;
      DtmImageDotRGBForm:=TDtmImageDotRGBForm.Create(Application);
      DtmImageDotRGBForm.Caption:='Rx Gy Bz 3D Dot: '
                           +ExtractFileName(OpenDialog.FileName)+
                            ', Sprites:'+Inttostr(Counter);
      DtmImageDotRGBForm.Showmodal;
      DtmImageDotRGBForm.Release;
      SetLength(Array3D, 0);
    end;
  end;
end;
{==============================================================}
{==============================================================}
procedure TDTMform.RIFImageViewer1Click(Sender: TObject);
begin
  RIFImageViewerForm.Show;
end;















end.
