// USMD Stuff unit demo by Mrqzzz (mrqzzz@yahoo.it)
// ------------------------------------------------
// Just a demo of my little USMDStuff.pas unit
// Feel free to use it.

unit dtmSmdQcFrm;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  GLVectorFileObjects, GLMisc, GLScene,
  StdCtrls, GLObjects, GLTexture,
  ExtCtrls, GLCadencer, GLWin32Viewer,
  GLGraph,VectorTypes, Spin, ComCtrls,
  Buttons;

type
  TdtmSmdQcForm = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLCamera1: TGLCamera;
    GLLightSource1: TGLLightSource;
    Actor1: TGLActor;
    DummyCube1: TGLDummyCube;
    GLMaterialLibrary1: TGLMaterialLibrary;
    Timer1: TTimer;
    GLCadencer1: TGLCadencer;
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    XYZGrid1: TGLXYZGrid;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    cboAnimations: TComboBox;
    Cube1: TGLCube;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    TrackBar4: TTrackBar;
    TrackBar5: TTrackBar;
    TrackBar6: TTrackBar;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Cube2: TGLCube;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    TrackBar7: TTrackBar;
    Label14: TLabel;
    Label1: TLabel;
    TrackBar8: TTrackBar;
    Label15: TLabel;
    ViewMdlBtn: TSpeedButton;
    HelpBtn: TSpeedButton;
    ExitBtn: TSpeedButton;

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure ViewMdlBtnClick(Sender: TObject);
procedure DoCcOpen(const fileName : String);    
    procedure HelpBtnClick(Sender: TObject);

    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
    procedure Button1Click(Sender: TObject);
    procedure cboAnimationsChange(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure Panel2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);

  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    baseAnimation : String;
    mx, my : Integer;


    AlreadyLoaded : boolean;

    // The Spine Rotations
    aaS,bbS,ccS : single;

    // The Head Rotations
    aaH,bbH,ccH : single;

    // The Bones we want to Rotate
    BoneIndex_Spine,BoneIndex_Head : integer;

  end;

var
  dtmSmdQcForm: TdtmSmdQcForm;

implementation

uses USMDStuff, dtmSmdLoadMdlFrm, dtmfrm, dtmPOFvar, dtmGlobals;

{$R *.DFM}

procedure TdtmSmdQcForm.FormCreate(Sender: TObject);
begin
  top := dtmSmdQcFormY;
  left := dtmSmdQcFormX;
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
end;
procedure TdtmSmdQcForm.FormShow(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  dtmSmdQcForm.Cursor:=crDefault;
end;

procedure TdtmSmdQcForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  dtmSmdQcFormY := dtmSmdQcForm.top;
  dtmSmdQcFormX := dtmSmdQcForm.left;
  DoSaver;
end;

procedure TdtmSmdQcForm.FormHide(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
end;
procedure TdtmSmdQcForm.ExitBtnClick(Sender: TObject);
begin
  Close;  {ModalResult:=mrOK;}
end;

procedure TdtmSmdQcForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(8000);
end;

procedure TdtmSmdQcForm.ViewMdlBtnClick(Sender: TObject);
begin
  dtmSmdLoadMdlForm.showmodal;
end;

procedure TdtmSmdQcForm.CheckBox1Click(Sender: TObject);
begin
   Actor1.OverlaySkeleton:=CheckBox1.Checked;
end;

procedure TdtmSmdQcForm.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TdtmSmdQcForm.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then
   begin
      Actor1.Roll(mx-x);
   end;
   mx:=x; my:=y;
end;

procedure TdtmSmdQcForm.Timer1Timer(Sender: TObject);
begin
   Caption:=Format('%.1f FPS', [GLSceneViewer1.FramesPerSecond]);
   GLSceneViewer1.ResetPerformanceMonitor;
end;

procedure TdtmSmdQcForm.GLCadencer1Progress(Sender: TObject; const deltaTime,
  newTime: Double);
begin
     if AlreadyLoaded then
     begin
          // IDEAL SPINE ROTATION
          GetIdealBoneRotationLookingAt(Actor1,BoneIndex_Spine,0,Cube1.AbsolutePosition,aaS,bbS,ccS);
          // ROTATE SPINE
          RotateBone(Actor1,BoneIndex_Spine,aaS,bbS,ccS,Trackbar7.Position / 100,2,-2,1,-1,1,-1);

          // IDEAL HEAD ROTATION
          GetIdealBoneRotationLookingAt(Actor1,BoneIndex_Head,0,Cube2.AbsolutePosition,aaH,bbH,ccH);
          // ROTATE HEAD
          RotateBone(Actor1,BoneIndex_Head,aaH-aaS,bbH-bbS,ccH-ccS,Trackbar8.Position / 100,2,-2,1,-1,1,-1);

     end;
     GLScene1.NotifyChange(nil);
end;

{(Use Milkshape to decompile a H-L SMD character)
http://www.milkshape3d.com}
{(Loading will be slow if there are many animations)}
procedure TdtmSmdQcForm.Button1Click(Sender: TObject);
begin
  OpenDialog1.Filter := 'lifeless (*.qc)|*.qc';
  OpenDialog1.InitialDir := TigerPath;
  OpenDialog1.Filename:='*.qc';
  if OpenDialog1.Execute then
     DoCcOpen(OpenDialog1.FileName);
end;
procedure TdtmSmdQcForm.DoCcOpen(const fileName : String);
var
   t: integer;
begin
       TigerPath:=ExtractFilePath(FileName);
       Application.ProcessMessages;
       dtmSmdQcForm.Cursor:=crHourGlass;
       Timer1.Enabled:=True;
       GLCadencer1.Enabled:=True;
       // LOAD THE Filename, into Actor1, with MODEL, + with ANIMATIONS
       LoadQC(FileName,Actor1,True,True);

     BoneIndex_Spine := GetBoneIndexByName(Actor1,'Bip01 Spine');
     BoneIndex_Head := GetBoneIndexByName(Actor1,'Bip01 Head');

     for t := 1 to Actor1.Animations.Count-1 do
     begin
          cboAnimations.Items.Add(Actor1.Animations[t].Name);
     end;

     Actor1.OverlaySkeleton:=False;
     Actor1.Interval := 50;

     Actor1.SwitchToAnimation(Actor1.Animations[1]);

     cboAnimations.ItemIndex := cboAnimations.Items.IndexOf(Actor1.Animations[1].Name);

     AlreadyLoaded := True;

     dtmSmdQcForm.Cursor:=crDefault;

end;


procedure TdtmSmdQcForm.cboAnimationsChange(Sender: TObject);
begin
  Timer1.Enabled:=True; {Just in case its been hiding...}
  GLCadencer1.Enabled:=True;
  Actor1.SwitchToAnimation(cboAnimations.Text,true);
end;

procedure TdtmSmdQcForm.TrackBar1Change(Sender: TObject);
begin
     Cube1.Position.SetPoint(TrackBar1.Position,TrackBar2.Position,TrackBar3.Position);
end;

procedure TdtmSmdQcForm.TrackBar4Change(Sender: TObject);
begin
     Cube2.Position.SetPoint(TrackBar4.Position,TrackBar5.Position,TrackBar6.Position);
end;

procedure TdtmSmdQcForm.Panel2MouseMove(Sender: TObject;
Shift: TShiftState; X,  Y: Integer);
var
   Tb1,Tb2 : TTrackBar;
begin
     // JUST AN EASY WAY FOR MOVING THE CUBES AROUND...
     // -----------------------------------------------
   if Sender= Panel2 then
   begin
        Tb2 := TrackBar1;
        Tb1 := TrackBar2;
   end
   else
   if Sender= Panel3 then
   begin
        Tb2 := TrackBar2;
        Tb1 := TrackBar3;
   end
   else
   if Sender= Panel4 then
   begin
        Tb2 := TrackBar4;
        Tb1 := TrackBar5;
   end
   else
   begin
        Tb2 := TrackBar5;
        Tb1 := TrackBar6;
   end;


   if Shift<>[] then
   begin
        Tb1.Position := (TPanel(Sender).Width div 2)-X;
        Tb2.Position := (TPanel(Sender).Height div 2)-Y;
   end;
end;





end.
