{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmRIFImageViewerFrm;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  Buttons, GR32, GR32_Layers, GR32_Image,
  dtmRasterImageFile,  {RIF file access}
  ToolWin, ComCtrls, StdCtrls, ExtCtrls;

type
  TRIFImageViewerForm = class(TForm)
    RifImage: TImage32;
    StatusBar: TStatusBar;
    ControlBar1: TControlBar;
    ToolBar2: TToolBar;
    HelpBtn: TSpeedButton;
    CreateBtn: TSpeedButton;
    ToolBar1: TToolBar;
    GreenCBox: TComboBox;
    BlueCBox: TComboBox;
    RedCBox: TComboBox;
    OpenDialog: TOpenDialog;
    OpenBtn: TSpeedButton;
    BandsLabel: TLabel;
    XSizeLabel: TLabel;
    YSizeLabel: TLabel;
    OpenIpcfgFileBtn: TSpeedButton;
    LAMap: TLabel;
    SetBtn: TSpeedButton;
    procedure RifImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
    procedure RifImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer; Layer: TCustomLayer);
    procedure RifImageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);

    procedure HelpBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
procedure PrepareRifBitmap;
procedure DoRifLoad(AFilename:String);
    procedure OpenIpcfgFileBtnClick(Sender: TObject);
procedure DoLoad(AFilename:String);
procedure PrepareBitmap;
    procedure CreateBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure SetBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);

  private
    { Private declarations }
    bmpTile : TBitmap32;  {Used for each small tile}
                          {big tiled image is Paintbox's}
{    ImagesLoaded: array of string; }
    ImageLayersLoaded,
    curX, curY,{ Losx, Losy,} mx, my : Integer;{Mouse locations}
    isRIFLoaded:Boolean;
  public
    { Public declarations }
  end;

var
  RIFImageViewerForm: TRIFImageViewerForm;

implementation

{$R *.DFM}

uses
dtmPOFvar,
dtmGlobals, dtmHtfFrm;

procedure TRIFImageViewerForm.FormCreate(Sender: TObject);
begin
  top  := RIFImageViewerFormY;
  left := RIFImageViewerFormX;
  isRIFLoaded:=False;
  RifImage.SetupBitmap;
  bmpTile:=TBitmap32.Create;
end;

procedure TRIFImageViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  RIFImageViewerFormY := RIFImageViewerForm.top;
  RIFImageViewerFormX := RIFImageViewerForm.left;
  DoSaver;
end;
procedure TRIFImageViewerForm.FormDestroy(Sender: TObject);
begin
  rif.Free;
  bmpTile.Free;
end;
procedure TRIFImageViewerForm.CreateBtnClick(Sender: TObject);
begin
  HtfForm.show;
end;

procedure TRIFImageViewerForm.RifImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
  Layer: TCustomLayer);
begin
    RifImage.Cursor:=crSizeAll;
    mx:=X;
    my:=Y;
end;

procedure TRIFImageViewerForm.RifImageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
var
   tileIdx, n : Integer;
   tileInfo : PImageTileInfo;
begin
    StatusBar.Panels[0].Text:=' X: '+IntToStr(x);
    StatusBar.Panels[1].Text:=' Y: '+IntToStr(y);
  if (ssLeft in shift){Shift<>[]} then    {??}
  begin
    curX:=curX-(x-mx);
    curY:=curY-(y-my);
    StatusBar.Panels[4].Text:=' N/Ax'+IntToStr(curX);
    StatusBar.Panels[5].Text:=' N/Ay'+IntToStr(curY);
    mx:=x;
    my:=y;
{    PrepareBitmap;}
{    RifImage.Refresh;}
  end;
  if Assigned(rif) then
  begin
    x:=x+curX;
    y:=y+curY;
    StatusBar.Panels[2].Text:=' Band1: '+IntToStr(rif.XYImage(rif.SizeBands2, x, y));
    tileInfo:=rif.XYTileInfo(rif.SizeBands2,x, y);
    if Assigned(tileInfo) then
    begin
      tileIdx:=rif.IndexOfTile(tileInfo);
      StatusBar.Panels[3].Text:=' Tile: '+IntToStr(tileIdx);
      n:=rif.TileCompressedSize(tileIdx)+SizeOf(TImageTileInfo);
      StatusBar.Panels[4].Text:=Format(' %.2f kB (%.0f %%)',
                                          [n/1024, 100-100*n/(rif.TileSize*rif.TileSize*rif.SizeBands2)]);
      StatusBar.Panels[5].Text:=Format(' Tile average: %d, range: [%d; %d])',
                                          [tileInfo.average, tileInfo.min, tileInfo.max]);
    end else
    begin
      StatusBar.Panels[3].Text:=' Tile: N/A';
      StatusBar.Panels[4].Text:=' N/A';
      StatusBar.Panels[5].Text:=' N/A';
    end;
  end;{if rif}
end;

procedure TRIFImageViewerForm.RifImageMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
  Layer: TCustomLayer);
begin
  if Assigned(rif) then PrepareRifBitmap else
     if isRIFLoaded then PrepareBitmap;
  RifImage.Cursor:=crDefault;
end;

procedure TRIFImageViewerForm.FormResize(Sender: TObject);
begin
   begin      { 479    471   w471              380 353 h279 }
     RifImage.Bitmap.SetSize(RIFImageViewerForm.ClientWidth,
                            (RIFImageViewerForm.ClientHeight-74));
     if Assigned(rif) then PrepareRifBitmap else
     if isRIFLoaded then PrepareBitmap;
   end;
end;

procedure TRIFImageViewerForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(14000);
end;

procedure TRIFImageViewerForm.OpenBtnClick(Sender: TObject);
begin
  OpenDialog.Filter:= 'RIF File (*.rif)|*.rif';
  OpenDialog.FileName:= '*.rif';
  OpenDialog.InitialDir:=HTFPath;
  if OpenDialog.Execute then
  begin
    HTFPath:=ExtractFilePath(OpenDialog.FileName);
    DoRifLoad(OpenDialog.FileName);
  end;
end;

procedure TRIFImageViewerForm.DoRifLoad(AFilename:String);
var i:Integer;
Begin
  isRIFLoaded:=False;
  rif.Free;
  rif:=TImageTileFile.Create(AFilename);
    {New RIF... new all}
  Caption:='RIF Image Viewer : '+ExtractFileName(AFilename);
  XSizeLabel.Caption:=Inttostr(rif.SizeX);
  YSizeLabel.Caption:=' '+Inttostr(rif.SizeY);
  BandsLabel.Caption:=' '+Inttostr(rif.SizeBands2)+' ';
  ImageLayersLoaded:=Strtoint(trim(BandsLabel.Caption));
  curX:=0;
  curY:=0;
  BlueCBox.Items.Clear;
         for i:=1 to rif.SizeBands2 do
           BlueCBox.Items.Add('Band '+Inttostr(i));
  RedCBox.Items.Clear;
  GreenCBox.Items.Clear;
  for i := 0 to rif.SizeBands2-1  do
  begin
    RedCBox.Items.Add(BlueCBox.Items[i]);
    GreenCBox.Items.Add(BlueCBox.Items[i]);
  end;
  RedCBox.ItemIndex := 0;{Band 1}
  GreenCBox.ItemIndex := 0;
  BlueCBox.ItemIndex := 0;
  isRIFLoaded:=True;
  Application.ProcessMessages;
  PrepareRifBitmap;
End;
procedure TRIFImageViewerForm.PrepareRifBitmap;
var
  R,G,B:Byte;
  Bands, Ri,Gi,Bi,i, sex, tx, ty : Integer;
  RifscanLine : PColor32Array;
  tileInfo : PImageTileInfo;
  dataRow : PByteArray;
  tile : PImageTile;
  start, lap, stop, htfTime, drawTime, freq : Int64;
  tileList : TList;
begin
    sex:=RifImage.Width;
    RifImage.Bitmap.Clear(Color32(MapBacksColor));
    if not Assigned(rif) then Exit;
    if not isRIFLoaded then Exit;
    Ri:=RedCBox.ItemIndex;
    Gi:=GreenCBox.ItemIndex;
    Bi:=BlueCBox.ItemIndex;
    Bands:=rif.SizeBands2;
    drawTime:=0;
    tileList:=TList.Create;
    try
      QueryPerformanceCounter(start);
      rif.TilesInRect(rif.SizeBands2 ,curX, curY, curX+sex-1,
                      curY+RifImage.Bitmap.Height-1, tileList);
      QueryPerformanceCounter(stop);
      htfTime:=stop-start;

      for i:=0 to tileList.Count-1 do
      begin
        tileInfo:=PImageTileInfo(tileList[i]);
        QueryPerformanceCounter(start);
        tile:=rif.GetTile(tileInfo.left, tileInfo.top);
        QueryPerformanceCounter(lap);
        bmpTile.Width:=tileinfo.width;
        bmpTile.Height:=tileInfo.height;
        for ty:=0 to tileInfo.height-1 do
        begin
          RifscanLine:=bmpTile.ScanLine[ty];
          dataRow:=@tile.data[ty*tileInfo.width*Bands];
          for tx:=0 to tileInfo.width-1 do
          begin
            R:=dataRow[tx*Bands+Ri];
            G:=dataRow[tx*Bands+Gi];
            B:=dataRow[tx*Bands+Bi];
            RifscanLine[tx]:=Color32(R,G,B);
          end;
        end;

        RifImage.Bitmap.Draw(tileInfo.left-curX, tileInfo.top-curY, bmpTile);

        QueryPerformanceCounter(stop);
        htfTime:=htfTime+lap-start;
        drawTime:=drawTime+stop-lap;
      end;
      {if LayersLoaded>0 then
      begin
        TMinOffX:= curX;
        TMinOffY:= curY;
        DVDORedraw;
      End;}
      {Tile Grid Lines}
      {if TBGrid.Down then
      begin
        for i:=0 to tileList.Count-1 do with PHeightTileInfo(tileList[i])^ do
        begin
          Image321.Bitmap.FrameRectS(
          left-curX,
          top-curY,
          left+width-curX+1,
          top+height-curY+1,
          Color32(MapGridsColor));
        end;
      end;}
      {LatLong Grid Lines}
      {if TLLGrid.Down then
      begin

      end;}

    finally
      tileList.Free;
    end;

    QueryPerformanceFrequency(freq);
    LAMap.Caption:=Format(' %d x %d - %.1f ms RIF - %.1fms Draw ',
                         [rif.SizeX, rif.SizeY,
                          1000*htfTime/freq,
                          1000*drawTime/freq]);
End;



procedure TRIFImageViewerForm.OpenIpcfgFileBtnClick(Sender: TObject);
Begin
  OpenDialog.Filter:= 'ImagePack Configuration (*.ipcfg)|*.ipcfg';
  OpenDialog.InitialDir:=ProgramPath;
  OpenDialog.Filename:='*.ipcfg';
  if OpenDialog.Execute then
  begin
    ProgramPath:=ExtractFilePath(OpenDialog.FileName);
    DoLoad(OpenDialog.FileName);
  end;
end;
procedure TRIFImageViewerForm.DoLoad(AFilename:String);
var
   i : Integer;
   SS:String;
   sl, sg : TStringList;
begin
  isRIFLoaded:=False;
  BlueCBox.Items.Clear;
  sl:=TStringList.Create;
  sl.LoadFromFile(aFileName);
  with sl do
  begin
    XSizeLabel.Caption:=Values['WorldSizeX'];
    YSizeLabel.Caption:=' '+Values['WorldSizeY'];
    BandsLabel.Caption:=' '+Values['Bands']+' ';
    ImageLayersLoaded:=Strtoint(trim(BandsLabel.Caption));
    ImagePath:=Extractfilepath(Values['ImagePath']);
    sg:=TStringList.Create;
    sg.CommaText:=Values['BandNames'];
    for i:=0 to sg.Count-1 do
    begin
      SS:= copy(sg[i],1,pos(',',sg[i])-1);
      BlueCBox.Items.Add(SS);
    end;
    sg.Free;
  end;
  sl.Free;
  {New RIF... new all}
  Caption:='RIF Image Viewer : '+ExtractFileName(AFilename);
  curX:=0;
  curY:=0;
  RedCBox.Items.Clear;
  GreenCBox.Items.Clear;
  for i := 0 to ImageLayersLoaded-1  do
  begin
    RedCBox.Items.Add(BlueCBox.Items[i]);
    GreenCBox.Items.Add(BlueCBox.Items[i]);
  end;
  RedCBox.ItemIndex := 0;
  GreenCBox.ItemIndex := 0;
  BlueCBox.ItemIndex := 0;
  isRIFLoaded:=True;
  Application.ProcessMessages;
  PrepareBitmap;
End;


{==============================================================}
procedure TRIFImageViewerForm.PrepareBitmap;
var
  R,G,B:Byte;
  WideX, tx, ty : Integer;
  scanLine : PColor32Array;
  Rfa,Gfa,Bfa:File of Byte;
  Rfs,Gfs,Bfs:String;
begin
  RifImage.Cursor:=crHourGlass;
  RifImage.Bitmap.Clear(Color32(MapBacksColor));
  if not isRIFLoaded then Exit;
  Rfs:=ImagePath+  RedCBox.Items[RedCBox.ItemIndex];
  AssignFile(Rfa,Rfs);
  Reset(Rfa);
  Gfs:=ImagePath+ GreenCBox.Items[GreenCBox.ItemIndex];
  AssignFile(Gfa,Gfs);
  Reset(Gfa);
  Bfs:=ImagePath+ BlueCBox.Items[BlueCBox.ItemIndex];
  AssignFile(Bfa,Bfs);
  Reset(Bfa);
  WideX:=Strtoint(XSizeLabel.Caption);
  If curX < 0 then curX:=0;
  If curX+RifImage.Width > Strtoint(XSizeLabel.Caption) then curX:=Strtoint(XSizeLabel.Caption)-RifImage.Width;
  If curY < 0 then curY:=0;
  If curY+RifImage.Height > Strtoint(YSizeLabel.Caption) then curY:=Strtoint(XSizeLabel.Caption)-RifImage.Height;

  for ty:=0 to RifImage.height-1 do
  begin
    scanLine:=RifImage.Bitmap.ScanLine[ty];
    for tx:=0 to RifImage.Width-1 do
    begin
      seek(Rfa,((curX+tx)+  ((curY+ty)*WideX)));
      BlockRead(Rfa,R,1);
      seek(Gfa,((curX+tx)+  ((curY+ty)*WideX)));
      BlockRead(Gfa,G,1);
      seek(Bfa,((curX+tx)+  ((curY+ty)*WideX)));
      BlockRead(Bfa,B,1);
      scanLine[tx]:=Color32(R,G,B);
    end;
  end;
  CloseFile(Rfa);
  CloseFile(Gfa);
  CloseFile(Bfa);
  RifImage.Cursor:=crDefault;
End;
{==============================================================}
procedure TRIFImageViewerForm.SetBtnClick(Sender: TObject);
begin
  if Assigned(rif) then PrepareRifBitmap else
     if isRIFLoaded then PrepareBitmap;
end;



end.
