{    muxed by Ivan Lee Herring, Jul-Aug 2002
    Outside of Globe : Planet Textures
    Inside Sphere : 180x180 images ..
    V 360x180
    Inside Cylinder: Panoramic (wide) 180x60 vertical images}
{
  Simple spherical panorama viewer using GLScene
  The sample input image is by Philippe Hurbain. http://philohome.free.fr/
  Resources on how to make your own spherical or cylindrical panorama:
    http://www.fh-furtwangen.de/~dersch/
    http://www.panoguide.com/
  Why IPIX patents regarding use of fisheye photos are questionable:
    http://www.worldserver.com/turk/quicktimevr/fisheye.html}

{: This sample illustrates basic user-driven camera movements.<p>
	I'm using the GLScene built-in camera movement methods. The camera object is
	a child of its target dummy cube (this means that the camera is translated
	when its target is translate, which is good for flyover/scrolling movements).<p>

	Movements in this sample are done by
  moving the mouse with a button pressed,
  left button will translate the dummy cube (and the camera),
	right button will rotate the camera around the target,
  shift+right will rotate the object in camera's axis.<br>

      // left button with shift rotates the object

   		// left button without shift changes camera angle
	   	// (we're moving around the parent and target dummycube)
      
      // right button moves our target and parent dummycube
	'7', '9' rotate around the X vector (in red, absolute).<br>
	'4', '6' rotate around the Y vector (in green, absolute).<br>
	'1', '3' rotate around the Z vector (in blue, absolute).<br>
}
unit dtmPanVizFrm;

interface

uses
  Windows, Forms, GLScene, GLObjects, GLMisc, SysUtils,
  Classes, Controls, Keyboard,
  GLWin32Viewer, GLTexture,
  Dialogs, ExtDlgs, StdCtrls, ExtCtrls, ComCtrls,
  Buttons, GLCadencer;

type
  TdtmPanVizForm = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLCamera1: TGLCamera;
    GLLightSource1: TGLLightSource;
    DummyCube1: TGLDummyCube;
    Sphere1: TGLSphere;
    Cylinder1: TGLCylinder;
    GLMaterialLibrary1: TGLMaterialLibrary;
    Panel1: TPanel;
    FocalLabel: TLabel;
    DepthLabel: TLabel;
    ExitBtn: TSpeedButton;
    HelpBtn: TSpeedButton;
    BtnLoad: TSpeedButton;
    TrackBar1: TTrackBar;
    PanTypeRG: TRadioGroup;
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;
    OpenPictureDialog1: TOpenPictureDialog;
    TrackBar4: TTrackBar;
    DistanceLabel: TLabel;
    SizeLabel: TLabel;
    GLCadencer1: TGLCadencer;
    LabelPitch: TLabel;
    LabelYaw: TLabel;
    ShowAxesCB: TCheckBox;
    Edit1: TEdit;
    ResetDefaultsBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
procedure ShowDown(const fileName : String);
    procedure BtnLoadClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ExitBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);

    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
	 procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
procedure HandleKeys(deltaTime: Double);
procedure PanCameraAround(dx, dy : single);

    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);

    procedure PanTypeRGClick(Sender: TObject);
    procedure ShowAxesCBClick(Sender: TObject);
    procedure ResetDefaultsBtnClick(Sender: TObject);
  private
    { Private declarations }
	 mdx, mdy : Integer;
   pitch, yaw : single; // in degree
  public
    { Public declarations }
  end;

var
  dtmPanVizForm: TdtmPanVizForm;

implementation

{$R *.DFM}

uses Geometry, Math, dtmPOFvar, dtmGlobals;

procedure TdtmPanVizForm.FormCreate(Sender: TObject);
begin
  top := dtmPanImageFormY;
  left := dtmPanImageFormX;
  GLCadencer1.Enabled:=False;
end;
procedure TdtmPanVizForm.FormShow(Sender: TObject);
begin
  GLCadencer1.Enabled:=True;
  NoGLRunning:=False;
end;

procedure TdtmPanVizForm.ShowDown(const fileName : String);
begin
      DLGPath:=ExtractFilePath(fileName);
      Application.processmessages;
      GLMaterialLibrary1.Materials[0].Material.Texture.Image.LoadFromFile(fileName);
      {Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);}
      dtmPanVizForm.Caption:= 'Panaviewer'
                    + ExtractFileName(fileName);
end;

procedure TdtmPanVizForm.BtnLoadClick(Sender: TObject);
begin
 OpenPictureDialog1.InitialDir:=DLGPath;
  OpenPictureDialog1.FileName:='*.jpg';
  with OpenPictureDialog1 do
    if Execute then
    begin
      DLGPath:=ExtractFilePath(OpenPictureDialog1.FileName);
      Application.processmessages;
      GLMaterialLibrary1.Materials[0].Material.Texture.Image.LoadFromFile(OpenPictureDialog1.FileName);
      {Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);}
      dtmPanVizForm.Caption:= 'Panaviewer'
                    + ExtractFileName(OpenPictureDialog1.FileName);
    end;
end;

procedure TdtmPanVizForm.FormHide(Sender: TObject);
begin
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
end;
procedure TdtmPanVizForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  NoGLRunning:=True;
  GLCadencer1.Enabled:=False;
  dtmPanImageFormY := dtmPanVizForm.top;
  dtmPanImageFormX := dtmPanVizForm.left;
  DoSaver;
end;

procedure TdtmPanVizForm.ExitBtnClick(Sender: TObject);
begin
  NoGLRunning:=True;
  Close;
end;

procedure TdtmPanVizForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(9000);
end;

procedure TdtmPanVizForm.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// store mouse coordinates when a button went down
	mdx:=x;
  mdy:=y;
end;

procedure TdtmPanVizForm.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
	idx, idy,	dx, dy : Integer;
	v : TVector;
  ddx,ddy,f:Single;
begin
	// calculate delta since last move or last mousedown
	dx:=mdx-x;
  dy:=mdy-y;
  idx:=mdx;
  idy:=mdy;
  mdx:=x;
  mdy:=y;
  if ssLeft in Shift then
  begin
    if (PanTypeRG.itemindex=3) then
    begin
    { Edit1.Text:=inttostr(dx);}
     f:=0.2*400/GLCamera1.FocalLength;
     ddx:=(x-idx)*f;
     ddy:=(y-idy)*f;
     PanCameraAround(ddx, ddy);
    end else
    if ssShift in Shift then
    begin
         // left button with shift rotates the object
         // (rotation happens around camera's axis)
      GLCamera1.RotateObject(DummyCube1, dy, dx);
      Case PanTypeRG.itemindex of
	      0:GLCamera1.RotateObject(Cylinder1, dy, dx);
        else
        GLCamera1.RotateObject(Sphere1, dy, dx);
      end;
    end else
  if ssCtrl in Shift then
  {if Shift=[ ssRight] then}
  begin
		// right button moves our target and parent dummycube
		v:=GLCamera1.ScreenDeltaToVectorXY(dx, -dy,
							0.12*GLCamera1.DistanceToTarget/GLCamera1.FocalLength);
		DummyCube1.Position.Translate(v);
		Sphere1.Position.Translate(v);
		Cylinder1.Position.Translate(v);
		// notify camera that its position/target has been changed
		GLCamera1.TransformationChanged;
	end else
    begin
   		// left button without shift changes camera angle
	   	// (we're moving around the parent and target dummycube)
		  GLCamera1.MoveAroundTarget(dy, dx)
    end;
	end;

  GLLightSource1.Position.X:=GLCamera1.Position.X{*10};
  GLLightSource1.Position.Y:=GLCamera1.Position.Y{*10};
  GLLightSource1.Position.Z:=GLCamera1.Position.Z{*10};
  GLLightSource1.SpotDirection.X:=GLCamera1.Direction.X{*10};
  GLLightSource1.SpotDirection.Y:=GLCamera1.Direction.Y{*10};
  GLLightSource1.SpotDirection.Z:=GLCamera1.Direction.Z{*10};
  Application.ProcessMessages;
end;

procedure TdtmPanVizForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Case PanTypeRG.itemindex of
    0:begin
      with Cylinder1 do case Key of
      '7' : RotateAbsolute(-15,  0,  0);
      '9' : RotateAbsolute(+15,  0,  0);
      '4' : RotateAbsolute(  0,-15,  0);
      '6' : RotateAbsolute(  0,+15,  0);
      '1' : RotateAbsolute(  0,  0,-15);
      '3' : RotateAbsolute(  0,  0,+15);
      end;
    end;
    else begin
      with Sphere1 do case Key of
      '7' : RotateAbsolute(-15,  0,  0);
      '9' : RotateAbsolute(+15,  0,  0);
      '4' : RotateAbsolute(  0,-15,  0);
      '6' : RotateAbsolute(  0,+15,  0);
      '1' : RotateAbsolute(  0,  0,-15);
      '3' : RotateAbsolute(  0,  0,+15);
      end;
    end;
  end;{case}
end;

procedure TdtmPanVizForm.GLCadencer1Progress(Sender: TObject;
  const deltaTime, newTime: Double);
begin
  HandleKeys(deltaTime);
end;
{procedure TdtmPanVizForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  key:=0; // all keys handled by Form
end;}

procedure TdtmPanVizForm.HandleKeys(deltaTime: Double);
const step_size = 20;
var
   delta : Single;
   dx, dy : Single;
begin
  if PanTypeRG.itemindex=3 then
  begin
    delta:=step_size * 400/GLCamera1.FocalLength * deltaTime;
    dx:=0;
    dy:=0;
    if IsKeyDown(VK_LEFT)  then dx:=dx+delta;
    if IsKeyDown(VK_UP)    then dy:=dy+delta;
    if IsKeyDown(VK_RIGHT) then dx:=dx-delta;
    if IsKeyDown(VK_DOWN)  then dy:=dy-delta;
    PanCameraAround(dx, dy);
     {Edit1.Text:=floattostr(dx); }
  end;
end;

procedure TdtmPanVizForm.PanCameraAround(dx, dy : single);
begin
  pitch:=pitch+dy;
  yaw:=yaw-dx;
  if pitch>90 then pitch:=90;
  if pitch<-90 then pitch:=-90;
  if yaw>360 then yaw:=yaw-360;
  if yaw<0 then yaw:=yaw+360;
  {GLCamera1.RotateObject(Sphere1, dy, dx); }
  GLCamera1.Up.SetVector(0, 1, 0);
  GLCamera1.Direction.SetVector( sin(DegToRad(yaw)),
                                 sin(DegToRad(pitch)),
                                -cos(DegToRad(yaw)));
  labelPitch.caption:=format('Pitch: %3f', [pitch]);
  labelYaw.caption:=format('Yaw: %3f', [yaw]);
  GLLightSource1.Position.X:=GLCamera1.Position.X{*10};
  GLLightSource1.Position.Y:=GLCamera1.Position.Y{*10};
  GLLightSource1.Position.Z:=GLCamera1.Position.Z{*10};
  GLLightSource1.SpotDirection.X:=GLCamera1.Direction.X{*10};
  GLLightSource1.SpotDirection.Y:=GLCamera1.Direction.Y{*10};
  GLLightSource1.SpotDirection.Z:=GLCamera1.Direction.Z{*10};  
end;



procedure TdtmPanVizForm.TrackBar1Change(Sender: TObject);
begin
  GLCamera1.FocalLength:=TrackBar1.Position;
  FocalLabel.caption:=' f :'+Inttostr(Round(GLCamera1.FocalLength));
end;
procedure TdtmPanVizForm.TrackBar2Change(Sender: TObject);
begin
  GLCamera1.DepthOfView:=TrackBar2.Position;
  DepthLabel.caption:=' V :'+Inttostr(Round(GLCamera1.DepthOfView));
end;
procedure TdtmPanVizForm.TrackBar3Change(Sender: TObject);
var Into:Double;
begin
  Into:=(TrackBar3.Position/10);
  Cylinder1.TopRadius:=Into;
  Cylinder1.BottomRadius:=Into;
  Cylinder1.Height:=Into+1;
  Sphere1.Radius:=Into;
  SizeLabel.caption:=' S :'+Inttostr(Round(Sphere1.Radius));
end;
procedure TdtmPanVizForm.TrackBar4Change(Sender: TObject);
begin
  GLCamera1.Position.Z:=TrackBar4.Position;
  DistanceLabel.caption:=' D :'+Inttostr(TrackBar4.Position);
end;


procedure TdtmPanVizForm.PanTypeRGClick(Sender: TObject);
begin
  Case PanTypeRG.itemindex of
    0:
    begin
      Cylinder1.Visible:=True;
      Sphere1.Visible:=False;
      Sphere1.Direction.Z:=1;
      GLCamera1.Direction.Z:=1;
    end;
    1:
    begin
      Cylinder1.Visible:=False;
      Sphere1.NormalDirection:=ndOutside;
      Sphere1.Visible:=True;
      Sphere1.Direction.Z:=1;
      GLCamera1.Direction.Z:=1;
    end;
    2:
    begin
      Cylinder1.Visible:=False;
      Sphere1.NormalDirection:=ndInside;
      Sphere1.Visible:=True;
      Sphere1.Direction.Z:=-1;
      GLCamera1.Direction.Z:=-1;
    end;
    3:
    begin
      Cylinder1.Visible:=False;
      Sphere1.NormalDirection:=ndInside;
      Sphere1.Visible:=True;
      Sphere1.Direction.Z:=-1;
      GLCamera1.Direction.Z:=-1;
      {TrackBar4.Position:=0;
      GLCamera1.Position.Z:=TrackBar4.Position; }
    end;
  end;
end;


procedure TdtmPanVizForm.ShowAxesCBClick(Sender: TObject);
begin
  DummyCube1.ShowAxes := ShowAxesCB.Checked;
  DummyCube1.VisibleAtRunTime := ShowAxesCB.Checked;
end;



procedure TdtmPanVizForm.ResetDefaultsBtnClick(Sender: TObject);
begin
  GLCamera1.DepthOfView  := 1000;
  TrackBar2.Position:= 1000;
  GLCamera1.FocalLength :=400;
  TrackBar1.Position:=400;
  TrackBar3.Position:=20;
  GLCamera1.Position.Z:=14;
  TrackBar4.Position:=14;
  Cylinder1.TopRadius:=2;
  Cylinder1.BottomRadius:=2;
  Cylinder1.Height:=3;
  Sphere1.Radius:=2;
  PanTypeRG.itemindex :=1;
  Cylinder1.Visible:=False;
  Sphere1.NormalDirection:=ndOutside;
  Sphere1.Visible:=True;
  ShowAxesCB.Checked:=False;
  DummyCube1.ShowAxes := ShowAxesCB.Checked;
  DummyCube1.VisibleAtRunTime := ShowAxesCB.Checked;
  GLCamera1.Position.X:=0;
  GLCamera1.Position.Y:=0;
  GLCamera1.Direction.X:=0;
  GLCamera1.Direction.Y:=0;
  GLCamera1.Direction.Z:=1;
  GLLightSource1.Position.X:=GLCamera1.Position.X;
  GLLightSource1.Position.Y:=GLCamera1.Position.Y;
  GLLightSource1.Position.Z:=GLCamera1.Position.Z;
  GLLightSource1.SpotDirection.X:=GLCamera1.Direction.X;
  GLLightSource1.SpotDirection.Y:=GLCamera1.Direction.Y;
  GLLightSource1.SpotDirection.Z:=GLCamera1.Direction.Z;
  DummyCube1.Position.X:=0;
  DummyCube1.Position.Y:=0;
  DummyCube1.Position.Z:=0;
  DummyCube1.Direction.X:=0;
  DummyCube1.Direction.Y:=0;
  DummyCube1.Direction.Z:=1;
  DummyCube1.Up.X:=0;
  DummyCube1.Up.Y:=1;
  DummyCube1.Up.Z:=0;
  DummyCube1.RollAngle  :=0;
  DummyCube1.TurnAngle:=0;

  Sphere1.Position.X:=0;
  Sphere1.Position.Y:=0;
  Sphere1.Position.Z:=0;
  Sphere1.Direction.X:=0;
  Sphere1.Direction.Y:=0;
  Sphere1.Direction.Z:=1;
  Sphere1.Up.X:=0;
  Sphere1.Up.Y:=1;
  Sphere1.Up.Z:=0;
  Sphere1.RollAngle  :=0;
  Sphere1.TurnAngle:=0;

  Cylinder1.Position.X:=0;
  Cylinder1.Position.Y:=0;
  Cylinder1.Position.Z:=0;
  Cylinder1.Direction.X:=0;
  Cylinder1.Direction.Y:=0;
  Cylinder1.Direction.Z:=1;
  Cylinder1.Up.X:=0;
  Cylinder1.Up.Y:=1;
  Cylinder1.Up.Z:=0;
  Cylinder1.RollAngle  :=0;
  Cylinder1.TurnAngle:=0;
  pitch:=0;
  yaw:=0;
  GLCamera1.Up.X:=0;
  GLCamera1.Up.Y:=1;
  GLCamera1.Up.Z:=0;
  GLCamera1.Up.SetVector(0, 1, 0);
  GLCamera1.Direction.SetVector( sin(DegToRad(0)),
                                 sin(DegToRad(0)),
                                -cos(DegToRad(0)));
  labelPitch.caption:=format('Pitch: %3f', [pitch]);
  labelYaw.caption:=format('Yaw: %3f', [yaw]);
end;

{Camera
GLCamera1.TargetObject := ?;
GLCamera1.CameraStyle csPerspective csOrthogonal csOrtho2D csCustom
GLCamera1.DepthOfView  :=200;  1000
GLCamera1.Direction.X:=0;
GLCamera1.Direction.Y:=0;
GLCamera1.Direction.Z:=-1;  1
GLCamera1.FocalLength :=40;
GLCamera1.Position.X:=0;
GLCamera1.Position.Y:=0;
GLCamera1.Position.Z:=0;   14
GLCamera1.SceneScale :=1;
GLCamera1.Up.X:=0;
GLCamera1.Up.Y:=1;
GLCamera1.Up.Z:=0;}

{SPHERE
Behaviours (TGLBehaviours) SELECTION
Bottom  :=-90;
BottomCap ctNone ctCenter ctFlat
Sphere.Direction.X:=0;
Sphere.Direction.Y:=0;
Sphere.Direction.Z:=-1; 1
Effects (TGLObjectEffects) SELECTION
Material (TGLMaterial) BIG SELECTION allnormal
NormalDirection:=ndOutside   ndInside
Normals  nsFlat nsNone  nsSmooth
ObjectSorting  osInherited  osNone  osRenderBlendedLast  osRenderFarthestFirst
PitchAngle :=0;
Sphere.Position.X:=0;
Sphere.Position.Y:=0;
Sphere.Position.Z:=0;
Radius  :=2;
RollAngle  :=0;
Sphere.Scale.X:=1;
Sphere.Scale.Y:=1;
Sphere.Scale.Z:=1;
ShowAxes True False
Slices :=64;
Stacks :=16;
Start :=0;
Stop :=360;
Tag  :=0;
TagFloat :=0;
Top  :=90;
TopCap  ctNone  ctFlat    ctCenter
TransformationMode  tmLocal  tmParentNoPos  tmParentWithPos
TurnAngle:=0;
Sphere.Up.X:=0;
Sphere.Up.Y:=1;
Sphere.Up.Z:=0;
VisibilityCulling  vcHierarchical  vcInherited vcNone  vcObjectBased
Visible  True False
}
{
This loads the texture:

      SphereEarth.Material.Texture.Image.LoadFromFile (map_filename);

This sets the "quality", the number of segments used to map the sphere:

  case display_quality.Value of
    0: steps := 36;
    1: steps := 48;
    2: steps := 64;
    3: steps := 96;
    4: steps := 128;
    5: steps := 192;
  else
    steps := 48;
  end;
  SphereEarth.Slices := steps;   // Set the number of elements
  SphereEarth.Stacks := steps;   // comprising the Earth sphere.

.. and this turns the topography image on and off:

  with SphereEarth.Material do
    case RadioGroupTopography.ItemIndex of
      0: begin  // Turn off the texture and substitute bluish-green
         Texture.Disabled := True;
         FrontProperties.Ambient.AsWinColor := RGB (85, 113, 124);
         FrontProperties.Diffuse.AsWinColor := RGB (149, 200, 219);
         FrontProperties.Specular.AsWinColor := RGB (51, 51, 51);
         end;
      1: begin  // Turn on the texture and make the sphere grey
         Texture.Disabled := False;
         FrontProperties.Ambient.AsWinColor := grey (150);  // was 204
         FrontProperties.Diffuse.AsWinColor := grey (210);  // was 242
         FrontProperties.Specular.AsWinColor := grey (64);  // was 51
         end
    end;

}
end.

