{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{ Global Variables that are Stored : Program Options    }
{*******************************************************}
unit dtmPOFvar;

interface

uses   Sysutils{Filestuff},  Graphics;

type
  PrefRecord = record
  {This is my secret string ? as text?}
  PHiddenString: string[255]; {array [1..256] of Char;}
  PColor256Name, PTempName, PProLoaded,
  PProgramPath,    PVRMProgramPath,
  PILHProgram,     PVRGISPath,
  PRasterPath,     PDTMPath,    PThumbPath,
  PFractal3DPath,  PLifePath,   PSOSMAPPath,
  PDigitizerPath,  PVoicePath,
  PInfoString, PConfirmationString, PWarnString,
  PErrorString, PDoneString,
  PProjectPath, PProjectName, PMapName,  PMapsPath,
  PDemPath,     PHTFPath,     PTigerPath, PDxfPath,
  PVRMDatabase, PDLGPath,     PImagePath, PShapePath,
  PNoNamePath: string[255];
    PCurrentColor,    {PColorRef,}
    PMapBordersColor, PMapGridsColor,
    PMapDatasColor,   PMapBacksColor,
    PThumbColor: TColor;
    PThresholdBarPosition{500}, PIntervalBarPosition{100},
    PJoyCentroidX,  PJoyCentroidY,
    PContours,
    PThumbSize: Integer;
    PSlopeDirection,
    PCropXWide,PCropYTall,
    PColorreg: Integer;
    PStarted: TDateTime;
    PStartedNameNumber: string[25];
    PUseContourColors,
    PPrintBigChecked, PSkip32BitNotice, PUseThumbnails,
    PScaleBarVisible, PSkipIntroScreen, PFilePreviews,
    PErrorBeepOn, PWarningBeepOn ,PInfoBeepOn,
    PConfirmBeepOn, PCompletedBeepOn, PVoicesON :Boolean;
  {X Y Location of forms}
      PDTMformX, PDTMformY,      {Main}
      PPOFFormX, PPOFFormY,  {TPOFForm}
      PHtfFormX,  PHtfFormY,  {HtfFormX}
      PMessageX, PMessageY,  {Message box}
      PImageMakerFormX, PImageMakerFormY,
      PLineProfileFormX,PLineProfileFormY,
      PdtmDbFormX,PdtmDbFormY,
      PLegendFormX,PLegendFormY,
      PdtmEcotypeColorsFormX, PdtmEcotypeColorsFormY,
      PDtmGlBaseFormX,PDtmGlBaseFormY,
      PGLSViewerFormX,PGLSViewerFormY,
      PDtmJoyFormX,PDtmJoyFormY,
      PDTMGLFormX,PDTMGLFormY,
      PdtmSmdQcFormX,PdtmSmdQcFormY,
      PdtmSmdLoadMdlFormX,PdtmSmdLoadMdlFormY,
      PNavFormX,PNavFormY,
      PdtmPanImageFormX,PdtmPanImageFormY,
      PDtmImageRGBFormX,PDtmImageRGBFormY,
      PSystemInfoFormX,PSystemInfoFormY,
      PRIFImageViewerFormX,PRIFImageViewerFormY,
      PAboutX, PAboutY: Integer;

(*    PColorWhite, PColorBlack,
      PColorPURPLE, PColorDPURPLE, PColorYELLOW, PColorLYELLOW,
      PColor1, PColor2, PColor3, PColor4, PColor5, PColor6, PColor8,
      PColor7, PColor9,
      {PUVW, PVDW, PVMW, PVLW, PUDW, PUMW, PULW,} PDDW, PDMW, PDLW,
      PMDW, PMMW, PMLW, PLDW, PLMW, PLLW,
      {PUVC, PVDC, PVMC, PVLC, PUDC, PUMC, PULC,} PDDC, PDMC, PDLC,
      PMDC, PMMC, PMLC, PLDC, PLMC, PLLC,
      {PUVF, PVDF, PVMF, PVLF, PUDF, PUMF, PULF,} PDDF, PDMF, PDLF,
      PMDF, PMMF, PMLF, PLDF, PLMF, PLLF,
      {PUVA, PVDA, PVMA, PVLA, PUDA, PUMA, PULA,} PDDA, PDMA, PDLA,
      PMDA, PMMA, PMLA, PLDA, PLMA, PLLA,
      {PUVR, PVDR, PVMR, PVLR, PUDR, PUMR, PULR,} PDDR, PDMR, PDLR,
      PMDR, PMMR, PMLR, PLDR, PLMR, PLLR,
      {PUVT, PVDT, PVMT, PVLT, PUDT, PUMT, PULT,} PDDT, PDMT, PDLT,
      PMDT, PMMT, PMLT, PLDT, PLMT, PLLT,
      {PUVB, PVDB, PVMB, PVLB, PUDB, PUMB, PULB,} PDDB, PDMB, PDLB,
      PMDB, PMMB, PMLB, PLDB, PLMB, PLLB,
      {PUVU, PVDU, PVMU, PVLU, PUDU, PUMU, PULU,} PDDU, PDMU, PDLU,
      PMDU, PMMU, PMLU, PLDU, PLMU, PLLU,
      {PUVS, PVDS, PVMS, PVLS, PUDS, PUMS, PULS,} PDDS, PDMS, PDLS,
      PMDS, PMMS, PMLS, PLDS, PLMS, PLLS
      : TColor;       *)
  end;

  PrefFile = file of PrefRecord;
var
  PreRcd: PrefRecord;
var
  Colorreg: Integer;
  Started: TDateTime;
  StartedNameNumber: string;

      DTMformX, DTMformY,      {Main}
      POFFormX, POFFormY,  {TPOFForm}
      HtfFormX,HtfFormY,  {BFilefinder}
      MessageX, MessageY,  {Message box}
      ImageMakerFormX, ImageMakerFormY,
      LineProfileFormX,LineProfileFormY,
      LegendFormX, LegendFormY,
      dtmEcotypeColorsFormX, dtmEcotypeColorsFormY,
      dtmDbFormX,dtmDbFormY,
      dtmPanImageFormX,dtmPanImageFormY,
      DtmImageRGBFormX,DtmImageRGBFormY,
      NavFormX,NavFormY,
      SystemInfoFormX,SystemInfoFormY,
      DtmGlBaseFormX,DtmGlBaseFormY,
      DTMGLFormX,DTMGLFormY,
      GLSViewerFormX,GLSViewerFormY,
      DtmJoyFormX,DtmJoyFormY,
      RIFImageViewerFormX,RIFImageViewerFormY,
      dtmSmdQcFormX,dtmSmdQcFormY,
      dtmSmdLoadMdlFormX,dtmSmdLoadMdlFormY,
      AboutX, AboutY    : Integer;

  EditingColor, ClassStartPanelColor,
  BackgroundColor,
  HighlightColor,
  EditColor,
  CurrentColor: TColor;
{  ColorRef, }
    MapBordersColor, MapGridsColor,
    MapDatasColor, MapBacksColor,
    ThumbColor: TColor;(*
ColorWhite, ColorBlack, {CurrentColor,}
    ColorPURPLE, ColorDPURPLE, ColorYELLOW, ColorLYELLOW,
    Color1, Color2, Color3, Color4, Color5, Color6, Color8, Color7,
    Color9,
    {UVW, VDW, VMW, VLW, UDW, UMW, ULW,} DDW, DMW, DLW, MDW, MMW, MLW,
    LDW, LMW, LLW,
    {UVC, VDC, VMC, VLC, UDC, UMC, ULC,} DDC, DMC, DLC, MDC, MMC, MLC,
    LDC, LMC, LLC,
    {UVF, VDF, VMF, VLF, UDF, UMF, ULF,} DDF, DMF, DLF, MDF, MMF, MLF,
    LDF, LMF, LLF,
    {UVA, VDA, VMA, VLA, UDA, UMA, ULA,} DDA, DMA, DLA, MDA, MMA, MLA,
    LDA, LMA, LLA,
    {UVR, VDR, VMR, VLR, UDR, UMR, ULR,} DDR, DMR, DLR, MDR, MMR, MLR,
    LDR, LMR, LLR,
    {UVT, VDT, VMT, VLT, UDT, UMT, ULT,} DDT, DMT, DLT, MDT, MMT, MLT,
    LDT, LMT, LLT,
    {UVB, VDB, VMB, VLB, UDB, UMB, ULB,} DDB, DMB, DLB, MDB, MMB, MLB,
    LDB, LMB, LLB,
    {UVU, VDU, VMU, VLU, UDU, UMU, ULU,} DDU, DMU, DLU, MDU, MMU, MLU,
    LDU, LMU, LLU,
    {UVS, VDS, VMS, VLS, UDS, UMS, ULS,} DDS, DMS, DLS, MDS, MMS, MLS,
    LDS, LMS, LLS
    : TColor;            *)

    ThresholdBarPosition{500}, IntervalBarPosition{100},
    JoyCentroidX,  JoyCentroidY,
    SlopeDirection,    Contours,    ThumbSize: Integer;

 UseThumbnails, Skip32BitNotice,PrintBigChecked,FilePreviews,
  ErrorBeepOn, WarningBeepOn ,InfoBeepOn, SkipIntroScreen,
  UseContourColors,
{  Drawing,bZoomMousing,ImageDrawChecked, ViewMagniOn,
  AlreadyGone, ScaleBarVisible, MorphingOn, MorphingOnDrawing,}
  ConfirmBeepOn, CompletedBeepOn, VoicesON :Boolean;
  InfoString, ConfirmationString, WarnString,
  ErrorString, DoneString,

  Color256Name,  HiddenString,
  ProjectName, MapName,ProjectPath,  MapsPath,
  ProjectActorOtsFilename,
  ViewFileName, TempName{Passing name},
  TransSearchDir,ProgramPath,
  VRMProgramPath, ThumbPath,
  Fractal3DPath,  LifePath,  SOSMAPPath,
  DigitizerPath, VRGISPath, DTMPath,
  VoicePath, RasterPath, ILHProgram,
  HTFName,
  TigerPath,DemPath,HTFPath, ShapePath,
  DLGPath,DxfPath,VRMDatabase, ImagePath,   NoNamePath  :String;

procedure DoLoader;
procedure SetPreferences;
procedure DoSaver;
procedure GetPreferences;
procedure ResetToDefaults;

implementation

uses dtmErrMsg;

procedure DoLoader;
var P_File: PrefFile;
var PathS: string;
begin {}
  PathS := ExtractFilePath(ParamStr(0)) + 'dtm.pof';
  if FileExists(PathS) then
  begin
    AssignFile(P_File, PathS);
    Reset(P_File);
    if IoResult <> 0 then DoMessages(29986);
    {29986, "Failed writing dtm.pof File"}
    Read(P_File, PreRcd);
    CloseFile(P_File);
    SetPreferences;
  end else DoMessages(29985);
  {29985, "dtm.pof Does NOT Exist"}
end;


procedure SetPreferences;
begin {after loading}
  with PreRcd do begin
  HiddenString:=PHiddenString;
  Color256Name:=PColor256Name;
{  TempName:=PTempName;}
  ProgramPath:=PProgramPath;
  VRMProgramPath:=PVRMProgramPath;
  DigitizerPath:=PDigitizerPath;
  Fractal3DPath:=PFractal3DPath;
  LifePath:=PLifePath;
  SOSMAPPath:=PSOSMAPPath;
  NoNamePath:=PNoNamePath;
  VRGISPath:=PVRGISPath;
  DTMPath:=PDTMPath;
  VoicePath:=PVoicePath;
  RasterPath:=PRasterPath;
  ILHProgram:=PILHProgram;

  InfoString:=PInfoString;
  ConfirmationString:=PConfirmationString;
  WarnString:=PWarnString;
  ErrorString:=PErrorString;
  DoneString:=PDoneString;

  ProjectPath:=PProjectPath;
  ProjectName:=PProjectName;
  MapName:=PMapName;
  MapsPath:=PMapsPath;
  TigerPath:=PTigerPath;
  DemPath:=PDemPath;
  HTFPath:=PHTFPath;
  ShapePath:=PShapePath;
  DLGPath:=PDLGPath;
  DxfPath:=PDxfPath;
  VRMDatabase:=PVRMDatabase;
  ImagePath:=PImagePath;
  ErrorBeepOn:=PErrorBeepOn;
  WarningBeepOn :=PWarningBeepOn;
  InfoBeepOn :=PInfoBeepOn;
  ConfirmBeepOn:=PConfirmBeepOn;
  CompletedBeepOn:=PCompletedBeepOn;
  SkipIntroScreen:=PSkipIntroScreen;
{  ScaleBarVisible:=PScaleBarVisible;}
  Skip32BitNotice:=PSkip32BitNotice;
  FilePreviews:=PFilePreviews;
  VoicesON :=PVoicesON;
    Started := PStarted;
    PrintBigChecked:=PPrintBigChecked;
    StartedNameNumber := PStartedNameNumber;
    Colorreg := PColorreg;
{CropXWide:=PCropXWide;
CropYTall:=PCropYTall;}
    MapBordersColor:=PMapBordersColor;
    MapGridsColor:=PMapGridsColor;
    MapDatasColor:=PMapDatasColor;
    MapBacksColor:=PMapBacksColor;
      DTMformX:=PDTMformX;
      DTMformY:=PDTMformY;
      POFFormX:=PPOFFormX;
      POFFormY:=PPOFFormY;
      HtfFormY:=PHtfFormY;
      HtfFormX:=PHtfFormX;
      DTMGLFormX:=PDTMGLFormX;
      DTMGLFormY:=PDTMGLFormY;
      DtmGlBaseFormX:=PDtmGlBaseFormX;
      DtmGlBaseFormY:=PDtmGlBaseFormY;
      GLSViewerFormX:=PGLSViewerFormX;
      GLSViewerFormY:=PGLSViewerFormY;
      DtmJoyFormX:=PDtmJoyFormX;
      DtmJoyFormY:=PDtmJoyFormY;
      dtmSmdQcFormX:= PdtmSmdQcFormX;
      dtmSmdQcFormY:= PdtmSmdQcFormY;
      dtmSmdLoadMdlFormX:=PdtmSmdLoadMdlFormX;
      dtmSmdLoadMdlFormY:=PdtmSmdLoadMdlFormY;
      dtmPanImageFormX:=PdtmPanImageFormX;
      dtmPanImageFormY:=PdtmPanImageFormY;
      DtmImageRGBFormX:=PDtmImageRGBFormX;
      DtmImageRGBFormY:=PDtmImageRGBFormY;
      NavFormX:=PNavFormX;
      NavFormY:=PNavFormY;
      MessageX:=PMessageX;
      MessageY:=PMessageY;
      AboutX:=PAboutX;
      AboutY:=PAboutY;
      dtmDbFormX:=PdtmDbFormX;
      dtmDbFormY:=PdtmDbFormY;
      RIFImageViewerFormX:=PRIFImageViewerFormX;
      PRIFImageViewerFormY:=PRIFImageViewerFormY;
      ImageMakerFormX:=PImageMakerFormX;
      ImageMakerFormY:=PImageMakerFormY;
      LineProfileFormX:=PLineProfileFormX;
      LineProfileFormY:=PLineProfileFormY;
      LegendFormX:=PLegendFormX;
      LegendFormY:=PLegendFormY;
      dtmEcotypeColorsFormX:=PdtmEcotypeColorsFormX;
      dtmEcotypeColorsFormY:=PdtmEcotypeColorsFormY;
      SystemInfoFormX:=PSystemInfoFormX;
      SystemInfoFormY:=PSystemInfoFormY;
      UseThumbnails:=PUseThumbnails;
    ThumbColor:=PThumbColor;
    ThumbSize:=PThumbSize;
    ThumbPath:=PThumbPath;
    Contours:=PContours;
    SlopeDirection:=PSlopeDirection;
    UseContourColors:=PUseContourColors;
    ThresholdBarPosition{500}:=PThresholdBarPosition;
    IntervalBarPosition{100}:=PIntervalBarPosition;

{    ColorRef := PColorRef;}
    CurrentColor := PCurrentColor;
    (*
     ColorWhite := PColorWhite;
    ColorBlack := PColorBlack;
    ColorPURPLE := PColorPURPLE; ColorDPURPLE := PColorDPURPLE;
    ColorYELLOW := PColorYELLOW; ColorLYELLOW := PColorLYELLOW;
    Color9 := PColor9;
    Color1 := PColor1; Color2 := PColor2;
    Color3 := PColor3; Color4 := PColor4;
    Color5 := PColor5; Color6 := PColor6;
    Color7 := PColor7; Color8 := PColor8;
    {UVW := PUVW; VDW := PVDW; VMW := PVMW; VLW := PVLW; UDW := PUDW;
    UMW := PUMW; ULW := PULW; }DDW := PDDW;
    DMW := PDMW; DLW := PDLW; MDW := PMDW; MMW := PMMW; MLW := PMLW;
    LDW := PLDW; LMW := PLMW; LLW := PLLW;
    {UVC := PUVC; VDC := PVDC; VMC := PVMC; VLC := PVLC; UDC := PUDC;
    UMC := PUMC; ULC := PULC;} DDC := PDDC;
    DMC := PDMC; DLC := PDLC; MDC := PMDC; MMC := PMMC; MLC := PMLC;
    LDC := PLDC; LMC := PLMC; LLC := PLLC;
    {UVF := PUVF; VDF := PVDF; VMF := PVMF; VLF := PVLF; UDF := PUDF;
    UMF := PUMF; ULF := PULF;} DDF := PDDF;
    DMF := PDMF; DLF := PDLF; MDF := PMDF; MMF := PMMF; MLF := PMLF;
    LDF := PLDF; LMF := PLMF; LLF := PLLF;
    {UVA := PUVA; VDA := PVDA; VMA := PVMA; VLA := PVLA; UDA := PUDA;
    UMA := PUMA; ULA := PULA;} DDA := PDDA;
    DMA := PDMA; DLA := PDLA; MDA := PMDA; MMA := PMMA; MLA := PMLA;
    LDA := PLDA; LMA := PLMA; LLA := PLLA;
    {UVR := PUVR; VDR := PVDR; VMR := PVMR; VLR := PVLR; UDR := PUDR;
    UMR := PUMR; ULR := PULR; }DDR := PDDR;
    DMR := PDMR; DLR := PDLR; MDR := PMDR; MMR := PMMR; MLR := PMLR;
    LDR := PLDR; LMR := PLMR; LLR := PLLR;
    {UVT := PUVT; VDT := PVDT; VMT := PVMT; VLT := PVLT; UDT := PUDT;
    UMT := PUMT; ULT := PULT;} DDT := PDDT;
    DMT := PDMT; DLT := PDLT; MDT := PMDT; MMT := PMMT; MLT := PMLT;
    LDT := PLDT; LMT := PLMT; LLT := PLLT;
    {UVB := PUVB; VDB := PVDB; VMB := PVMB; VLB := PVLB; UDB := PUDB;
    UMB := PUMB; ULB := PULB;} DDB := PDDB;
    DMB := PDMB; DLB := PDLB; MDB := PMDB; MMB := PMMB; MLB := PMLB;
    LDB := PLDB; LMB := PLMB; LLB := PLLB;
    {UVU := PUVU; VDU := PVDU; VMU := PVMU; VLU := PVLU; UDU := PUDU;
    UMU := PUMU; ULU := PULU;} DDU := PDDU;
    DMU := PDMU; DLU := PDLU; MDU := PMDU; MMU := PMMU; MLU := PMLU;
    LDU := PLDU; LMU := PLMU; LLU := PLLU;
    {UVS := PUVS; VDS := PVDS; VMS := PVMS; VLS := PVLS; UDS := PUDS;
    UMS := PUMS; ULS := PULS;} DDS := PDDS;
    DMS := PDMS; DLS := PDLS; MDS := PMDS; MMS := PMMS; MLS := PMLS;
    LDS := PLDS; LMS := PLMS; LLS := PLLS;    *)
  end;
end;
{---------------------------------------------------------------------}

procedure DoSaver;
var P_File: PrefFile;
var PathS: string;
begin
  PathS := ExtractFilePath(ParamStr(0)) + 'dtm.pof';
  if (not FileExists(PathS)) then DoMessages(14{39987});
  {14, "Creating dtm.pof File"}
  GetPreferences;
  AssignFile(P_File, PathS);
  Rewrite(P_File);
  if IoResult <> 0 then
  begin
    DoMessages(29986);   {29986, "Failed writing dtm.pof File"}
  end;
  write(P_File, PreRcd);
  CloseFile(P_File);
end;
{---------------------------------------------------------------------}

procedure GetPreferences;
begin {before saving}
  with PreRcd do begin
  PHiddenString:=HiddenString;
    PColorreg := Colorreg;
    PStarted := Started;
    PStartedNameNumber := StartedNameNumber;
  PColor256Name:=Color256Name;
  PPrintBigChecked:=PrintBigChecked;
{  PTempName:=TempName;}
  PProgramPath:=ProgramPath;
  PFractal3DPath:=Fractal3DPath;
  PLifePath:=LifePath;
  PSOSMAPPath:=SOSMAPPath;
  PNoNamePath:=NoNamePath;
  PVRMProgramPath:=VRMProgramPath;
  PDigitizerPath:=DigitizerPath;
  PVRGISPath:=VRGISPath;
  PDTMPath:=DTMPath;
  PVoicePath:=VoicePath;
 PRasterPath:=RasterPath;
  PILHProgram:=ILHProgram;
  PProjectPath:=ProjectPath;
  PProjectName:=ProjectName;

  PInfoString:=InfoString;
  PConfirmationString:=ConfirmationString;
  PWarnString:=WarnString;
  PErrorString:=ErrorString;
  PDoneString:=DoneString;

  PMapName:=MapName;
  PMapsPath:=MapsPath;
  PTigerPath:=TigerPath;
  PDemPath:=DemPath;
  PHTFPath:=HTFPath;
  PShapePath:=ShapePath;
  PDLGPath:=DLGPath;
  PDxfPath:=DxfPath;
  PVRMDatabase:=VRMDatabase;
  PImagePath:=ImagePath;
  PFilePreviews:=FilePreviews;
  PErrorBeepOn:=ErrorBeepOn;
{  PScaleBarVisible:=ScaleBarVisible;}
  PSkipIntroScreen:=SkipIntroScreen;
  PWarningBeepOn :=WarningBeepOn;
  PInfoBeepOn :=InfoBeepOn;
  PConfirmBeepOn:=ConfirmBeepOn;
  PCompletedBeepOn:=CompletedBeepOn;
  PSkip32BitNotice:=Skip32BitNotice;
  PUseThumbnails:=UseThumbnails;
  PVoicesON :=VoicesON;
{  PCropXWide:=CropXWide;
  PCropYTall:=CropYTall;}
    PMapBordersColor:=MapBordersColor;
    PMapGridsColor:=MapGridsColor;
    PMapDatasColor:=MapDatasColor;
    PMapBacksColor:=MapBacksColor;
      PDTMformX:=DTMformX;
      PDTMformY:=DTMformY;
      PPOFFormX:=POFFormX;
      PPOFFormY:=POFFormY;
      PHtfFormY:=HtfFormY;
      PHtfFormX:=HtfFormX;
      PDTMGLFormX:=DTMGLFormX;
      PDTMGLFormY:=DTMGLFormY;
      PDtmGlBaseFormX:=DtmGlBaseFormX;
      PDtmGlBaseFormY:=DtmGlBaseFormY;
      PGLSViewerFormX:=GLSViewerFormX;
      PGLSViewerFormY:=GLSViewerFormY;
      PDtmJoyFormX:=DtmJoyFormX;
      PDtmJoyFormY:=DtmJoyFormY;
      PdtmSmdQcFormX:= dtmSmdQcFormX;
      PdtmSmdQcFormY:= dtmSmdQcFormY;
      PdtmSmdLoadMdlFormX:=dtmSmdLoadMdlFormX;
      PdtmSmdLoadMdlFormY:=dtmSmdLoadMdlFormY;
      PdtmPanImageFormX:=dtmPanImageFormX;
      PdtmPanImageFormY:=dtmPanImageFormY;
      PDtmImageRGBFormX:=DtmImageRGBFormX;
      PDtmImageRGBFormY:=DtmImageRGBFormY;
      PRIFImageViewerFormX:=RIFImageViewerFormX;
      PRIFImageViewerFormY:=RIFImageViewerFormY;
      PMessageX:=MessageX;
      PMessageY:=MessageY;
      PNavFormX:=NavFormX;
      PNavFormY:=NavFormY;
      PAboutX:=AboutX;
      PAboutY:=AboutY;
      PImageMakerFormX:=ImageMakerFormX;
      PImageMakerFormY:=ImageMakerFormY;
      PLineProfileFormX:=LineProfileFormX;
      PLineProfileFormY:=LineProfileFormY;
      PLegendFormX:=LegendFormX;
      PLegendFormY:=LegendFormY;
      PdtmEcotypeColorsFormX:=dtmEcotypeColorsFormX;
      PdtmEcotypeColorsFormY:=dtmEcotypeColorsFormY;
      PdtmDbFormX:=dtmDbFormX;
      PdtmDbFormY:=dtmDbFormY;
      PSystemInfoFormX:=SystemInfoFormX;
      PSystemInfoFormY:=SystemInfoFormY;
    PThumbColor:=ThumbColor;
     PThumbSize:=ThumbSize;
    PThumbPath:=ThumbPath;
    PContours:=Contours;
    PUseContourColors:=UseContourColors;
    PSlopeDirection:=SlopeDirection;
    PThresholdBarPosition{500}:=ThresholdBarPosition;
    PIntervalBarPosition{100}:=IntervalBarPosition;
{    PColorRef := ColorRef;}
    PCurrentColor := CurrentColor;
    (*
    PColorWhite := ColorWhite;
    PColorBlack := ColorBlack;
    PColorPURPLE := ColorPURPLE; PColorDPURPLE := ColorDPURPLE;
    PColorYELLOW := ColorYELLOW; PColorLYELLOW := ColorLYELLOW;
    PColor9 := Color9;
    PColor1 := Color1; PColor2 := Color2; PColor3 := Color3; PColor4
    := Color4;
    PColor5 := Color5; PColor6 := Color6; PColor7 := Color7; PColor8
    := Color8;
    {PUVW := UVW; PVDW := VDW; PVMW := VMW; PVLW := VLW; PUDW := UDW;
    PUMW := UMW; PULW := ULW;} PDDW := DDW;
    PDMW := DMW; PDLW := DLW; PMDW := MDW; PMMW := MMW; PMLW := MLW;
    PLDW := LDW; PLMW := LMW; PLLW := LLW;
    {PUVC := UVC; PVDC := VDC; PVMC := VMC; PVLC := VLC; PUDC := UDC;
    PUMC := UMC; PULC := ULC;} PDDC := DDC;
    PDMC := DMC; PDLC := DLC; PMDC := MDC; PMMC := MMC; PMLC := MLC;
    PLDC := LDC; PLMC := LMC; PLLC := LLC;
    {PUVF := UVF; PVDF := VDF; PVMF := VMF; PVLF := VLF; PUDF := UDF;
    PUMF := UMF; PULF := ULF;} PDDF := DDF;
    PDMF := DMF; PDLF := DLF; PMDF := MDF; PMMF := MMF; PMLF := MLF;
    PLDF := LDF; PLMF := LMF; PLLF := LLF;
    {PUVA := UVA; PVDA := VDA; PVMA := VMA; PVLA := VLA; PUDA := UDA;
    PUMA := UMA; PULA := ULA;} PDDA := DDA;
    PDMA := DMA; PDLA := DLA; PMDA := MDA; PMMA := MMA; PMLA := MLA;
    PLDA := LDA; PLMA := LMA; PLLA := LLA;
    {PUVR := UVR; PVDR := VDR; PVMR := VMR; PVLR := VLR; PUDR := UDR;
    PUMR := UMR; PULR := ULR;} PDDR := DDR;
    PDMR := DMR; PDLR := DLR; PMDR := MDR; PMMR := MMR; PMLR := MLR;
    PLDR := LDR; PLMR := LMR; PLLR := LLR;
    {PUVT := UVT; PVDT := VDT; PVMT := VMT; PVLT := VLT; PUDT := UDT;
    PUMT := UMT; PULT := ULT;} PDDT := DDT;
    PDMT := DMT; PDLT := DLT; PMDT := MDT; PMMT := MMT; PMLT := MLT;
    PLDT := LDT; PLMT := LMT; PLLT := LLT;
   { PUVB := UVB; PVDB := VDB; PVMB := VMB; PVLB := VLB; PUDB := UDB;
    PUMB := UMB; PULB := ULB;} PDDB := DDB;
    PDMB := DMB; PDLB := DLB; PMDB := MDB; PMMB := MMB; PMLB := MLB;
    PLDB := LDB; PLMB := LMB; PLLB := LLB;
    {PUVU := UVU; PVDU := VDU; PVMU := VMU; PVLU := VLU; PUDU := UDU;
    PUMU := UMU; PULU := ULU;} PDDU := DDU;
    PDMU := DMU; PDLU := DLU; PMDU := MDU; PMMU := MMU; PMLU := MLU;
    PLDU := LDU; PLMU := LMU; PLLU := LLU;
    {PUVS := UVS; PVDS := VDS; PVMS := VMS; PVLS := VLS; PUDS := UDS;
    PUMS := UMS; PULS := ULS;} PDDS := DDS;
    PDMS := DMS; PDLS := DLS; PMDS := MDS; PMMS := MMS; PMLS := MLS;
    PLDS := LDS; PLMS := LMS; PLLS := LLS;*)
  end;
end;

procedure ResetToDefaults;
begin
    FilePreviews:=True;
    Skip32BitNotice:=False;
    SkipIntroScreen:=False;
    ErrorBeepOn:=False;
    WarningBeepOn:=False;
    InfoBeepOn :=False;
    ConfirmBeepOn:=False;
    CompletedBeepOn:=False;
    PrintBigChecked:=True;
    UseThumbnails:=False;
    DTMFormX := 0;
    DTMFormY := 0;
    POFFormX:=123;
    POFFormY:=123;
    HtfFormY:=123;
    HtfFormX:=123;
    DTMGLFormX:=123;
    DTMGLFormY:=123;
    DtmGlBaseFormX:=123;
    DtmGlBaseFormY:=123;
    GLSViewerFormX:=123;
    GLSViewerFormY:=123;
    DtmJoyFormX:=123;
    DtmJoyFormY:=123;
    dtmSmdQcFormX:=123;
    dtmSmdQcFormY:=123;
    dtmSmdLoadMdlFormX:=123;
    dtmSmdLoadMdlFormY:=123;
    dtmPanImageFormX:=123;
    dtmPanImageFormY:=123;
    RIFImageViewerFormX:=123;
    RIFImageViewerFormY:=123;
    DtmImageRGBFormX:=123;
    DtmImageRGBFormY:=123;
    ImageMakerFormX:=123;
    ImageMakerFormY:=123;
    LineProfileFormX:=123;
    LineProfileFormY:=123;
    LegendFormX:=123;
    LegendFormY:=123;
    dtmEcotypeColorsFormY := 123;
    dtmEcotypeColorsFormX := 123;
    dtmDbFormX:=123;
    dtmDbFormY:=123;
    NavFormX:=123;
    NavFormY:=123;
    MessageX := 123;
    MessageY := 123;
    AboutX := 123;
    AboutY := 123;
    SystemInfoFormX := 123;
    SystemInfoFormY := 123;
    {Reset Directories defaults  }
    TempName:='';{Passing name}
    DTMPath := (ParamStr(0));
    Fractal3DPath:=DTMPath;
    LifePath:=DTMPath;       { HTFName}
    SOSMAPPath:=DTMPath;
    DigitizerPath:=DTMPath;
    VRGISPath:=DTMPath;
    DTMPath:=DTMPath;
    VoicePath:=DTMPath;
    RasterPath:=DTMPath;
    ILHProgram:=DTMPath;
    NoNamePath:=DTMPath;
    ProjectName:=DTMPath;
    MapName:=DTMPath;
    ProjectPath:=DTMPath;
    MapsPath:=DTMPath;
    ProgramPath:=DTMPath;
    TransSearchDir:=DTMPath;
    ThumbPath:=DTMPath;
    DemPath:=DTMPath;
    HTFPath:=DTMPath;
    TigerPath:=DTMPath;
    DLGPath:=DTMPath;
    DXFPath:=DTMPath;
    ShapePath:=DTMPath;
    VRMDatabase:=DTMPath;
    ImagePath:=DTMPath;
   InfoString:= DTMPath+ 'fyinfo.wav'; {Info}
   ConfirmationString:= DTMPath+ 'confirm.wav';{ Confirmation}
   WarnString:= DTMPath+ 'warn.wav';{Warn}
   ErrorString:= DTMPath+ 'error.wav';{Error}
   DoneString:= DTMPath+ 'done.wav';{Done}
    MapBordersColor:=clGreen;
    MapGridsColor:=clOlive;
    MapDatasColor:=clRed;
    MapBacksColor:=clSilver;
    CurrentColor:=clBlack;
{    PColorRef,}
    ThumbColor:=clWhite;
    ThumbSize:=128;     {ThumbWidth:=128;    ThumbHeight:=96;}
    ThumbPath:=DTMPath;
    Contours:=20;
    SlopeDirection:=0;
    UseContourColors:=True;
    ThresholdBarPosition{500}:=500;{Joystick}
    IntervalBarPosition{100}:=100;
    JoyCentroidX:=0;
    JoyCentroidY:=0;
end;

end.
