{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{         Displays and gathers Program Options          }
{*******************************************************}
unit dtmPOFrm;
{by Ivan Lee Herring, 2002}
interface

uses
  Windows, Dialogs, StdCtrls, Buttons, Controls,Graphics,
  Sysutils{Filestuff},
  FileCtrl{SelectDirectory},
  ExtCtrls, ComCtrls, Forms, Classes;

type
  TdtmPOFForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Bevel1: TBevel;
    Label1: TLabel;
    Label4: TLabel;
    MessageBtn: TSpeedButton;
    POHelpBtn: TSpeedButton;
    POM_ResetMenuBtn: TSpeedButton;
    InfoCB: TCheckBox;
    ConfirmationCB: TCheckBox;
    ErrorsCB: TCheckBox;
    WarningCB: TCheckBox;
    CompletionCB: TCheckBox;
    BeepOrWavCB: TCheckBox;
    MessageXEdit: TEdit;
    MessageYEdit: TEdit;
    CloseBitBtn: TBitBtn;
    RecordReader: TTabSheet;
    ProjectsBtn: TSpeedButton;
    ShapeBtn: TSpeedButton;
    BaseImagesBtn: TSpeedButton;
    DLGBtn: TSpeedButton;
    VectorDbBtn: TSpeedButton;
    DXFBtn: TSpeedButton;
    TigerBtn: TSpeedButton;
    HtfBtn: TSpeedButton;
    DemBtn: TSpeedButton;
    Label3: TLabel;
    Label2: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label25: TLabel;
    Label17: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label49: TLabel;
    DemEdit: TEdit;
    HTFEdit: TEdit;
    TigerEdit: TEdit;
    DXFEdit: TEdit;
    VectorDbEdit: TEdit;
    DLGEdit: TEdit;
    BaseImagesEdit: TEdit;
    ShapeEdit: TEdit;
    ProjectsEdit: TEdit;
    OpenDialog1: TOpenDialog;
    TabSheet2: TTabSheet;
    SOSMAPBtn: TSpeedButton;
    SOSMAPEdit: TEdit;
    VoiceEdit: TEdit;
    VoiceBtn: TSpeedButton;
    TracerBtn: TSpeedButton;
    TracerEdit: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    VRGISBtn: TSpeedButton;
    VRGISEdit: TEdit;
    ILHEdit: TEdit;
    LifeEdit: TEdit;
    Fractal3DEdit: TEdit;
    DTMEdit: TEdit;
    GripIceEdit: TEdit;
    GripIceBtn: TSpeedButton;
    DTMBtn: TSpeedButton;
    Fractal3DBtn: TSpeedButton;
    LifeBtn: TSpeedButton;
    ILHBtn: TSpeedButton;
    MapBtn: TSpeedButton;
    MapEdit: TEdit;
    MapLabel: TLabel;
    PrintBigCB: TCheckBox;
    ThumbnailsTS: TTabSheet;
    ThumbBtn: TSpeedButton;
    ThumbEdit: TEdit;
    Label15: TLabel;
    WidthEdit: TEdit;
    SizeUpDown: TUpDown;
    Label18: TLabel;
    Shape1: TShape;
    FillColorBtn: TSpeedButton;
    ColorDialog: TColorDialog;
    Label20: TLabel;
    Skip32BitNoticeCB: TCheckBox;
    TabSheet3: TTabSheet;
    ExtMemo: TMemo;
    ExtDefaults: TSpeedButton;
    ExtOpen: TSpeedButton;
    ExtSave: TSpeedButton;
    ExtensionSetRG: TRadioGroup;
    ClearExtBtn: TSpeedButton;
    TestSoundRG: TRadioGroup;
    UseThumbnailsCB: TCheckBox;
    SkipIntroScreenCB: TCheckBox;
    Label14: TLabel;
    NoNamePathBtn: TSpeedButton;
    NoNameEdit: TEdit;
    FilePreviewsCB: TCheckBox;
    TabSheet4: TTabSheet;
    DemMaxE: TLabel;
    ECI7Edit: TEdit;
    ECI8Edit: TEdit;
    ECI6Edit: TEdit;
    ECI5Edit: TEdit;
    ECI4Edit: TEdit;
    ECI1Edit: TEdit;
    ECI2Edit: TEdit;
    ECI3Edit: TEdit;
    DemMinE: TLabel;
    EColorsRG: TRadioGroup;
    DemCIE: TLabel;
    DemCIEEdit: TEdit;
    Label19: TLabel;
    NullValueEdit: TEdit;
    SavePaletteBtn: TSpeedButton;
    SaveDialog1: TSaveDialog;
    ColorDialog1: TColorDialog;
    colorcolorPanel: TPanel;
    ECI9Edit: TEdit;
    ContourIntervalsBtn: TSpeedButton;
    Is1CB: TCheckBox;
    MapGridColor: TPanel;
    MapBorderColor: TPanel;
    MapDataColor: TPanel;
    MapBackColor: TPanel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    ContourColorsCB: TCheckBox;
    DemCIEdit: TEdit;
    Label16: TLabel;
    CIColorsCB: TCheckBox;
    SlopeDirectionRG: TRadioGroup;
    SetCIBtn: TSpeedButton;
    LoadSoundRG: TRadioGroup;
    Bevel5: TBevel;
    TabSheet5: TTabSheet;
    Label21: TLabel;
    Label24: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    CurrentColorPanel: TPanel;
    Label29: TLabel;

    procedure MessageBtnClick(Sender: TObject);
    procedure POHelpBtnClick(Sender: TObject);
    procedure POM_ResetMenuBtnClick(Sender: TObject);
    procedure CloseBitBtnClick(Sender: TObject);
    procedure ProjectsBtnClick(Sender: TObject);
    procedure ShapeBtnClick(Sender: TObject);
    procedure BaseImagesBtnClick(Sender: TObject);
    procedure DLGBtnClick(Sender: TObject);
    procedure VectorDbBtnClick(Sender: TObject);
    procedure DXFBtnClick(Sender: TObject);
    procedure TigerBtnClick(Sender: TObject);
    procedure HtfBtnClick(Sender: TObject);
    procedure DemBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
procedure Showem;
    procedure BeepOrWavCBClick(Sender: TObject);
    procedure VRGISBtnClick(Sender: TObject);
    procedure ILHBtnClick(Sender: TObject);
    procedure LifeBtnClick(Sender: TObject);
    procedure Fractal3DBtnClick(Sender: TObject);
    procedure DTMBtnClick(Sender: TObject);
    procedure GripIceBtnClick(Sender: TObject);
    procedure TracerBtnClick(Sender: TObject);
    procedure VoiceBtnClick(Sender: TObject);
    procedure SOSMAPBtnClick(Sender: TObject);
    procedure FillColorBtnClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure ThumbBtnClick(Sender: TObject);
    procedure SizeUpDownClick(Sender: TObject; Button: TUDBtnType);
    procedure ExtOpenClick(Sender: TObject);
    procedure ExtSaveClick(Sender: TObject);
    procedure ExtDefaultsClick(Sender: TObject);
    procedure ClearExtBtnClick(Sender: TObject);
    procedure TestSoundRGClick(Sender: TObject);
    procedure MapBtnClick(Sender: TObject);
    procedure UseThumbnailsCBClick(Sender: TObject);
    procedure NoNamePathBtnClick(Sender: TObject);
    procedure SavePaletteBtnClick(Sender: TObject);
    procedure EColorsRGClick(Sender: TObject);
    procedure ECI1EditDblClick(Sender: TObject);
    procedure ECI2EditDblClick(Sender: TObject);
    procedure ECI3EditDblClick(Sender: TObject);
    procedure ECI4EditDblClick(Sender: TObject);
    procedure ECI5EditDblClick(Sender: TObject);
    procedure ECI6EditDblClick(Sender: TObject);
    procedure ECI7EditDblClick(Sender: TObject);
    procedure ECI8EditDblClick(Sender: TObject);
    procedure ContourIntervalsBtnClick(Sender: TObject);
    procedure MapBorderColorClick(Sender: TObject);
    procedure MapGridColorClick(Sender: TObject);
    procedure MapDataColorClick(Sender: TObject);
    procedure MapBackColorClick(Sender: TObject);
    procedure SlopeDirectionRGClick(Sender: TObject);
    procedure SetCIBtnClick(Sender: TObject);
    procedure LoadSoundRGClick(Sender: TObject);
    procedure CurrentColorPanelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmPOFForm: TdtmPOFForm;

implementation

{$R *.DFM}

uses dtmErrMsg, dtmGlobals, dtmPOFvar;

procedure TdtmPOFForm.CloseBitBtnClick(Sender: TObject);
begin
Close;
end;

procedure TdtmPOFForm.FormClose(Sender: TObject; var Action: TCloseAction);
var code: Integer;
begin
  POFFormY := dtmPOFForm.top;
  POFFormX := dtmPOFForm.left;
  ErrorBeepOn := ErrorsCB.Checked;
  WarningBeepOn := WarningCB.Checked;
  InfoBeepOn := InfoCB.Checked;
  ConfirmBeepOn := ConfirmationCB.Checked;
  CompletedBeepOn := CompletionCB.Checked;
  Skip32BitNotice:=   Skip32BitNoticeCB.Checked;
  SkipIntroScreen:=   SkipIntroScreenCB.Checked;
  PrintBigChecked:=  PrintBigCB.Checked;
{Get the Thumbnail data}
  {ThumbPath}
  UseThumbnails:= UseThumbnailsCB.Checked;
  ThumbSize:=SizeUpDown.Position;   {ThumbWidth }
  {ThumbColor }
{Get the Message locations}
  val(MessageXEdit.Text, MessageX, Code);
  val(MessageYEdit.Text, MessageY, Code);
  MapBordersColor := MapBorderColor.Color;
  MapGridsColor := MapGridColor.Color;
  MapDatasColor := MapDataColor.Color;
  MapBacksColor := MapBackColor.Color;
  Contours:=Strtoint(DemCIEEdit.Text);
  UseContourColors := ContourColorsCB.Checked;
  DoSaver;
end;


procedure TdtmPOFForm.FormCreate(Sender: TObject);
begin
  top := POFFormY;
  left := POFFormX;
  OpenDialog1.InitialDir := HTFPath;
            {-50000.. - 7001: }{black 0,0,0}
     ECI1Edit.Color:= RGB({-7000.. - 6001: Navy} 0,0,128);
     ECI2Edit.Color:= RGB({-6000.. - 2001:Blue} 0,0,255 );
     ECI3Edit.Color:= RGB({-2000..0: Aqua} 0,255,255 );
     ECI4Edit.Color:= RGB({1..400:   Green} 0,255,0);
     ECI5Edit.Color:= RGB({401..1000: Yellow} 255,255,0);
     ECI6Edit.Color:= RGB({1001..2000:  Red }255,0,0);
     ECI7Edit.Color:= RGB({2001..3000:  Purple} 255,0,255);
     ECI8Edit.Color:= RGB({3001..4001:  Smog} 128,128,128);
     ECI9Edit.Color:= RGB({4001..50000:  Snow} 255,255,255);
     colorcolorPanel.Caption:=
     Inttostr(GetRValue(colorcolorPanel.Color))+','+
     Inttostr(GetGValue(colorcolorPanel.Color))+','+
     Inttostr(GetBValue(colorcolorPanel.Color));

  MapBorderColor.Color:=MapBordersColor;
  MapGridColor.Color:=MapGridsColor;
  MapDataColor.Color:=MapDatasColor;
  MapBackColor.Color:=MapBacksColor;
end;

procedure TdtmPOFForm.MessageBtnClick(Sender: TObject);
begin
  MessageX := StrtoInt(MessageXEdit.Text);
  MessageY := StrtoInt(MessageYEdit.Text);
  DoMessages(7499); {7499, "Resistance is futile
                      \015\012All Messages end here"}
end;

procedure TdtmPOFForm.POHelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(50);
end;

procedure TdtmPOFForm.POM_ResetMenuBtnClick(Sender: TObject);
begin
  ResetToDefaults;
  Showem;
End;


procedure TdtmPOFForm.FormShow(Sender: TObject);
begin
  Showem;
end;

procedure TdtmPOFForm.Showem;
var ShowString: string;
begin
{Set all the boxes and edits}
  ErrorsCB.Checked:=ErrorBeepOn;
  WarningCB.Checked:=WarningBeepOn;
  InfoCB.Checked:=InfoBeepOn;
  ConfirmationCB.Checked:=ConfirmBeepOn;
  CompletionCB.Checked:=CompletedBeepOn;
  PrintBigCB.Checked:=PrintBigChecked;
  FilePreviewsCB.Checked:=FilePreviews;
  Skip32BitNoticeCB.Checked:=Skip32BitNotice;
  UseThumbnailsCB.Checked:=UseThumbnails;
  str(MessageX, ShowString);
  MessageXEdit.Text := ShowString;
  str(MessageY, ShowString);
  MessageYEdit.Text := ShowString;
  Fractal3DEdit.Text:=Fractal3DPath;
  LifeEdit.Text:=LifePath;
  SOSMAPEdit.Text:=SOSMAPPath;
  TracerEdit.Text:=DigitizerPath;
  VRGISEdit.Text:=VRGISPath;
  DTMEdit.Text:=DTMPath;
  VoiceEdit.Text:=VoicePath;
  GripIceEdit.Text:=RasterPath;
  ILHEdit.Text:=ILHProgram;
  ProjectsEdit.Text := ProjectPath;
  MapEdit.Text:=MapsPath;
  NoNameEdit.Text := NoNamePath;
  TigerEdit.Text := TigerPath;
  DemEdit.Text := DemPath;
  HTFEdit.Text := HTFPath;
  DLGEdit.Text := DLGPath;
  DXFEdit.Text := DXFPath;
  ShapeEdit.Text := ShapePath;
  VectorDbEdit.Text := VRMDatabase;
  BaseImagesEdit.Text := ImagePath;
  ThumbEdit.Text :=ThumbPath;
  SizeUpDown.Position:=ThumbSize;   {Thumb Width and Height}
  Shape1.Brush.Color:=ThumbColor ;
  DemCIEEdit.Text:= Inttostr(Contours);
  ContourColorsCB.Checked:=UseContourColors;
  SlopeDirectionRG.ItemIndex:=SlopeDirection;
  MapBorderColor.Color:=MapBordersColor;
  MapGridColor.Color:=MapGridsColor;
  MapDataColor.Color:=MapDatasColor;
  MapBackColor.Color:=MapBacksColor;
  CurrentColorPanel.Color := CurrentColor;
end;




procedure TdtmPOFForm.ProjectsBtnClick(Sender: TObject);
begin
  TransSearchDir:= ProjectPath;
  if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
  begin
    ProjectPath := TransSearchDir;
    ProjectsEdit.Text := ProjectPath;
  end {else DoMessages(1)};
end;

procedure TdtmPOFForm.MapBtnClick(Sender: TObject);
begin
  TransSearchDir:= MapsPath;
  if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
  begin
    MapsPath := TransSearchDir;
    MapEdit.Text := MapsPath;
  end {else DoMessages(1)};
end;

procedure TdtmPOFForm.ShapeBtnClick(Sender: TObject);
begin
  TransSearchDir:= ShapePath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      ShapePath := TransSearchDir;
      ShapeEdit.Text := ShapePath;
    end {else DoMessages(8)};
end;

procedure TdtmPOFForm.BaseImagesBtnClick(Sender: TObject);
begin
  TransSearchDir:= ImagePath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      ImagePath := TransSearchDir;
        BaseImagesEdit.Text := ImagePath;
    end {else DoMessages(13)};
end;

procedure TdtmPOFForm.DLGBtnClick(Sender: TObject);
begin
  TransSearchDir:= DLGPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      DLGPath := TransSearchDir;
      DLGEdit.Text := DLGPath;
    end{ else DoMessages(10)};
end;

procedure TdtmPOFForm.VectorDbBtnClick(Sender: TObject);
begin
  TransSearchDir:= VRMDatabase;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      VRMDatabase := TransSearchDir;
      VectorDbEdit.Text := VRMDatabase;
    end {else DoMessages(12)};
end;

procedure TdtmPOFForm.DXFBtnClick(Sender: TObject);
begin
  TransSearchDir:= DXFPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      DXFPath := TransSearchDir;
      DXFEdit.Text := DXFPath;
    end {else DoMessages(11)};
end;


procedure TdtmPOFForm.TigerBtnClick(Sender: TObject);
begin
  TransSearchDir:= TigerPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
    TigerPath := TransSearchDir;
    TigerEdit.Text := TigerPath;
  end; {else DoMessages(3);}
end;

procedure TdtmPOFForm.HtfBtnClick(Sender: TObject);
begin
  TransSearchDir:= HTFPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      HTFPath := TransSearchDir;
      HTFEdit.Text := HTFPath;
  end;{ else DoMessages(4);}
end;

procedure TdtmPOFForm.DemBtnClick(Sender: TObject);
begin
  TransSearchDir:= DemPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
        begin
      DemPath :=TransSearchDir;
      DemEdit.Text := DemPath;
  end;{ else DoMessages(9);}
end;

procedure TdtmPOFForm.VRGISBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'VRGIS Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := VRGISPath;
  OpenDialog1.Filename:='vrgis.exe';
  if OpenDialog1.execute then
  begin
    VRGISPath := (OpenDialog1.filename);
    VRGISEdit.Text := VRGISPath;
  end;
end;

procedure TdtmPOFForm.ILHBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'ILH Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := ILHProgram;
  OpenDialog1.Filename:='Image.exe';
  if OpenDialog1.execute then
  begin
    ILHProgram := (OpenDialog1.filename);
    ILHEdit.Text := ILHProgram;
  end;
end;

procedure TdtmPOFForm.LifeBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Life Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := LifePath;
  OpenDialog1.Filename:='Life.exe';
  if OpenDialog1.execute then
  begin
    LifePath := (OpenDialog1.filename);
    LifeEdit.Text := LifePath;
  end;
end;

procedure TdtmPOFForm.Fractal3DBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Fractal3D Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := Fractal3DPath;
  OpenDialog1.Filename:='Fractl3D.exe';
  if OpenDialog1.execute then
  begin
    Fractal3DPath := (OpenDialog1.filename);
    Fractal3DEdit.Text := Fractal3DPath;
  end;
end;

procedure TdtmPOFForm.DTMBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'DTM Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := DTMPath;
  OpenDialog1.Filename:='dtm.exe';
  if OpenDialog1.execute then
  begin
    DTMPath := (OpenDialog1.filename);
    DTMEdit.Text := DTMPath;
  end;
end;

procedure TdtmPOFForm.GripIceBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'GripIce Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := RasterPath;
  OpenDialog1.Filename:='grip.exe';
  if OpenDialog1.execute then
  begin
    RasterPath := (OpenDialog1.filename);
    GripIceEdit.Text := RasterPath;
  end;
end;


procedure TdtmPOFForm.TracerBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Tracer Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := DigitizerPath;
  OpenDialog1.Filename:='Tracer.exe';
  if OpenDialog1.execute then
  begin
    DigitizerPath := (OpenDialog1.filename);
    TracerEdit.Text := DigitizerPath;
  end;
end;

procedure TdtmPOFForm.VoiceBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Voice Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := VoicePath;
  OpenDialog1.Filename:='Voice.exe';
  if OpenDialog1.execute then
  begin
    VoicePath := (OpenDialog1.filename);
    VoiceEdit.Text := VoicePath;
  end;
end;

procedure TdtmPOFForm.SOSMAPBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'SOSMAP Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := SOSMAPPath;
  OpenDialog1.Filename:='sosmap.exe';
  if OpenDialog1.execute then
  begin
    SOSMAPPath := (OpenDialog1.filename);
    SOSMAPEdit.Text := SOSMAPPath;
  end;
end;
procedure TdtmPOFForm.NoNamePathBtnClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'NoName Program (*.exe)|*.exe';
  OpenDialog1.InitialDir := NoNamePath;
  OpenDialog1.Filename:='*.exe';
  if OpenDialog1.execute then
  begin
    NoNamePath := (OpenDialog1.filename);
    NoNameEdit.Text := NoNamePath;
  end;
end;

(*
procedure TForm1.CreateButtonClick(Sender: TObject);
var
  i: Integer;
  InFileName, OutFileName: string;
  FilePath, FileName: string;
begin
  for i:=0 to FilesListBox.Items.Count-1 do
  begin
    InFileName:=FilesListBox.Items[i];
    FilePath:=ExtractFilePath(InFileName);
    FileName:=ExtractFileName(InFileName);
    if OutDirEdit.Text<>'' then
      FilePath:=IncludeTrailingBackSlash(OutDirEdit.Text);
                                        {ThumbPath}
    OutFileName:=Concat(FilePath,
    PrefixEdit.Text,                  {ThmPrefix  max 5}
    FileName);
    CreateThumbnail(InFileName,OutFileName,
    WidthUpDown.Position,             {ThumbWidth }
      HeightUpDown.Position,           {ThumbHeight }
      Shape1.Brush.Color);             {ThumbColor }
    Application.ProcessMessages;
    StatusBar1.SimpleText:=
    'Done '+IntToStr(i+1)+' of '+IntToStr(FilesListBox.Items.count);
  end;
end;
*)
{  UseThumbnailsCB.Checked:=UseThumbnails;}
procedure TdtmPOFForm.UseThumbnailsCBClick(Sender: TObject);
begin
  UseThumbnails:=(not UseThumbnails);
  UseThumbnailsCB.Checked:=UseThumbnails;
end;

procedure TdtmPOFForm.FillColorBtnClick(Sender: TObject);
begin
  ColorDialog.Color:=ThumbColor;
  if ColorDialog.Execute then
      ThumbColor:=ColorDialog.Color;
  Shape1.Brush.Color:=ThumbColor;
end;

procedure TdtmPOFForm.ThumbBtnClick(Sender: TObject);
begin
  TransSearchDir:= ThumbPath;
      if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
  begin
    ThumbPath := TransSearchDir;
    ThumbEdit.Text := ThumbPath;
  end;
end;

procedure TdtmPOFForm.SizeUpDownClick(Sender: TObject; Button: TUDBtnType);
begin
If ((Button = btNext) and  (SizeUpDown.Position <287)) then
   begin
   Shape1.Width:=SizeUpDown.Position+1;
   Shape1.Height:=SizeUpDown.Position+1;
   end   else  {287w 190h}
If ((Button = btPrev) and  (SizeUpDown.Position >2)) then
   begin
   Shape1.Width:=SizeUpDown.Position-1;
   Shape1.Height:=SizeUpDown.Position-1;
   end;
end;
(*If ((Button = btNext) and  (HeightUpDown.Position <190)) then
   Shape1.Height:=HeightUpDown.Position+1
   else  {287w 190h}
If ((Button = btPrev) and  (HeightUpDown.Position >2)) then
   Shape1.Height:=HeightUpDown.Position-1;*)
{The Button parameter specifies how the value of Position
 is about to change.
 When Button is btNext, the Up or Right arrow was clicked,
 and the value of Position is about to increase by Increment.
  When Button is btPrev, the Down or Left arrow was clicked,
  and the value of Position is about to decrease by Increment.  }
procedure TdtmPOFForm.ExtOpenClick(Sender: TObject);
var
ExtFileName:String;
begin

Case ExtensionSetRG.ItemIndex of
0:ExtFileName:='Grafext.et0';
1:ExtFileName:='Grafext.et1';
2:ExtFileName:='Grafext.et2';
3:ExtFileName:='Grafext.et3';
4:ExtFileName:='Grafext.et4';
5:ExtFileName:='Grafext.et5';
6:ExtFileName:='Grafext.et6';
end;{case}
If FileExists(ProgramPath+ExtFileName) then
  ExtMemo.Lines.LoadFromFile(ProgramPath+ExtFileName)
  else
  begin
  Tempname:=ProgramPath+ExtFileName;
  DoMessages(30002);{30002, "Error opening file "}
  end;
end;

procedure TdtmPOFForm.ExtSaveClick(Sender: TObject);
var
ExtFileName:String;
begin
Case ExtensionSetRG.ItemIndex of
0:ExtFileName:='Grafext.et0';
1:ExtFileName:='Grafext.et1';
2:ExtFileName:='Grafext.et2';
3:ExtFileName:='Grafext.et3';
4:ExtFileName:='Grafext.et4';
5:ExtFileName:='Grafext.et5';
6:ExtFileName:='Grafext.et6';
end;{case}
  ExtMemo.Lines.SaveToFile(ProgramPath+ExtFileName)
end;

procedure TdtmPOFForm.ExtDefaultsClick(Sender: TObject);
begin
Case ExtensionSetRG.ItemIndex of
0:begin
{ExtMemo}
  ExtMemo.Lines.Add('*.shp');
  ExtMemo.Lines.Add('*.shx');
  ExtMemo.Lines.Add('*.sbx');
  ExtMemo.Lines.Add('*.sbx');
  ExtMemo.Lines.Add('*.dxf');
  ExtMemo.Lines.Add('*.dlg');
  ExtMemo.Lines.Add('*.vrm');
end;
1:begin
    // internally register Delphi's "built in" formats,
    //these will not be unregistered on exit and
    // also not registered with TPicture
    //(because they are already or will soon be)
  ExtMemo.Lines.Add('*.png');
  ExtMemo.Lines.Add('*.bmp');
  ExtMemo.Lines.Add('*.ico');
  ExtMemo.Lines.Add('*.wmf');
  ExtMemo.Lines.Add('*.emf');
  ExtMemo.Lines.Add('*.jfif');
  ExtMemo.Lines.Add('*.jpg');
  ExtMemo.Lines.Add('*.jpe');
  ExtMemo.Lines.Add('*.jpeg');

    // register our own formats
  ExtMemo.Lines.Add('*.rle');
  ExtMemo.Lines.Add('*.dib');

    {.$ifdef TargaGraphic}
  ExtMemo.Lines.Add('*.win');
  ExtMemo.Lines.Add('*.vst');
  ExtMemo.Lines.Add('*.vda');
  ExtMemo.Lines.Add('*.tga');
  ExtMemo.Lines.Add('*.icb');
    {.$endif}

    {.$ifdef TIFFGraphic}
  ExtMemo.Lines.Add('*.tiff');
  ExtMemo.Lines.Add('*.tif');
  ExtMemo.Lines.Add('*.fax');
      {.$ifdef EPSGraphic}
  ExtMemo.Lines.Add('*.eps');
      {.$endif}
    {.$endif}

    {.$ifdef PCXGraphic}
  ExtMemo.Lines.Add('*.pcx');
  ExtMemo.Lines.Add('*.pcc');
  ExtMemo.Lines.Add('*.scr');
    {.$endif}

    {.$ifdef RLAGraphic}
  ExtMemo.Lines.Add('*.rpf');
  ExtMemo.Lines.Add('*.rla');
    {.$endif}

    {.$ifdef SGIGraphic}
  ExtMemo.Lines.Add('*.sgi');
  ExtMemo.Lines.Add('*.rgba');
  ExtMemo.Lines.Add('*.rgb');
  ExtMemo.Lines.Add('*.bw');
    {.$endif}

    {.$ifdef PhotoshopGraphic}
  ExtMemo.Lines.Add('*.psd');
  ExtMemo.Lines.Add('*.pdd');
    {.$endif}

    {.$ifdef PortableMapGraphic}
  ExtMemo.Lines.Add('*.ppm');
  ExtMemo.Lines.Add('*.pgm');
  ExtMemo.Lines.Add('*.pbm');
    {.$endif}

    {.$ifdef AutodeskGraphic}
  ExtMemo.Lines.Add('*.cel');
  ExtMemo.Lines.Add('*.pic');
    {.$endif}

    {.$ifdef PCDGraphic}
  ExtMemo.Lines.Add('*.pcd');
    {.$endif}

    {$ifdef GIFGraphic}
  ExtMemo.Lines.Add('*.gif');
    {$endif}

    {.$ifdef CUTGraphic}
  ExtMemo.Lines.Add('*.cut');
    {.$endif}

    {.$ifdef PaintshopProGraphic}
  ExtMemo.Lines.Add('*.psp');
    {.$endif}

    {.$ifdef PortableNetworkGraphic}
  ExtMemo.Lines.Add('*.png');
    {.$endif}
end;
2:begin
  ExtMemo.Lines.Add( '*.bt');
  ExtMemo.Lines.Add( '*.dem');
end;
3:begin
  ExtMemo.Lines.Add(      '*.tmp');
  ExtMemo.Lines.Add(      '~*.*');
  ExtMemo.Lines.Add(      '*.~*');
  ExtMemo.Lines.Add(      '*.?~?');
  ExtMemo.Lines.Add(      '*.aps');
  ExtMemo.Lines.Add(      '*.bak');
  ExtMemo.Lines.Add(      '*.bk?');
  ExtMemo.Lines.Add(      '*.bsc');
  ExtMemo.Lines.Add(      '*.dmp');
  ExtMemo.Lines.Add(      '*.dsm');
  ExtMemo.Lines.Add(      '*.ilk');
  ExtMemo.Lines.Add(      '*.pch');
  ExtMemo.Lines.Add(      '*.rws');
  ExtMemo.Lines.Add(      '*.sbr');
  ExtMemo.Lines.Add(      'backup*.wbk');
  ExtMemo.Lines.Add(      '*.fts');
  ExtMemo.Lines.Add(      '*.gid');
  ExtMemo.Lines.Add(      '*.$$$');
end;
4:begin  {Words}
  ExtMemo.Lines.Add(      '*.doc');
  ExtMemo.Lines.Add(      '*.txt');
  ExtMemo.Lines.Add(      '*.wpd');
  ExtMemo.Lines.Add(      '*.html');
  ExtMemo.Lines.Add(      '*.htm');
end;
5:begin  {Mine}
  ExtMemo.Lines.Add(      '*.db');
  ExtMemo.Lines.Add(      '*.dbf');
end;
6:begin {Other}
  ExtMemo.Lines.Add(      '*.bin');
end;
end;
end;

procedure TdtmPOFForm.ClearExtBtnClick(Sender: TObject);
begin
  ExtMemo.Clear;
end;

procedure TdtmPOFForm.TestSoundRGClick(Sender: TObject);
begin
   Case TestSoundRG.ItemIndex of
   0:DoMessages(7498{9998});  {info}
   1:DoMessages(14999);{ mtConfirmation}
   2:DoMessages(24999);{warn}
   3:DoMessages(29996);{error}
   4:DoMessages(31001);{done}
   end;{case}
end;

procedure TdtmPOFForm.LoadSoundRGClick(Sender: TObject);
begin
  OpenDialog1.Filter := 'Wav files (*.wav)|*.wav';
  OpenDialog1.InitialDir := ILHProgram;
  OpenDialog1.Filename:='*.wav';
  if OpenDialog1.execute then
  begin
   Case LoadSoundRG.ItemIndex of
   0:InfoString:= OpenDialog1.filename; {Info}
   1:ConfirmationString:= OpenDialog1.filename;{ Confirmation}
   2:WarnString:= OpenDialog1.filename;{Warn}
   3:ErrorString:= OpenDialog1.filename;{Error}
   4:DoneString:= OpenDialog1.filename;{Done}
   end;{case}
  end;
end;

procedure TdtmPOFForm.BeepOrWavCBClick(Sender: TObject);
begin
  InfoBeepOn := InfoCB.Checked;
  ConfirmBeepOn := ConfirmationCB.Checked;
  WarningBeepOn := WarningCB.Checked;
  ErrorBeepOn := ErrorsCB.Checked;
  CompletedBeepOn := CompletionCB.Checked;
  VoicesON:=BeepOrWavCB.Checked;
end;

procedure TdtmPOFForm.PageControl1Change(Sender: TObject);
begin
  if ((Sender as TPageControl).ActivePage = ThumbnailsTS)
  then
  begin
  {Use to store the Thumbnail Info}
  {ThumbPath}
  ThumbSize:=SizeUpDown.Position;   {ThumbSize }
  {ThumbColor }
  end;
end;

procedure TdtmPOFForm.ContourIntervalsBtnClick(Sender: TObject);
var
  {MyFilesS: string;}
  I,ContourI,i2,i3:Integer;
  outfile:Textfile;
begin
  SaveDialog1.Filter := 'HTFViewer Palette (*.pal)|*.pal';
  SaveDialog1.InitialDir:=ProgramPath;
  SaveDialog1.FileName:='Contours.pal';
  if (SaveDialog1.Execute) then
  begin
    if UpperCase(ExtractFileExt(SaveDialog1.FileName)) = '.PAL' then
    begin
    AssignFile(outfile, SaveDialog1.FileName);   { File selected in dialog box }
    Rewrite(outfile);
If EColorsRG.Itemindex=0 then
Writeln(outfile,NullValueEdit.text+':0,0,0')
else Writeln(outfile,NullValueEdit.text+':255,255,255');

If CIColorsCB.Checked then
begin
     ContourI:=  Strtoint(DemCIEdit.text);
      i2:=  Strtoint(NullValueEdit.text);
      If (i2 < -32766) then
      i3:= Round( (65534 )/ContourI )
      else
      i3:= Round( (32767 -abs(i2) )/ContourI );
For I:= 1 to ContourI do
begin
If EColorsRG.Itemindex=0 then
    Writeln(outfile, Inttostr(i2+(I*i3))+':'+  {32767:255,255,255}
     Inttostr(0+(I*GetRValue(colorcolorPanel.Color)div ContourI))+','+
     Inttostr(0+(I*GetGValue(colorcolorPanel.Color)div ContourI))+','+
     Inttostr(0+(I*GetBValue(colorcolorPanel.Color)div ContourI)))
     else
    Writeln(outfile, Inttostr(i2+(I*i3))+':'+  {32767:255,255,255}
     Inttostr(255-(I*GetRValue(colorcolorPanel.Color)div ContourI))+','+
     Inttostr(255-(I*GetGValue(colorcolorPanel.Color)div ContourI))+','+
     Inttostr(255-(I*GetBValue(colorcolorPanel.Color)div ContourI)));
end;
end else
begin
     ContourI:=  Strtoint(DemCIEdit.text);
      i2:=  Strtoint(NullValueEdit.text);
      If (i2 < -32766) then
      i3:= Round( (65534 )/ContourI )
      else
      i3:= Round( (32767 -abs(i2) )/ContourI );
    {-32768:0,0,0}
    Writeln(outfile, Inttostr(i2+i3)+':'+  {32767:255,255,255}
     Inttostr(GetRValue(colorcolorPanel.Color))+','+
     Inttostr(GetGValue(colorcolorPanel.Color))+','+
     Inttostr(GetBValue(colorcolorPanel.Color)));
end;
If EColorsRG.Itemindex=0 then
   Writeln(outfile,'32767:255,255,255')
   else Writeln(outfile,'32767:0,0,0');
    CloseFile(outfile);
    end;
  end;
end;

procedure TdtmPOFForm.SavePaletteBtnClick(Sender: TObject);
var
  {MyFilesS: string;}
  outfile:Textfile;
begin
  SaveDialog1.Filter := 'HTFViewer Palette (*.pal)|*.pal';
  SaveDialog1.InitialDir:=ProgramPath;
  SaveDialog1.FileName:='*.pal';
  if (SaveDialog1.Execute) then
  begin
    if UpperCase(ExtractFileExt(SaveDialog1.FileName)) = '.PAL' then
    begin
    AssignFile(outfile, SaveDialog1.FileName);   { File selected in dialog box }
    Rewrite(outfile);
Case EColorsRG.Itemindex of
0:
begin
Writeln(outfile,NullValueEdit.text+  {32767:255,255,255}
     Inttostr(GetRValue(colorcolorPanel.Color))+','+
     Inttostr(GetGValue(colorcolorPanel.Color))+','+
     Inttostr(GetBValue(colorcolorPanel.Color)));
Writeln(outfile,'32767:255,255,255');
end;
1:
begin
Writeln(outfile,NullValueEdit.text+':0,0,0');
{-32768:0,0,0}
Writeln(outfile,'32767:'+  {32767:255,255,255}
     Inttostr(GetRValue(colorcolorPanel.Color))+','+
     Inttostr(GetGValue(colorcolorPanel.Color))+','+
     Inttostr(GetBValue(colorcolorPanel.Color)));
end;
2..3:
begin
If EColorsRG.Itemindex=0 then
Writeln(outfile,NullValueEdit.text+':0,0,0')
else Writeln(outfile,NullValueEdit.text+':255,255,255');
Writeln(outfile, ECI1Edit.text+':'+
     Inttostr(GetRValue(ECI1Edit.Color))+','+
     Inttostr(GetGValue(ECI1Edit.Color))+','+
     Inttostr(GetBValue(ECI1Edit.Color)));
Writeln(outfile, ECI2Edit.text+':'+
     Inttostr(GetRValue(ECI2Edit.Color))+','+
     Inttostr(GetGValue(ECI2Edit.Color))+','+
     Inttostr(GetBValue(ECI2Edit.Color)));
Writeln(outfile, ECI3Edit.text+':'+
     Inttostr(GetRValue(ECI3Edit.Color))+','+
     Inttostr(GetGValue(ECI3Edit.Color))+','+
     Inttostr(GetBValue(ECI3Edit.Color)));
If Is1CB.Checked then
Writeln(outfile, '0'+':'+
     Inttostr(GetRValue(255-ECI4Edit.Color))+','+
     Inttostr(GetGValue(255-ECI4Edit.Color))+','+
     Inttostr(GetBValue(255-ECI4Edit.Color)));
Writeln(outfile, ECI4Edit.text+':'+
     Inttostr(GetRValue(ECI4Edit.Color))+','+
     Inttostr(GetGValue(ECI4Edit.Color))+','+
     Inttostr(GetBValue(ECI4Edit.Color)));
Writeln(outfile, ECI5Edit.text+':'+
     Inttostr(GetRValue(ECI5Edit.Color))+','+
     Inttostr(GetGValue(ECI5Edit.Color))+','+
     Inttostr(GetBValue(ECI5Edit.Color)));
Writeln(outfile, ECI6Edit.text+':'+
     Inttostr(GetRValue(ECI6Edit.Color))+','+
     Inttostr(GetGValue(ECI6Edit.Color))+','+
     Inttostr(GetBValue(ECI6Edit.Color)));
Writeln(outfile, ECI7Edit.text+':'+
     Inttostr(GetRValue(ECI7Edit.Color))+','+
     Inttostr(GetGValue(ECI7Edit.Color))+','+
     Inttostr(GetBValue(ECI7Edit.Color)));
Writeln(outfile, ECI8Edit.text+':'+
     Inttostr(GetRValue(ECI8Edit.Color))+','+
     Inttostr(GetGValue(ECI8Edit.Color))+','+
     Inttostr(GetBValue(ECI8Edit.Color)));
Writeln(outfile, ECI9Edit.text+':'+
     Inttostr(GetRValue(ECI9Edit.Color))+','+
     Inttostr(GetGValue(ECI9Edit.Color))+','+
     Inttostr(GetBValue(ECI9Edit.Color)));
If EColorsRG.Itemindex=0 then
   Writeln(outfile,'32767:255,255,255')
   else Writeln(outfile,'32767:0,0,0');
end;

end;{Case}
    CloseFile(outfile);

(*
Blue-Green.pal
-32768:0,0,0
-9000:0,0,0
0:0,0,255
1:0,255,0
9000:0,0,0
32767:0,0,0
     ECI1Edit.Color:=
            -50000.. - 7001: {Smog 255,255,255}
            -7000.. - 6001: { Purple 255,0,255}
            -6000.. - 2001: {Blue 0,0,255 }
            -2000..0: {Aqua 0,255,255 }
            1..400: {  Green 0,255,0}
            401..1000: {Yellow 255,255,0}
            1001..2000: { Red 255,0,0}
            2001..3000: { Purple 255,0,255}
            3001..50000: { Smog 255,255,255}
{Blue 0,0,255 }
{Aqua 0,255,255 }
{Green 0,255,0}
{Yellow 255,255,0}
{Red 255,0,0}
{Purple 255,0,255}
{Smog 255,255,255}
*)
    end ;
  end;
end;


procedure TdtmPOFForm.EColorsRGClick(Sender: TObject);
begin
  If EColorsRG.Itemindex=0 then
  begin
     ColorDialog1.Color:=colorcolorPanel.Color;
   If ColorDialog1.Execute then
   begin
     colorcolorPanel.Color:=ColorDialog1.Color;
     colorcolorPanel.Caption:=
     Inttostr(GetRValue(ColorDialog1.Color))+','+
     Inttostr(GetGValue(ColorDialog1.Color))+','+
     Inttostr(GetBValue(ColorDialog1.Color));
     colorcolorPanel.Hint:= colorcolorPanel.Caption;
   end;
  end;
end;


procedure TdtmPOFForm.ECI1EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI1Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI1Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI2EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI2Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI2Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI3EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI3Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI3Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI4EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI4Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI4Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI5EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI5Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI5Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI6EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI6Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI6Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI7EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI7Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI7Edit.Color:=ColorDialog1.Color;
   end;
end;

procedure TdtmPOFForm.ECI8EditDblClick(Sender: TObject);
begin
   ColorDialog1.Color:= ECI8Edit.Color;
   If ColorDialog1.Execute then
   begin
     ECI8Edit.Color:=ColorDialog1.Color;
   end;
end;



procedure TdtmPOFForm.MapBorderColorClick(Sender: TObject);
begin
  ColorDialog1.Color := MapBorderColor.Color;
  if ColorDialog1.execute then
    MapBorderColor.Color := ColorDialog1.Color;
  MapBordersColor := MapBorderColor.Color;
end;

procedure TdtmPOFForm.MapGridColorClick(Sender: TObject);
begin
  ColorDialog1.Color := MapGridColor.Color;
  if ColorDialog1.execute then
    MapGridColor.Color := ColorDialog1.Color;
  MapGridsColor := MapGridColor.Color;
end;

procedure TdtmPOFForm.MapDataColorClick(Sender: TObject);
begin
  ColorDialog1.Color := MapDataColor.Color;
  if ColorDialog1.execute then
    MapDataColor.Color := ColorDialog1.Color;
  MapDatasColor := MapDataColor.Color;
end;

procedure TdtmPOFForm.MapBackColorClick(Sender: TObject);
begin
  ColorDialog1.Color := MapBackColor.Color;
  if ColorDialog1.execute then
    MapBackColor.Color := ColorDialog1.Color;
  MapBacksColor := MapBackColor.Color;
end;

procedure TdtmPOFForm.SlopeDirectionRGClick(Sender: TObject);
begin
  SlopeDirection:=SlopeDirectionRG.ItemIndex;
end;

procedure TdtmPOFForm.SetCIBtnClick(Sender: TObject);
begin
  SlopeDirection:=SlopeDirectionRG.ItemIndex;
  Contours:=Strtoint(DemCIEEdit.Text);
  UseContourColors := ContourColorsCB.Checked;
end;



procedure TdtmPOFForm.CurrentColorPanelClick(Sender: TObject);
begin
  if ColorDialog1.Execute then
  begin
    CurrentColorPanel.Color := ColorDialog1.Color;
    CurrentColor := CurrentColorPanel.Color;
  end;
end;

end.
