unit dtmNavFrm;
{part of the HTF Generation Utility
Part of GLScene library
http://glscene.org}
{modified by Ivan Lee Herring, 2002}
interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms,
  Dialogs,  HeightTileFile, GR32, GR32_Layers, GR32_Image;

type
  TNavForm = class(TForm)
    Image: TImage32;
    procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    FPickX, FPickY : Integer;
  public
    { Public declarations }
    function Execute(htf : THeightTileFile) : Boolean;

    property PickX : Integer read FPickX;
    property PickY : Integer read FPickY;
  end;

var
  NavForm: TNavForm;

implementation

{$R *.dfm}

uses dtmfrm, dtmPOFvar;

procedure TNavForm.FormCreate(Sender: TObject);
begin
  top := NavFormY;
  left := NavFormX;
end;

procedure TNavForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  NavFormX := NavForm.left;
  NavFormY := NavForm.top;
end;

{Rewrite so possible to ALWAYS have a Navigator visible
 re-Compute Bitmap only when htf changes
 and it can select an AREA or something}

function TNavForm.Execute(htf : THeightTileFile) : Boolean;
var
   i, x, y, w, s, wx, wy : Integer;
begin
   // Computes scaling so that preview window isn't too small
   with htf do
   begin
      wx:=(SizeX+TileSize div 2) div TileSize;
      wy:=(SizeY+TileSize div 2) div TileSize;
   end;
   if wx<wy then
      w:=wy
   else w:=wx;
   s:=1;
   while w<256 do
   begin
      w:=w*2;
      s:=s*2;
   end;
   Image.Scale:=s;
   // Prepare the world tile map
   with Image.Bitmap do
   begin
      Width:=wx;
      Height:=wy;
      Clear(clGray32);
      for i:=0 to htf.TileCount-1 do with htf.Tiles[i]^ do
      begin
         x:=(left+(width div 2)) div htf.TileSize;
         y:=(top+(height div 2)) div htf.TileSize;
         PixelS[x, y]:=heightColor[average];
      end;
   end;
   // Couldn't get the form's AutoSize to work...
   Image.Width:=wx*s;
   Image.Height:=wy*s;
   Width:=Image.Width;
   Height:=Image.Height;
   // Show the Nav map
   Result:=(ShowModal=mrOk);
   // Convert back to world coordinates
   if Result then
   begin
      FPickX:=((FPickX*htf.TileSize) div s) - htf.TileSize;
      FPickY:=((FPickY*htf.TileSize) div s) - htf.TileSize;
   end;
end;

procedure TNavForm.ImageMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer; Layer: TCustomLayer);
var
  SaveFileName, BackupName: string;
begin
   if ((ssLeft in shift)and(ssAlt in shift))then
   begin
   {Save bitmap image}
   SaveFileName:=ImagePath+ChangeFileExt(HTFName,'.bmp');
    if FileExists(SaveFileName) then
    begin
      BackupName := ExtractFileName(SaveFileName);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(SaveFileName, BackupName) then
        raise Exception.Create('Unable to create backup file.');
    end;
   Image.Bitmap.SaveToFile(SaveFileName);
   end else
   begin
   FPickX:=X;
   FPickY:=Y;
   ModalResult:=mrOk;
   end;
end;



end.
