unit dtmLegend;
{by Ivan Lee Herring, 2002}
interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls, ExtDlgs,
  GR32, GR32_Image;

type
  TLegendForm = class(TForm)
    ColorDialog1: TColorDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox3: TGroupBox;
    SetHTFBtn: TSpeedButton;
    HTFYLabel: TLabel;
    HTFXLabel: TLabel;
    XLabel: TLabel;
    X2Label: TLabel;
    HTFXEdit: TEdit;
    HTFYEdit: TEdit;
    GroupBox1: TGroupBox;
    XUpBtn: TSpeedButton;
    XDownBtn: TSpeedButton;
    YUpBtn: TSpeedButton;
    YDownBtn: TSpeedButton;
    SetBtn: TSpeedButton;
    ReSetBtn: TSpeedButton;
    XLonEdit: TEdit;
    YLatEdit: TEdit;
    HelpBtn: TBitBtn;
    CloseBtn: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog1: TSaveDialog;
    GroupBox4: TGroupBox;
    OpenTextureBtn: TSpeedButton;
    OpenActorBtn: TSpeedButton;
    OpenSetBtn: TSpeedButton;
    OtsNameEdit: TEdit;
    ActorFileNameEdit: TEdit;
    TextureFileNameEdit: TEdit;
    SaveSetBtn: TSpeedButton;
    OpenWpnBtn: TSpeedButton;
    WeaponFileNameEdit: TEdit;
    OpenWpnTextureBtn: TSpeedButton;
    WpnTextureFileNameEdit: TEdit;
    OpenPictureDialog1: TOpenPictureDialog;
    InDatumCB: TComboBox;
    DoDatumBtn: TSpeedButton;
    Panel1: TPanel;
    LegendLayerCB: TComboBox;
    ActorObjectCB: TCheckBox;
    TabSheet3: TTabSheet;
    Antialiase: TCheckBox;
    Label3: TLabel;
    LineAlpha: TScrollBar;
    Label4: TLabel;
    FillAlpha: TScrollBar;
    LineThickness: TScrollBar;
    ThickOutline: TCheckBox;
    OutlineThicknessLabel: TLabel;
    Label6: TLabel;
    OutlineColorPanel: TPanel;
    LineOpacityLabel: TLabel;
    FillOpacityLabel: TLabel;
    Label5: TLabel;
    TabSheet4: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    LegendColorsPanel: TPanel;
    GroupBox2: TGroupBox;
    OtsNameEditTextEdit: TEdit;
    PointSizeScrollBar: TScrollBar;
    Label8: TLabel;
    PointSizeLabel: TLabel;
    ProjectSetotsFileBtn: TSpeedButton;
    LineScrollBar: TScrollBar;
    Label10: TLabel;
    StippleSizeLabel: TLabel;
    LineStippledCB: TCheckBox;
    Image32: TImage32;
    StippleColorPanel: TPanel;
    StippleStepper: TUpDown;
    StippleStepperLabel: TLabel;
    StippleCountBtn: TSpeedButton;
    StippleCountLabel: TLabel;
    ProjectActorotsFileBtn: TSpeedButton;
    ProjectActorEdit: TEdit;
    Label7: TLabel;
    Label9: TLabel;
    ShapeTypeLabel: TLabel;
    ViewChangesBtn: TSpeedButton;
    PointTypeRG: TRadioGroup;
    CanvasLineUpDown: TUpDown;
    CanvasLineSizeLabel: TLabel;
    Bevel1: TBevel;
    DtpHelpBtn: TSpeedButton;
    DtpExitBtn: TSpeedButton;
    PolyFilledCB: TCheckBox;
    TextureOnlyCB: TCheckBox;
    OtsSizeEdit: TEdit;
    Label11: TLabel;
    TabSheet5: TTabSheet;
    procedure FormCreate(Sender: TObject);
    procedure DtpExitBtnClick(Sender: TObject);
    procedure DtpHelpBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LegendColorsPanelClick(Sender: TObject);
    procedure LegendLayerCBClick(Sender: TObject);
    procedure XUpBtnClick(Sender: TObject);

    procedure SetBtnClick(Sender: TObject);
    procedure XDownBtnClick(Sender: TObject);
    procedure ReSetBtnClick(Sender: TObject);
    procedure YUpBtnClick(Sender: TObject);
    procedure YDownBtnClick(Sender: TObject);
    procedure DoDatumBtnClick(Sender: TObject);
    procedure SetHTFBtnClick(Sender: TObject);
    procedure OpenSetBtnClick(Sender: TObject);
    procedure SaveSetBtnClick(Sender: TObject);
    procedure OpenActorBtnClick(Sender: TObject);
    procedure OpenTextureBtnClick(Sender: TObject);
    procedure OpenWpnBtnClick(Sender: TObject);
    procedure OpenWpnTextureBtnClick(Sender: TObject);
    procedure OutlineColorPanelClick(Sender: TObject);
    procedure LineAlphaChange(Sender: TObject);
    procedure AntialiaseClick(Sender: TObject);
    procedure FillAlphaChange(Sender: TObject);
    procedure LineThicknessChange(Sender: TObject);
    procedure PointSizeScrollBarChange(Sender: TObject);
    procedure ProjectSetotsFileBtnClick(Sender: TObject);
    procedure ViewChangesBtnClick(Sender: TObject);
    procedure LineScrollBarChange(Sender: TObject);
    procedure StippleColorPanelClick(Sender: TObject);
    procedure StippleStepperClick(Sender: TObject; Button: TUDBtnType);
    procedure StippleCountBtnClick(Sender: TObject);
    procedure ProjectActorotsFileBtnClick(Sender: TObject);
    procedure PointTypeRGClick(Sender: TObject);
    procedure CanvasLineUpDownClick(Sender: TObject; Button: TUDBtnType);

procedure PaintMyPoints;
    procedure FormDestroy(Sender: TObject);
    procedure PolyFilledCBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  LegendForm: TLegendForm;

implementation

{$R *.DFM}

uses dtmGlobals, dtmfrm;

procedure TLegendForm.FormDestroy(Sender: TObject);
begin
    {}
end;
procedure TLegendForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  LegendFormY := LegendForm.top;
  LegendFormX := LegendForm.left;
end;
procedure TLegendForm.DtpExitBtnClick(Sender: TObject);
begin
  Close;
end;
procedure TLegendForm.DtpHelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(6000);
end;

procedure TLegendForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(6500);
end;

procedure TLegendForm.FormCreate(Sender: TObject);
var
 i, LayerDo,Startat:Integer;
begin
  top := LegendFormY;
  left := LegendFormX;
  {Fill Items with layers}
    For Startat:=0 to LayersLoaded-1 do
    Begin
      LayerDo:=LayersControlArray[Startat];
      LegendLayerCB.Items.Add( LayA[LayerDo].Filename);
    end;
  Image32.SetupBitmap;
  LegendLayerCB.ItemIndex:=(CurrentLayer-1);
  CurrentLayer:= LegendLayerCB.ItemIndex+1;
  LegendColorsPanel.Color := LayA[CurrentLayer].LayerColor;
  OutlineColorPanel.Color:= LayA[CurrentLayer].OutLineColor;
   Antialiase.Checked:=  LayA[CurrentLayer].PolygonAntialiased;
   PolyFilledCB.Checked:= LayA[CurrentLayer].PolyFilled;    
   ThickOutline.Checked:= LayA[CurrentLayer].UseOutlinePoly;
   LineAlpha.Position:=  LayA[CurrentLayer].LineAlphaPosition;
   LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition]);
   FillAlpha.Position:=  LayA[CurrentLayer].FillAlphaPosition;
   FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition]);
   LineThickness.Position:=  Round(LayA[CurrentLayer].LineSize*10);
   OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize]);
   PointSizeScrollBar.Position:=  ((LayA[CurrentLayer].PointSize));
   PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
   LineScrollBar.Position:=  Round(LayA[CurrentLayer].StippleStep*100);
   StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
   StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
   StippleColorPanel.Color :=  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
   StippleStepperLabel.Caption :=Format('(%d)', [StippleStepper.Position]);
   StippleCountLabel.Caption :=Format('(%d)', [((LayA[CurrentLayer].StippleColorCount))]);
   StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;

  CanvasLineUpDown.Position:=LayA[CurrentLayer].CanvasLineSize;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);

  i:= LayA[CurrentLayer].ShpType;
  Case i of
 0: ShapeTypeLabel.Caption:='Null Shape';
 1: ShapeTypeLabel.Caption:='Point';
 3: ShapeTypeLabel.Caption:='PolyLine';
 5: ShapeTypeLabel.Caption:='Polygon';
 8: ShapeTypeLabel.Caption:='MultiPoint';
11: ShapeTypeLabel.Caption:='PointZ';
13: ShapeTypeLabel.Caption:='PolyLineZ';
15: ShapeTypeLabel.Caption:='PolygonZ';
18: ShapeTypeLabel.Caption:='MultiPointZ';
21: ShapeTypeLabel.Caption:='PointM';
23: ShapeTypeLabel.Caption:='PolyLineM';
25: ShapeTypeLabel.Caption:='PolygonM';
28: ShapeTypeLabel.Caption:='MultiPointM';
31: ShapeTypeLabel.Caption:='MultiPatch';      {Fan or Strip     }
end;{case}

  {ots}
  OtsNameEditTextEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  OtsNameEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  ProjectActorEdit.Text:=ProjectActorOtsFilename;

  {HTFix}
  XLabel.Caption:=FLoattostr(LayA[CurrentLayer].OffsetX);
  X2Label.Caption:=FLoattostr(LayA[CurrentLayer].XMin);

  DShiftOffsetX:=TMaxOffsetX;
  XLonEdit.Text:=FloattoStr(TMaxOffsetX);
  DShiftOffsetY:=TMaxOffsetY;
  YLatEdit.Text:=FloattoStr(TMaxOffsetY);

HTFXLabel.Caption:=FloattoStr(TMaxOffsetX*TMaxOffX);
HTFYLabel.Caption:=FloattoStr(TMaxOffsetY*TMaxOffY);
HTFXEdit.Text:=FloattoStr(TMaxOffsetX*TMaxOffX);
HTFYEdit.Text:=FloattoStr(TMaxOffsetY*TMaxOffY);

  If FileExists(ChangeFileExt(
  LayA[CurrentLayer].Path+
  LayA[CurrentLayer].Filename,'.vrp'))then
  begin
    DoDatumBtn.Enabled:=True;
    {Read ProjectionRecord}
  end else
  begin
    DoDatumBtn.Enabled:=False;
    InDatumCB.ItemIndex:=24;{UnknownWGS84=23}
  end;
{  LineScrollBar(Sender);}
end;
{procedure THtfForm.ReadAnyVersionProj(ReadFileName:String);
procedure THtfForm.ReadVersionProj(ReadFileName:String);
procedure THtfForm.ReadVer1Proj(ReadFileName:String);}

procedure TLegendForm.LegendLayerCBClick(Sender: TObject);
var i:Integer;
begin
  CurrentLayer:= LegendLayerCB.ItemIndex+1;
  i:= LayA[CurrentLayer].ShpType;
  Case i of
 0: ShapeTypeLabel.Caption:='Null Shape';
 1: ShapeTypeLabel.Caption:='Point';
 3: ShapeTypeLabel.Caption:='PolyLine';
 5: ShapeTypeLabel.Caption:='Polygon';
 8: ShapeTypeLabel.Caption:='MultiPoint';
11: ShapeTypeLabel.Caption:='PointZ';
13: ShapeTypeLabel.Caption:='PolyLineZ';
15: ShapeTypeLabel.Caption:='PolygonZ';
18: ShapeTypeLabel.Caption:='MultiPointZ';
21: ShapeTypeLabel.Caption:='PointM';
23: ShapeTypeLabel.Caption:='PolyLineM';
25: ShapeTypeLabel.Caption:='PolygonM';
28: ShapeTypeLabel.Caption:='MultiPointM';
31: ShapeTypeLabel.Caption:='MultiPatch';      {Fan or Strip     }
end;{case}
  LegendColorsPanel.Color := LayA[CurrentLayer].LayerColor;
  OutlineColorPanel.Color:= LayA[CurrentLayer].OutLineColor;
   Antialiase.Checked:=  LayA[CurrentLayer].PolygonAntialiased;
   PolyFilledCB.Checked:= LayA[CurrentLayer].PolyFilled;
   ThickOutline.Checked:= LayA[CurrentLayer].UseOutlinePoly;
   LineAlpha.Position:=  LayA[CurrentLayer].LineAlphaPosition;
   LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition]);
   FillAlpha.Position:=  LayA[CurrentLayer].FillAlphaPosition;
   FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition]);
   LineThickness.Position:=  Round(LayA[CurrentLayer].LineSize*10);
   OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize]);
   PointSizeScrollBar.Position:=  ((LayA[CurrentLayer].PointSize));
   PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
   LineScrollBar.Position:=  Round(LayA[CurrentLayer].StippleStep*100);
   StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
   StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
   StippleColorPanel.Color :=  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
   StippleStepperLabel.Caption :=Format('(%d)', [StippleStepper.Position]);
   StippleCountLabel.Caption :=Format('(%d)', [((LayA[CurrentLayer].StippleColorCount))]);
   StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;

  CanvasLineUpDown.Position:=LayA[CurrentLayer].CanvasLineSize;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);

   LineScrollBarChange(Sender);
  {ots}
  OtsNameEditTextEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  OtsNameEdit.Text:=LayA[CurrentLayer].OtsNameEditText;

  {HTFix}
  XLabel.Caption:=FLoattostr(LayA[CurrentLayer].OffsetX);
  X2Label.Caption:=FLoattostr(LayA[CurrentLayer].XMin);

  If FileExists(ChangeFileExt(
  LayA[CurrentLayer].Path+
  LayA[CurrentLayer].Filename,'.vrp'))then
  begin
    DoDatumBtn.Enabled:=True;
    {Read ProjectionRecord}
  end else
  begin
    DoDatumBtn.Enabled:=False;
    InDatumCB.ItemIndex:=24;{UnknownWGS84=23}
  end;
end;

procedure TLegendForm.DoDatumBtnClick(Sender: TObject);
begin
{InDatumCB.ItemIndex  WGS84=23

buzDatum, buzGlobal

Procedure ConvertDatums(
                    LongXCoord, LatYCoord:Double;
                    var XCoord, YCoord:Double);}
end;
(*****************************************************)
(*****************************************************)



(*****************************************************)
(*****************************************************)
procedure TLegendForm.XUpBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=DShiftOffsetX+TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
end;

procedure TLegendForm.XDownBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=DShiftOffsetX-TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
end;

procedure TLegendForm.YUpBtnClick(Sender: TObject);
begin
    DShiftOffsetY:=DShiftOffsetY+TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
end;

procedure TLegendForm.YDownBtnClick(Sender: TObject);
begin
    DShiftOffsetY:=DShiftOffsetY-TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
end;

procedure TLegendForm.ReSetBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
    DShiftOffsetY:=TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
    DTMform.PrepareBitmap;
end;

procedure TLegendForm.SetBtnClick(Sender: TObject);
begin
  DTMform.PrepareBitmap;
{XLonEdit.Text}
{YLatEdit.Text}
end;

(*
    TMaxOffsetX:=( (360 /htf.SizeX));
    TMaxOffsetY:=( (180 /htf.SizeY));
    TMaxOffX:= htf.SizeX;
    TMaxOffY:= htf.SizeY;

        TMinOffX:= curX;
        TMinOffY:= curY;
        DVDORedraw;


    If CurrentLayer =1 then
    Begin
      MinOffX:=LayA[CurrentLayer].XMin;
      MinOffY:=LayA[CurrentLayer].YMin;
      MaxOffX:=LayA[CurrentLayer].XMax;
      MaxOffY:=LayA[CurrentLayer].YMax;
    End;


      {Offset is +- to center data to 0,0}
      TMinOffX:= TMinOffX*TMaxOffsetX;
      TMinOffY:= TMinOffY*TMaxOffsetY;
      ScreenScale :=   TMaxOffsetX;

              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].XMax;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].YMax;
              DXdtemp:=MaxOffsetX +dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              Image321.Bitmap.FillRect(DXI-2,DYI-2,DXI+2,DYI+2,PointColor);


              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
              DXdtemp:=MaxOffsetX +dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              Editarray[INumPoints-1].X:= DXI;
              Editarray[INumPoints-1].Y:= DYI;
*)

procedure TLegendForm.SetHTFBtnClick(Sender: TObject);
begin
  {isHTFLoaded}
  TMaxOffsetX:=( (strtofloat(HTFXEdit.Text) /TMaxOffX));
  TMaxOffsetY:=( (strtofloat(HTFYEdit.Text) /TMaxOffX));
  HTFXLabel.Caption:=FloattoStr(TMaxOffsetX*TMaxOffX);
  HTFYLabel.Caption:=FloattoStr(TMaxOffsetY*TMaxOffX);
  {HTFXEdit.Text:=FloattoStr(TMaxOffsetX*TMaxOffX);
   HTFYEdit.Text:=FloattoStr(TMaxOffsetY*TMaxOffX); }
end;
(*****************************************************)
(*****************************************************)





(*****************************************************)
   {ProjectPath
   MapsPath
   TigerPath md2 smd qc
   DXFPath dxf 3ds
3D Formats: 3DS, OBJ, SMD, MD2, TIN, PLY, STL
2D Formats: JPG, BMP, TGA, CEL etc.
   }
(*****************************************************)
procedure TLegendForm.OpenSetBtnClick(Sender: TObject);
var
 ActorFileName,TextureFileName,
 WeaponFileName, WpnTextureFileName,
 S : string;
 F: TextFile;
begin
  {OpenDialog.InitialDir:=ProjectPath;}
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (OtsNameEdit.Text=NoName) then
     OpenDialog.Filename:= '*.ots' else
  If (OtsNameEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= OtsNameEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    AssignFile(F, OpenDialog.FileName);
    Reset(F);
    Readln(F, S);
    If (S='GlobalObjectActorTerrain Version 1.0') then
    begin
             {Read file and get ActorFileName
              and TextureFileName
                  WeaponFileName
                  WpnTextureFileName
               Filenames...}
    Readln(F, S);
    If S='True' then ActorObjectCB.Checked:=True
                else ActorObjectCB.Checked:=False;{Boolean}
    Readln(F, S);
    If S='True'  then TextureOnlyCB.Checked:=True
                 else TextureOnlyCB.Checked:=False;
      OtsNameEdit.Text:= OpenDialog.FileName;
      Readln(F, ActorFileName);
      ActorFileNameEdit.Text:=ActorFileName;
      Readln(F, TextureFileName);
      TextureFileNameEdit.Text:=TextureFileName;
      Readln(F, WeaponFileName);
      WeaponFileNameEdit.Text:=WeaponFileName;
      Readln(F, WpnTextureFileName);
      WpnTextureFileNameEdit.Text:=WpnTextureFileName;
      Readln(F, S);
      OtsSizeEdit.Text:=S;
      CloseFile(F);
    end;
  end;
end;

procedure TLegendForm.SaveSetBtnClick(Sender: TObject);
var
{ ActorFileName,TextureFileName,
 WeaponFileName, WpnTextureFileName,}
 WhatsMyLine : string;
 F: TextFile;
begin  { for Actor and Texture}
  If ((FileExists(ActorFileNameEdit.Text))
      and(FileExists(TextureFileNameEdit.Text))) then
  begin
    SaveDialog1.InitialDir:=ProjectPath;
    SaveDialog1.Filter:= 'Object + Texture Set (*.ots)|*.ots';
    SaveDialog1.Filename:= OtsNameEdit.Text;
    if SaveDialog1.Execute then
    if UpperCase(ExtractFileExt(SaveDialog1.Filename)) = '.OTS' then
    begin
      ProjectPath:=ExtractFilePath(SaveDialog1.Filename);
      AssignFile(F, SaveDialog1.FileName);
      Rewrite(F);
      {S:='GlobalObjectActorTerrain Version 1.0';} {GetYourOats}
      writeln(F, 'GlobalObjectActorTerrain Version 1.0');
    If ActorObjectCB.Checked then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);
    If TextureOnlyCB.Checked  then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);{}
             {Read file and get ActorFileName
              and TextureFileName
                  WeaponFileName
                  WpnTextureFileName
               Filenames...}
      If length(ActorFileNameEdit.Text)<1 then
      ActorFileNameEdit.Text:= NoName;
      writeln(F, ActorFileNameEdit.Text);
      If length(TextureFileNameEdit.Text)<1 then
      TextureFileNameEdit.Text:= NoName;
      writeln(F, TextureFileNameEdit.Text);
{      S:='nada';  }
      If length(WeaponFileNameEdit.Text)<1 then
      WeaponFileNameEdit.Text:= NoName;
      writeln(F, WeaponFileNameEdit.Text);
      If length(WpnTextureFileNameEdit.Text)<1 then
      WpnTextureFileNameEdit.Text:= NoName;
      writeln(F, WpnTextureFileNameEdit.Text);

      If length(OtsSizeEdit.Text)<1 then
      OtsSizeEdit.Text:= '1';
      writeln(F, OtsSizeEdit.Text);
      CloseFile(F);
    end;
  end;
end;
   {TigerPath md2 smd qc ??? qc IS a kind of ots !!!
    SMD, MD2|*. SMD;*. MD2
    DXFPath dxf 3ds
    3DS, OBJ, TIN, PLY, STL|*.3DS;*. OBJ;*.TIN; *.PLY; *.STL
   }
procedure TLegendForm.OpenActorBtnClick(Sender: TObject);
begin
  If ActorObjectCB.Checked then
  begin
    OpenDialog.InitialDir:=TigerPath;
    OpenDialog.Filter:= 'Object (*.smd;*.md2)|*.smd;*.md2';
    OpenDialog.Filename:= '*.smd';
    OpenPictureDialog1.InitialDir:=TigerPath;
  end
  else
  begin
    OpenDialog.InitialDir:=DXFPath;
    OpenDialog.Filter:= 'Object (*.3ds)|*.3DS;*. OBJ;*.TIN;*.PLY;*.STL';
    OpenDialog.Filename:= '*.3ds';
    OpenPictureDialog1.InitialDir:=DXFPath;
  end;
  if OpenDialog.Execute then
  ActorFileNameEdit.Text:=OpenDialog.Filename;
end;

procedure TLegendForm.OpenTextureBtnClick(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  TextureFileNameEdit.Text:=OpenPictureDialog1.Filename;
end;

procedure TLegendForm.OpenWpnBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  WeaponFileNameEdit.Text:=OpenDialog.Filename;
end;

procedure TLegendForm.OpenWpnTextureBtnClick(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  WpnTextureFileNameEdit.Text:=OpenPictureDialog1.Filename;
end;
(*****************************************************)
(*****************************************************)



(*****************************************************)
(*****************************************************)
procedure TLegendForm.LegendColorsPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].LayerColor;
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    LegendColorsPanel.Color := ColorDialog1.Color;
    {MapGridsColor := LegendColorsPanel.Color;}
    LayA[CurrentLayer].LayerColor:=LegendColorsPanel.Color;
  end;
end;

procedure TLegendForm.OutlineColorPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].OutLineColor;
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    OutlineColorPanel.Color := ColorDialog1.Color;
    {MapGridsColor := LegendColorsPanel.Color;}
    LayA[CurrentLayer].OutLineColor:=OutlineColorPanel.Color;
  end;
end;
(*****************************************************)
(*****************************************************)

procedure TLegendForm.ViewChangesBtnClick(Sender: TObject);
begin
  DTMform.PrepareBitmap;
end;

(*****************************************************)
(*****************************************************)
procedure TLegendForm.AntialiaseClick(Sender: TObject);
begin      {False}
    LayA[CurrentLayer].PolygonAntialiased:=Antialiase.Checked;
end;

procedure TLegendForm.PolyFilledCBClick(Sender: TObject);
begin{}
    LayA[CurrentLayer].PolyFilled:=PolyFilledCB.Checked;
end;

procedure TLegendForm.LineAlphaChange(Sender: TObject);
begin   {255}
  LayA[CurrentLayer].LineAlphaPosition:=LineAlpha.Position;
  LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition])
end;

procedure TLegendForm.FillAlphaChange(Sender: TObject);
begin     {127}
  LayA[CurrentLayer].FillAlphaPosition:=FillAlpha.Position;
  FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition])
end;

procedure TLegendForm.LineThicknessChange(Sender: TObject);
begin    {10 of 200}
  LayA[CurrentLayer].UseOutlinePoly := ThickOutline.Checked;
  LayA[CurrentLayer].LineSize := LineThickness.Position / 10;
  OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize])
end;



procedure TLegendForm.StippleCountBtnClick(Sender: TObject);
begin
  Inc(LayA[CurrentLayer].StippleColorCount);
  StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;
  StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
  StippleColorPanel.Color := clBlack;
  SetLength(LayA[CurrentLayer].StippleColorArray,LayA[CurrentLayer].StippleColorCount);
  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position]:=
  StippleColorPanel.Color;
  StippleCountLabel.Caption:=InttoStr(LayA[CurrentLayer].StippleColorCount);
end;

procedure TLegendForm.StippleStepperClick(Sender: TObject;
  Button: TUDBtnType);
begin
  StippleColorPanel.Color :=
    LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
  {LayA[CurrentLayer].StippleStepper:=StippleStepper.Position;}
  StippleStepperLabel.Caption:=Format('(%d)', [StippleStepper.Position]);
end;

procedure TLegendForm.LineScrollBarChange(Sender: TObject);
var
I:Integer;
NewStipple: array of TColor32;
begin
  Image32.Bitmap.Clear(clWhite32);
  LayA[CurrentLayer].UseStippleStep := LineStippledCB.Checked;
  LayA[CurrentLayer].StippleStep := LineScrollBar.Position / 100;
  StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
    {SetStipple([clWhite32, clRed32, clGreen32, 0, 0, 0]);
     SetStipple([clGreen32, clGreen32, clGreen32, 0, 0, clWhite32, 0, 0]);
    SetStipple([clWhite32, $00FFFFFF]);
    SetStipple([clWhite32, clWhite32, clWhite32, clWhite32, 0, 0, 0, 0]);
}
  SetLength(NewStipple,LayA[CurrentLayer].StippleColorCount);
    For I:=0 to LayA[CurrentLayer].StippleColorCount-1 do
    NewStipple[I]:=Color32(LayA[CurrentLayer].StippleColorArray[I]);
  Image32.Bitmap.SetStipple(NewStipple);
  Image32.Bitmap.StippleStep := LayA[CurrentLayer].StippleStep;

  Image32.Bitmap.MoveToF(10, 10);
  If LayA[CurrentLayer].UseStippleStep then
   Image32.Bitmap.LineToFSP(110, 10) else
  begin
    Image32.Bitmap.PenColor :=
            Color32(LayA[CurrentLayer].LayerColor);
    Image32.Bitmap.LineToS(110, 10);
  end;
end;

procedure TLegendForm.StippleColorPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    StippleColorPanel.Color := ColorDialog1.Color;
    LayA[CurrentLayer].StippleColorArray[StippleStepper.Position]:= ColorDialog1.Color;
  end;
end;

procedure TLegendForm.ProjectSetotsFileBtnClick(Sender: TObject);
begin
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (OtsNameEditTextEdit.Text='Nada.ots') then
     OpenDialog.Filename:= '*.ots' else
  If (OtsNameEditTextEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= OtsNameEditTextEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    OtsNameEditTextEdit.Text:=(OpenDialog.Filename);
    LayA[CurrentLayer].OtsNameEditText:=OpenDialog.Filename;
  end;
end;
(*****************************************************)
procedure TLegendForm.ProjectActorotsFileBtnClick(Sender: TObject);
begin
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (ProjectActorEdit.Text='Nada.ots') then
     OpenDialog.Filename:= '*.ots' else
  If (ProjectActorEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= ProjectActorEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    ProjectActorEdit.Text:=(OpenDialog.Filename);
    ProjectActorOtsFilename:=OpenDialog.Filename;
  end;
end;
(*****************************************************)
(*****************************************************)


(*****************************************************)
(*****************************************************)
procedure TLegendForm.PointSizeScrollBarChange(Sender: TObject);
begin
  LayA[CurrentLayer].PointSize:=PointSizeScrollBar.Position;
  PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
  PaintMyPoints;
end;

procedure TLegendForm.PointTypeRGClick(Sender: TObject);
var PointCaption:String;
begin
  {Points: 0:Dot 1:Circle 2:DotInCircle 3:FilledCircle
        4:PlusSign 5:X 6:Box 7:XInBox 8:FilledBox}
  PointCaption:='Point Type: ';
  Case PointTypeRG.ItemIndex of {Points:}
    0:PointTypeRG.Caption:=PointCaption+'Dot';
    1:PointTypeRG.Caption:=PointCaption+'Circle';
    2:PointTypeRG.Caption:=PointCaption+'DotInCircle';
    3:PointTypeRG.Caption:=PointCaption+'FilledCircle';
    4:PointTypeRG.Caption:=PointCaption+'PlusSign';
    5:PointTypeRG.Caption:=PointCaption+'X';
    6:PointTypeRG.Caption:=PointCaption+'Box';
    7:PointTypeRG.Caption:=PointCaption+'XInBox';
    8:PointTypeRG.Caption:=PointCaption+'FilledBox';
  End;{Case}
  LayA[CurrentLayer].CurrentPointType:=PointTypeRG.ItemIndex;
  PaintMyPoints;
end;

procedure TLegendForm.CanvasLineUpDownClick(Sender: TObject; Button: TUDBtnType);
begin
  LayA[CurrentLayer].CanvasLineSize:=CanvasLineUpDown.Position;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);
  PaintMyPoints;
end;

procedure TLegendForm.PaintMyPoints;
var
   DXI, DYI,
   PointSize, CurrentPointType:Integer;
   Canvas: TCanvas;
{  I:Integer;
   PointColor:TColor32;
   NewStipple: array of TColor32;}
Begin
  Image32.Bitmap.Clear(clWhite32);
  Canvas := TCanvas.Create; // create a new independent TCanvas object
  Canvas.Handle := Image32.Bitmap.Handle;
  Canvas.Pen.Width := LayA[CurrentLayer].CanvasLineSize;
    Canvas.Brush.Color := LayA[CurrentLayer].LayerColor;
    Canvas.Brush.Style := bsSolid; {bsClear}

  CurrentPointType:=  LayA[CurrentLayer].CurrentPointType;
  PointSize:=  LayA[CurrentLayer].PointSize;
  DXI:=10; DYI:=10;
{  SetLength(NewStipple,LayA[CurrentLayer].StippleColorCount);
    For I:=0 to LayA[CurrentLayer].StippleColorCount-1 do
    NewStipple[I]:=Color32(LayA[CurrentLayer].StippleColorArray[I]);
  Image32.Bitmap.SetStipple(NewStipple);
  Image32.Bitmap.StippleStep := LayA[CurrentLayer].StippleStep;
  PointColor := Color32(LayA[CurrentLayer].LayerColor);}
{  Image32.Bitmap.MoveToF(10, 10);
  If CanvasLineSize=0 then
   Image32.Bitmap.LineToFSP(110, 10) else
  begin
    Image32.Bitmap.PenColor :=
            Color32(LayA[CurrentLayer].LayerColor);
    Image32.Bitmap.LineToS(110, 10);
  end;}
          case CurrentPointType of
            0: {Pnt Dot} Canvas.Pixels[DXI, DYI] :=
                LayA[CurrentLayer].LayerColor;
            1: {Pnt Circle}
              begin {    Canvas.Ellipse}
                Canvas.Ellipse(DXI - PointSize, DYI - PointSize,
                DXI + PointSize, DYI +PointSize);
              end;
            2: {Pnt DotInCircle  }
              begin
                Canvas.Ellipse(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.Pixels[DXI, DYI] :=
                  LayA[CurrentLayer].LayerColor;
              end;
              {FilledCircle}
            3:Canvas.Ellipse(DXI - PointSize,
            DYI - PointSize, DXI + PointSize, DYI +PointSize);

            4: {Pnt PlusSign  +}
              begin
                Canvas.moveto(DXI - PointSize, DYI);
                Canvas.lineto(DXI + PointSize, DYI);
                Canvas.moveto(DXI, DYI + PointSize);
                Canvas.lineto(DXI, DYI - PointSize);
              end;
            5: {PntX   X}
              begin
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;

            6: {Pnt Box X1, Y1, X2, Y2}
              begin
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
              end;
            7: {Pnt XInBox}
              begin
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;
             8: {FilledBox}
          Canvas.FillRect(Rect(DXI-PointSize,DYI+PointSize,
          DXI+PointSize,DYI-PointSize){,PointColor});
          end; {Case}
Canvas.Free;
End;
(*****************************************************)
(*****************************************************)
  {Points: 0:Dot 1:Circle 2:DotInCircle 3:FilledCircle
        4:PlusSign 5:X 6:Box 7:XInBox 8:FilledBox}
{Points: 9 Types Variable Size, Variable-Thick lines, Color
 Lines: Stippled Color or Variable Width-Solid Color
 Antialiased:  Lines? and Polygon-Outline
 Polygon: Line and Fill Opacity, Line and Fill Color, Outline Thickness}
{Overlaid Stippled on Solid-Wide-lines
 Points from GR32 Polygons
 Bitmap Image- Point/Lines/Polygons
 Jans Symbol maker}
(*****************************************************)
(*****************************************************)









end.


