{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
// Pixel Profile
// efg, September 1998
// www.efg2.com/lab

unit dtmLOSProfile;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs, ShellAPI,
  StdCtrls, ExtDlgs, ExtCtrls, ComCtrls, Buttons,
  GR32,
{  gULineLibrary,} // RestrictCursorToDrawingArea, TLineSelected, NearLine
  Grids, Spin, TeEngine, Series, TeeProcs, Chart;

TYPE
  TLineProfileForm = class(TForm)
    PageControlProfile: TPageControl;
    TabSheetData: TTabSheet;
    TabSheetGraphs: TTabSheet;
    ChartPixelProfile: TChart;
    SeriesRed: TLineSeries;
    ImagePixelRow: TImage;
    LabelPixelSlice: TLabel;
    LabelFilename: TLabel;
    CloseBtn: TSpeedButton;
    HelpBtn: TSpeedButton;
    LabelPoints: TLabel;
    efgLabel: TLabel;
    MemoData: TRichEdit;
    SaveButton: TSpeedButton;
    PrintButton: TSpeedButton;
    CopyButton: TSpeedButton;
    ButtonPrintGraph: TSpeedButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);

    procedure ButtonPrintGraphClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure efgLabelClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SaveButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
procedure UpdateImage(X1,X2,Y1,Y2:Integer);
  private
{    Bitmap           :  TBitmap; }
{    ImageDesignHeight:  INTEGER;
    ImageDesignWidth :  INTEGER;}
{    Drawing          :  BOOLEAN;}
{    DrawingTool: TDrawingTool;
    Selected: TLineSelected; }
    ULPEndPoint: TPoint;
    ULPStartPoint: TPoint;

    procedure CreateProfileLine;
{    procedure UpdateImage;}
    procedure UpdateLineLength;

  public
    { Public declarations }
  end;

var
  LineProfileForm: TLineProfileForm;

implementation
{$R *.DFM}

uses
{  Math,} // MinIntValue, MaxIntValue
 dtmfrm, dtmPOFvar, dtmGlobals;

{const
  MaxPixelCount = 65536;
  RubberBandColor: TColor = clNavy;
  SquareHalfSize = 4;
  OffScreenCoordinate = -3 * SquareHalfSize;}

{type
  EImageProcessingError = class(Exception);
  TRGBTripleArray = array[0..MaxPixelCount - 1] of TRGBTriple;
  pRGBTripleArray = ^TRGBTripleArray; }

////////////////////////////////////////////////////////////

procedure TLineProfileForm.FormCreate(Sender: TObject);
begin
  left := LineProfileFormX;
  top := LineProfileFormY;
end;

procedure TLineProfileForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  LineProfileFormX := LineProfileForm.left;
  LineProfileFormY := LineProfileForm.top;
  DoSaver;
end;

procedure TLineProfileForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TLineProfileForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(12000);
end;


function Distance(const a, b: TPoint): DOUBLE;
begin
  RESULT := SQRT(SQR(a.X - b.X) + SQR(a.Y - b.Y))
end {Distance};

///////////////////////////////////////////////////////////////
procedure TLineProfileForm.UpdateImage(X1,X2,Y1,Y2:Integer);
var s:String;
begin
  ULPStartPoint := Point(X1, Y1);
  ULPEndPoint := Point(X2, Y2);
  LabelPoints.Caption := '';
  LabelFilename.Caption := '';
  s := ExtractFilename(HTFName);
  LabelFilename.Caption := COPY(s, 1, LENGTH(s) - 4);
        TabSheetGraphs.TabVisible := TRUE;
        TabSheetData.TabVisible := TRUE;
  Application.ProcessMessages;
  UpdateLineLength;
  Application.ProcessMessages;
  CreateProfileLine;
end {UpdateImages};


procedure TLineProfileForm.UpdateLineLength;
var
  s: string;
begin
  s := 'Points = ';

  s := s + '(' + IntToStr(ULPStartPoint.x) + ', ' +
    IntToStr(ULPStartPoint.y) + ')   ';
  s := s + '(' + IntToStr(ULPEndPoint.x) + ', ' +
    IntToStr(ULPEndPoint.y) + ')   ';

    s := s + '  Distance = ' +
      Format('%.1f', [Distance(ULPStartPoint, ULPEndPoint)]);
    LabelPoints.Caption := s;

    ChartPixelProfile.Title.Text.Clear;
    ChartPixelProfile.Title.Text.Add(
      'Pixel Profile:   ' +
      LabelFilename.Caption +
      '   from (' +
      IntToStr(ULPStartPoint.x) + ', ' +
      IntToStr(ULPStartPoint.y) + ') to (' +
      IntToStr(ULPEndPoint.x) + ', ' +
      IntToStr(ULPEndPoint.y) + ')');
end {UpdateLineLength};


procedure TLineProfileForm.CreateProfileLine;
var
  fraction: DOUBLE;
  i, j: DWord;
  itoo, k,m: INTEGER;
  PixelDistance: INTEGER;
  x, y: DOUBLE;
  PredA: array of Smallint;
  xwhere: INTEGER;
  TempStringer, TempRString  : string;
  Pred: DOUBLE;
  BitmapSlice: TBitmap;
  scanLine32 : PColor32Array;
  bmp32Slice : TBitmap32;
begin
  try
    bmp32Slice:=TBitmap32.Create;
    PixelDistance := TRUNC(Distance(ULPStartPoint, ULPEndPoint) +0.5);
    SetLength(PredA, PixelDistance + 1);
    ChartPixelProfile.BottomAxis.Maximum := PixelDistance;
    case PixelDistance of
          0..10: ChartPixelProfile.BottomAxis.Increment := 1;
          11..50: ChartPixelProfile.BottomAxis.Increment := 5;
          51..125: ChartPixelProfile.BottomAxis.Increment := 10;
          126..250: ChartPixelProfile.BottomAxis.Increment := 25;
        else
          ChartPixelProfile.BottomAxis.Increment := 50;
    end;                     { 32768..32767 }
    ChartPixelProfile.LeftAxis.Maximum:=   MaximumElevation;
    ChartPixelProfile.LeftAxis.Minimum:=   MinimumElevation;
    BitmapSlice := TBitmap.Create;
    try
      BitmapSlice.Height := 3;
      BitmapSlice.PixelFormat := pf24Bit;
      BitmapSlice.Width := PixelDistance + 1;
      bmp32Slice.Width:=PixelDistance + 1;
      bmp32Slice.Height:=3;
      SeriesRed.Clear;
      MemoData.Clear;

         {FixedSys font to make the columns align
         Compute data into new columns}
      MemoData.Lines.Add(LabelFilename.Caption);
      MemoData.Lines.Add(' ');
      MemoData.Lines.Add(' #      X     Y       Z   slope  ');
      MemoData.Lines.Add('---   ----- -----   ----- ------  ');
                                             {24}
      for k := 0 to PixelDistance do
      begin
        fraction := k / PixelDistance;
        // Add 0.5 to endpoints so "line" is from center of pixel
        x := (1.0 - fraction) * (ULPStartPoint.X + 0.5) +
              fraction * (ULPEndPoint.X + 0.5);

        y := (1.0 - fraction) * (ULPStartPoint.Y + 0.5) +
              fraction * (ULPEndPoint.Y + 0.5);

        i := TRUNC(x);
        j := TRUNC(y);
        PredA[k]:=htf.XYHeight(i,j);
        for m := 0 to bmp32Slice.Height - 1 do
        begin
          scanLine32 := bmp32Slice.Scanline[m];
          scanLine32[k]:=heightColor[PredA[k]];
        end;
        MemoData.Lines.Add(
        Format('%3d   %5.1f %5.1f   %5d        ',
              [k, x, y, PredA[k]]));
        SeriesRed.AddXY(k, PredA[k], '', clTeeColor);
      end;
      BitmapSlice.Assign(bmp32Slice);
      ImagePixelRow.Picture.Assign(BitmapSlice);
      {Compute the Slopes}
      for xwhere := 3 to PixelDistance - 3 do
      begin
        Pred := ((((PredA[xwhere - 2]) + (PredA[xwhere - 1])
              + (PredA[xwhere]) + (PredA[xwhere + 1])
              + (PredA[xwhere + 2]))
              / 5)
              - (((PredA[xwhere - 2]) + (PredA[xwhere - 1])
              + (PredA[xwhere]) + (PredA[xwhere + 1])
              + (PredA[xwhere - 3]))
              / 5));
        str(Pred: 6: 1, TempRString);
        TempStringer := MemoData.Lines[xwhere + 4];
        for itoo := Length(TempRString) downto 1 do
           TempStringer[25 + itoo] := TempRString[itoo];
        MemoData.Lines[xwhere + 4] := TempStringer;
      end;
    finally
      BitmapSlice.Free;
      bmp32Slice.Free;
      SetLength(PredA, 0);
    end
  finally
    Screen.Cursor := crDefault
  end
  {end else DoMessages(39975);}
end {CreateProfileLine};


//////////////////////////////////////////////////////////////

procedure TLineProfileForm.ButtonPrintGraphClick(Sender: TObject);
begin
  ChartPixelProfile.PrintLandScape
end;


procedure TLineProfileForm.efgLabelClick(Sender: TObject);
begin
  ShellExecute(0, 'open', pchar(efgLabel.Caption),
{  'http://www.efg2.com/Lab/',}'', '', SW_SHOW);
end;



////////////////////////////////////////////////////////////

procedure TLineProfileForm.SaveButtonClick(Sender: TObject);
var S: string;
begin
  s := ChangeFileExt(HTFPath + HTFName, '.txt');
  MemoData.Lines.SavetoFile(s);
end;

procedure TLineProfileForm.PrintButtonClick(Sender: TObject);
begin
  MemoData.Print(HTFName{ProjectName} {'My Document Name'});
end;

procedure TLineProfileForm.CopyButtonClick(Sender: TObject);
begin
  MemoData.SelectAll;
  MemoData.CopyToClipboard;
end;

end.
