{: Using the TJoystick to retrieve joystick position +buttons.<p>

   The component make it fairly easy to get this info.
   The first method is to use the events, (Buttons)
   the second to use its properties.<br>   (Position)
   I've tried to put both methods at use in this sample :<ul>
   <li>spheres on the right are adjusted
       when button are pressed/depressed
   <li>the 3D stick position is read in the rendering loop
   </ul>
}
unit dtmJoy;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  Joystick, GLScene, GLMisc, GLObjects,
  GLCadencer, GLWin32Viewer, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TdtmJoyForm = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    Joystick1: TJoystick;
    GLCamera1: TGLCamera;
    GLLightSource1: TGLLightSource;
    DummyCube1: TGLDummyCube;
    Cube1: TGLCube;
    Cylinder1: TGLCylinder;
    Sphere1: TGLSphere;
    DummyCube2: TGLDummyCube;
    Sphere2: TGLSphere;
    Sphere3: TGLSphere;
    Sphere4: TGLSphere;
    DummyCube3: TGLDummyCube;
    GLCadencer1: TGLCadencer;
    Panel1: TPanel;
    IntervalBar: TTrackBar;
    ThresholdBar: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    IntervalLabel: TLabel;
    ThresholdLabel: TLabel;
    resetbtn: TSpeedButton;
    CaptureCentroid: TSpeedButton;
    XPosition: TLabel;
    YPosition: TLabel;
    procedure Joystick1JoystickButtonChange(Sender: TObject;
      JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
      YDeflection: Integer);
    procedure FormCreate(Sender: TObject);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure IntervalBarChange(Sender: TObject);
    procedure ThresholdBarChange(Sender: TObject);
    procedure resetbtnClick(Sender: TObject);
    procedure CaptureCentroidClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  dtmJoyForm: TdtmJoyForm;

implementation

{$R *.DFM}

uses dtmPOFvar, dtmGlobals;

procedure TdtmJoyForm.FormCreate(Sender: TObject);
begin
   if Joystick1.Capture=False then begin
      ShowMessage('Connect a Joystick!');
      dtmJoyForm.Close;
      Exit;
   end;
   // setup default sphere colors
   Joystick1JoystickButtonChange(Self, Joystick1.JoystickID, [], 0, 0);
  top := DtmJoyFormY;
  left := DtmJoyFormX;
  GLCadencer1.Enabled:=False;
end;

procedure TdtmJoyForm.FormShow(Sender: TObject);
begin
  GLCadencer1.Enabled:=True;
  ThresholdBar.Position:=ThresholdBarPosition;
  Joystick1.Threshold:=ThresholdBar.Position;
  IntervalBar.Position:=IntervalBarPosition;
  Joystick1.Interval:=IntervalBar.Position;
  ThresholdLabel.Caption:=Inttostr(ThresholdBar.Position);
  IntervalLabel.Caption:=Inttostr(IntervalBar.Position);
end;

procedure TdtmJoyForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  DtmJoyFormY := dtmJoyForm.top;
  DtmJoyFormX := dtmJoyForm.left;
  ThresholdBarPosition:=ThresholdBar.Position;
  IntervalBarPosition:=IntervalBar.Position;
  DoSaver;
end;



procedure TdtmJoyForm.FormHide(Sender: TObject);
begin
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
end;
{==========================================================}
{==========================================================}

{==========================================================}
{==========================================================}
procedure TdtmJoyForm.GLCadencer1Progress(Sender: TObject;
                       const deltaTime,  newTime: Double);
begin
   // Rotate our 3d stick (=cylinder),
   // a dummycube is used as its rotation axis
   DummyCube1.PitchAngle:=(-Joystick1.XPosition+(JoyCentroidX))/3;
   DummyCube1.RollAngle:=(Joystick1.YPosition+(JoyCentroidY))/3;
   XPosition.Caption:=Floattostr((Joystick1.XPosition)+(JoyCentroidX));
   YPosition.Caption:=Floattostr((Joystick1.YPosition)+(JoyCentroidY));
end;

procedure TdtmJoyForm.Joystick1JoystickButtonChange(Sender: TObject;
  JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
  YDeflection: Integer);
const
   cPressedColor : array [False..True] of Integer = (clGray, clWhite);
var
   button : TJoystickButton;
   i : Integer;
begin
   // Browse all buttons and adjusts matching spheres color
   // All the spheres are accessed in an arrayed fashion
   //(I made them child of a single dummycube)
   i:=0;
   for button:=jbButton1 to jbButton4 do begin
      with TGLSphere(DummyCube2.Children[i]).Material.FrontProperties.Diffuse do
         AsWinColor:=cPressedColor[button in buttons];
      Inc(i);
   end;
end;


{Windows sends continiously messages
in the interval you can specify (min 10ms; max 1000ms)  100}
procedure TdtmJoyForm.IntervalBarChange(Sender: TObject);
begin
  Joystick1.Interval:=IntervalBar.Position;
  IntervalLabel.Caption:=Inttostr(IntervalBar.Position);
end;

{Real; spezifies the amount of movement required to respond,
which needs to be done with the joystick
in the specified interval above
(0.01 .. 10 in per cent of maxvalues of internal range)
50 ? was  500 .. not 'real' values in GlScene}
procedure TdtmJoyForm.ThresholdBarChange(Sender: TObject);
begin
  Joystick1.Threshold:=ThresholdBar.Position;
  ThresholdLabel.Caption:=Inttostr(ThresholdBar.Position);
end;

procedure TdtmJoyForm.resetbtnClick(Sender: TObject);
begin
  JoyCentroidX:=0;
  JoyCentroidY:=0;
  ThresholdBarPosition:=500;
  ThresholdBar.Position:=ThresholdBarPosition;
  Joystick1.Threshold:=ThresholdBar.Position;
  IntervalBarPosition:=100;
  IntervalBar.Position:=IntervalBarPosition;
  Joystick1.Interval:=IntervalBar.Position;
  ThresholdLabel.Caption:=Inttostr(ThresholdBar.Position);
  IntervalLabel.Caption:=Inttostr(IntervalBar.Position);
end;

procedure TdtmJoyForm.CaptureCentroidClick(Sender: TObject);
begin
  JoyCentroidX:=0-Joystick1.XPosition;
  JoyCentroidY:=0-Joystick1.YPosition;
end;

end.
