{ This projects sets up a basic GLScene environment
  with mouse interaction:
    Drag = Rotate
    Shift + Vertical Drag = Zoom
    Control + Drag = Pan in XY plane
    Alt + Vertical Drag = Pan in Z
    F + Vertical Drag = Adjust camera focal length
    L + Vertical Drag = Adjust light intensity
    R = Reset scene
    W = Get Pixel data
    Q = Stop Processing cubes
    G = Grab a box of bytes
  You can either use it as a starting point for your projects
  or as a test bed to try out the really interesting stuff.

  Safak Cinar
  safak@shaw.ca
  http://members.shaw.ca/safak/}
{: from Basic particle system demo.
Scene Objects
|_Dummy Cube
  |_DirectOpenGL
  |_MainCam
  |_GLParticles
    |_Cube
_Light    }
Unit dtmImageRGB;

Interface

Uses
  Windows, Messages, SysUtils, Classes,Buttons,
  Graphics, Controls, Forms, Dialogs,StdCtrls,
  ExtCtrls,ComCtrls,Menus,Math,
  OpenGL12, GLCadencer, GLScene, GLObjects, GLParticles, GLMisc,
  GLWin32Viewer, XOpenGL, GLVectorFileObjects,
   GeometryBB, GLContext, GLCrossPlatform, VectorLists, GLCanvas,
  GLTexture, Geometry, GLSkydome, GLGraph, GLMesh,
  VectorTypes, GLHUDObjects, AVIRecorder;


Const
  //Default distance of the camera to the target object
  CamDistDef = 1000;
  // MinMax values allowed when zooming
  CamDistMax = 5000;
  CamDistMin = 1;
  // MinMax values allowed when changing camera focus. Default is 100
  CamFocalMax = 2000;
  CamFocalMin = 5;

  //Cursor ID's
  ZoomCursor = 5;
  MoveXYCursor = 6;
  MoveZCursor = 7;
  RotateCursor = 8;
  FocusCursor = 9;
  LightCursor = 10;
  DigiCursor=11;

Type

  TViewerState = (vsRotate, vsZoom, vsPanXY, vsPanZ, vsFocus, vsLight, vsDigi, vsGrab);

  TDtmImageRGBForm = class(TForm)
    Scene: TGLScene;
    Viewer: TGLSceneViewer;
    DummyCube: TGLDummyCube;
    MainCam: TGLCamera;
    Light1: TGLLightSource;
    GLParticles1: TGLParticles;
    HisPanel: TPanel;
    ProgressBar1: TProgressBar;
    TrackBar1: TTrackBar;
    DataLabel: TLabel;
    Cube1: TGLCube;
    SetBtn: TSpeedButton;
    TrackBar2: TTrackBar;
    TrackBar2Label: TLabel;
    TrackBar1Label: TLabel;
    CounterLabel: TLabel;
    TotalLabel: TLabel;
    RGBRG: TRadioGroup;
    GLCadencer1: TGLCadencer;
    Timer1: TTimer;
    procedure ViewerMouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
    procedure ViewerMouseMove(Sender: TObject;
    Shift: TShiftState; X, Y: Integer);
    procedure ViewerMouseUp(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
procedure MyGetPickedObject;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
    Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
    Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure GLParticles1ActivateParticle(Sender: TObject;
      particle: TGLBaseSceneObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
procedure ShowDown(HisFileName:String);
    procedure Cube1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
    procedure SetBtnClick(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ViewerPostRender(Sender: TObject);
{    procedure DirectOpenGL1Render(var rci: TRenderContextInfo);}
  Private
    //This tells what we should do when the user drags the mouse,
    //based on the keys that are down
    ViewerState : TViewerState;
    //Ratio of camera target distance to focal length.
    //When changing focal length keep the ratio constant
    //so that the target object seems to stay at the same place
    //to the viewer
    CameraAspect : Double;
    //These track down the mouse events in the viewer
    MouseDown : Boolean;
    MouseX,MouseY : Integer;
    //The light follows the camera,
    //we have to call this whenever the camera position changes
    Procedure ReAdjustLightPosition;
    //Resets the camera such that it's
    //CamDistDef distance away from the target in the direction [X,Y,Z]
    //Magnitude of [X,Y,Z] is irrelevant
    Procedure ResetCamera(X,Y,Z:Double);
    //This proc handles changing the cursor
    //as well as switching the ViewerState.
    //Called from the form's keydown and keyup events
    Procedure SetGLCursor(Var Key:Word; Down:Boolean);
  Public
  End;

Var
  DtmImageRGBForm: TDtmImageRGBForm;
  MouseSelRect:TGLRect;
  IsSelecting:Boolean;
{  LegoMyEggo, } {Switch type of display}
  IWannaQuit,  {Stop it}
  Busy:Boolean; {Interval stopper}
  TotalCounter:Integer;
  WhatTagFloat,
  RedFloater,GreenFloater,BlueFloater:Single;
  HisMatrix: array of array of array of Byte;

Implementation

{$R *.DFM}
{$R Cursors.res}
uses  dtmPOFvar,dtmGlobals;
{===============================================================}
{==========================================================
Check if a control (including all its parents) are visible }
Function IsControlShowing(C:TControl):Boolean;
Begin
  Result:=False;
  Try
    While Not (C is TForm) Do
          If Not C.Visible Then Exit Else C:=C.Parent;
  Except
    On Exception Do;
  End;
  Result:=True;
End;

{=============================================================
Returns true if a given screen coordinate (ie Mouse.CursorPos)
is over a given component (which must be showing)}
Function PointOver(T:TGLPoint{TPoint}; C:TControl):Boolean;
Var
  T1,T2 : TGLPoint;
  TInX,TinY:Integer;
Begin
TInX :=T.X;
TinY :=T.Y;
  T1.X:=0;
  T1.Y:=0;
  T2.X:=C.Width;
  T2.Y:=C.Height;
  T1:=C.ClientToScreen(T1);
  T2:=C.ClientToScreen(T2);
  Result:=(IsControlShowing(C) And (TInX{T.X}>=T1.X)
           And (TInX{T.X}<=T2.X) And (TinY{T.Y}>=T1.Y) And (TinY{T.Y}<=T2.Y));
End;
{===============================================================}
Procedure TDtmImageRGBForm.FormCreate(Sender: TObject);
Var
  K : Word;
{  i,j:Integer;
  R : Single; }
Begin
  top := DtmImageRGBFormY;
  left := DtmImageRGBFormX;
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  IWannaQuit:=False;
  IsSelecting:=False;
{  LegoMyEggo:=False;}
  Busy:=True;
  TotalCounter:=0;
  //Load cursors
  Screen.Cursors[ZoomCursor] := LoadCursor(HInstance, 'ZoomCursor');
  Screen.Cursors[MoveXYCursor] := LoadCursor(HInstance, 'PanXYCursor');
  Screen.Cursors[MoveZCursor] := LoadCursor(HInstance, 'PanZCursor');
  Screen.Cursors[RotateCursor] := LoadCursor(HInstance, 'RotateCursor');
  Screen.Cursors[FocusCursor] := LoadCursor(HInstance, 'FocusCursor');
  Screen.Cursors[LightCursor] := LoadCursor(HInstance, 'LightCursor');
  Screen.Cursors[DigiCursor] := LoadCursor(HInstance, 'DigiCursor');

  //Reset the camera
  ResetCamera(1,1,1);
  //Set the cursors and the ViewerState
  K:=0;
  SetGlCursor(K,False);
End;

procedure TDtmImageRGBForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  IWannaQuit:=True;
  Application.ProcessMessages;
  CanClose :=True;
end;
procedure TDtmImageRGBForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SetLength(HisMatrix, 0, 0, 0);
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  DtmImageRGBFormY := DtmImageRGBForm.top;
  DtmImageRGBFormX := DtmImageRGBForm.left;
  DoSaver;
end;
{==============================================================}

procedure TDtmImageRGBForm.FormShow(Sender: TObject);
var
  v : Tvector;
begin
  Busy:=False;
{  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True; }
  DataLabel.Caption:='Waiting to set';
  SetBtn.Caption:='Set';
{    Cursor:=crDefault;}
  v:=MainCam.ScreenDeltaToVectorXY(0,-600,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);
  DummyCube.Position.Translate(v);
  MainCam.MoveAroundTarget(0, 20);
  ReAdjustLightPosition;
  MainCam.TransformationChanged;
end;

procedure TDtmImageRGBForm.FormResize(Sender: TObject);
begin
   // change focal so the view will shrink and not just get clipped
{   MainCam.FocalLength:=50*Width/280; }  {was 200? >50 if width > 280}
end;


{====================================================================
The light follows the camera but at some distance away.
We don't want the light too close to the target object when we zoom in.
}
Procedure TDtmImageRGBForm.ReAdjustLightPosition;
Begin
  Light1.Position.X:=MainCam.Position.X*20;
  Light1.Position.Y:=MainCam.Position.Y*20;
  Light1.Position.Z:=MainCam.Position.Z*20;
End;

{=============================================================
Remember mouse position when it was clicked down }
Procedure TDtmImageRGBForm.ViewerMouseDown(Sender: TObject;
Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
var
  pick : TGLCustomSceneObject;
  Value:Single;
  MyTVector4f:TVector4f;
  K : Word;
Begin
  Case ViewerState Of
    vsDigi : { if w pressed then}
    begin   {Pick an Object X Y}
    	// if an object is picked...
	    pick:=(Viewer.Buffer.GetPickedObject(x, y) as TGLCustomSceneObject);
    	if Assigned(pick) then
      begin
        {RedFloater,GreenFloater,}
        MyTVector4f:=
		    pick.Material.FrontProperties.Emission.Color;
        Value:=pick.TagFloat;
        DataLabel.Caption:=
          'Red:'+Inttostr(Round(MyTVector4f[0]*255))+
          ', Green:'+Inttostr(Round(MyTVector4f[1]*255))+
          ', Blue:'+Inttostr(Round(MyTVector4f[2]*255))+
          ', Pixels:'+Inttostr(Round(Value));
        IsSelecting := false;
        ViewerState:=vsRotate;
        K:=0;
        SetGlCursor(K,False);
        Viewer.Invalidate;
        Application.ProcessMessages;
	    end;
    end; {anything but nit picking}
    vsGrab:
    Begin
      {Retain Initial Mouse box}
    MouseSelRect.Left := X;
    MouseSelRect.Top :=Y;
    IsSelecting := True;
    End;
  end;{Case}
  begin
  MouseDown:=True;
  MouseX:=X;
  MouseY:=Y;
  end;
End;

{============================================================
Main routine                                     }
Procedure TDtmImageRGBForm.ViewerMouseMove(Sender: TObject;
Shift: TShiftState; X,Y: Integer);
Var
  dx, dy : Integer;
  v : TVector;
  d : Double;
Begin
  If Not MouseDown Then Exit;

  //How much the mouse has moved since last time
  dx:=MouseX-x; dy:=MouseY-y;

  Case ViewerState Of
    vsRotate :
      Begin
        //Rotate the camera around the target
        MainCam.MoveAroundTarget(dy, dx);
        ReAdjustLightPosition;
      End;
    vsZoom :
      Begin
        //0.01 is an arbitrary scale factor
        //Notice we first check if the mouse movement will result
        //in an allowable camera target distance
        //and if not, we clamp the value
        //before assigning it to camera.
        d:=(1-dy*0.01)*MainCam.DistanceToTarget;
        If d>CamDistMax Then d:=CamDistMax;
        If d<CamDistMin Then d:=CamDistMin;
        MainCam.AdjustDistanceToTarget(d/MainCam.DistanceToTarget);
        //We also update the CameraAspect
        //so that next time the focal length changes,
        //this new ratio is used
        CameraAspect:=MainCam.DistanceToTarget/MainCam.FocalLength;
        //Again, lights follow the camera
        ReAdjustLightPosition;
      End;
    vsPanXY :
      Begin
        //Convert the delta movement to GLScene translation,
        //correcting for the camera
        //target distance and the focal length
        v:=MainCam.ScreenDeltaToVectorXY(dx,-dy,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);
    //Camera is actually a child of the dummycube (the target object).
    //This separates translation from rotation,
    //the former applied to the dummycube (and thus indirectly to the
    //camera as well), the latter to the camera only.
    //This way, instead of panning the scene,
    //we translate the dummycube+camera.
    //Such motion has side effects too. For example, the proper
    //place to attach a skydome would be as a child of the dummycube.
        DummyCube.Position.Translate(v);
        ReAdjustLightPosition;
        MainCam.TransformationChanged;
      End;
    vsPanZ :
      Begin
    //Same deal as above except that the motion is limited to one axis
       { v:=MainCam.ScreenDeltaToVectorXY(0,-dy,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);}
        v[0]:=0;
        v[1]:=0;
        v[2]:=-dy*0.12*MainCam.DistanceToTarget/MainCam.FocalLength;
        DummyCube.Position.Translate(v);
        ReAdjustLightPosition;
        MainCam.TransformationChanged;
      End;
    vsFocus :
      Begin
        //We first figure out what the new focal length would be
        d:=(1-dy*0.01)*MainCam.FocalLength;
        //then clamp it down based on the constraints.
        //Checking against CamDistMax/CameraAspect ..etc
        //at this stage makes sure we don't end up with
        //an illegal DistanceToTarget for the camera
        //since to keep the target in the same virtual location,
        //camera-target distance adjustment has
        //to immediately follow a focus adjustment
        If d>CamFocalMax Then d:=CamFocalMax;
        If d>CamDistMax/CameraAspect Then d:=CamDistMax/CameraAspect;
        If d<CamFocalMin Then d:=CamFocalMin;
        If d<CamDistMin/CameraAspect Then d:=CamDistMin/CameraAspect;
        MainCam.FocalLength:=d;
        MainCam.AdjustDistanceToTarget(MainCam.FocalLength
                               *CameraAspect/MainCam.DistanceToTarget);
      End;
    vsLight :
      Begin
        //Simply alter the light intensity.
        //Notice this time the change is additive
        d:=Light1.Diffuse.Red;
        d:=d+dy*0.001;
        If d>1 Then d:=1 Else If d<0 Then d:=0;
        Light1.Diffuse.Red:=d;
        Light1.Diffuse.Green:=d;
        Light1.Diffuse.Blue:=d;
      End;
    vsGrab:
      Begin
        if isSelecting then
        begin
          MouseSelRect.Right := x;
          MouseSelRect.Bottom := y;
          Viewer.Invalidate;
        end;
      End;
  End;

  //Reset the mouse position
  MouseX:=X;
  MouseY:=Y;
  DataLabel.Caption:=Inttostr(Round(MainCam.FocalLength));
End;

procedure TDtmImageRGBForm.ViewerPostRender(Sender: TObject);
var
  GLCanv: TGLCanvas;
  x1, y1, x2, y2: integer;
begin
  if IsSelecting then {Draw a Moused Box - Selection Area}
  begin
    GLCanv := TGLCanvas.Create(Viewer.Width, Viewer.Height);
    GLCanv.PenColor := clWhite;
    x1 := MouseSelRect.Left;
    y1 := MouseSelRect.Top;
    x2 := MouseSelRect.Right;
    y2 := MouseSelRect.Bottom;
    GLCanv.FrameRect(x1, y1, x2, y2);
    GLCanv.Free;
  end;
end;
{==========================================================}
Procedure TDtmImageRGBForm.ViewerMouseUp(Sender: TObject;
Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
var   K : Word;
Begin
  MouseDown:=False;
  If ViewerState = vsGrab then
  Begin
  IsSelecting := false;
  ViewerState:=vsRotate;
  K:=0;
  SetGlCursor(K,False);
  Viewer.Invalidate;
  MyGetPickedObject;
  End;
End;

// Fills the PickList with objects in Rect area
// Objects are sorted by depth (nearest objects first).
Procedure TDtmImageRGBForm.MyGetPickedObject;
{function (x, y : Integer) :TGLBaseSceneObject;}
var
   pkList : TGLPickList;
   PickCount:Integer;
begin
   PickCount:=64;
   pkList:=Viewer.Buffer.GetPickedObjects(MouseSelRect,PickCount);
   {Rect(x-1, y-1, x+1, y+1));}
   try
      if pkList.Count>0 then
      begin
      {Clear and Fill something}
      Showmessage(Inttostr(pkList.Count) + ' Objects found');
      end;
         {Result:=pkList.Hit[0] else Result:=nil;}
   finally
      pkList.Free;
   end;
end;
{=============================================================
Position the camera in it's default location..etc          }
Procedure TDtmImageRGBForm.ResetCamera(X,Y,Z:Double);
Var
  D : Double;
Begin
  D:=CamDistDef/Sqrt(Sqr(X)+Sqr(Y)+Sqr(Z));
  DummyCube.Position.X:=0;
  DummyCube.Position.Y:=0;
  DummyCube.Position.Z:=0;
  MainCam.Position.X:=X*D;
  MainCam.Position.Y:=Y*D;
  MainCam.Position.Z:=Z*D;
  MainCam.FocalLength:=50;
  ReAdjustLightPosition;
  MainCam.TransformationChanged;
  CameraAspect:=MainCam.DistanceToTarget/MainCam.FocalLength;
End;

{================================================================
This proc is called from the form KeyDown events
(Form.KeyPreview is set to true)
and based on the key that went down/up.}
Procedure TDtmImageRGBForm.SetGLCursor(Var Key:Word; Down:Boolean);
Var
  K : Integer;
  B : Boolean;
  DoWhere:TGLPoint;
Begin
DoWhere.X:=Mouse.CursorPos.X;
DoWhere.Y:=Mouse.CursorPos.Y;
  B:=PointOver(DoWhere{Mouse.CursorPos},Viewer);

  ViewerState:=vsRotate;
  K:=RotateCursor;

  If Down Then
  Begin
    Case Key Of
      VK_ESCAPE:Close;
      VK_SHIFT : Begin ViewerState:=vsZoom; K:=ZoomCursor; End;
      VK_CONTROL : Begin ViewerState:=vsPanXY; K:=MoveXYCursor; End;
      VK_MENU : Begin ViewerState:=vsPanZ; K:=MoveZCursor; End;
      Ord('F'), Ord('f') :
           Begin ViewerState:=vsFocus; K:=FocusCursor; End;
      Ord('L'), Ord('l') :
           Begin ViewerState:=vsLight; K:=LightCursor; End;
      Ord('R'), Ord('r') : If B Then ResetCamera(1,1,1);
      Ord('W'), Ord('w') :
           Begin ViewerState:=vsDigi; K:=-20;{DigiCursor;} End;
      Ord('Q'), Ord('q'):Close;
      Ord('G'), Ord('g') :
           Begin
             ViewerState:=vsGrab;  K:=-20;
           End;
    End;
  End;

  If Viewer.Cursor<>K Then
  Begin
    Viewer.Cursor:=K;
    //This next line is necessary to update the cursor immediately
    //in the case where a key switched state
    //while a mouse button was being held down.
    //To see the problem, comment out the next line,
    //then LEFT CLICK AND HOLD, then PRESS SHIFT :
    //the mouse cursor will not update.
    If B Then Windows.SetCursor(Screen.Cursors[K]);
  End;
  //Since the ALT key has a special significance (brings up menu),
  //we disable it if pressed over the GLSceneViewer.
  //Again, to see the problem, you can comment
  //out the next line and try pressing ALT:
  //the cursor will reset to the default one, depending on the timing
  If (Key=VK_MENU) And B Then Key:=0;

End;
{===============================================================}



{================================================================}
Procedure TDtmImageRGBForm.FormKeyDown(Sender: TObject;
var Key: Word; Shift: TShiftState);
Begin
  SetGlCursor(Key,True);
End;


Procedure TDtmImageRGBForm.FormKeyUp(Sender: TObject;
var Key: Word; Shift: TShiftState);
Begin
  SetGlCursor(Key,False);
End;
{===============================================================}

{===============================================================}
procedure TDtmImageRGBForm.ShowDown(HisFileName:String);
type
  Count3D = array[0..255] of Byte;
var
  Count3DArray: Count3D;
  RX, GY, BZ, Value: Byte;
  Counter{,Counter2}:Integer;
{  Present: TDateTime;
  Hour, Min, Sec, MSec: Word;}
  fLoad: file of Count3D;
{	MyCube : TGLCube;}
begin
{  DtmImageRGBForm.Cursor:=crHourglass;}
  DtmImageRGBForm.Caption:='Rx Gy Bz Value 3D Cubes: '
                           +ExtractFileName(HisFileName);
  Application.ProcessMessages;
  SetLength(HisMatrix, 256, 256, 256);
  Counter:=0;  {Counter2:=0;}
{  Present:=Now;}
  Try
  {Read em in}
  {$I-}
  AssignFile(fLoad, HisFileName);
  Reset(fLoad);
  ProgressBar1.Visible:=True;
  for BZ := 0 to 255 do
  begin
    ProgressBar1.Position:= Round(100 * (BZ / 255));
    for GY := 0 to 255 do
    begin {Row}
      Read(fLoad, Count3DArray);
      for RX := 0 to 255 do
      begin {Col}
        Value := Count3DArray[RX];
        HisMatrix[RX, GY, BZ] := Value;
        If Value > 0 then inc(Counter);
      end;
    end;
  end;
    CloseFile(fLoad);
  {$I+}
  ProgressBar1.Position:=(0);
  ProgressBar1.Visible:=False;
  Application.ProcessMessages;

  {create a particle from file data position}
(*  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glBegin(GL_POINTS);
  for BZ := 0 to 255 do
  begin
    for GY := 0 to 255 do
    begin {Row}
      for RX := 0 to 255 do
      begin {Col}
        Value:=HisMatrix[RX, GY, BZ];
        {create a particle from file data position}
        If Value > 0 then
        begin
          {(... color of point ....)}
         glColor3f(RX/255,GY/255,BZ/255);
         {(... coordinates of point ....)}
         glVertex3f(RX,GY,BZ);
        end;
      end;
    end;
  end;
  glEnd;
  glPopAttrib; *)

  Except
    ProgressBar1.Position:=(0);
    ProgressBar1.Visible:=False;
    ProgressBar1.Enabled:=False;
    CloseFile(fLoad);
    SetLength(HisMatrix, 0, 0, 0);
    Busy:=False;
    Timer1.Enabled:=False;
    GLCadencer1.Enabled:=False;
    DataLabel.Caption:='Waiting to set';
    SetBtn.Caption:='Set';
  end;

  DtmImageRGBForm.Caption:='Rx Gy Bz Value Cubes: '
                           +ExtractFileName(HisFileName)+
                            ', Sprites:'+Inttostr(Counter);
{  DecodeTime(Now-Present, Hour, Min, Sec, MSec);
  HisPanel.Caption := Inttostr(Counter2)+' : '+
    IntToStr(Hour)+' Hrs '+
    IntToStr(Min) +' Min ' +
    IntToStr(Sec) +' Sec ' +
    IntToStr(MSec)+' MSec ' ;}
{  DtmImageRGBForm.Cursor:=crDefault;}
  Busy:=False;
  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True;
  DataLabel.Caption:='Waiting to set';
  SetBtn.Caption:='Set';
end;



{===============================================================}
(*
procedure TDtmImageRGBForm.DirectOpenGL1Render(
  var rci: TRenderContextInfo);
var
  RX, GY, BZ, Value: Byte;
begin
{If ((not IWannaQuit)and (not LegoMyEggo)) then    }
begin
  {Place em as Sprites}
  {create a particle from file data position}
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glBegin(GL_POINTS);
  for BZ := 0 to 255 do
  begin
    for GY := 0 to 255 do
    begin {Row}
      for RX := 0 to 255 do
      begin {Col}
        Value:=HisMatrix[RX, GY, BZ];
        {create a particle from file data position}
        If Value > 0 then
        begin
          {(... color of point ....)}
         glColor3f(RX/255,GY/255,BZ/255);
         {(... coordinates of point ....)}
         glVertex3f(RX,GY,BZ);
        end;
      end;
    end;
  end;
  glEnd;
  glPopAttrib;
end;
end;    *)
{===============================================================}
procedure TDtmImageRGBForm.SetBtnClick(Sender: TObject);
var
RX, GY, BZ, Value, Temp: Byte;
RX1,RX2, GY1,GY2, BZ1,BZ2,
Counter:Integer;
begin
  If Busy then Exit;
  Busy:=True;
{  LegoMyEggo:=True;}
  SetBtn.Caption:='Busy';
  Viewer.ResetPerformanceMonitor;
  {create a particle from file data position}
  RX1:=0;RX2:=255;
  GY1:=0;GY2:=255;
  BZ1:=0;BZ2:=255;
      Case RGBRG.ItemIndex of
      0:Begin
      RX1:=TrackBar1.Position;
      RX2:=TrackBar1.Position;
      end;
      1:Begin
      GY1:=TrackBar1.Position;
      GY2:=TrackBar1.Position;
      end;
      2:Begin
      BZ1:=TrackBar1.Position;
      BZ2:=TrackBar1.Position;
      end;
      end;
  Counter:=0;

  for BZ := BZ1 to BZ2 do
  begin
    for GY := GY1 to GY2 do
    begin {Row}
      for RX := RX1 to RX2 do
      begin {Col}
      Value:=HisMatrix[RX, GY, BZ];
        {create a particle from file data position}
        If IWannaQuit then
        begin
          SetBtn.Caption:='Set';
          DataLabel.Caption:='Waiting to set';
          CounterLabel.Caption:=Inttostr(Counter)
                     +' at '+Inttostr(TrackBar1.Position);
          TotalLabel.Caption:=Inttostr(TotalCounter);
          Busy:=False;
          IWannaQuit:=False;
          Exit;
        end;
        If Value > 0 then
        begin   {Place em as Sprites}
          inc(Counter);
          inc(TotalCounter);
          with TGLCube(GLParticles1.CreateParticle).Position do
          begin
            X:=RX;
            Y:=GY;
            Z:=BZ;
            WhatTagFloat:=Value;
            RedFloater:=RX/255;
            GreenFloater:=GY/255;
            BlueFloater:=BZ/255;
          end;
          DataLabel.Caption:=
                  'R:'+Inttostr(RX)+
                  ', G:'+Inttostr(GY)+
                  ', B:'+Inttostr(BZ)+
                  ' #:'+Inttostr(Value)+
                  ' Cubes:'+Inttostr(Counter)+
                  ' of:'+Inttostr(TotalCounter);
          Application.ProcessMessages;
        end;
      end;
    end;
  end;
  SetBtn.Caption:='Set';
  DataLabel.Caption:='Waiting to set';
  CounterLabel.Caption:=Inttostr(Counter)
                     +' at '+Inttostr(TrackBar1.Position);
  TotalLabel.Caption:=Inttostr(TotalCounter);
  Busy:=False;
  IWannaQuit:=False;
end;

procedure TDtmImageRGBForm.GLParticles1ActivateParticle(Sender: TObject;
  particle: TGLBaseSceneObject);
begin
   // this event is called when a particle is activated,
   // ie. just before it will be rendered
   with TGLCube(particle) do
   begin
      with Material.FrontProperties do
      begin
         Emission.Color:=PointMake(RedFloater,GreenFloater,BlueFloater);
         Diffuse.Color:=Emission.Color;
         Ambient.Color:=Emission.Color;
         TagFloat:=WhatTagFloat;
      end;
   end;
end;

{This is why there is a Cadencer... to kill old particles}
procedure TDtmImageRGBForm.Cube1Progress(Sender: TObject;
              const deltaTime,  newTime: Double);
begin                               {TagFloat}
{If LegoMyEggo then}
begin
   with TGLCube(Sender) do
   begin
     Case RGBRG.ItemIndex of
     0:begin
   If (((TrackBar1.Position-TrackBar2.Position) >  Round(TGLCube(Sender).Position.X))
   or  ((TrackBar1.Position+TrackBar2.Position) <  Round(TGLCube(Sender).Position.X))  ) then
   begin
         GLParticles1.KillParticle(TGLCube(Sender));
         dec(TotalCounter);
         TotalLabel.Caption:=Inttostr(TotalCounter);
   end;
       end;
     1:begin
   If (((TrackBar1.Position-TrackBar2.Position) >  Round(TGLCube(Sender).Position.Y))
   or  ((TrackBar1.Position+TrackBar2.Position) <  Round(TGLCube(Sender).Position.Y))  ) then
   begin
         GLParticles1.KillParticle(TGLCube(Sender));
         dec(TotalCounter);
         TotalLabel.Caption:=Inttostr(TotalCounter);
   end;
       end;
     2:begin
   If (((TrackBar1.Position-TrackBar2.Position) >  Round(TGLCube(Sender).Position.Z))
   or  ((TrackBar1.Position+TrackBar2.Position) <  Round(TGLCube(Sender).Position.Z))  ) then
   begin
         GLParticles1.KillParticle(TGLCube(Sender));
         dec(TotalCounter);
         TotalLabel.Caption:=Inttostr(TotalCounter);
   end;
       end;
     end;
   end;
end;
end;



procedure TDtmImageRGBForm.TrackBar2Change(Sender: TObject);
begin
  TrackBar2Label.Caption:=Inttostr(TrackBar2.Position)
end;

procedure TDtmImageRGBForm.TrackBar1Change(Sender: TObject);
begin
  TrackBar1Label.Caption:=Inttostr(TrackBar1.Position)
end;




End.
