{ This projects sets up a basic GLScene environment
  with mouse interaction:
    Drag = Rotate
    Shift + Vertical Drag = Zoom
    Control + Drag = Pan in XY plane
    Alt + Vertical Drag = Pan in Z
    F + Vertical Drag = Adjust camera focal length
    L + Vertical Drag = Adjust light intensity
    R = Reset scene
    W = Get Pixel data
    Q = Stop Processing cubes
VK_SHIFT:X,
VK_CONTROL:Y,
Alt:Z,
Z:Zoom, F:Focus, L:Lights, R:Reset,
Q:Quit, Esc:Quit
  You can either use it as a starting point for your projects
  or as a test bed to try out the really interesting stuff.

  Safak Cinar
  safak@shaw.ca
  http://members.shaw.ca/safak/}
{: from Basic particle system demo.
Scene Objects
|_Dummy Cube
  |_DirectOpenGL
  |_MainCam
  |_GLParticles
    |_Cube
_Light    }
Unit dtmImageDotRGB;

Interface

Uses
  Windows, Messages, SysUtils, Classes,Buttons,
  Graphics, Controls, Forms, Dialogs,StdCtrls,
  ExtCtrls, ComCtrls, Menus, Math,
  OpenGL12, GLCadencer, GLScene,
  GLTexture, Geometry, GLWin32Viewer, GLMisc, GLObjects;


Const
  //Default distance of the camera to the target object
  CamDistDef = 500;
  // MinMax values allowed when zooming
  CamDistMax = 5000;
  CamDistMin = 1;
  // MinMax values allowed when changing camera focus. Default is 100
  CamFocalMax = 2000;
  CamFocalMin = 5;

  //Cursor ID's
  ZoomCursor = 5;
  MoveXYCursor = 6;
  MoveZCursor = 7;
  RotateCursor = 8;
  FocusCursor = 9;
  LightCursor = 10;
  DigiCursor=11;

Type

  TViewerState = (vsRotate, vsZoom, vsPanX, vsPanY, vsPanZ, vsFocus, vsLight, vsDigi);

  TDtmImageDotRGBForm = class(TForm)
    Scene: TGLScene;
    Viewer: TGLSceneViewer;
    DummyCube: TGLDummyCube;
    MainCam: TGLCamera;
    Light1: TGLLightSource;
    GLCadencer1: TGLCadencer;
    Timer1: TTimer;
    DirectOpenGL1: TGLDirectOpenGL;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    RGBDensityTrackBar: TTrackBar;
    CubeAxisCB: TCheckBox;
    RGBLevelsCB: TCheckBox;
    RedMaxTrackBar: TTrackBar;
    GreenMaxTrackBar: TTrackBar;
    BlueMaxTrackBar: TTrackBar;
    RedMinTrackBar: TTrackBar;
    GreenMinTrackBar: TTrackBar;
    BlueMinTrackBar: TTrackBar;
    DensityLabel: TLabel;
    RGBMaxTrackBar: TTrackBar;
    DensityMaxLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    MouseMovementCB: TCheckBox;
    procedure ViewerMouseDown(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
    procedure ViewerMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ViewerMouseUp(Sender: TObject; Button: TMouseButton;
    Shift: TShiftState; X, Y: Integer);
Procedure DoThatMouser(dx ,dy :Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
    Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
    Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DirectOpenGL1Render(var rci: TRenderContextInfo);
    procedure CubeAxisCBClick(Sender: TObject);
    procedure MouseMovementCBClick(Sender: TObject);

    procedure RGBDensityTrackBarChange(Sender: TObject);
    procedure RGBMaxTrackBarChange(Sender: TObject);
    procedure RedMaxTrackBarChange(Sender: TObject);
    procedure RedMinTrackBarChange(Sender: TObject);
    procedure GreenMinTrackBarChange(Sender: TObject);
    procedure GreenMaxTrackBarChange(Sender: TObject);
    procedure BlueMinTrackBarChange(Sender: TObject);
    procedure BlueMaxTrackBarChange(Sender: TObject);

  Private
    //This tells what we should do when the user drags the mouse,
    //based on the keys that are down
    ViewerState : TViewerState;
    //Ratio of camera target distance to focal length.
    //When changing focal length keep the ratio constant
    //so that the target object seems to stay at the same place
    //to the viewer
    CameraAspect : Double;
    //These track down the mouse events in the viewer
    MouseDown : Boolean;
    MouseX,MouseY : Integer;
    //The light follows the camera,
    //we have to call this whenever the camera position changes
    Procedure ReAdjustLightPosition;
    //Resets the camera such that it's
    //CamDistDef distance away from the target in the direction [X,Y,Z]
    //Magnitude of [X,Y,Z] is irrelevant
    Procedure ResetCamera(X,Y,Z:Double);
    //This proc handles changing the cursor
    //as well as switching the ViewerState.
    //Called from the form's keydown and keyup events
    Procedure SetGLCursor(Var Key:Word; Down:Boolean);
  Public
  End;

Var
  DtmImageDotRGBForm: TDtmImageDotRGBForm;
{  LegoMyEggo,}  {Switch type of display}
  IWannaQuit:Boolean;  {Stop it}
  Busy:Boolean; {Interval stopper}
(*  TotalCounter:Integer;
  WhatTagFloat,
  RedFloater,GreenFloater,BlueFloater:Single;
  HisMatrix: array of array of array of Byte; *)
Implementation

{$R *.DFM}
uses  dtmPOFvar, dtmGlobals;
{===============================================================}
Procedure TDtmImageDotRGBForm.FormCreate(Sender: TObject);
Var
  K : Word;
{  i,j:Integer;
  R : Single; }
Begin
  top := DtmImageRGBFormY;
  left := DtmImageRGBFormX;
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  IWannaQuit:=False;
  Busy:=False;
  //Load cursors
  Screen.Cursors[ZoomCursor] := LoadCursor(HInstance, 'ZoomCursor');
  Screen.Cursors[MoveXYCursor] := LoadCursor(HInstance, 'PanXYCursor');
  Screen.Cursors[MoveZCursor] := LoadCursor(HInstance, 'PanZCursor');
  Screen.Cursors[RotateCursor] := LoadCursor(HInstance, 'RotateCursor');
  Screen.Cursors[FocusCursor] := LoadCursor(HInstance, 'FocusCursor');
  Screen.Cursors[LightCursor] := LoadCursor(HInstance, 'LightCursor');
  Screen.Cursors[DigiCursor] := LoadCursor(HInstance, 'DigiCursor');

  //Reset the camera
  ResetCamera(1,1,1);
  //Set the cursors and the ViewerState
  K:=0;
  SetGlCursor(K,False);
End;

procedure TDtmImageDotRGBForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  IWannaQuit:=True;
{  Application.ProcessMessages; }
  CanClose :=True;
end;

procedure TDtmImageDotRGBForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  DtmImageRGBFormY := DtmImageDotRGBForm.top;
  DtmImageRGBFormX := DtmImageDotRGBForm.left;
  DoSaver;
  ModalResult:=mrOk;
end;

{==========================================================
Check if a control (including all its parents) are visible }
Function IsControlShowing(C:TControl):Boolean;
Begin
  Result:=False;
  Try
    While Not (C is TForm) Do
          If Not C.Visible Then Exit Else C:=C.Parent;
  Except
    On Exception Do;
  End;
  Result:=True;
End;

{=============================================================
Returns true if a given screen coordinate (ie Mouse.CursorPos)
is over a given component (which must be showing)}
Function PointOver(T:TPoint; C:TControl):Boolean;
Var
  T1,T2 : TPoint;
Begin
  T1.X:=0;
  T1.Y:=0;
  T2.X:=C.Width;
  T2.Y:=C.Height;
  T1:=C.ClientToScreen(T1);
  T2:=C.ClientToScreen(T2);
  Result:=(IsControlShowing(C) And (T.X>=T1.X)
           And (T.X<=T2.X) And (T.Y>=T1.Y) And (T.Y<=T2.Y));
End;

{====================================================================
The light follows the camera but at some distance away.
We don't want the light too close to the target object when we zoom in.
}
Procedure TDtmImageDotRGBForm.ReAdjustLightPosition;
Begin
  Light1.Position.X:=MainCam.Position.X*20;
  Light1.Position.Y:=MainCam.Position.Y*20;
  Light1.Position.Z:=MainCam.Position.Z*20;
End;

{=============================================================
Remember mouse position when it was clicked down }
Procedure TDtmImageDotRGBForm.ViewerMouseDown(Sender: TObject;
Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
Begin
  MouseDown:=True;
  MouseX:=X;
  MouseY:=Y;
End;

{============================================================}
procedure TDtmImageDotRGBForm.ViewerMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  If MouseMovementCB.Checked then
  begin
    If Not MouseDown Then Exit;
    DoThatMouser(MouseX-x,MouseY-y);
    //Reset the mouse position
    MouseX:=X;
    MouseY:=Y;
  end;
end;
{==========================================================}
Procedure TDtmImageDotRGBForm.ViewerMouseUp(Sender: TObject;
Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin
  If Not MouseDown Then Exit;
  //How much the mouse has moved since last time
  DoThatMouser(MouseX-x,MouseY-y);
  //Reset the mouse position
  MouseX:=X;
  MouseY:=Y;
  MouseDown:=False;
end;
Procedure TDtmImageDotRGBForm.DoThatMouser(dx ,dy :Integer);
Var
{  dx, dy : Integer;}
  v : TVector;
  d : Double;
Begin
  If Not MouseDown Then Exit;
  Case ViewerState Of
    vsRotate :
      Begin
        //Rotate the camera around the target
        MainCam.MoveAroundTarget(dy, dx);
        ReAdjustLightPosition;
      End;
    vsZoom :
      Begin
        //0.01 is an arbitrary scale factor
        //Notice we first check if the mouse movement will result
        //in an allowable camera target distance
        //and if not, we clamp the value
        //before assigning it to camera.
        d:=(1-dy*0.01)*MainCam.DistanceToTarget;
        If d>CamDistMax Then d:=CamDistMax;
        If d<CamDistMin Then d:=CamDistMin;
        MainCam.AdjustDistanceToTarget(d/MainCam.DistanceToTarget);
        //We also update the CameraAspect
        //so that next time the focal length changes,
        //this new ratio is used
        CameraAspect:=MainCam.DistanceToTarget/MainCam.FocalLength;
        //Again, lights follow the camera
        ReAdjustLightPosition;
      End;
    vsPanX :
      Begin
        v[0]:=-dx*0.12*(MainCam.DistanceToTarget/MainCam.FocalLength);
        v[1]:=0;
        v[2]:=0;
        {v:=MainCam.ScreenDeltaToVectorXY(dx,-dy,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);}
        MainCam.Position.Translate(v);
        ReAdjustLightPosition;
        MainCam.TransformationChanged;
      End;
    vsPanY :
      Begin
        //Convert the delta movement to GLScene translation,
        //correcting for the camera
        //target distance and the focal length
    //Camera is actually a child of the dummycube (the target object).
    //This separates translation from rotation,
    //the former applied to the dummycube (and thus indirectly to the
    //camera as well), the latter to the camera only.
    //This way, instead of panning the scene,
    //we translate the dummycube+camera.
    //Such motion has side effects too. For example, the proper
    //place to attach a skydome would be as a child of the dummycube.
        {v:=MainCam.ScreenDeltaToVectorXY(dx,-dy,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);}
        v[0]:=0;
        v[1]:=-dx*0.12*(MainCam.DistanceToTarget/MainCam.FocalLength);
        v[2]:=0;
        {DummyCube}
        MainCam.Position.Translate(v);
        ReAdjustLightPosition;
        MainCam.TransformationChanged;
      End;
    vsPanZ :{Alt}
      Begin
    //Same deal as above except that the motion is limited to one axis
        {v:=MainCam.ScreenDeltaToVectorXY(0,-dy,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);}
        v[0]:=0;
        v[1]:=0;
        v[2]:=-dy*0.12*(MainCam.DistanceToTarget/MainCam.FocalLength);
        {DummyCube}
        MainCam.Position.Translate(v);
        ReAdjustLightPosition;
        MainCam.TransformationChanged;
      End;
    vsFocus :
      Begin
        //We first figure out what the new focal length would be
        d:=(1-dy*0.01)*MainCam.FocalLength;
        //then clamp it down based on the constraints.
        //Checking against CamDistMax/CameraAspect ..etc
        //at this stage makes sure we don't end up with
        //an illegal DistanceToTarget for the camera
        //since to keep the target in the same virtual location,
        //camera-target distance adjustment has
        //to immediately follow a focus adjustment
        If d>CamFocalMax Then d:=CamFocalMax;
        If d>CamDistMax/CameraAspect Then d:=CamDistMax/CameraAspect;
        If d<CamFocalMin Then d:=CamFocalMin;
        If d<CamDistMin/CameraAspect Then d:=CamDistMin/CameraAspect;
        MainCam.FocalLength:=d;
        MainCam.AdjustDistanceToTarget(MainCam.FocalLength
                               *CameraAspect/MainCam.DistanceToTarget);
      End;
    vsLight :
      Begin
        //Simply alter the light intensity.
        //Notice this time the change is additive
        d:=Light1.Diffuse.Red;
        d:=d+dy*0.001;
        If d>1 Then d:=1 Else If d<0 Then d:=0;
        Light1.Diffuse.Red:=d;
        Light1.Diffuse.Green:=d;
        Light1.Diffuse.Blue:=d;
      End
  End;
        StatusBar1.Panels[0].Text:= {Direction}
        'Rx '+Inttostr(Round(MainCam.Position.X))+
        ',Gy '+Inttostr(Round(MainCam.Position.Y))+
        ',Bz '+Inttostr(Round(MainCam.Position.Z));
End;

{=============================================================
Position the camera in it's default location..etc          }
Procedure TDtmImageDotRGBForm.ResetCamera(X,Y,Z:Double);
Var
  D : Double;
Begin
  D:=CamDistDef/Sqrt(Sqr(X)+Sqr(Y)+Sqr(Z));
  DummyCube.Position.X:=0;
  DummyCube.Position.Y:=0;
  DummyCube.Position.Z:=0;
  MainCam.Position.X:=X*D;
  MainCam.Position.Y:=Y*D;
  MainCam.Position.Z:=Z*D;
  MainCam.FocalLength:=50;
  ReAdjustLightPosition;
  MainCam.TransformationChanged;
  CameraAspect:=MainCam.DistanceToTarget/MainCam.FocalLength;
        StatusBar1.Panels[0].Text:= {Direction}
        'Rx '+Inttostr(Round(MainCam.Position.X))+
        ',Gy '+Inttostr(Round(MainCam.Position.Y))+
        ',Bz '+Inttostr(Round(MainCam.Position.Z));
End;

{================================================================
This proc is called from the form KeyDown events
(Form.KeyPreview is set to true)
and based on the key that went down/up.}
Procedure TDtmImageDotRGBForm.SetGLCursor(Var Key:Word; Down:Boolean);
Var
  K : Integer;
  B : Boolean;
Begin
  If ( (Key= Ord('Q'))or(Key= Ord('q'))
  or (Key=VK_ESCAPE))then
  begin
     IWannaQuit:=True;
     DtmImageDotRGBForm.Close;
  end;
  B:=PointOver(Mouse.CursorPos,Viewer);

  ViewerState:=vsRotate;
  K:=RotateCursor;

  If Down Then
  Begin
    Case Key Of
{      VK_ESCAPE: begin   IWannaQuit:=True;  Application.ProcessMessages;Close;Exit;end;}
      Ord('Z'), Ord('z') :Begin ViewerState:=vsZoom; K:=ZoomCursor; End;
      VK_SHIFT :Begin ViewerState:=vsPanX; K:=MoveXYCursor; End;
      VK_CONTROL : Begin ViewerState:=vsPanY; K:=MoveXYCursor; End;
      VK_MENU : Begin ViewerState:=vsPanZ; K:=MoveZCursor; End;
      Ord('F'), Ord('f') :
           Begin ViewerState:=vsFocus; K:=FocusCursor; End;
      Ord('L'), Ord('l') :
           Begin ViewerState:=vsLight; K:=LightCursor; End;
      Ord('R'), Ord('r') : If B Then ResetCamera(1,1,1);
      {DigiCursor;}
      {Ord('W'), Ord('w') :
           Begin ViewerState:=vsDigi; K:=-20; End;}
    End;
  End;

  If Viewer.Cursor<>K Then
  Begin
    Viewer.Cursor:=K;
    //This next line is necessary to update the cursor immediately
    //in the case where a key switched state
    //while a mouse button was being held down.
    //To see the problem, comment out the next line,
    //then LEFT CLICK AND HOLD, then PRESS SHIFT :
    //the mouse cursor will not update.
    If B Then Windows.SetCursor(Screen.Cursors[K]);
  End;
  //Since the ALT key has a special significance (brings up menu),
  //we disable it if pressed over the GLSceneViewer.
  //Again, to see the problem, you can comment
  //out the next line and try pressing ALT:
  //the cursor will reset to the default one, depending on the timing
  If (Key=VK_MENU) And B Then Key:=0;
End;
{===============================================================}



{================================================================}
Procedure TDtmImageDotRGBForm.FormKeyDown(Sender: TObject;
var Key: Word; Shift: TShiftState);
Begin
  SetGlCursor(Key,True);
End;


Procedure TDtmImageDotRGBForm.FormKeyUp(Sender: TObject;
var Key: Word; Shift: TShiftState);
Begin
  SetGlCursor(Key,False);
End;

{==============================================================}

procedure TDtmImageDotRGBForm.FormShow(Sender: TObject);
var
  v : Tvector;
begin
  v:=MainCam.ScreenDeltaToVectorXY(0,-600,
             0.12*MainCam.DistanceToTarget/MainCam.FocalLength);
  DummyCube.Position.Translate(v);
  MainCam.MoveAroundTarget(0, 20);
  ReAdjustLightPosition;
  MainCam.TransformationChanged;
  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True;
{    Cursor:=crDefault;}
end;

procedure TDtmImageDotRGBForm.FormResize(Sender: TObject);
begin
   // change focal so the view will shrink and not just get clipped
{   MainCam.FocalLength:=50*Width/280; }  {was 200? >50 if width > 280}
end;
{===============================================================}

{===============================================================}

{===============================================================}
procedure TDtmImageDotRGBForm.DirectOpenGL1Render(
                                     var rci: TRenderContextInfo);
var
  RX, GY, BZ{, Value}: Byte;
  RgbLevelsDo:Boolean;
  RgbDoCheck,RgbDoMax,RgbDo,i:Integer;
{  CapString:String;}
begin
{If ((not IWannaQuit)and (not Busy)) then}
begin
        StatusBar1.Panels[1].Text:= 'Working';
{        Application.ProcessMessages;}
Busy:=True;
RgbDo:=RGBDensityTrackBar.Position;
RgbDoMax:=RGBMaxTrackBar.Position;
RgbLevelsDo:=RGBLevelsCB.Checked;
  {create a particle from file data position}
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);
  glBegin(GL_POINTS);
   for i := 1 to Array3DCounter do
   begin
   RgbDoCheck :=Array3D[i].Count;
   If (((RgbDoMax=256)and (RgbDoCheck>RgbDo))or
       ((RgbDoMax>RgbDoCheck)and (RgbDoCheck>RgbDo))) then
   begin
          RX:=Array3D[i].RX;
          GY:=Array3D[i].GY;
          BZ:=Array3D[i].BZ;
   If RgbLevelsDo then
   begin
     If ((RX >RedMinTrackBar.Position) and
         (GY >GreenMinTrackBar.Position) and
         (BZ >BlueMinTrackBar.Position) and
         (RX <RedMaxTrackBar.Position) and
         (GY <GreenMaxTrackBar.Position) and
         (BZ <BlueMaxTrackBar.Position) ) then
         begin
          glColor3f(RX/255,GY/255,BZ/255);
          glVertex3f(RX,GY,BZ);
         end;
   end else
   begin
         {(... color of point ....)}
          glColor3f(RX/255,GY/255,BZ/255);
          {(... coordinates of point ....)}
          glVertex3f(RX,GY,BZ);
          end
          end;
          end;
  glEnd;
  glPopAttrib;
        StatusBar1.Panels[1].Text:= 'Ready';
{        Application.ProcessMessages;}
  Busy:=False;
end;
end;
{===============================================================}

procedure TDtmImageDotRGBForm.CubeAxisCBClick(Sender: TObject);
begin
  DummyCube.ShowAxes:=CubeAxisCB.Checked;
{  DummyCube.Visible:=CubeAxisCB.Checked; }
end;
procedure TDtmImageDotRGBForm.MouseMovementCBClick(Sender: TObject);
begin
{MouseMovementCB.Checked;}
end;

procedure TDtmImageDotRGBForm.RGBDensityTrackBarChange(Sender: TObject);
begin
  DensityLabel.Caption:=Inttostr(RGBDensityTrackBar.Position+1);
end;

procedure TDtmImageDotRGBForm.RGBMaxTrackBarChange(Sender: TObject);
begin
  If RGBMaxTrackBar.Position=256 then
  DensityMaxLabel.Caption:='All' else
  DensityMaxLabel.Caption:=Inttostr(RGBMaxTrackBar.Position+1);
end;

procedure TDtmImageDotRGBForm.RedMaxTrackBarChange(Sender: TObject);
begin
  Label1.Caption:=Inttostr(RedMaxTrackBar.Position-1);
end;

procedure TDtmImageDotRGBForm.RedMinTrackBarChange(Sender: TObject);
begin
  Label2.Caption:=Inttostr(RedMinTrackBar.Position+1);
end;

procedure TDtmImageDotRGBForm.GreenMinTrackBarChange(Sender: TObject);
begin
  Label3.Caption:=Inttostr(GreenMinTrackBar.Position+1);
end;

procedure TDtmImageDotRGBForm.GreenMaxTrackBarChange(Sender: TObject);
begin
  Label4.Caption:=Inttostr(GreenMaxTrackBar.Position-1);
end;

procedure TDtmImageDotRGBForm.BlueMinTrackBarChange(Sender: TObject);
begin
  Label5.Caption:=Inttostr(BlueMinTrackBar.Position+1);
end;

procedure TDtmImageDotRGBForm.BlueMaxTrackBarChange(Sender: TObject);
begin
  Label6.Caption:=Inttostr(BlueMaxTrackBar.Position-1);
end;





End.
