unit dtmIMFrm;
{by Ivan Lee Herring, 2002}
{
Image or Bin from HTF/BMP:
Make a Manmatrix then
   save as bin with a .tpcfg  (Open needs to get htf location)
OR convert and save as bmp     (change file name)
}
interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
{  HeightTileFile,}  {HTF file access}
  ComCtrls, StdCtrls, Buttons, ExtCtrls;
{  GR32, GR32_Layers, GR32_Image;        }

type
  TImageMakerForm = class(TForm)
    SaveDialog1: TSaveDialog;
    IMRG: TRadioGroup;
    SaveBmpBtn: TSpeedButton;
    XSizeEdit: TEdit;
    YSizeEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    XSize: TLabel;
    YSize: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    SizerTrackBar: TTrackBar;
    HelpBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    ProgressBar1: TProgressBar;
    SaveBinBtn: TSpeedButton;
    OpenDialog1: TOpenDialog;
    GroupBox1: TGroupBox;
    ImageDoRG: TRadioGroup;
    ImageBinBtn: TSpeedButton;
    LaunchGLViewerCB: TCheckBox;
    SaveBothBtn: TSpeedButton;
    GroupBox2: TGroupBox;
    ImagetoRGBHistogramBtn: TSpeedButton;
    procedure SizerTrackBarChange(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SaveBmpBtnClick(Sender: TObject);
    procedure SaveBinBtnClick(Sender: TObject);
    procedure ImageBinBtnClick(Sender: TObject);
procedure MakeMatrix(var MinimumElevation,MaximumElevation:Integer);
procedure MatrixBmp(InFile:String;Min,Max:Integer);
procedure MatrixBin(InFile:String;Min,Max:Integer);
    procedure SaveBothBtnClick(Sender: TObject);
    procedure ImagetoRGBHistogramBtnClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ImageMakerForm: TImageMakerForm;
  iXSize,iYSize:Integer;

implementation

{$R *.DFM}

uses dtmfrm, dtmGlobals, dtmPOFvar, dtmPOFrm, DtmGlfrm;

procedure TImageMakerForm.FormCreate(Sender: TObject);
begin
  top := ImageMakerFormY;
  left := ImageMakerFormX;
  iXSize:=htf.SizeX;
  XSize.Caption:=Inttostr(iXSize);
  XSizeEdit.Text:=Inttostr(iXSize);
  iYSize:=htf.SizeY;
  YSize.Caption:=Inttostr(iYSize);
  YSizeEdit.Text:=Inttostr(iYSize);
end;

procedure TImageMakerForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ImageMakerFormX := ImageMakerForm.left;
  ImageMakerFormY := ImageMakerForm.top;
  modalresult:=mrOk;
end;

procedure TImageMakerForm.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TImageMakerForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(5678);
end;

procedure TImageMakerForm.SizerTrackBarChange(Sender: TObject);
var
  iXSizeOut,iYSizeOut,Ratiosize:Integer;
begin
  Ratiosize:=SizerTrackBar.Position;
  iXSizeOut:=  iXSize div Ratiosize;
  iYSizeOut:=  iYSize div Ratiosize;
  XSizeEdit.Text:=Inttostr(iXSizeOut);
  YSizeEdit.Text:=Inttostr(iYSizeOut);
  Application.ProcessMessages;
end;


procedure TImageMakerForm.SaveBmpBtnClick(Sender: TObject);
var MinimumElevation,MaximumElevation:Integer;
begin
  if not Assigned(htf) then Exit;
  SaveDialog1.Filter:= 'BMP Image  (*.bmp)|*.bmp';
  SaveDialog1.InitialDir:=ImagePath;
  SaveDialog1.Filename:='newname.bmp';
  if SaveDialog1.Execute then
  begin
    ImagePath:=ExtractFilePath(SaveDialog1.FileName);
    MaximumElevation := -2147483647;
    MinimumElevation := 2147483646;
    MakeMatrix(MinimumElevation,MaximumElevation);
    MatrixBmp(SaveDialog1.FileName,MinimumElevation,MaximumElevation);
    ProgressBar1.Position :=0;
    Application.ProcessMessages;
    SetLength(ManMatrix,0,0);
  end;
End;


procedure TImageMakerForm.SaveBinBtnClick(Sender: TObject);
var MinimumElevation,MaximumElevation:Integer;
begin
  if not Assigned(htf) then Exit;
  SaveDialog1.Filter:= 'DEM bin  (*.bin)|*.bin';
  SaveDialog1.InitialDir:=DemPath;
  SaveDialog1.Filename:='newname.bin';
  if SaveDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(SaveDialog1.FileName);
    MaximumElevation := -2147483647;
    MinimumElevation := 2147483646;
    MakeMatrix(MinimumElevation,MaximumElevation);
    MatrixBin(SaveDialog1.FileName,MinimumElevation,MaximumElevation);
    ProgressBar1.Position :=0;
    Application.ProcessMessages;
   If ((LaunchGLViewerCB.Checked)and NoGLRunning) then
   begin
     NoGLRunning:=False;
     dtmGlForm.show;
     dtmGlForm.EnableHeightCB.Checked:=False;
     dtmGlForm.FormShowDown;
   end else  SetLength(ManMatrix,0,0);
  end;
End;

procedure TImageMakerForm.SaveBothBtnClick(Sender: TObject);
var
  MinimumElevation,MaximumElevation:Integer;
  BmpName:String;
begin
  if not Assigned(htf) then Exit;
  SaveDialog1.Filter:= 'BMP Image  (*.bmp)|*.bmp';
  SaveDialog1.InitialDir:=ImagePath;
  SaveDialog1.Filename:='newname.bmp';
  if SaveDialog1.Execute then
  begin
    ImagePath:=ExtractFilePath(SaveDialog1.FileName);
    BmpName:= SaveDialog1.FileName;
  SaveDialog1.Filter:= 'DEM bin  (*.bin)|*.bin';
  SaveDialog1.InitialDir:=DemPath;
  SaveDialog1.Filename:='newname.bin';
  if SaveDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(SaveDialog1.FileName);
    MaximumElevation := -2147483647;
    MinimumElevation := 2147483646;
    MakeMatrix(MinimumElevation,MaximumElevation);
    MatrixBmp(BmpName,MinimumElevation,MaximumElevation);
    MatrixBin(SaveDialog1.FileName,MinimumElevation,MaximumElevation);
    ProgressBar1.Position :=0;
    Application.ProcessMessages;
   If ((LaunchGLViewerCB.Checked)and NoGLRunning) then
   begin
     NoGLRunning:=False;
     dtmGlForm.show;
     dtmGlForm.EnableHeightCB.Checked:=False;
     dtmGlForm.FormShowDown;
   end else  SetLength(ManMatrix,0,0);
  end;   end;
end;
(******************************************************************)
{Convert 24 bit image into a heightfield
Save as Bin/tpcfg   or  grayscale bmp}
procedure TImageMakerForm.ImageBinBtnClick(Sender: TObject);
var
  FractalFilename, MyFilesExtension: string;
{  F_File: file of Smallint;}
  Red,Green,Blue:Byte;
  Tempman,Pixelxs,
{  maxcolx, maxrowy,  XCount, YCount,}
  y,Pixelx,height:Integer;
  BitMap : TBitMap;
  PixelLine : PByteArray;
begin
            OpenDialog1.Filter := 'dem bmp|*.bmp';
            OpenDialog1.Filename := '*.bmp';
            OpenDialog1.InitialDir:=ImagePath;
if OpenDialog1.Execute then
begin
  MyFilesExtension :=
      Uppercase(ExtractFileExt(OpenDialog1.FileName));
  if MyFilesExtension = '.BMP' then
  begin
    FractalFilename := OpenDialog1.FileName;
    BitMap := TBitMap.create;
    try
    BitMap.LoadFromFile(FractalFilename);
    {  PixelScanSize := 3;   pf24bit  PixelScanSize := 4;   pf32bit  }
    BitMap.PixelFormat := pf24bit;
    FileSizeX:=Bitmap.Width;
    FileSizeY:=Bitmap.Height;
    // Dynamically allocate the ManMatrix array
    SetLength(ManMatrix, FileSizeX, FileSizeY);
    MaximumElevation := -2147483647;
    MinimumElevation := 2147483646;
    for y := 0 to BitMap.height -1 do
    begin
            ProgressBar1.Position :=
            Round((y / FileSizeY) * 100);
            Application.ProcessMessages;
      PixelLine := BitMap.ScanLine[y];
      for Pixelx := 0 to BitMap.width -1 do
      begin
        Pixelxs := (Pixelx * 3);
        Red:=GetRValue(PixelLine[Pixelxs]);
        Green:=GetGValue(PixelLine[(Pixelxs + 1)]);
        Blue:=GetBValue(PixelLine[(Pixelxs + 2)]);
        // Set the height to a percentage of the maximum
        // value (255+255+255 = 765) this sets the height in a range
        // of 0.0 (0+0+0 = black pixel) to 1.0 (255+255+255 = white pixel)
        height := Round(((Red + Green + Blue) / 765)*1000);
        // Set the Z value of the current point in the mesh to the
        // value calculated above
        ManMatrix[Pixelx, y] := height;
              TempMan:=height;
              if (MaximumElevation <= TempMan) then
                MaximumElevation := TempMan;
              if (MinimumElevation >= TempMan) then
                MinimumElevation := TempMan;
      end;
    end;
    ProgressBar1.Position :=0;
    Application.ProcessMessages;
    finally
    BitMap.free;
    end;

    If ((ImageDoRG.ItemIndex=0)or(ImageDoRG.ItemIndex=2)) then
     MatrixBmp(FractalFilename,MinimumElevation,MaximumElevation);
    If ((ImageDoRG.ItemIndex=1)or(ImageDoRG.ItemIndex=2)) then
     MatrixBin(FractalFilename,MinimumElevation,MaximumElevation);
    Application.ProcessMessages;
   If ((LaunchGLViewerCB.Checked)and NoGLRunning) then
   begin
     NoGLRunning:=False;
     dtmGlForm.show;
     dtmGlForm.EnableHeightCB.Checked:=False;
     dtmGlForm.FormShowDown;
   end else  SetLength(ManMatrix,0,0);
    end;
  end;
end;

procedure TImageMakerForm.MakeMatrix(var MinimumElevation,MaximumElevation:Integer);
var
   ThinnerSQ,Thinner, Y1size,X1size, ElevationCounted,
   Xcount, Ycount,  ElevationTotal, Xcount2, Ycount2,
   Ratiosize, OutX{,OutY}:Integer;
  ElevationCount: Smallint;
Begin
  Case IMRG.Itemindex of
    0:begin
        OutX:=iXSize;
      end;
    else
      begin
        OutX:=StrtoInt(XSizeEdit.Text);
      end;
  end;{case}
  Ratiosize:=  iXSize div OutX ;
  Thinner:=Ratiosize;
  ThinnerSQ:= (Thinner*Thinner);
  X1size := (iXSize div Thinner);
  Y1size := (iYSize div Thinner);
  FileSizeX:=X1size;
  FileSizeY:=Y1size;
  XSizeEdit.Text:=Inttostr(FileSizeX);
  YSizeEdit.Text:=Inttostr(FileSizeY);
  SetLength(ManMatrix, X1size, Y1size);
  ProgressBar1.Position:=0;
  Application.ProcessMessages;
  for Ycount := 0 to Y1size - 1 do
  begin
    ProgressBar1.Position :=
               Round((Ycount / (Y1size- 1)) * 100);
    Application.ProcessMessages;
    for Xcount := 0 to X1size - 1 do
    begin
          {Add the thinned data and divide by
          thinner * Thinner}
      ElevationTotal:=0;
      for Ycount2 := 0 to Thinner - 1 do
      begin
        for Xcount2 := 0 to Thinner - 1 do
        begin
          ElevationTotal:=
              ElevationTotal+
              htf.XYHeight(
                        ((Xcount*Thinner)+Xcount2),
                        ((Ycount*Thinner)+Ycount2));
        end;
      end;
      ElevationCount:=
                round(ElevationTotal / ThinnerSQ );
      ManMatrix[Xcount,Ycount]:=ElevationCount;
      ElevationCounted:=ElevationCount;
      if (MaximumElevation <= ElevationCounted) then
         MaximumElevation := ElevationCounted;
      if (MinimumElevation >= ElevationCounted) then
          MinimumElevation := ElevationCounted;
    end;
  end;
  ProgressBar1.Position := 0;
End;

procedure TImageMakerForm.MatrixBmp(InFile:String;Min,Max:Integer);
type
  TLogPal = record
     lpal : TLogPalette;
     pe : Array[0..255] of TPaletteEntry;
  end;
var
   Ratio, x, y : Integer;
   bmp : TBitmap;
   scanLine : {PChar; }PByteArray;
   logpal : TLogPal;
   BackupName:String;
begin
      bmp:=  TBitMap.Create;
      bmp.PixelFormat:=pf8bit;
      bmp.Width:=FileSizeX;
      bmp.Height:=FileSizeY;
      Ratio:=Round((Max - Min)/255);
      for x:=0 to 255 do with logPal.lpal.palPalEntry[x] do
      begin
         peRed:=x;
         peGreen:=x;
         peBlue:=x;
         peFlags:=0;
      end;
      with logpal.lpal do
      begin
         palVersion:=$300;
         palNumEntries:=256;
      end;
      bmp.Palette:=CreatePalette(logPal.lpal);
          for y := FileSizeY- 1 downto 0 do
          begin
            ProgressBar1.Position :=
            Round((y / FileSizeY) * 100);
            Application.ProcessMessages;
            scanLine:=bmp.ScanLine[y];
            for x := 0 to FileSizeX- 1 do
            begin
              scanLine[x]:=(ManMatrix[x, y] div Ratio);
            end;
          end;
    if FileExists(InFile) then
    begin
      BackupName := ExtractFileName(InFile);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(InFile, BackupName) then
        raise Exception.Create('Unable to create backup file.');
    end;
   bmp.SaveToFile(InFile);
   If ((LaunchGLViewerCB.Checked)and NoGLRunning) then
   begin
     NoGLRunning:=False;
     dtmGlForm.Image1.Picture.Assign(bmp);
     dtmGlForm.show;
     dtmGlForm.EnableHeightCB.Checked:=True;
     dtmGlForm.FormShowDown;
     bmp.Free;
   end else bmp.Free;
end;

procedure TImageMakerForm.MatrixBin(InFile:String;Min,Max:Integer);
var
  MyFilesS, FileMatrix:String;
  F_File: file of Smallint;
  tpcfgfile:textfile;
  XCount, YCount :Integer;
Begin
        FileMatrix := ChangeFileExt(InFile, '.bin');
        AssignFile(F_File, FileMatrix);
        ReWrite(F_File);
        if IoResult = 0 then
        begin
          for Ycount := 0 to FileSizeY- 1 do
          begin
            ProgressBar1.Position :=
            Round((Ycount / FileSizeY) * 100);
            Application.ProcessMessages;
            for Xcount := 0 to FileSizeX- 1 do
            begin
              Write(F_File, ManMatrix[Xcount, Ycount]);
            end;
          end;
          CloseFile(F_File);
       end;
begin
      AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(InFile),'.tpcfg'));
      Rewrite(tpcfgfile);
      {HTFName=F:\HTF\etopo2.htf}
      MyFilesS:='HTFName='+HTFPath{+'\'}+ChangeFileExt(ExtractFileName(InFile),'.htf');
      Writeln(tpcfgfile,MyFilesS);
      {WorldSizeX=10800}
      MyFilesS:='WorldSizeX='+IntToStr(FileSizeX);
      Writeln(tpcfgfile,MyFilesS);
      {WorldSizeY=6336}
      MyFilesS:='WorldSizeY='+IntToStr(FileSizeY);
      Writeln(tpcfgfile,MyFilesS);
      {TileSize=128}
      MyFilesS:='TileSize='+IntToStr(128);
      Writeln(tpcfgfile,MyFilesS);
      {DefaultZ=0}
      MyFilesS:='DefaultZ='+IntToStr(Min);{-32767 NullDatumValue}
      Writeln(tpcfgfile,MyFilesS);
      {DEMPath=F:\DEM}
      MyFilesS:='DEMPath='+DEMPath;
      Writeln(tpcfgfile,MyFilesS);
        MyFilesS:='DEMs="'
                +ExtractFileName(ChangeFileExt(InFile,'.bin'))
                +',""0,0"",'+
                IntToStr(FileSizeX)+'x'+
                IntToStr(FileSizeY)+',""16 bits (Intel)"""';
      Writeln(tpcfgfile,MyFilesS);
      CloseFile(tpcfgfile);
end;

End;
  {HTFPath DemPath}
(*


    begin
      tyCount:=0;
      tyCount2:=0;
      for ty:=0 to htf.SizeY-1 do
      begin
        inc(tyCount);
        If ((tyCount = Ratiosize)) then
        begin
          ProgressBar1.Position:= round((tyCount2/OutY)*100);
          inc(tyCount2);
          Application.ProcessMessages;
          tyCount:=0;
          txCount:=0;
          for tx:=0 to htf.SizeX-1 do
          begin
            inc(txCount);
            If (txCount = Ratiosize) then
            begin
              txCount:=0;
              OutNumber:=htf.XYHeight(tx,ty);
              BlockWrite(OutFile,OutNumber,1);
            end;
          end;
        end;
      end;
    end;
  CloseFile(OutFile);
  end;{Chosen}
  ProgressBar1.Position:=0;
end;*)
  (*
var
   doscanLine : PByteArray;
   tx, ty, tyCount, txCount, tyCounted, txCounted,
   Ratiosize, OutX,OutY:Integer;
   Outbmp:TBitmap;
   tile : PHeightTile;
   tileInfo : PHeightTileInfo;

var {Placemat,}
  MaximumElevationi,MinimumElevationi,
  Whatis1i, Whatis2i, Whatis3i, Whatis4i,
  Whatis5i, Whatis6i, Whatis7i, Whatis8i,
  Elevator, maxcolx, maxrowy, I, K, CodeVx: Integer;
  Whatis1, Whatis2, Whatis3, Whatis4,
  Whatis5, Whatis6, Whatis7, Whatis8, Whatis9: Double;
  TempColor: TColor; MtnString: string;
    Case IMRG.Itemindex of
    0:begin
        OutX:=iXSize;
        OutY:=iYSize;
      end;
      else
      begin
        OutX:=StrtoInt(XSizeEdit.Text);
        OutY:=StrtoInt(YSizeEdit.Text);
      end;
    end;{case}
    Ratiosize:=  iXSize div OutX ;
    Outbmp:=TBitmap.Create;
    Outbmp.Width:= OutX;
    Outbmp.Height:= OutY;
    Outbmp.Pixelformat:=pf24bit;
    tyCounted:=0;
    txCounted:=0;
    ProgressBar1.Position:=0;
    Application.ProcessMessages;
    For i:=0 to htf.TileCount-1 do
    begin
      tileInfo:=htf.Tiles[i];
      MaximumElevationi:=tileinfo.max;
      MinimumElevationi:=tileInfo.min;
      If (MaximumElevationi>MaximumElevation) then
         MaximumElevation:=MaximumElevationi;
      If (MinimumElevationi>MinimumElevation) then
         MinimumElevation:=MinimumElevationi;
    end;

    ContourInterval := ((MaximumElevation - MinimumElevation) div 7);
{            if (Fractalgorhythym = 4) then begin}
{Determine 9 Terrain RANGES having 255 units}
              val(dtmPOFForm.ECI1Edit.Text, Whatis1i, CodeVx);
                Codefx(dtmPOFForm.ECI1Edit.Text, CodeVx);
              val(dtmPOFForm.ECI2Edit.Text, Whatis2i, CodeVx);
                Codefx(dtmPOFForm.ECI2Edit.Text, CodeVx);
              val(dtmPOFForm.ECI3Edit.Text, Whatis3i, CodeVx);
                Codefx(dtmPOFForm.ECI3Edit.Text, CodeVx);
              val(dtmPOFForm.ECI4Edit.Text, Whatis4i, CodeVx);
                Codefx(dtmPOFForm.ECI4Edit.Text, CodeVx);
              val(dtmPOFForm.ECI5Edit.Text, Whatis5i, CodeVx);
                Codefx(dtmPOFForm.ECI5Edit.Text, CodeVx);
              val(dtmPOFForm.ECI6Edit.Text, Whatis6i, CodeVx);
                Codefx(dtmPOFForm.ECI6Edit.Text, CodeVx);
              val(dtmPOFForm.ECI7Edit.Text, Whatis7i, CodeVx);
                Codefx(dtmPOFForm.ECI7Edit.Text, CodeVx);
              val(dtmPOFForm.ECI8Edit.Text, Whatis8i, CodeVx);
                Codefx(dtmPOFForm.ECI8Edit.Text, CodeVx);

              Whatis1 := ((MinimumElevation + Whatis1i) / 255);
              Whatis2 := ((Whatis1i + Whatis2i) / 255);
              Whatis3 := ((Whatis2i + Whatis3i) / 255);
              Whatis4 := ((Whatis4i + Whatis3i) / 255);
              Whatis5 := ((Whatis5i - Whatis4i) / 255);
              Whatis6 := ((Whatis6i - Whatis5i) / 255);
              Whatis7 := ((Whatis7i - Whatis6i) / 255);
              Whatis8 := ((Whatis8i - Whatis7i) / 255);
              Whatis9 := ((MaximumElevation - Whatis8i) / 255);
    begin
      tyCount:=0;
      for ty:=0 to htf.SizeY-1 do
      begin
        inc(tyCount);
        If ((tyCount = Ratiosize)) then
        begin
          ProgressBar1.Position:= round((tyCounted/OutY)*100);
          Application.ProcessMessages;
          tyCount:=0;
          txCount:=0;
          doscanLine:=Outbmp.ScanLine[tyCounted];
          inc(tyCounted);
          for tx:=0 to htf.SizeX-1 do
          begin
            inc(txCount);
            If (txCount = Ratiosize) then
            begin
              txCount:=0;
              Elevator:=htf.XYHeight(tx,ty);
{Blue 0,0,255 }
{Aqua 0,255,255 }
{Green 0,255,0}
{Yellow 255,255,0}
{Red 255,0,0}
{Purple 255,0,255}
{Smog 255,255,255}
TempColor:= clBlue;
{ If (NullDemValue = Elevator)then Pixels[I, K] := clBlue else}

                  if ((Elevator >= MinimumElevation)
                    and (Elevator <= (Whatis1i))) then begin
                    TempColor := RGB(255 - abs(round(Elevator /
                      Whatis1) mod 255),
                      255 - abs(round(Elevator / Whatis1) mod 255),
                      255 - abs(round(Elevator / Whatis1) mod 255));
{                    Pixels[I, K] := TempColor;} {Smog 255,255,255}
                  end else
                    if ((Elevator >= Whatis1i)
                      and (Elevator <= Whatis2i)) then begin
                      TempColor := RGB(255 - abs(round(Elevator /
                        Whatis2) mod 255),
                        0,
                        255 - abs(round(Elevator / Whatis2) mod
                          255));
{                      Pixels[I, K] := TempColor; }{Purple 255,0,255}
                    end else
                      if ((Elevator >= Whatis2i)
                        and (Elevator <= Whatis3i)) then begin
                        TempColor := RGB(0,
                          0,
                          255 - abs(round(Elevator / Whatis3) mod
                            255));
{                        Pixels[I, K] := TempColor; }{Blue 0,0,255 }
                      end else
                        if ((Elevator >= Whatis3i)
                          and (Elevator <= Whatis4i)) then begin
                          TempColor := RGB(0,
                            255 - abs(round(Elevator / Whatis4) mod
                              255),
                            255 - abs(round(Elevator / Whatis4) mod
                              255));
{                          Pixels[I, K] := TempColor;}
                        end else {Aqua 0,255,255 }
                          if ((Elevator >= Whatis4i)
                            and (Elevator <= Whatis5i)) then begin
                            TempColor := RGB(0,
                              255 - abs(round(Elevator / Whatis5) mod
                                255),
                              0);
{                            Pixels[I, K] := TempColor;}
                          end else {Green 0,255,0}
                            if ((Elevator >= Whatis5i)
                              and (Elevator <= Whatis6i)) then begin
                              TempColor := RGB(255 -
                                abs(round(Elevator / Whatis6) mod 255),
                                255 - abs(round(Elevator / Whatis6)
                                  mod 255),
                                0);
{                              Pixels[I, K] := TempColor;}
                            end else {Yellow 255,255,0}
                              if ((Elevator >= Whatis6i)
                                and (Elevator <= Whatis7i)) then begin
                                TempColor := RGB(255 -
                                  abs(round(Elevator / Whatis7) mod
                                  255),
                                  0,
                                  0);
{                                Pixels[I, K] := TempColor;}
                              end else {Red 255,0,0}
                                if ((Elevator >= Whatis7i)
                                  and (Elevator <= Whatis8i)) then
                                    begin
                                  TempColor := RGB(255 -
                                    abs(round(Elevator / Whatis8) mod
                                    255),
                                    0,
                                    255 - abs(round(Elevator /
                                      Whatis8) mod 255));
{                                  Pixels[I, K] := TempColor;}
                                end else {Purple 255,0,255}
                                  if ((Elevator >= Whatis8i)
                                    and (Elevator <=
                                      MaximumElevation)) then begin
                                    TempColor := RGB(255 -
                                      abs(round(Elevator / Whatis9) mod
                                      255),
                                      255 - abs(round(Elevator /
                                        Whatis9) mod 255),
                                      255 - abs(round(Elevator /
                                        Whatis9) mod 255));
{                                    Pixels[I, K] := TempColor;}
                                  end; {Smog 255,255,255}
{                end;
              end;}
              doscanLine[txCounted]:=TempColor;
{              WinColor(heightColor[htf.XYHeight(tx,ty)]);}


              inc(txCounted);
            end;
          end;
        end;
      end;
    end;
    {OutX,OutY}

    Outbmp.SaveToFile(SaveDialog1.FileName);
    Outbmp.Free;
  end;{Chosen}
  ProgressBar1.Position:=0;
end;
*)
{Gather results}
{
          maxcolx:=  FileSizeX- 1;
          maxrowy := FileSizeY- 1;
          for Ycount := 0 to maxrowy do
          begin
            ProgressBar1.Position :=
            Round((Ycount / maxrowy) * 100);
            Application.ProcessMessages;
            for Xcount := 0 to maxcolx do
            begin
              TempMan:=ManMatrix[Xcount, Ycount];
              if (MaximumElevation <= TempMan) then
                MaximumElevation := TempMan;
              if (MinimumElevation >= TempMan) then
                MinimumElevation := TempMan;
            end;
          end;
}

{Save the data}
{          MyFilesS := ExtractFileName(FractalFileName);
          RgbToDemEdit.Text := MyFilesS;
          Vre:=0;
          Vde:=0;
          iMadeMountains:=200;
          Vx:=0; Vy:=0;
          Vzx:=FileSizeX;
          Vzy:=FileSizeY;
          Vg:=0; Vh:=0; Vi:=0;Viki:=0;
VDEM:=5;
NullDemValue:=-32767;
CellSizeX:=1;
CellSizeY:=1;
DemiLeftX1e:=0;
DemiTopY1e:=0;
DemiRightX2e:=FileSizeX*CellSizeX;
DemiBottomY2e:=FileSizeY*CellSizeY;
ContourInterval := 0;
Fractalgorhythym := 0;
GridOriginString:=    'NW';
CellOriginString:=  'NW';
ILorUGridString:= 'RGB Import';
ProjectionString:= 'None';
UtmZoneString:= 'None';
DatumString:= 'None';
SpheroidString:= 'None';
ZunitsString:=   'Meters';
GridUnitString:=  'Grid Unit';}
{  begin
      begin
        Application.ProcessMessages;
        FractalFilename := ChangeFileExt(FractalFilename, '.bin');
        AssignFile(F_File, FractalFilename);
        ReWrite(F_File);
        if IoResult = 0 then
        begin
          maxcolx:=  FileSizeX- 1;
          maxrowy := FileSizeY- 1;
          for Ycount := 0 to maxrowy do
          begin
            ProgressBar1.Position :=
            Round((Ycount / maxrowy) * 100);
            Application.ProcessMessages;
            for Xcount := 0 to maxcolx do
            begin
              Write(F_File, ManMatrix[Xcount, Ycount]);
            end;
          end;
          CloseFile(F_File);
          if (IoResult <> 0) then DoMessages(???30064);
        end else DoMessages(??30065);
      end;
  end;}{this set}
{           WriteFlmFile(ChangeFileExt(FractalFileName,'.flm'));
           WriteDehFile(ChangeFileExt(FractalFileName,'.deh'));}
    {Display or whatever}
{    XYZ3DForm.MtnsProgressBar.Position :=0;
    Application.ProcessMessages;
      XYZGL.FormShowDown;
      XYZGL.show;   }




procedure TImageMakerForm.ImagetoRGBHistogramBtnClick(Sender: TObject);
type
  Count3D = array[0..255] of Byte;
var
  Count3DArray: Count3D;
  RX, GY, BZ, Value: Byte;
  fLoad: file of Count3D;
var
  FractalFilename, MyFilesExtension: string;
  Red,Green,Blue:Byte;
  Pixelxs, y,Pixelx:Integer;
  BitMap : TBitMap;
  PixelLine : PByteArray;
  HisMatrix: array of array of array of Byte;
begin
            OpenDialog1.Filter := 'dem bmp|*.bmp';
            OpenDialog1.Filename := '*.bmp';
            OpenDialog1.InitialDir:=ImagePath;
if OpenDialog1.Execute then
begin
  MyFilesExtension :=
      Uppercase(ExtractFileExt(OpenDialog1.FileName));
  if MyFilesExtension = '.BMP' then
  begin
    FractalFilename := OpenDialog1.FileName;
    BitMap := TBitMap.create;
    try
    BitMap.LoadFromFile(FractalFilename);
    {  PixelScanSize := 3;   pf24bit  PixelScanSize := 4;   pf32bit  }
    BitMap.PixelFormat := pf24bit;
    FileSizeX:=Bitmap.Width;
    FileSizeY:=Bitmap.Height;
    // Dynamically allocate the ManMatrix array
    SetLength(ManMatrix, FileSizeX, FileSizeY);
    SetLength(HisMatrix, 256, 256, 256);
    MaximumElevation := -2147483647;
    MinimumElevation := 2147483646;
    for y := 0 to BitMap.height -1 do
    begin
            ProgressBar1.Position :=
            Round((y / FileSizeY) * 100);
            Application.ProcessMessages;
      PixelLine := BitMap.ScanLine[y];
      for Pixelx := 0 to BitMap.width -1 do
      begin
        Pixelxs := (Pixelx * 3);
        Red:=GetRValue(PixelLine[Pixelxs]);
        Green:=GetGValue(PixelLine[(Pixelxs + 1)]);
        Blue:=GetBValue(PixelLine[(Pixelxs + 2)]);
        Value:=HisMatrix[Red, Green, Blue];
        HisMatrix[Red, Green, Blue]:=Value+1;
     end;
   end;


  {Read em in}
  {$I-}
  FractalFilename:=ChangeFileExt(FractalFilename,'*.rs3');
  AssignFile(fLoad, FractalFilename);
  Rewrite(fLoad);
  ProgressBar1.Visible:=True;
  for BZ := 0 to 255 do
  begin
    ProgressBar1.Position:= Round(100 * (BZ / 255));
    for GY := 0 to 255 do
    begin {Row}
      for RX := 0 to 255 do
      begin {Col}
        Value :=HisMatrix[RX, GY, BZ];
        Count3DArray[RX] := Value;
      end;
      write(fLoad, Count3DArray);
    end;
  end;
    CloseFile(fLoad);
  {$I+}
  ProgressBar1.Position:=(0);
  Except
    ProgressBar1.Position:=(0);
    CloseFile(fLoad);
    SetLength(HisMatrix, 0, 0, 0);
  end;
    SetLength(HisMatrix, 0, 0, 0);
end;end;
end;

end.
