{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmHtfFrm;
{: Utility to pack one or many DEM sources into a single HTF.<p>
   Note: this is a *basic* tool,
   error messages are unfriendly
   and there are memory leaks if you do any, I know.
    So, don't do errors ;)<p>
   Changed May02 by Ivan Lee Herring}

{      SetDefaultDEMProj;
FileSizeX,FileSizeY
NullValueEdit.Text
IntegerorFloatCB.Checked
SourceCB.ItemIndex
WriteTpcfgFile(InfileName:String);}

interface

uses
  Windows, Messages, Sysutils, FileCtrl,
  Classes, Graphics, Controls, Forms,
  Dialogs, Grids, Menus,
  dtmgrdfuncs, dtmgridimportfn,
  StdCtrls, ComCtrls, ToolWin, ExtCtrls,
  ActnList, ImgList, Buttons, jpeg,
  GR32, GR32_Layers, GR32_Image;

type
   TSrc = record
      fs : TFileStream;
      x, y, w, h : Integer;
      format : Integer;
   end;
   PSrc = ^TSrc;

   TISrc = record
      fs : TFileStream;
      x, y, w, h, bands : Integer;
      format : Integer;
   end;
   PISrc = ^TISrc;

  THtfForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    ActionList: TActionList;
    ImageList: TImageList;
    ACOpen: TAction;
    ACSave: TAction;
    ACExit: TAction;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    ToolBar: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    DEMs1: TMenuItem;
    ACNewDEM: TAction;
    ACRemoveDEM: TAction;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    AddDEMsource1: TMenuItem;
    RemoveDEMsource1: TMenuItem;
    SDHTF: TSaveDialog;
    PopupMenu: TPopupMenu;
    AddDEMsource2: TMenuItem;
    RemoveDEMsource2: TMenuItem;
    MIAbout: TMenuItem;
    ODTerrainPack: TOpenDialog;
    SDTerrainPack: TSaveDialog;
    ToolButton6: TToolButton;
    ACProcess: TAction;
    ToolButton7: TToolButton;
    N2: TMenuItem;
    Process1: TMenuItem;
    Panel2: TPanel;
    ToolButton8: TToolButton;
    ACViewer: TAction;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EDHTFName: TEdit;
    EDDEMPath: TEdit;
    BUDEMPathBtn: TButton;
    HtfPathBtn: TButton;
    EDSizeX: TEdit;
    EDSizeY: TEdit;
    EDDefaultZ: TEdit;
    EDTileSize: TEdit;
    StringGrid: TStringGrid;
    CBFile: TComboBox;
    CBType: TComboBox;
    ProgressBar: TProgressBar;
    ProjectionCB: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    InUnitCB: TComboBox;
    Label9: TLabel;
    InDatumCB: TComboBox;
    Label289: TLabel;
    SpheroidCB: TComboBox;
    Label10: TLabel;
    InUtmZoneCB: TComboBox;
    UTMZoneNorthCB: TCheckBox;
    StatePlaneZoneEdit: TEdit;
    DLGPE1: TEdit;
    DLGPD1: TEdit;
    DLGPC1: TEdit;
    DLGPB1: TEdit;
    DLGPA1: TEdit;
    DLGPA2: TEdit;
    DLGPB2: TEdit;
    DLGPC2: TEdit;
    DLGPD2: TEdit;
    DLGPE2: TEdit;
    DLGPE3: TEdit;
    DLGPD3: TEdit;
    DLGPC3: TEdit;
    DLGPB3: TEdit;
    DLGPA3: TEdit;
    MapZUnitsCB: TComboBox;
    Label178: TLabel;
    BottomLeftXEdit: TEdit;
    Label189: TLabel;
    BottomRightXEdit: TEdit;
    Label188: TLabel;
    TopRightXEdit: TEdit;
    Label187: TLabel;
    TopLeftXEdit: TEdit;
    Label186: TLabel;
    Label184: TLabel;
    PixelXSizeEdit: TEdit;
    Label185: TLabel;
    PixelYSizeEdit: TEdit;
    NullValueEdit: TEdit;
    Help1: TMenuItem;
    Help2: TMenuItem;
    TabSheet3: TTabSheet;
    DEMtoBinBtn: TSpeedButton;
    ValidProjectionCB: TCheckBox;
    DEMtoBinMemo: TRichEdit;
    SavethememoBtn: TSpeedButton;
    ZSizeEdit: TEdit;
    Label12: TLabel;
    SDTStoBinBtn: TSpeedButton;
    XYZtoBinBtn: TSpeedButton;
    BottomLeftYEdit: TEdit;
    Label13: TLabel;
    BottomRightYEdit: TEdit;
    Label14: TLabel;
    TopRightYEdit: TEdit;
    Label15: TLabel;
    TopLeftYEdit: TEdit;
    Label16: TLabel;
    PixelCoordinateCB: TComboBox;
    Label17: TLabel;
    DEM1: TMenuItem;
    Projections1: TMenuItem;
    SetCurrent1: TMenuItem;
    ViewCurrent1: TMenuItem;
    Process250k1: TMenuItem;
    SDTS1: TMenuItem;
    XYZ1: TMenuItem;
    ARCGridtoBinBtn: TSpeedButton;
    Dem250kList: TSpeedButton;
    N3: TMenuItem;
    ArcGrid1: TMenuItem;
    N250kList1: TMenuItem;
    AutosaveMemoCB: TCheckBox;
    ReaddemProjection1: TMenuItem;
    SetdemProjection1: TMenuItem;
    XWidthEdit: TEdit;
    YHeightEdit: TEdit;
    IntegerorFloatCB: TCheckBox;
    DemName: TLabel;
    SaveBinProjastxt1: TMenuItem;
    N5: TMenuItem;
    ReadWriteLabel: TLabel;
    CellLocatorEdit: TEdit;
    SEYNSEdit: TEdit;
    SEXEWEdit: TEdit;
    BTBtn: TSpeedButton;
    EtopoBtn: TSpeedButton;
    GtopoBtn: TSpeedButton;
    GlobeBtn: TSpeedButton;
    FloatingPointCB: TCheckBox;
    BT1: TMenuItem;
    NOAAGlobe1: TMenuItem;
    Gtopo1: TMenuItem;
    Etopo1: TMenuItem;
    Etopo2Btn: TSpeedButton;
    ColonLabel: TLabel;
    Projections2: TMenuItem;
    Etopo21: TMenuItem;
    N6: TMenuItem;
    SourceCB: TComboBox;
    VersionEdit: TEdit;
    Label18: TLabel;
    SavedisplayedProjectionasprj1: TMenuItem;
    ResettoDefault1: TMenuItem;
    ReadfilenamevrpasProjection1: TMenuItem;
    dem24ktobinBtn: TSpeedButton;
    DEM24k1: TMenuItem;
    StateNameEdit: TEdit;
    StateFipsCodeEdit: TEdit;
    TabSheet4: TTabSheet;
    DMStoDDEdit: TEdit;
    DMStoDDBtn: TSpeedButton;
    Label213: TLabel;
    Label234: TLabel;
    Label214: TLabel;
    Label233: TLabel;
    Label11: TLabel;
    Label212: TLabel;
    RIHDMStoDDEdit: TEdit;
    RIHDMStoDDBtn: TButton;
    Bevel1: TBevel;
    StateFipsCodeCB: TComboBox;
    SRTM3toBinBtn: TSpeedButton;
    SRTM1toBinBtn: TSpeedButton;
    ProcessperProjectionData: TSpeedButton;
    IntelIntegersCB: TCheckBox;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label25: TLabel;
    CountryNameEdit: TEdit;
    CountryFipsCodeEdit: TEdit;
    CountryFipsCodeCB: TComboBox;
    CountyNameEdit: TEdit;
    CountyFipsCodeEdit: TEdit;
    CountyFipsCodeCB: TComboBox;
    MinPathEdit: TEdit;
    MinRowEdit: TEdit;
    Label23: TLabel;
    Label24: TLabel;
    CenterLatEdit: TEdit;
    CenterLonEdit: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    PRConverter: TSpeedButton;
    MarsBtn: TSpeedButton;
    SkipHeaderCB: TCheckBox;
    SkipHeaderSizeEdit: TEdit;
    MarsListFilesBtn: TSpeedButton;
    KiloPerPixelEdit: TEdit;
    PixelsPerDegreeEdit: TEdit;
    Label28: TLabel;
    Label29: TLabel;
    SkipHeaderSizeEdit2: TEdit;
    DemIntegerOrFloatCB: TCheckBox;
    SRTM3ListBtn: TSpeedButton;
    SRTM1ListBtn: TSpeedButton;
    SurferGridtoBinBtn: TSpeedButton;
    TabSheet5: TTabSheet;
    MoonPCBtn: TSpeedButton;
    MarsPCBtn: TSpeedButton;
    SurferGrid1: TMenuItem;
    Label19: TLabel;
    BitShpViewerTS: TTabSheet;
    OpenHtf1: TMenuItem;
    Openbit1: TMenuItem;
    Openshp1: TMenuItem;
    N4: TMenuItem;
    N7: TMenuItem;
    ScrollBox1: TScrollBox;
    BitShpImage: TImage32;
    TabSheet6: TTabSheet;
    Panel3: TPanel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    RifPathEdit: TEdit;
    ImagePathEdit: TEdit;
    ImagePathBtn: TButton;
    RifBtn: TButton;
    RifSizeX: TEdit;
    RifSizeY: TEdit;
    DefaultDataEdit: TEdit;
    RifTileSize: TEdit;
    StringGrid1: TStringGrid;
    RifCbFiles: TComboBox;
    RifCBType: TComboBox;
    RIF1: TMenuItem;
    Open2: TMenuItem;
    Save2: TMenuItem;
    Process2: TMenuItem;
    N8: TMenuItem;
    AddImageSource1: TMenuItem;
    RemoveImageSource1: TMenuItem;
    Label36: TLabel;
    TabSheet7: TTabSheet;
    RIHinSetEdit: TEdit;
    RIHVolumeEdit: TEdit;
    RIHProjectRollFrameEdit: TEdit;
    Label322: TLabel;
    Label325: TLabel;
    Label326: TLabel;
    RIHProductSizeEdit: TEdit;
    RIHProducedEdit: TEdit;
    RIHAcquiredEdit: TEdit;
    Label315: TLabel;
    Label193: TLabel;
    Label323: TLabel;
    RIHBlockEdit: TEdit;
    RIHEndRow: TEdit;
    RIHStartRow: TEdit;
    RIHPath: TEdit;
    Label194: TLabel;
    Label195: TLabel;
    Label297: TLabel;
    Label314: TLabel;
    RIHRecordSizeEdit: TEdit;
    RIHSensorID: TEdit;
    RIHSensorType: TEdit;
    Label164: TLabel;
    Label208: TLabel;
    Label327: TLabel;
    RIHWeatherEdit: TEdit;
    RIHSunAzimuthAngleEdit: TEdit;
    RIHSunElevationAngleEdit: TEdit;
    Label255: TLabel;
    Label256: TLabel;
    Label320: TLabel;
    RIHSwathWidthEdit: TEdit;
    RIHSwathWidthRezEdit: TEdit;
    RIHSwathHeightEdit: TEdit;
    RIHSwathHeightRezEdit: TEdit;
    RIHFlightlineEdit: TEdit;
    Label321: TLabel;
    Label37: TLabel;
    Label319: TLabel;
    SensorAltitudeEdit: TEdit;
    RIHOrientationAngleEdit: TEdit;
    RIHAcquiredBitsEdit: TEdit;
    RIHCurrentBitsEdit: TEdit;
    Label248: TLabel;
    Label246: TLabel;
    Label254: TLabel;
    Label317: TLabel;
    RIHOffsetEdit: TEdit;
    RIHRangeEdit: TEdit;
    RIHScannedRez: TEdit;
    Label139: TLabel;
    Label236: TLabel;
    Label253: TLabel;
    RIHLookAngleEdit: TEdit;
    RIHDirectionEdit: TEdit;
    RIHSourceScale: TEdit;
    Label223: TLabel;
    Label245: TLabel;
    RIHSensorModeEdit: TEdit;
    RIHDataSource: TEdit;
    RIHProjectData: TEdit;
    Label38: TLabel;
    Label192: TLabel;
    Label241: TLabel;
    RIHImageComboBox: TComboBox;
    RIHImageTypeEdit: TEdit;
    Label294: TLabel;
    Label222: TLabel;
    RIHSceneTitle: TEdit;
    Label165: TLabel;
    RIHIDEdit: TEdit;
    Label263: TLabel;
    RIHRIHEdit: TEdit;
    RIHLC: TEdit;
    RIHRC: TEdit;
    RIHIW: TEdit;
    RIHinLine: TEdit;
    RIHinColumn: TEdit;
    RIHIH: TEdit;
    RIHBR: TEdit;
    RIHTR: TEdit;
    Label171: TLabel;
    Label172: TLabel;
    Label173: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label170: TLabel;
    Label169: TLabel;
    Label168: TLabel;
    RIHNBEdit: TEdit;
    Label210: TLabel;
    Label330: TLabel;
    RevEdit: TEdit;
    Label166: TLabel;
    SignalEdit: TEdit;
    Label318: TLabel;
    PolarityEdit: TEdit;
    RIHBName1: TEdit;
    Label209: TLabel;
    RIHBSR1: TEdit;
    Label211: TLabel;
    RIHBFName1: TEdit;
    Label167: TLabel;
    RIHGain1: TEdit;
    Label249: TLabel;
    RIHBias1: TEdit;
    Label250: TLabel;
    RIHMin1: TEdit;
    Label292: TLabel;
    Label293: TLabel;
    RIHMax1: TEdit;
    Label316: TLabel;
    MapQuadrangleEdit: TEdit;
    Label324: TLabel;
    ProductTypeEdit: TEdit;
    Label251: TLabel;
    Label252: TLabel;
    PreProcessingEdit: TEdit;
    ResamplingTechniqueEdit: TEdit;
    YShiftEdit: TEdit;
    Label291: TLabel;
    XShiftEdit: TEdit;
    Label290: TLabel;
    RifBandsEdit: TEdit;
    RIFBandsUpDown: TUpDown;
    RIFProjections1: TMenuItem;
    ViewCurrentrifvrp1: TMenuItem;
    SetCurrentrifvrp1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure MIAboutClick(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure ACExitExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);


    procedure BUDEMPathBtnClick(Sender: TObject);
    procedure HtfPathBtnClick(Sender: TObject);

    procedure ActionListUpdate(Action: TBasicAction; var Handled: Boolean);
    procedure ACNewDEMExecute(Sender: TObject);
    procedure ACRemoveDEMExecute(Sender: TObject);
    procedure StringGridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure CBTypeChange(Sender: TObject);
    procedure ACSaveExecute(Sender: TObject);
    procedure ACOpenExecute(Sender: TObject);
procedure DoTpcfgOpen(Filename:String);
    procedure EDDEMPathChange(Sender: TObject);

    procedure EDDefaultZChange(Sender: TObject);
    procedure ACProcessExecute(Sender: TObject);

    procedure ViewCurrent1Click(Sender: TObject);
    procedure SetCurrent1Click(Sender: TObject);

    procedure DMStoDDBtnClick(Sender: TObject);
    procedure RIHDMStoDDBtnClick(Sender: TObject);
    function packedDMSToDouble(  packedDMS:double ):double;

    procedure DEMtoBinBtnClick(Sender: TObject);
    procedure SavethememoBtnClick(Sender: TObject);
    procedure SDTStoBinBtnClick(Sender: TObject);
    procedure XYZtoBinBtnClick(Sender: TObject);
procedure DoXYZtoBin(FileName:String);
    procedure Projections1Click(Sender: TObject);

    procedure ARCGridtoBinBtnClick(Sender: TObject);
    procedure Dem250kListClick(Sender: TObject);
procedure DoDEMtoBin( InfileName:String; Config:Integer);
    procedure ReaddemProjection1Click(Sender: TObject);
 procedure SetDefaultDEMProj;
    procedure SetdemProjection1Click(Sender: TObject);
{procedure ReadDEMProj(ReadFileName:String);}
{procedure SetDEMProj(SetFileName:String);}
    procedure SaveBinProjastxt1Click(Sender: TObject);
    procedure BTBtnClick(Sender: TObject);
procedure DoBT(Filename:String);
    procedure GlobeBtnClick(Sender: TObject);
    procedure GtopoBtnClick(Sender: TObject);
    procedure Etopo2BtnClick(Sender: TObject);
    procedure EtopoBtnClick(Sender: TObject);
{procedure WriteBinFile(InfileName:String;InType:Byte);}

    procedure SavedisplayedProjectionasprj1Click(Sender: TObject);
    procedure ResettoDefault1Click(Sender: TObject);
    procedure ReadfilenamevrpasProjection1Click(Sender: TObject);
{procedure ReadvrpProj(ReadFileName:String);}
    procedure dem24ktobinBtnClick(Sender: TObject);

    procedure SRTM3toBinBtnClick(Sender: TObject);
    procedure SRTM1toBinBtnClick(Sender: TObject);
procedure DoSRTMtoBin( InfileName:String; Config:Integer);
    procedure ProcessperProjectionDataClick(Sender: TObject);

    procedure CountryFipsCodeCBChange(Sender: TObject);
procedure SetCountryFipsCode(CountryIn,StateIn,CountyIn:Integer);
procedure SetCountryFipsCode2(CountryIn,StateIn,CountyIn:Integer);

    procedure StateFipsCodeCBChange(Sender: TObject);
procedure SetStateFipsCode(CountryIn,StateIn,CountyIn:Integer);
procedure DecipherSetStateFipsCode;
    procedure CountyFipsCodeCBChange(Sender: TObject);
procedure SetCountyFipsCode(CountryIn,StateIn,CountyIn:Integer);

{Read Projection} {-> Version 1 or 2}
{WriteProjection} {-> only latest version}
{Write DEM data} {Skip 256 bytes and write -> Single or SmallInt}
{Write single cell tpcfg}
procedure ReadAnyVersionProj(ReadFileName:String);
procedure ReadVersionProj(ReadFileName:String);
procedure ReadVer1Proj(ReadFileName:String);
procedure ReadBitFile(InfileName:String);
procedure WriteProjectionFile(InfileName:String);
procedure WriteBitFile(InfileName:String);
procedure WriteTpcfgFile(InfileName:String);

    procedure PRConverterClick(Sender: TObject);
procedure DoPRConversion(Path,Row:Integer;
                              var Laty,Lonx:Double);

    procedure MarsBtnClick(Sender: TObject);
    procedure MarsListFilesBtnClick(Sender: TObject);
procedure ConvertMarsTab(InName:String;DoTpcfg:Integer);
procedure ConvertMarsImg(InName:String;DoTpcfg:Integer);
procedure MatrixBmp(InFile:String;Min,Max:Integer);
    procedure SRTM3ListBtnClick(Sender: TObject);
    procedure SRTM1ListBtnClick(Sender: TObject);
    procedure SurferGridtoBinBtnClick(Sender: TObject);
procedure DoSurferGridtoBin(Filename:String);
    procedure Openbit1Click(Sender: TObject);
procedure ReadAlittleBit(Filename:String);
    procedure Openshp1Click(Sender: TObject);
procedure ReadAlittleShp(Filename:String);
procedure DrawShape;
    procedure MoonPCBtnClick(Sender: TObject);
    procedure MarsPCBtnClick(Sender: TObject);
    {RIF FILES}
    procedure Open2Click(Sender: TObject);
procedure DoIpcfgOpen(Filename:String);
    procedure Save2Click(Sender: TObject);
    procedure Process2Click(Sender: TObject);
    procedure AddImageSource1Click(Sender: TObject);
    procedure RemoveImageSource1Click(Sender: TObject);
procedure ReadImageProj(ReadFileName:String);
procedure WriteImageProjectionFile(InfileName:String);
    procedure RifBtnClick(Sender: TObject);
    procedure ImagePathBtnClick(Sender: TObject);
    procedure RifCbFilesChange(Sender: TObject);
    procedure ImagePathEditChange(Sender: TObject);
    procedure DefaultDataEditChange(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure ViewCurrentrifvrp1Click(Sender: TObject);
    procedure SetCurrentrifvrp1Click(Sender: TObject);
  private
    { Private declarations }
    sources : array of TSrc;
    defaultZ : SmallInt;
    isources : array of TISrc;
    DefaultDataZ:Byte;
    procedure Parse;
    procedure Cleanup;
    procedure IParse;
    procedure ICleanup;
{          procedure SrcExtract(src : PSrc; relX, relY, len : Integer; dest : PSmallInt);}
{procedure SrcExtract2(src : PSrc; relX, relY, len : Integer; dest : PSmallInt);}
{          procedure WorldExtract(x, y, len : Integer; dest : PSmallInt);}
{procedure WorldExtract2(x, y, len : Integer; dest : PSmallInt);}

  public
    { Public declarations }
  end;

var
  HtfForm: THtfForm;
  sManMatrix: array of array of Single;

implementation

{$R *.dfm}

uses HeightTileFile,
     dtmRasterImageFile,
     Math,
     DtmShpSaver,
     dtmPOFvar, dtmErrMsg,
     dtmGlobals, dtmIMFrm, dtmfrm;

procedure THtfForm.FormCreate(Sender: TObject);
var
   i : Integer;
begin
  top := HtfFormY;
  left := HtfFormX;
  SetDefaultDEMProj;
  SetLength(sManMatrix,0,0);
  with ActionList do
      for i:=0 to ActionCount-1 do with TAction(Actions[i]) do
         Hint:=Caption;
  with StringGrid do begin
      Cells[0, 0]:='File Name';
      Cells[1, 0]:='World Offset';
      Cells[2, 0]:='Size';
      Cells[3, 0]:='Data type';
      Row:=0;
  end;
  with StringGrid1 do begin
      Cells[0, 0]:='File Name';
      {Cells[1, 0]:='World Offset';
      Cells[2, 0]:='Size'; }
      Cells[1{3}, 0]:='Data type';
      Row:=0;
  end;
end;

procedure THtfForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  HtfFormY := HtfForm.top;
  HtfFormX := HtfForm.left;
  SetLength(sManMatrix,0,0);
end;

procedure THtfForm.FormDestroy(Sender: TObject);
begin
   Cleanup;
   ICleanup;
end;

procedure THtfForm.ACExitExecute(Sender: TObject);
begin
   Close;
end;

procedure THtfForm.Help2Click(Sender: TObject);
begin
  Application.HelpContext(2001);
end;

procedure THtfForm.MIAboutClick(Sender: TObject);
begin
   ShowMessage(Caption+#13#10#13#10
               +'HTF Generation Utility'#13#10
               +'Part of GLScene library.'#13#10
               +'http://glscene.org'#13#10#13#10
               +'DEM, Projection, Utility ...pages'#13#10
               +'Digital Terrain Mapping (DTM)'#13#10
               +'Part of Tachyon Unit: '#13#10
               +'VR GIS     ILH suite.');
end;
(***********************************************************)

(***********************************************************)
procedure THtfForm.BUDEMPathBtnClick(Sender: TObject);
var   TransSearchDir:String;
begin
  If EDDEMPath.Text='' then  TransSearchDir:= DemPath
     else If (not FileExists(EDDEMPath.Text))
          then TransSearchDir:= DemPath
     else  TransSearchDir:=EDDEMPath.Text;
  if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
  begin
    DemPath := TransSearchDir;
    EDDEMPath.Text:=TransSearchDir+'\';
  end {else DoMessages(1)};
end;

procedure THtfForm.HtfPathBtnClick(Sender: TObject);
begin
   If FileExists(EDHTFName.Text) then
   begin
     SDHTF.InitialDir:=ExtractFilePath(EDHTFName.Text);
     SDHTF.FileName:=EDHTFName.Text;
   end
   else
   begin
     SDHTF.InitialDir:=HTFPath;
     SDHTF.FileName:='*.*';
   end;
   if SDHTF.Execute then
   begin
     HTFPath:=ExtractFilePath(SDHTF.FileName);
     EDHTFName.Text:=SDHTF.FileName;
   end;
end;



procedure THtfForm.ActionListUpdate(Action: TBasicAction;
  var Handled: Boolean);
begin
   ACRemoveDEM.Enabled:=(StringGrid.RowCount>2);
   RemoveImageSource1.Enabled:=(StringGrid1.RowCount>2);
end;

procedure THtfForm.ACNewDEMExecute(Sender: TObject);
begin
   StringGrid.RowCount:=StringGrid.RowCount+1;
end;

procedure THtfForm.ACRemoveDEMExecute(Sender: TObject);
var
   i : Integer;
begin
   with StringGrid do begin
      i:=Row;
      if i<RowCount-1 then begin
         while i<RowCount-1 do begin
            Rows[i]:=Rows[i+1];
            Inc(i);
         end;
      end else Row:=i-1;
      RowCount:=RowCount-1;
   end;
end;

procedure THtfForm.StringGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);

   procedure SetCB(const cb : TComboBox);
   var
      r : TRect;
      i : Integer;
   begin
      r:=StringGrid.CellRect(ACol, ARow);
      cb.Left:=r.Left+StringGrid.Left;
      cb.Top:=r.Top+StringGrid.Top;
      cb.Width:=r.Right+1-r.Left;
      i:=cb.Items.IndexOf(StringGrid.Cells[ACol, ARow]);
      if i>=0 then
         cb.ItemIndex:=i
      else cb.Text:=StringGrid.Cells[ACol, ARow];
      if Visible then
         cb.SetFocus;
   end;

begin
   if ARow>0 then begin
      if ACol=0 then begin
         CBFile.Visible:=True;
         SetCB(CBFile);
      end else CBFile.Visible:=False;
      if ACol=3 then begin
         CBType.Visible:=True;
         SetCB(CBType);
      end else CBType.Visible:=False;
      CanSelect:=True;
   end;
end;

procedure THtfForm.CBTypeChange(Sender: TObject);
begin
   with StringGrid do
      Cells[Col, Row]:=(Sender as TComboBox).Text;
end;

procedure THtfForm.ACSaveExecute(Sender: TObject);
var
   i : Integer;
   sl, sg : TStringList;
begin
  SDTerrainPack.Filter:= 'TerrainPack Configuration (*.tpcfg)|*.tpcfg|All files (*.*)|*.*';
  SDTerrainPack.Filename:=ProgramPath+ChangeFileExt(ExtractFileName(EDHTFName.Text),'.tpcfg');
  SDTerrainPack.InitialDir:=ProgramPath;
  if SDTerrainPack.Execute then
  begin
      sl:=TStringList.Create;
      with sl do begin
         Values['HTFName']:=EDHTFName.Text;
         Values['WorldSizeX']:=EDSizeX.Text;
         Values['WorldSizeY']:=EDSizeY.Text;
         Values['TileSize']:=EDTileSize.Text;
         Values['DefaultZ']:=EDDefaultZ.Text;
         Values['DEMPath']:=EDDEMPath.Text;
         sg:=TStringList.Create;
         for i:=1 to StringGrid.RowCount-1 do
            sg.Add(StringGrid.Rows[i].CommaText);
         Values['DEMs']:=sg.CommaText;
         sg.Free;
      end;
      sl.SaveToFile(SDTerrainPack.FileName);
      sl.Free;
   end;
end;

procedure THtfForm.ACOpenExecute(Sender: TObject);
begin
  ODTerrainPack.Filter:= 'TerrainPack Configuration (*.tpcfg)|*.tpcfg|All files (*.*)|*.*';
  ODTerrainPack.InitialDir:=ProgramPath;
  ODTerrainPack.Filename:='*.tpcfg';
   if ODTerrainPack.Execute then
      DoTpcfgOpen(ODTerrainPack.FileName);
end;
procedure THtfForm.DoTpcfgOpen(Filename:String);
var
   i : Integer;
   sl, sg : TStringList;
begin
      sl:=TStringList.Create;
      sl.LoadFromFile(FileName);
      with sl do begin
         EDHTFName.Text:=Values['HTFName'];
         EDSizeX.Text:=Values['WorldSizeX'];
         EDSizeY.Text:=Values['WorldSizeY'];
         EDTileSize.Text:=Values['TileSize'];
         EDDefaultZ.Text:=Values['DefaultZ'];
         EDDEMPath.Text:=Values['DEMPath'];
         sg:=TStringList.Create;
         sg.CommaText:=Values['DEMs'];
         StringGrid.RowCount:=sg.Count+1;
         for i:=0 to sg.Count-1 do
            StringGrid.Rows[i+1].CommaText:=sg[i];
         sg.Free;
      end;
      sl.Free;
      SDTerrainPack.FileName:=FileName;
end;

procedure THtfForm.EDDEMPathChange(Sender: TObject);
var
   f : TSearchRec;
   r : Integer;
   PathString:String;
begin
   CBFile.Items.Clear;
      PathString:= EDDEMPath.Text;
      If (PathString[Length(PathString)]<>'\')
      then PathString:=PathString+'\';
      EDDEMPath.Text:=PathString;
   r:=FindFirst(EDDEMPath.Text+'*.*', faAnyFile, f);
   while r=0 do begin
      if (f.Attr and faDirectory)=0 then
         CBFile.Items.Add(f.Name);
      r:=FindNext(f);
   end;
   FindClose(f);
end;

procedure THtfForm.EDDefaultZChange(Sender: TObject);
begin
   defaultZ:=StrToIntDef(EDDefaultZ.Text, 0);
end;

procedure THtfForm.Parse;
var
   i, p : Integer;
   PathString:String;
   row : TStrings;
begin
   Cleanup;
   SetLength(sources, StringGrid.RowCount-1);
   for i:=0 to High(sources) do begin
      row:=StringGrid.Rows[i+1];
      PathString:= EDDEMPath.Text;
      If (PathString[Length(PathString)]<>'\')
      then PathString:=PathString+'\';
      EDDEMPath.Text:=PathString;
      sources[i].fs:=TFileStream.Create(PathString+row[0], fmOpenRead+fmShareDenyNone);
      p:=Pos(',', row[1]);
      sources[i].x:=StrToInt(Copy(row[1], 1, p-1));
      sources[i].y:=StrToInt(Copy(row[1], p+1, MaxInt));
      p:=Pos('x', row[2]);
      sources[i].w:=StrToInt(Copy(row[2], 1, p-1));
      sources[i].h:=StrToInt(Copy(row[2], p+1, MaxInt));
      if Pos('non-', row[3])>0 then
         sources[i].format:=1
      else if Pos('BT', row[3])>0 then
         sources[i].format:=2
      else if Pos('32', row[3])>0 then
         sources[i].format:=3
      else if Pos('bit', row[3])>0 then
         sources[i].format:=4
      else sources[i].format:=0;
   end;
end;
{16 bits (Intel)
16 bits (non-Intel)
VTP BT (single)
bit 32 (single)
bit 16 (Intel)}
procedure THtfForm.Cleanup;
var
   i : Integer;
begin
   for i:=0 to High(sources) do
      sources[i].fs.Free;
   SetLength(sources, 0);
end;



procedure THtfForm.ACProcessExecute(Sender: TObject);
var
   x, y, wx, wy, ts, tx, ty, i : Integer;
   n, maxN : Cardinal;
   htf : THeightTileFile;
   buf : array of SmallInt;
   f : file of Byte;
procedure {TMainForm.}WorldExtract(x, y, len : Integer; dest : PSmallInt);
var
   i, n, rx, ry : Integer;
   src : PSrc;
procedure {TMainForm.}SrcExtract(src : PSrc; relX, relY, len : Integer; dest : PSmallInt);
var
   i : Integer;
   wd : Word;
   buf : array of Single;
begin
   with src^ do begin
      case format of
         0 : begin // 16bits Intel
            fs.Position:=(relX+relY*w)*2;
            fs.Read(dest^, len*2);
         end;
         1 : begin // 16bits non-Intel
            fs.Position:=(relX+relY*w)*2;
            fs.Read(dest^, len*2);
            for i:=0 to len-1 do begin
               wd:=PWord(Integer(dest)+i*2)^;
               PWord(Integer(dest)+i*2)^:=((wd and 255) shl 8)+(wd shr 8);
            end;
         end;
         2 : begin // VTP's BT single    256 is header
            fs.Position:=(relX+relY*w)*4+256;
            SetLength(buf, len);
            fs.Read(buf[0], len*4);
            for i:=0 to len-1 do
               PSmallInt(Integer(dest)+i*2)^:=Round(buf[i]);
         end;
         3 : begin //bit  single    256 is header
            fs.Position:=(relX+relY*w)*4+256;
            SetLength(buf, len);
            fs.Read(buf[0], len*4);
            for i:=0 to len-1 do
               PSmallInt(Integer(dest)+i*2)^:=Round(buf[i]);
         end;
         4 : begin //bit  16bits Intel  256 is header
            fs.Position:=(relX+relY*w)*2+256;
            fs.Read(dest^, len*2);
         end;
      end;
   end;
end;

begin
   while len>0 do begin
      src:=nil;
      for i:=0 to High(sources) do begin
         if (sources[i].x<=x) and (sources[i].y<=y)
               and (x<sources[i].x+sources[i].w)
               and (y<sources[i].y+sources[i].h) then begin
            src:=@sources[i];
            Break;
         end;
      end;
      if Assigned(src) then begin
         rx:=x-src.x;
         ry:=y-src.y;
         n:=len;
         if rx+n>src.w then
            n:=src.w-rx;
         SrcExtract(src, rx, ry, n, dest);
         Dec(len, n);
         Inc(dest, n);
         Inc(x, n);
      end else begin
         dest^:=defaultZ;
         Inc(dest);
         Dec(len);
         Inc(x);
      end;
   end;
end;

begin
If DirectoryExists(ExtractFilePath(EDHTFName.Text)) then
begin
  Screen.Cursor:=crHourGlass;
  wx:=StrToInt(EDSizeX.Text);
  wy:=StrToInt(EDSizeY.Text);
  ts:=StrToInt(EDTileSize.Text);
  Parse;
  SetLength(buf, ts*ts);
  htf:=THeightTileFile.CreateNew(EDHTFName.Text, wx, wy, ts);
  htf.DefaultZ:=StrToInt(EDDefaultZ.Text);{defaultZ;}
  ProgressBar.Max:=1000;
  maxN:=Ceil(wx/ts)*Ceil(wy/ts);
  n:=0;
  ProgressBar.Visible:=True;
  ProgressBar.Position:=0;
  y:=0; while y<wy do
  begin
    ty:=wy-y;
    if ty>ts then ty:=ts;
    x:=0; while x<wx do
    begin
      tx:=wx-x;
      if tx>ts then tx:=ts;
      Inc(n);
      ProgressBar.Position:=(n*1000) div maxN;
      for i:=0 to ty-1 do
          WorldExtract(x, y+i, tx, @buf[i*tx]);
      htf.CompressTile(x, y, tx, ty, @buf[0]);
      Inc(x, ts);
      if (n and 15)=0 then
      begin
        Application.ProcessMessages;
      end;
    end;
    Inc(y, ts);
  end;
  htf.Free;
  Cleanup;
  Screen.Cursor:=crDefault;

  AssignFile(f, EDHTFName.Text);
  Reset(f);
  i:=FileSize(f);
  CloseFile(f);
  ProgressBar.Position:=0;
  ShowMessage( 'HTF file created.'#13#10#13#10
               +IntToStr(i)+' bytes in file'#13#10
               +'('+IntToStr(wx*wy*2)+' raw bytes)');
end;
end;
(***********************************************************)

(***********************************************************)

(***********************************************************)
procedure THtfForm.Projections1Click(Sender: TObject);
begin
  {If HTF loaded then enable}
  If isHTFLoaded then
  begin
    ViewCurrent1.Enabled:=True;
    SetCurrent1.Enabled:=True;
  end else
  begin
    ViewCurrent1.Enabled:=False;
    SetCurrent1.Enabled:=False;
  end;
end;

{Just check if there is a .vrp file for current htf file}
procedure THtfForm.ViewCurrent1Click(Sender: TObject);
begin
  If FileExists(ChangeFileExt(HTFName,'.vrp')) then
  ReadAnyVersionProj(ChangeFileExt(HTFName,'.vrp'));
end;

procedure THtfForm.SetCurrent1Click(Sender: TObject);
begin
  WriteProjectionFile(ChangeFileExt(HTFName,'.vrp'));
end;
(***********************************************************)

(***********************************************************)

(***********************************************************)
procedure THtfForm.RIHDMStoDDBtnClick(Sender: TObject);
var Code, Degree, Minute: Integer;
  Second:Double;
  TempDe, TempMe, TempSe, DDe: Extended;
  DMSstring, PosNeg, DDstring: string;
begin
  {Get RIHDMStoDDEdit.text and convert to Decimal Degrees
      S06 56 30  W177 25 59 }
  DMSstring := uppercase(RIHDMStoDDEdit.text);
  if ((DMSstring[1] = 'S') or (DMSstring[1] = 'W')) then
    PosNeg := '-' else PosNeg := '';
  if ((DMSstring[1] = 'S') or (DMSstring[1] = 'N')) then
  begin
    DDstring := copy(DMSstring, 2, 2);
    val(DDstring, Degree, Code);
    TempDe := Degree;
    DDstring := copy(DMSstring, 5, 2);
    val(DDstring, Minute, Code);
    TempMe := (Minute / 60);
    DDstring := copy(DMSstring, 8, {2}Length(DMSstring));
    val(DDstring, Second, Code);
    TempSe := (Second / 360);
    DDe := (TempDe + TempMe + TempSe);
    RIHDMStoDDEdit.text := FloattoStr(DDe);
  end else
  if ((DMSstring[1] = 'E') or (DMSstring[1] = 'W')) then
  begin
    {W or E} copy(DMSstring, 2, 3);
      val(DDstring, Degree, Code);
      TempDe := Degree;
      DDstring := copy(DMSstring, 6, 2);
      val(DDstring, Minute, Code);
      TempMe := (Minute / 60);
      DDstring := copy(DMSstring, 9, {2}Length(DMSstring));
      val(DDstring, Second, Code);
      TempSe := (Second / 360);
      DDe := (TempDe + TempMe + TempSe);
      RIHDMStoDDEdit.text := FloattoStr(DDe);
  end;
end;

procedure THtfForm.DMStoDDBtnClick(Sender: TObject);
begin
  {packedDMSToDouble(  packedDMS:double ):double;
   Value: Extended;
   Format: TFloatFormat;
   Precision, Digits:}
  DMStoDDEdit.Text:=FloatToStrF(
       packedDMSToDouble(StrtoFloat(DMStoDDEdit.Text)),ffFixed,15,3);
end;

function THtfForm.packedDMSToDouble(  packedDMS:double ):double;
var  min,deg,sign:Double;
Begin
  sign := 1.0;
  if ( packedDMS < 0.0 )then
  begin
    sign := -1.0;
    packedDMS := -packedDMS;
  end;
  deg := packedDMS / 1000000;
  packedDMS := packedDMS-(deg * 1000000);
  min := packedDMS / 1000;
  packedDMS := packedDMS-(min * 1000);
  result := deg;
  result := result+(min / 60.0);
  result := result+(packedDMS / 3600.0);
  result := result*sign;
End;


(***********************************************************)

(***********************************************************)
procedure THtfForm.SavedisplayedProjectionasprj1Click(Sender: TObject);
begin
  SDTerrainPack.Filter:= 'Projection File for ?(*.*)|*.*';
  SDTerrainPack.Filename:='*.*';
  SDTerrainPack.InitialDir:=ShapePath;
  if SDTerrainPack.Execute then
  begin
    if length(SDTerrainPack.filename) = 0 then Exit;
                 {Exits from the current procedure.}
    begin
      WriteProjectionFile(ChangeFileExt(SDTerrainPack.Filename,'.vrp'));
    end;
  end;
end;

procedure THtfForm.SDTStoBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= '24K SDTS DEM files (*.ddf)|*.ddf';
  if ODTerrainPack.Execute then
  begin
   {Call SDTS24KLoader}
  end;
end;

procedure THtfForm.dem24ktobinBtnClick(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'DEM files (*.dem)|*.dem';
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.DEM' then
    begin
      DemPath:= ExtractFilePath(ODTerrainPack.FileName);
{      DoDEMtoBin(ODTerrainPack.FileName,0);   }
    end;
  end;
end;

procedure THtfForm.DEMtoBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'DEM files (*.dem)|*.dem';
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.DEM' then
    begin
      SetDefaultDEMProj;
      DemPath:= ExtractFilePath(ODTerrainPack.FileName);
      DoDEMtoBin(ODTerrainPack.FileName,0);
    end;
  end;
end;

procedure THtfForm.Dem250kListClick(Sender: TObject);
var
  MaxX,MaxY,
 CountIn,CountAll:Integer;
 S : string;
 F: TextFile;
begin
  MaxX:=0;MaxY:=0;
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'DEM files list (*.txt)|*.txt';
  ODTerrainPack.Filename:= 'graflist.txt';
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.TXT' then
    begin
      SetDefaultDEMProj;
      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      CountIn:=0;
      CountAll:=0;
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountIn);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       end;

      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountAll);
        ReadWriteLabel.Caption:='Reading: ';
        ColonLabel.Caption:=' '+Inttostr(CountAll)+' of '+Inttostr(CountIn)+' : ';
        If FileExists(S) then
           DoDEMtoBin(S,1);
        If MaxX< FileSizeX then MaxX:= FileSizeX;
        SkipHeaderSizeEdit.Text:=Inttostr(MaxX);
        If MaxY< FileSizeY then MaxY:=  FileSizeY;
        SkipHeaderSizeEdit2.Text:=Inttostr(MaxY);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       ColonLabel.Caption:=' : ';
       end;
    end;
  end;
end;


procedure THtfForm.DoDEMtoBin( InfileName:String; Config:Integer);
var
  WhoAmI:Byte;
  cWhoAmI:Char;
  DoStateLatLongThing,
  bZisInteger,          {Elevations can be Smallints or Floats}
  bGetReadyToRowmble:Boolean;          {# of Rows unknown}
  iSinData:SmallInt;                  {smallint Datum}
  ProjData:SmallInt;{:Integer;}
  SEXEW, SEYNS,
  txin, tyin, typein,
  I,i2,
  iOverhead,                         {too many rows}
  iRowIDX,             {Check for processing error XRow of Columns}
  iRealColY, iMaxRealColY,     {Each Columns #of row can be different}
  tx, ty,ty1,ty2, Counted, Counter, NumRead: Integer;
  sSinData:Single	;
  dFirstX ,dFirstY, {First Point in a Column of data: not bottom or top}
  dCellSizeZ,                          {Z Resolution}
  dSinData,                          {float Datum}
  dLocalDatum,                       {Added to each datum}
  dMinCheck,dMaxCheck, {Column Elev checks for u r right}
  dAnyMaximumElevation, dAnyMinimumElevation, {running errors: Read}
  {Should be this:First full file Min Max}
  dMaximumElevation, dMinimumElevation,
  SWe,SWn,NWe,NWn,NEe,NEn,SEe,SEn:Double;     {Corners}
  Buf: array[1..1024] of Char;
  WhereString,
  TempS,MyFilesS: string;
  infile,outfile:file;
   {Store data till resorted:
    If integers then use iSinData:= round(dManMatrix[x,y]) em to file
    If Floats then use sSinData:= dManMatrix[x,y] to file}
  dManMatrix: array of array of Double;
begin
  Begin
  Try
      ReadWriteLabel.Caption:='Reading: ';
      DemName.Caption:=ExtractFileName(InfileName);
      Screen.Cursor:=crHourGlass;
      ProgressBar.Position:=0;
      bZisInteger :=True;
      bGetReadyToRowmble:=False;
      DEMtoBinMemo.Clear; { File selected in dialog box }
      CountryFipsCodeCB.ItemIndex:=241;{USA}
      CountryNameEdit.Text:='USA';
      CountryFipsCodeEdit.Text:='241';
      CountyFipsCodeCB.ItemIndex:=0;{unknown}
      CountyNameEdit.Text:='unk';
      CountyFipsCodeEdit.Text:='0';

      DemPath:=ExtractFilePath(InfileName);
      AssignFile(infile, InfileName);
      Reset(infile,1);
      BlockRead(infile, Buf, SizeOf(Buf), NumRead);
      {struct DemHeader_TMPL}
      Counted:= 1; Counter:=40;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('filename[40]'+MyFilesS);
      If ((Pos(',',MyFilesS) < 34)
      and (Pos(',',MyFilesS) >0)
      and (Pos('SW',MyFilesS) >34)) then
      begin  {AFOGNAK - W, AK}
        DoStateLatLongThing:=True;
        WhereString:=Copy(MyFilesS, Pos(',',MyFilesS)+1, length(MyFilesS));
        WhereString:=trim(WhereString);
        StateNameEdit.Text:=Copy(WhereString, Pos(',',WhereString)+1, 2);
      DEMtoBinMemo.LineS.Append(
        {Showmessage(}'DoStateLatLongThing]'+StateNameEdit.Text+'[');
      end else
      begin
        If ((Pos(',',MyFilesS) < 34)
        and (Pos(',',MyFilesS) >0))then
        begin
          WhereString:=Copy(MyFilesS, Pos(',',MyFilesS)+1, length(MyFilesS));
          WhereString:=trim(WhereString);
          StateNameEdit.Text:=Copy(WhereString, Pos(',',WhereString)+1, 2);
        end else
        {1..33     Name ADAK - NE}
        {34..48 State AK}
          StateNameEdit.Text:=Copy(MyFilesS, 34, 2);
        DoStateLatLongThing:=False;
      end;

      DecipherSetStateFipsCode;
      Counted:= Counted+Counter; Counter:=40;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('freetext[40];'+MyFilesS);
      {49..56 ID  NN01-11E}
      If DoStateLatLongThing then
      begin     {SW N58 W154}  {SEXEW SEYNS  DoStateLatLongThing}
        WhereString:=Trim(MyFilesS);
        SEXEW:=StrToInt(Copy(WhereString, 9, 3));
        If (WhereString[2] = 'W') then SEXEW:=SEXEW-1;
        If (WhereString[8] = 'W') then SEXEW:=SEXEW*-1;
        SEYNS:=StrToInt(Copy(WhereString, 5, 2));
        If (WhereString[4] = 'S') then SEYNS:=SEYNS*-1;
        WhereString:='Unknown';
        CellLocatorEdit.Text:=WhereString;{Duplicated later}
      end else
      begin
        WhereString:=Trim(MyFilesS);
        CellLocatorEdit.Text:=WhereString;{Duplicated later}
      end;
      Counted:= Counted+Counter; Counter:=29;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('fill01[29];'+MyFilesS);
      {SE is locational for a DEM name ... NEVER THERE???!?
      some Alaska dems have a xxx yy zz.zzzz format}
      Counted:= Counted+Counter; Counter:=13;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('SE X[13];'+MyFilesS);
      trim(MyFilesS);
      If Length(MyFilesS)<2 then MyFilesS:='0';
      For I:= 1 to Length(MyFilesS) do
          If MyFilesS[i]=' ' then MyFilesS[i]:='0';
      SEXEWEdit.Text:=Inttostr(Round(strtofloat(MyFilesS)));

      Counted:= Counted+Counter; Counter:=13;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('SE Y[13];'+MyFilesS);
      trim(MyFilesS);
      If Length(MyFilesS)<2 then MyFilesS:='0';
      For I:= 1 to Length(MyFilesS) do
          If MyFilesS[i]=' ' then MyFilesS[i]:='0';
      SEYNSEdit.Text:=Inttostr(Round(strtofloat(MyFilesS)));

      If DoStateLatLongThing then
      begin {redo for corrections}
        SEXEWEdit.Text:=IntToStr(SEXEW);
        SEYNSEdit.Text:=IntToStr(SEYNS);
      end;
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('process;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('fill02;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=3;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('sectind[3];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=4;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('origin[4];'+MyFilesS);
{}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('level[6];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('pattern[6];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter); Trim(MyFilesS);
      DEMtoBinMemo.LineS.Append('refcode[6];'+MyFilesS);
      ProjectionCB.ItemIndex:=StrToInt(MyFilesS);
{ProjectionCB}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
      DEMtoBinMemo.LineS.Append('zone[6];'+MyFilesS);
      InUtmZoneCB.ItemIndex:=StrToInt(MyFilesS);
      StatePlaneZoneEdit.Text:=IntToStr(StrToInt(MyFilesS));
{InUtmZoneCB}{UTMZoneNorthCB.Checked  ??}
      Counted:= Counted+Counter; Counter:=360;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('mapprojparams[360];'+MyFilesS);
      tx:=1;      ty:=24;
      DLGPA1.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPA2.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPA3.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPB1.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPB2.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPB3.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPC1.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPC2.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPC3.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPD1.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPD2.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPD3.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPE1.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPE2.Text:=Trim(Copy(MyFilesS, tx, ty));
      tx:= tx+ty;
      DLGPE3.Text:=Trim(Copy(MyFilesS, tx, ty));
{15 Doubles}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
      DEMtoBinMemo.LineS.Append('groundunits[6];'+MyFilesS);
      InUnitCB.ItemIndex:=StrToInt(MyFilesS);
{InUnitCB}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
      DEMtoBinMemo.LineS.Append('elevationunits[6];'+MyFilesS);
      MapZUnitsCB.ItemIndex:=StrToInt(MyFilesS);
{MapZUnitsCB}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('sides[6];'+MyFilesS);
{? always 4 sides}
      Counted:= Counted+Counter; Counter:=192;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('coords[192];'+MyFilesS);
      tx:=1;      ty:=24;
       SWe:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       SWn:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       BottomLeftXEdit.Text:= FloattostrF(SWe,ffFixed,15,15);
       BottomLeftYEdit.Text:= FloattostrF(SWn,ffFixed,15,15);
       NWe:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       NWn:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       TopLeftXEdit.Text:= FloattostrF(NWe,ffFixed,15,15);
       TopLeftYEdit.Text:= FloattostrF(NWn,ffFixed,15,15);
       NEe:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       NEn:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       TopRightXEdit.Text:= FloattostrF(NEe,ffFixed,15,15);
       TopRightYEdit.Text:= FloattostrF(NEn,ffFixed,15,15);
       SEe:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       SEn:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
       BottomRightXEdit.Text:= FloattostrF(SEe,ffFixed,15,15);
       BottomRightYEdit.Text:= FloattostrF(SEn,ffFixed,15,15);

       If (SWn < SEn) then DemiBottomY2e:=SWn else DemiBottomY2e:=SEn;
       If (NWn > NEn) then DemiTopY1e:=NWn else DemiTopY1e:=NEn;
       If (NWe < SWe) then DemiLeftX1e:=NWe else DemiLeftX1e:=SWe;
       If (NEe > SEe) then DemiRightX2e:=NEe else DemiRightX2e:=SEe;

{Gather then ReOrder}
{SWe,SWn,NWe,NWn,NEe,NEn,SEe,SEn
  dXTemp, dYTemp, dXMIN, dYMIN, dXMAX, dYMAX
  DemiBottomY2e, DemiRightX2e,
  DemiTopY1e, DemiLeftX1e}
{NullDemValue
      FileSizeX
FileSizeY    : Integer;
  CellSizeX,CellSizeY,
  DemiBottomY2e, DemiRightX2e,
  DemiTopY1e, DemiLeftX1e:Double;}
      Counted:= Counted+Counter; Counter:=48;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('elevs[48];'+MyFilesS);
      tx:=1;      ty:=24;
       dMinimumElevation:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
      tx:= tx+ty;
       dMaximumElevation:=StrtoFloat(Trim(Copy(MyFilesS, tx, ty)));
{?  dMaximumElevation, dMinimumElevation}
      Counted:= Counted+Counter; Counter:=24;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('angle[24];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('accuracycode[6];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=12;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('spatialresx[12];'+MyFilesS);
      CellSizeX:=StrToFloat(MyFilesS);
      {CellSizeX:=CellSizeX/60;}
      PixelXSizeEdit.Text:=FloattostrF(CellSizeX,ffFixed,15,15);
      {MyFilesS;}
{CellSizeX}
      Counted:= Counted+Counter; Counter:=12;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('spatialresy[12];'+MyFilesS);
      CellSizeY:=StrToFloat(MyFilesS);
      {CellSizeY:=CellSizeY/60;}
      PixelYSizeEdit.Text:=FloattostrF(CellSizeY,ffFixed,15,15);
      {MyFilesS;}
{CellSizeY}
      Counted:= Counted+Counter; Counter:=12;
      MyFilesS:=Copy(Buf, Counted, Counter);
      For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]='D' then MyFilesS[I]:='E';
      DEMtoBinMemo.LineS.Append('spatialresz[12];'+MyFilesS);
      dCellSizeZ:=StrToFloat(MyFilesS);
      ZSizeEdit.Text:= FloattostrF(dCellSizeZ,ffFixed,15,15);
      {MyFilesS;}
      If (dCellSizeZ < 0) then bZisInteger :=False;
{CellSizeZ  ??}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('rows[6];'+MyFilesS);
      FileSizeY:=StrToInt(MyFilesS);
      EDSizeY.Text:=IntToStr(FileSizeY);
      YHeightEdit.Text:=IntToStr(FileSizeY);
{FileSizeY  1 or Real amount... duplicated below}
      Counted:= Counted+Counter; Counter:=6;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('cols[6];'+MyFilesS);
      FileSizeX:=StrToInt(MyFilesS);
      EDSizeX.Text:=IntToStr(FileSizeX);
      XWidthEdit.Text:=IntToStr(FileSizeX);
{FileSizeX  Real #  cols=across=X}
{SOME files only have SPaces for the rest of the header}
      Counted:= Counted+Counter; Counter:=5;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('maxcontour[5];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('maxcontourunits;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=5;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('mincontour[5];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('char mincontourunits;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=4;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('sourcedate[4];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=4;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('inspectiondate[4];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('revflag;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=1;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('valflag;'+MyFilesS);
      Counted:= Counted+Counter; Counter:=2;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('suspectflag[2];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=2;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('vertdatum[2];'+MyFilesS);
{?}
      Counted:= Counted+Counter; Counter:=2;
      MyFilesS:=Copy(Buf, Counted, Counter);
      Trim(MyFilesS);
            For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]=' ' then MyFilesS[I]:='0';
      DEMtoBinMemo.LineS.Append('horzdatum[2];'+MyFilesS);
      If Length(MyFilesS)>1 then
      begin
      I:=StrToInt(MyFilesS);
      If I>0 then
      begin  {InDatumCB  IS NOT 0!}
      case I of
      1: InDatumCB.ItemIndex:=13 {Nad27};
      2: InDatumCB.ItemIndex:=22 {WGS72};
      3: InDatumCB.ItemIndex:=23 {WGS 84};
      4: InDatumCB.ItemIndex:=14 {NAD83};
      5: InDatumCB.ItemIndex:=15 {Old Hawaii};
      6: InDatumCB.ItemIndex:=18 {Puerto Rico};
      else InDatumCB.ItemIndex:=13;
      end;{Case}
      end else InDatumCB.ItemIndex:=13;
      end else InDatumCB.ItemIndex:=13; {DEM 1* = Nad27}
      Counted:= Counted+Counter; Counter:=4;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('dataedition[4];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=4;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('percentvoid[4];'+MyFilesS);
      Counted:= Counted+Counter; Counter:=124;
      MyFilesS:=Copy(Buf, Counted, Counter);
      DEMtoBinMemo.LineS.Append('fill03[124];'+MyFilesS);
{Process DATA per Profile}
      dAnyMaximumElevation:= dMinimumElevation;
      dAnyMinimumElevation:= dMaximumElevation;
      If FileSizeY = 1 then bGetReadyToRowmble:=True
         else SetLength(dManMatrix,FileSizeX+1,FileSizeY+1);

      For tx:=0 to FileSizeX-1 do
      begin
        ProgressBar.Position:=  Round((tx / FileSizeX)*100);
        Application.ProcessMessages;
        BlockRead(infile, Buf, SizeOf(Buf), NumRead);
      For I:=1 to Length(Buf) Do
         If Buf[I]='D' then Buf[I]:='E';
        {Read the line hdr}
        Counted:= 1; Counter:=6;{Skip it}
        Counted:= Counted+Counter; Counter:=6;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
               For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]=' ' then MyFilesS[I]:='0';
        iRowIDX:=StrToInt(MyFilesS);
        If iRowIDX <> (tx+1) then  DoMessages(25009);
            {25009, "Column Line Dem error"}
        Counted:= Counted+Counter; Counter:=6;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
               For I:=1 to Length(MyFilesS) Do
         If MyFilesS[I]=' ' then MyFilesS[I]:='0';
         { iMaxRealColY is the REAL number of Y values in this line}
        iMaxRealColY:=StrToInt(MyFilesS);
        Counted:= Counted+6; {ignore second Integer}
        {Read the Actual location of the first Point:
         how high up the Y is the first data point ?}
        Counted:= Counted+Counter; Counter:=24;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
        dFirstX:=StrToFloat(MyFilesS);
        Counted:= Counted+Counter; Counter:=24;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
        dFirstY:=StrToFloat(MyFilesS);
        If tx=0 then
        begin
        If (dFirstY <> SWn {NWn}) then DoMessages(25010);
        {25010, "Column Vertical lost Y error"}
        If (dFirstX <> SWe {NWn}) then DoMessages(25011);
        end;
        Counted:= Counted+Counter; Counter:=24;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
        dLocalDatum:=StrToFloat(MyFilesS);
        Counted:= Counted+Counter; Counter:=24;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
        dMinCheck:=StrToFloat(MyFilesS);
        Counted:= Counted+Counter; Counter:=24;
        MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
        dMaxCheck:=StrToFloat(MyFilesS);
        If (FileSizeY <> iMaxRealColY) then  Panel2.Color:=clYellow;

        If bGetReadyToRowmble=True then
        begin
          If (FileSizeY < iMaxRealColY) then FileSizeY:=iMaxRealColY;
          SetLength(dManMatrix,FileSizeX+1,FileSizeY+1);
        end;
        If (iMaxRealColY > 146) then
        begin
          iOverhead:= 146;
          For ty1:=0 to ((iOverhead-1)) do
          begin
            {Label13.Caption:=Inttostr(tx)+' : '+Inttostr(ty1);
             Application.ProcessMessages;}
            {Read each datum }
            Counted:= Counted+Counter; Counter:=6;
            MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
            dSinData:=Strtoint(MyFilesS);
            dSinData:=((dCellSizeZ*dSinData)+dLocalDatum  );
            dManMatrix[tx,ty1]:=dSinData;
            If dSinData>dAnyMaximumElevation
               then dAnyMaximumElevation:=dSinData
            else If dSinData<dAnyMinimumElevation
               then dAnyMinimumElevation:=dSinData;
            If ((dSinData>dMaxCheck) or (dSinData<dMinCheck))then
                DoMessages(25008);
          end;
        {Read another line as this has too many for 1}
        i2:=169;
        For ty2:= iOverhead to ((iMaxRealColY)-1) do
        begin
          inc(i2);
          If i2=170 then
          begin
            i2:=0;
            BlockRead(infile, Buf, SizeOf(Buf), NumRead);
            Counted:=0;  Counter:=1;
          end;
          {Label13.Caption:=Inttostr(tx)+' : '+Inttostr(ty2);
            Application.ProcessMessages;}
          {Read each datum }
          Counted:= Counted+Counter; Counter:=6;
          MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
          dSinData:=Strtoint(MyFilesS);
          dSinData:=((dCellSizeZ*dSinData)+dLocalDatum  );
          dManMatrix[tx,(ty2)]:=dSinData;
          If dSinData>dAnyMaximumElevation
             then dAnyMaximumElevation:=dSinData
          else If dSinData<dAnyMinimumElevation
             then dAnyMinimumElevation:=dSinData;
          If ((dSinData>dMaxCheck) or (dSinData<dMinCheck))then
             DoMessages(25008);
           {DEMtoBinMemo.LineS.Append(Inttostr(ty2)
           +': '+Floattostr(dSinData)+' : '+Floattostr(dMinCheck));}
        end;
        end else
        For ty2:=0 to ((iMaxRealColY-1)) do
        begin
          {Read each datum }
          Counted:= Counted+Counter; Counter:=6;
          MyFilesS:=Copy(Buf, Counted, Counter);Trim(MyFilesS);
          dSinData:=Strtoint(MyFilesS);
          dSinData:=((dCellSizeZ*dSinData)+dLocalDatum  );
          dManMatrix[tx,ty2]:=dSinData;
          If dSinData>dAnyMaximumElevation
             then dAnyMaximumElevation:=dSinData
          else If dSinData<dAnyMinimumElevation
             then dAnyMinimumElevation:=dSinData;
          If ((dSinData>dMaxCheck) or (dSinData<dMinCheck))then
             DoMessages(25008);
        end;

      end;{next x}
      If ((dAnyMaximumElevation >dMaximumElevation)or
          (dAnyMinimumElevation < dMinimumElevation )) then
          begin
          Panel2.Color:=clRed;
          DEMtoBinMemo.LineS.Append('Min Max Total Dem error');
          {DoMessages(30007);}
          end;

        Application.ProcessMessages;
{showmessage('here');}
      ReadWriteLabel.Caption:='Writing: ';
      DemName.Caption:=ExtractFileName(ChangeFileExt(InfileName,'.bit'));
      {Read it and switch it}
      {OOps Need an array to keep the number of values per X Column for 24k dems}
      Application.ProcessMessages;
      AssignFile(outfile, ChangeFileExt(InfileName,'.bit'));
      Rewrite(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      WhoAmI :=3;{ 30AS=250k DEM}
SourceCB.Itemindex:=3;      
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
      WhoAmI :=2;{  Version = 2}
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
        {Compute from Lower Right Coordinate.. someday}
      ProjData:= StrToInt(SEXEWEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      ProjData:= StrToInt(SEYNSEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      txin:=FileSizeX; {1201;}{250k DEM Width}
      Blockwrite(outfile,txin , Sizeof(txin), NumRead);
      XWidthEdit.Text:=IntToStr(FileSizeX);{Rewrite as Size matters}
      YHeightEdit.Text:=IntToStr(FileSizeY);
      tyin:=FileSizeY;{1201;}{250k DEM Height}
      Blockwrite(outfile,tyin , Sizeof(tyin), NumRead);
      WhoAmI:=1;  {1=Integer, 0=Float}
      {If (dCellSizeZ < 0) then bZisInteger :=False;}
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
      {WhereString is 4x6 Cell locator=8 Chars}
      CellLocatorEdit.Text:=WhereString;
      For ProjData:=1 to 8 do
      begin
      cWhoAmI:=WhereString[ProjData];
      Blockwrite(outfile,cWhoAmI , Sizeof(cWhoAmI), NumRead);
      end;
  If ValidProjectionCB.Checked then
  WhoAmI:=1 else ProjData:=0;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  WhoAmI:={2=Meters} MapZUnitsCB.Itemindex;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  WhoAmI:=3;{SE corner PixelCoordinateCB.Itemindex;}
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  ProjData:=StrtoInt(NullValueEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI:=ProjectionCB.Itemindex; {0=Geo}
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  WhoAmI:=InUnitCB.Itemindex; {3=Seconds of arc}
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  WhoAmI:=InUtmZoneCB.Itemindex;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  If UTMZoneNorthCB.Checked then
     WhoAmI:=1 else WhoAmI:=0;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  ProjData:=StrtoInt(StatePlaneZoneEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI:=InDatumCB.Itemindex;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
  WhoAmI:=SpheroidCB.Itemindex;
      Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
{Version 2}
ProjData:=CountryFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=StateFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=CountyFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

ProjData:=StrtoInt(PixelsPerDegreeEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  sSinData:=StrtoFloat(KiloPerPixelEdit.Text);
      Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead);

  dSinData:=StrtoFloat(PixelXSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(PixelYSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(ZSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(TopLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(DLGPA1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

              {Reverses the columns DEM to bin}
      for ty:=FileSizeY-1 downto 0 do
      begin   {Count down}
        ProgressBar.Position:=
           Round(((ty)/FileSizeY)*100);
        Application.ProcessMessages;
        for tx:=0 to FileSizeX-1 do
        begin
{          If bZisInteger then
          begin}
            iSinData :=Round(dManMatrix[tx,ty]);
            Blockwrite(outfile,iSinData , Sizeof(iSinData), NumRead)
{          end  else
          Blockwrite(outfile, dManMatrix[tx,ty], 1, NumRead);}
        end;
      end;
      CloseFile(outfile);
      CloseFile(infile);
     If AutosaveMemoCB.Checked then
     DEMtoBinMemo.Lines.SaveToFile(ChangeFileExt(InfileName,'.txt'));
{.tpcfg}
If Config = 0 then
begin
    WriteTpcfgFile(ChangeFileExt(InfileName,'.bit'));
end;
Finally
      SetLength(dManMatrix,0,0);
      Screen.Cursor:=crDefault;
      Panel2.Color:=clBtnFace;
      ProgressBar.Position:=0;
end;
    end;
end;

(***********************************************************)

(***********************************************************)
procedure THtfForm.ReaddemProjection1Click(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'bit files (*.bit)|*.bit';
  if ODTerrainPack.Execute then
  begin
    if LowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.bit' then
    begin
      ReadAnyVersionProj(ODTerrainPack.FileName);
    end;
  end;
end;

procedure THtfForm.SetdemProjection1Click(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'bit files (*.bit)|*.bit';
  if ODTerrainPack.Execute then
  begin
    if LowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.bit' then
    begin
      {Assumes Projection is Valid.. set Display into Data file}
      ReadBitFile(ODTerrainPack.FileName);
      WriteProjectionFile(ODTerrainPack.FileName);
      WriteBitFile(ODTerrainPack.FileName);
      {replaces SetDEMProj(ODTerrainPack.FileName);}
    end;
  end;
end;



procedure THtfForm.SaveBinProjastxt1Click(Sender: TObject);
var
  outfile:Textfile;
  FileText2,FileText:String;
begin
  FileText:=DemPath+DemName.Caption;
  FileText2:=HTFPath+DemName.Caption;
  If ((FileExists(FileText)) or (FileExists(FileText2))) then
  Begin
  If (FileExists(FileText))then
    FileText:=DemPath+ChangeFileExt(DemName.Caption,'.txt')
    else FileText:=HTFPath+ChangeFileExt(DemName.Caption,'.txt');
    AssignFile(outfile,FileText);
    Rewrite(outfile);
    Writeln(outfile,DemName.Caption);
    Writeln(outfile,'Version: '+VersionEdit.Text);
    Writeln(outfile,'Source: '+SourceCB.Items[SourceCB.Itemindex]);

    If IntegerorFloatCB.Checked=True then
       Writeln(outfile,'Integer data') else Writeln(outfile,'Float data');
    Writeln(outfile,'Map Z Units: '+MapZUnitsCB.Items[MapZUnitsCB.Itemindex]);
    Writeln(outfile,'Z Size: '+ZSizeEdit.Text);
    Writeln(outfile,'XY Unit Type: '+InUnitCB.Items[InUnitCB.Itemindex]);
    Writeln(outfile,'Pixel XSize: '+PixelXSizeEdit.Text);
    Writeln(outfile,'Pixel YSize: '+PixelYSizeEdit.Text);
    Writeln(outfile,'X Width: '+XWidthEdit.Text);
    Writeln(outfile,'Y Height: '+YHeightEdit.Text);
    Writeln(outfile,'NullValue: '+NullValueEdit.Text);
    Writeln(outfile,'PixelCoordinate: '+PixelCoordinateCB.Items[PixelCoordinateCB.Itemindex]);
    Writeln(outfile,'SE X EW: '+SEXEWEdit.Text);
    Writeln(outfile,'SE Y NS: '+SEYNSEdit.Text);
    Writeln(outfile,'Cell Locator: '+CellLocatorEdit.Text);

    Writeln(outfile,'Pixels Per Degree: '+PixelsPerDegreeEdit.Text);
    Writeln(outfile,'Kilometers Per Pixel: '+KiloPerPixelEdit.Text);

    If ValidProjectionCB.Checked then
       Writeln(outfile,'Valid Projection data') else Writeln(outfile,'NOT Valid Projection data');
    Writeln(outfile,'Projection: '+ProjectionCB.Items[ProjectionCB.Itemindex]);
    Writeln(outfile,'UtmZone: '+InUtmZoneCB.Items[InUtmZoneCB.Itemindex]);
    If UTMZoneNorthCB.Checked then
       Writeln(outfile,'UTM Zone North data') else Writeln(outfile,'UTM Zone South data');
    Writeln(outfile,'State Plane Zone: '+StatePlaneZoneEdit.Text);
    Writeln(outfile,'Datum: '+InDatumCB.Items[InDatumCB.Itemindex]);
    Writeln(outfile,'Spheroid: '+SpheroidCB.Items[SpheroidCB.Itemindex]);

    Writeln(outfile,'Country Name: '+CountryNameEdit.Text);
    Writeln(outfile,'Country Fips Code: '+CountryFipsCodeEdit.Text);
 Writeln(outfile,'Country Fips Code: '+CountryFipsCodeCB.Items[CountryFipsCodeCB.Itemindex]);
    Writeln(outfile,'State Name: '+StateNameEdit.Text);
    Writeln(outfile,'State Fips Code: '+StateFipsCodeEdit.Text);
 Writeln(outfile,'State Fips Code: '+StateFipsCodeCB.Items[StateFipsCodeCB.Itemindex]);
    Writeln(outfile,'County Name: '+CountyNameEdit.Text);
    Writeln(outfile,'County Fips Code: '+CountyFipsCodeEdit.Text);
 Writeln(outfile,'County Fips Code: '+CountyFipsCodeCB.Items[CountyFipsCodeCB.Itemindex]);

    Writeln(outfile,'TopLeftX: '+TopLeftXEdit.Text);
    Writeln(outfile,'TopLeftY: '+TopLeftYEdit.Text);
    Writeln(outfile,'TopRightX: '+TopRightXEdit.Text);
    Writeln(outfile,'TopRightY: '+TopRightYEdit.Text);
    Writeln(outfile,'BottomLeftX: '+BottomLeftXEdit.Text);
    Writeln(outfile,'BottomLeftY: '+BottomLeftYEdit.Text);
    Writeln(outfile,'BottomRightX: '+BottomRightXEdit.Text);
    Writeln(outfile,'BottomRightY: '+BottomRightYEdit.Text);

    Writeln(outfile,'DLGPA1: '+DLGPA1.Text);
    Writeln(outfile,'DLGPA2: '+DLGPA2.Text);
    Writeln(outfile,'DLGPA3: '+DLGPA3.Text);
    Writeln(outfile,'DLGPB1: '+DLGPB1.Text);
    Writeln(outfile,'DLGPB2: '+DLGPB2.Text);
    Writeln(outfile,'DLGPB3: '+DLGPB3.Text);
    Writeln(outfile,'DLGPC1: '+DLGPC1.Text);
    Writeln(outfile,'DLGPC2: '+DLGPC2.Text);
    Writeln(outfile,'DLGPC3: '+DLGPC3.Text);
    Writeln(outfile,'DLGPD1: '+DLGPD1.Text);
    Writeln(outfile,'DLGPD2: '+DLGPD2.Text);
    Writeln(outfile,'DLGPD3: '+DLGPD3.Text);
    Writeln(outfile,'DLGPE1: '+DLGPE1.Text);
    Writeln(outfile,'DLGPE2: '+DLGPE2.Text);
    Writeln(outfile,'DLGPE3: '+DLGPE3.Text);
  CloseFile(outfile);
  end else
  Showmessage(FileText+ ' is where?');
end;



procedure THtfForm.ReadfilenamevrpasProjection1Click(Sender: TObject);
Begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'Projection files (*.vrp)|*.vrp';
  if ODTerrainPack.Execute then
  begin
    if LowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.vrp' then
    begin
      ReadAnyVersionProj(ODTerrainPack.FileName);
      {ReadvrpProj(ODTerrainPack.FileName);}
    end;
  end;
End;


procedure THtfForm.SavethememoBtnClick(Sender: TObject);
begin
  SDTerrainPack.Filter:= 'Terrain data memo (*.txt)|*.txt|All files (*.*)|*.*';
  SDTerrainPack.InitialDir:=DemPath;
  if SDTerrainPack.Execute then
     DEMtoBinMemo.Lines.SaveToFile(SDTerrainPack.FileName);
end;
(***********************************************************)

(***********************************************************)
procedure THtfForm.SurferGridtoBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'Surfer grid (*.grd)|*.grd';
  ODTerrainPack.Filename:= '*.grd';
  if ODTerrainPack.Execute then
    DoSurferGridtoBin(ODTerrainPack.FileName);
end;
procedure THtfForm.DoSurferGridtoBin(Filename:String);
var
  bDoSurfer:Boolean;
  tx,ty:Integer;
  sSinData:Single	;
  InfileName: string;
  contourdata : TContourGridData;{Surfer}
  begin
    if lowerCase(ExtractFileExt(FileName)) = '.grd' then
    begin
  bDoSurfer:=False;
    Try
      Application.ProcessMessages;
      InfileName:=FileName;
      contourdata := TContourGridData.Create;
      contourdata.blanksub :=StrtoFloat(NullValueEdit.Text);{ 0.0;}
      DemPath:=ExtractFilePath(FileName);
      if (ContourData.LoadSurferGrid(InfileName) = 0) then
      bDoSurfer:=True;

Application.ProcessMessages;
{showmessage('here 1');}
If bDoSurfer then
begin
  SetDefaultDEMProj;
begin {Surfer}
  FileSizeX:= contourdata.nx;
  FileSizeY:=contourdata.ny;
  XWidthEdit.Text:=IntToStr(FileSizeX);
  YHeightEdit.Text:=IntToStr(FileSizeY);
  PixelXSizeEdit.Text:= Floattostr(contourdata.XStep);
  PixelYSizeEdit.Text:= Floattostr(contourdata.YStep);
  TopLeftXEdit.Text:= Floattostr(contourdata.xlo);
  TopLeftYEdit.Text:= Floattostr(contourdata.yhi);
  NullValueEdit.Text:= Floattostr(contourdata.blanksub);
end;
{Set Projection}
      IntegerorFloatCB.Checked:=False{0};  {1=Integer, 0=Float}
 SourceCB.ItemIndex :=12;{  SURFER  DEM}
        Application.ProcessMessages;


{Write DEM file}
  SetLength(sManMatrix,FileSizeX,FileSizeY);
{showmessage('here 2');  }
If bDoSurfer then
begin
{DSAA
329 582
width:329  height:582
0.00  3280.00
0.00  5810.00
-40 1065}
      for ty:=0 to contourdata.ny -1 do
      begin
        ProgressBar.Position:= {Count down}
           Round((( ty)/FileSizeY)*100);
        Application.ProcessMessages;
        for tx:=0 to FileSizeX-1 do
        begin
            sSinData :=contourdata.points[tx,ty];
            sManMatrix[tx,ty]:=sSinData;
        end;
      end;
end;
{showmessage('here 3');}
  contourdata.free;
    WriteProjectionFile(ChangeFileExt(FileName,'.bit'));
    WriteBitFile(ChangeFileExt(FileName,'.bit'));
    WriteTpcfgFile(ChangeFileExt(FileName,'.bit'));
  end;
  Finally
    SetLength(sManMatrix,0,0);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  end;
  end;
end;
{Arc.grd
ncols         200
nrows         225
xllcorner     2667000
yllcorner     6033000
cellsize      40
NODATA_value  -9999}
procedure THtfForm.ARCGridtoBinBtnClick(Sender: TObject);
var
  bDoArc:Boolean;
  tx,ty:Integer;
  sSinData:Single	;
  InfileName: string;
  grd:TGrd; {Arc grid}
begin
  bDoArc:=False;
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'Arc grid (*.grd)|*.grd';
  ODTerrainPack.Filename:= '*.grd';
  if ODTerrainPack.Execute then
  begin
    if lowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.grd' then
    begin
    Try
      Application.ProcessMessages;
      InfileName:=ODTerrainPack.FileName;
      grd := Tgrd.create;
      DecimalSeparator:='.';      {'kapiti.grd'}
      DemPath:=ExtractFilePath(ODTerrainPack.FileName);
      If  grd.loadArcfromfile(InfileName) then bDoArc:=True;

Application.ProcessMessages;
{showmessage('here 1');}
If bDoArc then
begin
  SetDefaultDEMProj;
If bDoArc then
begin
  FileSizeX:= grd.width;
  FileSizeY:=grd.height;
  XWidthEdit.Text:=IntToStr(FileSizeX);
  YHeightEdit.Text:=IntToStr(FileSizeY);
  PixelXSizeEdit.Text:= Floattostr(grd.cellsize);
  PixelYSizeEdit.Text:= Floattostr(grd.cellsize);
  TopLeftXEdit.Text:= Floattostr(grd.originX);
  TopLeftYEdit.Text:= Floattostr(grd.OriginY);
  NullValueEdit.Text:= Floattostr(grd.null);
end ;
{Set Projection}
      IntegerorFloatCB.Checked:=False{0};  {1=Integer, 0=Float}
      If bDoArc then SourceCB.ItemIndex :=13;{  ARC DEM}
        Application.ProcessMessages;


{Write DEM file}
  SetLength(sManMatrix,FileSizeX,FileSizeY);
{showmessage('here 2');  }
If bDoArc then
begin
{
ncols         200
nrows         225
xllcorner     2667000
yllcorner     6033000
cellsize      40
NODATA_value  -9999}
      for ty:=0 to grd.height-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/FileSizeY)*100);
        Application.ProcessMessages;
        for tx:=0 to grd.width-1 do
        begin
            {sSinData :=grd.pts[tx,ty];}
            sSinData :=grd.pts[ty,tx];
            sManMatrix[tx,ty]:=sSinData;
        end;
      end;
end ;
{showmessage('here 3');}
  grd.free;
    WriteProjectionFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteBitFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteTpcfgFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
  end;
  Finally
    SetLength(sManMatrix,0,0);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  end;
    end;
  end;
end;


{XYZ ASCII data files are made of rows
each containing longitude, latitude, and depth.
There is one row for each grid point.
Read til eof, Check X,Y for repeats to determine Columns and Rows.
 Store Z where till X and Y are determined?
 Store in linear array then reformat into X,Y Matrix.
Skagxyz.dat
0 0 -40
10 0 -20
20 0 0
30 0 24
10 10 -20}
procedure THtfForm.XYZtoBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'XYZ files (*.dat or *.xyz)|*.dat;*.xyz';
  ODTerrainPack.Filename:= '*.xyz';
  if ODTerrainPack.Execute then
    DoXYZtoBin(ODTerrainPack.FileName);
end;
procedure THtfForm.DoXYZtoBin(FileName:String);
var
  NumRead,tx,ty:Integer;
  Mintxin, Maxtxin, Maxtyin,Mintyin,
  txin, tyin, tzin:Double;
  txinS, tyinS,   TemptxinS, TemptyinS,
  WhereString,MyFilesS: string;
  infile:textfile;
  begin
    if ((lowerCase(ExtractFileExt(FileName)) = '.dat')or
        (lowerCase(ExtractFileExt(FileName)) = '.xyz'))
    then
    begin
      {Read data}   {Data format}
      Mintxin:= 3 * 10E38;
      Mintyin:= 3 * 10E38;
      Maxtxin:= -3 * 10E38;
      Maxtyin:= -3 * 10E38;
      AssignFile(infile, FileName);
      Reset(infile);
      Readln(infile, MyFilesS);
      NumRead:=Pos(' ',MyFilesS);
      txinS:=Copy(MyFilesS,1,NumRead);
      TemptxinS:=txinS;
      txin:=StrtoFloat(txinS);
      If Mintxin >txin then Mintxin:=txin;
      If Maxtxin <txin then Maxtxin:=txin;
      MyFilesS:=Copy(MyFilesS,NumRead,Length(MyFilesS));
      NumRead:=Pos(' ',MyFilesS);
      tyinS:=Copy(MyFilesS,1,NumRead);
      TemptyinS:=tyinS;
      tyin:=StrtoFloat(tyinS);
      If Mintyin >tyin then Mintyin:=tyin;
      If Maxtyin <tyin then Maxtyin:=tyin;
      MyFilesS:=Copy(MyFilesS,NumRead,Length(MyFilesS));
      If (Pos(' ',MyFilesS)>0) then
      begin
      NumRead:=Pos(' ',MyFilesS);
      WhereString:=Copy(MyFilesS,1,NumRead);
      end;
      tzin:=StrtoFloat(trim(WhereString));
      tx:=0;
      ty:=0;
      SetLength(sManMatrix,tx+1,ty+1);
      sManMatrix[tx,ty]:= tzin;
      While (not Eof(infile))do
      Begin
        Readln(infile, MyFilesS);
        NumRead:=Pos(' ',MyFilesS);
        txinS:=Copy(MyFilesS,1,NumRead);
        txin:=StrtoFloat(txinS);
        If Mintxin >txin then Mintxin:=txin;
        If Maxtxin <txin then Maxtxin:=txin;
        MyFilesS:=Copy(MyFilesS,NumRead,Length(MyFilesS));
        NumRead:=Pos(' ',MyFilesS);
        tyinS:=Copy(MyFilesS,1,NumRead);
        tyin:=StrtoFloat(tyinS);
        If Mintyin >tyin then Mintyin:=tyin;
        If Maxtyin <tyin then Maxtyin:=tyin;
        MyFilesS:=Copy(MyFilesS,NumRead,Length(MyFilesS));
        If (Pos(' ',MyFilesS)>0) then
        begin
          NumRead:=Pos(' ',MyFilesS);
          WhereString:=Copy(MyFilesS,1,NumRead);
        end;
        tzin:=StrtoFloat(trim(WhereString));
        If TemptyinS=tyinS then
        begin
          TemptyinS:=tyinS;
          inc(ty);
          tx:=-1;
        end;
        inc(tx);
        SetLength(sManMatrix,tx+1,ty+1);
        sManMatrix[tx,ty]:= tzin;
      End;
      CloseFile(infile);
      {Set Projection... nothing known
        can set Corner Coordinates after reading}
      SetDefaultDEMProj;
      IntegerorFloatCB.Checked:=False;{Floats data}
      FileSizeX:= tx;
      FileSizeY:=ty;
      XWidthEdit.Text:=IntToStr(FileSizeX);{Rewrite as Size matters}
      YHeightEdit.Text:=IntToStr(FileSizeY);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      SourceCB.ItemIndex :=14;{  '14'  Ascii XYZ DEM}
      PixelXSizeEdit.Text:= Floattostr(((Maxtxin-Mintxin)/tx));
      PixelYSizeEdit.Text:= Floattostr(((Maxtyin-Mintyin)/ty));
      TopLeftXEdit.Text:= Floattostr(Mintxin);
      TopLeftYEdit.Text:= Floattostr(Maxtyin);
      BottomRightXEdit.Text:= Floattostr(Maxtxin);
      BottomRightYEdit.Text:= Floattostr(Mintyin);
      WriteProjectionFile(ChangeFileExt(FileName,'.bit'));
      WriteBitFile(ChangeFileExt(FileName,'.bit'));
      WriteTpcfgFile(ChangeFileExt(FileName,'.bit'));
    end;
  SetLength(sManMatrix,0,0);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
end;

(***********************************************************)

(***********************************************************)
procedure THtfForm.BTBtnClick(Sender: TObject);
begin{}
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'BT files list (*.BT)|*.BT';
  ODTerrainPack.Filename:= '*.BT';
  if ODTerrainPack.Execute then
    DoBT(ODTerrainPack.Filename);
end;
procedure THtfForm.DoBT(Filename:String);
var
{  WhoAmI:Byte;}
  cWhoAmI:Char;
  bZisInteger:Boolean;
  typein, siSinData,
  ProjData:SmallInt;{:Integer;}
  iSinData,
  txin, tyin, NumRead,tx,ty:Integer;
  sSinData:Single;
  dSinData:Double;
  WhereString,
  InfileName: string;
  Infile{,outfile}:file;
{  siManMatrix: array of array of SmallInt;
  iManMatrix: array of array of Integer;
  sManMatrix: array of array of Double;}
  begin
    if lowerCase(ExtractFileExt(FileName)) = '.bt' then
    begin
      InfileName:=FileName;
      Screen.Cursor:=crHourGlass;
      ProgressBar.Position:=0;
      DEMtoBinMemo.Clear; { File selected in dialog box }
      DemPath:=ExtractFilePath(InfileName);
      AssignFile(infile, InfileName);
      Reset(infile,1);
      WhereString:='          ';{10 chars}{unknown }
      {Set Projection}
      For ProjData:=1 to 10 do
      begin
      Blockread(infile,cWhoAmI , Sizeof(cWhoAmI), NumRead);
      WhereString[ProjData]:=cWhoAmI;
      end;{ binterr1.1 }
      If (('binterr1.1'=WhereString)or('binterr1.2'=WhereString)) then
      begin
        {Read BT Header into Projection}
        SetDefaultDEMProj;
        {Columns Width (east-west) }
        Blockread(infile,txin , Sizeof(txin), NumRead);
        { Rows Height (north-south)}
        Blockread(infile,tyin , Sizeof(tyin), NumRead);
        FileSizeX:=txin;    XWidthEdit.Text:=Inttostr(FileSizeX);
        FileSizeY:=tyin;    YHeightEdit.Text:=Inttostr(FileSizeY);
        {Data size Bytes per elevation grid point, either 2 or 4}
        Blockread(infile,typein , Sizeof(typein), NumRead);
        {20 2 (short) Floating-point flag
         If 1, the data consists of floating point values (float),
         otherwise they are integers.}
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        If (siSinData=1) then bZisInteger:=False
        else bZisInteger:=True;
        IntegerorFloatCB.Checked:=bZisInteger;
        {Projection 0: Geographic 1: Universal Transverse Mercator (UTM)}
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        ProjectionCB.ItemIndex:=siSinData;
        {UTM zone Indicates the UTM zone (1-60) if the file is in UTM.
      		The usual convention is negative zone numbers for the southern hemisphere.}
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        InUtmZoneCB.ItemIndex:=siSinData;
        {Datum Indicates the Datum, see Datum Values below.}
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        InDatumCB.ItemIndex:=siSinData;
        {(double) Left extent The extents are specified in the coordinate space specified by
     		 the UTM flag/zone fields.
      		If UTM is false, they are ordinary geographic (latitude-longitude) values.}
        Blockread(infile,dSinData , Sizeof(dSinData), NumRead);
        TopLeftXEdit.Text:= Floattostr(dSinData);
        BottomLeftXEdit.Text:= Floattostr(dSinData);
        {Right extent}
        Blockread(infile,dSinData , Sizeof(dSinData), NumRead);
        TopRightXEdit.Text:= Floattostr(dSinData);
        BottomRightXEdit.Text:= Floattostr(dSinData);
        {Bottom extent}
        Blockread(infile,dSinData , Sizeof(dSinData), NumRead);
        BottomLeftYEdit.Text:= Floattostr(dSinData);
        BottomRightYEdit.Text:= Floattostr(dSinData);
       {Top extent}
        Blockread(infile,dSinData , Sizeof(dSinData), NumRead);
        TopLeftYEdit.Text:= Floattostr(dSinData);
        TopRightYEdit.Text:= Floattostr(dSinData);

        If ('binterr1.2'=WhereString) then
        begin
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        {External projection
          0: Projection is fully described by this header
      		1: Projection is specified in a external .prj file}
          If siSinData=1 then {do something};
        end else
        Blockread(infile,siSinData , Sizeof(siSinData), NumRead);
        {62-255 194 unused Bytes of value 0 are used to pad the rest of the header.}
        For ProjData:=1 to 194 do
        begin
          Blockread(infile,cWhoAmI , Sizeof(cWhoAmI), NumRead);
        end;
{Read BT Data into Matrix .. }
{READ it switched... like a DEM}
If bZisInteger then
begin
If typein=2 then
  begin
  SetLength(ManMatrix,txin+1,tyin+1 );
        for tx:=0 to FileSizeX-1 do
      begin
        ProgressBar.Position:=
           Round((( tx)/FileSizeY)*100);
        Application.ProcessMessages;
      for ty:=FileSizeY-1 downto 0 do
{      for ty:=0 to FileSizeY-1 do}
        begin
            BlockRead(Infile,siSinData , Sizeof(siSinData), NumRead);
            ManMatrix[tx,ty]:=siSinData;
        end;
      end;
  end
  else
  begin
  SetLength(ManMatrix,txin+1,tyin+1 );
        for tx:=0 to FileSizeX-1 do
      begin
        ProgressBar.Position:=
           Round((( tx)/FileSizeY)*100);
        Application.ProcessMessages;
      for ty:=FileSizeY-1 downto 0 do
{      for ty:=0 to FileSizeY-1 do    }
        begin
            BlockRead(Infile,iSinData , Sizeof(iSinData), NumRead);
            ManMatrix[tx,ty]:=iSinData;
        end;
      end;
  end
end else
begin
SetLength(sManMatrix,txin+1,tyin+1 );
        for tx:=0 to FileSizeX-1 do
      begin
        ProgressBar.Position:=
           Round((( tx)/FileSizeY)*100);
        Application.ProcessMessages;
      for ty:=FileSizeY-1 downto 0 do
{      for ty:=0 to FileSizeY-1 do    }
        begin
            BlockRead(Infile,sSinData , Sizeof(sSinData), NumRead);
            sManMatrix[tx,ty]:=sSinData;
        end;
      end;
end;
        Application.ProcessMessages;
        WriteProjectionFile(ChangeFileExt(FileName,'.bit'));
        WriteBitFile(ChangeFileExt(FileName,'.bit'));
        WriteTpcfgFile(ChangeFileExt(FileName,'.bit'));
        {CloseFile(outfile);}
        CloseFile(infile);
        SetLength(ManMatrix,0,0 );
        SetLength(sManMatrix,0,0 );
      end else
      begin
        showmessage('Not a 1.1 or 1.2 BT file');
        {CloseFile(outfile);}
        CloseFile(infile);
        SetLength(ManMatrix,0,0 );
        SetLength(sManMatrix,0,0 );
        ProgressBar.Position:=0;
        Screen.Cursor:=crDefault;
        exit;
      end;
    end;
  Screen.Cursor:=crDefault;
  ProgressBar.Position:=0;
end;

{no extensions}
procedure THtfForm.GlobeBtnClick(Sender: TObject);
var
  ElevationCount: Smallint;
  Xcount, Zcount: Integer;
 {  Tempe,}
  DemiLeftX1e, DemiTopY1e,
  DemiRightX2e, DemiBottomY2e: Double;
  FileString{,  MtnString}: string;
{  DTM_File: TextFile;}
 Dem_File: file of Smallint;
begin                          {no extensions}
  ODTerrainPack.Filter := 'NOAA GLOBE files (e10)|*.*';
  ODTerrainPack.Filename := 'NOAA GLOBE files';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    DemPath:=ExtractFilePath(ODTerrainPack.FileName);
    FileString := lowercase(extractfilename(ODTerrainPack.FileName))[1];
if FileString= 'a' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=6098;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=-180;
    DemiTopY1e:=90;
    DemiRightX2e:=-90;
    DemiBottomY2e:=50;
  end
else if FileString= 'b' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=3940;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=-90;
    DemiTopY1e:=90;
    DemiRightX2e:=0;
    DemiBottomY2e:=50;
  end
else if FileString= 'c' then
  begin
    MinimumElevation:=-30;
    MaximumElevation:=4010;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=0;
    DemiTopY1e:=90;
    DemiRightX2e:=90;
    DemiBottomY2e:=50;
  end
else if FileString= 'd' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=4588;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=90;
    DemiRightX2e:=180;
    DemiTopY1e:=90;
    DemiBottomY2e:=50;
  end
else if FileString= 'e' then
  begin
    MinimumElevation:=-84;
    MaximumElevation:=5443;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=-180;
    DemiTopY1e:=50;
    DemiRightX2e:=-90;
    DemiBottomY2e:=0;
  end
else if FileString= 'f' then
  begin
    MinimumElevation:=-40;
    MaximumElevation:=6085;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=-90;
    DemiRightX2e:=0;
    DemiTopY1e:=50;
    DemiBottomY2e:=0;
  end
else if FileString= 'g' then
  begin
    MinimumElevation:=-407;
    MaximumElevation:=8752;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=0;
    DemiRightX2e:=90;
    DemiTopY1e:=50;
    DemiBottomY2e:=0;
  end
else if FileString= 'h' then
  begin
    MinimumElevation:=-63;
    MaximumElevation:=7491;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=90;
    DemiRightX2e:=180;
    DemiTopY1e:=50;
    DemiBottomY2e:=0;
  end

else if FileString= 'i' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=2732;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=-180;
    DemiRightX2e:=-90;
    DemiTopY1e:=0;
    DemiBottomY2e:=-50;
  end
else if FileString= 'j' then
  begin
    MinimumElevation:=-127;
    MaximumElevation:=6798;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=-90;
    DemiRightX2e:=0;
    DemiTopY1e:=0;
    DemiBottomY2e:=-50;
  end
else if FileString= 'k' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=5825;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=0;
    DemiRightX2e:=90;
    DemiTopY1e:=0;
    DemiBottomY2e:=-50;
  end
else if (lowercase(extractfilename(ODTerrainPack.FileName))='l10g') then
  begin
    MinimumElevation:=1;
    MaximumElevation:=5179;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=90;
    DemiRightX2e:=180;
    DemiTopY1e:=0;
    DemiBottomY2e:=-50;
  end
else if (lowercase(extractfilename(ODTerrainPack.FileName))='l10b') then
  begin
    MinimumElevation:=-34;
    MaximumElevation:=5179;
    FileSizeX:=10800;
    FileSizeY:=6000;
    DemiLeftX1e:=90;
    DemiRightX2e:=180;
    DemiTopY1e:=0;
    DemiBottomY2e:=-50;
  end
else if FileString= 'm' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=4009;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=-180;
    DemiRightX2e:=-90;
    DemiTopY1e:=-50;
    DemiBottomY2e:=-90;
  end
else if FileString= 'n' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=4743;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=-90;
    DemiRightX2e:=0;
    DemiTopY1e:=-50;
    DemiBottomY2e:=-90;
  end
else if FileString= 'o' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=4039;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=0;
    DemiRightX2e:=90;
    DemiTopY1e:=-50;
    DemiBottomY2e:=-90;
  end
else if FileString= 'p' then
  begin
    MinimumElevation:=1;
    MaximumElevation:=4363;
    FileSizeX:=10800;
    FileSizeY:=4800;
    DemiLeftX1e:=90;
    DemiRightX2e:=180;
    DemiTopY1e:=-50;
    DemiBottomY2e:=-90;
  end
else begin
DoMessages(25011);
exit;
end;
    AssignFile(DEM_File, ODTerrainPack.Filename);
    Reset(DEM_File);
    SetLength(ManMatrix,FileSizeX,FileSizeY );
    for Zcount := 0 to FileSizeY - 1 do
    begin
      ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
      Application.ProcessMessages;
      for Xcount := 0 to FileSizeX - 1 do
      begin
        Read(DEM_File, ElevationCount);
        ManMatrix[Xcount,Zcount] := ElevationCount;
      end;
    end;
    CloseFile(DEM_File);
    SetDefaultDEMProj;
    SourceCB.ItemIndex:=4;{Globe}
    NullValueEdit.Text:=Inttostr(-500);
    XWidthEdit.Text:=Inttostr(FileSizeX);
    YHeightEdit.Text:=Inttostr(FileSizeY);
    PixelXSizeEdit.Text:= Floattostr(0.0083333333);{X Size .5 Minute}
    PixelYSizeEdit.Text:= Floattostr(0.0083333333);{Y Size .5 Minute}
    PixelCoordinateCB.ItemIndex:=0;
    TopLeftXEdit.Text:= Inttostr(Round(DemiLeftX1e));
    TopLeftYEdit.Text:= Inttostr(Round(DemiTopY1e));
    BottomRightXEdit.Text:= Inttostr(Round(DemiRightX2e));
    BottomRightYEdit.Text:= Inttostr(Round(DemiBottomY2e));
    MapZUnitsCB.Itemindex:=2;{Meters}
    ProjectionCB.Itemindex:=0;  {Geo}
    PixelCoordinateCB.Itemindex:=0;{Center}
    InUtmZoneCB.Itemindex:=0;{=#16}
    UTMZoneNorthCB.Checked:=True;
    IntegerorFloatCB.Checked:=True;
    InUnitCB.Itemindex:=4; {D Degrees of arc}
    InDatumCB.Itemindex:=14;  {wgs84}
    SpheroidCB.Itemindex:=12;{wgs84}
    Application.ProcessMessages;
    WriteProjectionFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteBitFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteTpcfgFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));

    {WriteProjectionFile(ODTerrainPack.FileName);
     WriteBitFile(ODTerrainPack.FileName);
    WriteBinFile(ODTerrainPack.FileName,4);}{Globe}
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
  end else DoMessages(25007);
end;


{.dem extension and a .hdr}
procedure THtfForm.GtopoBtnClick(Sender: TObject);
var
  MtnChar:Char;
  ElevationCount: Smallint;
  Xcount, Zcount, CodeVx: Integer;
  Tempe, DemiLeftX1e, DemiTopY1e,
DemiRightX2e, DemiBottomY2e:    Double;
  MtnString: string;
  DTM_File: TextFile;
  Dem_File: file of Smallint;
begin
  {NoData:=-9999;}
  {DemiLeftX1e:=0;DemiTopY1e:=0;DemiRightX2e:=0;DemiBottomY2e:=0;}
  ODTerrainPack.Filter := 'Gtopo files|*.dem';
  ODTerrainPack.Filename := 'Gtopo files.dem';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    DemPath:=ExtractFilePath(ODTerrainPack.FileName);
    MtnString := ChangeFileExt(ODTerrainPack.FileName, '.hdr');
    SetDefaultDEMProj;
    AssignFile(DTM_File, MtnString);
    Reset(DTM_File);
    Readln(DTM_File, MtnString);
    If ((pos('NROWS',MtnString)>0)
        and (pos(#13,MtnString)=0)) then
    begin
{      showmessage('rewriting it');}
      Reset(DTM_File);
      MtnString:='';
      DEMtoBinMemo.Clear;
      CodeVx:=0;
      While (not eof(DTM_File)) do
      begin
        Read(DTM_File, MtnChar);
        If (MtnChar = #10) then
        begin      {CR }
          MtnString:=MtnString+MtnChar;
          MtnString:=MtnString+#13;{Linefeed}
          {write to memo}
          DEMtoBinMemo.Lines[CodeVx]:=MtnString;
          MtnString:='';
          inc(CodeVx);
        end
        else MtnString:=MtnString+MtnChar;
      end;
      Rewrite(DTM_File);
      {Write file from memo}
      For Xcount:=0 to CodeVx-1 do
         writeln(DTM_File,DEMtoBinMemo.Lines[Xcount]);
    end;
    DEMtoBinMemo.Clear;
    Reset(DTM_File);
    if (IoResult = 0) then
    begin {BYTEORDER      M ad as a hatter}
      DEMtoBinMemo.Lines.Clear;
      Readln(DTM_File, MtnString);
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {LAYOUT       BIL}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {NCOLS   X      4800}
      MtnString := copy(MtnString, 6, 66);
      val(MtnString, FileSizeX, CodeVx);
      Codefx(MtnString,CodeVx);
      Readln(DTM_File, MtnString); {NROWS    Y     6000}
      MtnString := copy(MtnString, 6, 66);
      val(MtnString, FileSizeY, CodeVx);
      Codefx(MtnString, CodeVx);
      DEMtoBinMemo.Lines.Append(IntToStr(FileSizeX));
        {DemiColumns.Text:=IntToStr(FileSizeX);}
      DEMtoBinMemo.Lines.Append(IntToStr(FileSizeY));
      { DemiRows.Text:=IntToStr(FileSizeY);}
      Readln(DTM_File, MtnString); {NBANDS        1}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {NBITS         16}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {BANDROWBYTES         9600}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {TOTALROWBYTES        9600}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {BANDGAPBYTES         0}
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {NODATA        -9999}
      MtnString := copy(MtnString, 7, 66);
      val(MtnString, NullDemValue, CodeVx);
      Codefx(MtnString,CodeVx);
      DEMtoBinMemo.Lines.Append(MtnString);
      {DemiLeftX1e,DemiTopY1e,DemiRightX2e,DemiBottomY2e}
      Readln(DTM_File, MtnString);
       {ULXMAP        -59.99583333333333}
      MtnString := copy(MtnString, 7, 66);
       val(MtnString, DemiLeftX1e, CodeVx);
      Codefx(MtnString,CodeVx);
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString);
       {ULYMAP        39.99583333333333}
      MtnString := copy(MtnString, 7, 66);
        val(MtnString, DemiTopY1e, CodeVx);
      Codefx(MtnString, CodeVx);
      DEMtoBinMemo.Lines.Append(MtnString);
      Readln(DTM_File, MtnString); {XDIM  0.00833333333333}
      MtnString := copy(MtnString, 5, 66);
      val(MtnString, DemiRightX2e, CodeVx);
      Codefx(MtnString,CodeVx);
      DEMtoBinMemo.Lines.Append(Floattostr(DemiRightX2e));
      Readln(DTM_File, MtnString); {YDIM   0.00833333333333}
      MtnString := copy(MtnString, 5, 66);
      val(MtnString, DemiBottomY2e, CodeVx);
      Codefx(MtnString, CodeVx);
      DEMtoBinMemo.Lines.Append(Floattostr(DemiBottomY2e));
      CloseFile(DTM_File);
      if (IoResult <> 0) then DoMessages(25012);
      { MainForm.HintPanel.Caption :=
                'Reading Elevations from disk'; }
      Application.ProcessMessages;
      AssignFile(DEM_File, ODTerrainPack.Filename);
      Reset(DEM_File);
      if (IoResult = 0) then
      begin
        NullDemValue:=-9999;
        MaximumElevation := -2147483647;
        MinimumElevation := 2147483646;
        ProgressBar.Visible := True;
        Application.ProcessMessages;
        {Make an array the size of Xs}
        SetLength(ManMatrix,FileSizeX,FileSizeY );
        for Zcount := 0 to FileSizeY - 1 do
        begin
          ProgressBar.Position :=
                  Round((Zcount /
                    (FileSizeY - 1)) * 100);
          Application.ProcessMessages;
          for Xcount := 0 to FileSizeX - 1 do
          begin
            Read(DEM_File, ElevationCount);
            ElevationCount := Swap(ElevationCount);
            {Gtopo is M ordered... NOT Intel ordered}
            {Fill an array the size of Xs}
            ManMatrix[Xcount,Zcount] := ElevationCount;
            if (ElevationCount > NullDemValue) then
              {  TStackX[Xcount] := (-32767) was going to change em...
                    else}
            begin
              if (MaximumElevation <= ElevationCount) then
                 MaximumElevation := ElevationCount;
              if (MinimumElevation >= ElevationCount) then
                  MinimumElevation := ElevationCount;
            end;
          end;
        end;{Z}
        CloseFile(DEM_File);
        {  CloseFile(Bin_File);  }
        if (IoResult <> 0) then DoMessages(25005) else
        begin
          {DO ALL the Stuff and SAVE a FLM file and a HDR File}
          DemPath:=ExtractFilePath(ODTerrainPack.FileName);
          {FileSizeX:= 4320;}
          XWidthEdit.Text:=Inttostr(FileSizeX);
          {FileSizeY:=2160;}
          YHeightEdit.Text:=Inttostr(FileSizeY);
          PixelXSizeEdit.Text:= Floattostr(0.083333333);{X Size 5 Minute}
          PixelYSizeEdit.Text:= Floattostr(0.083333333);{Y Size 5 Minute}
          PixelCoordinateCB.ItemIndex:=1;
          {TopLeftXEdit.Text:= '0';
          TopLeftYEdit.Text:= '0';
          BottomRightXEdit.Text:= Inttostr(FileSizeX);
          BottomRightYEdit.Text:= Inttostr(FileSizeY);}
          MapZUnitsCB.Itemindex:=2;{Meters}
          ProjectionCB.Itemindex:=0;  {Geo}
          PixelCoordinateCB.Itemindex:=0;{Center}
          InUtmZoneCB.Itemindex:=0;{=#16}
          UTMZoneNorthCB.Checked:=True;
          IntegerorFloatCB.Checked:=True;
          InUnitCB.Itemindex:=4; {D Degrees of arc}
          InDatumCB.Itemindex:=14;  {wgs84}
          SpheroidCB.Itemindex:=12;{wgs84}
        end; {write a FLM file}
        if (IoResult = 0) then
        begin
        {Tempe,DemiLeftX1e,DemiTopY1e,DemiRightX2e,DemiBottomY2e}
         NullValueEdit.Text:=  Inttostr(NullDemValue);
         SourceCB.Itemindex:=5;{: Gtopo}
CellSizeX:=DemiRightX2e; {X Size 5 Minute}
CellSizeY:=DemiBottomY2e; {Y Size 5 Minute}
        {DemiLeftX1e,DemiTopY1e,DemiRightX2e,DemiBottomY2e}
                  Tempe := (DemiLeftX1e + (CellSizeX / 2));
                  DemiLeftX1e:= Tempe;
       str(Tempe {DemiLeftX1e}, MtnString);
       TopLeftXEdit.Text:=MtnString;
       BottomLeftXEdit.Text:=MtnString;
       SEXEWEdit.Text:=Inttostr(Round(DemiLeftX1e));
                  Tempe := (DemiTopY1e - (CellSizeY / 2));
                  DemiTopY1e:= Tempe;
       str(Tempe {DemiTopY1e}, MtnString);
       TopLeftYEdit.Text:=MtnString;
       TopRightYEdit.Text:=MtnString;
                  Tempe := (DemiLeftX1e +
                    (CellSizeX * (FileSizeX - 1)));
                  DemiRightX2e:=Tempe;
       str(DemiRightX2e, MtnString);
       TopRightXEdit.Text:=MtnString;
       BottomRightXEdit.Text:=MtnString;
                  Tempe := (DemiTopY1e +
                    (CellSizeY * (FileSizeY - 1)));
       DemiBottomY2e:=Tempe;
       str(DemiBottomY2e, MtnString);
       BottomRightYEdit.Text:=MtnString;
       BottomLeftYEdit.Text:=MtnString;
       SEYNSEdit.Text:=Inttostr(Round(DemiBottomY2e));
       PixelCoordinateCB.ItemIndex:=0;
       { GridOriginString:= 'NW'; }{Grid Origin}
              {CellOriginString:= 'Center';}
             {Cell Origin usually center of pixel...}
{Write deh DTM HDR}
{                MtnString :=
                  ChangeFileExt(ODTerrainPack.FileName,'.deh');
                  WriteDehFile(MtnString); }
    Application.ProcessMessages;
    WriteProjectionFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteBitFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteTpcfgFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
{    WriteBinFile(ODTerrainPack.FileName,5);}{GTopo}
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
        end else DoMessages(25011);
      end else DoMessages(25005);
    end else DoMessages(25012);
  end; {Opened file}
end; {1}


procedure THtfForm.Etopo2BtnClick(Sender: TObject);
begin
{}
end;
{SetDefaultDEMProj;
FileSizeX:= tx;
FileSizeY:=ty;
PixelXSizeEdit.Text:= Floattostr(((Maxtxin-Mintxin)/tx));
PixelYSizeEdit.Text:= Floattostr(((Maxtyin-Mintyin)/ty));
      TopLeftXEdit.Text:= Floattostr(Mintxin);
      TopLeftYEdit.Text:= Floattostr(Maxtyin);
      BottomRightXEdit.Text:= Floattostr(Maxtxin);
      BottomRightYEdit.Text:= Floattostr(Mintyin);}
(*MapZUnitsCB.Itemindex:=2;{Meters}
  ProjectionCB.Itemindex:=0;  {Geo}
  PixelCoordinateCB.Itemindex:=0;{Center}
  InUtmZoneCB.Itemindex:=17;{=#16}
  UTMZoneNorthCB.Checked:=True;
  IntegerorFloatCB.Checked:=True;
  InUnitCB.Itemindex:=4; {D Degrees of arc}
  InDatumCB.Itemindex:=13;  {Nad27}
  SpheroidCB.Itemindex:=0;*)
{4: NOAA Globe
5: Gtopo
6: Etopo2
7: Etopo}

procedure THtfForm.EtopoBtnClick(Sender: TObject);
var
  Check1,Check2:Byte;
  ElevationCount: Smallint;
  Xcount, Zcount: Integer;
  Bin_File: file of Smallint;
  testBin_File: file of Byte;
begin  {no Header?}                  {REALLY .bin is ORIGINAL}
  ODTerrainPack.Filter := 'Etopo files|*.bin';
  ODTerrainPack.Filename := 'Etopo files.bin';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    SetDefaultDEMProj;
    DemPath:=ExtractFilePath(ODTerrainPack.FileName);
    FileSizeX:= 4320;    XWidthEdit.Text:='4320';
    FileSizeY:=2160;     YHeightEdit.Text:='2160';
    PixelXSizeEdit.Text:= Floattostr(0.083333333);{X Size 5 Minute}
    PixelYSizeEdit.Text:= Floattostr(0.083333333);{Y Size 5 Minute}
    PixelCoordinateCB.ItemIndex:=1;
    TopLeftXEdit.Text:= '0';
    TopLeftYEdit.Text:= '0';
    BottomRightXEdit.Text:= '4320';
    BottomRightYEdit.Text:= '2160';
    MapZUnitsCB.Itemindex:=2;{Meters}
    ProjectionCB.Itemindex:=0;  {Geo}
    PixelCoordinateCB.Itemindex:=0;{Center}
    InUtmZoneCB.Itemindex:=0;{=#16}
    UTMZoneNorthCB.Checked:=True;
    IntegerorFloatCB.Checked:=True;
    InUnitCB.Itemindex:=4; {D Degrees of arc}
    InDatumCB.Itemindex:=14;  {wgs84}
    SpheroidCB.Itemindex:=12;{wgs84}
    Application.ProcessMessages;
    AssignFile(testBin_File, ODTerrainPack.FileName);
    Reset(testBin_File);
    Read(testBin_File, Check1);
    Read(testBin_File, Check2);
    CloseFile(testBin_File);
    If (not( (Check1=7) and (Check2=1))) then
    begin
    AssignFile(Bin_File, ODTerrainPack.FileName);
    Reset(Bin_File);
    if (IoResult = 0) then
    begin
      MaximumElevation := -2147483647;
      MinimumElevation := 2147483646;
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      SetLength(ManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          Read(Bin_File, ElevationCount);
          if (MaximumElevation <= ElevationCount) then
              MaximumElevation := ElevationCount;
          if (MinimumElevation >= ElevationCount) then
             MinimumElevation := ElevationCount;
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
      CloseFile(Bin_File);
      if (IoResult <> 0) then DoMessages(25005);
    end else DoMessages(25006);{Already processed}
    end else DoMessages(25006);
    Application.ProcessMessages;
    WriteProjectionFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteBitFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    WriteTpcfgFile(ChangeFileExt(ODTerrainPack.FileName,'.bit'));
    {WriteBinFile(ODTerrainPack.FileName,7);}
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
  end;
end;

(*************************************************************)


(*************************************************************)
{N44W122.hgt
Filename: Lat Long of Lower Left corner: 1 degree tiles
North and West edge are duplicates
Signed Big-endian Integers: SWAP to Intel Little-Endian
WGS84 ellipsoid
Heights in Meters
Null values: -32768}
procedure THtfForm.SRTM3toBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.Filter := 'SRTM files|*.hgt';
  ODTerrainPack.Filename := 'SRTM files.hgt';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    SetDefaultDEMProj;
    FileSizeX:= 1201;    XWidthEdit.Text:='1201';
    FileSizeY:=1201;     YHeightEdit.Text:='1201';
    PixelXSizeEdit.Text:= Floattostr(0.00083333333);{X Size 3AS}
    PixelYSizeEdit.Text:= Floattostr(0.00083333333);{Y Size 3AS}
    SourceCB.itemIndex:=16;  {15: 10M SRTM dem 16: 30M SRTM dem}
    DoSRTMtoBin(ODTerrainPack.Filename ,0);
  end;
end;
procedure THtfForm.SRTM3ListBtnClick(Sender: TObject);
var
  MaxX,MaxY,
 CountIn,CountAll:Integer;
 S : string;
 F: TextFile;
begin
  MaxX:=0;MaxY:=0;
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'SRTM files list (*.txt)|*.txt';
  ODTerrainPack.Filename:= 'graflist.txt';{graflist.txt}
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.TXT' then
    begin
      SetDefaultDEMProj;
    FileSizeX:= 1201;    XWidthEdit.Text:='1201';
    FileSizeY:=1201;     YHeightEdit.Text:='1201';
    PixelXSizeEdit.Text:= Floattostr(0.00083333333);{X Size 3AS}
    PixelYSizeEdit.Text:= Floattostr(0.00083333333);{Y Size 3AS}
    SourceCB.itemIndex:=16;  {15: 10M SRTM dem 16: 30M SRTM dem}
      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      CountIn:=0;
      CountAll:=0;
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountIn);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       end;

      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountAll);
        ReadWriteLabel.Caption:='Reading: ';
        ColonLabel.Caption:=' '+Inttostr(CountAll)+' of '+Inttostr(CountIn)+' : ';
        If FileExists(S) then
           DoSRTMtoBin(S,1);
        If MaxX< FileSizeX then MaxX:= FileSizeX;
        SkipHeaderSizeEdit.Text:=Inttostr(MaxX);
        If MaxY< FileSizeY then MaxY:=  FileSizeY;
        SkipHeaderSizeEdit2.Text:=Inttostr(MaxY);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       ColonLabel.Caption:=' : ';
       end;
    end;
  end;
end;

procedure THtfForm.SRTM1toBinBtnClick(Sender: TObject);
begin
  ODTerrainPack.Filter := 'SRTM files|*.hgt';
  ODTerrainPack.Filename := 'SRTM files.hgt';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    SetDefaultDEMProj;
    FileSizeX:= 3601;    XWidthEdit.Text:='3601';
    FileSizeY:=3601;     YHeightEdit.Text:='3601';
    PixelXSizeEdit.Text:= Floattostr(0.000277777777);{X Size 1AS}
    PixelYSizeEdit.Text:= Floattostr(0.000277777777);{Y Size 1AS}
    SourceCB.itemIndex:=15;  {15: 10M SRTM dem 16: 30M SRTM dem}
    DoSRTMtoBin(ODTerrainPack.Filename ,0);
  end;
end;
procedure THtfForm.SRTM1ListBtnClick(Sender: TObject);
var
  MaxX,MaxY,
 CountIn,CountAll:Integer;
 S : string;
 F: TextFile;
begin
  MaxX:=0;MaxY:=0;
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'SRTM files list (*.txt)|*.txt';
  ODTerrainPack.Filename:= 'graflist.txt';{graflist.txt}
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.TXT' then
    begin
      SetDefaultDEMProj;
    FileSizeX:= 3601;    XWidthEdit.Text:='3601';
    FileSizeY:=3601;     YHeightEdit.Text:='3601';
    PixelXSizeEdit.Text:= Floattostr(0.000277777777);{X Size 1AS}
    PixelYSizeEdit.Text:= Floattostr(0.000277777777);{Y Size 1AS}
    SourceCB.itemIndex:=15;  {15: 10M SRTM dem 16: 30M SRTM dem}
      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      CountIn:=0;
      CountAll:=0;
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountIn);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       end;

      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountAll);
        ReadWriteLabel.Caption:='Reading: ';
        ColonLabel.Caption:=' '+Inttostr(CountAll)+' of '+Inttostr(CountIn)+' : ';
        DemName.Caption:=S;
        If FileExists(S) then
           DoSRTMtoBin(S,1);
        If MaxX< FileSizeX then MaxX:= FileSizeX;
        SkipHeaderSizeEdit.Text:=Inttostr(MaxX);
        If MaxY< FileSizeY then MaxY:=  FileSizeY;
        SkipHeaderSizeEdit2.Text:=Inttostr(MaxY);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       ColonLabel.Caption:=' : ';
       DemName.Caption:='';
       end;
    end;
  end;
end;

procedure THtfForm.DoSRTMtoBin( InfileName:String; Config:Integer);
var
  ElevationCount: Smallint;
  yLat,xLon,
  Xcount, Zcount: Integer;
  Bin_File: file of Smallint;
  SrtmName,Lats,Lons:String;
begin  {no Header?}
  begin
    DemPath:=ExtractFilePath(InfileName);
    SrtmName:=ExtractFileName(InfileName);
    {N44W122.hgt}
    Lats:=Copy(SrtmName,2,2);
    Lons:=Copy(SrtmName,5,3);
      yLat:=Strtoint(Lats);
      If uppercase(SrtmName[1]) = 'S' then  yLat:= (yLat * -1);
      xLon:=Strtoint(Lons);
      If uppercase(SrtmName[4]) = 'W' then  xLon:= (xLon * -1);

    PixelCoordinateCB.ItemIndex:=1;
    {Filename: Lat Long of Lower Left corner: 1 degree tiles }
    TopLeftXEdit.Text:= Inttostr(xLon){'0'};
    TopLeftYEdit.Text:= Inttostr(yLat+1){'0'};
    TopRightXEdit.Text:= Inttostr(xLon-1);
    TopRightYEdit.Text:= Inttostr(yLat+1);
    BottomLeftXEdit.Text:= Inttostr(xLon);
    BottomLeftYEdit.Text:= Inttostr(yLat);
    BottomRightXEdit.Text:= Inttostr(xLon-1){'4320'};
    BottomRightYEdit.Text:=  Inttostr(yLat){'2160'};
    MapZUnitsCB.Itemindex:=2;{Meters}
    ProjectionCB.Itemindex:=0;  {Geo}
    PixelCoordinateCB.Itemindex:=0;{Center}
    InUtmZoneCB.Itemindex:=0;{=#16}
    UTMZoneNorthCB.Checked:=(yLat>0){True};
    IntegerorFloatCB.Checked:=True;{Integer}
    FloatingPointCB.Checked:=True;
    InUnitCB.Itemindex:=4; {D Degrees of arc}
    InDatumCB.Itemindex:=14;  {wgs84}
    SpheroidCB.Itemindex:=12;{wgs84}
    Application.ProcessMessages;

    AssignFile(Bin_File, InfileName);
    Reset(Bin_File);
    if (IoResult = 0) then
    begin
     { MaximumElevation := -2147483647;
      MinimumElevation := 2147483646;}
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      SetLength(ManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          Read(Bin_File, ElevationCount);
          ElevationCount := Swap(ElevationCount);
          If ElevationCount < -32760 then
          ElevationCount:=0;
          {if (MaximumElevation <= ElevationCount) then
              MaximumElevation := ElevationCount;
          if (MinimumElevation >= ElevationCount) then
             MinimumElevation := ElevationCount;  }
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
      CloseFile(Bin_File);
      if (IoResult <> 0) then DoMessages(25005);
    end else DoMessages(25006);
    Application.ProcessMessages;
    If (Config=0) then
    WriteTpcfgFile(ChangeFileExt(InfileName,'.bit'));
    WriteProjectionFile(ChangeFileExt(InfileName,'.bit'));
    WriteBitFile(ChangeFileExt(InfileName,'.bit'));

{    If FileSizeY=1201 then
       WriteBinFile(ODTerrainPack.FileName,15)
       else WriteBinFile(ODTerrainPack.FileName,16);}
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
  end;
end;

{USE the Projection data displayed to READ and WRITE a bit file}
procedure THtfForm.ProcessperProjectionDataClick(Sender: TObject);
var
  ElevationCount: Smallint;
  Xcount, Zcount: Integer;
  Bin_File: file of Smallint;
  DElevationCount: Double;
  Din_File: file of Double;
  DManMatrix:Array of Array of Double;
begin
  ODTerrainPack.Filter := 'Elevation data files|*.*';
  ODTerrainPack.Filename := '*.*';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    SetDefaultDEMProj;
    DemPath:=ExtractFilePath(ODTerrainPack.FileName);
    FileSizeX:= StrtoInt(XWidthEdit.Text);
    FileSizeY:=StrtoInt(YHeightEdit.Text);
    IntegerorFloatCB.Checked:=DemIntegerOrFloatCB.Checked;
    Application.ProcessMessages;
    If DemIntegerOrFloatCB.Checked then
    begin
    AssignFile(Bin_File, ODTerrainPack.FileName);
    Reset(Bin_File);
    if (IoResult = 0) then
    begin
     { MaximumElevation := -2147483647;
      MinimumElevation := 2147483646;}
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      If SkipHeaderCB.Checked then
      begin
        for Xcount := 0 to (Strtoint(SkipHeaderSizeEdit.Text) div 2) - 1 do
        begin
          Read(Bin_File, ElevationCount);
        end;
      end;
      SetLength(ManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          Read(Bin_File, ElevationCount);
          If (not (IntelIntegersCB.Checked)) then
              ElevationCount := Swap(ElevationCount);
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
      CloseFile(Bin_File);
    end;
    End else
    {These MUST be BINARY DOUBLEs}
    begin
    If (not (IntelIntegersCB.Checked)) then
    begin
      Showmessage('Cannot do Motorolla Doubles');
      Exit;
    end;
    AssignFile(Din_File, ODTerrainPack.FileName);
    Reset(Din_File);
    if (IoResult = 0) then
    begin
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      If SkipHeaderCB.Checked then
      begin
        for Xcount := 0 to (Strtoint(SkipHeaderSizeEdit.Text) div 8) - 1 do
        begin
          Read(Din_File, DElevationCount);
        end;
      end;
      SetLength(DManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          Read(Din_File, DElevationCount);
          {If (not (IntelIntegersCB.Checked)) then
              DElevationCount := Swap(DElevationCount);}
          DManMatrix[Xcount,Zcount]:=DElevationCount;
        end;
      end;
      CloseFile(Bin_File);
    end;
    end;
    {Should read the data from form...?}
    WriteProjectionFile(ODTerrainPack.FileName);
    WriteBitFile(ODTerrainPack.FileName);
    WriteTpcfgFile(ODTerrainPack.FileName);
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
  end;
end;
(*************************************************************)
(*************************************************************)
(*************************************************************)
(*************************************************************)
(*************************************************************)
(*************************************************************)
(*************************************************************)
(*************************************************************)
procedure THtfForm.CountryFipsCodeCBChange(Sender: TObject);
var temp:Integer;
begin
  temp:=CountryFipsCodeCB.ItemIndex;
  If (temp<151) then
        SetCountryFipsCode(temp,0,0)
   else SetCountryFipsCode2(temp,0,0);

  {CountryFipsCodeCB.ItemIndex}
  StateNameEdit.Text:='ZZ';
  StateFipsCodeEdit.Text:='00';
  CountyNameEdit.Text:='ZZ';
  CountyFipsCodeEdit.Text:='00';
  StateFipsCodeCB.ItemIndex:=0;
  CountyFipsCodeCB.ItemIndex:=0;
end;

{FIPS PUB 10-4
Supersedes FIPS PUB 10-3}
procedure THtfForm.SetCountryFipsCode(CountryIn,StateIn,CountyIn:Integer);
Begin
  If (CountryFipsCodeCB.ItemIndex<>CountryIn) then
    CountryFipsCodeCB.ItemIndex:=CountryIn;
  CountryFipsCodeEdit.Text:=Inttostr(CountryIn);
   {Set base for all}
  StateFipsCodeCB.Clear;
  StateFipsCodeCB.Items.add('00 : Unknown');

{IAW Country Code Set the Country data
AND Set the State Combobox items}
Case CountryIn of
000: Begin CountryNameEdit.Text:={ Unknown-}'ZZ';
     End;
001: Begin CountryNameEdit.Text:={Afghanistan-}'AF';
{AF     AFGHANISTAN province/velayat}
        StateFipsCodeCB.Items.add('AF01   Badakhshan');
        StateFipsCodeCB.Items.add('AF02   Badghis');
        StateFipsCodeCB.Items.add('AF03   Baghlan');
        StateFipsCodeCB.Items.add('AF30   Balkh');
        StateFipsCodeCB.Items.add('AF05   Bamian');
        StateFipsCodeCB.Items.add('AF06   Farah');
        StateFipsCodeCB.Items.add('AF07   Faryab');
        StateFipsCodeCB.Items.add('AF08   Ghazni');
        StateFipsCodeCB.Items.add('AF09   Ghowr    [Ghor]');
        StateFipsCodeCB.Items.add('AF10   Helmand');
        StateFipsCodeCB.Items.add('AF11   Herat');
        StateFipsCodeCB.Items.add('AF31   Jowzjan');
        StateFipsCodeCB.Items.add('AF13   Kabol');
        StateFipsCodeCB.Items.add('AF23   Kandahar  [Kandahar]');
        StateFipsCodeCB.Items.add('AF14   Kapisa');
        StateFipsCodeCB.Items.add('AF15   Konar');
        StateFipsCodeCB.Items.add('AF24   Kondoz   [Kunduz]');
        StateFipsCodeCB.Items.add('AF16   Laghman');
        StateFipsCodeCB.Items.add('AF17   Lowgar   [Logar]');
        StateFipsCodeCB.Items.add('AF18   Nangarhar');
        StateFipsCodeCB.Items.add('AF19   Nimruz   [Chakhansur]');
        StateFipsCodeCB.Items.add('AF20   Oruzgan  [Uruzgan]');
        StateFipsCodeCB.Items.add('AF21   Paktia');
        StateFipsCodeCB.Items.add('AF29   Paktika');
        StateFipsCodeCB.Items.add('AF22   Parvan   [Parwan]');
        StateFipsCodeCB.Items.add('AF32   Samangan');
        StateFipsCodeCB.Items.add('AF33   Sar-e Pol');
        StateFipsCodeCB.Items.add('AF26   Takhar');
        StateFipsCodeCB.Items.add('AF27   Vardak   [Warkak]');
        StateFipsCodeCB.Items.add('AF28   Zabol    [Zabul]');
     End;
002: Begin CountryNameEdit.Text:={Albania-}'AL';
{AL     ALBANIA  district/rreth}
        StateFipsCodeCB.Items.add('AL01   Berat');
        StateFipsCodeCB.Items.add('AL02   Dibre');
        StateFipsCodeCB.Items.add('AL03   Durres');
        StateFipsCodeCB.Items.add('AL04   Elbasan');
        StateFipsCodeCB.Items.add('AL05   Fier');
        StateFipsCodeCB.Items.add('AL06   Gjirokaster');
        StateFipsCodeCB.Items.add('AL07   Gramsh');
        StateFipsCodeCB.Items.add('AL08   Kolonje');
        StateFipsCodeCB.Items.add('AL09   Korce');
        StateFipsCodeCB.Items.add('AL10   Kruje');
        StateFipsCodeCB.Items.add('AL11   Kukes');
        StateFipsCodeCB.Items.add('AL12   Lezhe');
        StateFipsCodeCB.Items.add('AL13   Librazhd');
        StateFipsCodeCB.Items.add('AL14   Lushnje');
        StateFipsCodeCB.Items.add('AL15   Mat');
        StateFipsCodeCB.Items.add('AL16   Mirdite');
        StateFipsCodeCB.Items.add('AL17   Permet');
        StateFipsCodeCB.Items.add('AL18   Pogradec');
        StateFipsCodeCB.Items.add('AL19   Puke');
        StateFipsCodeCB.Items.add('AL20   Sarande');
        StateFipsCodeCB.Items.add('AL21   Shkoder');
        StateFipsCodeCB.Items.add('AL22   Skrapar');
        StateFipsCodeCB.Items.add('AL23   Tepelene');
        StateFipsCodeCB.Items.add('AL28   Tirane');
        StateFipsCodeCB.Items.add('AL26   Tropoje');
        StateFipsCodeCB.Items.add('AL27   Vlore');
     End;
003: Begin CountryNameEdit.Text:={Algeria-}'AG';
{AG     ALGERIA  province/wilaya}
        StateFipsCodeCB.Items.add('AG34   Adrar');
        StateFipsCodeCB.Items.add('AG35   Ain Defla');
        StateFipsCodeCB.Items.add('AG36   Ain Temouchent');
        StateFipsCodeCB.Items.add('AG01   Alger');
        StateFipsCodeCB.Items.add('AG37   Annaba');
        StateFipsCodeCB.Items.add('AG03   Batna');
        StateFipsCodeCB.Items.add('AG38   Bechar');
        StateFipsCodeCB.Items.add('AG18   Bejaia');
        StateFipsCodeCB.Items.add('AG19   Biskra');
        StateFipsCodeCB.Items.add('AG20   Blida');
        StateFipsCodeCB.Items.add('AG39   Bordj Bou Arreridj');
        StateFipsCodeCB.Items.add('AG21   Bouira');
        StateFipsCodeCB.Items.add('AG40   Boumerdes');
        StateFipsCodeCB.Items.add('AG04   Constantine');
        StateFipsCodeCB.Items.add('AG22   Djelfa');
        StateFipsCodeCB.Items.add('AG41   Chlef');
        StateFipsCodeCB.Items.add('AG42   El Bayadh');
        StateFipsCodeCB.Items.add('AG43   El Oued');
        StateFipsCodeCB.Items.add('AG44   El Tarf');
        StateFipsCodeCB.Items.add('AG45   Ghardaia');
        StateFipsCodeCB.Items.add('AG23   Guelma');
        StateFipsCodeCB.Items.add('AG46   Illizi');
        StateFipsCodeCB.Items.add('AG24   Jijel');
        StateFipsCodeCB.Items.add('AG47   Khenchela');
        StateFipsCodeCB.Items.add('AG25   Laghouat');
        StateFipsCodeCB.Items.add('AG26   Mascara');
        StateFipsCodeCB.Items.add('AG06   Medea');
        StateFipsCodeCB.Items.add('AG48   Mila');
        StateFipsCodeCB.Items.add('AG07   Mostaganem');
        StateFipsCodeCB.Items.add('AG27   M`sila');
        StateFipsCodeCB.Items.add('AG49   Naama');
        StateFipsCodeCB.Items.add('AG09   Oran');
        StateFipsCodeCB.Items.add('AG50   Ouargla');
        StateFipsCodeCB.Items.add('AG29   Oum el Bouaghi');
        StateFipsCodeCB.Items.add('AG51   Relizane');
        StateFipsCodeCB.Items.add('AG10   Saida');
        StateFipsCodeCB.Items.add('AG12   Setif');
        StateFipsCodeCB.Items.add('AG30   Sidi Bel Abbes');
        StateFipsCodeCB.Items.add('AG31   Skikda');
        StateFipsCodeCB.Items.add('AG52   Souk Ahras');
        StateFipsCodeCB.Items.add('AG53   Tamanghasset');
        StateFipsCodeCB.Items.add('AG33   Tebessa');
        StateFipsCodeCB.Items.add('AG13   Tiaret');
        StateFipsCodeCB.Items.add('AG54   Tindouf');
        StateFipsCodeCB.Items.add('AG55   Tipaza');
        StateFipsCodeCB.Items.add('AG56   Tissemsilt');
        StateFipsCodeCB.Items.add('AG14   Tizi Ouzou');
        StateFipsCodeCB.Items.add('AG15   Tlemcen');
     End;
004: Begin CountryNameEdit.Text:={American Samoa-}'AQ';
{AQ     AMERICAN SAMOA}
     End;
005: Begin CountryNameEdit.Text:={Andorra-}'AN';
{AN     ANDORRA  parish/parroquia }
        StateFipsCodeCB.Items.add('AN01   Andorra');
        StateFipsCodeCB.Items.add('AN02   Canillo');
        StateFipsCodeCB.Items.add('AN03   Encamp');
        StateFipsCodeCB.Items.add('AN04   La Massana');
        StateFipsCodeCB.Items.add('AN05   Ordino');
        StateFipsCodeCB.Items.add('AN06   Sant Julia de Loria');
     End;
006: Begin CountryNameEdit.Text:={Angola-}'AO';
{AO     ANGOLA  province/provincia}
        StateFipsCodeCB.Items.add('AO19   Bengo');
        StateFipsCodeCB.Items.add('AO01   Benguela');
        StateFipsCodeCB.Items.add('AO02   Bie');
        StateFipsCodeCB.Items.add('AO03   Cabinda');
        StateFipsCodeCB.Items.add('AO04   Cuando Cubango');
        StateFipsCodeCB.Items.add('AO05   Cuanza Norte');
        StateFipsCodeCB.Items.add('AO06   Cuanza Sul');
        StateFipsCodeCB.Items.add('AO07   Cunene');
        StateFipsCodeCB.Items.add('AO09   Huila');
        StateFipsCodeCB.Items.add('AO20   Luanda');
        StateFipsCodeCB.Items.add('AO17   Lunda Norte');
        StateFipsCodeCB.Items.add('AO18   Lunda Sul');
        StateFipsCodeCB.Items.add('AO12   Malanje');
        StateFipsCodeCB.Items.add('AO14   Moxico');
        StateFipsCodeCB.Items.add('A013   Namibe');
        StateFipsCodeCB.Items.add('AO15   Uige');
        StateFipsCodeCB.Items.add('AO16   Zaire');
     End;
007: Begin CountryNameEdit.Text:={Anguilla-}'AV';
{AV     ANGUILLA}
     End;
008: Begin CountryNameEdit.Text:={Antarctica-}'AY';
{AY     ANTARCTICA}
     End;
009: Begin CountryNameEdit.Text:={Antigua and Barbuda-}'AC';
{AC     ANTIGUA AND BARBUDA  parish}
        StateFipsCodeCB.Items.add('AC01   Barbuda');
        StateFipsCodeCB.Items.add('AC03   Saint George');
        StateFipsCodeCB.Items.add('AC04   Saint John');
        StateFipsCodeCB.Items.add('AC05   Saint Mary');
        StateFipsCodeCB.Items.add('AC06   Saint Paul');
        StateFipsCodeCB.Items.add('AC07   Saint Peter');
        StateFipsCodeCB.Items.add('AC08   Saint Philip');
     End;
010: Begin CountryNameEdit.Text:={Argentina-}'AR';
{AR     ARGENTINA **district/distrito
*national territory/territorio nacional  province/provincia}
        StateFipsCodeCB.Items.add('AR01   Buenos Aires');
        StateFipsCodeCB.Items.add('AR02   Catamarca');
        StateFipsCodeCB.Items.add('AR03   Chaco');
        StateFipsCodeCB.Items.add('AR04   Chubut');
        StateFipsCodeCB.Items.add('AR05   Cordoba');
        StateFipsCodeCB.Items.add('AR06   Corrientes');
        StateFipsCodeCB.Items.add('AR07   Distrito Federal**');
        StateFipsCodeCB.Items.add('AR08   Entre Rios');
        StateFipsCodeCB.Items.add('AR09   Formosa');
        StateFipsCodeCB.Items.add('AR10   Jujuy');
        StateFipsCodeCB.Items.add('AR11   La Pampa');
        StateFipsCodeCB.Items.add('AR12   La Rioja');
        StateFipsCodeCB.Items.add('AR13   Mendoza');
        StateFipsCodeCB.Items.add('AR14   Misiones');
        StateFipsCodeCB.Items.add('AR15   Neuquen');
        StateFipsCodeCB.Items.add('AR16   Rio Negro');
        StateFipsCodeCB.Items.add('AR17   Salta');
        StateFipsCodeCB.Items.add('AR18   San Juan');
        StateFipsCodeCB.Items.add('AR19   San Luis');
        StateFipsCodeCB.Items.add('AR20   Santa Cruz');
        StateFipsCodeCB.Items.add('AR21   Santa Fe');
        StateFipsCodeCB.Items.add('AR22   Santiago del Estero');
        StateFipsCodeCB.Items.add('AR23   Tierra del Fuego, Antartida e Islas del Atlantico Sur*');
        StateFipsCodeCB.Items.add('AR24   Tucuman');
     End;
011: Begin CountryNameEdit.Text:={Armenia-}'AM';
{AM     ARMENIA}
     End;
012: Begin CountryNameEdit.Text:={Aruba-}'AA';
{AA     ARUBA}
     End;
013: Begin CountryNameEdit.Text:={Ashmore and Cartier Islands-}'AT';
{AT     ASHMORE AND CARTIER ISLANDS}
     End;
014: Begin CountryNameEdit.Text:={Australia-}'AS';
{AS     AUSTRALIA state *territory}
        StateFipsCodeCB.Items.add('AS01   Australian Capital Territory*');
        StateFipsCodeCB.Items.add('AS02   New South Wales');
        StateFipsCodeCB.Items.add('AS03   Northern Territory*');
        StateFipsCodeCB.Items.add('AS04   Queensland');
        StateFipsCodeCB.Items.add('AS05   South Australia');
        StateFipsCodeCB.Items.add('AS06   Tasmania');
        StateFipsCodeCB.Items.add('AS07   Victoria');
        StateFipsCodeCB.Items.add('AS08   Western Australia');
     End;
015: Begin CountryNameEdit.Text:={Austria-}'AU';
{AU     AUSTRIA  state/bundesland}
        StateFipsCodeCB.Items.add('AU01   Burgenland');
        StateFipsCodeCB.Items.add('AU02   Karnten');
        StateFipsCodeCB.Items.add('AU03   Niederosterreich');
        StateFipsCodeCB.Items.add('AU04   Oberosterreich');
        StateFipsCodeCB.Items.add('AU05   Salzburg');
        StateFipsCodeCB.Items.add('AU06   Steiermark');
        StateFipsCodeCB.Items.add('AU07   Tirol');
        StateFipsCodeCB.Items.add('AU08   Vorarlberg');
        StateFipsCodeCB.Items.add('AU09   Wien');
     End;
016: Begin CountryNameEdit.Text:={Azerbaijan-}'AJ';
{AJ     AZERBAIJAN}
     End;
017: Begin CountryNameEdit.Text:={Bahamas, The-}'BF';
{BF     BAHAMAS, THE district}
        StateFipsCodeCB.Items.add('BF24   Acklins and Crooked Islands');
        StateFipsCodeCB.Items.add('BF05   Bimini');
        StateFipsCodeCB.Items.add('BF06   Cat Island');
        StateFipsCodeCB.Items.add('BF10   Exuma');
        StateFipsCodeCB.Items.add('BF25   Freeport');
        StateFipsCodeCB.Items.add('BF26   Fresh Creek');
        StateFipsCodeCB.Items.add('BF27   Governor`s Harbour');
        StateFipsCodeCB.Items.add('BF28   Green Turtle Cay');
        StateFipsCodeCB.Items.add('BF22   Harbour Island');
        StateFipsCodeCB.Items.add('BF29   High Rock');
        StateFipsCodeCB.Items.add('BF13   Inagua');
        StateFipsCodeCB.Items.add('BF30   Kemps Bay');
        StateFipsCodeCB.Items.add('BF15   Long Island');
        StateFipsCodeCB.Items.add('BF31   Marsh Harbour');
        StateFipsCodeCB.Items.add('BF16   Mayaguana');
        StateFipsCodeCB.Items.add('BF23   New Providence');
        StateFipsCodeCB.Items.add('BF32   Nichollstown and Berry Islands');
        StateFipsCodeCB.Items.add('BF18   Ragged Island');
        StateFipsCodeCB.Items.add('BF33   Rock Sound');
        StateFipsCodeCB.Items.add('BF34   Sandy Point');
        StateFipsCodeCB.Items.add('BF35   San Salvador and Rum Cay');
    End;
018: Begin CountryNameEdit.Text:={Bahrain-}'BA';
{BA     BAHRAIN  municipality}
        StateFipsCodeCB.Items.add('BA01   Al Hadd');
        StateFipsCodeCB.Items.add('BA02   Al Manamah');
        StateFipsCodeCB.Items.add('BA08   Al Mintaqah al Gharbiyah');
        StateFipsCodeCB.Items.add('BA11   Al Mintaqah al Wusta');
        StateFipsCodeCB.Items.add('BA10   Al Mintaqah ash Shamaliyah');
        StateFipsCodeCB.Items.add('BA03   Al Muharraq');
        StateFipsCodeCB.Items.add('BA13   Ar Rifa` wa al Mintaqah al Janubiyah');
        StateFipsCodeCB.Items.add('BA05   Jidd Hafs');
        StateFipsCodeCB.Items.add('BA14   Madinat Hamad');
        StateFipsCodeCB.Items.add('BA12   Madinat `Isa');
        StateFipsCodeCB.Items.add('BA09   Mintaqat Juzur Hawar');
        StateFipsCodeCB.Items.add('BA06   Sitrah');
     End;
019: Begin CountryNameEdit.Text:={Baker Island-}'FQ';
{FQ     BAKER ISLAND}
     End;
020: Begin CountryNameEdit.Text:={Bangladesh-}'BG';
{BG     BANGLADESH  district}
        StateFipsCodeCB.Items.add('BG22   Bagerhat');
        StateFipsCodeCB.Items.add('BG04   Bandarban');
        StateFipsCodeCB.Items.add('BG25   Barguna');
        StateFipsCodeCB.Items.add('BG01   Barisal');
        StateFipsCodeCB.Items.add('BG23   Bhola');
        StateFipsCodeCB.Items.add('BG24   Bogra');
        StateFipsCodeCB.Items.add('BG26   Brahmanbaria');
        StateFipsCodeCB.Items.add('BG27   Chandpur');
        StateFipsCodeCB.Items.add('BG28   Chapai Nawabganj');
        StateFipsCodeCB.Items.add('BG29   Chattagram');
        StateFipsCodeCB.Items.add('BG30   Chuadanga');
        StateFipsCodeCB.Items.add('BG05   Comilla');
        StateFipsCodeCB.Items.add('BG31   Cox`s Bazar');
        StateFipsCodeCB.Items.add('BG32   Dhaka');
        StateFipsCodeCB.Items.add('BG33   Dinajpur');
        StateFipsCodeCB.Items.add('BG34   Faridpur');
        StateFipsCodeCB.Items.add('BG35   Feni');
        StateFipsCodeCB.Items.add('BG36   Gaibandha');
        StateFipsCodeCB.Items.add('BG37   Gazipur');
        StateFipsCodeCB.Items.add('BG38   Gopalganj');
        StateFipsCodeCB.Items.add('BG39   Habiganj');
        StateFipsCodeCB.Items.add('BG40   Jaipurhat');
        StateFipsCodeCB.Items.add('BG41   Jamalpur');
        StateFipsCodeCB.Items.add('BG42   Jessore');
        StateFipsCodeCB.Items.add('BG43   Jhalakati');
        StateFipsCodeCB.Items.add('BG44   Jhenaidah');
        StateFipsCodeCB.Items.add('BG45   Khagrachari');
        StateFipsCodeCB.Items.add('BG46   Khulna');
        StateFipsCodeCB.Items.add('BG47   Kishorganj');
        StateFipsCodeCB.Items.add('BG48   Kurigram');
        StateFipsCodeCB.Items.add('BG49   Kushtia');
        StateFipsCodeCB.Items.add('BG50   Laksmipur');
        StateFipsCodeCB.Items.add('BG51   Lalmonirhat');
        StateFipsCodeCB.Items.add('BG52   Madaripur');
        StateFipsCodeCB.Items.add('BG53   Magura');
        StateFipsCodeCB.Items.add('BG54   Manikganj');
        StateFipsCodeCB.Items.add('BG55   Meherpur');
        StateFipsCodeCB.Items.add('BG56   Moulavibazar');
        StateFipsCodeCB.Items.add('BG57   Munshiganj');
        StateFipsCodeCB.Items.add('BG12   Mymensingh');
        StateFipsCodeCB.Items.add('BG58   Naogaon');
        StateFipsCodeCB.Items.add('BG59   Narail');
        StateFipsCodeCB.Items.add('BG60   Narayanganj');
        StateFipsCodeCB.Items.add('BG61   Narsingdi');
        StateFipsCodeCB.Items.add('BG62   Nator');
        StateFipsCodeCB.Items.add('BG63   Netrakona');
        StateFipsCodeCB.Items.add('BG64   Nilphamari');
        StateFipsCodeCB.Items.add('BG13   Noakhali');
        StateFipsCodeCB.Items.add('BG65   Pabna');
        StateFipsCodeCB.Items.add('BG66   Panchagar');
        StateFipsCodeCB.Items.add('BG67   Parbattya Chattagram');
        StateFipsCodeCB.Items.add('BG15   Patuakhali');
        StateFipsCodeCB.Items.add('BG68   Pirojpur');
        StateFipsCodeCB.Items.add('BG69   Rajbari');
        StateFipsCodeCB.Items.add('BG70   Rajshahi');
        StateFipsCodeCB.Items.add('BG71   Rangpur');
        StateFipsCodeCB.Items.add('BG72   Satkhira');
        StateFipsCodeCB.Items.add('BG73   Shariyatpur');
        StateFipsCodeCB.Items.add('BG74   Sherpur');
        StateFipsCodeCB.Items.add('BG75   Sirajganj');
        StateFipsCodeCB.Items.add('BG76   Sunamganj');
        StateFipsCodeCB.Items.add('BG77   Sylhet');
        StateFipsCodeCB.Items.add('BG78   Tangail');
        StateFipsCodeCB.Items.add('BG79   Thakurgaon');
     End;
021: Begin CountryNameEdit.Text:={Barbados-}'BB';
{BB     BARBADOS    parish}
        StateFipsCodeCB.Items.add('BB01   Christ Church');
        StateFipsCodeCB.Items.add('BB02   Saint Andrew');
        StateFipsCodeCB.Items.add('BB03   Saint George');
        StateFipsCodeCB.Items.add('BB04   Saint James');
        StateFipsCodeCB.Items.add('BB05   Saint John');
        StateFipsCodeCB.Items.add('BB06   Saint Joseph');
        StateFipsCodeCB.Items.add('BB07   Saint Lucy');
        StateFipsCodeCB.Items.add('BB08   Saint Michael');
        StateFipsCodeCB.Items.add('BB09   Saint Peter');
        StateFipsCodeCB.Items.add('BB10   Saint Philip');
        StateFipsCodeCB.Items.add('BB11   Saint Thomas');
     End;
022: Begin CountryNameEdit.Text:={Bassas Da India-}'BS';
{BS     BASSAS DA INDIA}
     End;
023: Begin CountryNameEdit.Text:={Belarus-}'BO';
{BO     BELARUS}
     End;
024: Begin CountryNameEdit.Text:={Belgium-}'BE';
{BE     BELGIUM        province/province(French),provincie (Flemish)}
        StateFipsCodeCB.Items.add('BE01   Antwerpen');
        StateFipsCodeCB.Items.add('BE02   Brabant');
        StateFipsCodeCB.Items.add('BE03   Hainaut');
        StateFipsCodeCB.Items.add('BE04   Liege');
        StateFipsCodeCB.Items.add('BE05   Limburg');
        StateFipsCodeCB.Items.add('BE06   Luxembourg');
        StateFipsCodeCB.Items.add('BE07   Namur');
        StateFipsCodeCB.Items.add('BE08   Oost-Vlaanderen');
        StateFipsCodeCB.Items.add('BE09   West-Vlaanderen');
    End;
025: Begin CountryNameEdit.Text:={Belize-}'BH';
{BH     BELIZE district}
        StateFipsCodeCB.Items.add('BH01   Belize');
        StateFipsCodeCB.Items.add('BH02   Cayo');
        StateFipsCodeCB.Items.add('BH03   Corozal');
        StateFipsCodeCB.Items.add('BH04   Orange Walk');
        StateFipsCodeCB.Items.add('BH05   Stann Creek');
        StateFipsCodeCB.Items.add('BH06   Toledo');
     End;
026: Begin CountryNameEdit.Text:={Benin-}'BN';
{BN     BENIN province}
        StateFipsCodeCB.Items.add('BN01   Atakora');
        StateFipsCodeCB.Items.add('BN02   Atlantique');
        StateFipsCodeCB.Items.add('BN03   Borgou');
        StateFipsCodeCB.Items.add('BN04   Mono');
        StateFipsCodeCB.Items.add('BN05   Oueme');
        StateFipsCodeCB.Items.add('BN06   Zou');
     End;
027: Begin CountryNameEdit.Text:={Bermuda-}'BD';
{BD     BERMUDA  *municipality  parish}
        StateFipsCodeCB.Items.add('BD01   Devonshire');
        StateFipsCodeCB.Items.add('BD02   Hamilton');
        StateFipsCodeCB.Items.add('BD03   Hamilton*');
        StateFipsCodeCB.Items.add('BD04   Paget');
        StateFipsCodeCB.Items.add('BD05   Pembroke');
        StateFipsCodeCB.Items.add('BD06   Saint George*');
        StateFipsCodeCB.Items.add('BD07   Saint George`s');
        StateFipsCodeCB.Items.add('BD08   Sandys');
        StateFipsCodeCB.Items.add('BD09   Smiths');
        StateFipsCodeCB.Items.add('BD10   Southampton');
        StateFipsCodeCB.Items.add('BD11   Warwick');
     End;
028: Begin CountryNameEdit.Text:={Bhutan-}'BT';
{BT     BHUTAN         district/dzongkhag}
        StateFipsCodeCB.Items.add('BT05   Bumthang');
        StateFipsCodeCB.Items.add('BT06   Chhukha');
        StateFipsCodeCB.Items.add('BT07   Chirang');
        StateFipsCodeCB.Items.add('BT08   Daga');
        StateFipsCodeCB.Items.add('BT09   Geylegphug');
        StateFipsCodeCB.Items.add('BT10   Ha');
        StateFipsCodeCB.Items.add('BT11   Lhuntshi');
        StateFipsCodeCB.Items.add('BT12   Mongar');
        StateFipsCodeCB.Items.add('BT13   Paro');
        StateFipsCodeCB.Items.add('BT14   Pemagatsel');
        StateFipsCodeCB.Items.add('BT15   Punakha');
        StateFipsCodeCB.Items.add('BT16   Samchi');
        StateFipsCodeCB.Items.add('BT17   Samdrup');
        StateFipsCodeCB.Items.add('BT18   Shemgang');
        StateFipsCodeCB.Items.add('BT19   Tashigang');
        StateFipsCodeCB.Items.add('BT20   Thimphu');
        StateFipsCodeCB.Items.add('BT21   Tongsa');
        StateFipsCodeCB.Items.add('BT22   Wangdi Phodrang');
     End;
029: Begin CountryNameEdit.Text:={Bolivia-}'BL';
{BL     BOLIVIA  department/departamento}
        StateFipsCodeCB.Items.add('BL01   Chuquisaca');
        StateFipsCodeCB.Items.add('BL02   Cochabamba');
        StateFipsCodeCB.Items.add('BL03   El Beni');
        StateFipsCodeCB.Items.add('BL04   La Paz');
        StateFipsCodeCB.Items.add('BL05   Oruro');
        StateFipsCodeCB.Items.add('BL06   Pando');
        StateFipsCodeCB.Items.add('BL07   Potosi');
        StateFipsCodeCB.Items.add('BL08   Santa Cruz');
        StateFipsCodeCB.Items.add('BL09   Tarija');
     End;
030: Begin CountryNameEdit.Text:={Bosnia and Herzegovina-}'BK';
{BK     BOSNIA AND HERZEGOVINA}
     End;
031: Begin CountryNameEdit.Text:={Botswana-}'BC';
{BC     BOTSWANA  district}
        StateFipsCodeCB.Items.add('BC01   Central');
        StateFipsCodeCB.Items.add('BC02   Chobe');
        StateFipsCodeCB.Items.add('BC03   Ghanzi');
        StateFipsCodeCB.Items.add('BC04   Kgalagadi');
        StateFipsCodeCB.Items.add('BC05   Kgatleng');
        StateFipsCodeCB.Items.add('BC06   Kweneng');
        StateFipsCodeCB.Items.add('BC07   Ngamiland');
        StateFipsCodeCB.Items.add('BC08   North-East');
        StateFipsCodeCB.Items.add('BC09   South-East');
        StateFipsCodeCB.Items.add('BC10   Southern');
    End;
032: Begin CountryNameEdit.Text:={Bouvet Island-}'BV';
{BV     BOUVET ISLAND}
     End;
033: Begin CountryNameEdit.Text:={Brazil-}'BR';
{BR     BRAZIL   **federal district/distrito federal
state/estado *territory/territorio}
        StateFipsCodeCB.Items.add('BR01   Acre');
        StateFipsCodeCB.Items.add('BR02   Alagoas');
        StateFipsCodeCB.Items.add('BR03   Amapa*');
        StateFipsCodeCB.Items.add('BR04   Amazonas');
        StateFipsCodeCB.Items.add('BR05   Bahia');
        StateFipsCodeCB.Items.add('BR06   Ceara');
        StateFipsCodeCB.Items.add('BR07   Distrito Federal**');
        StateFipsCodeCB.Items.add('BR08   Espirito Santo');
        StateFipsCodeCB.Items.add('BR29   Goias');
        StateFipsCodeCB.Items.add('BR13   Maranhao');
        StateFipsCodeCB.Items.add('BR14   Mato Grosso');
        StateFipsCodeCB.Items.add('BR11   Mato Grosso do Sul');
        StateFipsCodeCB.Items.add('BR15   Minas Gerais');
        StateFipsCodeCB.Items.add('BR16   Para');
        StateFipsCodeCB.Items.add('BR17   Paraiba');
        StateFipsCodeCB.Items.add('BR18   Parana');
        StateFipsCodeCB.Items.add('BR30   Pernambuco');
        StateFipsCodeCB.Items.add('BR20   Piaui');
        StateFipsCodeCB.Items.add('BR21   Rio de Janeiro');
        StateFipsCodeCB.Items.add('BR22   Rio Grande do Norte');
        StateFipsCodeCB.Items.add('BR23   Rio Grande do Sul');
        StateFipsCodeCB.Items.add('BR24   Rondonia');
        StateFipsCodeCB.Items.add('BR25   Roraima*');
        StateFipsCodeCB.Items.add('BR26   Santa Catarina');
        StateFipsCodeCB.Items.add('BR27   Sao Paulo');
        StateFipsCodeCB.Items.add('BR28   Sergipe');
        StateFipsCodeCB.Items.add('BR31   Tocantins');
     End;
034: Begin CountryNameEdit.Text:={British Indian Ocean Territory-}'IO';
{IO     BRITISH INDIAN OCEAN TERRITORY}
     End;
035: Begin CountryNameEdit.Text:={British Virgin Islands-}'VI';
{VI     BRITISH VIRGIN ISLANDS}
     End;
036: Begin CountryNameEdit.Text:={Brunei-}'BX';
{BX     BRUNEI  district}
        StateFipsCodeCB.Items.add('BX01   Belait');
        StateFipsCodeCB.Items.add('BX02   Brunei and Muara');
        StateFipsCodeCB.Items.add('BX03   Temburong');
        StateFipsCodeCB.Items.add('BX04   Tutong');
     End;
037: Begin CountryNameEdit.Text:={Bulgaria-}'BU';
{BU     BULGARIA  province/oblast }
        StateFipsCodeCB.Items.add('BU29   Burgas');
        StateFipsCodeCB.Items.add('BU30   Grad Sofiya');
        StateFipsCodeCB.Items.add('BU31   Khaskovo');
        StateFipsCodeCB.Items.add('BU32   Lovech');
        StateFipsCodeCB.Items.add('BU33   Mikhaylovgrad');
        StateFipsCodeCB.Items.add('BU34   Plovdiv');
        StateFipsCodeCB.Items.add('BU35   Razgrad');
        StateFipsCodeCB.Items.add('BU36   Sofiya');
        StateFipsCodeCB.Items.add('BU37   Varna');
     End;
038: Begin CountryNameEdit.Text:={Burkina Faso-}'UV';
{UV     BURKINA   province/province}
        StateFipsCodeCB.Items.add('UV15   Bam');
        StateFipsCodeCB.Items.add('UV16   Bazega');
        StateFipsCodeCB.Items.add('UV17   Bougouriba');
        StateFipsCodeCB.Items.add('UV18   Boulgou');
        StateFipsCodeCB.Items.add('UV19   Boulkiemde');
        StateFipsCodeCB.Items.add('UV20   Ganzourgou');
        StateFipsCodeCB.Items.add('UV21   Gnagna');
        StateFipsCodeCB.Items.add('UV22   Gourma');
        StateFipsCodeCB.Items.add('UV23   Houet');
        StateFipsCodeCB.Items.add('UV24   Kadiogo');
        StateFipsCodeCB.Items.add('UV25   Kenedougou');
        StateFipsCodeCB.Items.add('UV26   Komoe');
        StateFipsCodeCB.Items.add('UV27   Kossi');
        StateFipsCodeCB.Items.add('UV28   Kouritenga');
        StateFipsCodeCB.Items.add('UV29   Mouhoun');
        StateFipsCodeCB.Items.add('UV30   Namentenga');
        StateFipsCodeCB.Items.add('UV31   Naouri');
        StateFipsCodeCB.Items.add('UV32   Oubritenga');
        StateFipsCodeCB.Items.add('UV33   Oudalan');
        StateFipsCodeCB.Items.add('UV34   Passore');
        StateFipsCodeCB.Items.add('UV35   Poni');
        StateFipsCodeCB.Items.add('UV36   Sanguie');
        StateFipsCodeCB.Items.add('UV37   Sanmatenga');
        StateFipsCodeCB.Items.add('UV38   Seno');
        StateFipsCodeCB.Items.add('UV39   Sissili');
        StateFipsCodeCB.Items.add('UV40   Soum');
        StateFipsCodeCB.Items.add('UV41   Sourou');
        StateFipsCodeCB.Items.add('UV42   Tapoa');
        StateFipsCodeCB.Items.add('UV43   Yatenga');
        StateFipsCodeCB.Items.add('UV44   Zoundweogo');
     End;
039: Begin CountryNameEdit.Text:={Burma-}'BM';{-myanmar}
{BM     BURMA      *division  state}
        StateFipsCodeCB.Items.add('BM02   Chin State');
        StateFipsCodeCB.Items.add('BM03   Irrawaddy*');
        StateFipsCodeCB.Items.add('BM04   Kachin State');
        StateFipsCodeCB.Items.add('BM05   Karan State');
        StateFipsCodeCB.Items.add('BM06   Kayah State');
        StateFipsCodeCB.Items.add('BM07   Magwe*');
        StateFipsCodeCB.Items.add('BM08   Mandalay*');
        StateFipsCodeCB.Items.add('BM13   Mon State');
        StateFipsCodeCB.Items.add('BM09   Pegu*');
        StateFipsCodeCB.Items.add('BM01   Rakhine State');
        StateFipsCodeCB.Items.add('BM14   Rangoon*');
        StateFipsCodeCB.Items.add('BM10   Sagaing*');
        StateFipsCodeCB.Items.add('BM11   Shan State');
        StateFipsCodeCB.Items.add('BM12   Tenasserim*');
    End;
040: Begin CountryNameEdit.Text:={Burundi-}'BY';
{BY     BURUNDI  province}
        StateFipsCodeCB.Items.add('BY09   Bubanza');
        StateFipsCodeCB.Items.add('BY02   Bujumbura');
        StateFipsCodeCB.Items.add('BY10   Bururi');
        StateFipsCodeCB.Items.add('BY11   Cankuzo');
        StateFipsCodeCB.Items.add('BY12   Cibitoke');
        StateFipsCodeCB.Items.add('BY13   Gitega');
        StateFipsCodeCB.Items.add('BY14   Karuzi');
        StateFipsCodeCB.Items.add('BY15   Kayanza');
        StateFipsCodeCB.Items.add('BY16   Kirundo');
        StateFipsCodeCB.Items.add('BY17   Makamba');
        StateFipsCodeCB.Items.add('BY05   Muramvya');
        StateFipsCodeCB.Items.add('BY18   Muyinga');
        StateFipsCodeCB.Items.add('BY19   Ngozi');
        StateFipsCodeCB.Items.add('BY20   Rutana');
        StateFipsCodeCB.Items.add('BY21   Ruyigi');
     End;
041: Begin CountryNameEdit.Text:={Cambodia-}'CB';
{CB     CAMBODIA *autonomous municipality province/khet}
        StateFipsCodeCB.Items.add('CB01   Batdambang');
        StateFipsCodeCB.Items.add('CB02   Kampong Cham');
        StateFipsCodeCB.Items.add('CB03   Kampong Chhnang');
        StateFipsCodeCB.Items.add('CB04   Kampong Spoe');
        StateFipsCodeCB.Items.add('CB05   Kampong Thum');
        StateFipsCodeCB.Items.add('CB06   Kampot');
        StateFipsCodeCB.Items.add('CB07   Kandal');
        StateFipsCodeCB.Items.add('CB08   Kaoh Kong');
        StateFipsCodeCB.Items.add('CB09   Kracheh');
        StateFipsCodeCB.Items.add('CB10   Mondol Kiri');
        StateFipsCodeCB.Items.add('CB11   Phnum Penh*');
        StateFipsCodeCB.Items.add('CB12   Pouthisat');
        StateFipsCodeCB.Items.add('CB13   Preah Vihear');
        StateFipsCodeCB.Items.add('CB14   Prey Veng');
        StateFipsCodeCB.Items.add('CB15   Rotanokiri');
        StateFipsCodeCB.Items.add('CB16   Siemreab-Otdar Meanchey');
        StateFipsCodeCB.Items.add('CB17   Stoeng Treng');
        StateFipsCodeCB.Items.add('CB18   Svay Rieng');
        StateFipsCodeCB.Items.add('CB19   Takev');
    End;
042: Begin CountryNameEdit.Text:={Cameroon-}'CM';
{CM     CAMEROON province}
        StateFipsCodeCB.Items.add('CM10   Adamaoua');
        StateFipsCodeCB.Items.add('CM11   Centre');
        StateFipsCodeCB.Items.add('CM04   Est               (East)');
        StateFipsCodeCB.Items.add('CM12   Extreme-Nord      (Far North)');
        StateFipsCodeCB.Items.add('CM05   Littoral');
        StateFipsCodeCB.Items.add('CM13   Nord              (North)');
        StateFipsCodeCB.Items.add('CM07   Nord-Ouest        (North-west)');
        StateFipsCodeCB.Items.add('CM08   Ouest             (West)');
        StateFipsCodeCB.Items.add('CM14   Sud               (South)');
        StateFipsCodeCB.Items.add('CM09   Sud-Ouest         (South-west)');
     End;
043: Begin CountryNameEdit.Text:={Canada-}'CA';
{CA     CANADA  province  *territory }
        StateFipsCodeCB.Items.add('CA01   Alberta');
        StateFipsCodeCB.Items.add('CA02   British Columbia');
        StateFipsCodeCB.Items.add('CA03   Manitoba');
        StateFipsCodeCB.Items.add('CA04   New Brunswick');
        StateFipsCodeCB.Items.add('CA05   Newfoundland');
        StateFipsCodeCB.Items.add('CA06   Northwest Territories*');
        StateFipsCodeCB.Items.add('CA07   Nova Scotia');
        StateFipsCodeCB.Items.add('CA08   Ontario');
        StateFipsCodeCB.Items.add('CA09   Prince Edward Island');
        StateFipsCodeCB.Items.add('CA10   Quebec');
        StateFipsCodeCB.Items.add('CA11   Saskatchewan');
        StateFipsCodeCB.Items.add('CA12   Yukon Territory*');
     End;
044: Begin CountryNameEdit.Text:={Cape Verde-}'CV';
{CV     CAPE VERDE  district/concelho}
        StateFipsCodeCB.Items.add('CV01   Boa Vista');
        StateFipsCodeCB.Items.add('CV02   Brava');
        StateFipsCodeCB.Items.add('CV03   Fogo');
        StateFipsCodeCB.Items.add('CV04   Maio');
        StateFipsCodeCB.Items.add('CV05   Paul');
        StateFipsCodeCB.Items.add('CV06   Praia');
        StateFipsCodeCB.Items.add('CV07   Ribeira Grande');
        StateFipsCodeCB.Items.add('CV08   Sal');
        StateFipsCodeCB.Items.add('CV09   Santa Catarina');
        StateFipsCodeCB.Items.add('CV10   Sao Nicolau');
        StateFipsCodeCB.Items.add('CV11   Sao Vicente');
        StateFipsCodeCB.Items.add('CV12   Tarrafal');
     End;
045: Begin CountryNameEdit.Text:={Cayman Islands-}'CJ';
{CJ     CAYMAN ISLANDS district}
        StateFipsCodeCB.Items.add('CJ01   Creek');
        StateFipsCodeCB.Items.add('CJ02   Eastern');
        StateFipsCodeCB.Items.add('CJ03   Midland');
        StateFipsCodeCB.Items.add('CJ04   South Town');
        StateFipsCodeCB.Items.add('CJ05   Spot Bay');
        StateFipsCodeCB.Items.add('CJ06   Stake Bay');
        StateFipsCodeCB.Items.add('CJ07   West End');
        StateFipsCodeCB.Items.add('CJ08   Western');
     End;
046: Begin CountryNameEdit.Text:={Central African Republic-}'CT';
{CT     CENTRAL AFRICAN REPUBLIC  **commune
*economic prefecture/prefecture economique  prefecture/prefecture}
        StateFipsCodeCB.Items.add('CT01   Bamingui-Bangoran');
        StateFipsCodeCB.Items.add('CT18   Bangui**');
        StateFipsCodeCB.Items.add('CT02   Basse-Kotto');
        StateFipsCodeCB.Items.add('CT15   Gribingui*');
        StateFipsCodeCB.Items.add('CT03   Haute-Kotto');
        StateFipsCodeCB.Items.add('CT04   Haute-Sangha');
        StateFipsCodeCB.Items.add('CT05   Haut-Mbomou');
        StateFipsCodeCB.Items.add('CT06   Kemo-Gribingui');
        StateFipsCodeCB.Items.add('CT07   Lobaye');
        StateFipsCodeCB.Items.add('CT08   Mbomou');
        StateFipsCodeCB.Items.add('CT09   Nana-Mambere      [Nana-Nambere]');
        StateFipsCodeCB.Items.add('CT17   Ombella-Mpoko');
        StateFipsCodeCB.Items.add('CT11   Ouaka');
        StateFipsCodeCB.Items.add('CT12   Ouham');
        StateFipsCodeCB.Items.add('CT13   Ouham-Pende');
        StateFipsCodeCB.Items.add('CT16   Sangha*');
        StateFipsCodeCB.Items.add('CT14   Vakaga');
     End;
047: Begin CountryNameEdit.Text:={Chad-}'CD';
{CD     CHAD    prefecture/prefecture}
        StateFipsCodeCB.Items.add('CD01   Batha');
        StateFipsCodeCB.Items.add('CD02   Biltine');
        StateFipsCodeCB.Items.add('CD03   Borkou-Ennedi-Tibesti');
        StateFipsCodeCB.Items.add('CD04   Chari-Baguirmi');
        StateFipsCodeCB.Items.add('CD05   Guera');
        StateFipsCodeCB.Items.add('CD06   Kanem');
        StateFipsCodeCB.Items.add('CD07   Lac');
        StateFipsCodeCB.Items.add('CD08   Logone Occidental');
        StateFipsCodeCB.Items.add('CD09   Logone Oriental');
        StateFipsCodeCB.Items.add('CD10   Mayo-Kebbi');
        StateFipsCodeCB.Items.add('CD11   Moyen-Chari');
        StateFipsCodeCB.Items.add('CD12   Ouaddai');
        StateFipsCodeCB.Items.add('CD13   Salamat');
        StateFipsCodeCB.Items.add('CD14   Tandjile');
     End;
048: Begin CountryNameEdit.Text:={Chile-}'CI';
{CI     CHILE     region/region}
        StateFipsCodeCB.Items.add('CI02   Aisen del General Carlos Ibanez del Campo');
        StateFipsCodeCB.Items.add('CI03   Antofagasta');
        StateFipsCodeCB.Items.add('CI04   Araucania');
        StateFipsCodeCB.Items.add('CI05   Atacama');
        StateFipsCodeCB.Items.add('CI06   Bio-Bio');
        StateFipsCodeCB.Items.add('CI07   Coquimbo');
        StateFipsCodeCB.Items.add('CI08   Libertador General Bernardo O`Higgins');
        StateFipsCodeCB.Items.add('CI09   Los Lagos');
        StateFipsCodeCB.Items.add('CI10   Magallanes y de la Antartica Chilena');
        StateFipsCodeCB.Items.add('CI11   Maule');
        StateFipsCodeCB.Items.add('CI12   Region Metropolitana');
        StateFipsCodeCB.Items.add('CI13   Tarapaca');
        StateFipsCodeCB.Items.add('CI01   Valparaiso');
     End;
049: Begin CountryNameEdit.Text:={China-}'CH';
{CH     CHINA  *autonomous region/zizhiqu
**municipality/shi  province/sheng}
        StateFipsCodeCB.Items.add('CH01   Anhui             [Anhwei]');
        StateFipsCodeCB.Items.add('CH22   Beijing**         [Peking]');
        StateFipsCodeCB.Items.add('CH07   Fujian            [Fukien]');
        StateFipsCodeCB.Items.add('CH15   Gansu             [Kansu]');
        StateFipsCodeCB.Items.add('CH30   Guangdong         [Kwangtung]');
        StateFipsCodeCB.Items.add('CH16   Guangxi*          [Kwangsi]');
        StateFipsCodeCB.Items.add('CH18   Guizhou           [Kweichow]');
        StateFipsCodeCB.Items.add('CH31   Hainan');
        StateFipsCodeCB.Items.add('CH10   Hebei             [Hopeh]');
        StateFipsCodeCB.Items.add('CH08   Heilongjiang      [Heilungkiang]');
        StateFipsCodeCB.Items.add('CH09   Henan             [Honan]');
        StateFipsCodeCB.Items.add('CH12   Hubei             [Hupeh]');
        StateFipsCodeCB.Items.add('CH11   Hunan');
        StateFipsCodeCB.Items.add('CH04   Jiangsu           [Kiangsu]');
        StateFipsCodeCB.Items.add('CH03   Jiangxi           [Kiangsi]');
        StateFipsCodeCB.Items.add('CH05   Jilin             [Kirin]');
        StateFipsCodeCB.Items.add('CH19   Liaoning');
        StateFipsCodeCB.Items.add('CH20   Nei Mongol*       (Inner Mongolia)');
        StateFipsCodeCB.Items.add('CH21   Ningxia*          (Ningxia)');
        StateFipsCodeCB.Items.add('CH06   Qinghai           [Tsinghai]');
        StateFipsCodeCB.Items.add('CH26   Shaanxi           [Shensi]');
        StateFipsCodeCB.Items.add('CH25   Shandong          [Shantung]');
        StateFipsCodeCB.Items.add('CH23   Shanghai**');
        StateFipsCodeCB.Items.add('CH24   Shanxi            [Shansi]');
        StateFipsCodeCB.Items.add('CH27   Sichuan           [Szechwan]');
        StateFipsCodeCB.Items.add('CH28   Tianjin**');
        StateFipsCodeCB.Items.add('CH13   Xinjiang*         [Sinkiang]');
        StateFipsCodeCB.Items.add('CH14   Xizang*           (Tibet)');
        StateFipsCodeCB.Items.add('CH29   Yunnan');
        StateFipsCodeCB.Items.add('CH02   Zhejiang          [Chekiang]');
      End;
050: Begin CountryNameEdit.Text:={Christmas Island-}'KT';
{KT     CHRISTMAS ISLAND}
     End;
051: Begin CountryNameEdit.Text:={Clipperton Island-}'IP';
{IP     CLIPPERTON ISLAND}
     End;
52: Begin CountryNameEdit.Text:={Cocos (Keeling) Islands-}'CK';
{CK     COCOS (KEELING) ISLANDS}
     End;
53: Begin CountryNameEdit.Text:={Colombia-}'CO';
{CO     COLOMBIA  *commissariat/comisaria
department/departamento **intendancy/intendencia
***special district/distrito especial}
        StateFipsCodeCB.Items.add('CO01   Amazonas*');
        StateFipsCodeCB.Items.add('CO02   Antioquia');
        StateFipsCodeCB.Items.add('CO03   Arauca**');
        StateFipsCodeCB.Items.add('CO04   Atlantico');
        StateFipsCodeCB.Items.add('CO35   Bolivar');
        StateFipsCodeCB.Items.add('CO36   Boyaca');
        StateFipsCodeCB.Items.add('CO37   Caldas');
        StateFipsCodeCB.Items.add('CO08   Caqueta');
        StateFipsCodeCB.Items.add('CO32   Casanare**');
        StateFipsCodeCB.Items.add('CO09   Cauca');
        StateFipsCodeCB.Items.add('CO10   Cesar');
        StateFipsCodeCB.Items.add('CO11   Choco');
        StateFipsCodeCB.Items.add('CO12   Cordoba');
        StateFipsCodeCB.Items.add('CO33   Cundinamarca');
        StateFipsCodeCB.Items.add('CO34   Distrito Especial***');
        StateFipsCodeCB.Items.add('CO15   Guainia*');
        StateFipsCodeCB.Items.add('CO14   Guaviare*');
        StateFipsCodeCB.Items.add('CO16   Huila');
        StateFipsCodeCB.Items.add('CO17   La Guajira');
        StateFipsCodeCB.Items.add('CO38   Magdalena');
        StateFipsCodeCB.Items.add('CO19   Meta');
        StateFipsCodeCB.Items.add('CO20   Narino');
        StateFipsCodeCB.Items.add('CO21   Norte de Santander');
        StateFipsCodeCB.Items.add('CO22   Putumayo**');
        StateFipsCodeCB.Items.add('CO23   Quindio');
        StateFipsCodeCB.Items.add('CO24   Risaralda');
        StateFipsCodeCB.Items.add('CO25   San Andres y Providencia**');
        StateFipsCodeCB.Items.add('CO26   Santander');
        StateFipsCodeCB.Items.add('CO27   Sucre');
        StateFipsCodeCB.Items.add('CO28   Tolima');
        StateFipsCodeCB.Items.add('CO29   Valle del Cauca');
        StateFipsCodeCB.Items.add('CO30   Vaupes*');
        StateFipsCodeCB.Items.add('CO31   Vichada*');
     End;
54: Begin CountryNameEdit.Text:={Comoros-}'CN';
{CN     COMOROS  island}
        StateFipsCodeCB.Items.add('CN01   Anjouan');
        StateFipsCodeCB.Items.add('CN02   Grande Comore');
        StateFipsCodeCB.Items.add('CN03   Moheli');
     End;
55: Begin CountryNameEdit.Text:={Congo, Democratic Republic of The-}'CG';
{CG     ZAIRE region/region  *town/ville}
        StateFipsCodeCB.Items.add('CG01   Bandundu');
        StateFipsCodeCB.Items.add('CG08   Bas-Zaire');
        StateFipsCodeCB.Items.add('CG02   Equateur');
        StateFipsCodeCB.Items.add('CG09   Haut-Zaire');
        StateFipsCodeCB.Items.add('CG03   Kasai-Occidental');
        StateFipsCodeCB.Items.add('CG04   Kasai-Oriental');
        StateFipsCodeCB.Items.add('CG06   Kinshasa*');
        StateFipsCodeCB.Items.add('CG07   Kivu');
        StateFipsCodeCB.Items.add('CG05   Shaba');
     End;
56: Begin CountryNameEdit.Text:={Congo, Republic of The-}'CF';
{CF     CONGO *commune  region/region}
        StateFipsCodeCB.Items.add('CF01   Bouenza');
        StateFipsCodeCB.Items.add('CF12   Brazzaville*');
        StateFipsCodeCB.Items.add('CF03   Cuvette');
        StateFipsCodeCB.Items.add('CF04   Kouilou');
        StateFipsCodeCB.Items.add('CF05   Lekoumou');
        StateFipsCodeCB.Items.add('CF06   Likouala');
        StateFipsCodeCB.Items.add('CF07   Niari');
        StateFipsCodeCB.Items.add('CF08   Plateaux');
        StateFipsCodeCB.Items.add('CF11   Pool');
        StateFipsCodeCB.Items.add('CF10   Sangha');
     End;
57: Begin CountryNameEdit.Text:={Cook Islands-}'CW';
{CW     COOK ISLANDS}
     End;
58: Begin CountryNameEdit.Text:={Coral Sea Islands-}'CR';
{CR     CORAL SEA ISLANDS}
     End;
59: Begin CountryNameEdit.Text:={Costa Rica-}'CS';
{CS     COSTA RICA  province/provincia}
        StateFipsCodeCB.Items.add('CS01   Alajuela');
        StateFipsCodeCB.Items.add('CS02   Cartago');
        StateFipsCodeCB.Items.add('CS03   Guanacaste');
        StateFipsCodeCB.Items.add('CS04   Heredia');
        StateFipsCodeCB.Items.add('CS06   Limon');
        StateFipsCodeCB.Items.add('CS07   Puntarenas');
        StateFipsCodeCB.Items.add('CS08   San Jose');
     End;
60: Begin CountryNameEdit.Text:={Cote D'ivoire-}'IV';
{IV     COTE D'IVOIRE  department/departement }
        StateFipsCodeCB.Items.add('IV01   Abengourou');
        StateFipsCodeCB.Items.add('IV35   Abidjan');
        StateFipsCodeCB.Items.add('IV04   Aboisso');
        StateFipsCodeCB.Items.add('IV05   Adzope');
        StateFipsCodeCB.Items.add('IV06   Agboville');
        StateFipsCodeCB.Items.add('IV36   Bangolo');
        StateFipsCodeCB.Items.add('IV37   Beoumi');
        StateFipsCodeCB.Items.add('IV07   Biankouma');
        StateFipsCodeCB.Items.add('IV38   Bondoukou');
        StateFipsCodeCB.Items.add('IV27   Bongouanou');
        StateFipsCodeCB.Items.add('IV39   Bouafle');
        StateFipsCodeCB.Items.add('IV40   Bouake');
        StateFipsCodeCB.Items.add('IV11   Bouna');
        StateFipsCodeCB.Items.add('IV12   Boundiali');
        StateFipsCodeCB.Items.add('IV03   Dabakala');
        StateFipsCodeCB.Items.add('IV41   Daloa');
        StateFipsCodeCB.Items.add('IV14   Danane');
        StateFipsCodeCB.Items.add('IV42   Daoukro');
        StateFipsCodeCB.Items.add('IV43   Dimbokro');
        StateFipsCodeCB.Items.add('IV16   Divo');
        StateFipsCodeCB.Items.add('IV44   Duekoue');
        StateFipsCodeCB.Items.add('IV17   Ferkessedougou');
        StateFipsCodeCB.Items.add('IV18   Gagnoa');
        StateFipsCodeCB.Items.add('IV45   Grand-Lahou');
        StateFipsCodeCB.Items.add('IV46   Guiglo');
        StateFipsCodeCB.Items.add('IV28   Issia');
        StateFipsCodeCB.Items.add('IV20   Katiola');
        StateFipsCodeCB.Items.add('IV21   Korhogo');
        StateFipsCodeCB.Items.add('IV29   Lakota');
        StateFipsCodeCB.Items.add('IV47   Man');
        StateFipsCodeCB.Items.add('IV30   Mankono');
        StateFipsCodeCB.Items.add('IV48   Mbahiakro');
        StateFipsCodeCB.Items.add('IV23   Odienne');
        StateFipsCodeCB.Items.add('IV31   Oume');
        StateFipsCodeCB.Items.add('IV49   Sakassou');
        StateFipsCodeCB.Items.add('IV50   San Pedro');
        StateFipsCodeCB.Items.add('IV51   Sassandra');
        StateFipsCodeCB.Items.add('IV25   Seguela');
        StateFipsCodeCB.Items.add('IV52   Sinfra');
        StateFipsCodeCB.Items.add('IV32   Soubre');
        StateFipsCodeCB.Items.add('IV53   Tabou');
        StateFipsCodeCB.Items.add('IV54   Tanda');
        StateFipsCodeCB.Items.add('IV55   Tiassale');
        StateFipsCodeCB.Items.add('IV33   Tingrela');
        StateFipsCodeCB.Items.add('IV26   Touba');
        StateFipsCodeCB.Items.add('IV56   Toumodi');
        StateFipsCodeCB.Items.add('IV57   Vavoua');
        StateFipsCodeCB.Items.add('IV58   Yamoussoukro');
        StateFipsCodeCB.Items.add('IV34   Zuenoula');
     End;
61: Begin CountryNameEdit.Text:={Croatia-}'HR';
{HR     CROATIA}
     End;
62: Begin CountryNameEdit.Text:={Cuba-}'CU';
{CU     CUBA  *special municipality/municipio especial
province/provincia}
        StateFipsCodeCB.Items.add('CU05   Camaguey');
        StateFipsCodeCB.Items.add('CU07   Ciego de Avila');
        StateFipsCodeCB.Items.add('CU08   Cienfuegos');
        StateFipsCodeCB.Items.add('CU02   Ciudad de la Habana');
        StateFipsCodeCB.Items.add('CU09   Granma');
        StateFipsCodeCB.Items.add('CU10   Guantanamo');
        StateFipsCodeCB.Items.add('CU12   Holguin');
        StateFipsCodeCB.Items.add('CU04   Isla de la Juventud*');
        StateFipsCodeCB.Items.add('CU11   La Habana');
        StateFipsCodeCB.Items.add('CU13   Las Tunas');
        StateFipsCodeCB.Items.add('CU03   Matanzas');
        StateFipsCodeCB.Items.add('CU01   Pinar del Rio');
        StateFipsCodeCB.Items.add('CU14   Sancti Spiritus');
        StateFipsCodeCB.Items.add('CU15   Santiago de Cuba');
        StateFipsCodeCB.Items.add('CU16   Villa Clara');
     End;
63: Begin CountryNameEdit.Text:={Cyprus-}'CY';
{CY     CYPRUS  district}
        StateFipsCodeCB.Items.add('CY01   Famagusta');
        StateFipsCodeCB.Items.add('CY02   Kyrenia');
        StateFipsCodeCB.Items.add('CY03   Larnaca');
        StateFipsCodeCB.Items.add('CY05   Limassol');
        StateFipsCodeCB.Items.add('CY04   Nicosia');
        StateFipsCodeCB.Items.add('CY06   Paphos');
     End;
64: Begin CountryNameEdit.Text:={Czech Republic-}'EZ';
{EZ     CZECH REPUBLIC}
     End;
65: Begin CountryNameEdit.Text:={Denmark-}'DA';
{DA     DENMARK *city/staden  county/amt}
        StateFipsCodeCB.Items.add('DA01   Arhus');
        StateFipsCodeCB.Items.add('DA02   Bornholm');
        StateFipsCodeCB.Items.add('DA03   Frederiksborg');
        StateFipsCodeCB.Items.add('DA04   Fyn');
        StateFipsCodeCB.Items.add('DA05   Kobenhavn');
        StateFipsCodeCB.Items.add('DA07   Nordjylland');
        StateFipsCodeCB.Items.add('DA08   Ribe');
        StateFipsCodeCB.Items.add('DA09   Ringkobing');
        StateFipsCodeCB.Items.add('DA10   Roskilde');
        StateFipsCodeCB.Items.add('DA11   Sonderjylland');
        StateFipsCodeCB.Items.add('DA06   Staden Kobenhavn*');
        StateFipsCodeCB.Items.add('DA12   Storstrom');
        StateFipsCodeCB.Items.add('DA13   Vejle');
        StateFipsCodeCB.Items.add('DA14   Vestsjalland');
        StateFipsCodeCB.Items.add('DA15   Viborg');
     End;
66: Begin CountryNameEdit.Text:={Djibouti-}'DJ';
{DJ     DJIBOUTI  cercle}
        StateFipsCodeCB.Items.add('DJ01   `Ali Sabih');
        StateFipsCodeCB.Items.add('DJ02   Dikhil');
        StateFipsCodeCB.Items.add('DJ03   Djibouti');
        StateFipsCodeCB.Items.add('DJ04   Obock');
        StateFipsCodeCB.Items.add('DJ05   Tadjoura');
     End;
67: Begin CountryNameEdit.Text:={Dominica-}'DO';
{DO     DOMINICA   parish}
        StateFipsCodeCB.Items.add('DO02   Saint Andrew');
        StateFipsCodeCB.Items.add('DO03   Saint David');
        StateFipsCodeCB.Items.add('DO04   Saint George');
        StateFipsCodeCB.Items.add('DO05   Saint John');
        StateFipsCodeCB.Items.add('DO06   Saint Joseph');
        StateFipsCodeCB.Items.add('DO07   Saint Luke');
        StateFipsCodeCB.Items.add('DO08   Saint Mark');
        StateFipsCodeCB.Items.add('DO09   Saint Patrick');
        StateFipsCodeCB.Items.add('DO10   Saint Paul');
        StateFipsCodeCB.Items.add('DO11   Saint Peter');
     End;
68: Begin CountryNameEdit.Text:={Dominican Republic-}'DR';
{DR     DOMINICAN REPUBLIC  *district/distrito  province/provincia}
        StateFipsCodeCB.Items.add('DR01   Azua');
        StateFipsCodeCB.Items.add('DR02   Baoruco');
        StateFipsCodeCB.Items.add('DR03   Barahona');
        StateFipsCodeCB.Items.add('DR04   Dajabon');
        StateFipsCodeCB.Items.add('DR05   Distrito Nacional*');
        StateFipsCodeCB.Items.add('DR06   Duarte');
        StateFipsCodeCB.Items.add('DR11   Elias Pina');
        StateFipsCodeCB.Items.add('DR28   El Seibo');
        StateFipsCodeCB.Items.add('DR08   Espaillat');
        StateFipsCodeCB.Items.add('DR29   Hato Mayor');
        StateFipsCodeCB.Items.add('DR09   Independencia');
        StateFipsCodeCB.Items.add('DR10   La Altagracia');
        StateFipsCodeCB.Items.add('DR12   La Romana');
        StateFipsCodeCB.Items.add('DR30   La Vega');
        StateFipsCodeCB.Items.add('DR14   Maria Trinidad Sanchez');
        StateFipsCodeCB.Items.add('DR31   Monsenor Nouel');
        StateFipsCodeCB.Items.add('DR15   Monte Cristi');
        StateFipsCodeCB.Items.add('DR32   Monte Plata');
        StateFipsCodeCB.Items.add('DR16   Pedernales');
        StateFipsCodeCB.Items.add('DR17   Peravia');
        StateFipsCodeCB.Items.add('DR18   Puerto Plata');
        StateFipsCodeCB.Items.add('DR19   Salcedo');
        StateFipsCodeCB.Items.add('DR20   Samana');
        StateFipsCodeCB.Items.add('DR21   Sanchez Ramirez');
        StateFipsCodeCB.Items.add('DR33   San Cristobal');
        StateFipsCodeCB.Items.add('DR23   San Juan');
        StateFipsCodeCB.Items.add('DR24   San Pedro De Macoris');
        StateFipsCodeCB.Items.add('DR25   Santiago');
        StateFipsCodeCB.Items.add('DR26   Santiago Rodriguez');
        StateFipsCodeCB.Items.add('DR27   Valverde');
     End;
69: Begin CountryNameEdit.Text:={East Timor-}'TT';

     End;
70: Begin CountryNameEdit.Text:={Egypt-}'EG';
{EG     EGYPT  governorate/muhafazah}
        StateFipsCodeCB.Items.add('EG01   Ad Daqahliyah');
        StateFipsCodeCB.Items.add('EG02   Al Bahr al Ahmar');
        StateFipsCodeCB.Items.add('EG03   Al Buhayrah');
        StateFipsCodeCB.Items.add('EG04   Al Fayyum');
        StateFipsCodeCB.Items.add('EG05   Al Gharbiyah');
        StateFipsCodeCB.Items.add('EG06   Al Iskandariyah');
        StateFipsCodeCB.Items.add('EG07   Al Isma`iliyah');
        StateFipsCodeCB.Items.add('EG08   Al Jizah');
        StateFipsCodeCB.Items.add('EG09   Al Minufiyah');
        StateFipsCodeCB.Items.add('EG10   Al Minya');
        StateFipsCodeCB.Items.add('EG11   Al Qahirah');
        StateFipsCodeCB.Items.add('EG12   Al Qalyubiyah');
        StateFipsCodeCB.Items.add('EG13   Al Wadi al Jadid');
        StateFipsCodeCB.Items.add('EG14   Ash Sharqiyah');
        StateFipsCodeCB.Items.add('EG15   As Suways');
        StateFipsCodeCB.Items.add('EG16   Aswan');
        StateFipsCodeCB.Items.add('EG17   Asyut');
        StateFipsCodeCB.Items.add('EG18   Bani Suwayf');
        StateFipsCodeCB.Items.add('EG19   Bur Sa`id');
        StateFipsCodeCB.Items.add('EG20   Dumyat');
        StateFipsCodeCB.Items.add('EG26   Janub Sina`');
        StateFipsCodeCB.Items.add('EG21   Kafr ash Shaykh');
        StateFipsCodeCB.Items.add('EG22   Matruh');
        StateFipsCodeCB.Items.add('EG23   Qina');
        StateFipsCodeCB.Items.add('EG27   Shamal Sina`');
        StateFipsCodeCB.Items.add('EG24   Suhaj');
     End;
71: Begin CountryNameEdit.Text:={El Salvador-}'ES';
{ES     EL SALVADOR  department/departamento}
        StateFipsCodeCB.Items.add('ES01   Ahuachapan');
        StateFipsCodeCB.Items.add('ES02   Cabanas');
        StateFipsCodeCB.Items.add('ES03   Chalatenango');
        StateFipsCodeCB.Items.add('ES04   Cuscatlan');
        StateFipsCodeCB.Items.add('ES05   La Libertad');
        StateFipsCodeCB.Items.add('ES06   La Paz');
        StateFipsCodeCB.Items.add('ES07   La Union');
        StateFipsCodeCB.Items.add('ES08   Morazan');
        StateFipsCodeCB.Items.add('ES09   San Miguel');
        StateFipsCodeCB.Items.add('ES10   San Salvador');
        StateFipsCodeCB.Items.add('ES11   Santa Ana');
        StateFipsCodeCB.Items.add('ES12   San Vicente');
        StateFipsCodeCB.Items.add('ES13   Sonsonate');
        StateFipsCodeCB.Items.add('ES14   Usulutan');
     End;
72: Begin CountryNameEdit.Text:={Equador-}'EC';
{EC     ECUADOR         province/provincia}
        StateFipsCodeCB.Items.add('EC02   Azuay');
        StateFipsCodeCB.Items.add('EC03   Bolivar');
        StateFipsCodeCB.Items.add('EC04   Canar');
        StateFipsCodeCB.Items.add('EC05   Carchi');
        StateFipsCodeCB.Items.add('EC06   Chimborazo');
        StateFipsCodeCB.Items.add('EC07   Cotopaxi');
        StateFipsCodeCB.Items.add('EC08   El Oro');
        StateFipsCodeCB.Items.add('EC09   Esmeraldas');
        StateFipsCodeCB.Items.add('EC01   Galapagos');
        StateFipsCodeCB.Items.add('EC10   Guayas');
        StateFipsCodeCB.Items.add('EC11   Imbabura');
        StateFipsCodeCB.Items.add('EC12   Loja');
        StateFipsCodeCB.Items.add('EC13   Los Rios');
        StateFipsCodeCB.Items.add('EC14   Manabi');
        StateFipsCodeCB.Items.add('EC15   Morona-Santiago');
        StateFipsCodeCB.Items.add('EC21   Napo');
        StateFipsCodeCB.Items.add('EC17   Pastaza');
        StateFipsCodeCB.Items.add('EC18   Pichincha');
        StateFipsCodeCB.Items.add('EC22   Sucumbios');
        StateFipsCodeCB.Items.add('EC19   Tungurahua');
        StateFipsCodeCB.Items.add('EC20   Zamora-Chinchipe');
     End;
73: Begin CountryNameEdit.Text:={Equatorial Guinea-}'EK';
{EK     EQUATORIAL GUINEA  province/provincia}
        StateFipsCodeCB.Items.add('EK03   Annobon');
        StateFipsCodeCB.Items.add('EK04   Bioko Norte');
        StateFipsCodeCB.Items.add('EK05   Bioko Sur');
        StateFipsCodeCB.Items.add('EK06   Centro Sur');
        StateFipsCodeCB.Items.add('EK07   Kie-Ntem');
        StateFipsCodeCB.Items.add('EK08   Litoral');
        StateFipsCodeCB.Items.add('EK09   Wele-Nzas');
     End;
74: Begin CountryNameEdit.Text:={Eritrea-}'ER';
{ER     ERITREA}
     End;
75: Begin CountryNameEdit.Text:={Estonia-}'EN';
{EN     ESTONIA  *(city)  county/maa}
        StateFipsCodeCB.Items.add('EN01   Harjumaa');
        StateFipsCodeCB.Items.add('EN02   Hiiumaa');
        StateFipsCodeCB.Items.add('EN03   Ida-Virumaa');
        StateFipsCodeCB.Items.add('EN04   Jarvamaa');
        StateFipsCodeCB.Items.add('EN05   Jogevamaa');
        StateFipsCodeCB.Items.add('EN06   Kohtla-Jarve*');
        StateFipsCodeCB.Items.add('EN07   Laanemaa');
        StateFipsCodeCB.Items.add('EN08   Laane-Virumaa');
        StateFipsCodeCB.Items.add('EN09   Narva*');
        StateFipsCodeCB.Items.add('EN10   Parnu*');
        StateFipsCodeCB.Items.add('EN11   Parnumaa');
        StateFipsCodeCB.Items.add('EN12   Polvamaa');
        StateFipsCodeCB.Items.add('EN13   Raplamaa');
        StateFipsCodeCB.Items.add('EN14   Saaremaa');
        StateFipsCodeCB.Items.add('EN15   Sillamae*');
        StateFipsCodeCB.Items.add('EN16   Tallinn*');
        StateFipsCodeCB.Items.add('EN17   Tartu*');
        StateFipsCodeCB.Items.add('EN18   Tartumaa');
        StateFipsCodeCB.Items.add('EN19   Valgamaa');
        StateFipsCodeCB.Items.add('EN20   Viljandimaa');
        StateFipsCodeCB.Items.add('EN21   Vorumaa');
     End;
76: Begin CountryNameEdit.Text:={Ethiopia-}'ET';
{ET     ETHIOPIA
administrative region/astedader akababi
*autonomous region/rasgez akababi}
        StateFipsCodeCB.Items.add('ET15   Adis Abeba');
        StateFipsCodeCB.Items.add('ET01   Arsi     [Arusi]');
        StateFipsCodeCB.Items.add('ET17   Asosa');
        StateFipsCodeCB.Items.add('ET38   Bale     [Mendebo]');
        StateFipsCodeCB.Items.add('ET18   Borena');
        StateFipsCodeCB.Items.add('ET19   Debub Gonder');
        StateFipsCodeCB.Items.add('ET20   Debub Shewa');
        StateFipsCodeCB.Items.add('ET21   Debub Welo');
        StateFipsCodeCB.Items.add('ET22   Dire Dawa*');
        StateFipsCodeCB.Items.add('ET23   Gambela');
        StateFipsCodeCB.Items.add('ET39   Gamo Gofa [Gemu Gwefa]');
        StateFipsCodeCB.Items.add('ET40   Ilubabor');
        StateFipsCodeCB.Items.add('ET41   Kefa');
        StateFipsCodeCB.Items.add('ET24   Metekel');
        StateFipsCodeCB.Items.add('ET25   Mirab Gojam');
        StateFipsCodeCB.Items.add('ET26   Mirab Harerge');
        StateFipsCodeCB.Items.add('ET27   Mirab Shewa');
        StateFipsCodeCB.Items.add('ET28   Misrak Gojam');
        StateFipsCodeCB.Items.add('ET29   Misrak Harerge');
        StateFipsCodeCB.Items.add('ET30   Nazret');
        StateFipsCodeCB.Items.add('ET31   Ogaden*');
        StateFipsCodeCB.Items.add('ET32   Omo');
        StateFipsCodeCB.Items.add('ET33   Semen Gonder');
        StateFipsCodeCB.Items.add('ET34   Semen Shewa');
        StateFipsCodeCB.Items.add('ET35   Semen Welo');
        StateFipsCodeCB.Items.add('ET42   Sidamo');
        StateFipsCodeCB.Items.add('ET37   Tigray* [Tigre]');
        StateFipsCodeCB.Items.add('ET43   Welega  [Walaga]');
     End;
77: Begin CountryNameEdit.Text:={Europa Island-}'EU';
{EU     EUROPA ISLAND}
     End;
78: Begin CountryNameEdit.Text:={Falkland Islands-}'FK';
{FK     FALKLAND ISLANDS (ISLAS MALVINAS)}
     End;
79: Begin CountryNameEdit.Text:={Faroe Islands-}'FO';
{FO     FAROE ISLANDS}
     End;
80: Begin CountryNameEdit.Text:={Fiji-}'FJ';
{FJ     FIJI   *dependency  division }
        StateFipsCodeCB.Items.add('FJ01   Central');
        StateFipsCodeCB.Items.add('FJ02   Eastern');
        StateFipsCodeCB.Items.add('FJ03   Northern');
        StateFipsCodeCB.Items.add('FJ04   Rotuma*');
        StateFipsCodeCB.Items.add('FJ05   Western');
     End;
81: Begin CountryNameEdit.Text:={Finland-}'FI';
{FI     FINLAND  province/laani}
        StateFipsCodeCB.Items.add('FI01   Ahvenanmaa');
        StateFipsCodeCB.Items.add('FI02   Hame');
        StateFipsCodeCB.Items.add('FI03   Keski-Suomi');
        StateFipsCodeCB.Items.add('FI04   Kuopio');
        StateFipsCodeCB.Items.add('FI05   Kymi');
        StateFipsCodeCB.Items.add('FI06   Lappi');
        StateFipsCodeCB.Items.add('FI07   Mikkeli');
        StateFipsCodeCB.Items.add('FI08   Oulu');
        StateFipsCodeCB.Items.add('FI09   Pohjois-Karjala');
        StateFipsCodeCB.Items.add('FI10   Turku ja Pori');
        StateFipsCodeCB.Items.add('FI11   Uusimaa');
        StateFipsCodeCB.Items.add('FI12   Vaasa');
     End;
82: Begin CountryNameEdit.Text:={France-}'FR';
{FR     FRANCE     region/region}
        StateFipsCodeCB.Items.add('FRC1   Alsace');
        StateFipsCodeCB.Items.add('FR97   Aquitaine');
        StateFipsCodeCB.Items.add('FR98   Auvergne');
        StateFipsCodeCB.Items.add('FR99   Basse-Normandie');
        StateFipsCodeCB.Items.add('FRA1   Bourgogne');
        StateFipsCodeCB.Items.add('FRA2   Bretagne');
        StateFipsCodeCB.Items.add('FRA3   Centre');
        StateFipsCodeCB.Items.add('FRA4   Champagne-Ardenne');
        StateFipsCodeCB.Items.add('FRA5   Corse');
        StateFipsCodeCB.Items.add('FRA6   Franche-Comte');
        StateFipsCodeCB.Items.add('FRA7   Haute-Normandie');
        StateFipsCodeCB.Items.add('FRA8   Ile-de-France');
        StateFipsCodeCB.Items.add('FRA9   Languedoc-Roussillon');
        StateFipsCodeCB.Items.add('FRB1   Limousin');
        StateFipsCodeCB.Items.add('FRB2   Lorraine');
        StateFipsCodeCB.Items.add('FRB3   Midi-Pyrenees');
        StateFipsCodeCB.Items.add('FRB4   Nord-Pas-de-Calais');
        StateFipsCodeCB.Items.add('FRB5   Pays de la Loire');
        StateFipsCodeCB.Items.add('FRB6   Picardie');
        StateFipsCodeCB.Items.add('FRB7   Poitou-Charentes');
        StateFipsCodeCB.Items.add('FRB8   Provence-Alpes-Cote d`Azur');
        StateFipsCodeCB.Items.add('FRB9   Rhone-Alpes');
     End;
83: Begin CountryNameEdit.Text:={French Guiana-}'FG';
{FG     FRENCH GUIANA}
     End;
84: Begin CountryNameEdit.Text:={French Polynesia-}'FP';
{FP     FRENCH POLYNESIA}
     End;
85: Begin CountryNameEdit.Text:={French, Southern and Antarctic Lands-}'FS';
{FS     FRENCH SOUTHERN AND ANTARCTIC LANDS}
     End;
86: Begin CountryNameEdit.Text:={Gabon-}'GB';
{GB     GABON     province}
        StateFipsCodeCB.Items.add('GB01   Estuaire');
        StateFipsCodeCB.Items.add('GB02   Haut-Ogooue');
        StateFipsCodeCB.Items.add('GB03   Moyen-Ogooue');
        StateFipsCodeCB.Items.add('GB04   Ngounie');
        StateFipsCodeCB.Items.add('GB05   Nyanga');
        StateFipsCodeCB.Items.add('GB06   Ogooue-Ivindo');
        StateFipsCodeCB.Items.add('GB07   Ogooue-Lolo');
        StateFipsCodeCB.Items.add('GB08   Ogooue-Maritime');
        StateFipsCodeCB.Items.add('GB09   Woleu-Ntem');
     End;
87: Begin CountryNameEdit.Text:={Gambia, The-}'GA';
{GA     GAMBIA, THE  *city  division}
        StateFipsCodeCB.Items.add('GA01   Banjul*');
        StateFipsCodeCB.Items.add('GA02   Lower River');
        StateFipsCodeCB.Items.add('GA03   MacCarthy Island');
        StateFipsCodeCB.Items.add('GA07   North Bank');
        StateFipsCodeCB.Items.add('GA04   Upper River');
        StateFipsCodeCB.Items.add('GA05   Western');
    End;
88: Begin CountryNameEdit.Text:={Gaza Strip-}'GZ';
{GZ     GAZA STRIP}
     End;
89: Begin CountryNameEdit.Text:={Georgia-}'GG';
{GG     GEORGIA}
     End;
90: Begin CountryNameEdit.Text:={Germany-}'GM';
{GM     GERMANY  state/land}
        StateFipsCodeCB.Items.add('GM01   Baden-Wurttemberg');
        StateFipsCodeCB.Items.add('GM02   Bayern      [Bavaria]');
        StateFipsCodeCB.Items.add('GM16   Berlin');
        StateFipsCodeCB.Items.add('GM11   Brandenburg');
        StateFipsCodeCB.Items.add('GM03   Bremen');
        StateFipsCodeCB.Items.add('GM04   Hamburg');
        StateFipsCodeCB.Items.add('GM05   Hessen');
        StateFipsCodeCB.Items.add('GM12   Mecklenburg-Vorpommern');
        StateFipsCodeCB.Items.add('GM06   Niedersachsen');
        StateFipsCodeCB.Items.add('GM07   Nordrhein-Westfalen');
        StateFipsCodeCB.Items.add('GM08   Rheinland-Pfalz');
        StateFipsCodeCB.Items.add('GM09   Saarland');
        StateFipsCodeCB.Items.add('GM13   Sachsen');
        StateFipsCodeCB.Items.add('GM14   Sachsen-Anhalt');
        StateFipsCodeCB.Items.add('GM10   Schleswig-Holstein');
        StateFipsCodeCB.Items.add('GM15   Thuringen');
     End;
91: Begin CountryNameEdit.Text:={Ghana-}'GH';
{GH     GHANA  region}
        StateFipsCodeCB.Items.add('GH02   Ashanti');
        StateFipsCodeCB.Items.add('GH03   Brong-Ahafo');
        StateFipsCodeCB.Items.add('GH04   Central');
        StateFipsCodeCB.Items.add('GH05   Eastern');
        StateFipsCodeCB.Items.add('GH01   Greater Accra');
        StateFipsCodeCB.Items.add('GH06   Northern');
        StateFipsCodeCB.Items.add('GH10   Upper East');
        StateFipsCodeCB.Items.add('GH11   Upper West');
        StateFipsCodeCB.Items.add('GH08   Volta');
        StateFipsCodeCB.Items.add('GH09   Western');
     End;
92: Begin CountryNameEdit.Text:={Gibraltar-}'GI';
{GI     GIBRALTAR}
     End;
93: Begin CountryNameEdit.Text:={Glorioso Islands-}'GO';
{GO     GLORIOSO ISLANDS}
     End;
94: Begin CountryNameEdit.Text:={Greece-}'GR';
{GR     GREECE   department/nomos}
        StateFipsCodeCB.Items.add('GR31   Aitolia kai Akarnania');
        StateFipsCodeCB.Items.add('GR38   Akhaia');
        StateFipsCodeCB.Items.add('GR36   Argolis');
        StateFipsCodeCB.Items.add('GR41   Arkadhia');
        StateFipsCodeCB.Items.add('GR20   Arta');
        StateFipsCodeCB.Items.add('GR35   Attiki');
        StateFipsCodeCB.Items.add('GR47   Dhodhekanisos');
        StateFipsCodeCB.Items.add('GR04   Drama');
        StateFipsCodeCB.Items.add('GR30   Evritania');
        StateFipsCodeCB.Items.add('GR01   Evros');
        StateFipsCodeCB.Items.add('GR34   Evvoia');
        StateFipsCodeCB.Items.add('GR08   Florina');
        StateFipsCodeCB.Items.add('GR32   Fokis');
        StateFipsCodeCB.Items.add('GR29   Fthiotis');
        StateFipsCodeCB.Items.add('GR10   Grevena');
        StateFipsCodeCB.Items.add('GR39   Ilia');
        StateFipsCodeCB.Items.add('GR12   Imathia');
        StateFipsCodeCB.Items.add('GR17   Ioannina');
        StateFipsCodeCB.Items.add('GR45   Iraklion');
        StateFipsCodeCB.Items.add('GR23   Kardhitsa');
        StateFipsCodeCB.Items.add('GR09   Kastoria');
        StateFipsCodeCB.Items.add('GR14   Kavala');
        StateFipsCodeCB.Items.add('GR27   Kefallinia');
        StateFipsCodeCB.Items.add('GR25   Kerkira');
        StateFipsCodeCB.Items.add('GR15   Khalkidhiki');
        StateFipsCodeCB.Items.add('GR43   Khania');
        StateFipsCodeCB.Items.add('GR50   Khios');
        StateFipsCodeCB.Items.add('GR49   Kikladhes');
        StateFipsCodeCB.Items.add('GR06   Kilkis');
        StateFipsCodeCB.Items.add('GR37   Korinthia');
        StateFipsCodeCB.Items.add('GR11   Kozani');
        StateFipsCodeCB.Items.add('GR42   Lakonia');
        StateFipsCodeCB.Items.add('GR21   Larisa');
        StateFipsCodeCB.Items.add('GR46   Lasithi');
        StateFipsCodeCB.Items.add('GR51   Lesvos');
        StateFipsCodeCB.Items.add('GR26   Levkas');
        StateFipsCodeCB.Items.add('GR24   Magnisia');
        StateFipsCodeCB.Items.add('GR40   Messinia');
        StateFipsCodeCB.Items.add('GR07   Pella');
        StateFipsCodeCB.Items.add('GR16   Pieria');
        StateFipsCodeCB.Items.add('GR19   Preveza');
        StateFipsCodeCB.Items.add('GR44   Rethimni');
        StateFipsCodeCB.Items.add('GR02   Rodhopi');
        StateFipsCodeCB.Items.add('GR48   Samos');
        StateFipsCodeCB.Items.add('GR05   Serrai');
        StateFipsCodeCB.Items.add('GR18   Thesprotia');
        StateFipsCodeCB.Items.add('GR13   Thessaloniki');
        StateFipsCodeCB.Items.add('GR22   Trikala');
        StateFipsCodeCB.Items.add('GR33   Voiotia');
        StateFipsCodeCB.Items.add('GR03   Xanthi');
        StateFipsCodeCB.Items.add('GR28   Zakinthos');
     End;
95: Begin CountryNameEdit.Text:={Greenland-}'GL';
{GL     GREENLAND   municipality}
        StateFipsCodeCB.Items.add('GL01   Nordgronland');
        StateFipsCodeCB.Items.add('GL02   Ostgronland');
        StateFipsCodeCB.Items.add('GL03   Vestgronland');
     End;
96: Begin CountryNameEdit.Text:={Grenada-}'GJ';
{GJ     GRENADA      parish}
        StateFipsCodeCB.Items.add('GJ01   Saint Andrew');
        StateFipsCodeCB.Items.add('GJ02   Saint David');
        StateFipsCodeCB.Items.add('GJ03   Saint George');
        StateFipsCodeCB.Items.add('GJ04   Saint John');
        StateFipsCodeCB.Items.add('GJ05   Saint Mark');
        StateFipsCodeCB.Items.add('GJ06   Saint Patrick');
     End;
97: Begin CountryNameEdit.Text:={Guadeloupe-}'GP';
{GP     GUADELOUPE}
     End;
98: Begin CountryNameEdit.Text:={Guam-}'GQ';
{GQ     GUAM}
     End;
99: Begin CountryNameEdit.Text:={Guatemala-}'GT';
{GT     GUATEMALA  department/departamento}
        StateFipsCodeCB.Items.add('GT01   Alta Verapaz');
        StateFipsCodeCB.Items.add('GT02   Baja Verapaz');
        StateFipsCodeCB.Items.add('GT03   Chimaltenango');
        StateFipsCodeCB.Items.add('GT04   Chiquimula');
        StateFipsCodeCB.Items.add('GT05   El Progreso');
        StateFipsCodeCB.Items.add('GT06   Escuintla');
        StateFipsCodeCB.Items.add('GT07   Guatemala');
        StateFipsCodeCB.Items.add('GT08   Huehuetenango');
        StateFipsCodeCB.Items.add('GT09   Izabal');
        StateFipsCodeCB.Items.add('GT10   Jalapa');
        StateFipsCodeCB.Items.add('GT11   Jutiapa');
        StateFipsCodeCB.Items.add('GT12   Peten');
        StateFipsCodeCB.Items.add('GT14   Quiche');
        StateFipsCodeCB.Items.add('GT13   Quetzaltenango');
        StateFipsCodeCB.Items.add('GT15   Retalhuleu');
        StateFipsCodeCB.Items.add('GT16   Sacatepequez');
        StateFipsCodeCB.Items.add('GT17   San Marcos');
        StateFipsCodeCB.Items.add('GT18   Santa Rosa');
        StateFipsCodeCB.Items.add('GT19   Solola');
        StateFipsCodeCB.Items.add('GT20   Suchitepequez');
        StateFipsCodeCB.Items.add('GT21   Totonicapan');
        StateFipsCodeCB.Items.add('GT22   Zacapa');
     End;
100: Begin CountryNameEdit.Text:={Guernsey-}'GK';
{GK     GUERNSEY}
     End;
101: Begin CountryNameEdit.Text:={Guinea-bissau-}'PU';
{PU     GUINEA-BISSAU  region}
        StateFipsCodeCB.Items.add('PU01   Bafata');
        StateFipsCodeCB.Items.add('PU12   Biombo');
        StateFipsCodeCB.Items.add('PU11   Bissau');
        StateFipsCodeCB.Items.add('PU05   Bolama');
        StateFipsCodeCB.Items.add('PU06   Cacheu');
        StateFipsCodeCB.Items.add('PU10   Gabu');
        StateFipsCodeCB.Items.add('PU04   Oio');
        StateFipsCodeCB.Items.add('PU02   Quinara');
        StateFipsCodeCB.Items.add('PU07   Tombali');
    End;
102: Begin CountryNameEdit.Text:={Guinea-}'GV';
{GV     GUINEA administrative region/region administrative}
        StateFipsCodeCB.Items.add('GV01   Beyla');
        StateFipsCodeCB.Items.add('GV02   Boffa');
        StateFipsCodeCB.Items.add('GV03   Boke');
        StateFipsCodeCB.Items.add('GV04   Conakry');
        StateFipsCodeCB.Items.add('GV05   Dabola');
        StateFipsCodeCB.Items.add('GV06   Dalaba');
        StateFipsCodeCB.Items.add('GV07   Dinguiraye');
        StateFipsCodeCB.Items.add('GV08   Dubreka');
        StateFipsCodeCB.Items.add('GV09   Faranah');
        StateFipsCodeCB.Items.add('GV10   Forecariah');
        StateFipsCodeCB.Items.add('GV11   Fria');
        StateFipsCodeCB.Items.add('GV12   Gaoual');
        StateFipsCodeCB.Items.add('GV13   Gueckedou');
        StateFipsCodeCB.Items.add('GV14   Kankan');
        StateFipsCodeCB.Items.add('GV15   Kerouane');
        StateFipsCodeCB.Items.add('GV16   Kindia');
        StateFipsCodeCB.Items.add('GV17   Kissidougou');
        StateFipsCodeCB.Items.add('GV18   Koundara');
        StateFipsCodeCB.Items.add('GV19   Kouroussa');
        StateFipsCodeCB.Items.add('GV20   Labe');
        StateFipsCodeCB.Items.add('GV21   Macenta');
        StateFipsCodeCB.Items.add('GV22   Mali');
        StateFipsCodeCB.Items.add('GV23   Mamou');
        StateFipsCodeCB.Items.add('GV24   Nzerekore');
        StateFipsCodeCB.Items.add('GV25   Pita');
        StateFipsCodeCB.Items.add('GV26   Siguiri');
        StateFipsCodeCB.Items.add('GV27   Telimele');
        StateFipsCodeCB.Items.add('GV28   Tougue');
        StateFipsCodeCB.Items.add('GV29   Yomou');
     End;
103: Begin CountryNameEdit.Text:={Guyana-}'GY';
{GY     GUYANA  region}
        StateFipsCodeCB.Items.add('GY10   Barima-Waini');
        StateFipsCodeCB.Items.add('GY11   Cuyuni-Mazaruni');
        StateFipsCodeCB.Items.add('GY12   Demerara-Mahaica');
        StateFipsCodeCB.Items.add('GY13   East Berbice-Corentyne');
        StateFipsCodeCB.Items.add('GY14   Essequibo Islands-West Demerara');
        StateFipsCodeCB.Items.add('GY15   Mahaica-Berbice');
        StateFipsCodeCB.Items.add('GY16   Pomeroon-Supenaam');
        StateFipsCodeCB.Items.add('GY17   Potaro-Siparuni');
        StateFipsCodeCB.Items.add('GY18   Upper Demerara-Berbice');
        StateFipsCodeCB.Items.add('GY19   Upper Takutu-Upper Essequibo');
     End;
104: Begin CountryNameEdit.Text:={Haiti-}'HA';
{HA     HAITI  department/departement }
        StateFipsCodeCB.Items.add('HA06   Artibonite');
        StateFipsCodeCB.Items.add('HA07   Centre');
        StateFipsCodeCB.Items.add('HA08   Grand` Anse');
        StateFipsCodeCB.Items.add('HA09   Nord');
        StateFipsCodeCB.Items.add('HA10   Nord-Est');
        StateFipsCodeCB.Items.add('HA03   Nord-Ouest');
        StateFipsCodeCB.Items.add('HA11   Ouest');
        StateFipsCodeCB.Items.add('HA12   Sud');
        StateFipsCodeCB.Items.add('HA13   Sud-Est');
     End;
105: Begin CountryNameEdit.Text:={Heard Island and Mcdonald Islands-}'HM';
{HM     HEARD ISLAND AND MCDONALD ISLANDS}
     End;
106: Begin CountryNameEdit.Text:={Honduras-}'HO';
{HO     HONDURAS  department/departamento}
        StateFipsCodeCB.Items.add('HO01   Atlantida');
        StateFipsCodeCB.Items.add('HO02   Choluteca');
        StateFipsCodeCB.Items.add('HO03   Colon');
        StateFipsCodeCB.Items.add('HO04   Comayagua');
        StateFipsCodeCB.Items.add('HO05   Copan');
        StateFipsCodeCB.Items.add('HO06   Cortes');
        StateFipsCodeCB.Items.add('HO07   El Paraiso');
        StateFipsCodeCB.Items.add('HO08   Francisco Morazan');
        StateFipsCodeCB.Items.add('HO09   Gracias a Dios');
        StateFipsCodeCB.Items.add('HO10   Intibuca');
        StateFipsCodeCB.Items.add('HO11   Islas de la Bahia');
        StateFipsCodeCB.Items.add('HO12   La Paz');
        StateFipsCodeCB.Items.add('HO13   Lempira');
        StateFipsCodeCB.Items.add('HO14   Ocotepeque');
        StateFipsCodeCB.Items.add('HO15   Olancho');
        StateFipsCodeCB.Items.add('HO16   Santa Barbara');
        StateFipsCodeCB.Items.add('HO17   Valle');
        StateFipsCodeCB.Items.add('HO18   Yoro');
     End;
107: Begin CountryNameEdit.Text:={Hong Kong-}'HK';
{HK     HONG KONG}
     End;
108: Begin CountryNameEdit.Text:={Howland Island-}'HQ';
{HQ     HOWLAND ISLAND}
     End;
109: Begin CountryNameEdit.Text:={Hungary-}'HU';
{HU     HUNGARY       *capital city/fovaros
county/megye  **urban county/megyei varos  }
        StateFipsCodeCB.Items.add('HU01   Bacs-Kiskun');
        StateFipsCodeCB.Items.add('HU02   Baranya');
        StateFipsCodeCB.Items.add('HU03   Bekes');
        StateFipsCodeCB.Items.add('HU26   Bekescsaba**');
        StateFipsCodeCB.Items.add('HU04   Borsod-Abauj-Zemplen');
        StateFipsCodeCB.Items.add('HU05   Budapest*');
        StateFipsCodeCB.Items.add('HU06   Csongrad');
        StateFipsCodeCB.Items.add('HU07   Debrecen**');
        StateFipsCodeCB.Items.add('HU27   Dunaujvaros**');
        StateFipsCodeCB.Items.add('HU28   Eger**');
        StateFipsCodeCB.Items.add('HU08   Fejer');
        StateFipsCodeCB.Items.add('HU25   Gyor**');
        StateFipsCodeCB.Items.add('HU09   Gyor-Moson-Sopron');
        StateFipsCodeCB.Items.add('HU10   Hajdu-Bihar');
        StateFipsCodeCB.Items.add('HU11   Heves');
        StateFipsCodeCB.Items.add('HU29   Hodmezovasarhely**');
        StateFipsCodeCB.Items.add('HU20   Jasz-Nagykun-Szolnok');
        StateFipsCodeCB.Items.add('HU30   Kaposvar**');
        StateFipsCodeCB.Items.add('HU31   Kecskemet**');
        StateFipsCodeCB.Items.add('HU12   Komarom-Esztergom');
        StateFipsCodeCB.Items.add('HU13   Miskolc**');
        StateFipsCodeCB.Items.add('HU32   Nagykanizsa**');
        StateFipsCodeCB.Items.add('HU14   Nograd');
        StateFipsCodeCB.Items.add('HU33   Nyiregyhaza**');
        StateFipsCodeCB.Items.add('HU15   Pecs**');
        StateFipsCodeCB.Items.add('HU16   Pest');
        StateFipsCodeCB.Items.add('HU17   Somogy');
        StateFipsCodeCB.Items.add('HU34   Sopron**');
        StateFipsCodeCB.Items.add('HU18   Szabolcs-Szatmar-Bereg');
        StateFipsCodeCB.Items.add('HU19   Szeged**');
        StateFipsCodeCB.Items.add('HU35   Szekesfehervar**');
        StateFipsCodeCB.Items.add('HU36   Szolnok**');
        StateFipsCodeCB.Items.add('HU37   Szombathely**');
        StateFipsCodeCB.Items.add('HU38   Tatabanya**');
        StateFipsCodeCB.Items.add('HU21   Tolna');
        StateFipsCodeCB.Items.add('HU22   Vas');
        StateFipsCodeCB.Items.add('HU23   Veszprem');
        StateFipsCodeCB.Items.add('HU39   Veszprem**');
        StateFipsCodeCB.Items.add('HU24   Zala');
        StateFipsCodeCB.Items.add('HU40   Zalaegerszeg**');
     End;
110: Begin CountryNameEdit.Text:={Iceland-}'IC';
{IC     ICELAND  county/sysla  *independent town/kaupstadir}
        StateFipsCodeCB.Items.add('IC01   Akranes*');
        StateFipsCodeCB.Items.add('IC02   Akureyri*');
        StateFipsCodeCB.Items.add('IC03   Arnessysla');
        StateFipsCodeCB.Items.add('IC04   Austur-Bardastrandarsysla');
        StateFipsCodeCB.Items.add('IC05   Austur-Hunavatnssysla');
        StateFipsCodeCB.Items.add('IC06   Austur-Skaftafellssysla');
        StateFipsCodeCB.Items.add('IC07   Borgarfjardarsysla');
        StateFipsCodeCB.Items.add('IC08   Dalasysla');
        StateFipsCodeCB.Items.add('IC09   Eyjafjardarsysla');
        StateFipsCodeCB.Items.add('IC10   Gullbringusysla');
        StateFipsCodeCB.Items.add('IC11   Hafnarfjordur*');
        StateFipsCodeCB.Items.add('IC12   Husavik*');
        StateFipsCodeCB.Items.add('IC13   Isafjordur*');
        StateFipsCodeCB.Items.add('IC14   Keflavik*');
        StateFipsCodeCB.Items.add('IC15   Kjosarsysla');
        StateFipsCodeCB.Items.add('IC16   Kopavogur*');
        StateFipsCodeCB.Items.add('IC17   Myrasysla');
        StateFipsCodeCB.Items.add('IC18   Neskaupstadur*');
        StateFipsCodeCB.Items.add('IC19   Nordur-Isafjardarsysla');
        StateFipsCodeCB.Items.add('IC20   Nordur-Mulasysla');
        StateFipsCodeCB.Items.add('IC21   Nordur-Tingeyjarsysla');
        StateFipsCodeCB.Items.add('IC22   Olafsfjordur*');
        StateFipsCodeCB.Items.add('IC23   Rangarvallasysla');
        StateFipsCodeCB.Items.add('IC24   Reykjavik*');
        StateFipsCodeCB.Items.add('IC25   Saudarkrokur*');
        StateFipsCodeCB.Items.add('IC26   Seydisfjordur*');
        StateFipsCodeCB.Items.add('IC27   Siglufjordur*');
        StateFipsCodeCB.Items.add('IC28   Skagafjardarsysla');
        StateFipsCodeCB.Items.add('IC29   Snafellsnes- og Hnappadalssysla');
        StateFipsCodeCB.Items.add('IC30   Strandasysla');
        StateFipsCodeCB.Items.add('IC31   Sudur-Mulasysla');
        StateFipsCodeCB.Items.add('IC32   Sudur-Tingeyjarsysla');
        StateFipsCodeCB.Items.add('IC33   Vestmannaeyjar*');
        StateFipsCodeCB.Items.add('IC34   Vestur-Bardastrandarsysla');
        StateFipsCodeCB.Items.add('IC35   Vestur-Hunavatnssysla');
        StateFipsCodeCB.Items.add('IC36   Vestur-Isafjardarsysla');
        StateFipsCodeCB.Items.add('IC37   Vestur-Skaftafellssysla');
     End;
111: Begin CountryNameEdit.Text:={India-}'IN';
{IN     INDIA  state  *union territory}
        StateFipsCodeCB.Items.add('IN01   Andaman and Nicobar Islands*');
        StateFipsCodeCB.Items.add('IN02   Andhra Pradesh');
        StateFipsCodeCB.Items.add('IN30   Arunachal Pradesh');
        StateFipsCodeCB.Items.add('IN03   Assam');
        StateFipsCodeCB.Items.add('IN04   Bihar');
        StateFipsCodeCB.Items.add('IN05   Chandigarh*');
        StateFipsCodeCB.Items.add('IN06   Dadra and Nagar Haveli*');
        StateFipsCodeCB.Items.add('IN32   Daman and Diu*');
        StateFipsCodeCB.Items.add('IN07   Delhi*');
        StateFipsCodeCB.Items.add('IN33   Goa');
        StateFipsCodeCB.Items.add('IN09   Gujarat');
        StateFipsCodeCB.Items.add('IN10   Haryana');
        StateFipsCodeCB.Items.add('IN11   Himachal Pradesh');
        StateFipsCodeCB.Items.add('IN12   Jammu and Kashmir');
        StateFipsCodeCB.Items.add('IN19   Karnataka');
        StateFipsCodeCB.Items.add('IN13   Kerala');
        StateFipsCodeCB.Items.add('IN14   Lakshadweep*   [L,M,and A Islands]');
        StateFipsCodeCB.Items.add('IN15   Madhya Pradesh');
        StateFipsCodeCB.Items.add('IN16   Maharashtra');
        StateFipsCodeCB.Items.add('IN17   Manipur');
        StateFipsCodeCB.Items.add('IN18   Meghalaya');
        StateFipsCodeCB.Items.add('IN31   Mizoram*');
        StateFipsCodeCB.Items.add('IN20   Nagaland');
        StateFipsCodeCB.Items.add('IN21   Orissa');
        StateFipsCodeCB.Items.add('IN22   Pondicherry*');
        StateFipsCodeCB.Items.add('IN23   Punjab');
        StateFipsCodeCB.Items.add('IN24   Rajasthan');
        StateFipsCodeCB.Items.add('IN29   Sikkim');
        StateFipsCodeCB.Items.add('IN25   Tamil Nadu [Madras]');
        StateFipsCodeCB.Items.add('IN26   Tripura');
        StateFipsCodeCB.Items.add('IN27   Uttar Pradesh');
        StateFipsCodeCB.Items.add('IN28   West Bengal');
    End;
112: Begin CountryNameEdit.Text:={Indonesia-}'ID';
{ID     INDONESIA  province/propinsi
**special district/daerah khusus ibukota
*special region/daerah istimewa}
        StateFipsCodeCB.Items.add('ID01   Aceh*             [Atjeh]');
        StateFipsCodeCB.Items.add('ID02   Bali');
        StateFipsCodeCB.Items.add('ID03   Bengkulu');
        StateFipsCodeCB.Items.add('ID09   Irian Jaya');
        StateFipsCodeCB.Items.add('ID04   Jakarta Raya**    [Djakarta Raya]');
        StateFipsCodeCB.Items.add('ID05   Jambi             [Djambi]');
        StateFipsCodeCB.Items.add('ID06   Jawa Barat        [Djawa Barat]');
        StateFipsCodeCB.Items.add('ID07   Jawa Tengah       [Djawa Tengah]');
        StateFipsCodeCB.Items.add('ID08   Jawa Timur        [Djawa Timur]');
        StateFipsCodeCB.Items.add('ID11   Kalimantan Barat');
        StateFipsCodeCB.Items.add('ID12   Kalimantan Selatan');
        StateFipsCodeCB.Items.add('ID13   Kalimantan Tengah');
        StateFipsCodeCB.Items.add('ID14   Kalimantan Timur');
        StateFipsCodeCB.Items.add('ID15   Lampung');
        StateFipsCodeCB.Items.add('ID16   Maluku');
        StateFipsCodeCB.Items.add('ID17   Nusa Tenggara Barat');
        StateFipsCodeCB.Items.add('ID18   Nusa Tenggara Timur');
        StateFipsCodeCB.Items.add('ID19   Riau');
        StateFipsCodeCB.Items.add('ID20   Sulawesi Selatan');
        StateFipsCodeCB.Items.add('ID21   Sulawesi Tengah');
        StateFipsCodeCB.Items.add('ID22   Sulawesi Tenggara');
        StateFipsCodeCB.Items.add('ID23   Sulawesi Utara');
        StateFipsCodeCB.Items.add('ID24   Sumatera Barat');
        StateFipsCodeCB.Items.add('ID25   Sumatera Selatan');
        StateFipsCodeCB.Items.add('ID26   Sumatera Utara');
        StateFipsCodeCB.Items.add('ID27   Timor Timur');
        StateFipsCodeCB.Items.add('ID10   Yogyakarta*  [Jogjakarta]');
     End;
113: Begin CountryNameEdit.Text:={Iran-}'IR';
{IR     IRAN  province/ostan}
        StateFipsCodeCB.Items.add('IR01   Azarbayjan-e Bakhtari');
        StateFipsCodeCB.Items.add('IR02   Azarbayjan-e Khavari');
        StateFipsCodeCB.Items.add('IR13   Bakhtaran');
        StateFipsCodeCB.Items.add('IR22   Bushehr');
        StateFipsCodeCB.Items.add('IR03   Chahar Mahall va Bakhtiari');
        StateFipsCodeCB.Items.add('IR28   Esfahan');
        StateFipsCodeCB.Items.add('IR07   Fars');
        StateFipsCodeCB.Items.add('IR08   Gilan');
        StateFipsCodeCB.Items.add('IR09   Hamadan');
        StateFipsCodeCB.Items.add('IR11   Hormozgan');
        StateFipsCodeCB.Items.add('IR10   Ilam');
        StateFipsCodeCB.Items.add('IR29   Kerman');
        StateFipsCodeCB.Items.add('IR30   Khorasan');
        StateFipsCodeCB.Items.add('IR15   Khuzestan');
        StateFipsCodeCB.Items.add('IR05   Kohkiluyeh va Buyer Ahmadi');
        StateFipsCodeCB.Items.add('IR16   Kordestan');
        StateFipsCodeCB.Items.add('IR23   Lorestan');
        StateFipsCodeCB.Items.add('IR24   Markazi');
        StateFipsCodeCB.Items.add('IR17   Mazandaran');
        StateFipsCodeCB.Items.add('IR25   Semnan');
        StateFipsCodeCB.Items.add('IR04   Sistan va Baluchestan');
        StateFipsCodeCB.Items.add('IR26   Tehran');
        StateFipsCodeCB.Items.add('IR31   Yazd');
        StateFipsCodeCB.Items.add('IR27   Zanjan');
     End;
114: Begin CountryNameEdit.Text:={Iraq-}'IZ';
{IZ     IRAQ province/muhafazah}
        StateFipsCodeCB.Items.add('IZ01   Al Anbar');
        StateFipsCodeCB.Items.add('IZ02   Al Basrah');
        StateFipsCodeCB.Items.add('IZ03   Al Muthanna');
        StateFipsCodeCB.Items.add('IZ04   Al Qadisiyah');
        StateFipsCodeCB.Items.add('IZ17   An Najaf');
        StateFipsCodeCB.Items.add('IZ11   Arbil');
        StateFipsCodeCB.Items.add('IZ05   As Sulaymaniyah');
        StateFipsCodeCB.Items.add('IZ13   At Ta`mim [Kirkuk]');
        StateFipsCodeCB.Items.add('IZ06   Babil');
        StateFipsCodeCB.Items.add('IZ07   Baghdad');
        StateFipsCodeCB.Items.add('IZ08   Dahuk');
        StateFipsCodeCB.Items.add('IZ09   Dhi Qar');
        StateFipsCodeCB.Items.add('IZ10   Diyala');
        StateFipsCodeCB.Items.add('IZ12   Karbala`');
        StateFipsCodeCB.Items.add('IZ14   Maysan');
        StateFipsCodeCB.Items.add('IZ15   Ninawa');
        StateFipsCodeCB.Items.add('IZ18   Salah ad Din');
        StateFipsCodeCB.Items.add('IZ16   Wasit');
     End;
115: Begin CountryNameEdit.Text:={Ireland-}'EI';
{EI     IRELAND  county}
        StateFipsCodeCB.Items.add('EI01   Carlow');
        StateFipsCodeCB.Items.add('EI02   Cavan');
        StateFipsCodeCB.Items.add('EI03   Clare');
        StateFipsCodeCB.Items.add('EI04   Cork');
        StateFipsCodeCB.Items.add('EI06   Donegal');
        StateFipsCodeCB.Items.add('EI07   Dublin');
        StateFipsCodeCB.Items.add('EI10   Galway');
        StateFipsCodeCB.Items.add('EI11   Kerry');
        StateFipsCodeCB.Items.add('EI12   Kildare');
        StateFipsCodeCB.Items.add('EI13   Kilkenny');
        StateFipsCodeCB.Items.add('EI15   Laois');
        StateFipsCodeCB.Items.add('EI14   Leitrim');
        StateFipsCodeCB.Items.add('EI16   Limerick');
        StateFipsCodeCB.Items.add('EI18   Longford');
        StateFipsCodeCB.Items.add('EI19   Louth');
        StateFipsCodeCB.Items.add('EI20   Mayo');
        StateFipsCodeCB.Items.add('EI21   Meath');
        StateFipsCodeCB.Items.add('EI22   Monaghan');
        StateFipsCodeCB.Items.add('EI23   Offaly');
        StateFipsCodeCB.Items.add('EI24   Roscommon');
        StateFipsCodeCB.Items.add('EI25   Sligo');
        StateFipsCodeCB.Items.add('EI26   Tipperary');
        StateFipsCodeCB.Items.add('EI27   Waterford');
        StateFipsCodeCB.Items.add('EI29   Westmeath');
        StateFipsCodeCB.Items.add('EI30   Wexford');
        StateFipsCodeCB.Items.add('EI31   Wicklow');
     End;
116: Begin CountryNameEdit.Text:={Israel-}'IS';
{IS     ISRAEL district/mehoz}
        StateFipsCodeCB.Items.add('IS01   HaDarom           (Southern)');
        StateFipsCodeCB.Items.add('IS02   HaMerkaz          (Central)');
        StateFipsCodeCB.Items.add('IS03   HaZafon           (Northern)');
        StateFipsCodeCB.Items.add('IS04   Hefa              (Haifa)');
        StateFipsCodeCB.Items.add('IS05   Tel Aviv');
        StateFipsCodeCB.Items.add('IS06   Yerushalayim      (Jerusalem)');
     End;
117: Begin CountryNameEdit.Text:={Italy-}'IT';
{IT     ITALY region/regione}
        StateFipsCodeCB.Items.add('IT01   Abruzzi');
        StateFipsCodeCB.Items.add('IT02   Basilicata');
        StateFipsCodeCB.Items.add('IT03   Calabria');
        StateFipsCodeCB.Items.add('IT04   Campania');
        StateFipsCodeCB.Items.add('IT05   Emilia-Romagna');
        StateFipsCodeCB.Items.add('IT06   Friuli-Venezia Giulia');
        StateFipsCodeCB.Items.add('IT07   Lazio');
        StateFipsCodeCB.Items.add('IT08   Liguria');
        StateFipsCodeCB.Items.add('IT09   Lombardia');
        StateFipsCodeCB.Items.add('IT10   Marche');
        StateFipsCodeCB.Items.add('IT11   Molise');
        StateFipsCodeCB.Items.add('IT12   Piemonte');
        StateFipsCodeCB.Items.add('IT13   Puglia');
        StateFipsCodeCB.Items.add('IT14   Sardegna');
        StateFipsCodeCB.Items.add('IT15   Sicilia');
        StateFipsCodeCB.Items.add('IT16   Toscana');
        StateFipsCodeCB.Items.add('IT17   Trentino-Alto Adige');
        StateFipsCodeCB.Items.add('IT18   Umbria');
        StateFipsCodeCB.Items.add('IT19   Valle d`Aosta');
        StateFipsCodeCB.Items.add('IT20   Veneto');
      End;
118: Begin CountryNameEdit.Text:={Jamaica-}'JM';
{JM     JAMAICA     parish}
        StateFipsCodeCB.Items.add('JM01   Clarendon');
        StateFipsCodeCB.Items.add('JM02   Hanover');
        StateFipsCodeCB.Items.add('JM17   Kingston');
        StateFipsCodeCB.Items.add('JM04   Manchester');
        StateFipsCodeCB.Items.add('JM07   Portland');
        StateFipsCodeCB.Items.add('JM08   Saint Andrew');
        StateFipsCodeCB.Items.add('JM09   Saint Ann');
        StateFipsCodeCB.Items.add('JM10   Saint Catherine');
        StateFipsCodeCB.Items.add('JM11   Saint Elizabeth');
        StateFipsCodeCB.Items.add('JM12   Saint James');
        StateFipsCodeCB.Items.add('JM13   Saint Mary');
        StateFipsCodeCB.Items.add('JM14   Saint Thomas');
        StateFipsCodeCB.Items.add('JM15   Trelawny');
        StateFipsCodeCB.Items.add('JM16   Westmoreland');
     End;
119: Begin CountryNameEdit.Text:={Jan Mayen-}'JN';
{JN     JAN MAYEN}
     End;
120: Begin CountryNameEdit.Text:={Japan-}'JA';
{JA     JAPAN  prefecture}
        StateFipsCodeCB.Items.add('JA01   Aichi');
        StateFipsCodeCB.Items.add('JA02   Akita');
        StateFipsCodeCB.Items.add('JA03   Aomori');
        StateFipsCodeCB.Items.add('JA04   Chiba');
        StateFipsCodeCB.Items.add('JA05   Ehime');
        StateFipsCodeCB.Items.add('JA06   Fukui');
        StateFipsCodeCB.Items.add('JA08   Fukushima');
        StateFipsCodeCB.Items.add('JA09   Gifu');
        StateFipsCodeCB.Items.add('JA10   Gumma');
        StateFipsCodeCB.Items.add('JA11   Hiroshima');
        StateFipsCodeCB.Items.add('JA12   Hokkaido');
        StateFipsCodeCB.Items.add('JA13   Hyogo');
        StateFipsCodeCB.Items.add('JA14   Ibaraki');
        StateFipsCodeCB.Items.add('JA15   Ishikawa');
        StateFipsCodeCB.Items.add('JA16   Iwate');
        StateFipsCodeCB.Items.add('JA17   Kagawa');
        StateFipsCodeCB.Items.add('JA18   Kagoshima');
        StateFipsCodeCB.Items.add('JA19   Kanagawa');
        StateFipsCodeCB.Items.add('JA20   Kochi');
        StateFipsCodeCB.Items.add('JA21   Kumamoto');
        StateFipsCodeCB.Items.add('JA22   Kyoto');
        StateFipsCodeCB.Items.add('JA23   Mie');
        StateFipsCodeCB.Items.add('JA24   Miyagi');
        StateFipsCodeCB.Items.add('JA25   Miyazaki');
        StateFipsCodeCB.Items.add('JA26   Nagano');
        StateFipsCodeCB.Items.add('JA27   Nagasaki');
        StateFipsCodeCB.Items.add('JA28   Nara');
        StateFipsCodeCB.Items.add('JA29   Niigata');
        StateFipsCodeCB.Items.add('JA30   Oita');
        StateFipsCodeCB.Items.add('JA31   Okayama');
        StateFipsCodeCB.Items.add('JA47   Okinawa');
        StateFipsCodeCB.Items.add('JA32   Osaka');
        StateFipsCodeCB.Items.add('JA33   Saga');
        StateFipsCodeCB.Items.add('JA34   Saitama');
        StateFipsCodeCB.Items.add('JA35   Shiga');
        StateFipsCodeCB.Items.add('JA36   Shimane');
        StateFipsCodeCB.Items.add('JA37   Shizuoka');
        StateFipsCodeCB.Items.add('JA38   Tochigi');
        StateFipsCodeCB.Items.add('JA39   Tokushima');
        StateFipsCodeCB.Items.add('JA40   Tokyo');
        StateFipsCodeCB.Items.add('JA41   Tottori');
        StateFipsCodeCB.Items.add('JA42   Toyama');
        StateFipsCodeCB.Items.add('JA43   Wakayama');
        StateFipsCodeCB.Items.add('JA44   Yamagata');
        StateFipsCodeCB.Items.add('JA45   Yamaguchi');
        StateFipsCodeCB.Items.add('JA46   Yamanashi');
    End;
121: Begin CountryNameEdit.Text:={Jarvis Island-}'DQ';
{DQ     JARVIS ISLAND}
     End;
122: Begin CountryNameEdit.Text:={Jersey-}'JE';
{JE     JERSEY}
     End;


{JQ     JOHNSTON ATOLL}

123: Begin CountryNameEdit.Text:={Jordan-}'JO';
{JO     JORDAN  governorate/muhafazah}
        StateFipsCodeCB.Items.add('JO02   Al Balqa`');
        StateFipsCodeCB.Items.add('JO09   Al Karak');
        StateFipsCodeCB.Items.add('JO10   Al Mafraq');
        StateFipsCodeCB.Items.add('JO11   `Amman');
        StateFipsCodeCB.Items.add('JO12   At Tafilah');
        StateFipsCodeCB.Items.add('JO13   Az Zarqa');
        StateFipsCodeCB.Items.add('JO14   Irbid');
        StateFipsCodeCB.Items.add('JO07   Ma`an');
     End;
124: Begin CountryNameEdit.Text:={Juan De Nova Island-}'JU';
{JU     JUAN DE NOVA ISLAND}
     End;
125: Begin CountryNameEdit.Text:={Kazakhstan-}'KZ';
{KZ     KAZAKHSTAN}
     End;
126: Begin CountryNameEdit.Text:={Kenya-}'KE';
{KE     KENYA  *area province}
        StateFipsCodeCB.Items.add('KE01   Central');
        StateFipsCodeCB.Items.add('KE02   Coast');
        StateFipsCodeCB.Items.add('KE03   Eastern');
        StateFipsCodeCB.Items.add('KE05   Nairobi Area*');
        StateFipsCodeCB.Items.add('KE06   North-Eastern');
        StateFipsCodeCB.Items.add('KE07   Nyanza');
        StateFipsCodeCB.Items.add('KE08   Rift Valley');
        StateFipsCodeCB.Items.add('KE09   Western');
     End;
127: Begin CountryNameEdit.Text:={Kingman Reef-}'KQ';
{KQ     KINGMAN REEF}
     End;
128: Begin CountryNameEdit.Text:={Kiribati-}'KR';
{KR     KIRIBATI       islands}
        StateFipsCodeCB.Items.add('KR01   Gilbert Islands');
        StateFipsCodeCB.Items.add('KR02   Line Islands');
        StateFipsCodeCB.Items.add('KR03   Phoenix Islands');
     End;
129: Begin CountryNameEdit.Text:={Korea, Democratic People's Republic Of-}'KN';
{KN     KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF province *special city}
        StateFipsCodeCB.Items.add('KN01   Chagang-do');
        StateFipsCodeCB.Items.add('KN16   Hamgyong-bukto');
        StateFipsCodeCB.Items.add('KN03   Hamgyong-namdo');
        StateFipsCodeCB.Items.add('KN07   Hwanghae-bukto');
        StateFipsCodeCB.Items.add('KN06   Hwanghae-namdo');
        StateFipsCodeCB.Items.add('KN08   Kaesong-si*');
        StateFipsCodeCB.Items.add('KN09   Kangwon-do');
        StateFipsCodeCB.Items.add('KN14   Namp`o-si*');
        StateFipsCodeCB.Items.add('KN11   P`yongan-bukto');
        StateFipsCodeCB.Items.add('KN15   P`yongan-namdo');
        StateFipsCodeCB.Items.add('KN12   P`yongyang-si*');
        StateFipsCodeCB.Items.add('KN13   Yanggang-do');
     End;
130: Begin CountryNameEdit.Text:={Korea, Republic Of-}'KS';
{KS     KOREA, REPUBLIC OF province *special city}
        StateFipsCodeCB.Items.add('KS01   Cheju-do');
        StateFipsCodeCB.Items.add('KS03   Cholla-bukto');
        StateFipsCodeCB.Items.add('KS16   Cholla-namdo');
        StateFipsCodeCB.Items.add('KS05   Ch`ungch`ong-bukto');
        StateFipsCodeCB.Items.add('KS17   Ch`ungch`ong-namdo');
        StateFipsCodeCB.Items.add('KS12   Inch`on-jikhalsi*');
        StateFipsCodeCB.Items.add('KS06   Kangwon-do');
        StateFipsCodeCB.Items.add('KS18   Kwangju-jikhalsi');
        StateFipsCodeCB.Items.add('KS13   Kyonggi-do');
        StateFipsCodeCB.Items.add('KS14   Kyongsang-bukto');
        StateFipsCodeCB.Items.add('KS08   Kyongsang-namdo');
        StateFipsCodeCB.Items.add('KS10   Pusan-jikhalsi*');
        StateFipsCodeCB.Items.add('KS11   Soul-t`ukpyolsi*');
        StateFipsCodeCB.Items.add('KS15   Taegu-jikhalsi*');
        StateFipsCodeCB.Items.add('KS19   Taejon-jikhalsi');
     End;
131: Begin CountryNameEdit.Text:={Kuwait-}'KU';
{KU     KUWAIT governorate/muhafazah }
        StateFipsCodeCB.Items.add('KU01   Al Ahmadi');
        StateFipsCodeCB.Items.add('KU02   Al Kuwayt');
        StateFipsCodeCB.Items.add('KU03   Hawalli');
     End;
132: Begin CountryNameEdit.Text:={Kyrgyzstan-}'KG';
{KG     KYRGYZSTAN}
     End;
133: Begin CountryNameEdit.Text:={Laos-}'LA';
{LA     LAOS province/khoueng}
        StateFipsCodeCB.Items.add('LA01   Attapu            [Attopeu]');
        StateFipsCodeCB.Items.add('LA02   Champasak         [Champassak]');
        StateFipsCodeCB.Items.add('LA03   Houaphan          [Houa Phan]');
        StateFipsCodeCB.Items.add('LA04   Khammouan         [Khammouane]');
        StateFipsCodeCB.Items.add('LA05   Louang Namtha     [Houa Khong]');
        StateFipsCodeCB.Items.add('LA06   Louangphrabang    [Luang Prabang]');
        StateFipsCodeCB.Items.add('LA07   Oudomxai');
        StateFipsCodeCB.Items.add('LA08   Phongsali         [Phong Saly]');
        StateFipsCodeCB.Items.add('LA09   Saravan           [Saravane]');
        StateFipsCodeCB.Items.add('LA10   Savannakhet');
        StateFipsCodeCB.Items.add('LA11   Vientiane');
        StateFipsCodeCB.Items.add('LA13   Xaignabouri       [Sayaboury]');
        StateFipsCodeCB.Items.add('LA14   Xiangkhoang       [Xieng Khouang]');
     End;
134: Begin CountryNameEdit.Text:={Latvia-}'LG';
{LG     LATVIA}
     End;
135: Begin CountryNameEdit.Text:={Lebanon-}'LE';
{LE     LEBANON     governorate/muhafazah}
        StateFipsCodeCB.Items.add('LE01   Al Biqa`');
        StateFipsCodeCB.Items.add('LE02   Al Janub');
        StateFipsCodeCB.Items.add('LE03   Ash Shamal');
        StateFipsCodeCB.Items.add('LE04   Bayrut');
        StateFipsCodeCB.Items.add('LE05   Jabal Lubnan');
     End;
136: Begin CountryNameEdit.Text:={Lesotho-}'LT';
{LT     LESOTHO    district}
        StateFipsCodeCB.Items.add('LT10   Berea');
        StateFipsCodeCB.Items.add('LT11   Butha-Buthe');
        StateFipsCodeCB.Items.add('LT12   Leribe');
        StateFipsCodeCB.Items.add('LT13   Mafeteng');
        StateFipsCodeCB.Items.add('LT14   Maseru');
        StateFipsCodeCB.Items.add('LT15   Mohales Hoek');
        StateFipsCodeCB.Items.add('LT16   Mokhotlong');
        StateFipsCodeCB.Items.add('LT17   Qachas Nek');
        StateFipsCodeCB.Items.add('LT18   Quthing');
        StateFipsCodeCB.Items.add('LT19   Thaba-Tseka');
     End;
137: Begin CountryNameEdit.Text:={Liberia-}'LI';
{LI     LIBERIA *commonwealth district  county}
        StateFipsCodeCB.Items.add('LI01   Bong');
        StateFipsCodeCB.Items.add('LI03   Grand Bassa');
        StateFipsCodeCB.Items.add('LI04   Grand Cape Mount');
        StateFipsCodeCB.Items.add('LI02   Grand Jide');
        StateFipsCodeCB.Items.add('LI05   Lofa');
        StateFipsCodeCB.Items.add('LI06   Maryland');
        StateFipsCodeCB.Items.add('LI07   Monrovia*');
        StateFipsCodeCB.Items.add('LI08   Montserrado');
        StateFipsCodeCB.Items.add('LI09   Nimba');
        StateFipsCodeCB.Items.add('LI10   Sino');
     End;
138: Begin CountryNameEdit.Text:={Libya-}'LY';
{LY     LIBYA municipality/baladiyah}
        StateFipsCodeCB.Items.add('LY47   Ajdabiya');
        StateFipsCodeCB.Items.add('LY03   Al `Aziziyah');
        StateFipsCodeCB.Items.add('LY48   Al Fatih');
        StateFipsCodeCB.Items.add('LY49   Al Jabal al Akhdar');
        StateFipsCodeCB.Items.add('LY05   Al Jufrah');
        StateFipsCodeCB.Items.add('LY50   Al Khums');
        StateFipsCodeCB.Items.add('LY08   Al Kufrah');
        StateFipsCodeCB.Items.add('LY51   An Nuqat al Khams');
        StateFipsCodeCB.Items.add('LY13   Ash Shati`');
        StateFipsCodeCB.Items.add('LY52   Awbari');
        StateFipsCodeCB.Items.add('LY53   Az Zawiyah');
        StateFipsCodeCB.Items.add('LY54   Banghazi');
        StateFipsCodeCB.Items.add('LY55   Darnah');
        StateFipsCodeCB.Items.add('LY56   Ghadamis');
        StateFipsCodeCB.Items.add('LY57   Gharyan');
        StateFipsCodeCB.Items.add('LY58   Misratah');
        StateFipsCodeCB.Items.add('LY30   Murzuq');
        StateFipsCodeCB.Items.add('LY34   Sabha');
        StateFipsCodeCB.Items.add('LY59   Sawfajjin');
        StateFipsCodeCB.Items.add('LY60   Surt');
        StateFipsCodeCB.Items.add('LY61   Tarabulus');
        StateFipsCodeCB.Items.add('LY41   Tarhunah');
        StateFipsCodeCB.Items.add('LY42   Tubruq');
        StateFipsCodeCB.Items.add('LY62   Yafran');
        StateFipsCodeCB.Items.add('LY45   Zlitan');
     End;
139: Begin CountryNameEdit.Text:={Liechtenstein-}'LS';
{LS     LIECHTENSTEIN  commune/gemeinde}
        StateFipsCodeCB.Items.add('LS01   Balzers');
        StateFipsCodeCB.Items.add('LS02   Eschen');
        StateFipsCodeCB.Items.add('LS03   Gamprin');
        StateFipsCodeCB.Items.add('LS04   Mauren');
        StateFipsCodeCB.Items.add('LS05   Planken');
        StateFipsCodeCB.Items.add('LS06   Ruggell');
        StateFipsCodeCB.Items.add('LS07   Schaan');
        StateFipsCodeCB.Items.add('LS08   Schellenberg');
        StateFipsCodeCB.Items.add('LS09   Triesen');
        StateFipsCodeCB.Items.add('LS10   Triesenberg');
        StateFipsCodeCB.Items.add('LS11   Vaduz');
     End;
140: Begin CountryNameEdit.Text:={Lithuania-}'LH';
{LH     LITHUANIA}
     End;
141: Begin CountryNameEdit.Text:={Luxembourg-}'LU';
{LU     LUXEMBOURG  district/district}
        StateFipsCodeCB.Items.add('LU01   Diekirch');
        StateFipsCodeCB.Items.add('LU02   Grevenmacher');
        StateFipsCodeCB.Items.add('LU03   Luxembourg');
     End;
142: Begin CountryNameEdit.Text:={Macau-}'MC';
{MC     MACAU  district/concelho}
        StateFipsCodeCB.Items.add('MC01   Ilhas');
        StateFipsCodeCB.Items.add('MC02   Macau [Macao]');
     End;
143: Begin CountryNameEdit.Text:={Macedonia, the Former Yugoslav Republic Of-}'MK';
{MK     MACEDONIA}
     End;
144: Begin CountryNameEdit.Text:={Madagascar-}'MA';
{MA     MADAGASCAR province/faritanin'}
        StateFipsCodeCB.Items.add('MA05   Antananarivo');
        StateFipsCodeCB.Items.add('MA01   Antsiranana');
        StateFipsCodeCB.Items.add('MA02   Fianarantsoa');
        StateFipsCodeCB.Items.add('MA03   Mahajanga');
        StateFipsCodeCB.Items.add('MA04   Toamasina');
        StateFipsCodeCB.Items.add('MA06   Toliara');
     End;
145: Begin CountryNameEdit.Text:={Malawi-}'MI';
{MI     MALAWI  district}
        StateFipsCodeCB.Items.add('MI24   Blantyre');
        StateFipsCodeCB.Items.add('MI02   Chikwawa');
        StateFipsCodeCB.Items.add('MI03   Chiradzulu');
        StateFipsCodeCB.Items.add('MI04   Chitipa');
        StateFipsCodeCB.Items.add('MI06   Dedza');
        StateFipsCodeCB.Items.add('MI07   Dowa');
        StateFipsCodeCB.Items.add('MI08   Karonga');
        StateFipsCodeCB.Items.add('MI09   Kasungu');
        StateFipsCodeCB.Items.add('MI11   Lilongwe');
        StateFipsCodeCB.Items.add('MI10   Machinga    [Kasupe]');
        StateFipsCodeCB.Items.add('MI12   Mangochi    [Fort Johnston]');
        StateFipsCodeCB.Items.add('MI13   Mchinji');
        StateFipsCodeCB.Items.add('MI14   Mulanje     [Mlange]');
        StateFipsCodeCB.Items.add('MI25   Mwanza');
        StateFipsCodeCB.Items.add('MI15   Mzimba');
        StateFipsCodeCB.Items.add('MI17   Nkhata Bay');
        StateFipsCodeCB.Items.add('MI18   Nkhotakota');
        StateFipsCodeCB.Items.add('MI19   Nsanje');
        StateFipsCodeCB.Items.add('MI16   Ntcheu');
        StateFipsCodeCB.Items.add('MI20   Ntchisi     [Nchisi]');
        StateFipsCodeCB.Items.add('MI21   Rumphi      [Rumpi]');
        StateFipsCodeCB.Items.add('MI22   Salima');
        StateFipsCodeCB.Items.add('MI05   Thyolo');
        StateFipsCodeCB.Items.add('MI23   Zomba');
     End;
146: Begin CountryNameEdit.Text:={Malaysia-}'MY';
{MY     MALAYSIA
*federal territory/wilayah persekutuan state/negeri}
        StateFipsCodeCB.Items.add('MY01   Johor');
        StateFipsCodeCB.Items.add('MY02   Kedah');
        StateFipsCodeCB.Items.add('MY03   Kelantan');
        StateFipsCodeCB.Items.add('MY15   Labuan*');
        StateFipsCodeCB.Items.add('MY04   Melaka');
        StateFipsCodeCB.Items.add('MY05   Negeri Sembilan');
        StateFipsCodeCB.Items.add('MY06   Pahang');
        StateFipsCodeCB.Items.add('MY07   Perak');
        StateFipsCodeCB.Items.add('MY08   Perlis');
        StateFipsCodeCB.Items.add('MY09   Pulau Pinang');
        StateFipsCodeCB.Items.add('MY16   Sabah');
        StateFipsCodeCB.Items.add('MY11   Sarawak');
        StateFipsCodeCB.Items.add('MY12   Selangor');
        StateFipsCodeCB.Items.add('MY13   Terengganu');
        StateFipsCodeCB.Items.add('MY14   Wilayah Persekutuan*');
     End;
147: Begin CountryNameEdit.Text:={Maldives-}'MV';
{MV     MALDIVES district}
        StateFipsCodeCB.Items.add('MV02   Aliff');
        StateFipsCodeCB.Items.add('MV20   Baa');
        StateFipsCodeCB.Items.add('MV17   Daalu');
        StateFipsCodeCB.Items.add('MV14   Faafu');
        StateFipsCodeCB.Items.add('MV27   Gaafu Aliff');
        StateFipsCodeCB.Items.add('MV28   Gaafu Daalu');
        StateFipsCodeCB.Items.add('MV07   Haa Aliff');
        StateFipsCodeCB.Items.add('MV23   Haa Daalu');
        StateFipsCodeCB.Items.add('MV26   Kaafu');
        StateFipsCodeCB.Items.add('MV05   Laamu');
        StateFipsCodeCB.Items.add('MV03   Laviyani');
        StateFipsCodeCB.Items.add('MV12   Meemu');
        StateFipsCodeCB.Items.add('MV29   Naviyani');
        StateFipsCodeCB.Items.add('MV25   Noonu');
        StateFipsCodeCB.Items.add('MV13   Raa');
        StateFipsCodeCB.Items.add('MV01   Seenu');
        StateFipsCodeCB.Items.add('MV24   Shaviyani');
        StateFipsCodeCB.Items.add('MV08   Thaa');
        StateFipsCodeCB.Items.add('MV04   Waavu');
     End;
148: Begin CountryNameEdit.Text:={Mali-}'ML';
{ML     MALI      district/region}
        StateFipsCodeCB.Items.add('ML01   Bamako');
        StateFipsCodeCB.Items.add('ML02   Gao');
        StateFipsCodeCB.Items.add('ML03   Kayes');
        StateFipsCodeCB.Items.add('ML07   Koulikoro');
        StateFipsCodeCB.Items.add('ML04   Mopti');
        StateFipsCodeCB.Items.add('ML05   Segou');
        StateFipsCodeCB.Items.add('ML06   Sikasso');
        StateFipsCodeCB.Items.add('ML08   Tombouctou');
    End;
149: Begin CountryNameEdit.Text:={Malta-}'MT';
{MT     MALTA}
     End;
150: Begin CountryNameEdit.Text:={Man, Isle Of-}'IM';
{IM     MAN, ISLE OF}
     End;
End;{Case}
End;


procedure THtfForm.SetCountryFipsCode2(CountryIn,StateIn,CountyIn:Integer);
Begin
  If (CountryFipsCodeCB.ItemIndex<>CountryIn) then
    CountryFipsCodeCB.ItemIndex:=CountryIn;
  CountryFipsCodeEdit.Text:=Inttostr(CountryIn);
   {Set base for all}
  StateFipsCodeCB.Clear;
  StateFipsCodeCB.Items.add('00 : Unknown');

{IAW Country Code Set the Country data
AND Set the State Combobox items}
Case CountryIn of
151: Begin CountryNameEdit.Text:={Marshall Islands-}'RM';
{RM     MARSHALL ISLANDS}
     End;
152: Begin CountryNameEdit.Text:={Martinique-}'MB';
{MB     MARTINIQUE}
     End;
153: Begin CountryNameEdit.Text:={Mauritania-}'MR';
{MR     MAURITANIA region/region}
        StateFipsCodeCB.Items.add('MR07   Adrar             [Septieme Region]');
        StateFipsCodeCB.Items.add('MR03   Assaba            [Troisieme Region]');
        StateFipsCodeCB.Items.add('MR05   Brakna            [Cinquieme Region]');
        StateFipsCodeCB.Items.add('MR08   Dakhlet Nouadhibou[Huitieme Region]');
        StateFipsCodeCB.Items.add('MR04   Gorgol            [Quatrieme Region]');
        StateFipsCodeCB.Items.add('MR10   Guidimaka         [Dixieme Region]');
        StateFipsCodeCB.Items.add('MR01   Hodh Ech Chargui  [Premiere Region]');
        StateFipsCodeCB.Items.add('MR02   Hodh El Gharbi    [Deuxieme Region]');
        StateFipsCodeCB.Items.add('MR12   Inchiri           [Douzieme Region]');
        StateFipsCodeCB.Items.add('MR09   Tagant            [Neuvieme Region]');
        StateFipsCodeCB.Items.add('MR11   Tiris Zemmour     [Onzieme Region]');
        StateFipsCodeCB.Items.add('MR06   Trarza            [Sixieme Region]');
     End;
154: Begin CountryNameEdit.Text:={Mauritius-}'MP';
{MP     MAURITIUS  district *dependency}
        StateFipsCodeCB.Items.add('MP21   Agalega Islands*');
        StateFipsCodeCB.Items.add('MP12   Black River');
        StateFipsCodeCB.Items.add('MP22   Cargados Carajos*');
        StateFipsCodeCB.Items.add('MP13   Flacq');
        StateFipsCodeCB.Items.add('MP14   Grand Port');
        StateFipsCodeCB.Items.add('MP15   Moka');
        StateFipsCodeCB.Items.add('MP16   Pamplemousses');
        StateFipsCodeCB.Items.add('MP17   Plaines Wilhems');
        StateFipsCodeCB.Items.add('MP18   Port Louis');
        StateFipsCodeCB.Items.add('MP19   Riviere du Rempart');
        StateFipsCodeCB.Items.add('MP23   Rodrigues*');
        StateFipsCodeCB.Items.add('MP20   Savanne');
     End;
155: Begin CountryNameEdit.Text:={Mayotte-}'MF';
{MF     MAYOTTE}
     End;
156: Begin CountryNameEdit.Text:={Mexico-}'MX';
{MX     MEXICO   *federal district/distrito federal state/estado}
        StateFipsCodeCB.Items.add('MX01   Aguascalientes');
        StateFipsCodeCB.Items.add('MX02   Baja California');
        StateFipsCodeCB.Items.add('MX03   Baja California Sur');
        StateFipsCodeCB.Items.add('MX04   Campeche');
        StateFipsCodeCB.Items.add('MX05   Chiapas');
        StateFipsCodeCB.Items.add('MX06   Chihuahua');
        StateFipsCodeCB.Items.add('MX07   Coahuila de Zaragoza');
        StateFipsCodeCB.Items.add('MX08   Colima');
        StateFipsCodeCB.Items.add('MX09   Distrito Federal*');
        StateFipsCodeCB.Items.add('MX10   Durango');
        StateFipsCodeCB.Items.add('MX11   Guanajuato');
        StateFipsCodeCB.Items.add('MX12   Guerrero');
        StateFipsCodeCB.Items.add('MX13   Hidalgo');
        StateFipsCodeCB.Items.add('MX14   Jalisco');
        StateFipsCodeCB.Items.add('MX15   Mexico');
        StateFipsCodeCB.Items.add('MX16   Michoacan de Ocampo');
        StateFipsCodeCB.Items.add('MX17   Morelos');
        StateFipsCodeCB.Items.add('MX18   Nayarit');
        StateFipsCodeCB.Items.add('MX19   Nuevo Leon');
        StateFipsCodeCB.Items.add('MX20   Oaxaca');
        StateFipsCodeCB.Items.add('MX21   Puebla');
        StateFipsCodeCB.Items.add('MX22   Queretaro de Arteaga');
        StateFipsCodeCB.Items.add('MX23   Quintana Roo');
        StateFipsCodeCB.Items.add('MX24   San Luis Potosi');
        StateFipsCodeCB.Items.add('MX25   Sinaloa');
        StateFipsCodeCB.Items.add('MX26   Sonora');
        StateFipsCodeCB.Items.add('MX27   Tabasco');
        StateFipsCodeCB.Items.add('MX28   Tamaulipas');
        StateFipsCodeCB.Items.add('MX29   Tlaxcala');
        StateFipsCodeCB.Items.add('MX30   Veracruz-Llave');
        StateFipsCodeCB.Items.add('MX31   Yucatan');
        StateFipsCodeCB.Items.add('MX32   Zacatecas');
     End;
157: Begin CountryNameEdit.Text:={Micronesia, Federated States Of-}'FM';
{FM     FEDERATED STATES OF MICRONESIA  island}
        StateFipsCodeCB.Items.add('FM03   Chuuk');
        StateFipsCodeCB.Items.add('FM01   Kosrae');
        StateFipsCodeCB.Items.add('FM02   Pohnpei');
        StateFipsCodeCB.Items.add('FM04   Yap');
     End;
158: Begin CountryNameEdit.Text:={Midway Islands-}'MQ';
{MQ     MIDWAY ISLANDS}
     End;
159: Begin CountryNameEdit.Text:={Moldova-}'MD';
{MD     MOLDOVA}
     End;
160: Begin CountryNameEdit.Text:={Monaco-}'MN';
{MN     MONACO     commune}
        StateFipsCodeCB.Items.add('MN01   La Condamine');
        StateFipsCodeCB.Items.add('MN02   Monaco');
        StateFipsCodeCB.Items.add('MN03   Monte-Carlo');
     End;
161: Begin CountryNameEdit.Text:={Mongolia-}'MG';
{MG     MONGOLIA  *municipality/hot  province/aymag}
        StateFipsCodeCB.Items.add('MG01   Arhangay');
        StateFipsCodeCB.Items.add('MG02   Bayanhongor');
        StateFipsCodeCB.Items.add('MG03   Bayan-Olgiy');
        StateFipsCodeCB.Items.add('MG21   Bulgan');
        StateFipsCodeCB.Items.add('MG05   Darhan*');
        StateFipsCodeCB.Items.add('MG06   Dornod');
        StateFipsCodeCB.Items.add('MG07   Dornogovi');
        StateFipsCodeCB.Items.add('MG08   Dundgovi');
        StateFipsCodeCB.Items.add('MG09   Dzavhan');
        StateFipsCodeCB.Items.add('MG22   Erdenet*');
        StateFipsCodeCB.Items.add('MG10   Govi-Altay');
        StateFipsCodeCB.Items.add('MG11   Hentiy');
        StateFipsCodeCB.Items.add('MG12   Hovd');
        StateFipsCodeCB.Items.add('MG13   Hovsgol');
        StateFipsCodeCB.Items.add('MG14   Omnogovi');
        StateFipsCodeCB.Items.add('MG15   Ovorhangay');
        StateFipsCodeCB.Items.add('MG16   Selenge');
        StateFipsCodeCB.Items.add('MG17   Suhbaatar');
        StateFipsCodeCB.Items.add('MG18   Tov');
        StateFipsCodeCB.Items.add('MG20   Ulaanbaatar*');
        StateFipsCodeCB.Items.add('MG19   Uvs');
     End;

{MW     MONTENEGRO}

162: Begin CountryNameEdit.Text:={Montserrat-}'MH';
{MH     MONTSERRAT parish}
        StateFipsCodeCB.Items.add('MH01   Saint Anthony');
        StateFipsCodeCB.Items.add('MH02   Saint Georges');
        StateFipsCodeCB.Items.add('MH03   Saint Peter');
     End;
163: Begin CountryNameEdit.Text:={Morocco-}'MO';
{MO     MOROCCO *municipality/wilaya province/province}
        StateFipsCodeCB.Items.add('MO01   Agadir');
        StateFipsCodeCB.Items.add('MO02   Al Hoceima');
        StateFipsCodeCB.Items.add('MO03   Azilal');
        StateFipsCodeCB.Items.add('MO05   Beni Mellal');
        StateFipsCodeCB.Items.add('MO04   Ben Slimane');
        StateFipsCodeCB.Items.add('MO06   Boulemane');
        StateFipsCodeCB.Items.add('MO07   Casablanca*');
        StateFipsCodeCB.Items.add('MO08   Chaouen');
        StateFipsCodeCB.Items.add('MO09   El Jadida');
        StateFipsCodeCB.Items.add('MO10   El Kelaa des Srarhna');
        StateFipsCodeCB.Items.add('MO11   Er Rachidia');
        StateFipsCodeCB.Items.add('MO12   Essaouira');
        StateFipsCodeCB.Items.add('MO13   Fes');
        StateFipsCodeCB.Items.add('MO14   Figuig');
        StateFipsCodeCB.Items.add('MO33   Guelmim');
        StateFipsCodeCB.Items.add('MO34   Ifrane');
        StateFipsCodeCB.Items.add('MO15   Kenitra');
        StateFipsCodeCB.Items.add('MO16   Khemisset');
        StateFipsCodeCB.Items.add('MO17   Khenifra');
        StateFipsCodeCB.Items.add('MO18   Khouribga');
        StateFipsCodeCB.Items.add('MO35   Laayoune');
        StateFipsCodeCB.Items.add('MO41   Larache');
        StateFipsCodeCB.Items.add('MO19   Marrakech');
        StateFipsCodeCB.Items.add('MO20   Meknes');
        StateFipsCodeCB.Items.add('MO21   Nador');
        StateFipsCodeCB.Items.add('MO22   Ouarzazate');
        StateFipsCodeCB.Items.add('MO23   Oujda');
        StateFipsCodeCB.Items.add('MO24   Rabat-Sale* [Rabat]');
        StateFipsCodeCB.Items.add('MO25   Safi');
        StateFipsCodeCB.Items.add('MO26   Settat');
        StateFipsCodeCB.Items.add('MO38   Sidi Kacem');
        StateFipsCodeCB.Items.add('MO27   Tanger');
        StateFipsCodeCB.Items.add('MO36   Tan-Tan');
        StateFipsCodeCB.Items.add('MO37   Taounate');
        StateFipsCodeCB.Items.add('MO39   Taroudannt');
        StateFipsCodeCB.Items.add('MO29   Tata');
        StateFipsCodeCB.Items.add('MO30   Taza');
        StateFipsCodeCB.Items.add('MO40   Tetouan');
        StateFipsCodeCB.Items.add('MO32   Tiznit');
     End;
164: Begin CountryNameEdit.Text:={Mosambique-}'MZ';
{MZ     MOZAMBIQUE province/provincia}
        StateFipsCodeCB.Items.add('MZ01   Cabo Delgado');
        StateFipsCodeCB.Items.add('MZ02   Gaza');
        StateFipsCodeCB.Items.add('MZ03   Inhambane');
        StateFipsCodeCB.Items.add('MZ10   Manica');
        StateFipsCodeCB.Items.add('MZ04   Maputo');
        StateFipsCodeCB.Items.add('MZ06   Nampula');
        StateFipsCodeCB.Items.add('MZ07   Niassa');
        StateFipsCodeCB.Items.add('MZ05   Sofala');
        StateFipsCodeCB.Items.add('MZ08   Tete');
        StateFipsCodeCB.Items.add('MZ09   Zambezia');
     End;
165: Begin CountryNameEdit.Text:={Namibia-}'WA';
{WA     NAMIBIA district}
        StateFipsCodeCB.Items.add('WA01   Bethanien');
        StateFipsCodeCB.Items.add('WA03   Boesmanland');
        StateFipsCodeCB.Items.add('WA02   Caprivi Oos');
        StateFipsCodeCB.Items.add('WA22   Damaraland');
        StateFipsCodeCB.Items.add('WA04   Gobabis');
        StateFipsCodeCB.Items.add('WA05   Grootfontein');
        StateFipsCodeCB.Items.add('WA23   Hereroland Oos');
        StateFipsCodeCB.Items.add('WA24   Hereroland Wes');
        StateFipsCodeCB.Items.add('WA06   Kaokoland');
        StateFipsCodeCB.Items.add('WA20   Karasburg');
        StateFipsCodeCB.Items.add('WA07   Karibib');
        StateFipsCodeCB.Items.add('WA25   Kavango');
        StateFipsCodeCB.Items.add('WA08   Keetmanshoop');
        StateFipsCodeCB.Items.add('WA09   Luderitz');
        StateFipsCodeCB.Items.add('WA10   Maltahohe');
        StateFipsCodeCB.Items.add('WA26   Mariental');
        StateFipsCodeCB.Items.add('WA27   Namaland');
        StateFipsCodeCB.Items.add('WA11   Okahandja');
        StateFipsCodeCB.Items.add('WA12   Omaruru');
        StateFipsCodeCB.Items.add('WA13   Otjiwarongo');
        StateFipsCodeCB.Items.add('WA14   Outjo');
        StateFipsCodeCB.Items.add('WA15   Owambo');
        StateFipsCodeCB.Items.add('WA16   Rehoboth');
        StateFipsCodeCB.Items.add('WA17   Swakopmund');
        StateFipsCodeCB.Items.add('WA18   Tsumeb');
        StateFipsCodeCB.Items.add('WA21   Windhoek');
     End;
166: Begin CountryNameEdit.Text:={Nauru-}'NR';
{NR     NAURU  district}
        StateFipsCodeCB.Items.add('NR01   Aiwo');
        StateFipsCodeCB.Items.add('NR02   Anabar');
        StateFipsCodeCB.Items.add('NR03   Anetan');
        StateFipsCodeCB.Items.add('NR04   Anibare');
        StateFipsCodeCB.Items.add('NR05   Baiti');
        StateFipsCodeCB.Items.add('NR06   Boe');
        StateFipsCodeCB.Items.add('NR07   Buada');
        StateFipsCodeCB.Items.add('NR08   Denigomodu');
        StateFipsCodeCB.Items.add('NR09   Ewa');
        StateFipsCodeCB.Items.add('NR10   Ijuw');
        StateFipsCodeCB.Items.add('NR11   Meneng');
        StateFipsCodeCB.Items.add('NR12   Nibok');
        StateFipsCodeCB.Items.add('NR13   Uaboe');
        StateFipsCodeCB.Items.add('NR14   Yaren');
     End;
167: Begin CountryNameEdit.Text:={Navassa Island-}'BQ';
{BQ     NAVASSA ISLAND}
     End;
168: Begin CountryNameEdit.Text:={Nepal-}'NP';
{NP     NEPAL  zone}
        StateFipsCodeCB.Items.add('NP01   Bagmati');
        StateFipsCodeCB.Items.add('NP02   Bheri');
        StateFipsCodeCB.Items.add('NP03   Dhawalagiri');
        StateFipsCodeCB.Items.add('NP04   Gandaki');
        StateFipsCodeCB.Items.add('NP05   Janakpur');
        StateFipsCodeCB.Items.add('NP06   Karnali');
        StateFipsCodeCB.Items.add('NP07   Kosi');
        StateFipsCodeCB.Items.add('NP08   Lumbini');
        StateFipsCodeCB.Items.add('NP09   Mahakali');
        StateFipsCodeCB.Items.add('NP10   Mechi');
        StateFipsCodeCB.Items.add('NP11   Narayani');
        StateFipsCodeCB.Items.add('NP12   Rapti');
        StateFipsCodeCB.Items.add('NP13   Sagarmatha');
        StateFipsCodeCB.Items.add('NP14   Seti');
     End;
169: Begin CountryNameEdit.Text:={Netherlands Antilles-}'NT';
{NT     NETHERLANDS ANTILLES}
     End;
170: Begin CountryNameEdit.Text:={Netherlands-}'NL';
{NL     NETHERLANDS **administrative area
*municipality/gemeente  province/provincie}
        StateFipsCodeCB.Items.add('NL01   Drenthe');
        StateFipsCodeCB.Items.add('NL12   Dronten*');
        StateFipsCodeCB.Items.add('NL02   Friesland');
        StateFipsCodeCB.Items.add('NL03   Gelderland');
        StateFipsCodeCB.Items.add('NL04   Groningen');
        StateFipsCodeCB.Items.add('NL14   Lelystad*');
        StateFipsCodeCB.Items.add('NL05   Limburg');
        StateFipsCodeCB.Items.add('NL06   Noord-Brabant');
        StateFipsCodeCB.Items.add('NL07   Noord-Holland');
        StateFipsCodeCB.Items.add('NL08   Overijssel');
        StateFipsCodeCB.Items.add('NL09   Utrecht');
        StateFipsCodeCB.Items.add('NL10   Zeeland');
        StateFipsCodeCB.Items.add('NL13   Zuidelijke IJsselmeerpolders**');
        StateFipsCodeCB.Items.add('NL11   Zuid-Holland');
      End;
171: Begin CountryNameEdit.Text:={New Caledonia-}'NC';
{NC     NEW CALEDONIA}
     End;
172: Begin CountryNameEdit.Text:={New Zealand-}'NZ';
{NZ     NEW ZEALAND  county  *district  **town district}
        StateFipsCodeCB.Items.add('NZ01   Akaroa');
        StateFipsCodeCB.Items.add('NZ03   Amuri');
        StateFipsCodeCB.Items.add('NZ04   Ashburton');
        StateFipsCodeCB.Items.add('NZ07   Bay of Islands');
        StateFipsCodeCB.Items.add('NZ08   Bruce');
        StateFipsCodeCB.Items.add('NZ09   Buller');
        StateFipsCodeCB.Items.add('NZ10   Chatham Islands');
        StateFipsCodeCB.Items.add('NZ11   Cheviot');
        StateFipsCodeCB.Items.add('NZ12   Clifton');
        StateFipsCodeCB.Items.add('NZ13   Clutha');
        StateFipsCodeCB.Items.add('NZ14   Cook');
        StateFipsCodeCB.Items.add('NZ16   Dannevirke');
        StateFipsCodeCB.Items.add('NZ17   Egmont');
        StateFipsCodeCB.Items.add('NZ18   Eketahuna');
        StateFipsCodeCB.Items.add('NZ19   Ellesmere');
        StateFipsCodeCB.Items.add('NZ20   Eltham');
        StateFipsCodeCB.Items.add('NZ21   Eyre');
        StateFipsCodeCB.Items.add('NZ22   Featherston');
        StateFipsCodeCB.Items.add('NZ24   Franklin');
        StateFipsCodeCB.Items.add('NZ26   Golden Bay');
        StateFipsCodeCB.Items.add('NZ27   Great Barrier Island');
        StateFipsCodeCB.Items.add('NZ28   Grey');
        StateFipsCodeCB.Items.add('NZ29   Hauraki Plains');
        StateFipsCodeCB.Items.add('NZ30   Hawera*');
        StateFipsCodeCB.Items.add('NZ31   Hawke`s Bay');
        StateFipsCodeCB.Items.add('NZ32   Heathcote');
        StateFipsCodeCB.Items.add('NZD9   Hikurangi**');
        StateFipsCodeCB.Items.add('NZ33   Hobson');
        StateFipsCodeCB.Items.add('NZ34   Hokianga');
        StateFipsCodeCB.Items.add('NZ35   Horowhenua');
        StateFipsCodeCB.Items.add('NZD4   Hurunui');
        StateFipsCodeCB.Items.add('NZ36   Hutt');
        StateFipsCodeCB.Items.add('NZ37   Inangahua');
        StateFipsCodeCB.Items.add('NZ38   Inglewood');
        StateFipsCodeCB.Items.add('NZ39   Kaikoura');
        StateFipsCodeCB.Items.add('NZ40   Kairanga');
        StateFipsCodeCB.Items.add('NZ41   Kiwitea');
        StateFipsCodeCB.Items.add('NZ43   Lake');
        StateFipsCodeCB.Items.add('NZ45   Mackenzie');
        StateFipsCodeCB.Items.add('NZ46   Malvern');
        StateFipsCodeCB.Items.add('NZE1   Manaia**');
        StateFipsCodeCB.Items.add('NZ47   Manawatu');
        StateFipsCodeCB.Items.add('NZ48   Mangonui');
        StateFipsCodeCB.Items.add('NZ49   Maniototo');
        StateFipsCodeCB.Items.add('NZ50   Marlborough');
        StateFipsCodeCB.Items.add('NZ51   Masterton');
        StateFipsCodeCB.Items.add('NZ52   Matamata');
        StateFipsCodeCB.Items.add('NZ53   Mount Herbert');
        StateFipsCodeCB.Items.add('NZ54   Ohinemuri');
        StateFipsCodeCB.Items.add('NZ55   Opotiki');
        StateFipsCodeCB.Items.add('NZ56   Oroua');
        StateFipsCodeCB.Items.add('NZ57   Otamatea');
        StateFipsCodeCB.Items.add('NZ58   Otorohanga*');
        StateFipsCodeCB.Items.add('NZ59   Oxford');
        StateFipsCodeCB.Items.add('NZ60   Pahiatua');
        StateFipsCodeCB.Items.add('NZ61   Paparua');
        StateFipsCodeCB.Items.add('NZ63   Patea');
        StateFipsCodeCB.Items.add('NZ65   Piako');
        StateFipsCodeCB.Items.add('NZ66   Pohangina');
        StateFipsCodeCB.Items.add('NZ67   Raglan');
        StateFipsCodeCB.Items.add('NZ68   Rangiora*');
        StateFipsCodeCB.Items.add('NZ69   Rangitikei');
        StateFipsCodeCB.Items.add('NZ70   Rodney');
        StateFipsCodeCB.Items.add('NZ71   Rotorua*');
        StateFipsCodeCB.Items.add('NZE2   Runanga');
        StateFipsCodeCB.Items.add('NZE3   Saint Kilda');
        StateFipsCodeCB.Items.add('NZD5   Silverpeaks');
        StateFipsCodeCB.Items.add('NZ72   Southland');
        StateFipsCodeCB.Items.add('NZ73   Stewart Island');
        StateFipsCodeCB.Items.add('NZ74   Stratford');
        StateFipsCodeCB.Items.add('NZD6   Strathallan');
        StateFipsCodeCB.Items.add('NZ76   Taranaki');
        StateFipsCodeCB.Items.add('NZ77   Taumarunui');
        StateFipsCodeCB.Items.add('NZ78   Taupo');
        StateFipsCodeCB.Items.add('NZ79   Tauranga');
        StateFipsCodeCB.Items.add('NZE4   Thames-Coromandel*');
        StateFipsCodeCB.Items.add('NZ81   Tuapeka');
        StateFipsCodeCB.Items.add('NZ82   Vincent');
        StateFipsCodeCB.Items.add('NZ83   Waiapu');
        StateFipsCodeCB.Items.add('NZD8   Waiheke');
        StateFipsCodeCB.Items.add('NZ84   Waihemo');
        StateFipsCodeCB.Items.add('NZ85   Waikato');
        StateFipsCodeCB.Items.add('NZ86   Waikohu');
        StateFipsCodeCB.Items.add('NZ88   Waimairi');
        StateFipsCodeCB.Items.add('NZ89   Waimarino');
        StateFipsCodeCB.Items.add('NZ90   Waimate');
        StateFipsCodeCB.Items.add('NZ91   Waimate West');
        StateFipsCodeCB.Items.add('NZ92   Waimea');
        StateFipsCodeCB.Items.add('NZ93   Waipa');
        StateFipsCodeCB.Items.add('NZ95   Waipawa*');
        StateFipsCodeCB.Items.add('NZ96   Waipukurau*');
        StateFipsCodeCB.Items.add('NZ97   Wairarapa South');
        StateFipsCodeCB.Items.add('NZ98   Wairewa');
        StateFipsCodeCB.Items.add('NZ99   Wairoa');
        StateFipsCodeCB.Items.add('NZA4   Waitaki');
        StateFipsCodeCB.Items.add('NZA6   Waitomo*');
        StateFipsCodeCB.Items.add('NZA8   Waitotara');
        StateFipsCodeCB.Items.add('NZE6   Wallace');
        StateFipsCodeCB.Items.add('NZB2   Wanganui');
        StateFipsCodeCB.Items.add('NZE5   Waverley**');
        StateFipsCodeCB.Items.add('NZB3   Westland');
        StateFipsCodeCB.Items.add('NZB4   Whakatane*');
        StateFipsCodeCB.Items.add('NZA1   Whangarei');
        StateFipsCodeCB.Items.add('NZA2   Whangaroa');
        StateFipsCodeCB.Items.add('NZA3   Woodville');
     End;
173: Begin CountryNameEdit.Text:={Nicaragua-}'NU';
{NU     NICARAGUA  department/departamento}
        StateFipsCodeCB.Items.add('NU01   Boaco');
        StateFipsCodeCB.Items.add('NU02   Carazo');
        StateFipsCodeCB.Items.add('NU03   Chinandega');
        StateFipsCodeCB.Items.add('NU04   Chontales');
        StateFipsCodeCB.Items.add('NU05   Esteli');
        StateFipsCodeCB.Items.add('NU06   Granada');
        StateFipsCodeCB.Items.add('NU07   Jinotega');
        StateFipsCodeCB.Items.add('NU08   Leon');
        StateFipsCodeCB.Items.add('NU09   Madriz');
        StateFipsCodeCB.Items.add('NU10   Managua');
        StateFipsCodeCB.Items.add('NU11   Masaya');
        StateFipsCodeCB.Items.add('NU12   Matagalpa');
        StateFipsCodeCB.Items.add('NU13   Nueva Segovia');
        StateFipsCodeCB.Items.add('NU14   Rio San Juan');
        StateFipsCodeCB.Items.add('NU15   Rivas');
        StateFipsCodeCB.Items.add('NU16   Zelaya');
    End;
174: Begin CountryNameEdit.Text:={Nigeria-}'NI';
{NI     NIGERIA  state  *capital territory}
        StateFipsCodeCB.Items.add('NI34   Abia');
        StateFipsCodeCB.Items.add('NI11   Abuja Capital Territory*');
        StateFipsCodeCB.Items.add('NI35   Adamawa');
        StateFipsCodeCB.Items.add('NI21   Akwa Ibom');
        StateFipsCodeCB.Items.add('NI25   Anambra');
        StateFipsCodeCB.Items.add('NI06   Bauchi');
        StateFipsCodeCB.Items.add('NI26   Benue');
        StateFipsCodeCB.Items.add('NI27   Borno');
        StateFipsCodeCB.Items.add('NI22   Cross River');
        StateFipsCodeCB.Items.add('NI36   Delta');
        StateFipsCodeCB.Items.add('NI37   Edo');
        StateFipsCodeCB.Items.add('NI38   Enugu');
        StateFipsCodeCB.Items.add('NI28   Imo');
        StateFipsCodeCB.Items.add('NI39   Jigawa');
        StateFipsCodeCB.Items.add('NI23   Kaduna');
        StateFipsCodeCB.Items.add('NI29   Kano');
        StateFipsCodeCB.Items.add('NI24   Katsina');
        StateFipsCodeCB.Items.add('NI40   Kebbi');
        StateFipsCodeCB.Items.add('NI41   Kogi');
        StateFipsCodeCB.Items.add('NI30   Kwara');
        StateFipsCodeCB.Items.add('NI05   Lagos');
        StateFipsCodeCB.Items.add('NI31   Niger');
        StateFipsCodeCB.Items.add('NI16   Ogun');
        StateFipsCodeCB.Items.add('NI17   Ondo');
        StateFipsCodeCB.Items.add('NI42   Osun');
        StateFipsCodeCB.Items.add('NI32   Oyo');
        StateFipsCodeCB.Items.add('NI19   Plateau');
        StateFipsCodeCB.Items.add('NI10   Rivers');
        StateFipsCodeCB.Items.add('NI33   Sokoto');
        StateFipsCodeCB.Items.add('NI43   Taraba');
        StateFipsCodeCB.Items.add('NI44   Yobe');
     End;
175: Begin CountryNameEdit.Text:={Niger-}'NG';
{NG     NIGER department/departement}
        StateFipsCodeCB.Items.add('NG01   Agadez');
        StateFipsCodeCB.Items.add('NG02   Diffa');
        StateFipsCodeCB.Items.add('NG03   Dosso');
        StateFipsCodeCB.Items.add('NG04   Maradi');
        StateFipsCodeCB.Items.add('NG05   Niamey');
        StateFipsCodeCB.Items.add('NG06   Tahoua');
        StateFipsCodeCB.Items.add('NG07   Zinder');
     End;
176: Begin CountryNameEdit.Text:={Niue-}'NE';
{NE     NIUE}
     End;
177: Begin CountryNameEdit.Text:={Norfolk Island-}'NF';
{NF     NORFOLK ISLAND}
     End;
178: Begin CountryNameEdit.Text:={Northern Mariana Islands-}'CQ';
{CQ     NORTHERN MARIANA ISLANDS}
     End;
179: Begin CountryNameEdit.Text:={Norway-}'NO';
{NO     NORWAY  province/fylke}
        StateFipsCodeCB.Items.add('NO01   Akershus');
        StateFipsCodeCB.Items.add('NO02   Aust-Agder');
        StateFipsCodeCB.Items.add('NO04   Buskerud');
        StateFipsCodeCB.Items.add('NO05   Finnmark');
        StateFipsCodeCB.Items.add('NO06   Hedmark');
        StateFipsCodeCB.Items.add('NO07   Hordaland');
        StateFipsCodeCB.Items.add('NO08   More og Romsdal');
        StateFipsCodeCB.Items.add('NO09   Nordland');
        StateFipsCodeCB.Items.add('NO10   Nord-Trondelag');
        StateFipsCodeCB.Items.add('NO11   Oppland');
        StateFipsCodeCB.Items.add('NO12   Oslo');
        StateFipsCodeCB.Items.add('NO13   Ostfold');
        StateFipsCodeCB.Items.add('NO14   Rogaland');
        StateFipsCodeCB.Items.add('NO15   Sogn og Fjordane');
        StateFipsCodeCB.Items.add('NO16   Sor-Trondelag');
        StateFipsCodeCB.Items.add('NO17   Telemark');
        StateFipsCodeCB.Items.add('NO18   Troms');
        StateFipsCodeCB.Items.add('NO19   Vest-Agder');
        StateFipsCodeCB.Items.add('NO20   Vestfold');
     End;
180: Begin CountryNameEdit.Text:={Oman-}'MU';
{MU     OMAN}
     End;
181: Begin CountryNameEdit.Text:={Pakistan-}'PK';
{PK     PAKISTAN ***capital territory
**Pakistan-administered area  province  *territory }
        StateFipsCodeCB.Items.add('PK06   Azad Kashmir**');
        StateFipsCodeCB.Items.add('PK02   Balochistan');
        StateFipsCodeCB.Items.add('PK01   Federally Administered Tribal Areas*');
        StateFipsCodeCB.Items.add('PK08   Islamabad***');
        StateFipsCodeCB.Items.add('PK07   Northern Areas**');
        StateFipsCodeCB.Items.add('PK03   North-West Frontier');
        StateFipsCodeCB.Items.add('PK04   Punjab');
        StateFipsCodeCB.Items.add('PK05   Sindh');
     End;
182: Begin CountryNameEdit.Text:={Palau, Republic Of-}'PS';
{PS     TRUST TERRITORY OF THE PACIFIC ISLANDS (PALAU)}
     End;
183: Begin CountryNameEdit.Text:={Palmyra Atoll-}'LQ';
{LQ     PALMYRA ATOLL}
     End;
184: Begin CountryNameEdit.Text:={Panama-}'PM';
{PM     PANAMA  *intendancy/intendencia province/provincia}
        StateFipsCodeCB.Items.add('PM01   Bocas del Toro');
        StateFipsCodeCB.Items.add('PM02   Chiriqui');
        StateFipsCodeCB.Items.add('PM03   Cocle');
        StateFipsCodeCB.Items.add('PM04   Colon');
        StateFipsCodeCB.Items.add('PM05   Darien');
        StateFipsCodeCB.Items.add('PM06   Herrera');
        StateFipsCodeCB.Items.add('PM07   Los Santos');
        StateFipsCodeCB.Items.add('PM08   Panama');
        StateFipsCodeCB.Items.add('PM09   San Blas*');
        StateFipsCodeCB.Items.add('PM10   Veraguas');
     End;
185: Begin CountryNameEdit.Text:={Papua New Guinea-}'PP';
{PP     PAPUA NEW GUINEA  province}
        StateFipsCodeCB.Items.add('PP01   Central');
        StateFipsCodeCB.Items.add('PP08   Chimbu');
        StateFipsCodeCB.Items.add('PP09   Eastern Highlands');
        StateFipsCodeCB.Items.add('PP10   East New Britain');
        StateFipsCodeCB.Items.add('PP11   East Sepik');
        StateFipsCodeCB.Items.add('PP19   Enga');
        StateFipsCodeCB.Items.add('PP02   Gulf');
        StateFipsCodeCB.Items.add('PP12   Madang');
        StateFipsCodeCB.Items.add('PP13   Manus');
        StateFipsCodeCB.Items.add('PP03   Milne Bay');
        StateFipsCodeCB.Items.add('PP14   Morobe');
        StateFipsCodeCB.Items.add('PP20   National Capital');
        StateFipsCodeCB.Items.add('PP15   New Ireland');
        StateFipsCodeCB.Items.add('PP04   Northern');
        StateFipsCodeCB.Items.add('PP07   North Solomons');
        StateFipsCodeCB.Items.add('PP18   Sandaun');
        StateFipsCodeCB.Items.add('PP05   Southern Highlands');
        StateFipsCodeCB.Items.add('PP06   Western');
        StateFipsCodeCB.Items.add('PP16   Western Highlands');
        StateFipsCodeCB.Items.add('PP17   West New Britain');
     End;
186: Begin CountryNameEdit.Text:={Paracel Islands-}'PF';
{PF     PARACEL ISLANDS}
     End;
187: Begin CountryNameEdit.Text:={Paraguay-}'PA';
{PA     PARAGUAY department/departamento}
        StateFipsCodeCB.Items.add('PA18   Alto Paraguay');
        StateFipsCodeCB.Items.add('PA01   Alto Parana');
        StateFipsCodeCB.Items.add('PA02   Amambay');
        StateFipsCodeCB.Items.add('PA03   Boqueron');
        StateFipsCodeCB.Items.add('PA04   Caaguazu');
        StateFipsCodeCB.Items.add('PA05   Caazapa');
        StateFipsCodeCB.Items.add('PA19   Canindeyu');
        StateFipsCodeCB.Items.add('PA06   Central');
        StateFipsCodeCB.Items.add('PA20   Chaco');
        StateFipsCodeCB.Items.add('PA07   Concepcion');
        StateFipsCodeCB.Items.add('PA08   Cordillera');
        StateFipsCodeCB.Items.add('PA10   Guaira');
        StateFipsCodeCB.Items.add('PA11   Itapua');
        StateFipsCodeCB.Items.add('PA12   Misiones');
        StateFipsCodeCB.Items.add('PA13   Neembucu');
        StateFipsCodeCB.Items.add('PA21   Nueva Asuncion');
        StateFipsCodeCB.Items.add('PA15   Paraguari');
        StateFipsCodeCB.Items.add('PA16   Presidente Hayes');
        StateFipsCodeCB.Items.add('PA17   San Pedro');
     End;
188: Begin CountryNameEdit.Text:={Peru-}'PE';
{PE     PERU
*constitutional province/provincia constitucional
department/departamento}
        StateFipsCodeCB.Items.add('PE01   Amazonas');
        StateFipsCodeCB.Items.add('PE02   Ancash');
        StateFipsCodeCB.Items.add('PE03   Apurimac');
        StateFipsCodeCB.Items.add('PE04   Arequipa');
        StateFipsCodeCB.Items.add('PE05   Ayacucho');
        StateFipsCodeCB.Items.add('PE06   Cajamarca');
        StateFipsCodeCB.Items.add('PE07   Callao*');
        StateFipsCodeCB.Items.add('PE08   Cusco');
        StateFipsCodeCB.Items.add('PE09   Huancavelica');
        StateFipsCodeCB.Items.add('PE10   Huanuco');
        StateFipsCodeCB.Items.add('PE11   Ica');
        StateFipsCodeCB.Items.add('PE12   Junin');
        StateFipsCodeCB.Items.add('PE13   La Libertad');
        StateFipsCodeCB.Items.add('PE14   Lambayeque');
        StateFipsCodeCB.Items.add('PE15   Lima');
        StateFipsCodeCB.Items.add('PE16   Loreto');
        StateFipsCodeCB.Items.add('PE17   Madre de Dios');
        StateFipsCodeCB.Items.add('PE18   Moquegua');
        StateFipsCodeCB.Items.add('PE19   Pasco');
        StateFipsCodeCB.Items.add('PE20   Piura');
        StateFipsCodeCB.Items.add('PE21   Puno');
        StateFipsCodeCB.Items.add('PE22   San Martin');
        StateFipsCodeCB.Items.add('PE23   Tacna');
        StateFipsCodeCB.Items.add('PE24   Tumbes');
        StateFipsCodeCB.Items.add('PE25   Ucayali');
     End;
189: Begin CountryNameEdit.Text:={Phillipines-}'RP';
{RP     PHILIPPINES      *chartered city  province}
        StateFipsCodeCB.Items.add('RP01   Abra');
        StateFipsCodeCB.Items.add('RP02   Agusan del Norte');
        StateFipsCodeCB.Items.add('RP03   Agusan del Sur');
        StateFipsCodeCB.Items.add('RP04   Aklan');
        StateFipsCodeCB.Items.add('RP05   Albay');
        StateFipsCodeCB.Items.add('RPA1   Angeles*');
        StateFipsCodeCB.Items.add('RP06   Antique');
        StateFipsCodeCB.Items.add('RPG8   Aurora');
        StateFipsCodeCB.Items.add('RPA2   Bacolod*');
        StateFipsCodeCB.Items.add('RPA3   Bago*');
        StateFipsCodeCB.Items.add('RPA4   Baguio*');
        StateFipsCodeCB.Items.add('RPA5   Bais*');
        StateFipsCodeCB.Items.add('RP22   Basilan');
        StateFipsCodeCB.Items.add('RPA6   Basilan City*');
        StateFipsCodeCB.Items.add('RP07   Bataan');
        StateFipsCodeCB.Items.add('RP08   Batanes');
        StateFipsCodeCB.Items.add('RP09   Batangas');
        StateFipsCodeCB.Items.add('RPA7   Batangas City*');
        StateFipsCodeCB.Items.add('RP10   Benguet');
        StateFipsCodeCB.Items.add('RP11   Bohol');
        StateFipsCodeCB.Items.add('RP12   Bukidnon');
        StateFipsCodeCB.Items.add('RP13   Bulacan');
        StateFipsCodeCB.Items.add('RPA8   Butuan*');
        StateFipsCodeCB.Items.add('RPA9   Cabanatuan*');
        StateFipsCodeCB.Items.add('RPB1   Cadiz*');
        StateFipsCodeCB.Items.add('RP14   Cagayan');
        StateFipsCodeCB.Items.add('RPB2   Cagayan de Oro*');
        StateFipsCodeCB.Items.add('RPB3   Calbayog*');
        StateFipsCodeCB.Items.add('RPB4   Caloocan*');
        StateFipsCodeCB.Items.add('RP15   Camarines Norte');
        StateFipsCodeCB.Items.add('RP16   Camarines Sur');
        StateFipsCodeCB.Items.add('RP17   Camiguin');
        StateFipsCodeCB.Items.add('RPB5   Canlaon*');
        StateFipsCodeCB.Items.add('RP18   Capiz');
        StateFipsCodeCB.Items.add('RP19   Catanduanes');
        StateFipsCodeCB.Items.add('RP20   Cavite');
        StateFipsCodeCB.Items.add('RPB6   Cavite City*');
        StateFipsCodeCB.Items.add('RP21   Cebu');
        StateFipsCodeCB.Items.add('RPB7   Cebu City*');
        StateFipsCodeCB.Items.add('RPB8   Cotabato*');
        StateFipsCodeCB.Items.add('RPB9   Dagupan*');
        StateFipsCodeCB.Items.add('RPC1   Danao*');
        StateFipsCodeCB.Items.add('RPC2   Dapitan*');
        StateFipsCodeCB.Items.add('RP24   Davao');
        StateFipsCodeCB.Items.add('RPC3   Davao City*');
        StateFipsCodeCB.Items.add('RP25   Davao del Sur');
        StateFipsCodeCB.Items.add('RP26   Davao Oriental');
        StateFipsCodeCB.Items.add('RPC4   Dipolog*');
        StateFipsCodeCB.Items.add('RPC5   Dumaguete*');
        StateFipsCodeCB.Items.add('RP23   Eastern Samar');
        StateFipsCodeCB.Items.add('RPC6   General Santos*');
        StateFipsCodeCB.Items.add('RPC7   Gingoog*');
        StateFipsCodeCB.Items.add('RP27   Ifugao');
        StateFipsCodeCB.Items.add('RPC8   Iligan*');
        StateFipsCodeCB.Items.add('RP28   Ilocos Norte');
        StateFipsCodeCB.Items.add('RP29   Ilocos Sur');
        StateFipsCodeCB.Items.add('RP30   Iloilo');
        StateFipsCodeCB.Items.add('RPC9   Iloilo City*');
        StateFipsCodeCB.Items.add('RPD1   Iriga*');
        StateFipsCodeCB.Items.add('RP31   Isabela');
        StateFipsCodeCB.Items.add('RP32   Kalinga-Apayao');
        StateFipsCodeCB.Items.add('RPD2   La Carlota*');
        StateFipsCodeCB.Items.add('RP33   Laguna');
        StateFipsCodeCB.Items.add('RP34   Lanao del Norte');
        StateFipsCodeCB.Items.add('RP35   Lanao del Sur');
        StateFipsCodeCB.Items.add('RPD3   Laoag*');
        StateFipsCodeCB.Items.add('RPD4   Lapu-Lapu*');
        StateFipsCodeCB.Items.add('RP36   La Union');
        StateFipsCodeCB.Items.add('RPD5   Legaspi*');
        StateFipsCodeCB.Items.add('RP37   Leyte');
        StateFipsCodeCB.Items.add('RPD6   Lipa*');
        StateFipsCodeCB.Items.add('RPD7   Lucena*');
        StateFipsCodeCB.Items.add('RP56   Maguindanao');
        StateFipsCodeCB.Items.add('RPD8   Mandaue*');
        StateFipsCodeCB.Items.add('RPD9   Manila*');
        StateFipsCodeCB.Items.add('RPE1   Marawi*');
        StateFipsCodeCB.Items.add('RP38   Marinduque');
        StateFipsCodeCB.Items.add('RP39   Masbate');
        StateFipsCodeCB.Items.add('RP40   Mindoro Occidental');
        StateFipsCodeCB.Items.add('RP41   Mindoro Oriental');
        StateFipsCodeCB.Items.add('RP42   Misamis Occidental');
        StateFipsCodeCB.Items.add('RP43   Misamis Oriental');
        StateFipsCodeCB.Items.add('RP44   Mountain');
        StateFipsCodeCB.Items.add('RPE2   Naga*');
        StateFipsCodeCB.Items.add('RPH3   Negros Occidental');
        StateFipsCodeCB.Items.add('RP46   Negros Oriental');
        StateFipsCodeCB.Items.add('RP57   North Cotabato');
        StateFipsCodeCB.Items.add('RP67   Northern Samar');
        StateFipsCodeCB.Items.add('RP47   Nueva Ecija');
        StateFipsCodeCB.Items.add('RP48   Nueva Vizcaya');
        StateFipsCodeCB.Items.add('RPE3   Olongapo*');
        StateFipsCodeCB.Items.add('RPE4   Ormoc*');
        StateFipsCodeCB.Items.add('RPE5   Oroquieta*');
        StateFipsCodeCB.Items.add('RPE6   Ozamis*');
        StateFipsCodeCB.Items.add('RPE7   Pagadian*');
        StateFipsCodeCB.Items.add('RP49   Palawan');
        StateFipsCodeCB.Items.add('RPE8   Palayan*');
        StateFipsCodeCB.Items.add('RP50   Pampanga');
        StateFipsCodeCB.Items.add('RP51   Pangasinan');
        StateFipsCodeCB.Items.add('RPE9   Pasay*');
        StateFipsCodeCB.Items.add('RPF1   Puerto Princesa*');
        StateFipsCodeCB.Items.add('RPH2   Quezon');
        StateFipsCodeCB.Items.add('RPF2   Quezon City*');
        StateFipsCodeCB.Items.add('RP68   Quirino');
        StateFipsCodeCB.Items.add('RP53   Rizal');
        StateFipsCodeCB.Items.add('RP54   Romblon');
        StateFipsCodeCB.Items.add('RPF3   Roxas*');
        StateFipsCodeCB.Items.add('RP55   Samar');
        StateFipsCodeCB.Items.add('RPF4   San Carlos, Negros Occidental*');
        StateFipsCodeCB.Items.add('RPF5   San Carlos, Pangasinan*');
        StateFipsCodeCB.Items.add('RPF6   San Jose*');
        StateFipsCodeCB.Items.add('RPF7   San Pablo*');
        StateFipsCodeCB.Items.add('RPF8   Silay*');
        StateFipsCodeCB.Items.add('RP69   Siquijor');
        StateFipsCodeCB.Items.add('RP58   Sorsogon');
        StateFipsCodeCB.Items.add('RP70   South Cotabato');
        StateFipsCodeCB.Items.add('RP59   Southern Leyte');
        StateFipsCodeCB.Items.add('RP71   Sultan Kudarat');
        StateFipsCodeCB.Items.add('RP60   Sulu');
        StateFipsCodeCB.Items.add('RPF9   Surigao*');
        StateFipsCodeCB.Items.add('RP61   Surigao del Norte');
        StateFipsCodeCB.Items.add('RP62   Surigao del Sur');
        StateFipsCodeCB.Items.add('RPG1   Tacloban*');
        StateFipsCodeCB.Items.add('RPG2   Tagaytay*');
        StateFipsCodeCB.Items.add('RPG3   Tagbilaran*');
        StateFipsCodeCB.Items.add('RPG4   Tangub*');
        StateFipsCodeCB.Items.add('RP63   Tarlac');
        StateFipsCodeCB.Items.add('RP72   Tawitawi');
        StateFipsCodeCB.Items.add('RPG5   Toledo*');
        StateFipsCodeCB.Items.add('RPG6   Trece Martires*');
        StateFipsCodeCB.Items.add('RP64   Zambales');
        StateFipsCodeCB.Items.add('RPG7   Zamboanga*');
        StateFipsCodeCB.Items.add('RP65   Zamboanga del Norte');
        StateFipsCodeCB.Items.add('RP66   Zamboanga del Sur');
    End;
190: Begin CountryNameEdit.Text:={Pitcairn Islands-}'PC';
{PC     PITCAIRN ISLANDS}
     End;
191: Begin CountryNameEdit.Text:={Poland-}'PL';
{PL     POLAND      province/wojewodztwo}
        StateFipsCodeCB.Items.add('PL23   Biala Podlaska');
        StateFipsCodeCB.Items.add('PL24   Bialystok');
        StateFipsCodeCB.Items.add('PL25   Bielsko');
        StateFipsCodeCB.Items.add('PL26   Bydgoszcz');
        StateFipsCodeCB.Items.add('PL27   Chelm');
        StateFipsCodeCB.Items.add('PL28   Ciechanow');
        StateFipsCodeCB.Items.add('PL29   Czestochowa');
        StateFipsCodeCB.Items.add('PL30   Elblag');
        StateFipsCodeCB.Items.add('PL31   Gdansk');
        StateFipsCodeCB.Items.add('PL32   Gorzow');
        StateFipsCodeCB.Items.add('PL33   Jelenia Gora');
        StateFipsCodeCB.Items.add('PL34   Kalisz');
        StateFipsCodeCB.Items.add('PL35   Katowice');
        StateFipsCodeCB.Items.add('PL36   Kielce');
        StateFipsCodeCB.Items.add('PL37   Konin');
        StateFipsCodeCB.Items.add('PL38   Koszalin');
        StateFipsCodeCB.Items.add('PL39   Krakow');
        StateFipsCodeCB.Items.add('PL40   Krosno');
        StateFipsCodeCB.Items.add('PL41   Legnica');
        StateFipsCodeCB.Items.add('PL42   Leszno');
        StateFipsCodeCB.Items.add('PL43   Lodz');
        StateFipsCodeCB.Items.add('PL44   Lomza');
        StateFipsCodeCB.Items.add('PL45   Lublin');
        StateFipsCodeCB.Items.add('PL46   Nowy Sacz');
        StateFipsCodeCB.Items.add('PL47   Olsztyn');
        StateFipsCodeCB.Items.add('PL48   Opole');
        StateFipsCodeCB.Items.add('PL49   Ostroleka');
        StateFipsCodeCB.Items.add('PL50   Pila');
        StateFipsCodeCB.Items.add('PL51   Piotrkow');
        StateFipsCodeCB.Items.add('PL52   Plock');
        StateFipsCodeCB.Items.add('PL53   Poznan');
        StateFipsCodeCB.Items.add('PL54   Przemysl');
        StateFipsCodeCB.Items.add('PL55   Radom');
        StateFipsCodeCB.Items.add('PL56   Rzeszow');
        StateFipsCodeCB.Items.add('PL57   Siedlce');
        StateFipsCodeCB.Items.add('PL58   Sieradz');
        StateFipsCodeCB.Items.add('PL59   Skierniewice');
        StateFipsCodeCB.Items.add('PL60   Slupsk');
        StateFipsCodeCB.Items.add('PL61   Suwalki');
        StateFipsCodeCB.Items.add('PL62   Szczecin');
        StateFipsCodeCB.Items.add('PL63   Tarnobrzeg');
        StateFipsCodeCB.Items.add('PL64   Tarnow');
        StateFipsCodeCB.Items.add('PL65   Torun');
        StateFipsCodeCB.Items.add('PL66   Walbrzych');
        StateFipsCodeCB.Items.add('PL67   Warszawa');
        StateFipsCodeCB.Items.add('PL68   Wloclawek');
        StateFipsCodeCB.Items.add('PL69   Wroclaw');
        StateFipsCodeCB.Items.add('PL70   Zamosc');
        StateFipsCodeCB.Items.add('PL71   Zielona Gora');
    End;
192: Begin CountryNameEdit.Text:={Portugal-}'PO';
{PO     PORTUGAL *autonomous region/regiao autonoma
district/distrito}
        StateFipsCodeCB.Items.add('PO02   Aveiro');
        StateFipsCodeCB.Items.add('PO23   Azores*');
        StateFipsCodeCB.Items.add('PO03   Beja');
        StateFipsCodeCB.Items.add('PO04   Braga');
        StateFipsCodeCB.Items.add('PO05   Braganca');
        StateFipsCodeCB.Items.add('PO06   Castelo Branco');
        StateFipsCodeCB.Items.add('PO07   Coimbra');
        StateFipsCodeCB.Items.add('PO08   Evora');
        StateFipsCodeCB.Items.add('PO09   Faro');
        StateFipsCodeCB.Items.add('PO11   Guarda');
        StateFipsCodeCB.Items.add('PO13   Leiria');
        StateFipsCodeCB.Items.add('PO14   Lisboa');
        StateFipsCodeCB.Items.add('PO10   Madeira*');
        StateFipsCodeCB.Items.add('PO16   Portalegre');
        StateFipsCodeCB.Items.add('PO17   Porto');
        StateFipsCodeCB.Items.add('PO18   Santarem');
        StateFipsCodeCB.Items.add('PO19   Setubal');
        StateFipsCodeCB.Items.add('PO20   Viana do Castelo');
        StateFipsCodeCB.Items.add('PO21   Vila Real');
        StateFipsCodeCB.Items.add('PO22   Viseu');
    End;
193: Begin CountryNameEdit.Text:={Puerto Rico-}'RQ';
{RQ     PUERTO RICO}
     End;
194: Begin CountryNameEdit.Text:={Qatar-}'QA';
{QA     QATAR}
     End;
195: Begin CountryNameEdit.Text:={Reunion-}'RE';
{RE     REUNION}
     End;
196: Begin CountryNameEdit.Text:={Romania-}'RO';
{RO     ROMANIA  county/judet  *municipality/municipiu}
        StateFipsCodeCB.Items.add('RO01   Alba');
        StateFipsCodeCB.Items.add('RO02   Arad');
        StateFipsCodeCB.Items.add('RO03   Arges');
        StateFipsCodeCB.Items.add('RO04   Bacau');
        StateFipsCodeCB.Items.add('RO05   Bihor');
        StateFipsCodeCB.Items.add('RO06   Bistrita-Nasaud');
        StateFipsCodeCB.Items.add('RO07   Botosani');
        StateFipsCodeCB.Items.add('RO08   Braila');
        StateFipsCodeCB.Items.add('RO09   Brasov');
        StateFipsCodeCB.Items.add('RO10   Bucuresti*');
        StateFipsCodeCB.Items.add('RO11   Buzau');
        StateFipsCodeCB.Items.add('RO41   Calarasi');
        StateFipsCodeCB.Items.add('RO12   Caras-Severin');
        StateFipsCodeCB.Items.add('RO13   Cluj');
        StateFipsCodeCB.Items.add('RO14   Constanta');
        StateFipsCodeCB.Items.add('RO15   Covasna');
        StateFipsCodeCB.Items.add('RO16   Dimbovita');
        StateFipsCodeCB.Items.add('RO17   Dolj');
        StateFipsCodeCB.Items.add('RO18   Galati');
        StateFipsCodeCB.Items.add('RO19   Gorj');
        StateFipsCodeCB.Items.add('RO42   Giurgiu');
        StateFipsCodeCB.Items.add('RO20   Harghita');
        StateFipsCodeCB.Items.add('RO21   Hunedoara');
        StateFipsCodeCB.Items.add('RO22   Ialomita');
        StateFipsCodeCB.Items.add('RO23   Iasi');
        StateFipsCodeCB.Items.add('RO25   Maramures');
        StateFipsCodeCB.Items.add('RO26   Mehedinti');
        StateFipsCodeCB.Items.add('RO27   Mures');
        StateFipsCodeCB.Items.add('RO28   Neamt');
        StateFipsCodeCB.Items.add('RO29   Olt');
        StateFipsCodeCB.Items.add('RO30   Prahova');
        StateFipsCodeCB.Items.add('RO31   Salaj');
        StateFipsCodeCB.Items.add('RO32   Satu Mare');
        StateFipsCodeCB.Items.add('RO33   Sibiu');
        StateFipsCodeCB.Items.add('RO34   Suceava');
        StateFipsCodeCB.Items.add('RO35   Teleorman');
        StateFipsCodeCB.Items.add('RO36   Timis');
        StateFipsCodeCB.Items.add('RO37   Tulcea');
        StateFipsCodeCB.Items.add('RO38   Vaslui');
        StateFipsCodeCB.Items.add('RO39   Vilcea');
        StateFipsCodeCB.Items.add('RO40   Vrancea');
      End;
197: Begin CountryNameEdit.Text:={Russia-}'RS';
{RS     RUSSIA}
     End; 
198: Begin CountryNameEdit.Text:={Rwanda-}'RW';
{RW     RWANDA
prefecture/prefecture (French), prefegitura (Kinyarwanda)}
        StateFipsCodeCB.Items.add('RW01   Butare');
        StateFipsCodeCB.Items.add('RW02   Byumba');
        StateFipsCodeCB.Items.add('RW03   Cyangugu');
        StateFipsCodeCB.Items.add('RW04   Gikongoro');
        StateFipsCodeCB.Items.add('RW05   Gisenyi');
        StateFipsCodeCB.Items.add('RW06   Gitarama');
        StateFipsCodeCB.Items.add('RW07   Kibungo');
        StateFipsCodeCB.Items.add('RW08   Kibuye');
        StateFipsCodeCB.Items.add('RW09   Kigali');
        StateFipsCodeCB.Items.add('RW10   Ruhengeri');
    End;
199: Begin CountryNameEdit.Text:={Samoa-}'WS';
{WS     WESTERN SAMOA  district}
        StateFipsCodeCB.Items.add('WS01   A`ana');
        StateFipsCodeCB.Items.add('WS02   Aiga-i-le-Tai');
        StateFipsCodeCB.Items.add('WS03   Atua');
        StateFipsCodeCB.Items.add('WS04   Fa`asaleleaga');
        StateFipsCodeCB.Items.add('WS05   Gaga`emauga');
        StateFipsCodeCB.Items.add('WS07   Gagaifomauga');
        StateFipsCodeCB.Items.add('WS08   Palauli');
        StateFipsCodeCB.Items.add('WS09   Satupa`itea');
        StateFipsCodeCB.Items.add('WS10   Tuamasaga');
        StateFipsCodeCB.Items.add('WS06   Va`a-o-Fonoti');
        StateFipsCodeCB.Items.add('WS11   Vaisigano');
    End;
200: Begin CountryNameEdit.Text:={San Marino-}'SM';
{SM     SAN MARINO municipality/castello}
        StateFipsCodeCB.Items.add('SM01   Acquaviva');
        StateFipsCodeCB.Items.add('SM06   Borgo Maggiore');
        StateFipsCodeCB.Items.add('SM02   Chiesanuova');
        StateFipsCodeCB.Items.add('SM03   Domagnano');
        StateFipsCodeCB.Items.add('SM04   Faetano');
        StateFipsCodeCB.Items.add('SM05   Fiorentino');
        StateFipsCodeCB.Items.add('SM08   Monte Giardino');
        StateFipsCodeCB.Items.add('SM07   San Marino');
        StateFipsCodeCB.Items.add('SM09   Serravalle');
     End;
201: Begin CountryNameEdit.Text:={Sao Tome and Principe-}'TP';
{TP     SAO TOME AND PRINCIPE district/concelho}
        StateFipsCodeCB.Items.add('TP01   Principe');
        StateFipsCodeCB.Items.add('TP02   Sao Tome');
     End;
202: Begin CountryNameEdit.Text:={Saudi Arabia-}'SA';
{SA     SAUDI ARABIA emirate/mintaqah}
        StateFipsCodeCB.Items.add('SA02   Al Bahah');
        StateFipsCodeCB.Items.add('SA15   Al Hudud ash Shamaliyah');
        StateFipsCodeCB.Items.add('SA03   Al Jawf');
        StateFipsCodeCB.Items.add('SA05   Al Madinah');
        StateFipsCodeCB.Items.add('SA08   Al Qasim');
        StateFipsCodeCB.Items.add('SA09   Al Qurayyat');
        StateFipsCodeCB.Items.add('SA10   Ar Riyad');
        StateFipsCodeCB.Items.add('SA06   Ash Sharqiyah');
        StateFipsCodeCB.Items.add('SA11   `Asir');
        StateFipsCodeCB.Items.add('SA13   Ha`il');
        StateFipsCodeCB.Items.add('SA17   Jizan');
        StateFipsCodeCB.Items.add('SA14   Makkah');
        StateFipsCodeCB.Items.add('SA16   Najran');
        StateFipsCodeCB.Items.add('SA19   Tabuk');
    End;
203: Begin CountryNameEdit.Text:={Senegal-}'SG';
{SG     SENEGAL   region/region}
        StateFipsCodeCB.Items.add('SG01   Dakar');
        StateFipsCodeCB.Items.add('SG03   Diourbel');
        StateFipsCodeCB.Items.add('SG09   Fatick');
        StateFipsCodeCB.Items.add('SG10   Kaolack');
        StateFipsCodeCB.Items.add('SG11   Kolda');
        StateFipsCodeCB.Items.add('SG08   Louga');
        StateFipsCodeCB.Items.add('SG04   Saint-Louis');
        StateFipsCodeCB.Items.add('SG05   Tambacounda');
        StateFipsCodeCB.Items.add('SG07   Thies');
        StateFipsCodeCB.Items.add('SG12   Ziguinchor');
    End;
204: Begin CountryNameEdit.Text:={Seychelles-}'SE';
{SE     SEYCHELLES  district/district}
        StateFipsCodeCB.Items.add('SE01   Anse aux Pins');
        StateFipsCodeCB.Items.add('SE02   Anse Boileau');
        StateFipsCodeCB.Items.add('SE03   Anse Etoile');
        StateFipsCodeCB.Items.add('SE04   Anse Louis');
        StateFipsCodeCB.Items.add('SE05   Anse Royale');
        StateFipsCodeCB.Items.add('SE06   Baie Lazare');
        StateFipsCodeCB.Items.add('SE07   Baie Sainte Anne');
        StateFipsCodeCB.Items.add('SE08   Beau Vallon');
        StateFipsCodeCB.Items.add('SE09   Bel Air');
        StateFipsCodeCB.Items.add('SE10   Bel Ombre');
        StateFipsCodeCB.Items.add('SE11   Cascade');
        StateFipsCodeCB.Items.add('SE12   Glacis');
        StateFipsCodeCB.Items.add('SE13   Grand` Anse (Mahe)');
        StateFipsCodeCB.Items.add('SE14   Grand` Anse (Praslin)');
        StateFipsCodeCB.Items.add('SE15   La Digue');
        StateFipsCodeCB.Items.add('SE16   La Riviere Anglaise');
        StateFipsCodeCB.Items.add('SE17   Mont Buxton');
        StateFipsCodeCB.Items.add('SE18   Mont Fleuri');
        StateFipsCodeCB.Items.add('SE19   Plaisance');
        StateFipsCodeCB.Items.add('SE20   Pointe La Rue');
        StateFipsCodeCB.Items.add('SE21   Port Glaud');
        StateFipsCodeCB.Items.add('SE22   Saint Louis');
        StateFipsCodeCB.Items.add('SE23   Takamaka');
    End;

{SR     SERBIA}

205: Begin CountryNameEdit.Text:={Sierra Leone-}'SL';
{SL     SIERRA LEONE province}
        StateFipsCodeCB.Items.add('SL01   Eastern');
        StateFipsCodeCB.Items.add('SL02   Northern');
        StateFipsCodeCB.Items.add('SL03   Southern');
        StateFipsCodeCB.Items.add('SL04   Western Area');
     End;
206: Begin CountryNameEdit.Text:={Singapore-}'SN';
{SN     SINGAPORE}
     End;
207: Begin CountryNameEdit.Text:={Slovakia-}'LO';
{LO     SLOVAKIA}
     End;
208: Begin CountryNameEdit.Text:={Slovenia-}'SI';
{SI     SLOVENIA}
     End;
209: Begin CountryNameEdit.Text:={Solomon Islands-}'BP';
{BP     SOLOMON ISLANDS province}
        StateFipsCodeCB.Items.add('BP05   Central');
        StateFipsCodeCB.Items.add('BP06   Guadalcanal');
        StateFipsCodeCB.Items.add('BP07   Isabel');
        StateFipsCodeCB.Items.add('BP08   Makira');
        StateFipsCodeCB.Items.add('BP03   Malaita');
        StateFipsCodeCB.Items.add('BP09   Temotu');
        StateFipsCodeCB.Items.add('BP04   Western');
    End;
210: Begin CountryNameEdit.Text:={Somalia-}'SO';
{SO     SOMALIA        region/gobolka}
        StateFipsCodeCB.Items.add('SO01   Bakool');
        StateFipsCodeCB.Items.add('SO02   Banaadir');
        StateFipsCodeCB.Items.add('SO03   Bari');
        StateFipsCodeCB.Items.add('SO04   Bay');
        StateFipsCodeCB.Items.add('SO05   Galguduud');
        StateFipsCodeCB.Items.add('SO06   Gedo');
        StateFipsCodeCB.Items.add('SO07   Hiiraan');
        StateFipsCodeCB.Items.add('SO08   Jubbada Dhexe');
        StateFipsCodeCB.Items.add('SO09   Jubbada Hoose');
        StateFipsCodeCB.Items.add('SO10   Mudug');
        StateFipsCodeCB.Items.add('SO11   Nugaal');
        StateFipsCodeCB.Items.add('SO12   Sanaag');
        StateFipsCodeCB.Items.add('SO13   Shabeellaha Dhexe');
        StateFipsCodeCB.Items.add('SO14   Shabeellaha Hoose');
        StateFipsCodeCB.Items.add('SO15   Togdheer');
        StateFipsCodeCB.Items.add('SO16   Woqooyi Galbeed');
    End;
211: Begin CountryNameEdit.Text:={South Africa-}'SF';
{SF     SOUTH AFRICA province}
        StateFipsCodeCB.Items.add('SF01   Cape Province');
        StateFipsCodeCB.Items.add('SF02   Natal');
        StateFipsCodeCB.Items.add('SF03   Orange Free State');
        StateFipsCodeCB.Items.add('SF04   Transvaal');
     End;
212: Begin CountryNameEdit.Text:={South Georgia and the South Sandwich Islands-}'SX';
{SX     SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS}
     End;
213: Begin CountryNameEdit.Text:={Spain-}'SP';
{SP     SPAIN     autonomous community/comunidad autonoma}
        StateFipsCodeCB.Items.add('SP51   Andalucia');
        StateFipsCodeCB.Items.add('SP52   Aragon');
        StateFipsCodeCB.Items.add('SP34   Asturias');
        StateFipsCodeCB.Items.add('SP53   Canarias');
        StateFipsCodeCB.Items.add('SP39   Cantabria');
        StateFipsCodeCB.Items.add('SP54   Castilla-La Mancha');
        StateFipsCodeCB.Items.add('SP55   Castilla y Leon');
        StateFipsCodeCB.Items.add('SP56   Cataluna');
        StateFipsCodeCB.Items.add('SP57   Extremadura');
        StateFipsCodeCB.Items.add('SP58   Galicia');
        StateFipsCodeCB.Items.add('SP07   Islas Baleares');
        StateFipsCodeCB.Items.add('SP27   La Rioja');
        StateFipsCodeCB.Items.add('SP29   Madrid');
        StateFipsCodeCB.Items.add('SP31   Murcia');
        StateFipsCodeCB.Items.add('SP32   Navarra');
        StateFipsCodeCB.Items.add('SP59   Pais Vasco');
        StateFipsCodeCB.Items.add('SP60   Valenciana');
    End;
214: Begin CountryNameEdit.Text:={Spratly Islands-}'PG';
{PG     SPRATLY ISLANDS}
     End;
215: Begin CountryNameEdit.Text:={Sri Lanka-}'CE';
{CE     SRI LANKA district}
        StateFipsCodeCB.Items.add('CE01   Amparai');
        StateFipsCodeCB.Items.add('CE02   Anuradhapura');
        StateFipsCodeCB.Items.add('CE03   Badulla');
        StateFipsCodeCB.Items.add('CE04   Batticaloa');
        StateFipsCodeCB.Items.add('CE23   Colombo');
        StateFipsCodeCB.Items.add('CE06   Galle');
        StateFipsCodeCB.Items.add('CE24   Gampaha');
        StateFipsCodeCB.Items.add('CE07   Hambantota');
        StateFipsCodeCB.Items.add('CE25   Jaffna');
        StateFipsCodeCB.Items.add('CE09   Kalutara');
        StateFipsCodeCB.Items.add('CE10   Kandy');
        StateFipsCodeCB.Items.add('CE11   Kegalla');
        StateFipsCodeCB.Items.add('CE12   Kurunegala');
        StateFipsCodeCB.Items.add('CE26   Mannar');
        StateFipsCodeCB.Items.add('CE14   Matale');
        StateFipsCodeCB.Items.add('CE15   Matara');
        StateFipsCodeCB.Items.add('CE16   Moneragala');
        StateFipsCodeCB.Items.add('CE27   Mullaittivu');
        StateFipsCodeCB.Items.add('CE17   Nuwara Eliya');
        StateFipsCodeCB.Items.add('CE18   Polonnaruwa');
        StateFipsCodeCB.Items.add('CE19   Puttalam');
        StateFipsCodeCB.Items.add('CE20   Ratnapura');
        StateFipsCodeCB.Items.add('CE21   Trincomalee');
        StateFipsCodeCB.Items.add('CE28   Vavuniya');
    End;
216: Begin CountryNameEdit.Text:={St. Helena-}'SH';
{SH     ST. HELENA      *administrative area dependency}
        StateFipsCodeCB.Items.add('SH01   Ascension*');
        StateFipsCodeCB.Items.add('SH02   Saint Helena');
        StateFipsCodeCB.Items.add('SH03   Tristan da Cunha');
     End;
217: Begin CountryNameEdit.Text:={St. Kitts and Nevis-}'SC';
{SC     ST. KITTS AND NEVIS   parish}
        StateFipsCodeCB.Items.add('SC01   Christ Church Nichola Town');
        StateFipsCodeCB.Items.add('SC02   Saint Anne Sandy Point');
        StateFipsCodeCB.Items.add('SC03   Saint George Basseterre');
        StateFipsCodeCB.Items.add('SC04   Saint George Gingerland');
        StateFipsCodeCB.Items.add('SC05   Saint James Windward');
        StateFipsCodeCB.Items.add('SC06   Saint John Capisterre');
        StateFipsCodeCB.Items.add('SC07   Saint John Figtree');
        StateFipsCodeCB.Items.add('SC08   Saint Mary Cayon');
        StateFipsCodeCB.Items.add('SC09   Saint Paul Capisterre');
        StateFipsCodeCB.Items.add('SC10   Saint Paul Charlestown');
        StateFipsCodeCB.Items.add('SC11   Saint Peter Basseterre');
        StateFipsCodeCB.Items.add('SC12   Saint Thomas Lowland');
        StateFipsCodeCB.Items.add('SC13   Saint Thomas Middle Island');
        StateFipsCodeCB.Items.add('SC15   Trinity Palmetto Point');
    End;
218: Begin CountryNameEdit.Text:={St. Lucia-}'ST';
{ST     ST. LUCIA quarter}
        StateFipsCodeCB.Items.add('ST01   Anse-la-Raye');
        StateFipsCodeCB.Items.add('ST03   Castries');
        StateFipsCodeCB.Items.add('ST04   Choiseul');
        StateFipsCodeCB.Items.add('ST02   Dauphin');
        StateFipsCodeCB.Items.add('ST05   Dennery');
        StateFipsCodeCB.Items.add('ST06   Gros-Islet');
        StateFipsCodeCB.Items.add('ST07   Laborie');
        StateFipsCodeCB.Items.add('ST08   Micoud');
        StateFipsCodeCB.Items.add('ST11   Praslin');
        StateFipsCodeCB.Items.add('ST09   Soufriere');
        StateFipsCodeCB.Items.add('ST10   Vieux-Fort');
    End;
219: Begin CountryNameEdit.Text:={St. Pierre and Miquelon-}'SB';
{SB     ST. PIERRE AND MIQUELON}
     End;
220: Begin CountryNameEdit.Text:={St. Vincent and the Grenadines-}'VC';
{VC     ST. VINCENT AND THE GRENADINES parish}
        StateFipsCodeCB.Items.add('VC01   Charlotte');
        StateFipsCodeCB.Items.add('VC06   Grenadines');
        StateFipsCodeCB.Items.add('VC02   Saint Andrew');
        StateFipsCodeCB.Items.add('VC03   Saint David');
        StateFipsCodeCB.Items.add('VC04   Saint George');
        StateFipsCodeCB.Items.add('VC05   Saint Patrick');
    End;
221: Begin CountryNameEdit.Text:={Sudan-}'SU';
{SU     SUDAN   region/iqlim}
        StateFipsCodeCB.Items.add('SU26   A`ali an Nil');
        StateFipsCodeCB.Items.add('SU28   Al Istiwa`iyah');
        StateFipsCodeCB.Items.add('SU29   Al Khartum');
        StateFipsCodeCB.Items.add('SU27   Al Wusta');
        StateFipsCodeCB.Items.add('SU30   Ash Shamaliyah');
        StateFipsCodeCB.Items.add('SU31   Ash Sharqiyah');
        StateFipsCodeCB.Items.add('SU32   Bahr al Ghazal');
        StateFipsCodeCB.Items.add('SU33   Darfur');
        StateFipsCodeCB.Items.add('SU34   Kurdufan');
    End;
222: Begin CountryNameEdit.Text:={Suriname-}'NS';
{NS     SURINAME district/distrikt}
        StateFipsCodeCB.Items.add('NS10   Brokopondo');
        StateFipsCodeCB.Items.add('NS11   Commewijne');
        StateFipsCodeCB.Items.add('NS12   Coronie');
        StateFipsCodeCB.Items.add('NS13   Marowijne');
        StateFipsCodeCB.Items.add('NS14   Nickerie');
        StateFipsCodeCB.Items.add('NS15   Para');
        StateFipsCodeCB.Items.add('NS16   Paramaribo');
        StateFipsCodeCB.Items.add('NS17   Saramacca');
        StateFipsCodeCB.Items.add('NS18   Sipaliwini');
        StateFipsCodeCB.Items.add('NS19   Wanica');
    End;
223: Begin CountryNameEdit.Text:={Svalbard-}'SV';
{SV     SVALBARD}
     End;
224: Begin CountryNameEdit.Text:={Swaziland-}'WZ';
{WZ     SWAZILAND district}
        StateFipsCodeCB.Items.add('WZ01   Hhohho');
        StateFipsCodeCB.Items.add('WZ02   Lubombo');
        StateFipsCodeCB.Items.add('WZ03   Manzini');
        StateFipsCodeCB.Items.add('WZ05   Praslin');
        StateFipsCodeCB.Items.add('WZ04   Shiselweni');
     End;
225: Begin CountryNameEdit.Text:={Sweden-}'SW';
{SW     SWEDEN          province/lan}
        StateFipsCodeCB.Items.add('SW01   Alvsborgs Lan');
        StateFipsCodeCB.Items.add('SW02   Blekinge Lan');
        StateFipsCodeCB.Items.add('SW03   Gavleborgs Lan');
        StateFipsCodeCB.Items.add('SW04   Goteborgs och Bohus Lan');
        StateFipsCodeCB.Items.add('SW05   Gotlands Lan');
        StateFipsCodeCB.Items.add('SW06   Hallands Lan');
        StateFipsCodeCB.Items.add('SW07   Jamtlands Lan');
        StateFipsCodeCB.Items.add('SW08   Jonkopings Lan');
        StateFipsCodeCB.Items.add('SW09   Kalmar Lan');
        StateFipsCodeCB.Items.add('SW10   Kopparbergs Lan');
        StateFipsCodeCB.Items.add('SW11   Kristianstads Lan');
        StateFipsCodeCB.Items.add('SW12   Kronobergs Lan');
        StateFipsCodeCB.Items.add('SW13   Malmohus Lan');
        StateFipsCodeCB.Items.add('SW14   Norrbottens Lan');
        StateFipsCodeCB.Items.add('SW15   Orebro Lan');
        StateFipsCodeCB.Items.add('SW16   Ostergotlands Lan');
        StateFipsCodeCB.Items.add('SW17   Skaraborgs Lan');
        StateFipsCodeCB.Items.add('SW18   Sodermanlands Lan');
        StateFipsCodeCB.Items.add('SW26   Stockholms Lan');
        StateFipsCodeCB.Items.add('SW21   Uppsala Lan');
        StateFipsCodeCB.Items.add('SW22   Varmlands Lan');
        StateFipsCodeCB.Items.add('SW13   Malmohus Lan');
        StateFipsCodeCB.Items.add('SW23   Vasterbottens Lan');
        StateFipsCodeCB.Items.add('SW24   Vasternorrlands Lan');
        StateFipsCodeCB.Items.add('SW25   Vastmanlands Lan');
    End;
226: Begin CountryNameEdit.Text:={Switzerland-}'SZ';
{SZ     SWITZERLAND
canton/canton (French), cantone (Italian), kanton (German)}
        StateFipsCodeCB.Items.add('SZ01   Aargau');
        StateFipsCodeCB.Items.add('SZ02   Ausser-Rhoden');
        StateFipsCodeCB.Items.add('SZ03   Basel-Landschaft');
        StateFipsCodeCB.Items.add('SZ04   Basel-Stadt');
        StateFipsCodeCB.Items.add('SZ05   Bern');
        StateFipsCodeCB.Items.add('SZ06   Fribourg');
        StateFipsCodeCB.Items.add('SZ07   Geneve');
        StateFipsCodeCB.Items.add('SZ08   Glarus');
        StateFipsCodeCB.Items.add('SZ09   Graubunden');
        StateFipsCodeCB.Items.add('SZ10   Inner-Rhoden');
        StateFipsCodeCB.Items.add('SZ26   Jura');
        StateFipsCodeCB.Items.add('SZ11   Luzern');
        StateFipsCodeCB.Items.add('SZ12   Neuchatel');
        StateFipsCodeCB.Items.add('SZ13   Nidwalden');
        StateFipsCodeCB.Items.add('SZ14   Obwalden');
        StateFipsCodeCB.Items.add('SZ15   Sankt Gallen');
        StateFipsCodeCB.Items.add('SZ16   Schaffhausen');
        StateFipsCodeCB.Items.add('SZ17   Schwyz');
        StateFipsCodeCB.Items.add('SZ18   Solothurn');
        StateFipsCodeCB.Items.add('SZ19   Thurgau');
        StateFipsCodeCB.Items.add('SZ20   Ticino');
        StateFipsCodeCB.Items.add('SZ21   Uri');
        StateFipsCodeCB.Items.add('SZ22   Valais');
        StateFipsCodeCB.Items.add('SZ23   Vaud');
        StateFipsCodeCB.Items.add('SZ24   Zug');
        StateFipsCodeCB.Items.add('SZ25   Zurich');
    End;
227: Begin CountryNameEdit.Text:={Syria-}'SY';
{SY     SYRIA province/muhafazah}
        StateFipsCodeCB.Items.add('SY01   Al Hasakah');
        StateFipsCodeCB.Items.add('SY02   Al Ladhiqiyah');
        StateFipsCodeCB.Items.add('SY03   Al Qunaytirah');
        StateFipsCodeCB.Items.add('SY04   Ar Raqqah');
        StateFipsCodeCB.Items.add('SY05   As Suwayda`');
        StateFipsCodeCB.Items.add('SY06   Dar`a');
        StateFipsCodeCB.Items.add('SY07   Dayr az Zawr');
        StateFipsCodeCB.Items.add('SY13   Dimashq');
        StateFipsCodeCB.Items.add('SY09   Halab');
        StateFipsCodeCB.Items.add('SY10   Hamah');
        StateFipsCodeCB.Items.add('SY11   Hims');
        StateFipsCodeCB.Items.add('SY12   Idlib');
        StateFipsCodeCB.Items.add('SY08   Rif Dimashq');
        StateFipsCodeCB.Items.add('SY14   Tartus');
    End;
228: Begin CountryNameEdit.Text:={Taiwan-}'TW';
{TW     TAIWAN  *municipality/shih  province/sheng}
        StateFipsCodeCB.Items.add('TW01   Fu-chien');
        StateFipsCodeCB.Items.add('TW02   Kao-hsiung*');
        StateFipsCodeCB.Items.add('TW03   T`ai-pei*');
        StateFipsCodeCB.Items.add('TW04   T`ai-wan');
     End;
229: Begin CountryNameEdit.Text:={Tajikistan-}'TI';
{TI     TAJIKISTAN}
     End;
230: Begin CountryNameEdit.Text:={Tanzania, United Republic Of-}'TZ';
{TZ     TANZANIA      region}
        StateFipsCodeCB.Items.add('TZ01   Arusha');
        StateFipsCodeCB.Items.add('TZ23   Dar es Salaam');
        StateFipsCodeCB.Items.add('TZ03   Dodoma');
        StateFipsCodeCB.Items.add('TZ04   Iringa');
        StateFipsCodeCB.Items.add('TZ05   Kigoma');
        StateFipsCodeCB.Items.add('TZ06   Kilimanjaro');
        StateFipsCodeCB.Items.add('TZ07   Lindi');
        StateFipsCodeCB.Items.add('TZ08   Mara');
        StateFipsCodeCB.Items.add('TZ09   Mbeya');
        StateFipsCodeCB.Items.add('TZ10   Morogoro');
        StateFipsCodeCB.Items.add('TZ11   Mtwara');
        StateFipsCodeCB.Items.add('TZ12   Mwanza');
        StateFipsCodeCB.Items.add('TZ13   Pemba North');
        StateFipsCodeCB.Items.add('TZ20   Pemba South');
        StateFipsCodeCB.Items.add('TZ02   Pwani');
        StateFipsCodeCB.Items.add('TZ24   Rukwa');
        StateFipsCodeCB.Items.add('TZ14   Ruvuma');
        StateFipsCodeCB.Items.add('TZ15   Shinyanga');
        StateFipsCodeCB.Items.add('TZ16   Singida');
        StateFipsCodeCB.Items.add('TZ17   Tabora');
        StateFipsCodeCB.Items.add('TZ18   Tanga');
        StateFipsCodeCB.Items.add('TZ21   Zanzibar Central/South');
        StateFipsCodeCB.Items.add('TZ22   Zanzibar North');
        StateFipsCodeCB.Items.add('TZ25   Zanzibar Urban/West');
        StateFipsCodeCB.Items.add('TZ19   Ziwa Magharibi');
    End;
231: Begin CountryNameEdit.Text:={Thailand-}'TH';
{TH     THAILAND  *municipality  province}
        StateFipsCodeCB.Items.add('TH35   Ang Thong');
        StateFipsCodeCB.Items.add('TH28   Buriram');
        StateFipsCodeCB.Items.add('TH44   Chachoengsao');
        StateFipsCodeCB.Items.add('TH32   Chai Nat');
        StateFipsCodeCB.Items.add('TH26   Chaiyaphum');
        StateFipsCodeCB.Items.add('TH48   Chanthaburi');
        StateFipsCodeCB.Items.add('TH02   Chiang Mai');
        StateFipsCodeCB.Items.add('TH03   Chiang Rai');
        StateFipsCodeCB.Items.add('TH46   Chon Buri');
        StateFipsCodeCB.Items.add('TH58   Chumphon');
        StateFipsCodeCB.Items.add('TH23   Kalasin');
        StateFipsCodeCB.Items.add('TH11   Kamphaeng Phet');
        StateFipsCodeCB.Items.add('TH50   Kanchanaburi');
        StateFipsCodeCB.Items.add('TH22   Khon Kaen');
        StateFipsCodeCB.Items.add('TH63   Krabi');
        StateFipsCodeCB.Items.add('TH40   Krung Thep*');
        StateFipsCodeCB.Items.add('TH06   Lampang');
        StateFipsCodeCB.Items.add('TH05   Lamphun');
        StateFipsCodeCB.Items.add('TH18   Loei');
        StateFipsCodeCB.Items.add('TH34   Lop Buri');
        StateFipsCodeCB.Items.add('TH01   Mae Hong Son');
        StateFipsCodeCB.Items.add('TH24   Maha Sarakham');
        StateFipsCodeCB.Items.add('TH43   Nakhon Nayok');
        StateFipsCodeCB.Items.add('TH53   Nakhon Pathom');
        StateFipsCodeCB.Items.add('TH21   Nakhon Phanom');
        StateFipsCodeCB.Items.add('TH27   Nakhon Ratchasima');
        StateFipsCodeCB.Items.add('TH16   Nakhon Sawan');
        StateFipsCodeCB.Items.add('TH64   Nakhon Si Thammarat');
        StateFipsCodeCB.Items.add('TH04   Nan');
        StateFipsCodeCB.Items.add('TH31   Narathiwat');
        StateFipsCodeCB.Items.add('TH17   Nong Khai');
        StateFipsCodeCB.Items.add('TH38   Nonthaburi');
        StateFipsCodeCB.Items.add('TH39   Pathum Thani');
        StateFipsCodeCB.Items.add('TH69   Pattani');
        StateFipsCodeCB.Items.add('TH61   Phangnga');
        StateFipsCodeCB.Items.add('TH66   Phatthalung');
        StateFipsCodeCB.Items.add('TH41   Phayao');
        StateFipsCodeCB.Items.add('TH14   Phetchabun');
        StateFipsCodeCB.Items.add('TH56   Phetchaburi');
        StateFipsCodeCB.Items.add('TH13   Phichit');
        StateFipsCodeCB.Items.add('TH12   Phitsanulok');
        StateFipsCodeCB.Items.add('TH36   Phra Nakhon Si Ayutthaya');
        StateFipsCodeCB.Items.add('TH07   Phrae');
        StateFipsCodeCB.Items.add('TH62   Phuket');
        StateFipsCodeCB.Items.add('TH45   Prachin Buri');
        StateFipsCodeCB.Items.add('TH57   Prachuap Khiri Khan');
        StateFipsCodeCB.Items.add('TH59   Ranong');
        StateFipsCodeCB.Items.add('TH52   Ratchaburi');
        StateFipsCodeCB.Items.add('TH47   Rayong');
        StateFipsCodeCB.Items.add('TH25   Roi Et');
        StateFipsCodeCB.Items.add('TH20   Sakon Nakhon');
        StateFipsCodeCB.Items.add('TH42   Samut Prakan');
        StateFipsCodeCB.Items.add('TH55   Samut Sakhon');
        StateFipsCodeCB.Items.add('TH54   Samut Songkhram');
        StateFipsCodeCB.Items.add('TH37   Saraburi');
        StateFipsCodeCB.Items.add('TH67   Satun');
        StateFipsCodeCB.Items.add('TH33   Sing Buri');
        StateFipsCodeCB.Items.add('TH30   Sisaket');
        StateFipsCodeCB.Items.add('TH68   Songkhla');
        StateFipsCodeCB.Items.add('TH09   Sukhothai');
        StateFipsCodeCB.Items.add('TH51   Suphan Buri');
        StateFipsCodeCB.Items.add('TH60   Surat Thani');
        StateFipsCodeCB.Items.add('TH29   Surin');
        StateFipsCodeCB.Items.add('TH08   Tak');
        StateFipsCodeCB.Items.add('TH65   Trang');
        StateFipsCodeCB.Items.add('TH49   Trat');
        StateFipsCodeCB.Items.add('TH71   Ubon Ratchathani');
        StateFipsCodeCB.Items.add('TH19   Udon Thani');
        StateFipsCodeCB.Items.add('TH15   Uthai Thani');
        StateFipsCodeCB.Items.add('TH10   Uttaradit');
        StateFipsCodeCB.Items.add('TH70   Yala');
        StateFipsCodeCB.Items.add('TH72   Yasothon');
    End;
232: Begin CountryNameEdit.Text:={Togo-}'TO';
{TO     TOGO circumscription/circonscription}
        StateFipsCodeCB.Items.add('TO01   Amlame');
        StateFipsCodeCB.Items.add('TO02   Aneho');
        StateFipsCodeCB.Items.add('TO03   Atakpame');
        StateFipsCodeCB.Items.add('TO15   Badou');
        StateFipsCodeCB.Items.add('TO04   Bafilo');
        StateFipsCodeCB.Items.add('TO05   Bassar');
        StateFipsCodeCB.Items.add('TO06   Dapaong');
        StateFipsCodeCB.Items.add('TO07   Kante');
        StateFipsCodeCB.Items.add('TO08   Klouto');
        StateFipsCodeCB.Items.add('TO14   Kpagouda');
        StateFipsCodeCB.Items.add('TO09   Lama-Kara');
        StateFipsCodeCB.Items.add('TO10   Lome');
        StateFipsCodeCB.Items.add('TO11   Mango');
        StateFipsCodeCB.Items.add('TO12   Niamtougou');
        StateFipsCodeCB.Items.add('TO13   Notse');
        StateFipsCodeCB.Items.add('TO16   Sotouboua');
        StateFipsCodeCB.Items.add('TO17   Tabligbo');
        StateFipsCodeCB.Items.add('TO19   Tchamba');
        StateFipsCodeCB.Items.add('TO20   Tchaoudjo');
        StateFipsCodeCB.Items.add('TO18   Tsevie');
        StateFipsCodeCB.Items.add('TO21   Vogan');
    End;
233: Begin CountryNameEdit.Text:={Tokelau-}'TL';
{TL     TOKELAU}
     End;
234: Begin CountryNameEdit.Text:={Tonga-}'TN';
{TN     TONGA island group}
        StateFipsCodeCB.Items.add('TN01   Ha`apai');
        StateFipsCodeCB.Items.add('TN02   Tongatapu');
        StateFipsCodeCB.Items.add('TN03   Vava`u');
     End;
235: Begin CountryNameEdit.Text:={Trinidad and Tobago-}'TD';
{TD     TRINIDAD AND TOBAGO county *municipality **ward}
        StateFipsCodeCB.Items.add('TD01   Arima*');
        StateFipsCodeCB.Items.add('TD02   Caroni');
        StateFipsCodeCB.Items.add('TD03   Mayaro');
        StateFipsCodeCB.Items.add('TD04   Nariva');
        StateFipsCodeCB.Items.add('TD05   Port-of-Spain*');
        StateFipsCodeCB.Items.add('TD06   Saint Andrew');
        StateFipsCodeCB.Items.add('TD07   Saint David');
        StateFipsCodeCB.Items.add('TD08   Saint George');
        StateFipsCodeCB.Items.add('TD09   Saint Patrick');
        StateFipsCodeCB.Items.add('TD10   San Fernando*');
        StateFipsCodeCB.Items.add('TD11   Tobago**');
        StateFipsCodeCB.Items.add('TD12   Victoria');
    End;
236: Begin CountryNameEdit.Text:={Tromelin Island-}'TE';
{TE     TROMELIN ISLAND}
     End;
237: Begin CountryNameEdit.Text:={Tunisia-}'TS';
{TS     TUNISIA governorate/wilayah}
        StateFipsCodeCB.Items.add('TS14   Al Kaf');
        StateFipsCodeCB.Items.add('TS15   Al Mahdiyah');
        StateFipsCodeCB.Items.add('TS16   Al Munastir');
        StateFipsCodeCB.Items.add('TS02   Al Qasrayn');
        StateFipsCodeCB.Items.add('TS03   Al Qayrawan');
        StateFipsCodeCB.Items.add('TS26   Aryanah');
        StateFipsCodeCB.Items.add('TS17   Bajah');
        StateFipsCodeCB.Items.add('TS18   Banzart');
        StateFipsCodeCB.Items.add('TS27   Bin `Arus');
        StateFipsCodeCB.Items.add('TS06   Jundubah');
        StateFipsCodeCB.Items.add('TS28   Madanin');
        StateFipsCodeCB.Items.add('TS19   Nabul');
        StateFipsCodeCB.Items.add('TS29   Qabis');
        StateFipsCodeCB.Items.add('TS10   Qafsah');
        StateFipsCodeCB.Items.add('TS31   Qibili');
        StateFipsCodeCB.Items.add('TS32   Safaqis');
        StateFipsCodeCB.Items.add('TS33   Sidi Bu Zayd');
        StateFipsCodeCB.Items.add('TS22   Silyanah');
        StateFipsCodeCB.Items.add('TS23   Susah');
        StateFipsCodeCB.Items.add('TS34   Tatawin');
        StateFipsCodeCB.Items.add('TS35   Tawzar');
        StateFipsCodeCB.Items.add('TS36   Tunis');
        StateFipsCodeCB.Items.add('TS37   Zaghwan');
    End;
238: Begin CountryNameEdit.Text:={Turkey-}'TU';
{TU     TURKEY   province/il}
        StateFipsCodeCB.Items.add('TU01   Adana');
        StateFipsCodeCB.Items.add('TU02   Adiyaman');
        StateFipsCodeCB.Items.add('TU03   Afyon');
        StateFipsCodeCB.Items.add('TU04   Agri');
        StateFipsCodeCB.Items.add('TU75   Aksaray');
        StateFipsCodeCB.Items.add('TU05   Amasya');
        StateFipsCodeCB.Items.add('TU68   Ankara');
        StateFipsCodeCB.Items.add('TU07   Antalya');
        StateFipsCodeCB.Items.add('TU08   Artvin');
        StateFipsCodeCB.Items.add('TU09   Aydin');
        StateFipsCodeCB.Items.add('TU10   Balikesir');
        StateFipsCodeCB.Items.add('TU76   Batman');
        StateFipsCodeCB.Items.add('TU77   Bayburt');
        StateFipsCodeCB.Items.add('TU11   Bilecik');
        StateFipsCodeCB.Items.add('TU12   Bingol');
        StateFipsCodeCB.Items.add('TU13   Bitlis');
        StateFipsCodeCB.Items.add('TU14   Bolu');
        StateFipsCodeCB.Items.add('TU15   Burdur');
        StateFipsCodeCB.Items.add('TU16   Bursa');
        StateFipsCodeCB.Items.add('TU17   Canakkale');
        StateFipsCodeCB.Items.add('TU18   Cankiri');
        StateFipsCodeCB.Items.add('TU19   Corum');
        StateFipsCodeCB.Items.add('TU20   Denizli');
        StateFipsCodeCB.Items.add('TU21   Diyarbakir');
        StateFipsCodeCB.Items.add('TU22   Edirne');
        StateFipsCodeCB.Items.add('TU23   Elazig');
        StateFipsCodeCB.Items.add('TU24   Erzincan');
        StateFipsCodeCB.Items.add('TU25   Erzurum');
        StateFipsCodeCB.Items.add('TU26   Eskisehir');
        StateFipsCodeCB.Items.add('TU27   Gaziantep');
        StateFipsCodeCB.Items.add('TU28   Giresun');
        StateFipsCodeCB.Items.add('TU69   Gumushane');
        StateFipsCodeCB.Items.add('TU70   Hakkari');
        StateFipsCodeCB.Items.add('TU31   Hatay');
        StateFipsCodeCB.Items.add('TU32   Icel');
        StateFipsCodeCB.Items.add('TU33   Isparta');
        StateFipsCodeCB.Items.add('TU34   Istanbul');
        StateFipsCodeCB.Items.add('TU35   Izmir');
        StateFipsCodeCB.Items.add('TU46   Kahraman Maras');
        StateFipsCodeCB.Items.add('TU78   Karaman');
        StateFipsCodeCB.Items.add('TU36   Kars');
        StateFipsCodeCB.Items.add('TU37   Kastamonu');
        StateFipsCodeCB.Items.add('TU38   Kayseri');
        StateFipsCodeCB.Items.add('TU79   Kirikkale');
        StateFipsCodeCB.Items.add('TU39   Kirklareli');
        StateFipsCodeCB.Items.add('TU40   Kirsehir');
        StateFipsCodeCB.Items.add('TU41   Kocaeli');
        StateFipsCodeCB.Items.add('TU71   Konya');
        StateFipsCodeCB.Items.add('TU43   Kutahya');
        StateFipsCodeCB.Items.add('TU44   Malatya');
        StateFipsCodeCB.Items.add('TU45   Manisa');
        StateFipsCodeCB.Items.add('TU72   Mardin');
        StateFipsCodeCB.Items.add('TU48   Mugla');
        StateFipsCodeCB.Items.add('TU43   Kutahya');
        StateFipsCodeCB.Items.add('TU49   Mus');
        StateFipsCodeCB.Items.add('TU50   Nevsehir');
        StateFipsCodeCB.Items.add('TU73   Nigde');
        StateFipsCodeCB.Items.add('TU52   Ordu');
        StateFipsCodeCB.Items.add('TU53   Rize');
        StateFipsCodeCB.Items.add('TU54   Sakarya');
        StateFipsCodeCB.Items.add('TU55   Samsun');
        StateFipsCodeCB.Items.add('TU74   Siirt');
        StateFipsCodeCB.Items.add('TU57   Sinop');
        StateFipsCodeCB.Items.add('TU80   Sirnak');
        StateFipsCodeCB.Items.add('TU58   Sivas');
        StateFipsCodeCB.Items.add('TU59   Tekirdag');
        StateFipsCodeCB.Items.add('TU60   Tokat');
        StateFipsCodeCB.Items.add('TU61   Trabzon');
        StateFipsCodeCB.Items.add('TU62   Tunceli');
        StateFipsCodeCB.Items.add('TU63   Urfa');
        StateFipsCodeCB.Items.add('TU64   Usak');
        StateFipsCodeCB.Items.add('TU65   Van');
        StateFipsCodeCB.Items.add('TU66   Yozgat');
        StateFipsCodeCB.Items.add('TU67   Zonguldak');
    End;
239: Begin CountryNameEdit.Text:={Turkmenistan-}'TX';
{TX     TURKMENISTAN}
     End;
240: Begin CountryNameEdit.Text:={Turks and Caicos Islands-}'TK';
{TK     TURKS AND CAICOS ISLANDS}
     End;
241: Begin CountryNameEdit.Text:={Tuvalu-}'TV';
{TV     TUVALU}
     End;
242: Begin CountryNameEdit.Text:={Uganda-}'UG';
{UG     UGANDA province }
        StateFipsCodeCB.Items.add('UG05   Busoga');
        StateFipsCodeCB.Items.add('UG18   Central');
        StateFipsCodeCB.Items.add('UG20   Eastern');
        StateFipsCodeCB.Items.add('UG08   Karamoja');
        StateFipsCodeCB.Items.add('UG21   Nile');
        StateFipsCodeCB.Items.add('UG22   North Buganda');
        StateFipsCodeCB.Items.add('UG23   Northern');
        StateFipsCodeCB.Items.add('UG12   South Buganda');
        StateFipsCodeCB.Items.add('UG24   Southern');
        StateFipsCodeCB.Items.add('UG25   Western');
    End;
243: Begin CountryNameEdit.Text:={Ukraine-}'UP';
{UP     UKRAINE *city/misto  province/oblast'  **republic/respublika}
        StateFipsCodeCB.Items.add('UP01   Cherkas`ka Oblast`');
        StateFipsCodeCB.Items.add('UP02   Chernihivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP03   Chernivets`ka Oblast`');
        StateFipsCodeCB.Items.add('UP04   Dnipropetrovs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP05   Donets`ka Oblast`');
        StateFipsCodeCB.Items.add('UP06   Ivano-Frankivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP07   Kharkivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP08   Khersons`ka Oblast`');
        StateFipsCodeCB.Items.add('UP09   Khmel`nyts`ka Oblast`');
        StateFipsCodeCB.Items.add('UP10   Kirovohrads`ka Oblast`');
        StateFipsCodeCB.Items.add('UP11   Krym, Respublika**');
        StateFipsCodeCB.Items.add('UP12   Kyyiv, Misto*');
        StateFipsCodeCB.Items.add('UP13   Kyyivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP14   Luhans`ka Oblast`');
        StateFipsCodeCB.Items.add('UP15   L`vivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP16   Mykolayivs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP17   Odes`ka Oblast`');
        StateFipsCodeCB.Items.add('UP18   Poltavs`ka Oblast`');
        StateFipsCodeCB.Items.add('UP19   Rivnens`ka Oblast`');
        StateFipsCodeCB.Items.add('UP20   Sevastopol`, Misto*');
        StateFipsCodeCB.Items.add('UP21   Sums`ka Oblast`');
        StateFipsCodeCB.Items.add('UP22   Ternopil`s`ka Oblast`');
        StateFipsCodeCB.Items.add('UP23   Vinnyts`ka Oblast`');
        StateFipsCodeCB.Items.add('UP24   Volyns`ka Oblast`');
        StateFipsCodeCB.Items.add('UP25   Zakarpats`ka Oblast`');
        StateFipsCodeCB.Items.add('UP26   Zaporiz`ka Oblast`');
        StateFipsCodeCB.Items.add('UP27   Zhytomyrs`ka Oblast`');
    End;
244: Begin CountryNameEdit.Text:={United Arab Emirates-}'AE';
{TC     UNITED ARAB EMIRATES emirate}
        StateFipsCodeCB.Items.add('AE01   Abu Zaby');
        StateFipsCodeCB.Items.add('AE02   `Ajman');
        StateFipsCodeCB.Items.add('AE04   Al Fujayrah');
        StateFipsCodeCB.Items.add('AE06   Ash Shariqah');
        StateFipsCodeCB.Items.add('AE03   Dubayy');
        StateFipsCodeCB.Items.add('AE05   Ra`s al Khaymah');
        StateFipsCodeCB.Items.add('AE07   Umm al Qaywayn');
    End;
245: Begin CountryNameEdit.Text:={United Kingdom-}'UK';
{UK     UNITED KINGDOM county  *metropolitan county}
        StateFipsCodeCB.Items.add('UK01   Avon');
        StateFipsCodeCB.Items.add('UK02   Bedford');
        StateFipsCodeCB.Items.add('UK03   Berkshire');
        StateFipsCodeCB.Items.add('UK04   Buckingham');
        StateFipsCodeCB.Items.add('UK05   Cambridge');
        StateFipsCodeCB.Items.add('UK06   Cheshire');
        StateFipsCodeCB.Items.add('UK07   Cleveland');
        StateFipsCodeCB.Items.add('UK08   Cornwall');
        StateFipsCodeCB.Items.add('UK09   Cumbria');
        StateFipsCodeCB.Items.add('UK10   Derby');
        StateFipsCodeCB.Items.add('UK11   Devon');
        StateFipsCodeCB.Items.add('UK12   Dorset');
        StateFipsCodeCB.Items.add('UK13   Durham');
        StateFipsCodeCB.Items.add('UK14   East Sussex');
        StateFipsCodeCB.Items.add('UK15   Essex');
        StateFipsCodeCB.Items.add('UK16   Gloucester');
        StateFipsCodeCB.Items.add('UK17   Greater London*');
        StateFipsCodeCB.Items.add('UK18   Greater Manchester*');
        StateFipsCodeCB.Items.add('UK19   Hampshire');
        StateFipsCodeCB.Items.add('UK20   Hereford and Worcester');
        StateFipsCodeCB.Items.add('UK21   Hertford');
        StateFipsCodeCB.Items.add('UK22   Humberside');
        StateFipsCodeCB.Items.add('UK23   Isle of Wight');
        StateFipsCodeCB.Items.add('UK24   Kent');
        StateFipsCodeCB.Items.add('UK25   Lancashire');
        StateFipsCodeCB.Items.add('UK26   Leicester');
        StateFipsCodeCB.Items.add('UK27   Lincoln');
        StateFipsCodeCB.Items.add('UK28   Merseyside*');
        StateFipsCodeCB.Items.add('UK29   Norfolk');
        StateFipsCodeCB.Items.add('UK31   Northampton');
        StateFipsCodeCB.Items.add('UK32   Northumberland');
        StateFipsCodeCB.Items.add('UK30   North Yorkshire');
        StateFipsCodeCB.Items.add('UK33   Nottingham');
        StateFipsCodeCB.Items.add('UK34   Oxford');
        StateFipsCodeCB.Items.add('UK35   Shropshire');
        StateFipsCodeCB.Items.add('UK36   Somerset');
        StateFipsCodeCB.Items.add('UK37   South Yorkshire*');
        StateFipsCodeCB.Items.add('UK38   Stafford');
        StateFipsCodeCB.Items.add('UK39   Suffolk');
        StateFipsCodeCB.Items.add('UK40   Surrey');
        StateFipsCodeCB.Items.add('UK41   Tyne and Wear*');
        StateFipsCodeCB.Items.add('UK42   Warwick');
        StateFipsCodeCB.Items.add('UK43   West Midlands*');
        StateFipsCodeCB.Items.add('UK44   West Sussex');
        StateFipsCodeCB.Items.add('UK45   West Yorkshire*');
        StateFipsCodeCB.Items.add('UK46   Wiltshire');
{(Northern Ireland: 52 through 77, inclusive)district}
        StateFipsCodeCB.Items.add('UK52   Antrim');
        StateFipsCodeCB.Items.add('UK53   Ards');
        StateFipsCodeCB.Items.add('UK54   Armagh');
        StateFipsCodeCB.Items.add('UK55   Ballymena');
        StateFipsCodeCB.Items.add('UK56   Ballymoney');
        StateFipsCodeCB.Items.add('UK57   Banbridge');
        StateFipsCodeCB.Items.add('UK58   Belfast');
        StateFipsCodeCB.Items.add('UK59   Carrickfergus');
        StateFipsCodeCB.Items.add('UK60   Castlereagh');
        StateFipsCodeCB.Items.add('UK61   Coleraine');
        StateFipsCodeCB.Items.add('UK62   Cookstown');
        StateFipsCodeCB.Items.add('UK63   Craigavon');
        StateFipsCodeCB.Items.add('UK64   Down');
        StateFipsCodeCB.Items.add('UK65   Dungannon');
        StateFipsCodeCB.Items.add('UK66   Fermanagh');
        StateFipsCodeCB.Items.add('UK67   Larne');
        StateFipsCodeCB.Items.add('UK68   Limavady');
        StateFipsCodeCB.Items.add('UK69   Lisburn');
        StateFipsCodeCB.Items.add('UK70   Londonderry');
        StateFipsCodeCB.Items.add('UK71   Magherafelt');
        StateFipsCodeCB.Items.add('UK72   Moyle');
        StateFipsCodeCB.Items.add('UK73   Newry and Mourne');
        StateFipsCodeCB.Items.add('UK74   Newtownabbey');
        StateFipsCodeCB.Items.add('UK75   North Down');
        StateFipsCodeCB.Items.add('UK76   Omagh');
        StateFipsCodeCB.Items.add('UK77   Strabane');
{(Scotland: 78 through 89, inclusive)*islands area  region}
        StateFipsCodeCB.Items.add('UK78   Borders');
        StateFipsCodeCB.Items.add('UK79   Central');
        StateFipsCodeCB.Items.add('UK80   Dumfries and Galloway');
        StateFipsCodeCB.Items.add('UK81   Fife');
        StateFipsCodeCB.Items.add('UK82   Grampian');
        StateFipsCodeCB.Items.add('UK83   Highland');
        StateFipsCodeCB.Items.add('UK84   Lothian');
        StateFipsCodeCB.Items.add('UK85   Orkney*');
        StateFipsCodeCB.Items.add('UK86   Shetland*');
        StateFipsCodeCB.Items.add('UK87   Strathclyde');
        StateFipsCodeCB.Items.add('UK88   Tayside');
        StateFipsCodeCB.Items.add('UK89   Western Isles*');
{(Wales: 90 though 97, inclusive)county}
        StateFipsCodeCB.Items.add('UK90   Clwyd');
        StateFipsCodeCB.Items.add('UK91   Dyfed');
        StateFipsCodeCB.Items.add('UK92   Gwent');
        StateFipsCodeCB.Items.add('UK93   Gwynedd');
        StateFipsCodeCB.Items.add('UK94   Mid Glamorgan');
        StateFipsCodeCB.Items.add('UK95   Powys');
        StateFipsCodeCB.Items.add('UK96   South Glamorgan');
        StateFipsCodeCB.Items.add('UK97   West Glamorgan');
    End;
246: Begin CountryNameEdit.Text:={United States-}'US';
{US     UNITED STATES  *district  state}
        StateFipsCodeCB.Items.add('US01   Alabama');
        StateFipsCodeCB.Items.add('US02   Alaska');
        StateFipsCodeCB.Items.add('US04   Arizona');
        StateFipsCodeCB.Items.add('US05   Arkansas');
        StateFipsCodeCB.Items.add('US06   California');
        StateFipsCodeCB.Items.add('US08   Colorado');
        StateFipsCodeCB.Items.add('US09   Connecticut');
        StateFipsCodeCB.Items.add('US10   Delaware');
        StateFipsCodeCB.Items.add('US11   District of Columbia*');
        StateFipsCodeCB.Items.add('US12   Florida');
        StateFipsCodeCB.Items.add('US13   Georgia');
        StateFipsCodeCB.Items.add('US15   Hawaii');
        StateFipsCodeCB.Items.add('US16   Idaho');
        StateFipsCodeCB.Items.add('US17   Illinois');
        StateFipsCodeCB.Items.add('US18   Indiana');
        StateFipsCodeCB.Items.add('US19   Iowa');
        StateFipsCodeCB.Items.add('US20   Kansas');
        StateFipsCodeCB.Items.add('US21   Kentucky');
        StateFipsCodeCB.Items.add('US22   Louisiana');
        StateFipsCodeCB.Items.add('US23   Maine');
        StateFipsCodeCB.Items.add('US24   Maryland');
        StateFipsCodeCB.Items.add('US25   Massachusetts');
        StateFipsCodeCB.Items.add('US26   Michigan');
        StateFipsCodeCB.Items.add('US27   Minnesota');
        StateFipsCodeCB.Items.add('US28   Mississippi');
        StateFipsCodeCB.Items.add('US29   Missouri');
        StateFipsCodeCB.Items.add('US30   Montana');
        StateFipsCodeCB.Items.add('US31   Nebraska');
        StateFipsCodeCB.Items.add('US32   Nevada');
        StateFipsCodeCB.Items.add('US33   New Hampshire');
        StateFipsCodeCB.Items.add('US34   New Jersey');
        StateFipsCodeCB.Items.add('US35   New Mexico');
        StateFipsCodeCB.Items.add('US36   New York');
        StateFipsCodeCB.Items.add('US37   North Carolina');
        StateFipsCodeCB.Items.add('US38   North Dakota');
        StateFipsCodeCB.Items.add('US39   Ohio');
        StateFipsCodeCB.Items.add('US40   Oklahoma');
        StateFipsCodeCB.Items.add('US41   Oregon');
        StateFipsCodeCB.Items.add('US42   Pennyslvania');
        StateFipsCodeCB.Items.add('US44   Rhode Island');
        StateFipsCodeCB.Items.add('US45   South Carolina');
        StateFipsCodeCB.Items.add('US46   South Dakota');
        StateFipsCodeCB.Items.add('US47   Tennessee');
        StateFipsCodeCB.Items.add('US48   Texas');
        StateFipsCodeCB.Items.add('US49   Utah');
        StateFipsCodeCB.Items.add('US50   Vermont');
        StateFipsCodeCB.Items.add('US51   Virginia');
        StateFipsCodeCB.Items.add('US53   Washington');
        StateFipsCodeCB.Items.add('US54   West Virginia');
        StateFipsCodeCB.Items.add('US55   Wisconsin');
        StateFipsCodeCB.Items.add('US56   Wyoming');
        StateFipsCodeCB.Items.add('US60 : American Samoa');
        StateFipsCodeCB.Items.add('US66 : Guam');
        StateFipsCodeCB.Items.add('US69 : Northern Mariana Islands');
        StateFipsCodeCB.Items.add('US70 : Palau');
        StateFipsCodeCB.Items.add('US72 : Puerto Rico');
        StateFipsCodeCB.Items.add('US78 : Virgin Islands (US)');
        StateFipsCodeCB.Items.add('US74 : US MINOR OUTLYING ISLANDS');
        StateFipsCodeCB.Items.add('US64 : FEDERATED STATES OF MICRONESIA');
        StateFipsCodeCB.Items.add('US68 : MARSHALL ISLANDS');
     End;
247: Begin CountryNameEdit.Text:={Uruguay-}'UY';
{UY     URUGUAY       department/departamento}
        StateFipsCodeCB.Items.add('UY01   Artigas');
        StateFipsCodeCB.Items.add('UY02   Canelones');
        StateFipsCodeCB.Items.add('UY03   Cerro Largo');
        StateFipsCodeCB.Items.add('UY04   Colonia');
        StateFipsCodeCB.Items.add('UY05   Durazno');
        StateFipsCodeCB.Items.add('UY06   Flores');
        StateFipsCodeCB.Items.add('UY07   Florida');
        StateFipsCodeCB.Items.add('UY08   Lavalleja');
        StateFipsCodeCB.Items.add('UY09   Maldonado');
        StateFipsCodeCB.Items.add('UY10   Montevideo');
        StateFipsCodeCB.Items.add('UY11   Paysandu');
        StateFipsCodeCB.Items.add('UY12   Rio Negro');
        StateFipsCodeCB.Items.add('UY13   Rivera');
        StateFipsCodeCB.Items.add('UY14   Rocha');
        StateFipsCodeCB.Items.add('UY15   Salto');
        StateFipsCodeCB.Items.add('UY16   San Jose');
        StateFipsCodeCB.Items.add('UY17   Soriano');
        StateFipsCodeCB.Items.add('UY18   Tacuarembo');
        StateFipsCodeCB.Items.add('UY19   Treinta y Tres');
    End;
248: Begin CountryNameEdit.Text:={Uzbekistan-}'UZ';
{UZ     UZBEKISTAN}
     End;
249: Begin CountryNameEdit.Text:={Vanuatu-}'NH';
{NH     VANUATU district}
        StateFipsCodeCB.Items.add('NH05   Ambrym');
        StateFipsCodeCB.Items.add('NH06   Aoba/Maewo');
        StateFipsCodeCB.Items.add('NH07   Banks/Torres');
        StateFipsCodeCB.Items.add('NH08   Efate');
        StateFipsCodeCB.Items.add('NH09   Epi');
        StateFipsCodeCB.Items.add('NH10   Malakula');
        StateFipsCodeCB.Items.add('NH11   Paama');
        StateFipsCodeCB.Items.add('NH12   Pentecote');
        StateFipsCodeCB.Items.add('NH13   Santo/Malo');
        StateFipsCodeCB.Items.add('NH14   Shepherd');
        StateFipsCodeCB.Items.add('NH15   Tafea');
    End;
250: Begin CountryNameEdit.Text:={Vatican City-}'VT';
{VT     VATICAN CITY}
     End;
251: Begin CountryNameEdit.Text:={Venezuela-}'VE';
{VE     VENEZUELA
***federal dependencies/dependencias federales
**federal district/distrito federal
state/estado *territory/territorio}
        StateFipsCodeCB.Items.add('VE01   Amazonas*');
        StateFipsCodeCB.Items.add('VE02   Anzoategui');
        StateFipsCodeCB.Items.add('VE03   Apure');
        StateFipsCodeCB.Items.add('VE04   Aragua');
        StateFipsCodeCB.Items.add('VE05   Barinas');
        StateFipsCodeCB.Items.add('VE06   Bolivar');
        StateFipsCodeCB.Items.add('VE07   Carabobo');
        StateFipsCodeCB.Items.add('VE08   Cojedes');
        StateFipsCodeCB.Items.add('VE09   Delta Amacuro*');
        StateFipsCodeCB.Items.add('VE24   Dependencias Federales***');
        StateFipsCodeCB.Items.add('VE10   Distrito Federal**');
        StateFipsCodeCB.Items.add('VE11   Falcon');
        StateFipsCodeCB.Items.add('VE12   Guarico');
        StateFipsCodeCB.Items.add('VE13   Lara');
        StateFipsCodeCB.Items.add('VE14   Merida');
        StateFipsCodeCB.Items.add('VE15   Miranda');
        StateFipsCodeCB.Items.add('VE16   Monagas');
        StateFipsCodeCB.Items.add('VE17   Nueva Esparta');
        StateFipsCodeCB.Items.add('VE18   Portuguesa');
        StateFipsCodeCB.Items.add('VE19   Sucre');
        StateFipsCodeCB.Items.add('VE20   Tachira');
        StateFipsCodeCB.Items.add('VE21   Trujillo');
        StateFipsCodeCB.Items.add('VE22   Yaracuy');
        StateFipsCodeCB.Items.add('VE23   Zulia');
    End;
252: Begin CountryNameEdit.Text:={Vietnam-}'VM';
{VM     VIETNAM
NOTE:  ADM1 names have been taken from the most reliable sources
available.  They have not necessarily been approved by the US Board
on Geographic Names.
*municipality/thanh pho  province/tinh}
        StateFipsCodeCB.Items.add('VM43   An Giang');
        StateFipsCodeCB.Items.add('VM53   Ba Ria-Vung Tau');
        StateFipsCodeCB.Items.add('VM02   Bac Thai');
        StateFipsCodeCB.Items.add('VM03   Ben Tre');
        StateFipsCodeCB.Items.add('VM54   Binh Dinh');
        StateFipsCodeCB.Items.add('VM55   Binh Thuan');
        StateFipsCodeCB.Items.add('VM56   Can Tho');
        StateFipsCodeCB.Items.add('VM05   Cao Bang');
        StateFipsCodeCB.Items.add('VM44   Dac Lac');
        StateFipsCodeCB.Items.add('VM45   Dong Nai');
        StateFipsCodeCB.Items.add('VM46   Dong Thap');
        StateFipsCodeCB.Items.add('VM57   Gia Lai');
        StateFipsCodeCB.Items.add('VM11   Ha Bac');
        StateFipsCodeCB.Items.add('VM58   Ha Giang');
        StateFipsCodeCB.Items.add('VM51   Ha Noi*');
        StateFipsCodeCB.Items.add('VM59   Ha Tay');
        StateFipsCodeCB.Items.add('VM60   Ha Tinh');
        StateFipsCodeCB.Items.add('VM12   Hai Hung');
        StateFipsCodeCB.Items.add('VM13   Hai Phong*');
        StateFipsCodeCB.Items.add('VM52   Ho Chi Minh*');
        StateFipsCodeCB.Items.add('VM61   Hoa Binh');
        StateFipsCodeCB.Items.add('VM62   Khanh Hoa');
        StateFipsCodeCB.Items.add('VM47   Kien Giang');
        StateFipsCodeCB.Items.add('VM63   Kon Tum');
        StateFipsCodeCB.Items.add('VM22   Lai Chau');
        StateFipsCodeCB.Items.add('VM23   Lam Dong');
        StateFipsCodeCB.Items.add('VM39   Lang Son');
        StateFipsCodeCB.Items.add('VM64   Lao Cai');
        StateFipsCodeCB.Items.add('VM24   Long An');
        StateFipsCodeCB.Items.add('VM48   Minh Hai');
        StateFipsCodeCB.Items.add('VM65   Nam Ha');
        StateFipsCodeCB.Items.add('VM66   Nghe An');
        StateFipsCodeCB.Items.add('VM67   Ninh Binh');
        StateFipsCodeCB.Items.add('VM68   Ninh Thuan');
        StateFipsCodeCB.Items.add('VM69   Phu Yen');
        StateFipsCodeCB.Items.add('VM70   Quang Binh');
        StateFipsCodeCB.Items.add('VM29   Quang Nam-Da Nang');
        StateFipsCodeCB.Items.add('VM71   Quang Ngai');
        StateFipsCodeCB.Items.add('VM30   Quang Ninh');
        StateFipsCodeCB.Items.add('VM72   Quang Tri');
        StateFipsCodeCB.Items.add('VM73   Soc Trang');
        StateFipsCodeCB.Items.add('VM49   Song Be');
        StateFipsCodeCB.Items.add('VM32   Son La');
        StateFipsCodeCB.Items.add('VM33   Tay Ninh');
        StateFipsCodeCB.Items.add('VM35   Thai Binh');
        StateFipsCodeCB.Items.add('VM34   Thanh Hoa');
        StateFipsCodeCB.Items.add('VM74   Thua Thien');
        StateFipsCodeCB.Items.add('VM37   Tien Giang');
        StateFipsCodeCB.Items.add('VM75   Tra Vinh');
        StateFipsCodeCB.Items.add('VM76   Tuyen Quang');
        StateFipsCodeCB.Items.add('VM77   Vinh Long');
        StateFipsCodeCB.Items.add('VM50   Vinh Phu');
        StateFipsCodeCB.Items.add('VM78   Yen Bai');
    End;
253: Begin CountryNameEdit.Text:={Virgin Islands-}'VQ';
{VQ     VIRGIN ISLANDS}
     End;
254: Begin CountryNameEdit.Text:={Wake Island-}'WQ';
{WQ     WAKE ISLAND}
     End;
255: Begin CountryNameEdit.Text:={Wallis and Futuna-}'WF';
{WF     WALLIS AND FUTUNA}
     End;
256: Begin CountryNameEdit.Text:={West Bank-}'WE';
{WE     WEST BANK}
     End;
257: Begin CountryNameEdit.Text:={Western Sahara-}'WI';
{WI     WESTERN SAHARA}
     End;
258: Begin CountryNameEdit.Text:={Yemen-}'YM';
{YM     YEMEN  governorate/muhafazah}
        StateFipsCodeCB.Items.add('YM01   Abyan');
        StateFipsCodeCB.Items.add('YM02   `Adan');
        StateFipsCodeCB.Items.add('YM07   Al Bayda`');
        StateFipsCodeCB.Items.add('YM08   Al Hudaydah');
        StateFipsCodeCB.Items.add('YM09   Al Jawf');
        StateFipsCodeCB.Items.add('YM03   Al Mahrah');
        StateFipsCodeCB.Items.add('YM10   Al Mahwit');
        StateFipsCodeCB.Items.add('YM11   Dhamar');
        StateFipsCodeCB.Items.add('YM04   Hadramawt');
        StateFipsCodeCB.Items.add('YM12   Hajjah');
        StateFipsCodeCB.Items.add('YM13   Ibb');
        StateFipsCodeCB.Items.add('YM06   Lahij');
        StateFipsCodeCB.Items.add('YM14   Ma`rib');
        StateFipsCodeCB.Items.add('YM05   Shabwah');
        StateFipsCodeCB.Items.add('YM15   Sa`dah');
        StateFipsCodeCB.Items.add('YM16   San`a`');
        StateFipsCodeCB.Items.add('YM17   Ta`izz');
    End;
259: Begin CountryNameEdit.Text:={Yugoslavia-}'YI';
     End;
260: Begin CountryNameEdit.Text:={Zambia-}'ZA';
{ZA     ZAMBIA province}
        StateFipsCodeCB.Items.add('ZA02   Central');
        StateFipsCodeCB.Items.add('ZA08   Copperbelt');
        StateFipsCodeCB.Items.add('ZA03   Eastern');
        StateFipsCodeCB.Items.add('ZA04   Luapula');
        StateFipsCodeCB.Items.add('ZA09   Lusaka');
        StateFipsCodeCB.Items.add('ZA05   Northern');
        StateFipsCodeCB.Items.add('ZA06   North-Western');
        StateFipsCodeCB.Items.add('ZA07   Southern');
        StateFipsCodeCB.Items.add('ZA01   Western');
    End;


261: Begin CountryNameEdit.Text:={Zimbabwe-}'ZI';
{ZI     ZIMBABWE province}
        StateFipsCodeCB.Items.add('ZI01   Manicaland');
        StateFipsCodeCB.Items.add('ZI03   Mashonaland Central');
        StateFipsCodeCB.Items.add('ZI04   Mashonaland East');
        StateFipsCodeCB.Items.add('ZI05   Mashonaland West');
        StateFipsCodeCB.Items.add('ZI06   Matabeleland North');
        StateFipsCodeCB.Items.add('ZI07   Matabeleland South');
        StateFipsCodeCB.Items.add('ZI02   Midlands');
        StateFipsCodeCB.Items.add('ZI08   Masvingo');
    End;
262: Begin CountryNameEdit.Text:={North America-}'NA';
     End;
263: Begin CountryNameEdit.Text:={South America-}'SS';
     End;
264: Begin CountryNameEdit.Text:={Greenland-93-}'GL';
{WRONG}
     End;
265: Begin CountryNameEdit.Text:={Europe-}'EE';
     End;
266: Begin CountryNameEdit.Text:={Africa-}'AI';
     End;
267: Begin CountryNameEdit.Text:={Asia East-}'AX';
     End;
268: Begin CountryNameEdit.Text:={Asia West-}'AW';
     End;
269: Begin CountryNameEdit.Text:={Asia South-}'AZ';
     End;
270: Begin CountryNameEdit.Text:={Australia-13-}'AS';
{WRONG}         StateFipsCodeCB.Clear;
        StateFipsCodeCB.Items.add('00 : Unknown');
     End;
271: Begin CountryNameEdit.Text:={Antarctica-17-}'AY';
{WRONG}         StateFipsCodeCB.Clear;
        StateFipsCodeCB.Items.add('00 : Unknown');
     End;
End;{Case}
End;


(*************************************************************)
(*************************************************************)
{Set State Name and Fips Code  IAW Country/State/County inputs
 AND SET UP COUNTY ComboBox items}
procedure THtfForm.StateFipsCodeCBChange(Sender: TObject);
begin
  SetStateFipsCode(CountryFipsCodeCB.ItemIndex,
                   StateFipsCodeCB.ItemIndex,
                   0);
  SetCountyFipsCode(CountryFipsCodeCB.ItemIndex,
                   StateFipsCodeCB.ItemIndex,
                   0);
  CountyFipsCodeCB.ItemIndex:=0;
end;



procedure THtfForm.SetStateFipsCode(CountryIn,StateIn,CountyIn:Integer);
var FipsString:String;
{FipsCode:Integer;}
begin
        FipsString:=StateFipsCodeCB.Items[
          StateFipsCodeCB.ItemIndex];
        StateFipsCodeEdit.Text:=Trim(Copy(FipsString,1,4));
        StateNameEdit.Text:=Trim(Copy(FipsString,5,Length(FipsString)));
(*
  Case CountryIn of
    246:Begin
Case StateIn of
1:Begin FipsCode:=01 ;StateNameEdit.Text:='AL';end;{: Alabama';}
2:Begin FipsCode:=02 ;StateNameEdit.Text:='AK';end;{: Alaska';}
3:Begin FipsCode:=04 ;StateNameEdit.Text:='AZ';end;{: Arizona';}
4:Begin FipsCode:=05 ;StateNameEdit.Text:='AR';end;{: Arkansas';}
5:Begin FipsCode:=06 ;StateNameEdit.Text:='CA';end;{: California';}
6:Begin FipsCode:=08 ;StateNameEdit.Text:='CO';end;{: Colorado';}
7:Begin FipsCode:=09 ;StateNameEdit.Text:='CT';end;{: Connecticut';}
8:Begin FipsCode:=10 ;StateNameEdit.Text:='DE';end;{: Delaware';}
9:Begin FipsCode:=11 ;StateNameEdit.Text:='DC';end;{: District of Columbia';}
10:Begin FipsCode:=12 ;StateNameEdit.Text:='FL';end;{: Florida';}
11:Begin FipsCode:=13 ;StateNameEdit.Text:='GA';end;{: Georgia';}
12:Begin FipsCode:=15 ;StateNameEdit.Text:='HI';end;{: Hawaii';}
13:Begin FipsCode:=16 ;StateNameEdit.Text:='ID';end;{: Idaho';}
14:Begin FipsCode:=17 ;StateNameEdit.Text:='IL';end;{: Illinois';}
15:Begin FipsCode:=18 ;StateNameEdit.Text:='IN';end;{: Indiana';}
16:Begin FipsCode:=19 ;StateNameEdit.Text:='IA';end;{: Iowa';}
17:Begin FipsCode:=20 ;StateNameEdit.Text:='KS';end;{: Kansas';}
18:Begin FipsCode:=21 ;StateNameEdit.Text:='KY';end;{: Kentucky';}
19:Begin FipsCode:=22 ;StateNameEdit.Text:='LA';end;{: Louisiana';}
20:Begin FipsCode:=23 ;StateNameEdit.Text:='ME';end;{: Maine';}
21:Begin FipsCode:=24 ;StateNameEdit.Text:='MD';end;{: Maryland';}
22:Begin FipsCode:=25 ;StateNameEdit.Text:='MA';end;{: Massachusetts';}
23:Begin FipsCode:=26 ;StateNameEdit.Text:='MI';end;{: Michigan';}
24:Begin FipsCode:=27 ;StateNameEdit.Text:='MN';end;{: Minnesota';}
25:Begin FipsCode:=28 ;StateNameEdit.Text:='MS';end;{: Mississippi';}
26:Begin FipsCode:=29 ;StateNameEdit.Text:='MO';end;{: Missouri';}
27:Begin FipsCode:=30 ;StateNameEdit.Text:='MT';end;{: Montana';}
28:Begin FipsCode:=31 ;StateNameEdit.Text:='NE';end;{: Nebraska';}
29:Begin FipsCode:=32 ;StateNameEdit.Text:='NV';end;{: Nevada';}
30:Begin FipsCode:=33 ;StateNameEdit.Text:='NH';end;{: New Hampshire';}
31:Begin FipsCode:=34 ;StateNameEdit.Text:='NJ';end;{: New Jersey';}
32:Begin FipsCode:=35 ;StateNameEdit.Text:='NM';end;{: New Mexico';}
33:Begin FipsCode:=36 ;StateNameEdit.Text:='NY';end;{: New York';}
34:Begin FipsCode:=37 ;StateNameEdit.Text:='NC';end;{: North Carolina';}
35:Begin FipsCode:=38 ;StateNameEdit.Text:='ND';end;{: North Dakota';}
36:Begin FipsCode:=39 ;StateNameEdit.Text:='OH';end;{: Ohio';}
37:Begin FipsCode:=40 ;StateNameEdit.Text:='OK';end;{: Oklahoma';}
38:Begin FipsCode:=41 ;StateNameEdit.Text:='OR';end;{: Oregon';}
39:Begin FipsCode:=42 ;StateNameEdit.Text:='PA';end;{: Pennsylvania';}
40:Begin FipsCode:=44 ;StateNameEdit.Text:='RI';end;{: RhodeIsland';}
41:Begin FipsCode:=45 ;StateNameEdit.Text:='SC';end;{: South Carolina';}
42:Begin FipsCode:=46 ;StateNameEdit.Text:='SD';end;{: South Dakota';}
43:Begin FipsCode:=47 ;StateNameEdit.Text:='TN';end;{: Tennessee';}
44:Begin FipsCode:=48 ;StateNameEdit.Text:='TX';end;{: Texas';}
45:Begin FipsCode:=49 ;StateNameEdit.Text:='UT';end;{: Utah';}
46:Begin FipsCode:=50 ;StateNameEdit.Text:='VT';end;{: Vermont';}
47:Begin FipsCode:=51 ;StateNameEdit.Text:='VA';end;{: Virginia';}
48:Begin FipsCode:=53 ;StateNameEdit.Text:='WA';end;{: Washington';}
49:Begin FipsCode:=54 ;StateNameEdit.Text:='WV';end;{: West Virginia';}
50:Begin FipsCode:=55 ;StateNameEdit.Text:='WI';end;{: Wisconsin';}
51:Begin FipsCode:=56 ;StateNameEdit.Text:='WY';end;{: Wyoming';}
52:Begin FipsCode:=60 ;StateNameEdit.Text:='AS';end;{: American Samoa';}
53:Begin FipsCode:=66 ;StateNameEdit.Text:='GU';end;{: Guam';}
54:Begin FipsCode:=69 ;StateNameEdit.Text:='MP';end;{: Northern Mariana Islands';}
55:Begin FipsCode:=70 ;StateNameEdit.Text:='PW';end;{: Palau';}
56:Begin FipsCode:=72 ;StateNameEdit.Text:='PR';end;{: Puerto Rico';}
57:Begin FipsCode:=78 ;StateNameEdit.Text:='VI';end;{: Virgin Islands (US)';}
58:Begin FipsCode:=74 ;StateNameEdit.Text:='UM';end;{US MINOR OUTLYING ISLANDS}
59:Begin FipsCode:=64 ;StateNameEdit.Text:='FM';end;{FEDERATED STATES OF MICRONESIA}
60:Begin FipsCode:=68 ;StateNameEdit.Text:='MH';end;{MARSHALL ISLANDS}
else Begin FipsCode:=0; StateNameEdit.Text:='ZZ';end;
end;
StateFipsCodeEdit.Text:=Inttostr(FipsCode);
{Set up COUNTY Combo Box items}
End;{CountryIn of    246}
End;{Country Case}
*)
end;





procedure THtfForm.DecipherSetStateFipsCode;
var FipsCode:Integer;
Switchback:String;
begin
Switchback:=StateNameEdit.Text;
If (Switchback='AL') then
Begin FipsCode:=01 ;StateFipsCodeCB.ItemIndex:=1;end{: Alabama';}
else If (Switchback='AK') then
Begin FipsCode:=02 ;StateFipsCodeCB.ItemIndex:=2;end{: Alaska';}
else If (Switchback='AZ') then
Begin FipsCode:=04 ;StateFipsCodeCB.ItemIndex:=3;end{: Arizona';}
else If (Switchback='AR') then
Begin FipsCode:=05 ;StateFipsCodeCB.ItemIndex:=4;end{: Arkansas';}
else If (Switchback='CA') then
Begin FipsCode:=06 ;StateFipsCodeCB.ItemIndex:=5;end{: California';}
else If (Switchback='CO') then
Begin FipsCode:=08 ;StateFipsCodeCB.ItemIndex:=6;end{: Colorado';}
else If (Switchback='CT') then
Begin FipsCode:=09 ;StateFipsCodeCB.ItemIndex:=7;end{: Connecticut';}
else If (Switchback='DE') then
Begin FipsCode:=10 ;StateFipsCodeCB.ItemIndex:=8;end{: Delaware';}
else If (Switchback='DC') then
Begin FipsCode:=11 ;StateFipsCodeCB.ItemIndex:=9;end{: District of Columbia';}
else If (Switchback='FL') then
Begin FipsCode:=12 ;StateFipsCodeCB.ItemIndex:=10;end{: Florida';}
else If (Switchback='GA') then
Begin FipsCode:=13 ;StateFipsCodeCB.ItemIndex:=11;end{: Georgia';}
else If (Switchback='HI') then
Begin FipsCode:=15 ;StateFipsCodeCB.ItemIndex:=12;end{: Hawaii';}
else If (Switchback='ID') then
Begin FipsCode:=16 ;StateFipsCodeCB.ItemIndex:=13;end{: Idaho';}
else If (Switchback='IL') then
Begin FipsCode:=17 ;StateFipsCodeCB.ItemIndex:=14;end{: Illinois';}
else If (Switchback='IN') then
Begin FipsCode:=18 ;StateFipsCodeCB.ItemIndex:=15;end{: Indiana';}
else If (Switchback='IA') then
Begin FipsCode:=19 ;StateFipsCodeCB.ItemIndex:=16;end{: Iowa';}
else If (Switchback='KS') then
Begin FipsCode:=20 ;StateFipsCodeCB.ItemIndex:=17;end{: Kansas';}
else If (Switchback='KY') then
Begin FipsCode:=21 ;StateFipsCodeCB.ItemIndex:=18;end{: Kentucky';}
else If (Switchback='LA') then
Begin FipsCode:=22 ;StateFipsCodeCB.ItemIndex:=19;end{: Louisiana';}
else If (Switchback='ME') then
Begin FipsCode:=23 ;StateFipsCodeCB.ItemIndex:=20;end{: Maine';}
else If (Switchback='MD') then
Begin FipsCode:=24 ;StateFipsCodeCB.ItemIndex:=21;end{: Maryland';}
else If (Switchback='MA') then
Begin FipsCode:=25 ;StateFipsCodeCB.ItemIndex:=22;end{: Massachusetts';}
else If (Switchback='MI') then
Begin FipsCode:=26 ;StateFipsCodeCB.ItemIndex:=23;end{: Michigan';}
else If (Switchback='MN') then
Begin FipsCode:=27 ;StateFipsCodeCB.ItemIndex:=24;end{: Minnesota';}
else If (Switchback='MS') then
Begin FipsCode:=28 ;StateFipsCodeCB.ItemIndex:=25;end{: Mississippi';}
else If (Switchback='MO') then
Begin FipsCode:=29 ;StateFipsCodeCB.ItemIndex:=26;end{: Missouri';}
else If (Switchback='MT') then
Begin FipsCode:=30 ;StateFipsCodeCB.ItemIndex:=27;end{: Montana';}
else If (Switchback='NE') then
Begin FipsCode:=31 ;StateFipsCodeCB.ItemIndex:=28;end{: Nebraska';}
else If (Switchback='NV') then
Begin FipsCode:=32 ;StateFipsCodeCB.ItemIndex:=29;end{: Nevada';}
else If (Switchback='NH') then
Begin FipsCode:=33 ;StateFipsCodeCB.ItemIndex:=30;end{: New Hampshire';}
else If (Switchback='NJ') then
Begin FipsCode:=34 ;StateFipsCodeCB.ItemIndex:=31;end{: New Jersey';}
else If (Switchback='NM') then
Begin FipsCode:=35 ;StateFipsCodeCB.ItemIndex:=32;end{: New Mexico';}
else If (Switchback='NY') then
Begin FipsCode:=36 ;StateFipsCodeCB.ItemIndex:=33;end{: New York';}
else If (Switchback='NC') then
Begin FipsCode:=37 ;StateFipsCodeCB.ItemIndex:=34;end{: North Carolina';}
else If (Switchback='ND') then
Begin FipsCode:=38 ;StateFipsCodeCB.ItemIndex:=35;end{: North Dakota';}
else If (Switchback='OH') then
Begin FipsCode:=39 ;StateFipsCodeCB.ItemIndex:=36;end{: Ohio';}
else If (Switchback='OK') then
Begin FipsCode:=40 ;StateFipsCodeCB.ItemIndex:=37;end{: Oklahoma';}
else If (Switchback='OR') then
Begin FipsCode:=41 ;StateFipsCodeCB.ItemIndex:=38;end{: Oregon';}
else If (Switchback='PA') then
Begin FipsCode:=42 ;StateFipsCodeCB.ItemIndex:=39;end{: Pennsylvania';}
else If (Switchback='RI') then
Begin FipsCode:=44 ;StateFipsCodeCB.ItemIndex:=40;end{: RhodeIsland';}
else If (Switchback='SC') then
Begin FipsCode:=45 ;StateFipsCodeCB.ItemIndex:=41;end{: South Carolina';}
else If (Switchback='SD') then
Begin FipsCode:=46 ;StateFipsCodeCB.ItemIndex:=42;end{: South Dakota';}
else If (Switchback='TN') then
Begin FipsCode:=47 ;StateFipsCodeCB.ItemIndex:=43;end{: Tennessee';}
else If (Switchback='TX') then
Begin FipsCode:=48 ;StateFipsCodeCB.ItemIndex:=44;end{: Texas';}
else If (Switchback='UT') then
Begin FipsCode:=49 ;StateFipsCodeCB.ItemIndex:=45;end{: Utah';}
else If (Switchback='VT') then
Begin FipsCode:=50 ;StateFipsCodeCB.ItemIndex:=46;end{: Vermont';}
else If (Switchback='VA') then
Begin FipsCode:=51 ;StateFipsCodeCB.ItemIndex:=47;end{: Virginia';}
else If (Switchback='WA') then
Begin FipsCode:=53 ;StateFipsCodeCB.ItemIndex:=48;end{: Washington';}
else If (Switchback='WV') then
Begin FipsCode:=54 ;StateFipsCodeCB.ItemIndex:=49;end{: West Virginia';}
else If (Switchback='WI') then
Begin FipsCode:=55 ;StateFipsCodeCB.ItemIndex:=50;end{: Wisconsin';}
else If (Switchback='WY') then
Begin FipsCode:=56 ;StateFipsCodeCB.ItemIndex:=51;end{: Wyoming';}
else If (Switchback='AS') then
Begin FipsCode:=60 ;StateFipsCodeCB.ItemIndex:=52;end{: American Samoa';}
else If (Switchback='GU') then
Begin FipsCode:=66 ;StateFipsCodeCB.ItemIndex:=53;end{: Guam';}
else If (Switchback='MP') then
Begin FipsCode:=69 ;StateFipsCodeCB.ItemIndex:=54;end{: Northern Mariana Islands';}
else If (Switchback='PW') then
Begin FipsCode:=70 ;StateFipsCodeCB.ItemIndex:=55;end{: Palau';}
else If (Switchback='PR') then
Begin FipsCode:=72 ;StateFipsCodeCB.ItemIndex:=56;end{: Puerto Rico';}
else If (Switchback='VI') then
Begin FipsCode:=78 ;StateFipsCodeCB.ItemIndex:=57;end{: Virgin Islands (US)';}
else If (Switchback='UM') then
Begin FipsCode:=74 ;StateFipsCodeCB.ItemIndex:=58;end{US MINOR OUTLYING ISLANDS}
else If (Switchback='FM') then
Begin FipsCode:=64 ;StateFipsCodeCB.ItemIndex:=59;end{FEDERATED STATES OF MICRONESIA}
else If (Switchback='MH') then
Begin FipsCode:=68 ;StateFipsCodeCB.ItemIndex:=60;end{MARSHALL ISLANDS}

else Begin FipsCode:=0; StateNameEdit.Text:='zz';end;
StateFipsCodeEdit.Text:=Inttostr(FipsCode);
end;
(*************************************************************)
(*************************************************************)


(*************************************************************)
(*************************************************************)
procedure THtfForm.CountyFipsCodeCBChange(Sender: TObject);
var FipsString:String;
{FipsCode:Integer;}
begin
  {Set County Name and Fips Code  IAW Country/State/County inputs}
  {Base filler}
{  FipsCode:=CountyFipsCodeCB.ItemIndex;}
  CountyNameEdit.Text:='ZZ';
  {Fill by actual data}
  Case CountryFipsCodeCB.ItemIndex of
  246:Begin
        FipsString:=CountyFipsCodeCB.Items[
          CountyFipsCodeCB.ItemIndex];
        CountyFipsCodeEdit.Text:=Trim(Copy(FipsString,1,3));
        CountyNameEdit.Text:=Trim(Copy(FipsString,4,Length(FipsString)));
        Case StateFipsCodeCB.ItemIndex of
        0:Begin
            Case CountyFipsCodeCB.ItemIndex of
            0:Begin
              End;
            End;{Case  CountyIn}
          End;
        End{Case StateIn}
      End;{246}
  End;{Case CountryIn}
{  CountyFipsCodeEdit.Text:=Inttostr(FipsCode);}
end;

procedure THtfForm.SetCountyFipsCode(CountryIn,StateIn,CountyIn:Integer);
begin
  CountyFipsCodeCB.Clear;
  CountyFipsCodeCB.Items.add('00 : Unknown');
  Case CountryIn of
  246:Begin
Case StateIn of
1:Begin {1: Alabama';}
        CountyFipsCodeCB.Items.add('001  Autauga');
        CountyFipsCodeCB.Items.add('003  Baldwin');
        CountyFipsCodeCB.Items.add('005  Barbour');
        CountyFipsCodeCB.Items.add('007  Bibb');
        CountyFipsCodeCB.Items.add('009  Blount');
        CountyFipsCodeCB.Items.add('011  Bullock');
        CountyFipsCodeCB.Items.add('013  Butler');
        CountyFipsCodeCB.Items.add('015  Calhoun');
        CountyFipsCodeCB.Items.add('017  Chambers');
        CountyFipsCodeCB.Items.add('019  Cherokee');
        CountyFipsCodeCB.Items.add('021  Chilton');
        CountyFipsCodeCB.Items.add('023  Choctaw');
        CountyFipsCodeCB.Items.add('025  Clarke');
        CountyFipsCodeCB.Items.add('027  Clay');
        CountyFipsCodeCB.Items.add('029  Cleburne');
        CountyFipsCodeCB.Items.add('031  Coffee');
        CountyFipsCodeCB.Items.add('033  Colbert');
        CountyFipsCodeCB.Items.add('035  Conecuh');
        CountyFipsCodeCB.Items.add('037  Coosa');
        CountyFipsCodeCB.Items.add('039  Covington');
        CountyFipsCodeCB.Items.add('041  Crenshaw');
        CountyFipsCodeCB.Items.add('043  Cullman');
        CountyFipsCodeCB.Items.add('045  Dale');
        CountyFipsCodeCB.Items.add('047  Dallas');
        CountyFipsCodeCB.Items.add('049  DeKalb*');
        CountyFipsCodeCB.Items.add('051  Elmore');
        CountyFipsCodeCB.Items.add('053  Escambia');
        CountyFipsCodeCB.Items.add('055  Etowah');
        CountyFipsCodeCB.Items.add('057  Fayette');
        CountyFipsCodeCB.Items.add('059  Franklin');
        CountyFipsCodeCB.Items.add('061  Geneva');
        CountyFipsCodeCB.Items.add('063  Greene');
        CountyFipsCodeCB.Items.add('065  Hale');
        CountyFipsCodeCB.Items.add('067  Henry');
        CountyFipsCodeCB.Items.add('069  Houston');
        CountyFipsCodeCB.Items.add('071  Jackson');
        CountyFipsCodeCB.Items.add('073  Jefferson');
        CountyFipsCodeCB.Items.add('075  Lamar');
        CountyFipsCodeCB.Items.add('077  Lauderdale');
        CountyFipsCodeCB.Items.add('073  Jefferson');
        CountyFipsCodeCB.Items.add('079  Lawrence');
        CountyFipsCodeCB.Items.add('081  Lee');
        CountyFipsCodeCB.Items.add('083  Limestone');
        CountyFipsCodeCB.Items.add('085  Lowndes');
        CountyFipsCodeCB.Items.add('087  Macon');
        CountyFipsCodeCB.Items.add('089  Madison');
        CountyFipsCodeCB.Items.add('091  Marengo');
        CountyFipsCodeCB.Items.add('093  Marion');
        CountyFipsCodeCB.Items.add('095  Marshall');
        CountyFipsCodeCB.Items.add('097  Mobile');
        CountyFipsCodeCB.Items.add('099  Monroe');
        CountyFipsCodeCB.Items.add('101  Montgomery');
        CountyFipsCodeCB.Items.add('103  Morgan');
        CountyFipsCodeCB.Items.add('105  Perry');
        CountyFipsCodeCB.Items.add('107  Pickens');
        CountyFipsCodeCB.Items.add('109  Pike');
        CountyFipsCodeCB.Items.add('111  Randolph');
        CountyFipsCodeCB.Items.add('113  Russell');
        CountyFipsCodeCB.Items.add('115  St. Clair');
        CountyFipsCodeCB.Items.add('117  Shelby');
        CountyFipsCodeCB.Items.add('119  Sumter');
        CountyFipsCodeCB.Items.add('121  Talladega');
        CountyFipsCodeCB.Items.add('123  Tallapoosa');
        CountyFipsCodeCB.Items.add('125  Tuscaloosa');
        CountyFipsCodeCB.Items.add('127  Walker');
        CountyFipsCodeCB.Items.add('129  Washington');
        CountyFipsCodeCB.Items.add('131  Wilcox');
        CountyFipsCodeCB.Items.add('133  Winston');
  end;
2:Begin {2: Alaska';}
    CountyFipsCodeCB.Items.add('013* Aleutians East');
    CountyFipsCodeCB.Items.add('016* Aleutians West (CA)');
    CountyFipsCodeCB.Items.add('020  Anchorage');
    CountyFipsCodeCB.Items.add('050  Bethel (CA)');
    CountyFipsCodeCB.Items.add('060  Bristol Bay');
    CountyFipsCodeCB.Items.add('070  Dillingham (CA)');
    CountyFipsCodeCB.Items.add('090  Fairbanks North Star');
    CountyFipsCodeCB.Items.add('100  Haines');
    CountyFipsCodeCB.Items.add('110  Juneau');
    CountyFipsCodeCB.Items.add('122  Kenai Peninsula');
    CountyFipsCodeCB.Items.add('130  Ketchikan Gateway');
    CountyFipsCodeCB.Items.add('150  Kodiak Island');
    CountyFipsCodeCB.Items.add('164* Lake and Peninsula');
    CountyFipsCodeCB.Items.add('170  Matanuska-Susitna');
    CountyFipsCodeCB.Items.add('180  Nome (CA)');
    CountyFipsCodeCB.Items.add('185  North Slope');
    CountyFipsCodeCB.Items.add('188* Northwest Arctic');
    CountyFipsCodeCB.Items.add('201  Prince of Wales-OuterKetchikan (CA)');
    CountyFipsCodeCB.Items.add('220  Sitka');
    CountyFipsCodeCB.Items.add('231  Skagway-Yakutat-Angoon (CA)');
    CountyFipsCodeCB.Items.add('240  Southeast Fairbanks (CA)');
    CountyFipsCodeCB.Items.add('261  Valdez-Gordova (CA)');
    CountyFipsCodeCB.Items.add('270  Wade Hampton (CA)');
    CountyFipsCodeCB.Items.add('280  Wrangell-Petersburg (CA)');
    CountyFipsCodeCB.Items.add('290  Yukon-Koyukuk (CA)');
  end;
3:Begin {4: Arizona';}
    CountyFipsCodeCB.Items.add('001  Apache');
    CountyFipsCodeCB.Items.add('003  Cochise');
    CountyFipsCodeCB.Items.add('005  Coconino');
    CountyFipsCodeCB.Items.add('007  Gila');
    CountyFipsCodeCB.Items.add('009  Graham ');
    CountyFipsCodeCB.Items.add('011  Greenlee');
    CountyFipsCodeCB.Items.add('012* La Paz');
    CountyFipsCodeCB.Items.add('013  Maricopa');
    CountyFipsCodeCB.Items.add('015  Mohave');
    CountyFipsCodeCB.Items.add('017  Navajo');
    CountyFipsCodeCB.Items.add('019  Pima');
    CountyFipsCodeCB.Items.add('021  Pinal');
    CountyFipsCodeCB.Items.add('023  Santa Cruz');
    CountyFipsCodeCB.Items.add('025  Yavapai');
    CountyFipsCodeCB.Items.add('027  Yuma');
  end;
4:Begin  {ARKANSAS (AR) (05)}
    CountyFipsCodeCB.Items.add('001  Arkansas');
    CountyFipsCodeCB.Items.add('003  Ashley');
    CountyFipsCodeCB.Items.add('005  Baxter');
    CountyFipsCodeCB.Items.add('007  Benton');
    CountyFipsCodeCB.Items.add('009  Boone');
    CountyFipsCodeCB.Items.add('011  Bradley');
    CountyFipsCodeCB.Items.add('013  Calhoun');
    CountyFipsCodeCB.Items.add('015  Carroll');
    CountyFipsCodeCB.Items.add('017  Chicot');
    CountyFipsCodeCB.Items.add('019  Clark');
    CountyFipsCodeCB.Items.add('021  Clay');
    CountyFipsCodeCB.Items.add('023  Cleburne');
    CountyFipsCodeCB.Items.add('025  Cleveland');
    CountyFipsCodeCB.Items.add('027  Columbia');
    CountyFipsCodeCB.Items.add('029  Conway');
    CountyFipsCodeCB.Items.add('031  Craighead');
    CountyFipsCodeCB.Items.add('033  Crawford');
    CountyFipsCodeCB.Items.add('035  Crittenden');
    CountyFipsCodeCB.Items.add('037  Cross');
    CountyFipsCodeCB.Items.add('039  Dallas');
    CountyFipsCodeCB.Items.add('041  Desha');
    CountyFipsCodeCB.Items.add('043  Drew');
    CountyFipsCodeCB.Items.add('045  Faulkner');
    CountyFipsCodeCB.Items.add('047  Franklin');
    CountyFipsCodeCB.Items.add('049  Fulton');
    CountyFipsCodeCB.Items.add('051  Garland');
    CountyFipsCodeCB.Items.add('053  Grant');
    CountyFipsCodeCB.Items.add('055  Greene');
    CountyFipsCodeCB.Items.add('057  Hempstead');
    CountyFipsCodeCB.Items.add('059  Hot Spring');
    CountyFipsCodeCB.Items.add('061  Howard');
    CountyFipsCodeCB.Items.add('063  Independence');
    CountyFipsCodeCB.Items.add('065  Izard');
    CountyFipsCodeCB.Items.add('067  Jackson');
    CountyFipsCodeCB.Items.add('069  Jefferson');
    CountyFipsCodeCB.Items.add('071  Johnson');
    CountyFipsCodeCB.Items.add('073  Lafayette');
    CountyFipsCodeCB.Items.add('075  Lawrence');
    CountyFipsCodeCB.Items.add('077  Lee');
    CountyFipsCodeCB.Items.add('079  Lincoln');
    CountyFipsCodeCB.Items.add('081  Little River');
    CountyFipsCodeCB.Items.add('083  Logan');
    CountyFipsCodeCB.Items.add('085  Lonoke');
    CountyFipsCodeCB.Items.add('087  Madison');
    CountyFipsCodeCB.Items.add('089  Marion');
    CountyFipsCodeCB.Items.add('091  Miller');
    CountyFipsCodeCB.Items.add('093  Mississippi');
    CountyFipsCodeCB.Items.add('095  Monroe');
    CountyFipsCodeCB.Items.add('097  Montgomery');
    CountyFipsCodeCB.Items.add('099  Nevada');
    CountyFipsCodeCB.Items.add('101  Newton');
    CountyFipsCodeCB.Items.add('103  Ouachita');
    CountyFipsCodeCB.Items.add('105  Perry');
    CountyFipsCodeCB.Items.add('107  Phillips');
    CountyFipsCodeCB.Items.add('109  Pike');
    CountyFipsCodeCB.Items.add('111  Poinsett');
    CountyFipsCodeCB.Items.add('113  Polk');
    CountyFipsCodeCB.Items.add('115  Pope');
    CountyFipsCodeCB.Items.add('117  Prairie');
    CountyFipsCodeCB.Items.add('119  Pulaski');
    CountyFipsCodeCB.Items.add('121  Randolph');
    CountyFipsCodeCB.Items.add('123  St. Francis');
    CountyFipsCodeCB.Items.add('125  Saline');
    CountyFipsCodeCB.Items.add('127  Scott');
    CountyFipsCodeCB.Items.add('129  Searcy');
    CountyFipsCodeCB.Items.add('131  Sebastian');
    CountyFipsCodeCB.Items.add('133  Sevier');
    CountyFipsCodeCB.Items.add('135  Sharp');
    CountyFipsCodeCB.Items.add('137  Stone');
    CountyFipsCodeCB.Items.add('139  Union');
    CountyFipsCodeCB.Items.add('141  Van Buren');
    CountyFipsCodeCB.Items.add('143  Washington');
    CountyFipsCodeCB.Items.add('145  White');
    CountyFipsCodeCB.Items.add('147  Woodruff');
    CountyFipsCodeCB.Items.add('149  Yell');
  end;{: Arkansas';}
5:Begin { CALIFORNIA (CA) (06)}
    CountyFipsCodeCB.Items.add('001  Alameda');
    CountyFipsCodeCB.Items.add('003  Alpine');
    CountyFipsCodeCB.Items.add('005  Amador');
    CountyFipsCodeCB.Items.add('007  Butte');
    CountyFipsCodeCB.Items.add('009  Calaveras');
    CountyFipsCodeCB.Items.add('011  Colusa');
    CountyFipsCodeCB.Items.add('013  Contra Costa');
    CountyFipsCodeCB.Items.add('015  Del Norte');
    CountyFipsCodeCB.Items.add('017  El Dorado');
    CountyFipsCodeCB.Items.add('019  Fresno');
    CountyFipsCodeCB.Items.add('021  Glenn');
    CountyFipsCodeCB.Items.add('023  Humboldt');
    CountyFipsCodeCB.Items.add('025  Imperial');
    CountyFipsCodeCB.Items.add('027  Inyo');
    CountyFipsCodeCB.Items.add('029  Kern');
    CountyFipsCodeCB.Items.add('031  Kings ');
    CountyFipsCodeCB.Items.add('033  Lake');
    CountyFipsCodeCB.Items.add('035  Lassen');
    CountyFipsCodeCB.Items.add('037  Los Angeles');
    CountyFipsCodeCB.Items.add('039  Madera');
    CountyFipsCodeCB.Items.add('041  Marin');
    CountyFipsCodeCB.Items.add('043  Mariposa');
    CountyFipsCodeCB.Items.add('045  Mendocino');
    CountyFipsCodeCB.Items.add('051  Mono');
    CountyFipsCodeCB.Items.add('053  Monterey');
    CountyFipsCodeCB.Items.add('055  Napa');
    CountyFipsCodeCB.Items.add('057  Nevada');
    CountyFipsCodeCB.Items.add('059  Orange');
    CountyFipsCodeCB.Items.add('061  Placer');
    CountyFipsCodeCB.Items.add('063  Plumas');
    CountyFipsCodeCB.Items.add('065  Riverside');
    CountyFipsCodeCB.Items.add('067  Sacramento');
    CountyFipsCodeCB.Items.add('069  San Benito');
    CountyFipsCodeCB.Items.add('071  San Bernardino');
    CountyFipsCodeCB.Items.add('073  San Diego');
    CountyFipsCodeCB.Items.add('075  San Francisco');
    CountyFipsCodeCB.Items.add('077  San Joaquin');
    CountyFipsCodeCB.Items.add('079  San Luis Obispo');
    CountyFipsCodeCB.Items.add('081  San Mateo');
    CountyFipsCodeCB.Items.add('083  Santa Barbara');
    CountyFipsCodeCB.Items.add('085  Santa Clara');
    CountyFipsCodeCB.Items.add('087  Santa Cruz');
    CountyFipsCodeCB.Items.add('089  Shasta');
    CountyFipsCodeCB.Items.add('091  Sierra');
    CountyFipsCodeCB.Items.add('093  Siskiyou');
    CountyFipsCodeCB.Items.add('095  Solano');
    CountyFipsCodeCB.Items.add('097  Sonoma');
    CountyFipsCodeCB.Items.add('099  Stanislaus');
    CountyFipsCodeCB.Items.add('101  Sutter');
    CountyFipsCodeCB.Items.add('103  Tehama');
    CountyFipsCodeCB.Items.add('105  Trinity');
    CountyFipsCodeCB.Items.add('107  Tulare');
    CountyFipsCodeCB.Items.add('109  Tuolumne');
    CountyFipsCodeCB.Items.add('111  Ventura');
    CountyFipsCodeCB.Items.add('113  Yolo');
    CountyFipsCodeCB.Items.add('115  Yuba');
  end;{: California';}
6:Begin {COLORADO (CO) (08)}
    CountyFipsCodeCB.Items.add('001  Adams');
    CountyFipsCodeCB.Items.add('003  Alamosa');
    CountyFipsCodeCB.Items.add('005  Arapahoe');
    CountyFipsCodeCB.Items.add('007  Archuleta');
    CountyFipsCodeCB.Items.add('009  Baca');
    CountyFipsCodeCB.Items.add('011  Bent');
    CountyFipsCodeCB.Items.add('013  Boulder');
    CountyFipsCodeCB.Items.add('015  Chaffee');
    CountyFipsCodeCB.Items.add('017  Cheyenne');
    CountyFipsCodeCB.Items.add('019  Clear Creek');
    CountyFipsCodeCB.Items.add('021  Conejos');
    CountyFipsCodeCB.Items.add('023  Costilla');
    CountyFipsCodeCB.Items.add('025  Crowley');
    CountyFipsCodeCB.Items.add('027  Custer ');
    CountyFipsCodeCB.Items.add('029  Delta');
    CountyFipsCodeCB.Items.add('031  Denver');
    CountyFipsCodeCB.Items.add('033  Dolores');
    CountyFipsCodeCB.Items.add('035  Douglas');
    CountyFipsCodeCB.Items.add('037  Eagle');
    CountyFipsCodeCB.Items.add('039  Elbert');
    CountyFipsCodeCB.Items.add('041  El Paso');
    CountyFipsCodeCB.Items.add('043  Fremont');
    CountyFipsCodeCB.Items.add('045  Garfield');
    CountyFipsCodeCB.Items.add('047  Gilpin');
    CountyFipsCodeCB.Items.add('049  Grand');
    CountyFipsCodeCB.Items.add('051  Gunnison');
    CountyFipsCodeCB.Items.add('053  Hinsdale');
    CountyFipsCodeCB.Items.add('055  Huerfano');
    CountyFipsCodeCB.Items.add('101  Pueblo');
    CountyFipsCodeCB.Items.add('057  Jackson');
    CountyFipsCodeCB.Items.add('059  Jefferson');
    CountyFipsCodeCB.Items.add('061  Kiowa');
    CountyFipsCodeCB.Items.add('063  Kit Carson');
    CountyFipsCodeCB.Items.add('065  Lake');
    CountyFipsCodeCB.Items.add('067  La Plata');
    CountyFipsCodeCB.Items.add('069  Larimer');
    CountyFipsCodeCB.Items.add('071  Las Animas');
    CountyFipsCodeCB.Items.add('073  Lincoln');
    CountyFipsCodeCB.Items.add('075  Logan');
    CountyFipsCodeCB.Items.add('077  Mesa');
    CountyFipsCodeCB.Items.add('079  Mineral');
    CountyFipsCodeCB.Items.add('081  Moffat');
    CountyFipsCodeCB.Items.add('083  Montezuma');
    CountyFipsCodeCB.Items.add('085  Montrose');
    CountyFipsCodeCB.Items.add('087  Morgan');
    CountyFipsCodeCB.Items.add('089  Otero');
    CountyFipsCodeCB.Items.add('091  Ouray');
    CountyFipsCodeCB.Items.add('093  Park');
    CountyFipsCodeCB.Items.add('095  Phillips');
    CountyFipsCodeCB.Items.add('097  Pitkin');
    CountyFipsCodeCB.Items.add('099  Prowers');
    CountyFipsCodeCB.Items.add('103  Rio Blanco');
    CountyFipsCodeCB.Items.add('105  Rio Grande');
    CountyFipsCodeCB.Items.add('107  Routt');
    CountyFipsCodeCB.Items.add('109  Saguache');
    CountyFipsCodeCB.Items.add('111  San Juan');
    CountyFipsCodeCB.Items.add('113  San Miguel');
    CountyFipsCodeCB.Items.add('115  Sedgwick');
    CountyFipsCodeCB.Items.add('117  Summit');
    CountyFipsCodeCB.Items.add('119  Teller');
    CountyFipsCodeCB.Items.add('121  Washington');
    CountyFipsCodeCB.Items.add('123  Weld');
    CountyFipsCodeCB.Items.add('125  Yuma');
  end;{: Colorado';}
7:Begin {CONNECTICUT (CT) (09)}
    CountyFipsCodeCB.Items.add('001  Fairfield');
    CountyFipsCodeCB.Items.add('003  Hartford');
    CountyFipsCodeCB.Items.add('005  Litchfield');
    CountyFipsCodeCB.Items.add('007  Middlesex');
    CountyFipsCodeCB.Items.add('009  New Haven');
    CountyFipsCodeCB.Items.add('011  New London');
    CountyFipsCodeCB.Items.add('013  Tolland');
    CountyFipsCodeCB.Items.add('015  Windham');
  end;{: Connecticut';}
8:Begin  {DELAWARE (DE) (10)}
    CountyFipsCodeCB.Items.add('001  Kent');
    CountyFipsCodeCB.Items.add('003  New Castle');
    CountyFipsCodeCB.Items.add('005  Sussex');
  end;{: Delaware';}
9:Begin  {DISTRICT OF COLUMBIA (DC) (11)}
    CountyFipsCodeCB.Items.add('001  District of Columbia');
  end;{: District of Columbia';}
10:Begin  {FLORIDA (FL) (12)}
     CountyFipsCodeCB.Items.add('001  Alachua');
     CountyFipsCodeCB.Items.add('003  Baker');
     CountyFipsCodeCB.Items.add('005  Bay');
     CountyFipsCodeCB.Items.add('007  Bradford ');
     CountyFipsCodeCB.Items.add('009  Brevard');
     CountyFipsCodeCB.Items.add('011  Broward');
     CountyFipsCodeCB.Items.add('013  Calhoun');
     CountyFipsCodeCB.Items.add('015  Charlotte');
     CountyFipsCodeCB.Items.add('017  Citrus');
     CountyFipsCodeCB.Items.add('019  Clay ');
     CountyFipsCodeCB.Items.add('021  Collier');
     CountyFipsCodeCB.Items.add('023  Columbia');
     CountyFipsCodeCB.Items.add('025  Dade');
     CountyFipsCodeCB.Items.add('027  DeSoto*');
     CountyFipsCodeCB.Items.add('029  Dixie');
     CountyFipsCodeCB.Items.add('031  Duval');
     CountyFipsCodeCB.Items.add('033  Escambia');
     CountyFipsCodeCB.Items.add('035  Flagler');
     CountyFipsCodeCB.Items.add('037  Franklin');
     CountyFipsCodeCB.Items.add('039  Gadsden');
     CountyFipsCodeCB.Items.add('041  Gilchrist');
     CountyFipsCodeCB.Items.add('043  Glades');
     CountyFipsCodeCB.Items.add('045  Gulf');
     CountyFipsCodeCB.Items.add('047  Hamilton');
     CountyFipsCodeCB.Items.add('049  Hardee');
     CountyFipsCodeCB.Items.add('051  Hendry');
     CountyFipsCodeCB.Items.add('053  Hernando');
     CountyFipsCodeCB.Items.add('055  Highlands');
     CountyFipsCodeCB.Items.add('057  Hillsborough');
     CountyFipsCodeCB.Items.add('059  Holmes');
     CountyFipsCodeCB.Items.add('061  Indian River');
     CountyFipsCodeCB.Items.add('063  Jackson');
     CountyFipsCodeCB.Items.add('065  Jefferson');
     CountyFipsCodeCB.Items.add('067  Lafayette');
     CountyFipsCodeCB.Items.add('069  Lake');
     CountyFipsCodeCB.Items.add('071  Lee');
     CountyFipsCodeCB.Items.add('073  Leon');
     CountyFipsCodeCB.Items.add('075  Levy');
     CountyFipsCodeCB.Items.add('077  Liberty');
     CountyFipsCodeCB.Items.add('079  Madison');
     CountyFipsCodeCB.Items.add('081  Manatee');
     CountyFipsCodeCB.Items.add('083  Marion');
     CountyFipsCodeCB.Items.add('085  Martin');
     CountyFipsCodeCB.Items.add('087  Monroe');
     CountyFipsCodeCB.Items.add('089  Nassau');
     CountyFipsCodeCB.Items.add('091  Okaloosa');
     CountyFipsCodeCB.Items.add('093  Okeechobee');
     CountyFipsCodeCB.Items.add('095  Orange');
     CountyFipsCodeCB.Items.add('097  Osceola');
     CountyFipsCodeCB.Items.add('099  Palm Beach');
     CountyFipsCodeCB.Items.add('101  Pasco');
     CountyFipsCodeCB.Items.add('103  Pinellas');
     CountyFipsCodeCB.Items.add('105  Polk');
     CountyFipsCodeCB.Items.add('107  Putnam');
     CountyFipsCodeCB.Items.add('109  St. Johns');
     CountyFipsCodeCB.Items.add('111  St. Lucie');
     CountyFipsCodeCB.Items.add('113  Santa Rosa');
     CountyFipsCodeCB.Items.add('115  Sarasota');
     CountyFipsCodeCB.Items.add('117  Seminole');
     CountyFipsCodeCB.Items.add('119  Sumter');
     CountyFipsCodeCB.Items.add('121  Suwannee');
     CountyFipsCodeCB.Items.add('123  Taylor');
     CountyFipsCodeCB.Items.add('125  Union');
     CountyFipsCodeCB.Items.add('127  Volusia');
     CountyFipsCodeCB.Items.add('129  Wakulla');
     CountyFipsCodeCB.Items.add('131  Walton');
     CountyFipsCodeCB.Items.add('133  Washington');
  end;{: Florida';}
11:Begin  {GEORGIA (GA) (13)}
     CountyFipsCodeCB.Items.add('001  Appling');
     CountyFipsCodeCB.Items.add('003  Atkinson');
     CountyFipsCodeCB.Items.add('005  Bacon ');
     CountyFipsCodeCB.Items.add('007  Baker');
     CountyFipsCodeCB.Items.add('009  Baldwin');
     CountyFipsCodeCB.Items.add('011  Banks');
     CountyFipsCodeCB.Items.add('013  Barrow');
     CountyFipsCodeCB.Items.add('015  Bartow');
     CountyFipsCodeCB.Items.add('017  Ben Hill');
     CountyFipsCodeCB.Items.add('019  Berrien');
     CountyFipsCodeCB.Items.add('021  Bibb');
     CountyFipsCodeCB.Items.add('023  Bleckley');
     CountyFipsCodeCB.Items.add('025  Brantley');
     CountyFipsCodeCB.Items.add('027  Brooks');
     CountyFipsCodeCB.Items.add('029  Bryan');
     CountyFipsCodeCB.Items.add('031  Bulloch');
     CountyFipsCodeCB.Items.add('033  Burke');
     CountyFipsCodeCB.Items.add('035  Butts');
     CountyFipsCodeCB.Items.add('037  Calhoun');
     CountyFipsCodeCB.Items.add('039  Camden');
     CountyFipsCodeCB.Items.add('043  Candler');
     CountyFipsCodeCB.Items.add('045  Carroll');
     CountyFipsCodeCB.Items.add('047  Catoosa');
     CountyFipsCodeCB.Items.add('049  Charlton');
     CountyFipsCodeCB.Items.add('051  Chatham');
     CountyFipsCodeCB.Items.add('053  Chattahoochee');
     CountyFipsCodeCB.Items.add('055  Chattooga');
     CountyFipsCodeCB.Items.add('057  Cherokee');
     CountyFipsCodeCB.Items.add('059  Clarke');
     CountyFipsCodeCB.Items.add('061  Clay');
     CountyFipsCodeCB.Items.add('063  Clayton');
     CountyFipsCodeCB.Items.add('065  Clinch');
     CountyFipsCodeCB.Items.add('067  Cobb');
     CountyFipsCodeCB.Items.add('069  Coffee');
     CountyFipsCodeCB.Items.add('071  Colquitt');
     CountyFipsCodeCB.Items.add('073  Columbia ');
     CountyFipsCodeCB.Items.add('075  Cook');
     CountyFipsCodeCB.Items.add('077  Coweta');
     CountyFipsCodeCB.Items.add('079  Crawford');
     CountyFipsCodeCB.Items.add('081  Crisp');
     CountyFipsCodeCB.Items.add('083  Dade');
     CountyFipsCodeCB.Items.add('085  Dawson');
     CountyFipsCodeCB.Items.add('087  Decatur');
     CountyFipsCodeCB.Items.add('089  DeKalb*');
     CountyFipsCodeCB.Items.add('091  Dodge');
     CountyFipsCodeCB.Items.add('093  Dooly');
     CountyFipsCodeCB.Items.add('095  Dougherty');
     CountyFipsCodeCB.Items.add('097  Douglas');
     CountyFipsCodeCB.Items.add('099  Early');
     CountyFipsCodeCB.Items.add('101  Echols');
     CountyFipsCodeCB.Items.add('103  Effingham');
     CountyFipsCodeCB.Items.add('105  Elbert');
     CountyFipsCodeCB.Items.add('107  Emanuel');
     CountyFipsCodeCB.Items.add('109  Evans');
     CountyFipsCodeCB.Items.add('111  Fannin');
     CountyFipsCodeCB.Items.add('113  Fayette');
     CountyFipsCodeCB.Items.add('115  Floyd');
     CountyFipsCodeCB.Items.add('117  Forsyth');
     CountyFipsCodeCB.Items.add('119  Franklin');
     CountyFipsCodeCB.Items.add('121  Fulton');
     CountyFipsCodeCB.Items.add('123  Gilmer');
     CountyFipsCodeCB.Items.add('125  Glascock');
     CountyFipsCodeCB.Items.add('127  Glynn');
     CountyFipsCodeCB.Items.add('129  Gordon');
     CountyFipsCodeCB.Items.add('131  Grady');
     CountyFipsCodeCB.Items.add('133  Greene');
     CountyFipsCodeCB.Items.add('135  Gwinnett');
     CountyFipsCodeCB.Items.add('137  Habersham');
     CountyFipsCodeCB.Items.add('139  Hall');
     CountyFipsCodeCB.Items.add('141  Hancock');
     CountyFipsCodeCB.Items.add('143  Haralson');
     CountyFipsCodeCB.Items.add('145  Harris');
     CountyFipsCodeCB.Items.add('147  Hart');
     CountyFipsCodeCB.Items.add('149  Heard');
     CountyFipsCodeCB.Items.add('151  Henry');
     CountyFipsCodeCB.Items.add('153  Houston');
     CountyFipsCodeCB.Items.add('155  Irwin');
     CountyFipsCodeCB.Items.add('157  Jackson');
     CountyFipsCodeCB.Items.add('159  Jasper');
     CountyFipsCodeCB.Items.add('161  Jeff Davis');
     CountyFipsCodeCB.Items.add('163  Jefferson');
     CountyFipsCodeCB.Items.add('165  Jenkins');
     CountyFipsCodeCB.Items.add('167  Johnson');
     CountyFipsCodeCB.Items.add('169  Jones');
     CountyFipsCodeCB.Items.add('171  Lamar');
     CountyFipsCodeCB.Items.add('173  Lanier');
     CountyFipsCodeCB.Items.add('175  Laurens');
     CountyFipsCodeCB.Items.add('177  Lee');
     CountyFipsCodeCB.Items.add('179  Liberty');
     CountyFipsCodeCB.Items.add('181  Lincoln');
     CountyFipsCodeCB.Items.add('183  Long');
     CountyFipsCodeCB.Items.add('185  Lowndes');
     CountyFipsCodeCB.Items.add('187  Lumpkin');
     CountyFipsCodeCB.Items.add('189  McDuffie');
     CountyFipsCodeCB.Items.add('191  Mclntosh');
     CountyFipsCodeCB.Items.add('193  Macon');
     CountyFipsCodeCB.Items.add('195  Madison');
     CountyFipsCodeCB.Items.add('197  Marion');
     CountyFipsCodeCB.Items.add('199  Meriwether');
     CountyFipsCodeCB.Items.add('201  Miller');
     CountyFipsCodeCB.Items.add('205  Mitchell');
     CountyFipsCodeCB.Items.add('207  Monroe');
     CountyFipsCodeCB.Items.add('209  Montgomery');
     CountyFipsCodeCB.Items.add('211  Morgan');
     CountyFipsCodeCB.Items.add('213  Murray');
     CountyFipsCodeCB.Items.add('215* Muscogee');
     CountyFipsCodeCB.Items.add('217  Newton');
     CountyFipsCodeCB.Items.add('219  Oconee');
     CountyFipsCodeCB.Items.add('221  Oglethorpe');
     CountyFipsCodeCB.Items.add('223  Paulding');
     CountyFipsCodeCB.Items.add('225  Peach');
     CountyFipsCodeCB.Items.add('227  Pickens');
     CountyFipsCodeCB.Items.add('229  Pierce');
     CountyFipsCodeCB.Items.add('231  Pike');
     CountyFipsCodeCB.Items.add('233  Polk');
     CountyFipsCodeCB.Items.add('235  Pulaski');
     CountyFipsCodeCB.Items.add('237  Putnam');
     CountyFipsCodeCB.Items.add('239  Quitman');
     CountyFipsCodeCB.Items.add('241  Rabun');
     CountyFipsCodeCB.Items.add('243  Randolph');
     CountyFipsCodeCB.Items.add('245  Richmond');
     CountyFipsCodeCB.Items.add('247  Rockdale');
     CountyFipsCodeCB.Items.add('249  Schley');
     CountyFipsCodeCB.Items.add('251  Screven');
     CountyFipsCodeCB.Items.add('253  Seminole');
     CountyFipsCodeCB.Items.add('255  Spalding');
     CountyFipsCodeCB.Items.add('257  Stephens');
     CountyFipsCodeCB.Items.add('259  Stewart');
     CountyFipsCodeCB.Items.add('261  Sumter');
     CountyFipsCodeCB.Items.add('263  Talbot');
     CountyFipsCodeCB.Items.add('265  Taliaferro');
     CountyFipsCodeCB.Items.add('267  Tattnall');
     CountyFipsCodeCB.Items.add('269  Taylor');
     CountyFipsCodeCB.Items.add('271  Telfair');
     CountyFipsCodeCB.Items.add('273  Terrell');
     CountyFipsCodeCB.Items.add('275  Thomas');
     CountyFipsCodeCB.Items.add('277  Tift');
     CountyFipsCodeCB.Items.add('279  Toombs');
     CountyFipsCodeCB.Items.add('281  Towns');
     CountyFipsCodeCB.Items.add('283  Treutlen');
     CountyFipsCodeCB.Items.add('285  Troup');
     CountyFipsCodeCB.Items.add('287  Turner');
     CountyFipsCodeCB.Items.add('289  Twiggs');
     CountyFipsCodeCB.Items.add('291  Union');
     CountyFipsCodeCB.Items.add('293  Upson');
     CountyFipsCodeCB.Items.add('295  Walker');
     CountyFipsCodeCB.Items.add('297  Walton');
     CountyFipsCodeCB.Items.add('299  Ware');
     CountyFipsCodeCB.Items.add('301  Warren');
     CountyFipsCodeCB.Items.add('303  Washington');
     CountyFipsCodeCB.Items.add('305  Wayne');
     CountyFipsCodeCB.Items.add('307  Webster');
     CountyFipsCodeCB.Items.add('309  Wheeler');
     CountyFipsCodeCB.Items.add('311  White');
     CountyFipsCodeCB.Items.add('313  Whitfield');
     CountyFipsCodeCB.Items.add('315  Wilcox');
     CountyFipsCodeCB.Items.add('317  Wilkes');
     CountyFipsCodeCB.Items.add('319  Wilkinson');
     CountyFipsCodeCB.Items.add('321  Worth');
  end;{: Georgia';}
12:Begin  {HAWAII (HI) (15)}
     CountyFipsCodeCB.Items.add('001 Hawaii');
     CountyFipsCodeCB.Items.add('003 Honolulu');
     CountyFipsCodeCB.Items.add('005 Kalawao');
     CountyFipsCodeCB.Items.add('007 Kauai');
     CountyFipsCodeCB.Items.add('009 Maui');
{Kalawao does not have its own local government; it is
administered by the State of Hawaii.  It may be included
with Maui for statistical purposes.}
  end;{: Hawaii';}
13:Begin {IDAHO (ID) (16)}
     CountyFipsCodeCB.Items.add('001  Ada');
     CountyFipsCodeCB.Items.add('003  Adams');
     CountyFipsCodeCB.Items.add('005  Bannock');
     CountyFipsCodeCB.Items.add('007  Bear Lake');
     CountyFipsCodeCB.Items.add('009  Benewah');
     CountyFipsCodeCB.Items.add('011  Bingham');
     CountyFipsCodeCB.Items.add('013  Bane');
     CountyFipsCodeCB.Items.add('015  Boise');
     CountyFipsCodeCB.Items.add('017  Bonner');
     CountyFipsCodeCB.Items.add('019  Bonneville');
     CountyFipsCodeCB.Items.add('021  Boundary');
     CountyFipsCodeCB.Items.add('023  Butte');
     CountyFipsCodeCB.Items.add('025  Camas ');
     CountyFipsCodeCB.Items.add('027  Canyon');
     CountyFipsCodeCB.Items.add('029  Caribou');
     CountyFipsCodeCB.Items.add('031  Cassia');
     CountyFipsCodeCB.Items.add('033  Clark');
     CountyFipsCodeCB.Items.add('035  Clearwater');
     CountyFipsCodeCB.Items.add('037  Custer');
     CountyFipsCodeCB.Items.add('039  Elmore');
     CountyFipsCodeCB.Items.add('041  Franklin');
     CountyFipsCodeCB.Items.add('043  Fremont');
     CountyFipsCodeCB.Items.add('045  Gem');
     CountyFipsCodeCB.Items.add('047  Gooding');
     CountyFipsCodeCB.Items.add('049  Idaho');
     CountyFipsCodeCB.Items.add('051  Jefferson');
     CountyFipsCodeCB.Items.add('053  Jerome');
     CountyFipsCodeCB.Items.add('055  Kootenai');
     CountyFipsCodeCB.Items.add('057  Latah');
     CountyFipsCodeCB.Items.add('059  Lemhi');
     CountyFipsCodeCB.Items.add('061  Lewis');
     CountyFipsCodeCB.Items.add('063  Lincoln');
     CountyFipsCodeCB.Items.add('065  Madison');
     CountyFipsCodeCB.Items.add('067  Minidoka');
     CountyFipsCodeCB.Items.add('069  Nez Perce');
     CountyFipsCodeCB.Items.add('071  Oneida');
     CountyFipsCodeCB.Items.add('073  Owyhee');
     CountyFipsCodeCB.Items.add('075  Payette');
     CountyFipsCodeCB.Items.add('077  Power');
     CountyFipsCodeCB.Items.add('079  Shoshone');
     CountyFipsCodeCB.Items.add('081  Teton');
     CountyFipsCodeCB.Items.add('083  Twin Falls');
     CountyFipsCodeCB.Items.add('085  Valley');
     CountyFipsCodeCB.Items.add('087  Washington');
  end;{: Idaho';}
14:Begin {ILLINOIS (IL) (17)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Alexander');
     CountyFipsCodeCB.Items.add('005  Bond');
     CountyFipsCodeCB.Items.add('007  Boone');
     CountyFipsCodeCB.Items.add('009  Brown');
     CountyFipsCodeCB.Items.add('011  Bureau');
     CountyFipsCodeCB.Items.add('013  Calhoun');
     CountyFipsCodeCB.Items.add('015  Carroll');
     CountyFipsCodeCB.Items.add('017  Cass');
     CountyFipsCodeCB.Items.add('019  Champaign');
     CountyFipsCodeCB.Items.add('021  Christian');
     CountyFipsCodeCB.Items.add('023  Clark');
     CountyFipsCodeCB.Items.add('025  Clay ');
     CountyFipsCodeCB.Items.add('027  Clinton');
     CountyFipsCodeCB.Items.add('029  Coles');
     CountyFipsCodeCB.Items.add('031  Cook ');
     CountyFipsCodeCB.Items.add('033  Crawford');
     CountyFipsCodeCB.Items.add('035  Cumberland');
     CountyFipsCodeCB.Items.add('037  DeKalb*');
     CountyFipsCodeCB.Items.add('039  De Witt');
     CountyFipsCodeCB.Items.add('041  Douglas');
     CountyFipsCodeCB.Items.add('043  DuPage*');
     CountyFipsCodeCB.Items.add('045  Edgar');
     CountyFipsCodeCB.Items.add('047  Edwards');
     CountyFipsCodeCB.Items.add('049  Effingham');
     CountyFipsCodeCB.Items.add('051  Fayette');
     CountyFipsCodeCB.Items.add('053  Ford');
     CountyFipsCodeCB.Items.add('055  Franklin');
     CountyFipsCodeCB.Items.add('057  Fulton');
     CountyFipsCodeCB.Items.add('059  Gallatin');
     CountyFipsCodeCB.Items.add('061  Greene');
     CountyFipsCodeCB.Items.add('063  Grundy');
     CountyFipsCodeCB.Items.add('065  Hamilton');
     CountyFipsCodeCB.Items.add('067  Hancock');
     CountyFipsCodeCB.Items.add('069  Hardin');
     CountyFipsCodeCB.Items.add('071  Henderson');
     CountyFipsCodeCB.Items.add('073  Henry');
     CountyFipsCodeCB.Items.add('075  Iroquois');
     CountyFipsCodeCB.Items.add('077  Jackson');
     CountyFipsCodeCB.Items.add('079  Jasper');
     CountyFipsCodeCB.Items.add('081  Jefferson');
     CountyFipsCodeCB.Items.add('083  Jersey');
     CountyFipsCodeCB.Items.add('085  Jo Daviess');
     CountyFipsCodeCB.Items.add('087  Johnson');
     CountyFipsCodeCB.Items.add('089  Kane');
     CountyFipsCodeCB.Items.add('091  Kankakee');
     CountyFipsCodeCB.Items.add('093  Kendall');
     CountyFipsCodeCB.Items.add('095  Knox');
     CountyFipsCodeCB.Items.add('097  Lake');
     CountyFipsCodeCB.Items.add('099  La Salle');
     CountyFipsCodeCB.Items.add('101  Lawrence');
     CountyFipsCodeCB.Items.add('103  Lee');
     CountyFipsCodeCB.Items.add('105  Livingston');
     CountyFipsCodeCB.Items.add('107  Logan');
     CountyFipsCodeCB.Items.add('109  McDonough');
     CountyFipsCodeCB.Items.add('111  McHenry');
     CountyFipsCodeCB.Items.add('113  McLean');
     CountyFipsCodeCB.Items.add('115  Macon');
     CountyFipsCodeCB.Items.add('117  Macoupin');
     CountyFipsCodeCB.Items.add('119  Madison');
     CountyFipsCodeCB.Items.add('121  Marion');
     CountyFipsCodeCB.Items.add('123  Marshall');
     CountyFipsCodeCB.Items.add('125  Mason');
     CountyFipsCodeCB.Items.add('127  Massac');
     CountyFipsCodeCB.Items.add('129  Menard');
     CountyFipsCodeCB.Items.add('131  Mercer');
     CountyFipsCodeCB.Items.add('133  Monroe');
     CountyFipsCodeCB.Items.add('135  Montgomery');
     CountyFipsCodeCB.Items.add('137  Morgan');
     CountyFipsCodeCB.Items.add('139  Moultrie');
     CountyFipsCodeCB.Items.add('141  Ogle');
     CountyFipsCodeCB.Items.add('143  Peoria');
     CountyFipsCodeCB.Items.add('145  Perry');
     CountyFipsCodeCB.Items.add('147  Piatt');
     CountyFipsCodeCB.Items.add('149  Pike');
     CountyFipsCodeCB.Items.add('151  Pope');
     CountyFipsCodeCB.Items.add('153  Pulaski');
     CountyFipsCodeCB.Items.add('155  Putnam');
     CountyFipsCodeCB.Items.add('157  Randolph');
     CountyFipsCodeCB.Items.add('159  Richland');
     CountyFipsCodeCB.Items.add('161  Rock Island');
     CountyFipsCodeCB.Items.add('163  St. Clair');
     CountyFipsCodeCB.Items.add('165  Saline');
     CountyFipsCodeCB.Items.add('167  Sangamon');
     CountyFipsCodeCB.Items.add('169  Schuyler');
     CountyFipsCodeCB.Items.add('171  Scott');
     CountyFipsCodeCB.Items.add('173  Shelby');
     CountyFipsCodeCB.Items.add('175  Stark');
     CountyFipsCodeCB.Items.add('177  Stephenson');
     CountyFipsCodeCB.Items.add('179  Tazewell');
     CountyFipsCodeCB.Items.add('181  Union');
     CountyFipsCodeCB.Items.add('183  Vermilion');
     CountyFipsCodeCB.Items.add('185  Wabash');
     CountyFipsCodeCB.Items.add('187  Warren');
     CountyFipsCodeCB.Items.add('189  Washington');
     CountyFipsCodeCB.Items.add('191  Wayne');
     CountyFipsCodeCB.Items.add('193  White');
     CountyFipsCodeCB.Items.add('195  Whiteside');
     CountyFipsCodeCB.Items.add('197  Will');
     CountyFipsCodeCB.Items.add('199  Williamson');
     CountyFipsCodeCB.Items.add('201  Winnebago');
     CountyFipsCodeCB.Items.add('203  Woodford');
  end;{: Illinois';}
15:Begin  {INDIANA (IN) (18)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Allen');
     CountyFipsCodeCB.Items.add('005  Bartholomew');
     CountyFipsCodeCB.Items.add('007  Benton');
     CountyFipsCodeCB.Items.add('009  Blackford');
     CountyFipsCodeCB.Items.add('011  Boone');
     CountyFipsCodeCB.Items.add('013  Brown');
     CountyFipsCodeCB.Items.add('015  Carroll');
     CountyFipsCodeCB.Items.add('017  Cass');
     CountyFipsCodeCB.Items.add('019  Clark');
     CountyFipsCodeCB.Items.add('021  Clay');
     CountyFipsCodeCB.Items.add('023  Clinton');
     CountyFipsCodeCB.Items.add('025  Crawford');
     CountyFipsCodeCB.Items.add('027  Daviess');
     CountyFipsCodeCB.Items.add('029  Dearborn');
     CountyFipsCodeCB.Items.add('031  Decatur');
     CountyFipsCodeCB.Items.add('033  De Kalb');
     CountyFipsCodeCB.Items.add('035  Delaware');
     CountyFipsCodeCB.Items.add('037  Dubois');
     CountyFipsCodeCB.Items.add('039  Elkhart');
     CountyFipsCodeCB.Items.add('041  Fayette');
     CountyFipsCodeCB.Items.add('043  Floyd');
     CountyFipsCodeCB.Items.add('045  Fountain');
     CountyFipsCodeCB.Items.add('047  Franklin');
     CountyFipsCodeCB.Items.add('049  Fulton');
     CountyFipsCodeCB.Items.add('051  Gibson');
     CountyFipsCodeCB.Items.add('053  Grant');
     CountyFipsCodeCB.Items.add('055  Greene');
     CountyFipsCodeCB.Items.add('057  Hamilton');
     CountyFipsCodeCB.Items.add('059  Hancock');
     CountyFipsCodeCB.Items.add('061  Harrison');
     CountyFipsCodeCB.Items.add('063  Hendricks');
     CountyFipsCodeCB.Items.add('065  Henry');
     CountyFipsCodeCB.Items.add('067  Howard');
     CountyFipsCodeCB.Items.add('069  Huntington');
     CountyFipsCodeCB.Items.add('071  Jackson');
     CountyFipsCodeCB.Items.add('073  Jasper');
     CountyFipsCodeCB.Items.add('075  Jay');
     CountyFipsCodeCB.Items.add('077  Jefferson');
     CountyFipsCodeCB.Items.add('079  Jennings');
     CountyFipsCodeCB.Items.add('081  Johnson');
     CountyFipsCodeCB.Items.add('083  Knox');
     CountyFipsCodeCB.Items.add('085  Kosciusko');
     CountyFipsCodeCB.Items.add('087  Lagrange');
     CountyFipsCodeCB.Items.add('089  Lake');
     CountyFipsCodeCB.Items.add('091  La Porte');
     CountyFipsCodeCB.Items.add('093  Lawrence');
     CountyFipsCodeCB.Items.add('095  Madison');
     CountyFipsCodeCB.Items.add('097  Marion');
     CountyFipsCodeCB.Items.add('099  Marshall');
     CountyFipsCodeCB.Items.add('101  Martin');
     CountyFipsCodeCB.Items.add('103  Miami');
     CountyFipsCodeCB.Items.add('105  Monroe');
     CountyFipsCodeCB.Items.add('107  Montgomery');
     CountyFipsCodeCB.Items.add('109  Morgan');
     CountyFipsCodeCB.Items.add('111  Newton');
     CountyFipsCodeCB.Items.add('113  Noble');
     CountyFipsCodeCB.Items.add('115  Ohio');
     CountyFipsCodeCB.Items.add('117  Orange');
     CountyFipsCodeCB.Items.add('119  Owen');
     CountyFipsCodeCB.Items.add('121  Parke');
     CountyFipsCodeCB.Items.add('123  Perry');
     CountyFipsCodeCB.Items.add('125  Pike');
     CountyFipsCodeCB.Items.add('127  Porter');
     CountyFipsCodeCB.Items.add('129  Posey');
     CountyFipsCodeCB.Items.add('131  Pulaski');
     CountyFipsCodeCB.Items.add('133  Putnam');
     CountyFipsCodeCB.Items.add('135  Randolph');
     CountyFipsCodeCB.Items.add('137  Ripley');
     CountyFipsCodeCB.Items.add('139  Rush');
     CountyFipsCodeCB.Items.add('141  St. Joseph');
     CountyFipsCodeCB.Items.add('143  Scott');
     CountyFipsCodeCB.Items.add('145  Shelby');
     CountyFipsCodeCB.Items.add('147  Spencer');
     CountyFipsCodeCB.Items.add('149  Starke');
     CountyFipsCodeCB.Items.add('151  Steuben');
     CountyFipsCodeCB.Items.add('153  Sullivan');
     CountyFipsCodeCB.Items.add('155  Switzerland');
     CountyFipsCodeCB.Items.add('157  Tippecanoe');
     CountyFipsCodeCB.Items.add('159  Tipton');
     CountyFipsCodeCB.Items.add('161  Union');
     CountyFipsCodeCB.Items.add('163  Vanderburgh');
     CountyFipsCodeCB.Items.add('165  Vermilion');
     CountyFipsCodeCB.Items.add('167  Vigo');
     CountyFipsCodeCB.Items.add('169  Wabash');
     CountyFipsCodeCB.Items.add('171  Warren');
     CountyFipsCodeCB.Items.add('173  Warrick');
     CountyFipsCodeCB.Items.add('175  Washington');
     CountyFipsCodeCB.Items.add('177  Wayne');
     CountyFipsCodeCB.Items.add('179  Wells');
     CountyFipsCodeCB.Items.add('181  White');
     CountyFipsCodeCB.Items.add('183  Whitley');
  end;{: Indiana';}
16:Begin  {IOWA (IA) (19)}
     CountyFipsCodeCB.Items.add('001  Adair');
     CountyFipsCodeCB.Items.add('003  Adams');
     CountyFipsCodeCB.Items.add('005  Allamakee');
     CountyFipsCodeCB.Items.add('007  Appanoose');
     CountyFipsCodeCB.Items.add('009  Audubon');
     CountyFipsCodeCB.Items.add('011  Benton');
     CountyFipsCodeCB.Items.add('013  Black Hawk');
     CountyFipsCodeCB.Items.add('015  Boone ');
     CountyFipsCodeCB.Items.add('017  Bremer');
     CountyFipsCodeCB.Items.add('019  Buchanan');
     CountyFipsCodeCB.Items.add('021  Buena Vista');
     CountyFipsCodeCB.Items.add('023  Butler ');
     CountyFipsCodeCB.Items.add('025  Calhoun ');
     CountyFipsCodeCB.Items.add('027  Carroll');
     CountyFipsCodeCB.Items.add('029  Cass');
     CountyFipsCodeCB.Items.add('031  Cedar');
     CountyFipsCodeCB.Items.add('033  Cerro Gordo');
     CountyFipsCodeCB.Items.add('035  Cherokee');
     CountyFipsCodeCB.Items.add('037  Chickasaw');
     CountyFipsCodeCB.Items.add('039  Clarke');
     CountyFipsCodeCB.Items.add('041  Clay');
     CountyFipsCodeCB.Items.add('043  Clayton');
     CountyFipsCodeCB.Items.add('045  Clinton');
     CountyFipsCodeCB.Items.add('047  Crawford');
     CountyFipsCodeCB.Items.add('049  Dallas');
     CountyFipsCodeCB.Items.add('051  Davis');
     CountyFipsCodeCB.Items.add('053  Decatur');
     CountyFipsCodeCB.Items.add('055  Delaware');
     CountyFipsCodeCB.Items.add('057  Des Moines');
     CountyFipsCodeCB.Items.add('059  Dickinson');
     CountyFipsCodeCB.Items.add('061  Dubuque');
     CountyFipsCodeCB.Items.add('063  Emmet');
     CountyFipsCodeCB.Items.add('065  Fayette');
     CountyFipsCodeCB.Items.add('067  Floyd');
     CountyFipsCodeCB.Items.add('069  Franklin');
     CountyFipsCodeCB.Items.add('071  Fremont');
     CountyFipsCodeCB.Items.add('073  Greene');
     CountyFipsCodeCB.Items.add('075  Grundy');
     CountyFipsCodeCB.Items.add('077  Guthrie');
     CountyFipsCodeCB.Items.add('079  Hamilton');
     CountyFipsCodeCB.Items.add('081  Hancock');
     CountyFipsCodeCB.Items.add('083  Hardin');
     CountyFipsCodeCB.Items.add('085  Harrison');
     CountyFipsCodeCB.Items.add('087  Henry');
     CountyFipsCodeCB.Items.add('089  Howard');
     CountyFipsCodeCB.Items.add('091  Humboldt');
     CountyFipsCodeCB.Items.add('093  Ida');
     CountyFipsCodeCB.Items.add('095  Iowa');
     CountyFipsCodeCB.Items.add('097  Jackson');
     CountyFipsCodeCB.Items.add('099  Jasper');
     CountyFipsCodeCB.Items.add('101  Jefferson');
     CountyFipsCodeCB.Items.add('103  Johnson');
     CountyFipsCodeCB.Items.add('105  Jones');
     CountyFipsCodeCB.Items.add('107  Keokuk');
     CountyFipsCodeCB.Items.add('109  Kossuth');
     CountyFipsCodeCB.Items.add('111  Lee');
     CountyFipsCodeCB.Items.add('113  Linn');
     CountyFipsCodeCB.Items.add('115  Louisa');
     CountyFipsCodeCB.Items.add('117  Lucas');
     CountyFipsCodeCB.Items.add('119  Lyon');
     CountyFipsCodeCB.Items.add('121  Madison');
     CountyFipsCodeCB.Items.add('123  Mahaska');
     CountyFipsCodeCB.Items.add('125  Marion');
     CountyFipsCodeCB.Items.add('127  Marshall');
     CountyFipsCodeCB.Items.add('129  Mills');
     CountyFipsCodeCB.Items.add('131  Mitchell');
     CountyFipsCodeCB.Items.add('133  Monona');
     CountyFipsCodeCB.Items.add('135  Monroe');
     CountyFipsCodeCB.Items.add('137  Montgomery');
     CountyFipsCodeCB.Items.add('139  Muscatine');
     CountyFipsCodeCB.Items.add('141  O`Brien');
     CountyFipsCodeCB.Items.add('143  Osceola');
     CountyFipsCodeCB.Items.add('145  Page');
     CountyFipsCodeCB.Items.add('147  Palo Alto');
     CountyFipsCodeCB.Items.add('149  Plymouth');
     CountyFipsCodeCB.Items.add('151  Pocahontas');
     CountyFipsCodeCB.Items.add('153  Polk');
     CountyFipsCodeCB.Items.add('155  Pottawattamie');
     CountyFipsCodeCB.Items.add('157  Poweshiek');
     CountyFipsCodeCB.Items.add('159  Ringgold');
     CountyFipsCodeCB.Items.add('161  Sac');
     CountyFipsCodeCB.Items.add('163  Scott');
     CountyFipsCodeCB.Items.add('165  Shelby');
     CountyFipsCodeCB.Items.add('167  Sioux');
     CountyFipsCodeCB.Items.add('169  Story');
     CountyFipsCodeCB.Items.add('171  Tama');
     CountyFipsCodeCB.Items.add('173  Taylor');
     CountyFipsCodeCB.Items.add('175  Union');
     CountyFipsCodeCB.Items.add('177  Van Buren');
     CountyFipsCodeCB.Items.add('179  Wapello');
     CountyFipsCodeCB.Items.add('181  Warren');
     CountyFipsCodeCB.Items.add('183  Washington');
     CountyFipsCodeCB.Items.add('185  Wayne');
     CountyFipsCodeCB.Items.add('187  Webster');
     CountyFipsCodeCB.Items.add('189  Winnebago');
     CountyFipsCodeCB.Items.add('191  Winneshiek');
     CountyFipsCodeCB.Items.add('193  Woodbury');
     CountyFipsCodeCB.Items.add('195  Worth');
     CountyFipsCodeCB.Items.add('197  Wright');
  end;{: Iowa';}
17:Begin  {KANSAS (KS) (20)}
     CountyFipsCodeCB.Items.add('001  Allen ');
     CountyFipsCodeCB.Items.add('003  Anderson ');
     CountyFipsCodeCB.Items.add('005  Atchison ');
     CountyFipsCodeCB.Items.add('007  Barber');
     CountyFipsCodeCB.Items.add('009  Barton ');
     CountyFipsCodeCB.Items.add('011  Bourbon');
     CountyFipsCodeCB.Items.add('013  Brown');
     CountyFipsCodeCB.Items.add('015  Butler');
     CountyFipsCodeCB.Items.add('017  Chase');
     CountyFipsCodeCB.Items.add('019  Chautauqua');
     CountyFipsCodeCB.Items.add('021  Cherokee');
     CountyFipsCodeCB.Items.add('023  Cheyenne');
     CountyFipsCodeCB.Items.add('025  Clark');
     CountyFipsCodeCB.Items.add('027  Clay');
     CountyFipsCodeCB.Items.add('029  Cloud');
     CountyFipsCodeCB.Items.add('031  Coffey');
     CountyFipsCodeCB.Items.add('033  Comanche');
     CountyFipsCodeCB.Items.add('035  Cowley');
     CountyFipsCodeCB.Items.add('037  Crawford');
     CountyFipsCodeCB.Items.add('039  Decatur');
     CountyFipsCodeCB.Items.add('041  Dickinson');
     CountyFipsCodeCB.Items.add('043  Doniphan');
     CountyFipsCodeCB.Items.add('045  Douglas');
     CountyFipsCodeCB.Items.add('047  Edwards');
     CountyFipsCodeCB.Items.add('049  Elk');
     CountyFipsCodeCB.Items.add('051  Ellis');
     CountyFipsCodeCB.Items.add('053  Ellsworth');
     CountyFipsCodeCB.Items.add('055  Finney');
     CountyFipsCodeCB.Items.add('057  Ford');
     CountyFipsCodeCB.Items.add('059  Franklin');
     CountyFipsCodeCB.Items.add('061  Geary');
     CountyFipsCodeCB.Items.add('063  Gove');
     CountyFipsCodeCB.Items.add('065  Graham');
     CountyFipsCodeCB.Items.add('067  Grant');
     CountyFipsCodeCB.Items.add('069  Gray');
     CountyFipsCodeCB.Items.add('071  Greeley');
     CountyFipsCodeCB.Items.add('073  Greenwood');
     CountyFipsCodeCB.Items.add('075  Hamilton');
     CountyFipsCodeCB.Items.add('077  Harper');
     CountyFipsCodeCB.Items.add('079  Harvey');
     CountyFipsCodeCB.Items.add('081  Haskell');
     CountyFipsCodeCB.Items.add('083  Hodgeman');
     CountyFipsCodeCB.Items.add('085  Jackson');
     CountyFipsCodeCB.Items.add('087  Jefferson');
     CountyFipsCodeCB.Items.add('089  Jewell');
     CountyFipsCodeCB.Items.add('091  Johnson');
     CountyFipsCodeCB.Items.add('093  Kearny');
     CountyFipsCodeCB.Items.add('095  Kingman');
     CountyFipsCodeCB.Items.add('097  Kiowa');
     CountyFipsCodeCB.Items.add('099  Labette');
     CountyFipsCodeCB.Items.add('101  Lane');
     CountyFipsCodeCB.Items.add('103  Leavenworth');
     CountyFipsCodeCB.Items.add('105  Lincoln');
     CountyFipsCodeCB.Items.add('107  Linn');
     CountyFipsCodeCB.Items.add('109  Logan');
     CountyFipsCodeCB.Items.add('111  Lyon');
     CountyFipsCodeCB.Items.add('113  McPherson');
     CountyFipsCodeCB.Items.add('115  Marion');
     CountyFipsCodeCB.Items.add('117  Marshall');
     CountyFipsCodeCB.Items.add('119  Meade');
     CountyFipsCodeCB.Items.add('121  Miami');
     CountyFipsCodeCB.Items.add('123  Mitchell');
     CountyFipsCodeCB.Items.add('125  Montgomery');
     CountyFipsCodeCB.Items.add('127  Morris');
     CountyFipsCodeCB.Items.add('129  Morton');
     CountyFipsCodeCB.Items.add('131  Nemaha');
     CountyFipsCodeCB.Items.add('133  Neosho');
     CountyFipsCodeCB.Items.add('135  Ness');
     CountyFipsCodeCB.Items.add('137  Norton');
     CountyFipsCodeCB.Items.add('139  Osage');
     CountyFipsCodeCB.Items.add('141  Osborne');
     CountyFipsCodeCB.Items.add('143  Ottawa');
     CountyFipsCodeCB.Items.add('145  Pawnee');
     CountyFipsCodeCB.Items.add('147  Phillips');
     CountyFipsCodeCB.Items.add('149  Pottawatomie');
     CountyFipsCodeCB.Items.add('151  Pratt');
     CountyFipsCodeCB.Items.add('153  Rawlins');
     CountyFipsCodeCB.Items.add('155  Reno');
     CountyFipsCodeCB.Items.add('157  Republic');
     CountyFipsCodeCB.Items.add('159  Rice');
     CountyFipsCodeCB.Items.add('161  Riley');
     CountyFipsCodeCB.Items.add('163  Rooks');
     CountyFipsCodeCB.Items.add('165  Rush');
     CountyFipsCodeCB.Items.add('167  Russell');
     CountyFipsCodeCB.Items.add('169  Saline');
     CountyFipsCodeCB.Items.add('171  Scott');
     CountyFipsCodeCB.Items.add('173  Sedgwick');
     CountyFipsCodeCB.Items.add('175  Seward');
     CountyFipsCodeCB.Items.add('177  Shawnee');
     CountyFipsCodeCB.Items.add('179  Sheridan');
     CountyFipsCodeCB.Items.add('181  Sherman');
     CountyFipsCodeCB.Items.add('183  Smith');
     CountyFipsCodeCB.Items.add('185  Stafford');
     CountyFipsCodeCB.Items.add('187  Stanton');
     CountyFipsCodeCB.Items.add('189  Stevens');
     CountyFipsCodeCB.Items.add('191  Sumner');
     CountyFipsCodeCB.Items.add('193  Thomas');
     CountyFipsCodeCB.Items.add('195  Trego');
     CountyFipsCodeCB.Items.add('197  Wabaunsee');
     CountyFipsCodeCB.Items.add('199  Wallace');
     CountyFipsCodeCB.Items.add('201  Washington');
     CountyFipsCodeCB.Items.add('203  Wichita');
     CountyFipsCodeCB.Items.add('205  Wilson');
     CountyFipsCodeCB.Items.add('207  Woodson');
     CountyFipsCodeCB.Items.add('209  Wyandotte');
  end;{: Kansas';}
18:Begin  {KENTUCKY (KY) (21)}
     CountyFipsCodeCB.Items.add('001  Adair');
     CountyFipsCodeCB.Items.add('003  Allen');
     CountyFipsCodeCB.Items.add('005  Anderson');
     CountyFipsCodeCB.Items.add('007  Ballard');
     CountyFipsCodeCB.Items.add('009  Barren');
     CountyFipsCodeCB.Items.add('011  Bath');
     CountyFipsCodeCB.Items.add('013  Bell');
     CountyFipsCodeCB.Items.add('015  Boone');
     CountyFipsCodeCB.Items.add('017  Bourbon');
     CountyFipsCodeCB.Items.add('019  Boyd ');
     CountyFipsCodeCB.Items.add('021  Boyle');
     CountyFipsCodeCB.Items.add('023  Bracken');
     CountyFipsCodeCB.Items.add('025  Breathitt');
     CountyFipsCodeCB.Items.add('027  Breckinridge');
     CountyFipsCodeCB.Items.add('029  Bullitt');
     CountyFipsCodeCB.Items.add('031  Butler');
     CountyFipsCodeCB.Items.add('033  Caldwell');
     CountyFipsCodeCB.Items.add('035  Calloway');
     CountyFipsCodeCB.Items.add('037  Campoell');
     CountyFipsCodeCB.Items.add('039  Carlisle');
     CountyFipsCodeCB.Items.add('041  Carroll');
     CountyFipsCodeCB.Items.add('043  Carter');
     CountyFipsCodeCB.Items.add('045  Casey');
     CountyFipsCodeCB.Items.add('047  Christian');
     CountyFipsCodeCB.Items.add('049  Clark ');
     CountyFipsCodeCB.Items.add('051  Clay');
     CountyFipsCodeCB.Items.add('053  Clinton');
     CountyFipsCodeCB.Items.add('055  Crittenden');
     CountyFipsCodeCB.Items.add('057  Cumberland');
     CountyFipsCodeCB.Items.add('059  Daviess');
     CountyFipsCodeCB.Items.add('061  Edmonson');
     CountyFipsCodeCB.Items.add('063  Elliott');
     CountyFipsCodeCB.Items.add('065  Estill');
     CountyFipsCodeCB.Items.add('067  Fayette');
     CountyFipsCodeCB.Items.add('069  Fleming');
     CountyFipsCodeCB.Items.add('071  Floyd');
     CountyFipsCodeCB.Items.add('073  Franklin');
     CountyFipsCodeCB.Items.add('075  Fulton');
     CountyFipsCodeCB.Items.add('077  Gallatin');
     CountyFipsCodeCB.Items.add('079  Garrard');
     CountyFipsCodeCB.Items.add('081  Grant');
     CountyFipsCodeCB.Items.add('083  Graves');
     CountyFipsCodeCB.Items.add('085  Grayson');
     CountyFipsCodeCB.Items.add('087  Green');
     CountyFipsCodeCB.Items.add('089  Greenup');
     CountyFipsCodeCB.Items.add('091  Hancock');
     CountyFipsCodeCB.Items.add('093  Hardin');
     CountyFipsCodeCB.Items.add('095  Harlan');
     CountyFipsCodeCB.Items.add('097  Harrison');
     CountyFipsCodeCB.Items.add('099  Hart');
     CountyFipsCodeCB.Items.add('101  Henderson');
     CountyFipsCodeCB.Items.add('103  Henry');
     CountyFipsCodeCB.Items.add('105  Hickman');
     CountyFipsCodeCB.Items.add('107  Hopkins');
     CountyFipsCodeCB.Items.add('109  Jackson');
     CountyFipsCodeCB.Items.add('111  Jefferson');
     CountyFipsCodeCB.Items.add('113  Jessamine');
     CountyFipsCodeCB.Items.add('115  Johnson');
     CountyFipsCodeCB.Items.add('117  Kenton');
     CountyFipsCodeCB.Items.add('119  Knott');
     CountyFipsCodeCB.Items.add('121  Knox');
     CountyFipsCodeCB.Items.add('123  Larue');
     CountyFipsCodeCB.Items.add('125  Laurel');
     CountyFipsCodeCB.Items.add('127  Lawrence');
     CountyFipsCodeCB.Items.add('129  Lee');
     CountyFipsCodeCB.Items.add('131  Leslie');
     CountyFipsCodeCB.Items.add('133  Letcher');
     CountyFipsCodeCB.Items.add('135  Lewis');
     CountyFipsCodeCB.Items.add('137  Lincoln');
     CountyFipsCodeCB.Items.add('139  Livingston');
     CountyFipsCodeCB.Items.add('141  Logan');
     CountyFipsCodeCB.Items.add('143  Lyon');
     CountyFipsCodeCB.Items.add('145  McCracken');
     CountyFipsCodeCB.Items.add('147  McCreary');
     CountyFipsCodeCB.Items.add('149  McLean');
     CountyFipsCodeCB.Items.add('151  Madison');
     CountyFipsCodeCB.Items.add('153  Magoffin');
     CountyFipsCodeCB.Items.add('155  Marion');
     CountyFipsCodeCB.Items.add('157  Marshall');
     CountyFipsCodeCB.Items.add('159  Martin');
     CountyFipsCodeCB.Items.add('161  Mason');
     CountyFipsCodeCB.Items.add('163  Meade');
     CountyFipsCodeCB.Items.add('165  Menifee');
     CountyFipsCodeCB.Items.add('167  Mercer');
     CountyFipsCodeCB.Items.add('169 Metcalfe');
     CountyFipsCodeCB.Items.add('171  Monroe');
     CountyFipsCodeCB.Items.add('173  Montgomery');
     CountyFipsCodeCB.Items.add('175  Morgan');
     CountyFipsCodeCB.Items.add('177  Muhlenberg');
     CountyFipsCodeCB.Items.add('179  Nelson');
     CountyFipsCodeCB.Items.add('181  Nicholas');
     CountyFipsCodeCB.Items.add('183  Ohio');
     CountyFipsCodeCB.Items.add('185  Oldham');
     CountyFipsCodeCB.Items.add('187  Owen');
     CountyFipsCodeCB.Items.add('189  Owsley');
     CountyFipsCodeCB.Items.add('191  Pendleton');
     CountyFipsCodeCB.Items.add('193  Perry');
     CountyFipsCodeCB.Items.add('195  Pike');
     CountyFipsCodeCB.Items.add('197  Powell');
     CountyFipsCodeCB.Items.add('199  Pulaski');
     CountyFipsCodeCB.Items.add('201  Robertson');
     CountyFipsCodeCB.Items.add('203  Rockcastle');
     CountyFipsCodeCB.Items.add('205  Rowan');
     CountyFipsCodeCB.Items.add('207  Russell');
     CountyFipsCodeCB.Items.add('209  Scott');
     CountyFipsCodeCB.Items.add('211  Shelby');
     CountyFipsCodeCB.Items.add('213  Simpson');
     CountyFipsCodeCB.Items.add('215  Spencer');
     CountyFipsCodeCB.Items.add('217  Taylor');
     CountyFipsCodeCB.Items.add('219  Todd');
     CountyFipsCodeCB.Items.add('221  Trigg');
     CountyFipsCodeCB.Items.add('223  Trimble');
     CountyFipsCodeCB.Items.add('225  Union');
     CountyFipsCodeCB.Items.add('227  Warren');
     CountyFipsCodeCB.Items.add('229  Washington');
     CountyFipsCodeCB.Items.add('231  Wayne');
     CountyFipsCodeCB.Items.add('233  Webster');
     CountyFipsCodeCB.Items.add('235  Whitley');
     CountyFipsCodeCB.Items.add('237  Wolfe');
     CountyFipsCodeCB.Items.add('239  Woodford');
  end;{: Kentucky';}
19:Begin  {LOUISIANA (LA) (22)}
{(Parish Names are used instead of County Names)}
     CountyFipsCodeCB.Items.add('001  Acadia');
     CountyFipsCodeCB.Items.add('003  Allen');
     CountyFipsCodeCB.Items.add('005  Ascension');
     CountyFipsCodeCB.Items.add('007  Assumption');
     CountyFipsCodeCB.Items.add('009  Avoyelles');
     CountyFipsCodeCB.Items.add('011  Beauregard');
     CountyFipsCodeCB.Items.add('013  Bienville');
     CountyFipsCodeCB.Items.add('015  Bossier ');
     CountyFipsCodeCB.Items.add('017  Caddo');
     CountyFipsCodeCB.Items.add('019  Calcasieu');
     CountyFipsCodeCB.Items.add('021  Caldwell');
     CountyFipsCodeCB.Items.add('023  Cameron');
     CountyFipsCodeCB.Items.add('025  Catahoula');
     CountyFipsCodeCB.Items.add('025  Catahoula');
     CountyFipsCodeCB.Items.add('029  Concordia');
     CountyFipsCodeCB.Items.add('031  De Soto');
     CountyFipsCodeCB.Items.add('033  E. Baton Rouge');
     CountyFipsCodeCB.Items.add('035  E. Carroll');
     CountyFipsCodeCB.Items.add('037  E. Feliciana');
     CountyFipsCodeCB.Items.add('039  Evangeline');
     CountyFipsCodeCB.Items.add('041  Franklin');
     CountyFipsCodeCB.Items.add('043  Grant');
     CountyFipsCodeCB.Items.add('045  Iberia');
     CountyFipsCodeCB.Items.add('047  lberville ');
     CountyFipsCodeCB.Items.add('049  Jackson');
     CountyFipsCodeCB.Items.add('051  Jefferson');
     CountyFipsCodeCB.Items.add('053 Jefferson Davis');
     CountyFipsCodeCB.Items.add('055  Lafayette');
     CountyFipsCodeCB.Items.add('057  Lafourche');
     CountyFipsCodeCB.Items.add('059  La Salle');
     CountyFipsCodeCB.Items.add('061  Lincoln');
     CountyFipsCodeCB.Items.add('063  Livingston');
     CountyFipsCodeCB.Items.add('065  Madison');
     CountyFipsCodeCB.Items.add('071  Orleans');
     CountyFipsCodeCB.Items.add('073  Ouachita');
     CountyFipsCodeCB.Items.add('075  Plaquemines');
     CountyFipsCodeCB.Items.add('077  Pointe Coupee');
     CountyFipsCodeCB.Items.add('079  Rapides');
     CountyFipsCodeCB.Items.add('081  Red River');
     CountyFipsCodeCB.Items.add('083  Richland');
     CountyFipsCodeCB.Items.add('085  Sabine');
     CountyFipsCodeCB.Items.add('087  St. Bernard');
     CountyFipsCodeCB.Items.add('089  St. Charles');
     CountyFipsCodeCB.Items.add('091  St. Helena');
     CountyFipsCodeCB.Items.add('093  St. James');
     CountyFipsCodeCB.Items.add('095  St. John the Baptist');
     CountyFipsCodeCB.Items.add('097  St. Landry');
     CountyFipsCodeCB.Items.add('099  St. Martin');
     CountyFipsCodeCB.Items.add('101  St. Mary');
     CountyFipsCodeCB.Items.add('103  St. Tammany');
     CountyFipsCodeCB.Items.add('105  Tangipahoa');
     CountyFipsCodeCB.Items.add('107  Tensas');
     CountyFipsCodeCB.Items.add('109  Terrebonne');
     CountyFipsCodeCB.Items.add('111  Union');
     CountyFipsCodeCB.Items.add('113  Vermilion');
     CountyFipsCodeCB.Items.add('115  Vernon');
     CountyFipsCodeCB.Items.add('117  Washington');
     CountyFipsCodeCB.Items.add('119  Webster');
     CountyFipsCodeCB.Items.add('121  W. Baton Rouge');
     CountyFipsCodeCB.Items.add('123  W. Carroll');
     CountyFipsCodeCB.Items.add('125  W. Feliciana');
     CountyFipsCodeCB.Items.add('127  Winn');
     CountyFipsCodeCB.Items.add('167  Wilkin');
     CountyFipsCodeCB.Items.add('169  Winona');
  end;{: Louisiana';}
20:Begin  {MAINE (ME) (23)}
     CountyFipsCodeCB.Items.add('001  Androscoggin');
     CountyFipsCodeCB.Items.add('003  Aroostook');
     CountyFipsCodeCB.Items.add('005  Cumberland ');
     CountyFipsCodeCB.Items.add('007  Franklin');
     CountyFipsCodeCB.Items.add('009  Hancock');
     CountyFipsCodeCB.Items.add('011  Kennebec');
     CountyFipsCodeCB.Items.add('013  Knox');
     CountyFipsCodeCB.Items.add('015  Lincoln');
     CountyFipsCodeCB.Items.add('017  Oxford');
     CountyFipsCodeCB.Items.add('019  Penobscot');
     CountyFipsCodeCB.Items.add('021  Piscataquis');
     CountyFipsCodeCB.Items.add('023  Sagadahoc');
     CountyFipsCodeCB.Items.add('025  Somerset');
     CountyFipsCodeCB.Items.add('027  Waldo');
     CountyFipsCodeCB.Items.add('029  Washington');
     CountyFipsCodeCB.Items.add('031  York');
  end;{: Maine';}
21:Begin {MARYLAND (MD) (24)}
     CountyFipsCodeCB.Items.add('001  Allegany');
     CountyFipsCodeCB.Items.add('003  Anne Arundel');
     CountyFipsCodeCB.Items.add('005  Baltimore ');
     CountyFipsCodeCB.Items.add('009  Calvert');
     CountyFipsCodeCB.Items.add('011  Caroline');
     CountyFipsCodeCB.Items.add('013  Carroll');
     CountyFipsCodeCB.Items.add('015  Cecil');
     CountyFipsCodeCB.Items.add('017  Charles');
     CountyFipsCodeCB.Items.add('019  Dorchester');
     CountyFipsCodeCB.Items.add('021  Frederick');
     CountyFipsCodeCB.Items.add('023  Garrett');
     CountyFipsCodeCB.Items.add('025  Harford');
     CountyFipsCodeCB.Items.add('027  Howard');
     CountyFipsCodeCB.Items.add('029  Kent');
     CountyFipsCodeCB.Items.add('031  Montgomery');
     CountyFipsCodeCB.Items.add('033  Prince George`s*');
     CountyFipsCodeCB.Items.add('035  Queen Anne`s*');
     CountyFipsCodeCB.Items.add('037  St. Mary`s *');
     CountyFipsCodeCB.Items.add('039  Somerset');
     CountyFipsCodeCB.Items.add('041  Talbot');
     CountyFipsCodeCB.Items.add('043  Washington');
     CountyFipsCodeCB.Items.add('045  Wicomico');
     CountyFipsCodeCB.Items.add('047  Worcester');
     {INDEPENDENT CITY}
     CountyFipsCodeCB.Items.add('510 Baltimore (city)');
  end;{: Maryland';}
22:Begin {MASSACHUSETTS (MA) (25)}
     CountyFipsCodeCB.Items.add('001  Barnstable');
     CountyFipsCodeCB.Items.add('003  Berkshire');
     CountyFipsCodeCB.Items.add('005  Bristo');
     CountyFipsCodeCB.Items.add('007  Dukes');
     CountyFipsCodeCB.Items.add('009  Essex');
     CountyFipsCodeCB.Items.add('011  Franklin');
     CountyFipsCodeCB.Items.add('013  Hampden');
     CountyFipsCodeCB.Items.add('015  Hampshire');
     CountyFipsCodeCB.Items.add('017  Middlesex');
     CountyFipsCodeCB.Items.add('019  Nantucket');
     CountyFipsCodeCB.Items.add('021  Norfolk');
     CountyFipsCodeCB.Items.add('023  Plymouth');
     CountyFipsCodeCB.Items.add('025  Suffolk');
     CountyFipsCodeCB.Items.add('027  Worcester');
  end;{: Massachusetts';}
23:Begin {MICHIGAN (MI) (26)}
     CountyFipsCodeCB.Items.add('001  Alcona');
     CountyFipsCodeCB.Items.add('003  Alger');
     CountyFipsCodeCB.Items.add('005  Allegan');
     CountyFipsCodeCB.Items.add('007  Alpena');
     CountyFipsCodeCB.Items.add('009  Antrim');
     CountyFipsCodeCB.Items.add('011  Arenac');
     CountyFipsCodeCB.Items.add('013  Baraga');
     CountyFipsCodeCB.Items.add('015  Barry');
     CountyFipsCodeCB.Items.add('017  Bay');
     CountyFipsCodeCB.Items.add('019  Benzie');
     CountyFipsCodeCB.Items.add('021  Berrien');
     CountyFipsCodeCB.Items.add('023  Branch');
     CountyFipsCodeCB.Items.add('025  Calhoun');
     CountyFipsCodeCB.Items.add('027  Cass');
     CountyFipsCodeCB.Items.add('029  Charlevoix');
     CountyFipsCodeCB.Items.add('031  Cheboygan');
     CountyFipsCodeCB.Items.add('033  Chippewa');
     CountyFipsCodeCB.Items.add('035  Clare');
     CountyFipsCodeCB.Items.add('037  Clinton');
     CountyFipsCodeCB.Items.add('039  Crawford');
     CountyFipsCodeCB.Items.add('041  Delta');
     CountyFipsCodeCB.Items.add('043  Dickinson');
     CountyFipsCodeCB.Items.add('045  Eaton');
     CountyFipsCodeCB.Items.add('047  Emmet');
     CountyFipsCodeCB.Items.add('049  Genesee');
     CountyFipsCodeCB.Items.add('051  Gladwin');
     CountyFipsCodeCB.Items.add('053  Gogebic');
     CountyFipsCodeCB.Items.add('055  Grand Traverse');
     CountyFipsCodeCB.Items.add('057  Gratiot');
     CountyFipsCodeCB.Items.add('059  Hillsdale');
     CountyFipsCodeCB.Items.add('061  Houghton');
     CountyFipsCodeCB.Items.add('063  Huron');
     CountyFipsCodeCB.Items.add('065  Ingham');
     CountyFipsCodeCB.Items.add('067  lonia');
     CountyFipsCodeCB.Items.add('069  losco');
     CountyFipsCodeCB.Items.add('071  Iron');
     CountyFipsCodeCB.Items.add('073  IsabelIa');
     CountyFipsCodeCB.Items.add('075  Jackson');
     CountyFipsCodeCB.Items.add('077  Kalamazoo');
     CountyFipsCodeCB.Items.add('079  Kalkaska');
     CountyFipsCodeCB.Items.add('081  Kent');
     CountyFipsCodeCB.Items.add('083  Keweenaw');
     CountyFipsCodeCB.Items.add('085  Lake');
     CountyFipsCodeCB.Items.add('087  Lapeer');
     CountyFipsCodeCB.Items.add('089  Leelanau');
     CountyFipsCodeCB.Items.add('091  Lenawee');
     CountyFipsCodeCB.Items.add('093  Livingston');
     CountyFipsCodeCB.Items.add('095  Luce');
     CountyFipsCodeCB.Items.add('097  Mackinac');
     CountyFipsCodeCB.Items.add('099  Macomb');
     CountyFipsCodeCB.Items.add('101  Manistee');
     CountyFipsCodeCB.Items.add('103  Marquette');
     CountyFipsCodeCB.Items.add('105  Mason');
     CountyFipsCodeCB.Items.add('107  Mecosta');
     CountyFipsCodeCB.Items.add('109  Menominee');
     CountyFipsCodeCB.Items.add('111  Midland');
     CountyFipsCodeCB.Items.add('113  Missaukee');
     CountyFipsCodeCB.Items.add('115  Monroe');
     CountyFipsCodeCB.Items.add('117  Montcalm');
     CountyFipsCodeCB.Items.add('119  Montmorency');
     CountyFipsCodeCB.Items.add('121  Muskegon');
     CountyFipsCodeCB.Items.add('123  Newaygo');
     CountyFipsCodeCB.Items.add('125  Oakland');
     CountyFipsCodeCB.Items.add('127  Oceana');
     CountyFipsCodeCB.Items.add('129  Ogemaw');
     CountyFipsCodeCB.Items.add('131  Ontonagon');
     CountyFipsCodeCB.Items.add('133  Osceola');
     CountyFipsCodeCB.Items.add('135  Oscoda');
     CountyFipsCodeCB.Items.add('137  Otsego');
     CountyFipsCodeCB.Items.add('139  Ottawa');
     CountyFipsCodeCB.Items.add('141  Presque Isle');
     CountyFipsCodeCB.Items.add('143  Roscommon');
     CountyFipsCodeCB.Items.add('145  Saginaw');
     CountyFipsCodeCB.Items.add('147  St. Clair');
     CountyFipsCodeCB.Items.add('149  St. Joseph');
     CountyFipsCodeCB.Items.add('151  Sanilac');
     CountyFipsCodeCB.Items.add('153  Schoolcraft');
     CountyFipsCodeCB.Items.add('155  Shiawassee');
     CountyFipsCodeCB.Items.add('157  Tuscola');
     CountyFipsCodeCB.Items.add('159  Van Buren');
     CountyFipsCodeCB.Items.add('161  Washtenaw');
     CountyFipsCodeCB.Items.add('163  Wayne');
     CountyFipsCodeCB.Items.add('165  Wexford');
  end;{: Michigan';}
24:Begin {MINNESOTA (MN) (27)}
     CountyFipsCodeCB.Items.add('001  Aitkin');
     CountyFipsCodeCB.Items.add('003  Anoka');
     CountyFipsCodeCB.Items.add('005  Becker');
     CountyFipsCodeCB.Items.add('007  Beltrami');
     CountyFipsCodeCB.Items.add('009  Benton');
     CountyFipsCodeCB.Items.add('011  Big Stone');
     CountyFipsCodeCB.Items.add('013  Blue Earth');
     CountyFipsCodeCB.Items.add('015  Brown');
     CountyFipsCodeCB.Items.add('017  Carlton');
     CountyFipsCodeCB.Items.add('019  Carver');
     CountyFipsCodeCB.Items.add('021  Cass');
     CountyFipsCodeCB.Items.add('023  Chippewa');
     CountyFipsCodeCB.Items.add('025  Chisago');
     CountyFipsCodeCB.Items.add('027  Clay');
     CountyFipsCodeCB.Items.add('029  Clearwater');
     CountyFipsCodeCB.Items.add('031  Cook');
     CountyFipsCodeCB.Items.add('033  Cottonwood');
     CountyFipsCodeCB.Items.add('035  Crow Wing');
     CountyFipsCodeCB.Items.add('037  Dakota');
     CountyFipsCodeCB.Items.add('039  Dodge');
     CountyFipsCodeCB.Items.add('041  Douglas');
     CountyFipsCodeCB.Items.add('043  Faribault');
     CountyFipsCodeCB.Items.add('045  Fillmore');
     CountyFipsCodeCB.Items.add('047  Freeborn');
     CountyFipsCodeCB.Items.add('049  Goodhue');
     CountyFipsCodeCB.Items.add('051  Grant');
     CountyFipsCodeCB.Items.add('053  Hennepin');
     CountyFipsCodeCB.Items.add('055  Houston');
     CountyFipsCodeCB.Items.add('057  Hubbard');
     CountyFipsCodeCB.Items.add('059  Isanti');
     CountyFipsCodeCB.Items.add('061  Itasca');
     CountyFipsCodeCB.Items.add('063  Jackson');
     CountyFipsCodeCB.Items.add('065  Kanabec');
     CountyFipsCodeCB.Items.add('067  Kandiyohi');
     CountyFipsCodeCB.Items.add('069  Kittson');
     CountyFipsCodeCB.Items.add('071  Koochiching');
     CountyFipsCodeCB.Items.add('073  Lac qui Pare');
     CountyFipsCodeCB.Items.add('075  Lake');
     CountyFipsCodeCB.Items.add('077  Lake of the Woods');
     CountyFipsCodeCB.Items.add('079  Le Sueur');
     CountyFipsCodeCB.Items.add('081  Lincoln');
     CountyFipsCodeCB.Items.add('083  Lyon');
     CountyFipsCodeCB.Items.add('085  McLeod');
     CountyFipsCodeCB.Items.add('087  Mahnomen');
     CountyFipsCodeCB.Items.add('089  Marshall');
     CountyFipsCodeCB.Items.add('091  Martin');
     CountyFipsCodeCB.Items.add('093  Meeker');
     CountyFipsCodeCB.Items.add('095  Mille Lacs');
     CountyFipsCodeCB.Items.add('097  Morrison');
     CountyFipsCodeCB.Items.add('099  Mower');
     CountyFipsCodeCB.Items.add('101  Murray');
     CountyFipsCodeCB.Items.add('103  Nicollet');
     CountyFipsCodeCB.Items.add('105  Nobles');
     CountyFipsCodeCB.Items.add('107  Norman');
     CountyFipsCodeCB.Items.add('109  Olmsted');
     CountyFipsCodeCB.Items.add('111  Otter Tail');
     CountyFipsCodeCB.Items.add('113  Pennington');
     CountyFipsCodeCB.Items.add('115  Pine');
     CountyFipsCodeCB.Items.add('117  Pipestone');
     CountyFipsCodeCB.Items.add('119  Polk');
     CountyFipsCodeCB.Items.add('121  Pope');
     CountyFipsCodeCB.Items.add('123  Ramsey');
     CountyFipsCodeCB.Items.add('125  Red Lake');
     CountyFipsCodeCB.Items.add('127  Redwood');
     CountyFipsCodeCB.Items.add('129  Renville');
     CountyFipsCodeCB.Items.add('131  Rice');
     CountyFipsCodeCB.Items.add('133  Rock');
     CountyFipsCodeCB.Items.add('135  Roseau');
     CountyFipsCodeCB.Items.add('137  St. Louis');
     CountyFipsCodeCB.Items.add('139  Scott');
     CountyFipsCodeCB.Items.add('141  Sherburne');
     CountyFipsCodeCB.Items.add('143  Sibley');
     CountyFipsCodeCB.Items.add('145  Stearns');
     CountyFipsCodeCB.Items.add('147  Steele');
     CountyFipsCodeCB.Items.add('149  Stevens');
     CountyFipsCodeCB.Items.add('151  Swift');
     CountyFipsCodeCB.Items.add('153  Todd');
     CountyFipsCodeCB.Items.add('155  Traverse');
     CountyFipsCodeCB.Items.add('157  Wabasha');
     CountyFipsCodeCB.Items.add('159  Wadena');
     CountyFipsCodeCB.Items.add('161  Waseca');
     CountyFipsCodeCB.Items.add('163  Washington');
     CountyFipsCodeCB.Items.add('165  Watonwan');
     CountyFipsCodeCB.Items.add('167  Wilkin');
     CountyFipsCodeCB.Items.add('169  Winona');
     CountyFipsCodeCB.Items.add('171  Wright');
     CountyFipsCodeCB.Items.add('173  Yellow Medicine');
  end;{: Minnesota';}
25:Begin {MISSISSIPPI (MS) (28)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Alcorn');
     CountyFipsCodeCB.Items.add('005  Amite');
     CountyFipsCodeCB.Items.add('007  Attala');
     CountyFipsCodeCB.Items.add('009  Benton');
     CountyFipsCodeCB.Items.add('011  Bolivar');
     CountyFipsCodeCB.Items.add('013  Calhoun');
     CountyFipsCodeCB.Items.add('015  Carroll');
     CountyFipsCodeCB.Items.add('017  Chickasaw');
     CountyFipsCodeCB.Items.add('019  Choctaw');
     CountyFipsCodeCB.Items.add('021  Claiborne');
     CountyFipsCodeCB.Items.add('023  Clarke');
     CountyFipsCodeCB.Items.add('025  Clay');
     CountyFipsCodeCB.Items.add('027  Coahoma');
     CountyFipsCodeCB.Items.add('029  Copiah');
     CountyFipsCodeCB.Items.add('031  Covington');
     CountyFipsCodeCB.Items.add('033  DeSoto*');
     CountyFipsCodeCB.Items.add('035  Forrest');
     CountyFipsCodeCB.Items.add('037  Franklin');
     CountyFipsCodeCB.Items.add('039  George');
     CountyFipsCodeCB.Items.add('041  Greene');
     CountyFipsCodeCB.Items.add('043  Grenada');
     CountyFipsCodeCB.Items.add('045  Hancock');
     CountyFipsCodeCB.Items.add('047  Harrison');
     CountyFipsCodeCB.Items.add('049  Hinds');
     CountyFipsCodeCB.Items.add('051  Holmes');
     CountyFipsCodeCB.Items.add('053  Humphreys');
     CountyFipsCodeCB.Items.add('055  Issaquena');
     CountyFipsCodeCB.Items.add('057  ltawamba');
     CountyFipsCodeCB.Items.add('059  Jackson');
     CountyFipsCodeCB.Items.add('061  Jasper');
     CountyFipsCodeCB.Items.add('063  Jefferson');
     CountyFipsCodeCB.Items.add('065 Jefferson Davis');
     CountyFipsCodeCB.Items.add('067  Jones');
     CountyFipsCodeCB.Items.add('069  Kemper');
     CountyFipsCodeCB.Items.add('071  Lafayette');
     CountyFipsCodeCB.Items.add('073  Lamar');
     CountyFipsCodeCB.Items.add('075  Lauderdale');
     CountyFipsCodeCB.Items.add('077  Lawrence');
     CountyFipsCodeCB.Items.add('079  Leake');
     CountyFipsCodeCB.Items.add('081  Lee');
     CountyFipsCodeCB.Items.add('083  Leflore');
     CountyFipsCodeCB.Items.add('085  Lincoln');
     CountyFipsCodeCB.Items.add('087  Lowndes');
     CountyFipsCodeCB.Items.add('089  Madison');
     CountyFipsCodeCB.Items.add('091  Marion');
     CountyFipsCodeCB.Items.add('093  Marshall');
     CountyFipsCodeCB.Items.add('095  Monroe');
     CountyFipsCodeCB.Items.add('097  Montgomery');
     CountyFipsCodeCB.Items.add('099  Neshoba');
     CountyFipsCodeCB.Items.add('101  Newton');
     CountyFipsCodeCB.Items.add('103  Noxubee');
     CountyFipsCodeCB.Items.add('105  Oktibbeha');
     CountyFipsCodeCB.Items.add('107  Panola');
     CountyFipsCodeCB.Items.add('109  Pearl River');
     CountyFipsCodeCB.Items.add('111  Perry');
     CountyFipsCodeCB.Items.add('113  Pike');
     CountyFipsCodeCB.Items.add('115  Pontotoc');
     CountyFipsCodeCB.Items.add('117  Prentiss');
     CountyFipsCodeCB.Items.add('119  Quitman');
     CountyFipsCodeCB.Items.add('121  Rankin');
     CountyFipsCodeCB.Items.add('123  Scott');
     CountyFipsCodeCB.Items.add('125  Sharkey');
     CountyFipsCodeCB.Items.add('127  Simpson');
     CountyFipsCodeCB.Items.add('129  Smith');
     CountyFipsCodeCB.Items.add('131  Stone');
     CountyFipsCodeCB.Items.add('133  Sunflower');
     CountyFipsCodeCB.Items.add('135  Tallahatchie');
     CountyFipsCodeCB.Items.add('137  Tate');
     CountyFipsCodeCB.Items.add('139  Tippah');
     CountyFipsCodeCB.Items.add('141  Tishomingo');
     CountyFipsCodeCB.Items.add('143  Tunica');
     CountyFipsCodeCB.Items.add('145  Union');
     CountyFipsCodeCB.Items.add('147  Walthall');
     CountyFipsCodeCB.Items.add('149  Warren');
     CountyFipsCodeCB.Items.add('151  Washington');
     CountyFipsCodeCB.Items.add('153  Wayne');
     CountyFipsCodeCB.Items.add('155  Webster');
     CountyFipsCodeCB.Items.add('157  Wilkinson');
     CountyFipsCodeCB.Items.add('159  Winston');
     CountyFipsCodeCB.Items.add('161  Yalobusha');
     CountyFipsCodeCB.Items.add('163  Yazoo');
  end;{: Mississippi';}
26:Begin {MISSOURI (MO) (29)}
     CountyFipsCodeCB.Items.add('001  Adair');
     CountyFipsCodeCB.Items.add('003  Andrew');
     CountyFipsCodeCB.Items.add('005  Atchison');
     CountyFipsCodeCB.Items.add('007  Audrain');
     CountyFipsCodeCB.Items.add('009  Barry');
     CountyFipsCodeCB.Items.add('011  Barton');
     CountyFipsCodeCB.Items.add('013  Bates');
     CountyFipsCodeCB.Items.add('015  Benton');
     CountyFipsCodeCB.Items.add('017  Bollinger');
     CountyFipsCodeCB.Items.add('019  Boone');
     CountyFipsCodeCB.Items.add('021  Buchanan');
     CountyFipsCodeCB.Items.add('023  Butler');
     CountyFipsCodeCB.Items.add('025  Caldwell');
     CountyFipsCodeCB.Items.add('027  Callaway');
     CountyFipsCodeCB.Items.add('029  Camden');
     CountyFipsCodeCB.Items.add('031  Cape Girardeau');
     CountyFipsCodeCB.Items.add('033  Carroll');
     CountyFipsCodeCB.Items.add('035  Carter');
     CountyFipsCodeCB.Items.add('037  Cass');
     CountyFipsCodeCB.Items.add('039  Cedar');
     CountyFipsCodeCB.Items.add('041  Chariton');
     CountyFipsCodeCB.Items.add('043  Christian');
     CountyFipsCodeCB.Items.add('045  Clark');
     CountyFipsCodeCB.Items.add('047  Clay');
     CountyFipsCodeCB.Items.add('049  Clinton');
     CountyFipsCodeCB.Items.add('051  Cole');
     CountyFipsCodeCB.Items.add('053  Cooper');
     CountyFipsCodeCB.Items.add('055  Crawford');
     CountyFipsCodeCB.Items.add('057  Dade');
     CountyFipsCodeCB.Items.add('059  Dallas');
     CountyFipsCodeCB.Items.add('061  Daviess');
     CountyFipsCodeCB.Items.add('063  DeKalb*');
     CountyFipsCodeCB.Items.add('065  Dent');
     CountyFipsCodeCB.Items.add('067  Douglas');
     CountyFipsCodeCB.Items.add('069  Dunklin');
     CountyFipsCodeCB.Items.add('071  Franklin');
     CountyFipsCodeCB.Items.add('073  Gasconade');
     CountyFipsCodeCB.Items.add('075  Gentry');
     CountyFipsCodeCB.Items.add('077  Greene');
     CountyFipsCodeCB.Items.add('079  Grundy');
     CountyFipsCodeCB.Items.add('081  Harrison');
     CountyFipsCodeCB.Items.add('083  Henry');
     CountyFipsCodeCB.Items.add('085  Hickory');
     CountyFipsCodeCB.Items.add('087  Holt');
     CountyFipsCodeCB.Items.add('089  Howard');
     CountyFipsCodeCB.Items.add('091  Howell');
     CountyFipsCodeCB.Items.add('093  Iron');
     CountyFipsCodeCB.Items.add('095  Jackson');
     CountyFipsCodeCB.Items.add('097  Jasper');
     CountyFipsCodeCB.Items.add('099  Jefferson');
     CountyFipsCodeCB.Items.add('101  Johnson');
     CountyFipsCodeCB.Items.add('103  Knox');
     CountyFipsCodeCB.Items.add('105  Laclede');
     CountyFipsCodeCB.Items.add('107  Lafayette');
     CountyFipsCodeCB.Items.add('109  Lawrence');
     CountyFipsCodeCB.Items.add('111  Lewis');
     CountyFipsCodeCB.Items.add('113  Lincoln');
     CountyFipsCodeCB.Items.add('115  Linn');
     CountyFipsCodeCB.Items.add('117  Livingston');
     CountyFipsCodeCB.Items.add('119  McDonald');
     CountyFipsCodeCB.Items.add('121  Macon');
     CountyFipsCodeCB.Items.add('123  Madison');
     CountyFipsCodeCB.Items.add('125  Maries');
     CountyFipsCodeCB.Items.add('127  Marion');
     CountyFipsCodeCB.Items.add('129  Mercer');
     CountyFipsCodeCB.Items.add('131  Miller');
     CountyFipsCodeCB.Items.add('133  Mississippi');
     CountyFipsCodeCB.Items.add('135  Moniteau');
     CountyFipsCodeCB.Items.add('137  Monroe');
     CountyFipsCodeCB.Items.add('139  Montgomery');
     CountyFipsCodeCB.Items.add('141  Morgan');
     CountyFipsCodeCB.Items.add('143  New Madrid');
     CountyFipsCodeCB.Items.add('145  Newton');
     CountyFipsCodeCB.Items.add('147  Nodaway');
     CountyFipsCodeCB.Items.add('149  Oregon');
     CountyFipsCodeCB.Items.add('151  Osage');
     CountyFipsCodeCB.Items.add('153  Ozark');
     CountyFipsCodeCB.Items.add('155  Pemiscot');
     CountyFipsCodeCB.Items.add('157  Perry');
     CountyFipsCodeCB.Items.add('159  Pettis');
     CountyFipsCodeCB.Items.add('161  Phelps');
     CountyFipsCodeCB.Items.add('163  Pike');
     CountyFipsCodeCB.Items.add('165  Platte');
     CountyFipsCodeCB.Items.add('167  Polk');
     CountyFipsCodeCB.Items.add('169  Pulaski');
     CountyFipsCodeCB.Items.add('171  Putnam');
     CountyFipsCodeCB.Items.add('173  RaIls');
     CountyFipsCodeCB.Items.add('175  Randolph');
     CountyFipsCodeCB.Items.add('177  Ray');
     CountyFipsCodeCB.Items.add('179  Reynolds');
     CountyFipsCodeCB.Items.add('181  Ripley');
     CountyFipsCodeCB.Items.add('183  St. Charles');
     CountyFipsCodeCB.Items.add('185  St. Clair');
     CountyFipsCodeCB.Items.add('186  Ste. Genevieve');
     CountyFipsCodeCB.Items.add('187  St. Francois');
     CountyFipsCodeCB.Items.add('189  St. Louis');
     CountyFipsCodeCB.Items.add('195  Saline');
     CountyFipsCodeCB.Items.add('197  Schuyler');
     CountyFipsCodeCB.Items.add('199  Scotland');
     CountyFipsCodeCB.Items.add('201  Scott');
     CountyFipsCodeCB.Items.add('203  Shannon');
     CountyFipsCodeCB.Items.add('205  Shelby');
     CountyFipsCodeCB.Items.add('207  Stoddard');
     CountyFipsCodeCB.Items.add('209  Stone');
     CountyFipsCodeCB.Items.add('211  Sullivan');
     CountyFipsCodeCB.Items.add('213  Taney');
     CountyFipsCodeCB.Items.add('215  Texas');
     CountyFipsCodeCB.Items.add('217  Vernon');
     CountyFipsCodeCB.Items.add('219  Warren');
     CountyFipsCodeCB.Items.add('221  Washington');
     CountyFipsCodeCB.Items.add('223  Wayne');
     CountyFipsCodeCB.Items.add('225  Webster');
     CountyFipsCodeCB.Items.add('227  Worth');
     CountyFipsCodeCB.Items.add('229  Wright');
         {INDEPENDENT CITY}
     CountyFipsCodeCB.Items.add('510  St. Louis (city)');
  end;{: Missouri';}
27:Begin {MONTANA (MT) (30)}
     CountyFipsCodeCB.Items.add('001  Beaverhead');
     CountyFipsCodeCB.Items.add('003  Big Horn');
     CountyFipsCodeCB.Items.add('005  Blaine');
     CountyFipsCodeCB.Items.add('007  Broadwater');
     CountyFipsCodeCB.Items.add('009  Carbon');
     CountyFipsCodeCB.Items.add('011  Carter');
     CountyFipsCodeCB.Items.add('013  Cascade');
     CountyFipsCodeCB.Items.add('015  Chouteau');
     CountyFipsCodeCB.Items.add('017  Custer');
     CountyFipsCodeCB.Items.add('019  Daniels');
     CountyFipsCodeCB.Items.add('021  Dawson');
     CountyFipsCodeCB.Items.add('023  Deer Lodge');
     CountyFipsCodeCB.Items.add('025  Fallon');
     CountyFipsCodeCB.Items.add('027  Fergus');
     CountyFipsCodeCB.Items.add('029  Flathead');
     CountyFipsCodeCB.Items.add('031  Gallatin');
     CountyFipsCodeCB.Items.add('033  Garfield Park*');
     CountyFipsCodeCB.Items.add('035  Glacier');
     CountyFipsCodeCB.Items.add('037  Golden Valley');
     CountyFipsCodeCB.Items.add('039  Granite');
     CountyFipsCodeCB.Items.add('041  Hill');
     CountyFipsCodeCB.Items.add('043  Jefferson');
     CountyFipsCodeCB.Items.add('045  Judith Basin');
     CountyFipsCodeCB.Items.add('047  Lake');
     CountyFipsCodeCB.Items.add('049  Lewis & Clark');
     CountyFipsCodeCB.Items.add('051  Liberty');
     CountyFipsCodeCB.Items.add('053  Lincoln');
     CountyFipsCodeCB.Items.add('055  McCone');
     CountyFipsCodeCB.Items.add('057  Madison');
     CountyFipsCodeCB.Items.add('059  Meagher');
     CountyFipsCodeCB.Items.add('061  Mineral');
     CountyFipsCodeCB.Items.add('063  Missoula');
     CountyFipsCodeCB.Items.add('065  Musselshell');
     CountyFipsCodeCB.Items.add('067  Park');
     CountyFipsCodeCB.Items.add('069  Petroleum');
     CountyFipsCodeCB.Items.add('071  Phillips');
     CountyFipsCodeCB.Items.add('073  Pondera');
     CountyFipsCodeCB.Items.add('075  Powder River');
     CountyFipsCodeCB.Items.add('077  Powell');
     CountyFipsCodeCB.Items.add('079  Prairie');
     CountyFipsCodeCB.Items.add('081  Ravalli');
     CountyFipsCodeCB.Items.add('083  Richland');
     CountyFipsCodeCB.Items.add('085  Roosevelt');
     CountyFipsCodeCB.Items.add('087  Rosebud');
     CountyFipsCodeCB.Items.add('089  Sanders');
     CountyFipsCodeCB.Items.add('091  Sheridan');
     CountyFipsCodeCB.Items.add('093  Silver Bow');
     CountyFipsCodeCB.Items.add('095  Stillwater');
     CountyFipsCodeCB.Items.add('097  Sweet Grass');
     CountyFipsCodeCB.Items.add('099  Teton');
     CountyFipsCodeCB.Items.add('101  Toole');
     CountyFipsCodeCB.Items.add('103  Treasure');
     CountyFipsCodeCB.Items.add('105  Valley');
     CountyFipsCodeCB.Items.add('107  Wheatland');
     CountyFipsCodeCB.Items.add('109  Wibaux');
     CountyFipsCodeCB.Items.add('111  Yellowstone');
     CountyFipsCodeCB.Items.add('113  Yellowstone National');
  end;{: Montana';}
28:Begin {NEBRASKA (NE) (31)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Antelope');
     CountyFipsCodeCB.Items.add('005  Arthur');
     CountyFipsCodeCB.Items.add('007  Banner');
     CountyFipsCodeCB.Items.add('009  Blaine');
     CountyFipsCodeCB.Items.add('011  Boone');
     CountyFipsCodeCB.Items.add('013  Box Butte');
     CountyFipsCodeCB.Items.add('015  Boyd');
     CountyFipsCodeCB.Items.add('017  Brown');
     CountyFipsCodeCB.Items.add('019  Buffalo');
     CountyFipsCodeCB.Items.add('021  Burt');
     CountyFipsCodeCB.Items.add('023  Butler');
     CountyFipsCodeCB.Items.add('025  Cass');
     CountyFipsCodeCB.Items.add('027  Cedar');
     CountyFipsCodeCB.Items.add('029  Chase');
     CountyFipsCodeCB.Items.add('031  Cherry');
     CountyFipsCodeCB.Items.add('033  Cheyenne');
     CountyFipsCodeCB.Items.add('035  Clay');
     CountyFipsCodeCB.Items.add('037  Colfax');
     CountyFipsCodeCB.Items.add('039  Cuming');
     CountyFipsCodeCB.Items.add('041  Custer');
     CountyFipsCodeCB.Items.add('043  Dakota');
     CountyFipsCodeCB.Items.add('045  Dawes');
     CountyFipsCodeCB.Items.add('047  Dawson');
     CountyFipsCodeCB.Items.add('049  Deuel');
     CountyFipsCodeCB.Items.add('051  Dixon');
     CountyFipsCodeCB.Items.add('053  Dodge');
     CountyFipsCodeCB.Items.add('055   Douglas');
     CountyFipsCodeCB.Items.add('057  Dundy');
     CountyFipsCodeCB.Items.add('059  Fillmore');
     CountyFipsCodeCB.Items.add('061  Franklin');
     CountyFipsCodeCB.Items.add('063  Frontier');
     CountyFipsCodeCB.Items.add('065  Furnas');
     CountyFipsCodeCB.Items.add('067  Gage');
     CountyFipsCodeCB.Items.add('069  Garden');
     CountyFipsCodeCB.Items.add('071  Garfield');
     CountyFipsCodeCB.Items.add('073  Gosper');
     CountyFipsCodeCB.Items.add('075  Grant');
     CountyFipsCodeCB.Items.add('077  Greeley');
     CountyFipsCodeCB.Items.add('079  Hall');
     CountyFipsCodeCB.Items.add('081  Hamilton');
     CountyFipsCodeCB.Items.add('083  Harlan');
     CountyFipsCodeCB.Items.add('085  Hayes');
     CountyFipsCodeCB.Items.add('087  Hitchcock');
     CountyFipsCodeCB.Items.add('089  Holt');
     CountyFipsCodeCB.Items.add('091  Hooker');
     CountyFipsCodeCB.Items.add('093  Howard');
     CountyFipsCodeCB.Items.add('095  Jefferson');
     CountyFipsCodeCB.Items.add('097  Johnson');
     CountyFipsCodeCB.Items.add('099  Kearney');
     CountyFipsCodeCB.Items.add('101  Keith');
     CountyFipsCodeCB.Items.add('103  Keya Paha');
     CountyFipsCodeCB.Items.add('105  Kimball');
     CountyFipsCodeCB.Items.add('107  Knox');
     CountyFipsCodeCB.Items.add('109  Lancaster');
     CountyFipsCodeCB.Items.add('111  Lincoln');
     CountyFipsCodeCB.Items.add('113  Logan');
     CountyFipsCodeCB.Items.add('115  Loup');
     CountyFipsCodeCB.Items.add('117  McPherson');
     CountyFipsCodeCB.Items.add('119  Madison');
     CountyFipsCodeCB.Items.add('121  Merrick');
     CountyFipsCodeCB.Items.add('123  Morrill');
     CountyFipsCodeCB.Items.add('125  Nance');
     CountyFipsCodeCB.Items.add('127  Nemaha');
     CountyFipsCodeCB.Items.add('129  Nuckolls');
     CountyFipsCodeCB.Items.add('131  Otoe');
     CountyFipsCodeCB.Items.add('133  Pawnee');
     CountyFipsCodeCB.Items.add('135  Perkins');
     CountyFipsCodeCB.Items.add('137  Phelps');
     CountyFipsCodeCB.Items.add('139  Pierce');
     CountyFipsCodeCB.Items.add('141  Platte');
     CountyFipsCodeCB.Items.add('143  Polk');
     CountyFipsCodeCB.Items.add('145  Red Willow');
     CountyFipsCodeCB.Items.add('147  Richardson');
     CountyFipsCodeCB.Items.add('149  Rock');
     CountyFipsCodeCB.Items.add('151  Saline');
     CountyFipsCodeCB.Items.add('153  Sarpy');
     CountyFipsCodeCB.Items.add('155  Saunders');
     CountyFipsCodeCB.Items.add('157  Scotts Bluff');
     CountyFipsCodeCB.Items.add('159  Seward');
     CountyFipsCodeCB.Items.add('161  Sheridan');
     CountyFipsCodeCB.Items.add('163  Sherman');
     CountyFipsCodeCB.Items.add('165  Sioux');
     CountyFipsCodeCB.Items.add('167  Stanton');
     CountyFipsCodeCB.Items.add('169  Thayer');
     CountyFipsCodeCB.Items.add('171  Thomas');
     CountyFipsCodeCB.Items.add('173  Thurston');
     CountyFipsCodeCB.Items.add('175  Valley');
     CountyFipsCodeCB.Items.add('177  Washington');
     CountyFipsCodeCB.Items.add('179  Wayne');
     CountyFipsCodeCB.Items.add('181  Webster');
     CountyFipsCodeCB.Items.add('183  Wheeler');
     CountyFipsCodeCB.Items.add('185  York');
  end;{: Nebraska';}
29:Begin {NEVADA (NV) (32)}
     CountyFipsCodeCB.Items.add('001  Churchill');
     CountyFipsCodeCB.Items.add('003  Clark');
     CountyFipsCodeCB.Items.add('005  Douglas');
     CountyFipsCodeCB.Items.add('007  Elko');
     CountyFipsCodeCB.Items.add('009  Esmeralda ');
     CountyFipsCodeCB.Items.add('011  Eureka');
     CountyFipsCodeCB.Items.add('013  Humboldt');
     CountyFipsCodeCB.Items.add('015  Lander');
     CountyFipsCodeCB.Items.add('017  Lincoln');
     CountyFipsCodeCB.Items.add('019  Lyon');
     CountyFipsCodeCB.Items.add('021  Mineral');
     CountyFipsCodeCB.Items.add('023  Nye');
     CountyFipsCodeCB.Items.add('027  Pershing');
     CountyFipsCodeCB.Items.add('029  Storey');
     CountyFipsCodeCB.Items.add('031  Washoe');
     CountyFipsCodeCB.Items.add('033  White Pine');
         {INDEPENDENT CITY}
     CountyFipsCodeCB.Items.add('510 Carson City');
  end;{: Nevada';}
30:Begin {NEW HAMPSHIRE (NH) (33)}
     CountyFipsCodeCB.Items.add('001  Belknap');
     CountyFipsCodeCB.Items.add('003  Carroll');
     CountyFipsCodeCB.Items.add('005  Cheshire');
     CountyFipsCodeCB.Items.add('007  Coos');
     CountyFipsCodeCB.Items.add('009  Grafton');
     CountyFipsCodeCB.Items.add('011  Hillsborough');
     CountyFipsCodeCB.Items.add('013  Merrimack');
     CountyFipsCodeCB.Items.add('015  Rockingham');
     CountyFipsCodeCB.Items.add('017  Strafford');
     CountyFipsCodeCB.Items.add('019  Sullivan');
  end;{: New Hampshire';}
31:Begin {NEW JERSEY (NJ) (34)}
     CountyFipsCodeCB.Items.add('001  Atlantic');
     CountyFipsCodeCB.Items.add('003  Bergen');
     CountyFipsCodeCB.Items.add('005  Burlington');
     CountyFipsCodeCB.Items.add('007  Camden');
     CountyFipsCodeCB.Items.add('009  Cape May');
     CountyFipsCodeCB.Items.add('011  Cumberland');
     CountyFipsCodeCB.Items.add('013  Essex');
     CountyFipsCodeCB.Items.add('015  Gloucester');
     CountyFipsCodeCB.Items.add('017  Hudson');
     CountyFipsCodeCB.Items.add('019  Hunterdon');
     CountyFipsCodeCB.Items.add('021  Mercer');
     CountyFipsCodeCB.Items.add('023  Middlesex');
     CountyFipsCodeCB.Items.add('025  Monmouth');
     CountyFipsCodeCB.Items.add('027  Morris');
     CountyFipsCodeCB.Items.add('029  Ocean');
     CountyFipsCodeCB.Items.add('031  Passaic');
     CountyFipsCodeCB.Items.add('033  Salem');
     CountyFipsCodeCB.Items.add('035  Somerset');
     CountyFipsCodeCB.Items.add('037  Sussex');
     CountyFipsCodeCB.Items.add('039  Union');
     CountyFipsCodeCB.Items.add('041  Warren');
  end;{: New Jersey';}
32:Begin {NEW MEXICO (NM) (35)}
     CountyFipsCodeCB.Items.add('001  Bernalillo');
     CountyFipsCodeCB.Items.add('003  Catron');
     CountyFipsCodeCB.Items.add('005  Chaves');
     CountyFipsCodeCB.Items.add('006* Cibola ');
     CountyFipsCodeCB.Items.add('007  Colfax ');
     CountyFipsCodeCB.Items.add('009  Curry');
     CountyFipsCodeCB.Items.add('011  DeBaca*');
     CountyFipsCodeCB.Items.add('013  Dona Ana ');
     CountyFipsCodeCB.Items.add('015  Eddy');
     CountyFipsCodeCB.Items.add('017  Grant');
     CountyFipsCodeCB.Items.add('019  Guadalupe');
     CountyFipsCodeCB.Items.add('021  Harding');
     CountyFipsCodeCB.Items.add('023  Hidalgo');
     CountyFipsCodeCB.Items.add('025  Lea');
     CountyFipsCodeCB.Items.add('027  Lincoln');
     CountyFipsCodeCB.Items.add('028  Los Alamos');
     CountyFipsCodeCB.Items.add('029  Luna');
     CountyFipsCodeCB.Items.add('031  McKinley');
     CountyFipsCodeCB.Items.add('033  Mora');
     CountyFipsCodeCB.Items.add('035  Otero');
     CountyFipsCodeCB.Items.add('037 Quay');
     CountyFipsCodeCB.Items.add('039 Rio Arriba');
     CountyFipsCodeCB.Items.add('041 Roosevelt');
     CountyFipsCodeCB.Items.add('043 Sandoval');
     CountyFipsCodeCB.Items.add('045 San Juan');
     CountyFipsCodeCB.Items.add('047 San Miguel');
     CountyFipsCodeCB.Items.add('049 Santa Fe');
     CountyFipsCodeCB.Items.add('051 Sierra');
     CountyFipsCodeCB.Items.add('053 Socorro');
     CountyFipsCodeCB.Items.add('055 Taos');
     CountyFipsCodeCB.Items.add('057  Torrance');
     CountyFipsCodeCB.Items.add('059  Union');
     CountyFipsCodeCB.Items.add('061  Valencia');
  end;{: New Mexico';}
33:Begin {NEW YORK (NY) (36)}
     CountyFipsCodeCB.Items.add('001  Albany');
     CountyFipsCodeCB.Items.add('003  Allegany');
     CountyFipsCodeCB.Items.add('005  Bronx');
     CountyFipsCodeCB.Items.add('007  Broome');
     CountyFipsCodeCB.Items.add('009  Cattarnugus');
     CountyFipsCodeCB.Items.add('011  Cayuga');
     CountyFipsCodeCB.Items.add('013  Chautauqua');
     CountyFipsCodeCB.Items.add('015  Chemung ');
     CountyFipsCodeCB.Items.add('017  Chenango');
     CountyFipsCodeCB.Items.add('019  Clinton');
     CountyFipsCodeCB.Items.add('021  Columbia');
     CountyFipsCodeCB.Items.add('023  Cortland');
     CountyFipsCodeCB.Items.add('025  Delaware');
     CountyFipsCodeCB.Items.add('027  Dutchess');
     CountyFipsCodeCB.Items.add('029  Erie');
     CountyFipsCodeCB.Items.add('031  Essex');
     CountyFipsCodeCB.Items.add('033  Franklin');
     CountyFipsCodeCB.Items.add('035  Fulton');
     CountyFipsCodeCB.Items.add('037  Genesee');
     CountyFipsCodeCB.Items.add('039  Greene');
     CountyFipsCodeCB.Items.add('041  Hamilton');
     CountyFipsCodeCB.Items.add('043  Herkimer');
     CountyFipsCodeCB.Items.add('045  Jefferson');
     CountyFipsCodeCB.Items.add('047  Kings');
     CountyFipsCodeCB.Items.add('049  Lewis');
     CountyFipsCodeCB.Items.add('051  Livingston');
     CountyFipsCodeCB.Items.add('053  Madison');
     CountyFipsCodeCB.Items.add('055  Monroe');
     CountyFipsCodeCB.Items.add('057  Montgomery');
     CountyFipsCodeCB.Items.add('059  Nassau');
     CountyFipsCodeCB.Items.add('061  New York');
     CountyFipsCodeCB.Items.add('063  Niagara');
     CountyFipsCodeCB.Items.add('065  Oneida');
     CountyFipsCodeCB.Items.add('067  Onondaga');
     CountyFipsCodeCB.Items.add('069  Ontario');
     CountyFipsCodeCB.Items.add('071  Orange');
     CountyFipsCodeCB.Items.add('073  Orleans');
     CountyFipsCodeCB.Items.add('075  Oswego');
     CountyFipsCodeCB.Items.add('077  Otsego');
     CountyFipsCodeCB.Items.add('079  Putnam');
     CountyFipsCodeCB.Items.add('081  Queens');
     CountyFipsCodeCB.Items.add('083  Renselaer');
     CountyFipsCodeCB.Items.add('085  Richmond');
     CountyFipsCodeCB.Items.add('087  Rockland');
     CountyFipsCodeCB.Items.add('089  St. Lawrence');
     CountyFipsCodeCB.Items.add('091  Saratoga');
     CountyFipsCodeCB.Items.add('093  Schenectady');
     CountyFipsCodeCB.Items.add('095  Schoharie');
     CountyFipsCodeCB.Items.add('097  Schuyler');
     CountyFipsCodeCB.Items.add('099  Seneca');
     CountyFipsCodeCB.Items.add('101  Steuben');
     CountyFipsCodeCB.Items.add('103  Suffolk');
     CountyFipsCodeCB.Items.add('105  Sullivan');
     CountyFipsCodeCB.Items.add('107  Tioga');
     CountyFipsCodeCB.Items.add('109  Tompkins');
     CountyFipsCodeCB.Items.add('111  Ulster');
     CountyFipsCodeCB.Items.add('113  Warren');
     CountyFipsCodeCB.Items.add('115  Washington');
     CountyFipsCodeCB.Items.add('117  Wayne');
     CountyFipsCodeCB.Items.add('119  Westchester');
     CountyFipsCodeCB.Items.add('121  Wyoming');
     CountyFipsCodeCB.Items.add('123  Yates');
  end;{: New York';}
34:Begin {NORTH CAROLINA (NC) (37)}
     CountyFipsCodeCB.Items.add('001  Alamance');
     CountyFipsCodeCB.Items.add('003  Alexander');
     CountyFipsCodeCB.Items.add('005  Alleghany');
     CountyFipsCodeCB.Items.add('007  Anson ');
     CountyFipsCodeCB.Items.add('009  Ashe');
     CountyFipsCodeCB.Items.add('011  Avery');
     CountyFipsCodeCB.Items.add('013  Beaufort');
     CountyFipsCodeCB.Items.add('015  Bertie');
     CountyFipsCodeCB.Items.add('017  Bladen');
     CountyFipsCodeCB.Items.add('019  Brunswick');
     CountyFipsCodeCB.Items.add('021  Buncombe');
     CountyFipsCodeCB.Items.add('023  Burke');
     CountyFipsCodeCB.Items.add('025  Cabarrus');
     CountyFipsCodeCB.Items.add('027  Caldwell');
     CountyFipsCodeCB.Items.add('029  Camden');
     CountyFipsCodeCB.Items.add('031  Carteret');
     CountyFipsCodeCB.Items.add('033  Caswell');
     CountyFipsCodeCB.Items.add('035  Catawba');
     CountyFipsCodeCB.Items.add('037  Chatham ');
     CountyFipsCodeCB.Items.add('039  Cherokee');
     CountyFipsCodeCB.Items.add('041  Chowan');
     CountyFipsCodeCB.Items.add('043  Clay');
     CountyFipsCodeCB.Items.add('045  Cleveland');
     CountyFipsCodeCB.Items.add('047  Columbus');
     CountyFipsCodeCB.Items.add('049  Craven');
     CountyFipsCodeCB.Items.add('051  Cumberland');
     CountyFipsCodeCB.Items.add('053  Currituck');
     CountyFipsCodeCB.Items.add('055  Dare');
     CountyFipsCodeCB.Items.add('057  Davidson');
     CountyFipsCodeCB.Items.add('059  Davie');
     CountyFipsCodeCB.Items.add('061  Duplin ');
     CountyFipsCodeCB.Items.add('063  Durham');
     CountyFipsCodeCB.Items.add('065  Edgecombe');
     CountyFipsCodeCB.Items.add('067  Forsyth');
     CountyFipsCodeCB.Items.add('069  Franklin');
     CountyFipsCodeCB.Items.add('071  Gaston');
     CountyFipsCodeCB.Items.add('073  Gates');
     CountyFipsCodeCB.Items.add('075  Graham');
     CountyFipsCodeCB.Items.add('077  Granville');
     CountyFipsCodeCB.Items.add('079  Greene');
     CountyFipsCodeCB.Items.add('081  Guilford');
     CountyFipsCodeCB.Items.add('083  Halifax');
     CountyFipsCodeCB.Items.add('085  Harnett');
     CountyFipsCodeCB.Items.add('087  Haywood');
     CountyFipsCodeCB.Items.add('089  Henderson');
     CountyFipsCodeCB.Items.add('091  Hertford');
     CountyFipsCodeCB.Items.add('093  Hoke');
     CountyFipsCodeCB.Items.add('095  Hyde');
     CountyFipsCodeCB.Items.add('097  Iredell');
     CountyFipsCodeCB.Items.add('099  Jackson');
     CountyFipsCodeCB.Items.add('101  Johnston');
     CountyFipsCodeCB.Items.add('103   Jones');
     CountyFipsCodeCB.Items.add('105  Lee');
     CountyFipsCodeCB.Items.add('107  Lenoir');
     CountyFipsCodeCB.Items.add('109  Lincoln');
     CountyFipsCodeCB.Items.add('111  McDowell');
     CountyFipsCodeCB.Items.add('113  Macon');
     CountyFipsCodeCB.Items.add('115  Madison');
     CountyFipsCodeCB.Items.add('117  Martin');
     CountyFipsCodeCB.Items.add('119  Mecklenburg');
     CountyFipsCodeCB.Items.add('121  Mitchell');
     CountyFipsCodeCB.Items.add('123  Montgomery');
     CountyFipsCodeCB.Items.add('125  Moore');
     CountyFipsCodeCB.Items.add('127  Nash');
     CountyFipsCodeCB.Items.add('129  New Hanover');
     CountyFipsCodeCB.Items.add('131  Northampton');
     CountyFipsCodeCB.Items.add('133  Onslow');
     CountyFipsCodeCB.Items.add('135  Orange');
     CountyFipsCodeCB.Items.add('137  Pamlico');
     CountyFipsCodeCB.Items.add('139  Pasquotank');
     CountyFipsCodeCB.Items.add('141  Pender');
     CountyFipsCodeCB.Items.add('143  Perquimans');
     CountyFipsCodeCB.Items.add('145  Person');
     CountyFipsCodeCB.Items.add('147  Pitt');
     CountyFipsCodeCB.Items.add('149  Polk');
     CountyFipsCodeCB.Items.add('151  Randolph');
     CountyFipsCodeCB.Items.add('153  Richmond');
     CountyFipsCodeCB.Items.add('155  Robeson');
     CountyFipsCodeCB.Items.add('157  Rockingham');
     CountyFipsCodeCB.Items.add('159  Rowan');
     CountyFipsCodeCB.Items.add('161  Rutherford');
     CountyFipsCodeCB.Items.add('163  Sampson');
     CountyFipsCodeCB.Items.add('165  Scotland');
     CountyFipsCodeCB.Items.add('167  Staniy');
     CountyFipsCodeCB.Items.add('169  Stokes');
     CountyFipsCodeCB.Items.add('171  Surry');
     CountyFipsCodeCB.Items.add('173  Swain');
     CountyFipsCodeCB.Items.add('175  Transylvania');
     CountyFipsCodeCB.Items.add('177  Tyrrell');
     CountyFipsCodeCB.Items.add('179  Union');
     CountyFipsCodeCB.Items.add('181  Vance');
     CountyFipsCodeCB.Items.add('183  Wake');
     CountyFipsCodeCB.Items.add('185  Warren');
     CountyFipsCodeCB.Items.add('187  Washington');
     CountyFipsCodeCB.Items.add('189  Watauga');
     CountyFipsCodeCB.Items.add('191  Wayne');
     CountyFipsCodeCB.Items.add('193  Wilkes');
     CountyFipsCodeCB.Items.add('195  Wilson');
     CountyFipsCodeCB.Items.add('197  Yadkin');
     CountyFipsCodeCB.Items.add('199  Yancey');
  end;{: North Carolina';}
35:Begin {NORTH DAKOTA (ND) (38)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Barnes');
     CountyFipsCodeCB.Items.add('005  Benson');
     CountyFipsCodeCB.Items.add('007  Billings');
     CountyFipsCodeCB.Items.add('009  Bottineau');
     CountyFipsCodeCB.Items.add('011  Bowman');
     CountyFipsCodeCB.Items.add('013  Burke');
     CountyFipsCodeCB.Items.add('015  Burleigh');
     CountyFipsCodeCB.Items.add('017  Cass');
     CountyFipsCodeCB.Items.add('019  Cavalier');
     CountyFipsCodeCB.Items.add('021  Dickey');
     CountyFipsCodeCB.Items.add('023  Divide');
     CountyFipsCodeCB.Items.add('025  Dunn');
     CountyFipsCodeCB.Items.add('027  Eddy');
     CountyFipsCodeCB.Items.add('029  Emmons');
     CountyFipsCodeCB.Items.add('031  Foster');
     CountyFipsCodeCB.Items.add('033  Golden Valley');
     CountyFipsCodeCB.Items.add('035  Grand Forks');
     CountyFipsCodeCB.Items.add('037  Grant');
     CountyFipsCodeCB.Items.add('039  Griggs');
     CountyFipsCodeCB.Items.add('041  Hettinger');
     CountyFipsCodeCB.Items.add('043  Kidder');
     CountyFipsCodeCB.Items.add('045  LaMoure*');
     CountyFipsCodeCB.Items.add('047  Logan');
     CountyFipsCodeCB.Items.add('049  McHenry');
     CountyFipsCodeCB.Items.add('051  Mclntosh');
     CountyFipsCodeCB.Items.add('053  McKenzie');
     CountyFipsCodeCB.Items.add('055  McLean');
     CountyFipsCodeCB.Items.add('057  Mercer');
     CountyFipsCodeCB.Items.add('059  Morton');
     CountyFipsCodeCB.Items.add('061  Mountrail*');
     CountyFipsCodeCB.Items.add('063  Nelson');
     CountyFipsCodeCB.Items.add('065  Oliver');
     CountyFipsCodeCB.Items.add('067  Pembina');
     CountyFipsCodeCB.Items.add('069  Pierce');
     CountyFipsCodeCB.Items.add('071  Ramsey');
     CountyFipsCodeCB.Items.add('073  Ransom');
     CountyFipsCodeCB.Items.add('075  Renville');
     CountyFipsCodeCB.Items.add('077  Richland');
     CountyFipsCodeCB.Items.add('079  Rolette');
     CountyFipsCodeCB.Items.add('081  Sargent');
     CountyFipsCodeCB.Items.add('083  Sheridan');
     CountyFipsCodeCB.Items.add('085  Sioux');
     CountyFipsCodeCB.Items.add('087  Slope');
     CountyFipsCodeCB.Items.add('089  Stark');
     CountyFipsCodeCB.Items.add('091  Steele');
     CountyFipsCodeCB.Items.add('093  Stutsman');
     CountyFipsCodeCB.Items.add('095  Towner');
     CountyFipsCodeCB.Items.add('097  Traill');
     CountyFipsCodeCB.Items.add('099  Walsh');
     CountyFipsCodeCB.Items.add('101  Ward');
     CountyFipsCodeCB.Items.add('103  Wells');
     CountyFipsCodeCB.Items.add('105  Williams');
  end;{: North Dakota';}
36:Begin {OHIO (OH) (39)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Allen');
     CountyFipsCodeCB.Items.add('005  Ashland');
     CountyFipsCodeCB.Items.add('007  Ashtabula');
     CountyFipsCodeCB.Items.add('009  Athens');
     CountyFipsCodeCB.Items.add('011  Auglaize');
     CountyFipsCodeCB.Items.add('013  Belmont');
     CountyFipsCodeCB.Items.add('015  Brown');
     CountyFipsCodeCB.Items.add('017  Butler');
     CountyFipsCodeCB.Items.add('019  Carroll');
     CountyFipsCodeCB.Items.add('021  Champaign');
     CountyFipsCodeCB.Items.add('023  Clark');
     CountyFipsCodeCB.Items.add('025  Clermont');
     CountyFipsCodeCB.Items.add('027  Clinton');
     CountyFipsCodeCB.Items.add('029  Columbiana');
     CountyFipsCodeCB.Items.add('031  Coshocton');
     CountyFipsCodeCB.Items.add('033  Crawford');
     CountyFipsCodeCB.Items.add('035  Cuyahoga');
     CountyFipsCodeCB.Items.add('037  Darke');
     CountyFipsCodeCB.Items.add('039  Defiance');
     CountyFipsCodeCB.Items.add('041  Delaware');
     CountyFipsCodeCB.Items.add('043  Erie');
     CountyFipsCodeCB.Items.add('045  Fairfield');
     CountyFipsCodeCB.Items.add('O47  Fayette');
     CountyFipsCodeCB.Items.add('049  Franklin');
     CountyFipsCodeCB.Items.add('051  Fulton');
     CountyFipsCodeCB.Items.add('053  Gallia');
     CountyFipsCodeCB.Items.add('055  Geauga');
     CountyFipsCodeCB.Items.add('057  Greene');
     CountyFipsCodeCB.Items.add('059  Guernsey');
     CountyFipsCodeCB.Items.add('061  Hamilton');
     CountyFipsCodeCB.Items.add('063  Hancock');
     CountyFipsCodeCB.Items.add('065  Hardin');
     CountyFipsCodeCB.Items.add('067  Harrison');
     CountyFipsCodeCB.Items.add('069  Henry');
     CountyFipsCodeCB.Items.add('071  Highland');
     CountyFipsCodeCB.Items.add('073  Hocking');
     CountyFipsCodeCB.Items.add('075  Holmes');
     CountyFipsCodeCB.Items.add('077  Huron');
     CountyFipsCodeCB.Items.add('079  Jackson');
     CountyFipsCodeCB.Items.add('081  Jefferson');
     CountyFipsCodeCB.Items.add('083  Knox');
     CountyFipsCodeCB.Items.add('085  Lake');
     CountyFipsCodeCB.Items.add('087  Lawrence');
     CountyFipsCodeCB.Items.add('089  Licking');
     CountyFipsCodeCB.Items.add('091  Logan');
     CountyFipsCodeCB.Items.add('093  Lorain');
     CountyFipsCodeCB.Items.add('095  Lucas');
     CountyFipsCodeCB.Items.add('097  Madison');
     CountyFipsCodeCB.Items.add('099  Mahoning');
     CountyFipsCodeCB.Items.add('101  Marion');
     CountyFipsCodeCB.Items.add('103  Medina');
     CountyFipsCodeCB.Items.add('105  Meigs');
     CountyFipsCodeCB.Items.add('107  Mercer');
     CountyFipsCodeCB.Items.add('109  Miami');
     CountyFipsCodeCB.Items.add('111  Monroe');
     CountyFipsCodeCB.Items.add('113  Montgomery');
     CountyFipsCodeCB.Items.add('115  Morgan');
     CountyFipsCodeCB.Items.add('117  Morrow');
     CountyFipsCodeCB.Items.add('119  Muskingum');
     CountyFipsCodeCB.Items.add('121  Noble');
     CountyFipsCodeCB.Items.add('123  Ottawa');
     CountyFipsCodeCB.Items.add('125  Paulding');
     CountyFipsCodeCB.Items.add('127  Perry');
     CountyFipsCodeCB.Items.add('129  Pickaway');
     CountyFipsCodeCB.Items.add('131  Pike');
     CountyFipsCodeCB.Items.add('133  Portage');
     CountyFipsCodeCB.Items.add('135  Preble');
     CountyFipsCodeCB.Items.add('137  Putnam');
     CountyFipsCodeCB.Items.add('139  Richland');
     CountyFipsCodeCB.Items.add('141  Ross');
     CountyFipsCodeCB.Items.add('143  Sandusky');
     CountyFipsCodeCB.Items.add('145  Scioto');
     CountyFipsCodeCB.Items.add('147  Seneca');
     CountyFipsCodeCB.Items.add('149  Shelby');
     CountyFipsCodeCB.Items.add('151  Stark');
     CountyFipsCodeCB.Items.add('153  Summit');
     CountyFipsCodeCB.Items.add('155  Trumbull');
     CountyFipsCodeCB.Items.add('157  Tuscarawas');
     CountyFipsCodeCB.Items.add('159  Union');
     CountyFipsCodeCB.Items.add('161  Van Wert');
     CountyFipsCodeCB.Items.add('163  Vinton');
     CountyFipsCodeCB.Items.add('165  Warren');
     CountyFipsCodeCB.Items.add('167  Washington');
     CountyFipsCodeCB.Items.add('169  Wayne');
     CountyFipsCodeCB.Items.add('171  Williams');
     CountyFipsCodeCB.Items.add('173  Wood');
     CountyFipsCodeCB.Items.add('175  Wyandot');
  end;{: Ohio';}
37:Begin {OKLAHOMA (OK) (40)}
     CountyFipsCodeCB.Items.add('001  Adair');
     CountyFipsCodeCB.Items.add('003  Alfalfa');
     CountyFipsCodeCB.Items.add('005  Atoka');
     CountyFipsCodeCB.Items.add('007  Beaver');
     CountyFipsCodeCB.Items.add('009  Beckham ');
     CountyFipsCodeCB.Items.add('011  Blaine');
     CountyFipsCodeCB.Items.add('013  Bryan');
     CountyFipsCodeCB.Items.add('015  Caddo');
     CountyFipsCodeCB.Items.add('017  Canadian');
     CountyFipsCodeCB.Items.add('019  Carter');
     CountyFipsCodeCB.Items.add('021  Cherokee');
     CountyFipsCodeCB.Items.add('023  Choctaw');
     CountyFipsCodeCB.Items.add('025  Cimarron');
     CountyFipsCodeCB.Items.add('027  Cleveland');
     CountyFipsCodeCB.Items.add('029  Coal');
     CountyFipsCodeCB.Items.add('031  Comanche');
     CountyFipsCodeCB.Items.add('033  Cotton');
     CountyFipsCodeCB.Items.add('035  Craig');
     CountyFipsCodeCB.Items.add('037  Creek');
     CountyFipsCodeCB.Items.add('039  Custer');
     CountyFipsCodeCB.Items.add('041  Delaware');
     CountyFipsCodeCB.Items.add('043  Dewey');
     CountyFipsCodeCB.Items.add('045  Ellis');
     CountyFipsCodeCB.Items.add('047  Garfield');
     CountyFipsCodeCB.Items.add('049  Garvin');
     CountyFipsCodeCB.Items.add('051  Grady');
     CountyFipsCodeCB.Items.add('053  Grant');
     CountyFipsCodeCB.Items.add('055  Greer');
     CountyFipsCodeCB.Items.add('057  Harmon');
     CountyFipsCodeCB.Items.add('059  Harper ');
     CountyFipsCodeCB.Items.add('061  Haskell');
     CountyFipsCodeCB.Items.add('063  Hughes');
     CountyFipsCodeCB.Items.add('065  Jackson');
     CountyFipsCodeCB.Items.add('067  Jefferson');
     CountyFipsCodeCB.Items.add('069  Johnston');
     CountyFipsCodeCB.Items.add('071  Kay');
     CountyFipsCodeCB.Items.add('073  Kingfisher');
     CountyFipsCodeCB.Items.add('075  Kiowa');
     CountyFipsCodeCB.Items.add('077  Latimer');
     CountyFipsCodeCB.Items.add('079  Le Flore');
     CountyFipsCodeCB.Items.add('081  Lincoln');
     CountyFipsCodeCB.Items.add('083  Logan');
     CountyFipsCodeCB.Items.add('085  Love');
     CountyFipsCodeCB.Items.add('087  McClain');
     CountyFipsCodeCB.Items.add('089  McCurtain');
     CountyFipsCodeCB.Items.add('091  McIntosh');
     CountyFipsCodeCB.Items.add('093  Major');
     CountyFipsCodeCB.Items.add('095  Marshall');
     CountyFipsCodeCB.Items.add('097  Mayes');
     CountyFipsCodeCB.Items.add('099  Murray');
     CountyFipsCodeCB.Items.add('101  Muskogee');
     CountyFipsCodeCB.Items.add('103  Noble');
     CountyFipsCodeCB.Items.add('105  Nowata');
     CountyFipsCodeCB.Items.add('107  Okfuskee');
     CountyFipsCodeCB.Items.add('109  Oklahoma');
     CountyFipsCodeCB.Items.add('111  Okmulgee');
     CountyFipsCodeCB.Items.add('113  Osage');
     CountyFipsCodeCB.Items.add('115  Ottawa');
     CountyFipsCodeCB.Items.add('117  Pawnee');
     CountyFipsCodeCB.Items.add('119  Payne');
     CountyFipsCodeCB.Items.add('121  Pittsburg');
     CountyFipsCodeCB.Items.add('123  Pontotoc');
     CountyFipsCodeCB.Items.add('125  Pottawatomie');
     CountyFipsCodeCB.Items.add('127  Pushmataha');
     CountyFipsCodeCB.Items.add('129  Roger Mills');
     CountyFipsCodeCB.Items.add('131  Rogers');
     CountyFipsCodeCB.Items.add('133  Seminole');
     CountyFipsCodeCB.Items.add('135  Sequoyah');
     CountyFipsCodeCB.Items.add('137  Stephens');
     CountyFipsCodeCB.Items.add('139  Texas');
     CountyFipsCodeCB.Items.add('141  Tillman');
     CountyFipsCodeCB.Items.add('143  Tulsa');
     CountyFipsCodeCB.Items.add('145  Wagoner');
     CountyFipsCodeCB.Items.add('147  Washington');
     CountyFipsCodeCB.Items.add('149  Washita');
     CountyFipsCodeCB.Items.add('151  Woods');
     CountyFipsCodeCB.Items.add('153  Woodward');
  end;{: Oklahoma';}
38:Begin {OREGON (OR) (41)}
     CountyFipsCodeCB.Items.add('001  Baker');
     CountyFipsCodeCB.Items.add('003  Benton');
     CountyFipsCodeCB.Items.add('005  Clackamas');
     CountyFipsCodeCB.Items.add('007  Clatsop');
     CountyFipsCodeCB.Items.add('009  Columbia');
     CountyFipsCodeCB.Items.add('011  Coos');
     CountyFipsCodeCB.Items.add('013  Crook');
     CountyFipsCodeCB.Items.add('015  Curry');
     CountyFipsCodeCB.Items.add('017  Deschutes');
     CountyFipsCodeCB.Items.add('019  Douglas');
     CountyFipsCodeCB.Items.add('021  Gilliam');
     CountyFipsCodeCB.Items.add('023  Grant');
     CountyFipsCodeCB.Items.add('025  Harney ');
     CountyFipsCodeCB.Items.add('027  Hood River');
     CountyFipsCodeCB.Items.add('029  Jackson');
     CountyFipsCodeCB.Items.add('031  Jefferson');
     CountyFipsCodeCB.Items.add('033  Josephine');
     CountyFipsCodeCB.Items.add('035  Klamath');
     CountyFipsCodeCB.Items.add('037  Lake');
     CountyFipsCodeCB.Items.add('039  Lane');
     CountyFipsCodeCB.Items.add('041  Lincoln');
     CountyFipsCodeCB.Items.add('043  Linn');
     CountyFipsCodeCB.Items.add('045  Malheur');
     CountyFipsCodeCB.Items.add('047  Marion');
     CountyFipsCodeCB.Items.add('049  Morrow');
     CountyFipsCodeCB.Items.add('051  Multnomah');
     CountyFipsCodeCB.Items.add('053  Polk');
     CountyFipsCodeCB.Items.add('055  Sherman');
     CountyFipsCodeCB.Items.add('057  Tillamook');
     CountyFipsCodeCB.Items.add('059  Umatilla');
     CountyFipsCodeCB.Items.add('061  Union');
     CountyFipsCodeCB.Items.add('063  Wallowa');
     CountyFipsCodeCB.Items.add('065  Wasco');
     CountyFipsCodeCB.Items.add('067  Washington');
     CountyFipsCodeCB.Items.add('069  Wheeler');
     CountyFipsCodeCB.Items.add('071  Yamhill');
  end;{: Oregon';}
39:Begin {PENNSYLVANIA (PA) (42)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Allegheny');
     CountyFipsCodeCB.Items.add('005  Armstrong');
     CountyFipsCodeCB.Items.add('007  Beaver');
     CountyFipsCodeCB.Items.add('009  Bedford');
     CountyFipsCodeCB.Items.add('011  Berks');
     CountyFipsCodeCB.Items.add('013  Blair');
     CountyFipsCodeCB.Items.add('015  Bradford');
     CountyFipsCodeCB.Items.add('017  Bucks');
     CountyFipsCodeCB.Items.add('019  Butler');
     CountyFipsCodeCB.Items.add('021  Cambria');
     CountyFipsCodeCB.Items.add('023  Cameron');
     CountyFipsCodeCB.Items.add('025  Carbon');
     CountyFipsCodeCB.Items.add('027  Centre');
     CountyFipsCodeCB.Items.add('029  Chester');
     CountyFipsCodeCB.Items.add('031  Clarion');
     CountyFipsCodeCB.Items.add('033  Clearfield');
     CountyFipsCodeCB.Items.add('035  Clinton');
     CountyFipsCodeCB.Items.add('037  Columbia');
     CountyFipsCodeCB.Items.add('039  Crawford');
     CountyFipsCodeCB.Items.add('041  Cumberland');
     CountyFipsCodeCB.Items.add('043  Dauphin');
     CountyFipsCodeCB.Items.add('045  Delaware');
     CountyFipsCodeCB.Items.add('047  Elk');
     CountyFipsCodeCB.Items.add('049  Erie');
     CountyFipsCodeCB.Items.add('051  Fayette');
     CountyFipsCodeCB.Items.add('053  Forest');
     CountyFipsCodeCB.Items.add('055  Franklin');
     CountyFipsCodeCB.Items.add('057  Fulton');
     CountyFipsCodeCB.Items.add('059  Greene');
     CountyFipsCodeCB.Items.add('061  Huntingdon');
     CountyFipsCodeCB.Items.add('063  Indiana');
     CountyFipsCodeCB.Items.add('065  Jefferson');
     CountyFipsCodeCB.Items.add('067  Juniata');
     CountyFipsCodeCB.Items.add('069  Lackawanna');
     CountyFipsCodeCB.Items.add('071  Lancaster');
     CountyFipsCodeCB.Items.add('073  Lawrence');
     CountyFipsCodeCB.Items.add('075  Lebanon');
     CountyFipsCodeCB.Items.add('077  Lehigh');
     CountyFipsCodeCB.Items.add('079  Luzerne');
     CountyFipsCodeCB.Items.add('081  Lycoming');
     CountyFipsCodeCB.Items.add('083  McKean');
     CountyFipsCodeCB.Items.add('085  Mercer');
     CountyFipsCodeCB.Items.add('087  Mifflin');
     CountyFipsCodeCB.Items.add('089  Monroe');
     CountyFipsCodeCB.Items.add('091  Montgomery');
     CountyFipsCodeCB.Items.add('093  Montour');
     CountyFipsCodeCB.Items.add('095  Northampton');
     CountyFipsCodeCB.Items.add('097  Northumberland');
     CountyFipsCodeCB.Items.add('099  Perry');
     CountyFipsCodeCB.Items.add('101  Philadelphia');
     CountyFipsCodeCB.Items.add('103  Pike');
     CountyFipsCodeCB.Items.add('105  Potter');
     CountyFipsCodeCB.Items.add('107  Schuylkill');
     CountyFipsCodeCB.Items.add('109  Snyder');
     CountyFipsCodeCB.Items.add('111  Somerset');
     CountyFipsCodeCB.Items.add('113  Sullivan');
     CountyFipsCodeCB.Items.add('115  Susquehanna');
     CountyFipsCodeCB.Items.add('117  Tioga');
     CountyFipsCodeCB.Items.add('119  Union');
     CountyFipsCodeCB.Items.add('121  Venango');
     CountyFipsCodeCB.Items.add('123  Warren');
     CountyFipsCodeCB.Items.add('125  Washington');
     CountyFipsCodeCB.Items.add('127  Wayne');
     CountyFipsCodeCB.Items.add('129  Westmornland');
     CountyFipsCodeCB.Items.add('131  Wyoming');
     CountyFipsCodeCB.Items.add('133  York');
  end;{: Pennsylvania';}
40:Begin {RHODE ISLAND (RI) (44)}
     CountyFipsCodeCB.Items.add('001 Bristol');
     CountyFipsCodeCB.Items.add('003 Kent ');
     CountyFipsCodeCB.Items.add('005 Newport');
     CountyFipsCodeCB.Items.add('007 Providence');
     CountyFipsCodeCB.Items.add('009 Washington');
  end;{: RhodeIsland';}
41:Begin {SOUTH CAROLINA (SC) (45)}
     CountyFipsCodeCB.Items.add('001  Abbeville');
     CountyFipsCodeCB.Items.add('003  Aiken');
     CountyFipsCodeCB.Items.add('005  Allendale');
     CountyFipsCodeCB.Items.add('007  Anderson');
     CountyFipsCodeCB.Items.add('009  Bamberg');
     CountyFipsCodeCB.Items.add('011  Barnwell');
     CountyFipsCodeCB.Items.add('013  Beaufort');
     CountyFipsCodeCB.Items.add('015  Berkeley ');
     CountyFipsCodeCB.Items.add('017  Calhoun');
     CountyFipsCodeCB.Items.add('019  Charleston');
     CountyFipsCodeCB.Items.add('021  Cherokee');
     CountyFipsCodeCB.Items.add('023  Chester');
     CountyFipsCodeCB.Items.add('025  Chesterfield');
     CountyFipsCodeCB.Items.add('027  Clarendon');
     CountyFipsCodeCB.Items.add('029  Colleton');
     CountyFipsCodeCB.Items.add('031  Darlington');
     CountyFipsCodeCB.Items.add('033  Dillon');
     CountyFipsCodeCB.Items.add('035  Dorchester');
     CountyFipsCodeCB.Items.add('037  Edgefield ');
     CountyFipsCodeCB.Items.add('039  Fairfield');
     CountyFipsCodeCB.Items.add('041  Florence');
     CountyFipsCodeCB.Items.add('043  Georgetown');
     CountyFipsCodeCB.Items.add('045  Greenville');
     CountyFipsCodeCB.Items.add('047  Greenwood');
     CountyFipsCodeCB.Items.add('049  Hampton');
     CountyFipsCodeCB.Items.add('051  Horry');
     CountyFipsCodeCB.Items.add('053  Jasper');
     CountyFipsCodeCB.Items.add('055  Kershaw');
     CountyFipsCodeCB.Items.add('057  Lancaster');
     CountyFipsCodeCB.Items.add('059  Laurens');
     CountyFipsCodeCB.Items.add('061  Lee');
     CountyFipsCodeCB.Items.add('063  Lexington');
     CountyFipsCodeCB.Items.add('065  McCormick');
     CountyFipsCodeCB.Items.add('067  Marion');
     CountyFipsCodeCB.Items.add('069  Marlboro');
     CountyFipsCodeCB.Items.add('071  Newberry');
     CountyFipsCodeCB.Items.add('073  Oconee');
     CountyFipsCodeCB.Items.add('075  Orangeburg0');
     CountyFipsCodeCB.Items.add('077  Pickens');
     CountyFipsCodeCB.Items.add('079  Richland');
     CountyFipsCodeCB.Items.add('081  Saluda');
     CountyFipsCodeCB.Items.add('083  Spartanburg');
     CountyFipsCodeCB.Items.add('085  Sumter');
     CountyFipsCodeCB.Items.add('087  Union');
     CountyFipsCodeCB.Items.add('089  Williamsburg');
     CountyFipsCodeCB.Items.add('091  York');
  end;{: South Carolina';}
42:Begin {SOUTH DAKOTA (SD) (46)}
     CountyFipsCodeCB.Items.add('003  Aurora ');
     CountyFipsCodeCB.Items.add('005  Beadle');
     CountyFipsCodeCB.Items.add('007  Bennett');
     CountyFipsCodeCB.Items.add('009  Bon Homme');
     CountyFipsCodeCB.Items.add('011  Brookings');
     CountyFipsCodeCB.Items.add('013  Brown');
     CountyFipsCodeCB.Items.add('015  Brule');
     CountyFipsCodeCB.Items.add('017  Buffalo');
     CountyFipsCodeCB.Items.add('019  Butte');
     CountyFipsCodeCB.Items.add('021  Campbell');
     CountyFipsCodeCB.Items.add('023  Charles Mix');
     CountyFipsCodeCB.Items.add('025  Clark');
     CountyFipsCodeCB.Items.add('027  Clay');
     CountyFipsCodeCB.Items.add('029  Codington');
     CountyFipsCodeCB.Items.add('031  Corson');
     CountyFipsCodeCB.Items.add('033  Custer');
     CountyFipsCodeCB.Items.add('035  Davison');
     CountyFipsCodeCB.Items.add('037  Day');
     CountyFipsCodeCB.Items.add('039  Deuel');
     CountyFipsCodeCB.Items.add('041  Dewey');
     CountyFipsCodeCB.Items.add('043  Douglas');
     CountyFipsCodeCB.Items.add('045  Edmunds');
     CountyFipsCodeCB.Items.add('047  Fall River');
     CountyFipsCodeCB.Items.add('049  Faulk');
     CountyFipsCodeCB.Items.add('051  Grant');
     CountyFipsCodeCB.Items.add('053  Gregory');
     CountyFipsCodeCB.Items.add('055  Haakon');
     CountyFipsCodeCB.Items.add('057  Hamlin');
     CountyFipsCodeCB.Items.add('059  Hand');
     CountyFipsCodeCB.Items.add('061  Hanson');
     CountyFipsCodeCB.Items.add('063  Harding');
     CountyFipsCodeCB.Items.add('065  Hughes');
     CountyFipsCodeCB.Items.add('067  Hutchinson');
     CountyFipsCodeCB.Items.add('069  Hyde');
     CountyFipsCodeCB.Items.add('071  Jackson');
     CountyFipsCodeCB.Items.add('073  Jerauld');
     CountyFipsCodeCB.Items.add('075  Jones');
     CountyFipsCodeCB.Items.add('077  Kingsbury');
     CountyFipsCodeCB.Items.add('079  Lake');
     CountyFipsCodeCB.Items.add('081  Lawrence');
     CountyFipsCodeCB.Items.add('083  Lincoln');
     CountyFipsCodeCB.Items.add('085  Lyman');
     CountyFipsCodeCB.Items.add('087  McCook');
     CountyFipsCodeCB.Items.add('089  McPherson');
     CountyFipsCodeCB.Items.add('091  Marshall');
     CountyFipsCodeCB.Items.add('093  Meade');
     CountyFipsCodeCB.Items.add('095  Mellette');
     CountyFipsCodeCB.Items.add('097  Miner');
     CountyFipsCodeCB.Items.add('099  Minnehaha');
     CountyFipsCodeCB.Items.add('101  Moody');
     CountyFipsCodeCB.Items.add('103  Pennington');
     CountyFipsCodeCB.Items.add('105  Perkins');
     CountyFipsCodeCB.Items.add('107  Potter');
     CountyFipsCodeCB.Items.add('109  Roberts');
     CountyFipsCodeCB.Items.add('111  Sanborn');
     CountyFipsCodeCB.Items.add('113  Shannon');
     CountyFipsCodeCB.Items.add('115  Spink');
     CountyFipsCodeCB.Items.add('117  Stanley');
     CountyFipsCodeCB.Items.add('119  Sully');
     CountyFipsCodeCB.Items.add('121  Todd');
     CountyFipsCodeCB.Items.add('123  Tripp');
     CountyFipsCodeCB.Items.add('125  Turner');
     CountyFipsCodeCB.Items.add('127  Union');
     CountyFipsCodeCB.Items.add('129  Walworth');
     CountyFipsCodeCB.Items.add('135  Yankton');
     CountyFipsCodeCB.Items.add('137  Ziebach');
  end;{: South Dakota';}
43:Begin {TENNESSEE (TN) (47)}
     CountyFipsCodeCB.Items.add('001  Anderson');
     CountyFipsCodeCB.Items.add('003  Bedford');
     CountyFipsCodeCB.Items.add('005  Benton');
     CountyFipsCodeCB.Items.add('007  Bledsoe');
     CountyFipsCodeCB.Items.add('009  Blount');
     CountyFipsCodeCB.Items.add('011  Bradley');
     CountyFipsCodeCB.Items.add('013  Campbell');
     CountyFipsCodeCB.Items.add('015  Cannon');
     CountyFipsCodeCB.Items.add('017  Carroll');
     CountyFipsCodeCB.Items.add('019  Carter');
     CountyFipsCodeCB.Items.add('021  Cheatham');
     CountyFipsCodeCB.Items.add('023  Chester');
     CountyFipsCodeCB.Items.add('025  Claiborne');
     CountyFipsCodeCB.Items.add('027  Clay');
     CountyFipsCodeCB.Items.add('029  Cocke');
     CountyFipsCodeCB.Items.add('031  Coffee ');
     CountyFipsCodeCB.Items.add('033  Crockett');
     CountyFipsCodeCB.Items.add('035  Cumberland');
     CountyFipsCodeCB.Items.add('037  Davidson');
     CountyFipsCodeCB.Items.add('039  Decatur');
     CountyFipsCodeCB.Items.add('041  DeKalb*');
     CountyFipsCodeCB.Items.add('043  Dickson');
     CountyFipsCodeCB.Items.add('045  Dyer');
     CountyFipsCodeCB.Items.add('047  Fayette');
     CountyFipsCodeCB.Items.add('049  Fentress ');
     CountyFipsCodeCB.Items.add('051  Franklin');
     CountyFipsCodeCB.Items.add('053  Gibson');
     CountyFipsCodeCB.Items.add('055  Giles');
     CountyFipsCodeCB.Items.add('057  Grainger');
     CountyFipsCodeCB.Items.add('059  Greene ');
     CountyFipsCodeCB.Items.add('061  Grundy ');
     CountyFipsCodeCB.Items.add('063  Hamblen');
     CountyFipsCodeCB.Items.add('065  Hamilton ');
     CountyFipsCodeCB.Items.add('067  Hancock');
     CountyFipsCodeCB.Items.add('069  Hardeman');
     CountyFipsCodeCB.Items.add('071  Hardin');
     CountyFipsCodeCB.Items.add('073  Hawkins');
     CountyFipsCodeCB.Items.add('075  Haywood');
     CountyFipsCodeCB.Items.add('077  Henderson');
     CountyFipsCodeCB.Items.add('079  Henry');
     CountyFipsCodeCB.Items.add('081  Hickman');
     CountyFipsCodeCB.Items.add('083  Houston');
     CountyFipsCodeCB.Items.add('085  Humphreys');
     CountyFipsCodeCB.Items.add('087  Jackson');
     CountyFipsCodeCB.Items.add('089  Jefferson');
     CountyFipsCodeCB.Items.add('091  Johnson');
     CountyFipsCodeCB.Items.add('093  Knox');
     CountyFipsCodeCB.Items.add('095  Lake');
     CountyFipsCodeCB.Items.add('097  Lauderdale');
     CountyFipsCodeCB.Items.add('099  Lawrence');
     CountyFipsCodeCB.Items.add('101  Lewis');
     CountyFipsCodeCB.Items.add('103  Lincoln');
     CountyFipsCodeCB.Items.add('105  Loudon');
     CountyFipsCodeCB.Items.add('107  McMinn');
     CountyFipsCodeCB.Items.add('109  McNairy');
     CountyFipsCodeCB.Items.add('111  Macon');
     CountyFipsCodeCB.Items.add('113  Madison');
     CountyFipsCodeCB.Items.add('115  Marion');
     CountyFipsCodeCB.Items.add('117  Marshall');
     CountyFipsCodeCB.Items.add('119  Maury');
     CountyFipsCodeCB.Items.add('121  Meigs');
     CountyFipsCodeCB.Items.add('123  Monroe');
     CountyFipsCodeCB.Items.add('125  Montgomery');
     CountyFipsCodeCB.Items.add('127  Moore');
     CountyFipsCodeCB.Items.add('129  Morgan');
     CountyFipsCodeCB.Items.add('131  Obion');
     CountyFipsCodeCB.Items.add('133  Overton');
     CountyFipsCodeCB.Items.add('135  Perry');
     CountyFipsCodeCB.Items.add('137  Pickett');
     CountyFipsCodeCB.Items.add('139  Polk');
     CountyFipsCodeCB.Items.add('141  Putnam');
     CountyFipsCodeCB.Items.add('143  Rhea');
     CountyFipsCodeCB.Items.add('145  Roane');
     CountyFipsCodeCB.Items.add('147  Robertson');
     CountyFipsCodeCB.Items.add('149  Rutherford');
     CountyFipsCodeCB.Items.add('151  Scott');
     CountyFipsCodeCB.Items.add('153  Sequatchie');
     CountyFipsCodeCB.Items.add('155  Sevier');
     CountyFipsCodeCB.Items.add('157  Shelby');
     CountyFipsCodeCB.Items.add('159  Smith');
     CountyFipsCodeCB.Items.add('161  Stewart');
     CountyFipsCodeCB.Items.add('163  Sullivan');
     CountyFipsCodeCB.Items.add('165  Sumner');
     CountyFipsCodeCB.Items.add('167  Tipton');
     CountyFipsCodeCB.Items.add('169  Trousdale');
     CountyFipsCodeCB.Items.add('171  Unicoi');
     CountyFipsCodeCB.Items.add('173  Union');
     CountyFipsCodeCB.Items.add('175  Van Buren');
     CountyFipsCodeCB.Items.add('177  Warren');
     CountyFipsCodeCB.Items.add('179  Washington');
     CountyFipsCodeCB.Items.add('181  Wayne');
     CountyFipsCodeCB.Items.add('183  Weakley');
     CountyFipsCodeCB.Items.add('185  White');
     CountyFipsCodeCB.Items.add('187  Williamson');
     CountyFipsCodeCB.Items.add('189  Wilson');
  end;{: Tennessee';}
44:Begin {TEXAS (TX) (48)}
     CountyFipsCodeCB.Items.add('001  Anderson');
     CountyFipsCodeCB.Items.add('003  Andrews');
     CountyFipsCodeCB.Items.add('005  Angelina');
     CountyFipsCodeCB.Items.add('007  Aransas');
     CountyFipsCodeCB.Items.add('009  Archer');
     CountyFipsCodeCB.Items.add('011  Armstrong ');
     CountyFipsCodeCB.Items.add('013  Atascosa');
     CountyFipsCodeCB.Items.add('015  Austin');
     CountyFipsCodeCB.Items.add('017  Bailey ');
     CountyFipsCodeCB.Items.add('019  Bandera');
     CountyFipsCodeCB.Items.add('021  Bastrop');
     CountyFipsCodeCB.Items.add('023  Baylor');
     CountyFipsCodeCB.Items.add('025  Bee');
     CountyFipsCodeCB.Items.add('027  Bell');
     CountyFipsCodeCB.Items.add('029  Bexar');
     CountyFipsCodeCB.Items.add('031  Blanco');
     CountyFipsCodeCB.Items.add('033  Borden');
     CountyFipsCodeCB.Items.add('035  Bosque');
     CountyFipsCodeCB.Items.add('037  Bowie');
     CountyFipsCodeCB.Items.add('039  Brazoria');
     CountyFipsCodeCB.Items.add('041  Brazos');
     CountyFipsCodeCB.Items.add('043  Brewster');
     CountyFipsCodeCB.Items.add('045  Briscoe');
     CountyFipsCodeCB.Items.add('047  Brooks');
     CountyFipsCodeCB.Items.add('049  Brown');
     CountyFipsCodeCB.Items.add('051  Burleson');
     CountyFipsCodeCB.Items.add('053  Burnet');
     CountyFipsCodeCB.Items.add('055  Caldwell');
     CountyFipsCodeCB.Items.add('057  Calhoun');
     CountyFipsCodeCB.Items.add('059  Callahan');
     CountyFipsCodeCB.Items.add('061  Cameron');
     CountyFipsCodeCB.Items.add('063  Camp');
     CountyFipsCodeCB.Items.add('065  Carson');
     CountyFipsCodeCB.Items.add('067  Cass');
     CountyFipsCodeCB.Items.add('069  Castro');
     CountyFipsCodeCB.Items.add('071  Chambers');
     CountyFipsCodeCB.Items.add('073  Cherokee');
     CountyFipsCodeCB.Items.add('075  Childress');
     CountyFipsCodeCB.Items.add('077  Clay');
     CountyFipsCodeCB.Items.add('079  Cochran');
     CountyFipsCodeCB.Items.add('081  Coke');
     CountyFipsCodeCB.Items.add('083  Coleman');
     CountyFipsCodeCB.Items.add('085  Collin');
     CountyFipsCodeCB.Items.add('087  Collingsworth');
     CountyFipsCodeCB.Items.add('089  Colorado');
     CountyFipsCodeCB.Items.add('091  Comal');
     CountyFipsCodeCB.Items.add('093  Comanche');
     CountyFipsCodeCB.Items.add('095  Concho');
     CountyFipsCodeCB.Items.add('097  Cooke');
     CountyFipsCodeCB.Items.add('099  Coryell');
     CountyFipsCodeCB.Items.add('101  Cottle');
     CountyFipsCodeCB.Items.add('103  Crane');
     CountyFipsCodeCB.Items.add('105  Crockett');
     CountyFipsCodeCB.Items.add('107  Crosby');
     CountyFipsCodeCB.Items.add('109  Culberson');
     CountyFipsCodeCB.Items.add('111  Dallam');
     CountyFipsCodeCB.Items.add('113  Dallas');
     CountyFipsCodeCB.Items.add('115  Dawson');
     CountyFipsCodeCB.Items.add('117  Deaf Smith');
     CountyFipsCodeCB.Items.add('119  Delta');
     CountyFipsCodeCB.Items.add('121  Denton');
     CountyFipsCodeCB.Items.add('123  DeWitt*');
     CountyFipsCodeCB.Items.add('125  Dickens');
     CountyFipsCodeCB.Items.add('127  Dimmit');
     CountyFipsCodeCB.Items.add('129  Donley');
     CountyFipsCodeCB.Items.add('131  Duval');
     CountyFipsCodeCB.Items.add('133  Eastland');
     CountyFipsCodeCB.Items.add('135  Ector');
     CountyFipsCodeCB.Items.add('137  Edwards');
     CountyFipsCodeCB.Items.add('139  Ellis');
     CountyFipsCodeCB.Items.add('141  El Paso');
     CountyFipsCodeCB.Items.add('143  Erath');
     CountyFipsCodeCB.Items.add('145  Falls');
     CountyFipsCodeCB.Items.add('147  Fannin');
     CountyFipsCodeCB.Items.add('149  Fayette');
     CountyFipsCodeCB.Items.add('151  Fisher');
     CountyFipsCodeCB.Items.add('153  Floyd');
     CountyFipsCodeCB.Items.add('155  Foard');
     CountyFipsCodeCB.Items.add('157  Fort Bend');
     CountyFipsCodeCB.Items.add('159  Franklin');
     CountyFipsCodeCB.Items.add('161  Freestone');
     CountyFipsCodeCB.Items.add('163  Frio');
     CountyFipsCodeCB.Items.add('165  Gaines');
     CountyFipsCodeCB.Items.add('167  Galveston');
     CountyFipsCodeCB.Items.add('169  Garza');
     CountyFipsCodeCB.Items.add('171  Gillespie');
     CountyFipsCodeCB.Items.add('173  Glasscock');
     CountyFipsCodeCB.Items.add('175  Goliad');
     CountyFipsCodeCB.Items.add('177  Gonzales');
     CountyFipsCodeCB.Items.add('179  Gray');
     CountyFipsCodeCB.Items.add('181  Grayson');
     CountyFipsCodeCB.Items.add('183  Gregg');
     CountyFipsCodeCB.Items.add('185  Grimes');
     CountyFipsCodeCB.Items.add('187  Guadalupe');
     CountyFipsCodeCB.Items.add('189  Hale');
     CountyFipsCodeCB.Items.add('191  Hall');
     CountyFipsCodeCB.Items.add('193  Hamilton');
     CountyFipsCodeCB.Items.add('195  Hansford');
     CountyFipsCodeCB.Items.add('197  Hardeman');
     CountyFipsCodeCB.Items.add('199  Hardin');
     CountyFipsCodeCB.Items.add('201  Harris');
     CountyFipsCodeCB.Items.add('203  Harrison');
     CountyFipsCodeCB.Items.add('205  Hartley');
     CountyFipsCodeCB.Items.add('207  Haskell');
     CountyFipsCodeCB.Items.add('209  Hays');
     CountyFipsCodeCB.Items.add('211  Hemphill');
     CountyFipsCodeCB.Items.add('213  Henderson');
     CountyFipsCodeCB.Items.add('215  Hidalgo');
     CountyFipsCodeCB.Items.add('217  Hill');
     CountyFipsCodeCB.Items.add('219  Hockley');
     CountyFipsCodeCB.Items.add('221  Hood');
     CountyFipsCodeCB.Items.add('223  Hopkins');
     CountyFipsCodeCB.Items.add('225  Houston');
     CountyFipsCodeCB.Items.add('227  Howard');
     CountyFipsCodeCB.Items.add('229  Hudspeth');
     CountyFipsCodeCB.Items.add('231  Hunt');
     CountyFipsCodeCB.Items.add('233  Hutchinson');
     CountyFipsCodeCB.Items.add('235  Irion');
     CountyFipsCodeCB.Items.add('237  Jack');
     CountyFipsCodeCB.Items.add('239  Jackson');
     CountyFipsCodeCB.Items.add('241  Jasper');
     CountyFipsCodeCB.Items.add('243  Jeff Davis');
     CountyFipsCodeCB.Items.add('245  Jefferson');
     CountyFipsCodeCB.Items.add('247  Jim Hogg');
     CountyFipsCodeCB.Items.add('249  Jim Wells');
     CountyFipsCodeCB.Items.add('251  Johnson');
     CountyFipsCodeCB.Items.add('253  Jones');
     CountyFipsCodeCB.Items.add('255  Karnes');
     CountyFipsCodeCB.Items.add('257  Kaufman');
     CountyFipsCodeCB.Items.add('259  Kendall');
     CountyFipsCodeCB.Items.add('261  Kenedy');
     CountyFipsCodeCB.Items.add('263  Kent');
     CountyFipsCodeCB.Items.add('265  Kerr');
     CountyFipsCodeCB.Items.add('267  Kimble');
     CountyFipsCodeCB.Items.add('269  King');
     CountyFipsCodeCB.Items.add('271  Kinney');
     CountyFipsCodeCB.Items.add('273  Kleberg');
     CountyFipsCodeCB.Items.add('275  Knox');
     CountyFipsCodeCB.Items.add('277  Lamar');
     CountyFipsCodeCB.Items.add('279  Lamb');
     CountyFipsCodeCB.Items.add('281  Lampasas');
     CountyFipsCodeCB.Items.add('283  La Salle');
     CountyFipsCodeCB.Items.add('285  Lavaca');
     CountyFipsCodeCB.Items.add('287  Lee');
     CountyFipsCodeCB.Items.add('289  Leon');
     CountyFipsCodeCB.Items.add('291  Liberty');
     CountyFipsCodeCB.Items.add('293  Limestone');
     CountyFipsCodeCB.Items.add('295  Lipscomb');
     CountyFipsCodeCB.Items.add('297  Live Oak');
     CountyFipsCodeCB.Items.add('299  Llano');
     CountyFipsCodeCB.Items.add('301  Loving');
     CountyFipsCodeCB.Items.add('303  Lubbock');
     CountyFipsCodeCB.Items.add('305  Lynn');
     CountyFipsCodeCB.Items.add('307  McCulloch');
     CountyFipsCodeCB.Items.add('309  McLennan');
     CountyFipsCodeCB.Items.add('311  McMullen');
     CountyFipsCodeCB.Items.add('313  Madison');
     CountyFipsCodeCB.Items.add('315  Marion');
     CountyFipsCodeCB.Items.add('317  Martin');
     CountyFipsCodeCB.Items.add('319  Mason');
     CountyFipsCodeCB.Items.add('321  Matagorda');
     CountyFipsCodeCB.Items.add('323  Maverick');
     CountyFipsCodeCB.Items.add('325  Medina');
     CountyFipsCodeCB.Items.add('327  Menard');
     CountyFipsCodeCB.Items.add('329  Midland');
     CountyFipsCodeCB.Items.add('331  Milam');
     CountyFipsCodeCB.Items.add('333  Mills');
     CountyFipsCodeCB.Items.add('335  Mitchell');
     CountyFipsCodeCB.Items.add('337  Montague');
     CountyFipsCodeCB.Items.add('339  Montgomery');
     CountyFipsCodeCB.Items.add('341  Moore');
     CountyFipsCodeCB.Items.add('343  Morris');
     CountyFipsCodeCB.Items.add('345  Motley');
     CountyFipsCodeCB.Items.add('347  Nacogdoches');
     CountyFipsCodeCB.Items.add('349  Navarro');
     CountyFipsCodeCB.Items.add('351  Newton');
     CountyFipsCodeCB.Items.add('353  Nolan');
     CountyFipsCodeCB.Items.add('355  Nueces');
     CountyFipsCodeCB.Items.add('357  Ochiltree');
     CountyFipsCodeCB.Items.add('359  Oldham');
     CountyFipsCodeCB.Items.add('361  Orange');
     CountyFipsCodeCB.Items.add('363  Palo Pinto');
     CountyFipsCodeCB.Items.add('365  Panola');
     CountyFipsCodeCB.Items.add('367  Parker');
     CountyFipsCodeCB.Items.add('369  Parmer');
     CountyFipsCodeCB.Items.add('371  Pecos');
     CountyFipsCodeCB.Items.add('373  Polk');
     CountyFipsCodeCB.Items.add('375  Potter');
     CountyFipsCodeCB.Items.add('377  Presidio');
     CountyFipsCodeCB.Items.add('379  Rains');
     CountyFipsCodeCB.Items.add('381  Randall');
     CountyFipsCodeCB.Items.add('383  Reagan');
     CountyFipsCodeCB.Items.add('385  Real');
     CountyFipsCodeCB.Items.add('387  Red River');
     CountyFipsCodeCB.Items.add('389  Reeves');
     CountyFipsCodeCB.Items.add('391  Refugio');
     CountyFipsCodeCB.Items.add('393  Roberts');
     CountyFipsCodeCB.Items.add('395  Robertson');
     CountyFipsCodeCB.Items.add('397  Rockwall');
     CountyFipsCodeCB.Items.add('399  Runnels');
     CountyFipsCodeCB.Items.add('401  Rusk');
     CountyFipsCodeCB.Items.add('403  Sabine');
     CountyFipsCodeCB.Items.add('405  San Augustine');
     CountyFipsCodeCB.Items.add('407  San Jacinto');
     CountyFipsCodeCB.Items.add('409  San Patricio');
     CountyFipsCodeCB.Items.add('411  San Saba');
     CountyFipsCodeCB.Items.add('413  Schleicher');
     CountyFipsCodeCB.Items.add('415  Scurry');
     CountyFipsCodeCB.Items.add('417  Shackelford');
     CountyFipsCodeCB.Items.add('419  Shelby');
     CountyFipsCodeCB.Items.add('421  Sherman');
     CountyFipsCodeCB.Items.add('423  Smith');
     CountyFipsCodeCB.Items.add('425  Somervell');
     CountyFipsCodeCB.Items.add('427  Starr');
     CountyFipsCodeCB.Items.add('429  Stephens');
     CountyFipsCodeCB.Items.add('431  Sterling');
     CountyFipsCodeCB.Items.add('433  Stonewall');
     CountyFipsCodeCB.Items.add('435  Sutton');
     CountyFipsCodeCB.Items.add('437  Swisher');
     CountyFipsCodeCB.Items.add('439  Tarrant');
     CountyFipsCodeCB.Items.add('441  Taylor');
     CountyFipsCodeCB.Items.add('443  Terrell');
     CountyFipsCodeCB.Items.add('445  Terry');
     CountyFipsCodeCB.Items.add('447  Throckmorton');
     CountyFipsCodeCB.Items.add('449  Titus');
     CountyFipsCodeCB.Items.add('451  Tom Green');
     CountyFipsCodeCB.Items.add('453  Travis');
     CountyFipsCodeCB.Items.add('455  Trinity');
     CountyFipsCodeCB.Items.add('457  Tyler');
     CountyFipsCodeCB.Items.add('459  Upshur');
     CountyFipsCodeCB.Items.add('461  Upton');
     CountyFipsCodeCB.Items.add('463  Uvalde');
     CountyFipsCodeCB.Items.add('465  Val Verde');
     CountyFipsCodeCB.Items.add('467  Van Zandt');
     CountyFipsCodeCB.Items.add('469  Victoria');
     CountyFipsCodeCB.Items.add('471  Walker');
     CountyFipsCodeCB.Items.add('473  Waller');
     CountyFipsCodeCB.Items.add('475  Ward');
     CountyFipsCodeCB.Items.add('477  Washington');
     CountyFipsCodeCB.Items.add('479  Webb');
     CountyFipsCodeCB.Items.add('481  Wharton');
     CountyFipsCodeCB.Items.add('483  Wheeler');
     CountyFipsCodeCB.Items.add('485  Wichita');
     CountyFipsCodeCB.Items.add('487  Wilbarger');
     CountyFipsCodeCB.Items.add('489  Willacy');
     CountyFipsCodeCB.Items.add('491  Williamson');
     CountyFipsCodeCB.Items.add('493  Wilson');
     CountyFipsCodeCB.Items.add('495  Winkler');
     CountyFipsCodeCB.Items.add('497  Wise');
     CountyFipsCodeCB.Items.add('499  Wood');
     CountyFipsCodeCB.Items.add('501  Yoakum');
     CountyFipsCodeCB.Items.add('503  Young');
     CountyFipsCodeCB.Items.add('505  Zapata');
     CountyFipsCodeCB.Items.add('507  Zavala');
  end;{: Texas';}
45:Begin {UTAH (UT) (49)}
     CountyFipsCodeCB.Items.add('001  Beaver');
     CountyFipsCodeCB.Items.add('003  Box Elder');
     CountyFipsCodeCB.Items.add('005  Cache');
     CountyFipsCodeCB.Items.add('007  Carbon');
     CountyFipsCodeCB.Items.add('009  Daggett');
     CountyFipsCodeCB.Items.add('011  Davis');
     CountyFipsCodeCB.Items.add('013  Duchesne');
     CountyFipsCodeCB.Items.add('015  Emery');
     CountyFipsCodeCB.Items.add('017  Garfield');
     CountyFipsCodeCB.Items.add('019  Grand ');
     CountyFipsCodeCB.Items.add('021  Iron');
     CountyFipsCodeCB.Items.add('023  Juab');
     CountyFipsCodeCB.Items.add('025  Kane');
     CountyFipsCodeCB.Items.add('027  Millard');
     CountyFipsCodeCB.Items.add('029  Morgan');
     CountyFipsCodeCB.Items.add('031  Piute');
     CountyFipsCodeCB.Items.add('031  Piute');
     CountyFipsCodeCB.Items.add('035  Salt Lake');
     CountyFipsCodeCB.Items.add('037  San Juan');
     CountyFipsCodeCB.Items.add('039  Sanpete');
     CountyFipsCodeCB.Items.add('041  Sevier');
     CountyFipsCodeCB.Items.add('043  Summit');
     CountyFipsCodeCB.Items.add('045  Tooele');
     CountyFipsCodeCB.Items.add('047  Uintah');
     CountyFipsCodeCB.Items.add('049  Utah');
     CountyFipsCodeCB.Items.add('051  Wasatch');
     CountyFipsCodeCB.Items.add('053  Washington');
     CountyFipsCodeCB.Items.add('055  Wayne');
     CountyFipsCodeCB.Items.add('057   Weber');
  end;{: Utah';}
46:Begin {VERMONT (VT) (50)}
     CountyFipsCodeCB.Items.add('001  Addison');
     CountyFipsCodeCB.Items.add('003  Bennington');
     CountyFipsCodeCB.Items.add('005  Caledonia');
     CountyFipsCodeCB.Items.add('007  Chittenden');
     CountyFipsCodeCB.Items.add('009  Essex');
     CountyFipsCodeCB.Items.add('011  Franklin');
     CountyFipsCodeCB.Items.add('013  Grand Isle');
     CountyFipsCodeCB.Items.add('015  Lamoille');
     CountyFipsCodeCB.Items.add('017  Orange');
     CountyFipsCodeCB.Items.add('019  Orleans');
     CountyFipsCodeCB.Items.add('021  Rutland');
     CountyFipsCodeCB.Items.add('023  Washington');
     CountyFipsCodeCB.Items.add('025  Windham');
     CountyFipsCodeCB.Items.add('027  Windsor');
  end;{: Vermont';}
47:Begin {VIRGINIA (VA) (51)}
     CountyFipsCodeCB.Items.add('001   Accomack');
     CountyFipsCodeCB.Items.add('003  Albemarle');
     CountyFipsCodeCB.Items.add('005  Alleghany');
     CountyFipsCodeCB.Items.add('007  Amelia');
     CountyFipsCodeCB.Items.add('009  Amherst');
     CountyFipsCodeCB.Items.add('011  Appomattox');
     CountyFipsCodeCB.Items.add('013  Arlington');
     CountyFipsCodeCB.Items.add('015  Augusta');
     CountyFipsCodeCB.Items.add('017  Bath');
     CountyFipsCodeCB.Items.add('019  Bedford');
     CountyFipsCodeCB.Items.add('021  Bland');
     CountyFipsCodeCB.Items.add('023  Botetourt');
     CountyFipsCodeCB.Items.add('025  Brunswick');
     CountyFipsCodeCB.Items.add('027  Buchanan');
     CountyFipsCodeCB.Items.add('029  Buckingham');
     CountyFipsCodeCB.Items.add('031  Campbell');
     CountyFipsCodeCB.Items.add('033  Caroline');
     CountyFipsCodeCB.Items.add('035  Carroll');
     CountyFipsCodeCB.Items.add('036* Charles City');
     CountyFipsCodeCB.Items.add('037* Charlotte');
     CountyFipsCodeCB.Items.add('041  Chesterfield');
     CountyFipsCodeCB.Items.add('043  Clarke');
     CountyFipsCodeCB.Items.add('045  Craig');
     CountyFipsCodeCB.Items.add('047  Culpeper');
     CountyFipsCodeCB.Items.add('049  Cumberland');
     CountyFipsCodeCB.Items.add('051  Dickenson');
     CountyFipsCodeCB.Items.add('053  Dinwiddie');
     CountyFipsCodeCB.Items.add('057  Essex');
     CountyFipsCodeCB.Items.add('059  Fairfax');
     CountyFipsCodeCB.Items.add('061  Fauquier');
     CountyFipsCodeCB.Items.add('063  Floyd');
     CountyFipsCodeCB.Items.add('065  Fluvanna');
     CountyFipsCodeCB.Items.add('067  Franklin');
     CountyFipsCodeCB.Items.add('069  Frederick');
     CountyFipsCodeCB.Items.add('071  Giles');
     CountyFipsCodeCB.Items.add('073  Gloucester');
     CountyFipsCodeCB.Items.add('075  Goochland');
     CountyFipsCodeCB.Items.add('077  Grayson');
     CountyFipsCodeCB.Items.add('079  Greene');
     CountyFipsCodeCB.Items.add('081  Greensville');
     CountyFipsCodeCB.Items.add('083  Halifax');
     CountyFipsCodeCB.Items.add('085  Hanover');
     CountyFipsCodeCB.Items.add('087  Henrico');
     CountyFipsCodeCB.Items.add('089  Henry');
     CountyFipsCodeCB.Items.add('091  Highland');
     CountyFipsCodeCB.Items.add('093  Isle of Wight');
     CountyFipsCodeCB.Items.add('095  James City');
     CountyFipsCodeCB.Items.add('097  King and Queen');
     CountyFipsCodeCB.Items.add('099  King George');
     CountyFipsCodeCB.Items.add('101  King William');
     CountyFipsCodeCB.Items.add('103  Lancaster');
     CountyFipsCodeCB.Items.add('105  Lee');
     CountyFipsCodeCB.Items.add('107  Loudoun');
     CountyFipsCodeCB.Items.add('109  Louisa');
     CountyFipsCodeCB.Items.add('111  Lunenburg');
     CountyFipsCodeCB.Items.add('113  Madison');
     CountyFipsCodeCB.Items.add('115  Mathews');
     CountyFipsCodeCB.Items.add('117  Mecklenburg');
     CountyFipsCodeCB.Items.add('119  Middlesex');
     CountyFipsCodeCB.Items.add('121  Montgomery');
     CountyFipsCodeCB.Items.add('125  Nelson');
     CountyFipsCodeCB.Items.add('127  New Kent');
     CountyFipsCodeCB.Items.add('131  Northampton');
     CountyFipsCodeCB.Items.add('133  Northumberland');
     CountyFipsCodeCB.Items.add('135  Nottoway');
     CountyFipsCodeCB.Items.add('137  Orange');
     CountyFipsCodeCB.Items.add('139  Page');
     CountyFipsCodeCB.Items.add('141  Patrick');
     CountyFipsCodeCB.Items.add('143  Pittsylvania');
     CountyFipsCodeCB.Items.add('145  Powhatan');
     CountyFipsCodeCB.Items.add('147  Prince Edward');
     CountyFipsCodeCB.Items.add('149  Prince George');
     CountyFipsCodeCB.Items.add('153  Prince William');
     CountyFipsCodeCB.Items.add('155  Pulaski');
     CountyFipsCodeCB.Items.add('157  Rappahannock');
     CountyFipsCodeCB.Items.add('159  Richmond');
     CountyFipsCodeCB.Items.add('161  Roanoke');
     CountyFipsCodeCB.Items.add('163  Rockbridge');
     CountyFipsCodeCB.Items.add('165  Rockingham');
     CountyFipsCodeCB.Items.add('167  Russell');
     CountyFipsCodeCB.Items.add('169  Scott');
     CountyFipsCodeCB.Items.add('171  Shenandoah');
     CountyFipsCodeCB.Items.add('173  Smyth');
     CountyFipsCodeCB.Items.add('175  Southampton');
     CountyFipsCodeCB.Items.add('177  Spotsylvania');
     CountyFipsCodeCB.Items.add('179  Stafford');
     CountyFipsCodeCB.Items.add('181  Surry');
     CountyFipsCodeCB.Items.add('183  Sussex');
     CountyFipsCodeCB.Items.add('185  Tazewell');
     CountyFipsCodeCB.Items.add('187  Warren');
     CountyFipsCodeCB.Items.add('191  Washington');
     CountyFipsCodeCB.Items.add('193  Westmoreland');
     CountyFipsCodeCB.Items.add('195  Wise');
     CountyFipsCodeCB.Items.add('197  Wythe');
     CountyFipsCodeCB.Items.add('199  York');
      {INDEPENDENT CITIES of Virginia}
     CountyFipsCodeCB.Items.add('510  Alexandria (city)');
     CountyFipsCodeCB.Items.add('515  Bedford (city)');
     CountyFipsCodeCB.Items.add('520  Bristol (city)');
     CountyFipsCodeCB.Items.add('530  Buena Vista (city)');
     CountyFipsCodeCB.Items.add('540  Charlottesville (city)');
     CountyFipsCodeCB.Items.add('550  Chesapeake (city)');
     CountyFipsCodeCB.Items.add('560  Clifton Forge (city)');
     CountyFipsCodeCB.Items.add('570  Colonial Heights (city)');
     CountyFipsCodeCB.Items.add('580  Covington (city)');
     CountyFipsCodeCB.Items.add('590  Danville (city)');
     CountyFipsCodeCB.Items.add('595  Emporia (city)');
     CountyFipsCodeCB.Items.add('600  Fairfax (city)');
     CountyFipsCodeCB.Items.add('610  Falls Church (city)');
     CountyFipsCodeCB.Items.add('620  Franklin (city)');
     CountyFipsCodeCB.Items.add('630  Fredericksburg (city)');
     CountyFipsCodeCB.Items.add('640  Galax (city)');
     CountyFipsCodeCB.Items.add('650  Hampton (city)');
     CountyFipsCodeCB.Items.add('660  Harrisonburg (city)');
     CountyFipsCodeCB.Items.add('670  Hopewell (city)');
     CountyFipsCodeCB.Items.add('678  Lexington (city)');
     CountyFipsCodeCB.Items.add('680  Lynchburg (city)');
     CountyFipsCodeCB.Items.add('683  Manassas (city)');
     CountyFipsCodeCB.Items.add('685  Manassas Park (city)');
     CountyFipsCodeCB.Items.add('690  Martinsville (city)');
     CountyFipsCodeCB.Items.add('700  Newport News (city)');
     CountyFipsCodeCB.Items.add('710  Norfolk (city)');
     CountyFipsCodeCB.Items.add('720  Norton (city)');
     CountyFipsCodeCB.Items.add('730  Petersburg (city)');
     CountyFipsCodeCB.Items.add('735  Poquoson (city)');
     CountyFipsCodeCB.Items.add('740  Portsmouth (city)');
     CountyFipsCodeCB.Items.add('750  Radford (city)');
     CountyFipsCodeCB.Items.add('760  Richmond (city)');
     CountyFipsCodeCB.Items.add('770  Roanoke (city)');
     CountyFipsCodeCB.Items.add('775  Salem (city)');
     CountyFipsCodeCB.Items.add('780  South Boston (city)');
     CountyFipsCodeCB.Items.add('790   Staunton (city)');
     CountyFipsCodeCB.Items.add('800  Suffolk (city)');
     CountyFipsCodeCB.Items.add('810  Virginia Beach (city)');
     CountyFipsCodeCB.Items.add('820  Waynesboro (city)');
     CountyFipsCodeCB.Items.add('830  Williamsburg (city)');
     CountyFipsCodeCB.Items.add('840  Winchester (city)');
  end;{: Virginia';}
48:Begin {WASHINGTON (WA) (53)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Asotin');
     CountyFipsCodeCB.Items.add('005  Benton');
     CountyFipsCodeCB.Items.add('007  Chelan');
     CountyFipsCodeCB.Items.add('009  Clallam');
     CountyFipsCodeCB.Items.add('011  Clark');
     CountyFipsCodeCB.Items.add('013  Columbia');
     CountyFipsCodeCB.Items.add('015  Cowlitz');
     CountyFipsCodeCB.Items.add('017  Douglas');
     CountyFipsCodeCB.Items.add('019  Ferry ');
     CountyFipsCodeCB.Items.add('021  Franklin');
     CountyFipsCodeCB.Items.add('023  Garfield');
     CountyFipsCodeCB.Items.add('025  Grant');
     CountyFipsCodeCB.Items.add('027  Grays Harbor');
     CountyFipsCodeCB.Items.add('029  Island');
     CountyFipsCodeCB.Items.add('031  Jefferson');
     CountyFipsCodeCB.Items.add('033  King');
     CountyFipsCodeCB.Items.add('035  Kitsap');
     CountyFipsCodeCB.Items.add('037  Kittitas');
     CountyFipsCodeCB.Items.add('039  Klickitat');
     CountyFipsCodeCB.Items.add('041  Lewis');
     CountyFipsCodeCB.Items.add('043  Lincoln');
     CountyFipsCodeCB.Items.add('045  Mason');
     CountyFipsCodeCB.Items.add('047  Okanogan');
     CountyFipsCodeCB.Items.add('049  Pacific');
     CountyFipsCodeCB.Items.add('051  Pend Oreille');
     CountyFipsCodeCB.Items.add('053  Pierce');
     CountyFipsCodeCB.Items.add('055  San Juan');
     CountyFipsCodeCB.Items.add('057  Skagit');
     CountyFipsCodeCB.Items.add('059  Skamania');
     CountyFipsCodeCB.Items.add('061  Snohomish');
     CountyFipsCodeCB.Items.add('063  Spokane');
     CountyFipsCodeCB.Items.add('065  Stevens');
     CountyFipsCodeCB.Items.add('067  Thurston');
     CountyFipsCodeCB.Items.add('069  Wahkiakum');
     CountyFipsCodeCB.Items.add('071  Walla Walla');
     CountyFipsCodeCB.Items.add('073  Whatcom');
     CountyFipsCodeCB.Items.add('075  Whitman');
     CountyFipsCodeCB.Items.add('077  Yakima');
  end;{: Washington';}
49:Begin {WEST VIRGINIA (WV) (54)}
     CountyFipsCodeCB.Items.add('001  Barbour');
     CountyFipsCodeCB.Items.add('003  Berkeley');
     CountyFipsCodeCB.Items.add('005  Boone');
     CountyFipsCodeCB.Items.add('007  Braxton');
     CountyFipsCodeCB.Items.add('009  Brooke');
     CountyFipsCodeCB.Items.add('011  Cabell');
     CountyFipsCodeCB.Items.add('013  Calhoun');
     CountyFipsCodeCB.Items.add('015  Clay');
     CountyFipsCodeCB.Items.add('017  Doddridge');
     CountyFipsCodeCB.Items.add('019  Fayette');
     CountyFipsCodeCB.Items.add('021  Gilmer');
     CountyFipsCodeCB.Items.add('023  Grant');
     CountyFipsCodeCB.Items.add('025  Greenbrier');
     CountyFipsCodeCB.Items.add('027  Hampshire');
     CountyFipsCodeCB.Items.add('029  Hancock');
     CountyFipsCodeCB.Items.add('031  Hardy');
     CountyFipsCodeCB.Items.add('033  Harrison');
     CountyFipsCodeCB.Items.add('035  Jackson');
     CountyFipsCodeCB.Items.add('037  Jefferson');
     CountyFipsCodeCB.Items.add('039  Kanawha');
     CountyFipsCodeCB.Items.add('041  Lewis');
     CountyFipsCodeCB.Items.add('043  Lincoln');
     CountyFipsCodeCB.Items.add('045  Logan');
     CountyFipsCodeCB.Items.add('047  McDowell');
     CountyFipsCodeCB.Items.add('049  Marion');
     CountyFipsCodeCB.Items.add('051  Marshall');
     CountyFipsCodeCB.Items.add('053  Mason');
     CountyFipsCodeCB.Items.add('055  Mercer');
     CountyFipsCodeCB.Items.add('057  Mineral');
     CountyFipsCodeCB.Items.add('059  Mingo');
     CountyFipsCodeCB.Items.add('061  Monongalia');
     CountyFipsCodeCB.Items.add('063  Monroe');
     CountyFipsCodeCB.Items.add('065  Morgan');
     CountyFipsCodeCB.Items.add('067  Nicholas');
     CountyFipsCodeCB.Items.add('069  Ohio');
     CountyFipsCodeCB.Items.add('071  Pendleton');
     CountyFipsCodeCB.Items.add('073  Pleasants');
     CountyFipsCodeCB.Items.add('075  Pocahontas');
     CountyFipsCodeCB.Items.add('077  Preston');
     CountyFipsCodeCB.Items.add('079  Putnam');
     CountyFipsCodeCB.Items.add('081  Raleigh');
     CountyFipsCodeCB.Items.add('083  Randolph');
     CountyFipsCodeCB.Items.add('085  Ritchie');
     CountyFipsCodeCB.Items.add('087  Roane');
     CountyFipsCodeCB.Items.add('089  Summers');
     CountyFipsCodeCB.Items.add('091  Taylor');
     CountyFipsCodeCB.Items.add('093  Tucker');
     CountyFipsCodeCB.Items.add('095  Tyler');
     CountyFipsCodeCB.Items.add('097  Upshur');
     CountyFipsCodeCB.Items.add('099  Wayne');
     CountyFipsCodeCB.Items.add('101  Webster');
     CountyFipsCodeCB.Items.add('103  Wetzel');
     CountyFipsCodeCB.Items.add('105  Wirt');
     CountyFipsCodeCB.Items.add('107  Wood');
     CountyFipsCodeCB.Items.add('109  Wyoming');
  end;{: West Virginia';}
50:Begin {WISCONSIN (WI) (55)}
     CountyFipsCodeCB.Items.add('001  Adams');
     CountyFipsCodeCB.Items.add('003  Ashland');
     CountyFipsCodeCB.Items.add('005  Barron');
     CountyFipsCodeCB.Items.add('007  Bayfield');
     CountyFipsCodeCB.Items.add('009  Brown');
     CountyFipsCodeCB.Items.add('011  Buffalo');
     CountyFipsCodeCB.Items.add('013  Burnett');
     CountyFipsCodeCB.Items.add('015  Calumet');
     CountyFipsCodeCB.Items.add('017  Chippewa');
     CountyFipsCodeCB.Items.add('019  Clark');
     CountyFipsCodeCB.Items.add('021  Columbia');
     CountyFipsCodeCB.Items.add('023  Crawford');
     CountyFipsCodeCB.Items.add('025  Dane');
     CountyFipsCodeCB.Items.add('027  Dodge');
     CountyFipsCodeCB.Items.add('029  Door');
     CountyFipsCodeCB.Items.add('031  Douglas');
     CountyFipsCodeCB.Items.add('033  Dunn');
     CountyFipsCodeCB.Items.add('035  Eau Claire');
     CountyFipsCodeCB.Items.add('037  Florence');
     CountyFipsCodeCB.Items.add('039  Fond du Lac');
     CountyFipsCodeCB.Items.add('041  Forest');
     CountyFipsCodeCB.Items.add('043  Grant');
     CountyFipsCodeCB.Items.add('045  Green');
     CountyFipsCodeCB.Items.add('047  Green Lake');
     CountyFipsCodeCB.Items.add('049  Iowa');
     CountyFipsCodeCB.Items.add('051  Iron');
     CountyFipsCodeCB.Items.add('053  Jackson');
     CountyFipsCodeCB.Items.add('055  Jefferson');
     CountyFipsCodeCB.Items.add('057  Juneau');
     CountyFipsCodeCB.Items.add('059  Kenosha');
     CountyFipsCodeCB.Items.add('061 Kewaunee');
     CountyFipsCodeCB.Items.add('063  La Crosse');
     CountyFipsCodeCB.Items.add('065  Lafayette');
     CountyFipsCodeCB.Items.add('067  Langlade');
     CountyFipsCodeCB.Items.add('069  Lincoln');
     CountyFipsCodeCB.Items.add('071  Manitowoc');
     CountyFipsCodeCB.Items.add('073  Marathon');
     CountyFipsCodeCB.Items.add('075  Marinette');
     CountyFipsCodeCB.Items.add('077  Marquette');
     CountyFipsCodeCB.Items.add('078  Menominee');
     CountyFipsCodeCB.Items.add('079  Milwaukee');
     CountyFipsCodeCB.Items.add('081  Monroe');
     CountyFipsCodeCB.Items.add('083  Oconto');
     CountyFipsCodeCB.Items.add('085  Oneida');
     CountyFipsCodeCB.Items.add('087  Outagamie');
     CountyFipsCodeCB.Items.add('089  Ozaukee');
     CountyFipsCodeCB.Items.add('091  Pepin');
     CountyFipsCodeCB.Items.add('093  Pierce');
     CountyFipsCodeCB.Items.add('095  Polk');
     CountyFipsCodeCB.Items.add('097  Portage');
     CountyFipsCodeCB.Items.add('099  Price');
     CountyFipsCodeCB.Items.add('101  Racine');
     CountyFipsCodeCB.Items.add('103  Richland');
     CountyFipsCodeCB.Items.add('105  Rock');
     CountyFipsCodeCB.Items.add('107  Rusk');
     CountyFipsCodeCB.Items.add('109  St. Croix');
     CountyFipsCodeCB.Items.add('111  Sauk');
     CountyFipsCodeCB.Items.add('113  Sawyer');
     CountyFipsCodeCB.Items.add('115  Shawano');
     CountyFipsCodeCB.Items.add('117  Sheboygan');
     CountyFipsCodeCB.Items.add('119  Taylor');
     CountyFipsCodeCB.Items.add('121  Trempealeau');
     CountyFipsCodeCB.Items.add('123  Vernon');
     CountyFipsCodeCB.Items.add('125  Vilas');
     CountyFipsCodeCB.Items.add('127  Walworth');
     CountyFipsCodeCB.Items.add('129  Washburn');
     CountyFipsCodeCB.Items.add('131  Washington');
     CountyFipsCodeCB.Items.add('133  Waukesha');
     CountyFipsCodeCB.Items.add('135  Waupaca');
     CountyFipsCodeCB.Items.add('137  Waushara');
     CountyFipsCodeCB.Items.add('139  Winnebago');
     CountyFipsCodeCB.Items.add('141  Wood');
  end;{: Wisconsin';}
51:Begin {WYOMING (WY) (56)}
     CountyFipsCodeCB.Items.add('001  Albany');
     CountyFipsCodeCB.Items.add('003  Big Horn');
     CountyFipsCodeCB.Items.add('005  Campbell');
     CountyFipsCodeCB.Items.add('007  Carbon');
     CountyFipsCodeCB.Items.add('009  Converse');
     CountyFipsCodeCB.Items.add('011  Crook');
     CountyFipsCodeCB.Items.add('013  Fremont');
     CountyFipsCodeCB.Items.add('015  Goshen');
     CountyFipsCodeCB.Items.add('017  Hot Springs');
     CountyFipsCodeCB.Items.add('019  Johnson');
     CountyFipsCodeCB.Items.add('021  Laramie');
     CountyFipsCodeCB.Items.add('023  Lincoln');
     CountyFipsCodeCB.Items.add('025  Natrona');
     CountyFipsCodeCB.Items.add('027  Niobrara');
     CountyFipsCodeCB.Items.add('029  Park');
     CountyFipsCodeCB.Items.add('031  Platte');
     CountyFipsCodeCB.Items.add('033  Sheridan');
     CountyFipsCodeCB.Items.add('035  Sublette');
     CountyFipsCodeCB.Items.add('037  Sweetwater');
     CountyFipsCodeCB.Items.add('039  Teton');
     CountyFipsCodeCB.Items.add('041  Uinta');
     CountyFipsCodeCB.Items.add('043  Washakie');
     CountyFipsCodeCB.Items.add('045  Weston');
  end;{: Wyoming';}
52:Begin {AMERICA SAMOA (AS) (60)}
     CountyFipsCodeCB.Items.add('010  Eastern (District)');
     CountyFipsCodeCB.Items.add('020  Manu`a (District)');
     CountyFipsCodeCB.Items.add('030  Rose Island');
     CountyFipsCodeCB.Items.add('040  Swains Island');
     CountyFipsCodeCB.Items.add('050  Western (District)');
{(District/Island Names are used instead of County Names)}
  end;{: American Samoa';}
53:Begin {GUAM (GU) (66)}
     CountyFipsCodeCB.Items.add('010  Guam');
  end;{: Guam';}
54:Begin {NORTHERN MARIANA ISLANDS (MP) (69)}
     CountyFipsCodeCB.Items.add('085 Northern Islands');
     CountyFipsCodeCB.Items.add('100 Rota');
     CountyFipsCodeCB.Items.add('110 Saipan');
     CountyFipsCodeCB.Items.add('120 Tinian');
{(Municipality Names are used instead of County Names.)}
  end;{: Northern Mariana Islands';}
55:Begin {PALAU (PW) (70)}
     CountyFipsCodeCB.Items.add('002  Aimeliik');
     CountyFipsCodeCB.Items.add('004  Airai');
     CountyFipsCodeCB.Items.add('212  Melekeok*');
     CountyFipsCodeCB.Items.add('214  Ngaraard');
     CountyFipsCodeCB.Items.add('227* Ngernmlengui*');
     CountyFipsCodeCB.Items.add('228  Ngiwal');
  end;{: Palau';}
56:Begin {PUERTO RICO (PR) (72)}
     {(Municipio Names are used instead of County Names.)}
     CountyFipsCodeCB.Items.add('001  Adjuntas');
     CountyFipsCodeCB.Items.add('003  Aguada');
     CountyFipsCodeCB.Items.add('005  Aguadilla');
     CountyFipsCodeCB.Items.add('007  Aguas Buenas');
     CountyFipsCodeCB.Items.add('009  Aibonito');
     CountyFipsCodeCB.Items.add('011  Anasco');
     CountyFipsCodeCB.Items.add('013  Arecibo');
     CountyFipsCodeCB.Items.add('015  Arroyo');
     CountyFipsCodeCB.Items.add('017  Barceloneta');
     CountyFipsCodeCB.Items.add('019  Barranquitas');
     CountyFipsCodeCB.Items.add('021  Bayamo`n');
     CountyFipsCodeCB.Items.add('023  Cabo Rojo');
     CountyFipsCodeCB.Items.add('025  Caguas');
     CountyFipsCodeCB.Items.add('027  Camuy');
     CountyFipsCodeCB.Items.add('029  Canovanas');
     CountyFipsCodeCB.Items.add('031  Carolina');
     CountyFipsCodeCB.Items.add('033  Catano');
     CountyFipsCodeCB.Items.add('035  Cayey');
     CountyFipsCodeCB.Items.add('037  Ceiba');
     CountyFipsCodeCB.Items.add('039  Ciales');
     CountyFipsCodeCB.Items.add('041  Cidra');
     CountyFipsCodeCB.Items.add('043  Coamo');
     CountyFipsCodeCB.Items.add('045  Comerio');
     CountyFipsCodeCB.Items.add('047  Corozal');
     CountyFipsCodeCB.Items.add('049  Culebra');
     CountyFipsCodeCB.Items.add('051  Dorado');
     CountyFipsCodeCB.Items.add('053  Fajardo');
     CountyFipsCodeCB.Items.add('054  Florida');
     CountyFipsCodeCB.Items.add('055  Guanica');
     CountyFipsCodeCB.Items.add('057  Guayama');
     CountyFipsCodeCB.Items.add('059  Guayanilla');
     CountyFipsCodeCB.Items.add('061  Guaynabo');
     CountyFipsCodeCB.Items.add('063  Gurabo');
     CountyFipsCodeCB.Items.add('065  Hatillo');
     CountyFipsCodeCB.Items.add('067  Hormigueros');
     CountyFipsCodeCB.Items.add('069  Humacao');
     CountyFipsCodeCB.Items.add('071  lsabela');
     CountyFipsCodeCB.Items.add('073  Jayuya');
     CountyFipsCodeCB.Items.add('075  Juana Diaz');
     CountyFipsCodeCB.Items.add('077  Juncos');
     CountyFipsCodeCB.Items.add('079  Lajas');
     CountyFipsCodeCB.Items.add('081  Lares');
     CountyFipsCodeCB.Items.add('083  Las Marias');
     CountyFipsCodeCB.Items.add('085  Las Piedras');
     CountyFipsCodeCB.Items.add('087  Loiza');
     CountyFipsCodeCB.Items.add('089  Luquillo');
     CountyFipsCodeCB.Items.add('091  Manati');
     CountyFipsCodeCB.Items.add('093  Maricao');
     CountyFipsCodeCB.Items.add('095  Maunabo');
     CountyFipsCodeCB.Items.add('097  Mayaguez');
     CountyFipsCodeCB.Items.add('099  Moca');
     CountyFipsCodeCB.Items.add('101  Morovis');
     CountyFipsCodeCB.Items.add('103  Naguabo');
     CountyFipsCodeCB.Items.add('105  Naranjito');
     CountyFipsCodeCB.Items.add('107  Orocovis');
     CountyFipsCodeCB.Items.add('109  Patillas');
     CountyFipsCodeCB.Items.add('111  Penuelas');
     CountyFipsCodeCB.Items.add('113  Ponce');
     CountyFipsCodeCB.Items.add('115  Quebradillas');
     CountyFipsCodeCB.Items.add('117  Rincon');
     CountyFipsCodeCB.Items.add('119  Rio Grande');
     CountyFipsCodeCB.Items.add('121  Sabana Grande');
     CountyFipsCodeCB.Items.add('123  Salinas');
     CountyFipsCodeCB.Items.add('125  San German');
     CountyFipsCodeCB.Items.add('127  San Juan');
     CountyFipsCodeCB.Items.add('129  San Lorenzo');
     CountyFipsCodeCB.Items.add('131  San Sebastian');
     CountyFipsCodeCB.Items.add('133  Santa Isabel');
     CountyFipsCodeCB.Items.add('135  Toa Alta');
     CountyFipsCodeCB.Items.add('137  Toa Baja');
     CountyFipsCodeCB.Items.add('139  Trujillo Alto');
     CountyFipsCodeCB.Items.add('141  Utuado');
     CountyFipsCodeCB.Items.add('143  Vega Alta');
     CountyFipsCodeCB.Items.add('145  Vega Baja');
     CountyFipsCodeCB.Items.add('147  Vieques');
     CountyFipsCodeCB.Items.add('149  Villalba');
     CountyFipsCodeCB.Items.add('151  Yabucoa');
     CountyFipsCodeCB.Items.add('153  Yauco');
  end;{: Puerto Rico';}
57:Begin {VIRGIN ISLANDS OF THE UNITED STATES (VI) (78)}
     CountyFipsCodeCB.Items.add('010  St. Croix');
     CountyFipsCodeCB.Items.add('020  St. John');
     CountyFipsCodeCB.Items.add('030  St. Thomas');
{(Island Names are used instead of County Names.)}
     CountyFipsCodeCB.Items.add('010  Angaur');
     CountyFipsCodeCB.Items.add('050* Hatoboheit*');
     CountyFipsCodeCB.Items.add('100  Kayangel');
     CountyFipsCodeCB.Items.add('150  Koror');
     CountyFipsCodeCB.Items.add('218  Ngarchelong');
     CountyFipsCodeCB.Items.add('222  Ngardmau');
     CountyFipsCodeCB.Items.add('224  Ngatpang');
     CountyFipsCodeCB.Items.add('226  Ngchesar');
     CountyFipsCodeCB.Items.add('350  Peleliu');
     CountyFipsCodeCB.Items.add('370  Sonsorol');
  end;{: Virgin Islands (US)';}
58:Begin {U.S. MINOR OUTLYING ISLANDS (UM) (74)}
{(Island Names are used instead of County Names.)}
     CountyFipsCodeCB.Items.add('050  Baker Island');
     CountyFipsCodeCB.Items.add('100  Howland Island');
     CountyFipsCodeCB.Items.add('150  Jarvis Island');
     CountyFipsCodeCB.Items.add('200  Johnston Island');
     CountyFipsCodeCB.Items.add('250  Kingman Reef');
     CountyFipsCodeCB.Items.add('300  Midway Islands');
     CountyFipsCodeCB.Items.add('350  Navassa Island');
     CountyFipsCodeCB.Items.add('400  Palmyra Atoll');
     CountyFipsCodeCB.Items.add('450  Wake Island');
  end;{US MINOR OUTLYING ISLANDS}
59:Begin {FEDERATED STATES OF MICRONESIA (FM) (64)}
     CountyFipsCodeCB.Items.add('002* Chuuk*');
     CountyFipsCodeCB.Items.add('005  Kosrae');
     CountyFipsCodeCB.Items.add('040  Pohnpeit*');
     CountyFipsCodeCB.Items.add('060  Yap');
  end;{FEDERATED STATES OF MICRONESIA}
60:Begin {MARSHALL ISLANDS (MH) (68)}
     CountyFipsCodeCB.Items.add('007  Ailinginae');
     CountyFipsCodeCB.Items.add('010  Ailinglaplap');
     CountyFipsCodeCB.Items.add('030  Ailuk');
     CountyFipsCodeCB.Items.add('040  Arno');
     CountyFipsCodeCB.Items.add('050  Aur');
     CountyFipsCodeCB.Items.add('060  Bikar');
     CountyFipsCodeCB.Items.add('070  Bikini');
     CountyFipsCodeCB.Items.add('073  Bokak');
     CountyFipsCodeCB.Items.add('080  Ebon');
     CountyFipsCodeCB.Items.add('090  Enewetak');
     CountyFipsCodeCB.Items.add('100  Erikub');
     CountyFipsCodeCB.Items.add('110  Jabat');
     CountyFipsCodeCB.Items.add('120  Jaluit');
     CountyFipsCodeCB.Items.add('130  Jemo*');
     CountyFipsCodeCB.Items.add('140  Kili');
     CountyFipsCodeCB.Items.add('150  Kwajalein');
     CountyFipsCodeCB.Items.add('160  Lae');
     CountyFipsCodeCB.Items.add('170  Lib');
     CountyFipsCodeCB.Items.add('180  Likiep');
     CountyFipsCodeCB.Items.add('190  Majuro');
     CountyFipsCodeCB.Items.add('300  Maloelap');
     CountyFipsCodeCB.Items.add('310  Mejit');
     CountyFipsCodeCB.Items.add('320  Mili');
     CountyFipsCodeCB.Items.add('330  Namorik');
     CountyFipsCodeCB.Items.add('340  Namu');
     CountyFipsCodeCB.Items.add('350  Rongelap');
     CountyFipsCodeCB.Items.add('360  Rongrik');
     CountyFipsCodeCB.Items.add('385  Toke');
     CountyFipsCodeCB.Items.add('390  Ujae');
     CountyFipsCodeCB.Items.add('400  Ujelang');
     CountyFipsCodeCB.Items.add('410  Utrik');
     CountyFipsCodeCB.Items.add('420  Wotho');
     CountyFipsCodeCB.Items.add('430  Wotle');
  end;{MARSHALL ISLANDS}
else Begin CountyFipsCodeCB.Items.add('0');
  end;
end;{Case StateIn}
      End;{246}
  End;{Case CountryIn}
end;
{==============================================================}
{==============================================================}
(*************************************************************)
(*************************************************************)



(*************************************************************)
(*************************************************************)
{procedure THtfForm.ReadAnyVersionProj(ReadFileName:String);
procedure THtfForm.ReadVersionProj(ReadFileName:String);
procedure THtfForm.ReadVer1Proj(ReadFileName:String);

procedure THtfForm.ReadBitFile(InfileName:String);
procedure THtfForm.WriteProjectionFile(InfileName:String);
procedure THtfForm.WriteBitFile(InfileName:String);
procedure THtfForm.WriteTpcfgFile(InfileName:String);}
(*************************************************************)
procedure THtfForm.ResettoDefault1Click(Sender: TObject);
begin
  SetDefaultDEMProj;
end;
procedure THtfForm.SetDefaultDEMProj;
var
  TempInteger:Integer;
  dSinData:Double;
Begin
  TempInteger:=0;
  dSinData:=0;
  ValidProjectionCB.Checked:=False;
  NullValueEdit.Text :='-32768';
  MapZUnitsCB.Itemindex:=2;{Meters}
  ProjectionCB.Itemindex:=TempInteger;  {0=Geo}
  PixelCoordinateCB.Itemindex:=TempInteger;{3 LR}{0 Center}
  InUtmZoneCB.Itemindex:=60;{Index 60= 61:Geo}
  UTMZoneNorthCB.Checked:=True;
  IntegerorFloatCB.Checked:=True;{Integer}
  FloatingPointCB.Checked:=True;
  InUnitCB.Itemindex:=4; {D Degrees of arc}
  InDatumCB.Itemindex:=13;  {Nad27}
  SourceCB.Itemindex:=TempInteger;
  SpheroidCB.Itemindex:=TempInteger;
  StatePlaneZoneEdit.Text:=InttoStr(TempInteger);
  SEXEWEdit.Text:=InttoStr(TempInteger);
  SEYNSEdit.Text:=InttoStr(TempInteger);
  XWidthEdit.Text:=InttoStr(TempInteger);
  YHeightEdit.Text:=InttoStr(TempInteger);
  PixelsPerDegreeEdit.Text:=InttoStr(TempInteger);
  KiloPerPixelEdit.Text:=FloattoStr(dSinData);
    {Should set the Name and Code}
  CountryFipsCodeCB.ItemIndex:=TempInteger;
  StateFipsCodeCB.ItemIndex:=TempInteger;
  CountyFipsCodeCB.ItemIndex:=TempInteger;
  PixelXSizeEdit.Text :=InttoStr(10);
  PixelYSizeEdit.Text:=InttoStr(10);
  ZSizeEdit.Text:=InttoStr(1);
  VersionEdit.Text:=InttoStr(2);
  CellLocatorEdit.Text:='00000-A1';{47124-G6}{Change to IL}
  TopLeftXEdit.Text:=FloattoStr(dSinData);
  TopLeftYEdit.Text:=FloattoStr(dSinData);
  TopRightXEdit.Text:=FloattoStr(dSinData);
  TopRightYEdit.Text:=FloattoStr(dSinData);
  BottomLeftXEdit.Text:=FloattoStr(dSinData);
  BottomLeftYEdit.Text:=FloattoStr(dSinData);
  BottomRightXEdit.Text:=FloattoStr(dSinData);
  BottomRightYEdit.Text:=FloattoStr(dSinData);
  DLGPA1.Text:=FloattoStr(dSinData);
  DLGPA2.Text:=FloattoStr(dSinData);
  DLGPA3.Text:=FloattoStr(dSinData);
  DLGPB1.Text:=FloattoStr(dSinData);
  DLGPB2.Text:=FloattoStr(dSinData);
  DLGPB3.Text:=FloattoStr(dSinData);
  DLGPC1.Text:=FloattoStr(dSinData);
  DLGPC2.Text:=FloattoStr(dSinData);
  DLGPC3.Text:=FloattoStr(dSinData);
  DLGPD1.Text:=FloattoStr(dSinData);
  DLGPD2.Text:=FloattoStr(dSinData);
  DLGPD3.Text:=FloattoStr(dSinData);
  DLGPE1.Text:=FloattoStr(dSinData);
  DLGPE2.Text:=FloattoStr(dSinData);
  DLGPE3.Text:=FloattoStr(dSinData);
End;

{==============================================================}
{==============================================================}
{==============================================================}
{==============================================================}
{==============================================================}
{==============================================================}
procedure THtfForm.ReadAnyVersionProj(ReadFileName:String);
var
  outfile:file;
{  WhoAmI:Char;}
  WhoAmI1,WhoAmI2:Byte;{Char;}
NumRead: Integer;
begin
      AssignFile(outfile, ReadFileName);
      ReSet(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      BlockRead(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      CloseFile(outfile);
      {Data Source SourceCB}  {Header Version}
      if ((WhoAmI1 <17) and (WhoAmI2=1)) then
      ReadVer1Proj(ReadFileName); {Old}
      if ((WhoAmI1 <27) and (WhoAmI2=2)) then
      ReadVersionProj(ReadFileName);{Aug02}
      if ((WhoAmI1 <32) and (WhoAmI2=3)) then
      ReadImageProj(ReadFileName); {Image 02}
end;


(*************************************************************)
{Old Version}
procedure THtfForm.ReadVer1Proj(ReadFileName:String);
var
  outfile:file;
  ProjData:Smallint;
  WhoAmI:Char;
  WhoAmI1,WhoAmI2:Byte;{Char;}
  WhereString:String;
  txin, tyin, typein,
  TempInteger,NumRead: Integer;
  dSinData:Double;
Begin
      AssignFile(outfile, ReadFileName);
      ReSet(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      BlockRead(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      if ((WhoAmI1 <15) and (WhoAmI2=1)) then
      begin
      ReadWriteLabel.Caption:='Reading';
      DemName.Caption:=ExtractFileName(ReadFileName);
      DemPath:= ExtractFilePath(ReadFileName);
      SourceCB.Itemindex:= WhoAmI1;
      MapProjRec.SourceCBItemindex:= WhoAmI1;
      VersionEdit.Text:=inttostr(WhoAmI2);
      MapProjRec.VersionEditText:=(WhoAmI2);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEXEWEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEXEWEditText:=(ProjData);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEYNSEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEYNSEditText:=(ProjData);
      Blockread(outfile,txin , Sizeof(txin), NumRead);
      XWidthEdit.Text:=InttoStr(txin);
      MapProjRec.XWidthEditText:=(txin);
      Blockread(outfile,tyin , Sizeof(tyin), NumRead);
      YHeightEdit.Text:=InttoStr(tyin);
      MapProjRec.YHeightEditText:=(tyin);
      Blockread(outfile,typein , Sizeof(typein), NumRead);
      If typein=1 then IntegerorFloatCB.Checked:=True else
         IntegerorFloatCB.Checked:=False;
      MapProjRec.IntegerorFloatCBChecked:=typein;
      {WhereString is 4x6 Cell locator=8 Chars}
      WhereString:='        ';{8 chars}{unknown }
      For ProjData:=1 to 8 do
      begin
      Blockread(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
      WhereString[ProjData]:=WhoAmI;
      end;
      CellLocatorEdit.Text:=WhereString;
      MapProjRec.CellLocatorEditText:=WhereString;
{11*2}
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
  If ProjData=1 then ValidProjectionCB.Checked:=True else
      ValidProjectionCB.Checked:=False;
      MapProjRec.ValidProjectionCBChecked:=ProjData;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;  MapZUnitsCB.Itemindex:=TempInteger;
      MapProjRec.MapZUnitsCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   PixelCoordinateCB.Itemindex:=TempInteger;
      MapProjRec.PixelCoordinateCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   NullValueEdit.Text :=InttoStr(TempInteger);
      MapProjRec.NullValueEditText:=ProjData;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   ProjectionCB.Itemindex:=TempInteger;
      MapProjRec.ProjectionCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   InUnitCB.Itemindex:=TempInteger;
      MapProjRec.InUnitCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   InUtmZoneCB.Itemindex:=TempInteger;
      MapProjRec.InUtmZoneCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
  If ProjData=1 then UTMZoneNorthCB.Checked:=True else
      UTMZoneNorthCB.Checked:=False;
      MapProjRec.UTMZoneNorthCBChecked:=ProjData;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   StatePlaneZoneEdit.Text:=InttoStr(TempInteger);
      MapProjRec.StatePlaneZoneEditText:=ProjData;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   InDatumCB.Itemindex:=TempInteger;
      MapProjRec.InDatumCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   SpheroidCB.Itemindex:=TempInteger;
      MapProjRec.SpheroidCBItemindex:=TempInteger;

{26 *8}
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelXSizeEdit.Text :=FloattoStr(dSinData);
      MapProjRec.PixelXSizeEditText :=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelYSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.PixelYSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  ZSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.ZSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE3Text:=(dSinData);
  end else
  begin
    DemName.Caption:='NONE';
    DoMessages(25012);
  end;
  CloseFile(outfile);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  Application.ProcessMessages;
End;
{==============================================================}
{==============================================================}

{==============================================================}
{==============================================================}


{==============================================================}
{==============================================================}
{Double	5.0 x 10^324 .. 1.7 x 10^308	1516	8 bytes=64bit
Integer	2147483648..2147483647	signed 32-bit =4 bytes}
procedure THtfForm.ReadVersionProj(ReadFileName:String);
var
  outfile:file;
  ProjData:Smallint;{	32768..32767}{2 bytes}
  WhoAmI:Char;
  WhoAmI1,WhoAmI2:Byte;
  txin, tyin, {typein,}
  TempInteger,NumRead: Integer;
  sSinData:Single;
  dSinData:Double;
  WhereString:String;
Begin
      AssignFile(outfile, ReadFileName);
      ReSet(outfile,1);              {(11 * 2 = 22)}
      { (2*1=2) +4 + (2*4=8 +1=9) +8 + (2*2=4+9=13)
         (new)
      + (3*2=6)+6free) +(26 * 8 = 208) = 256}
      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      BlockRead(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      if ((WhoAmI1 <26) and (WhoAmI2=2)) then
      begin
      ReadWriteLabel.Caption:='Reading';
      DemName.Caption:=ExtractFileName(ReadFileName);
      DemPath:= ExtractFilePath(ReadFileName);
      SourceCB.Itemindex:= WhoAmI1;
      MapProjRec.SourceCBItemindex:= WhoAmI1;
      VersionEdit.Text:=inttostr(WhoAmI2);
      MapProjRec.VersionEditText:=(WhoAmI2);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEXEWEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEXEWEditText:=(ProjData);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEYNSEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEYNSEditText:=(ProjData);
      Blockread(outfile,txin , Sizeof(txin), NumRead);
      XWidthEdit.Text:=InttoStr(txin);
      MapProjRec.XWidthEditText:=(txin);
      Blockread(outfile,tyin , Sizeof(tyin), NumRead);
      YHeightEdit.Text:=InttoStr(tyin);
      MapProjRec.YHeightEditText:=(tyin);
{Byte=3}      Blockread(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      If WhoAmI1=1 then IntegerorFloatCB.Checked:=True else
         IntegerorFloatCB.Checked:=False;
      MapProjRec.IntegerorFloatCBChecked:=WhoAmI1;
      {WhereString is 4x6 Cell locator=8 Chars}
      WhereString:='        ';{8 chars}{unknown }
      For ProjData:=1 to 8 do
      begin
      Blockread(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
      WhereString[ProjData]:=WhoAmI;
      end;
      CellLocatorEdit.Text:=WhereString;
      MapProjRec.CellLocatorEditText:=WhereString;
{2*2=4+9=13}
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If WhoAmI1=1 then ValidProjectionCB.Checked:=True else
      ValidProjectionCB.Checked:=False;
      MapProjRec.ValidProjectionCBChecked:=WhoAmI1;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;  MapZUnitsCB.Itemindex:=TempInteger;
      MapProjRec.MapZUnitsCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   PixelCoordinateCB.Itemindex:=TempInteger;
      MapProjRec.PixelCoordinateCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   NullValueEdit.Text :=InttoStr(TempInteger);
      MapProjRec.NullValueEditText:=ProjData;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   ProjectionCB.Itemindex:=TempInteger;
      MapProjRec.ProjectionCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InUnitCB.Itemindex:=TempInteger;
      MapProjRec.InUnitCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InUtmZoneCB.Itemindex:=TempInteger;
      MapProjRec.InUtmZoneCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If WhoAmI1=1 then UTMZoneNorthCB.Checked:=True else
      UTMZoneNorthCB.Checked:=False;
      MapProjRec.UTMZoneNorthCBChecked:=WhoAmI1;

      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   StatePlaneZoneEdit.Text:=InttoStr(TempInteger);
      MapProjRec.StatePlaneZoneEditText:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InDatumCB.Itemindex:=TempInteger;
      MapProjRec.InDatumCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   SpheroidCB.Itemindex:=TempInteger;
      MapProjRec.SpheroidCBItemindex:=TempInteger;

{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   CountryFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.CountryFipsCodeCBItemIndex:=TempInteger;
{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   StateFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.StateFipsCodeCBItemIndex:=TempInteger;
{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   CountyFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.CountyFipsCodeCBItemIndex:=TempInteger;
{2+4=6  bytes}
BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;
PixelsPerDegreeEdit.Text:=InttoStr(TempInteger);
      MapProjRec.PixelsPerDegreeEdit:=TempInteger;
      BlockRead(outfile,sSinData , Sizeof(sSinData), NumRead);
  KiloPerPixelEdit.Text:=FloattoStr(sSinData);
      MapProjRec.KiloPerPixelEdit :=(sSinData);
{...new ver2}
{26 *8}
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelXSizeEdit.Text :=FloattoStr(dSinData);
      MapProjRec.PixelXSizeEditText :=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelYSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.PixelYSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  ZSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.ZSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE3Text:=(dSinData);
  end else
  begin
    DemName.Caption:='NONE';
    DoMessages(25012);
  end;
      CloseFile(outfile);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  Application.ProcessMessages;
End;
{==============================================================}
{==============================================================}


procedure THtfForm.WriteProjectionFile(InfileName:String);
var
  WhoAmI1,WhoAmI2:Byte;
  WhoAmInot:Char;
  WhereString:String;
  outfile:file;
  ProjData{, iSinData}:SmallInt;   {smallint Datum}
  txin, tyin, {typein, tx, ty,} NumRead: Integer;
  sSinData:Single;
  dSinData:Double;
Begin
      AssignFile(outfile, InfileName);
      Rewrite(outfile,1);
  { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      WhoAmI1:=SourceCB.Itemindex;
      WhoAmI2:=Strtoint(VersionEdit.Text);
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      Blockwrite(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      { SE Y:N-S and SE X:E-W degrees}
      ProjData:=StrToInt(SEXEWEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      ProjData:=StrToInt(SEYNSEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      txin:=StrtoInt(XWidthEdit.Text);
      Blockwrite(outfile,txin , Sizeof(txin), NumRead);
      tyin:=StrtoInt(YHeightEdit.Text);
      Blockwrite(outfile,tyin , Sizeof(tyin), NumRead);
      If IntegerorFloatCB.Checked then WhoAmI1:=1 else
         WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      WhereString:=CellLocatorEdit.Text;
      For ProjData:=1 to 8 do
      begin
      WhoAmInot:=WhereString[ProjData];
      Blockwrite(outfile,WhoAmInot , Sizeof(WhoAmInot), NumRead);
      end;

  If ValidProjectionCB.Checked then
  WhoAmI1:=1 else WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=MapZUnitsCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=PixelCoordinateCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
ProjData:=StrtoInt(NullValueEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI1:=ProjectionCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=InUnitCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=InUtmZoneCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If UTMZoneNorthCB.Checked then
     WhoAmI1:=1 else WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
ProjData:=StrtoInt(StatePlaneZoneEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI1:=InDatumCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=SpheroidCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);

{new ver2}
ProjData:=CountryFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=StateFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=CountyFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

ProjData:=StrtoInt(PixelsPerDegreeEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  sSinData:=StrtoFloat(KiloPerPixelEdit.Text);
      Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead);

  dSinData:=StrtoFloat(PixelXSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(PixelYSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(ZSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(TopLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(DLGPA1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  CloseFile(outfile);
End;
{==============================================================}
{==============================================================}


{==============================================================}
{==============================================================}
{ONLY called by SetProjection which READS the projection First
then reads the bits (this)
then writes the projection then the bits}
procedure THtfForm.ReadBitFile(InfileName:String);
var
{  WhoAmI:Byte;
  cWhoAmI:Char;}
{  bZisInteger:Boolean;}
  typein, iSinData:SmallInt;
  {ProjData:SmallInt;}{:Integer;}
{  iSinData,}
  txin, tyin, NumRead,tx,ty:Integer;
  sSinData:Single;
  {dSinData:Double;
  WhereString: string; }
{  InfileName,
  MyFilesS: string;
{  Infile,}outfile:file;
  Buf: array[1..256] of Byte;
begin
      AssignFile(outfile, ChangeFileExt(InfileName,'.bit'));
      Reset(outfile,1);
      {READ HEADER into BUFFER then write into NEW FILE with data}
      BlockRead(outfile, Buf, SizeOf(Buf), NumRead);
      txin:=StrtoInt(XWidthEdit.Text);
      tyin:=StrtoInt(YHeightEdit.Text);
      If IntegerorFloatCB.Checked then typein:=1 else
         typein:=0;
      {typein determines if 1=Shortint or 0=Floats}
      If typein=1 then
      begin
      SetLength(ManMatrix,txin+1,tyin+1);
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            Blockread(outfile,iSinData , Sizeof(iSinData), NumRead);
            ManMatrix[tx,ty]:=iSinData;
        end;
      end;
      end else{Float}
      begin
      SetLength(sManMatrix,txin+1,tyin+1);
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            Blockread(outfile,sSinData , Sizeof(sSinData), NumRead);
            sManMatrix[tx,ty]:=sSinData;
        end;
      end;
      end;
      CloseFile(outfile);
      DeleteFile(InfileName);{Allows resorting...}
      Application.ProcessMessages;
end;

procedure THtfForm.WriteBitFile(InfileName:String);
var
{  WhoAmI:Byte;
  cWhoAmI:Char;}
{  bZisInteger:Boolean;}
 siSinData:SmallInt;{:Integer;}
{  iSinData,}  typein,
  txin, tyin, NumRead,tx,ty:Integer;
  sSinData:Single;
  {dSinData:Double;
  WhereString: string; }
{  InfileName,
  MyFilesS: string;
{  Infile,}outfile:file;
  Buf: array[1..256] of Byte;
begin
      Application.ProcessMessages;
      ReadWriteLabel.Caption:='Writing: ';
      DemName.Caption:=ExtractFileName(ChangeFileExt(InfileName,'.bit'));
      Application.ProcessMessages;
      AssignFile(outfile, ChangeFileExt(InfileName,'.bit'));
      Reset(outfile,1);
      {READ HEADER into BUFFER then write into NEW FILE with data}
      BlockRead(outfile, Buf, SizeOf(Buf), NumRead);
      CloseFile(outfile);
      Rewrite(outfile,1);
      BlockWrite(outfile, Buf, SizeOf(Buf));
{Write DEM file}
      txin:=StrtoInt(XWidthEdit.Text);
      tyin:=StrtoInt(YHeightEdit.Text);
      If IntegerorFloatCB.Checked then typein:=1 else
         typein:=0;{1=Integer, 0=Float}
      If typein=1 then
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            siSinData :=ManMatrix[tx,ty];
            Blockwrite(outfile,siSinData , Sizeof(siSinData), NumRead)
        end;
      end;
      end else
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            sSinData :=sManMatrix[tx,ty];
            Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead)
        end;
      end;
     end;
  CloseFile(outfile);
End;
(*************************************************************)

(*************************************************************)
(*
procedure THtfForm.SetDEMProj(SetFileName:String);
var
  WhoAmI1,WhoAmI2:Byte;
  WhoAmInot:Char;
  WhereString:String;
  outfile:file;
  ProjData, iSinData:SmallInt;                  {smallint Datum}
  txin, tyin, typein, tx, ty, NumRead: Integer;
  sSinData:Single;
  dSinData:Double;
  iManMatrix: array of array of SmallInt;
  sManMatrix: array of array of Single;
Begin
      AssignFile(outfile, SetFileName);
      Reset(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      Blockread(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      if ((WhoAmI1 <15) and (WhoAmI2=1)) then
      begin
      ReadWriteLabel.Caption:='Writing';
      DemName.Caption:=ExtractFileName(SetFileName);
      DemPath:= ExtractFilePath(SetFileName);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      Blockread(outfile,txin , Sizeof(txin), NumRead);
      Blockread(outfile,tyin , Sizeof(tyin), NumRead);
      Blockread(outfile,typein , Sizeof(typein), NumRead);
      {Skip past the rest of header}
      For ProjData:=1 to 238 do
      Blockread(outfile,WhoAmInot , Sizeof(WhoAmInot), NumRead);


      AssignFile(outfile, SetFileName);
      Rewrite(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      WhoAmI1:=SourceCB.Itemindex;
      WhoAmI2:=Strtoint(VersionEdit.Text);
         {  WhoAmI1:=3;}
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
         {  WhoAmI2:=1;}
      Blockwrite(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      { SE Y:N-S and SE X:E-W degrees}
      ProjData:=StrToInt(SEXEWEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      ProjData:=StrToInt(SEYNSEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

      Blockwrite(outfile,txin , Sizeof(txin), NumRead);

      Blockwrite(outfile,tyin , Sizeof(tyin), NumRead);

      Blockwrite(outfile,typein , Sizeof(typein), NumRead);
      WhereString:=CellLocatorEdit.Text;
      For ProjData:=1 to 8 do
      begin
      WhoAmInot:=WhereString[ProjData];
      Blockwrite(outfile,WhoAmInot , Sizeof(WhoAmInot), NumRead);
      end;

  If ValidProjectionCB.Checked then
  ProjData:=1 else ProjData:=0;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=MapZUnitsCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=PixelCoordinateCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=StrtoInt(NullValueEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=ProjectionCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=InUnitCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=InUtmZoneCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  If UTMZoneNorthCB.Checked then
     ProjData:=1 else ProjData:=0;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=StrtoInt(StatePlaneZoneEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=InDatumCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  ProjData:=SpheroidCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

  dSinData:=StrtoFloat(PixelXSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(PixelYSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(ZSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(TopLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(DLGPA1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
      If typein=1 then
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            iSinData :=iManMatrix[tx,ty];
            Blockwrite(outfile,iSinData , Sizeof(iSinData), NumRead)
        end;
      end;
      end else
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        for tx:=0 to txin-1 do
        begin
            sSinData :=sManMatrix[tx,ty];
            Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead)
        end;
      end;
      end;
  end else
  begin
    DemName.Caption:='NONE';
    DoMessages(25012);
  end;
  CloseFile(outfile);
  SetLength(iManMatrix,0,0);
  SetLength(sManMatrix,0,0);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
End;
*)
(*************************************************************)



procedure THtfForm.PRConverterClick(Sender: TObject);
var
No_paths,No_rows,
Row,Path:Integer;
Laty,Lonx:Double;
begin
If ( (length(MinRowEdit.Text) >0) and (length(MinPathEdit.Text) >0)) then
begin
Row:=Strtoint(MinRowEdit.Text);
Path:=Strtoint(MinPathEdit.Text);
No_rows:=248;
No_paths:=233;
If ( (Row <= No_rows) and (Path <= No_paths)) then
begin
DoPRConversion(Path,Row,Laty,Lonx);
CenterLonEdit.Text:=Floattostr(Lonx);
CenterLatEdit.Text:=Floattostr(Laty);
end;end;
end;

procedure THtfForm.DoPRConversion(Path,Row:Integer;
                              var Laty,Lonx:Double);
var
No_paths,No_rows,Row_eq,sign:Integer;
g,q,L,f,qa,A,B,
Inc,Inclination,Rotation,lasc:Double;
begin
No_rows:=248;
No_paths:=233;
Rotation:=3.640625;
Row_eq:=184;
lasc:=103.03948;
sign:=1;
Inclination:=98.2;
Inc:=180-Inclination;
A := 6378.388;
B := 6356.912;

g := (Row - Row_eq)*360/ No_rows;

qa := lasc - ((Path - 1)*sign*360/ No_paths);

q :=ArcTan2((sin(inc)*sin(g)),cos(g));
{q := tan-1(sin(inc)*sin(g)/ cos(g));}
{   DegToRad}
L := ArcSin( (sin(inc)*sin(g)) );
{L := sin-1(sin(inc)*sin(g); }

f :=ArcTan2(((A*A)*tan(L)),(B*B));
{f := tan-1((A*A)*tan(L)/ (B*B));}
l := qa - q - (0.25*g / Rotation);
Laty:=f;
Lonx:=l;
end;


procedure THtfForm.MarsListFilesBtnClick(Sender: TObject);
var
 CountIn,CountAll:Integer;
 MarsNameExt:String;
 S : string;
 F: TextFile;
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'Mars DEM files list (*.txt)|*.txt';
  ODTerrainPack.Filename:= 'graflist.txt';{graflist.txt}
  if ODTerrainPack.Execute then
  begin
    if UpperCase(ExtractFileExt(ODTerrainPack.FileName)) = '.TXT' then
    begin
      SetDefaultDEMProj;
      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      CountIn:=0;
      CountAll:=0;
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountIn);
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       end;

      AssignFile(F, ODTerrainPack.FileName);
      Reset(F);
      Try
      Repeat
      begin
        Readln(F, S);
        inc(CountAll);
        ReadWriteLabel.Caption:='Reading: ';
        ColonLabel.Caption:=' '+Inttostr(CountAll)+' of '+Inttostr(CountIn)+' : ';
        If FileExists(S) then
        begin
          MarsNameExt:=ExtractFileExt(S);
          If ((MarsNameExt='.img')or(MarsNameExt='.lbl'))then
          begin
            If FileExists(ChangeFileExt(S,'.lbl'))then
              S:=ChangeFileExt(S,'.lbl');
            ConvertMarsImg(S,1)
          end
        end;
      end;
      until (eof(F));
       Finally
       CloseFile(F);
       ColonLabel.Caption:=' : ';
       end;
    end;
  end;
end;

procedure THtfForm.MarsBtnClick(Sender: TObject);
var
  MarsName,MarsNameExt:String;
begin  {no Header?}
  ODTerrainPack.Filter :=
  'Mars files (*.tab;*.lbl;*.img)|*.img;*.tab;*.lbl|All files (*.*)|*.*';
  ODTerrainPack.Filename := 'Mars files.img';
  ODTerrainPack.InitialDir:=DemPath;
  if (ODTerrainPack.Execute) then
  begin
    DemPath:=ExtractFilePath(ODTerrainPack.FileName);
    MarsNameExt:=ExtractFileExt(ODTerrainPack.FileName);
    If ((MarsNameExt='.img')or(MarsNameExt='.lbl')) then
    begin
      MarsName:=ODTerrainPack.FileName;
      If FileExists(ChangeFileExt(MarsName,'.lbl'))then
       MarsName:=ChangeFileExt(ODTerrainPack.FileName,'.lbl');
      ConvertMarsImg(MarsName,0)
    end
    else If (MarsNameExt='.tab') then ConvertMarsTab(ODTerrainPack.FileName,0);
  end;
End;

{mola2x2a.tab
Half-degree MOLA Dataset released to the PDS: (preliminary, subject to review)
ftp://ltpftp.gsfc.nasa.gov/pub/projects/tharsis/MOLA/GRIDS/mola2x2a.tab
Denser grids may be made in selected regions by binning the observations from
the PEDR datasets themselves.
The rows are listed in "scan-line" order, by increasing longitude, N to S,
i.e.,
    0.25   89.75  3376191.45  3378185.03  -1993.09     2
    0.75   89.75  3376195.73  3378185.04  -1990.11     4
    1.25   89.75  3376192.15  3378185.04  -1993.28     2
    1.75   89.75  3376185.31  3378185.05  -2016.83     4
    2.25   89.75  3376170.32  3378185.05  -2007.51     2
    2.75   89.75  3376199.11  3378185.06  -2003.41     4
    3.25   89.75  3376124.51  3378185.06  -2077.21     0
    3.75   89.75  3376168.45  3378185.07  -2035.67     4
    4.25   89.75  3376153.36  3378185.08  -2024.65     3
    4.75   89.75  3376180.29  3378185.08  -2009.75     9}
{mola1x1a.tab
Dataset released to the PDS: (preliminary, subject to review)
ftp://ltpftp.gsfc.nasa.gov/pub/projects/tharsis/MOLA/GRIDS/mola1x1a.tab
The rows are listed in "scan-line" order, by increasing longitude, N to S,
i.e.,
     0.5    89.5  3376055.43  3378187.24  -2149.39    24
     1.5    89.5  3376056.95  3378187.27  -2153.40    22
     2.5    89.5  3376066.28  3378187.30  -2148.07    17
     3.5    89.5  3376010.75  3378187.33  -2216.51    11
     4.5    89.5  3376071.33  3378187.35  -2137.71     8
     5.5    89.5  3376128.38  3378187.38  -2070.54     9
     6.5    89.5  3376168.03  3378187.41  -2033.42     7
     7.5    89.5  3376170.55  3378187.43  -2023.11     6
     8.5    89.5  3376181.59  3378187.46  -2009.45     6
     9.5    89.5  3376189.74  3378187.48  -2002.86     7}
procedure THtfForm.ConvertMarsTab(InName:String;DoTpcfg:Integer);
var
  MarsName:String;
var
  ElevationCount: Smallint;
{  yLat,xLon,}
  Xcount, Zcount: Integer;
  Text_File: Textfile;
  SrtmName,Elevations:String;
  Bin_File: file;
  Buf: array[1..256] of Char;
  Buffoon: array[1..57] of Char;
  OktoGo:Boolean;
  i,NumRead:Integer;
Begin
  MarsName:=lowercase(ExtractFileName(InName));
  If ( (MarsName='mola2x2a.tab')
    or (MarsName='ieg050_a.tab')
    or (MarsName='ieg100_a.tab')
    or (MarsName='mola1x1a.tab') ) then
  Begin
    SetDefaultDEMProj;
    If ( (MarsName='mola2x2a.tab')
      or (MarsName='ieg050_a.tab')) then
    Begin
    {The table is as follows: 259200 rows, each row containing observations
from a 1/2 degree by 1/2 degree area:
center areocentric longitude East, degrees,	f8.2
center areocentric latitude North, degrees,	f8.2
mean planetary radius, m,			f12.2
areoid radius at center, m,			f12.2
median topography, m,				f10.2
number of observations, counts,			i6
360*2=720 x 180*2=360  720*360=259200
720 points (0..360) per 90..-90 degrees N..S}
    FileSizeX:= 720;    XWidthEdit.Text:='720';
    FileSizeY:=360;     YHeightEdit.Text:='360';
    PixelXSizeEdit.Text:= Floattostr(0.5);{X Size 1AS}
    PixelYSizeEdit.Text:= Floattostr(0.5);{Y Size 1AS}
    SourceCB.itemIndex:=18;
    {17: Mars 1 Degree
18: Mars 0.5 Degree
19: Mars 1/4 Degree
20: Mars 1/16 Degree
21: Mars 1/64 Degree
22: Mars 1/256 Degree
23: Venusian 1/64 Degree
24: Venusian 1/?? Degree}
    end else
  If ( (MarsName='ieg100_a.tab')
    or (MarsName='mola1x1a.tab') ) then
    Begin
    {mola1x1a
    or ieg100_a.tab
    The table is as follows: 360 by 180 rows, each row containing observations
from a one-by-one-degree area:

center areocentric longitude, degrees,	f8.1
center areocentric latitude,  degrees,	f8.1
mean planetary radius, m,		f12.2
areoid radius at center, m,		f12.2
median topography, m,			f10.2
number of observations, counts,		i6
}
    FileSizeX:= 360;    XWidthEdit.Text:='360';
    FileSizeY:=180;     YHeightEdit.Text:='180';
    PixelXSizeEdit.Text:= Floattostr(1.0);{X Size 1AS}
    PixelYSizeEdit.Text:= Floattostr(1.0);{Y Size 1AS}
    SourceCB.itemIndex:=17;
    end;
    PixelCoordinateCB.ItemIndex:=1;
    {Filename: Lat Long of Lower Left corner: 1 degree tiles }
    TopLeftXEdit.Text:= Inttostr(0){'0'};
    TopLeftYEdit.Text:= Inttostr(90){'0'};
    TopRightXEdit.Text:= Inttostr(360);
    TopRightYEdit.Text:= Inttostr(90);
    BottomLeftXEdit.Text:= Inttostr(0);
    BottomLeftYEdit.Text:= Inttostr(-90);
    BottomRightXEdit.Text:= Inttostr(360){'4320'};
    BottomRightYEdit.Text:=  Inttostr(-90){'2160'};
    MapZUnitsCB.Itemindex:=2;{Meters}
    ProjectionCB.Itemindex:=0;  {Geo}
    PixelCoordinateCB.Itemindex:=0;{Center}
    InUtmZoneCB.Itemindex:=0;{=#16}
    UTMZoneNorthCB.Checked:=True;
    IntegerorFloatCB.Checked:=True;{Integer}
    InUnitCB.Itemindex:=4; {D Degrees of arc}
    InDatumCB.Itemindex:=26;  {wgs84
    26: Mercury
27: Venus
28: Mars
29: Jupiter
30: Saturn
31: Uranus
32: Neptune
33: Pluto}
    SpheroidCB.Itemindex:=31;{wgs84
    31: Mercury
32: Venus
33: Mars
34: Jupiter
35: Saturn
36: Uranus
37: Neptune
38: Pluto}
  AssignFile(Bin_File, InName);
  Reset(Bin_File,1);
  BlockRead(Bin_File, Buf, SizeOf(Buf), NumRead);
  CloseFile(Bin_File);
  OktoGo:=False;
  For I:= 1 to 254 do
  If Buf[i]=#13 then OktoGo:=True;
  If (not OktoGo) then
  begin
  AssignFile(Bin_File, InName);
  Reset(Bin_File,1);
    if (IoResult = 0) then
    begin
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      SetLength(ManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          BlockRead(Bin_File, Buffoon, SizeOf(Buffoon), NumRead);
          {Readln(Text_File, SrtmName);}
          Elevations:=Copy(Buffoon,41,11);
          {     0.5    89.5  3376055.43  3378187.24  -2149.39    24}
          Trim(Elevations);
          ElevationCount := Round(StrtoFloat(Elevations));
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
      CloseFile(Bin_File);
      if (IoResult <> 0) then DoMessages(25005);
    end else DoMessages(25006);
  end else
  begin
    Application.ProcessMessages;
    DemName.Caption:=ExtractFileName(InName);
    AssignFile(Text_File, InName);
    Reset(Text_File);
    if (IoResult = 0) then
    begin
      ProgressBar.Visible := True;
      Application.ProcessMessages;
      SetLength(ManMatrix,FileSizeX,FileSizeY );
      for Zcount := 0 to FileSizeY - 1 do
      begin
        ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
        Application.ProcessMessages;
        for Xcount := 0 to FileSizeX - 1 do
        begin
          Readln(Text_File, SrtmName);
          Elevations:=Copy(SrtmName,41,11);
          {     0.5    89.5  3376055.43  3378187.24  -2149.39    24}
          Trim(Elevations);
          ElevationCount := Round(StrtoFloat(Elevations));
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
      CloseFile(Text_File);
      if (IoResult <> 0) then DoMessages(25005);
    end else DoMessages(25006);
    end;
    Application.ProcessMessages;
    WriteProjectionFile(ChangeFileExt(InName,'.bit'));
    WriteBitFile(ChangeFileExt(InName,'.bit'));
    If DoTpcfg=0 then
    WriteTpcfgFile(ChangeFileExt(InName,'.bit'));
    SetLength(ManMatrix,0,0 );
    ProgressBar.Visible :=False;
  End else DoMessages(25012);
end;



procedure THtfForm.ConvertMarsImg(InName:String;DoTpcfg:Integer);
var
  MarsName:String;
var
  Minin,Maxin,
  HeadButt:Byte;
{  Word	0..65535	unsigned 16-bit
Longword	0..4294967295	unsigned 32-bit
Cardinal	0..4294967295	unsigned 32-bit}
  OktoGo,ByteOrInt:Boolean;
  ElevationCount: Smallint;
  i,NumRead,
{  yLat,xLon,}HeaderSize,RECORDBYTES,
  Xcount, Zcount: Integer;
  HeadbangerDouble:Double;
  SwitchExt, HeadString,HeadbangerString:String;
{  SrtmName,Lats,Lons:String;}
  Head_File:Textfile;
  Bin_File: file;
  Buf: array[1..256] of Char;
Begin
  SetDefaultDEMProj;
  SwitchExt:=ExtractFileExt(InName);
  If (SwitchExt='.img') then
  begin
  AssignFile(Bin_File, InName);
  Reset(Bin_File,1);
  BlockRead(Bin_File, Buf, SizeOf(Buf), NumRead);
  CloseFile(Bin_File);
  OktoGo:=False;
  For I:= 1 to 254 do
  If Buf[i]=#13 then OktoGo:=True;
  If (not OktoGo) then
  begin
    Showmessage('No header or .lbl missing:'+#13#10
              + 'use Process per Projection Data Button');
    Exit;
  end;
end;
  RECORDBYTES:=0;
  HeaderSize:=0;
  FileSizeY:=0;
  FileSizeX:=0;
  ByteOrInt:=True;
  Minin:= 255;
  Maxin:= 0;
  {HeadbangerDouble:=0;}
  DEMtoBinMemo.Clear;
  MarsName:=ExtractFileName(InName);
  DemName.Caption:=ExtractFileName(InName);
  AssignFile(Head_File, InName);
  Reset(Head_File);
  While (not eof(Head_File)) do
  begin
    Readln(Head_File, HeadString);
    If pos('=',HeadString)>0 then
    begin
      If pos('RECORD_BYTES',HeadString)>0 then
      begin {RECORD_BYTES         = 974}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        RECORDBYTES:=StrtoInt(Trim(HeadbangerString));
        DEMtoBinMemo.LineS.Append('RECORD_BYTES: '+HeadbangerString);
      end;
      {ignore... FILE_RECORDS         =  685}
      If ((SwitchExt='.img')and (pos('^IMAGE',HeadString)>0)) then
      begin {^IMAGE               = 3}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        HeaderSize:=(RECORDBYTES *(StrtoInt(Trim(HeadbangerString))-1));
        DEMtoBinMemo.LineS.Append('IMAGE: '+HeadbangerString);
      end;

      If pos('LINES',HeadString)>0 then
      begin {LINES                = 680}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        FileSizeY:=StrtoInt(Trim(HeadbangerString));
        YHeightEdit.Text:=trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('LINES: '+HeadbangerString);
      end;
      If pos('LINE_SAMPLES',HeadString)>0 then
      begin {LINE_SAMPLES         = 974}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        FileSizeX:= StrtoInt(Trim(HeadbangerString));
        XWidthEdit.Text:=trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('LINE_SAMPLES: '+HeadbangerString);
      end;

      If pos('SAMPLE_TYPE',HeadString)>0 then
      begin {SAMPLE_TYPE          = UNSIGNED_INTEGER  VAX_INTEGER}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        Trim(HeadbangerString);{UNSIGNED_INTEGER}
        If pos('UNSIGNED_INTEGER',HeadbangerString)>0{(HeadbangerString='UNSIGNED_INTEGER')} then ByteOrInt:=True
        else If pos('MSB_INTEGER',HeadbangerString)>0{(HeadbangerString='MSB_INTEGER')} then ByteOrInt:=False
        else If pos('VAX_INTEGER',HeadbangerString)>0{(HeadbangerString='VAX_INTEGER')} then ByteOrInt:=False
        else begin showmessage('SAMPLE_TYPE error '+HeadbangerString);ByteOrInt:=True;{Exit} {procedure} end;
        DEMtoBinMemo.LineS.Append('SAMPLE_TYPE:'+HeadbangerString);
      end;

      {  SAMPLE_BITS          = 8
        SAMPLE_BIT_MASK      = 2#11111111#}

      If ((pos('MAP_PROJECTION_TYPE',HeadString)>0)) then
      begin {MAP_PROJECTION_TYPE  = SINUSODIAL}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        Trim(HeadbangerString);
        If (HeadbangerString='SINUSODIAL') then
            ProjectionCB.Itemindex:=33  {33: Mars Geo Snsoid}
        else If (HeadbangerString='SIMPLE CYLINDRICAL') then
            ProjectionCB.Itemindex:=34  {34: Mars S CYLINDRICAL}
        else ProjectionCB.Itemindex:=0;
        DEMtoBinMemo.LineS.Append('MAP_PROJECTION_TYPE: '+HeadbangerString);
      end;

      If pos('MAP_RESOLUTION',HeadString)>0 then
      begin {MAP_RESOLUTION       = 16<PIXEL/DEG>}
        DEMtoBinMemo.LineS.Append(HeadString);
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        Zcount:= Round(StrToFloat(trim(HeadbangerString)));
        Case Zcount of
          {17: Mars 1 Degree
          18: Mars 0.5 Degree
          19: Mars 1/4 Degree}
          16:SourceCB.itemIndex:=20;{: Mars 1/16 Degree}
          64:SourceCB.itemIndex:=21;{: Mars 1/64 Degree}
          256:SourceCB.itemIndex:=22;{: Mars 1/256 Degree}
          {23: Venusian 1/64 Degree
          24: Venusian 1/?? Degree}
          end;{case}
        DEMtoBinMemo.LineS.Append('MAP_RESOLUTION: '+HeadbangerString);
        HeadbangerDouble:=(1/Zcount);
        DLGPA1.Text:=Inttostr(Zcount);
        PixelsPerDegreeEdit.Text:=Inttostr(Zcount);
        DLGPA2.Text:=Floattostr(HeadbangerDouble);
        DLGPA3.Text:=Floattostr(HeadbangerDouble/360);
        PixelXSizeEdit.Text:= Floattostr(HeadbangerDouble);
        PixelYSizeEdit.Text:= Floattostr(HeadbangerDouble);
      end;

      If pos('MAP_SCALE',HeadString)>0 then
      begin {MAP_SCALE            = 3.701625<KM/PIXEL>}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        DEMtoBinMemo.LineS.Append(HeadString);
        DEMtoBinMemo.LineS.Append('MAP_SCALE: '+HeadbangerString);
        KiloPerPixelEdit.Text:=trim(HeadbangerString);
      end;
      (*/*        ELEVATION (METERS) = 2*DN - 6000, NULL DN VALUES = 0 */
            MISSING              = 0
            SCALING_FACTOR       = 2
            OFFSET               = -6000*)

      If pos('MAXIMUM_LATITUDE',HeadString)>0 then
      begin {MAXIMUM_LATITUDE     = 90.00000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        {HeadbangerDouble:=Strtofloat(HeadbangerString);}
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        TopLeftYEdit.Text:= HeadbangerString;
        TopRightYEdit.Text:= HeadbangerString;
        DEMtoBinMemo.LineS.Append('MAXIMUM_LATITUDE: '+HeadbangerString);
      end;
      If pos('MINIMUM_LATITUDE',HeadString)>0 then
      begin {MINIMUM_LATITUDE     = 47.50000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        {HeadbangerDouble:=Strtofloat(HeadbangerString);}
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        BottomLeftYEdit.Text:= HeadbangerString;
        BottomRightYEdit.Text:= HeadbangerString;
        DEMtoBinMemo.LineS.Append('MINIMUM_LATITUDE: '+HeadbangerString);
        SEYNSEdit.Text:=inttostr(round(strtofloat(HeadbangerString)));
      end;
      If ((pos('MAXIMUM_LONGITUDE',HeadString)>0)
          or (pos(' EASTERNMOST_LONGITUDE',HeadString)>0)) then
      begin {MAXIMUM_LONGITUDE    = 180.00000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        {HeadbangerDouble:=Strtofloat(HeadbangerString);}
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        TopLeftXEdit.Text:= HeadbangerString;
        BottomLeftXEdit.Text:= HeadbangerString;
        SEXEWEdit.Text:=inttostr(round(strtofloat(HeadbangerString)));
        DEMtoBinMemo.LineS.Append('MAXIMUM_LONGITUDE: '+HeadbangerString);
      end;
      If ((pos('MINIMUM_LONGITUDE',HeadString)>0)
      or (pos(' WESTERNMOST_LONGITUDE',HeadString)>0)) then
      begin {MINIMUM_LONGITUDE    = 89.89360}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        {HeadbangerDouble:=Strtofloat(HeadbangerString);}
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        TopRightXEdit.Text:= HeadbangerString;
        BottomRightXEdit.Text:= HeadbangerString;
        DEMtoBinMemo.LineS.Append('MINIMUM_LONGITUDE: '+HeadbangerString);
      end;
      If ((pos('X_AXIS_PROJECTION_OFFSET',HeadString)>0)
      or (pos('LINE_PROJECTION_OFFSET',HeadString)>0)) then
      begin {X_AXIS_PROJECTION_OFFSET = 1440.000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('X_AXIS_PROJECTION_OFFSET: '+HeadbangerString);
        HeadbangerDouble:=Strtofloat(HeadbangerString);
        DLGPB1.Text:=Floattostr(HeadbangerDouble);
      end;
      If ((pos('Y_AXIS_PROJECTION_OFFSET',HeadString)>0)
      or (pos('SAMPLE_PROJECTION_OFFSET',HeadString)>0)) then
      begin {Y_AXIS_PROJECTION_OFFSET = 486.425}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('Y_AXIS_PROJECTION_OFFSET: '+HeadbangerString);
        HeadbangerDouble:=Strtofloat(HeadbangerString);
        DLGPC1.Text:=Floattostr(HeadbangerDouble);
      end;
      {A_AXIS_RADIUS        = 3393.40
       B_AXIS_RADIUS        = 3393.40
       C_AXIS_RADIUS        = 3375.73
       FIRST_STANDARD_PARALLEL = "N/A"
       SECOND_STANDARD_PARALLEL = "N/A"
       POSITIVE_LONGITUDE_DIRECTION = WEST ??? never ever??}
      If pos('CENTER_LATITUDE',HeadString)>0 then
      begin {CENTER_LATITUDE      = 0.00000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('CENTER_LATITUDE: '+HeadbangerString);
      end;
      If pos('CENTER_LONGITUDE',HeadString)>0 then
      begin {CENTER_LONGITUDE     = 135.00000}
        HeadbangerString:=Copy(HeadString,pos('=',HeadString)+1,length(HeadString));
        If Pos('<', HeadbangerString) > 0 then
        begin
        HeadbangerString:=Copy(HeadbangerString,1,pos('<',HeadbangerString));
        while Pos('<', HeadbangerString) > 0 do
              HeadbangerString[Pos('<', HeadbangerString)] := ' ';
        end;
        Trim(HeadbangerString);
        DEMtoBinMemo.LineS.Append('CENTER_LONGITUDE: '+HeadbangerString);
        HeadbangerDouble:=Strtofloat(HeadbangerString);
        DLGPD1.Text:=Floattostr(HeadbangerDouble);
      end;
       {REFERENCE_LATITUDE   = "N/A"
       REFERENCE_LONGITUDE  = "N/A"
       X_AXIS_FIRST_PIXEL   = 1   LINE_FIRST_PIXEL
       Y_AXIS_FIRST_PIXEL   = 1   SAMPLE_FIRST_PIXEL
       X_AXIS_LAST_PIXEL    = 680 LINE_LAST_PIXEL
               LINES          = 680
       Y_AXIS_LAST_PIXEL    = 974 SAMPLE_LAST_PIXEL
              LINE_SAMPLES   = 974
       MAP_PROJECTION_ROTATION = "N/A"}
    end;
  end;
  CloseFile(Head_File);
  HeadString:='';{Clears last BIG LINE}

  {Input a Laty Lonx to get Liney Samplex
  line = INT(X_AXIS_PROJECTION_OFFSET
            - lat*MAP_RESOLUTION + 1.0)
  line = Round(DLGPB1.Text - (lat* DLGPA1.Text) + 1.0))
  sample = INT(Y_AXIS_PROJECTION_OFFSET
              - (lon - CENTER_LONGITUDE)*
                 MAP_RESOLUTION*cos(lat) + 1.0)
  sample = Round(DLGPC1.Text - ( (lon-DLGPD1.Text)
                                  *(DLGPA1.Text *cos(lat))+1.0));}

  MapZUnitsCB.Itemindex:=2;{Meters}
  NullValueEdit.Text :='0';
  PixelCoordinateCB.Itemindex:=0;{Center}
  InUtmZoneCB.Itemindex:=0;{=#16}
  UTMZoneNorthCB.Checked:={True;}
                 (StrtoFloat(BottomRightXEdit.Text)>0);
  IntegerorFloatCB.Checked:=(not ByteOrInt);{Integer.. no floats here: rounded}
  InUnitCB.Itemindex:=4; {D Degrees of arc}
  InDatumCB.Itemindex:=14;  {wgs84}
  SpheroidCB.Itemindex:=12;{wgs84}
  Application.ProcessMessages;
If (SwitchExt='.lbl') then
begin
InName:=ChangeFileExt(InName,'.img');
end;
  AssignFile(Bin_File, InName);
  Reset(Bin_File,1);
  if (IoResult = 0) then
  begin
If (SwitchExt='.img') then
begin
    for Xcount := 0 to HeaderSize - 1 do
    begin
      BlockRead(Bin_File, HeadButt, SizeOf(HeadButt), NumRead);
    end;
end;
    ProgressBar.Visible := True;
    Application.ProcessMessages;
    SetLength(ManMatrix,FileSizeX,FileSizeY );
    for Zcount := 0 to FileSizeY - 1 do
    begin
      ProgressBar.Position := Round((Zcount /
                    (FileSizeY - 1)) * 100);
      Application.ProcessMessages;
      for Xcount := 0 to FileSizeX - 1 do
      begin
        If ByteOrInt then
        begin {Should just convert into a .bmp}
          BlockRead(Bin_File, HeadButt,
                            SizeOf(HeadButt), NumRead);
          If Minin >HeadButt then Minin:=HeadButt;
          If Maxin <HeadButt then Maxin:=HeadButt;
          ManMatrix[Xcount,Zcount]:=HeadButt;
        end else
        begin
          BlockRead(Bin_File, ElevationCount,
                            SizeOf(ElevationCount), NumRead);
          ElevationCount := Swap(ElevationCount);
          ManMatrix[Xcount,Zcount]:=ElevationCount;
        end;
      end;
    end;
    CloseFile(Bin_File);
    if (IoResult <> 0) then DoMessages(25005);
  end else DoMessages(25006);
  Application.ProcessMessages;
        If ByteOrInt then
        begin
        WriteProjectionFile(ChangeFileExt(InName,'.vrp'));
        MatrixBmp(ChangeFileExt(InName,'.bmp'),
                                 Minin,Maxin);
        end else
        begin
          WriteProjectionFile(ChangeFileExt(InName,'.bit'));
          WriteBitFile(ChangeFileExt(InName,'.bit'));
          If DoTpcfg=0 then
          WriteTpcfgFile(ChangeFileExt(InName,'.bit'));
        end;
  SetLength(ManMatrix,0,0 );
  ProgressBar.Visible :=False;
End;

{Duplicated from TImageMakerForm}
procedure THtfForm.MatrixBmp(InFile:String;Min,Max:Integer);
type
  TLogPal = record
     lpal : TLogPalette;
     pe : Array[0..255] of TPaletteEntry;
  end;
var
   Ratio, x, y : Integer;
   bmp : TBitmap;
   scanLine : {PChar; }PByteArray;
   logpal : TLogPal;
   BackupName:String;
begin
      bmp:=  TBitMap.Create;
      bmp.PixelFormat:=pf8bit;
      bmp.Width:=FileSizeX;
      bmp.Height:=FileSizeY;
      Ratio:=Round((Max - Min)/255);
      for x:=0 to 255 do with logPal.lpal.palPalEntry[x] do
      begin
         peRed:=x;
         peGreen:=x;
         peBlue:=x;
         peFlags:=0;
      end;
      with logpal.lpal do
      begin
         palVersion:=$300;
         palNumEntries:=256;
      end;
      bmp.Palette:=CreatePalette(logPal.lpal);
          for y := FileSizeY- 1 downto 0 do
          begin
            ProgressBar.Position :=
            Round((y / FileSizeY) * 100);
            Application.ProcessMessages;
            scanLine:=bmp.ScanLine[y];
            for x := 0 to FileSizeX- 1 do
            begin
              scanLine[x]:=(ManMatrix[x, y] div Ratio);
            end;
          end;
    if FileExists(InFile) then
    begin
      BackupName := ExtractFileName(InFile);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(InFile, BackupName) then
        showmessage('Unable to create backup file.');
    end;
   bmp.SaveToFile(InFile);
   bmp.Free;
end;


(*************************************************************)
{      SetDefaultDEMProj;
FileSizeX,FileSizeY
NullValueEdit.Text
IntegerorFloatCB.Checked
SourceCB.ItemIndex
WriteTpcfgFile(InfileName:String);}
procedure THtfForm.WriteTpcfgFile(InfileName:String);
var
  IntegerorFloatCBChecked:Boolean;
{  SourceCBItemIndex:Integer;}
  MyFilesS:String;
  tpcfgfile:textfile;
Begin
  IntegerorFloatCBChecked:=IntegerorFloatCB.Checked;
(*  SourceCBItemIndex:=SourceCB.ItemIndex;
0: NA
1: 10M dem
2: 30M dem
3: 30AS dem
4: NOAA Globe
5: Gtopo
6: Etopo2
7: Etopo
8, {___}
9: Unknown
10: VTP BT
11: NIMA DTED
12: Surfer .grd
13: Arc .grd
14: Ascii XYZ
15: 10M SRTM dem
16: 30M SRTM dem
17: Mars 1 Degree
18: Mars 0.5 Degree
19: Mars 1/4 Degree
20: Mars 1/16 Degree
21: Mars 1/64 Degree
22: Mars 1/256 Degree
23: Venusian 1/64 Degree
24: Venusian 1/?? Degree*)
      AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(InfileName),'.tpcfg'));
      Rewrite(tpcfgfile);
      {HTFName=F:\HTF\etopo2.htf} {path includes \  ??}
      MyFilesS:='HTFName='+HTFPath{+'\'}+ChangeFileExt(ExtractFileName(InfileName),'.htf');
      Writeln(tpcfgfile,MyFilesS);
      {WorldSizeX=10800}
      MyFilesS:='WorldSizeX='+IntToStr(FileSizeX);
      Writeln(tpcfgfile,MyFilesS);
      {WorldSizeY=6336}
      MyFilesS:='WorldSizeY='+IntToStr(FileSizeY);
      Writeln(tpcfgfile,MyFilesS);
      {TileSize=128}
      MyFilesS:='TileSize='+IntToStr(128);
      Writeln(tpcfgfile,MyFilesS);
      {DefaultZ=0}
      MyFilesS:='DefaultZ='+NullValueEdit.Text;
                     {IntToStr(-32767);}{-32767 NullDatumValue}
      Writeln(tpcfgfile,MyFilesS);
      {DEMPath=F:\DEM}
      MyFilesS:='DEMPath='+DEMPath;
      Writeln(tpcfgfile,MyFilesS);
{bit 32 (single)
bit 16 (Intel)}
If IntegerorFloatCBChecked then
        MyFilesS:='DEMs="'
                +ExtractFileName(ChangeFileExt(InfileName,'.bit'))
                +',""0,0"",'+
                IntToStr(FileSizeX)+'x'+
                IntToStr(FileSizeY)+',""bit 16 (Intel)"""'
else
        MyFilesS:='DEMs="'
                +ExtractFileName(ChangeFileExt(InfileName,'.bit'))
                +',""0,0"",'+
                IntToStr(FileSizeX)+'x'+
                IntToStr(FileSizeY)+',""bit 32 (single)"""';
      Writeln(tpcfgfile,MyFilesS);
      CloseFile(tpcfgfile);
End;
{16 bits (Intel)
16 bits (non-Intel)
VTP BT (single)
bit 32 (single)
bit 16 (Intel)}


procedure THtfForm.Openbit1Click(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=DemPath;
  ODTerrainPack.Filter:= 'bit files (*.bit)|*.bit';
  if ODTerrainPack.Execute then
  begin
    if LowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.bit' then
    begin
      ReadAlittleBit(ODTerrainPack.FileName);
    end;
  end;
end;
procedure THtfForm.ReadAlittleBit(Filename:String);
var
  siSinData:SmallInt;
  typein, txin, tyin, tx,ty:Integer;
  scanLine : PColor32Array;
  bmpTile : TBitmap32;
begin
  ReadAnyVersionProj(FileName);
  ReadBitFile(FileName);
  PageControl1.ActivePage:=BitShpViewerTS;
  txin:=StrtoInt(XWidthEdit.Text);
  tyin:=StrtoInt(YHeightEdit.Text);
  BitShpImage.Width:= txin;
  BitShpImage.Height:= tyin;
  BitShpImage.SetupBitmap;
  bmpTile:=TBitmap32.Create;
  bmpTile.Width:= txin;
  bmpTile.Height:= tyin;
      If IntegerorFloatCB.Checked then typein:=1 else
         typein:=0;{1=Integer, 0=Float}
      If typein=1 then
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        scanLine:=bmpTile.ScanLine[ty];
        for tx:=0 to txin-1 do
        begin
            siSinData :=ManMatrix[tx,ty];
             scanLine[tx]:=heightColor[siSinData];
        end;
      end;
      end else
      begin
      for ty:=0 to tyin-1 do
      begin
        ProgressBar.Position:=
           Round((( ty)/tyin)*100);
        Application.ProcessMessages;
        scanLine:=bmpTile.ScanLine[ty];
        for tx:=0 to txin-1 do
        begin
            siSinData :=trunc(sManMatrix[tx,ty]);
             scanLine[tx]:=heightColor[siSinData];
        end;
      end;
     end;
  BitShpImage.Bitmap.Draw(0, 0, bmpTile);
  SetLength(ManMatrix,0,0);
  SetLength(sManMatrix,0,0);
  bmpTile.Free;
  ProgressBar.Position:=0;
End;

procedure THtfForm.Openshp1Click(Sender: TObject);
begin
  ODTerrainPack.InitialDir:=ShapePath;
  ODTerrainPack.Filter:= 'Shape files (*.shp)|*.shp';
  if ODTerrainPack.Execute then
  begin
    if LowerCase(ExtractFileExt(ODTerrainPack.FileName)) = '.shp' then
    begin
      ReadAlittleShp(ODTerrainPack.FileName);
    end;
  end;
end;
procedure THtfForm.ReadAlittleShp(Filename:String);
var gotloaded:Boolean;
begin
  PageControl1.ActivePage:=BitShpViewerTS;
  ShapePath := ExtractFilePath(Filename);
  ShpFileName := Filename;
  HtfForm.Cursor:=crHourGlass; {crDefault}
  gotloaded:=False;
  LayersLoaded:=0;
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[(LayersLoaded-1)]:= LayersLoaded;
  If DTMform.LoadLayer then gotloaded:=True;
  If gotloaded then DrawShape;
  {Clear this data}    {dec(LayersLoaded);}
  LayersLoaded:=0;
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded{+1});
  SetLength(LayersControlArray,LayersLoaded);
  HtfForm.Cursor:=crDefault;
End;
{==============================================================}
procedure THtfForm.DrawShape;
var
 LayerDo, Startat, INumparts,  INumPoints,
 ShapeType, ShapeToDo, DXI,DYI,iiV,iV,
 NumShape, NumParts, NumPoints: integer;
 DXdtemp,DYdtemp:Double;
 XShift, YShift, Ratio, xdiff, ydiff, XTemp, YTemp: Double;
 Editarray:Array of TPoint;
 PointColor:TColor;
begin
  If LayersLoaded>0 then
  Begin
    BitShpImage.Width := 600;
    BitShpImage.Height := 333;
    BitShpImage.SetupBitmap;
    BitShpImage.Bitmap.Clear(Color32(MapBacksColor));
{    LayA[CurrentLayer].XMin:= dXMIN;
    LayA[CurrentLayer].YMin:= dYMIN;
    LayA[CurrentLayer].XMax:= dXMAX;
    LayA[CurrentLayer].YMax:= dYMAX;}

      xdiff := abs(LayA[CurrentLayer].YMax - LayA[CurrentLayer].XMin);
      ydiff := Abs(LayA[CurrentLayer].YMax - LayA[CurrentLayer].YMin);
      if (xdiff > ydiff) then Ratio := (xdiff / 600) else
        Ratio := (ydiff / 333);
      if dXMIN < 0 then begin XShift := abs(dXMIN) end
      else if dXMIN > 0 then XShift := (0 - dXMIN) else XShift := 0;
      if dYMIN < 0 then begin YShift := abs(dYMIN) end
      else if dYMIN > 0 then YShift := (0 - dYMIN) else YShift := 0;

    For Startat:=0 to LayersLoaded-1 do
    Begin
      LayerDo:=LayersControlArray[Startat];
      ShapeType:= LayA[LayerDo].ShpType;
      NumShape:= LayA[LayerDo].ShapeN;
      {Could change each layer color...}
      BitShpImage.Bitmap.PenColor := Color32(MapDatasColor);
      PointColor:= Color32(MapDatasColor);
          {Point Type, Box, Numpoints, Points }
      If ((ShapeType=1) or(ShapeType=11) or(ShapeType=21)) then
      begin
        For ShapeToDo:=1 to NumShape do
        Begin
          dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].XMax;
          dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].YMax;
                XTemp := dXTemp + XShift;
                YTemp := dYTemp + YShift;
                iV := trunc((XTemp / Ratio));
                iiV :=333- trunc((YTemp /Ratio));
          BitShpImage.Bitmap.FillRect(iV-2,iiV-2,iV+2,iiV+2,PointColor);
        end;
      end else
      If ( (ShapeType=3) or (ShapeType=13) or (ShapeType=23)or
         (ShapeType=5) or (ShapeType=15) or (ShapeType=25)
         {MultiPoint 1 Part of Many Points}
         or(ShapeType=8) or(ShapeType=18) or(ShapeType=28)
         {31 blocked out Fans and Strips}
         )then
      begin
        For ShapeToDo:=1 to NumShape do
        Begin
          Application.ProcessMessages;
          Numparts:=LayA[LayerDo].LyrShp[ShapeToDo].PartsN;{Numparts}
          for INumparts := 1 to Numparts do
          begin {Always at least 1 0...}
            NumPoints:=LayA[LayerDo].LyrShp[ShapeToDo].PPA[INumparts];
            {Make Poly array}
            SetLength(Editarray,NumPoints);
            for INumPoints := 1{2} to NumPoints do
            begin {2 points internally}
              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
                XTemp := dXTemp + XShift;
                YTemp := dYTemp + YShift;
                iV := trunc((XTemp / Ratio));
                iiV := 333-trunc((YTemp /Ratio));
              Editarray[INumPoints-1].X:= iV;
              Editarray[INumPoints-1].Y:= iiV;
            end;{INumPoints}
            begin
              BitShpImage.Bitmap.MoveTo(Editarray[0].X, Editarray[0].Y);
              for INumPoints := 2 to NumPoints do
                BitShpImage.Bitmap.LineToS(Editarray[INumPoints-1].X,
                                        Editarray[INumPoints-1].Y);
            end;
          end;{INumparts}
        end; {For ShapeToDo}
      end;
    end;{LayerDo}
  end;{CurrentLayer}
  SetLength(Editarray,0);
End;
{==============================================================}
{==============================================================}
procedure THtfForm.MoonPCBtnClick(Sender: TObject);
begin
{Need List of ALL required files}
end;

procedure THtfForm.MarsPCBtnClick(Sender: TObject);
begin
{Need List of ALL required files}
end;
{==============================================================}
{==============================================================}
procedure THtfForm.Open2Click(Sender: TObject);
begin
  ODTerrainPack.Filter:= 'ImagePack Configuration (*.ipcfg)|*.ipcfg';
  ODTerrainPack.InitialDir:=ProgramPath;
  ODTerrainPack.Filename:='*.ipcfg';
   if ODTerrainPack.Execute then
      DoIpcfgOpen(ODTerrainPack.FileName);
end;
procedure THtfForm.DoIpcfgOpen(Filename:String);
var
   i : Integer;
   sl, sg : TStringList;
begin
      sl:=TStringList.Create;
      sl.LoadFromFile(FileName);
      with sl do begin
         RifPathEdit.Text:=Values['RIFName'];
         RifSizeX.Text:=Values['WorldSizeX'];
         RifSizeY.Text:=Values['WorldSizeY'];
         RifTileSize.Text:=Values['TileSize'];
         DefaultDataEdit.Text:=Values['Default'];
         RifBandsEdit.Text:=Values['Bands'];
         ImagePathEdit.Text:=Values['ImagePath'];
         sg:=TStringList.Create;
         sg.CommaText:=Values['BandNames'];
         StringGrid1.RowCount:=sg.Count+1;
         for i:=0 to sg.Count-1 do
            StringGrid1.Rows[i+1].CommaText:=sg[i];
         sg.Free;
      end;
      sl.Free;
      SDTerrainPack.FileName:=FileName;
end;

procedure THtfForm.Save2Click(Sender: TObject);
var
   i : Integer;
   sl, sg : TStringList;
begin
  SDTerrainPack.Filter:= 'ImagePack Configuration (*.ipcfg)|*.ipcfg';
  SDTerrainPack.Filename:=ProgramPath+ChangeFileExt(ExtractFileName(RifPathEdit.Text),'.ipcfg');
  SDTerrainPack.InitialDir:=ProgramPath;
  if SDTerrainPack.Execute then
  begin
      sl:=TStringList.Create;
      with sl do begin
         Values['RIFName']:=RifPathEdit.Text;
         Values['WorldSizeX']:=RifSizeX.Text;
         Values['WorldSizeY']:=RifSizeY.Text;
         Values['TileSize']:=RifTileSize.Text;
         Values['Default']:=DefaultDataEdit.Text;
         Values['Bands']:=RifBandsEdit.Text;
         Values['ImagePath']:=ImagePathEdit.Text;
         sg:=TStringList.Create;
         for i:=1 to StringGrid1.RowCount-1 do
            sg.Add(StringGrid1.Rows[i].CommaText);
         Values['BandNames']:=sg.CommaText;
         sg.Free;
      end;
      sl.SaveToFile(SDTerrainPack.FileName);
      sl.Free;
   end;
end;



procedure THtfForm.AddImageSource1Click(Sender: TObject);
begin
   StringGrid1.RowCount:=StringGrid1.RowCount+1;
end;

procedure THtfForm.RemoveImageSource1Click(Sender: TObject);
var
   i : Integer;
begin
   with StringGrid1 do begin
      i:=Row;
      if i<RowCount-1 then begin
         while i<RowCount-1 do begin
            Rows[i]:=Rows[i+1];
            Inc(i);
         end;
      end else Row:=i-1;
      RowCount:=RowCount-1;
   end;
end;
{==============================================================}

{==============================================================}
procedure THtfForm.ViewCurrentrifvrp1Click(Sender: TObject);
begin {Image 02}
  SDTerrainPack.Filter:= 'RIF Files (*.rif)|*.rif';
  SDTerrainPack.Filename:=HTFPath+'*.rif';
  SDTerrainPack.InitialDir:=HTFPath;
  If SDTerrainPack.Execute then
  If FileExists(SDTerrainPack.FileName) then
  begin
    If FileExists(ChangeFileExt(SDTerrainPack.FileName,'.vrp')) then
    ReadAnyVersionProj(ChangeFileExt(SDTerrainPack.FileName,'.vrp'));
  end;
  {      if ((WhoAmI1 <32) and (WhoAmI2=3)) then
      ReadImageProj(ReadFileName);   }
end;

procedure THtfForm.SetCurrentrifvrp1Click(Sender: TObject);
begin
  SDTerrainPack.Filter:= 'RIF Files (*.rif)|*.rif';
  SDTerrainPack.Filename:=HTFPath+'*.rif';
  SDTerrainPack.InitialDir:=HTFPath;
  If SDTerrainPack.Execute then
  If FileExists(SDTerrainPack.FileName) then
  begin
    If FileExists(ChangeFileExt(SDTerrainPack.FileName,'.vrp')) then
    WriteImageProjectionFile(ChangeFileExt(SDTerrainPack.FileName,'.vrp'));
  end;
end;
{==============================================================}

{==============================================================}
{Double	5.0 x 10^324 .. 1.7 x 10^308	1516	8 bytes=64bit
Integer	2147483648..2147483647	signed 32-bit =4 bytes}
procedure THtfForm.ReadImageProj(ReadFileName:String);
var
  outfile:file;
  ProjData:Smallint;{	32768..32767}{2 bytes}
  WhoAmI:Char;
  WhoAmI1,WhoAmI2:Byte;
  txin, tyin, {typein,}
  TempInteger,NumRead: Integer;
  sSinData:Single;
  dSinData:Double;
  WhereString:String;
Begin
      AssignFile(outfile, ReadFileName);
      ReSet(outfile,1);              {(11 * 2 = 22)}
      { (2*1=2) +4 + (2*4=8 +1=9) +8 + (2*2=4+9=13)
         (new)
      + (3*2=6)+6free) +(26 * 8 = 208) = 256}
      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      BlockRead(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      if ((WhoAmI1 <26) and (WhoAmI2=2)) then
      begin
      ReadWriteLabel.Caption:='Reading';
      DemName.Caption:=ExtractFileName(ReadFileName);
      DemPath:= ExtractFilePath(ReadFileName);
      SourceCB.Itemindex:= WhoAmI1;
      MapProjRec.SourceCBItemindex:= WhoAmI1;
      VersionEdit.Text:=inttostr(WhoAmI2);
      MapProjRec.VersionEditText:=(WhoAmI2);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEXEWEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEXEWEditText:=(ProjData);
      Blockread(outfile,ProjData , Sizeof(ProjData), NumRead);
      SEYNSEdit.Text:=Inttostr(ProjData);
      MapProjRec.SEYNSEditText:=(ProjData);
      Blockread(outfile,txin , Sizeof(txin), NumRead);
      XWidthEdit.Text:=InttoStr(txin);
      MapProjRec.XWidthEditText:=(txin);
      Blockread(outfile,tyin , Sizeof(tyin), NumRead);
      YHeightEdit.Text:=InttoStr(tyin);
      MapProjRec.YHeightEditText:=(tyin);
{Byte=3}      Blockread(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      If WhoAmI1=1 then IntegerorFloatCB.Checked:=True else
         IntegerorFloatCB.Checked:=False;
      MapProjRec.IntegerorFloatCBChecked:=WhoAmI1;
      {WhereString is 4x6 Cell locator=8 Chars}
      WhereString:='        ';{8 chars}{unknown }
      For ProjData:=1 to 8 do
      begin
      Blockread(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
      WhereString[ProjData]:=WhoAmI;
      end;
      CellLocatorEdit.Text:=WhereString;
      MapProjRec.CellLocatorEditText:=WhereString;
{2*2=4+9=13}
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If WhoAmI1=1 then ValidProjectionCB.Checked:=True else
      ValidProjectionCB.Checked:=False;
      MapProjRec.ValidProjectionCBChecked:=WhoAmI1;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;  MapZUnitsCB.Itemindex:=TempInteger;
      MapProjRec.MapZUnitsCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   PixelCoordinateCB.Itemindex:=TempInteger;
      MapProjRec.PixelCoordinateCBItemindex:=TempInteger;
      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   NullValueEdit.Text :=InttoStr(TempInteger);
      MapProjRec.NullValueEditText:=ProjData;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   ProjectionCB.Itemindex:=TempInteger;
      MapProjRec.ProjectionCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InUnitCB.Itemindex:=TempInteger;
      MapProjRec.InUnitCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InUtmZoneCB.Itemindex:=TempInteger;
      MapProjRec.InUtmZoneCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If WhoAmI1=1 then UTMZoneNorthCB.Checked:=True else
      UTMZoneNorthCB.Checked:=False;
      MapProjRec.UTMZoneNorthCBChecked:=WhoAmI1;

      BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   StatePlaneZoneEdit.Text:=InttoStr(TempInteger);
      MapProjRec.StatePlaneZoneEditText:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   InDatumCB.Itemindex:=TempInteger;
      MapProjRec.InDatumCBItemindex:=TempInteger;
{Byte=1}      BlockRead(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
TempInteger:=WhoAmI1;   SpheroidCB.Itemindex:=TempInteger;
      MapProjRec.SpheroidCBItemindex:=TempInteger;

{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   CountryFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.CountryFipsCodeCBItemIndex:=TempInteger;
{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   StateFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.StateFipsCodeCBItemIndex:=TempInteger;
{new ver2} BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;   CountyFipsCodeCB.ItemIndex:=TempInteger;
      MapProjRec.CountyFipsCodeCBItemIndex:=TempInteger;
{2+4=6  bytes}
BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;
PixelsPerDegreeEdit.Text:=InttoStr(TempInteger);
      MapProjRec.PixelsPerDegreeEdit:=TempInteger;
      BlockRead(outfile,sSinData , Sizeof(sSinData), NumRead);
  KiloPerPixelEdit.Text:=FloattoStr(sSinData);
      MapProjRec.KiloPerPixelEdit :=(sSinData);
{...new ver2}
{26 *8}
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelXSizeEdit.Text :=FloattoStr(dSinData);
      MapProjRec.PixelXSizeEditText :=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  PixelYSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.PixelYSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  ZSizeEdit.Text:=FloattoStr(dSinData);
      MapProjRec.ZSizeEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  TopRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.TopRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomLeftYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomLeftYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightXEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightXEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  BottomRightYEdit.Text:=FloattoStr(dSinData);
      MapProjRec.BottomRightYEditText:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPA3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPA3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPB3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPB3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPC3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPC3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPD3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPD3Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE1.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE1Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE2.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE2Text:=(dSinData);
      BlockRead(outfile,dSinData , Sizeof(dSinData), NumRead);
  DLGPE3.Text:=FloattoStr(dSinData);
      MapProjRec.DLGPE3Text:=(dSinData);
  end else
  begin
    DemName.Caption:='NONE';
    DoMessages(25012);
  end;
      CloseFile(outfile);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  Application.ProcessMessages;
End;
{==============================================================}
{==============================================================}
procedure THtfForm.WriteImageProjectionFile(InfileName:String);
var
  WhoAmI1,WhoAmI2:Byte;
  WhoAmInot:Char;
  WhereString:String;
  outfile:file;
  ProjData{, iSinData}:SmallInt;   {smallint Datum}
  txin, tyin, {typein, tx, ty,} NumRead: Integer;
  sSinData:Single;
  dSinData:Double;
Begin
      AssignFile(outfile, InfileName);
      Rewrite(outfile,1);
  { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
      WhoAmI1:=SourceCB.Itemindex;
      WhoAmI2:=Strtoint(VersionEdit.Text);
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      Blockwrite(outfile,WhoAmI2 , Sizeof(WhoAmI2), NumRead);
      { SE Y:N-S and SE X:E-W degrees}
      ProjData:=StrToInt(SEXEWEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      ProjData:=StrToInt(SEYNSEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
      txin:=StrtoInt(XWidthEdit.Text);
      Blockwrite(outfile,txin , Sizeof(txin), NumRead);
      tyin:=StrtoInt(YHeightEdit.Text);
      Blockwrite(outfile,tyin , Sizeof(tyin), NumRead);
      If IntegerorFloatCB.Checked then WhoAmI1:=1 else
         WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
      WhereString:=CellLocatorEdit.Text;
      For ProjData:=1 to 8 do
      begin
      WhoAmInot:=WhereString[ProjData];
      Blockwrite(outfile,WhoAmInot , Sizeof(WhoAmInot), NumRead);
      end;

  If ValidProjectionCB.Checked then
  WhoAmI1:=1 else WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=MapZUnitsCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=PixelCoordinateCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
ProjData:=StrtoInt(NullValueEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI1:=ProjectionCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=InUnitCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=InUtmZoneCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  If UTMZoneNorthCB.Checked then
     WhoAmI1:=1 else WhoAmI1:=0;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
ProjData:=StrtoInt(StatePlaneZoneEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  WhoAmI1:=InDatumCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);
  WhoAmI1:=SpheroidCB.Itemindex;
      Blockwrite(outfile,WhoAmI1 , Sizeof(WhoAmI1), NumRead);

{new ver2}
ProjData:=CountryFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=StateFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
ProjData:=CountyFipsCodeCB.ItemIndex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

ProjData:=StrtoInt(PixelsPerDegreeEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  sSinData:=StrtoFloat(KiloPerPixelEdit.Text);
      Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead);

  dSinData:=StrtoFloat(PixelXSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(PixelYSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(ZSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(TopLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(TopRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(BottomRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

  dSinData:=StrtoFloat(DLGPA1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPA3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPB3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPC3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPD3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  dSinData:=StrtoFloat(DLGPE3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
  CloseFile(outfile);
End;
{==============================================================}
{==============================================================}

procedure THtfForm.RifBtnClick(Sender: TObject);
begin
  SDTerrainPack.Filter:= 'RIF Files (*.rif)|*.rif';
{  SDTerrainPack.Filename:=HTFPath+ChangeFileExt(ExtractFileName(RifPathEdit.Text),'.rif');
  SDTerrainPack.InitialDir:=HTFPath;}
   If FileExists(RifPathEdit.Text) then
   begin
     SDTerrainPack.InitialDir:=ExtractFilePath(RifPathEdit.Text);
     SDTerrainPack.FileName:=RifPathEdit.Text;
   end
   else
   begin
     SDTerrainPack.InitialDir:=HTFPath;
     SDTerrainPack.FileName:='*.*';
   end;
   if SDTerrainPack.Execute then
   begin
     HTFPath:=ExtractFilePath(SDTerrainPack.FileName);
     RifPathEdit.Text:=SDTerrainPack.FileName;
   end;
end;

procedure THtfForm.ImagePathBtnClick(Sender: TObject);
var   TransSearchDir:String;
begin
  If ImagePathEdit.Text='' then  TransSearchDir:= ImagePath
     else If (not FileExists(ImagePathEdit.Text))
          then TransSearchDir:= ImagePath
     else  TransSearchDir:=ImagePathEdit.Text;
  if SelectDirectory(TransSearchDir,
        [sdAllowCreate, sdPerformCreate, sdPrompt],
        SELDIRHELP) then
  begin
    ImagePath := TransSearchDir;
    ImagePathEdit.Text:=TransSearchDir+'\';
  end {else DoMessages(1)};
end;

procedure THtfForm.RifCbFilesChange(Sender: TObject);
begin
   with StringGrid1 do
      Cells[Col, Row]:=(Sender as TComboBox).Text;
end;

procedure THtfForm.ImagePathEditChange(Sender: TObject);
var
   f : TSearchRec;
   r : Integer;
   PathString:String;
begin
   RifCbFiles.Items.Clear;
      PathString:= ImagePathEdit.Text;
      If (PathString[Length(PathString)]<>'\')
      then PathString:=PathString+'\';
      ImagePathEdit.Text:=PathString;
   r:=FindFirst(ImagePathEdit.Text+'*.*', faAnyFile, f);
   while r=0 do begin
      if (f.Attr and faDirectory)=0 then
         RifCbFiles.Items.Add(f.Name);
      r:=FindNext(f);
   end;
   FindClose(f);
end;

procedure THtfForm.DefaultDataEditChange(Sender: TObject);
begin
   DefaultDataZ:=StrToIntDef(DefaultDataEdit.Text, 0);
end;

procedure THtfForm.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
   procedure SetCB(const cb : TComboBox);
   var
      r : TRect;
      i : Integer;
   begin
      r:=StringGrid1.CellRect(ACol, ARow);
      cb.Left:=r.Left+StringGrid1.Left;
      cb.Top:=r.Top+StringGrid1.Top;
      cb.Width:=r.Right+1-r.Left;
      i:=cb.Items.IndexOf(StringGrid1.Cells[ACol, ARow]);
      if i>=0 then
         cb.ItemIndex:=i
      else cb.Text:=StringGrid1.Cells[ACol, ARow];
      if Visible then
         cb.SetFocus;
   end;

begin
   if ARow>0 then begin
      if ACol=0 then begin
         RifCbFiles.Visible:=True;
         SetCB(RifCbFiles);
      end else RifCbFiles.Visible:=False;
      if ACol=1 then begin
         RifCBType.Visible:=True;
         SetCB(RifCBType);
      end else RifCBType.Visible:=False;
      CanSelect:=True;
   end;
end;




procedure THtfForm.IParse;
var
   i: Integer;
   PathString:String;
   row : TStrings;
begin
   ICleanup;
   SetLength(Isources, StringGrid1.RowCount-1);
   for i:=0 to High(Isources) do begin
      row:=StringGrid1.Rows[i+1];
      PathString:= ImagePathEdit.Text;
      If (PathString[Length(PathString)]<>'\')
      then PathString:=PathString+'\';
      ImagePathEdit.Text:=PathString;
      Isources[i].fs:=TFileStream.Create(PathString+row[0], fmOpenRead+fmShareDenyNone);
      Isources[i].x:=0;
      Isources[i].y:=0;
      Isources[i].w:=StrToInt(RifSizeX.Text);
      Isources[i].h:=StrToInt(RifSizeY.Text);
      Isources[i].bands:=StrToInt(RifBandsEdit.Text);
      Isources[i].format:=0;
   end;
end;

procedure THtfForm.ICleanup;
var
   i : Integer;
begin
   for i:=0 to High(Isources) do
      Isources[i].fs.Free;
   SetLength(Isources, 0);
end;


procedure THtfForm.Process2Click(Sender: TObject);
var
   bn, x, y, wx, wy, ts, tx, ty, i : Integer;
   n, maxN : Cardinal;
   rif : TImageTileFile;
   buf : array of Byte;{SmallInt;}
   f : file of Byte;
procedure {TMainForm.}WorldExtract(WEBands,x, y, len : Integer; dest : PByte{PSmallInt});
var
   i, n, rx, ry : Integer;
   WEsrc : PISrc;
procedure {TMainForm.}SrcExtract({src : PISrc;} SEBands, relX, relY, len : Integer; dest : PByte{PSmallInt});
var
leni,   i : Integer;
{   wd : Word;}
   abuf : array of Byte;{Single;}
   Srcsrc : PISrc;
begin
         begin // 8bits Intel
           for leni:=0 to len-1 do
           begin
             SetLength(abuf, SEBands+1);
             for i:=0 to High(Isources) do
             begin
               Srcsrc:=@Isources[i];
               with Srcsrc^ do
               begin
                 fs.Position:=(relX+relY*w);{for each Band}
                 fs.Read(abuf[i],1);
               end;
               PByte(Integer(dest)+leni*SEBands+i)^:=abuf[i];
             end;
           end;
         end;
end;

begin{WorldExtract(WEBands,x, y, len : Integer; dest : PByte}
   while len>0 do
   begin
      {src:=nil;}
       i:=0;
      WEsrc:=@Isources[i];
      {for i:=0 to High(Isources) do
      begin}
         if (Isources[i].x<=x) and (Isources[i].y<=y)
               and (x<Isources[i].x+Isources[i].w)
               and (y<Isources[i].y+Isources[i].h) then
         begin
         {   src:=@Isources[i];
            Break;
         end;
      end;
      if Assigned(src) then begin}
         rx:=x-WEsrc.x;
         ry:=y-WEsrc.y;
         n:=len;
         if rx+n>WEsrc.w then
            n:=WEsrc.w-rx;
         SrcExtract(WEBands, rx, ry, n,  dest);
         Dec(len, n);
         Inc(dest, n);
         Inc(x, n);
      end else begin
         dest^:=defaultDataZ;
         Inc(dest);
         Dec(len);
         Inc(x);
      end;
   end;
end;

begin
If DirectoryExists(ExtractFilePath(RifPathEdit.Text)) then
begin
  Screen.Cursor:=crHourGlass;
  wx:=StrToInt(RifSizeX.Text);
  wy:=StrToInt(RifSizeY.Text);
  ts:=StrToInt(RifTileSize.Text);
  bn:=StrToInt(RifBandsEdit.Text);
  IParse;
  SetLength(buf, ts*ts*bn);
  rif:=TImageTileFile.CreateNew(RifPathEdit.Text,bn, wx, wy, ts);
  rif.DefaultZ:=StrToInt(DefaultDataEdit.Text);{defaultZ;}
  ProgressBar.Max:=1000;
  maxN:=Ceil(wx/ts)*Ceil(wy/ts);
  n:=0;
  ProgressBar.Visible:=True;
  ProgressBar.Position:=0;
  y:=0;
  while y<wy do  {Height}
  begin
    ty:=wy-y;
    if ty>ts then ty:=ts; {hold to tile size}
    x:=0; while x<wx do
    begin
      tx:=wx-x;    {Width}
      if tx>ts then tx:=ts;
      Inc(n);
      ProgressBar.Position:=(n*1000) div maxN;
      {THIS is where the rubber rubs
      Need to do  Bands of data for ONLY 1 XxY World Set}
      for i:=0 to ty-1 do
          WorldExtract(bn,x, y+i, tx, @buf[i*tx*bn]);
      rif.CompressTile(bn,x, y, tx, ty, @buf[0]);
      Inc(x, ts);
      if (n and 15)=0 then
      begin
        Application.ProcessMessages;
      end;
    end;
    Inc(y, ts);
  end;
  rif.Free;
  ICleanup;
  {Get file info for display}
  AssignFile(f, RifPathEdit.Text);
  Reset(f);
  i:=FileSize(f);
  CloseFile(f);
  ProgressBar.Position:=0;
  Screen.Cursor:=crDefault;
  ShowMessage( 'RIF file created.'#13#10#13#10
               +IntToStr(i)+' bytes in file'#13#10
               +'('+IntToStr(wx*wy*bn)+' raw bytes)');
end;
end;
{==============================================================}
{==============================================================}
{00 : Unknown
01 : Alabama
02 : Alaska
04 : Arizona
05 : Arkansas
06 : California
08 : Colorado
09 : Connecticut
10 : Delaware
11 : District of Columbia
12 : Florida
13 : Georgia
15 : Hawaii
16 : Idaho
17 : Illinois
18 : Indiana
19 : Iowa
20 : Kansas
21 : Kentucky
22 : Louisiana
23 : Maine
24 : Maryland
25 : Massachusetts
26 : Michigan
27 : Minnesota
28 : Mississippi
29 : Missouri
30 : Montana
31 : Nebraska
32 : Nevada
33 : New Hampshire
34 : New Jersey
35 : New Mexico
36 : New York
37 : North Carolina
38 : North Dakota
39 : Ohio
40 : Oklahoma
41 : Oregon
42 : Pennsylvania
44 : RhodeIsland
45 : South Carolina
46 : South Dakota
47 : Tennessee
48 : Texas
49 : Utah
50 : Vermont
51 : Virginia
53 : Washington
54 : West Virginia
55 : Wisconsin
56 : Wyoming
60 : American Samoa
66 : Guam
69 : Northern Mariana Islands
70 : Palau
72 : Puerto Rico
78 : Virgin Islands (US)
74 : US MINOR OUTLYING ISLANDS
64 : FEDERATED STATES OF MICRONESIA
68 : MARSHALL ISLANDS}
(*0: NA
1: 10M dem
2: 30M dem
3: 30AS dem
4: NOAA Globe
5: Gtopo
6: Etopo2
7: Etopo
8, {___}
9: Unknown
10: VTP BT
11: NIMA DTED
12: Surfer .grd
13: Arc .grd
14: Ascii XYZ*)
{==============================================================}
{==============================================================}

end.

