{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmGlHeight;
//Landscape Demo By Ren Lindsay  program Navigator;
{Drag with the Left mouse-button to rotate the camera.
Use the mouse-wheel, or slider to adjust camera distance.
Use the cursor keys to control the actor around the terrain.}

{TGLProcTextureClouds GLProcTextures.pas
To use it you have to set the
Material.Texture.ImageClassName to "Procedural Clouds"
have fun Tobias Peirick (www.TobSoft.de)}
interface

uses
  Windows, Messages, SysUtils, Classes, ExtDlgs,
  Graphics, Controls, Forms, Dialogs, ExtCtrls,StdCtrls,
  Buttons, ComCtrls, Keyboard, jpeg,
  GLScene, GLMisc, GLObjects, GLWin32Viewer,
  GLCadencer, Joystick,
  GLGraph, GLVectorFileObjects, Geometry, VectorTypes,
  GLSkydome, GLTexture, GLProcTextures,
  GLFireFX, GLParticleFX, GLThorFX;


type
  TdtmGlHeightForm = class(TForm)
    Panel1: TPanel;
    GLCadencer1: TGLCadencer;
    TimeLabel: TLabel;
    CBAnimations: TComboBox;
    DistanceBar: TTrackBar;
    SBPlay: TSpeedButton;
    SBStop: TSpeedButton;
    SBFrameToFrame: TSpeedButton;
    GLSceneViewer1: TGLSceneViewer;
    GLScene1: TGLScene;
    GLLightSource1: TGLLightSource;
    GLCamera1: TGLCamera;
    Actor1: TGLActor;
    ActorCube: TGLDummyCube;
    HeightField1: TGLHeightField;
    AllObjects: TGLDummyCube;
    CameraCube: TGLDummyCube;
    AfterSky: TGLDummyCube;
    FogBox: TCheckBox;
    Label1: TLabel;
    Label3: TLabel;
    Timer1: TTimer;
    OpenPictureDialog1: TOpenPictureDialog;
    Edit1: TEdit;
    HeightTrackBar1: TTrackBar;
    HeightMaxMinCB: TCheckBox;
    LoadActorBtn: TSpeedButton;
    FlyCB: TCheckBox;
    Actor2: TGLActor;
    FlyByCube: TGLDummyCube;
    FlyByGLCamera: TGLCamera;
    ShapeObjCB: TCheckBox;
    OpenDialog1: TOpenDialog;
    ShpFreeForm: TGLFreeForm;
    FlyByLight: TGLLightSource;
    Joystick1: TJoystick;
    FlyHiCB: TCheckBox;
    otsBtn: TSpeedButton;
    CloudHeightTrackBar: TTrackBar;
    CloudWidthTrackBar: TTrackBar;
    CloudCoverTrackBar: TTrackBar;
    CloudSharpnessTrackBar: TTrackBar;
    Label2: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    GLMaterialLibrary1: TGLMaterialLibrary;
    procedure HandleKeys(const deltaTime: Double);
    procedure GLCadencer1Progress(Sender: TObject;
               const deltaTime, newTime: Double);
    procedure FormCreate(Sender: TObject);
    procedure SBPlayClick(Sender: TObject);
    procedure SBStopClick(Sender: TObject);
    procedure SBFrameToFrameClick(Sender: TObject);
    procedure CBAnimationsChange(Sender: TObject);
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject;
             Shift: TShiftState;
             X, Y: Integer);
    procedure DistanceBarChange(Sender: TObject);
    procedure FormMouseWheel(Sender: TObject;
               Shift: TShiftState;
               WheelDelta: Integer;
               MousePos: TPoint;
               var Handled: Boolean);
    procedure ActorDo(action:string; perform:boolean);
    procedure Timer1Timer(Sender: TObject);
    procedure HeightField1GetHeight(const x, y: Single; var z: Single;
      var color: TVector4f; var texPoint: TTexPoint);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormHide(Sender: TObject);
procedure FormShowDown;
    procedure HeightTrackBar1Change(Sender: TObject);
    procedure HeightMaxMinCBClick(Sender: TObject);
    procedure ShapeObjCBClick(Sender: TObject);
procedure HandleJoy(const deltaTime: Double);
    procedure Joystick1JoystickButtonChange(Sender: TObject;
      JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
      YDeflection: Integer);
    procedure FlyHiCBClick(Sender: TObject);
    procedure LoadActorBtnClick(Sender: TObject);
procedure DoQcOpen(const fileName : String);
    procedure otsBtnClick(Sender: TObject);
procedure LoadActorots(Filename:String);
{    procedure CloudSharpnessTrackBarChange(Sender: TObject);
    procedure CloudCoverTrackBarChange(Sender: TObject);
    procedure CloudWidthTrackBarChange(Sender: TObject);
    procedure CloudHeightTrackBarChange(Sender: TObject);}
  private
    { Private declarations }
  public
    { Public declarations }
    ProjectLoaded, ObjectsDone, ActorLoaded:Boolean;
  end;

var
  dtmGlHeightForm: TdtmGlHeightForm;
  JoyX, JoyY, OldJoyX, OldJoyY,{:Single;}
  CloudAnime,
  mx,my,mx2,my2:integer;
  FdeltaTime: Double;

implementation

{$R *.DFM}

uses

dtmfrm, dtmPOFvar, USMDStuff, DtmShpSaver, dtmGlobals;

procedure TdtmGlHeightForm.FormCreate(Sender: TObject);
begin
  top := DtmGlBaseFormY;
  left := DtmGlBaseFormX;
  FdeltaTime:=0;
  CloudAnime:=0;
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  ActorLoaded:=False;
  ObjectsDone:=False;
  ProjectLoaded:=False;
  Heightfield1.Material.Texture.Disabled:=True;{False;}
end;

procedure TdtmGlHeightForm.FormShowDown;
var ILoad:Integer;
begin
  Joystick1.Capture:=True;
  Heightfield1.Material.Texture.Disabled:=False;
  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True;
  Heightfield1.StructureChanged;
  Application.ProcessMessages;
  if Joystick1.Capture=False then
  begin
    FlyCB.Enabled:=False;
    FlyHiCB.Enabled:=False;
  end else
  begin
    JoyX:=Joystick1.XPosition+JoyCentroidX;
    OldJoyX:=Joystick1.XPosition+JoyCentroidX;
    JoyY:=Joystick1.YPosition+JoyCentroidY;
    OldJoyY:=Joystick1.YPosition+JoyCentroidY;
    Joystick1.Threshold:=ThresholdBarPosition;
    Joystick1.Interval:=IntervalBarPosition;
  end;
  If isRunningOnDtp then
  Begin {Load Actor, etc... Shape Objects,... ???}
    If ProjectLoaded then exit;
  If ((ProjectActorOtsFilename<> NoName)
      and( FileExists(ProjectActorOtsFilename)) )then
      begin
        LoadActorots(ProjectActorOtsFilename);
        For ILoad := 1 to  LayersLoaded do
        begin
        end;
        ProjectLoaded:=True;
      end;
  End;
end;

procedure TdtmGlHeightForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  DtmGlBaseFormY := dtmGlHeightForm.top;
  DtmGlBaseFormX := dtmGlHeightForm.left;
  DoSaver;
end;
procedure TdtmGlHeightForm.FormHide(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
end;
{==========================================================}
{==========================================================}


{==============================================================}
{==============================================================}
procedure TdtmGlHeightForm.FlyHiCBClick(Sender: TObject);
begin
  {Change CAMERA ... thus keys and Mouse have no effect}
  If FlyHiCB.Checked then
  begin
    FlyByCube.position:=CameraCube.Position;
    FlyByGLCamera.position:=FlyByCube.Position;
    GLSceneViewer1.Camera:= FlyByGLCamera;
  end else GLSceneViewer1.Camera:= GLCamera1;
end;

procedure TdtmGlHeightForm.Joystick1JoystickButtonChange(Sender: TObject;
  JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
  YDeflection: Integer);
var
   button1,button2,button3,button4 : TJoystickButton;
   Dist, NewDist,cx,cy,cz :single;
begin
  If FlyHiCB.Checked then
  begin
    NewDist:=1;
    Dist:=FlyByGLCamera.DistanceToTarget;
    cx:=FlyByGLCamera.Position.x;
    cy:=FlyByGLCamera.Position.y;
    cz:=FlyByGLCamera.Position.z;
    {Hat buttons...}
    button1:=jbButton1;
    button2:=jbButton2;
    button3:=jbButton3;
    button4:=jbButton4;
    If ((button1 in buttons)
     and(button2 in buttons)
     and(button3 in buttons)
     and(button4 in buttons)) then
    begin
      {up forward}
    end else
    If ((button1 in buttons)
     and(button2 in buttons)
     and(button3 in buttons)) then
    begin
      {back down}
    end else
    If ((button1 in buttons)
     and(button2 in buttons)
     and(button4 in buttons)) then
    begin
      {Right}
    end else
    If ((button1 in buttons)and(button2 in buttons)) then
    begin
      {Left}
    end else
    {Fire=1, Reset=2,  Up=3, Down=4}
    If button1 in buttons then
    begin
      {Explode actor}
    end else
    If button2 in buttons then
    begin
      {Reset Actor}
    end else
    If button3 in buttons then
    begin
      NewDist:=Dist +10;
    end else
    If button4 in buttons then
    begin
      NewDist:=Dist -10;
    end;
    If (NewDist<>1) then
    begin
      FlyByGLCamera.Position.x:=cx/dist*NewDist;
      FlyByGLCamera.Position.y:=cy/dist*NewDist;
      FlyByGLCamera.Position.z:=cz/dist*NewDist;
    end;
  end;
end;

procedure TdtmGlHeightForm.HandleJoy(const deltaTime: Double);
const
   cTurnSpeed = 100;
   cMoveSpeed = 9;
var
  JoyXChange,JoyYChange:Integer;
   Dist, NewDist,cx,cy,cz :single;
begin
  If FlyHiCB.Checked then
  begin
    NewDist:=1;
    Dist:=FlyByGLCamera.DistanceToTarget;
    cx:=FlyByGLCamera.Position.x;
    cy:=FlyByGLCamera.Position.y;
    cz:=FlyByGLCamera.Position.z;
      if IsKeyDown(VK_UP) then
         NewDist:=Dist +10 else
      if IsKeyDown(VK_DOWN) then
         NewDist:=Dist -10;
    If (NewDist<>1) then
    begin
      FlyByGLCamera.Position.x:=cx/dist*NewDist;
      FlyByGLCamera.Position.y:=cy/dist*NewDist;
      FlyByGLCamera.Position.z:=cz/dist*NewDist;
    end;

    JoyX:=Joystick1.XPosition+JoyCentroidX;
    JoyY:=Joystick1.YPosition+JoyCentroidY;
    if ((JoyX<>OldJoyX)or(JoyY<>OldJoyY)) then
    begin
      JoyXChange:=OldJoyX-JoyX;
      JoyYChange:=OldJoyY-JoyY;
      OldJoyX:=JoyX;
      OldJoyY:=JoyY;
      FlyByGLCamera.MoveAroundTarget(JoyXChange, JoyYChange);
    end;
  end;
end;
{==============================================================}
{==============================================================}
procedure TdtmGlHeightForm.HandleKeys(const deltaTime: Double);
const
  cTurnSpeed = 100;
  cMoveSpeed = 9;
  cRunBoost = 2;   // speed boost when running
var
   moving : String;
   boost : Double;
var
   hgt :single;
   HV :THomogeneousFltVector;
   tp  :TTexPoint;
   xpos,zpos :single;
   proxy : TGLProxyObject;
{var
  JoyXChange,JoyYChange:Integer;}
begin
  if IsKeyDown(VK_ESCAPE) then Close;
  moving:='stand';
   // first, are we running ? if yes give animation & speed a boost
  if IsKeyDown(VK_SHIFT) then
  begin
    Actor1.Interval:=150;{100;}
    boost:=cRunBoost*deltaTime
  end else
  begin
    Actor1.Interval:=100;{150;}
    boost:=deltaTime;
  end;
  Actor2.Interval:=Actor1.Interval;
  If FlyCB.Checked then
  begin
    JoyX:=Joystick1.XPosition+JoyCentroidX;
    JoyY:=Joystick1.YPosition+JoyCentroidY;
  end;
  if IsKeyDown(VK_UP) or IsKeyDown(VK_DOWN)
{     or (FlyCB.Checked)}
     or (JoyX<>OldJoyX)or(JoyY<>OldJoyY)
     or IsKeyDown(VK_LEFT) or IsKeyDown(VK_RIGHT) then
  begin
    if ((JoyX<>OldJoyX)or(JoyY<>OldJoyY)) then
       {  if (FlyCB.Checked) then}
    begin
      {JoyXChange:=OldJoyX-JoyX;
       JoyYChange:=OldJoyY-JoyY;}
      OldJoyX:=JoyX;
      OldJoyY:=JoyY;
      ActorCube.Turn(cTurnSpeed*(Joystick1.XPosition/100)*boost);
      ActorCube.Move(cMoveSpeed*(Joystick1.YPosition/100)*boost);
    end;{Joy}
    if IsKeyDown(VK_UP) or IsKeyDown(VK_DOWN)
     or IsKeyDown(VK_LEFT) or IsKeyDown(VK_RIGHT) then
    begin
      if IsKeyDown(VK_LEFT)    then
         ActorCube.Turn(-cTurnSpeed*boost)else      //rotate actor left
      if IsKeyDown(VK_RIGHT)   then
         ActorCube.Turn(cTurnSpeed*boost);       //rotate actor right
      if IsKeyDown(VK_UP) then
         ActorCube.Move(cMoveSpeed*boost) else
      if IsKeyDown(VK_DOWN) then
         ActorCube.Move(-cMoveSpeed*boost);
    end;{Keys}
     //calc actors position on heightfield
    xpos:=-(ActorCube.position.x/HeightField1.Scale.x);
    zpos:=(ActorCube.position.z/HeightField1.Scale.y);
    Heightfield1GetHeight(Xpos,Zpos,hgt,HV,tp);
    //get hgt ---this is the same procedure used
     //to get the heightfields heights
    ActorCube.position.Y:=
                 (hgt*HeightField1.Scale.z)
                 +(HeightField1.Position.y)+1.2;
      //place actor just above heightfield
    CameraCube.position:=ActorCube.Position;
    GLLightSource1.Position.X:=CameraCube.Position.X{*20};
    GLLightSource1.Position.Y:=CameraCube.Position.Y{*20};
    GLLightSource1.Position.Z:=CameraCube.Position.Z{*20};
    //move camera to actors position
    If ActorLoaded then
    begin
      ActorDo('run0',True);//play 'run0' animation
      moving:='run';
      Actor2.Synchronize(Actor1);
     {Firing Gun ?}
     {myFireFX := TGLBFireFX.Create(your_object_here.Effects);}
    end;
  end else If ActorLoaded then
  begin
    ActorDo('run0',False); //stop playing 'run0' animation
    moving:='run';
    Actor2.Synchronize(Actor1);
    {Firing Gun ?}
  end;
  if (ShapeObjCB.Checked and IsKeyDown(VK_CONTROL){VK_SPACE}) then
  begin
    proxy:=TGLProxyObject(AfterSky.AddNewChild(TGLProxyObject));
    with proxy do
    begin
      ProxyOptions:=[pooObjects];
      MasterObject:=ShpFreeForm;
       // retrieve reference attitude
      Direction:=ShpFreeForm.Direction;
      Up:=ShpFreeForm.Up;
      Scale.SetVector(0.05, 0.05, 0.05, 0);
      Position:=ActorCube.Position;
    end;
  end;

  //----   Move camera around the target.
  //----   This code is placed here so the
  //  camera-movements would not cause the Actor to pause
  // the key must move actor at same time else resets to standing
  if ((mx<>mx2)or(my<>my2)) then
  begin
    GLCamera1.MoveAroundTarget(my-my2, mx-mx2);
    //move the camera around the target if mouse was dragged
    mx:=mx2; my:=my2;
  end;

  if Actor1.CurrentAnimation<>moving then
  begin
    Actor1.SwitchToAnimation(moving);
    Actor2.Synchronize(Actor1);
  end;
end;



procedure TdtmGlHeightForm.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
   mx2:=x; my2:=y;
end;

procedure TdtmGlHeightForm.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if ssLeft in Shift then
   begin
      mx2:=x; my2:=y;
   end;
end;



procedure TdtmGlHeightForm.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
   GLCamera1.AdjustDistanceToTarget(Power(1.1, WheelDelta/120));
   //Adjust Camera distance with mousewheel
end;
procedure TdtmGlHeightForm.DistanceBarChange(Sender: TObject);
var
   Dist, NewDist,cx,cy,cz :single;
begin
   Dist:=GLCamera1.DistanceToTarget;
   cx:=GLCamera1.Position.x;
   cy:=GLCamera1.Position.y;
   cz:=GLCamera1.Position.z;
   NewDist:=DistanceBar.position;
   GLCamera1.Position.x:=cx/dist*NewDist;
   GLCamera1.Position.y:=cy/dist*NewDist;
   GLCamera1.Position.z:=cz/dist*NewDist;
end;


procedure TdtmGlHeightForm.HeightTrackBar1Change(Sender: TObject);
begin
  Heightfield1.StructureChanged;
end;

procedure TdtmGlHeightForm.HeightMaxMinCBClick(Sender: TObject);
begin
  Heightfield1.StructureChanged;
end;

procedure TdtmGlHeightForm.HeightField1GetHeight(
          const x, y: Single;
          var z: Single;
          var color: TVector4f;
          var texPoint: TTexPoint);
var
  val : integer;
begin
    If ((round(x*(FileSizeX-1))>0)and
        (round(x*(FileSizeX-1))<FileSizeX)and
        (((y)*(FileSizeY-1))>0)and
        (((y)*(FileSizeY-1))<FileSizeY))
    then
    begin
      val:=ManMatrix[round(x*(FileSizeX-1)),
                     round(y*(FileSizeY-1))];
      If HeightMaxMinCB.Checked then
         z:=val*(HeightTrackBar1.Position
                  /(  MaximumElevation-MinimumElevation))
         else z:=val*(HeightTrackBar1.Position/1000);
    end else z:=1; {Off the planet}
end;

{==============================================================}
{==============================================================}

{==============================================================}
{==============================================================}
{Scale ... Focal Length ... Height of Observer}
{Size of Object... Perspective ... X,Y,Z Location}
{Shape file Import into Vector Mesh
  <> Overlay as colors on bitmap
 Level of Detail <> Terrain Size}
 {Sun Azimuth for Lights .. Moon & Twinkle stars at night..}
  {Actors <> Objects}
  {md2..smd ??  Textures and Weapons
  3DS Point Objects .. Line Objects (Roads, Bridges)
  Billboard Textures for Objects}
{==============================================================}
{==============================================================}
procedure TdtmGlHeightForm.ShapeObjCBClick(Sender: TObject);
{var
   i : Integer;
   proxy : TGLProxyObject;
   s : TVector;
   Xpos,Zpos,f : Single;
   hgt :single;
   HV :THomogeneousFltVector;
   tp  :TTexPoint;}
const
  cSpread = 90;
  cNbMushrooms = 1;
begin
If ObjectsDone then
begin
{?? Kill the objects}
end else
  If ShapeObjCB.Checked then
  begin
    {Load the FreeForm data}
     // Load mushroom mesh
    OpenDialog1.Filter:='3ds or smd|*.3ds;*.smd';
    OpenDialog1.Filename:='*.3ds';
    OpenDialog1.InitialDir:=DXFPath;
    if OpenDialog1.Execute then
    begin
      If (ExtractFileExt(OpenDialog1.FileName)='.3ds')
         then DXFPath :=ExtractFilePath(OpenDialog1.FileName)
         else {TigerPath smd}
      If (ExtractFileExt(OpenDialog1.FileName)='.smd')
         then TigerPath :=ExtractFilePath(OpenDialog1.FileName);

      ShpFreeForm.LoadFromFile(OpenDialog1.FileName);
      ShpFreeForm.Scale.SetVector(0.05, 0.05, 0.05, 0);
      ShpFreeForm.Position:=ActorCube.Position;
      ObjectsDone:=True;
(*
      // spawn some more mushrooms using proxy objects
      for i:=0 to cNbMushrooms-1 do
      begin
        // create a new proxy and set its MasterObject property
        proxy:=TGLProxyObject(AfterSky.AddNewChild(TGLProxyObject));
        with proxy do
        begin
          ProxyOptions:=[pooObjects];
          MasterObject:=FreeForm1;
          // retrieve reference attitude
          Direction:=FreeForm1.Direction;
          Up:=FreeForm1.Up;
          Scale.SetVector(0.05, 0.05, 0.05, 0);
          // randomize scale to make them different sizes!
          s:=FreeForm1.Scale.AsVector;
          {f:=(Random);}
          f:=(Random(10)/10000);
          ScaleVector(s, f);
          Scale.AsVector:=s;
          Position:=ActorCube.Position;
          // randomize position
          {position.SetPoint(x, y, z : Single);}
          Position.SetPoint(Random(cSpread)-(cSpread/2),
                           FreeForm1.Position.z+0.8*f,
                           Random(cSpread)-(cSpread/2));
          //calc actors position on heightfield
          xpos:=-(position.x/HeightField1.Scale.x);
          zpos:=(position.z/HeightField1.Scale.y);
          Heightfield1GetHeight(Xpos,Zpos,hgt,HV,tp);
          //get hgt ---this is the same procedure used
          //to get the heightfieds heights
          position.Y:=
               (hgt*HeightField1.Scale.z)
               +(HeightField1.Position.y){+1.2};
          {Position.SetPoint(Random(cSpread)-(cSpread/2),
                           FreeForm1.Position.z+0.8*f,
                           Random(cSpread)-(cSpread/2));}

          // randomize orientation
          RollAngle:=Random(360);
          TransformationChanged;
        end;
      end;
*)
    end;
  end;
end;
{==============================================================}
{==============================================================}
procedure TdtmGlHeightForm.ActorDo(action:string; Perform:boolean);
begin
   if ((Action<>Actor1.CurrentAnimation)and(Perform=True)) then
      Actor1.SwitchToAnimation(action);
   if ((Action=Actor1.CurrentAnimation)and(Perform=False)) then
      Actor1.SwitchToAnimation('stand0');
   Actor2.Synchronize(Actor1);
end;



procedure TdtmGlHeightForm.SBPlayClick(Sender: TObject);
begin
   Actor1.AnimationMode:=aamLoop;
   SBPlay.Enabled:=False;
   SBStop.Enabled:=True;
   SBFrameToFrame.Enabled:=False;
end;

procedure TdtmGlHeightForm.SBStopClick(Sender: TObject);
begin
   Actor1.AnimationMode:=aamNone;
   SBPlay.Enabled:=True;
   SBStop.Enabled:=False;
   SBFrameToFrame.Enabled:=True;
end;

procedure TdtmGlHeightForm.SBFrameToFrameClick(Sender: TObject);
begin
   Actor1.NextFrame;
end;

procedure TdtmGlHeightForm.CBAnimationsChange(Sender: TObject);
begin
  If ActorLoaded then
  begin
    Actor1.SwitchToAnimation(CBAnimations.Text);
    Actor2.Synchronize(Actor1);
  end;
end;

{==============================================================}
{==============================================================}


{==============================================================}
{==============================================================}
procedure TdtmGlHeightForm.Timer1Timer(Sender: TObject);
begin
   Caption:=Format('%.1f FPS', [GLSceneViewer1.FramesPerSecond]);
   GLSceneViewer1.ResetPerformanceMonitor;
end;

procedure TdtmGlHeightForm.GLCadencer1Progress(Sender: TObject;
                const deltaTime, newTime: Double);
var NewnewTime:Double;
begin
  If FlyHiCB.Checked then HandleJoy(deltaTime)
     else HandleKeys(deltaTime);
   If ActorLoaded then
      TimeLabel.caption:=IntToStr(Round(DeltaTime*10000));
   {show sky}
  NewnewTime:= newTime/300;
  if (Trunc(NewnewTime*300)>CloudAnime) then
  begin
    TimeLabel.caption:=IntToStr(Trunc(NewnewTime*300));
    CloudAnime:=Trunc(NewnewTime*300);
    TGLProcTextureClouds(GLMaterialLibrary1.Materials[0].Material.Texture.Image).CloudAnimate(NewnewTime);
  end;
  GLMaterialLibrary1.Materials[0].TextureOffset.Y := -NewnewTime;
  GLMaterialLibrary1.Materials[0].TextureOffset.x := NewnewTime;

end;
{==============================================================}
{==============================================================}





{==============================================================}
{==============================================================}
Procedure TdtmGlHeightForm.LoadActorBtnClick(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  OpenDialog1.Filter := 'lifeless (*.qc)|*.qc';
  OpenDialog1.InitialDir := TigerPath;
  OpenDialog1.Filename:='*.qc';
  if OpenDialog1.Execute then
     DoQcOpen(OpenDialog1.FileName);
  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True;
End;
procedure TdtmGlHeightForm.DoQcOpen(const fileName : String);
var
   t: integer;
begin
  ActorLoaded:=False;
       TigerPath:=ExtractFilePath(FileName);
       Application.ProcessMessages;
       dtmGlHeightForm.Cursor:=crHourGlass;
{       Timer1.Enabled:=True;
       GLCadencer1.Enabled:=True;  }
       // LOAD THE Filename, into Actor1, with MODEL, + with ANIMATIONS
       LoadQC(FileName,Actor1,True,True);

   {  BoneIndex_Spine := GetBoneIndexByName(Actor1,'Bip01 Spine');
     BoneIndex_Head := GetBoneIndexByName(Actor1,'Bip01 Head');}

     for t := 1 to Actor1.Animations.Count-1 do
     begin
          cbAnimations.Items.Add(Actor1.Animations[t].Name);
     end;

     Actor1.OverlaySkeleton:=False;
{     Actor1.Interval := 50;}
      ActorLoaded:=True;
     Actor1.SwitchToAnimation(Actor1.Animations[1]);

     cbAnimations.ItemIndex := cbAnimations.Items.IndexOf(Actor1.Animations[1].Name);

{     AlreadyLoaded := True;}

     dtmGlHeightForm.Cursor:=crDefault;

end;
(*
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  ActorLoaded:=False;
  begin
    {Load Actor base}
    OpenDialog1.Filter:='actor |*.md2;*.smd';
    OpenDialog1.InitialDir:=TigerPath;
    OpenDialog1.Filename:='*.*';
    if OpenDialog1.Execute then
    begin
      TigerPath:=ExtractFilePath(OpenDialog1.FileName);
      //----Load the main Actor and skin----
      Actor1.LoadFromFile(OpenDialog1.FileName{'.\alita\tris.md2'});
      {Load Actor texture}
      OpenDialog1.Filter:='md2 texture (jpg)|*.jpg;*.bmp';
      OpenDialog1.InitialDir:=TigerPath;
      OpenDialog1.Filename:='*.*';
      if OpenDialog1.Execute then
      begin
        Actor1.Material.Texture.Image.LoadFromFile(ChangeFileExt(OpenDialog1.FileName,'.jpg'){'.\alita\alita2.jpg'});
        Actor1.Scale.SetVector(0.05, 0.05, 0.05, 0);
        {Actor Weapon}
        OpenDialog1.Filter:='md2 weapon |*.md2';
        OpenDialog1.InitialDir:=TigerPath;
        OpenDialog1.Filename:='*.md2';
        if OpenDialog1.Execute then
        begin
          Actor2.LoadFromFile(OpenDialog1.FileName);
          {Load Actor texture}
          OpenDialog1.Filter:='weapon texture (jpg)|*.jpg';
          OpenDialog1.InitialDir:=TigerPath;
          OpenDialog1.Filename:='*.jpg';
          if OpenDialog1.Execute then
          begin
            Actor2.Material.Texture.Image.LoadFromFile(OpenDialog1.FileName);
          end;
          Actor2.Animations.Assign(Actor1.Animations);
          ActorLoaded:=True;
        end;
      end;
      // Define animation properties
      Actor1.AnimationMode:=aamLoop;
      Actor1.FrameInterpolation:=afpLinear;
      Actor1.Animations.SetToStrings(CBAnimations.Items);
      CBAnimations.ItemIndex:=0;
      CBAnimationsChange(Self);
      If ActorLoaded then Actor2.Synchronize(Actor1);
      ActorLoaded:=True;
    end;
  end;
  Timer1.Enabled:=True;
  GLCadencer1.Enabled:=True;
end;
*)


procedure TdtmGlHeightForm.otsBtnClick(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  ActorLoaded:=False;
  begin
    OpenDialog1.Filter:='Object + Texture Set (*.ots)|*.ots';
    OpenDialog1.InitialDir:=ProjectPath;
    OpenDialog1.Filename:='*.ots';
    if OpenDialog1.Execute then
    begin
      if UpperCase(ExtractFileExt(OpenDialog1.Filename)) = '.OTS' then
      begin
        LoadActorots(OpenDialog1.Filename);
        ProjectLoaded:=True;
        Timer1.Enabled:=True;
        GLCadencer1.Enabled:=True;
      end;
    end;
  end;
end;
procedure TdtmGlHeightForm.LoadActorots(Filename:String);
var
 ActorFileName,TextureFileName,
 WeaponFileName, WpnTextureFileName,
 S : string;
 F: TextFile;
 begin
        ProjectPath:=ExtractFilePath(Filename);
        AssignFile(F, FileName);
        Reset(F);
        Readln(F, S);
        If (S='GlobalObjectActorTerrain Version 1.0') then
        begin
           {Read file and get ActorFileName
             and TextureFileName
                  WeaponFileName
                  WpnTextureFileName
               Filenames...}
    Readln(F, S);  If S <> 'True' then exit;
    Readln(F, S);
    Readln(F, S);
    Readln(F, S);
    Readln(F, S);
          Readln(F, ActorFileName);
          If FileExists(ActorFileName) then
          If lowercase(ExtractFileExt(ActorFileName))='qc' then
          DoQcOpen(ActorFileName)else Exit;
          {Actor1.LoadFromFile(ActorFileName) else Exit;}
          Readln(F, TextureFileName);
          If FileExists(TextureFileName) then
          Actor1.Material.Texture.Image.LoadFromFile(TextureFileName);
          Actor1.Scale.SetVector(0.05, 0.05, 0.05, 0);
          Readln(F, WeaponFileName);
          If FileExists(WeaponFileName) then
          Actor2.LoadFromFile(WeaponFileName);
          Readln(F, WpnTextureFileName);
          If FileExists(WpnTextureFileName) then
          Actor2.Material.Texture.Image.LoadFromFile(WpnTextureFileName);
          CloseFile(F);
          Actor2.Animations.Assign(Actor1.Animations);
          ActorLoaded:=True;
          // Define animation properties
          Actor1.AnimationMode:=aamLoop;
          Actor1.FrameInterpolation:=afpLinear;
          Actor1.Animations.SetToStrings(CBAnimations.Items);
          CBAnimations.ItemIndex:=0;
          CBAnimationsChange(Self);
          If ActorLoaded then Actor2.Synchronize(Actor1);
          ActorLoaded:=True;
        end;
      {end;
    end;
  end}
end;
{==============================================================}
{==============================================================}





{==============================================================}
{==============================================================}

{procedure TdtmGlHeightForm.CloudSharpnessTrackBarChange(Sender: TObject);
var cs : single;
begin
  cs := CloudSharpnessTrackBar.Position/100;
  Label2.Caption := FloatToStr(cs);
  TGLProcTextureClouds(GLMaterialLibrary1.Materials[0].Material.Texture.Image).CloudSharpness := cs;
end;

procedure TdtmGlHeightForm.CloudCoverTrackBarChange(Sender: TObject);
var cc : Byte;
begin
  cc := CloudCoverTrackBar.Position;
  Label4.Caption := IntToStr(cc);
  TGLProcTextureClouds(GLMaterialLibrary1.Materials[0].Material.Texture.Image).CloudCover := cc;
end;

procedure TdtmGlHeightForm.CloudWidthTrackBarChange(Sender: TObject);
var cw : Integer;
begin
  cw := CloudWidthTrackBar.Position;
  Label6.Caption := IntToStr(cw);
  TGLProcTextureClouds(GLMaterialLibrary1.Materials[0].Material.Texture.Image).Width := cw;
end;

procedure TdtmGlHeightForm.CloudHeightTrackBarChange(Sender: TObject);
var ch : Integer;
begin
  ch := CloudHeightTrackBar.Position;
  Label8.Caption := IntToStr(ch);
  TGLProcTextureClouds(GLMaterialLibrary1.Materials[0].Material.Texture.Image).Height := ch;
end;}

end.
