{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{         Displays all error Messages et al.            }
{*******************************************************}
unit dtmErrMsg;
{by Ivan Lee Herring, 2002}

interface

uses
  Windows,
  Classes,
  Messages,   Graphics, Controls,
  Shellapi,{ShellExecute}
  Forms,{App}
  Dialogs{MessageDlg},
  Sysutils{Filestuff};

var
  MMSysHandle: THandle;
  PlaySound: function(lpszSoundName: PAnsiChar; uFlags: UINT): BOOL;
  stdcall;

function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;

procedure Codefx(WhatString: string; Codein: Integer);
function C2S(X: Extended): string;
function I2S(X: Integer): string;

Function DoConfirm(Choice: Integer):Word;
procedure DoMessages(Choice: Integer);
procedure DoRezError(Choice: Integer);

procedure RunProgress(WhatString,Codein: Integer);

implementation

uses
dtmPOFvar,dtmProgressFrm,
dtmGlobals;

{$R Messages.res}
{Compile the Messages..rc file at the DOS prompt call:
brcc32 Messages}

procedure RunProgress(WhatString,Codein: Integer);
Begin
  Case Codein of
  -1: {Start display}
  begin
  dtmProgressForm.Show;
  dtmProgressForm.ProgressBar1.Position:=0;
  end;
  0: dtmProgressForm.Hide{Hide away};
  1..101: {Display Progress in whatever form}
  dtmProgressForm.ProgressBar1.Position:=Codein;
  end;
End;

procedure DoRezError(Choice: Integer);
Begin
  DoMessages(Choice);
End;
{uses hAbout;}
function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..255] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;
{nil="open"	=opens the file specified by lpFile. }
{FileName=Grafree.exe}
{Params=Signal and Text filename}
{DefaultDir=This apps location as the file is created there}
{ShowCmd=SW_SHOWNORMAL}

function C2S(X: Extended): string;
var TempStr: string;
begin
  str(X: 24: 18, TempStr);
  C2S := TempStr;
end;

function I2S(X: Integer): string;
var
  TempStr: string;
begin
  str(X, TempStr);
  I2S := TempStr;
end;

procedure Codefx(WhatString: string; Codein: Integer);
var CodeS: string;
begin
  if Codein > 0 then
  begin
    str(Codein, CodeS);
    ShowMessage('Error in File data Number: ' + #13#10 +
      CodeS + #13#10 +
      WhatString);
  end;
end;

{---------------------------------------------------------------}
Function DoConfirm(Choice: Integer):Word;
var
  Messagestr: string;
  HelpContextl: Longint;
{  s:array[0..79] of Char;}
  Ch:array[0..255] of Char;
begin
  HelpContextl := 110;

(*case Choice of
    32501{10001}: Messagestr := 'Reduce Image to fit page?';
    32502{10002}: Messagestr := 'Database Exists: Append? '
                 +#13#10+'(Yes), Replace (No), Abort (Cancel)';
    end;                 *)
     If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then
     Messagestr := StrPas(Ch)+Tempname else
     begin
     Showmessage(NeedlessErrorMessage);
     Result:=0;
     Exit;  {Exits from the current procedure.}
     end;

  case Choice of
    32500..32760:
    Result:=MessageDlgPos(Messagestr,
        mtConfirmation,
       {[mbOK],} mbYesNoCancel,
        HelpContextl,
        MessageX,
        MessageY);
    else Result:=0;{mrNone;}
    end;
end;

procedure DoMessages(Choice: Integer);
var
  Messagestr: string;
  HelpContextl: Longint;
  s:array[0..79] of Char;{sound file names}
  Ch:array[0..255] of Char;
begin
  case Choice of
  1..7499{9999} : {mtInformation} HelpContextl := 111;
  7500..14999{10000..19999}: {mtConfirmation}HelpContextl := 112;
  15000..22499{20000..29999}:{ mtWarning}HelpContextl := 113;
  else{25000..30000 =>30000..40000:}{ mtError}HelpContextl := 114;
  end;{..32760}

  case Choice of
  1..30000:
  If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then
     Messagestr := StrPas(Ch) else
     begin
     Showmessage(NeedlessErrorMessage);
     Exit;  {Exits from the current procedure.}
     end;
{  30001..31000:}

    {30001: Messagestr := 'Error changing '+Tempname ;}
    {30002: Messagestr := 'Error opening file '+Tempname ;}
30001..30002:
     If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then
     Messagestr := StrPas(Ch)+Tempname else
     begin
     Showmessage(NeedlessErrorMessage);
     Exit;  {Exits from the current procedure.}
     end;
30003:
     If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then
     begin
     Messagestr := StrPas(Ch)+Tempname;
     If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then exit;
     Messagestr := Messagestr+StrPas(Ch);
     end else
     begin
     Showmessage(NeedlessErrorMessage);
     Exit;  {Exits from the current procedure.}
     end;
    {30003: Messagestr := 'Unable to delete the file: '+
                    #13#10 + Tempname +
     30004               #13#10+'Perhaps this file is still in use, ' +
                    #13#10+'or is write-protected ?';}

    {31001: Messagestr := 'Test Sound';}{Done.wav special}
    31001:
     If LoadString(hInstance, Choice,@Ch,sizeof(Ch))<>0 then
     Messagestr := StrPas(Ch)+Tempname else
     begin
     Showmessage(NeedlessErrorMessage);
     Exit;  {Exits from the current procedure.}
     end;
   end;{Case}

  case Choice of {2,147,483,648..2,147,483,647}
{mtInformation	A message box containing a blue "i".}
    1..7499:
    begin
        if ((WarningBeepOn) and (not VoicesON)) then Beep;
        if ((WarningBeepOn) and (VoicesON)) then
        begin
          if (FileExists(InfoString))then
          begin
            StrPCopy(s, InfoString);
            if (MMSysHandle <> 0) then  PlaySound(s,  0);
          end else beep;
        end;
    MessageDlgPos(Messagestr,
        mtInformation,
        [mbOK], {mbYesNoCancel,}
        HelpContextl,
        MessageX,
        MessageY);
        end;
{mtConfirmation	A message box containing a green question mark.}
    7500..14999{10000..19999}:
    begin
        if ((WarningBeepOn) and (not VoicesON)) then Beep;
        if ((WarningBeepOn) and (VoicesON)) then
        begin
          if (FileExists(ConfirmationString))then
          begin
            StrPCopy(s, ConfirmationString);
            if (MMSysHandle <> 0) then  PlaySound(s,  0);
          end else beep;
        end;
    MessageDlgPos(Messagestr,
        mtConfirmation,
                {[mbOK],} mbYesNoCancel,
        HelpContextl,
        MessageX,
        MessageY);
        end;
{mtWarning   A message box containing a yellow exclamation point symbol.}
    15000..22499{20000..29999}:
    begin
        if ((WarningBeepOn) and (not VoicesON)) then Beep;
        if ((WarningBeepOn) and (VoicesON)) then
        begin
          if (FileExists(WarnString))then
          begin
            StrPCopy(s, WarnString);
            if (MMSysHandle <> 0) then  PlaySound(s,  0);
          end else beep;
        end;
    MessageDlgPos(Messagestr,
        mtWarning,
        [mbOK], {mbYesNoCancel,}
        HelpContextl,
        MessageX,
        MessageY);
        end;
{mtError  A message box containing a red stop sign.}
    25000..31000{30000..41000}:
    begin
        if ((WarningBeepOn) and (not VoicesON)) then Beep;
        if ((WarningBeepOn) and (VoicesON)) then
        begin
          if (FileExists(ErrorString))then
          begin
            StrPCopy(s, ErrorString);
            if (MMSysHandle <> 0) then  PlaySound(s,  0);
          end else beep;
        end;

        MessageDlgPos(Messagestr,
          mtError,
          [mbOK], {mbYesNoCancel,}
          HelpContextl,
          MessageX,
          MessageY);
      end;
    31001{80001}:
    begin
        if ((WarningBeepOn) and (not VoicesON)) then Beep;
        if ((WarningBeepOn) and (VoicesON)) then
        begin
          if (FileExists(DoneString))then
          begin
            StrPCopy(s, DoneString);
            if (MMSysHandle <> 0) then  PlaySound(s,  0);
          end else beep;
        end;
      end;{case}
  end;
end;

{---------------------------------------------------------------------}

end.
