{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmEcotypeColorsFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  Buttons, Grids, ComCtrls;

type
  TdtmEcotypeColorsForm = class(TForm)
    DrawGrid1: TDrawGrid;
    ColorDialog1: TColorDialog;
    EcoHelpBtn: TSpeedButton;
    EcoColorPrintBtn: TSpeedButton;
    EcoColorResetBtn: TSpeedButton;
    EcoSelectColorsBtn: TSpeedButton;
    ColorPanel: TPanel;
    ColorValuesPanel: TPanel;
    AcceptColorBtn: TSpeedButton;
    Label30: TLabel;
    Label19: TLabel;
    Label18: TLabel;
    Red: TLabel;
    Edit3: TEdit;
    Edit2: TEdit;
    Edit1: TEdit;
    EcoTypeEdit: TEdit;
    EcoDescEdit: TEdit;
    SetBitmapBtn: TSpeedButton;
    Image1: TImage;
    ColorRowV: TUpDown;
    ColorColumnHLabel: TLabel;
    SetBitmapEdit: TEdit;
    OpenFileNameBtn: TSpeedButton;
    SaveFileNameBtn: TSpeedButton;
    FileNameEdit: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ElevationMinEdit: TEdit;
    ElevationMaxEdit: TEdit;
    ElevationEdit: TEdit;
    REMinEdit: TEdit;
    REMaxEdit: TEdit;
    REEdit: TEdit;
    SlopeMinEdit: TEdit;
    SlopeMaxEdit: TEdit;
    SlopeEdit: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ColorColumnH: TUpDown;
    ColorRowVLabel: TLabel;
    DirectionEdit: TEdit;
    DirectionMaxEdit: TEdit;
    DirectionMinEdit: TEdit;
    Label2: TLabel;
    DisplayBitsCB: TCheckBox;
    StretchCB: TCheckBox;
    USNVCEdit: TEdit;
    RECEdit: TEdit;
    GeologyEdit: TEdit;
    StreamOrderEdit: TEdit;
    LatitudeEdit: TEdit;
    LatitudeMaxEdit: TEdit;
    LatitudeMinEdit: TEdit;
    RainEdit: TEdit;
    RainMaxEdit: TEdit;
    RainMinEdit: TEdit;
    TempEdit: TEdit;
    TempMaxEdit: TEdit;
    TempMinEdit: TEdit;
    LongitudeEdit: TEdit;
    LongitudeMaxEdit: TEdit;
    LongitudeMinEdit: TEdit;
    DensityEdit: TEdit;
    DensityMaxEdit: TEdit;
    DensityMinEdit: TEdit;
    HeightEdit: TEdit;
    HeightMaxEdit: TEdit;
    HeightMinEdit: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    EcoProcessedCB: TCheckBox;
    USNVCIDCB: TCheckBox;
    EcotypeComputedCB: TCheckBox;
    EcotypeValidCB: TCheckBox;
    Label14: TLabel;
    StreamSourceEdit: TEdit;
    EcoResultCB: TCheckBox;
    EcoLevelUpDown: TUpDown;
    EcoLevelLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure EcoHelpBtnClick(Sender: TObject);

    procedure DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure EcoColorResetBtnClick(Sender: TObject);

procedure SetEcoData;
procedure SetEcoBoolean;
procedure GetEcoBoolean;

    procedure AcceptColorBtnClick(Sender: TObject);
    procedure EcoSelectColorsBtnClick(Sender: TObject);
    procedure EcoColorPrintBtnClick(Sender: TObject);

procedure SpareChange;
procedure GettheColor;

    procedure OpenFileNameBtnClick(Sender: TObject);
    procedure SaveFileNameBtnClick(Sender: TObject);
    procedure SetBitmapBtnClick(Sender: TObject);
    procedure ColorRowVClick(Sender: TObject; Button: TUDBtnType);
    procedure ColorColumnHClick(Sender: TObject; Button: TUDBtnType);
    procedure StretchCBClick(Sender: TObject);
    procedure EcoLevelUpDownClick(Sender: TObject; Button: TUDBtnType);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmEcotypeColorsForm: TdtmEcotypeColorsForm;

implementation

{$R *.DFM}

uses dtmEcoReader, dtmPOFvar, dtmGlobals, dtmErrMsg, dtmEcoDbFrm;

procedure TdtmEcotypeColorsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  dtmEcotypeColorsFormY := dtmEcotypeColorsForm.top;
  dtmEcotypeColorsFormX := dtmEcotypeColorsForm.left;
  DoSaver;
end;

procedure TdtmEcotypeColorsForm.FormCreate(Sender: TObject);
var I, J: LongInt;
  Fooled: Boolean;
begin
  top := dtmEcotypeColorsFormY;
  left := dtmEcotypeColorsFormX;
  {EcoRecord[ChangeColX,ChangeRowY]}

  Fooled := True;
  for I := 0 to 9 do begin {ColX}
    for J := 0 to 9{16} do begin {RowY}
      {ACol,  ARow}
      ChangeCol :=I;
      ChangeRow :=J;
      LoadEcoRecordDefaults;
      DrawGrid1SelectCell(Sender, I, J, Fooled);
    end;
  end;
  ChangeCol :=0;
  ColorColumnH.Position:=0;
  ChangeRow :=0;
  ColorRowV.Position:=0;
  EcoLevelsProcessed:=0;
  EcoBool[0]:=False;
  SetEcoBoolean;
end;


procedure TdtmEcotypeColorsForm.FormShow(Sender: TObject);
{var I, J: LongInt;
  Fooled: Boolean;}
begin
  EcoLevelUpDown.Position:=EcoLevelsProcessed;
(*
  {EcoRecord[ChangeColX,ChangeRowY]}
  SetLength(EcoRecord, 10, 10);
  Fooled := True;
  for I := 0 to 9 do begin {ColX}
    for J := 0 to 9{16} do begin {RowY}
      {ACol,  ARow}
      ChangeCol :=I;
      ChangeRow :=J;
      LoadEcoRecordDefaults;
      DrawGrid1SelectCell(Sender, I, J, Fooled);
    end;
  end;
  ChangeCol :=0;
  ColorColumnH.Position:=0;
  ChangeRow :=0;
  ColorRowV.Position:=0;
  SetEcoBoolean;     *)
end;

{---------------------------------------------------------------}
procedure TdtmEcotypeColorsForm.EcoHelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(6500);
end;
{---------------------------------------------------------------}

procedure TdtmEcotypeColorsForm.DrawGrid1DrawCell(Sender: TObject;
  ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
  DrawGrid1.Canvas.Brush.Color := EcoRecord[ACol,ARow].Color;
  DrawGrid1.Canvas.FillRect(Rect);
end;


procedure TdtmEcotypeColorsForm.DrawGrid1SelectCell(Sender: TObject;
          ACol,  ARow: Integer; var CanSelect: Boolean);
begin
  {Select the Cell, Place Color values in The Edits
   When whatever Accept Color Button is pressed
   then change the Color of THIS CELL
   DrawGrid1.Cells[Col,Row]=}
  CanSelect := True;
  foobar := false;
  ChangeRow := ARow;
  ChangeCol := ACol;
  ColorColumnH.Position:=ChangeCol;
  ColorRowV.Position:=ChangeRow;
  ColorColumnHLabel.Caption:= Inttostr(ChangeCol+1);
  ColorRowVLabel.Caption:= Inttostr(ChangeRow+1);
  SpareChange;
end;

procedure TdtmEcotypeColorsForm.ColorRowVClick(Sender: TObject;
  Button: TUDBtnType);
begin
  ChangeRow := ColorRowV.Position;
  foobar := false;
  SpareChange;
  ColorRowVLabel.Caption:= Inttostr(ChangeRow+1);
end;

procedure TdtmEcotypeColorsForm.ColorColumnHClick(Sender: TObject;
  Button: TUDBtnType);
begin
  ChangeCol := ColorColumnH.Position;
  foobar := false;
  SpareChange;
  ColorColumnHLabel.Caption:= Inttostr(ChangeCol+1);
end;
(*****************************************************)
(*****************************************************)

procedure TdtmEcotypeColorsForm.EcoColorPrintBtnClick(Sender: TObject);
begin
{Form contains Db and Design Criteria Choices
Size of Bitmap > 2 Reports?
{Make a db and print to a report}
{Print out the Color Swatch}
  Try
    EcoDbForm.Show;
    EcoDbForm.FormSetup;
  Except
    DoMessages(30005);
  End;
end;

(*****************************************************)
(*****************************************************)

procedure TdtmEcotypeColorsForm.EcoSelectColorsBtnClick(Sender: TObject);
var RString, GString, BString: string;
begin
  foobar := false;
  if ColorDialog1.Execute then
  begin
    ColorPanel.Color := ColorDialog1.Color;
    Str(GetRValue(ColorPanel.Color), RString);
    Str(GetGValue(ColorPanel.Color), GString);
    Str(GetBValue(ColorPanel.Color), BString);
    ColorValuesPanel.Caption :=
    'B:' + BString + ' G:' + GString +' R:' + RString;
    Edit1.Text := RString;
    Edit2.Text := GString;
    Edit3.Text := BString;
  end;
end;


procedure TdtmEcotypeColorsForm.SpareChange;
var RString, GString, BString: string;
begin
  GettheColor;
  Str(GetRValue(ChangingColor), RString); Edit1.Text := RString;
  Str(GetGValue(ChangingColor), GString); Edit2.Text := GString;
  Str(GetBValue(ChangingColor), BString); Edit3.Text := BString;
  ColorValuesPanel.Caption :=
    'B:' + BString + ' G:' + GString +' R:' + RString;
  ColorPanel.Color := ChangingColor;
  Application.ProcessMessages;
end;

{FloatToStrF(Value: Extended; Format: TFloatFormat; Precision, Digits: Integer)}
procedure TdtmEcotypeColorsForm.GettheColor;
var BitMap:TBitMap;
begin
  SetEcoData;
  If DisplayBitsCB.Checked then
  begin
    If FileExists(EcoRecord[ChangeCol,ChangeRow].ColorBitmap) then
    begin
      BitMap := TBitMap.create;
      BitMap.LoadFromFile(EcoRecord[ChangeCol,ChangeRow].ColorBitmap);
      {  PixelScanSize := 3;   pf24bit  PixelScanSize := 4;   pf32bit  }
      BitMap.PixelFormat := pf24bit;
      {FileSizeX:=Bitmap.Width;
      FileSizeY:=Bitmap.Height;}
      Image1.Assign(BitMap);
      If StretchCB.Checked then Image1.Stretch := True
                           else Image1.Stretch := False;
      BitMap.Free;
    end;
  end;
  ChangingColor := EcoRecord[ChangeCol,ChangeRow].Color;
  if foobar then EcoRecord[ChangeCol,ChangeRow].Color := ColorChanging;
End;
(********************************************************************)
procedure TdtmEcotypeColorsForm.EcoColorResetBtnClick(Sender: TObject);
var I,J:Integer;
begin
  CurrentColor := clBlack;
  for I := 0 to 9 do begin {Col}
    for J := 0 to 9{16} do begin {Row}
      ChangeCol:=i;
      ChangeRow:=j;
      LoadEcoRecordDefaults;
    end;
  end;
  ChangeCol :=0;
  ColorColumnH.Position:=0;
  ChangeRow :=0;
  ColorRowV.Position:=0;
  EcoBool[0]:=False;{CHANGED ONLY by Program Action!!!}
  EcoBool[1]:=False;
  EcoBool[2]:=False;
  EcoBool[3]:=False;
  EcoBool[4]:=False;
  SetEcoBoolean;
  SetEcoData;
end;
(********************************************************************)
procedure TdtmEcotypeColorsForm.SetEcoData;
Begin

  SetBitmapEdit.Text:={ExtractFileName}(EcoRecord[ChangeCol,ChangeRow].ColorBitmap);
  EcoTypeEdit.Text :=EcoRecord[ChangeCol,ChangeRow].TypeLevel;
  EcoDescEdit.Text:=EcoRecord[ChangeCol,ChangeRow].Desc;

  GeologyEdit.Text:=EcoRecord[ChangeCol,ChangeRow].Geology;
  StreamOrderEdit.Text:=EcoRecord[ChangeCol,ChangeRow].StreamOrder;
  StreamSourceEdit.Text:=EcoRecord[ChangeCol,ChangeRow].StreamSource;
  USNVCEdit.Text:=EcoRecord[ChangeCol,ChangeRow].USNVC;
  RECEdit.Text:=EcoRecord[ChangeCol,ChangeRow].REC;

  ElevationMinEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].ElevMin);
  ElevationMaxEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].ElevMax);
  ElevationEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].ElevSharpness);

  REMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].REMin,ffFixed,15,4);{Double}
  REMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].REMax,ffFixed,15,4);{Double}
  REEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].RESharpness);

  SlopeMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].SlopeMin,ffFixed,15,4);
  SlopeMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].SlopeMax,ffFixed,15,4);
  SlopeEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].SlopeSharpness);

  DirectionMinEdit.Text:=floattostr(EcoRecord[ChangeCol,ChangeRow].SlopeDirMin);
  DirectionMaxEdit.Text:=floattostr(EcoRecord[ChangeCol,ChangeRow].SlopeDirMax);
  DirectionEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness);

  LatitudeMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].LatitudeMin,ffFixed,15,4);
  LatitudeMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].LatitudeMax,ffFixed,15,4);
  LatitudeEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness);

  LongitudeMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].LongitudeMin,ffFixed,15,4);
  LongitudeMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].LongitudeMax,ffFixed,15,4);
  LongitudeEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness);

  RainMinEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgRainMin);
  RainMaxEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgRainMax);
  RainEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness);

  TempMinEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgTempMin);
  TempMaxEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgTempMax);
  TempEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness);

  DensityMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].VegDensityMin,ffFixed,15,4);
  DensityMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].VegDensityMax,ffFixed,15,4);
  DensityEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness);

  HeightMinEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].VegHeightMin,ffFixed,15,4);
  HeightMaxEdit.Text:=FloattostrF(EcoRecord[ChangeCol,ChangeRow].VegHeightMax,ffFixed,15,4);
  HeightEdit.Text:=Inttostr(EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness);
End;

procedure TdtmEcotypeColorsForm.SetEcoBoolean;
Begin  {EcoProcessedCB  USNVCIDCB   EcotypeComputedCB  EcotypeValidCB}
EcoProcessedCB.Checked:=EcoBool[0];
USNVCIDCB.Checked:=EcoBool[1];
EcotypeComputedCB.Checked:=EcoBool[2];
EcotypeValidCB.Checked:=EcoBool[3];
EcoResultCB.Checked:=EcoBool[4];
DisplayBitsCB.Checked:=EcoBool[5];
StretchCB.Checked:=EcoBool[6];
End;

procedure TdtmEcotypeColorsForm.GetEcoBoolean;
Begin  {EcoProcessedCB  USNVCIDCB   EcotypeComputedCB  EcotypeValidCB}
{EcoBool[0]:=EcoProcessedCB.Checked;}{CHANGED ONLY by Program Action!!!}
EcoBool[1]:=USNVCIDCB.Checked;
EcoBool[2]:=EcotypeComputedCB.Checked;
EcoBool[3]:=EcotypeValidCB.Checked;
EcoBool[4]:=EcoResultCB.Checked;
EcoBool[5]:=DisplayBitsCB.Checked;
EcoBool[6]:=StretchCB.Checked;
End;
(********************************************************************)
procedure TdtmEcotypeColorsForm.AcceptColorBtnClick(Sender: TObject);
var
  R,G,B:Byte;
  ShutUpCompilerColor:TColor;
begin
  R:=strtoint(Edit1.Text);
  G:=strtoint(Edit2.Text);
  B:=strtoint(Edit3.Text);
  ShutUpCompilerColor:=RGB(R,G,B);
  If (ColorPanel.Color <> ShutUpCompilerColor )
  then ColorPanel.Color:=   RGB(strtoint(Edit1.Text),
                            strtoint(Edit2.Text),
                            strtoint(Edit3.Text));
  if (not (ColorPanel.Color = clBtnFace)) then
  begin
    ColorChanging := ColorPanel.Color;
    foobar := true;

    EcoRecord[ChangeCol,ChangeRow].ColorBitmap:=(SetBitmapEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].TypeLevel:=(EcoTypeEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].Desc:=(EcoDescEdit.Text);

    EcoRecord[ChangeCol,ChangeRow].Geology:=GeologyEdit.Text;
    EcoRecord[ChangeCol,ChangeRow].StreamOrder:=StreamOrderEdit.Text;
    EcoRecord[ChangeCol,ChangeRow].StreamSource:=StreamSourceEdit.Text;
    EcoRecord[ChangeCol,ChangeRow].USNVC:=USNVCEdit.Text;
    EcoRecord[ChangeCol,ChangeRow].REC:=RECEdit.Text;

    EcoRecord[ChangeCol,ChangeRow].ElevMin:=Strtoint(ElevationMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].ElevMax:=Strtoint(ElevationMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=Strtoint(ElevationEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].REMin:=StrtoFloat(REMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].REMax:=StrtoFloat(REMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].RESharpness:=Strtoint(REEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeMin:=StrtoFloat(SlopeMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeMax:=StrtoFloat(SlopeMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:=Strtoint(SlopeEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeDirMin:=Strtoint(DirectionMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeDirMax:=Strtoint(DirectionMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=Strtoint(DirectionEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LatitudeMin:=StrtoFloat(LatitudeMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LatitudeMax:=StrtoFloat(LatitudeMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:=Strtoint(LatitudeEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LongitudeMin:=StrtoFloat(LongitudeMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LongitudeMax:=StrtoFloat(LongitudeMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:=Strtoint(LongitudeEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgRainMin:=Strtoint(RainMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgRainMax:=Strtoint(RainMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=Strtoint(RainEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgTempMin:=Strtoint(TempMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgTempMax:=Strtoint(TempMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=Strtoint(TempEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegDensityMin:=StrtoFloat(DensityMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegDensityMax:=StrtoFloat(DensityMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:=Strtoint(DensityEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegHeightMin:=StrtoFloat(HeightMinEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegHeightMax:=StrtoFloat(HeightMaxEdit.Text);
    EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:=Strtoint(HeightEdit.Text);
    GettheColor;
    EcoRecord[ChangeCol,ChangeRow].Color:=ColorChanging;
    foobar := False;
  end;
end;

(********************************************************************)

procedure TdtmEcotypeColorsForm.OpenFileNameBtnClick(Sender: TObject);
var
  RString,GString,BString,
  MyFilesExtension:String;
  Fooled:Boolean;
  I,J:Integer;
begin
  OpenDialog1.Filter := 'dtm eco|*.eco';
  OpenDialog1.Filename := '*.eco';
  OpenDialog1.InitialDir:=ProjectPath;
  if OpenDialog1.Execute then
  begin
    MyFilesExtension :=
      Uppercase(ExtractFileExt(OpenDialog1.FileName));
    if MyFilesExtension = '.ECO' then
    begin
      FileNameEdit.Text:=ExtractFileName(OpenDialog1.FileName);
      ProjectPath:=ExtractFilePath(OpenDialog1.FileName);
      LoadEcotypeColorsFile(OpenDialog1.FileName);

      {Set the data into form}
     EcoLevelUpDown.Position:=EcoLevelsProcessed;
     EcoLevelLabel.Caption:= Inttostr(EcoLevelUpDown.Position+1);
      Fooled := True;
      for I := 0 to 9 do begin {ColX}
        for J := 0 to 9{16} do begin {RowY}
          {ACol,  ARow}
          ChangeCol :=I;
          ChangeRow :=J;
          dtmEcotypeColorsForm.DrawGrid1SelectCell(Self, I, J, Fooled);
        end;
      end;
  ColorPanel.Color :=EcoRecord[0,0].Color;
  ChangingColor:=EcoRecord[0,0].Color;
    Str(GetRValue(ColorPanel.Color), RString);
    Str(GetGValue(ColorPanel.Color), GString);
    Str(GetBValue(ColorPanel.Color), BString);
    ColorValuesPanel.Caption :=
    'B:' + BString + ' G:' + GString +' R:' + RString;
    Edit1.Text := RString;
    Edit2.Text := GString;
    Edit3.Text := BString;
      ChangeCol :=0;
      ColorColumnH.Position:=0;
      ChangeRow :=0;
      ColorRowV.Position:=0;
      SetEcoBoolean;
    end;
  end;
end;

procedure TdtmEcotypeColorsForm.SaveFileNameBtnClick(Sender: TObject);
var MyFilesExtension: string;
begin
  SaveDialog1.Filter:= 'dtm eco|*.eco';
  SaveDialog1.InitialDir:=ProjectPath;
  If FileNameEdit.Text='' then
  SaveDialog1.Filename:='newname.eco' else
  SaveDialog1.Filename:=FileNameEdit.Text;
  if SaveDialog1.Execute then
  begin
    MyFilesExtension :=
      Uppercase(ExtractFileExt(SaveDialog1.FileName));
    if MyFilesExtension = '.ECO' then
    begin
      FileNameEdit.Text:=SaveDialog1.FileName;
      ProjectPath:=ExtractFilePath(SaveDialog1.FileName);
      SaveEcotypeColorsFile(SaveDialog1.FileName);
    end;
  end;
end;


procedure TdtmEcotypeColorsForm.SetBitmapBtnClick(Sender: TObject);
var
  FractalFilename, MyFilesExtension: string;
  BitMap : TBitMap;
begin
  OpenDialog1.Filter := 'dem bmp|*.bmp';
  OpenDialog1.Filename := '*.bmp';
  OpenDialog1.InitialDir:=ImagePath;
  if OpenDialog1.Execute then
  begin
    MyFilesExtension :=
      Uppercase(ExtractFileExt(OpenDialog1.FileName));
    if MyFilesExtension = '.BMP' then
    begin
      SetBitmapEdit.Text:=ExtractFileName(OpenDialog1.FileName);
      {Paint Bitmap}
      FractalFilename := OpenDialog1.FileName;
      BitMap := TBitMap.create;
      try
        BitMap.LoadFromFile(FractalFilename);
        {  PixelScanSize := 3;   pf24bit  PixelScanSize := 4;   pf32bit  }
        BitMap.PixelFormat := pf24bit;
        Image1.Assign(BitMap);
        If StretchCB.Checked then Image1.Stretch := True
                             else Image1.Stretch := False;
      finally
        BitMap.Free;
      end;
      {Place Name into Data record}
      {EcoRecord[ChangeColX,ChangeRowY]}
      EcoRecord[ChangeCol,ChangeRow].ColorBitmap:=OpenDialog1.FileName;
      foobar:=False;
      SpareChange;
    end;
  end;
end;


procedure TdtmEcotypeColorsForm.StretchCBClick(Sender: TObject);
begin
  Image1.Stretch:=StretchCB.Checked;
end;

procedure TdtmEcotypeColorsForm.EcoLevelUpDownClick(Sender: TObject;
  Button: TUDBtnType);
begin
  EcoLevelLabel.Caption:= Inttostr(EcoLevelUpDown.Position+1);
  EcoLevelsProcessed:=EcoLevelUpDown.Position;
end;

end.
