{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmEcoReader;

interface

uses Windows, Messages, Graphics, SysUtils;

type
  EcoTypeDefRec= record
    {EcoProcessedCB  USNVCIDCB   EcotypeComputedCB  EcotypeValidCB}
    Color: Integer;
    ColorBitmap{255},TypeLevel{30},Desc{255},
    Geology{4},StreamOrder{4},StreamSource{4},
    USNVC{6} {1A1Na},
    REC{12} {WXM2ALIFLOHG}:String;
    ElevMin,ElevMax,ElevSharpness: Integer;
    REMin,REMax:Double;{Relative Elevation}RESharpness: Integer;
    SlopeMin,SlopeMax:Double;              SlopeSharpness: Integer;
    SlopeDirMin,SlopeDirMax:Double;        SlopeDirSharpness: Integer;
    LatitudeMin,LatitudeMax:Double;        LatitudeSharpness: Integer;
    LongitudeMin,LongitudeMax:Double;      LongitudeSharpness: Integer;
    AvgRainMin,AvgRainMax,AvgRainSharpness: Integer;
    AvgTempMin,AvgTempMax,AvgTempSharpness: Integer;
    VegDensityMin,VegDensityMax:Double;    VegDensitySharpness: Integer;
    VegHeightMin,VegHeightMax:Double;      VegHeightSharpness: Integer;
  end;
var
   {EcoRecord[ChangeColX,ChangeRowY]}
  EcoRecord: array of array of EcoTypeDefRec;
  EcoBool: Array[0..6] of Boolean;
  {EcoProcessedCB  USNVCIDCB   EcotypeComputedCB  EcotypeValidCB}
var
  EcoLevelsProcessed,
  ColorChanging, ChangeRow, ChangeCol, ChangingColor:Integer;{ Longint;}
  foobar: Boolean;

procedure LoadEcotypeColorsFile(FileName:String);
procedure SaveEcotypeColorsFile(FileName:String);

procedure LoadEcoRecordDefaults;

implementation

uses   dtmEcotypeColorsFrm, dtmPOFvar, dtmGlobals;

procedure LoadEcotypeColorsFile(FileName:String);
var
  I,J:Integer;
  InVerstring, WhatsMyLine: string;
  EcoTextFile: Textfile;
Begin
      Try
        AssignFile(EcoTextFile, FileName);
        Reset(EcoTextFile);
        ReadLn(EcoTextFile, InVerstring);{ERROR ?}
        ReadLn(EcoTextFile, WhatsMyLine);
        EcoLevelsProcessed:=Strtoint(WhatsMyLine);
        for I := 0 to 6 do
        begin
          Readln(EcoTextFile, WhatsMyLine);
          If WhatsMyLine='True' then EcoBool[I]:=True
                                 else EcoBool[I]:=False;
        end;
        for I := 0 to 9 do begin {Col}
          for J := 0 to 9{16} do begin {Row}
          ChangeRow := J;   ChangeCol:=I;
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].Color:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].ColorBitmap:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].TypeLevel:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].Desc:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].Geology:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].StreamOrder:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].StreamSource:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].USNVC:=(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].REC:=(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].ElevMin:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].ElevMax:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].REMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].REMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].RESharpness:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeDirMin:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeDirMax:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LatitudeMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LatitudeMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LongitudeMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LongitudeMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgRainMin:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgRainMax:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgTempMin:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgTempMax:=Strtoint(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegDensityMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegDensityMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:=Strtoint(WhatsMyLine);

            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegHeightMin:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegHeightMax:=StrtoFloat(WhatsMyLine);
            ReadLn(EcoTextFile, WhatsMyLine);
            EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:=Strtoint(WhatsMyLine);
          end;
        end;
      Finally
        CloseFile(EcoTextFile);
      End;
ChangeRow := 0;   ChangeCol:=0;
end;

procedure SaveEcotypeColorsFile(FileName:String);
var
  I,J:Integer;
  WhatsMyLine: string;
  EcoTextFile: Textfile;
Begin
  dtmEcotypeColorsForm.GetEcoBoolean;
      Try
        AssignFile(EcoTextFile, FileName);
        Rewrite(EcoTextFile);
        WhatsMyLine:=Verstring;
        Writeln(EcoTextFile, WhatsMyLine);
        WhatsMyLine:=inttostr(EcoLevelsProcessed);
        Writeln(EcoTextFile, WhatsMyLine);
        for I := 0 to 6 do
        begin
          If EcoBool[I]=True then WhatsMyLine:='True'
                             else WhatsMyLine:='False';
          Writeln(EcoTextFile, WhatsMyLine);
        end;
        for I := 0 to 9 do begin {Col}
          for J := 0 to 9{16} do begin {Row}
            WhatsMyLine:=inttostr(EcoRecord[I,J].Color);{:TColor;}
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].ColorBitmap;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].TypeLevel;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].Desc;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].Geology;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].StreamOrder;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].StreamSource;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].USNVC;
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=EcoRecord[I,J].REC;
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=inttostr(EcoRecord[I,J].ElevMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].ElevMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].ElevSharpness);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].REMin);{:Double;}
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].REMax);{:Double;}
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].RESharpness);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].SlopeMin);{:Double;}
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].SlopeMax);{:Double;}
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].SlopeSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=floattostr(EcoRecord[I,J].SlopeDirMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].SlopeDirMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].SlopeDirSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=floattostr(EcoRecord[I,J].LatitudeMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].LatitudeMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].LatitudeSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=floattostr(EcoRecord[I,J].LongitudeMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].LongitudeMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].LongitudeSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgRainMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgRainMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgRainSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgTempMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgTempMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].AvgTempSharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=floattostr(EcoRecord[I,J].VegDensityMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].VegDensityMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].VegDensitySharpness);
            Writeln(EcoTextFile, WhatsMyLine);

            WhatsMyLine:=floattostr(EcoRecord[I,J].VegHeightMin);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=floattostr(EcoRecord[I,J].VegHeightMax);
            Writeln(EcoTextFile, WhatsMyLine);
            WhatsMyLine:=inttostr(EcoRecord[I,J].VegHeightSharpness);
            Writeln(EcoTextFile, WhatsMyLine);
          end;
        end;
      Finally
        CloseFile(EcoTextFile);
      End;
end;
(*****************************************************)
(*****************************************************)

{5000 ~ lines of setting Default values...}
(*****************************************************)
(*****************************************************)
{FE=254  F4=244  EA=234 E0=224 D6=214 CC=204 C2=194 B8=184 AF=174 A4=164
9A=154  90=144  86=134  7C=124 72=114 68=104 5E=94   54=84  4A=74 40=64
36=54  2C=44    22=34   18=24  0E=14    4=4}
procedure LoadEcoRecordDefaults;
begin
  case ChangeCol of
    0: begin         {UnClassified}
        case ChangeRow of
          0: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00FE00FE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'Color0';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClasified';

          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;

          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00EF00EF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LLX :90';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DF00DF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMX: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CF00CF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LDX: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BF00BF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MLX: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AF00AF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MMX: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$009F009F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MDX: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F008F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DLX 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
           EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F007F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DMX 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
          EcoRecord[ChangeCol,ChangeRow].Color:= $006F006F;{same as Blue $007F0000;}
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DDX 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'UnClassed';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10376;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=7320;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:= 1;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 1}
    1: begin         {Water}
        case ChangeRow of
          0: begin
         { Color1 := $00BF0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00FE0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'Color1';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Water';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
                {LLW := $00FE0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00EF0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LLW :90';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Rocky Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
                {LMW := $00EF0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DF0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMW: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Riverine: Intermittent';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
                {LDW := $00DF0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CF0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LDW: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Riverine: Upper Perennial';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
                {MLW := $00CF0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BF0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MLW: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Riverine Braided';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
               {MMW := $00BF0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AF0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MMW: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Riverine: Lower Perennial';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1; {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
               { MDW := $00AF0000; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$009F0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MDW: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Riverine: Tidal';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
                {DLW := $009F0000; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DLW 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Lacustrine: Limnetic';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 2;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
               {DMW := $008F0000;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DMW 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Estuary: Subtidal';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
              {DDW := $007F0000; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$006F0000;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DDW 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Marine: Subtidal';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=-10400;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 1}
    2: begin     {Wetland}
        case ChangeRow of
          0: begin
               {Color2 := $00BFBF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00FEFE00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'Color2';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
               {LLC := $00FEFE00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00EFEF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LLC: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Unconsolidated: Mud';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
             {  LMC := $00EFEF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DFDF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMC: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Moss-Lichen Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
              { LDC := $00DFDF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CFCF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LDC: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Scrub-Shrub Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
               {MLC := $00CFCF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BFBF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLC: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Forested Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
              { MMC := $00BFBF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $00AFAF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMC: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Emergent Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
              { MDC := $00AFAF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$009F9F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDC: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Aquatic Bed Wetland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
               {DLC := $009F9F00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F8F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DLC: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Lacustrine: Littoral';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
              { DMC := $008F8F00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F7F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMC: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Estuary: Intertidal';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               {DDC := $007F7F00; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $006F6F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDC: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Marine: Intertidal';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=150;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;     {Integer}
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 2}
    3: begin   {Forest}
        case ChangeRow of
          0: begin
              { Color3 := $0000BF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $0000FE00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color3';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Forest';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
               {LLF := $0000FE00; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $0000EF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LLF: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Forest: Cut';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
               {LMF := $0000EF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:= $0000DF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMF: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Forest: Burnt';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
              { LDF := $0000DF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000CF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LDF: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Krumholz Zone/Edge';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
              { MLF := $0000CF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000BF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLF: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Scrub Forest';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
              { MMF := $0000BF00;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000AF00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMF: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Broadleaf Deciduous';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
             {  MDF := $0000AF00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00009F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MDF: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Broadleaf Evergreen';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
               {DLF := $00009F00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00008F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLF: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Needle Deciduous';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
              { DMF := $00008F00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00007F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMF: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Needle Evergreen';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               {DDF := $00007F00; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00006F00;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDF: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Tropical Forest: Jungle';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=50;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 3}
    4: begin {Agricultural}
        case ChangeRow of
          0: begin
              { Color4 := $009FBF9F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DFFEDF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'Color4';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Agriculture';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
              { LLA := $00DFFEDF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CFEFCF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LLA: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Dead Crops';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
               {LMA := $00CFEFCF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BFDFBF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMA: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Pasture';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
              { LDA := $00BFDFBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AFCFAF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LDA: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Crops';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
               {MLA := $00AFCFAF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$009FBF9F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLA: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'IR Healthy Crops';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
              { MMA := $009FBF9F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$008FAF8F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMA: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Irrigated Crops';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
               {MDA := $008FAF8F;  }
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F9F7F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDA: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Nurseries: Mixed Ag';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
               {DLA := $007F9F7F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$006F8F6F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLA: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Vineyards';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
             {  DMA := $006F8F6F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$005F7F5F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMA: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Confined Feeding Operations';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               {DDA := $005F7F5F;  }
          EcoRecord[ChangeCol,ChangeRow].Color:= $004F6F4F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDA: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Orchards and Groves';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=300;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:=1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 4}
    5: begin     {Rangeland}
        case ChangeRow of
          0: begin
               {Color5 := $00007FBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:= $0000BFFE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color5';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Rangeland';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
               {LLR := $0000BFFE;  }
          EcoRecord[ChangeCol,ChangeRow].Color:= $0000AFEF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LLR: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Prairie: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
              { LMR := $0000AFEF;}
          EcoRecord[ChangeCol,ChangeRow].Color:= $00009FDF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LMR: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Herb: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
               {LDR := $00009FDF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00008FCF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LDR: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Shrub: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
               {MLR := $00008FCF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00007FBF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLR: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:='Prairie: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
              { MMR := $00007FBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00006FAF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMR: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Herb: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
             {  MDR := $00006FAF;}
          EcoRecord[ChangeCol,ChangeRow].Color:= $00005F9F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDR: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Shrub: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
              { DLR := $00005F9F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00004F8F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLR: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Prairie: Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
               {DMR := $00004F8F; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $00003F7F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMR: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Herbaceous Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
              { DDR := $00003F7F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00002F5F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDR: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Shrub and brush: Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 5}
    6: begin   {Tundra}
        case ChangeRow of
          0: begin
               {Color6 := $009F9FBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DFDFFE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color6';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Tundra';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
               {LLT := $00DFDFFE;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CFCFEF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LLT: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Moss: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
              { LMT := $00CFCFEF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BFBFDF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LMT 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Herb: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
               {LDT := $00BFBFDF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AFAFCF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LDT: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Shrub: Dead';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
              { MLT := $00AFAFCF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$009F9FBF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLT 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Moss: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
               {MMT := $009F9FBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F8FAF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMT: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Herb: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
             {  MDT := $008F8FAF;  }
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F7F9F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDT: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Shrub: OK';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
              { DLT := $007F7F9F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$006F6F8F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLT: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Moss: Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
               {DMT := $006F6F8F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$005F5F7F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMT: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Herb: Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               {DDT := $005F5F7F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$004F4F6F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDT: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Shrub and Brush: Healthy';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=1000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=3000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 6}
    7: begin        {Barren}
        case ChangeRow of
          0: begin
               { Color7 := $00BFAFBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00FEEFFE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color7';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Barren Land';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
              {  LLB := $00FEEFFE; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00EFDFEF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LLB: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Dry salt flats';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
                {LMB := $00EFDFEF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DFCFDF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMB: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Sand: not beaches';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
                {LDB := $00DFCFDF;  }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CFBFCF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LDB: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Beaches';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
                {MLB := $00CFBFCF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00BFAFBF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLB: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Bare Exposed Rock';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
             {   MMB := $00BFAFBF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AF9FAF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MMB: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:=   'Transitional areas';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
                {MDB := $00AF9FAF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$009F8F9F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MDB: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'EPA NBC Zoned';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
                {DLB := $009F8F9F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F7F8F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLB: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Gravel pits';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
                {DMB := $008F7F8F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F6F7F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMB: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Quarries';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               {DDB := $007F6F7F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$006F5F6F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDB: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Strip Mines';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=2000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 7}
    8: begin   {Urban}
        case ChangeRow of
          0: begin
           {Color8 := $000000BF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000FE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color8';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Urban';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
                 { LLU := $000000FE;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000EF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LLU: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Industrial Extraction';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
                  { LMU := $000000EF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000DF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LMU: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Industrial Production';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
                  { LDU := $000000DF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000CF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LDU: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Industrial and Commercial complexes';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
                  {MLU := $000000CF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000BF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'MLU: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Commercial and Services';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
                  {MMU := $000000BF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$000000AF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMU: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Major Roads: Transportation';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
                  {MDU := $000000AF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000009F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDU: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:='Minor Roads: Transportation';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
                {DLU := $0000009F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000008F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'DLU: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Utilities';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
                {DMU := $0000008F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000007F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMU: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Communications';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
               { DDU := $0000007F;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$0000006F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDU: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Residential';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=3500;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=8000;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end; end; {Case 8}
    9: begin  {Snow}
 {Snow or Ice? Black or White is NOT Classified items?}
        case ChangeRow of
          0: begin
            {Color9 := $00BFBFBF; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $00FEFEFE;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='Color9';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Snow or Ice';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          1: begin
               {LLS := $00FEFEFE;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00EFEFEF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LLS: 90';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'New Snow';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=0;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          2: begin
               {LMS := $00EFEFEF;}
          EcoRecord[ChangeCol,ChangeRow].Color:=$00DFDFDF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:= 'LMS: 80';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'White Snow';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          3: begin
               {LDS := $00DFDFDF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00CFCFCF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='LDS: 70';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Snow Fields';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          4: begin
             {  MLS := $00CFCFCF; }
          EcoRecord[ChangeCol,ChangeRow].Color:= $00BFBFBF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MLS: 60';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Broken Snow';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          5: begin
             {  MMS := $00BFBFBF; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$00AFAFAF;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MMS: 50';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Ice Fields';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          6: begin
              { MDS := $00AFAFAF;}
          EcoRecord[ChangeCol,ChangeRow].Color:= $009F9F9F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='MDS: 40';
          EcoRecord[ChangeCol,ChangeRow].Desc:=  'Moving Ice-Flows';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          7: begin
             {  DLS := $009F9F9F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$008F8F8F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DLS: 30';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Mountain Ice';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          8: begin
               {DMS := $008F8F8F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$007F7F7F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DMS: 20';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Icebergs';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
          9: begin
              {DDS := $007F7F7F; }
          EcoRecord[ChangeCol,ChangeRow].Color:=$006F6F6F;
          EcoRecord[ChangeCol,ChangeRow].ColorBitmap :=NoName;
          EcoRecord[ChangeCol,ChangeRow].TypeLevel:='DDS: 10';
          EcoRecord[ChangeCol,ChangeRow].Desc:= 'Glaciers';
          EcoRecord[ChangeCol,ChangeRow].Geology :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamOrder :=NoName;
          EcoRecord[ChangeCol,ChangeRow].StreamSource :=NoName;
          EcoRecord[ChangeCol,ChangeRow].USNVC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].REC :=NoName;
          EcoRecord[ChangeCol,ChangeRow].ElevMin :=5000;
          EcoRecord[ChangeCol,ChangeRow].ElevMax :=10500;
          EcoRecord[ChangeCol,ChangeRow].ElevSharpness:=2;
          {Relative Elevation}
          EcoRecord[ChangeCol,ChangeRow].REMin:= -1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].REMax:= 1;           {Double}
          EcoRecord[ChangeCol,ChangeRow].RESharpness:= 1;     {Integer}
          {Slope}
          EcoRecord[ChangeCol,ChangeRow].SlopeMin:= -1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].SlopeSharpness:= 1;  {Integer}
          {SlopeDir}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMin :=-2;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirMax :=2;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].SlopeDirSharpness:=1;     {Integer}
          {Latitude}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMin:= -90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeMax:= 90;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LatitudeSharpness:= 1;  {Integer}
          {Longitude}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMin:= -180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeMax:= 180;        {Double}
          EcoRecord[ChangeCol,ChangeRow].LongitudeSharpness:= 1;  {Integer}
          {AvgRain}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMin :=0;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainMax :=60;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgRainSharpness:=1;     {Integer}
          {AvgTemp}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMin :=-20;         {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempMax :=100;          {Integer}
          EcoRecord[ChangeCol,ChangeRow].AvgTempSharpness:=1;     {Integer}
          {VegDensity}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensityMax:= 1;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegDensitySharpness:= 1;  {Integer}
          {VegHeight}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMin:= 0;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightMax:= 100;        {Double}
          EcoRecord[ChangeCol,ChangeRow].VegHeightSharpness:= 1;  {Integer}
            end;
        end;
    end; {Case 9}
  end; {Case}
end; {PROCEDURE}
(*****************************************************)
(*****************************************************)



(*****************************************************)
(*****************************************************)

end.
