unit dtmEcoDbFrm;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, DBTables, ComCtrls,
  StdCtrls, Buttons, ExtCtrls;

type
  TEcoDbForm = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBGrid1: TDBGrid;
    ProgressBar1: TProgressBar;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    DoAllCB: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
procedure FormSetup;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EcoDbForm: TEcoDbForm;

implementation

uses dtmPOFvar,dtmEcoReader,dtmEcoDbReportFrm, dtmEcoDbCSFrm;

{$R *.DFM}

procedure TEcoDbForm.FormCreate(Sender: TObject);
begin
  top := dtmEcotypeColorsFormY;
  left := dtmEcotypeColorsFormX;
{}(*
    Table1.Active := False;
    Table1.DatabaseName :=ProgramPath+'dtmeco.db';
{    'c:\delphi\demos\database';}
    Table1.Active := True;*)
end;

procedure TEcoDbForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{}    Table1.Active := False;
end;
(*
procedure TDbAdrViewForm.ImgLabelBtnClick(Sender: TObject);
begin
  DbSessionForm.AdrSavedTable.Active := True;
  DatabaseDo;
  If BigLabelsCB.Checked then
  DbBigAdrImgLblForm.BigAdrImgLblForm.QuickRep1.Preview else
  DbAdrImgLblForm.AdrImgLblForm.QuickRep1.Preview;
  DbSessionForm.AdrSavedTable.Active := False;
end;


procedure TDbAdrViewForm.DatabaseSaveBitBtnClick(Sender: TObject);
begin
  DbSessionForm.AdrSavedTable.Active := True;
  DatabaseDo;
  DbSessionForm.AdrSavedTable.Active := False;
end;

procedure TDbAdrViewForm.DatabaseDo;
var
{  ImageInt:Integer;}
  Key,
  aFirstName,  LastName, FirstName,
  A, Address, City, State, Zip: string;
begin
  Connect;
  Select;
  {Empty old table data}
  DbSessionForm.AdrSavedTable.First;
  while (not DbSessionForm.AdrSavedTable.EOF) do
  begin
    DbSessionForm.AdrSavedTable.Delete;
  end;
  {Compile data for new Saved Table}
  DbSessionForm.DataTable.First;
  {HoloForm.AdrSavedTable.Active:=True;}
  while (not DbSessionForm.DataTable.EOF) do
  begin
    LastName := DbSessionForm.DataTableLastName.Value;
    aFirstName := DbSessionForm.DataTableFirstName.Value;
    If NamebyRG.ItemIndex=0 then
         FirstName :=LastName+ ' ' +aFirstName
       else FirstName := aFirstName + ' ' + LastName;
    Key:= DbSessionForm.DataTableParentLink.AsString;
    If KeyedCB.Checked then FirstName :=Key+FirstName;
    A := DbSessionForm.AdrTableA.Value;
    Address := DbSessionForm.AdrTableAddress.Value;
    A := A + ' ' + Address;
    City := DbSessionForm.AdrTableCity.Value;
    State := DbSessionForm.AdrTableState.Value;
    Zip := DbSessionForm.AdrTableZip.Value;
    City := City + ' ' + State + ' ' + Zip;
{  ImageInt:=DbSessionForm.AdrTableImageLink.Value;
        DbSessionForm.ImagTable.Filtered := False;
        DbSessionForm.ImagTable.Filter := 'ImageLink='+
                                     Inttostr(ImageInt);
  DbSessionForm.ImagTable.Filtered := True;}
    DbSessionForm.AdrSavedTable.AppendRecord(
           [FirstName, A, City,DbSessionForm.ImagTableBLOBIMAGE.Value]);
    DbSessionForm.DataTable.Next;
  end;
*)
procedure TEcoDbForm.FormSetup;
var
  Ornot, I, J: LongInt;
  BitMap : TBitMap;
begin
{Clear DB}
  Table1.Active := True;
  ProgressBar1.Position:=50;
  {Empty old table data}
  Table1.First;
  while (not Table1.EOF) do
  begin
    Table1.Delete;
  end;
  If DoAllCB.Checked then Ornot:=9 else Ornot:=0;
{Input All the new Data}
  for I := 0 to 9 do begin {ColX}
    ProgressBar1.Position:=I*10;
    for J := 0 to Ornot do begin {RowY}
{Create the bitmap}
BitMap := TBitMap.create;
BitMap.PixelFormat := pf24bit;
Bitmap.Width:=64;
Bitmap.Height:=64;
If FileExists(EcoRecord[I,J].ColorBitmap) then
begin
      try
        BitMap.LoadFromFile(EcoRecord[I,J].ColorBitmap);
        BitMap.PixelFormat := pf24bit;
      finally
      end;
end else
begin
    BitMap.Canvas.Brush.Color := EcoRecord[I,J].Color;
    BitMap.Canvas.FillRect(Rect(0,0,64,64));
end;
  Table1.AppendRecord([
  ((I*10)+J),
  EcoRecord[I,J].Color,
  GetRValue(EcoRecord[I,J].Color),
  GetGValue(EcoRecord[I,J].Color),
  GetBValue(EcoRecord[I,J].Color),
  EcoRecord[I,J].ColorBitmap,
  EcoRecord[I,J].TypeLevel,
  EcoRecord[I,J].Desc,
  EcoRecord[I,J].Geology,
  EcoRecord[I,J].StreamOrder,
  EcoRecord[I,J].StreamSource,
  EcoRecord[I,J].USNVC,
  EcoRecord[I,J].REC,
  EcoRecord[I,J].ElevMin,
  EcoRecord[I,J].ElevMax,
  EcoRecord[I,J].ElevSharpness,
  EcoRecord[I,J].REMin,
  EcoRecord[I,J].REMax,
  EcoRecord[I,J].RESharpness,
  EcoRecord[I,J].SlopeMin,
  EcoRecord[I,J].SlopeMax,
  EcoRecord[I,J].SlopeSharpness,
  EcoRecord[I,J].SlopeDirMin,
  EcoRecord[I,J].SlopeDirMax,
  EcoRecord[I,J].SlopeDirSharpness,
  EcoRecord[I,J].LatitudeMin,
  EcoRecord[I,J].LatitudeMax,
  EcoRecord[I,J].LatitudeSharpness,
  EcoRecord[I,J].LongitudeMin,
  EcoRecord[I,J].LongitudeMax,
  EcoRecord[I,J].LongitudeSharpness,
  EcoRecord[I,J].AvgRainMin,
  EcoRecord[I,J].AvgRainMax,
  EcoRecord[I,J].AvgRainSharpness,
  EcoRecord[I,J].AvgTempMin,
  EcoRecord[I,J].AvgTempMax,
  EcoRecord[I,J].AvgTempSharpness,
  EcoRecord[I,J].VegDensityMin,
  EcoRecord[I,J].VegDensityMax,
  EcoRecord[I,J].VegDensitySharpness,
  EcoRecord[I,J].VegHeightMin,
  EcoRecord[I,J].VegHeightMax,
  EcoRecord[I,J].VegHeightSharpness,
  BitMap ]);
{Table1.Post;}
        BitMap.Free;
    end;
  end;
  ProgressBar1.Position:=0;
end;

procedure TEcoDbForm.SpeedButton1Click(Sender: TObject);
begin
  If (not DoAllCB.Checked) then FormSetup;
  {Print the Db onto Form}
  EcoDbReportForm.QuickRep1.Preview;
  {Auto Close this Db form when finished}
  EcoDbForm.Close;
end;

procedure TEcoDbForm.SpeedButton2Click(Sender: TObject);
begin
  If (not DoAllCB.Checked) then FormSetup;
  {Print the Db  COLORS ONLY onto Form}{EcoDbCSForm}
  EcoDbCSForm.QuickRep1.Preview;
  {Auto Close this Db form when finished}
  EcoDbForm.Close;
end;

end.
