unit dtmDbFrm;
{by Ivan Lee Herring, 2002}
      {250k(956): Name,ID,LT,LON,IMWS,A
      QDNAME C 31
      QUADID C  7   48124a1
      LT     C  3   -90
      LON    C  4   -180
      IMWS   C  8   NM10-10E
      A      C  1   A or N}
                           {HI   -18.875 -155.625  18155-H6   A}
      {24k(56617): Name C30 State C2 Lat C7 Long C8 MRC C8 A C1}
interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Grids,
  DBGrids, Db, ComCtrls, Spin, Menus, dbf, DBCtrls;

type
  TdtmDbForm = class(TForm)
    DemDS: TDataSource;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    DbNameLabel: TLabel;
    OpenDialog1: TOpenDialog;
    ProgressBar: TProgressBar;
    FieldLabel: TLabel;
    SpinEdit1: TSpinEdit;
    Memo1: TMemo;
    FilePathLabel: TLabel;
    ListBox1: TListBox;
    DBNavigator1: TDBNavigator;
    MainMenu1: TMainMenu;
    DbProcessorMenu: TMenuItem;
    ListProcessorMenu: TMenuItem;
    Help1: TMenuItem;
    OpenDb1: TMenuItem;
    DisplayNavigator1: TMenuItem;
    LoadList1: TMenuItem;
    ProcessList1: TMenuItem;
    N1: TMenuItem;
    LocatebinFiles1: TMenuItem;
    ProcessbinFiles1: TMenuItem;
    BinsdoDBCellLocator1: TMenuItem;
    DBdo250KBins1: TMenuItem;
    Make1DegreeShapefromDb1: TMenuItem;
    N3: TMenuItem;
    MakeAll24KShapefromDb: TMenuItem;
    Make24KtpcfgfromDb1: TMenuItem;
    Make1DegreetpcfgfromDb1: TMenuItem;
    Make24KFloattpcfgfromDb1: TMenuItem;
    MakeMTVSelected24KShapefromDb1: TMenuItem;
    N5: TMenuItem;
    MakeStateSelected24KShapefromDb1: TMenuItem;
    Ascii1234561: TMenuItem;
    ProcessDb1: TMenuItem;
    Db250kbins1: TMenuItem;
    SplitshpIAWDb1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    N4: TMenuItem;
    ShapeProcessor1: TMenuItem;
    OpenShapeDb1: TMenuItem;
    SaveDialog1: TSaveDialog;
    AsciiListto250DB: TMenuItem;
    MakeALLMRC24KShapesfromDb1: TMenuItem;
    MakeALLState24KShapesfromDb1: TMenuItem;
    PathperspinDbshp1: TMenuItem;
    PathMinSpinner: TSpinEdit;
    PathMaxSpinner: TSpinEdit;
    ToggleSpinnerdisplay1: TMenuItem;
    AsciiListto24KDB: TMenuItem;
    Ascii1: TMenuItem;
    MrcStEdit: TEdit;
    ToggleMRCStateDisplay1: TMenuItem;
    SelectedStatefromdatabase1: TMenuItem;
    FipsCodeCB: TComboBox;
    AsciiPathRow1: TMenuItem;
    N6: TMenuItem;
    RowMinSpinner: TSpinEdit;
    RowMaxSpinner: TSpinEdit;
    SquashShapeIAWDbselection1: TMenuItem;
    DBdo24KBinsProjection1: TMenuItem;
    N24kBinsdoDBState1: TMenuItem;
    PathRoworPathRowCentroid1: TMenuItem;
    BinsDoDBLatYLonX: TMenuItem;
    Bins250kDoDBID: TMenuItem;
    N7: TMenuItem;
    SortOnLatLon: TMenuItem;
    Make1DegreetpcfgfromAlaskanDb1: TMenuItem;
    BitsdoDBFilenameExtension1: TMenuItem;
    Help2: TMenuItem;
    About1: TMenuItem;
    DemTable: TDbf;
    Dbf1: TDbf;

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Exit1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);

    procedure DBGrid1ColEnter(Sender: TObject);
    procedure MrcStEditChange(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);

    procedure OpenBtnClick(Sender: TObject);
    procedure DisplayNavigator1Click(Sender: TObject);

    procedure SelectedStatefromdatabase1Click(Sender: TObject);
    procedure AsciiListto250DBClick(Sender: TObject);
procedure AsciiDbDo(PathMax,PathMin,RowMax,RowMin:Integer);
    procedure AsciiListto24KDBClick(Sender: TObject);
{24k}
    procedure Ascii1234561Click(Sender: TObject);
    procedure ToggleSpinnerdisplay1Click(Sender: TObject);
    procedure PathperspinDbshp1Click(Sender: TObject);


    procedure LoadListBtnClick(Sender: TObject);
    procedure DoitBtnClick(Sender: TObject);

    procedure LocateFilesBtnClick(Sender: TObject);
    procedure ProcessBtnClick(Sender: TObject);

    procedure DBdoBtnClick(Sender: TObject);
    procedure DBdoBinsBtnClick(Sender: TObject);
    procedure DBdo24KBinsProjection1Click(Sender: TObject);

    procedure MakeShapeBtnClick(Sender: TObject);
    procedure Make1DegreetpcfgfromDb1Click(Sender: TObject);
procedure Make24Ktpcfg(bZisInteger:Boolean);

    procedure Make24KtpcfgfromDb1Click(Sender: TObject);
    procedure Make24KFloattpcfgfromDb1Click(Sender: TObject);

    procedure ToggleMRCStateDisplay1Click(Sender: TObject);
    procedure MakeMTVSelected24KShapefromDb1Click(Sender: TObject);
    procedure MakeALLMRC24KShapesfromDb1Click(Sender: TObject);
    procedure MakeStateSelected24KShapefromDb1Click(Sender: TObject);
    procedure MakeALLState24KShapesfromDb1Click(Sender: TObject);
    procedure MakeAll24KShapefromDbClick(Sender: TObject);
procedure Make24KShapefromDb(Switch:Integer);

    procedure OpenShapeDb1Click(Sender: TObject);
    procedure SplitshpIAWDb1Click(Sender: TObject);
    procedure SquashShapeIAWDbselection1Click(Sender: TObject);
    
    procedure FipsCodeCBClick(Sender: TObject);
    procedure N24kBinsdoDBState1Click(Sender: TObject);
    procedure PathRoworPathRowCentroid1Click(Sender: TObject);
    procedure BinsDoDBLatYLonXClick(Sender: TObject);
    procedure Bins250kDoDBIDClick(Sender: TObject);
    procedure SortOnLatLonClick(Sender: TObject);
    procedure Make1DegreetpcfgfromAlaskanDb1Click(Sender: TObject);
    procedure BitsdoDBFilenameExtension1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmDbForm: TdtmDbForm;
  SelectedField, FieldFileNameNumber:Integer;
  PathRoworPathRowCentroid,
  StareThere,StarIsThere: Boolean;
  StareThereString:String;
{  dbTable: TTable;}
implementation

uses
  dtmHtfFrm, dtmGlobals,
  dtmPOFvar, dtmShpSaver, dtmDbAboutFrm;

{$R *.DFM}

procedure TdtmDbForm.FormCreate(Sender: TObject);
begin
  top := dtmDbFormY;
  left := dtmDbFormX;
  StarIsThere:=False;
  StareThere:=True;
  FieldFileNameNumber:=0;
  SelectedField:=0;
  DisplayNavigator1.Enabled:=False;
    ProcessDb1.Enabled:=False;
    Db250kbins1.Enabled:=False;
    SplitshpIAWDb1.Enabled:=False;
    ListProcessorMenu.Enabled:=False;
  ProgressBar.Visible:=False;
  PathMinSpinner.Visible:=false;
  PathMaxSpinner.Visible:=false;
  RowMinSpinner.Visible:=false;
  RowMaxSpinner.Visible:=false;
  MrcStEdit.Visible:=False;
  FipsCodeCB.Visible:=False;
  PathRoworPathRowCentroid:=False;
end;

procedure TdtmDbForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  dtmDbFormX := dtmDbForm.left;
  dtmDbFormY := dtmDbForm.top;
end;

procedure TdtmDbForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TdtmDbForm.Help1Click(Sender: TObject);
begin
  Application.HelpContext(7000);
end;
(***********************************************************)

(***********************************************************)
procedure TdtmDbForm.DisplayNavigator1Click(Sender: TObject);
begin
    iF DBNavigator1.Visible THEN
    BEGIN
      DBNavigator1.Enabled:=False;
      DBNavigator1.Visible:=False;
    END ELSE
    BEGIN
      DBNavigator1.Enabled:=DemTable.Active;
      DBNavigator1.Visible:=DemTable.Active;
    END;
end;

procedure TdtmDbForm.ToggleMRCStateDisplay1Click(Sender: TObject);
begin
{MrcStEdit}
    iF MrcStEdit.Visible THEN
    BEGIN
      {MrcStEdit.Enabled:=False;}
      MrcStEdit.Visible:=False;
    END ELSE
    BEGIN
      {MrcStEdit.Enabled:=DemTable.Active;}
      MrcStEdit.Visible:=DemTable.Active;
    END;
end;
(***********************************************************)

(***********************************************************)



(***********************************************************)
    {DATABASE FUNCTIONS}
(***********************************************************)
procedure TdtmDbForm.OpenBtnClick(Sender: TObject);
begin
{DemTable.TableName}
  OpenDialog1.InitialDir:=VRMDatabase;
  OpenDialog1.Filter := 'Dbf files (*.dbf)|*.dbf';
  if OpenDialog1.Execute then
  begin
    DemTable.Active:=False;
    DemTable.TableName:='';
    DemTable.TableName:=OpenDialog1.FileName;
    DbNameLabel.Caption:=OpenDialog1.FileName;
    VRMDatabase:=ExtractFilePath(OpenDialog1.FileName);
    DemTable.Active:=True;
    DemTable.First;
    FieldLabel.Caption:=DemTable.Fields[0].AsString;
    SpinEdit1.MaxValue:=DemTable.FieldCount;
    FieldFileNameNumber:=0;
    DisplayNavigator1.Enabled:=True;
    ProcessDb1.Enabled:=True;
    ListProcessorMenu.Enabled:=True;
    Db250kbins1.Enabled:=True;
      DBNavigator1.Enabled:=DemTable.Active;
      DBNavigator1.Visible:=DemTable.Active;
  end;
end;

procedure TdtmDbForm.DBGrid1ColEnter(Sender: TObject);
begin
{Read the SelectedField or SelectedIndex property
 to determine which cell was just entered.
 vs:
 procedure TdtmDbForm.DBGrid1CellClick(Column: TColumn);}
  with DBGrid1.SelectedField do
  begin
  Memo1.Clear;
  StarIsThere := True;
  SelectedField:= DBGrid1.SelectedIndex;
  SpinEdit1.Value:= DBGrid1.SelectedIndex;
  Memo1.Lines.Add('250K: State Lat Long MRC : '+Inttostr(SelectedField));
  StareThereString:= DemTable.Fields.Fields[SelectedField].AsString;
  MrcStEdit.Visible:=True;
  MrcStEdit.Text:=StareThereString;
  Memo1.Lines.Add(StareThereString);
  end;
end;

procedure TdtmDbForm.MrcStEditChange(Sender: TObject);
begin
  StareThereString:=MrcStEdit.Text;
end;

{Determine which field contains the actual filename}
procedure TdtmDbForm.SpinEdit1Change(Sender: TObject);
begin
  If SpinEdit1.Value < SpinEdit1.MaxValue then
  begin
    FieldLabel.Caption:=DemTable.Fields[SpinEdit1.Value].AsString;
    FieldFileNameNumber:=SpinEdit1.Value;
    SelectedField:=SpinEdit1.Value;
  end;
end;

procedure TdtmDbForm.LocateFilesBtnClick(Sender: TObject);
begin
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := 'Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
  end;
end;


(*
procedure TdtmDbForm.SpeedButton1Click(Sender: TObject);
var
  i,Longer: Integer;
  s: string;
begin
  with ProgressBar1 do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    for i := Min to Max do
    begin
      {IF not a E then add a W and change the Longitude -1 degree}
      s:=DemTable.Fields[0].AsString;
      FieldLabel.Caption:=s;
{      if ((Pos('-E', s)>0)) then
      begin
      For Longer :=1 to Length(s) do
      If s[Longer]='_' then s[Longer]:='-';
      For Longer :=1 to Length(s) do
      If s[Longer]=' ' then s[Longer]:='_';
        DemTable.Edit;
        DemTable.Fields.Fields[0].AsString := s;
        DemTable.Post;
      end else}
      if ({not}(Pos('-W', s)>0)) then
      begin
      For Longer :=1 to Length(s) do
{      If s[Longer]=' ' then s[Longer]:='_';
        s:=s+'-W';}
        DemTable.Edit;
{        DemTable.Fields.Fields[0].AsString := s;}
        s:=DemTable.Fields[3].AsString;
        Longer:=StrtoInt(s);
        {dec(Longer);}inc(Longer);inc(Longer);
        DemTable.Fields.Fields[3].AsString := InttoStr(Longer);
        DemTable.Post;
      end;
      Position := i;
      DemTable.Next;
    end;
  end;
  ProgressBar1.Position:=0;
  ProgressBar.Visible:=False;
end;
*)

{Search database <> files to verify they exist}
procedure TdtmDbForm.ProcessBtnClick(Sender: TObject);
var
  i: Integer;
  s: string;
begin
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    Memo1.Clear;
    for i := Min to Max do
    begin
      s:=DemTable.Fields[FieldFileNameNumber].AsString;
      s:=lowercase(changefileext(s,'.bit'));
      If (FileExists(DemPath+s)) then
      begin
        DemTable.Edit;
        DemTable.Fields.Fields[5].AsString := 'A';
        DemTable.Post;
      end else
      begin
        DemTable.Edit;
        DemTable.Fields.Fields[5].AsString := 'N';
        DemTable.Post;
        FilePathLabel.Caption:=DemPath+s;
        Memo1.Lines.Add(DemPath+s);
      end;
      Position := i;
      DemTable.Next;
    end;
  end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.DBdoBtnClick(Sender: TObject);
var
  i: Integer;
  s: string;
begin
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    Memo1.Clear;
    for i := Min to Max do
    begin
      s:=DemTable.Fields[FieldFileNameNumber].AsString;
      s:=lowercase(changefileext(s,'.bit'));
      If (FileExists(DemPath+s)) then
      begin
        HtfForm.ReadAnyVersionProj(DemPath+s);
        {HtfForm.ReadDEMProj(DemPath+s);}
        s:=HtfForm.CellLocatorEdit.Text;
        DemTable.Edit;
      {250k: Name,ID,LT,LON,IMWS,A} {0,1,2,3,4}
      {24k: Name State Lat Long MRC A}
        DemTable.Fields.Fields[4].AsString := s;
        DemTable.Post;
      end;
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.BitsdoDBFilenameExtension1Click(Sender: TObject);
begin
{}
end;

procedure TdtmDbForm.BinsDoDBLatYLonXClick(Sender: TObject);
var
  i: Integer;
  s2,s: string;
begin
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    Memo1.Clear;
    for i := Min to Max do
    begin
      s:=DemTable.Fields[FieldFileNameNumber].AsString;
      s:=lowercase(changefileext(s,'.bit'));
      If (FileExists(DemPath+s)) then
      begin
        HtfForm.ReadAnyVersionProj(DemPath+s);
        {HtfForm.ReadDEMProj(DemPath+s);}
        s:=HtfForm.SEXEWEdit.Text;
        s2:=HtfForm.SEYNSEdit.Text;
        DemTable.Edit;
      {250k: Name,ID,LT,LON,IMWS,A} {0,1,2,3,4}
      {24k: Name State Lat Long MRC A}
        DemTable.Fields.Fields[3].AsString := s;
        DemTable.Fields.Fields[2].AsString := s2;
        DemTable.Post;
      end;
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.Bins250kDoDBIDClick(Sender: TObject);
begin
{250K: State Lat Long MRC : 1
49094a1}
end;

procedure TdtmDbForm.DBdoBinsBtnClick(Sender: TObject);
var
Xin,Yin,  i: Integer;
dSinData:Double;
XinS,YinS,  ss,s: string;
begin
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    Memo1.Clear;
    for i := Min to Max do
    begin
      s:=DemTable.Fields[FieldFileNameNumber].AsString;
      s:=lowercase(changefileext(s,'.bit'));
      If (FileExists(DemPath+s)) then
      begin    {Name ID LT Lon IMWS A}
        HtfForm.ReadAnyVersionProj(DemPath+s);
        {HtfForm.ReadDEMProj(DemPath+s);}
        Application.ProcessMessages;
        YinS:=DemTable.Fields.Fields[2].AsString;
        XinS:=DemTable.Fields.Fields[3].AsString;
        ss:=DemTable.Fields.Fields[4].AsString;
        HtfForm.CellLocatorEdit.Text:=ss;
        Xin:=StrtoInt(XinS);
        {Xin:=Xin*-1;}{Temp thing to fix bad data}
        Yin:=StrtoInt(YinS);
        If ((Xin < 100) and (Xin > 9))then XinS:='0'+Inttostr(Xin) else
        If ((Xin < 10) and (Xin > -1)) then XinS:='00'+Inttostr(Xin) else
        If ((Xin < 0) and (Xin > -10)) then XinS:='-00'+Inttostr(abs(Xin)) else
        If ((Xin > -100) and (Xin < -9))then XinS:='-0'+Inttostr(abs(Xin)) else
           XinS:=Inttostr(Xin);
        HtfForm.SEXEWEdit.Text:=XinS;
        If ((Yin < 10) and (Yin > -1)) then YinS:='0'+Inttostr(Yin) else
        If ((Yin < 0) and (Yin > -10)) then YinS:='-0'+Inttostr(abs(Yin)) else
           YinS:=Inttostr(Yin);
        HtfForm.SEYNSEdit.Text:=YinS;
        DemTable.Edit;
        DemTable.Fields.Fields[2].AsString:=YinS;
        DemTable.Fields.Fields[3].AsString:=XinS;
        DemTable.Post;
(*
  HtfForm.IntegerorFloatCB.Checked:=True;
  HtfForm.MapZUnitsCB.Itemindex:=2;{Meters}
  HtfForm.PixelCoordinateCB.Itemindex:=3{BR};
        HtfForm.NullValueEdit.Text :='-32767';
  HtfForm.ProjectionCB.Itemindex:=0;  {Geo}
  HtfForm.InUnitCB.Itemindex:=4; {D Degrees of arc}
  HtfForm.InUtmZoneCB.Itemindex:=60;{=Geo}
  HtfForm.UTMZoneNorthCB.Checked:=True;
  HtfForm.StatePlaneZoneEdit.Text:='0';
  HtfForm.InDatumCB.Itemindex:=13;  {Nad27}
  HtfForm.SpheroidCB.Itemindex:=0;
*)
        HtfForm.TopRightXEdit.Text:=FloattoStr(Xin);
        HtfForm.BottomRightXEdit.Text:=FloattoStr(Xin);
        HtfForm.TopLeftXEdit.Text:=FloattoStr(Xin-1);
        HtfForm.BottomLeftXEdit.Text:=FloattoStr(Xin-1);
        HtfForm.BottomLeftYEdit.Text:=FloattoStr(Yin);
        HtfForm.BottomRightYEdit.Text:=FloattoStr(Yin);
        HtfForm.TopLeftYEdit.Text:=FloattoStr(Yin+1);
        HtfForm.TopRightYEdit.Text:=FloattoStr(Yin+1);
        dSinData:=0;{Clear to zero}
        HtfForm.DLGPA1.Text:=FloattoStr(dSinData);
        HtfForm.DLGPA2.Text:=FloattoStr(dSinData);
        HtfForm.DLGPA3.Text:=FloattoStr(dSinData);
        HtfForm.DLGPB1.Text:=FloattoStr(dSinData);
        HtfForm.DLGPB2.Text:=FloattoStr(dSinData);
        HtfForm.DLGPB3.Text:=FloattoStr(dSinData);
        HtfForm.DLGPC1.Text:=FloattoStr(dSinData);
        HtfForm.DLGPC2.Text:=FloattoStr(dSinData);
        HtfForm.DLGPC3.Text:=FloattoStr(dSinData);
        HtfForm.DLGPD1.Text:=FloattoStr(dSinData);
        HtfForm.DLGPD2.Text:=FloattoStr(dSinData);
        HtfForm.DLGPD3.Text:=FloattoStr(dSinData);
        HtfForm.DLGPE1.Text:=FloattoStr(dSinData);
        HtfForm.DLGPE2.Text:=FloattoStr(dSinData);
        HtfForm.DLGPE3.Text:=FloattoStr(dSinData);
        Application.ProcessMessages;
        HtfForm.WriteProjectionFile(DemPath+s);
        HtfForm.WriteBitFile(DemPath+s);
        {HtfForm.SetDEMProj(DemPath+s);}
      end;
      ProgressBar.Position := i;
      DemTable.Next;
      Application.ProcessMessages;
    end;
  end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.DBdo24KBinsProjection1Click(Sender: TObject);
begin
{24k Lat Long are floats <> 250k Integers
24k would require PROJECTION...
this actually DUMPS 250k info and changes to a single degree box}
end;

procedure TdtmDbForm.N24kBinsdoDBState1Click(Sender: TObject);
var
  i: Integer;
  s: string;
begin
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    Memo1.Clear;
    for i := Min to Max do
    begin
      s:=DemTable.Fields[FieldFileNameNumber].AsString;
      s:=lowercase(changefileext(s,'.bit'));
      If (FileExists(DemPath+s)) then
      begin
        HtfForm.ReadAnyVersionProj(DemPath+s);
        {HtfForm.ReadDEMProj(DemPath+s);}
        s:=HtfForm.StateNameEdit.Text;
        {State Name}
        DemTable.Edit;
      {250k: Name,ID,LT,LON,IMWS,A} {0,1,2,3,4}
      {24k: Name State Lat Long MRC}
        DemTable.Fields.Fields[1].AsString := s;
        DemTable.Post;
      end;
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;
(***********************************************************)

(***********************************************************)

procedure TdtmDbForm.SortOnLatLonClick(Sender: TObject);
var
i:Integer;
begin
  {DemTable.TableName}
  OpenDialog1.InitialDir:=VRMDatabase;
  OpenDialog1.Filter := 'Dbf files (*.dbf)|*.dbf';
  if OpenDialog1.Execute then
  begin
    DemTable.Active:=False;
    DemTable.TableName:='';
    DemTable.TableName:=OpenDialog1.FileName;
    DbNameLabel.Caption:=OpenDialog1.FileName;
    VRMDatabase:=ExtractFilePath(OpenDialog1.FileName);
    DemTable.Active:=True;
    DemTable.First;
    FieldLabel.Caption:=DemTable.Fields[0].AsString;
    SpinEdit1.MaxValue:=DemTable.FieldCount;
    FieldFileNameNumber:=0;
    DisplayNavigator1.Enabled:=True;
    ProcessDb1.Enabled:=True;
    ListProcessorMenu.Enabled:=True;
    Db250kbins1.Enabled:=True;
    DBNavigator1.Enabled:=DemTable.Active;
    DBNavigator1.Visible:=DemTable.Active;
  end;

  If DemTable.Active then
  begin
    Inc(LayersLoaded);
    CurrentLayer:=LayersLoaded;
    SetLength(LayA,LayersLoaded+1);
    SetLength(LayersControlArray,LayersLoaded);
    LayersControlArray[LayersLoaded-1]:= LayersLoaded;
    LayA[CurrentLayer].AttributesN:=DemTable.FieldDefs.Count;
    SetLength(LayA[CurrentLayer].AttType,
            LayA[CurrentLayer].AttributesN);
    for i:= 0 to DemTable.FieldDefs.Count - 1 do
    begin
      LayA[CurrentLayer].AttType[i].FieldNo:=
        DemTable.FieldDefs[i].FieldNo;
      LayA[CurrentLayer].AttType[i].Displayname:=
        DemTable.FieldDefs[i].Name;
      LayA[CurrentLayer].AttType[i].DataType:=
        DemTable.FieldDefs[i].DataType;
      LayA[CurrentLayer].AttType[i].Size:=
        DemTable.FieldDefs[i].Size;
      LayA[CurrentLayer].AttType[i].Precision:=
        DemTable.FieldDefs[i].Precision;
      LayA[CurrentLayer].AttType[i].Required:=
        DemTable.FieldDefs[i].Required;
    end;

    {Make a database table}
    {dbTable:=TTable.Create(dtmDbForm); }
    with Dbf1 do
    begin
      Active:=False;
      {DatabaseName:= DemTable.DatabaseName;}
      {TableType := ttDBase;}
      FilePath:= ExtractFilePath(OpenDialog1.FileName);
      TableName:=ChangeFileExt(ExtractFileName(OpenDialog1.FileName),'.db');
      with FieldDefs do
      begin
        Clear;    {i:= 0;}
        for i:= 0 to LayA[CurrentLayer].AttributesN - 1 do
        begin
          with AddFieldDef do
          begin
            FieldNo:=LayA[CurrentLayer].AttType[i].FieldNo;
            Name := LayA[CurrentLayer].AttType[i].Displayname;
            DataType := LayA[CurrentLayer].AttType[i].DataType;
            Size:=LayA[CurrentLayer].AttType[i].Size ;
            Precision:=LayA[CurrentLayer].AttType[i].Precision;
            Required:=LayA[CurrentLayer].AttType[i].Required;
          end;
        end;
      End;{FieldDefs}
(*
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        {250k(956): Name,ID,LT,LON,IMWS,A}
        with AddIndexDef do
        begin
          Name := '';
          Fields := dbTable.Fields[2].Name
          +';'+dbTable.Fields[3].Name;{'Field1';}
          Options := [ixPrimary];
        end;
      end;
*)
      CreateTable;
      Dbf1.Active := True;
    end;
    {Copy from original to temporary Paradox db}
    DemTable.First;
    Dbf1.First;
    ProgressBar.Visible:=True;
    with ProgressBar do
    begin
      Min := 0;
      Max := DemTable.RecordCount;
      DemTable.First;
      Memo1.Clear;
      for i := Min to Max do
      begin
        {      S:=ExtractFileName(S);
         FieldLabel.Caption:=S;}
        Application.ProcessMessages;
        {Fill the Shape data into arrays}
        {SelectedField  StareThereString}
        {250k: Name,ID,LT,LON,IMWS,A}
        {24k: Name State Lat Long MRC A}
        {24k has State      If SelectedStatefromdatabase1.Checked then
         dbTable.AppendRecord([S,MrcStEdit.Text]) else}
        {      dbTable.AppendRecord([S]);}
        {250K
          Name,ID,LT,LON,IMWS,A}
        Dbf1.AppendRecord([
        DemTable.Fields.Fields[0].AsString,
        DemTable.Fields.Fields[1].AsString,
        DemTable.Fields.Fields[2].AsString,
        DemTable.Fields.Fields[3].AsString,
        DemTable.Fields.Fields[4].AsString,
        DemTable.Fields.Fields[5].AsString]);
                       {DemTable.FieldValues['Name'],
                       DemTable.FieldValues['State'],
                       DemTable.FieldValues['Lat'],
                       DemTable.FieldValues['Long'],
                       DemTable.FieldValues['MRC']]);}
        ProgressBar.Position := i;
        DemTable.Next;
      end;
    end;
    ProgressBar.Position:=0;
    {Copy back to Original}
    DemTable.Active:=False;
    {DemTable.EmptyTable;}
    with ProgressBar do
    begin
      Min := 0;
      Max := DemTable.RecordCount;
      DemTable.First;
      Memo1.Clear;
      for i := Min to Max do
      begin
      DemTable.delete;
      end;
    end;
    ProgressBar.Visible:=True;
    with ProgressBar do
    begin
      Min := 0;
      Max := DemTable.RecordCount;
      DemTable.First;
      for i := Min to Max do
      begin
        DemTable.delete;
      end;
    end;
    DemTable.Active:=True;
    DemTable.First;
    Dbf1.First;
    ProgressBar.Visible:=True;
    with ProgressBar do
    begin
      Min := 0;
      Max := Dbf1.RecordCount;
      Dbf1.First;
      Memo1.Clear;
      for i := Min to Max do
      begin
        {      S:=ExtractFileName(S);
         FieldLabel.Caption:=S;}
        Application.ProcessMessages;
        {Fill the Shape data into arrays}
        {SelectedField  StareThereString}
        {250k: Name,ID,LT,LON,IMWS,A}
        {24k: Name State Lat Long MRC A}
        {24k has State      If SelectedStatefromdatabase1.Checked then
         dbTable.AppendRecord([S,MrcStEdit.Text]) else}
        {      dbTable.AppendRecord([S]);}
        {250K
          Name,ID,LT,LON,IMWS,A}
        DemTable.AppendRecord([
        Dbf1.Fields.Fields[0].AsString,
        Dbf1.Fields.Fields[1].AsString,
        Dbf1.Fields.Fields[2].AsString,
        Dbf1.Fields.Fields[3].AsString,
        Dbf1.Fields.Fields[4].AsString,
        Dbf1.Fields.Fields[5].AsString]);
                       {DemTable.FieldValues['Name'],
                       DemTable.FieldValues['State'],
                       DemTable.FieldValues['Lat'],
                       DemTable.FieldValues['Long'],
                       DemTable.FieldValues['MRC']]);}
        ProgressBar.Position := i;
        Dbf1.Next;
      end;
    end;
    ProgressBar.Position:=0;
  end;
  {Get name of 1st REAL db (Open) and 2nd TO BE DB (Save)
   Load 1st DB and get info
   Make 2nd DB and its PRIMARY INDEX of Lat Lon
   Copy All data from 1 to 2 (sorted) then back from 2 to 1}
  Dbf1.Active:=False;
  Dbf1.TableName:='';
  Dbf1.Free;{ finally, delete the table }
  DemTable.Active:=False;
  DemTable.TableName:='';
  DbNameLabel.Caption:='';
  FieldFileNameNumber:=0;
  DisplayNavigator1.Enabled:=False;
  ProcessDb1.Enabled:=False;
  ListProcessorMenu.Enabled:=False;
  Db250kbins1.Enabled:=True;
  DBNavigator1.Enabled:=DemTable.Active;
  DBNavigator1.Visible:=DemTable.Active;
  FieldLabel.Caption:='';
      {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

(***********************************************************)
     {LIST Functions}
     {
File list of DEM files
-> Make Database
-> Check List <> DB
-> Make Shape and Tpcfg from DB
     }
(***********************************************************)
procedure TdtmDbForm.LoadListBtnClick(Sender: TObject);
var
 ii:Integer;
 S : string;
 F: TextFile;
begin
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter:= 'DEM files list (*.txt)|*.txt';
  OpenDialog1.Filename:= '_graflist.txt';{graflist.txt}
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
      AssignFile(F, OpenDialog1.FileName);
      Reset(F);
      Listbox1.Clear;
      Memo1.Clear;
      Try
    Repeat
    begin
      Readln(F, S);
      Memo1.Lines.Add(s);
    end;
    until (eof(F));
       Finally
       CloseFile(F);
       end;
    Application.ProcessMessages;
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    for ii := Min to Max do
    begin
      s:=DemTable.Fields[0].AsString;
      s:=lowercase(DemPath+ChangeFileExt(s,'.bit'));
      Listbox1.Items.Add(s);
      Position := ii;
      DemTable.Next;
    end;
    end;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  end;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.DoitBtnClick(Sender: TObject);
var i,ii:Integer;
begin
  {Check FILES memo against DB listbox}
  for ii := 0 to (Memo1.Lines.Count - 1) do
  begin
    FilePathLabel.Caption:=lowercase(Memo1.Lines[ii]);
    Application.ProcessMessages;
    for i := 0 to (ListBox1.Items.Count - 1) do
    begin
      If lowercase(Memo1.Lines[ii])= lowercase(ListBox1.Items[i]) then
      begin
        {    ListBox1.Items.Delete[ii]; }
        DbNameLabel.Caption:=lowercase(Memo1.Lines[ii]);
        Memo1.Lines[ii]:='...';{Strings[i].Delete[ii];}
        Application.ProcessMessages;
        break;
      end;
    end;
  end;
  {Could not get delete to work so mangled this to get a memo list}
  ListBox1.Clear;
  for ii := (Memo1.Lines.Count - 1) downto 0 do
  begin
    If lowercase(Memo1.Lines[ii])<>'...'then
      Listbox1.Items.Add(Memo1.Lines[ii]);
  end;
  Listbox1.Sorted:=True;
  for i := 0 to (ListBox1.Items.Count - 1) do
  begin
    Memo1.Lines.Add(ListBox1.Items[i]);
  end;
  ListBox1.Clear;
end;


{Convert 250k DB into a shape file}
procedure TdtmDbForm.MakeShapeBtnClick(Sender: TObject);
var
  FileString:String;
  ShapeType, PointCount, IslandCount,i: Integer;
{  NumShape,} NumParts, NumPoints,   ShapeNumber: integer;
  TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
  BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,
  Xin,Yin,
  dXMINt, dYMINt, dXMAXt, dYMAXt:Double;
  XinS,YinS{,s}: string;
begin
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[LayersLoaded-1]:= LayersLoaded;
  dXMINt:=510324;
  dYMINt:=510324;
  dXMAXt:=-510324;
  dYMAXt:=-510324;
  PointCount := 0;
  IslandCount := 0;
     {AreaCount := 0; }
  ShapeNumber :=0;
  {    NumShape:=0;}
  LayA[CurrentLayer].Modified:=False;
  LayA[CurrentLayer].LayerN:=CurrentLayer;
  ShapeType:=5;{Polygon}
  LayA[CurrentLayer].ShpType:=ShapeType;
  LayA[CurrentLayer].Modified:=False;
  FileString:=DbNameLabel.Caption;
  LayA[CurrentLayer].LayerDBName:=ExtractFileName(FileString);
  LayA[CurrentLayer].LayerDBPath:=ExtractFilePath(FileString);
  FileString:=ChangeFileExt(FileString,'.shp');
  LayA[CurrentLayer].Filename:=ExtractFileName(FileString);
  LayA[CurrentLayer].Path:=ExtractFilePath(FileString);
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    for i := Min to Max do
    begin       {934 dems}
      {Fill the Shape data into arrays}
{      If ('A'=DemTable.Fields.Fields[5].AsString) then }
      Begin
      { s:=DemTable.Fields[FieldFileNameNumber].AsString;}
      YinS:=DemTable.Fields.Fields[2].AsString;
      XinS:=DemTable.Fields.Fields[3].AsString;
      Xin:=StrtoFloat(XinS);
      Yin:=StrtoFloat(YinS);

      TopRightXEdit:=(Xin);
      BottomRightXEdit:=(Xin);
      TopLeftXEdit:=(Xin-1);
      BottomLeftXEdit:=(Xin-1);
      BottomLeftYEdit:=(Yin);
      BottomRightYEdit:=(Yin);
      TopLeftYEdit:=(Yin+1);
      TopRightYEdit:=(Yin+1);
      inc(ShapeNumber);
        {NumShape:=SwapShapeInteger(ICOIn);}{Store total for later}
      Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
      LayA[CurrentLayer].LyrShp[ShapeNumber].ShpType:=ShapeType;
      LayA[CurrentLayer].LyrShp[ShapeNumber].ShapeIDN:=ShapeNumber;
      Numparts:=1;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=Numparts;
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
      NumPoints:=5;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
      PointCount:=PointCount+NumPoints;{Total points for File}
      LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:={0;}NumPoints;{((NumPoints-BufI)+1);}{BufI;}
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,NumPoints+1);

      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{ointNumber}].Xd:=TopRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{PointNumber}].Yd:=TopRightYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Xd:=BottomRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Yd:=BottomRightYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Xd:=BottomLeftXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Yd:=BottomLeftYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Xd:=TopLeftXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Yd:=TopLeftYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Xd:=TopRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Yd:=TopRightYEdit;
      if Xin-1<dXMINt then dXMINt := Xin-1;
      if Yin<dYMINt then dYMINt := Yin;
      if Xin>dXMAXt then dXMAXt := Xin;
      if Yin+1>dYMAXt then dYMAXt := Yin+1;

      LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= Xin-1;
      LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= Yin;
      LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= Xin;
      LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= Yin+1;
      {TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
       BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,}
      end;{If A}
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  LayA[CurrentLayer].LayerColor:=
     RGB(Random(255),Random(255),Random(255));
  LayA[CurrentLayer].ShapeN:=ShapeNumber;{NumShape;}
  LayA[CurrentLayer].TotalPnts:=PointCount;
  LayA[CurrentLayer].IslandsN:=IslandCount;
  LayA[CurrentLayer].XMin:= dXMINt;
  LayA[CurrentLayer].YMin:= dYMINt;
  LayA[CurrentLayer].XMax:= dXMAXt;
  LayA[CurrentLayer].YMax:= dYMAXt;
  LayA[CurrentLayer].ZMin:= 0;
  LayA[CurrentLayer].ZMax:= 0;
  LayA[CurrentLayer].MMin:= 0;
  LayA[CurrentLayer].MMax:= 0;
  if dXMINt < 0 then
      LayA[CurrentLayer].OffsetX := abs(dXMINt)
      else if dXMINt > 0 then
      LayA[CurrentLayer].OffsetX  := (0 - dXMINt)
      else LayA[CurrentLayer].OffsetX  := 0;
  if dYMINt < 0 then
      LayA[CurrentLayer].OffsetY := abs(dYMINt)
      else if dYMINt > 0 then
      LayA[CurrentLayer].OffsetY := (0 - dYMINt)
      else LayA[CurrentLayer].OffsetY := 0;

  If abs(LayA[CurrentLayer].OffsetX) > abs(MaxOffsetX) then
       MaxOffsetX:= LayA[CurrentLayer].OffsetX;
  If abs(LayA[CurrentLayer].OffsetY) > abs(MaxOffsetY) then
       MaxOffsetY:= LayA[CurrentLayer].OffsetY;
  If CurrentLayer =1 then
  Begin
    MinOffX:=LayA[CurrentLayer].XMin;
    MinOffY:=LayA[CurrentLayer].YMin;
    MaxOffX:=LayA[CurrentLayer].XMax;
    MaxOffY:=LayA[CurrentLayer].YMax;
  End;
  {Write the shape file}
  SaveShpFile(CurrentLayer,FileString);
  {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);
  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

(*
procedure TdtmDbForm.Make1DegreeShapefromDbperField1Click(Sender: TObject);
var
  FileString:String;
  ShapeType, PointCount, IslandCount,i: Integer;
{  NumShape,} NumParts, NumPoints,   ShapeNumber: integer;
  TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
  BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,
  Xin,Yin,
  dXMINt, dYMINt, dXMAXt, dYMAXt:Double;
  XinS,YinS,s: string;
begin
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[LayersLoaded-1]:= LayersLoaded;
  dXMINt:=510324;
  dYMINt:=510324;
  dXMAXt:=-510324;
  dYMAXt:=-510324;
  PointCount := 0;
  IslandCount := 0;
     {AreaCount := 0; }
  ShapeNumber :=0;
  {    NumShape:=0;}
  LayA[CurrentLayer].Modified:=False;
  LayA[CurrentLayer].LayerN:=CurrentLayer;
  ShapeType:=5;{Polygon}
  LayA[CurrentLayer].ShpType:=ShapeType;
  LayA[CurrentLayer].Modified:=False;
  FileString:=DbNameLabel.Caption;
  LayA[CurrentLayer].LayerDBName:=ExtractFileName(FileString);
  LayA[CurrentLayer].LayerDBPath:=ExtractFilePath(FileString);
  FileString:=ChangeFileExt(FileString,'.shp');
  LayA[CurrentLayer].Filename:=ExtractFileName(FileString);
  LayA[CurrentLayer].Path:=ExtractFilePath(FileString);
  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    for i := Min to Max do
    begin       {934 dems}
      {Fill the Shape data into arrays}
If (MrcStEdit.Text = DemTable.Fields[SelectedField].AsString) then
{      If ('A'=DemTable.Fields.Fields[5].AsString) then}
      Begin
      { s:=DemTable.Fields[FieldFileNameNumber].AsString;}
      YinS:=DemTable.Fields.Fields[2].AsString;
      XinS:=DemTable.Fields.Fields[3].AsString;
      Xin:=StrtoFloat(XinS);
      Yin:=StrtoFloat(YinS);

      TopRightXEdit:=(Xin);
      BottomRightXEdit:=(Xin);
      TopLeftXEdit:=(Xin-1);
      BottomLeftXEdit:=(Xin-1);
      BottomLeftYEdit:=(Yin);
      BottomRightYEdit:=(Yin);
      TopLeftYEdit:=(Yin+1);
      TopRightYEdit:=(Yin+1);
      inc(ShapeNumber);
        {NumShape:=SwapShapeInteger(ICOIn);}{Store total for later}
      Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
      LayA[CurrentLayer].LyrShp[ShapeNumber].ShpType:=ShapeType;
      LayA[CurrentLayer].LyrShp[ShapeNumber].ShapeIDN:=ShapeNumber;
      Numparts:=1;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=Numparts;
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
      NumPoints:=5;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
      PointCount:=PointCount+NumPoints;{Total points for File}
      LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:={0;}NumPoints;{((NumPoints-BufI)+1);}{BufI;}
      SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,NumPoints+1);

      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{ointNumber}].Xd:=TopRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{PointNumber}].Yd:=TopRightYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Xd:=BottomRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Yd:=BottomRightYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Xd:=BottomLeftXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Yd:=BottomLeftYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Xd:=TopLeftXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Yd:=TopLeftYEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Xd:=TopRightXEdit;
      LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Yd:=TopRightYEdit;
      if Xin-1<dXMINt then dXMINt := Xin-1;
      if Yin<dYMINt then dYMINt := Yin;
      if Xin>dXMAXt then dXMAXt := Xin;
      if Yin+1>dYMAXt then dYMAXt := Yin+1;

      LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= Xin-1;
      LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= Yin;
      LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= Xin;
      LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= Yin+1;
      {TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
       BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,}
      end;{If A}
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  LayA[CurrentLayer].LayerColor:=
     RGB(Random(255),Random(255),Random(255));
  LayA[CurrentLayer].ShapeN:=ShapeNumber;{NumShape;}
  LayA[CurrentLayer].TotalPnts:=PointCount;
  LayA[CurrentLayer].IslandsN:=IslandCount;
  LayA[CurrentLayer].XMin:= dXMINt;
  LayA[CurrentLayer].YMin:= dYMINt;
  LayA[CurrentLayer].XMax:= dXMAXt;
  LayA[CurrentLayer].YMax:= dYMAXt;
  LayA[CurrentLayer].ZMin:= 0;
  LayA[CurrentLayer].ZMax:= 0;
  LayA[CurrentLayer].MMin:= 0;
  LayA[CurrentLayer].MMax:= 0;
  if dXMINt < 0 then
      LayA[CurrentLayer].OffsetX := abs(dXMINt)
      else if dXMINt > 0 then
      LayA[CurrentLayer].OffsetX  := (0 - dXMINt)
      else LayA[CurrentLayer].OffsetX  := 0;
  if dYMINt < 0 then
      LayA[CurrentLayer].OffsetY := abs(dYMINt)
      else if dYMINt > 0 then
      LayA[CurrentLayer].OffsetY := (0 - dYMINt)
      else LayA[CurrentLayer].OffsetY := 0;

  If abs(LayA[CurrentLayer].OffsetX) > abs(MaxOffsetX) then
       MaxOffsetX:= LayA[CurrentLayer].OffsetX;
  If abs(LayA[CurrentLayer].OffsetY) > abs(MaxOffsetY) then
       MaxOffsetY:= LayA[CurrentLayer].OffsetY;
  If CurrentLayer =1 then
  Begin
    MinOffX:=LayA[CurrentLayer].XMin;
    MinOffY:=LayA[CurrentLayer].YMin;
    MaxOffX:=LayA[CurrentLayer].XMax;
    MaxOffY:=LayA[CurrentLayer].YMax;
  End;
  {Write the shape file}
  SaveShpFile(CurrentLayer,FileString);
  {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);
  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;
*)
procedure TdtmDbForm.MakeMTVSelected24KShapefromDb1Click(Sender: TObject);
begin
  If StarIsThere then
  begin
    {GET correct DEMPATH}
    OpenDialog1.InitialDir:=DemPath;
    OpenDialog1.Filter := '24K Dem bit files (*.bit)|*.bit';
    if OpenDialog1.Execute then
    begin
      DemPath:=ExtractFilePath(OpenDialog1.FileName);
      FilePathLabel.Caption:=DemPath;
                  {47124-G6}
      StareThereString:=Copy(StareThereString,1,5);
      Make24KShapefromDb(-1);
      Make24Ktpcfg(StareThere);{uses DemPath}
      Dbf1.free;
    end;
  end;
end;


procedure TdtmDbForm.MakeStateSelected24KShapefromDb1Click(
          Sender: TObject);
begin
 If StarIsThere then
  begin
    {GET correct DEMPATH}
    OpenDialog1.InitialDir:=DemPath;
    OpenDialog1.Filter := '24K Dem bit files (*.bit)|*.bit';
    if OpenDialog1.Execute then
    begin
      DemPath:=ExtractFilePath(OpenDialog1.FileName);
      FilePathLabel.Caption:=DemPath;
      Make24KShapefromDb(0);
      Make24Ktpcfg(StareThere);{uses DemPath}
      Dbf1.free;
    end;
  end;
end;

{  SelectedField:= DBGrid1.SelectedIndex;
  Memo1.Lines.Add('State Lat Long MRC : '+Inttostr(SelectedField));
  StareThereString:= DemTable.Fields.Fields[SelectedField].AsString;
  Memo1.Lines.Add(StareThereString);
}
procedure TdtmDbForm.MakeALLMRC24KShapesfromDb1Click(Sender: TObject);
var
  ii,i:integer;
  ss:String;
  found:Boolean;
begin
  {GET correct DEMPATH}
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := 'tpcfg: 24K Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
                  {47124-G6} {MRC... cut off end data}
    {SelectedField  StareThereString}
    {Name State Lat Long MRC}
    {      -1: Begin
            ss:=DemTable.Fields[SelectedField].AsString;
            ss:=  Copy(ss,1,5);
            If (ss=StareThereString)then}
      SelectedField:=4; {MRC}
    {Make List then rotate through it}
    ListBox1.Clear;
    DemTable.First;
    ss:=DemTable.Fields[SelectedField].AsString;
    ss:=  Copy(ss,1,5);
    Listbox1.Items.Add(ss);
    {  Memo1.Lines.Add(ListBox1.Items[i]);}
    with ProgressBar do
    begin
      Min := 0;
      Max := DemTable.RecordCount;
      DemTable.First;
      for i := Min to Max do
      begin       {>50k dems sorted on MRC =16 cell groups}
        {Fill the Shape data into arrays}
        {SelectedField  StareThereString}
        {Name State Lat Long MRC}
        {MRC... cut off end data}
        ss:=DemTable.Fields[SelectedField].AsString;
        ss:=  Copy(ss,1,5);
        found:=False;
        for ii := 0 to (ListBox1.Items.Count - 1) do
        begin
          If lowercase(ss)<>lowercase(ListBox1.Items[ii]) then
          begin
            Listbox1.Items.Add(ss);
            found:=true;
          end;
          If found then break;{this loop}
        end;
        Position := i;
        DemTable.Next;
      end;
    end;
    ProgressBar.Position:=0;

    {Listbox1.Items.Add(Memo1.Lines[ii]);}
    for ii := 0 to (ListBox1.Items.Count - 1) do
    begin
      StareThereString:=ListBox1.Items[ii];
      Make24KShapefromDb(-1);
      Make24Ktpcfg(StareThere);{uses DemPath}
      Dbf1.free;
    end;
  end;
end;


procedure TdtmDbForm.MakeALLState24KShapesfromDb1Click(Sender: TObject);
var
  ii,i:integer;
  ss:String;
  found:Boolean;
begin
  {GET correct DEMPATH}
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := '24K Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
      {Rotate through ALL States} {Selected State}
      {            ss:=DemTable.Fields[SelectedField].AsString;
            If (ss=StareThereString)then}
    SelectedField:=1;{State}
      {Make List then rotate through it}
    ListBox1.Clear;
    DemTable.First;
    ss:=DemTable.Fields[SelectedField].AsString;
    Listbox1.Items.Add(ss);
    with ProgressBar do
    begin
      Min := 0;
      Max := DemTable.RecordCount;
      DemTable.First;
      for i := Min to Max do
      begin       {>50k dems sorted on state =50? cell groups}
        {Fill the Shape data into arrays}
        {SelectedField  StareThereString}
        {Name State Lat Long MRC}
        ss:=DemTable.Fields[SelectedField].AsString;
        found:=False;
        for ii := 0 to (ListBox1.Items.Count - 1) do
        begin
          If lowercase(ss)<>lowercase(ListBox1.Items[ii]) then
          begin
            Listbox1.Items.Add(ss);
            found:=true;
          end;
          If found then break;{this loop}
        end;
        Position := i;
        DemTable.Next;
      end;
    end;
    ProgressBar.Position:=0;

    for ii := 0 to (ListBox1.Items.Count - 1) do
    begin
      StareThereString:=ListBox1.Items[ii];
      Make24KShapefromDb(0);
      Make24Ktpcfg(StareThere);{uses DemPath}
      Dbf1.free;
    end;
  end;
end;

procedure TdtmDbForm.MakeAll24KShapefromDbClick(Sender: TObject);
begin
  begin
    {GET correct DEMPATH}
    OpenDialog1.InitialDir:=DemPath;
    OpenDialog1.Filter := '24K Dem bit files (*.bit)|*.bit';
    if OpenDialog1.Execute then
    begin
      DemPath:=ExtractFilePath(OpenDialog1.FileName);
      FilePathLabel.Caption:=DemPath;
      Make24KShapefromDb(1);
      Make24Ktpcfg(StareThere);{uses DemPath}
      Dbf1.free;
    end;
  end;
end;

procedure TdtmDbForm.Make24KShapefromDb(Switch:Integer);
var
  DoThisOne:Boolean;
  ShapeType, PointCount, IslandCount,
  {NumShape,} NumParts, NumPoints,   ShapeNumber,i: integer;
  TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
  BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,
  Xin,Yin,dXMINt, dYMINt, dXMAXt, dYMAXt:Double;
  FileString:String;
  XinS,YinS,ss: string;
begin
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[LayersLoaded-1]:= LayersLoaded;
  dXMINt:=510324;
  dYMINt:=510324;
  dXMAXt:=-510324;
  dYMAXt:=-510324;
  PointCount := 0;
  IslandCount := 0;
     {AreaCount := 0; }
  ShapeNumber :=0;
    {NumShape:=0;}
  LayA[CurrentLayer].Modified:=False;
  LayA[CurrentLayer].LayerN:=CurrentLayer;
  ShapeType:=5;{Polygon}
  LayA[CurrentLayer].ShpType:=ShapeType;
  LayA[CurrentLayer].Modified:=False;
  FileString:=DbNameLabel.Caption;
  LayA[CurrentLayer].LayerDBName:=ExtractFileName(FileString);
  LayA[CurrentLayer].LayerDBPath:=ExtractFilePath(FileString);
  FileString:=ChangeFileExt(FileString,'.shp');
  LayA[CurrentLayer].Filename:=ExtractFileName(FileString);
  LayA[CurrentLayer].Path:=ExtractFilePath(FileString);

  LayA[CurrentLayer].AttributesN:=DemTable.FieldDefs.Count;
  SetLength(LayA[CurrentLayer].AttType,
            LayA[CurrentLayer].AttributesN);
  {type TFieldType =
  (ftUnknown, ftString, ftSmallint, ftInteger, ftWord, ftBoolean,
   ftFloat, ftCurrency, ftBCD, ftDate, ftTime, ftDateTime,
   ftBytes, ftVarBytes, ftAutoInc, ftBlob, ftMemo, ftGraphic,
   ftFmtMemo, ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor,
   ftFixedChar, ftWideString, ftLargeint, ftADT, ftArray,
   ftReference, ftDataSet, ftOraBlob, ftOraClob, ftVariant,
   ftInterface, ftIDispatch, ftGuid);}
  for i:= 0 to DemTable.FieldDefs.Count - 1 do
  begin
    LayA[CurrentLayer].AttType[i].FieldNo:=
        DemTable.FieldDefs[i].FieldNo;
    LayA[CurrentLayer].AttType[i].Displayname:=
        DemTable.FieldDefs[i].Name;
    LayA[CurrentLayer].AttType[i].DataType:=
        DemTable.FieldDefs[i].DataType;
    LayA[CurrentLayer].AttType[i].Size:=
        DemTable.FieldDefs[i].Size;
    LayA[CurrentLayer].AttType[i].Precision:=
        DemTable.FieldDefs[i].Precision;
    LayA[CurrentLayer].AttType[i].Required:=
        DemTable.FieldDefs[i].Required;
  end;

  {For Multiple sets RECREATE a Database ELSE just make 1}
  {Make a database table}
  {dbTable:=TTable.Create(dtmDbForm);}
  with Dbf1 do
  begin
    Active:=False;
    {DatabaseName:= DemTable.DatabaseName; }
    {    'sshift'+ IntToStr(LayerDBCount);}
    {TableType := ttDBase;}
    TableName:=StareThereString+LayA[CurrentLayer].LayerDBName;
    with FieldDefs do
    begin
      Clear;
      for i:= 0 to LayA[CurrentLayer].AttributesN - 1 do
      begin
        with AddFieldDef do
        begin
          FieldNo:=LayA[CurrentLayer].AttType[i].FieldNo;
          Name := LayA[CurrentLayer].AttType[i].Displayname;
          DataType := LayA[CurrentLayer].AttType[i].DataType;
          Size:=LayA[CurrentLayer].AttType[i].Size ;
          Precision:=LayA[CurrentLayer].AttType[i].Precision;
          Required:=LayA[CurrentLayer].AttType[i].Required;
        end;
      end;
    End;{FieldDefs}
    CreateTable;
    Dbf1.Active := True;
  end;


  ProgressBar.Visible:=True;
  with ProgressBar do
  begin
    Min := 0;
    Max := DemTable.RecordCount;
    DemTable.First;
    for i := Min to Max do
    begin       {>50k dems sorted on MRC =16 cell groups}
      {Fill the Shape data into arrays}
      {SelectedField  StareThereString}
      {Name State Lat Long MRC}
      Case Switch of
      -1: Begin   {MRC... cut off end data}
            ss:=DemTable.Fields[SelectedField].AsString;
            ss:=  Copy(ss,1,5);
            If (ss=StareThereString)then
            begin
              Dbf1.AppendRecord([
                       DemTable.FieldValues['Name'],
                       DemTable.FieldValues['State'],
                       DemTable.FieldValues['Lat'],
                       DemTable.FieldValues['Long'],
                       DemTable.FieldValues['MRC'],
                       DemTable.FieldValues['A']]);
              DoThisOne:=True
            end else
            begin
              DemTable.Delete;
              DoThisOne:=False;
            end
          End;
      0: Begin   {Selected State}
            ss:=DemTable.Fields[SelectedField].AsString;
            If (ss=StareThereString)then
            begin
              Dbf1.AppendRecord([
                       DemTable.FieldValues['Name'],
                       DemTable.FieldValues['State'],
                       DemTable.FieldValues['Lat'],
                       DemTable.FieldValues['Long'],
                       DemTable.FieldValues['MRC'],
                       DemTable.FieldValues['A']]);
              DoThisOne:=True
            end else
            begin
              {DemTable.Delete;}
              DoThisOne:=False;
            end
          End;
      1: Begin {ALL}
            DoThisOne:=True;
         End;
         else DoThisOne:=False;
      End;{Case}
      If DoThisOne then
      Begin
        {Lat}  YinS:=DemTable.Fields.Fields[2].AsString;
        {Lon}  XinS:=DemTable.Fields.Fields[3].AsString;
        Xin:=StrtoFloat(XinS);
        Yin:=StrtoFloat(YinS);

        TopRightXEdit:=(Xin);
        BottomRightXEdit:=(Xin);
        TopLeftXEdit:=(Xin-0.125);
        BottomLeftXEdit:=(Xin-0.125);
        BottomLeftYEdit:=(Yin);
        BottomRightYEdit:=(Yin);
        TopLeftYEdit:=(Yin+0.125);
        TopRightYEdit:=(Yin+0.125);
        inc(ShapeNumber);
        {NumShape:=SwapShapeInteger(ICOIn);}{Store total for later}
        Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
        LayA[CurrentLayer].LyrShp[ShapeNumber].ShpType:=ShapeType;
        LayA[CurrentLayer].LyrShp[ShapeNumber].ShapeIDN:=ShapeNumber;
        Numparts:=1;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=Numparts;
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
        NumPoints:=5;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
        PointCount:=PointCount+NumPoints;{Total points for File}
        LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:={0;}NumPoints;{((NumPoints-BufI)+1);}{BufI;}
        SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,NumPoints+1);

        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{ointNumber}].Xd:=TopRightXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{PointNumber}].Yd:=TopRightYEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Xd:=BottomRightXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Yd:=BottomRightYEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Xd:=BottomLeftXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Yd:=BottomLeftYEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Xd:=TopLeftXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Yd:=TopLeftYEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Xd:=TopRightXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Yd:=TopRightYEdit;
        if BottomLeftXEdit<dXMINt then dXMINt := BottomLeftXEdit;
        if BottomLeftYEdit<dYMINt then dYMINt := BottomLeftYEdit;
        if TopRightXEdit>dXMAXt then dXMAXt := TopRightXEdit;
        if TopRightYEdit>dYMAXt then dYMAXt := TopRightYEdit;

        LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= BottomLeftXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= BottomLeftYEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= TopRightXEdit;
        LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= TopRightYEdit;
        {TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
         BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,}
        ProgressBar.Position := i;
        DemTable.Next;
      end;
    end;
  End;
  LayA[CurrentLayer].LayerColor:=
      RGB(Random(255),Random(255),Random(255));
  LayA[CurrentLayer].ShapeN:=ShapeNumber;{NumShape;}
  LayA[CurrentLayer].TotalPnts:=PointCount;
  LayA[CurrentLayer].IslandsN:=IslandCount;
  LayA[CurrentLayer].XMin:= dXMINt;
  LayA[CurrentLayer].YMin:= dYMINt;
  LayA[CurrentLayer].XMax:= dXMAXt;
  LayA[CurrentLayer].YMax:= dYMAXt;
  LayA[CurrentLayer].ZMin:= 0;
  LayA[CurrentLayer].ZMax:= 0;
  LayA[CurrentLayer].MMin:= 0;
  LayA[CurrentLayer].MMax:= 0;
  if dXMINt < 0 then
      LayA[CurrentLayer].OffsetX := abs(dXMINt)
     else if dXMINt > 0 then
      LayA[CurrentLayer].OffsetX  := (0 - dXMINt)
      else LayA[CurrentLayer].OffsetX  := 0;
  if dYMINt < 0 then
      LayA[CurrentLayer].OffsetY := abs(dYMINt)
      else if dYMINt > 0 then
      LayA[CurrentLayer].OffsetY := (0 - dYMINt)
      else LayA[CurrentLayer].OffsetY := 0;

  If abs(LayA[CurrentLayer].OffsetX) > abs(MaxOffsetX) then
       MaxOffsetX:= LayA[CurrentLayer].OffsetX;
  If abs(LayA[CurrentLayer].OffsetY) > abs(MaxOffsetY) then
       MaxOffsetY:= LayA[CurrentLayer].OffsetY;
  If CurrentLayer =1 then
  Begin
    MinOffX:=LayA[CurrentLayer].XMin;
    MinOffY:=LayA[CurrentLayer].YMin;
    MaxOffX:=LayA[CurrentLayer].XMax;
    MaxOffY:=LayA[CurrentLayer].YMax;
  End;
    {Write the shape file}
  SaveShpFile(CurrentLayer,FileString);
  {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);
  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

procedure TdtmDbForm.Make24KtpcfgfromDb1Click(Sender: TObject);
begin
  StareThere:=True;
  Make24KtpcfgfromDb1.Checked:=True;
  Make24KFloattpcfgfromDb1.Checked:=False;
end;

procedure TdtmDbForm.Make24KFloattpcfgfromDb1Click(Sender: TObject);
begin
  StareThere:=False;
  Make24KFloattpcfgfromDb1.Checked:=True;
  Make24KtpcfgfromDb1.Checked:=False;
end;

procedure TdtmDbForm.Make24Ktpcfg(bZisInteger:Boolean);
var
{  StareThere
  Make24Ktpcfg(StareThere);
  Make24Ktpcfg(False);

  bZisInteger:Boolean;}
  i:Integer;
{  txin, tyin, NumRead,tx,ty:Integer;
  sSinData:Single;
  dSinData:Double;
  WhereString,   }
  XinS,YinS, yyS,
  FileString, MyFilesS: string;
  tpcfgfile:textfile;
begin
  If bZisInteger then  yyS:=',""bin 16 (Intel)"""'
     else yyS:=',""bin 32 (single)"""';
  FileString:=DbNameLabel.Caption;
  Screen.Cursor:=crHourGlass;
  ProgressBar.Position:=0;
  ProgressBar.Visible:=True;
  {Write tpcfg file}
  AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
  Rewrite(tpcfgfile);
      {HTFName=F:\HTF\etopo2.htf}
  MyFilesS:='HTFName='+HTFPath+'\'+ChangeFileExt(ExtractFileName(FileString),'.htf');
  Writeln(tpcfgfile,MyFilesS);
      {WorldSizeX=10800}
  MyFilesS:='WorldSizeX='+IntToStr(FileSizeX);
  Writeln(tpcfgfile,MyFilesS);
      {WorldSizeY=6336}
  MyFilesS:='WorldSizeY='+IntToStr(FileSizeY);
  Writeln(tpcfgfile,MyFilesS);
      {TileSize=128}
  MyFilesS:='TileSize='+IntToStr(128);
  Writeln(tpcfgfile,MyFilesS);
      {DefaultZ=0}

  MyFilesS:='DefaultZ='+HtfForm.NullValueEdit.Text;{NullDatumValue}
  Writeln(tpcfgfile,MyFilesS);
      {DEMPath=F:\DEM}
  MyFilesS:='DEMPath='+DEMPath;
  Writeln(tpcfgfile,MyFilesS);
  MyFilesS:='DEMs="'
                +ExtractFileName(ChangeFileExt(FileString,'.bit'))
                +',""0,0"",'+
                IntToStr(FileSizeX)+'x'+
                IntToStr(FileSizeY)+yyS;
  with ProgressBar do
  begin
    Min := 0;
    Max := Dbf1.RecordCount;
    DemTable.First;
    for i := Min to Max do
    begin       {934 dems}
      {Fill the Shape data into arrays}
       { s:=DemTable.Fields[FieldFileNameNumber].AsString;}
      YinS:=Dbf1.Fields.Fields[2].AsString;
      XinS:=Dbf1.Fields.Fields[3].AsString;
      ProgressBar.Position := i;
      DemTable.Next;
    end;
  end;
  Writeln(tpcfgfile,MyFilesS);
  CloseFile(tpcfgfile);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;



procedure TdtmDbForm.Make1DegreetpcfgfromDb1Click(Sender: TObject);
var
  txin3, txin2, tyin2,txin, tyin,Xfiles,i,tx,ty:Integer;
  XinSTemp,YinSTemp,XinS,YinS,s,XinSTempTOPLEFT,
  IsReal,FileString, MyFilesS: string;
  tpcfgfile:textfile;
begin
  {GET correct DEMPATH}
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := 'Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    HtfForm.ReadAnyVersionProj(OpenDialog1.FileName);
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
    FileString:=DbNameLabel.Caption;
      Screen.Cursor:=crHourGlass;
      ProgressBar.Position:=0;
    ProgressBar.Visible:=True;
    FileSizeX:={1201;}  Strtoint(HtfForm.XWidthEdit.text)-1;
    FileSizeY:={1201;}  Strtoint(HtfForm.YHeightEdit.text)-1;

    {Write tpcfg file}
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    Rewrite(tpcfgfile);
    {HTFName=F:\HTF\etopo2.htf}
    MyFilesS:='HTFName='+HTFPath{+'\'}+ChangeFileExt(ExtractFileName(FileString),'.htf');
    Writeln(tpcfgfile,MyFilesS);
      {WorldSizeX=10800}
    MyFilesS:='WorldSizeX='+IntToStr(FileSizeX);
    Writeln(tpcfgfile,MyFilesS);
     {WorldSizeY=6336}
    MyFilesS:='WorldSizeY='+IntToStr(FileSizeY);
    Writeln(tpcfgfile,MyFilesS);
      {TileSize=128}
    MyFilesS:='TileSize='+IntToStr(128);
    Writeln(tpcfgfile,MyFilesS);
      {DefaultZ=0}

    MyFilesS:='DefaultZ='+HtfForm.NullValueEdit.Text;{NullDatumValue}
    Writeln(tpcfgfile,MyFilesS);
     {DEMPath=F:\DEM}
    MyFilesS:='DEMPath='+DEMPath;
    Writeln(tpcfgfile,MyFilesS);

    MyFilesS:='DEMs=';
    YinSTemp:='0';
    txin:=0;
    tyin:=0;
    tyin2:=0;
    ty:=-FileSizeY;
    txin3:=-200;
    with ProgressBar do
    begin
      Min := 1;
      Max := DemTable.RecordCount;
      DemTable.First;
      for i := Min to Max do
      begin       {934 dems}
        {Name,ID,LT,LON,IMWS,A}
        Application.ProcessMessages;
        s:=lowercase(DemTable.Fields[FieldFileNameNumber].AsString);
      If (ExtractFileExt(s)='') then s:=s+'.bit';
      s:=lowercase(changefileext(s,'.bit'));
        YinS:=DemTable.Fields.Fields[2].AsString;
        XinS:=DemTable.Fields.Fields[3].AsString;
        IsReal:=DemTable.Fields.Fields[5].AsString;
        If i=Min then {This probably IS NOT REAL}
        begin
          XinSTempTOPLEFT:=XinS;
          txin:=Strtoint(XinS);
          tyin:=Strtoint(YinS);
          {txin2:=Strtoint(XinS);}
          tyin2:=Strtoint(YinS);
        end;
        If IsReal='A' then
        begin
          {Check YinS for change.. make new line}
          If (YinSTemp<> YinS)then
          begin
            YinSTemp:= YinS;
            ty:=ty+FileSizeY;
            tyin2:=Strtoint(YinS);
            XinSTemp:= XinS;
            If (XinSTemp= XinSTempTOPLEFT)then tx:=0
            else
            begin
              Xfiles:=abs(abs(strtoint(XinSTempTOPLEFT))- abs(strtoint(XinS)));
              tx:=(Xfiles*FileSizeX);
            end;
          end else
          begin  {any x skipped.. OTHER THAN THE FIRST per ROW!!! ????}
            Xfiles:=abs(abs(strtoint(XinSTempTOPLEFT))- abs(strtoint(XinS)));
            tx:=(Xfiles*FileSizeX);
            txin2:=Strtoint(XinS);
            If txin3<txin2 then txin3:=txin2;
          end;
          MyFilesS:=MyFilesS+'"'
                +s{+'.bit'} +',""'+
                Inttostr(tx)+','+Inttostr(ty)+'"",'+
                IntToStr(FileSizeX+1)+'x'+
                IntToStr(FileSizeY+1)+',""bin 16 (Intel)""",';
        end;{IsReal}
        ProgressBar.Position := i;
        DemTable.Next;
      end;
    end;
    {Remove the last , delimiter}
    Delete(MyFilesS,Length(MyFilesS),1);
    {Length(MyFilesS):=Length(MyFilesS)-1; }
    Writeln(tpcfgfile,MyFilesS);
    CloseFile(tpcfgfile);
    {Read and REwrite the tpcfg file}
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    ReSet(tpcfgfile);{7 strings}
    Readln(tpcfgfile,XinSTemp);
    Readln(tpcfgfile,MyFilesS);
    Readln(tpcfgfile,MyFilesS);

    Readln(tpcfgfile,YinSTemp);
    Readln(tpcfgfile,XinS);
    Readln(tpcfgfile,YinS);
    Readln(tpcfgfile,s);
    CloseFile(tpcfgfile);
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    ReWrite(tpcfgfile);
    Writeln(tpcfgfile,XinSTemp);
    Xfiles:=abs(abs(txin3)- abs(txin));
    tx:=(Xfiles*FileSizeX)+FileSizeX+1;
    MyFilesS:='WorldSizeX='+IntToStr(tx);
    Writeln(tpcfgfile,MyFilesS);
    Xfiles:=abs(abs(tyin2)- abs(tyin));
    ty:=(Xfiles*FileSizeY)+FileSizeY+1;
    MyFilesS:='WorldSizeY='+IntToStr(ty);
    Writeln(tpcfgfile,MyFilesS);
    Writeln(tpcfgfile,YinSTemp);
    Writeln(tpcfgfile,XinS);
    Writeln(tpcfgfile,YinS);
    Writeln(tpcfgfile,s);
    CloseFile(tpcfgfile);
    ProgressBar.Position:=0;
    ProgressBar.Visible:=False;
  end;
  Screen.Cursor:=crDefault;
end;
(***********************************************************)
procedure TdtmDbForm.Make1DegreetpcfgfromAlaskanDb1Click(Sender: TObject);
var
{  Count401,Count601,Count1201,TempWidth,}
  txin3, txin2, tyin2,txin, tyin,Xfiles,i,tx,ty:Integer;
  XinSTemp,YinSTemp,XinS,YinS,s,XinSTempTOPLEFT,
  IsReal,FileString, MyFilesS: string;
  tpcfgfile:textfile;
begin
iF ((MrcStEdit.Visible)and (SelectedField>0)) then
Begin
  {GET correct DEMPATH}
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := 'Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
    FileString:=DbNameLabel.Caption;
      Screen.Cursor:=crHourGlass;
      ProgressBar.Position:=0;
    ProgressBar.Visible:=True;
{  Count401:=0;
  Count601:=0;
  Count1201:=0;}
    YinSTemp:='0';
    txin:=0;
    tyin:=0;
    tyin2:=0;
    txin3:=-200;
    DemTable.Active:=False;
    DemTable.Filter:=DemTable.Fields[SelectedField].FieldName
    {DemTable.Fields[SelectedField].AsString}
                +' = '+MrcStEdit.Text;
{If (MrcStEdit.Text = DemTable.Fields[SelectedField].AsString) then}
    DemTable.Filtered:=True;
    DemTable.Active:=True;
    with ProgressBar do
    begin
      Min := 1;
      Max := DemTable.RecordCount;
      DemTable.First;
      {Get base data}
      s:=lowercase(DemTable.Fields[FieldFileNameNumber].AsString);
      If (ExtractFileExt(s)='') then s:=s+'.bit';
      s:=lowercase(changefileext(s,'.bit'));
    HtfForm.ReadAnyVersionProj(DEMPath+s);
    FileSizeX:={1201;}  Strtoint(HtfForm.XWidthEdit.text)-1;
{     Case FileSizeX of
     401:Begin inc(Count401); TempWidth:=FileSizeX; End;
     601:Begin inc(Count601); TempWidth:=FileSizeX; End;
     1201:Begin inc(Count1201); TempWidth:=FileSizeX; End;
     end;}{Case}
    FileSizeY:={1201;}  Strtoint(HtfForm.YHeightEdit.text)-1;
    {Write tpcfg file ~ .dbf filename}
    FileString:=Copy(FileString,1,Length(FileString)-4)
    +MrcStEdit.Text
    +'.dbf';
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    Rewrite(tpcfgfile);
    {HTFName=F:\HTF\etopo2.htf}
    MyFilesS:='HTFName='+HTFPath{+'\'}+ChangeFileExt(ExtractFileName(FileString),'.htf');
    Writeln(tpcfgfile,MyFilesS);
      {WorldSizeX=10800}
    MyFilesS:='WorldSizeX='+IntToStr(FileSizeX);
    Writeln(tpcfgfile,MyFilesS);
     {WorldSizeY=6336}
    MyFilesS:='WorldSizeY='+IntToStr(FileSizeY);
    Writeln(tpcfgfile,MyFilesS);
      {TileSize=128}
    MyFilesS:='TileSize='+HtfForm.EDTileSize.Text;{IntToStr(128)};
    Writeln(tpcfgfile,MyFilesS);
      {DefaultZ=0}

    MyFilesS:='DefaultZ='+HtfForm.NullValueEdit.Text;{NullDatumValue}
    Writeln(tpcfgfile,MyFilesS);
     {DEMPath=F:\DEM}
    MyFilesS:='DEMPath='+DEMPath;
    Writeln(tpcfgfile,MyFilesS);

    MyFilesS:='DEMs=';
    ty:=-FileSizeY;
      for i := Min to Max do
      begin       {934 dems}
        {Name,ID,LT,LON,IMWS,A}
        Application.ProcessMessages;
        s:=lowercase(DemTable.Fields[FieldFileNameNumber].AsString);
        If (ExtractFileExt(s)='') then s:=s+'.bit';
        s:=lowercase(changefileext(s,'.bit'));
        YinS:=DemTable.Fields.Fields[2].AsString;
        XinS:=DemTable.Fields.Fields[3].AsString;
        IsReal:=DemTable.Fields.Fields[5].AsString;
        If i=Min then {This probably IS NOT REAL}
        begin
          XinSTempTOPLEFT:=XinS;
          txin:=Round(StrtoFloat(XinS));
          tyin:=Round(StrtoFloat(YinS));
          {txin2:=Strtoint(XinS);}
          tyin2:=Round(StrtoFloat(YinS));
        end;
        If IsReal='A' then
        begin
          {Check YinS for change.. make new line}
          If (YinSTemp<> YinS)then
          begin
{    HtfForm.ReadAnyVersionProj(DEMPath+s);
    FileSizeX:=  Strtoint(HtfForm.XWidthEdit.text)-1;
     Case FileSizeX of
     401:Begin inc(Count401); TempWidth:=FileSizeX; End;
     601:Begin inc(Count601); TempWidth:=FileSizeX; End;
     1201:Begin inc(Count1201); TempWidth:=FileSizeX; End;
     end;}{Case}
            YinSTemp:= YinS;
            ty:=ty+FileSizeY;
            tyin2:=Round(StrtoFloat(YinS));
            XinSTemp:= XinS;
            If (XinSTemp= XinSTempTOPLEFT)then tx:=0
            else
            begin
              Xfiles:=abs(abs(Round(StrtoFloat(XinSTempTOPLEFT)))- abs(Round(StrtoFloat(XinS))));
              tx:=(Xfiles*FileSizeX);
            end;
          end else
          begin  {any x skipped.. OTHER THAN THE FIRST per ROW!!! ????}
            Xfiles:=abs(abs(Round(StrtoFloat(XinSTempTOPLEFT)))- abs(Round(StrtoFloat(XinS))));
            tx:=(Xfiles*FileSizeX);
            txin2:=Round(StrtoFloat(XinS));
            If txin3<txin2 then txin3:=txin2;
          end;
          MyFilesS:=MyFilesS+'"'
                +s+',""'+
                Inttostr(tx)+','+Inttostr(ty)+'"",'+
                IntToStr(FileSizeX+1)+'x'+
                IntToStr(FileSizeY+1)+',""bin 16 (Intel)""",';
        end;{IsReal}
        ProgressBar.Position := i;
        DemTable.Next;
      end;
    end;
    {Remove the last , delimiter}
    Delete(MyFilesS,Length(MyFilesS),1);
    {Length(MyFilesS):=Length(MyFilesS)-1; }
    Writeln(tpcfgfile,MyFilesS);
    CloseFile(tpcfgfile);
    {Read and REwrite the tpcfg file}
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    ReSet(tpcfgfile);{7 strings}
    Readln(tpcfgfile,XinSTemp);
    Readln(tpcfgfile,MyFilesS);
    Readln(tpcfgfile,MyFilesS);

    Readln(tpcfgfile,YinSTemp);
    Readln(tpcfgfile,XinS);
    Readln(tpcfgfile,YinS);
    Readln(tpcfgfile,s);
    CloseFile(tpcfgfile);
    AssignFile(tpcfgfile, ProgramPath+ChangeFileExt(ExtractFileName(FileString),'.tpcfg'));
    ReWrite(tpcfgfile);
    Writeln(tpcfgfile,XinSTemp);
    Xfiles:=abs(abs(txin3)- abs(txin));
    {REDO this iaw Counts}
     {Case FileSizeX of
     401:Begin inc(Count401); TempWidth:=FileSizeX; End;
     601:Begin inc(Count601); TempWidth:=FileSizeX; End;
     1201:Begin inc(Count1201); TempWidth:=FileSizeX; End;
     end;}
    tx:=(Xfiles*FileSizeX)+FileSizeX+1;
    MyFilesS:='WorldSizeX='+IntToStr(tx);
    Writeln(tpcfgfile,MyFilesS);
    Xfiles:=abs(abs(tyin2)- abs(tyin));
    ty:=(Xfiles*FileSizeY)+FileSizeY+1;
    MyFilesS:='WorldSizeY='+IntToStr(ty);
    Writeln(tpcfgfile,MyFilesS);
    Writeln(tpcfgfile,YinSTemp);
    Writeln(tpcfgfile,XinS);
    Writeln(tpcfgfile,YinS);
    Writeln(tpcfgfile,s);
    CloseFile(tpcfgfile);
    ProgressBar.Position:=0;
    ProgressBar.Visible:=False;
  end;
  Screen.Cursor:=crDefault;
End;  
end;
(***********************************************************)

(*
procedure TdtmDbForm.Make1NullValueDemfromDb1Click(Sender: TObject);
var
  WhoAmI:Byte;
  cWhoAmI:Char;
  iSinData, ProjData:SmallInt;
  {Xfiles,i,}
  NumRead,  typein,Xin,Yin,
  txin, tyin,tx,ty:Integer;
  dSinData:Double;
  XinS,YinS,s,
{ MyFilesS, XinSTempTOPLEFT,XinSTemp,YinSTemp,}
  WhereString, FileString: string;
  outfile:File;
begin
  {GET correct DEMPATH}
  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter := 'Dem bit files (*.bit)|*.bit';
  if OpenDialog1.Execute then
  begin
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
    Screen.Cursor:=crHourGlass;
    ProgressBar.Position:=0;
    ProgressBar.Visible:=True;
    HtfForm.SetDefaultDEMProj;
    FileSizeX:=1201;
    FileSizeY:=1201;
    {  txin:=0;  ty:=-1200; }
    DemTable.First;
    s:=DemTable.Fields[FieldFileNameNumber].AsString;
    YinS:=DemTable.Fields.Fields[2].AsString;
    XinS:=DemTable.Fields.Fields[3].AsString;
    Xin:=strtoint(XinS);
    Yin:=strtoint(YinS);
    HtfForm.TopRightXEdit.Text:=FloattoStr(Xin);
    HtfForm.BottomRightXEdit.Text:=FloattoStr(Xin);
        HtfForm.TopLeftXEdit.Text:=FloattoStr(Xin-1);
        HtfForm.BottomLeftXEdit.Text:=FloattoStr(Xin-1);
        HtfForm.BottomLeftYEdit.Text:=FloattoStr(Yin);
        HtfForm.BottomRightYEdit.Text:=FloattoStr(Yin);
        HtfForm.TopLeftYEdit.Text:=FloattoStr(Yin+1);
        HtfForm.TopRightYEdit.Text:=FloattoStr(Yin+1);
    Application.ProcessMessages;
    FileString:= DemPath+s+'.bit';
    AssignFile(outfile,FileString);
    Rewrite(outfile,1);
      { (2*1=2) +4 + (3*4=12) +8 + (11 * 2 = 22) + (26 * 8 = 208) = 256}
    WhoAmI :=3;{ 30AS=250k DEM}
    Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
    WhoAmI :=1;{  Version = 1}
    Blockwrite(outfile,WhoAmI , Sizeof(WhoAmI), NumRead);
        {Compute from Lower Right Coordinate.. someday}
    ProjData:= StrToInt(XinS{HtfForm.SEXEWEdit.Text});
    Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:= StrToInt(YinS{HtfForm.SEYNSEdit.Text});
    Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    txin:=FileSizeX; {1201;}{250k DEM Width}
    Blockwrite(outfile,txin , Sizeof(txin), NumRead);
    tyin:=FileSizeY;{1201;}{250k DEM Height}
    Blockwrite(outfile,tyin , Sizeof(tyin), NumRead);
    typein:=1;  {1=Integer, 0=Float}
      {If (dCellSizeZ < 0) then bZisInteger :=False;}
    Blockwrite(outfile,typein , Sizeof(typein), NumRead);
      {WhereString is 4x6 Cell locator=8 Chars}
    WhereString:=DemTable.Fields.Fields[4].AsString;;

    For ProjData:=1 to 8 do
    begin
      cWhoAmI:=WhereString[ProjData];
      Blockwrite(outfile,cWhoAmI , Sizeof(cWhoAmI), NumRead);
    end;
    If HtfForm.ValidProjectionCB.Checked then
       ProjData:=1 else ProjData:=0;
    Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:={2=Meters} HtfForm.MapZUnitsCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=3;{SE corner PixelCoordinateCB.Itemindex;}
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=StrtoInt(HtfForm.NullValueEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=HtfForm.ProjectionCB.Itemindex; {0=Geo}
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=HtfForm.InUnitCB.Itemindex; {3=Seconds of arc}
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=HtfForm.InUtmZoneCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    If HtfForm.UTMZoneNorthCB.Checked then
       ProjData:=1 else ProjData:=0;
    Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=StrtoInt(HtfForm.StatePlaneZoneEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=HtfForm.InDatumCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
    ProjData:=HtfForm.SpheroidCB.Itemindex;
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);

    dSinData:=StrtoFloat(HtfForm.PixelXSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.PixelYSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.ZSizeEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

    dSinData:=StrtoFloat(HtfForm.TopLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.TopLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.TopRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.TopRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.BottomLeftXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.BottomLeftYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.BottomRightXEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.BottomRightYEdit.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);

    dSinData:=StrtoFloat(HtfForm.DLGPA1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPA2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPA3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPB1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPB2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPB3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPC1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPC2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPC3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPD1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPD2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPD3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPE1.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPE2.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
    dSinData:=StrtoFloat(HtfForm.DLGPE3.Text);
      Blockwrite(outfile,dSinData , Sizeof(dSinData), NumRead);
            iSinData :=-32767;
      for ty:=0 to FileSizeY-1do
      begin   {Count down}
        ProgressBar.Position:=
           Round(((ty)/FileSizeY)*100);
        Application.ProcessMessages;
        for tx:=0 to FileSizeX-1 do
        begin
            Blockwrite(outfile,iSinData , Sizeof(iSinData), NumRead)
        end;
      end;
      CloseFile(outfile);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  end;
  Screen.Cursor:=crDefault;
end;
*)



(***********************************************************)

(***********************************************************)
{Path Row: Use spinner to set Amount of Column 1 (path)
thus divide Ascii file into 'regions' : NA, SA, Africe,Asia,Europe}

procedure TdtmDbForm.ToggleSpinnerdisplay1Click(Sender: TObject);
begin
  If PathMinSpinner.Visible=false then
  begin
  PathMinSpinner.Visible:=True;
  PathMaxSpinner.Visible:=True;
  RowMinSpinner.Visible:=True;
  RowMaxSpinner.Visible:=True;
  ToggleSpinnerdisplay1.Checked :=True;
  end else
  begin
  ToggleSpinnerdisplay1.Checked :=false;
  PathMinSpinner.Visible:=false;
  PathMaxSpinner.Visible:=false;
  RowMinSpinner.Visible:=false;
  RowMaxSpinner.Visible:=false;
  end
end;

procedure TdtmDbForm.PathperspinDbshp1Click(Sender: TObject);
begin
  Memo1.Lines.Add('PathMinSpinner'+Inttostr(PathMinSpinner.Value));
  Memo1.Lines.Add('PathMaxSpinner'+Inttostr(PathMaxSpinner.Value));
  AsciiDbDo(PathMaxSpinner.Value,PathMinSpinner.Value,
  RowMaxSpinner.Value,RowMinSpinner.Value);
end;

procedure TdtmDbForm.PathRoworPathRowCentroid1Click(Sender: TObject);
begin
  PathRoworPathRowCentroid:= (not PathRoworPathRowCentroid);
  PathRoworPathRowCentroid1.Checked :=PathRoworPathRowCentroid;
end;

procedure TdtmDbForm.Ascii1234561Click(Sender: TObject);
begin
  AsciiDbDo(333,-1,333,-1);
end;

procedure TdtmDbForm.AsciiDbDo(PathMax,PathMin,RowMax,RowMin:Integer);
var
  ShapeType, PointCount, IslandCount,
  NumParts, NumPoints,   ShapeNumber: integer;
Row,Path:Integer;
Laty,Lonx:Double;
  TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
  BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,
  Xin,Yin, dXMINt2, dYMINt2, dXMAXt2, dYMAXt2,
  dXMINt, dYMINt, dXMAXt, dYMAXt:Double;
  FileString,XinS,YinS,s,InFileName,DBFileName: string;
  InFile:TextFile;
begin
  OpenDialog1.InitialDir:=VRMDatabase;
  OpenDialog1.Filter := 'Dbf files (*.dbf)|*.dbf';
  OpenDialog1.Filename:='pathrow.dbf';
  if OpenDialog1.Execute then
  begin
    DBFileName:=OpenDialog1.FileName;
    DemTable.TableName:=DBFileName;
    VRMDatabase:=ExtractFilePath(DBFileName);

    OpenDialog1.Filter := 'Ascii files (*.txt)|*.txt';
    if OpenDialog1.Execute then
    begin{  InFile}
      InFileName:=OpenDialog1.FileName;
      Screen.Cursor:=crHourGlass;

  {Make a database table}
    DBFileName:=ChangeFileExt(OpenDialog1.FileName,'.dbf');
    DbNameLabel.Caption:=DBFileName;
    VRMDatabase:=ExtractFilePath(DBFileName);
    FilePathLabel.Caption:=DBFileName;

  {dbTable:=TTable.Create(dtmDbForm); }
  with Dbf1 do
  begin
    Active:=False;
    {DatabaseName:= DemTable.DatabaseName;
    TableType := ttDBase; }
    TableName:=DBFileName;
    with FieldDefs do
    begin
      Clear;
        with AddFieldDef do
        begin
          FieldNo:=1;
          Name := 'PATH';
          DataType := ftString;
          Size:=4 ;
          Precision:=4;
          Required:=False;
          FieldNo:=2;
          Name := 'ROW';
          DataType := ftString;
          Size:=4 ;
          Precision:=4;
          Required:=False;
  If PathRoworPathRowCentroid then
  begin   {ftFloat	}
            FieldNo:=3;
          Name := 'LATY';
          DataType := ftFloat;
          Size:=4 ;
          Precision:=4;
          Required:=False;
            FieldNo:=4;
          Name := 'LONX';
          DataType := ftFloat;
          Size:=4 ;
          Precision:=4;
          Required:=False;
          end;
        end;
    End;{FieldDefs}
   CreateTable;
   Dbf1.Active := True;
  end;

      AssignFile(InFile,InFileName);
      Reset(InFile);
      Inc(LayersLoaded);
      CurrentLayer:=LayersLoaded;
      SetLength(LayA,LayersLoaded+1);{Trash the Zero layer in array}
      SetLength(LayersControlArray,LayersLoaded);
      LayersControlArray[LayersLoaded-1]:= LayersLoaded;
      dXMINt:=510324;
      dYMINt:=510324;
      dXMAXt:=-510324;
      dYMAXt:=-510324;
      dXMINt2:=510324;
      dYMINt2:=510324;
      dXMAXt2:=-510324;
      dYMAXt2:=-510324;
      PointCount := 0;
      IslandCount := 0;
      {AreaCount := 0; }
      ShapeNumber :=0;
      {    NumShape:=0;}
      LayA[CurrentLayer].Modified:=False;
      LayA[CurrentLayer].LayerN:=CurrentLayer;
      ShapeType:=5;{Polygon}
      LayA[CurrentLayer].ShpType:=ShapeType;
      LayA[CurrentLayer].Modified:=False;
      LayA[CurrentLayer].LayerDBName:=ExtractFileName(DBFileName);
      LayA[CurrentLayer].LayerDBPath:=ExtractFilePath(DBFileName);
      FileString:=ChangeFileExt(DBFileName,'.shp');
      LayA[CurrentLayer].Filename:=ExtractFileName(FileString);
      LayA[CurrentLayer].Path:=ExtractFilePath(FileString);
      Readln(InFile,s);        {4 header lines}
      Readln(InFile,s);
      Readln(InFile,s);
      Readln(InFile,s);
      begin
        While (not EOF(InFile)) do
        begin
        Application.ProcessMessages;
          Readln(InFile,s);
          XinS:=Copy(s,1,4);
          YinS:=Copy(s,5,5);
          Xin:=StrtoFloat(trim(XinS));
          Yin:=StrtoFloat(trim(YinS));
          { Memo1.Lines.Add(YinS);
          Memo1.Lines.Add(XinS);}
If ((Xin < PathMax)and(Xin>PathMin)and
     (Yin < RowMax)and(Yin>RowMin)) then
begin
  If PathRoworPathRowCentroid then
  begin
    Path:=Round(Xin);
    Row:=Round(Yin);
    HtfForm.DoPRConversion(Path,Row,Laty,Lonx);
    Dbf1.AppendRecord([trim(XinS),
                           trim(YinS),
                           Laty,Lonx
                           ])
  end  else  Dbf1.AppendRecord([trim(XinS),
                                 trim(YinS)]);
          {DemTable.Append;
          DemTable.FieldValues['PATH'] := trim(Copy(s,1,4));
          DemTable.FieldValues['ROW'] := trim(Copy(s,5,5));
          DemTable.Post;  }
          FieldLabel.caption:=Copy(s,1,10);
          {Memo1.Lines.Add(Copy(s,1,10));}
          Application.ProcessMessages;
              {Copy(S; Index, Count: Integer)}
          XinS:=Copy(s,10,18);
          YinS:=Copy(s,28,13);
          Xin:=StrtoFloat(trim(XinS));
          Yin:=StrtoFloat(trim(YinS));
          TopLeftXEdit:=(Xin);
          TopLeftYEdit:=(Yin);
          if Xin<dXMINt then dXMINt := Xin;
          if Yin<dYMINt then dYMINt := Yin;
          if Xin>dXMAXt then dXMAXt := Xin;
          if Yin>dYMAXt then dYMAXt := Yin;
          XinS:=Copy(s,41,14);
          YinS:=Copy(s,55,13);
          Xin:=StrtoFloat(trim(XinS));
          Yin:=StrtoFloat(trim(YinS));
          {Memo1.Lines.Add(YinS);
          Memo1.Lines.Add(XinS);}
          TopRightXEdit:=(Xin);
          TopRightYEdit:=(Yin);
          if Xin<dXMINt then dXMINt := Xin;
          if Yin<dYMINt then dYMINt := Yin;
          if Xin>dXMAXt then dXMAXt := Xin;
          if Yin>dYMAXt then dYMAXt := Yin;
          XinS:=Copy(s,68,14);
          YinS:=Copy(s,82,13);
          Xin:=StrtoFloat(trim(XinS));
          Yin:=StrtoFloat(trim(YinS));
          {Memo1.Lines.Add(YinS);
          Memo1.Lines.Add(XinS);}
          BottomRightXEdit:=(Xin);
          BottomRightYEdit:=(Yin);
          if Xin<dXMINt then dXMINt := Xin;
          if Yin<dYMINt then dYMINt := Yin;
          if Xin>dXMAXt then dXMAXt := Xin;
          if Yin>dYMAXt then dYMAXt := Yin;
          XinS:=Copy(s,95,14);
          YinS:=Copy(s,109,13);
          Xin:=StrtoFloat(trim(XinS));
          Yin:=StrtoFloat(trim(YinS));
          {Memo1.Lines.Add(YinS);
          Memo1.Lines.Add(XinS);}
          BottomLeftXEdit:=(Xin);
          BottomLeftYEdit:=(Yin);
          if Xin<dXMINt then dXMINt := Xin;
          if Yin<dYMINt then dYMINt := Yin;
          if Xin>dXMAXt then dXMAXt := Xin;
          if Yin>dYMAXt then dYMAXt := Yin;
          inc(ShapeNumber);
          {NumShape:=SwapShapeInteger(ICOIn);}{Store total for later}
          Setlength(LayA[CurrentLayer].LyrShp,ShapeNumber+1);
          LayA[CurrentLayer].LyrShp[ShapeNumber].ShpType:=ShapeType;
          LayA[CurrentLayer].LyrShp[ShapeNumber].ShapeIDN:=ShapeNumber;
          Numparts:=1;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PartsN:=Numparts;
          SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PPA,Numparts+1);
          SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA,Numparts+1);
          NumPoints:=5;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PntsN:=NumPoints;
          PointCount:=PointCount+NumPoints;{Total points for File}
          LayA[CurrentLayer].LyrShp[ShapeNumber].PPA[Numparts]:={0;}NumPoints;{((NumPoints-BufI)+1);}{BufI;}
          SetLength(LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[Numparts].PA,NumPoints+1);

          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{ointNumber}].Xd:=TopRightXEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[1{PointNumber}].Yd:=TopRightYEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Xd:=BottomRightXEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[2{PointNumber}].Yd:=BottomRightYEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Xd:=BottomLeftXEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[3{PointNumber}].Yd:=BottomLeftYEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Xd:=TopLeftXEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[4{PointNumber}].Yd:=TopLeftYEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Xd:=TopRightXEdit;
          LayA[CurrentLayer].LyrShp[ShapeNumber].PARA[1{PartNumber}].PA[5{PointNumber}].Yd:=TopRightYEdit;

          if dXMINt2<dXMINt then dXMINt2 := dXMINt;
          if dYMINt2<dYMINt then dYMINt2 := dYMINt;
          if dXMAXt2>dXMAXt then dXMAXt2 := dXMAXt;
          if dYMAXt2>dYMAXt then dYMAXt2 := dYMAXt;
          LayA[CurrentLayer].LyrShp[ShapeNumber].XMin:= dXMINt;
          LayA[CurrentLayer].LyrShp[ShapeNumber].YMin:= dYMINt;
          LayA[CurrentLayer].LyrShp[ShapeNumber].XMax:= dXMAXt;
          LayA[CurrentLayer].LyrShp[ShapeNumber].YMax:= dYMAXt;
          {TopRightXEdit,BottomRightXEdit,TopLeftXEdit,BottomLeftXEdit,
           BottomLeftYEdit,BottomRightYEdit,TopLeftYEdit,TopRightYEdit,}
end;
        end;
      end;
      LayA[CurrentLayer].LayerColor:=
      RGB(Random(255),Random(255),Random(255));
      LayA[CurrentLayer].ShapeN:=ShapeNumber;{NumShape;}
      LayA[CurrentLayer].TotalPnts:=PointCount;
      LayA[CurrentLayer].IslandsN:=IslandCount;
      LayA[CurrentLayer].XMin:= dXMINt2;
      LayA[CurrentLayer].YMin:= dYMINt2;
      LayA[CurrentLayer].XMax:= dXMAXt2;
      LayA[CurrentLayer].YMax:= dYMAXt2;
      LayA[CurrentLayer].ZMin:= 0;
      LayA[CurrentLayer].ZMax:= 0;
      LayA[CurrentLayer].MMin:= 0;
      LayA[CurrentLayer].MMax:= 0;
      if dXMINt2 < 0 then
        LayA[CurrentLayer].OffsetX := abs(dXMINt2)
      else if dXMINt2 > 0 then
        LayA[CurrentLayer].OffsetX  := (0 - dXMINt2)
      else LayA[CurrentLayer].OffsetX  := 0;
      if dYMINt2 < 0 then
        LayA[CurrentLayer].OffsetY := abs(dYMINt2)
      else if dYMINt2 > 0 then
        LayA[CurrentLayer].OffsetY := (0 - dYMINt2)
      else LayA[CurrentLayer].OffsetY := 0;

      If abs(LayA[CurrentLayer].OffsetX) > abs(MaxOffsetX) then
       MaxOffsetX:= LayA[CurrentLayer].OffsetX;
      If abs(LayA[CurrentLayer].OffsetY) > abs(MaxOffsetY) then
       MaxOffsetY:= LayA[CurrentLayer].OffsetY;
      If CurrentLayer =1 then
      Begin
        MinOffX:=LayA[CurrentLayer].XMin;
        MinOffY:=LayA[CurrentLayer].YMin;
        MaxOffX:=LayA[CurrentLayer].XMax;
        MaxOffY:=LayA[CurrentLayer].YMax;
      End;
      CloseFile(InFile);
      {Write the shape file}
      SaveShpFile(CurrentLayer,FileString);

    end;
  end;
      {Toss the shapefile.. reload to view}
  Dbf1.Active:=False;
  Dbf1.Free;{ finally, delete the table }
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);
  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;

(***********************************************************)

(***********************************************************)

procedure TdtmDbForm.SelectedStatefromdatabase1Click(Sender: TObject);
begin
   If SelectedStatefromdatabase1.Checked then
   SelectedStatefromdatabase1.Checked:=False else
   SelectedStatefromdatabase1.Checked:=True;
{MrcStEdit}
    iF SelectedStatefromdatabase1.Checked THEN
    BEGIN
      {MrcStEdit.Enabled:=DemTable.Active;}
      MrcStEdit.Visible:=DemTable.Active;
    END ELSE
    BEGIN
      {MrcStEdit.Enabled:=False;}
      MrcStEdit.Visible:=False;
    END;
end;

procedure TdtmDbForm.AsciiListto250DBClick(Sender: TObject);
var
 i:Integer;
DbFileName,TextFileName, S : string;
 F: TextFile;
begin
If DemTable.Active then
begin
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[LayersLoaded-1]:= LayersLoaded;
  LayA[CurrentLayer].AttributesN:=DemTable.FieldDefs.Count;
  SetLength(LayA[CurrentLayer].AttType,
            LayA[CurrentLayer].AttributesN);
  for i:= 0 to DemTable.FieldDefs.Count - 1 do
  begin
    LayA[CurrentLayer].AttType[i].FieldNo:=
        DemTable.FieldDefs[i].FieldNo;
    LayA[CurrentLayer].AttType[i].Displayname:=
        DemTable.FieldDefs[i].Name;
    LayA[CurrentLayer].AttType[i].DataType:=
        DemTable.FieldDefs[i].DataType;
    LayA[CurrentLayer].AttType[i].Size:=
        DemTable.FieldDefs[i].Size;
    LayA[CurrentLayer].AttType[i].Precision:=
        DemTable.FieldDefs[i].Precision;
    LayA[CurrentLayer].AttType[i].Required:=
        DemTable.FieldDefs[i].Required;
  end;

  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter:= 'DEM files list (*.txt)|*.txt';
  OpenDialog1.Filename:= '_graflist.txt';{graflist.txt}
  if OpenDialog1.Execute then
  begin
  {Make TextFileName}
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
    TextFileName:=OpenDialog1.FileName;
  SaveDialog1.InitialDir:=VRMDatabase;
  SaveDialog1.Filter := 'Dbf files (*.dbf)|*.dbf';
  SaveDialog1.FileName:=OpenDialog1.FileName;
  if SaveDialog1.Execute then
  begin
  If (SaveDialog1.FileName=OpenDialog1.FileName) then exit;
    DbFileName:=SaveDialog1.FileName;
    {Make a database table}
    {dbTable:=TTable.Create(dtmDbForm);}
    with Dbf1 do
    begin
      Active:=False;
      {DatabaseName:= DemTable.DatabaseName;
      TableType := ttDBase;}
      TableName:=ChangeFileExt(ExtractFileName(DbFileName),'.dbf');
      with FieldDefs do
      begin
        Clear;    {i:= 0;}
        for i:= 0 to LayA[CurrentLayer].AttributesN - 1 do
        begin
          with AddFieldDef do
          begin
            FieldNo:=LayA[CurrentLayer].AttType[i].FieldNo;
            Name := LayA[CurrentLayer].AttType[i].Displayname;
            DataType := LayA[CurrentLayer].AttType[i].DataType;
            Size:=LayA[CurrentLayer].AttType[i].Size ;
            Precision:=LayA[CurrentLayer].AttType[i].Precision;
            Required:=LayA[CurrentLayer].AttType[i].Required;
          end;
        end;
      End;{FieldDefs}
     CreateTable;
     Dbf1.Active := True;
    end;
    AssignFile(F, TextFileName);
    Reset(F);
    Dbf1.First;
    Try
    While (not eof(F)) do
    begin
      Readln(F, S);
      S:=ExtractFileName(S);
      FieldLabel.Caption:=S;
      Application.ProcessMessages;
      {Fill the Shape data into arrays}
      {SelectedField  StareThereString}
      {250k: Name,ID,LT,LON,IMWS,A}
      {24k: Name State Lat Long MRC}
{24k has State      If SelectedStatefromdatabase1.Checked then
      dbTable.AppendRecord([S,MrcStEdit.Text]) else}
      Dbf1.AppendRecord([S]);
    {250K
    Name,ID,LT,LON,IMWS,A}
                      { DemTable.FieldValues['Name'],
                       DemTable.FieldValues['State'],
                       DemTable.FieldValues['Lat'],
                       DemTable.FieldValues['Long'],
                       DemTable.FieldValues['MRC']]);}
    end;
    Finally
    CloseFile(F);
    end;
  end;
  Dbf1.Active:=False;
  Dbf1.TableName:='';
    DemTable.Active:=False;
    DemTable.TableName:='';
    DbNameLabel.Caption:='';
    FieldFileNameNumber:=0;
    DisplayNavigator1.Enabled:=False;
    ProcessDb1.Enabled:=False;
    ListProcessorMenu.Enabled:=False;
    Db250kbins1.Enabled:=True;
      DBNavigator1.Enabled:=DemTable.Active;
      DBNavigator1.Visible:=DemTable.Active;
    FieldLabel.Caption:='';
      {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;end;
end;

procedure TdtmDbForm.AsciiListto24KDBClick(Sender: TObject);
var
 i:Integer;
  DbFileName, TextFileName, S : string;
 F: TextFile;
begin
If DemTable.Active then
begin
  Inc(LayersLoaded);
  CurrentLayer:=LayersLoaded;
  SetLength(LayA,LayersLoaded+1);
  SetLength(LayersControlArray,LayersLoaded);
  LayersControlArray[LayersLoaded-1]:= LayersLoaded;
  LayA[CurrentLayer].AttributesN:=DemTable.FieldDefs.Count;
  SetLength(LayA[CurrentLayer].AttType,
            LayA[CurrentLayer].AttributesN);
  for i:= 0 to DemTable.FieldDefs.Count - 1 do
  begin
    LayA[CurrentLayer].AttType[i].FieldNo:=
        DemTable.FieldDefs[i].FieldNo;
    LayA[CurrentLayer].AttType[i].Displayname:=
        DemTable.FieldDefs[i].Name;
    LayA[CurrentLayer].AttType[i].DataType:=
        DemTable.FieldDefs[i].DataType;
    LayA[CurrentLayer].AttType[i].Size:=
        DemTable.FieldDefs[i].Size;
    LayA[CurrentLayer].AttType[i].Precision:=
        DemTable.FieldDefs[i].Precision;
    LayA[CurrentLayer].AttType[i].Required:=
        DemTable.FieldDefs[i].Required;
  end;

  OpenDialog1.InitialDir:=DemPath;
  OpenDialog1.Filter:= 'DEM files list (*.txt)|*.txt';
  OpenDialog1.Filename:= '_graflist.txt';{graflist.txt}
  if OpenDialog1.Execute then
  begin
  {Make TextFileName}
    DemPath:=ExtractFilePath(OpenDialog1.FileName);
    FilePathLabel.Caption:=DemPath;
    TextFileName:=OpenDialog1.FileName;
  SaveDialog1.InitialDir:=VRMDatabase;
  SaveDialog1.Filter := 'Dbf files (*.dbf)|*.dbf';
  SaveDialog1.FileName:=OpenDialog1.FileName;
  if SaveDialog1.Execute then
  begin
  If (SaveDialog1.FileName=OpenDialog1.FileName) then exit;
    DbFileName:=SaveDialog1.FileName;
    {Make a database table}
    {dbTable:=TTable.Create(dtmDbForm);}
    with Dbf1 do
    begin
      Active:=False;
      {DatabaseName:= DemTable.DatabaseName;
      TableType := ttDBase;}
      TableName:=ChangeFileExt(ExtractFileName(DbFileName),'.dbf');
      with FieldDefs do
      begin
        Clear;    {i:= 0;}
        for i:= 0 to LayA[CurrentLayer].AttributesN - 1 do
        begin
          with AddFieldDef do
          begin
            FieldNo:=LayA[CurrentLayer].AttType[i].FieldNo;
            Name := LayA[CurrentLayer].AttType[i].Displayname;
            DataType := LayA[CurrentLayer].AttType[i].DataType;
            Size:=LayA[CurrentLayer].AttType[i].Size ;
            Precision:=LayA[CurrentLayer].AttType[i].Precision;
            Required:=LayA[CurrentLayer].AttType[i].Required;
          end;
        end;
      End;{FieldDefs}
     CreateTable;
     Dbf1.Active := True;
    end;
    AssignFile(F, TextFileName);
    Reset(F);
    Dbf1.First;
    Try
    While (not eof(F)) do
    begin
      Readln(F, S);
      S:=ExtractFileName(S);
      FieldLabel.Caption:=S;
      Application.ProcessMessages;      
      {Fill the Shape data into arrays}
      {SelectedField  StareThereString}
      {Name,ID,LT,LON,IMWS,A}
      {Name State Lat Long MRC}
      {24k has State }
      If SelectedStatefromdatabase1.Checked then
         Dbf1.AppendRecord([S,MrcStEdit.Text]) else
         Dbf1.AppendRecord([S]);
    end;
    Finally
    CloseFile(F);
    end;
  end;
  Dbf1.Active:=False;
  Dbf1.TableName:='';
    DemTable.Active:=False;
    DemTable.TableName:='';
    DbNameLabel.Caption:='';
    FieldFileNameNumber:=0;
    DisplayNavigator1.Enabled:=False;
    ProcessDb1.Enabled:=False;
    ListProcessorMenu.Enabled:=False;
    Db250kbins1.Enabled:=True;
      DBNavigator1.Enabled:=DemTable.Active;
      DBNavigator1.Visible:=DemTable.Active;
    FieldLabel.Caption:='';
      {Toss the shapefile.. reload to view}
  LayersLoaded:=0;
  SetLength(ManMatrix,0,0);
  SetLength(LayA,0);  {  SetLength(MapA,0);}
  SetLength(LayersControlArray,0);
  SetLength(ShapesFoundArray,0);
  ProgressBar.Position:=0;
  ProgressBar.Visible:=False;
  Screen.Cursor:=crDefault;
end;     end;
end;

(***********************************************************)

(***********************************************************)



(***********************************************************)
    {SHAPE FUNCTIONS}
(***********************************************************)
procedure TdtmDbForm.OpenShapeDb1Click(Sender: TObject);
begin
  OpenDialog1.InitialDir:=ShapePath;
  OpenDialog1.Filter := 'Shape files (*.shp)|*.shp';
  if OpenDialog1.Execute then
  begin
  SaveDialog1.InitialDir:=ShapePath;
  SaveDialog1.Filter := 'Shape files (*.shp)|*.shp';
  if SaveDialog1.Execute then
  begin
    FilePathLabel.Caption:=SaveDialog1.FileName;
    DbNameLabel.Caption:=OpenDialog1.FileName;
    SplitshpIAWDb1.Enabled:=True;

    DemTable.TableName:=OpenDialog1.FileName;
    DbNameLabel.Caption:=OpenDialog1.FileName;
    ShapePath:=ExtractFilePath(OpenDialog1.FileName);
    DemTable.Active:=True;
    DemTable.First;
    FieldLabel.Caption:=DemTable.Fields[0].AsString;
    SpinEdit1.MaxValue:=DemTable.FieldCount;
    FieldFileNameNumber:=0;
    Memo1.Clear;
    Memo1.Lines.Add('Select a Field and Row');
  end;
  end;
end;

{Allow Dividing complete Shape file into
Filename_Itemname.shp
REQUIRES many passes and a LIST of Objects ALREADY processed}

{Combine Shape files
Max Extents
Just read 1&2 then Save Shp and DB}
procedure TdtmDbForm.SplitshpIAWDb1Click(Sender: TObject);
begin
    DemTable.First;
    DisplayNavigator1.Enabled:=True;

{Split a shape file IAW Db selection of
a Field (column) and a field-TYPE data parameter

Select a Shape file & (ONLY) Load its DB
Choose NEW filename
From loaded DB Select a Field and Row (data type)

Incoming Shape filename (& DB Filename extension .dbf)
    DbNameLabel.Caption
Outgoing Shape filename (& DB Filename extension .dbf)
    FilePathLabel.Caption
Make a new DB file from ?CURRENT? DB field data

  SelectedField:= DBGrid1.SelectedIndex;
  Memo1.Lines.Add('State Lat Long MRC : '+Inttostr(SelectedField));
  StareThereString:= DemTable.Fields.Fields[SelectedField].AsString;


Traverse DB:
  If Selected = This then
     Add to Shape & Add field data

Result is a New Shape file collated with a New (REDUCED) DB file }
end;

procedure TdtmDbForm.SquashShapeIAWDbselection1Click(Sender: TObject);
begin
{Reduce Points, Lines, or Areas to JUST the Objects per selection
instead of 50,000 areas it becomes 50 areas with ALL Db + shape items
This trashes the database !}
end;
(***********************************************************)
    {SHAPE FUNCTIONS}
(***********************************************************)



(***********************************************************)

(***********************************************************)
procedure TdtmDbForm.FipsCodeCBClick(Sender: TObject);
var FipsCode:Integer;
begin
Case FipsCodeCB.ItemIndex of
0:FipsCode:=01 ;{: Alabama';}
1:FipsCode:=02 ;{: Alaska';}
2:FipsCode:=04 ;{: Arizona';}
3:FipsCode:=05 ;{: Arkansas';}
4:FipsCode:=06 ;{: California';}
5:FipsCode:=08 ;{: Colorado';}
6:FipsCode:=09 ;{: Connecticut';}
7:FipsCode:=10 ;{: Delaware';}
8:FipsCode:=11 ;{: District of Columbia';}
9:FipsCode:=12 ;{: Florida';}
10:FipsCode:=13 ;{: Georgia';}
11:FipsCode:=15 ;{: Hawaii';}
12:FipsCode:=16 ;{: Idaho';}
13:FipsCode:=17 ;{: Illinois';}
14:FipsCode:=18 ;{: Indiana';}
15:FipsCode:=19 ;{: Iowa';}
16:FipsCode:=20 ;{: Kansas';}
17:FipsCode:=21 ;{: Kentucky';}
18:FipsCode:=22 ;{: Louisiana';}
19:FipsCode:=23 ;{: Maine';}
20:FipsCode:=24 ;{: Maryland';}
21:FipsCode:=25 ;{: Massachusetts';}
22:FipsCode:=26 ;{: Michigan';}
23:FipsCode:=27 ;{: Minnesota';}
24:FipsCode:=28 ;{: Mississippi';}
25:FipsCode:=29 ;{: Missouri';}
26:FipsCode:=30 ;{: Montana';}
27:FipsCode:=31 ;{: Nebraska';}
28:FipsCode:=32 ;{: Nevada';}
29:FipsCode:=33 ;{: New Hampshire';}
30:FipsCode:=34 ;{: New Jersey';}
31:FipsCode:=35 ;{: New Mexico';}
32:FipsCode:=36 ;{: New York';}
33:FipsCode:=37 ;{: North Carolina';}
34:FipsCode:=38 ;{: North Dakota';}
35:FipsCode:=39 ;{: Ohio';}
36:FipsCode:=40 ;{: Oklahoma';}
37:FipsCode:=41 ;{: Oregon';}
38:FipsCode:=42 ;{: Pennsylvania';}
39:FipsCode:=44 ;{: RhodeIsland';}
40:FipsCode:=45 ;{: South Carolina';}
41:FipsCode:=46 ;{: South Dakota';}
42:FipsCode:=47 ;{: Tennessee';}
43:FipsCode:=48 ;{: Texas';}
44:FipsCode:=49 ;{: Utah';}
45:FipsCode:=50 ;{: Vermont';}
46:FipsCode:=51 ;{: Virginia';}
47:FipsCode:=53 ;{: Washington';}
48:FipsCode:=54 ;{: West Virginia';}
49:FipsCode:=55 ;{: Wisconsin';}
50:FipsCode:=56 ;{: Wyoming';}
51:FipsCode:=60 ;{: American Samoa';}
52:FipsCode:=66 ;{: Guam';}
53:FipsCode:=69 ;{: Northern Mariana Islands';}
54:FipsCode:=70 ;{: Palau';}
55:FipsCode:=72 ;{: Puerto Rico';}
56:FipsCode:=78 ;{: Virgin Islands (US)';}
else FipsCode:=0;
end;
If FipsCode < 0 then;{Shut up compiler}
end;


















procedure TdtmDbForm.About1Click(Sender: TObject);
begin
    dtmDbAboutForm:=TdtmDbAboutForm.Create(Application);
    dtmDbAboutForm.Showmodal;
    dtmDbAboutForm.Release;
end;

end.

