{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit dtmDTPFrm;
{by Ivan Lee Herring, 2002}
interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls, ExtDlgs,
  GR32, {GR32_Layers,}GR32_Polygons, GR32_Image;

type
  TdtmDTPForm = class(TForm)
    ColorDialog1: TColorDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox3: TGroupBox;
    SetHTFBtn: TSpeedButton;
    HTFYLabel: TLabel;
    HTFXLabel: TLabel;
    XLabel: TLabel;
    X2Label: TLabel;
    HTFXEdit: TEdit;
    HTFYEdit: TEdit;
    GroupBox1: TGroupBox;
    XUpBtn: TSpeedButton;
    XDownBtn: TSpeedButton;
    YUpBtn: TSpeedButton;
    YDownBtn: TSpeedButton;
    SetBtn: TSpeedButton;
    ReSetBtn: TSpeedButton;
    XLonEdit: TEdit;
    YLatEdit: TEdit;
    HelpBtn: TBitBtn;
    CloseBtn: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog1: TSaveDialog;
    GroupBox4: TGroupBox;
    OpenTextureBtn: TSpeedButton;
    OpenActorBtn: TSpeedButton;
    OpenSetBtn: TSpeedButton;
    OtsNameEdit: TEdit;
    ActorFileNameEdit: TEdit;
    TextureFileNameEdit: TEdit;
    SaveSetBtn: TSpeedButton;
    OpenWpnBtn: TSpeedButton;
    WeaponFileNameEdit: TEdit;
    OpenWpnTextureBtn: TSpeedButton;
    WpnTextureFileNameEdit: TEdit;
    OpenPictureDialog1: TOpenPictureDialog;
    InDatumCB: TComboBox;
    DoDatumBtn: TSpeedButton;
    Panel1: TPanel;
    LegendLayerCB: TComboBox;
    ActorCB: TCheckBox;
    TabSheet3: TTabSheet;
    Antialiase: TCheckBox;
    Label3: TLabel;
    LineAlpha: TScrollBar;
    Label4: TLabel;
    FillAlpha: TScrollBar;
    LineThickness: TScrollBar;
    ThickOutline: TCheckBox;
    OutlineThicknessLabel: TLabel;
    Label6: TLabel;
    OutlineColorPanel: TPanel;
    LineOpacityLabel: TLabel;
    FillOpacityLabel: TLabel;
    TabSheet4: TTabSheet;
    LegendColorsPanel: TPanel;
    GroupBox2: TGroupBox;
    OtsNameEditTextEdit: TEdit;
    PointSizeScrollBar: TScrollBar;
    Label8: TLabel;
    PointSizeLabel: TLabel;
    ProjectSetotsFileBtn: TSpeedButton;
    LineScrollBar: TScrollBar;
    Label10: TLabel;
    StippleSizeLabel: TLabel;
    LineStippledCB: TCheckBox;
    Image32: TImage32;
    StippleColorPanel: TPanel;
    StippleStepper: TUpDown;
    StippleStepperLabel: TLabel;
    StippleCountBtn: TSpeedButton;
    StippleCountLabel: TLabel;
    ProjectActorotsFileBtn: TSpeedButton;
    ProjectActorEdit: TEdit;
    Label9: TLabel;
    ShapeTypeLabel: TLabel;
    ViewChangesBtn: TSpeedButton;
    PointTypeRG: TRadioGroup;
    CanvasLineUpDown: TUpDown;
    CanvasLineSizeLabel: TLabel;
    Bevel1: TBevel;
    DtpHelpBtn: TSpeedButton;
    DtpExitBtn: TSpeedButton;
    PolyFilledCB: TCheckBox;
    TextureOnlyCB: TCheckBox;
    OtsSizeEdit: TEdit;
    Label11: TLabel;
    TabSheet5: TTabSheet;
    PageControl2: TPageControl;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    TabSheet8: TTabSheet;
    BioregionEdit: TEdit;
    BioregionBtn: TSpeedButton;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    BioregionGroupUpDown: TUpDown;
    BioregionPlantsUpDown: TUpDown;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    BioregionPCNEdit: TEdit;
    BioregionDensityEdit: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    BioregionSIDEdit: TEdit;
    BuildingCB: TCheckBox;
    TabSheet9: TTabSheet;
    PlantsCB: TCheckBox;
    Label32: TLabel;
    Label33: TLabel;
    UrbanFilenameEdit: TEdit;
    UrbanFilenameBtn: TSpeedButton;
    UrbanUpDown: TUpDown;
    Label34: TLabel;
    Label35: TLabel;
    UrbanEdit: TEdit;
    UrbanOpenBtn: TSpeedButton;
    Label36: TLabel;
    DomainFilenameEdit: TEdit;
    DomainFilenameBtn: TSpeedButton;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    DomainUpDown: TUpDown;
    Label40: TLabel;
    DomainEdit: TEdit;
    DomainOpenBtn: TSpeedButton;
    Label41: TLabel;
    Label42: TLabel;
    Label5: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    VegEdit: TEdit;
    VegOpenBtn: TSpeedButton;
    VegSampleUpDown: TUpDown;
    VegIfnBtn: TSpeedButton;
    VegIfnEdit: TEdit;
    VegSpeciesUpDown: TUpDown;
    PolyPatternCB: TCheckBox;
    TabSheet10: TTabSheet;
    Label45: TLabel;
    PatternBtn: TSpeedButton;
    PatternEdit: TEdit;
    Label46: TLabel;
    PatternUpDown: TUpDown;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    PatternSatBtn: TSpeedButton;
    PatternSatEdit: TEdit;
    Image1: TImage;
    PatternCBox: TCheckBox;
    PolyEcotypeCB: TCheckBox;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    PatternCB: TComboBox;
    Label54: TLabel;
    VegSidEdit: TEdit;
    VegUidEdit: TEdit;
    VegCnEdit: TEdit;
    VegSnEdit: TEdit;
    VegWidthEdit: TEdit;
    VegHeightEdit: TEdit;
    VegSrEdit: TEdit;
    VegSdEdit: TEdit;
    VegNosEdit: TEdit;
    Label55: TLabel;
    DomainCB: TComboBox;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    PageControl3: TPageControl;
    TabSheet11: TTabSheet;
    TabSheet12: TTabSheet;
    Label64: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    UrbanCB: TComboBox;
    Label68: TLabel;
    Label53: TLabel;
    Label69: TLabel;
    Label7: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Label63: TLabel;
    Label61: TLabel;
    Label60: TLabel;
    Label59: TLabel;
    Label62: TLabel;
    Label12: TLabel;
    EcotypeColorBtn: TSpeedButton;
    Label14: TLabel;
    Label13: TLabel;
    EcotypeUpDown: TUpDown;
    Label70: TLabel;
    Label71: TLabel;
    Label72: TLabel;
    Label73: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    EcotypeCB: TComboBox;
    Label76: TLabel;
    EcotypeEdit: TEdit;
    EcotypeOpenBtn: TSpeedButton;
    EcotypeIDEdit: TEdit;
    Label78: TLabel;
    Label79: TLabel;
    Label77: TLabel;
    Label80: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    ObjectCB: TCheckBox;
    Label84: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure DtpExitBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DtpHelpBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure LegendColorsPanelClick(Sender: TObject);
    procedure LegendLayerCBClick(Sender: TObject);
    procedure XUpBtnClick(Sender: TObject);

    procedure SetBtnClick(Sender: TObject);
    procedure XDownBtnClick(Sender: TObject);
    procedure ReSetBtnClick(Sender: TObject);
    procedure YUpBtnClick(Sender: TObject);
    procedure YDownBtnClick(Sender: TObject);
    procedure DoDatumBtnClick(Sender: TObject);
    procedure SetHTFBtnClick(Sender: TObject);
    procedure OpenSetBtnClick(Sender: TObject);
    procedure SaveSetBtnClick(Sender: TObject);
    procedure OpenActorBtnClick(Sender: TObject);
    procedure OpenTextureBtnClick(Sender: TObject);
    procedure OpenWpnBtnClick(Sender: TObject);
    procedure OpenWpnTextureBtnClick(Sender: TObject);
    procedure OutlineColorPanelClick(Sender: TObject);
    procedure LineAlphaChange(Sender: TObject);
    procedure AntialiaseClick(Sender: TObject);
    procedure FillAlphaChange(Sender: TObject);
    procedure LineThicknessChange(Sender: TObject);
    procedure PointSizeScrollBarChange(Sender: TObject);
    procedure ProjectSetotsFileBtnClick(Sender: TObject);
    procedure ViewChangesBtnClick(Sender: TObject);
    procedure LineScrollBarChange(Sender: TObject);
    procedure StippleColorPanelClick(Sender: TObject);
    procedure StippleStepperClick(Sender: TObject; Button: TUDBtnType);
    procedure StippleCountBtnClick(Sender: TObject);
    procedure ProjectActorotsFileBtnClick(Sender: TObject);
    procedure PointTypeRGClick(Sender: TObject);
    procedure CanvasLineUpDownClick(Sender: TObject; Button: TUDBtnType);

procedure PaintMyPoints;

    procedure PolyFilledCBClick(Sender: TObject);
procedure PaintMyPoly;
    procedure EcotypeColorBtnClick(Sender: TObject);
    procedure PatternSatBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmDTPForm: TdtmDTPForm;

implementation

{$R *.DFM}

uses
  dtmGlobals, dtmPOFvar,
  dtmfrm, DtmShpSaver, dtmEcotypeColorsFrm;

procedure TdtmDTPForm.FormDestroy(Sender: TObject);
begin
    {}
end;
procedure TdtmDTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  LegendFormY := dtmDTPForm.top;
  LegendFormX := dtmDTPForm.left;
end;
procedure TdtmDTPForm.DtpExitBtnClick(Sender: TObject);
begin
  Close;
end;
procedure TdtmDTPForm.DtpHelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(6000);
end;

procedure TdtmDTPForm.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(6200);
end;

procedure TdtmDTPForm.FormCreate(Sender: TObject);
var
 i, LayerDo,Startat:Integer;
begin
  top := LegendFormY;
  left := LegendFormX;
  {Fill Items with layers}
    For Startat:=0 to LayersLoaded-1 do
    Begin
      LayerDo:=LayersControlArray[Startat];
      LegendLayerCB.Items.Add( LayA[LayerDo].Filename);
    end;
  Image32.SetupBitmap;
  LegendLayerCB.ItemIndex:=(CurrentLayer-1);
  CurrentLayer:= LegendLayerCB.ItemIndex+1;
  LegendColorsPanel.Color := LayA[CurrentLayer].LayerColor;
  OutlineColorPanel.Color:= LayA[CurrentLayer].OutLineColor;
   Antialiase.Checked:=  LayA[CurrentLayer].PolygonAntialiased;
   PolyFilledCB.Checked:= LayA[CurrentLayer].PolyFilled;    
   ThickOutline.Checked:= LayA[CurrentLayer].UseOutlinePoly;
   LineAlpha.Position:=  LayA[CurrentLayer].LineAlphaPosition;
   LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition]);
   FillAlpha.Position:=  LayA[CurrentLayer].FillAlphaPosition;
   FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition]);
   LineThickness.Position:=  Round(LayA[CurrentLayer].LineSize*10);
   OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize]);
   PointSizeScrollBar.Position:=  ((LayA[CurrentLayer].PointSize));
   PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
   LineScrollBar.Position:=  Round(LayA[CurrentLayer].StippleStep*100);
   StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
   StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
   StippleColorPanel.Color :=  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
   StippleStepperLabel.Caption :=Format('(%d)', [StippleStepper.Position]);
   StippleCountLabel.Caption :=Format('(%d)', [((LayA[CurrentLayer].StippleColorCount))]);
   StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;

  CanvasLineUpDown.Position:=LayA[CurrentLayer].CanvasLineSize;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);

  i:= LayA[CurrentLayer].ShpType;
  Case i of
 0: ShapeTypeLabel.Caption:='Null Shape';
 1: ShapeTypeLabel.Caption:='Point';
 3: ShapeTypeLabel.Caption:='PolyLine';
 5: ShapeTypeLabel.Caption:='Polygon';
 8: ShapeTypeLabel.Caption:='MultiPoint';
11: ShapeTypeLabel.Caption:='PointZ';
13: ShapeTypeLabel.Caption:='PolyLineZ';
15: ShapeTypeLabel.Caption:='PolygonZ';
18: ShapeTypeLabel.Caption:='MultiPointZ';
21: ShapeTypeLabel.Caption:='PointM';
23: ShapeTypeLabel.Caption:='PolyLineM';
25: ShapeTypeLabel.Caption:='PolygonM';
28: ShapeTypeLabel.Caption:='MultiPointM';
31: ShapeTypeLabel.Caption:='MultiPatch';      {Fan or Strip     }
end;{case}

  {ots}
  OtsNameEditTextEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  OtsNameEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  ProjectActorEdit.Text:=ProjectActorOtsFilename;

  {HTFix}
  XLabel.Caption:=FLoattostr(LayA[CurrentLayer].OffsetX);
  X2Label.Caption:=FLoattostr(LayA[CurrentLayer].XMin);

  DShiftOffsetX:=TMaxOffsetX;
  XLonEdit.Text:=FloattoStr(TMaxOffsetX);
  DShiftOffsetY:=TMaxOffsetY;
  YLatEdit.Text:=FloattoStr(TMaxOffsetY);

HTFXLabel.Caption:=FloattoStr(TMaxOffsetX*TMaxOffX);
HTFYLabel.Caption:=FloattoStr(TMaxOffsetY*TMaxOffY);
HTFXEdit.Text:=FloattoStr(TMaxOffsetX*TMaxOffX);
HTFYEdit.Text:=FloattoStr(TMaxOffsetY*TMaxOffY);

  If FileExists(ChangeFileExt(
  LayA[CurrentLayer].Path+
  LayA[CurrentLayer].Filename,'.vrp'))then
  begin
    DoDatumBtn.Enabled:=True;
    {Read ProjectionRecord}
  end else
  begin
    DoDatumBtn.Enabled:=False;
    InDatumCB.ItemIndex:=24;{UnknownWGS84=23}
  end;
{  LineScrollBar(Sender);}
end;
{procedure THtfForm.ReadAnyVersionProj(ReadFileName:String);
procedure THtfForm.ReadVersionProj(ReadFileName:String);
procedure THtfForm.ReadVer1Proj(ReadFileName:String);}

procedure TdtmDTPForm.LegendLayerCBClick(Sender: TObject);
var i:Integer;
begin
  CurrentLayer:= LegendLayerCB.ItemIndex+1;
  i:= LayA[CurrentLayer].ShpType;
  Case i of
 0: ShapeTypeLabel.Caption:='Null Shape';
 1: ShapeTypeLabel.Caption:='Point';
 3: ShapeTypeLabel.Caption:='PolyLine';
 5: ShapeTypeLabel.Caption:='Polygon';
 8: ShapeTypeLabel.Caption:='MultiPoint';
11: ShapeTypeLabel.Caption:='PointZ';
13: ShapeTypeLabel.Caption:='PolyLineZ';
15: ShapeTypeLabel.Caption:='PolygonZ';
18: ShapeTypeLabel.Caption:='MultiPointZ';
21: ShapeTypeLabel.Caption:='PointM';
23: ShapeTypeLabel.Caption:='PolyLineM';
25: ShapeTypeLabel.Caption:='PolygonM';
28: ShapeTypeLabel.Caption:='MultiPointM';
31: ShapeTypeLabel.Caption:='MultiPatch';      {Fan or Strip     }
end;{case}
  LegendColorsPanel.Color := LayA[CurrentLayer].LayerColor;
  OutlineColorPanel.Color:= LayA[CurrentLayer].OutLineColor;
   Antialiase.Checked:=  LayA[CurrentLayer].PolygonAntialiased;
   PolyFilledCB.Checked:= LayA[CurrentLayer].PolyFilled;
   ThickOutline.Checked:= LayA[CurrentLayer].UseOutlinePoly;
   LineAlpha.Position:=  LayA[CurrentLayer].LineAlphaPosition;
   LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition]);
   FillAlpha.Position:=  LayA[CurrentLayer].FillAlphaPosition;
   FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition]);
   LineThickness.Position:=  Round(LayA[CurrentLayer].LineSize*10);
   OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize]);
   PointSizeScrollBar.Position:=  ((LayA[CurrentLayer].PointSize));
   PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
   LineScrollBar.Position:=  Round(LayA[CurrentLayer].StippleStep*100);
   StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
   StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
   StippleColorPanel.Color :=  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
   StippleStepperLabel.Caption :=Format('(%d)', [StippleStepper.Position]);
   StippleCountLabel.Caption :=Format('(%d)', [((LayA[CurrentLayer].StippleColorCount))]);
   StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;

  CanvasLineUpDown.Position:=LayA[CurrentLayer].CanvasLineSize;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);

   LineScrollBarChange(Sender);
  {ots}
  OtsNameEditTextEdit.Text:=LayA[CurrentLayer].OtsNameEditText;
  OtsNameEdit.Text:=LayA[CurrentLayer].OtsNameEditText;

  {HTFix}
  XLabel.Caption:=FLoattostr(LayA[CurrentLayer].OffsetX);
  X2Label.Caption:=FLoattostr(LayA[CurrentLayer].XMin);

  If FileExists(ChangeFileExt(
  LayA[CurrentLayer].Path+
  LayA[CurrentLayer].Filename,'.vrp'))then
  begin
    DoDatumBtn.Enabled:=True;
    {Read ProjectionRecord}
  end else
  begin
    DoDatumBtn.Enabled:=False;
    InDatumCB.ItemIndex:=24;{UnknownWGS84=23}
  end;
end;

procedure TdtmDTPForm.DoDatumBtnClick(Sender: TObject);
begin
{InDatumCB.ItemIndex  WGS84=23

buzDatum, buzGlobal

Procedure ConvertDatums(
                    LongXCoord, LatYCoord:Double;
                    var XCoord, YCoord:Double);}
end;
(*****************************************************)
(*****************************************************)



(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.XUpBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=DShiftOffsetX+TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
end;

procedure TdtmDTPForm.XDownBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=DShiftOffsetX-TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
end;

procedure TdtmDTPForm.YUpBtnClick(Sender: TObject);
begin
    DShiftOffsetY:=DShiftOffsetY+TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
end;

procedure TdtmDTPForm.YDownBtnClick(Sender: TObject);
begin
    DShiftOffsetY:=DShiftOffsetY-TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
end;

procedure TdtmDTPForm.ReSetBtnClick(Sender: TObject);
begin
    DShiftOffsetX:=TMaxOffsetX;
    XLonEdit.Text:=FloattoStr(DShiftOffsetX);
    DShiftOffsetY:=TMaxOffsetY;
    YLatEdit.Text:=FloattoStr(DShiftOffsetY);
    DTMform.PrepareBitmap;
end;

procedure TdtmDTPForm.SetBtnClick(Sender: TObject);
begin
  DTMform.PrepareBitmap;
{XLonEdit.Text}
{YLatEdit.Text}
end;

(*
    TMaxOffsetX:=( (360 /htf.SizeX));
    TMaxOffsetY:=( (180 /htf.SizeY));
    TMaxOffX:= htf.SizeX;
    TMaxOffY:= htf.SizeY;

        TMinOffX:= curX;
        TMinOffY:= curY;
        DVDORedraw;


    If CurrentLayer =1 then
    Begin
      MinOffX:=LayA[CurrentLayer].XMin;
      MinOffY:=LayA[CurrentLayer].YMin;
      MaxOffX:=LayA[CurrentLayer].XMax;
      MaxOffY:=LayA[CurrentLayer].YMax;
    End;


      {Offset is +- to center data to 0,0}
      TMinOffX:= TMinOffX*TMaxOffsetX;
      TMinOffY:= TMinOffY*TMaxOffsetY;
      ScreenScale :=   TMaxOffsetX;

              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].XMax;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].YMax;
              DXdtemp:=MaxOffsetX +dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              Image321.Bitmap.FillRect(DXI-2,DYI-2,DXI+2,DYI+2,PointColor);


              dXTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
              dYTemp:=LayA[LayerDo].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
              DXdtemp:=MaxOffsetX +dXTemp- TMinOffX ;
              DYdtemp:=MaxOffsetY +dYTemp+ TMinOffY;
              DXI:= Trunc((DXdtemp   ) / ScreenScale) ;
              DYI:=Trunc(TMaxOffY-( ((DYdtemp ) / ScreenScale))) ;
              Editarray[INumPoints-1].X:= DXI;
              Editarray[INumPoints-1].Y:= DYI;
*)

procedure TdtmDTPForm.SetHTFBtnClick(Sender: TObject);
begin
  {isHTFLoaded}
  TMaxOffsetX:=( (strtofloat(HTFXEdit.Text) /TMaxOffX));
  TMaxOffsetY:=( (strtofloat(HTFYEdit.Text) /TMaxOffX));
  HTFXLabel.Caption:=FloattoStr(TMaxOffsetX*TMaxOffX);
  HTFYLabel.Caption:=FloattoStr(TMaxOffsetY*TMaxOffX);
  {HTFXEdit.Text:=FloattoStr(TMaxOffsetX*TMaxOffX);
   HTFYEdit.Text:=FloattoStr(TMaxOffsetY*TMaxOffX); }
end;
(*****************************************************)
(*****************************************************)





(*****************************************************)
   {ProjectPath
   MapsPath
   TigerPath md2 smd qc
   DXFPath dxf 3ds
3D Formats: 3DS, OBJ, SMD, MD2, TIN, PLY, STL
2D Formats: JPG, BMP, TGA, CEL etc.
   }
(*****************************************************)
procedure TdtmDTPForm.OpenSetBtnClick(Sender: TObject);
var
 ActorFileName,TextureFileName,
 WeaponFileName, WpnTextureFileName,
 S : string;
 F: TextFile;
begin
  {OpenDialog.InitialDir:=ProjectPath;}
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (OtsNameEdit.Text=NoName) then
     OpenDialog.Filename:= '*.ots' else
  If (OtsNameEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= OtsNameEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    If (not FileExists(OpenDialog.Filename)) then Exit;
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    AssignFile(F, OpenDialog.FileName);
    Reset(F);
    Readln(F, S);
    If (S='GlobalObjectActorTerrain Version 1.0') then
    begin
             {Read file and get ActorFileName
              and TextureFileName
                  WeaponFileName
                  WpnTextureFileName
               Filenames...}
    Readln(F, S);
    If S='True' then ActorCB.Checked:=True
                else ActorCB.Checked:=False;{Boolean}
    Readln(F, S);
    If S='True' then ObjectCB.Checked:=True
                else ObjectCB.Checked:=False;{Boolean}
    Readln(F, S);
    If S='True'  then TextureOnlyCB.Checked:=True
                 else TextureOnlyCB.Checked:=False;
    Readln(F, S);
    If S='True'  then PlantsCB.Checked:=True
                 else PlantsCB.Checked:=False;
    Readln(F, S);
    If S='True'  then BuildingCB.Checked:=True
                 else BuildingCB.Checked:=False;
      OtsNameEdit.Text:= OpenDialog.FileName;
      Readln(F, ActorFileName);
      ActorFileNameEdit.Text:=ActorFileName;
      Readln(F, TextureFileName);
      TextureFileNameEdit.Text:=TextureFileName;
      Readln(F, WeaponFileName);
      WeaponFileNameEdit.Text:=WeaponFileName;
      Readln(F, WpnTextureFileName);
      WpnTextureFileNameEdit.Text:=WpnTextureFileName;
      Readln(F, S);
      OtsSizeEdit.Text:=S;
      CloseFile(F);
    end else {Error Message Wrong File type Version};
  end;
end;

procedure TdtmDTPForm.SaveSetBtnClick(Sender: TObject);
var
{ ActorFileName,TextureFileName,
 WeaponFileName, WpnTextureFileName,}
 WhatsMyLine : string;
 F: TextFile;
begin  { for Actor and Texture}
  If ((FileExists(ActorFileNameEdit.Text))
      {and(FileExists(TextureFileNameEdit.Text))}) then
  begin
    SaveDialog1.InitialDir:=ProjectPath;
    SaveDialog1.Filter:= 'Object + Texture Set (*.ots)|*.ots';
    SaveDialog1.Filename:= OtsNameEdit.Text;
    if SaveDialog1.Execute then
    if UpperCase(ExtractFileExt(SaveDialog1.Filename)) = '.OTS' then
    begin
      ProjectPath:=ExtractFilePath(SaveDialog1.Filename);
      AssignFile(F, SaveDialog1.FileName);
      Rewrite(F);
      {S:='GlobalObjectActorTerrain Version 1.0';} {GetYourOats}
      writeln(F, 'GlobalObjectActorTerrain Version 1.0');
    If ActorCB.Checked then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);
    If ObjectCB.Checked  then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);{}
    If TextureOnlyCB.Checked  then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);{}
    If PlantsCB.Checked  then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);{}
    If BuildingCB.Checked  then WhatsMyLine:='True'
                          else WhatsMyLine:='False';{Boolean}
    Writeln(F, WhatsMyLine);{}
             {Read file and get ActorFileName
              and TextureFileName
                  WeaponFileName
                  WpnTextureFileName
               Filenames...}
      If (not FileExists(ActorFileNameEdit.Text)) then
      ActorFileNameEdit.Text:= NoName;
      writeln(F, ActorFileNameEdit.Text);
      If (not FileExists(TextureFileNameEdit.Text)) then
      TextureFileNameEdit.Text:= NoName;
      writeln(F, TextureFileNameEdit.Text);
      If (not FileExists(WeaponFileNameEdit.Text)) then
      WeaponFileNameEdit.Text:= NoName;
      writeln(F, WeaponFileNameEdit.Text);
      If (not FileExists(WpnTextureFileNameEdit.Text)) then
      WpnTextureFileNameEdit.Text:= NoName;
      writeln(F, WpnTextureFileNameEdit.Text);

      If length(OtsSizeEdit.Text)<1 then
      OtsSizeEdit.Text:= '1';
      {Check Validity of Input Size: is it a number?}
      writeln(F, OtsSizeEdit.Text);
      CloseFile(F);
    end;
  end;
end;
   {TigerPath md2 smd qc ??? qc IS a kind of ots !!!
    SMD, MD2|*. SMD;*. MD2
    DXFPath dxf 3ds
    3DS, OBJ, TIN, PLY, STL|*.3DS;*. OBJ;*.TIN; *.PLY; *.STL
   }
procedure TdtmDTPForm.OpenActorBtnClick(Sender: TObject);
begin
  If ActorCB.Checked then
  begin
    OpenDialog.InitialDir:=TigerPath;
    OpenDialog.Filter:= 'Actor  (*.qc)|*.qc';
    OpenDialog.Filename:= '*.qc';
    OpenPictureDialog1.InitialDir:=TigerPath;
  end
  else If ObjectCB.Checked then
  begin
    OpenDialog.InitialDir:=DXFPath;
    OpenDialog.Filter:= 'Object (*.3ds)|*.3DS;*. OBJ;*.TIN;*.PLY;*.STL';
    OpenDialog.Filename:= '*.3ds';
  end
  else If TextureOnlyCB.Checked then
  begin
    OpenDialog.InitialDir:=DXFPath;
    OpenDialog.Filter:= 'Texture Billboard (*.png)|*.png;*.jpg;*.bmp';
    OpenDialog.Filename:= '*.png';
  end
  else If PlantsCB.Checked then
  begin
    OpenDialog.InitialDir:=ProjectPath;
    OpenDialog.Filter:= 'Plants (*.vld)|*.vld';
    OpenDialog.FileName:= '*.vld';
  end
  else If BuildingCB.Checked then
  begin
    OpenDialog.InitialDir:=ProjectPath;
    OpenDialog.Filter:= 'Plants (*.bld)|*.bld';
    OpenDialog.FileName:= '*.bld';
  end;
  if OpenDialog.Execute then
  ActorFileNameEdit.Text:=OpenDialog.Filename;
end;

procedure TdtmDTPForm.OpenTextureBtnClick(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  TextureFileNameEdit.Text:=OpenPictureDialog1.Filename;
end;

procedure TdtmDTPForm.OpenWpnBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  WeaponFileNameEdit.Text:=OpenDialog.Filename;
end;

procedure TdtmDTPForm.OpenWpnTextureBtnClick(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  WpnTextureFileNameEdit.Text:=OpenPictureDialog1.Filename;
end;
(*****************************************************)
(*****************************************************)



(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.LegendColorsPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].LayerColor;
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    LegendColorsPanel.Color := ColorDialog1.Color;
    {MapGridsColor := LegendColorsPanel.Color;}
    LayA[CurrentLayer].LayerColor:=LegendColorsPanel.Color;
  end;
end;

procedure TdtmDTPForm.OutlineColorPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].OutLineColor;
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    OutlineColorPanel.Color := ColorDialog1.Color;
    {MapGridsColor := LegendColorsPanel.Color;}
    LayA[CurrentLayer].OutLineColor:=OutlineColorPanel.Color;
  end;
end;
(*****************************************************)
(*****************************************************)

procedure TdtmDTPForm.ViewChangesBtnClick(Sender: TObject);
begin
  DTMform.PrepareBitmap;
end;

(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.AntialiaseClick(Sender: TObject);
begin      {False}
  LayA[CurrentLayer].PolygonAntialiased:=Antialiase.Checked;
  PaintMyPoly;
end;

procedure TdtmDTPForm.PolyFilledCBClick(Sender: TObject);
begin{}
  LayA[CurrentLayer].PolyFilled:=PolyFilledCB.Checked;
  PaintMyPoly;
end;

procedure TdtmDTPForm.LineAlphaChange(Sender: TObject);
begin   {255}
  LayA[CurrentLayer].LineAlphaPosition:=LineAlpha.Position;
  LineOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].LineAlphaPosition]);
  PaintMyPoly;
end;

procedure TdtmDTPForm.FillAlphaChange(Sender: TObject);
begin     {127}
  LayA[CurrentLayer].FillAlphaPosition:=FillAlpha.Position;
  FillOpacityLabel.Caption := Format('(%d)', [LayA[CurrentLayer].FillAlphaPosition]);
  PaintMyPoly;
end;

procedure TdtmDTPForm.LineThicknessChange(Sender: TObject);
begin    {10 of 200}
  LayA[CurrentLayer].UseOutlinePoly := ThickOutline.Checked;
  LayA[CurrentLayer].LineSize := LineThickness.Position / 10;
  OutlineThicknessLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].LineSize]);
  PaintMyPoly;
end;

procedure TdtmDTPForm.PaintMyPoly;
var
  UseOutlinePoly:Boolean;
  FillAlphaPosition, LineAlphaPosition : integer;
  LineSize:Single;
  PolyColor, OutLineColor:TColor32;
    Polygon: TPolygon32;
    Outline: TPolygon32;
    TmpPoly: TPolygon32;
Begin
  {Draw a line to SEE Transparency against}
  Image32.Bitmap.MoveTo(60, 4);
  Image32.Bitmap.PenColor := Color32(MapGridsColor);
  Image32.Bitmap.LineToS(60, 26);
  {Do Poly stuff}
  Polygon := TPolygon32.Create;
  Outline := TPolygon32.Create;
  Polygon.Antialiased := LayA[CurrentLayer].PolygonAntialiased;
  UseOutlinePoly:= LayA[CurrentLayer].UseOutlinePoly;
  Polygon.FillMode := pfWinding;  {pfAlternate}
  OutLineColor:= Color32(LayA[CurrentLayer].OutLineColor);
  PolyColor:= Color32(LayA[CurrentLayer].LayerColor);
  FillAlphaPosition:= LayA[CurrentLayer].FillAlphaPosition;
  LineAlphaPosition:= LayA[CurrentLayer].LineAlphaPosition;
  LineSize:= LayA[CurrentLayer].LineSize;
  Polygon.NewLine;
  Polygon.Add(FixedPoint(10, 10));
  Polygon.Add(FixedPoint(110, 10));
  Polygon.Add(FixedPoint(110, 20));
  Polygon.Add(FixedPoint(10, 20));
  Polygon.Add(FixedPoint(10, 10));
  Polygon.DrawFill(Image32.Bitmap,
               SetAlpha(PolyColor, FillAlphaPosition));
  if UseOutlinePoly then
  begin
    TmpPoly := Polygon.Outline;
    Outline := TmpPoly.Grow(Fixed(LineSize / 2), 0.5);
    Outline.FillMode := pfWinding;
    TmpPoly.Free;
  end;
  if UseOutlinePoly then
     Outline.Antialiased := LayA[CurrentLayer].PolygonAntialiased;
  if UseOutlinePoly then
     Outline.DrawFill(Image32.Bitmap,
                    SetAlpha(OutLineColor, LineAlphaPosition))
     else Polygon.DrawEdge(Image32.Bitmap,
                    SetAlpha(OutLineColor, LineAlphaPosition));
  Outline.Free;
  {Outline := nil;  }
  Polygon.Free;
End;
(*****************************************************)
{Lines}
(*****************************************************)

procedure TdtmDTPForm.StippleCountBtnClick(Sender: TObject);
begin
  Inc(LayA[CurrentLayer].StippleColorCount);
  StippleStepper.Max:=LayA[CurrentLayer].StippleColorCount-1;
  StippleStepper.Position:=LayA[CurrentLayer].StippleColorCount-1;
  StippleColorPanel.Color := clBlack;
  SetLength(LayA[CurrentLayer].StippleColorArray,LayA[CurrentLayer].StippleColorCount);
  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position]:=
  StippleColorPanel.Color;
  StippleCountLabel.Caption:=InttoStr(LayA[CurrentLayer].StippleColorCount);
end;

procedure TdtmDTPForm.StippleStepperClick(Sender: TObject;
  Button: TUDBtnType);
begin
  StippleColorPanel.Color :=
    LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
  {LayA[CurrentLayer].StippleStepper:=StippleStepper.Position;}
  StippleStepperLabel.Caption:=Format('(%d)', [StippleStepper.Position]);
end;

procedure TdtmDTPForm.LineScrollBarChange(Sender: TObject);
var
I:Integer;
NewStipple: array of TColor32;
begin
  Image32.Bitmap.Clear(clWhite32);
  LayA[CurrentLayer].UseStippleStep := LineStippledCB.Checked;
  LayA[CurrentLayer].StippleStep := LineScrollBar.Position / 100;
  StippleSizeLabel.Caption := Format('(%.1f)', [LayA[CurrentLayer].StippleStep]);
    {SetStipple([clWhite32, clRed32, clGreen32, 0, 0, 0]);
     SetStipple([clGreen32, clGreen32, clGreen32, 0, 0, clWhite32, 0, 0]);
    SetStipple([clWhite32, $00FFFFFF]);
    SetStipple([clWhite32, clWhite32, clWhite32, clWhite32, 0, 0, 0, 0]);
}
  SetLength(NewStipple,LayA[CurrentLayer].StippleColorCount);
    For I:=0 to LayA[CurrentLayer].StippleColorCount-1 do
    NewStipple[I]:=Color32(LayA[CurrentLayer].StippleColorArray[I]);
  Image32.Bitmap.SetStipple(NewStipple);
  Image32.Bitmap.StippleStep := LayA[CurrentLayer].StippleStep;

  Image32.Bitmap.MoveTo(10, 10);
  If LayA[CurrentLayer].UseStippleStep then
   Image32.Bitmap.LineToFSP(110, 10) else
  begin
    Image32.Bitmap.PenColor :=
            Color32(LayA[CurrentLayer].LayerColor);
    Image32.Bitmap.LineToS(110, 10);
  end;
end;

procedure TdtmDTPForm.StippleColorPanelClick(Sender: TObject);
begin
  ColorDialog1.Color :=
  LayA[CurrentLayer].StippleColorArray[StippleStepper.Position];
  {LegendColorsPanel.Color;}
  if ColorDialog1.execute then
  begin
    StippleColorPanel.Color := ColorDialog1.Color;
    LayA[CurrentLayer].StippleColorArray[StippleStepper.Position]:= ColorDialog1.Color;
  end;
end;
(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.ProjectSetotsFileBtnClick(Sender: TObject);
begin
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (OtsNameEditTextEdit.Text='Nada.ots') then
     OpenDialog.Filename:= '*.ots' else
  If (OtsNameEditTextEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= OtsNameEditTextEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    OtsNameEditTextEdit.Text:=(OpenDialog.Filename);
    LayA[CurrentLayer].OtsNameEditText:=OpenDialog.Filename;
  end;
end;
(*****************************************************)
procedure TdtmDTPForm.ProjectActorotsFileBtnClick(Sender: TObject);
begin
  OpenDialog.InitialDir:=ProjectPath;
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  If (ProjectActorEdit.Text='Nada.ots') then
     OpenDialog.Filename:= '*.ots' else
  If (ProjectActorEdit.Text <> '') then
  OpenDialog.Filename:= '*.ots' else
  OpenDialog.Filename:= ProjectActorEdit.Text;
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  begin
    ProjectPath:=ExtractFilePath(OpenDialog.Filename);
    ProjectActorEdit.Text:=(OpenDialog.Filename);
    ProjectActorOtsFilename:=OpenDialog.Filename;
  end;
end;
(*****************************************************)
(*****************************************************)


(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.PointSizeScrollBarChange(Sender: TObject);
begin
  LayA[CurrentLayer].PointSize:=PointSizeScrollBar.Position;
  PointSizeLabel.Caption := Format('(%d)', [((LayA[CurrentLayer].PointSize*2)+1)]);
  PaintMyPoints;
end;

procedure TdtmDTPForm.PointTypeRGClick(Sender: TObject);
var PointCaption:String;
begin
  {Points: 0:Dot 1:Circle 2:DotInCircle 3:FilledCircle
        4:PlusSign 5:X 6:Box 7:XInBox 8:FilledBox}
  PointCaption:='Point Type: ';
  Case PointTypeRG.ItemIndex of {Points:}
    0:PointTypeRG.Caption:=PointCaption+'Dot';
    1:PointTypeRG.Caption:=PointCaption+'Circle';
    2:PointTypeRG.Caption:=PointCaption+'DotInCircle';
    3:PointTypeRG.Caption:=PointCaption+'FilledCircle';
    4:PointTypeRG.Caption:=PointCaption+'PlusSign';
    5:PointTypeRG.Caption:=PointCaption+'X';
    6:PointTypeRG.Caption:=PointCaption+'Box';
    7:PointTypeRG.Caption:=PointCaption+'XInBox';
    8:PointTypeRG.Caption:=PointCaption+'FilledBox';
  End;{Case}
  LayA[CurrentLayer].CurrentPointType:=PointTypeRG.ItemIndex;
  PaintMyPoints;
end;

procedure TdtmDTPForm.CanvasLineUpDownClick(Sender: TObject; Button: TUDBtnType);
begin
  LayA[CurrentLayer].CanvasLineSize:=CanvasLineUpDown.Position;
  CanvasLineSizeLabel.Caption:=Format('(%d)', [CanvasLineUpDown.Position]);
  PaintMyPoints;
end;

procedure TdtmDTPForm.PaintMyPoints;
var
   DXI, DYI,
   PointSize, CurrentPointType:Integer;
   Canvas: TCanvas;
{  I:Integer;
   PointColor:TColor32;
   NewStipple: array of TColor32;}
Begin
  Image32.Bitmap.Clear(clWhite32);
  Canvas := TCanvas.Create; // create a new independent TCanvas object
  Canvas.Handle := Image32.Bitmap.Handle;
           { Color32(LayA[CurrentLayer].LayerColor)}
  Canvas.Pen.Color :=LayA[CurrentLayer].LayerColor;
  Canvas.Pen.Style := psSolid;
  Canvas.Pen.Width := LayA[CurrentLayer].CanvasLineSize;
  Canvas.Brush.Color := LayA[CurrentLayer].LayerColor;{OutLineColor;}
  Canvas.Brush.Style := bsSolid; {bsClear}

  CurrentPointType:=  LayA[CurrentLayer].CurrentPointType;
  PointSize:=  LayA[CurrentLayer].PointSize;
  DXI:=10; DYI:=10;
{  SetLength(NewStipple,LayA[CurrentLayer].StippleColorCount);
    For I:=0 to LayA[CurrentLayer].StippleColorCount-1 do
    NewStipple[I]:=Color32(LayA[CurrentLayer].StippleColorArray[I]);
  Image32.Bitmap.SetStipple(NewStipple);
  Image32.Bitmap.StippleStep := LayA[CurrentLayer].StippleStep;
  PointColor := Color32(LayA[CurrentLayer].LayerColor);}
{  Image32.Bitmap.MoveToF(10, 10);
  If CanvasLineSize=0 then
   Image32.Bitmap.LineToFSP(110, 10) else
  begin
    Image32.Bitmap.PenColor :=
            Color32(LayA[CurrentLayer].LayerColor);
    Image32.Bitmap.LineToS(110, 10);
  end;}
          case CurrentPointType of
            0: {Pnt Dot} Canvas.Pixels[DXI, DYI] :=
                LayA[CurrentLayer].LayerColor;
            1: {Pnt Circle}
              begin {    Canvas.Ellipse}
                {The ellipse is outlined using the value of Pen,
                 and filled using the value of Brush.}
                Canvas.Brush.Style :=bsClear;
                Canvas.Ellipse(DXI - PointSize, DYI - PointSize,
                DXI + PointSize, DYI +PointSize);
                Canvas.Brush.Style := bsSolid; {bsClear}
              end;
            2: {Pnt DotInCircle  }
              begin
                Canvas.Ellipse(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.Pixels[DXI, DYI] :=
                  LayA[CurrentLayer].OutLineColor;
              end;
              {FilledCircle}
            3:
            begin
            Canvas.Pen.Color :=LayA[CurrentLayer].OutLineColor;
            Canvas.Ellipse(DXI - PointSize,
            DYI - PointSize, DXI + PointSize, DYI +PointSize);
            end;
            4: {Pnt PlusSign  +}
              begin
                Canvas.moveto(DXI - PointSize, DYI);
                Canvas.lineto(DXI + PointSize, DYI);
                Canvas.moveto(DXI, DYI + PointSize);
                Canvas.lineto(DXI, DYI - PointSize);
              end;
            5: {PntX   X}
              begin
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;

            6: {Pnt Box X1, Y1, X2, Y2}
{To fill a rectangular region
without drawing the boundary in the current pen,
use FillRect.
To outline a rectangular region without filling it,
use FrameRect or Polygon.
To draw a rectangle with rounded corners, use RoundRect.}
              begin
                Canvas.Brush.Style :=bsClear;
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.Brush.Style := bsSolid; {bsClear}
              end;
            7: {Pnt XInBox}
              begin
                Canvas.Brush.Style :=bsClear;
                Canvas.Rectangle(DXI - PointSize,
                DYI - PointSize, DXI + PointSize, DYI +PointSize);
                Canvas.Brush.Style := bsSolid; {bsClear}
                Canvas.moveto(DXI - PointSize, DYI - PointSize);
                Canvas.lineto(DXI + PointSize, DYI + PointSize);
                Canvas.moveto(DXI - PointSize, DYI + PointSize);
                Canvas.lineto(DXI + PointSize, DYI - PointSize);
              end;
             8: {FilledBox}
          Canvas.FillRect(Rect(DXI-PointSize,DYI+PointSize,
          DXI+PointSize,DYI-PointSize){,PointColor});
          end; {Case}
Canvas.Free;
End;
(*****************************************************)
(*****************************************************)
  {Points: 0:Dot 1:Circle 2:DotInCircle 3:FilledCircle
        4:PlusSign 5:X 6:Box 7:XInBox 8:FilledBox}
{Points: 9 Types Variable Size, Variable-Thick lines, Color
 Lines: Stippled Color or Variable Width-Solid Color
 Antialiased:  Lines? and Polygon-Outline
 Polygon: Line and Fill Opacity, Line and Fill Color, Outline Thickness}
{Overlaid Stippled on Solid-Wide-lines
 Points from GR32 Polygons
 Bitmap Image- Point/Lines/Polygons
 Jans Symbol maker}
(*****************************************************)
(*****************************************************)
procedure TdtmDTPForm.EcotypeColorBtnClick(Sender: TObject);
begin
  dtmEcotypeColorsForm.show;
end;

procedure TdtmDTPForm.PatternSatBtnClick(Sender: TObject);
var
  Bitmap: TBitmap;
begin
  Bitmap := TBitmap.Create;
  try
    Bitmap.LoadFromFile('MyBitmap.bmp');
    Image1.Canvas.Brush.Bitmap := Bitmap;
    Image1.Canvas.FillRect(Rect(0,0,100,100));
  finally
    Image1.Canvas.Brush.Bitmap := nil;
    Bitmap.Free;
  end;

end;

end.


