object dtmDTPForm: TdtmDTPForm
  Left = 332
  Top = 34
  Width = 320
  Height = 386
  HelpContext = 6000
  Caption = 'Digital Terrain Project (.DTP)'
  Color = clBtnFace
  Font.Charset = DEFAULT_CHARSET
  Font.Color = clWindowText
  Font.Height = -11
  Font.Name = 'MS Sans Serif'
  Font.Style = []
  Icon.Data = {
    0000010001002020100000000000E80200001600000028000000200000004000
    0000010004000000000080020000000000000000000000000000000000000000
    0000000080000080000000808000800000008000800080800000C0C0C0008080
    80000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF000000
    0000000000ECCC000000000000EC000000000000000ECCC00000000000EC0000
    00000000000EECC0000000000ECC0000000000000000ECC0000000000ECC0000
    000000000000EECC00000000ECCC00000000000000000ECC00000000ECCC0000
    0000000000880ECC00000000ECC088888000000000880EECC0000000ECC08888
    88000000000ECCECC0088800ECC0ECCCCCCC0000000ECCECC00ECC00ECC0ECEE
    ECCCC000000ECCECC00ECC00ECC0EC00EECCCC00000ECCECC00ECC00ECC0EC00
    0EEECC00000ECCECC00ECC00ECC0EC00000ECCC0000ECCEEC00ECC00ECC0EC00
    000EECC0000ECCEECC0ECC00ECC0EC000000EECC000ECC0ECC0ECEC0ECC0EC00
    00000ECC000ECC0ECCEECEC0ECC0EC0000000ECC000ECC0ECCECCEC0ECC0EC00
    00000ECC000ECC0ECCEC0ECEECC0EC0000000ECC000ECC0EECEC0EEC0CC0EC00
    00000ECC000ECC00ECCC00ECCCC0EC0000000ECC000ECC00ECC000ECCC00EC00
    0000EECC000ECC00ECC000EECC00EC000000ECCC000ECC00ECC0000ECC00EC00
    0000ECC0000ECC000C00000ECC00EC00000EECC0000ECC00000000000000EC00
    000ECCC0000ECC00000000000000EC0000EECC00000ECC00000000000000EC00
    EEECC000000ECC00000000000000ECEEECC0EEEEEEEECEEEEEEEE0000000ECCC
    CCC0CCCCCCCCCCCCCCCCC0000000CCCC0000CCCCCCCCCCCCCCCCC0000000FFFC
    3FFCFFFE1FFCFFFE1FF8FFFF1FF8FFFF0FF0FFFF8FF0FFFC8FF107FC87F103FE
    063100FE0631007E0631303E0631383E06313E1E06313E1E02313F0E22113F8E
    20113F8E20113F8E20813F8E20893F8E30C13F8E31C33F0E31C33F0E31E33F1E
    3BE33E1E3FFF3E1E3FFF3C3E3FFF307E3FFF0100007F0100007F0F00007F}
  OldCreateOrder = False
  ShowHint = True
  OnClose = FormClose
  OnCreate = FormCreate
  OnDestroy = FormDestroy
  PixelsPerInch = 96
  TextHeight = 13
  object PageControl1: TPageControl
    Left = 0
    Top = 41
    Width = 312
    Height = 318
    HelpContext = 6000
    ActivePage = TabSheet3
    Align = alClient
    TabOrder = 0
    object TabSheet3: TTabSheet
      HelpContext = 6000
      Caption = 'Layer'
      ImageIndex = 2
      object Label3: TLabel
        Left = 8
        Top = 156
        Width = 62
        Height = 13
        Caption = 'Line Opacity:'
      end
      object Label4: TLabel
        Left = 8
        Top = 192
        Width = 54
        Height = 13
        Caption = 'Fill Opacity:'
      end
      object OutlineThicknessLabel: TLabel
        Left = 248
        Top = 178
        Width = 12
        Height = 13
        Caption = '(1)'
      end
      object Label6: TLabel
        Left = 168
        Top = 160
        Width = 88
        Height = 13
        Caption = 'Outline Thickness:'
      end
      object LineOpacityLabel: TLabel
        Left = 80
        Top = 156
        Width = 12
        Height = 13
        Caption = '(1)'
      end
      object FillOpacityLabel: TLabel
        Left = 72
        Top = 192
        Width = 12
        Height = 13
        Caption = '(1)'
      end
      object Label8: TLabel
        Left = 8
        Top = 72
        Width = 92
        Height = 13
        Caption = 'Point Size (2+2=5) :'
      end
      object PointSizeLabel: TLabel
        Left = 112
        Top = 72
        Width = 12
        Height = 13
        Caption = '(5)'
      end
      object Label10: TLabel
        Left = 168
        Top = 24
        Width = 61
        Height = 13
        Caption = 'Stipple Size :'
      end
      object StippleSizeLabel: TLabel
        Left = 240
        Top = 24
        Width = 21
        Height = 13
        Caption = '(0.5)'
      end
      object StippleStepperLabel: TLabel
        Left = 224
        Top = 60
        Width = 12
        Height = 13
        Caption = '(1)'
      end
      object StippleCountBtn: TSpeedButton
        Left = 264
        Top = 58
        Width = 23
        Height = 22
        Hint = 'Stipple Count'
        OnClick = StippleCountBtnClick
      end
      object StippleCountLabel: TLabel
        Left = 248
        Top = 60
        Width = 12
        Height = 13
        Caption = '(1)'
      end
      object CanvasLineSizeLabel: TLabel
        Left = 138
        Top = 92
        Width = 12
        Height = 13
        Caption = '(0)'
      end
      object Bevel1: TBevel
        Left = 8
        Top = 110
        Width = 281
        Height = 9
        Hint = 'Poly Gone'
        Shape = bsFrame
      end
      object Antialiase: TCheckBox
        Left = 8
        Top = 128
        Width = 81
        Height = 17
        Hint = 'Lines Smoothed'
        HelpContext = 6000
        Caption = 'Antialiased'
        TabOrder = 0
        OnClick = AntialiaseClick
      end
      object LineAlpha: TScrollBar
        Left = 8
        Top = 172
        Width = 121
        Height = 14
        HelpContext = 6000
        Max = 255
        PageSize = 0
        Position = 255
        TabOrder = 1
        OnChange = LineAlphaChange
      end
      object FillAlpha: TScrollBar
        Left = 8
        Top = 208
        Width = 121
        Height = 14
        HelpContext = 6000
        Max = 255
        PageSize = 0
        Position = 127
        TabOrder = 2
        OnChange = FillAlphaChange
      end
      object LineThickness: TScrollBar
        Left = 168
        Top = 202
        Width = 121
        Height = 16
        Hint = 'Change Thickness'
        HelpContext = 6000
        Max = 200
        Min = 1
        PageSize = 0
        Position = 10
        TabOrder = 3
        OnChange = LineThicknessChange
      end
      object ThickOutline: TCheckBox
        Left = 168
        Top = 176
        Width = 65
        Height = 17
        Hint = 'Variable Thickness'
        HelpContext = 6000
        Caption = 'Enabled'
        TabOrder = 4
        OnClick = LineThicknessChange
      end
      object OutlineColorPanel: TPanel
        Left = 168
        Top = 128
        Width = 121
        Height = 25
        Hint = 'Select Shape Layer Color'
        HelpContext = 6000
        Caption = 'Outline Color'
        TabOrder = 5
        OnClick = OutlineColorPanelClick
      end
      object LegendColorsPanel: TPanel
        Left = 10
        Top = 2
        Width = 105
        Height = 25
        Hint = 'Select Shape Layer Color'
        HelpContext = 6000
        Caption = 'All Shapes Color'
        TabOrder = 6
        OnClick = LegendColorsPanelClick
      end
      object GroupBox2: TGroupBox
        Left = 8
        Top = 224
        Width = 281
        Height = 65
        HelpContext = 6000
        Caption = '3D: Each Layer Object  ?ld / 1 Project Actor .qc filename'
        TabOrder = 7
        object ProjectSetotsFileBtn: TSpeedButton
          Left = 8
          Top = 16
          Width = 23
          Height = 22
          Hint = 'Set Layer.ots file'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = ProjectSetotsFileBtnClick
        end
        object ProjectActorotsFileBtn: TSpeedButton
          Left = 8
          Top = 40
          Width = 23
          Height = 22
          Hint = 'Set Actor.ots file'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = ProjectActorotsFileBtnClick
        end
        object OtsNameEditTextEdit: TEdit
          Left = 40
          Top = 16
          Width = 233
          Height = 21
          Hint = 'Each Layer has a 3d Object'
          HelpContext = 6000
          TabOrder = 0
        end
        object ProjectActorEdit: TEdit
          Left = 40
          Top = 40
          Width = 233
          Height = 21
          Hint = 'Only 1 Project (Actor)'
          HelpContext = 6000
          TabOrder = 1
        end
      end
      object PointSizeScrollBar: TScrollBar
        Left = 8
        Top = 88
        Width = 100
        Height = 16
        Hint = '1,3,5,7,...'
        HelpContext = 6000
        Max = 25
        PageSize = 0
        Position = 2
        TabOrder = 8
        OnChange = PointSizeScrollBarChange
      end
      object LineScrollBar: TScrollBar
        Left = 167
        Top = 40
        Width = 121
        Height = 16
        HelpContext = 6000
        PageSize = 0
        Position = 50
        TabOrder = 9
        OnChange = LineScrollBarChange
      end
      object LineStippledCB: TCheckBox
        Left = 168
        Top = 8
        Width = 97
        Height = 17
        HelpContext = 6000
        Caption = 'Line Stippled'
        TabOrder = 10
        OnClick = LineScrollBarChange
      end
      object Image32: TImage32
        Left = 168
        Top = 80
        Width = 120
        Height = 30
        HelpContext = 6000
        BitmapAlign = baTopLeft
        Scale = 1
        ScaleMode = smNormal
        TabOrder = 11
      end
      object StippleColorPanel: TPanel
        Left = 168
        Top = 56
        Width = 25
        Height = 25
        Hint = 'StippleColor'
        HelpContext = 6000
        TabOrder = 12
        OnClick = StippleColorPanelClick
      end
      object StippleStepper: TUpDown
        Left = 194
        Top = 60
        Width = 24
        Height = 16
        HelpContext = 6000
        Min = 0
        Max = 0
        Orientation = udHorizontal
        Position = 0
        TabOrder = 13
        Wrap = False
        OnClick = StippleStepperClick
      end
      object PointTypeRG: TRadioGroup
        Left = 8
        Top = 32
        Width = 144
        Height = 32
        Hint = 
          'Points: 1:Dot 2:Circle 3:DotInCircle 4:FilledCircle 5:PlusSign 6' +
          ':X 7:Box 8:XInBox 9:FilledBox'
        HelpContext = 6000
        Caption = 'Point Type'
        Columns = 9
        ItemIndex = 8
        Items.Strings = (
          '0'
          '1'
          '2'
          '3'
          '4'
          '5'
          '6'
          '7'
          '8')
        TabOrder = 14
        OnClick = PointTypeRGClick
      end
      object CanvasLineUpDown: TUpDown
        Left = 121
        Top = 86
        Width = 15
        Height = 21
        Hint = 'Point Symbol Line Width'
        HelpContext = 6000
        Min = 0
        Position = 4
        TabOrder = 15
        Wrap = False
        OnClick = CanvasLineUpDownClick
      end
      object PolyFilledCB: TCheckBox
        Left = 104
        Top = 120
        Width = 57
        Height = 17
        Hint = 'Fill takes time'
        Caption = 'Filled'
        TabOrder = 16
        OnClick = PolyFilledCBClick
      end
      object PolyPatternCB: TCheckBox
        Left = 104
        Top = 136
        Width = 57
        Height = 17
        Hint = 'Pattern takes LONG time'
        Caption = 'Pattern'
        TabOrder = 17
        OnClick = PolyFilledCBClick
      end
      object PolyEcotypeCB: TCheckBox
        Left = 104
        Top = 152
        Width = 57
        Height = 17
        Hint = 'Ecotype takes LONG time'
        Caption = 'Ecotype'
        TabOrder = 18
        OnClick = PolyFilledCBClick
      end
    end
    object TabSheet10: TTabSheet
      HelpContext = 6030
      Caption = 'Pattern'
      ImageIndex = 6
      object Label45: TLabel
        Left = 8
        Top = 8
        Width = 218
        Height = 13
        Caption = 'Shape Layer Pattern List (Shape Filename.pld)'
      end
      object PatternBtn: TSpeedButton
        Left = 8
        Top = 24
        Width = 23
        Height = 22
      end
      object Label46: TLabel
        Left = 24
        Top = 56
        Width = 179
        Height = 13
        Caption = 'Shape Layer Attributes: Object Types '
      end
      object Label47: TLabel
        Left = 48
        Top = 160
        Width = 18
        Height = 13
        Caption = '123'
      end
      object Label48: TLabel
        Left = 72
        Top = 160
        Width = 68
        Height = 13
        Caption = 'Current Object'
      end
      object Label49: TLabel
        Left = 32
        Top = 248
        Width = 208
        Height = 13
        Caption = 'Filename (*.png)  for Selected Attribute Type'
      end
      object PatternSatBtn: TSpeedButton
        Left = 8
        Top = 264
        Width = 23
        Height = 22
        OnClick = PatternSatBtnClick
      end
      object Image1: TImage
        Left = 168
        Top = 114
        Width = 128
        Height = 128
      end
      object Label52: TLabel
        Left = 72
        Top = 176
        Width = 69
        Height = 13
        Caption = 'Attribute Value'
      end
      object Label54: TLabel
        Left = 48
        Top = 176
        Width = 18
        Height = 13
        Caption = '123'
      end
      object Label53: TLabel
        Left = 72
        Top = 96
        Width = 89
        Height = 13
        Caption = '<= Total # of types'
      end
      object Label69: TLabel
        Left = 40
        Top = 96
        Width = 18
        Height = 13
        Caption = '123'
      end
      object PatternEdit: TEdit
        Left = 32
        Top = 24
        Width = 249
        Height = 21
        HelpContext = 6030
        TabOrder = 0
      end
      object PatternUpDown: TUpDown
        Left = 24
        Top = 168
        Width = 16
        Height = 24
        HelpContext = 6030
        Min = 0
        Position = 0
        TabOrder = 1
        Wrap = False
      end
      object PatternSatEdit: TEdit
        Left = 32
        Top = 264
        Width = 249
        Height = 21
        HelpContext = 6030
        TabOrder = 2
      end
      object PatternCBox: TCheckBox
        Left = 40
        Top = 224
        Width = 97
        Height = 17
        Caption = 'Display Image'
        TabOrder = 3
      end
      object PatternCB: TComboBox
        Left = 26
        Top = 68
        Width = 252
        Height = 21
        Hint = 'Select Current Layer'
        HelpContext = 6030
        ItemHeight = 13
        TabOrder = 4
        OnClick = LegendLayerCBClick
      end
    end
    object TabSheet4: TTabSheet
      HelpContext = 6060
      Caption = 'Ecotype'
      ImageIndex = 3
      object PageControl3: TPageControl
        Left = 12
        Top = 0
        Width = 289
        Height = 289
        HelpContext = 6060
        ActivePage = TabSheet11
        TabOrder = 0
        object TabSheet11: TTabSheet
          Caption = 'Ecotype List'
          object Label70: TLabel
            Left = 32
            Top = 152
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label71: TLabel
            Left = 64
            Top = 152
            Width = 158
            Height = 13
            Caption = '<= Current Layer Attribute VALUE'
          end
          object Label72: TLabel
            Left = 64
            Top = 136
            Width = 148
            Height = 13
            Caption = '<= Current # of Total # of types'
          end
          object Label73: TLabel
            Left = 32
            Top = 136
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label74: TLabel
            Left = 32
            Top = 112
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label75: TLabel
            Left = 64
            Top = 112
            Width = 89
            Height = 13
            Caption = '<= Total # of types'
          end
          object Label76: TLabel
            Left = 38
            Top = 64
            Width = 184
            Height = 13
            Caption = 'Shape Layer Attributes: Ecotype Types'
          end
          object EcotypeOpenBtn: TSpeedButton
            Left = 8
            Top = 24
            Width = 23
            Height = 22
          end
          object Label78: TLabel
            Left = 96
            Top = 172
            Width = 86
            Height = 13
            Caption = 'Ecotype ID (0..99)'
          end
          object Label79: TLabel
            Left = 8
            Top = 8
            Width = 226
            Height = 13
            Caption = 'Shape Layer Ecotype List (Shape Filename .eld)'
          end
          object EcotypeUpDown: TUpDown
            Left = 8
            Top = 144
            Width = 16
            Height = 24
            HelpContext = 6060
            Min = 0
            Position = 0
            TabOrder = 0
            Wrap = False
          end
          object EcotypeCB: TComboBox
            Left = 40
            Top = 80
            Width = 201
            Height = 21
            HelpContext = 6060
            ItemHeight = 13
            TabOrder = 1
          end
          object EcotypeEdit: TEdit
            Left = 40
            Top = 24
            Width = 201
            Height = 21
            HelpContext = 6060
            TabOrder = 2
          end
          object EcotypeIDEdit: TEdit
            Left = 32
            Top = 168
            Width = 50
            Height = 21
            HelpContext = 6060
            TabOrder = 3
          end
        end
        object TabSheet12: TTabSheet
          Caption = 'File Types Information'
          ImageIndex = 1
          object Label7: TLabel
            Left = 0
            Top = 0
            Width = 177
            Height = 13
            Caption = 'Digital Terain Map ( .dtm ) List of Stuff'
          end
          object Label2: TLabel
            Left = 0
            Top = 16
            Width = 142
            Height = 13
            Caption = 'Vector Raster Projection (.vrp)'
          end
          object Label1: TLabel
            Left = 0
            Top = 32
            Width = 190
            Height = 13
            Caption = 'Digital Terrain Project ( .dtp ) List of Stuff'
          end
          object Label63: TLabel
            Left = 16
            Top = 48
            Width = 124
            Height = 13
            Caption = 'Object + Texture Set (.ots)'
          end
          object Label61: TLabel
            Left = 32
            Top = 64
            Width = 119
            Height = 13
            Caption = 'Urban Buildings List (.uld)'
          end
          object Label60: TLabel
            Left = 32
            Top = 112
            Width = 81
            Height = 13
            Caption = 'Domain List (.dld)'
          end
          object Label59: TLabel
            Left = 16
            Top = 192
            Width = 79
            Height = 13
            Caption = 'Pattern List (.pld)'
          end
          object Label62: TLabel
            Left = 16
            Top = 208
            Width = 84
            Height = 13
            Caption = 'Ecotype List (.eld)'
          end
          object Label12: TLabel
            Left = 32
            Top = 224
            Width = 183
            Height = 13
            Caption = 'Ecotype Colors :Bitmaps + Data (*.eco)'
          end
          object EcotypeColorBtn: TSpeedButton
            Left = 32
            Top = 240
            Width = 193
            Height = 18
            Caption = 'Bitmap for Color Replacement'
            OnClick = EcotypeColorBtnClick
          end
          object Label14: TLabel
            Left = 136
            Top = 144
            Width = 127
            Height = 13
            Caption = '~VTP Bioregion,  Plant List'
          end
          object Label13: TLabel
            Left = 136
            Top = 176
            Width = 132
            Height = 13
            Caption = '~VTP Plant Instances: (*.vf)'
          end
          object Label80: TLabel
            Left = 64
            Top = 160
            Width = 167
            Height = 13
            Caption = 'Vegetation Plants List .vld Filename'
          end
          object Label81: TLabel
            Left = 48
            Top = 128
            Width = 83
            Height = 13
            Caption = 'Bioregion List .bld'
          end
          object Label82: TLabel
            Left = 48
            Top = 80
            Width = 117
            Height = 13
            Caption = '3DS/dxf?, or VTP (.vst2)'
          end
          object Label83: TLabel
            Left = 48
            Top = 96
            Width = 137
            Height = 13
            Caption = 'or Procedural  L-System (.pls)'
          end
        end
      end
    end
    object TabSheet2: TTabSheet
      HelpContext = 6100
      Caption = '.ots'
      ImageIndex = 1
      object GroupBox4: TGroupBox
        Left = 8
        Top = 8
        Width = 281
        Height = 273
        HelpContext = 6100
        Caption = 'Object + Texture Set (.ots)'
        TabOrder = 0
        object OpenTextureBtn: TSpeedButton
          Left = 32
          Top = 195
          Width = 23
          Height = 22
          Hint = 'Object Texture'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = OpenTextureBtnClick
        end
        object OpenActorBtn: TSpeedButton
          Left = 16
          Top = 128
          Width = 23
          Height = 22
          Hint = 'File name'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = OpenActorBtnClick
        end
        object OpenSetBtn: TSpeedButton
          Left = 8
          Top = 16
          Width = 23
          Height = 22
          Hint = 'Open Set.ots file'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = OpenSetBtnClick
        end
        object SaveSetBtn: TSpeedButton
          Left = 240
          Top = 16
          Width = 23
          Height = 22
          Hint = 'Save Set.ots file'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00333333333333
            333333FFFFFFFFFFFFF33000077777770033377777777777773F000007888888
            00037F3337F3FF37F37F00000780088800037F3337F77F37F37F000007800888
            00037F3337F77FF7F37F00000788888800037F3337777777337F000000000000
            00037F3FFFFFFFFFFF7F00000000000000037F77777777777F7F000FFFFFFFFF
            00037F7F333333337F7F000FFFFFFFFF00037F7F333333337F7F000FFFFFFFFF
            00037F7F333333337F7F000FFFFFFFFF00037F7F333333337F7F000FFFFFFFFF
            00037F7F333333337F7F000FFFFFFFFF07037F7F33333333777F000FFFFFFFFF
            0003737FFFFFFFFF7F7330099999999900333777777777777733}
          NumGlyphs = 2
          OnClick = SaveSetBtnClick
        end
        object OpenWpnBtn: TSpeedButton
          Left = 72
          Top = 219
          Width = 23
          Height = 22
          Hint = 'Actors Weapon File'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = OpenWpnBtnClick
        end
        object OpenWpnTextureBtn: TSpeedButton
          Left = 72
          Top = 243
          Width = 23
          Height = 22
          Hint = 'Actors Weapon Texture'
          Glyph.Data = {
            76010000424D7601000000000000760000002800000020000000100000000100
            04000000000000010000120B0000120B00001000000000000000000000000000
            800000800000008080008000000080008000808000007F7F7F00BFBFBF000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00555555555555
            5555555555555555555555555555555555555555555555555555555555555555
            555555555555555555555555555555555555555FFFFFFFFFF555550000000000
            55555577777777775F55500B8B8B8B8B05555775F555555575F550F0B8B8B8B8
            B05557F75F555555575F50BF0B8B8B8B8B0557F575FFFFFFFF7F50FBF0000000
            000557F557777777777550BFBFBFBFB0555557F555555557F55550FBFBFBFBF0
            555557F555555FF7555550BFBFBF00055555575F555577755555550BFBF05555
            55555575FFF75555555555700007555555555557777555555555555555555555
            5555555555555555555555555555555555555555555555555555}
          NumGlyphs = 2
          OnClick = OpenWpnTextureBtnClick
        end
        object Label11: TLabel
          Left = 32
          Top = 152
          Width = 222
          Height = 13
          Caption = 'Actor - Object Height (or Line Length) in Meters'
        end
        object Label5: TLabel
          Left = 40
          Top = 40
          Width = 156
          Height = 13
          Caption = 'Check Box Checked: [Actor .qc] '
        end
        object Label43: TLabel
          Left = 40
          Top = 88
          Width = 67
          Height = 13
          Caption = 'or [Plants .vld]'
        end
        object Label50: TLabel
          Left = 40
          Top = 72
          Width = 91
          Height = 13
          Caption = 'or Texture Billboard'
        end
        object Label51: TLabel
          Left = 40
          Top = 104
          Width = 112
          Height = 13
          Caption = 'or [Urban Buildings .bld]'
        end
        object Label84: TLabel
          Left = 40
          Top = 56
          Width = 83
          Height = 13
          Caption = 'or [Shape Object]'
        end
        object OtsNameEdit: TEdit
          Left = 32
          Top = 16
          Width = 201
          Height = 21
          HelpContext = 6100
          TabOrder = 0
        end
        object ActorFileNameEdit: TEdit
          Left = 40
          Top = 128
          Width = 201
          Height = 21
          HelpContext = 6100
          TabOrder = 1
        end
        object TextureFileNameEdit: TEdit
          Left = 56
          Top = 196
          Width = 201
          Height = 21
          HelpContext = 6100
          TabOrder = 2
        end
        object WeaponFileNameEdit: TEdit
          Left = 96
          Top = 220
          Width = 161
          Height = 21
          HelpContext = 6100
          TabOrder = 3
        end
        object WpnTextureFileNameEdit: TEdit
          Left = 96
          Top = 244
          Width = 161
          Height = 21
          HelpContext = 6100
          TabOrder = 4
        end
        object ActorCB: TCheckBox
          Left = 16
          Top = 40
          Width = 17
          Height = 17
          Hint = 'Actor (md2 smd) else Object (3ds dxf) Directory'
          HelpContext = 6100
          TabOrder = 5
        end
        object TextureOnlyCB: TCheckBox
          Left = 16
          Top = 72
          Width = 17
          Height = 17
          Hint = 'Object is 1 Billboard Texture ONLY'
          HelpContext = 6100
          TabOrder = 6
        end
        object OtsSizeEdit: TEdit
          Left = 32
          Top = 168
          Width = 49
          Height = 21
          HelpContext = 6100
          TabOrder = 7
          Text = '1.7'
        end
        object BuildingCB: TCheckBox
          Left = 16
          Top = 104
          Width = 17
          Height = 17
          Hint = 'Object is Buildings List (.bld)'
          HelpContext = 6100
          TabOrder = 8
        end
        object PlantsCB: TCheckBox
          Left = 16
          Top = 88
          Width = 17
          Height = 17
          Hint = 'Object is Areal Vegetation (Plants)'
          HelpContext = 6100
          TabOrder = 9
        end
        object ObjectCB: TCheckBox
          Left = 16
          Top = 56
          Width = 17
          Height = 17
          Hint = 'Object (3ds dxf) Directory'
          HelpContext = 6100
          TabOrder = 10
        end
      end
    end
    object TabSheet5: TTabSheet
      Caption = 'Plants'
      ImageIndex = 4
      object PageControl2: TPageControl
        Left = 12
        Top = 0
        Width = 289
        Height = 289
        HelpContext = 6130
        ActivePage = TabSheet6
        TabOrder = 0
        object TabSheet6: TTabSheet
          HelpContext = 6130
          Caption = 'Domain'
          object DomainFilenameBtn: TSpeedButton
            Left = 8
            Top = 192
            Width = 23
            Height = 22
            Caption = 'bld'
          end
          object Label37: TLabel
            Left = 16
            Top = 176
            Width = 229
            Height = 13
            Caption = 'Filename of Each BioRegion Filename in Domain'
          end
          object Label38: TLabel
            Left = 64
            Top = 152
            Width = 183
            Height = 13
            Caption = '<= Current Vegetation Attribute VALUE'
          end
          object Label39: TLabel
            Left = 32
            Top = 152
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label40: TLabel
            Left = 6
            Top = 64
            Width = 245
            Height = 13
            Caption = 'Shape Layer Attributes: Vegetation/Bioregion Types'
          end
          object DomainOpenBtn: TSpeedButton
            Left = 8
            Top = 24
            Width = 23
            Height = 22
            Caption = 'dld'
          end
          object Label41: TLabel
            Left = 40
            Top = 8
            Width = 160
            Height = 13
            Caption = '.ots Object is Vegetation List (.dld)'
          end
          object Label42: TLabel
            Left = 64
            Top = 112
            Width = 89
            Height = 13
            Caption = '<= Total # of types'
          end
          object Label56: TLabel
            Left = 32
            Top = 112
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label57: TLabel
            Left = 32
            Top = 136
            Width = 18
            Height = 13
            Caption = '123'
          end
          object Label58: TLabel
            Left = 64
            Top = 136
            Width = 148
            Height = 13
            Caption = '<= Current # of Total # of types'
          end
          object DomainFilenameEdit: TEdit
            Left = 40
            Top = 192
            Width = 201
            Height = 21
            HelpContext = 6130
            TabOrder = 0
          end
          object DomainUpDown: TUpDown
            Left = 8
            Top = 144
            Width = 16
            Height = 24
            HelpContext = 6130
            Min = 0
            Position = 0
            TabOrder = 1
            Wrap = False
          end
          object DomainEdit: TEdit
            Left = 40
            Top = 24
            Width = 201
            Height = 21
            HelpContext = 6130
            TabOrder = 2
          end
          object DomainCB: TComboBox
            Left = 40
            Top = 80
            Width = 201
            Height = 21
            HelpContext = 6130
            ItemHeight = 13
            TabOrder = 3
          end
        end
        object TabSheet7: TTabSheet
          HelpContext = 6130
          Caption = 'Bioregion'
          ImageIndex = 1
          object BioregionBtn: TSpeedButton
            Left = 16
            Top = 8
            Width = 23
            Height = 22
            Caption = 'bld'
          end
          object Label25: TLabel
            Left = 24
            Top = 144
            Width = 99
            Height = 13
            Caption = 'Plant Common Name'
          end
          object Label26: TLabel
            Left = 48
            Top = 40
            Width = 89
            Height = 13
            Caption = 'Number of Groups:'
          end
          object Label27: TLabel
            Left = 48
            Top = 72
            Width = 84
            Height = 13
            Caption = 'Number of Plants:'
          end
          object Label28: TLabel
            Left = 144
            Top = 40
            Width = 6
            Height = 13
            Caption = '1'
          end
          object Label29: TLabel
            Left = 136
            Top = 72
            Width = 6
            Height = 13
            Caption = '1'
          end
          object Label30: TLabel
            Left = 24
            Top = 184
            Width = 89
            Height = 13
            Caption = 'Density  (0.012345'
          end
          object Label31: TLabel
            Left = 24
            Top = 104
            Width = 52
            Height = 13
            Caption = 'Species ID'
          end
          object BioregionEdit: TEdit
            Left = 40
            Top = 8
            Width = 233
            Height = 21
            Hint = 'Bioregion .bld Filename'
            HelpContext = 6130
            TabOrder = 0
          end
          object BioregionGroupUpDown: TUpDown
            Left = 24
            Top = 32
            Width = 16
            Height = 24
            HelpContext = 6130
            Min = 0
            Position = 0
            TabOrder = 1
            Wrap = False
          end
          object BioregionPlantsUpDown: TUpDown
            Left = 24
            Top = 64
            Width = 16
            Height = 24
            HelpContext = 6130
            Min = 0
            Position = 0
            TabOrder = 2
            Wrap = False
          end
          object BioregionPCNEdit: TEdit
            Left = 24
            Top = 160
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 3
          end
          object BioregionDensityEdit: TEdit
            Left = 24
            Top = 200
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 4
          end
          object BioregionSIDEdit: TEdit
            Left = 24
            Top = 120
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 5
          end
        end
        object TabSheet8: TTabSheet
          Caption = 'Vegetation'
          ImageIndex = 2
          object Label15: TLabel
            Left = 32
            Top = 28
            Width = 52
            Height = 13
            Caption = 'Species ID'
          end
          object Label16: TLabel
            Left = 20
            Top = 52
            Width = 72
            Height = 13
            Caption = 'Common Name'
          end
          object Label17: TLabel
            Left = 22
            Top = 76
            Width = 70
            Height = 13
            Caption = 'Science Name'
          end
          object Label18: TLabel
            Left = 16
            Top = 140
            Width = 79
            Height = 13
            Caption = 'Image File Name'
          end
          object Label19: TLabel
            Left = 0
            Top = 100
            Width = 92
            Height = 13
            Caption = 'Number of Samples'
          end
          object Label20: TLabel
            Left = 24
            Top = 120
            Width = 77
            Height = 13
            Caption = 'Sample Image #'
          end
          object Label21: TLabel
            Left = 72
            Top = 164
            Width = 28
            Height = 13
            Caption = 'Width'
          end
          object Label22: TLabel
            Left = 69
            Top = 191
            Width = 31
            Height = 13
            Caption = 'Height'
          end
          object Label23: TLabel
            Left = 25
            Top = 217
            Width = 75
            Height = 13
            Caption = 'Shadow Radius'
          end
          object Label24: TLabel
            Left = 13
            Top = 244
            Width = 87
            Height = 13
            Caption = 'Shadow Darkness'
          end
          object Label44: TLabel
            Left = 153
            Top = 28
            Width = 51
            Height = 13
            Caption = 'USNVC ID'
          end
          object VegOpenBtn: TSpeedButton
            Left = 16
            Top = 2
            Width = 23
            Height = 22
            Caption = 'vld'
          end
          object VegIfnBtn: TSpeedButton
            Left = 112
            Top = 136
            Width = 23
            Height = 22
          end
          object Label55: TLabel
            Left = 112
            Top = 120
            Width = 6
            Height = 13
            Caption = '1'
          end
          object VegEdit: TEdit
            Left = 40
            Top = 2
            Width = 233
            Height = 21
            Hint = 'Vegetation List .vld Filename'
            HelpContext = 6130
            TabOrder = 0
          end
          object VegSampleUpDown: TUpDown
            Left = 0
            Top = 120
            Width = 16
            Height = 24
            HelpContext = 6130
            Min = 0
            Position = 0
            TabOrder = 1
            Wrap = False
          end
          object VegIfnEdit: TEdit
            Left = 136
            Top = 136
            Width = 121
            Height = 21
            Hint = 'Image File name .png'
            HelpContext = 6130
            TabOrder = 2
          end
          object VegSpeciesUpDown: TUpDown
            Left = 0
            Top = 24
            Width = 16
            Height = 24
            HelpContext = 6130
            Min = 0
            Position = 0
            TabOrder = 3
            Wrap = False
          end
          object VegSidEdit: TEdit
            Left = 96
            Top = 24
            Width = 50
            Height = 21
            HelpContext = 6130
            TabOrder = 4
          end
          object VegUidEdit: TEdit
            Left = 208
            Top = 24
            Width = 65
            Height = 21
            HelpContext = 6130
            TabOrder = 5
          end
          object VegCnEdit: TEdit
            Left = 96
            Top = 48
            Width = 177
            Height = 21
            HelpContext = 6130
            TabOrder = 6
          end
          object VegSnEdit: TEdit
            Left = 96
            Top = 72
            Width = 177
            Height = 21
            HelpContext = 6130
            TabOrder = 7
          end
          object VegWidthEdit: TEdit
            Left = 112
            Top = 160
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 8
          end
          object VegHeightEdit: TEdit
            Left = 112
            Top = 187
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 9
          end
          object VegSrEdit: TEdit
            Left = 112
            Top = 213
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 10
          end
          object VegSdEdit: TEdit
            Left = 112
            Top = 240
            Width = 121
            Height = 21
            HelpContext = 6130
            TabOrder = 11
          end
          object VegNosEdit: TEdit
            Left = 96
            Top = 96
            Width = 49
            Height = 21
            HelpContext = 6130
            TabOrder = 12
          end
        end
      end
    end
    object TabSheet9: TTabSheet
      HelpContext = 6160
      Caption = 'Urban'
      ImageIndex = 5
      object Label32: TLabel
        Left = 16
        Top = 8
        Width = 259
        Height = 13
        Caption = 'Shape Layer Attributes: Building Types (and # of types)'
      end
      object Label33: TLabel
        Left = 32
        Top = 200
        Width = 259
        Height = 13
        Caption = 'List of Filenames (*.???)  for Each building and/or Type'
      end
      object UrbanFilenameBtn: TSpeedButton
        Left = 24
        Top = 216
        Width = 23
        Height = 22
      end
      object Label34: TLabel
        Left = 80
        Top = 176
        Width = 161
        Height = 13
        Caption = '<= Current Building Attribute Value'
      end
      object Label35: TLabel
        Left = 48
        Top = 176
        Width = 18
        Height = 13
        Caption = '123'
      end
      object UrbanOpenBtn: TSpeedButton
        Left = 24
        Top = 48
        Width = 23
        Height = 22
        Caption = 'uld'
      end
      object Label36: TLabel
        Left = 56
        Top = 32
        Width = 151
        Height = 13
        Caption = '.ots Object is Buildings List (.uld)'
      end
      object Label64: TLabel
        Left = 48
        Top = 160
        Width = 18
        Height = 13
        Caption = '123'
      end
      object Label65: TLabel
        Left = 80
        Top = 160
        Width = 148
        Height = 13
        Caption = '<= Current # of Total # of types'
      end
      object Label66: TLabel
        Left = 80
        Top = 136
        Width = 89
        Height = 13
        Caption = '<= Total # of types'
      end
      object Label67: TLabel
        Left = 48
        Top = 136
        Width = 18
        Height = 13
        Caption = '123'
      end
      object Label68: TLabel
        Left = 54
        Top = 88
        Width = 182
        Height = 13
        Caption = 'Shape Layer Attributes: Urban Building'
      end
      object Label77: TLabel
        Left = 24
        Top = 248
        Width = 257
        Height = 13
        Caption = '3DS/dxf?, or VTP (.vst2) or Procedural  L-System (.pls)'
      end
      object UrbanFilenameEdit: TEdit
        Left = 56
        Top = 216
        Width = 201
        Height = 21
        HelpContext = 6160
        TabOrder = 0
      end
      object UrbanUpDown: TUpDown
        Left = 24
        Top = 168
        Width = 16
        Height = 24
        HelpContext = 6160
        Min = 0
        Position = 0
        TabOrder = 1
        Wrap = False
      end
      object UrbanEdit: TEdit
        Left = 56
        Top = 48
        Width = 193
        Height = 21
        HelpContext = 6160
        TabOrder = 2
      end
      object UrbanCB: TComboBox
        Left = 56
        Top = 104
        Width = 201
        Height = 21
        HelpContext = 6160
        ItemHeight = 13
        TabOrder = 3
      end
    end
    object TabSheet1: TTabSheet
      HelpContext = 6200
      Caption = 'HTFix'
      object DoDatumBtn: TSpeedButton
        Left = 248
        Top = 124
        Width = 23
        Height = 22
        Hint = 'Change Layer Datum to WGS84'
        OnClick = DoDatumBtnClick
      end
      object GroupBox3: TGroupBox
        Left = 8
        Top = 0
        Width = 281
        Height = 121
        HelpContext = 6200
        Caption = 'HTF Coordinate Range'
        TabOrder = 0
        object SetHTFBtn: TSpeedButton
          Left = 16
          Top = 72
          Width = 249
          Height = 22
          Caption = 'Set (X,Y) Distance of HTF'
          OnClick = SetHTFBtnClick
        end
        object HTFYLabel: TLabel
          Left = 144
          Top = 16
          Width = 54
          Height = 13
          Caption = 'HTFYLabel'
        end
        object HTFXLabel: TLabel
          Left = 16
          Top = 16
          Width = 54
          Height = 13
          Caption = 'HTFXLabel'
        end
        object XLabel: TLabel
          Left = 16
          Top = 104
          Width = 33
          Height = 13
          Caption = 'XLabel'
        end
        object X2Label: TLabel
          Left = 104
          Top = 104
          Width = 26
          Height = 13
          Caption = 'Label'
        end
        object HTFXEdit: TEdit
          Left = 16
          Top = 40
          Width = 121
          Height = 21
          HelpContext = 6200
          TabOrder = 0
        end
        object HTFYEdit: TEdit
          Left = 144
          Top = 40
          Width = 121
          Height = 21
          HelpContext = 6200
          TabOrder = 1
        end
      end
      object GroupBox1: TGroupBox
        Left = 8
        Top = 152
        Width = 281
        Height = 121
        HelpContext = 6200
        Caption = '(Shape Shifter) Corrections '
        TabOrder = 1
        object XUpBtn: TSpeedButton
          Left = 16
          Top = 24
          Width = 33
          Height = 25
          Caption = 'X+'
          OnClick = XUpBtnClick
        end
        object XDownBtn: TSpeedButton
          Left = 48
          Top = 24
          Width = 33
          Height = 25
          Caption = 'X -'
          OnClick = XDownBtnClick
        end
        object YUpBtn: TSpeedButton
          Left = 16
          Top = 56
          Width = 33
          Height = 25
          Caption = 'Y+'
          OnClick = YUPBtnClick
        end
        object YDownBtn: TSpeedButton
          Left = 48
          Top = 56
          Width = 33
          Height = 25
          Caption = 'Y-'
          OnClick = YDownBtnClick
        end
        object SetBtn: TSpeedButton
          Left = 93
          Top = 88
          Width = 44
          Height = 25
          Hint = 'Set Shift'
          Caption = 'Set'
          OnClick = SetBtnClick
        end
        object ReSetBtn: TSpeedButton
          Left = 139
          Top = 88
          Width = 49
          Height = 25
          Hint = 'ReSet Shift'
          Caption = 'Re Set'
          OnClick = ReSetBtnClick
        end
        object XLonEdit: TEdit
          Left = 88
          Top = 24
          Width = 177
          Height = 21
          HelpContext = 6200
          TabOrder = 0
        end
        object YLatEdit: TEdit
          Left = 88
          Top = 56
          Width = 177
          Height = 21
          HelpContext = 6200
          TabOrder = 1
        end
        object HelpBtn: TBitBtn
          Left = 16
          Top = 88
          Width = 75
          Height = 25
          HelpContext = 6200
          TabOrder = 2
          OnClick = HelpBtnClick
          Kind = bkHelp
        end
        object CloseBtn: TBitBtn
          Left = 190
          Top = 88
          Width = 75
          Height = 25
          HelpContext = 6200
          Caption = '&Close'
          ModalResult = 2
          TabOrder = 3
          Glyph.Data = {
            DE010000424DDE01000000000000760000002800000024000000120000000100
            0400000000006801000000000000000000001000000000000000000000000000
            80000080000000808000800000008000800080800000C0C0C000808080000000
            FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00388888888877
            F7F787F8888888888333333F00004444400888FFF444448888888888F333FF8F
            000033334D5007FFF4333388888888883338888F0000333345D50FFFF4333333
            338F888F3338F33F000033334D5D0FFFF43333333388788F3338F33F00003333
            45D50FEFE4333333338F878F3338F33F000033334D5D0FFFF43333333388788F
            3338F33F0000333345D50FEFE4333333338F878F3338F33F000033334D5D0FFF
            F43333333388788F3338F33F0000333345D50FEFE4333333338F878F3338F33F
            000033334D5D0EFEF43333333388788F3338F33F0000333345D50FEFE4333333
            338F878F3338F33F000033334D5D0EFEF43333333388788F3338F33F00003333
            4444444444333333338F8F8FFFF8F33F00003333333333333333333333888888
            8888333F00003333330000003333333333333FFFFFF3333F00003333330AAAA0
            333333333333888888F3333F00003333330000003333333333338FFFF8F3333F
            0000}
          NumGlyphs = 2
        end
      end
      object InDatumCB: TComboBox
        Left = 24
        Top = 124
        Width = 217
        Height = 21
        Hint = 'Current Layer Datum'
        HelpContext = 6200
        ItemHeight = 13
        TabOrder = 2
        Items.Strings = (
          'ADINDAN'
          'ARC1950'
          'ARC1960'
          'AUSTRALIAN_GEODETIC_1966'
          'AUSTRALIAN_GEODETIC_1984'
          'CAMP_AREA_ASTRO'
          'CAPE'
          'EUROPEAN_DATUM_1950'
          'EUROPEAN_DATUM_1979'
          'GEODETIC_DATUM_1949'
          'HONG_KONG_1963'
          'HU_TZU_SHAN'
          'INDIAN'
          'NAD27'
          'NAD83'
          'OLD_HAWAIIAN_MEAN'
          'OMAN'
          'ORDNANCE_SURVEY_1936'
          'PUERTO_RICO'
          'PULKOVO_1942'
          'PROVISIONAL_S_AMERICAN_1956'
          'TOKYO'
          'WGS_72'
          'WGS_84'
          'UNKNOWN_DATUM-1'
          'NO_DATUM-2')
      end
    end
  end
  object Panel1: TPanel
    Left = 0
    Top = 0
    Width = 312
    Height = 41
    HelpContext = 6000
    Align = alTop
    TabOrder = 1
    object Label9: TLabel
      Left = 24
      Top = 26
      Width = 61
      Height = 13
      Caption = 'Shape Type:'
    end
    object ShapeTypeLabel: TLabel
      Left = 96
      Top = 26
      Width = 20
      Height = 13
      Caption = 'Line'
    end
    object ViewChangesBtn: TSpeedButton
      Left = 176
      Top = 24
      Width = 102
      Height = 17
      Hint = 'View Changes'
      Caption = 'View Changes'
      OnClick = ViewChangesBtnClick
    end
    object DtpHelpBtn: TSpeedButton
      Left = 2
      Top = 4
      Width = 23
      Height = 22
      Glyph.Data = {
        BE060000424DBE06000000000000360400002800000024000000120000000100
        0800000000008802000000000000000000000001000000000000000000000000
        BF0000BF000000BFBF00BF000000BF00BF00BFBF0000C0C0C000C0DCC000F0C8
        A400000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        0000000000000000000000000000000000000000000000000000000000000000
        000000000000000000000000000000000000F0FBFF00A4A0A000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00030303030303
        03030606030303030303030303030303030303FFFF0303030303030303030303
        0303030303060404060303030303030303030303030303F8F8FF030303030303
        030303030303030303FE06060403030303030303030303030303F8FF03F8FF03
        0303030303030303030303030303FE060603030303030303030303030303F8FF
        FFF8FF0303030303030303030303030303030303030303030303030303030303
        030303F8F8030303030303030303030303030303030304040603030303030303
        0303030303030303FFFF03030303030303030303030303030306060604030303
        0303030303030303030303F8F8F8FF0303030303030303030303030303FE0606
        0403030303030303030303030303F8FF03F8FF03030303030303030303030303
        03FE06060604030303030303030303030303F8FF03F8FF030303030303030303
        030303030303FE060606040303030303030303030303F8FF0303F8FF03030303
        0303030303030303030303FE060606040303030303030303030303F8FF0303F8
        FF030303030303030303030404030303FE060606040303030303030303FF0303
        F8FF0303F8FF030303030303030306060604030303FE06060403030303030303
        F8F8FF0303F8FF0303F8FF03030303030303FE06060604040406060604030303
        030303F8FF03F8FFFFFFF80303F8FF0303030303030303FE0606060606060606
        06030303030303F8FF0303F8F8F8030303F8FF030303030303030303FEFE0606
        060606060303030303030303F8FFFF030303030303F803030303030303030303
        0303FEFEFEFEFE03030303030303030303F8F8FFFFFFFFFFF803030303030303
        0303030303030303030303030303030303030303030303F8F8F8F8F803030303
        0303}
      NumGlyphs = 2
      OnClick = DtpHelpBtnClick
    end
    object DtpExitBtn: TSpeedButton
      Left = 280
      Top = 4
      Width = 23
      Height = 22
      Glyph.Data = {
        DE010000424DDE01000000000000760000002800000024000000120000000100
        0400000000006801000000000000000000001000000000000000000000000000
        80000080000000808000800000008000800080800000C0C0C000808080000000
        FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF00388888888877
        F7F787F8888888888333333F00004444400888FFF444448888888888F333FF8F
        000033334D5007FFF4333388888888883338888F0000333345D50FFFF4333333
        338F888F3338F33F000033334D5D0FFFF43333333388788F3338F33F00003333
        45D50FEFE4333333338F878F3338F33F000033334D5D0FFFF43333333388788F
        3338F33F0000333345D50FEFE4333333338F878F3338F33F000033334D5D0FFF
        F43333333388788F3338F33F0000333345D50FEFE4333333338F878F3338F33F
        000033334D5D0EFEF43333333388788F3338F33F0000333345D50FEFE4333333
        338F878F3338F33F000033334D5D0EFEF43333333388788F3338F33F00003333
        4444444444333333338F8F8FFFF8F33F00003333333333333333333333888888
        8888333F00003333330000003333333333333FFFFFF3333F00003333330AAAA0
        333333333333888888F3333F00003333330000003333333333338FFFF8F3333F
        0000}
      NumGlyphs = 2
      OnClick = DtpExitBtnClick
    end
    object LegendLayerCB: TComboBox
      Left = 26
      Top = 4
      Width = 252
      Height = 21
      Hint = 'Select Current Layer'
      HelpContext = 6000
      ItemHeight = 13
      TabOrder = 0
      OnClick = LegendLayerCBClick
    end
  end
  object ColorDialog1: TColorDialog
    Ctl3D = True
    Left = 144
    Top = 328
  end
  object OpenDialog: TOpenDialog
    Filter = 
      '3DS, OBJ, TIN, PLY, STL|*.3DS;*. OBJ;*.TIN;*.PLY;*.STL|SMD, MD2|' +
      '*. SMD;*. MD2'
    Options = [ofHideReadOnly, ofPathMustExist, ofFileMustExist, ofEnableSizing]
    Left = 180
    Top = 328
  end
  object SaveDialog1: TSaveDialog
    DefaultExt = 'ots'
    Left = 252
    Top = 328
  end
  object OpenPictureDialog1: TOpenPictureDialog
    Options = [ofHideReadOnly, ofPathMustExist, ofFileMustExist, ofEnableSizing]
    Left = 212
    Top = 328
  end
end
