unit dtmAbout;
(***************************************************************
 *                                                             *
 *        Image Locatable Holographics      Version 3.0.0.0    *
 *                                                             *
 *        Copyright (C) 1991,2002 by   Tachyon Software, Inc.  *
 *                                                             *
 *                                                             *
{. $IFDEF DO87}
{. $F+,O+,X+,I-}
{. $N+,E-,R-,D-,S-}
{. $B-,A+,W+,L-,V-,G+}
{. $ELSE}
{. $F+,O+,X+,I-}
{. $N-,E-,R-,D-,S-}
{. $B-,A+,W+,L-,V-,G+}
{. $ENDIF}
 ***************************************************************)



interface

uses Windows, SysUtils, Classes, Registry,
  Graphics, Forms, Controls, StdCtrls,
  ShellAPI, Dialogs, Buttons, ExtCtrls, Consts;

type
  TAboutDTM = class(TForm)
    Panel1: TPanel;
    Version: TLabel;
    Copyright: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    BuildInfo: TLabel;
    Label12: TLabel;
    PhysMem: TLabel;
    Label13: TLabel;
    FreeRes: TLabel;
    Label10: TLabel;
    Label16: TLabel;
    WindowsVersion: TLabel;
    Label4: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    SystemInformationBtn: TSpeedButton;
    Bevel1: TBevel;
    DelphiButton: TSpeedButton;
    Label14: TLabel;
    Licensee: TLabel;
    Label15: TLabel;
    RNEdit: TEdit;
    HelpBtn: TSpeedButton;
    AboutBtn: TSpeedButton;
    LicenseBtn: TSpeedButton;
    RegisterBtn: TSpeedButton;
    Panel2: TPanel;
    Image3: TImage;
    Label8: TLabel;
    ProgramInformationBtn: TSpeedButton;
    OrganizationLabel: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure ProgramIconClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LoadEdits;
    procedure GetBuildInfo(var v1, v2, v3, v4: Word);
    function GetBuildInfoString: string;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label2Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure SystemInformationBtnClick(Sender: TObject);
    procedure DelphiButtonClick(Sender: TObject);
    procedure RegisterBtnClick(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure ProgramInformationBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutDTM: TAboutDTM;

implementation
uses dtmSysInfo,
dtmErrMsg,
dtmPOFvar, dtmGlobals, dtmfrm;
{$R *.DFM}

procedure TAboutDTM.FormClose(Sender: TObject; var Action:
  TCloseAction);
begin {}
  AboutX := AboutDTM.left;
  AboutY := AboutDTM.top;
  DoSaver;
  ModalResult := mrOK;
end;

procedure TAboutDTM.FormCreate(Sender: TObject);
var
  MS: TMemoryStatus;
begin
  left := AboutX;
  top := AboutY;
  GlobalMemoryStatus(MS);
  PhysMem.Caption := FormatFloat('#,###" KB"', MS.dwTotalPhys /
    1024);
  FreeRes.Caption := Format('%d %%', [MS.dwMemoryLoad]);
  RNEdit.Text := StartedNameNumber;
  LoadEdits;
end;


procedure TAboutDTM.BitBtn1Click(Sender: TObject);
begin
  Application.HelpContext(222);
end;
                    {Readme}

procedure TAboutDTM.ProgramIconClick(Sender: TObject);
var PathS: string;
begin
  PathS := ExtractFilePath(Application.EXEName);
  if FileExists(PathS + 'dtm.html') then
    ExecuteFile('dtm.html', '', PathS, SW_SHOW) else
    DoMessages(20003);{20003, "Readme.txt Files not found"}
end;

                    {License}

procedure TAboutDTM.Image1Click(Sender: TObject);
var PathS: string;
begin
  PathS := ExtractFilePath(Application.EXEName);
  if FileExists(PathS + 'license.doc') then
    ExecuteFile('license.doc', '', PathS, SW_SHOW) else
    DoMessages(20002);
end;

procedure TAboutDTM.RegisterBtnClick(Sender: TObject);
var PathS: string;
begin
  PathS := ExtractFilePath(Application.EXEName);
  if FileExists(PathS + 'order.txt') then
    ExecuteFile('order.txt', '', PathS, SW_SHOW) else
    DoMessages(20001);
end;

          {Order form}

procedure TAboutDTM.LoadEdits;
const
  Win95RegInfo = 'SOFTWARE\Microsoft\Windows\CurrentVersion\';
var
  OsVersionInfo: TOsVersionInfo;
  Reg: TRegistry;
{dc : HDC;}
begin
{ Fetch registered user name from Win95 Registry }
  Reg := TRegistry.Create;
  with Reg do begin
    RootKey := HKEY_LOCAL_MACHINE;
    if KeyExists(Win95RegInfo) then begin
      OpenKey(Win95RegInfo, False);
      Licensee.Caption := ReadString('RegisteredOwner');
      OrganizationLabel.Caption :=
        ReadString('RegisteredOrganization');
    end
    else DoMessages(29976);
    Free;
  end; { with }
  OsVersionInfo.dwOSVersionInfoSize := sizeof(OsVersionInfo);
  GetVersionEx(OsVersionInfo);
  with OsVersionInfo do
  begin
    WindowsVersion.Caption := (IntToStr(dwMajorVersion) + '.'
      + IntToStr(dwMinorVersion));
{WORD HIWORD(DWORD dwValue ); // value from which high-order word is retrieved
LOWORD...}
  end;
  BuildInfo.Caption := GetBuildInfoString
end; {Of Getting ... Load}




procedure TAboutDTM.GetBuildInfo(var v1, v2, v3, v4: Word);
var
  VerInfoSize: DWord;
  VerInfo: Pointer;
  VerValueSize: DWord;
  VerValue: PVSFixedFileInfo;
  Dummy: DWord;
begin
  VerInfoSize := GetFileVersionInfoSize(PChar(Application.ExeName),
    dummy);
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(Application.ExeName), 0, VerInfoSize,
    VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue), VerValueSize);
  with VerValue^ do
  begin
    v1 := dwFileVersionMS shr 16;
    v2 := dwFileVersionMS and $FFFF;
    v3 := dwFileVersionLS shr 16;
    v4 := dwFileVersionLS and $FFFF;
  end;
  FreeMem(VerInfo, VerInfoSize);
end;

function TAboutDTM.GetBuildInfoString: string;
var
  v1, v2, v3, v4: Word;
begin
  GetBuildInfo(v1, v2, v3, v4);
  Result := Format('%d.%d.%d  (Build %d)', [v1, v2, v3, v4]);
end;


procedure TAboutDTM.Image3Click(Sender: TObject);
begin
      StartedNameNumber := RNEdit.Text;
      DoSaver;
      Close;
end;




procedure TAboutDTM.Label2Click(Sender: TObject);
begin
  ShellExecute(0, 'open',
    'mailto:ilh2o@ezl.com', '', '',
    SW_SHOW);
end;

procedure TAboutDTM.Label5Click(Sender: TObject);
begin
  ShellExecute(0, 'open',
    'http://www.ezl.com/~ilh2o/', '', '',
    SW_SHOW);
end;

procedure TAboutDTM.SystemInformationBtnClick(Sender: TObject);
begin
  ExecuteFile('MSINFO32.EXE', '', '', SW_SHOW);
end;

procedure TAboutDTM.DelphiButtonClick(Sender: TObject);
begin
  ShellExecute(0, 'open',
    'http://www.borland.com/delphi/', '', '',
    SW_SHOW);
end;



procedure TAboutDTM.ProgramInformationBtnClick(Sender: TObject);
begin
  SystemInfoForm.Show;
end;



end.
