unit GLSViewerFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, {Placemnt,} ActnList, Menus, ImgList, ToolWin, ComCtrls, GLMisc,
  GLScene, GLWin32Viewer, GLVectorFileObjects, GLObjects, Geometry,
  GLTexture, OpenGL12, GLContext, ExtDlgs, ExtCtrls;

type
  TGLSViewerForm = class(TForm)
    MainMenu: TMainMenu;
    ActionList: TActionList;
    ImageList: TImageList;
    ToolBar: TToolBar;
    MIFile: TMenuItem;
    MIHelp: TMenuItem;
    ACOpen: TAction;
    ACExit: TAction;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    ToolButton1: TToolButton;
    StatusBar: TStatusBar;
    GLSceneViewer: TGLSceneViewer;
    GLScene: TGLScene;
    MIOptions: TMenuItem;
    MIAntiAlias: TMenuItem;
    MIAADefault: TMenuItem;
    MIAA2x: TMenuItem;
    MIAA4X: TMenuItem;
    ACSaveAs: TAction;
    ACZoomIn: TAction;
    ACZoomOut: TAction;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    MIView: TMenuItem;
    ZoomIn1: TMenuItem;
    ZoomOut1: TMenuItem;
    FreeForm: TFreeForm;
    OpenDialog: TOpenDialog;
    GLLightSource: TGLLightSource;
    GLMaterialLibrary: TGLMaterialLibrary;
    CubeExtents: TCube;
    ACResetView: TAction;
    Resetview1: TMenuItem;
    ToolButton5: TToolButton;
    ACShadeSmooth: TAction;
    ACFlatShading: TAction;
    ACWireframe: TAction;
    ACHiddenLines: TAction;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    N2: TMenuItem;
    Smoothshading1: TMenuItem;
    Flatshading1: TMenuItem;
    Hiddenlines1: TMenuItem;
    Wireframe1: TMenuItem;
    ToolButton10: TToolButton;
    ACCullFace: TAction;
    Faceculling1: TMenuItem;
    N3: TMenuItem;
    MIBgColor: TMenuItem;
    ColorDialog: TColorDialog;
    MITexturing: TMenuItem;
    ACTexturing: TAction;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    OpenPictureDialog: TOpenPictureDialog;
    MIPickTexture: TMenuItem;
    DCTarget: TDummyCube;
    GLCamera: TGLCamera;
    DCAxis: TDummyCube;
    About1: TMenuItem;
    N4: TMenuItem;
    ShapeLegend1: TMenuItem;
    Openots1: TMenuItem;
    ToolBar1: TToolBar;
    OtsSizePanel: TPanel;
    SizePanel2: TPanel;
    procedure MIHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure ACOpenExecute(Sender: TObject);
procedure DoOtsOpen(const fileName : String);
    procedure GLSceneViewerMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewerMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure GLSceneViewerMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ACZoomInExecute(Sender: TObject);
    procedure ACZoomOutExecute(Sender: TObject);
    procedure ACExitExecute(Sender: TObject);
    procedure ACShadeSmoothExecute(Sender: TObject);
    procedure GLSceneViewerBeforeRender(Sender: TObject);
    procedure MIAADefaultClick(Sender: TObject);
    procedure GLSceneViewerAfterRender(Sender: TObject);
    procedure ACResetViewExecute(Sender: TObject);
    procedure ACCullFaceExecute(Sender: TObject);
    procedure MIBgColorClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure GLMaterialLibraryTextureNeeded(Sender: TObject;
      var textureFileName: String);
    procedure ACTexturingExecute(Sender: TObject);
    procedure MIPickTextureClick(Sender: TObject);
    procedure MIFileClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ShapeLegend1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Openots1Click(Sender: TObject);
  private
    { Private declarations }
    procedure DoResetCamera;
    procedure ApplyShadeModeToMaterial(aMaterial : TGLMaterial);
    procedure ApplyShadeMode;
    procedure ApplyFSAA;
    procedure ApplyFaceCull;
    procedure ApplyBgColor;
    procedure ApplyTexturing;

    procedure DoOpen(const fileName : String);

  public
    { Public declarations }
    md, nthShow : Boolean;
    mx, my : Integer;
    OtsSize:Double;
    hlShader : TGLShader;
    lastFileName : String;
    lastLoadWithTextures : Boolean;
  end;

var
  GLSViewerForm: TGLSViewerForm;

implementation

{$R *.dfm}

uses dtmGlobals, GLFileObj, KeyBoard, GraphicEx, dtmLegend;

type

   // Hidden line shader (specific implem for the viewer, *not* generic)
   THiddenLineShader = class (TGLShader)
      private
         BackgroundColor : TColorVector;
         PassCount : Integer;
      public
         procedure DoApply(var rci : TRenderContextInfo); override;
         function DoUnApply(var rci : TRenderContextInfo) : Boolean; override;
   end;

procedure THiddenLineShader.DoApply(var rci : TRenderContextInfo);
begin
   PassCount:=1;
   SetGLPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glPushAttrib(GL_CURRENT_BIT+GL_ENABLE_BIT);
   glColor3fv(@BackgroundColor);
   glDisable(GL_TEXTURE_2D);
   glEnable(GL_POLYGON_OFFSET_FILL);
   glPolygonOffset(1, 2);
end;

function THiddenLineShader.DoUnApply(var rci : TRenderContextInfo) : Boolean;
begin
   case PassCount of
      1 : begin
         PassCount:=2;
         SetGLPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
         glPopAttrib;
         Result:=True;
      end;
      2 :  Result:=False;
   else
      // doesn't hurt to be cautious
      Assert(False);
      Result:=False;
   end;
end;

procedure TGLSViewerForm.FormCreate(Sender: TObject);
begin
   // instantiate our specific hidden-lines shader
  hlShader:=THiddenLineShader.Create(Self);

  FreeForm.IgnoreMissingTextures:=True;
  top := GLSViewerFormY;
  left := GLSViewerFormX;
end;

procedure TGLSViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  NoGLRunning:=True;
  GLSViewerFormY := GLSViewerForm.top;
  GLSViewerFormX := GLSViewerForm.left;
  DoSaver;
end;

procedure TGLSViewerForm.FormShow(Sender: TObject);
var
   i : Integer;
begin
   if not nthShow then begin
      OpenDialog.Filter:=VectorFileFormatsFilter;
      with ActionList do for i:=0 to ActionCount-1 do
         if Actions[i] is TCustomAction then
            with TCustomAction(Actions[i]) do Hint:=Caption;
      ApplyFSAA;
      ApplyFaceCull;
      ApplyBgColor;

      if ParamCount>0 then
      if UpperCase(ExtractFileExt(ParamStr(1))) = '.OTS' then
          DoOtsOpen(ParamStr(1))else
      if UpperCase(ExtractFileExt(ParamStr(1))) <> '.HTF' then
         DoOpen(ParamStr(1));
      nthShow:=True;
   end;
end;

procedure TGLSViewerForm.MIHelpClick(Sender: TObject);
begin
  Application.HelpContext(11000);
end;

procedure TGLSViewerForm.About1Click(Sender: TObject);
begin
   ShowMessage( 'GLSViewer - Simple OpenGL Mesh Viewer'#13#10
               +'Copyright 2002 Eric Grange'#13#10#13#10
               +'A freeware Delphi program based on...'#13#10#13#10
               +'GLScene: 3D view, 3D file formats support'#13#10
               +'http://glscene.org'#13#10#13#10
               +'GraphicEx: 2D image file formats support'#13#10
               +'http://www.delphi-gems.com/')
end;

procedure TGLSViewerForm.GLSceneViewerBeforeRender(Sender: TObject);
begin
   THiddenLineShader(hlShader).BackgroundColor:=ConvertWinColor(GLSceneViewer.Buffer.BackgroundColor);
   if not GL_ARB_multisample then begin
      MIAADefault.Checked:=True;
      MIAA2x.Enabled:=False;
      MIAA4X.Enabled:=False;
   end;
end;

procedure TGLSViewerForm.GLSceneViewerAfterRender(Sender: TObject);
begin
   ApplyFSAA;
   Screen.Cursor:=crDefault;
end;


procedure TGLSViewerForm.DoResetCamera;
var
   objSize : Single;
begin
   DCTarget.Position.AsVector:=NullHmgPoint;
   GLCamera.Position.SetPoint(7, 3, 5);
   FreeForm.Position.AsVector:=NullHmgPoint;
   FreeForm.Up.Assign(DCAxis.Up);
   FreeForm.Direction.Assign(DCAxis.Direction);

   objSize:=FreeForm.BoundingSphereRadius;
   if objSize>0 then begin
      GLCamera.AdjustDistanceToTarget(objSize*0.25);
      GLCamera.DepthOfView:=2*GLCamera.DistanceToTarget+objSize*2;
   end;
end;

procedure TGLSViewerForm.ApplyShadeModeToMaterial(aMaterial : TGLMaterial);
begin
   with aMaterial do begin
      if ACShadeSmooth.Checked then begin
         GLSceneViewer.Buffer.Lighting:=True;
         GLSceneViewer.Buffer.ShadeModel:=smSmooth;
         aMaterial.FrontProperties.PolygonMode:=pmFill;
         aMaterial.BackProperties.PolygonMode:=pmFill;
      end else if ACFlatShading.Checked then begin
         GLSceneViewer.Buffer.Lighting:=True;
         GLSceneViewer.Buffer.ShadeModel:=smFlat;
         aMaterial.FrontProperties.PolygonMode:=pmFill;
         aMaterial.BackProperties.PolygonMode:=pmFill;
      end else if ACHiddenLines.Checked then begin
         GLSceneViewer.Buffer.Lighting:=False;
         GLSceneViewer.Buffer.ShadeModel:=smSmooth;
         aMaterial.FrontProperties.PolygonMode:=pmLines;
         aMaterial.BackProperties.PolygonMode:=pmLines;
      end else if ACWireframe.Checked then begin
         GLSceneViewer.Buffer.Lighting:=False;
         GLSceneViewer.Buffer.ShadeModel:=smSmooth;
         aMaterial.FrontProperties.PolygonMode:=pmLines;
         aMaterial.BackProperties.PolygonMode:=pmLines;
      end;
   end;
end;

procedure TGLSViewerForm.ApplyShadeMode;
var
   i : Integer;
begin
   with GLMaterialLibrary.Materials do for i:=0 to Count-1 do begin
      ApplyShadeModeToMaterial(Items[i].Material);
      if ACHiddenLines.Checked then
         Items[i].Shader:=hlShader
      else Items[i].Shader:=nil;
   end;
   FreeForm.StructureChanged;
end;

procedure TGLSViewerForm.ApplyFSAA;
begin
   with GLSceneViewer.Buffer do begin
      if MIAADefault.Checked then
         AntiAliasing:=aaDefault
      else if MIAA2X.Checked then
         AntiAliasing:=aa2x
      else if MIAA4X.Checked then
         AntiAliasing:=aa4x;
   end;
end;

procedure TGLSViewerForm.ApplyFaceCull;
begin
   with GLSceneViewer.Buffer do begin
      if ACCullFace.Checked then begin
         FaceCulling:=True;
         ContextOptions:=ContextOptions-[roTwoSideLighting];
      end else begin
         FaceCulling:=False;
         ContextOptions:=ContextOptions+[roTwoSideLighting];
      end;
   end;
end;

procedure TGLSViewerForm.ApplyBgColor;
var
   bmp : TBitmap;
   col : TColor;
begin
   bmp:=TBitmap.Create;
   try
      bmp.Width:=16;
      bmp.Height:=16;
      col:=ColorToRGB(ColorDialog.Color);
      GLSceneViewer.Buffer.BackgroundColor:=col;
      with bmp.Canvas do begin
         Pen.Color:=col xor $FFFFFF;
         Brush.Color:=col;
         Rectangle(0, 0, 16, 16);
      end;
      MIBgColor.Bitmap:=bmp;
   finally
      bmp.Free;
   end;
end;

procedure TGLSViewerForm.ApplyTexturing;
var
   i : Integer;
begin
   with GLMaterialLibrary.Materials do for i:=0 to Count-1 do begin
      with Items[i].Material.Texture do begin
         if Enabled then
            Items[i].Tag:=Integer(True);
         Enabled:=Boolean(Items[i].Tag) and ACTexturing.Checked;
      end;
   end;
   FreeForm.StructureChanged;
end;

procedure TGLSViewerForm.DoOpen(const fileName : String);
var
   i : Integer;
   min, max : TAffineVector;
   libMat : TGLLibMaterial;
begin
   if not FileExists(fileName) then Exit;

   Screen.Cursor:=crHourGlass;

   Caption:='GLSViewer - '+ExtractFileName(fileName);

   FreeForm.MeshObjects.Clear;
   GLMaterialLibrary.Materials.Clear;

   FreeForm.LoadFromFile(fileName);
   with GLMaterialLibrary do begin
      if Materials.Count=0 then begin
         FreeForm.Material.MaterialLibrary:=GLMaterialLibrary;
         libMat:=Materials.Add;
         FreeForm.Material.LibMaterialName:=libMat.Name;
         libMat.Material.FrontProperties.Diffuse.Red:=0;
      end;
      for i:=0 to Materials.Count-1 do
         with Materials[i].Material do BackProperties.Assign(FrontProperties);
   end;
   ApplyShadeMode;
   ApplyTexturing;

   StatusBar.Panels[0].Text:=IntToStr(FreeForm.MeshObjects.TriangleCount)+' tris';
   StatusBar.Panels[1].Text:=fileName;
   lastFileName:=fileName;
   lastLoadWithTextures:=ACTexturing.Enabled;

   FreeForm.GetExtents(min, max);
   with CubeExtents do begin
      CubeWidth:=max[0]-min[0];
      CubeHeight:=max[1]-min[1];
      CubeDepth:=max[2]-min[2];
      Position.AsAffineVector:=VectorLerp(min, max, 0.5);
   end;
   DoResetCamera;
   SizePanel2.Caption:=
   'X: '+ Inttostr(Round(max[0]))  {CubeWidth}
   + ' Y: ' + Inttostr(Round(max[1]))  {CubeHeight}
   + ' Z: ' + Inttostr(Round(max[2]));  {CubeDepth}
   {TAffineVector}
end;

procedure TGLSViewerForm.DoOtsOpen(const fileName : String);
var
 ActorFileName,TextureFileName,
 S : string;
 F: TextFile;
begin
  begin
    AssignFile(F,fileName);
    Reset(F);
    Readln(F, S);
    If (S='GlobalObjectActorTerrain Version 1.0') then
    begin
             {Read file and get Actor.FileName
              and Texture.FileName
                  Weapon.FileName
                  WpnTexture.FileName
               Filenames...}
    Readln(F, S);
    If S='True' then {ActorObjectCB.Checked};
    Readln(F, S);
    If S='True' then {TextureOnlyCB.Checked};
    {Objects as Billboards.. DO WHAT ... Create a BillBoard??
    HOW to get size????}
      Readln(F, ActorFileName);
      Readln(F, TextureFileName);
            Readln(F, S); {Weapon and Texture}
            Readln(F, S);
      Readln(F, S);  {Size}
      OtsSize:=StrtoFloat(S);
      OtsSizePanel.Caption:='Scale Size: '+S;
      CloseFile(F);
      DoOpen(ActorFileName);
      if not FileExists(TextureFileName) then Exit;
      with GLMaterialLibrary.Materials do begin
        with Items[Count-1] do begin
         Tag:=1;
         Material.Texture.Image.LoadFromFile(TextureFileName);
         Material.Texture.Enabled:=True;
        end;
        ApplyTexturing;
      end;
    end else CloseFile(F);
  end;
end;

procedure TGLSViewerForm.Openots1Click(Sender: TObject);
begin
{  OpenDialog.InitialDir:=ProjectPath;}
  OpenDialog.Filter:= 'Object + Texture Set (*.ots)|*.ots';
  OpenDialog.Filename:= '*.ots';
  if OpenDialog.Execute then
  if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
  DoOtsOpen(OpenDialog.FileName);
  OpenDialog.InitialDir:='';
  OpenDialog.Filter:= '';
  OpenDialog.Filename:= '';
end;

procedure TGLSViewerForm.ACOpenExecute(Sender: TObject);
begin
   if OpenDialog.Execute then
   if UpperCase(ExtractFileExt(OpenDialog.Filename)) = '.OTS' then
      DoOtsOpen(OpenDialog.FileName) else
      DoOpen(OpenDialog.FileName);
end;

procedure TGLSViewerForm.GLSceneViewerMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
   md:=True;
end;

procedure TGLSViewerForm.GLSceneViewerMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
   d : Single;
begin
   if md and (Shift<>[]) then begin
      if ssLeft in Shift then
         GLCamera.MoveAroundTarget(my-y, mx-x)
      else if ssRight in Shift then begin
         d:=GLCamera.DistanceToTarget*0.01*(x-mx+y-my);
         if IsKeyDown('x') then
            FreeForm.Translate(d, 0, 0)
         else if IsKeyDown('y') then
            FreeForm.Translate(0, d, 0)
         else if IsKeyDown('z') then
            FreeForm.Translate(0, 0, d)
         else GLCamera.RotateObject(FreeForm, my-y, mx-x);
      end;
      mx:=x; my:=y;
   end;
end;

procedure TGLSViewerForm.GLSceneViewerMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   md:=False;
end;

procedure TGLSViewerForm.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
   if FreeForm.MeshObjects.Count>0 then begin
      GLCamera.AdjustDistanceToTarget(Power(1.05, WheelDelta/120));
      GLCamera.DepthOfView:=2*GLCamera.DistanceToTarget+2*FreeForm.BoundingSphereRadius;
   end;
   Handled:=True;
end;

procedure TGLSViewerForm.ACZoomInExecute(Sender: TObject);
var
   h : Boolean;
begin
   FormMouseWheel(Self, [], -120*4, Point(0, 0), h);
end;

procedure TGLSViewerForm.ACZoomOutExecute(Sender: TObject);
var
   h : Boolean;
begin
   FormMouseWheel(Self, [], 120*4, Point(0, 0), h);
end;

procedure TGLSViewerForm.ACExitExecute(Sender: TObject);
begin
   Close;
end;

procedure TGLSViewerForm.ACShadeSmoothExecute(Sender: TObject);
begin
   ApplyShadeMode;
end;

procedure TGLSViewerForm.MIAADefaultClick(Sender: TObject);
begin
   (Sender as TMenuItem).Checked:=True;
   ApplyFSAA;
end;

procedure TGLSViewerForm.ACResetViewExecute(Sender: TObject);
begin
   DoResetCamera;
end;

procedure TGLSViewerForm.ACCullFaceExecute(Sender: TObject);
begin
   ACCullFace.Checked:=not ACCullFace.Checked;
   ApplyFaceCull;
end;

procedure TGLSViewerForm.MIBgColorClick(Sender: TObject);
begin
   if ColorDialog.Execute then
      ApplyBgColor;
end;

procedure TGLSViewerForm.GLMaterialLibraryTextureNeeded(Sender: TObject;
  var textureFileName: String);
begin
   if not ACTexturing.Enabled then
      textureFileName:='';
end;

procedure TGLSViewerForm.ACTexturingExecute(Sender: TObject);
begin
   ACTexturing.Checked:=not ACTexturing.Checked;
   if ACTexturing.Checked then
      if lastLoadWithTextures then
         ApplyTexturing
      else begin
         DoOpen(lastFileName);
      end
   else ApplyTexturing;
end;

procedure TGLSViewerForm.MIFileClick(Sender: TObject);
begin
   MIPickTexture.Enabled:=(GLMaterialLibrary.Materials.Count>0);
end;

procedure TGLSViewerForm.MIPickTextureClick(Sender: TObject);
begin
   if OpenPictureDialog.Execute then with GLMaterialLibrary.Materials do begin
      with Items[Count-1] do begin
         Tag:=1;
         Material.Texture.Image.LoadFromFile(OpenPictureDialog.FileName);
         Material.Texture.Enabled:=True;
      end;
      ApplyTexturing;
   end;
end;




procedure TGLSViewerForm.ShapeLegend1Click(Sender: TObject);
begin
  If ((LayersLoaded>0 ))then
  begin         {Legend is MODAL.. only 1 and only IT}
    LegendForm:=TLegendForm.Create(Application);
    LegendForm.Showmodal;
    LegendForm.Release;
    {PrepareBitmap;}
  end;
end;







end.
