unit DtmShpSaver;
{by Ivan Lee Herring, 2002}
{Arc programs use Shape files using DBase III+, mine dont care }
interface

uses
  Forms,{for Application.ProcessMessages}
  dbtables, db, Graphics,
  Windows, Messages, SysUtils, Classes;

type
  FieldDefRec= record
    FieldNo: Integer;
    Displayname:String;
    DataType: TFieldType;
    Size: Integer;
    Precision: Integer;
    Required: Boolean;
    {TFieldDef Field Name,Type,Size for Each attribute}
   end;

  Pnts = record
    Xd,Yd: Double;
   end;
  Pnts3 = record
    Xd,Yd,Zd,Md: Double;
   end;
  PAR = record
    PA:array of Pnts;  {Pnts in each Part}
   end;
  PAR3 = record
    PA3:array of Pnts3;{Pnts in each Part}
   end;
  ShpObj = record
    ShpType: Integer;{Shape type for THIS Object: ONLY MY Types}
    ShapeIDN, {Shape Object number in file}
    PntsN, {Total points in Object}
    PartsN:integer;{1 implies single part with no subpparts}
    PPA: array of Integer;{# of Pnts in each Part}
    PARA: array of PAR;{array of Pnts for each Part in Object}
    {Boundary of THIS object}
    XMin,YMin,XMax,YMax{,ZMin,MMin,ZMax,MMax}: Double;
    {array of the attributes AS Strings .. per Object}
    AAttributes:array of string;{0..AttributesN-1}
  end;
    {all per ShpObj: PARA[PartsN #].PA[PPA[PartsN #]].Xn }
  ShpObj3 = record
    ShpType: Integer;{Shape type for THIS Object: ONLY MY Types}
    ShapeIDN, {Shape Object number in file}
    PntsN, {Total points in Object}
    PartsN:integer;{1 implies single part with no subpparts}
    PPA: array of Integer;{# of Pnts in each Part}
    PARA3: array of PAR3;{array of Pnts for each Part in Object}
    {Boundary of THIS object}
    XMin,YMin,XMax,YMax{,ZMin,MMin,ZMax,MMax}: Double;
    {array of the attributes AS Strings .. per Object}
    AAttributes:array of string;{0..AttributesN-1}
  end;

  ShpLayer = record{Shape Type and Boundary}
    LayerN,{Layer number loaded as}
    ShapeN,{Number of Shape Objects in file layer}
    IslandsN,{Total Islands  ie. ShapeN+IslandsN=Total parts}
    TotalPnts:Integer;{Total Points in file layer}
    Modified:Boolean; {Editing done for THIS layer}
    ShpType: Integer;{Shape file type for THIS Layer:
                       All except MY Types}
    LayerDBName,LayerDBPath,{ ? should be same as Shape file name..}
    Filename,Path:String;
    OffsetX, OffsetY,{Offset +- resets-sizes to 0,0 for display}
      {Boundary of Layer}
    XMin,YMin,XMax,YMax,ZMin,MMin,ZMax,MMax: Double;
       {Attribute count for THIS File}
    AttributesN: Integer;
      {TFieldDef Field Name,Type,Size for Each attribute}
    AttType:array of FieldDefRec;
      {All the Objects in the file}
    LyrShp:array of ShpObj;
    {LayA[].LyrShp[].PARA[PartsN #].PA[PPA[PartsN #]].Xn Yn Zn Mn}
    LayerColor:TColor;
    {GR32 data}
    CanvasLineSize,
    PointSize,CurrentPointType:Integer;

    StippleColorCount:Integer;
    UseStippleStep:Boolean;
    StippleStep:Single;
    StippleColorArray:array of TColor;

    OutLineColor:TColor;
    PolyFilled, UseOutlinePoly, PolygonAntialiased:Boolean;
    FillAlphaPosition, LineAlphaPosition:Integer;
    LineSize:Single;
    OtsNameEditText:String;{Actor Name}
  end;
  ShpLayer3 = record{Shape Type and Boundary}
    LayerN,{Layer number loaded as}
    ShapeN,{Number of Shape Objects in file layer}
    IslandsN,{Total Islands  ie. ShapeN+IslandsN=Total parts}
    TotalPnts:Integer;{Total Points in file layer}
    Modified:Boolean; {Editing done for THIS layer}
    ShpType: Integer;{Shape file type for THIS Layer:
                       All except MY Types}
    LayerDBName,LayerDBPath,{ ? should be same as Shape file name..}
    Filename,Path:String;
    OffsetX, OffsetY,{Offset +- resets-sizes to 0,0 for display}
      {Boundary of Layer}
    XMin,YMin,XMax,YMax,ZMin,MMin,ZMax,MMax: Double;
       {Attribute count for THIS File}
    AttributesN: Integer;
      {TFieldDef Field Name,Type,Size for Each attribute}
    AttType:array of FieldDefRec;
      {All the Objects in the file}
    LyrShp3:array of ShpObj3;
    {LayA[].LyrShp[].PARA[PartsN #].PA[PPA[PartsN #]].Xn Yn Zn Mn}
    LayerColor:TColor;
  end;

  SymObj = record
  {0 Not, 1 Simple, 2 Unique, 3 Classed, 4 Individual}
    SymSymboled, SymLabeled, SymClassSize:Integer;
    SymStyle,SymLineStyle,SymLineWidth:Integer;
    SymLabelBackColor, SymLineColor, SymBrushColor:TColor;
    isSymOutlined, isSymLabelSet,isSymLabelColored:Boolean;
    SymFont:Tfont;
    {SymlabelFieldstring: string;}
    labelHeight,labelAngle,HAlign,VAlign:Integer;
    LabelX,LabelY:Double;
    end;
  SymLayer=record
    SymLayerBeginSize,SymLayerEndSize, SymLayerClasses,
   {0 Not, 1 Simple, 2 Unique, 3 Classed, 4 Individual}
    SymLayerSymboled, SymLayerLabeled:Integer;
    SymLayerStyle, SymLayerLineStyle,
    SymLayerLineWidth{1.. else no style}:Integer;
    SymLayerLabelBackColor,
    SymLayerStartColor, SymLayerFinishColor,
    SymLayerLineColor,  SymLayerBrushColor:TColor;
    isSymLayerEditable,
    isSymLayerOutlined, isSymLayerLabelColored:Boolean;
    SymFont:Tfont;
    labelHeight,labelAngle,Field:Integer;
    SymLayerClassBreaks:Array of Double;
    SymlabelFieldstring: array of string;
    LyrSym:array of SymObj;{Store data for EACH OBJECT  LayA[].ShapeN}
  end;

{sSinData
BlockRead(outfile,ProjData , Sizeof(ProjData), NumRead);
TempInteger:=ProjData;
PixelsPerDegreeEdit.Text:=InttoStr(TempInteger);
      BlockRead(outfile,sSinData , Sizeof(sSinData), NumRead);
  KiloPerPixelEdit.Text:=FloattoStr(sSinData);


ProjData:=StrtoInt(PixelsPerDegreeEdit.Text);
      Blockwrite(outfile,ProjData , Sizeof(ProjData), NumRead);
  sSinData:=StrtoFloat(KiloPerPixelEdit.Text);
      Blockwrite(outfile,sSinData , Sizeof(sSinData), NumRead);
  }

  Type
  ProjRec=Record
  SourceCBItemindex,VersionEditText,
  ValidProjectionCBChecked,
  IntegerorFloatCBChecked,
  MapZUnitsCBItemindex,PixelCoordinateCBItemindex,
  ProjectionCBItemindex,InUnitCBItemindex,
  InUtmZoneCBItemindex,UTMZoneNorthCBChecked,
  InDatumCBItemindex,  SpheroidCBItemindex:Byte;
  PixelsPerDegreeEdit,
    SEXEWEditText,SEYNSEditText,
    StatePlaneZoneEditText,NullValueEditText  :Smallint;
    CountryFipsCodeCBItemIndex,
    StateFipsCodeCBItemIndex,
    CountyFipsCodeCBItemIndex,
  XWidthEditText,YHeightEditText  : Integer;
  KiloPerPixelEdit:Single;
  PixelXSizeEditText,PixelYSizeEditText,ZSizeEditText,
  TopLeftXEditText,TopLeftYEditText,
  TopRightXEditText,TopRightYEditText,
  BottomLeftXEditText,BottomLeftYEditText,
  BottomRightXEditText,BottomRightYEditText,
    DLGPA1Text,DLGPA2Text,DLGPA3Text,
    DLGPB1Text,DLGPB2Text,DLGPB3Text,
    DLGPC1Text,DLGPC2Text,DLGPC3Text,
    DLGPD1Text,DLGPD2Text,DLGPD3Text,
    DLGPE1Text,DLGPE2Text,DLGPE3Text
  :Double;
  CellLocatorEditText:String[8];
  end;
  var
  MapProjRec: ProjRec;
{Store Info for Each Layer loaded as MapLayerRec}
  Type
  MapRec=Record
    MapNameEdit,       MapDateEdit,       MapRevisionEdit,
    MapScaleEdit,      MapQuadrangleEdit, ProductTypeEdit,
    PreProcessingEdit, ResamplingTechniqueEdit
    :string[255];{ :String;}

    MapEdge1Edit, MapEdge2Edit, MapEdge3Edit, MapEdge4Edit,
    MapEdgeW1Edit,MapEdgeW2Edit,
    MapEdgeN1Edit,MapEdgeN2Edit,
    MapEdgeE1Edit,MapEdgeE2Edit,
    MapEdgeS1Edit,MapEdgeS2Edit:Char;

    bIsProjectedCB, bNeverProjectedCB,
    bIgnoreDatumCB, bIgnoreErrorsCB,
    bUTMZoneNorthCB,
    bProjectionValidCBox:Boolean;

    CatNameCB,
    ProjectionCB,
    InUnitCB,
    InUtmZoneCB,
    InDatumCB,
    SpheroidCB,
    StatePlaneZoneEdit:Integer;

    ModeEdit,
    SMajorEdit, SMinorEdit,    SphereEdit,
    FEEdit,     FNEdit,        OriginLatEdit,
    STDPR1Edit, STDPR2Edit,    CentMerEdit,
    TrueScaleEdit,    CentLonEdit,    CenterLatEdit,
    STDPAREdit, LongPolEdit, FactorEdit, HeightEdit,
    ShapeMEdit, ShapeNEdit,  AngleEdit,
    Long1Edit,  Long2Edit,   Lat1Edit,   Lat2Edit,
    AziAngEdit, AzmthPtEdit, IncAngEdit,
    AscLongEdit,PSRevEdit,   LRatEdit,
    PFlagEdit,  SatnumEdit,  PathEdit:Double;
    DLGPA1,DLGPA2,DLGPA3,
    DLGPB1,DLGPB2,DLGPB3,
    DLGPC1,DLGPC2,DLGPC3,
    DLGPD1,DLGPD2,DLGPD3,
    DLGPE1,DLGPE2,DLGPE3,
    DLGPP1,DLGPP2,DLGPP3,DLGPP4:Double;

    MapZUnitsCB, MapMUnitsCB:Integer;

    MapXMaxEdit,MapXMinEdit,
    MapYMaxEdit,MapYMinEdit,
    MapZMaxEdit,MapZMinEdit,
    MapMMaxEdit,MapMMinEdit:Double;

    bCoordinatesValidCBox:Boolean;

    ULLongitudeEdit,ULLatitudeEdit,
    URLongitudeEdit, URLatitudeEdit,
    LLLongitudeEdit,LLLatitudeEdit,
    LRLongitudeEdit,LRLatitudeEdit:Double;

    MetadataFileEdit:string[255];{ :String;}
  end;
{  MapLayerFile = file of MapRec;}{for Layer Projections}

  Type
  LegendRec=Record
  ProjectionName:String;

  ProjectionCB,  GridsRG,
  TitleTopCount,AuthorTopCount,TitleBottomCount,AuthorBottomCount,
  SourceCount,FeatureTextCount,NorthArrowTextCount,
  ContourIntervalCount:Integer;

  TitleTopFont, AuthorTopFont,TitleBottomFont,
  AuthorBottomFont,SourceFont,FeatureTextFont,
  NorthArrowTextFont,ContourIntervalFont:Tfont;

  TitleTop,AuthorTop,TitleBottom,AuthorBottom,
  Source,FeatureText,NorthArrowText,ContourInterval:array of string;

  TitleTopOn,AuthorTopOn,TitleBottomOn,AuthorBottomOn,
  SourceOn,FeatureTextOn,NorthArrowTextOn,
  ContourIntervalOn:Boolean;

  TitleTopAt,AuthorTopAt,TitleBottomAt,AuthorBottomAt,
  SourceAt,FeatureTextAt,NorthArrowTextAt,
  ContourIntervalAt:Array[0..7] of Integer;
  {BITMAPS}
  MapLocationText,
  GridName,NorthArrowBitName,LegendName,
  MapLocationName,ScalebarsName,FeatureBitmapName:String;

  GridOn,NorthArrowBitOn,LegendOn,
  MapLocationOn,ScalebarsOn,FeatureBitmapOn:Boolean;

  PaperSizeAt, NorthArrowBitAt,LegendAt,MapAt,
  MapLocationAt,ScalebarsAt,FeatureBitmapAt:Array[0..7] of Integer;
  end;


var
{  MapLegendRec: LegendRec;}{Loaded with Map Project file}
{  MapProject: MapRec; } { "   "  }
  MapLayerRec: MapRec;{Loaded and saved per command per layer}


  MapVersion:Double;{Map load and save}
  {Length is 0..LayersLoaded-1 to use with Index es}
  LayersControlArray: Array  of Integer;
  ShapesFoundArray: Array of array[1..2]of Integer;
  ShpFilename: string;
(*  ShapesFound,
  SelectionRadius,
  CurrentObj, {selected when searching else 0}
  CurrentObjPart,
  CurrentObjPoint,
  CurrentField, {selected from FieldComboBox}
  SearchDbField,*)
{  AnnoLayerCreatedAs,PolygonLayerCreatedAs,
  LineLayerCreatedAs,   PointLayerCreatedAs}
  CurrentLayer,{selected from LayerComboBox or LayerCount when loaded}
    LayersLoaded{0 is nil for editing}:Integer;
{  IsMapLoaded, IsProjected, IsPointDrawn,
  AnnoLayerCreated,   PolygonLayerCreated,
  LineLayerCreated,   PointLayerCreated,
  isShapeSelected,}
  bDemLoaded, bBackClipBitmapLoaded:Boolean;
{    DemPath, DemName,
    BackBitmapPath, BackBitmapName,}
  NewLayerName:String;

{  MapA:Array of SymLayer;}{  MapA[].LyrSym[]  MapA[].Labeled}
  LayA:array of ShpLayer;{All Shape Layers for all Files loaded}
  {LayA[].LyrShp[].PARA[].PA[].Xn   Yn Zn Mn}
{  AnnoA: array of SymObj;}
procedure SaveShpFile(LayerToSave:Integer;FileName:String);

procedure SaveShpDXFFile(LayerToSave:Integer;FileName:String);

Function LoadDatabase(WhichLayer:Integer):Boolean;
Function SaveDatabase(WhichLayer:Integer):Boolean;
function RunTimeDbCreate(
  const DatabaseName, SessionName: string): TDatabase;


implementation

uses
dtmErrMsg,
dtmGlobals{,dtmDbFrm};

procedure SaveShpFile(LayerToSave:Integer;FileName:String);
var
  IndexFileOut, ShapeFileOut: file;
temp{, InString, ShapeString}: string;
  ShapeByte: Byte;
{  ShapeLineNumber, ShapeLinePoints, ShapeLinePointsN }
{  , LinePointCount,  Areas, Lines LineCount
   IShape,  DoThisMany,     }
  Incrementer, IndexOffsetTotal,
  PartCount,PartCounter,
  PointCount,PointCounter, PartCountTotal,
  Count, Shapetype, ShapeInteger: Integer;
{  TotalLinePointSets, TotalShapePointSets,
  TotalShapeIslandsN, ,  PointCountTotal}
  ShapeFileSize, IndexFileSize,
  RecordSize,  IndexOffset  : integer;
{  XTemp, YTemp, XMIN, YMIN, XMAX, YMAX: Double;   }
procedure SwapShapeInteger(Incoming: Integer);
  var ByteArray: array[0..3] of Byte;
begin
    Move(Incoming, ByteArray, 4);
    ShapeByte := ByteArray[3];
    BlockWrite(ShapeFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[2];
    BlockWrite(ShapeFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[1];
    BlockWrite(ShapeFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[0];
    BlockWrite(ShapeFileOut, ShapeByte, 1);
end;
procedure SwapIndexInteger(Incoming: Integer);
  var ByteArray: array[0..3] of Byte;
begin
    Move(Incoming, ByteArray, 4);
    ShapeByte := ByteArray[3];
    BlockWrite(IndexFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[2];
    BlockWrite(IndexFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[1];
    BlockWrite(IndexFileOut, ShapeByte, 1);
    ShapeByte := ByteArray[0];
    BlockWrite(IndexFileOut, ShapeByte, 1);
end;

Begin
{Write the Layer to a Shape file  .shp  .shx  .dbf}
        {Set up Shape and Index file}
        temp := ChangeFileExt(FileName, '.shx');
        AssignFile(IndexFileOut, temp);
        Rewrite(IndexFileOut, 1);
        AssignFile(ShapeFileOut, FileName);
        Rewrite(ShapeFileOut, 1);
        RunProgress(0,-1);
        SwapShapeInteger(9994);
        SwapIndexInteger(9994);
        for Incrementer := 1 to 5 do
        begin {5 blank zeros}
          SwapShapeInteger(0);
          SwapIndexInteger(0);
        end;

        {Compute and Write File size}
        Shapetype:=LayA[LayerToSave].ShpType;
        ShapeFileSize:=1;
        IndexFileSize:=1;
  Case Shapetype of
  1:Begin     {14= 4+ 2 + 8}
     ShapeFileSize := ((LayA[LayerToSave].ShapeN * (10+4)) + 50);
     IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
      {(Each point set is a header, shape type,and the 2 points)
        + Main header, in 16 bit words - not bytes}
    end;
  3..5:
    begin
  {Lines} {8 for X and Y points}
    {count the number of Polylines per line,
    ...like islands in area}
            {28=22 +2(1 part)+4 (header)}
    ShapeFileSize :=
            ((LayA[LayerToSave].ShapeN * 28)
     {They ALL have 1 line, some have more,
      so count islands (line) separate}
            + (LayA[LayerToSave].IslandsN * 2) {Islands pointers }
            + (LayA[LayerToSave].TotalPnts * 8)
            + 50);
    IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
         {as 16 bit words, not 8 bit bytes}
          {(Each line set is a header,
            count stuff and the points) + Main header}
    end;
  8:  {MultiPoint}
    Begin                                      {20+4}
     ShapeFileSize := ((LayA[LayerToSave].ShapeN * 24)
                            + (LayA[LayerToSave].TotalPnts * 8)
                            + 50);
     IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    End;
  11:  {Point Z}
    Begin
     ShapeFileSize := ((LayA[LayerToSave].ShapeN * (10+8+4))+ 50);
     IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    End;
  13..15:
    begin
      ShapeFileSize :=      {Mand Z Min Max}
            ((LayA[LayerToSave].ShapeN * 28+8)
            + (LayA[LayerToSave].IslandsN * 2) {Islands pointers }
            + (LayA[LayerToSave].TotalPnts * 16)
            + 50);
      IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    end;
  18:
    begin
      ShapeFileSize :=
            ((LayA[LayerToSave].ShapeN * 28+8)
{            + (LayA[LayerToSave].IslandsN * 2) }{Islands pointers }
            + (LayA[LayerToSave].TotalPnts * 16)
            + 50);
      IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    end;
  21:  {Point M}
    Begin
     ShapeFileSize := ((LayA[LayerToSave].ShapeN * (10+4+4)) + 50);
     IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    End;
  23..25:
    begin
      ShapeFileSize :=
            ((LayA[LayerToSave].ShapeN * 28+4)
            + (LayA[LayerToSave].IslandsN * 2) {Islands pointers }
            + (LayA[LayerToSave].TotalPnts * 12)
            + 50);
      IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    end;
  28:
    begin
      ShapeFileSize :=
            ((LayA[LayerToSave].ShapeN * 28+4)
{            + (LayA[LayerToSave].IslandsN * 2) }{Islands pointers }
            + (LayA[LayerToSave].TotalPnts * 12)
            + 50);
      IndexFileSize := ((LayA[LayerToSave].ShapeN * 4) + 50);
    end;
  End;{Case}
        {Write the file size}
        SwapShapeInteger(ShapeFileSize);
        SwapIndexInteger(IndexFileSize);
        {Version}
        ShapeInteger := 1000;
        BlockWrite(ShapeFileOut, ShapeInteger, 4);
        BlockWrite(IndexFileOut, ShapeInteger, 4);

        {Shapetype}
        BlockWrite(ShapeFileOut, LayA[LayerToSave].ShpType, 4);
        BlockWrite(IndexFileOut, LayA[LayerToSave].ShpType, 4);
        {XMIN,YMIN,XMAX,YMAX:Double;}
        BlockWrite(ShapeFileOut, LayA[LayerToSave].XMIN, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].XMIN, 8);
        BlockWrite(ShapeFileOut, LayA[LayerToSave].YMIN, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].YMIN, 8);
        BlockWrite(ShapeFileOut, LayA[LayerToSave].XMAX, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].XMAX, 8);
        BlockWrite(ShapeFileOut, LayA[LayerToSave].YMAX, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].YMAX, 8);
        {M and Z}
        BlockWrite(ShapeFileOut, LayA[LayerToSave].ZMIN, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].ZMIN, 8);
        BlockWrite(ShapeFileOut, LayA[LayerToSave].ZMAX, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].ZMAX, 8);
        {M and Z}
        BlockWrite(ShapeFileOut, LayA[LayerToSave].MMIN, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].MMIN, 8);
        BlockWrite(ShapeFileOut, LayA[LayerToSave].MMAX, 8);
        BlockWrite(IndexFileOut, LayA[LayerToSave].MMAX, 8);


{HEADER Written... NOW write Shape Objects}
{VoEditForm.XYPanel.Caption := 'Writing Shape File';  }
if ((Shapetype = 1) )then
begin {Writing Points}
  Count := LayA[LayerToSave].ShapeN;
{  PointCount := 1;
  IndexOffset := 50;}
  IndexOffsetTotal:= 50;
        for Incrementer := 1 to LayA[LayerToSave].ShapeN do
        begin
          RunProgress(0,(Count div Incrementer));
          PointCount :=Incrementer;
          SwapShapeInteger(PointCount);
          {Record Number starts with 1}
          {Offset incremented for start of NEXT one}
          IndexOffset :=IndexOffsetTotal;
          SwapIndexInteger(IndexOffset);
          IndexOffsetTotal:=IndexOffsetTotal + 10 + 4;
           {Index offset = Content Length +header}
          SwapShapeInteger(10);
           {Content Length.. not content + header}
          SwapIndexInteger(10);
          ShapeInteger := (ShapeType); {Shape Type=1}
          BlockWrite(ShapeFileOut, ShapeInteger, 4);
          BlockWrite(ShapeFileOut,     {Only 1 point per part}
          LayA[LayerToSave].LyrShp[Incrementer].XMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Xd}, 8);
          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].YMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Yd}, 8);
       end;
end {Shape type 1} else
if ((Shapetype = 11) )then
begin {Writing Points}
  Count := LayA[LayerToSave].ShapeN;
{  PointCount := 1;
  IndexOffset := 50;}
  IndexOffsetTotal:= 50;
        for Incrementer := 1 to LayA[LayerToSave].ShapeN do
        begin
          RunProgress(0,(Count div Incrementer));
          PointCount :=Incrementer;
          SwapShapeInteger(PointCount);
          {Record Number starts with 1}
          {Offset incremented for start of NEXT one}
          IndexOffset :=IndexOffsetTotal;
          SwapIndexInteger(IndexOffset);
          IndexOffsetTotal:=IndexOffsetTotal + 18 + 4;
           {Index offset = Content Length +header}
          SwapShapeInteger(18);
           {Content Length.. not content + header}
          SwapIndexInteger(18);
          ShapeInteger := (ShapeType); {Shape Type=1}
          BlockWrite(ShapeFileOut, ShapeInteger, 4);
          BlockWrite(ShapeFileOut,     {Only 1 point per part}
          LayA[LayerToSave].LyrShp[Incrementer].XMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Xd}, 8);
          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].YMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Yd}, 8);
{          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].ZMin, 8);
          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].MMin, 8);}
       end;
end {Shape type 11} else
if ((Shapetype = 21) )then
begin {Writing Points}
  Count := LayA[LayerToSave].ShapeN;
{  PointCount := 1;
  IndexOffset := 50;}
  IndexOffsetTotal:= 50;
        for Incrementer := 1 to LayA[LayerToSave].ShapeN do
        begin
          RunProgress(0,(Count div Incrementer));
          PointCount :=Incrementer;
          SwapShapeInteger(PointCount);
          {Record Number starts with 1}
          {Offset incremented for start of NEXT one}
          IndexOffset :=IndexOffsetTotal;
          SwapIndexInteger(IndexOffset);
          IndexOffsetTotal:=IndexOffsetTotal + 14 + 4;
           {Index offset = Content Length +header}
          SwapShapeInteger(14);
           {Content Length.. not content + header}
          SwapIndexInteger(14);
          ShapeInteger := (ShapeType); {Shape Type=1}
          BlockWrite(ShapeFileOut, ShapeInteger, 4);
          BlockWrite(ShapeFileOut,     {Only 1 point per part}
          LayA[LayerToSave].LyrShp[Incrementer].XMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Xd}, 8);
          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].YMin
          {LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[1].Yd}, 8);
{          BlockWrite(ShapeFileOut,
          LayA[LayerToSave].LyrShp[Incrementer].MMin, 8);}
       end;
end {Shape type 21} else
(********************************)

(********************************)
if ((Shapetype = 3)or(Shapetype = 5)
or (Shapetype = 13)or(Shapetype = 15)
or (Shapetype = 23)or(Shapetype = 25)) then
begin
  Count := LayA[LayerToSave].ShapeN;
{  IndexOffset := 50;}
{  PointCount := 1;}
  IndexOffsetTotal:= 50;
    for Incrementer := 1 to LayA[LayerToSave].ShapeN do
    begin
      RunProgress(0,(Count div Incrementer));
{Write Record header}
      PointCount := Incrementer;
      SwapShapeInteger(PointCount); {Record Number}
      IndexOffset :=IndexOffsetTotal;
      SwapIndexInteger(IndexOffset);
      {Index offset + Content Length... for NEXT record... first is 50}
if ((Shapetype = 3)or(Shapetype = 5))then
      RecordSize := (22
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 8)
      {+4}{this header data})
else if ((Shapetype = 13)or(Shapetype = 15)) then
      RecordSize := (22+8+8 {Z +-}{M +-}
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 16)
      {+4}{this header data})
else RecordSize := (22+8 {M +-}
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 12)
      {+4}{this header data});
        {Content Length}
      IndexOffsetTotal:=IndexOffsetTotal + RecordSize + 4;
        {Index is Index+  (4 (header)+content)}
      SwapShapeInteger(RecordSize);
      SwapIndexInteger(RecordSize);
{Write Record Content}
      ShapeInteger := (ShapeType); {Shape Type is same for FILE}
      BlockWrite(ShapeFileOut, ShapeInteger, 4);
      {Object boundaries}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].XMin, 8); {X min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].YMin, 8); {Y min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].XMax, 8); {X max}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].YMax, 8); {Y max}
      {Number of Parts... poly lines in THIS arc... }
      ShapeInteger := (LayA[LayerToSave].LyrShp[Incrementer].PartsN);
      BlockWrite(ShapeFileOut, ShapeInteger, 4);
      {Number of Points for ALL polylines in THIS arc... X and Y}
      BlockWrite(ShapeFileOut, LayA[LayerToSave].LyrShp[Incrementer].PntsN, 4);


      PartCount := (LayA[LayerToSave].LyrShp[Incrementer].PartsN);
      {Parts index pointer for start of each line... 0}
      ShapeInteger := (0);
      PartCountTotal:=0;{from 0 array index}
      BlockWrite(ShapeFileOut, ShapeInteger, 4);
        {Do first ^ and then any-all the others}
        {Island Index Counter is ALL that determines Rings of a Polygon}
      for PartCounter := 2 to PartCount do  {all have 1 part}
      begin
        ShapeInteger := PartCountTotal+
        LayA[LayerToSave].LyrShp[Incrementer].PPA[PartCounter-1];
        BlockWrite(ShapeFileOut, ShapeInteger, 4);
        PartCountTotal:=ShapeInteger;
      end;       {AreaRecord Islands}

      for PartCounter := 1 to PartCount  do
      begin
        PointCount:=
          LayA[LayerToSave].LyrShp[Incrementer].PPA[PartCounter];
      for PointCounter := 1 to PointCount do
      begin
        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[PartCounter].PA[PointCounter].Xd, 8);
        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[PartCounter].PA[PointCounter].Yd, 8);
      end;
    end;{for PartCounter }

if ((Shapetype = 13)or (Shapetype = 23)) then
begin  {Z ONLY}
(*      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].ZMax, 8); {X max}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].ZMin, 8); {Y max}*)
      for PartCounter := 1 to PartCount  do
      begin
        PointCount:=
          LayA[LayerToSave].LyrShp[Incrementer].PPA[PartCounter];
      for PointCounter := 1 to PointCount do
      begin
{        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[PartCounter].PA[PointCounter].Zd, 8);}
      end;
    end;{for PartCounter }
end;
if ((Shapetype = 13)or(Shapetype = 15)
or (Shapetype = 23)or(Shapetype = 25)) then
begin {Z and M}
(*      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].MMax, 8); {X max}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].MMin, 8); {Y max}*)
      for PartCounter := 1 to PartCount  do
      begin
        PointCount:=
          LayA[LayerToSave].LyrShp[Incrementer].PPA[PartCounter];
      for PointCounter := 1 to PointCount do
      begin
{        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[PartCounter].PA[PointCounter].Md, 8);}
      end;
    end;{for PartCounter }
end;
  end;{for Incrementer Shapes}
end else
(********************************)

(********************************)
if ((Shapetype = 8)or(Shapetype = 18)or(Shapetype = 28)) then
begin
  Count := LayA[LayerToSave].ShapeN;
{  IndexOffset := 50;}
{  PointCount := 1;}
  IndexOffsetTotal:= 50;
    for Incrementer := 1 to LayA[LayerToSave].ShapeN do
    begin
          RunProgress(0,(Count div Incrementer));
{Write Record header}
      PointCount := Incrementer;
      SwapShapeInteger(PointCount); {Record Number}
      IndexOffset :=IndexOffsetTotal;
      SwapIndexInteger(IndexOffset);
      {Index offset + Content Length... for NEXT record... first is 50}
if ((Shapetype = 8)) then
      RecordSize := (18{22}
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 8)
      {+4}{this header data})
else if ((Shapetype = 18)) then
      RecordSize := (18{22}+16
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 16)
      {+4}{this header data})
else {if ((Shapetype = 28)) then}
      RecordSize := (18{22}+8
      +(LayA[LayerToSave].LyrShp[Incrementer].PartsN* 2)
      + (LayA[LayerToSave].LyrShp[Incrementer].PntsN  * 12)
      {+4}{this header data});
        {Content Length}
      IndexOffsetTotal:=IndexOffsetTotal + RecordSize + 4;
        {Index is Index+  (4 (header)+content)}
      SwapShapeInteger(RecordSize);
      SwapIndexInteger(RecordSize);
{Write Record Content}
      ShapeInteger := (ShapeType); {Shape Type is same for FILE}
      BlockWrite(ShapeFileOut, ShapeInteger, 4);
      {Object boundaries}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].XMin, 8); {X min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].YMin, 8); {Y min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].XMax, 8); {X max}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].YMax, 8); {Y max}
      {Number of Points  in THIS set... X and Y}
      BlockWrite(ShapeFileOut, LayA[LayerToSave].LyrShp[Incrementer].PntsN, 4);
        PointCount:=
          LayA[LayerToSave].LyrShp[Incrementer].PntsN;
      for PointCounter := 1 to PointCount do
      begin
        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[PointCounter].Xd, 8);
        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[PointCounter].Yd, 8);
      end;
      If (ShapeType=18) then {Z 18 only}
      begin{Z}
(*      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].ZMin, 8); {Z min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].ZMax, 8); {Z max}*)
      for PointCounter := 1 to PointCount do
      begin
{        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[PointCounter].Zd, 8);}
      end;
      end;
      If (ShapeType>8) then {18 and 28}
      begin{M}
(*      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].MMin, 8); {M min}
      BlockWrite(ShapeFileOut,
      LayA[LayerToSave].LyrShp[Incrementer].MMax, 8); {M max}*)
      for PointCounter := 1 to PointCount do
      begin
{        BlockWrite(ShapeFileOut,
        LayA[LayerToSave].LyrShp[Incrementer].PARA[1].PA[PointCounter].Md, 8);}
      end;
      end;
    end;
end;
          RunProgress(0,0);
      CloseFile(IndexFileOut);
      CloseFile(ShapeFileOut);
End;

procedure SaveShpDXFFile(LayerToSave:Integer;FileName:String);
var
DxfOutFile: TextFile;
{ AnythingGoS,dxfXTempS, dxfYTempS, DXFLineWidthS: string;}
 INumparts,  INumPoints,
 ShapeType, ShapeToDo,
 NumShape, NumParts, NumPoints: integer;
{ dZTemp:Double;}
Begin
{Write the Layer to a DXF File}
    AssignFile(DxfOutFile, FileName);
    Rewrite(DxfOutFile);
{Header comment and header section
It is common for the first line of a DXF file to contain a comment,
the group code for comments is 999.}
    Writeln(DxfOutFile, inttostr(999));
    Writeln(DxfOutFile, 'Ver 1.0 VOICE 2D dxf');
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'SECTION');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, 'HEADER');
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'ENDSEC');

{Tables Section
    These can be used to specify predefined constants, line styles, text styles, view
    tables, user coordinate systems, etc. We will only use tables to define some layers
    for use later on. Note: not all programs that support DXF import will support
    layers and those that do usually insist on the layers being defined before use. The
    following will initialise layer 1 for use later on.}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'SECTION');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, 'TABLES');
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'TABLE');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, 'LAYER');
    {?}
    {Writeln(DxfOutFile, 70);
    Writeln(DxfOutFile, 153);}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'LAYER');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, '0'); {layer name}
    {?}
{    Writeln(DxfOutFile, 70);
    Writeln(DxfOutFile, 0);}
    {Color}
    {Writeln(DxfOutFile, 62);
    Writeln(DxfOutFile, 15);}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'ENDTAB');
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'ENDSEC');

{Blocks section
    Not necessary here but it's good form to include one anyway. The following is an
    empty block section.}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'SECTION');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, 'BLOCKS');
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'ENDSEC');

{Entities section
    The entities section is where the geometric elements of the model or scene are
    described. The following is the standard form of the entities section.
    0 SECTION 2 ENTITIES <Geometric entities go here> 0 ENDSEC}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'SECTION');
    Writeln(DxfOutFile, inttostr(2));
    Writeln(DxfOutFile, 'ENTITIES');
    {thickness}
    {Writeln(DxfOutFile, 39);
    Writeln(DxfOutFile, 1);}
{Colour
    Only index colour is supported,
    it is done with group code 62 within an entity description.
    The value is the colour index.}
{Layers
    Layer numbers are specified with group code 8 within an entity description. The
    layers to be used should be defined as described earlier in the tables section. Most
    DXF importers will insist on predefining the layers in the tables. Note: the
    number of layers possible will vary on the software used to import the DXF file.
    The following indicates that the current entity is to be placed on layer 2
    8
    2}
{Geometry
    DXF explicitly supports two 3D primitive types, namely, 3DFACE and 3DLINE
    (usual to just use plain LINE primitive). LINE consists of the two endpoints,
    3DFACE specifies either three or four vertex facets (polygonal bounded planes).
    All four vertices must be specified, in the case of a three point facet the last vertex
    is specified twice. In general vertex group codes are numbers 10,20,30 for the first
    (x,y,z) triple, 11,21,31 for the second, 12,22,32 for the third and 13,23,33 for the
    fourth. Each vertex group code is followed by the appropriate coordinate value.
    Note: that there is no requirement for the four vertices specifying the facet to be
    planar but it may be important for the software that imports the DXF file. The
    vertices can be ordered clockwise or anticlockwise with respect to the outward
    pointing normal, however some modellers may insist on a particular
    orientation, especially rendering software.}
      ShapeType:= LayA[LayerToSave].ShpType;
      NumShape:= LayA[LayerToSave].ShapeN;
      {Point}
      If ( (ShapeType=1) or (ShapeType=11) or (ShapeType=21) )then
        begin
          For ShapeToDo:=1 to NumShape do
          Begin
          RunProgress(0,Round((ShapeToDo/NumShape)*100));

          Writeln(DxfOutFile, inttostr(0));
          Writeln(DxfOutFile, 'POINT');
          Writeln(DxfOutFile, inttostr(8));{Layer}
          Writeln(DxfOutFile, '0');
            dXTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].XMin;
            dYTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].YMin;
                  Writeln(DxfOutFile, inttostr(10));
                  Writeln(DxfOutFile,FloatToStrF(dXTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(20));
                  Writeln(DxfOutFile,FloatToStrF(dYTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(30));
               If ((ShapeType=15) or (ShapeType=13))then
               begin
{                 dZTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].ZMin;
                 Writeln(DxfOutFile,FloatToStrF(dZTemp, ffFixed,5,1));}
               end
               else  Writeln(DxfOutFile, '0.000000');
        Writeln(DxfOutFile, inttostr(0));
        Writeln(DxfOutFile, 'SEQEND');
          Writeln(DxfOutFile, inttostr(8));
          Writeln(DxfOutFile, '0');
          end;
        end;
      {Lines and Polys... into PolyLines}
      If ( (ShapeType=3) or (ShapeType=13) or (ShapeType=23)or
         (ShapeType=5) or (ShapeType=15) or (ShapeType=25))then
        {3..5:}
        begin
          For ShapeToDo:=1 to NumShape do
          Begin
          RunProgress(0,Round((ShapeToDo/NumShape)*100));
            Numparts:=LayA[LayerToSave].LyrShp[ShapeToDo].PartsN;{Numparts}

            for INumparts := 1 to Numparts do
            begin {Always at least 1 0...}
{dxf header stuff}
 {Write out Line header}
          Writeln(DxfOutFile, inttostr(0));
          Writeln(DxfOutFile, 'POLYLINE');
          Writeln(DxfOutFile, inttostr(8));{Layer}
          Writeln(DxfOutFile, '0');
          Writeln(DxfOutFile, inttostr(70));
{          Writeln(DxfOutFile, inttostr(8));}
    If ( (ShapeType=3) or (ShapeType=13) or (ShapeType=23))then
       Writeln(DxfOutFile, inttostr(8)) {3D polyline}
       else   Writeln(DxfOutFile, inttostr(1));{closed polyline}
          Writeln(DxfOutFile, inttostr(66));
          Writeln(DxfOutFile, inttostr(1));
          Writeln(DxfOutFile, inttostr(10));{who knows why}
          Writeln(DxfOutFile, '0.000000');
          Writeln(DxfOutFile, inttostr(20));{who knows why}
          Writeln(DxfOutFile, '0.000000');
          Writeln(DxfOutFile, inttostr(30));{who knows why}
          Writeln(DxfOutFile, '0.000000');
(*        Writeln(DxfOutFile, 40);
          Writeln(DxfOutFile, 1{DXFLineWidthS});
          Writeln(DxfOutFile, 41);
          Writeln(DxfOutFile, 1{DXFLineWidthS});*)

              NumPoints:=LayA[LayerToSave].LyrShp[ShapeToDo].PPA[INumparts];
              for INumPoints := 1 to NumPoints-1 do
              begin {2 points internally}
                dXTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Xd;
                dYTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Yd;
                {Write dxf points into line}
                Writeln(DxfOutFile, inttostr(0));
                Writeln(DxfOutFile, 'VERTEX');
                Writeln(DxfOutFile, inttostr(8));{Layer}
                Writeln(DxfOutFile, '0');
                  Writeln(DxfOutFile, inttostr(10));
                  Writeln(DxfOutFile,FloatToStrF(dXTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(20));
                  Writeln(DxfOutFile,FloatToStrF(dYTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(30));
               If ((ShapeType=15) or (ShapeType=13))then
               begin
{                 dZTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[INumPoints].Zd;
                 Writeln(DxfOutFile,FloatToStrF(dZTemp, ffFixed,5,1));}
               end
               else  Writeln(DxfOutFile, '0.000000');
               (* Writeln(DxfOutFile, 42);
                  Writeln(DxfOutFile, 0);
                  Writeln(DxfOutFile, 70);
                  Writeln(DxfOutFile, 32);*)
               If ((ShapeType=3) or (ShapeType=13)or (ShapeType=23))then
               begin {real lines get all the points.. polys skip last point}
                dXTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[NumPoints].Xd;
                dYTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[NumPoints].Yd;
                {Write dxf points into line}
                Writeln(DxfOutFile, inttostr(0));
                Writeln(DxfOutFile, 'VERTEX');
                Writeln(DxfOutFile, inttostr(8));{Layer}
                Writeln(DxfOutFile, '0');
                  Writeln(DxfOutFile, inttostr(10));
                  Writeln(DxfOutFile,FloatToStrF(dXTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(20));
                  Writeln(DxfOutFile,FloatToStrF(dYTemp, ffFixed,5,1));
                  Writeln(DxfOutFile, inttostr(30));
               If ((ShapeType=13))then
               begin
{                 dZTemp:=LayA[LayerToSave].LyrShp[ShapeToDo].PARA[INumparts].PA[NumPoints].Zd;
                 Writeln(DxfOutFile,FloatToStrF(dZTemp, ffFixed,5,1));}
               end
               else  Writeln(DxfOutFile, '0.000000');
               end;
             end;{INumPoints}
{Write out Line }
        Writeln(DxfOutFile, inttostr(0));
        Writeln(DxfOutFile, 'SEQEND');
          Writeln(DxfOutFile, inttostr(8));
          Writeln(DxfOutFile, '0');
            end;{INumparts}
          end;{ShapeToDo}
         end;{ShapeType}

{End of Entities}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'ENDSEC');
{    End of file
    This simply indicates the end of the DXF file,
    it is not usually necessary but good form.}
    Writeln(DxfOutFile, inttostr(0));
    Writeln(DxfOutFile, 'EOF');
    CloseFile(DxfOutFile);
End;
(*************************************************************)
(*************************************************************)

(*************************************************************)
(*************************************************************)
Function LoadDatabase(WhichLayer:Integer):Boolean;
(*var
{MyBuffer:Pointer;}
TempS,
  DBName, DBPath:String;
  Min , Max,
  ii,i,Test:Integer;
  Table1:TTable;*)
Begin(*
{    VoEditForm.VEProgressBar.Visible:= True;
    VoEditForm.VEProgressBar.Position:=0;  }
  Test:=0;
  Try
  LayA[WhichLayer].LayerDBName:=
     ChangeFileExt(LayA[WhichLayer].Filename,'.dbf');
  DBName:=LayA[WhichLayer].LayerDBName;
  LayA[WhichLayer].LayerDBPath:=LayA[WhichLayer].Path;
  DBPath:=LayA[WhichLayer].Path;

  Table1.Active := False;
  Table1.TableName:=DBName;
  Table1.DatabaseName := DBPath;
  Table1.Active := True;

  LayA[WhichLayer].AttributesN:=Table1.FieldDefs.Count;
  SetLength(LayA[WhichLayer].AttType, LayA[WhichLayer].AttributesN);
{type TFieldType =
(ftUnknown, ftString, ftSmallint, ftInteger, ftWord, ftBoolean,
ftFloat, ftCurrency, ftBCD, ftDate, ftTime, ftDateTime,
ftBytes, ftVarBytes, ftAutoInc, ftBlob, ftMemo, ftGraphic,
ftFmtMemo, ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor,
ftFixedChar, ftWideString, ftLargeint, ftADT, ftArray,
 ftReference, ftDataSet, ftOraBlob, ftOraClob, ftVariant,
 ftInterface, ftIDispatch, ftGuid);}
  for i:= 0 to Table1.FieldDefs.Count - 1 do
  begin
    LayA[WhichLayer].AttType[i].FieldNo:=
        Table1.FieldDefs[i].FieldNo;
    LayA[WhichLayer].AttType[i].Displayname:=
        Table1.FieldDefs[i].Name;
    LayA[WhichLayer].AttType[i].DataType:=
        Table1.FieldDefs[i].DataType;
    LayA[WhichLayer].AttType[i].Size:=
        Table1.FieldDefs[i].Size;
    LayA[WhichLayer].AttType[i].Precision:=
        Table1.FieldDefs[i].Precision;
    LayA[WhichLayer].AttType[i].Required:=
        Table1.FieldDefs[i].Required;
  end;


{show message('did db');}
{  with VoEditForm.VEProgressBar do     }
  begin
    Table1.Last;
    Max :=Table1.RecNo ;{ Table1.RecordCount;}
    Table1.First;
    Min :=Table1.RecNo; {0}
    for i := Min to Max do
    begin
{      VoEditForm.XYPanel.Caption:=inttostr(i);}
      Application.Processmessages;
{      Position := i;}
      SetLength(LayA[WhichLayer].LyrShp[i].AAttributes,
            LayA[WhichLayer].AttributesN);

      for ii := 0 to Table1.FieldCount - 1 do
      begin
        If LayA[WhichLayer].AttType[ii].DataType =ftString then
        Begin           { Allocate space }
        If (Table1.Fields[ii].IsNull) then
        begin
           TempS:='x';   {show message('nada');}
           {StringOfChar('x',LayA[WhichLayer].AttType[i].Size);}
           LayA[WhichLayer].LyrShp[i].AAttributes[ii]:=TempS;
        end else
        begin
        TempS:=Table1.Fields[ii].Value{.AsString};
        If Length(TempS)=0 then TempS:='Null';
        LayA[WhichLayer].LyrShp[i].AAttributes[ii]:= TempS;
             {  copy(TempS,1,LayA[WhichLayer].AttType[i].Size)}
        end;

        End else
        If (
            (LayA[WhichLayer].AttType[ii].DataType =ftSmallint)
         or (LayA[WhichLayer].AttType[ii].DataType =ftInteger)
         or (LayA[WhichLayer].AttType[ii].DataType =ftWord)
         or (LayA[WhichLayer].AttType[ii].DataType =ftLargeint)
        ) then
        Begin    { Allocate space }
LayA[WhichLayer].LyrShp[i].AAttributes[ii]:=
               IntToStr(Table1.Fields[ii].Value)

        End else
        If LayA[WhichLayer].AttType[ii].DataType =ftBoolean then
        Begin    { Allocate space }
 If Table1.Fields[ii].Value then
           LayA[WhichLayer].LyrShp[i].AAttributes[ii]:='True'
           else LayA[WhichLayer].LyrShp[i].AAttributes[ii]:='False'

        End else
        If LayA[WhichLayer].AttType[ii].DataType =ftFloat then
        Begin    { Allocate space }
LayA[WhichLayer].LyrShp[i].AAttributes[ii]:=
               FloatToStr(Table1.Fields[ii].Value)

        End else
        If LayA[WhichLayer].AttType[ii].DataType =ftCurrency then
        Begin    { Allocate space }
 LayA[WhichLayer].LyrShp[i].AAttributes[ii]:=
               Table1.Fields[ii].Value.AsCurrency

        End else
        If LayA[WhichLayer].AttType[ii].DataType =ftDateTime then
        Begin    { Allocate space }
LayA[WhichLayer].LyrShp[i].AAttributes[ii]:=
               Table1.Fields[ii].Value.AsDateTime

        End else
        LayA[WhichLayer].LyrShp[i].AAttributes[ii]:='Unknown Lost Value';
      end;
      Table1.Next;
    end;
  end;
  Result:=True;
  Test:=1;
  Finally
  If Test=0 then Result:=False;
  Table1.Active := False;
  Table1.TableName:='';
  Table1.DatabaseName := '';
  end;
    VoEditForm.VEProgressBar.Position:=0;
    VoEditForm.VEProgressBar.Visible:= False;
*)Result:=False;
End;


Function SaveDatabase(WhichLayer:Integer):Boolean;
{var
  i,ii,Test:Integer;
  TempS:String;
  dbTable: TTable;}
Begin(*
  Test:=0;
  Try
  {RunTimeDbCreate(const DatabaseName, SessionName: String): TDatabase;}
  {The following code fragment illustrates how you might
   call this function to create a database component
   for the default session at runtime:}
  LayerDBCount := 1;
  SetLength(LayDatabase,1);
  LayDatabase[LayerDBCount] :=
     RunTimeDbCreate('Layer' +LayA[WhichLayer].LayerDBName
     {IntToStr(LayerDBCount)}, '');
  { Later, create a database component at runtime }

  {Make a database table}
  dbTable:=TTable.Create(VoEditDbForm);
  with dbTable do
  begin
    Active:=False;
    DatabaseName:='sshift'+ IntToStr(LayerDBCount);
    TableType := ttDBase;
    TableName:=LayA[WhichLayer].LayerDBName;
    with FieldDefs do
    begin
      Clear;
      for i:= 0 to LayA[WhichLayer].AttributesN - 1 do
      begin
        with AddFieldDef do
        begin
          FieldNo:=LayA[WhichLayer].AttType[i].FieldNo;
          Name := LayA[WhichLayer].AttType[i].Displayname;
          DataType := LayA[WhichLayer].AttType[i].DataType;
          Size:=LayA[WhichLayer].AttType[i].Size ;
          Precision:=LayA[WhichLayer].AttType[i].Precision;
          Required:=LayA[WhichLayer].AttType[i].Required;
        end;
      end;
    End;{FieldDefs}
   CreateTable;
   dbTable.Active := True;
    VoEditForm.VEProgressBar.Visible:= True;
    VoEditForm.VEProgressBar.Position:=0;
  with VoEditForm.VEProgressBar do
  begin
    Min :=1;
    Max :=LayA[WhichLayer].ShapeN;{ Table1.RecordCount;}
    for i := Min to Max do
    begin
    dbTable.Append;
      Position := i;
      for ii := 0 to LayA[WhichLayer].AttributesN - 1 do
      begin
        If LayA[WhichLayer].AttType[ii].DataType =ftString then
        begin
        TempS:=LayA[WhichLayer].LyrShp[i].AAttributes[ii];
        If (Length(LayA[WhichLayer].LyrShp[i].AAttributes[ii])
        > LayA[WhichLayer].AttType[i].Size)then
        TempS:=copy(LayA[WhichLayer].LyrShp[i].AAttributes[ii],1,LayA[WhichLayer].AttType[i].Size);
        dbTable.Fields[ii].Value:= TempS
        {LayA[WhichLayer].LyrShp[i].AAttributes[ii] }
        end
        else If (
            (LayA[WhichLayer].AttType[ii].DataType =ftSmallint)
         or (LayA[WhichLayer].AttType[ii].DataType =ftInteger)
         or (LayA[WhichLayer].AttType[ii].DataType =ftWord)
         or (LayA[WhichLayer].AttType[ii].DataType =ftLargeint)
        ) then
        dbTable.Fields[ii].Value:=
        StrToInt(LayA[WhichLayer].LyrShp[i].AAttributes[ii])
        else If LayA[WhichLayer].AttType[ii].DataType =ftBoolean then
        begin
            If LayA[WhichLayer].LyrShp[i].AAttributes[ii]='True' then
           dbTable.Fields[ii].Value.AsBoolean:= True
           else Table1.Fields[ii].Value.AsBoolean:= False
        end
        else If LayA[WhichLayer].AttType[ii].DataType =ftFloat then
        dbTable.Fields[ii].Value:=
        StrToFloat(LayA[WhichLayer].LyrShp[i].AAttributes[ii])
        else If LayA[WhichLayer].AttType[ii].DataType =ftCurrency then
        dbTable.Fields[ii].Value.AsCurrency:=
        LayA[WhichLayer].LyrShp[i].AAttributes[ii]
        else If LayA[WhichLayer].AttType[ii].DataType =ftDateTime then
        dbTable.Fields[ii].Value.AsDateTime:=
        LayA[WhichLayer].LyrShp[i].AAttributes[ii]
        else
        dbTable.Fields[ii].Value:=ftUnknown;
      end;
    end;
    dbTable.Post;
  end;

   dbTable.Active := False;
   end;{Dbtable}
  Result:=True;
  Test:=1;
  Finally
  If Test=0 then Result:=False;
   LayerDBCount := 0;
   SetLength(LayDatabase,0);
    VoEditForm.VEProgressBar.Position:=0;
    VoEditForm.VEProgressBar.Visible:= False;
  end; *)Result:=False;
End;

{---------------------------------------------------------------------}

function RunTimeDbCreate(
  const DatabaseName, SessionName: string): TDatabase;
var
  TempDatabase: TDatabase;
begin
TempDatabase := nil;
RunTimeDbCreate:=TempDatabase;
 (*

  try
    { If the session exists, make it active; if not, create a new session }
    Sessions.OpenSession(SessionName);
    with Sessions do
      with FindSession(SessionName) do begin
        Result := FindDatabase(DatabaseName);
        if (Result = nil) then begin
          { Create a new database component }
          TempDatabase := TDatabase.Create(Self);
          TempDatabase.DatabaseName :=
            {'sshift' + IntToStr(MyDbCount)}
             DatabaseName;
          TempDatabase.SessionName := SessionName;
          ConfigMode := cmSession;
          try
            AddStandardAlias(DatabaseName, ShapePath, 'DBASE');
          finally
            ConfigMode := cmAll;
            TempDatabase.KeepConnection := False; {True;}
          end; {finally}
        end; {Result}
        Result := OpenDatabase(DatabaseName);
      end;
  except
    TempDatabase.Free;
    raise;
  end;*)
end;
(*************************************************************)
(*************************************************************)





end.
