{*******************************************************}
{                                                       }
{                      Tachyon Unit                     }
{    Vector Raster Geographic Information Sysnthesis    }
{                 Image Locatable Holographics          }
{                 Digital Terrain Mapping               }
{       Copyright (c) 1995,2002  Ivan Lee Herring       }
{                                                       }
{*******************************************************}
unit DtmGlfrm;
//Landscape Demo By Ren Lindsay
//           program Navigator;
// It demonstrates an Actor on a Heightfield landscape.
// The actor was downloaded from www.polycount.com
// The heightfied and texture was generated by Terragen
//          (see http://www.terragen.de/index.htm)
//
// Sample Perf (default map, default size, etc.):
//         K6-400 + Voodoo3 (16bits)     =  13 FPS
//        Centrum-400 + Radeon II ddr(32bits)  =  13..28 FPS
//         K7-500 + GeForce SDR (32bits) = 150 FPS
{
Drag with the Left mouse-button to rotate the camera.
Use the mouse-wheel, or slider to adjust camera distance.
Use the cursor keys to control the girl around the mountain.
The Left image is used as the landscape heightfield. (256x256 bmp)
The Right image is used as the Texturemap. (1024x1024 jpg)
They were both generated with Terragen.
Modified by Ivan Lee Herring, 2002
}


interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  GR32,
  GLScene, ExtCtrls, GLMisc, GLObjects,
  GLCadencer, StdCtrls, GLVectorFileObjects,
  Buttons, ComCtrls, Keyboard, jpeg, GLGraph,
  Geometry, VectorTypes, GLFireFX, GLSkydome,
  GLTexture, ExtDlgs, GLWin32Viewer;


type
  TdtmGlForm = class(TForm)
    Panel1: TPanel;
    GLCadencer1: TGLCadencer;
    DistanceBar: TTrackBar;
    GLSceneViewer1: TGLSceneViewer;
    GLScene1: TGLScene;
    GLLightSource1: TGLLightSource;
    GLCamera1: TGLCamera;
    ActorCube: TGLDummyCube;
    Image1: TImage;
    Image2: TImage;
    HeightField1: TGLHeightField;
    AllObjects: TGLDummyCube;
    CameraCube: TGLDummyCube;
    AfterSky: TGLDummyCube;
    Label1: TLabel;
    Timer1: TTimer;
    OpenPictureDialog1: TOpenPictureDialog;
    HeightTrackBar1: TTrackBar;
    EnableHeightCB: TCheckBox;
    Edit1: TEdit;
    HeightMaxMinCB: TCheckBox;
    OpenDialog1: TOpenDialog;
    TextureCB: TCheckBox;
    Light1: TGLLightSource;
    ScaleTrackBar: TTrackBar;
    ScaleSampleTrackBar: TTrackBar;
    ResetDefaultsBtn: TSpeedButton;
    HTBLabel: TLabel;
    SaTBLabel: TLabel;
    STBLabel: TLabel;
    procedure HandleKeys(const deltaTime: Double);
    procedure GLCadencer1Progress(Sender: TObject;
               const deltaTime, newTime: Double);
    procedure FormCreate(Sender: TObject);
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject;
             Shift: TShiftState;
             X, Y: Integer);
    procedure DistanceBarChange(Sender: TObject);
    procedure HeightField1GetHeight(const x, y: Single;
      var z: Single;
      var color: TVector4f; var texPoint: TTexPoint);
    procedure FormMouseWheel(Sender: TObject;
               Shift: TShiftState;
               WheelDelta: Integer;
               MousePos: TPoint;
               var Handled: Boolean);
    procedure Image2DblClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Image1DblClick(Sender: TObject);
procedure FormShowDown;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormHide(Sender: TObject);
    procedure HeightMaxMinCBClick(Sender: TObject);
    procedure EnableHeightCBClick(Sender: TObject);
    procedure HeightTrackBar1Change(Sender: TObject);
    procedure TextureCBClick(Sender: TObject);
    procedure ScaleTrackBarChange(Sender: TObject);
    procedure ScaleSampleTrackBarChange(Sender: TObject);
    procedure ResetDefaultsBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    snowyMapActive : Boolean;
  end;

var
  dtmGlForm: TdtmGlForm;
  dtmGlmx,dtmGlmy,dtmGlmx2,dtmGlmy2:integer;
  ReadytoGo:Boolean;
implementation

{$R *.DFM}
uses dtmfrm,
dtmPOFvar,
dtmGlobals;

procedure TdtmGlForm.FormHide(Sender: TObject);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
end;
procedure TdtmGlForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  NoGLRunning:=True;
  DTMGLFormY := dtmGlForm.top;
  DTMGLFormX := dtmGlForm.left;
  DoSaver;
end;

procedure TdtmGlForm.FormCreate(Sender: TObject);
begin
  top := DTMGLFormY;
  left := DTMGLFormX;
  SetCurrentDir(ExtractFilePath(Application.ExeName));
  ReadytoGo:=False;
  Timer1.Enabled:=False;
  GLCadencer1.Enabled:=False;
  snowyMapActive:=True;
  Heightfield1.Material.Texture.Image.assign(Image2.picture.Graphic);
  Heightfield1.Material.Texture.Disabled:=False;
end;

procedure TdtmGlForm.FormShowDown;
begin
   ReadytoGo:=True;
   Timer1.Enabled:=True;
   GLCadencer1.Enabled:=True;
   Heightfield1.StructureChanged;
end;

procedure TdtmGlForm.HandleKeys(const deltaTime: Double);
const
   cTurnSpeed = 100;
   cMoveSpeed = 9;
var
   hgt :single;
   HV :THomogeneousFltVector;
   tp  :TTexPoint;
   xpos,zpos :single;
begin
  if IsKeyDown(VK_ESCAPE) then Close;
  if IsKeyDown(VK_UP) or IsKeyDown(VK_DOWN)
     or IsKeyDown(VK_LEFT) or IsKeyDown(VK_RIGHT) then
  begin
    if IsKeyDown(VK_LEFT)    then
       ActorCube.Turn(-cTurnSpeed*deltaTime);      //rotate actor left
    if IsKeyDown(VK_RIGHT)   then
       ActorCube.Turn(cTurnSpeed*deltaTime);       //rotate actor right

    if IsKeyDown(VK_UP) then
       ActorCube.Move(cMoveSpeed*deltaTime);
    if IsKeyDown(VK_DOWN) then
       ActorCube.Move(-cMoveSpeed*deltaTime);
    xpos:=-(ActorCube.position.x/HeightField1.Scale.x);
    //calc actors position on heightfield
    zpos:=(ActorCube.position.z/HeightField1.Scale.y);
    Heightfield1GetHeight(Xpos,Zpos,hgt,HV,tp);
    //get hgt ---this is the same procedure used
    //to get the heightfields heights
    ActorCube.position.Y:=
    (hgt*HeightField1.Scale.z)+(HeightField1.Position.y)+1.2;
     //place actor just above heightfield
    CameraCube.position:=ActorCube.Position;
    //move camera to actors position
 end;

 //----   Move camera around the target.
 //----   This code is placed here so the
 //  camera-movements would not cause the Actor to pause
 if ((dtmGlmx<>dtmGlmx2)or(dtmGlmy<>dtmGlmy2)) then
 begin
    GLCamera1.MoveAroundTarget(dtmGlmy-dtmGlmy2, dtmGlmx-dtmGlmx2);
     //move the camera around the target if mouse was dragged
    dtmGlmx:=dtmGlmx2;
    dtmGlmy:=dtmGlmy2;
 end;
end;

procedure TdtmGlForm.GLCadencer1Progress(Sender: TObject;
                const deltaTime, newTime: Double);
begin
   HandleKeys(deltaTime);
end;

procedure TdtmGlForm.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   dtmGlmx:=x;
   dtmGlmy:=y;
   dtmGlmx2:=x;
   dtmGlmy2:=y;
end;

procedure TdtmGlForm.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if ssLeft in Shift then begin
      dtmGlmx2:=x;
      dtmGlmy2:=y;
   end;
end;

procedure TdtmGlForm.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
   GLCamera1.AdjustDistanceToTarget(Power(1.1, WheelDelta/120));
   //Adjust Camera distance with mousewheel
end;

procedure TdtmGlForm.DistanceBarChange(Sender: TObject);
var
   Dist, NewDist,cx,cy,cz :single;
begin
   Dist:=GLCamera1.DistanceToTarget;
   cx:=GLCamera1.Position.x;
   cy:=GLCamera1.Position.y;
   cz:=GLCamera1.Position.z;
   NewDist:=DistanceBar.position;
   GLCamera1.Position.x:=cx/dist*NewDist;
   GLCamera1.Position.y:=cy/dist*NewDist;
   GLCamera1.Position.z:=cz/dist*NewDist;
end;


procedure TdtmGlForm.EnableHeightCBClick(Sender: TObject);
begin
  Heightfield1.StructureChanged;
end;

procedure TdtmGlForm.HeightMaxMinCBClick(Sender: TObject);
begin
  Heightfield1.StructureChanged;
end;

procedure TdtmGlForm.HeightTrackBar1Change(Sender: TObject);
begin
  If (ReadytoGo {and ( not EnableHeightCB.Checked)})
      then Heightfield1.StructureChanged;
  HTBLabel.Caption:=Inttostr(HeightTrackBar1.Position);
end;
procedure TdtmGlForm.ScaleTrackBarChange(Sender: TObject);
begin
  If (ReadytoGo {and ( not EnableHeightCB.Checked)})
  then begin
  STBLabel.Caption:=Inttostr(ScaleTrackBar.Position);
   Heightfield1.Scale.X:=ScaleTrackBar.Position;
   Heightfield1.Scale.Y:=ScaleTrackBar.Position;
   Heightfield1.StructureChanged;
   end;
end;
procedure TdtmGlForm.ScaleSampleTrackBarChange(Sender: TObject);
begin
  If (ReadytoGo {and ( not EnableHeightCB.Checked)})
  then begin
  SaTBLabel.Caption:=Floattostr((ScaleSampleTrackBar.Position/10000));
   Heightfield1.XSamplingScale.Step:=(ScaleSampleTrackBar.Position/10000);
   Heightfield1.YSamplingScale.Step:=(ScaleSampleTrackBar.Position/10000);
   Heightfield1.StructureChanged;
   end;
end;
procedure TdtmGlForm.ResetDefaultsBtnClick(Sender: TObject);
begin
  HeightMaxMinCB.Checked:=False;
  TextureCB.Checked:=True;
  EnableHeightCB.Checked:=True;
  ScaleTrackBar.Position:= 100;
  ScaleSampleTrackBar.Position:= 100;
  HeightTrackBar1.Position:= 5;
  DistanceBar.Position:= 5;
end;
procedure TdtmGlForm.HeightField1GetHeight(
          const x, y: Single;
          var z: Single;
          var color: TVector4f;
          var texPoint: TTexPoint);
var
   val : integer;
   xi,yi : integer;
begin
val:=1;
  If EnableHeightCB.Checked then
  begin
    xi:=round(x*(Image1.Picture.Width-1));
    //translate heightfield coordinate to Image1 pixel number
    yi:=round((1-y)*(Image1.Picture.Height-1));
    val:=(Image1.Picture.Bitmap.Canvas.Pixels[xi,yi]) AND $000000FF;
    //use brightness of heightmap pixel
    //to calculate height of point x,y
    z:=val*0.05;
     //return the height of the landscape in z  at position x,y
  end else
  If ReadytoGo then
(*  val:=htf.XYHeight(round(x{*(htf.SizeX-1)}),
                 round((y){*(htf.SizeY-1)}));
  z:=val*0.05;*)

  begin  {z:=ManMatrix[round(x),round(y)]}
    If ((round(x*(FileSizeX-1))>0)and
        (round(x*(FileSizeX-1))<FileSizeX)and
        (((y)*(FileSizeY-1))>0)and
        (((y)*(FileSizeY-1))<FileSizeY))
    then
    begin
      val:=ManMatrix[round(x*(FileSizeX-1)),
                 round((y)*(FileSizeY-1))];
      If HeightMaxMinCB.Checked then
         z:=val*(HeightTrackBar1.Position
                  /(  MaximumElevation-MinimumElevation)) else
         z:=val*(HeightTrackBar1.Position/1000){ else
         z:=val*0.05};
    end else z:=1;
  end;

If (not TextureCB.Checked) then
  begin
    {Color.. according to Height... }
{    color:=WinColor(heightColor[val]);}
{    If val<MinimumElevation then color:=clrBlue
    else} If val< (MaximumElevation div 4)then
       VectorLerp(clrGreen, clrOlive, (val+1)/2, color)
       else VectorLerp(clrYellow, clrPurple, (val+1)/2, color);
  end;
end;

procedure TdtmGlForm.TextureCBClick(Sender: TObject);
begin
   Heightfield1.Material.Texture.Disabled:=
   (not TextureCB.Checked);
   If TextureCB.Checked then
        heightfield1.material.texture.texturemode:=  tmDecal
      else
        heightfield1.material.texture.texturemode:=  tmModulate;
end;

procedure TdtmGlForm.Image2DblClick(Sender: TObject);
begin
   if OpenPictureDialog1.Execute then
      Image2.Picture.LoadFromFile(OpenPictureDialog1.FileName);
   Heightfield1.Material.Texture.Image.assign(Image2.picture.Graphic);
end;

procedure TdtmGlForm.Image1DblClick(Sender: TObject);
begin
   if OpenPictureDialog1.Execute then
      Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
   Heightfield1.StructureChanged;
   {   if OpenPictureDialog1.Execute then
      Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
   Heightfield1.StructureChanged;         }
{   if OpenPictureDialog1.Execute then
      Image2.Picture.LoadFromFile(OpenPictureDialog1.FileName);
   Heightfield1.Material.Texture.Image.assign(Image2.picture.Graphic);}
end;

procedure TdtmGlForm.Timer1Timer(Sender: TObject);
begin
   Caption:=Format('%.1f FPS', [GLSceneViewer1.FramesPerSecond]);
   GLSceneViewer1.ResetPerformanceMonitor;
end;


{==============================================================}
{==============================================================}

{==============================================================}
{==============================================================}

{==============================================================}
{==============================================================}

{==============================================================}
{==============================================================}









end.
