/***************************************************************************

 bmp2mp1.c - phase one of bmp2map

(tabs=4)
***************************************************************************/


#include    <stdio.h>
#include    <string.h>
#include	<stdlib.h>


#include	"bmp2map.h"


/*** savebrush() - save coorinates and texture for brush
***/
void savebrush( FILE *fp, QEXTREMES *qe, long *brushcnt,
				int x1, int x2, int y1, int y2,
				int z1, int z2, int texture)
{
	BRUSH b;

	/* track extremes */
	if( x1 < qe->minx) qe->minx = x1;
	if( x2 > qe->maxx) qe->maxx = x2;
	if( y1 < qe->miny) qe->miny = y1;
	if( y2 > qe->maxy) qe->maxy = y1;

	b.x1 = x1; b.x2 = x2;
	b.y1 = y1; b.y2 = y2;
	b.z1 = z1; b.z2 = z2;
	b.texture = texture;

	/* save the brush in the .MP1/2 file */
	fwrite( &b, sizeof(BRUSH), 1, fp);
	++(*brushcnt);
	return;
} /*** savebrush() ***/


/*** boundmap() - write brushes for box around map (make map leak-proof)
***/
void boundmap( CFG *cfg, FILE *mp1fp, QEXTREMES *qe, long *brushcnt)
{
	if( cfg->sealtopbottom)
	{
		/* write floor and ceiling brushes */
		/* Z */
		savebrush( mp1fp, qe, brushcnt,
			qe->minx, qe->maxx,
			qe->miny, qe->maxy,
			cfg->ceiling, cfg->ceiling + cfg->outerqunits,
			CEILINGBRUSH);

		savebrush( mp1fp, qe, brushcnt,
			qe->minx, qe->maxx,
			qe->miny, qe->maxy,
			cfg->floor - cfg->outerqunits, cfg->floor,
			FLOORBRUSH);
	}

	if( cfg->sealsides)
	{
		/* surround the whole dang thing (leakproof) */
		/* X */
		savebrush( mp1fp, qe, brushcnt,
			qe->minx - cfg->outerqunits, qe->minx,
			qe->miny, qe->maxy,
			cfg->floor - cfg->outerqunits, cfg->ceiling + cfg->outerqunits,
			SKYBRUSH);

		savebrush( mp1fp, qe, brushcnt,
			qe->maxx, qe->maxx + cfg->outerqunits,
			qe->miny, qe->maxy,
			cfg->floor - cfg->outerqunits, cfg->ceiling + cfg->outerqunits,
			SKYBRUSH);


		/* Y */
		savebrush( mp1fp, qe, brushcnt,
			qe->minx, qe->maxx,
			qe->miny - cfg->outerqunits, qe->miny,
			cfg->floor - cfg->outerqunits, cfg->ceiling + cfg->outerqunits,
			SKYBRUSH);

		savebrush( mp1fp, qe, brushcnt,
			qe->minx, qe->maxx,
			qe->maxy, qe->maxy + cfg->outerqunits,
			cfg->floor - cfg->outerqunits, cfg->ceiling + cfg->outerqunits,
			SKYBRUSH);
	}

	return;
} /*** boundmap() ***/


/*** pel2brush() - calculate Quake units given pixels location in .BMP
***/

void pel2brush( CFG *cfg, FILE *fp, QEXTREMES *qe, long *brushcnt,
				int x, int y, int zbot, int ztop, int texture)
{
	int qx1, qx2, qy1, qy2;

	/* calculate quake coordinates from bitmap coordinates */
	qx1 = qe->xbase + cfg->qunitsperpel * x;
	qx2 = qe->xbase + cfg->qunitsperpel * (x+1);
	qy1 = qe->ybase + cfg->qunitsperpel * y;
	qy2 = qe->ybase + cfg->qunitsperpel * (y+1);


	/* if brush is an arrow brush or a teleport platform brush
		then do a calculation to place at even (not odd) values
	*/
	if( (texture >= RNARROWBRUSH) && (texture <= BWARROWBRUSH))
	{
		qx1 = qx1 - ( (cfg->arrowbrushqunits - cfg->qunitsperpel) / 4 ) * 2;
		qx2 = qx1 + cfg->arrowbrushqunits;
		qy1 = qy1 - ( (cfg->arrowbrushqunits - cfg->qunitsperpel) / 4 ) * 2;
		qy2 = qy1 + cfg->arrowbrushqunits;
	}
	else if( texture == TELEPLATBRUSH)
	{
		qx1 = qx1 - ( (cfg->teleplatbrushqunits - cfg->qunitsperpel) / 4 ) * 2;
		qx2 = qx1 + cfg->teleplatbrushqunits;
		qy1 = qy1 - ( (cfg->teleplatbrushqunits - cfg->qunitsperpel) / 4 ) * 2;
		qy2 = qy1 + cfg->teleplatbrushqunits;
	}

	/* save brush to .MP1/.MP2 file */
	savebrush( fp, qe, brushcnt, qx1, qx2, qy1, qy2, zbot, ztop, texture);
	return;
} /*** pel2brush() ***/


/*** saveent() - calculate Quake units and save entity string
***/
void saveent( CFG *cfg, FILE *entfp, QEXTREMES *qe, int x, int y, char *entstring)
{
	int qx, qy;

	/* calculate quake coordinates from bitmap coordinates */
	qx = qe->xbase + cfg->qunitsperpel * x + (cfg->qunitsperpel/2);
	qy = qe->ybase + cfg->qunitsperpel * y + (cfg->qunitsperpel/2);

	myfprintf( entfp,
		"{\n\"classname\" \"%s\"\n",entstring);

	if( ! strcmp( "light", entstring))
		myfprintf( entfp, "\"light\" \"%d\"\n", cfg->lightlevel);

	myfprintf( entfp, "\"origin\" \"%d %d %d\"\n}\n", qx, qy, qe->zmiddle);
	return;


} /*** saveent() ***/


/*** initbmp() - read bitmap header and palette
***/
void initbmp( FILE *bmpfp, BITMAPINFOHEADER *bmih)
{
	BITMAPFILEHEADER bmfh; /* bit map file header */
	RGBQUAD rgbq;          /* RGBx foursome for palette */
	int i;

	/* read file header */
	if( fread( &bmfh, sizeof( BITMAPFILEHEADER), 1, bmpfp) != 1)
	{
		logprintf("Error reading .BMP.\n");
		exit(1);
	}

	/* check to see if it is a valid bitmap file */
	if( bmfh.bfType != MUSTBETYPE)
	{
		logprintf(".BMP is not a valid bitmap.\n");
		exit(1);
	}

	if( bmfh.bfReserved1 || bmfh.bfReserved2)
	{
		logprintf("Reserved fields are not 0?\n");
		exit(1);

	}
	logprintf(".BMP is %ld bytes long.  Image offset is %ld.\n",
		bmfh.bfSize, bmfh.bfOffBits);

	/* read info header */
	if( fread( bmih, sizeof( BITMAPINFOHEADER), 1, bmpfp) != 1)
	{
		logprintf("Error reading .BMP\n");
		exit(1);
	}

	if( bmih->biPlanes != 1)
	{
		logprintf(".BMP has incorrect value (%d) for biPlanes.\n",
			bmih->biPlanes);
		exit(1);
	}

	/* check for 256 colors */
	if( bmih->biBitCount != 8)
	{
		logprintf("Not a 8-bit (256 color) .BMP\n");
		exit(1);
	}

	/* make sure not .RLE */
	if( bmih->biCompression != BI_RGB)
	{
		logprintf("Only uncompressed .BMPs allowed.\n");
		exit(1);
	}

	logprintf("Header: %ld bytes   Image: %ld bytes\n",
		bmih->biSize, bmih->biSizeImage);
	logprintf("%ld x %ld pixels w/ %ld colors, %ld of which are \"important\"\n",
		bmih->biWidth, bmih->biHeight, bmih->biClrUsed, bmih->biClrImportant);
	logprintf("Pixels/Meter = %ld x %ld\n",
		bmih->biXPelsPerMeter, bmih->biYPelsPerMeter);

	/* skip palette entries */
	for( i = 0; i < bmih->biClrUsed; i++)
	{
		if(	fread( &rgbq, sizeof(RGBQUAD), 1, bmpfp) != 1)
		{
			logprintf("Error reading palette information.\n");
			exit(1);
		}
#ifdef DEBUG
		logprintf("Index: %02x   Red: %02x  Green: %02x  Blue:%02x\n",
			i, rgbq.rgbRed, rgbq.rgbGreen, rgbq.rgbBlue);
#endif
	}
	return;
} /*** initbmp() ***/


/*** bmp2mp1() - read bitmap recording brushes encountered
				 returns the number of brushes recorded
***/
void bmp2mp1( char *inname, char *outname, CFG *cfg, QEXTREMES *qe,
	long *mp1brushcnt, long *mp3brushcnt)
{
	FILE *bmpfp, *mp1fp, *mp3fp, *entfp;
	int x, y, i;
	BYTE pel;
	WORD xWidth;
	char bmpfile[FILENAMESIZE], mp1file[FILENAMESIZE], entfile[FILENAMESIZE], mp3file[FILENAMESIZE];
	BITMAPINFOHEADER bmih; /* bit map information header */
	int entcnt = 0;     /* "" entities */
	int lightcnt = 0;   /* "" lights (auto) */


	/* initialize brush counters */
	*mp1brushcnt = *mp3brushcnt = 0L;

	/* prepare file names */
	strcpy( bmpfile, inname);
	strcat( bmpfile, BMPEXT);
	strcpy( mp1file, outname);
	strcat( mp1file, MP1EXT);
	strcpy( mp3file, outname);
	strcat( mp3file, MP3EXT);
	strcpy( entfile, outname);
	strcat( entfile, ENTEXT);


	/* open the file */
	logprintf("Reading file %s\n", bmpfile);
	if ((bmpfp = fopen(bmpfile,"rb")) == NULL)
	{
		logprintf("Error opening file %s.\n",bmpfile);
		exit(1);
	}

	/* read bitmap information header */
	initbmp( bmpfp, &bmih);

	/* open brush output files */
	if( ( mp1fp = fopen( mp1file, "wb")) == NULL)
		error("Unable to open file %s for output.\n", mp1file);
	if( ( mp3fp = fopen( mp3file, "wb")) == NULL)
		error("Unable to open file %s for output.\n", mp3file);

	/* open entity output file */
	if( ( entfp = fopen( entfile, "w")) == NULL)
	{
		logprintf("Unable to open file %s for output.\n", entfile);
		exit(1);
	}

	/* calculate base quake coordinates so map is centered at origin */
	qe->xbase = ((int) bmih.biWidth/2) * cfg->qunitsperpel;
	qe->xbase += cfg->qunitsperpel - (qe->xbase%cfg->qunitsperpel);
	qe->xbase = - (qe->xbase);

	qe->ybase = ((int) bmih.biHeight/2) * cfg->qunitsperpel;
	qe->ybase += cfg->qunitsperpel - (qe->ybase%cfg->qunitsperpel);
	qe->ybase = - (qe->ybase);

	qe->minx = EXTREME;		/* Smallest X (in Quake units) encountered */
	qe->maxx = -EXTREME;		/* Largest "" */
	qe->miny = EXTREME;		/* Like above for Y */
	qe->maxy = -EXTREME;		/* "" */


	/* calculate number of bytes for each line (padding to `long's) */
	xWidth = bmih.biWidth;
	if( xWidth % 4) xWidth += 4 - (xWidth%4);
	for( y = 0; y < bmih.biHeight; y++)
	{
		logprintf(".");  /* progress indicator - one per line read */
		for( x = 0; x < xWidth; x++)
		{
			pel = (BYTE) fgetc(bmpfp);

			/* if not padding */
			if( x < bmih.biWidth)
			{
				/* write brush depending upon pixels color */

				if( pel == cfg->wallval) /* wall */
				{
					/* write walls in parts - in hopes of good brush
					   reduction with windows/doors - go with FRAMEBRUSH
					   since top/bottom of wall is never visible (?) -
					   also, write FRAMEBRUSHes from top to bottom in
					   hopes of getting better brush compression
					*/

					/* if door top is higher than window top, write these three */
					if( cfg->doortop > cfg->wintop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->doortop, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->winbottom, cfg->wintop, FRAMEBRUSH);
					}
					/* else if window top is higher than door top, write these three */
					else if( cfg->doortop < cfg->wintop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->wintop, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->winbottom, cfg->doortop, FRAMEBRUSH);
					}
					/* otherwise, they're equal, write these two */
					else
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->winbottom, cfg->wintop, FRAMEBRUSH);

					}
					/* write floor to window bottom */
					pel2brush( cfg, mp3fp, qe, mp3brushcnt,
						x, y, cfg->floor, cfg->winbottom, FRAMEBRUSH);

				}
				else if( pel == cfg->winval) /* window */
				{
					if( cfg->doortop > cfg->wintop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->doortop, FRAMEBRUSH);

					}
					else
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->ceiling, FRAMEBRUSH);
					}
					pel2brush( cfg, mp3fp, qe, mp3brushcnt,
						x, y, cfg->floor, cfg->winbottom, FRAMEBRUSH);
				}
				else if( pel == cfg->doorval) /* door */
				{
					if( cfg->wintop > cfg->doortop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->wintop, FRAMEBRUSH);
					}
					else
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
					}
					pel2brush( cfg, mp1fp, qe, mp1brushcnt,
						x, y, cfg->floor, cfg->doortop, DOORBRUSH);
				}
				else if( pel == cfg->doorframeval) /* door frame */
				{
					if( cfg->wintop > cfg->doortop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->wintop, FRAMEBRUSH);
					}
					else
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
					}
				}
				else if( pel == cfg->skywinval) /* skyed window */
				{
					if( cfg->doortop > cfg->wintop)
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->doortop, cfg->ceiling, FRAMEBRUSH);
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->doortop, FRAMEBRUSH);

					}
					else
					{
						pel2brush( cfg, mp3fp, qe, mp3brushcnt,
							x, y, cfg->wintop, cfg->ceiling, FRAMEBRUSH);
					}
					pel2brush( cfg, mp1fp, qe, mp1brushcnt,
						x, y, cfg->winbottom, cfg->wintop, SKYBRUSH);
					pel2brush( cfg, mp3fp, qe, mp3brushcnt,
						x, y, cfg->floor, cfg->winbottom, FRAMEBRUSH);
				}
				else if( pel == cfg->carvefloorval) /* carve floor */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->floor-cfg->outerqunits-1,
						cfg->floor+1,
						CARVEBRUSH);
				}
				else if( pel == cfg->carveceilingval) /* carve ceiling */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1,
						cfg->ceiling+cfg->outerqunits+1,
						CARVEBRUSH);
				}
				else if( pel == cfg->carvebothval) /* carve both */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->floor-cfg->outerqunits-1,
						cfg->floor+1,
						CARVEBRUSH);

					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1,
						cfg->ceiling+cfg->outerqunits+1,
						CARVEBRUSH);
				}
				else if( pel == cfg->skyceilingval) /* skyed ceiling */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1,
						cfg->ceiling+cfg->outerqunits+1,
						SKYBRUSH);
				}
				else if( pel == cfg->triggerval) /* trigger */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->floor + cfg->outerqunits,
						cfg->ceiling - cfg->outerqunits,
						TRIGGERBRUSH);
				}
				else if( pel == cfg->rnaval) /* red north arrow */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, RNARROWBRUSH);
				}
				else if( pel == cfg->rsaval) /* red south */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, RSARROWBRUSH);
				}
				else if( pel == cfg->reaval) /* red east */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, REARROWBRUSH);
				}
				else if( pel == cfg->rwaval) /* etc. */
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, RWARROWBRUSH);
				}
				else if( pel == cfg->bnaval)
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, BNARROWBRUSH);
				}
				else if( pel == cfg->bsaval)
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, BSARROWBRUSH);
				}
				else if( pel == cfg->beaval)
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, BEARROWBRUSH);
				}
				else if( pel == cfg->bwaval)
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->ceiling-1, cfg->ceiling, BWARROWBRUSH);
				}
				else if( pel == cfg->teleplatval)
				{
					pel2brush( cfg, mp1fp, qe, mp1brushcnt, x, y,
						cfg->floor, cfg->floor+4, TELEPLATBRUSH);
				}

				/*	colors can be shared between brush types and entities.
					eg. color XXX could be a teleport platform and an
					info_player_deathmatch
				*/

				/* search entity list for a match */
				for( i = 0; i < cfg->numents; i++)
				{
					if( pel == cfg->ents[i].entval)
					{
						entcnt++;
						saveent( cfg, entfp, qe, x, y, cfg->ents[i].entstring);
						break;
					}
				}
			}
		}
	}


	/* put start at origin */
	/* not 0,0 because it may cause problems (??? empty hulls ???) */
	if( cfg->autostart)
	{
		myfprintf( entfp,
		"{\n\"classname\" \"info_player_start\"\n\"origin\" \"2 2 %d\"\n}\n",
			qe->zmiddle);
		entcnt++;
	}

	/* if autolight write light entities using interval specified */
	if( cfg->autolight)
	{
		for( x = qe->minx+cfg->autolightqunits; x < qe->maxx; x += cfg->autolightqunits)
		{
			for( y = qe->miny+cfg->autolightqunits; y < qe->maxy; y+=cfg->autolightqunits)
			{
				myfprintf( entfp, "{\n\"classname\" \"light\"\n");
				myfprintf( entfp, "\"light\" \"%d\"\n", cfg->lightlevel);
				myfprintf( entfp,"\"origin\" \"%d %d %d\"\n}\n",
					x,y,qe->zmiddle);

				lightcnt++;
				entcnt++;
			}
		}
	}

	/* show extremes and close files */
	logprintf("\nX: %d to %d  by Y: %d to %d\n",
		qe->minx, qe->maxx, qe->miny, qe->maxy);
	fclose( bmpfp);
	fclose( entfp);
	fclose( mp3fp);
	boundmap( cfg, mp1fp, qe, mp1brushcnt); /* seal map in a box (leak-proof) */
	fclose( mp1fp);

	logprintf("%ld brushes written to %s.\n", *mp1brushcnt, mp1file);
	logprintf("%ld brushes written to %s.\n", *mp3brushcnt, mp3file);
	logprintf("%d entities written to %s.\n", entcnt, entfile);
} /*** bmp2mp1() ***/





/*** EOF ***/
