/***************************************************************************

 bmp2map.h - header file for bmp2map modules

***************************************************************************/
/***************************************************************************

   bmp2map - A conversion utility to convert 256 color .BMPs into
	(v.05)   Quake .MAPs.

             It's intended use is to quickly convert 2D floor/street
             plans into 3D maps.

             Pixel colors are used to create boxes textured as solid walls,
             doors, windows or windows filled with sky (for outside walls).

   Author - Jack Perdue (aka Silicon Slick) - si_slick@cy-net.net

	 v.01 - May 10th, 1997
	 v.02 - Friday, June 13th, 1997
	 v.03 - July 5th, 1997
	 v.04 - July 11th, 1997
	 v.05 - July 22nd, 1997

 Compiler - Borland TurboC 2.0 for MS-DOS

 Copyright(C) 1997 - Silicon Slick's Software, Supplies and Support Services
         http://www2.cy-net.net/~si_slick  si_slick@cy-net.net

	You are welcome to copy and modify this code at will as long as you
	   include this copyright statement in all derivative works.
		   You may distribute any derivative products for free.

							   HOWEVER,

	No products derived from this program, either .MAPs or other programs,
  may be sold without the expressed, written and signed consent of the author.

	  (That is, if it helps you make some bucks, I deserve a chunk. ;)

                 "Quake" is copyright id Software

(tabs=4)
***************************************************************************/

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;

#define	TRUE	1
#define FALSE   0
#define	CFGEXT	".cfg"
#define	BMPEXT	".bmp"
#define MP1EXT	".mp1"
#define MP2EXT	".mp2"
#define	MP3EXT	".mp3"
#define MAPEXT	".map"
#define	ENTEXT	".en1"
#define	LOGEXT	".log"

#define MUSTBETYPE  	(((WORD) 'M' << 8) | 'B') /* 1st 2bytes must=='BM' */
#define	BI_RGB			0L  /* uncompressed 256 color .BMPs only */
#define	BI_RLE8			1L	/* not supported */
#define	BI_RLE4			2L	/* not supported */

#define DEFQUNITSPERPEL	4		/* Quake units per pixel (box thickness) */
#define	DEFOUTERQUNITS	8		/* thickness of ceiling/floor in Qunits */
#define	DEFFLOOR		-64		/* z for floor */


#define	DEFAUTOLIGHT	TRUE	/* automatically add lights? */
#define	DEFAUTOLIGHTQU	128		/* interval (in Quake units) for lights */
#define	DEFAUTOSTART	TRUE			/* put info_player_start at center? */
#define	DEFWORLDSPAWN	TRUE		/* enclose brushes in "worldspawn"? */
#define	DEFWALLTEXT		"wbrick1_5"		/* texture name for walls/ceilings/floors */
#define DEFDOORTEXT		"door02_3"		/* "" doors */
#define DEFSKYTEXT		"sky4"			/* "" sky for windows to the outside */
#define	DEFFLOORTEXT	"city2_6"		/* "" the floor */
#define DEFCEILINGTEXT	"comp1_7"		/* "" the ceiling */
#define DEFBARROWTEXT	"barrow"		/* "" arrows (red/blue for CTF) */
#define	DEFRARROWTEXT	"rarrow"
#define	DEFARROWQUNITS	32				/* size (square) of arrow texture */
#define	DEFCARVETEXT	"carve_me"
#define	DEFTRIGGERTEXT	"trigger"
#define	DEFTELEPLATTEXT	"tele_top"
#define	DEFTELEPLATQU	64
#define	DEFWADNAME		"sample.wad"    /*default .WAD name */
#define	DEFMAPNAME		"Untitled"		/* default .MAP name */
#define	DEFCDTRACK		0				/* no default CD track */
#define	DEFJOINENTMAP	TRUE			/* write ents in .MAP or leave in .EN1 */
#define	DEFLIGHTLEVEL	200				/* default value for lights in level */
#define	DEFSEALSIDES	TRUE			/* slap sides on it (in case not sealed) */
#define	DEFSEALTOPBOTTOM TRUE	/* write ceiling and floor brushes */
#define	DEFMEMBRUSHES	64	/* default number of brushes to compress at a time - smaller = faster */

#define CFGNAME			"bmp2map.cfg"  /* name of configuration file */
#define CFGQUNITSPERPEL	"qunitsperpel"
#define	CFGARROWQU		"arrowtexturequnits"
#define	CFGTELEPLATQU	"teleplatformtexturequnits"
#define	CFGFLOOR		"floor"
#define	CFGCEILING		"ceiling"
#define	CFGOUTERQUNITS	"outerqunits"
#define	CFGWINBOTTOM	"windowbottom"
#define	CFGWINTOP		"windowtop"
#define	CFGDOORTOP		"doortop"
#define	CFGWALLVAL		"wallcolor"     /* see comments in #define DEF... section */
#define	CFGWINVAL		"wincolor"
#define	CFGDOORVAL		"doorcolor"
#define	CFGDOORFRVAL	"doorframecolor"
#define CFGSKYWINVAL	"skywincolor"
#define	CFGRNARROWVAL	"rednortharrowcolor"
#define	CFGRSARROWVAL	"redsoutharrowcolor"
#define	CFGREARROWVAL	"redeastarrowcolor"
#define	CFGRWARROWVAL	"redwestarrowcolor"
#define	CFGBNARROWVAL	"bluenortharrowcolor"
#define	CFGBSARROWVAL	"bluesoutharrowcolor"
#define	CFGBEARROWVAL	"blueeastarrowcolor"
#define	CFGBWARROWVAL	"bluewestarrowcolor"
#define	CFGTELEPLATVAL	"teleplatformcolor"
#define	CFGCARVEFVAL	"carvefloorcolor"
#define	CFGCARVECVAL	"carveceilingcolor"
#define	CFGCARVEBOTHVAL	"carvebothcolor"
#define	CFGSKYCEILINGVAL	"skyceilingcolor"
#define	CFGTRIGGERVAL	"triggercolor"
#define	CFGWALLTEXT		"walltexture"
#define	CFGSKYTEXT		"skytexture"
#define	CFGDOORTEXT		"doortexture"
#define	CFGFLOORTEXT	"floortexture"
#define	CFGCEILINGTEXT	"ceilingtexture"
#define	CFGCARVETEXT	"carvetexture"
#define	CFGTRIGGERTEXT	"triggertexture"
#define	CFGRARROWTEXT	"redarrowtexture"
#define	CFGBARROWTEXT	"bluearrowtexture"
#define	CFGFRAMETEXT	"frametexture"
#define	CFGTELEPLATTEXT	"teleplatformtexture"
#define	CFGWADNAME		"wadname"
#define	CFGMAPNAME		"mapname"
#define	CFGAUTOLIGHT	"autolight"
#define	CFGAUTOLIGHTQU  "autolightqunits"
#define	CFGAUTOSTART	"autostart"
#define	CFGWORLDSPAWN	"worldspawn"
#define	CFGENTITY		"entity"
#define	CFGJOINENTMAP	"joinentmap"
#define	CFGLIGHTLEVEL	"lightlevel"
#define	CFGSEALSIDES	"sealsides"
#define	CFGSEALTOPBOTTOM 	"sealtopbottom"
#define	CFGCDTRACK		"cdtrack"
#define	CFGMEMBRUSHES	"membrushes"

#define	TEXTURENAMESIZE	20
#define	MAPNAMESIZE		40
#define	WADNAMESIZE		60
#define	CFGLINESIZE		256
#define	ENTITYSIZE		50		/* for entity strings in config file */
#define	ENTLINESIZE		80		/* for entity strings in temp entity file */
#define FILENAMESIZE	128		/* for all file names */

#define	EXTREME 		8192	/* for min/max tracking */

#define	ABSORBED		(-1)	/* brush has been combined with another */
#define	WALLBRUSH		1
#define	DOORBRUSH		2
#define	SKYBRUSH		3
#define	FLOORBRUSH		4
#define CEILINGBRUSH	5
#define	CARVEBRUSH		6
#define	TRIGGERBRUSH	7
#define	FRAMEBRUSH		8

#define	RNARROWBRUSH	9 	/* Make sure RNARROWRBRUSH is listed first */
#define	RSARROWBRUSH	10
#define	REARROWBRUSH	11
#define	RWARROWBRUSH	12
#define	BNARROWBRUSH	13
#define	BSARROWBRUSH	14
#define	BEARROWBRUSH	15
#define	BWARROWBRUSH	16	 /* Make sure BWARROWBRUSH is last */

#define	TELEPLATBRUSH	17


#define MINBRUSH		1
#define MAXBRUSH		17 		/* change this when adding brush types */

#define	SPARERAM		0x8000L	/* leave some RAM (~32K) available */

typedef struct entitystruct
{
	BYTE entval;					/* pixel color for entity */
	char entstring[ ENTITYSIZE];	/* classname for ent (eg. info_player_start) */
} ENTITY;


typedef struct cfgstruct
{
	int floor;
	int ceiling;
	int winbottom;
	int wintop;
	int doortop;
	int arrowbrushqunits;
	int teleplatbrushqunits;
	int autolightqunits;
	int lightlevel;
	int wallval;
	int winval;		/* see comments in #define DEF... section */
	int doorval;
	int doorframeval;
	int skywinval;
	int triggerval;
	int carvefloorval;
	int carveceilingval;
	int carvebothval;
	int skyceilingval;
	int rnaval;
	int rsaval;
	int reaval;
	int rwaval;
	int bnaval;
	int bsaval;
	int beaval;
	int bwaval;
	int teleplatval;
	int qunitsperpel;
	int outerqunits;
	int autolight;
	int sealsides;
	int sealtopbottom;
	int autostart;
	int	worldspawn;
	int numents;
	int joinentmap;
	int	cdtrack;
	int membrushes;
	char walltext[ TEXTURENAMESIZE];
	char doortext[ TEXTURENAMESIZE];
	char skytext[ TEXTURENAMESIZE];
	char floortext[ TEXTURENAMESIZE];
	char ceilingtext[ TEXTURENAMESIZE];
	char rarrowtext[ TEXTURENAMESIZE];
	char barrowtext[ TEXTURENAMESIZE];
	char carvetext[ TEXTURENAMESIZE];
	char triggertext[ TEXTURENAMESIZE];
	char frametext[ TEXTURENAMESIZE];
	char teleplattext[ TEXTURENAMESIZE];
	char mapname[ MAPNAMESIZE];
	char wadname[ WADNAMESIZE];
	ENTITY *ents;
} CFG;


typedef struct SIXSIDES
{
	int x1, x2, y1, y2, z1, z2;     /* Quake coordinates of brush */
	int texture; 					/* wall, door, sky, etc. */
} BRUSH;

typedef struct EXTREMES
{
	int xbase, ybase;
	int minx, maxx;		/* for tracking extreme values encountered */
	int miny, maxy;
	int zmiddle;
} QEXTREMES;


typedef struct tagBITMAPFILEHEADER
{
	WORD bfType;
	DWORD bfSize;
	WORD bfReserved1;
	WORD bfReserved2;
	DWORD bfOffBits;

} BITMAPFILEHEADER;


typedef struct tagBITMAPINFOHEADER
{
	DWORD biSize;
	DWORD biWidth;
	DWORD biHeight;
	WORD  biPlanes;
	WORD  biBitCount;
	DWORD biCompression;
	DWORD biSizeImage;
	DWORD biXPelsPerMeter;
	DWORD biYPelsPerMeter;
	DWORD biClrUsed;
	DWORD biClrImportant;

} BITMAPINFOHEADER;


typedef struct tagRGBQUAD
{
	BYTE rgbBlue;
	BYTE rgbGreen;
	BYTE rgbRed;
	BYTE rgbReserved;

} RGBQUAD;

/*** Prototypes
***/


/*** in BMP2MAP.C */
/* used throughout */
void logprintf( const char *format, ...);

/* used throughout */
void error( const char *format, ...);

/* used throughout */
void myfprintf( FILE *fp, const char *format, ...);

/* used throughout */
void printbrush( long seq, BRUSH huge *b);

/* used by main() */
void initcfg( char *cfgname, char *bmpname, CFG *cfg);



/*** in BMP2MP1.C */
/* used by boundmap() & pel2brush() */
void savebrush( FILE *fp, QEXTREMES *qe, long *brushcnt,
				int x1, int x2, int y1, int y2,
				int z1, int z2, int texture);

/* used by bmp2mp1() */
void boundmap( CFG *cfg, FILE *mp1fp, QEXTREMES *qe, long *brushcnt);

/* used by bmp2mp1() */
void pel2brush( CFG *cfg, FILE *fp, QEXTREMES *qe, long *brushcnt,
				int x, int y, int zbot, int ztop, int texture);

/* used by bmp2mp1() */
void saveent( CFG *cfg, FILE *entfp, QEXTREMES *qe, int x, int y, char *entstring);

/* used by bmp2mp1() */
void initbmp( FILE *bmpfp, BITMAPINFOHEADER *bmih);

/* used by main() */
void bmp2mp1( char *inname, char *outname, CFG *cfg, QEXTREMES *qe, long *mp1brushcnt, long *mp3brushcnt);



/*** in MP12MAP.C ***/
/* used by mp12mp2() */
long readbrushes( FILE *mp1fp, BRUSH huge *b, long inmem, long toread);
/* used by mp12mp2() */
long compressxybrushes( BRUSH huge *b, long brushcnt);
/* used by mp12mp2() */
long compresszbrushes( BRUSH huge *b, long brushcnt);
/* used by main() */
void mp12mp2( char *filename, long mp1brushcnt, long mp3brushcnt, CFG *cfg);
/* used mp22map() */
void writebrush( FILE *fp, int x1, int x2, int y1, int y2,
			int z1, int z2, int xshift, int yshift, int zrot, char *texture, char *frametexture);
/* used by main() */
void mp22map( char *filename, CFG *cfg);



/*** EOF ***/
