/*
 * asc2tga.cpp
 * converts ascii matrix to tga heightfield
 * Copyright (C) 1999 by Ortwin Glueck
 * Released under the GNU General Public License (GPL)
 * This is free software. No warranty.
 */

#include <stdio.h> 
#include <stdlib.h>

unsigned char tgaheader[]={0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,24,32}; 

void main(int argc,char *argv[])
{
 FILE *in,*out;
 unsigned int value,i,j;
 unsigned short rows,cols;
 unsigned char BGR[3];
 unsigned short *target;
 
 if (argc!=3)
 {
  printf("asc2tga <input.txt> <output.tga>\n");
  printf("Input textfile is integers separated by tabs/spaces\nstarting with number of rows/columns.\n");
  exit(1);
 }
 
 in=fopen(argv[1],"rt");
 if (in==NULL)
 {
  printf("File not found\n");
  exit(1);
 }
 out=fopen(argv[2],"wb");
 if (out==NULL)
 {
  printf("Could not open output file\n");
  exit(1);
 }
 
 fscanf(in,"%u\t%u\n",&rows,&cols);
 target=(unsigned short*)&tgaheader[12];
 target[0]=cols;
 target[1]=rows;
 fwrite(tgaheader,18,1,out);
 printf("Writing %u x %u samples\n",rows,cols);
 
 BGR[0]=0; //blue is not used
 for (i=0;i<rows;i++)
  for (j=0;j<cols;j++)
  {
   fscanf(in,"%u\t",&value);
   *((unsigned short*)&BGR[1])=value;
   fwrite(BGR,3,1,out);
  }
 fclose(in);
 fclose(out);
 printf("Written 1999 by O. Glueck. Freeware under GPL.\n");
}