#include <stdlib.h>
#if !defined WM_NULL
  #include <windows.h>
#endif

static LPVOID LoadBitmapBits(LPSTR FileName, LPBITMAPINFO bi)
{
  LPVOID lpBits;
  int linesz, file;
  long bitmapsz;

  /* WARNING: this routine can only load 256 colour .BMP files */
  if ((file = _lopen(FileName, OF_READ | OF_SHARE_DENY_WRITE)) >= 0) {
    _llseek(file, sizeof(BITMAPFILEHEADER), SEEK_SET);
    _lread(file, &bi->bmiHeader, sizeof(BITMAPINFOHEADER));
    _lread(file, bi->bmiColors, 256 * sizeof(RGBQUAD));
    linesz = (int) (((bi->bmiHeader.biWidth * 8 + 31) & ~31u) >> 3u);
    bitmapsz = bi->bmiHeader.biHeight * linesz;

    if ((lpBits = as_AllocResource(bitmapsz)) != NULL) {
        _hread(file, lpBits, bitmapsz);
    } /* if */

    _lclose(file);
    return lpBits;
  } /* if */

  MessageBox(NULL,"Bitmap image files not found",NULL,MB_ICONEXCLAMATION|MB_OK);
  exit(1);
  return NULL;
}

