/* ANISPRI.H
 *
 * Definitions for the AniSprite animation DLL.
 * Copyright (c) 1997-1998, ITB CompuPhase, The Netherlands
 */

#ifndef _ANISPRI_H
#define _ANISPRI_H

/* Every compiler uses different "default" macros to indicate the mode
 * it is in. Throughout the source, I use the Borland C++ macros, so
 * the macros of Watcom C/C++ and Microsoft Visual C/C++ are mapped to
 * those of Borland C++.
 */
#if defined(__WATCOMC__)
#  if defined(__WINDOWS__) || defined(__NT__)
#    define _Windows
#  endif
#  ifdef __386__
#    define __32BIT__
#  endif
#  if defined(_Windows) && defined(__32BIT__)
#    define __WIN32__
#  endif
#elif defined(_MSC_VER)
#  if defined(_WINDOWS) || defined(_WIN32)
#    define _Windows
#  endif
#  ifdef _WIN32
#    define __WIN32__
#    define __32BIT__
#  endif
#endif

#if !defined(_INC_WINDOWS) && !defined(__WINDOWS_H)
#  include <windows.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#if !defined(_ASMAKE_DLL)
    /* Some compilers are smart enough to detect identical structures and
     * to mark them as equivalent. This reduces type checking, so here we
     * make sure that the dummy structures are explicitly different.
     */
    typedef struct {
	int dummy;
    }   FAR *ASBOARD;

    typedef struct {
	int *dummy;
    }   FAR *ASPRITE;

#   if defined(__WIN32__)
#	define ASAPI	 __declspec(dllimport) __stdcall
#   else
#	define ASAPI	 WINAPI
#   endif
#endif

typedef struct {
  HDC hDC;
  int Width, Height;
} ASPAINT_DDB_INST, FAR * ASPAINT_DDB;

typedef struct {
  LPBITMAPINFO lpBitsInfo;
  LPVOID lpBits;
  int X, Y, Width, Height;
  int cX, cY, cWidth, cHeight;
} ASPAINT_DIB_INST, FAR * ASPAINT_DIB;

#if defined _MSC_VER
  /* Earlier versions of Microsoft C/C++ accept only this syntax */
  typedef DWORD (CALLBACK *ASCALLBACK)(ASPRITE Sprite, int Event,
                                       DWORD Value, LPVOID Data);
#else
  typedef DWORD CALLBACK (FAR *ASCALLBACK)(ASPRITE Sprite, int Event,
                                           DWORD Value, LPVOID Data);
#endif

typedef enum {
    AS_EVENT_PAINT_DIB,
    AS_EVENT_PAINT_DDB,
    AS_EVENT_TIMER,
    AS_EVENT_COLLIDE,
    /* ----- */
    AS_EVENT_CODES
}   AS_EVENT_TYPE;

typedef enum {
    AS_MASK_NONE,
    AS_MASK_CUTOUT,
    AS_MASK_LUMA,
    AS_MASK_ALPHA,
    /* ----- */
    AS_MASK_CODES,
}   AS_MASK_CODE;

typedef enum {
    AS_DATA_ALPHA_LEVEL,        /* 0 */
    AS_DATA_BITMAPINFO,         /* 1 */
    AS_DATA_BOARD,              /* 2 */
    AS_DATA_BOX,                /* 3 */
    AS_DATA_LUMA_LEVEL,         /* 4 */
    AS_DATA_CALLBACK,           /* 5 */
    AS_DATA_CANVASBITS,         /* 6 */
    AS_DATA_COLORTABLE,         /* 7 */
    AS_DATA_IMAGEBITS,          /* 8 */
    AS_DATA_MASKBITS,           /* 9 */
    AS_DATA_SPRITE,             /* 10 */
    AS_DATA_USERDATA,           /* 11 */
    AS_DATA_REGIONRECT,         /* 12 */
    AS_DATA_UPDATERECT,         /* 13 */
    AS_DATA_MASTER,             /* 14 */
    AS_DATA_LINK,               /* 15 */

    AS_VALUE_HEIGHT = 50,       /* 50 */
    AS_VALUE_ID,                /* 51 */
    AS_VALUE_LAYER,             /* 52 */
    AS_VALUE_MASKCODE,          /* 53 */
    AS_VALUE_MASKED,            /* 54 */
    AS_VALUE_MASKSUPPORT,       /* 55 */
    AS_VALUE_NUMSPRITES,        /* 56 */
    AS_VALUE_PAL_COLORS,        /* 57 */
    AS_VALUE_VISIBLE,           /* 58 */
    AS_VALUE_WIDTH,             /* 59 */
    AS_VALUE_XPOS,              /* 60 */
    AS_VALUE_YPOS,              /* 61 */
    AS_VALUE_OPAQUE_LEVEL,      /* 62 */
    AS_VALUE_PAINTMODE,         /* 63 */
    AS_VALUE_TIMERRES,          /* 64 */
    AS_VALUE_XORG,              /* 65 */
    AS_VALUE_YORG,              /* 66 */

    AS_HANDLE_PALETTE = 100,    /* 100 */
    AS_HANDLE_DIBSECTION,       /* 101 */

}   AS_VALUE_TYPE;

typedef enum {
    AS_ERR_NONE,
    AS_ERR_ASSIGNED,            /* 1 */
    AS_ERR_BOARDMISMATCH,       /* 2 */
    AS_ERR_INVALIDCODE,         /* 3 */
    AS_ERR_INVALIDINDEX,        /* 4 */
    AS_ERR_INVALIDPOINTER,      /* 5 */
    AS_ERR_INVALIDVALUE,        /* 6 */
    AS_ERR_NOTEMPTY,            /* 7 */
    AS_ERR_OPAQUE,              /* 8 */
    AS_ERR_MEMORY,              /* 9 */
    AS_ERR_UNASSIGNED,          /* 10 */
    AS_ERR_UNSUPPORTED,         /* 11 */
    AS_ERR_WRONGFORMAT,         /* 12 */
    AS_ERR_INVALIDOPERATION,    /* 13 */
    AS_ERR_NORESOURCES,         /* 14 */
    AS_ERR_INVALIDCRDS,         /* 15 */
    AS_ERR_INVALIDHANDLE,       /* 16 */
    /* ----- */
    AS_ERRORS,
}   AS_ERR_TYPE;


#define AS_MODE_PAL_COLORS          (0x01)
#define AS_MODE_LUMA                (0x02)
#define AS_MODE_ALPHA               (0x04)
#define AS_MODE_DIBSECTION          (0x08)
#define AS_MODE_NODRAW              (0x10)
#define AS_MODE_MASKED              (0x20)

#define AS_TIMER                    (WM_USER+89)

/* Board functions */

ASBOARD ASAPI as_BoardFromBitmap(HDC hdc, HBITMAP hbmp, LPRGBQUAD lpPalette,
                                 int NumColors, int Code);

ASBOARD ASAPI as_CreateBoard(LPBITMAPINFO lpBitsInfo, LPVOID lpBits,
                             LPRECT lpVisRect, int Code);

BOOL ASAPI as_DeleteBoard(ASBOARD lpBoard, BOOL DeleteImage);

BOOL ASAPI as_SetBoardData(ASBOARD Board, int Code, int Index, LPVOID Value);

LPVOID ASAPI as_GetBoardData(ASBOARD Board, int Code, int Index);

HANDLE ASAPI as_GetBoardHandle(ASBOARD Board, int Code);

int ASAPI as_GetBoardValue(ASBOARD Board, int Code, int Index);

BOOL ASAPI as_SetPalette(ASBOARD Board, LPRGBQUAD lpPal, BOOL IdentPalette);

BOOL ASAPI as_ForwardMessage(ASBOARD Board, HWND hWnd, UINT msg,
                             WPARAM wParam, LPARAM lParam);

COLORREF ASAPI as_GetNearestColor(ASBOARD Board, COLORREF crColor);

int ASAPI as_GetPaletteIndex(ASBOARD Board, COLORREF crColor);

BOOL ASAPI as_PtInBoard(ASBOARD Board, int X, int Y);

BOOL ASAPI as_BlitInBoard(ASBOARD Board,
                          int dstX, int dstY, int Width, int Height,
                          LPBITMAPINFO lpBitsInfo, LPVOID lpImage,
                          int srcX, int srcY);

BOOL ASAPI as_FillBoard(ASBOARD Board, int X, int Y, int Width, int Height,
                        COLORREF crColor);

BOOL ASAPI as_PaintBoard(HDC hDC, ASBOARD Board, int X, int Y, BOOL PaintAll);

BOOL ASAPI as_ReplaceBoard(ASBOARD Board, int Width, int Height, LPVOID lpBits,
			   LPRECT lpVisRect, LPRECT lpInvalidRect);

ASPRITE ASAPI as_SpriteAtPos(ASBOARD Board, int X, int Y, ASPRITE Sprite);

BOOL ASAPI as_SetTimer(ASBOARD Board, HWND hwnd, WORD Interval);

BOOL ASAPI as_ReleaseTimer(ASBOARD Board);

BOOL ASAPI as_IsValidBoard(ASBOARD Board);

/* Sprite functions */

BOOL ASAPI as_Animate(ASPRITE Sprite, int Width, int Height,
		      LPVOID lpMask, int MaskCode,
		      LPVOID lpImage, BOOL ImageMasked,
		      LPRECT lpBoundingBox);

BOOL ASAPI as_Assign(ASPRITE Sprite, ASBOARD Board, int Layer);

ASPRITE ASAPI as_Collide(ASPRITE Sprite, BOOL SameLayer);

BOOL ASAPI as_CollideBox(ASPRITE Sprite, LPRECT lpBox);

BOOL ASAPI as_CollideSprite(ASPRITE Sprite1, ASPRITE Sprite2);

ASPRITE ASAPI as_Create(int Width, int Height,
                        LPVOID lpMask, int MaskCode,
                        LPVOID lpImage, BOOL ImageMasked);

BOOL ASAPI as_Delete(ASPRITE Sprite, BOOL DeleteDIBs);

BOOL ASAPI as_Invalidate(ASPRITE Sprite);

LPVOID ASAPI as_GetData(ASPRITE Sprite, int Code, int Index);

BOOL ASAPI as_SetData(ASPRITE Sprite, int Code, int Index, LPVOID Value);

int ASAPI as_GetValue(ASPRITE Sprite, int Code);

BOOL ASAPI as_SetValue(ASPRITE Sprite, int Code, int Value);

BOOL ASAPI as_SetOrigin(ASPRITE Sprite, int Xorg, int Yorg);

BOOL ASAPI as_InBox(ASPRITE Sprite, LPRECT lpBox);

BOOL ASAPI as_Link(ASPRITE Sprite, ASPRITE Master);

BOOL ASAPI as_Move(ASPRITE Sprite, int DeltaX, int DeltaY);

BOOL ASAPI as_GetPos(ASPRITE Sprite, LPINT X, LPINT Y);

BOOL ASAPI as_SetPos(ASPRITE Sprite, int X, int Y);

BOOL ASAPI as_PtInSprite(ASPRITE Sprite, int X, int Y);

BOOL ASAPI as_Show(ASPRITE Sprite, BOOL Show);

BOOL ASAPI as_IsValid(ASPRITE Sprite);

/* Utility functions */

LPVOID ASAPI as_AllocResource(long Size);

LPVOID ASAPI as_FreeResource(LPVOID Resource);

int ASAPI as_LastError(LPVOID Object);

LPVOID ASAPI as_ConvertImage(LPBITMAPINFO lpSrcInfo, LPVOID lpSrcBits,
                             LPBITMAPINFO lpDstInfo, LPRGBQUAD lpPal,
                             BOOL DeleteSrc);

LPVOID ASAPI as_CropImage(LPBITMAPINFO lpSrcInfo, LPVOID lpSrcBits,
                          LPBITMAPINFO lpDstInfo, LPRECT rc, BOOL DeleteSrc);

LPVOID ASAPI as_CreateAlphaLevel(LPRGBQUAD lpPal, WORD InterFactor);

LPVOID ASAPI as_CreateLumaLevel(LPRGBQUAD lpPal, COLORREF crColor,
                                WORD InterFactor);

LPVOID ASAPI as_CreateMask(LPBITMAPINFO lpBitsInfo, LPVOID lpBits,
			   BOOL MaskImage,
                           COLORREF FAR *crTransColor, int Colors);

LPVOID ASAPI as_ExpandMonoMask(int Width, int Height, LPVOID lpMonoBits);

BOOL ASAPI as_LevelInMask(int Width, int Height, LPVOID lpMask, int Level);

BOOL ASAPI as_ReduceMask(int Width, int Height, LPVOID lpMask, int Levels);

BOOL ASAPI as_MapMaskLevel(int Width, int Height, LPVOID lpMask,
                           int From, int To);

BOOL ASAPI as_SmoothMask(int Width, int Height, LPVOID lpMask,
                         int Feather, int Levels);

BOOL ASAPI as_BoundingBox(int Width, int Height, LPVOID lpImage, int Level,
                          LPRECT rc);

void ASAPI as_CreateBitmapInfoHeader(LPBITMAPINFO lpBitsInfo,
                                     int width, int height,
                                     LPRGBQUAD lpPal, int Colors);

HPALETTE ASAPI as_GrabSysPalette(LPRGBQUAD lpPalette);

HBITMAP ASAPI as_GrabScreen(HDC hDC, LPRECT rc);

#ifdef __cplusplus
}
#endif

#endif
