#ifndef _SunClock_Header
#define _SunClock_Header

#include <windows.h>
#include "resource.h"

// --- Global Constants ---
static char AppName[] = "Win Sun Clock" ;

// --- Definitions ---
typedef struct { int x, y, width, height, onTop; } WinInfo;

// --- Prototypes ---
int WINAPI SunClock (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
int MakeNewWindow (void);
void LoadWindowInfo (void);
BOOL CALLBACK AboutDialog    (HWND hwndDlg,  UINT uMsg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK ColBlendDialog (HWND hwndDlg,  UINT uMsg, WPARAM wParam, LPARAM lParam );

// --- Pop-up menu identifiers ---
const int IDPOPMENU_TOPMOST  = 50;
const int IDPOPMENU_COLBLEND = 75;
const int IDPOPMENU_QUIT     = 100;
const int IDPOPMENU_ABOUT    = 200;
const int IDPOPMENU_SHIFTMAP = 300;

const char* PPopMenuTopmost  = "&Top Most";
const char* PPopMenuColBlend = "&Colour Blend";
const char* PPopMenuShiftMap = "&Shift Map";
const char* PPopMenuQuit     = "&Quit";
const char* PPopMenuAbout    = "&About";

// --- Colour Blend Limits 
#define MAXCOLLIMIT  255
#define MINCOLLIMIT  -255
#define MODIFYRGB    -80

#endif // _SunClock_Header
