#ifndef _SUNALGO
#define _SUNALGO

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

#define False 0
#define True  -1
#define abs(x) ((x) < 0 ? (-(x)) : x)             /* Absolute value */
                                                  /* Extract sign */
#define sgn(x) (((x) < 0) ? -1 : ((x) > 0 ? 1 : 0))
#define dtr(x) ((x) * (PI / 180.0))               /* Degree->Radian */
#define rtd(x) ((x) / (PI / 180.0))               /* Radian->Degree */
                                                  /* Fix angle    */
#define fixangle(a) ((a) - 360.0 * (floor((a) / 360.0)))

#define PI 3.14159265358979323846

#define TERMINC  100                              /* Circle segments for terminator */

#define PROJINT  (60 * 10)                        /* Frequency of seasonal recalculation in seconds. */

typedef struct
{
    int             s_width;                      /* size of pixmap */
    int             s_height;
    int             s_flags;                      /* see below */
    int             s_noon;                       /* position of noon */
    short *         s_wtab1;                      /* current width table (?) */
    short *         s_wtab;                       /* previous width table (?) */
    long            s_increm;                     /* increment for fake time */
    long            s_time;                       /* time - real or fake, see flags */
    long            s_projtime;                   /* last time we projected illumination */
    int             s_timeout;                    /* time until next image update */
} sunclock;

/************************* Prototypes ********************************/

void Initialise (HDC hdcOrigImage, HDC hdcDestImage, int width, int height);
sunclock* makeClockContext(int wid, int ht);
void updimage(void);
void projillum(short* wtab, int xdots, int ydots, double dec);
void xspan(register int pline, register int leftp, register int npix, register int xdots);
void moveterm(short* wtab, int noon, short* otab, int onoon, int xdots, int ydots);
char* salloc(register int nbytes);
void updtext(sunclock *s);

long   jdate (struct tm *t);
double jtime (struct tm *t);
double kepler(double m, double ecc);
void   sunpos(double  jd, int apparent, double *ra, double *dec, double *rv, double* slong);
double gmst  (double jd);

#endif // _SUNALGO





