#include "sunalgo.h"

char *                          Wdayname[] =
{
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};


char *                          Monname[] =
{
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
    "Aug", "Sep", "Oct", "Nov", "Dec"
};

/*** Globals ***/
sunclock   clockblock;
sunclock*  PCurrClock   = NULL;
HDC        HdcOrigImage = NULL;
HDC        HdcDestImage = NULL;
extern int ColourBlendAmount;
/******************************************************************************************/
/******************************* Sun Clock Functions **************************************/
/******************************************************************************************/

void Initialise (HDC hdcOrigImage, HDC hdcDestImage, int width, int height)
{
    HdcOrigImage = hdcOrigImage;
    HdcDestImage = hdcDestImage;
   
    // free and allowcate memory required 
    if (PCurrClock != NULL)
    {
        // free memory 
        free (PCurrClock -> s_wtab);
        free (PCurrClock->s_wtab1);
        PCurrClock = NULL;
    }

    makeClockContext(width, height);
}

sunclock* makeClockContext(int wid, int ht)
{
    register sunclock * s;

    s = &clockblock;
    s->s_width = wid;
    s->s_height = ht;
    s->s_flags = 0;
    s->s_noon = -1;
    s->s_wtab =  (short*) salloc((int)(ht * sizeof (short*)));
    s->s_wtab1 = (short*) salloc((int)(ht * sizeof (short*)));
    s->s_increm = 180;
    time(&s->s_time);
    s->s_timeout = 0;
    s->s_projtime = -1L;

    PCurrClock = s;
    return (s);
}


/*  UPDIMAGE  --  Update current displayed image.  */
void updimage(void)
{
    register int       i;
    int                xl;
    tm *               ct;
    double             jt;
    double             sunra;
    double             sundec;
    double             sunrv;
    double             sunlong;
    double             gt;
    short *            wtab_swap;
    register sunclock* s = PCurrClock;

    /* If this is a full repaint of the window, force complete
       recalculation. */
    if (s->s_noon < 0)
    {
        s->s_projtime = 0;
        for (i = 0; i < s->s_height; i++)
        {
            s->s_wtab1[i] = -1;
        }
    }

    time(&s->s_time);

    ct = gmtime(&s->s_time);

    jt = jtime(ct);
    
    sunpos(jt, False, &sunra, &sundec, &sunrv, &sunlong);

    gt = gmst(jt);


    /* Projecting the illumination curve  for the PCurrClock seasonal
       instant is costly.  If we're running in real time, only  do
       it every PROJINT seconds.  */
    if ((s->s_projtime < 0) || ((s->s_time - s->s_projtime) > PROJINT))        
    {
        projillum(s->s_wtab, s->s_width, s->s_height, sundec);
        wtab_swap = s->s_wtab;
        s->s_wtab = s->s_wtab1;
        s->s_wtab1 = wtab_swap;
        s->s_projtime = s->s_time;
    }

    sunlong = fixangle(180.0 + (sunra - (gt * 15)));
    xl = (int)(sunlong * ((double)s->s_width / 360.0));

    /* If the subsolar point has moved at least one pixel, update
       the illuminated area on the screen.  */
    if (s->s_noon != xl)
    {
        moveterm(s->s_wtab1, xl, s->s_wtab, s->s_noon, s->s_width, s->s_height);
        s->s_noon = xl;
    }
}


/*  PROJILLUM  --  Project illuminated area on the map.  */
void projillum(short* wtab, int xdots, int ydots, double dec)
{
    int i, ftf = True, ilon, ilat, lilon, lilat, xt;
    double m, x, y, z, th, lon, lat, s, c;

    /* Clear unoccupied cells in width table */
    for (i = 0; i < ydots; i++)
        wtab[i] = -1;

    /* Build transformation for declination */
    s = sin(-dtr(dec));
    c = cos(-dtr(dec));

    /* Increment over a semicircle of illumination */
    for (th = -(PI / 2); th <= PI / 2 + 0.001;
    th += PI / TERMINC)
    {
        /* Transform the point through the declination rotation. */
        x = -s * sin(th);
        y = cos(th);
        z = c * sin(th);

        /* Transform the resulting co-ordinate through the
           map projection to obtain screen co-ordinates. */
        lon = (y == 0 && x == 0) ? 0.0 : rtd(atan2(y, x));
        lat = rtd(asin(z));

        ilat = (int)(ydots - (double)(lat + 90) * ((double)ydots / 180.0));
        ilon = (int)(lon * ((double)xdots / 360.0));

        if (ftf)
        {
            /* First time.  Just save start co-ordinate. */
            lilon = ilon;
            lilat = ilat;
            ftf = False;
        }
        else
        {
            /* Trace out the line and set the width table. */
            if (lilat == ilat)
            {
                wtab[(ydots - 1) - ilat] = ilon == 0 ? 1 : ilon;
            }
            else
            {
                m = ((double) (ilon - lilon)) / (ilat - lilat);
                for (i = lilat; i != ilat; i += sgn(ilat - lilat))
                {
                    xt = (int)(lilon + floor((double)(m * (i - lilat)) + 0.5));
                    wtab[(ydots - 1) - i] = xt == 0 ? 1 : xt;
                }
            }
            lilon = ilon;
            lilat = ilat;
        }
    }


    /* Now tweak the widths to generate full illumination for
       the correct pole. */
    if (dec < 0.0)
    {
        ilat = ydots - 1;
        lilat = -1;
    }
    else
    {
        ilat = 0;
        lilat = 1;
    }

    for (i = ilat; i != ydots / 2; i += lilat)
    {
        if (wtab[i] != -1)
        {
            while (True)
            {
                wtab[i] = xdots / 2;
                if (i == ilat)
                    break;
                i -= lilat;
            }
            break;
        }
    }
}


/*  XSPAN  --  Complement a span of pixels.  Called with line in which
               pixels are contained, leftmost pixel in the  line,  and
               the   number   of   pixels   to   complement.   Handles
               wrap-around at the right edge of the screen.  */

void xspan(register int pline, register int leftp, register int npix, register int xdots)
{
    int i;
    if (npix == 0)
        return;
    leftp = leftp % xdots;

    if (leftp + npix > xdots)
    {
        xspan(pline, leftp, (xdots - leftp), xdots);
        xspan(pline, 0, (leftp + npix - xdots), xdots);
    }
    else
    {
        COLORREF curPix;
        int      r, g, b;
        
        for (i = (leftp-1); i < leftp+npix; i++)
        {
            curPix = GetPixel(HdcOrigImage, i, pline);
            r = ((int)GetRValue(curPix) - ColourBlendAmount);
            if (r < 0)
                r = 0;
            else if (r > 255)
                r = 255;

            g = ((int)GetGValue(curPix) - ColourBlendAmount);

            if (g < 0)
                g = 0;
            else if (g > 255)
                g = 255;

            b = ((int)GetBValue(curPix) - ColourBlendAmount);

            if (b < 0)
                b = 0;
            else if (b > 255)
                b = 255;

            SetPixelV (HdcDestImage, i, pline, RGB (r, g, b)); 
        }
    }
}


/*  MOVETERM  --  Update illuminated portion of the globe.  */
void moveterm(short* wtab, int noon, short* otab, int onoon, int xdots, int ydots)
{
    int i, ol, oh, nl, nh;

    for (i = 0; i < ydots; i++)
    {
        /* If line is off in new width table but is set in the old table, clear it. */
        if (wtab[i] < 0)
        {
            if (otab[i] >= 0)
            {
                xspan(i, ((onoon - otab[i]) + xdots) % xdots,
                otab[i] * 2, xdots);
            }
        }
        else
        {
            /* Line is on in new width table.  If it was off in
               the old width table, just draw it. */
            if (otab[i] < 0)
            {
                xspan(i, ((noon - wtab[i]) + xdots) % xdots,
                wtab[i] * 2, xdots);
            }
            else
            {
                /* If both the old and new spans were the entire
                   screen, they're equivalent. */
                if (otab[i] == wtab[i] && wtab[i] == (xdots / 2))
                    continue;

                /* The line was on in both the old and new width
                   tables.  We must adjust the difference in the span.  */
                ol =  ((onoon - otab[i]) + xdots) % xdots;
                oh = (ol + otab[i] * 2) - 1;
                nl =  ((noon - wtab[i]) + xdots) % xdots;
                nh = (nl + wtab[i] * 2) - 1;

                /* If spans are disjoint, erase old span and set new span. */
                if (oh < nl || nh < ol)
                {
                    xspan(i, ol, (oh - ol) + 1, xdots);
                    xspan(i, nl, (nh - nl) + 1, xdots);
                }
                else
                {
                    /* Clear portion(s) of old span that extend
                       beyond end of new span. */
                    if (ol < nl)
                    {
                        xspan(i, ol, nl - ol, xdots);
                        ol = nl;
                    }
                    if (oh > nh)
                    {
                        xspan(i, nh + 1, oh - nh, xdots);
                        oh = nh;
                    }

                    /* Extend existing (possibly trimmed) span to correct new length. */
                    if (nl < ol)
                    {
                        xspan(i, nl, ol - nl, xdots);
                    }
                    if (nh > oh)
                    {
                        xspan(i, oh + 1, nh - oh, xdots);
                    }
                }
            }
        }
        otab[i] = wtab[i];
    }
}

char* salloc(register int nbytes)
{
    register char*         p;

    p = (char*) malloc((unsigned)nbytes);
    if (p == (char *)NULL)
    {
        fprintf(stderr, "%s: out of memory\n");
        exit(1);
    }
    return (p);
}


void updtext(sunclock *s)
{
    struct tm lt;
    register struct tm *            ltp = &lt;
    register struct tm *            gmtp;
    static char old[80];
    char newStr[80];
    char outstring[2];
    int i;

    outstring[1] = '\0';
    lt = *localtime(&s->s_time);
    gmtp = gmtime(&s->s_time);

    sprintf(newStr,
    "%02d:%02d:%02d %s %s %02d %s %02d     %02d:%02d:%02d UTC %s %02d %s %02d",
    ltp->tm_hour, ltp->tm_min,
    ltp->tm_sec,
    tzname[ltp->tm_isdst],
    Wdayname[ltp->tm_wday], ltp->tm_mday,
    Monname[ltp->tm_mon], ltp->tm_year % 100,
    gmtp->tm_hour, gmtp->tm_min,
    gmtp->tm_sec, Wdayname[gmtp->tm_wday], gmtp->tm_mday,
    Monname[gmtp->tm_mon], gmtp->tm_year % 100);

    /* For speed purposes, only update changed characters on the screen. */
    for (i=0; i < (int)strlen(newStr); i++)
    {
        if (old[i] != newStr[i])
        {
//            _settextposition(TEXTROW, i + 13);
//            outstring[0] = newStr[i];
//            _outtext(outstring);
//            old[i] = newStr[i];
//
        }
    }
}

/*******************************************************************************************/
/*******************************************************************************************/
/*******************************************************************************************/

/*  JDATE  --  Convert internal GMT date and time to Julian day
               and fraction.  */
long jdate(struct tm *t)
{
    long c, m, y;

    y = t->tm_year + 1900;
    m = t->tm_mon + 1;
    if (m > 2)
        m = m - 3;
    else
    {
        m = m + 9;
        y--;
    }
    c = y / 100L;                                 /* Compute century */
    y -= 100L * c;
    return t->tm_mday + (c * 146097L) / 4 + (y * 1461L) / 4 +
    (m * 153L + 2) / 5 + 1721119L;
}


/* JTIME --    Convert internal GMT  date  and time  to  astronomical
               Julian  time  (i.e.   Julian  date  plus  day fraction,
               expressed as a double). */
double jtime(struct tm *t)
{
    return (jdate(t) - 0.5) +
    (((long) t->tm_sec) +
    60L * (t->tm_min + 60L * t->tm_hour)) / 86400.0;
}


/*  KEPLER  -- Solve the equation of Kepler.  */
double kepler(double m, double ecc)
{
    double e, delta;
#define EPSILON 1E-6

    e = m = dtr(m);
    do
    {
        delta = e - ecc * sin(e) - m;
        e -= delta / (1 - ecc * cos(e));
    } while (abs(delta) > EPSILON);
    return e;
}


/*  SUNPOS  -- Calculate position of the Sun.  JD is the Julian  date
               of  the  instant for which the position is desired and
               APPARENT should be nonzero if  the  apparent  position
               (corrected  for  nutation  and aberration) is desired.
               The Sun's co-ordinates are returned  in  RA  and  DEC,
               both  specified  in degrees (divide RA by 15 to obtain
               hours).  The radius vector to the Sun in  astronomical
               units  is returned in RV and the Sun's longitude (true
               or apparent, as desired) is  returned  as  degrees  in
               SLONG.  */

void sunpos(double  jd, int apparent, double *ra, double *dec, double *rv, 
            double* slong)
{
    double t, t2, t3, l, m, e, ea, v, theta, omega,
    eps;

    /* Time, in Julian centuries of 36525 ephemeris days,
       measured from the epoch 1900 January 0.5 ET. */
    t = (jd - 2415020.0) / 36525.0;
    t2 = t * t;
    t3 = t2 * t;


    /* Geometric mean longitude of the Sun, referred to the
       mean equinox of the date. */
    l = fixangle(279.69668 + 36000.76892 * t + 0.0003025 * t2);

    /* Sun's mean anomaly. */
    m = fixangle(358.47583 + 35999.04975*t - 0.000150*t2 - 0.0000033*t3);

    /* Eccentricity of the Earth's orbit. */
    e = 0.01675104 - 0.0000418 * t - 0.000000126 * t2;

    /* Eccentric anomaly. */
    ea = kepler(m, e);

    /* True anomaly */
    v = fixangle(2 * rtd(atan(sqrt((1 + e) / (1 - e))  * tan(ea / 2))));

    /* Sun's true longitude. */
    theta = l + v - m;

    /* Obliquity of the ecliptic. */
    eps = 23.452294 - 0.0130125 * t - 0.00000164 * t2 + 0.000000503 * t3;

    /* Corrections for Sun's apparent longitude, if desired. */
    if (apparent)
    {
        omega = fixangle(259.18 - 1934.142 * t);
        theta = theta - 0.00569 - 0.00479 * sin(dtr(omega));
        eps += 0.00256 * cos(dtr(omega));
    }

    /* Return Sun's longitude and radius vector */
    *slong = theta;
    *rv = (1.0000002 * (1 - e * e)) / (1 + e * cos(dtr(v)));

    /* Determine solar co-ordinates. */
    *ra =
    fixangle(rtd(atan2(cos(dtr(eps)) * sin(dtr(theta)), cos(dtr(theta)))));
    *dec = rtd(asin(sin(dtr(eps)) * sin(dtr(theta))));
}


/*  GMST  --  Calculate Greenwich Mean Siderial Time for a given
              instant expressed as a Julian date and fraction. */
double gmst(double jd)
{
    double t, theta0;

    /* Time, in Julian centuries of 36525 ephemeris days,
       measured from the epoch 1900 January 0.5 ET. */
    t = ((floor(jd + 0.5) - 0.5) - 2415020.0) / 36525.0;

    theta0 = 6.6460656 + 2400.051262 * t + 0.00002581 * t * t;

    t = (jd + 0.5) - (floor(jd + 0.5));

    theta0 += (t * 24.0) * 1.002737908;

    theta0 = (theta0 - 24.0 * (floor(theta0 / 24.0)));

    return theta0;
}