/*
 * Decompiled with CFR 0.152.
 */
package wdict;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import wdict.DictEngine;

public class MainForm
extends JDialog {
    public static final String ME = "Developer: Charles a.k.a KK";
    private static final String MAIN_ICON_FILE = "/wdict/icons/wdict.png";
    private static final String HOME_SIZE_ADDR = "http://wdict.fw.hu";
    private static final String APP_NAME = "WDictionary v0.1";
    private static final String APP_VER = "07/24/2011 17:13";
    private JButton goSiteBtn;
    private JButton helpBtn;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea resultTextArea;
    private JButton searchBtn;
    private JTextField searchTextField;

    public MainForm() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.setLocationRelativeTo(null);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(MAIN_ICON_FILE));
        this.setIconImage(imageIcon.getImage());
        this.setTitle(APP_NAME);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.searchTextField = new JTextField();
        this.searchBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.resultTextArea = new JTextArea();
        this.helpBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.goSiteBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("English => Hungarian Dictionary");
        this.setIconImage(null);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.searchTextField.setBackground(new Color(255, 255, 204));
        this.searchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MainForm.this.searchTextFieldFocusGained(focusEvent);
            }
        });
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                MainForm.this.searchTextFieldKeyTyped(keyEvent);
            }
        });
        this.searchBtn.setFont(new Font("Tahoma", 1, 10));
        this.searchBtn.setIcon(new ImageIcon(this.getClass().getResource("/wdict/icons/arrow-right.png")));
        this.searchBtn.setPreferredSize(new Dimension(45, 23));
        this.searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainForm.this.searchBtnActionPerformed(actionEvent);
            }
        });
        this.resultTextArea.setBackground(new Color(204, 255, 204));
        this.resultTextArea.setColumns(20);
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.resultTextArea);
        this.helpBtn.setFont(new Font("Tahoma", 1, 10));
        this.helpBtn.setIcon(new ImageIcon(this.getClass().getResource("/wdict/icons/question.png")));
        this.helpBtn.setPreferredSize(new Dimension(45, 23));
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainForm.this.helpBtnActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setBackground(new Color(204, 204, 255));
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setText("If you like this application, visit home page (wdict.fw.hu) and say Thanks.");
        this.goSiteBtn.setIcon(new ImageIcon(this.getClass().getResource("/wdict/icons/wdict-16x16.png")));
        this.goSiteBtn.setPreferredSize(new Dimension(45, 23));
        this.goSiteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainForm.this.goSiteBtnActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 404, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.searchTextField, -1, 245, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchBtn, -2, -1, -2).addGap(8, 8, 8).addComponent(this.helpBtn, -2, -1, -2)).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goSiteBtn, -2, -1, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.searchBtn, -2, -1, -2).addComponent(this.helpBtn, -2, -1, -2)).addComponent(this.goSiteBtn, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(20, 20, 20)));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void searchBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.searchTextField.getText();
        if (string.length() < 2 || string.length() > 20) {
            return;
        }
        String string2 = DictEngine.getInstance().translateWord(string);
        this.resultTextArea.setText(string2);
        this.resultTextArea.setCaretPosition(0);
    }

    private void searchTextFieldKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.searchBtnActionPerformed(null);
        }
    }

    private void helpBtnActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "WDictionary v0.1\nFree English->Hungarian Dictionary\nWritten by Charles aka KK\nBased on the free word list at\nhttp://mek.oszk.hu/00000/00076/", "WDictionary v0.1 About", 1);
    }

    private void searchTextFieldFocusGained(FocusEvent focusEvent) {
        this.searchTextField.setSelectionStart(0);
        this.searchTextField.setSelectionEnd(100);
    }

    private void goSiteBtnActionPerformed(ActionEvent actionEvent) {
        try {
            Desktop.getDesktop().browse(new URI(HOME_SIZE_ADDR));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

