1000 '*** SOLVE3.BAS *** MBASIC/GWBASIC ******** J R Ferguson, Dec 07,1996 ***
1010 '
1020 ' SOLVE A CUBIC EQUATION
1030 ' CARDANO'S METHOD / TRIGONIOMETRIC EQUATIONS
1040 '                                                      * prog variabels :
1050 '    a*x^3 + b*x^2 + c*x + d = 0                       * A,B,C
1060 '                                                      *
1070 ' with z=x+b/(3a): z^3 + 3pz + 2q = 0                  * E=b/(3a),F=c/(3a)
1080 ' where            p = c/(3a) - (b/(3a))^2             * P
1090 '                  q = (b/(3a))^3 - bc/(6a^2) + d/(2a) * Q
1100 ' Discriminant   : D = p^3 + q^2                       * D0
1110 '*******************************************************
1120 ' 1] D<0 : 3 separate real roots                       *
1130 '                                                      *
1140 '          z1 = -2 SQR(-p) cos(f/3)                    *
1150 '          z2 = -2 SQR(-p) cos(2/3 PI + f/3)           *
1160 '          z3 = -2 SQR(-p) cos(2/3 PI - f/3)           *
1170 '                                                      * R=-2 SQR(-p)
1180 '          where cos f = q * p^(-3/2)                  * S=f/3
1190 '*******************************************************
1200 ' 2] D=0 en q=0 : 3 identical real roots               *
1210 '                 z1 = z2 = z3 = 0                     *
1220 '    D=0 en q<>0: 2 separate real roots                *
1230 '                 z1 = -2 q^(1/3)                      *
1240 '                 z2 = z3 = q^(1/3)                    * R=q^(1/3)
1250 '*******************************************************
1260 ' 3] D>0 : 1 real and 2 complex roots                  *
1270 '                                                      *
1280 '          z1 = u + v                                  *
1290 '          z2 = -(u+v)/2 + i * SQR(3) * (u-v)/2        *
1300 '          z3 = -(u+v)/2 - i * SQR(3) * (u-v)/2        *
1310 '                                                      *
1320 '          with: u = (-q + SQR(D))^(1/3)               * U
1330 '                v = (-q - SQR(D))^(1/3)               * V
1340 '*******************************************************
1350 ' General rule : x = z - b/(3a)                        *
1360 '*************************************************************************
1370 EPS=.00001                          'precision
1380 PI=3.141593#
1390 DEF FNARCCOS(X)=-ATN(X/SQR(-X*X+1))+1.570796#
1400 DEF FNW3(X)=SGN(X)*ABS(X)^(1/3)     '3rd degree root
1410 DEF FNX(Z)=INT((Z-E+EPS/2)/EPS)*EPS 'retransformation and rounding
1430 '*************************************************************************
1440 '
1450 ' M A I N   P R O G R A M :
1460 '
1470 '*************************************************************************
1480 'REPEAT
1490   FOR I=1 TO 24:PRINT:NEXT I 
1500   PRINT "SOLVE A CUBIC EQUATION"
1510   PRINT "     a*x^3 + b*x^2 + c*x + d = 0"
1520   PRINT
1530   INPUT "Enter a,b,c,d (separated by comma's) : ",A,B,C,D:PRINT
1540   IF A=0 THEN 1550 ELSE 1570
1550   'THEN
1560     PRINT "a=0 : use program SOLVE2":GOTO 1650
1570   'ELSE
1580     E=B/3/A
1590     F=C/3/A
1600     P=F-E*E
1610     Q=E*(E*E-1.5*F)+D/2/A
1620     D0=P*P*P+Q*Q
1630     IF ABS(D0)<EPS THEN D0=0
1640     ON SGN(D0)+2 GOSUB 1760,1870,2030
1650   'ENDIF
1660   PRINT:PRINT "Solve another equation? (Y/N) : ";
1670   Y$=INPUT$(1):IF INSTR("YyNn",Y$)=0 THEN 1670
1680   IF INSTR("Yy",Y$) THEN PRINT "yes":GOTO 1480 ELSE PRINT "no"
1690 'UNTIL ANSWER="No"
1700 END
1710 '*************************************************************************
1720 '
1730 ' S U B R O U T I N E S :
1740 '
1750 '*************************************************************************
1760 ' D<0 :
1770 '*************************************************************************
1780 PRINT "three separate real roots:"
1790 R=-2*SQR(-P)
1800 S=FNARCCOS(2*Q/P/R)/3
1810 Z1=R*COS(S)
1820 Z2=R*COS(2/3*PI+S)
1830 Z3=R*COS(2/3*PI-S)
1840 PRINT "x1=";FNX(Z1),"x2=";FNX(Z2),"x3=";FNX(Z3)
1850 RETURN
1860 '*************************************************************************
1870 ' D=0 :
1880 '*************************************************************************
1890 IF Q=0 THEN 1900 ELSE 1940
1900 'THEN
1910   PRINT "three identical real roots:"
1920   PRINT "x1=x2=x3=";FNX(0)
1930   GOTO 2000
1940 'ELSE
1950   PRINT "1 separate and 2 identical real roots:"
1960   R=FN W3(Q)
1970   Z1=-2*R
1980   Z2=R
1990   PRINT "x1=";FNX(Z1),"x2=x3=";FNX(Z2)
2000 'ENDIF
2010 RETURN
2020 '*************************************************************************
2030 ' D>0 :
2040 '*************************************************************************
2050 PRINT "1 real and 2 complex roots:"
2060 U=FNW3(-Q+SQR(D0))
2070 V=FNW3(-Q-SQR(D0))
2080 Z1=U+V
2090 Z2=-(U+V)/2
2100 Z3= (U-V)/2*SQR(3)
2110 PRINT "x1  =";FNX(Z1)
2120 PRINT "x2,3=";FNX(Z2);" +/- i *";Z3
2130 RETURN
