{ About box }
unit SolveEq2;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, ShellAPI;

type
  TAboutBox = class(TForm)
    Panel: TPanel;
    ProgIcon: TImage;
    ProgTitle: TLabel;
    ProgIdn: TLabel;
    ProgTarget: TLabel;
    Copyright: TLabel;
    Email: TLabel;
    Website: TLabel;
    OKButton: TButton;
    procedure EmailClick(Sender: TObject);
    procedure WebsiteClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

Uses SolveEq0;

{$R *.DFM}

procedure TAboutBox.EmailClick(Sender: TObject);
var cmd: string;
begin if GC_LinkEmail then begin
  cmd:= 'mailto:'  + GC_Email +
        '?subject=' + 'About '+GC_ProgIdn+' '+GC_ProgVers;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to create e-mail');
end end;

procedure TAboutBox.WebsiteClick(Sender: TObject);
var cmd: string;
begin if GC_LinkWebsite then begin
  cmd:= GC_Website;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage('failed to launch web browser');
end end;

procedure TAboutBox.FormShow(Sender: TObject);
begin
  Caption               := GC_About;
  ProgIcon.Picture.Icon := Application.Icon;
  ProgIdn.Caption       := GC_ProgIdn+' '+GC_ProgVers+' - '+GC_ProgDate;
  ProgTitle.Caption     := GC_ProgTitle;
  ProgTarget.Caption    := GC_ProgTarget;
  Copyright.Caption     := GC_Copyright;
  Email.Caption         := GC_Email;
  Website.Caption       := GC_Website;
  if GC_LinkEmail then with Email.Font do begin
    Color:= clBlue;
    Style:= Style + [fsUnderline];
  end;
  if GC_LinkWebsite then with Website.Font do begin
    Color:= clBlue;
    Style:= Style + [fsUnderline];
  end;
end;

end.

