{ Main Window }
unit SolveEq1;

interface

uses
  SolveEq0, NumLib,
  ExtCtrls, Menus, Dialogs, StdCtrls, Controls, Buttons, Classes,
  Windows, Messages, SysUtils, Graphics, Forms, ComCtrls, Mask, Spin;

type
  TMainWindow = class(TForm)
    ToolBar: TPanel;
    FontDialog: TFontDialog;
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuFileExit: TMenuItem;
    MnuOptions: TMenuItem;
    MnuOptToolBar: TMenuItem;
    MnuOptHints: TMenuItem;
    MnuOptFont: TMenuItem;
    MnuOptLanguage: TMenuItem;
    MnuOptLangUS: TMenuItem;
    MnuOptLangNL: TMenuItem;
    MnuHelp: TMenuItem;
    MnuHelpAbout: TMenuItem;
    BtnExit: TSpeedButton;
    BtnHints: TSpeedButton;
    BtnFont: TSpeedButton;
    BtnHelp: TSpeedButton;
    TxtOutput: TMemo;
    PnlInput: TPanel;
    PageControl: TPageControl;
    TabSheet3: TTabSheet;
    PnlInput2: TPanel;
    LblA2: TLabel;
    LblB2: TLabel;
    LblC2: TLabel;
    TxtEquation2: TMemo;
    TxtA2: TEdit;
    TxtB2: TEdit;
    TxtC2: TEdit;
    TabSheet4: TTabSheet;
    PnlInput3: TPanel;
    LblA3: TLabel;
    LblB3: TLabel;
    LblC3: TLabel;
    LblD3: TLabel;
    TxtEquation3: TMemo;
    TxtA3: TEdit;
    TxtB3: TEdit;
    TxtC3: TEdit;
    TxtD3: TEdit;
    PnlButtons: TPanel;
    BtnOK: TBitBtn;
    BtnClose: TBitBtn;
    BtnClear: TBitBtn;
    PnlStatus3: TPanel;
    PnlStatus2: TPanel;
    GrpPrecision: TGroupBox;
    TxtPrecision: TSpinEdit;
    LblPrecision: TLabel;
    GrpDecimal: TRadioGroup;
    BtnUS: TSpeedButton;
    BtnNL: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MnuFileExitClick(Sender: TObject);
    procedure MnuOptionsClick(Sender: TObject);
    procedure MnuOptToolBarClick(Sender: TObject);
    procedure MnuOptHintsClick(Sender: TObject);
    procedure MnuOptFontClick(Sender: TObject);
    procedure MnuHelpAboutClick(Sender: TObject);
    procedure FontDialogApply(Sender: TObject; Wnd: Integer);
    procedure BtnOKClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
    procedure GrpDecimalClick(Sender: TObject);
    procedure TxtFactor2Change(Sender: TObject);
    procedure TxtFactor3Change(Sender: TObject);
    procedure MnuOptLangUSClick(Sender: TObject);
    procedure MnuOptLangNLClick(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(var V_Msg: Tmessage); message WM_GetMinMaxInfo;
    function  EqDegree: integer;
    procedure SolveInp2;
    procedure SolveInp3;
    procedure Solve2(A: T_Factor);
    procedure Solve3(A: T_Factor);
  public
    procedure ApplyFont;
    procedure AdjustControls;
    procedure SwitchLanguage(V_Language: T_Language);
  end;

var
  MainWindow: TMainWindow;

implementation

uses SolveEq2;

{$R *.DFM}

procedure TMainWindow.SwitchLanguage(V_Language: T_Language);
begin
  GC_Language:= V_Language;
  case V_Language of
    lng_US : begin
      MnuOptLangUS.Checked:= true;
      MnuOptLangNL.Checked:= false;
      BtnUS.Down     := true;
      BtnNL.Down     := false;
      GC_ProgTitle   := GC_ProgTitleE;
      GC_ProgDate    := GC_ProgDateE;
      GC_ProgTitle   := GC_ProgTitleE;
      GC_About       := GC_AboutE;
      GC_ErrInput    := GC_ErrInputE;
      GC_MsgIdentity := GC_MsgIdentityE;
      GC_MsgFalseEq  := GC_MsgFalseEqE;
      GC_Msg1Root    := GC_Msg1RootE;
      GC_Msg2CCRoots := GC_Msg2CCRootsE;
      GC_Msg2EqRoots := GC_Msg2EqRootsE;
      GC_Msg3EqRoots := GC_Msg3EqRootsE;
      GC_Msg2SepRoot := GC_Msg2SepRootE;
      GC_Msg3SepRoot := GC_Msg3SepRootE;
      GC_Msg1_EqRoot := GC_Msg1_EqRootE;
      GC_Msg1_CCRoot := GC_Msg1_CCRootE;
      MainWindow.Caption           := GC_ProgTitleE;
      PageControl.Pages[0].Caption := GC_Title2E;
      PageControl.Pages[1].Caption := GC_Title3E;
      GrpPrecision.Caption         := GC_PrecisionE;
      LblPrecision.Caption         := GC_DigitsE;
      GrpDecimal.Caption           := GC_DecimalPtE;
      GrpDecimal.Items[0]          := GC_DotE;
      GrpDecimal.Items[1]          := GC_CommaE;
      BtnClear.Caption             := GC_ClearE;
      BtnClose.Caption             := GC_CloseE;
      MnuFile.Caption              := GC_MnuFileE;
      MnuFileExit.Caption          := GC_MnuFileExitE;
      MnuOptions.Caption           := GC_MnuOptionsE;
      MnuOptToolbar.Caption        := GC_MnuOptToolbE;
      MnuOptLanguage.Caption       := GC_MnuOptLangE;
      MnuHelpAbout.Caption         := GC_MnuHlpAboutE;
    end;
    lng_NL : begin
      MnuOptLangUS.Checked:= false;
      MnuOptLangNL.Checked:= true;
      BtnUS.Down     := false;
      BtnNL.Down     := true;
      GC_ProgTitle   := GC_ProgTitleN;
      GC_ProgDate    := GC_ProgDateN;
      GC_ProgTitle   := GC_ProgTitleN;
      GC_About       := GC_AboutN;
      GC_ErrInput    := GC_ErrInputN;
      GC_MsgIdentity := GC_MsgIdentityN;
      GC_MsgFalseEq  := GC_MsgFalseEqN;
      GC_Msg1Root    := GC_Msg1RootN;
      GC_Msg2CCRoots := GC_Msg2CCRootsN;
      GC_Msg2EqRoots := GC_Msg2EqRootsN;
      GC_Msg3EqRoots := GC_Msg3EqRootsN;
      GC_Msg2SepRoot := GC_Msg2SepRootN;
      GC_Msg3SepRoot := GC_Msg3SepRootN;
      GC_Msg1_EqRoot := GC_Msg1_EqRootN;
      GC_Msg1_CCRoot := GC_Msg1_CCRootN;
      MainWindow.Caption           := GC_ProgTitleN;
      PageControl.Pages[0].Caption := GC_Title2N;
      PageControl.Pages[1].Caption := GC_Title3N;
      GrpPrecision.Caption         := GC_PrecisionN;
      LblPrecision.Caption         := GC_DigitsN;
      GrpDecimal.Caption           := GC_DecimalPtN;
      GrpDecimal.Items[0]          := GC_DotN;
      GrpDecimal.Items[1]          := GC_CommaN;
      BtnClear.Caption             := GC_ClearN;
      BtnClose.Caption             := GC_CloseN;
      MnuFile.Caption              := GC_MnuFileN;
      MnuFileExit.Caption          := GC_MnuFileExitN;
      MnuOptions.Caption           := GC_MnuOptionsN;
      MnuOptToolbar.Caption        := GC_MnuOptToolbN;
      MnuOptLanguage.Caption       := GC_MnuOptLangN;
      MnuHelpAbout.Caption         := GC_MnuHlpAboutN;
    end;
  end;
end;

procedure TMainWindow.WMGetMinMaxInfo(var V_Msg: Tmessage);
begin with PMinMaxInfo(V_Msg.lparam)^.ptMinTrackSize do begin
  x:= GC_MinWidth;
  y:= GC_MinHeight;
end; end;

function  TMainWindow.EqDegree: integer;
begin
  if PageControl.ActivePage = TabSheet3
    then Result:= 2
    else Result:= 3;
end;

procedure TMainWindow.SolveInp2;
var Factor: T_Factor;
begin with TxtOutput.Lines do begin
  if TxtA2.Text = '' then TxtA2.Text:= '0';
  if TxtB2.Text = '' then TxtB2.Text:= '0';
  if TxtC2.Text = '' then TxtC2.Text:= '0';
  if not (EditToReal(TxtA2,Factor[2]) and
          EditToReal(TxtB2,Factor[1]) and
          EditToReal(TxtC2,Factor[0]))
  then begin
    PnlStatus2.Caption:= GC_ErrInput;
    MessageBeep(MB_ICONHAND);
  end
  else begin
    PnlStatus2.Caption:= '';
    Solve2(Factor);
  end;
end end;

procedure TMainWindow.SolveInp3;
var Factor: T_Factor;
begin with TxtOutput.Lines do begin
  if TxtA3.Text = '' then TxtA3.Text:= '0';
  if TxtB3.Text = '' then TxtB3.Text:= '0';
  if TxtC3.Text = '' then TxtC3.Text:= '0';
  if TxtD3.Text = '' then TxtD3.Text:= '0';
  if not (EditToReal(TxtA3,Factor[3]) and
          EditToReal(TxtB3,Factor[2]) and
          EditToReal(TxtC3,Factor[1]) and
          EditToReal(TxtD3,Factor[0]))
  then begin
    PnlStatus3.Caption:= GC_ErrInput;
    MessageBeep(MB_ICONHAND);
  end
  else begin
    PnlStatus3.Caption:= '';
    Solve3(Factor);
  end;
end end;

procedure TMainWindow.Solve2(A: T_Factor);
var Discr,w,x1: Extended;
begin with TxtOutput.Lines do begin
  Add(EquationStr(2,A));
  if A[2] = 0.0 then begin
    if A[1] = 0.0 then begin
      if A[0] = 0.0 then Add(GC_MsgIdentity)
                 else Add(GC_MsgFalseEq);
    end
    else begin
      Add(GC_Msg1Root);
      Add('x = '+ RealToString(-A[0]/A[1]));
    end;
  end
  else begin
    Discr:= A[1]*A[1] - 4*A[2]*A[0];
    if Discr < 0.0 then begin
      Add(GC_Msg2CCRoots);
      Add('x1,2 = '+
          RealToString(-A[1]/A[2]/2.0)+' +/- i * '+
          RealToString(sqrt(-Discr)/A[2]/2.0))
    end
    else if Discr = 0.0 then begin
      Add(GC_Msg2EqRoots);
      Add('x1 = x2 = '+
          RealToString(-A[1]/A[2]/2.0))
    end
    else {Discr > 0} begin
      if A[1] < 0.0 then w:= -sqrt(Discr) else w:= sqrt(Discr);
      x1:= -(A[1]+w)/A[2]/2.0;
      Add(GC_Msg2SepRoot);
      Add('x1 = '+RealToString(x1));
      Add('x2 = '+RealToString(A[0]/A[2]/x1));
    end;
  end;
  Add('');
end end;

procedure TMainWindow.Solve3(A: T_Factor);
{
 CARDANO'S METHOD / TRIGONIOMETRIC EQUATIONS
********************************************************
*                                                      * prog variables:
*    a*x^3 + b*x^2 + c*x + d = 0                       * A[3],A[2],A[1],A[0]
*                                                      *
* with z=x+b/(3a): z^3 + 3pz + 2q = 0                  * e=b/(3a),f=c/(3a)
* where            p = c/(3a) - (b/(3a))^2             * p
*                  q = (b/(3a))^3 - bc/(6a^2) + d/(2a) * q
* Discriminant   : D = p^3 + q^2                       * Discr
********************************************************
* 1] D<0 : 3 separate real roots                       *
*                                                      *
*          z1 = -2 SQRT(-p) cos(f/3)                   *
*          z2 = -2 SQRT(-p) cos(2/3 PI + f/3)          *
*          z3 = -2 SQRT(-p) cos(2/3 PI - f/3)          *
*                                                      * r=-2 SQRT(-p)
*          where cos f = q * p^(-3/2)                  * s=Ff3
********************************************************
* 2] D=0 and q=0 : 3 identical real roots              *
*                  z1 = z2 = z3 = 0                    *
*    D=0 and q<>0: 2 separate real roots               *
*                  z1 = -2 q^(1/3)                     *
*                  z2 = z3 = q^(1/3)                   * r=q^(1/3)
********************************************************
* 3] D>0 : 1 real and 2 complex roots                  *
*                                                      *
*          z1 = u + v                                  *
*          z2 = -(u+v)/2 + i * SQRT(3) * (u-v)/2       *
*          z3 = -(u+v)/2 - i * SQRT(3) * (u-v)/2       *
*                                                      *
*          with: u = (-q + SQR(D))^(1/3)               * U
*                v = (-q - SQR(D))^(1/3)               * V
********************************************************
* General rule : x = z - b/(3a)                        *
********************************************************
}
var e,f,p,q,r,s,u,v,Discr: Extended;
begin
  if A[3] = 0.0 then Solve2(A)
  else with TxtOutput.Lines do begin
    Add(EquationStr(3,A));
    e:= A[2]/A[3]/3.0;
    f:= A[1]/A[3]/3.0;
    p:= f-e*e;
    q:= e*(e*e-1.5*f)+A[0]/A[3]/2.0;
    Discr:= p*p*p+q*q;
    if      Discr < 0.0  then begin
      Add(GC_Msg3SepRoot);
      r:= -2.0 * sqrt(-p);
      s:= EArcCos(2.0*q/p/r)/3.0;
      Add('x1 = ' + RealToString(r*Cos(s)-e));
      Add('x2 = ' + RealToString(r*Cos(Pi*2.0/3.0+s)-e));
      Add('x3 = ' + RealToString(r*Cos(Pi*2.0/3.0-s)-e));
    end
    else if Discr = 0.0  then begin
      if q = 0.0 then begin
        Add(GC_Msg3EqRoots);
        Add('x1 = x2 = x3 = ' + RealToString(-e));
      end
      else begin
        Add(GC_Msg1_EqRoot);
        r:= ERoot3(q);
        Add('x1 = '      + RealToString(-2.0*r-e));
        Add('x2 = x3 = ' + RealToString(r-e));
      end
    end
    else   {Discr > 0} begin
      Add(GC_Msg1_CCRoot);
      u:= ERoot3(-q+sqrt(Discr));
      v:= ERoot3(-q-sqrt(Discr));
      Add('x1 = '   + RealToString(u+v-e));
      Add('x2,3 = ' + RealToString(-(u+v)/2.0-e) +
        ' +/- i * ' + RealToString((u-v)/2.0*sqrt(3.0)-e));
    end;
    Add('');
  end;
end;

procedure TMainWindow.ApplyFont;
begin
  TxtEquation2.Font := FontDialog.Font;
  TxtA2.Font        := FontDialog.Font;
  TxtB2.Font        := FontDialog.Font;
  TxtC2.Font        := FontDialog.Font;
  TxtEquation3.Font := FontDialog.Font;
  TxtA3.Font        := FontDialog.Font;
  TxtB3.Font        := FontDialog.Font;
  TxtC3.Font        := FontDialog.Font;
  TxtD3.Font        := FontDialog.Font;
  TxtOutput.Font    := FontDialog.Font;
end;

procedure TMainWindow.AdjustControls;
begin
  BtnHints.Down:= ShowHint;
end;


{ Generated }

procedure TMainWindow.FormCreate(Sender: TObject);
begin
  Icon:= Application.Icon;
  ApplyFont;
end;

procedure TMainWindow.FormShow(Sender: TObject);
begin
  GV_SettingFnm      := ChangeFileExt(Application.ExeName,GC_SettingExt);
  ReadOptions;
  SwitchLanguage(GC_Language);
  Application.Title  := GC_ProgTitle;
  MainWindow.Caption := GC_ProgTitle;
  SetSeparators(GrpDecimal.ItemIndex);
end;

procedure TMainWindow.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:= WriteOptions;
end;

procedure TMainWindow.MnuFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainWindow.MnuOptionsClick(Sender: TObject);
begin
  MnuOptToolbar.Checked  := Toolbar.Visible;
  MnuOptHints.Enabled    := Toolbar.Visible;
  if MnuOptHints.Enabled then
    MnuOptHints.Checked  := ShowHint
  else
    MnuOptHints.Checked  := false;
end;

procedure TMainWindow.MnuOptToolBarClick(Sender: TObject);
begin
  Toolbar.Visible:= not Toolbar.Visible;
end;

procedure TMainWindow.MnuOptHintsClick(Sender: TObject);
begin
  ShowHint:= not ShowHint;
  AdjustControls;
end;

procedure TMainWindow.MnuOptFontClick(Sender: TObject);
begin
  if FontDialog.Execute then ApplyFont;
end;

procedure TMainWindow.MnuHelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainWindow.FontDialogApply(Sender: TObject; Wnd: Integer);
begin
  ApplyFont;
end;


procedure TMainWindow.BtnOKClick(Sender: TObject);
begin
  if EqDegree = 2 then SolveInp2 else SolveInp3;
end;

procedure TMainWindow.BtnClearClick(Sender: TObject);
begin
  TxtOutput.Lines.Clear;
end;

procedure TMainWindow.GrpDecimalClick(Sender: TObject);
  var F2,F3: T_Factor; ok2,ok3: array[0..3] of boolean;
begin
  ok2[0]:= EditToReal(TxtC2,F2[0]);
  ok2[1]:= EditToReal(TxtB2,F2[1]);
  ok2[2]:= EditToReal(TxtA2,F2[2]);
  ok3[0]:= EditToReal(TxtD3,F3[0]);
  ok3[1]:= EditToReal(TxtC3,F3[1]);
  ok3[2]:= EditToReal(TxtB3,F3[2]);
  ok3[3]:= EditToReal(TxtA3,F3[3]);
  SetSeparators(GrpDecimal.ItemIndex);
  if ok2[0] then TxtC2.Text:= RealToString(F2[0]);
  if ok2[1] then TxtB2.Text:= RealToString(F2[1]);
  if ok2[2] then TxtA2.Text:= RealToString(F2[2]);
  if ok3[0] then TxtD3.Text:= RealToString(F3[0]);
  if ok3[1] then TxtC3.Text:= RealToString(F3[1]);
  if ok3[2] then TxtB3.Text:= RealToString(F3[2]);
  if ok3[3] then TxtA3.Text:= RealToString(F3[3]);
end;

procedure TMainWindow.TxtFactor2Change(Sender: TObject);
begin
  PnlStatus2.Caption:= '';
end;

procedure TMainWindow.TxtFactor3Change(Sender: TObject);
begin
  PnlStatus3.Caption:= '';
end;

procedure TMainWindow.MnuOptLangUSClick(Sender: TObject);
begin
  SwitchLanguage(lng_US);
end;

procedure TMainWindow.MnuOptLangNLClick(Sender: TObject);
begin
  SwitchLanguage(lng_NL);
end;

end.
