{ General }
unit SolveEq0;

interface

uses
  NumLib,
  SysUtils, WinProcs, Classes, Controls, Graphics, Forms, Dialogs,
  StdCtrls, IniFiles;

const
  { global constants : general }
  GC_ProgIdn     = 'SolveEqD';
  GC_ProgVers    = 'v1.1';
  GC_ProgDateE   = 'March 11, 2000';
  GC_ProgDateN   = '11 maart 2000';
  GC_ProgTitleE  = 'Solve 2nd or 3rd degree equation';
  GC_ProgTitleN  = 'Oplossing 2e of 3e graads vergelijking';
  GC_AboutE      = 'About';
  GC_AboutN      = 'Info';
  GC_ProgTarget  = 'Windows 95/NT';
  GC_Copyright   = 'Copyright  2000, J.R. Ferguson';
  GC_Email       = 'j.r.ferguson@iname.com';
  GC_Website     = 'http://hello.to/ferguson';
  GC_Title2E     = '2nd degree';
  GC_Title3E     = '3rd degree';
  GC_Title2N     = '2e graad';
  GC_Title3N     = '3e graad';
  GC_PrecisionE  = 'Precision';
  GC_PrecisionN  = 'Nauwkeurigheid';
  GC_DigitsE     = 'digits';
  GC_DigitsN     = 'cijfers';
  GC_DecimalPtE  = 'Decimal point';
  GC_DecimalPtN  = 'Decimaalteken';
  GC_DotE        = 'Dot';
  GC_DotN        = 'Punt';
  GC_CommaE      = 'Comma';
  GC_CommaN      = 'Komma';
  GC_ClearE      = 'Clear';
  GC_ClearN      = 'Wissen';
  GC_CloseE      = 'Close';
  GC_CloseN      = 'Sluiten';
  GC_MnuFileE    = '&File';
  GC_MnuFileN    = '&Bestand';
  GC_MnuFileExitE= 'E&xit';
  GC_MnuFileExitN= '&Afsluiten';
  GC_MnuOptionsE = '&Options';
  GC_MnuOptionsN = '&Opties';
  GC_MnuOptToolbE= '&Toolbar';
  GC_MnuOptToolbN= '&Taakbalk';
  GC_MnuOptLangE = '&Language';
  GC_MnuOptLangN = 'T&aal';
  GC_MnuHlpAboutE= '&About';
  GC_MnuHlpAboutN= '&Info';
  GC_LinkEmail   = true;
  GC_LinkWebsite = true;
  GC_SettingExt  = '.ini';
  GC_MinWidth    = 305;
  GC_MinHeight   = 380;
  GC_ErrInputE   = 'Incorrect: input must be numeric';
  GC_ErrInputN   = 'Fout: invoer moet een getal zijn';
  GC_MsgIdentityE= 'Identity : holds for any x';
  GC_MsgIdentityN= 'Identiteit : geldig voor elke x';
  GC_MsgFalseEqE = 'False equation : no solution';
  GC_MsgFalseEqN = 'Valse vergelijking : geen oplossing';
  GC_Msg1RootE   = 'One single root:';
  GC_Msg1RootN   = 'Een losse wortel';
  GC_Msg2CCRootsE= 'Two conjungate complex roots:';
  GC_Msg2CCRootsN= 'Twee toegevoegd complexe wortels:';
  GC_Msg2EqRootsE= 'Two identical real roots:';
  GC_Msg2EqRootsN= 'Twee identieke reele wortels:';
  GC_Msg3EqRootsE= 'Three identical real roots:';
  GC_Msg3EqRootsN= 'Drie identieke reele wortels:';
  GC_Msg2SepRootE= 'Two separate real roots:';
  GC_Msg2SepRootN= 'Twee verschillende reele wortels';
  GC_Msg3SepRootE= 'Three separate real roots:';
  GC_Msg3SepRootN= 'Drie verschillende reele wortels';
  GC_Msg1_EqRootE= 'One separate and two identical real roots:';
  GC_Msg1_EqRootN= 'Een aparte en twee identieke reele wortels:';
  GC_Msg1_CCRootE= 'One real and two conjungate complex roots:';
  GC_Msg1_CCRootN= 'Een reele en twee toegevoegd complexe wortels:';

type
  T_Factor       = array[0..3] of Extended;
  T_Language     = (lng_US,lng_NL);

const
  GC_Language    : T_Language = lng_US;
  GC_About       : String = GC_AboutE;
  GC_ProgDate    : String = GC_ProgDateE;
  GC_ProgTitle   : String = GC_ProgTitleE;
  GC_ErrInput    : String = GC_ErrInputE;
  GC_MsgIdentity : String = GC_MsgIdentityE;
  GC_MsgFalseEq  : String = GC_MsgFalseEqE;
  GC_Msg1Root    : String = GC_Msg1RootE;
  GC_Msg2CCRoots : String = GC_Msg2CCRootsE;
  GC_Msg2EqRoots : String = GC_Msg2EqRootsE;
  GC_Msg3EqRoots : String = GC_Msg3EqRootsE;
  GC_Msg2SepRoot : String = GC_Msg2SepRootE;
  GC_Msg3SepRoot : String = GC_Msg3SepRootE;
  GC_Msg1_EqRoot : String = GC_Msg1_EqRootE;
  GC_Msg1_CCRoot : String = GC_Msg1_CCRootE;

var
  GV_SettingFnm  : String;

function  ERoot3(x: Extended): Extended;
procedure SetSeparators(V_Index: integer);
function  EditToReal(const V_Edit: TEdit; var V_Number: Extended): boolean;
function  RealToString(const V_Number: Extended): String;
function  EquationStr(V_Degree: integer; const V_Factor: T_Factor): String;
procedure SetCursor(V_NewCursor: TCursor);
procedure RestoreCursor;
procedure ReadOptions;
function  WriteOptions: boolean;

implementation

Uses SolveEq1;

var
  OldCursor: TCursor;


function  ERoot3(x: Extended): Extended;
begin
  if      x = 0.0 then Result:= 0.0
  else if x > 0.0 then Result:= EPowerE( x,1.0/3.0)
  else{if x < 0.0 then}Result:=-EPowerE(-x,1.0/3.0);
end;

procedure SetSeparators(V_Index: integer);
begin case V_Index of
 0 : begin DecimalSeparator:= '.'; ThousandSeparator:= ','; end;
 1 : begin DecimalSeparator:= ','; ThousandSeparator:= '.'; end;
end end;

function EditToReal(const V_Edit: TEdit; var V_Number: Extended): boolean;
begin
  try V_Number:= StrToFloat(V_Edit.Text); Result:= true;
  except on EConvertError do Result:= false; end;
end;

function RealToString(const V_Number: Extended): String;
begin
  Result:= FloatToStrF(V_Number,ffGeneral,MainWindow.TxtPrecision.Value,1);
end;

function  EquationStr(V_Degree: integer; const V_Factor: T_Factor): String;
var s: String; i: integer;
  function OptionalFactor(a: Extended): String;
  begin
    if (a = 1) and (i>0) then Result:= ''
                         else Result:= RealToString(a)+' ';
  end;
begin { EquationStr }
  s:= '';
  for i:= V_Degree downto 0 do if V_Factor[i] <> 0 then begin
    if s = '' then s:= OptionalFactor(V_Factor[i])
    else begin
      if V_Factor[i] > 0 then s:= s + '+ '
                         else s:= s + '- ';
      s:= s + OptionalFactor(abs(V_Factor[i]));
    end;
    if i > 0 then begin
      s:= s + 'x';
      if i > 1 then s:= s + '^' + IntToStr(i);
      s:= s + ' '
    end;
  end;
  if s = '' then s:= '0 ';
  Result:= s + '= 0';
end;

procedure SetCursor(V_NewCursor: TCursor);
begin OldCursor:= Screen.Cursor; Screen.Cursor:= V_NewCursor; end;

procedure RestoreCursor;
begin Screen.Cursor:= OldCursor; end;

procedure ReadOptions;
var Bold, Italic: boolean; IniFile: TIniFile;
begin
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try
    Left   := ReadInteger('Position','Left'  ,Left);
    Top    := ReadInteger('Position','Top'   ,Top);
    Width  := ReadInteger('Position','Width' ,Width);
    Height := ReadInteger('Position','Height',Height);
    with FontDialog.Font do begin
      Name    := ReadString ('Font' ,'Name'  ,Name);
      Size    := ReadInteger('Font' ,'Size'  ,Size);
      Color   := ReadInteger('Font' ,'Color' ,Color);
      Bold    := ReadBool   ('Font' ,'Bold'  ,fsBold   in Style);
      Italic  := ReadBool   ('Font' ,'Italic',fsItalic in Style);
      Style   := [];
      if Bold   then Style := Style + [fsBold];
      if Italic then Style := Style + [fsItalic];
      ApplyFont;
    end;
    GC_Language:= T_Language(ReadInteger(  'Options','Language',ord(GC_Language)));
    with Toolbar    do Visible := ReadBool('Options','Toolbar' ,Visible);
    with MainWindow do ShowHint:= ReadBool('Options','Hints'   ,ShowHint);
    with MainWindow.TxtPrecision do
      Value     := ReadInteger('Options','Precision' ,Value);
    with MainWindow.GrpDecimal do
      ItemIndex := ReadInteger('Options','DecimalSep',ItemIndex);
  finally IniFile.Free; AdjustControls; RestoreCursor; end;
end;

function  WriteOptions: boolean;
var IniFile: TIniFile;
begin
  Result:= true;
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try try
    WriteInteger('Position','Left'  ,Left);
    WriteInteger('Position','Top'   ,Top);
    WriteInteger('Position','Width' ,Width);
    WriteInteger('Position','Height',Height);
    with FontDialog.Font do begin
      WriteString ('Font','Name'  ,Name);
      WriteInteger('Font','Size'  ,Size);
      WriteInteger('Font','Color' ,Color);
      WriteBool   ('Font','Bold'  ,fsBold   in Style);
      WriteBool   ('Font','Italic',fsItalic in Style);
    end;
    WriteInteger('Options','Language'  ,ord(GC_Language));
    WriteBool   ('Options','Toolbar'   ,Toolbar.Visible);
    WriteBool   ('Options','Hints'     ,MainWindow.ShowHint);
    WriteInteger('Options','Precision' ,MainWindow.TxtPrecision.Value);
    WriteInteger('Options','DecimalSep',MainWindow.GrpDecimal.ItemIndex);
  finally IniFile.Free; RestoreCursor; end;
  except on E: Exception do
    Result:= MessageDlg(E.Message,mtError,mbOKCancel,0) = mrOk;
  end;
end;

end.

