{ SIMPSONE: Compute definite integral with Simpson's rule

  Title   : SIMPSONE
  Language: Borland Pascal v7.0
  Version : 1.3
  Date    : Feb 15, 2000
  Author  : J R Ferguson
  Usage   : refer procedure Help
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

Computation of the definite integral value for a function with optional
check if the primitive function is known. The step size is decided by
the user.

This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need  some  units  from  the  JRFPAS
Pascal  routine  library by the same author, which can be downloaded from
the Internet address mentioned above.
}

program SIMPSON;
Uses DefLib, ConLib, EvlLib, Crt;

const
 test = false;

var
  a,b,h,x,
  approximation,
  integral    : real;
  n,k         : integer;
  known       : boolean;  { primitive function known }
  f, primitive: StpTyp;
  err         : boolean;

function evaluate(f: StpTyp; x: real): real;
begin if not err then evaluate:= eval(f,x,err); end;

procedure Main;
begin {Main}
  ClrScr;
  writeln        ('COMPUTE DEFINITE INTEGRAL WITH SIMPSON''S RULE');
  writeln;
  write          ('Function ............... f(x) = '); readln(f);
  known :=
    YesNo        ('Is primitive function known ');
  if known then begin
    write        ('Primitive function ..... F(x) = '); readln(primitive);
  end;
  write          ('Lower boundary ............ a = '); readln(a);
  write          ('Upper boundary ............ b = '); readln(b);
  err:= false;
  if known then begin
    integral:= evaluate(primitive,b) - evaluate(primitive,a);
    if not err then
      writeln    ('  Computed ................ I = ',integral);
  end;
  if not err then repeat
    write        ('Number of steps (stop with 0) n = '); readln(n);
    if n > 0 then begin
      if odd(n) then Inc(n); { must be even }
      h:= (b-a)/n;
      x:= a;
      approximation:= evaluate(f,x);
      if not err then begin
        for k:= 1 to n div 2 do begin
          x:= x + h; approximation:= approximation + 4 * evaluate(f,x);
          if not err then begin
            x:= x + h; approximation:= approximation + 2 * evaluate(f,x);
          end;
        end;
        if not err then begin
          approximation:= (approximation - evaluate(f,b)) * h/3;
          if not err then begin
            write('  Approximation ........... I = ',approximation);
            if known then write (',  error = ',approximation - integral);
            writeln;
          end;
        end;
      end;
    end;
  until (n <= 0) or err;
  if err then writeln('DISCARDED: EVAL ERROR');
end;

begin {program}
  repeat Main
  until not YesNo('Again');
end.
