
{ Makes a huge sieve on disk. }

PROGRAM Sieve_01;

USES Crt, Dos;

TYPE

    SieveRecord = RECORD
                     SieveValue : Char
                  END;

VAR

    SieveRec:  SieveRecord;              { A record variable }
    SieveFile: FILE OF SieveRecord;
    I, K, N, KN, LastRecordNumber, Start, Current, Step : LongInt ;

    AN : Real ;

    h1, m1, s1, ss1, h2, m2, s2, ss2 : word ;
    ht, mt, st, sst : word ;
    ElapsedTime, Count : LongInt ;
    ETH, ETM, ETS : LongInt ;

    PrimeFile : Text ;
    TimeFIle  : Text ;

BEGIN

    CLRSCR;
    ASSIGN( SieveFile, 'Sieve.Lst' );
    REWRITE( SieveFile );                { File pointer at rec 0 }

    Assign(PrimeFile, 'Prime.lst') ;
    ReWrite(PrimeFile) ;

    Assign(TimeFile, 'Time.lst') ;
    ReWrite(TimeFile) ;

    Writeln('Input Maximum N.') ;
    Read(N) ;

    Writeln('Starting .... ') ;

    GetTime(ht, mt, st, sst) ;
    Writeln('Time in h/m/s/hs is ', ht:4, mt:4, st:4, sst:4) ;
    Writeln ;

    AN := N ;
    KN := Trunc(sqrt(AN)) + 1 ;

    SieveRec.SieveValue := '1' ;

    For I := 1 to N do
    Begin

        WRITE( SieveFile, SieveRec );

    END;

    Writeln('Sieve Allocated') ;

    GetTime(ht, mt, st, sst) ;
    Writeln('Time in h/m/s/hs is ', ht:4, mt:4, st:4, sst:4) ;
    Writeln ;

    LastRecordNumber := Pred(FileSize(SieveFile)) ;

    SieveRec.SieveValue := ' ' ;

{Remove 0 and 1 the sieve.}

    Seek(SieveFile, 0) ;
    Write(SieveFile, SieveRec) ;

    Seek(SieveFile, 1) ;
    Write(SieveFile, SieveRec) ;

    GetTime(H1, M1, S1, SS1) ;

    Start   := 2 ;
    Current := 2 ;
    Step    := 2 ;

    Repeat

        Current := Current + Step ;
        If Current <= LastRecordNumber then
        begin
             Seek(SieveFile, Current) ;
             Write(SieveFile, SieveRec) ;
        end ;

    Until Current >= LastRecordNumber ;

    Writeln('Sieve Completed') ;

    GetTime(ht, mt, st, sst) ;
    Writeln('Time in h/m/s/hs is ', ht:4, mt:4, st:4, sst:4) ;
    Writeln ;

    While Start <= LastRecordNumber do
    begin

         Start := Start + 1 ;
         If Start <= LastRecordNumber then
         Begin
              Seek(SieveFile, Start) ;
              Read(SieveFile, SieveRec) ;
         end ;

         If SieveRec.SieveValue  <> ' ' then
         begin


              Current := Start ;
              Step    := Start ;
              SieveRec.SieveValue  := ' ' ;

              Repeat

                    Current := Current + Step ;
                    If Current <= LastRecordNumber then
                    Begin
                         Seek(SieveFile, Current) ;
                         Write(SieveFile, SieveRec) ;
                    end ;

              Until 
                   (
                   (Current >= LastRecordNumber + 1) 
                    or 
                   (Current >= AN) 
                   );

              {
              Writeln(Step:10, Current:10) ;
              }

         end ;

    End ;

    K     := 0 ;
    Count := 0 ;

    Writeln('Prime File Started') ;

    GetTime(ht, mt, st, sst) ;
    Writeln('Time in h/m/s/hs is ', ht:4, mt:4, st:4, sst:4) ;
    Writeln ;

    While K < LastRecordNumber do
    begin
         Seek(SieveFile, K) ;
         Read(SieveFile, SieveRec) ;
         If SieveRec.SieveValue = '1' then
         begin
             Write(PrimeFile, K:8) ;
             Count := Count + 1 ;
         End ;
         K := K + 1 ;
    End ;

    Writeln('Prime File Completed') ;

    GetTime(ht, mt, st, sst) ;
    Writeln('Time in h/m/s/hs is ', ht:4, mt:4, st:4, sst:4) ;
    Writeln ;

    GetTime(H2, M2, S2, SS2) ;

    ElapsedTime := (h2 - h1) * 3600 + (m2 - m1) * 60 + (S2 - s1) ;

    Writeln(PrimeFile) ;
    Writeln(PrimeFile, 'Elapsed Time in Seconds is ', ElapsedTime : 12) ;

    Writeln(TimeFile, 'Elapsed Time in Seconds is ', ElapsedTime : 12) ;

    ETH := 0 ;
    ETM := 0 ;
    ETS := 0 ;

    If ElapsedTime >= 3600 then
    Begin
         ETH         := ElapsedTime div 3600 ;
         ElapsedTime := ElapsedTime mod 3600 ;
    End ;

    If ElapsedTime >= 60 then
    Begin
         ETM         := ElapsedTime div 60 ;
         ElapsedTime := ElapsedTime mod 60 ;
    End ;

    ETS := ElapsedTime ;

    Writeln(PrimeFile) ;

    Writeln(PrimeFile, 'Hours     ', ETH : 5) ;
    Writeln(PrimeFile, 'Minutes   ', ETM : 5) ;
    Writeln(PrimeFile, 'Seconds   ', ETS : 5) ;

    Writeln(PrimeFile, 'Number of Primes <= ', N : 12, ' is ', Count : 12) ;

    Writeln(TimeFile, 'Hours     ', ETH : 5) ;
    Writeln(TimeFile, 'Minutes   ', ETM : 5) ;
    Writeln(TimeFile, 'Seconds   ', ETS : 5) ;


    Writeln(TimeFile, 'Number of Primes <= ', N : 12, ' is ', Count : 12) ;

    Close(SieveFile) ;
    Close(PrimeFile) ;
    Close(TimeFile) ;

    Writeln('Number of Primes = ', Count:12) ;


END.  {Sieve1}

