
----------------------------------------------------------------
|                                                              |
|                                                              |
|                                                              |
|                 TTTTTTT   H     H   EEEEEEE                  |
|                    T      H     H   E                        |
|                    T      H     H   E                        |
|                    T      HHHHHHH   EEEEE                    |
|                    T      H     H   E                        |
|                    T      H     H   E                        |
|                    T      H     H   EEEEEEE                  |
|                                                              |
|                                                              |
|          RRRRRR    U     U   BBBBBB    III   K     K         |
|          R     R   U     U   B     B    I    K   K           |
|          R     R   U     U   B     B    I    K K             |
|          RRRRRR    U     U   BBBBBB     I    K               |
|          R R       U     U   B     B    I    K K             |
|          R   R     U     U   B     B    I    K   K           |
|          R     R    UUUUU    BBBBBB    III   K     K         |
|                                                              |
|                                                              |
|              CCCC    U     U   BBBBBB    EEEEEEE             |
|             C    C   U     U   B     B   E                   |
|            C         U     U   B     B   E                   |
|            C         U     U   BBBBBB    EEEEE               |
|            C         U     U   B     B   E                   |
|             C    C   U     U   B     B   E                   |
|              CCCC     UUUUU    BBBBBB    EEEEEEE             |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                 A Solution to the Rubik Cube                 |
|                                                              |
|                                                              |
|                                                              |
|                                  B                           |
|                  _________________________________           |
|                 /          /          /          /|          |
|                /   ULB    /   UB     /   UBR    / |          |
|               /__________/__________/__________/ R|          |
|              /          /          /          /| U|          |
|          L  /   UL     /    U     /    UR    / | B|          |
|            /__________/__________/__________/ R| /|          |
|           /          /          /          /| U|/ |          |
|          /   UFL    /    UF    /    URF   / |  / R|  B       |
|         /__________/__________/__________/ R| /| B|          |
|         |          |          |          | F|/ |  |          |
|         |          |          |          | U/ R| /|          |
|         |    FLU   |    FU    |    FUR   | /|  |/ |          |
|         |          |          |          |/ |  / R|          |
|         |__________|__________|__________/ R| /| B|          |
|         |          |          |          | F|/ | D|          |
|         |          |          |          |  / R| /           |
|      L  |    FL    |    F     |    FR    | /| D|/            |
|         |          |          |          |/ |  /             |
|         |__________|__________|__________/ R| /              |
|         |          |          |          | D|/  D            |
|         |          |          |          | F/                |
|         |    FDL   |    FD    |    FRD   | /                 |
|         |          |          |          |/                  |
|         |__________|__________|__________/                   |
|                                                              |
|                         D                                    |
|                                                              |
|                                                              |
|Written by     Jonathan Bowen                                 |
|               Programming Research Group                     |
|               Oxford University Computing Laboratory         |
|               8-11 Keble Road                                |
|               Oxford OX1 3QD                                 |
|               England                                        |
|                                                              |
|               Tel +44-865-273840                             |
|                                                              |
|Created        October 1981                                   |
|Updated        April 1985                                     |
|Issue          1.1                                            |
----------------------------------------------------------------
----------------------------------------------------------------
|                           Notation                           |
|--------------------------------------------------------------|
|                                                              |
|1.  Description                                               |
|    -----------                                               |
|                                                              |
|    The Rubik Cube  is a cube  which may be  considered to    |
|    consist of 27 miniature  cubes or 'cubies'.  Each face    |
|    is divided  into  nine square segments.  Any face  and    |
|    its  adjacent  segments  on  the other  faces  may  be    |
|    rotated relative to the rest of the cube.                 |
|                                                              |
|2.  Faces                                                     |
|    -----                                                     |
|                                                              |
|    The following letters are used to denote the six faces    |
|    of the cube:                                              |
|                                                              |
|    U  for the upper face,                                    |
|    B  for the back face,                                     |
|    F  for the front face,                                    |
|    L  for the lefthand face,                                 |
|    R  for the righthand face,                                |
|    D  for the downward face.                                 |
|                                                              |
|    U  B  F  L  R  D   denote a clockwise rotation through    |
|                       90 degrees  of the face  indicated.    |
|                                                              |
|    U- B- F- L- R- D-  denote  an  anticlockwise  rotation    |
|                       through 90 degrees.                    |
|                                                              |
|    U2 B2 F2 L2 R2 D2  denote   a  rotation  through   180    |
|                       degrees.                               |
|                                                              |
|3.  Segments                                                  |
|    --------                                                  |
|                                                              |
|    Each segment  of each face is represented  by a string    |
|    of one to  three letters.  The first letter  indicates    |
|    the face on which the segment is situated.  If this is    |
|    the only letter  in the string  then the segment is in    |
|    the centre of the face. If one letter follows then the    |
|    segment is  in the centre  of one of  the edges of the    |
|    face and  the  second letter  indicates  the  adjacent    |
|    face. If two letters follow then the segment is in one    |
|    of  the  corners  of the  face  and  the  two  letters    |
|    indicate the  two adjacent faces.  Note that the order    |
|    of the last two letters  is immaterial.  The following    |
|    are examples of segments:                                 |
|                                                              |
|    U           the centre segment of the upper face.         |
|                                                              |
|    RF          the segment at the centre of the righthand    |
|                face's edge which is adjacent to the front    |
|                face.                                         |
|                                                              |
|    FDL or FLD  the corner segment on the front face which    |
|                is adjacent  to the lefthand  and downward    |
|                faces.                                        |
|                                                              |
|4.  Operation notation                                        |
|    ------------------                                        |
|                                                              |
|    Segments in brackets  denote movement  of the segments    |
|    specified. Elements in the brackets are a cyclic group    |
|    and rotate round one place from right to left when the    |
|    operation is performed. E.g. (UF,BU,UL) is transformed    |
|    to (BU,UL,UF).  Note that  the first element  moves to    |
|    the last position.                                        |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
----------------------------------------------------------------
----------------------------------------------------------------
|                          Operation                           |
|--------------------------------------------------------------|
|                                                              |
|1.  Get a cross on a face ensuring that the segments match    |
|    downwards.                                                |
|                                                              |
|2.  Complete  the face  ensuring  that  the corners  match    |
|    across.                                                   |
|                                                              |
|3.  Using  the completed face  as the bottom face complete    |
|    the middle slice  using either  of the following moves    |
|    for each  of the four segments depending  on which  is    |
|    required.                                                 |
|                                                              |
|    (i)    (UF,RF):  U  R  U- R- U- F- U  F                   |
|                                                              |
|    (ii)   (UF,FR):  F- U2 L- U  L  U2 F                      |
|                                                              |
|4.  Again using the completed face  as the bottom face now    |
|    get  a  cross  on  the  upper  face.  Do  not  try  to    |
|    orientate these downwards at first.  Use the following    |
|    two moves:                                                |
|                                                              |
|    (iii)  UB,UF flip  (UF,BU,UL):  B  L  U  L- U- B-         |
|                                                              |
|    (iv)   UB,UL flip  (UF,UL,BU):  B  U  L  U- L- B-         |
|                                                              |
|5.  Now orientate the cross downwards:                        |
|                                                              |
|    (v)    (UR,UB):  F- U- F  U- F- U2 F                      |
|                                                              |
|6.  Get  the four  corners into  their  correct  positions    |
|    using either  of the following moves  depending on how    |
|    the cube has fallen out:                                  |
|                                                              |
|    (vi)   (UBR,LBU,LUF):  U  R  U- L- U  R- U- L             |
|                                                              |
|    (vii)  (UFL,FUR) and (ULB,BRU):                           |
|               B  L  U  L- U- L  U  L- U- L  U  L- U- B       |
|                                                              |
|7.  Rotate  the  corners   so  that  they  are  orientated    |
|    properly using the following move:                        |
|                                                              |
|    (viii) (FLU,LUF,UFL) and (FDL,DLF,LFD):                   |
|               R  F  R- F  R  F2  R- L- F- L  F- L- F2 L      |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
|                                                              |
----------------------------------------------------------------

