% Demonstrates how the thin lens approximation works
% Expects variables
%
% Creates variables
%
% Clears variables
%    All of them
.file_new
.quiet_snap 1
.grid_snap 0
.enable_undo 0
.clear_var
.new_text
This script demostrates how the ideal thin lens approximation relates
to a thin lens with spherical surfaces.


Do you wish to proceed?
.yes_no SKIP
.new_text
Please wait while the script creates the ray diagram.
.painting 0
.refractive_index 1.5 1.5 1.5
.0
.=> CENTREX
.75
.=> CENTREY
.150
.=> HEIGHT
.200
.=> R1
.+/-
.=> R2
.call findthck.rsc
.call mklens.rsc
.create_shape
.fast_click -200 75
.fast_click 200 75
.end_element
.create_ray
.fast_click -200 100
.fast_click -100 100
.=> RAY
.finished_rays
.painting 1
.new_text
Here you see a simple bi-convex lens with both radii of curvature set
at 200 units.


A ray striking the lens parallel to the axis is refracted towards the
axis as shown.
.pause
.new_text
The "height" of the ray is the distance between it and the lens axis.
This is indicated here by the tape measure readout (25 units at present).
.painting 0
.tapemeasure
.mid_snap
.fast_click -150 100
.perp_snap
.fast_click -100 75
.=> RAYHEIGHT
.select_object RAYHEIGHT
.tapemeasure_options 1 1 leader distance
.fast_click -98 96
.fast_click -185 90
.unselect_all
.painting 1
.pause 
.new_text
Note the point where the transmitted ray crosses the lens axis.
.annotation Here
.fast_click 200 75
.fast_click_rel 20 50
.pause


The point at which the transmitted ray crosses the axis is almost
independent of the ray height.


Click on continue to move the ray up and down the lens.
.pause
.new_text
Move the mouse to move the incident ray up and down the lens.


When you have finished click on the primary mouse button.


Notice how for large ray heights the point at which the transmitted
ray crosses the axis deviates from the marked point. This is the
cause of spherical aberration.
.mouse_limits -151 1 -150 149
.drag_handles 0
.select_object RAY
.fast_move -150 100
.fast_click -150 100
.allow_drag
.click -150 100
.unselect_all
.drag_handles 1
.new_text
To simplify analyses of thin lens systems the approximation is
usually made that all rays that strike the lens parallel to the axis
will pass through the same point on the other side of the lens.


Such an idealised lens has been added to the diagram now. The thickness
of the lens is ignored and the aperture is shown as a line with arrow
heads which indicate the convex nature of the lens.
.painting 0
.converging_lens
.paraxials_on_centre
.fast_click 0 -80
.fast_click_rel 0 75
.fast_click 200 -80
.=> PALENS
.annotation Focus
.fast_click 200 -80
.fast_click_rel 20 50
.create_ray
.fast_click -200 -55
.fast_click -100 -55
.=> RAY2
.finished_rays
.painting 1
.pause
.new_text
All rays striking an idealised thin lens parallel to its axis pass
through the focus after leaving the lens.


Move the mouse to drag the incident ray up and down the idealised thin lens.


When you have finished click on the primary mouse button.
.drag_handles 0
.select_object RAY2
.fast_move -150 -55
.fast_click -150 -55
.mouse_limits -150 -154 -149 -6
.allow_drag
.click -150 -55
.unselect_all
.drag_handles 1
.new_text
You can clearly see the effect of spherical aberration when
many rays strike the lenses at the same time.


Click on continue to see this.
.pause
.painting 0
.clear_rays
.clear_tapemeasures
.source_ray_count 10
.plane_source
.fast_click -200 150
.fast_click -50 150
.fast_click -50 0
.=> SRC1
.plane_source
.fast_click -200 -5
.fast_click -50 -5
.fast_click -50 -155
.=> SRC2
.painting 1
.new_text
Rays that pass through the outer edge of the real lens cross the axis
closer to the lens than those rays that are close to the axis of the lens.
This effect is known as spherical aberration.


Notice that all the rays passing through the lower idealised lens
pass through the focus.
.pause
.new_text
Since any ray path can be reversed it also holds that rays leaving
the focus of an idealised thin lens will be transmitted parallel to
the axis of the lens.


Click on continue to see rays leaving the focus of the real and ideal
lenses.
.pause
.clear_rays
.painting 0
.source_ray_count 10
.point_source
.fast_click -200 75
.fast_click 0 0
.fast_click 0 150
.=> SRC1
.point_source
.fast_click -200 -80
.fast_click 0 -155
.fast_click 0 -5
.=> SRC2
.painting 1
.new_text
You can see that for a real lens this is only an approximation. 


Click on continue.
.pause
.painting 0
.unselect_all
.select_object SRC1
.delete
.painting 1
.new_text
Another ray path of importance through a lens is one which passes directly
through the centre of the lens.
.source_ray_count 1
.point_source
.fast_click -200 100
.fast_click 0 75
.fast_click 0 75
.=> SRC1
.pause
.new_text
You can see that the ray is hardly deviated from its original path
as it passes through the lens.


To make this clearer, click on continue and the incident ray will be
projected through the lens undeviated.
.pause
.new_text
The display has been zoomed in on the mid section of the upper lens
so that you can see the slight difference in the actual ray path and
the projected ray path.
.select_object SRC1
.forward_project 1
.unselect_all
.zoom_in
.fast_click -75 120
.fast_click 75 40
.pause
.zoom_previous
.painting 0
.protractor
.fast_click 0 75
.mid_snap
.fast_click -107 88
.fast_click -100 75
.=> PROT1
.select_object PROT1
.protractor_options 1 leader degrees
.fast_click 10 85
.fast_click -65 100
.unselect_all
.painting 1 
.new_text
Now move the mouse to change the angle at which the incident ray strikes
the lens.


Notice that even for quiet large angles the difference between the transmitted
ray and the forward projection of the incident ray is very small.


When you have finished, click on the primary mouse button. 
.select_object SRC1
.fast_move -200 100
.fast_click -200 100
.mouse_limits -200 0 -100 150
.allow_drag
.click -200 100
.new_text
Hence another simplifying approimation that is made when dealing with
thin lenses is that any ray passing through the centre of the lens is
undeviated.


Move the mouse to check this on the idealised thin lens shown in the
ray diagram.


Click on the primary mouse button when you have finished.
.painting 0
.unselect_all
.select_object SRC2
.delete
.create_ray
.fast_click -200 -55
.fast_click 0 -80
.finished_rays
.=> RAY1
.select_object RAY1
.painting 1
.fast_move -200 -55
.fast_click -200 -55
.mouse_limits -200 -155 -100 -5
.allow_drag
.click -200 -55
.unselect_all
.new_text
The approximations presented here form the basis for image location
in thin lens system. The three principle rays used are:


Rays parallel to the axis are transmitted through the focus.


Rays passing through the centre are undeviated.


Rays coming from/through the focus are transmitted parallel to the axis.
.pause
.new_text
When using Raytrace, you can trace any ray through a thin lens system,
you are not restricted to the three principle rays just mentioned.


That's the end of this script. Click on continue.
.pause
:SKIP
.enable_undo 1
.quiet_snap 0
.clear_var
.return
