% Help make a point source
.new_text
This script takes you step by step through the procedure for
creating a group of rays coming from a single point - a point source.
You can create a point source without using this script
by choosing the menu item

Create -- Source > Point.


Continue?
.yes_no SKIP
:START
.grid_snap 0
.new_text
First you need to specify the number of rays you want to
come from the source. Enter this number now.
.input_limits 2 50
.10
.=> RAYCOUNT
.default_input RAYCOUNT
.RAYCOUNT userinput
.source_ray_count RAYCOUNT
.new_text
Next you must specify the point from which you want the rays to
emanate. Move the "Centre" cursor to the desired point and
click the primary mouse button.


Remember that you can use snaps to accurately specify points.
.point_source
.user_click
.new_text
Now you must specify an aperture through which the rays will pass. This is
done by selecting the two points at the ends of the aperture. The rays will
be spread out between these two points in an anticlockwise sense.


Select the first of these aperture points now by clicking with the primary mouse
button.
.user_click
.new_text
Now select the second aperture point.
.user_click
.=> SRC
.new_text
Your source has now been constructed.
If you specified the aperture points in the wrong order then the rays will
fan out in the opposite direction to that which you expected. Did this
happen?
.yes_no NOFLIP
.new_text
If this happens you can either delete the source and start again or select the
source by clicking on one of its rays and use the menu item
Modify -- Source  > Flip point sources. Click on continue to
flip the source over.
:FLIP
.unselect_all
.select_object SRC
.flip_source
:NOFLIP
.unselect_all
.new_text
Are you happy with the source you have constructed?

If you click on No then you can change various aspects of the source.
.yes_no SKIP CHANGE
:CHANGE
.new_text
Choose one of the options...


A - to change the number of rays in the source

B - to delete the whole source and start again

C - to drag the centre of the source around

D - to drag the aperture points around

E - to flip the source over

F - to exit
.choose 6 A B C D E SKIP
:A
.new_text
Enter the number of rays you want in the source.
.default_input RAYCOUNT
.RAYCOUNT userinput
.select_object SRC
.source_ray_count RAYCOUNT
.unselect_all
.goto CHANGE
:B
.select_object SRC
.delete
.goto START
:C
.select_object SRC
.object_coordinates SRC centre
.fast_move X Y
.fc X Y
.new_text
Move the mouse to drag the centre of the source and click on the
primary mouse button when you have finished.
.user_click
.unselect_all
.goto CHANGE
:D
.0
.=> RAY
.object_coordinates SRC aperture_one
.X
.=> APPNTX
.Y
.=> APPNTY
.new_text
After you click on continue the cursor will be positioned over the
first aperture point, do not move the mouse until you see where the
cursor stops.
.pause
.move X Y


Is this the point that you want to move?
.yes_no OTHERPNT
:DRAGAPPNT
.ray_of_source SRC RAY
.=> RAY
.select_object RAY
.object_coordinates RAY end
.fc X Y
.fast_move APPNTX APPNTY
.new_text
Move the mouse to drag the aperture point about and click on the
primary mouse button when you have finished.
.user_click
.unselect_all
.goto CHANGE
:OTHERPNT
.RAYCOUNT
.- 1
.=> RAY
.object_coordinates SRC aperture_two
.X
.=> APPNTX
.Y
.=> APPNTY
.goto DRAGAPPNT
:E
.select_object SRC
.flip_source
.unselect_all
.goto CHANGE
:SKIP
.return
 