% Demonstrates how the par-axial mirror approximation works
% Expects variables
%
% Creates variables
%
% Clears variables
%    All of them
.goto START
% ------------------------
% This loop is put here to speed it up
:LOOP
.fc -150 Y1
.fc TOPFX TOPFY
.fc -150 Y2
.fc 100 -80
.Y1
.- 25
.=> Y1
.Y2
.- 25
.=> Y2
.--if!=0 COUNT LOOP
.goto CONTINUE
% ------------------------
:START
.file_new
.quiet_snap 1
.grid_snap 0
.enable_undo 0
.clear_var
.new_text
This script demostrates how the par-axial mirror approximation relates
to a curved spherical mirror.


Do you wish to proceed?
.yes_no SKIP
.new_text
Please wait while the script creates the ray diagram.
.painting 0
.create_surface
.fc 0 0
.arcseg
.chord_tan
.fc 0 150
.fc -20 150
.end_element
.=> MIRROR
.select_object MIRROR
.object_coordinates MIRROR 1 tangent
.fc X Y
.set_radius 200
.unselect_all
.annotation Centre
.object_coordinates MIRROR 1 centre
.fc X Y
.fast_click_rel 20 20
.create_shape
.fast_click -200 75
.fast_click 200 75
.end_element
.set_length 150
.create_ray
.fast_click -200 100
.fast_click -100 100
.=> RAY
.finished_rays
.painting 1
.new_text
Here you see the cross section of a spherical mirror with a radius of
curvature of 200 units. The centre of curvature of the mirror is
marked for reference.


First consider a ray striking the lens parallel to the axis on the
convex side as shown.
.pause
.new_text
What is of interest is where the reflected ray appears to come from.
In particular, where it would cross the axis of the mirror. The ray
has been back projected to show this.


You can see that the reflected ray appears to come from a point on
the mirror's axis about half way between the mirror and its centre point
as marked.
.painting 0
.child_by RAY reflection
.select_object
.back_project 1
.unselect_all
.tapemeasure
.mid_snap
.fc 0 0
.centre_snap
.fc 0 0
.=> RADIUSMEAS
.annotation Here
.object_coordinates RADIUSMEAS middle
.fc X Y
.fast_click_rel 20 20
.select_object RADIUSMEAS
.delete
.X
.=> TOPFX
.Y
.=> TOPFY
.painting 1
.pause
.new_text
The "height" of the ray is the distance between it and the lens axis.
This is indicated here by the tape measure readout (25 units at present).
.painting 0
.tapemeasure
.mid_snap
.fast_click -150 100
.perp_snap
.fast_click -100 75
.=> RAYHEIGHT
.select_object RAYHEIGHT
.tapemeasure_options 1 1 leader distance
.fast_click -98 96
.fast_click -185 90
.unselect_all
.painting 1
.pause 
.new_text
The point at which the transmitted ray crosses the axis is almost
independent of the ray height.


Click on continue to move the ray up and down the lens.
.pause
.new_text
Move the mouse to move the incident ray up and down the lens.


When you have finished click on the primary mouse button.


Notice how for large ray heights the point on the axis which the
reflected ray's projection crosses deviates from the marked point.
This is the cause of spherical aberration.
.mouse_limits -151 1 -150 149
.drag_handles 0
.select_object RAY
.fast_move -150 100
.fast_click -150 100
.allow_drag
.click -150 100
.unselect_all
.drag_handles 1
.new_text
To simplify analyses of spherical mirror systems the approximation is
usually made that all rays that strike the convex side of the mirror
parallel to the axis will be reflected so that the reflected rays appear to
have come from the "focus" on the concave side of the mirror.
.pause
.new_text
Such an idealised mirror has been added to the diagram now. The curvature
of the mirror is ignored and the aperture is shown as a single line.
The dashed line indicates the axis of the mirror and the end is the focus.
.painting 0
.paraxial_mirror
.paraxials_on_centre
.fast_click 0 -80
.fast_click_rel 0 75
.fast_click 100 -80
.=> PAMIRROR
.annotation Focus
.fast_click 100 -80
.fast_click_rel 20 50
.create_ray
.fast_click -200 -55
.fast_click -100 -55
.=> RAY2
.finished_rays
.child_by RAY2 reflection
.select_object
.back_project 1
.unselect_all
.painting 1
.pause
.new_text
All rays striking the convex side of an idealised par-axial mirror parallel
to its axis give rise to reflected rays that appear to have come from the
focus of the mirror.


Move the mouse to drag the incident ray up and down the idealised mirror.


When you have finished click on the primary mouse button.
.drag_handles 0
.select_object RAY2
.fast_move -150 -55
.fast_click -150 -55
.mouse_limits -150 -154 -149 -6
.allow_drag
.click -150 -55
.unselect_all
.drag_handles 1
.new_text
What about rays that strike the mirror on the concave side?
.pause
.clear_rays
.clear_tapemeasures
.source_ray_count 2
.plane_source
.fc 200 190
.fc 55 190
.fc 55 -120
.=> PSRC
.new_text
You can see that the same focus point is important. Now there is no need
to project the reflected ray - it actually passes through the focus. To
an observer far enough to the right in this diagram, the reflected ray can be
thought of as originating at the focus.
.pause
.new_text
Move the mouse up and down now to see the effect of changing the ray height
on the mirrors.


Click on the primary mouse button when you have finished.
.drag_handles 0
.select_object PSRC
.ray_of_source PSRC 0
.=> RAY1
.object_coordinates RAY1 middle
.fc X Y
.fast_move X Y
.mouse_limits 95 1 95 149
.allow_drag
.click X Y
.drag_handles 1
.new_text
You can clearly see the effect of spherical aberration when
many rays strike the mirrors at the same time.


Click on continue to see this.
.pause
.painting 0
.clear_rays
.back_project 1
.childray_fertility
.back_project 0
.clear_tapemeasures
.source_ray_count 10
.plane_source
.fast_click -200 150
.fast_click -50 150
.fast_click -50 0
.=> SRC1
.plane_source
.fast_click -200 -5
.fast_click -50 -5
.fast_click -50 -155
.=> SRC2
.painting 1
.new_text
Rays reflected from close to the outer edge of the real mirror cross the axis
closer to the mirror than those rays that are reflected from close to the axis
of the mirror.
This effect is known as spherical aberration.


Notice that all the rays reflected from the lower idealised mirror
appear to have passed through (or come from) the focus.
.pause
.new_text
A similar situation exists for rays striking the concave side.
.painting 0
.clear_rays
.childray_fertility
.source_ray_count 10
.plane_source
.fast_click 200 150
.fast_click 50 150
.fast_click 50 0
.=> SRC1
.plane_source
.fast_click 200 -5
.fast_click 50 -5
.fast_click 50 -155
.=> SRC2
.painting 1
.pause
.new_text
Since any ray path can be reversed it also holds that rays leaving
the focus of an idealised spherical mirror will be reflected parallel to
the axis of the mirror.


Click on continue to see rays leaving the focus of the real and ideal
mirrors.
.pause
.clear_rays
.painting 0
.source_ray_count 10
.point_source
.fast_click TOPFX TOPFY
.fast_click 0 150
.fast_click 0 0
.=> SRC1
.point_source
.fast_click 100 -80
.fast_click 0 -5
.fast_click 0 -155
.=> SRC2
.painting 1
.new_text
You can see that for the real mirror this is only an approximation. 


Click on continue.
.pause
.new_text
Please wait a moment as some rays are constructed.
.painting 0
.clear_rays
.forward_project 1
.set_length 350
.10
.=> COUNT
.200
.=> Y1
.45
.=> Y2
.create_rays
.goto LOOP
:CONTINUE
.finished_rays
.painting 1
.new_text
Since there is only one focus and it is on the concave side of the mirror, real
rays on the convex side cannot "come from" the focus. They can however head
towards the focus as is shown here.


Any ray heading towards the focus and striking the convex side of the lens
is taken to be reflected parallel to the axis.
.pause
.new_text
The approximations presented here form the basis for image location
in par-axial spherical mirror systems. The two principle rays used are:


Rays parallel to the axis are reflect through (or as if they came from)
the focus.


Rays coming from or heading towards the focus are reflected
parallel to the axis.
.clear_rays
% Show the principle rays being discussed.
.forward_project 0
.back_project 1
.childray_fertility
.back_project 0
.create_rays
.set_length 150
.fc -200 100
.fc -50 100
.fc -200 -55
.fc -50 -55
.finished_rays
.childray_fertility
.forward_project 1
.create_rays
.fc -200 0
.fc TOPFX TOPFY
.fc -200 -155
.fc 100 -80
.finished_rays
.pause
.new_text
When using Raytrace, you can trace any ray through a par-axial mirror
system, you are not restricted to the principle rays just mentioned.


That's the end of this script. Click on continue.
.pause
:SKIP
.enable_undo 1
.quiet_snap 0
.clear_var
.return
