% Script to demonstrate object-image distances in a single
% thin lens
% Expects
%	Nothing
% Creates
%	Nothing
% Clears
%	All
.new_text
This script allows you to investigate the object and image
distances for a single thin lens.


Proceed?
.yes_no SKIP
% Some parameters and variables
.3
.=> RAYS
.0
.=> BPROJECT
.1
.=> CONVERG
.=> OBJIMGDIM
.=> FOCALANNS
.50
.=> HEIGHT
.100
.=> FOCALLEN
.new_text
Please wait while the ray diagram is constructed.
.file_new
.red
.button_bar 0
.grid_snap 0
.drag_handles 0
.quiet_snap 1
.enable_undo 0
.paraxials_on_centre 1
.painting 0
% Create the lens (converging to start - check above)
.converging_lens
.fc 0 0
.fc 0 HEIGHT
.fc FOCALLEN 0
.=> LENS
.annotation Focus
.focus_snap
.fc FOCALLEN 0
.fcr 10 80
.=> FOCANN1
.annotation Focus
.FOCALLEN
.+/-
.=> TEMP
.focus_snap
.fc TEMP 0
.fcr 10 80
.=> FOCANN2
.tapemeasure
.mid_snap
.fc 0 0
.focus_snap
.fc FOCALLEN 0
.=> FOCDIST
.select_object FOCDIST
.object_coordinates FOCDIST lead_to
.fc X Y
.fc 125 130
.tapemeasure_options 2 2 fixed distance
.unselect_all
.annotation Focal length
.fc 125 130
.fcr -3 0
.annotation Lens
.end_snap
.fc 0 HEIGHT
.fcr 20 20
% Create the object source and a tapemeasure to show object
.source_ray_count 3
.point_source
.fc -200 60
.end_snap
.fc 0 -50
.end_snap
.fc 0 50
.=> SRC
.tapemeasure
.end_snap
.fc -200 60
.perp_snap
.fc -50 0
.=> OBJLINE
.object_coordinates OBJLINE end_one
.annotation Object
.end_snap
.fc X Y
.fcr 30 40
% Create the tapemeasure to show image, first find the rays
.ray_of_source SRC 0
.=> RAY0
.child_by RAY0 refraction
.=> RAY0
.ray_of_source SRC 1
.=> RAY1
.child_by RAY1 refraction
.=> RAY1
.unselect_all
.select_object RAY0 RAY1
.tapemeasure
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.perp_snap
.fc -50 0
.=> IMGLINE
.annotation Image
.select_object RAY0 RAY1
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.fcr 30 40
.unselect_all
.select_object OBJLINE IMGLINE
% Set the options for the object and image tapemeasures
.tapemeasure_options 1 0 noleader distance
.unselect_all
% Create the object/image distance tapemeasures
.red_rays 0
.object_coordinates OBJLINE end_two
.tapemeasure
.end_snap
.fc X Y
.mid_snap
.fc 0 25
.=> OBJDIST
.select_object OBJDIST
.object_coordinates OBJDIST lead_to
.fc X Y
.fc -200 -70
.tapemeasure_options 2 2 fixed distance
.unselect_all
.object_coordinates IMGLINE end_two
.tapemeasure
.end_snap
.fc X Y
.mid_snap
.fc 0 25
.=> IMGDIST
.select_object IMGDIST
.object_coordinates IMGDIST lead_to
.fc X Y
.fc -200 -105
.tapemeasure_options 2 2 fixed distance
.unselect_all
.annotation Object
.fc -200 -70
.fcr -3 0
.annotation Image
.fc -200 -105
.fcr -3 0
.red_rays 1
.painting 1
:LOOP
.new_text
What would you like to do now?


A - Drag the object about

B - Change the focal length of the lens

.BPROJECT
.if!= 0 NOPROJECT
C - Turn on back projected rays
.goto BPROJECT
:NOPROJECT
C - Turn off back projected rays
:BPROJECT

.CONVERG
.if== 0 DIVERG
D - Change the lens to diverging
.goto CONVERG
:DIVERG
D - Change the lens to converging
:CONVERG

E - Move a single ray from the object up and down the lens

F - More options
.choose 6 DRAGOBJ FOCLEN BPROJRAYS CONVDIV MOVERAY MORE
:DRAGOBJ
.unselect_all
.select_object SRC
.object_coordinates SRC centre
.fc X Y
.fast_move X Y
.new_text
Move the mouse about to change the object position and size.


Click on the primary mouse button when you have finished.
.user_click
.unselect_all
.goto LOOP
:FOCLEN
.unselect_all
.select_object LENS
.focus_snap
.fc 0 HEIGHT
.fast_move lastclick.x lastclick.y
.new_text
Move the mouse now to change the focal length.


Click on the primary mouse button when you have finished.
.user_click
.lastclick.x
.abs
.=> FOCALLEN
.unselect_all
.goto LOOP
:BPROJRAYS
.unselect_all
.object_coordinates IMGDIST cartesian
.X
.^2
.=> TEMP
.object_coordinates IMGLINE cartesian
.Y
.abs
.+ HEIGHT
.^2
.+ TEMP
.sqrt
.set_length
.BPROJECT
.if!= 0 NOPROJ
.1
.goto DOPROJ
:NOPROJ
.0
:DOPROJ
.=> BPROJECT
.unselect_all
.all_rays
.back_project BPROJECT
.unselect_all
.goto LOOP
:CONVDIV
.select_object LENS
.CONVERG
.if== 0 CHANGECON
.0
.=> CONVERG
.make_diverging
.unselect_all
.goto LOOP
:CHANGECON
.1
.=> CONVERG
.make_converging
.unselect_all
.goto LOOP
:MOVERAY
.unselect_all
.RAYS
./ 2
.truncate
.ray_of_source SRC
.=> RAY
.select_object RAY
.object_coordinates RAY end
.drag_single
.fc X Y
.fast_move X Y
.HEIGHT
.+/-
.=> TEMP
.mouse_limits 0 TEMP 0 HEIGHT
.new_text
Move the mouse now to move a ray up and down the lens aperture.


Click on the primary mouse button when you have finished.
.user_click
.mouse_limits -1e5 -1e5 1e5 1e5
.unselect_all
.goto LOOP
:MORE
.new_text
More things you can do...


A - Change the size of the lens aperture

B - Change the number of rays coming from the object

C - Toggle the object and image size readouts on or off

D - Toggle the presence of the focal point annotations

E - Go back to the first set of options

F - Exit this script
.choose 6 NEWHEIGHT CHANGERAYS TOGGSIZE TOGGFOCANN LOOP EXIT
:CHANGERAYS
.input_limits 2 20
.default_input RAYS
.new_text
Enter the desired number of rays (between 2 and 20).
.RAYS userinput
.painting 0
.select_object SRC
.source_ray_count RAYS
.unselect_all
.painting 1
.goto LOOP
:TOGGSIZE
.painting 0
.unselect_all
.select_object OBJLINE IMGLINE
.OBJIMGDIM
.if== 0 OIDIMON
.0
.=> OBJIMGDIM
.tapemeasure_options 1 0 noleader none
.goto DONEOIDIM
:OIDIMON
.1
.=> OBJIMGDIM
.tapemeasure_options 1 0 noleader distance
:DONEOIDIM
.unselect_all
.painting 1
.goto LOOP
:NEWHEIGHT
.unselect_all
.select_object LENS
.fc 0 HEIGHT
.fast_move 0 HEIGHT
.new_text
Move the mouse now to change the height of the lens.


Click on the primary mouse button when you have finished.
.user_click
.lastclick.y
.abs
.=> HEIGHT
.unselect_all
.goto LOOP
:TOGGFOCANN
.FOCALANNS
.if== 0 FOCANNON
.0
.=> FOCALANNS
.unselect_all
.select_object FOCANN1 FOCANN2
.delete
.goto LOOP
:FOCANNON
.1
.=> FOCALANNS
.painting 0
.show_tapemeasures 0
.red_rays 0
.annotation Focus
.focus_snap
.fc FOCALLEN 0
.fcr 10 80
.=> FOCANN1
.annotation Focus
.FOCALLEN
.+/-
.=> TEMP
.focus_snap
.fc TEMP 0
.fcr 10 80
.=> FOCANN2
.show_tapemeasures 1
.red_rays 1
.painting 1
.goto LOOP
:EXIT
.clear_var
.unselect_all
.button_bar 2
.drag_handles 1
.quiet_snap 0
.enable_undo 1
:SKIP
.return
