% Script routine to make a bifacial lens
% Uses current default refractive indices
% Expects variables
%   CENTREX
%   CENTREY
%   HEIGHT
%   THICK
%   R1
%   R2
% Creates variables
%   LENS
% Clears variables
%   ARC2
%   VERTEX1
%   VERTEX2
% ------------------------------------------------------
% Create and position the first arc
% ------------------------------------------------------
.quiet_snap 1
.grid_snap 0
.unselect_all
.create_surface
.fc CENTREX CENTREY
.arcseg
.chord_tan
.+/- HEIGHT
.=> HEIGHT
.fcr 0 HEIGHT
.R1
.if> 0.0 CONCAVE1
.fcr +10 HEIGHT
.goto CONT1
:CONCAVE1
.fcr -10 HEIGHT
:CONT1
.end_element
.=> LENS
.unselect_all
.select_object LENS
.object_coordinates LENS 1 tangent
.fc X Y
.set_radius R1
.THICK
./ 2
.+/-
.+ CENTREX
.=> VERTEX1
.unselect_all
.select_object LENS
.object_coordinates LENS 1 middle
.move_selection
.fc X Y
.fc VERTEX1 CENTREY
.unselect_all
% -------------------------------------------------------
% Create and position the second arc
% ------------------------------------------------------
.create_surface
.fc CENTREX CENTREY
.arcseg
.0.0
.- HEIGHT
.=> HEIGHT
.fcr 0 HEIGHT
.R2
.if< 0.0 CONCAVE2
.fcr -10 HEIGHT
.goto CONT2
:CONCAVE2
.fcr 10 HEIGHT
:CONT2
.end_element
.=> ARC2
.unselect_all
.select_object ARC2
.object_coordinates ARC2 1 tangent
.fc X Y
.set_radius R2
.THICK
./ 2
.+ CENTREX
.=> VERTEX2
.unselect_all
.select_object ARC2
.object_coordinates ARC2 1 middle
.move_selection
.fc X Y
.fc VERTEX2 CENTREY
.unselect_all
% --------------------------------------------------------
% Create the segment which will join the arcs
% --------------------------------------------------------
.create_surface
.object_coordinates LENS 1 end
.fc X Y
.object_coordinates ARC2 0 end
.fc X Y
.end_element
.=> SEGMENT
% --------------------------------------------------------
% Select and join the three surfaces and make a region
% --------------------------------------------------------
.unselect_all
.select_object LENS
.select_object SEGMENT
.select_object ARC2
.join
.make_region
.unselect_all
.clear_var VERTEX1 VERTEX2 ARC2
.return
