% Script introducing image formation in curved mirrors
.file_new
.zoom_reset
.clear_var
.quiet_snap 1
.grid_snap 0
.enable_undo 0
.painting 0
.create_surface
.fc -130 -35
.arcseg
.chord_tan
.fc 100 -35
.fc 85 15
.end_element
.=> MIRROR
.annotation Mirror
.end_snap
.fc 85 -35
.fcr  20 10
.create_shape
.fast_click -150 80
.fast_click -120 60
.fast_click -160 60
.fast_click -150 80
.end_element
.=> OBJECT
.annotation Object
.mid_snap
.fast_click -140 60
.fast_click_rel -20 -20
.=> OBANN1
.50
.=> EYEX
.115
.=> EYEY
.235
.=> ANGLE
.call eye.rsc
.EYE
.=> EYE1
.annotation Eye
.end_snap
.fast_click 66 137
.fast_click_rel 20 -20
.=> EYEANN1
.unselect_all
.set_length 200
.source_ray_count 2
.point_source
.end_snap
.fast_click -150 80
.fast_click -30 -30
.fast_click -20 -30
.=> SRC
.all_rays
.link_by_child_rays
.end_snap
.fc 55 113
.end_snap
.fc 47 119
.unselect_all
.painting 1
.new_text
Here you see rays originating from a point on the object and being
reflected from a curved mirror into the eye.
.pause
.new_text
To locate the image of this point the rays are back projected and their
intersection found.
.painting 0
.ray_of_source SRC 0
.=> RAY
.child_by RAY reflection
.=> RAY1
.ray_of_source SRC 1
.=> RAY
.child_by RAY reflection
.=> RAY
.select_object RAY RAY1
.back_project 1
.unselect_all
.child_by RAY1 back_proj
.select_object
.child_by RAY back_proj
.select_object
.annotation Image
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.fcr -20 20
.trail
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.unselect_all
.painting 1
.pause
.new_text
If every point on the object is considered then the image shape can be
traced out.
.select_object SRC OBJECT
.drag_handles 0
.steps_per 10 10 10
.auto_trace 1 0
.drag_handles 1


You can see that the image is smaller than the object and distorted;
just like you see in security observation mirrors in shopping centres.
.pause
:LOOP
.new_text
Choose on of the following options...


A - To change the curvature of the mirror

B - To retrace the image shape

C - To zoom out to see something that may be outside the window

D - To exit
.choose 4 NEWCURVE RETRACE ZOOMOUT EXIT
:NEWCURVE
.reset_trails
.pause_trails 1
.drag_handles 0
.unselect_all
.mouse_limits 55 -75 100 70
.select_object MIRROR
.object_coordinates MIRROR 1 tangent
.fast_move X Y
.fc X Y
.new_text
Move the cursor to change the shape of the mirror and click on
the primary mouse button when you have finished.
.user_click
.drag_handles 1
.pause_trails 0
.goto LOOP
:RETRACE
.unselect_all
.drag_handles 0
.select_object SRC OBJECT
.auto_trace 1 0
.unselect_all
.drag_handles 1
.goto LOOP
:ZOOMOUT
.zoom_extents
.new_text
Click on continue.
.pause
.zoom_reset
.goto LOOP
:EXIT
.unselect_all
.drag_handles 1
.quiet_snap 0
.return
